# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Authors:
#   Benjamin Kampmann <benjamin@fluendo.com>

if __name__ == '__main__':

    from twisted.internet import glib2reactor
    glib2reactor.install()

from elisa.plugins.daap.daap_connection import DaapConnection
from elisa.plugins.daap.models import DaapDatabaseListModel, \
        DaapSongListModel, DaapPlaylistListModel, DaapPlaylistModel

from elisa.core.media_uri import MediaUri

class DaapDebug(object):

    # you need to have a daap server running with this data
    server = 'localhost'
    port = 3689
    db = 1 # the db to use, 1 is default

    # for password tests add it here
    password = None

    base = "http://%s:%s" % (server, port)

    def setUp(self):
        self.connection = DaapConnection(self.server, self.port)
        def _printer(result):
            print result

        return self.connection.login(self.password).addCallback(_printer)

    def tearDown(self):
        # ugly: using a private API
        return self.connection._client.close()

    def get_db_data(self):
        model = DaapDatabaseListModel()
        uri = MediaUri("%s/databases" % self.base)
        return self.connection.request(uri, model).addCallback(lambda x: model)

    def get_db_listing(self):
        model = DaapSongListModel()
        
        uri = MediaUri("%s/databases/%s/items?type=music" % (self.base, self.db))

        return self.connection.request(uri, model).addCallback(lambda x: model)

    def get_playlist_listing(self):
        model = DaapPlaylistListModel()
        
        uri = MediaUri('%s/databases/%s/containers?' % (self.base, self.db))
        return self.connection.request(uri, model).addCallback(lambda x: model)

    def get_one_playlist(self):
        model = DaapPlaylistModel()
        
        uri = MediaUri('%s/databases/%s/containers/3/items?type=music' % (self.base, self.db))
        return self.connection.request(uri, model).addCallback(lambda x: model)


if __name__ == '__main__':

    from twisted.internet import reactor

    daap_debug = DaapDebug()

    def setup_done(result, daap_debug):
        print """

        You are now in the interactive tests. You have the DaapDebug object
        at *daap_debug* and you can play around with its get_* methods. It is
        holding the connection to your server. The login already worked :) .

        """

    def setup():
        dfr = daap_debug.setUp()
        dfr.addCallback(setup_done, daap_debug)

    reactor.callWhenRunning(setup)
    reactor.simulate()
    reactor.startRunning()
    import IPython
    IPython.Shell.IPShellGTK([], locals()).mainloop()
