# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.


from elisa.plugins.poblesec.player_video import PlayerController, \
     get_default_audio_sink
from elisa.plugins.poblesec import constants

import platform

def player_default_config():
    if platform.system() == 'Windows':
        visualization = 'goom2k1'
    else:
        visualization = 'libvisual_jess'
    # relook: visualizations disabled by default
    visualization = ''
    default_config = {'visualization': visualization,
                      'osd_timeout': '0',
                      'audio_sink' : get_default_audio_sink(),
                      }
    return default_config

class AudioPlayerController(PlayerController):
    # At the moment the audio player just acts like the normal player,
    # except it doesn't need VIDEO, controller but this class is used 
    # to at be able to have different configurations for audio and 
    # video playback easily.
    needs = [constants.PLAYER_PROVIDES_SOUND,]

    config_doc = {'visualization': 'GStreamer visualization element to use for '\
                                   'audio animations display',
                  'osd_timeout': 'Time in seconds after which the OSD should '\
                                 'auto-hide. Set to 0 to deactivate that feature',
                  'audio_sink' : 'give the name of the gstreamer audio sink' \
                                 'elisa should use. If not set autoaudiosink'\
                                 'will be used.',
                  }
    default_config = player_default_config()
