'\"
'\" Generated from file '/usr/ports/pobj/tcllib-1.11.1/tcllib-1.11.1/modules/otp/otp.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2006, Pat Thoyts <patthoyts@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "otp" n 1.0.0 otp "RFC 2289 A One-Time Password System"
.BS
.SH NAME
otp \- One-Time Passwords
.SH SYNOPSIS
package require \fBTcl  8.2\fR
.sp
package require \fBotp  ?1.0.0?\fR
.sp
\fB::otp::otp-md4\fR ?\fI-hex\fR? ?\fI-words\fR? \fI-seed seed\fR \fI-count count\fR \fIdata\fR
.sp
\fB::otp::otp-md5\fR ?\fI-hex\fR? ?\fI-words\fR? \fI-seed seed\fR \fI-count count\fR \fIdata\fR
.sp
\fB::otp::otp-sha1\fR ?\fI-hex\fR? ?\fI-words\fR? \fI-seed seed\fR \fI-count count\fR \fIdata\fR
.sp
\fB::otp::otp-rmd160\fR ?\fI-hex\fR? ?\fI-words\fR? \fI-seed seed\fR \fI-count count\fR \fIdata\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package is an implementation in Tcl of the One-Time Password
system as described in RFC 2289 (1). This system uses message-digest
algorithms to sequentially hash a passphrase to create single-use
passwords. The resulting data is then provided to the user as either
hexadecimal digits or encoded using a dictionary of 2048 words. This
system is used by OpenBSD for secure login and can be used as a SASL
mechanism for authenticating users.
.PP
In this implementation we provide support for four algorithms that are
included in the tcllib distribution: MD5 (2), MD4 (3), RIPE-MD160 (4)
and SHA-1 (5).
.SH COMMANDS
.TP
\fB::otp::otp-md4\fR ?\fI-hex\fR? ?\fI-words\fR? \fI-seed seed\fR \fI-count count\fR \fIdata\fR
.TP
\fB::otp::otp-md5\fR ?\fI-hex\fR? ?\fI-words\fR? \fI-seed seed\fR \fI-count count\fR \fIdata\fR
.TP
\fB::otp::otp-sha1\fR ?\fI-hex\fR? ?\fI-words\fR? \fI-seed seed\fR \fI-count count\fR \fIdata\fR
.TP
\fB::otp::otp-rmd160\fR ?\fI-hex\fR? ?\fI-words\fR? \fI-seed seed\fR \fI-count count\fR \fIdata\fR
.PP
.SH EXAMPLES
.nf

% otp::otp-md5 -count 99 -seed host67821 "My Secret Pass Phrase"
(binary gibberish)
% otp::otp-md5 -words -count 99 -seed host67821 "My Secret Pass Phrase"
SOON ARAB BURG LIMB FILE WAD
% otp::otp-md5 -hex -count 99 -seed host67821 "My Secret Pass Phrase"
e249b58257c80087

.fi
.SH REFERENCES
.IP [1]
Haller, N. et al., "A One-Time Password System", RFC 2289, February 1998.
\fIhttp://www.rfc-editor.org/rfc/rfc2289.txt\fR
.IP [2]
Rivest, R., "The MD5 Message-Digest Algorithm", RFC 1321, MIT and
RSA Data Security, Inc, April 1992.
(\fIhttp://www.rfc-editor.org/rfc/rfc1321.txt\fR)
.IP [3]
Rivest, R., "The MD4 Message Digest Algorithm", RFC 1320, MIT,
April 1992. (\fIhttp://www.rfc-editor.org/rfc/rfc1320.txt\fR)
.IP [4]
H. Dobbertin, A. Bosselaers, B. Preneel,
"RIPEMD-160, a strengthened version of RIPEMD"
\fIhttp://www.esat.kuleuven.ac.be/~cosicart/pdf/AB-9601/AB-9601.pdf\fR
.IP [5]
"Secure Hash Standard", National Institute of Standards
and Technology, U.S. Department Of Commerce, April 1995.
(\fIhttp://www.itl.nist.gov/fipspubs/fip180-1.htm\fR)
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIotp\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH "SEE ALSO"
SASL, md4, md5, ripemd160, sha1
.SH KEYWORDS
hashing, message-digest, password, rfc 2289, security
.SH COPYRIGHT
.nf
Copyright (c) 2006, Pat Thoyts <patthoyts@users.sourceforge.net>

.fi