'\"
'\" Generated from file '/usr/ports/pobj/tcllib-1.11.1/tcllib-1.11.1/modules/irc/picoirc.man' by tcllib/doctools with format 'nroff'
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "picoirc" n 0.5 irc "Simple embeddable IRC interface"
.BS
.SH NAME
picoirc \- Small and simple embeddable IRC client.
.SH SYNOPSIS
package require \fBTcl \fR
.sp
package require \fBpicoirc  ?0.5?\fR
.sp
\fB::picoirc::connect\fR \fIcallback\fR \fInick\fR \fIurl\fR
.sp
\fB::picoirc::post\fR \fIcontext\fR \fIchannel\fR \fImessage\fR
.sp
\fB::picoirc::splituri\fR \fIuri\fR
.sp
\fB::picoirc::send\fR \fIcontext\fR \fIline\fR
.sp
.BE
.SH DESCRIPTION
This package provides a general purpose minimal IRC client suitable for
embedding in other applications. All communication with the parent
application is done via an application provided callback procedure.
Each connection has its own state so you can hook up multiple servers
in a single application instance.
.PP
To initiate an IRC connection you must call \fBpicoirc::connect\fR
with a callback procedure, a nick-name to use on IRC and the IRC URL
that describes the connection. This will return a variable name that
is the irc connection context. See \fBCALLBACK\fR for details.
.PP
This package is a fairly simple IRC client. If you need something with
more capability investigate the \fBirc\fR package.
.PP
.SH COMMANDS
.TP
\fB::picoirc::connect\fR \fIcallback\fR \fInick\fR \fIurl\fR
Create a new irc connection to the server specified by \fIurl\fR and
login using the \fInick\fR as the username. The \fIcallback\fR must be
as specified in \fBCALLBACK\fR. Returns a package-specific variable
that is used when calling other commands in this package.
.TP
\fB::picoirc::post\fR \fIcontext\fR \fIchannel\fR \fImessage\fR
This should be called to process user input and send it to the
server. A number of commands are recognised when prefixed with a
forward-slash (/). Such commands are converted to IRC command
sequences and then sent.
.TP
\fB::picoirc::splituri\fR \fIuri\fR
Splits an IRC scheme uniform resource indicator into its component
parts. Returns a list of server, port and channel. The default port is
6667 and there is no default channel.
.TP
\fB::picoirc::send\fR \fIcontext\fR \fIline\fR
This command is where all raw output to the server is handled. The
default action is to write the \fIline\fR to the irc socket. However,
before this happens the callback is called with "debug write". This
permits the application author to inspect the raw IRC data and if
desired to return a break error code to halt further processing. In
this way the application can override the default send via the
callback procedure.
.PP
.SH CALLBACK
The callback must look like:
.nf

proc Callback {context state args} {
}

.fi
where context is the irc context variable name (in case you need to pass
it back to a picoirc procedure). state is one of a number of states as
described below.
.TP
\fBinit\fR
called just before the socket is created
.TP
\fBconnect\fR
called once we have connected, before we join any channels
.TP
\fBclose\fR
called when the socket gets closed, before the context is deleted. If
an error occurs before we get connected the only argument will be the
socket error message.
.TP
\fBuserlist\fR \fIchannel\fR \fInicklist\fR
called to notify the application of an updated userlist. This is
generated when the output of the NAMES irc command is seen. The
package collects the entire output which can span a number of output
lines from the server and calls this callback when they have all been
received.
.TP
\fBchat\fR \fItarget\fR \fInick\fR \fImessage\fR \fItype\fR
called when a message arrives. \fItarget\fR is the identity that the
message was targetted for. This can be the logged in nick or a channel
name. \fInick\fR is the name of the sender of the message.
\fImessage\fR is the message text. \fItype\fR is set to "ACTION" if the
message was sent as a CTCP ACTION
.TP
\fBsystem\fR \fIchannel\fR \fImessage\fR
called when a system message is received
.TP
\fBtopic\fR \fIchannel\fR \fItopic\fR
called when the channel topic string is seen. \fItopic\fR is the text
of the channel topic.
.TP
\fBtraffic\fR \fIaction\fR \fIchannel\fR \fInick\fR ?\fInewnick\fR?
called when users join, leave or change names.
\fIaction\fR is either entered, left or nickchange and \fInick\fR
is the user doing the action. \fInewnick\fR is
the new name if \fIaction\fR is nickchange.
.sp
\fINOTE\fR: \fIchannel\fR is often empty for these messages as nick
activities are global for the irc server. You will have
to manage the nick for all connected channels yourself.
.TP
\fBversion\fR
This is called to request a version string to use to
override the internal version. If implemented, you should
return as colon delimited string as
.sp
Appname:Appversion:LibraryVersion
.sp
For example, the default is
.sp
PicoIRC:[package provide picoirc]:Tcl [info patchlevel]
.TP
\fBdebug\fR \fItype\fR \fIraw\fR
called when data is either being read or written to the network
socket. \fItype\fR is set to \fBread\fR when reading data and
\fBwrite\fR if the data is to be written. \fIraw\fR is the
unprocessed IRC protocol data.
.sp
In both cases the application can return a break error code to
interrupt further processing of the raw data. If this is a
\fBread\fR operation then the package will not handle this line. If
the operation is \fBwrite\fR then the package will not send the
data. This callback is intended for debugging protocol issues but
could be used to redirect all input and output if desired.
.PP
.SH "SEE ALSO"
rfc 1459
.SH KEYWORDS
chat, irc