/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego;

import br.arca.morcego.Config;
import br.arca.morcego.physics.Vector3D;
import junit.framework.Assert;
import junit.framework.TestCase;

public class Vector3DTest
extends TestCase {
    private Vector3D origin;
    private Vector3D one;
    private Vector3D lost;

    protected void setUp() throws Exception {
        Config.init();
        this.origin = new Vector3D(0.0f, 0.0f, 0.0f);
        this.one = new Vector3D(1.0f, 0.0f, 0.0f);
        this.lost = new Vector3D(1.0f, 1.0f, 1.0f);
    }

    public void testVertexConstructor() {
        Assert.assertEquals((String)"x should be what we constructed the vertex with", (float)0.0f, (float)this.origin.getX(), (float)0.0f);
        Assert.assertEquals((String)"y should be what we constructed the vertex with", (float)0.0f, (float)this.origin.getY(), (float)0.0f);
        Assert.assertEquals((String)"z should be what we constructed the vertex with", (float)0.0f, (float)this.origin.getZ(), (float)0.0f);
    }

    public void testGetDistanceTo() {
        Assert.assertEquals((String)"distance from origin to one should be one", (float)1.0f, (float)this.origin.getDistanceTo(this.one), (float)0.0f);
        Assert.assertEquals((String)"distance from one to origin should also be one", (float)1.0f, (float)this.one.getDistanceTo(this.origin), (float)0.0f);
        Assert.assertEquals((String)"distance from origin to lost should be sqrt(3)", (float)((float)Math.sqrt(3.0)), (float)this.origin.getDistanceTo(this.lost), (float)0.0f);
    }

    public void testProj() {
    }

    public void testConstructor() {
        Vector3D v = new Vector3D(1.1f, 2.2f, 3.3f);
        this.assertSpeedVector(v, 2.0f, 3.0f, 4.0f);
    }

    public void testAdd() {
        Vector3D v1 = new Vector3D(1.0f, 2.0f, 3.0f);
        Vector3D v2 = new Vector3D(3.0f, 2.0f, 1.0f);
        v1.add(v2);
        this.assertSpeedVector(v1, 4.0f, 4.0f, 4.0f);
        this.assertSpeedVector(v2, 3.0f, 2.0f, 1.0f);
    }

    public void testClear() {
        Vector3D v = new Vector3D(9.0f, 8.0f, 7.0f);
        v.clear();
        this.assertSpeedVector(v, 0.0f, 0.0f, 0.0f);
    }

    public void testResize() {
        Vector3D v = new Vector3D(9.0f, 8.0f, 7.0f);
        v.resize(10.0f);
        this.assertSpeedVector(v, 90.0f, 80.0f, 70.0f);
    }

    public void testReverse() {
        Vector3D v = new Vector3D(9.0f, 8.0f, 7.0f);
        this.assertSpeedVector(v.opposite(), -9.0f, -8.0f, -7.0f);
    }

    public void testModule() {
        Vector3D v = new Vector3D(9.0f, 8.0f, 7.0f);
        float expected = (float)Math.sqrt(v.x * v.x + v.y * v.y + v.z * v.z);
        Assert.assertTrue((expected == v.module() ? 1 : 0) != 0);
    }

    public void testOpposite() {
        Vector3D o = new Vector3D(35.0f, 87.0f, 23.0f);
        Vector3D d = new Vector3D(135.0f, 187.0f, 123.0f);
        Vector3D orig = o.makeClone();
        o.add(d);
        o.add(d.opposite());
        Assert.assertEquals((float)o.x, (float)orig.x, (float)0.0f);
        Assert.assertEquals((float)o.y, (float)orig.y, (float)0.0f);
        Assert.assertEquals((float)o.z, (float)orig.z, (float)0.0f);
    }

    public void testGetVectorFrom() {
        Vector3D o = new Vector3D(35.0f, 87.0f, 23.0f);
        Vector3D d = new Vector3D(135.0f, 187.0f, 123.0f);
        Vector3D diff = d.getVectorFrom(o);
        o.add(diff);
        Assert.assertEquals((float)o.x, (float)d.x, (float)0.0f);
        Assert.assertEquals((float)o.y, (float)d.y, (float)0.0f);
        Assert.assertEquals((float)o.z, (float)d.z, (float)0.0f);
    }

    private void assertSpeedVector(Vector3D v, float x, float y, float z) {
    }
}

