/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego.structure;

import br.arca.morcego.Config;
import br.arca.morcego.Morcego;
import br.arca.morcego.physics.PositionedObject;
import br.arca.morcego.physics.PunctualBody;
import br.arca.morcego.physics.Vector3D;
import br.arca.morcego.structure.Graph;
import br.arca.morcego.structure.GraphElement;
import br.arca.morcego.structure.Link;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;

public class Node
extends GraphElement
implements PositionedObject {
    private static final long serialVersionUID = 4471920873578042527L;
    protected String id;
    protected PunctualBody body;
    protected Rectangle boundRectangle = new Rectangle();
    private Hashtable links;
    private boolean isCentered;
    private float maxModule;
    private Integer centerDistance = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public Node() {
    }

    public Node(String name, Graph graph) {
        this.setup(name, graph);
    }

    public void setup(String name, Graph graph) {
        this.links = new Hashtable();
        this.graph = graph;
        this.id = name;
        int x = this.randomLength();
        int y = this.randomLength();
        int z = this.randomLength();
        z = -1 * Math.abs(z);
        this.body = new PunctualBody(x, y, z);
        this.graph.addNode(this);
    }

    public Hashtable availableProperties() {
        Hashtable prop = super.availableProperties();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.Color");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        prop.put("color", clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.net.URL");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        prop.put("actionurl", clazz2);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        prop.put("description", clazz3);
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        prop.put("title", clazz4);
        Class<?> clazz5 = class$3;
        if (clazz5 == null) {
            try {
                clazz5 = class$3 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        prop.put("mass", clazz5);
        Class<?> clazz6 = class$3;
        if (clazz6 == null) {
            try {
                clazz6 = class$3 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        prop.put("charge", clazz6);
        Class<?> clazz7 = class$4;
        if (clazz7 == null) {
            try {
                clazz7 = class$4 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        prop.put("level", clazz7);
        return prop;
    }

    public PunctualBody getBody() {
        return this.body;
    }

    public int getLevel() {
        Integer level = (Integer)this.getProperty("level");
        if (level == null) {
            return 0;
        }
        return level;
    }

    public void setBody(PunctualBody body) {
        this.body = body;
    }

    public boolean isLinkedTo(Node node) {
        return this.links.containsKey(node.id);
    }

    public boolean centered() {
        return this.isCentered;
    }

    public void center() {
        this.isCentered = true;
        this.body.fixPosition(0, 0, 0);
    }

    public void unCenter() {
        this.isCentered = false;
        this.releasePosition();
    }

    public int linkCount() {
        int i = 0;
        Enumeration e = this.links.keys();
        while (e.hasMoreElements()) {
            e.nextElement();
            ++i;
        }
        return i;
    }

    public void move() {
        this.body.move();
        this.proj();
    }

    public void releasePosition() {
        this.body.releasePosition();
    }

    public void fixPosition() {
        this.body.fixPosition();
    }

    public synchronized void proj() {
    }

    public boolean contains(MouseEvent e) {
        return this.boundRectangle.contains(e.getX(), e.getY());
    }

    public int randomLength() {
        return (int)((Math.random() * 2.0 - 1.0) * 500.0);
    }

    public void addLink(Node node, Link link) {
        this.links.put(node.getId(), link);
    }

    public void paint(Graphics g) {
    }

    public String getId() {
        return this.id;
    }

    public Enumeration getLinks() {
        return this.links.elements();
    }

    public Integer getCenterDistance() {
        return this.centerDistance;
    }

    public void setCenterDistance(Integer centerDistance) {
        this.centerDistance = centerDistance;
    }

    public float getDepth() {
        return Morcego.getCamera().getDistanceTo(this.body);
    }

    public void init() {
        super.init();
        if (this.getProperty("title") == null) {
            this.setProperty("title", this.id);
        }
        if (this.getProperty("color") == null) {
            this.setProperty("color", Config.getColor("morcego.nodeDefaultColor"));
        }
    }

    public boolean isVisible() {
        return this.graph.isVisible(this);
    }

    public void mouseClicked(MouseEvent e) {
        URL url;
        boolean navigate;
        boolean bl = navigate = this.centered() || Config.getBoolean(Config.loadPageOnCenter);
        if (!this.centered()) {
            this.graph.navigateTo(this);
            if (this.description != null) {
                Morcego.getApplication().remove(this.description);
            }
        }
        if (navigate && (url = (URL)this.graph.getFocus().getProperty("actionUrl")) != null) {
            Morcego.showDocument(url, Config.getString("morcego.controlWindowName"));
        }
        this.callJsEvent("onclick");
    }

    public void mouseEntered(MouseEvent e) {
        Morcego.setHandCursor();
        this.showDescription();
        e.consume();
        this.callJsEvent("onmouseover");
    }

    private void showDescription() {
        if (this.description != null) {
            this.description.setPosition(this.body.projection.x, this.body.projection.y);
            Morcego application = Morcego.getApplication();
            application.add(this.description);
            this.description.setVisible(true);
            Morcego.notifyRenderer();
        }
    }

    public void mouseExited(MouseEvent e) {
        Morcego.setDefaultCursor();
        this.hideDescription();
        this.callJsEvent("onmouseout");
    }

    public void mousePressed(MouseEvent e) {
        Enumeration el = this.graph.getVisibleNodes().elements();
        float reachableRadius = 0.0f;
        while (el.hasMoreElements()) {
            Node node = (Node)el.nextElement();
            float radius = node.getBody().module();
            if (!(radius > reachableRadius)) continue;
            reachableRadius = radius;
        }
        this.maxModule = 5.0f * reachableRadius;
        this.fixPosition();
        this.graph.fixFocus();
        if (this.description != null) {
            Morcego.getApplication().remove(this.description);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (!this.centered()) {
            this.releasePosition();
        }
        this.mouseExited(e);
        this.graph.releaseFocus();
        this.graph.notifyBalancer();
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.centered()) {
            Vector3D position = this.body.unproj(e.getX(), e.getY());
            if (position.module() > this.maxModule) {
                position.resize(this.maxModule / position.module());
            }
            this.body.moveTo(position);
            this.graph.notifyBalancer();
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void rotate(float xTheta, float yTheta) {
        this.body.rotate(xTheta, yTheta);
    }

    public void setProperty(String name, Object value) {
        if (name.equals("bodyCharge")) {
            this.body.setCharge(((Float)value).floatValue());
        }
        if (name.equals("bodyMass")) {
            this.body.setMass(((Float)value).floatValue());
        }
        super.setProperty(name, value);
    }

    public Link getLinkTo(Node node) {
        if (this.isLinkedTo(node)) {
            return (Link)this.links.get(node.id);
        }
        return null;
    }

    public boolean visible() {
        return true;
    }

    public float getScale() {
        float scale = this.body.getScale();
        if (this.centered()) {
            scale *= Config.getFloat(Config.centerNodeScale);
        }
        return scale;
    }
}

