<?php // -*- coding:utf-8 -*-
// Parameters:

// lang=xx    : only translates language 'xx',
//              if not given all languages are translated

// comments   : generate all comments (equal to close&module)

// close      : look for similar strings that are already translated and
//              generate a comment if a 'match' is made

// module     : generate comments that describe in which .php and/or .tpl
//              module(s) a certain string was found (useful for checking
//              translations in context)

// patch      : looks for the file 'language.patch' in the same directory
//              as the corresponding language.php and overrides any strings
//              in language.php - good if a user does not agree with
//              some translations or if only changes are sent to the maintainer

// spelling   : generates a file 'spellcheck_me.txt' that contains the
//              words used in the translation. It is then easy to check this
//              file for spelling errors (corrections must be done in
//              'language.php, however)

// groupwrite : Sets the generated files permissions to allow the generated
//              language.php also be group writable. This is good for
//              translators if they do not have root access to tiki but
//              are in the same group as the webserver. Please remember
//              to have write access removed when translation is finished
//              for security reasons. (Run script again without this
//              parameter)

// Examples:
// http://www.neonchart.com/get_strings.php?lang=sv
// Will translate language 'sv' and (almost) avoiding comment generation

// http://www.neonchart.com/get_strings.php?lang=sv&comments
// Will translate language 'sv' and generate all possible comments.
// This is the most usefull mode when working on a translation.

// http://www.neonchart.com/get_strings.php?lang=sv&nohelp&nosections
// These options will only provide the minimal amout of comments.
// Usefull mode when preparing a translation for distribution.

// http://www.neonchart.com/get_strings.php?nohelp&nosections
// Prepare all languages for release


// ### Note for translators about translation of text ending with punctuation
// ###
// ### The current list of concerned punctuation can be found in 'lib/init/tra.php'
// ### On 2009-03-02, it is: (':', '!', ';', '.', ',', '?')
// ### For clarity, we explain here only for colons: ':' but it is the same for the rest
// ###
// ### Short version: it is not a problem that string "Login:" has no translation. Only "Login" needs to be translated.
// ###
// ### Technical justification:
// ### If a string ending with colon needs translating (like "{tr}Login:{/tr}")
// ### then TikiWiki tries to translate 'Login' and ':' separately.
// ### This allows to have only one translation for "{tr}Login{/tr}" and "{tr}Login:{/tr}"
// ### and it still allows to translate ":" as "&nbsp;:" for languages that
// ### need it (like french)

$lang=Array(
// ### Start of unused words
// ### Please remove manually!
// ### N.B. Legitimate strings may be marked// ### as unused!
// ### Please see http://tikiwiki.org/tiki-index.php?page=UnusedWords for further info
"Wiki page" => "Sivu",
"pageviews" => "sivunäyttöjä",
"Security check failed!" => "Turvallisuus tarkistus epäonnistui!",
"Your Tiki account information for" => "Sinun tilisi tiedot",
"A new password has been sent " => "Uusi salasana on lähetetty ",
"You have to type a searchword" => "Kirjoita etsintä sana",
"Upload was not successful (maybe a duplicate file)" => "Lähetys ei onnistunut (ehkä sillä nimellä on tiedosto)",
"You have to provide a name to the image" => "Sinun on annettava nimi kuvalle",
"Invalid password.  You current password is required to change your email address." => "Väärä salasana.  Nykyinen salasanasi tarvitaan voidaksesi muuttaa sähköpostiosoitetta.",
" new topic:" => " uusi aihe:",
"topic:" => "aihe:",
"You are not permitted to edit someone else\\'s post!" => "Et voi muokata kenenkään toisen posteja!",
"Only an admin can remove a thread." => "Vain ylläpito voi poistaa ketjun.",
"forum topic" => "foorumin aihe",
"New article submitted at " => "Uusi artikkeli lisätty ",
" line " => " rivi ",
"Error: Invalid" => "Virhe: Väärä",
"Error: No" => "Virhe: Ei",
"permission." => "lupa.",
"Error: Call to hw_page_fetch_by_id failed!" => "Virhe: Kutsu hw_page_fetch_by_id epäonnistui!",
"New message arrived from " => "Uusi viesti vastaanotettu: ",
"Welcome to " => "Tervetuloa ",
"Bye bye from " => "Heippa ",
" at " => "  ",
"Insert articles into a wikipage" => "Lisää artikkeli sivulle",
"note: those parameters are exclusive" => "huomio: nuo parametrit ovat valikoivia",
"__key__ | __defaults__ | __comments__\n" => "__key__ | __oletus__ | __kommentit__\n",
"Are you sure you want to delete this attachment?" => "Oletko varma, että haluat poistaa liitteen?",
"Click here to delete this attachment" => "Paina tästä, poistaaksesi liitteen",
"Posted comments" => "Lähetetyt kommentit",
"Are you sure you want to delete this comment?" => "Oletko varma, että haluat poistaa kommentin?",
"Click here to delete this comment" => "Paina tästä, poistaaksesi kommentin",
"reply to this" => "vastaa tähän",
"parent" => "isäntä",
"Reply to parent comment" => "Vastaa isäntä kommenttiin",
"Are you sure you want to delete this copyright?" => "Oletko varma, että haluat poistaa tämän copyrightin?",
"Click here to delete this copyright" => "Paina tästä, poistaaksesi copyright",
"compose message tpl" => "muodosta viesti tpl",
"messages tpl" => "viestien tpl",
"Return to messages" => "Palaa viesteihin",
"Unflagg" => "Poista merkki",
"Click here to unassign this module" => "Paina tästä, poistaaksesi modulin",
"Admin structures" => "Hallitse rakenteita",
"Reduce area width" => "Pienennä alueen leveyttä",
"Enlarge area width" => "Suurenna alueen leveyttä",
"Blog settings" => "Blogi asetukset",
"In blog listing show user as" => "Blogi listalla näytä käyttäjät",
"CMS settings" => "CMS asetukset",
"FAQs settings" => "UKK asetukset",
"FAQ comments" => "UKK kommentit",
"Email Encoding" => "Sähköpostin koodaus",
"Time Zone" => "Aika Vyöhyke",
"Server time zone" => "Palvelimen Aika Vyöhyke",
"Time Zone Map" => "Aika Vyöhyke Kartta",
"Remind passwords by email" => "Muistuta salasanoista sähköpostilla",
"Poll settings" => "Poll settings",
"Append CSS file to feed urls" => "Lisää CSS urlin syötteeseen",
"Publisher" => "Julkaisija",
"Create a tag for the current wiki" => "Luo kiinnike nykyiseen sivustoon",
"Restore the wiki" => "Palauta wiki",
"Wiki comments settings" => "Wiki kommenttien asetukset",
"Wiki page list configuration" => "Wiki sivulistaus asetukset",
"Ranking" => "Arvostus",
"Warn on edit" => "Varoita muokkauksesta",
"Are you sure you want to delete this rule?" => "Oletko varma, että haluat poistaa tämän säännön?",
"List Calendars" => "Listaa Kalenterit",
"Are you sure you want to delete this calendar?" => "Oletko varma, että haluat poistaa tämän kalenterin?",
"Delete item from category?" => "Poista luokan osa?",
"Are you sure you want to delete this category?" => "Oletko varma, että haluat poistaa tämän luokan?",
"admin charts tpl" => "ylläpidä kaavio tpl",
"ChatAdmin" => "JutYlläp",
"ChatAdmin tpl" => "JutYlläp tpl",
"Click here to delete this channel" => "Paina tästä poistaaksesi tämän kanavan",
"Are you sure you want to delete this channel?" => "Oletko varma, että haluat poistaa tämän kanavan?",
"admin content templates tpl" => "ylläpidä sisältö mallien tpl",
"Click here to delete this template" => "Paina tästä poistaaksesi tämän mallin",
"Are you sure you want to delete this template?" => "Oletko varma, että haluat poistaa tämän mallin?",
"Are you sure you want to delete this cookie?" => "Oletko varma, että haluat poistaa tämän keksin?",
"Click here to delete this cookie" => "Paina tästä poistaaksesi tämän keksin",
"admin Drawings" => "ylläpidä Piirroksia",
"Are you sure you want to delete this drawing?" => "Oletko varma, että haluat poistaa tämän piirroksen?",
"Click here to delete this drawing" => "Paina tästä poistaaksesi tämän piirroksen",
"AdminDSN" => "YlläpidäDSN",
"Are you sure you want to delete this dsn?" => "Oletko varma, että haluat poistaa tämän dsn:n?",
"admin ExternalWiki" => "ylläpidä UlkoinenWiki",
"tiki admin external wikis tpl" => "tiki ylläpidä ulkoinen wiki tpl",
"Are you sure you want to delete this external wiki?" => "Oletko varma, että haluat poistaa tämän ulkoisen wikin?",
"admin forums tpl" => "ylläpidä foorumien tpl",
"Threads can be voted" => "Ketjuja voi äänestää",
"Are you sure you want to delete this forum?" => "Oletko varma, että haluat poistaa tämän foorumin?",
"admin hotwords tpl" => "ylläpidä hotwords tpl",
"Are you sure you want to delete this hotword?" => "Oletko varma, että haluat poistaa tämän hotword?",
"admin HtmlPages" => "ylläpidä HtmlSivuja",
"admin HtmlPages tpl" => "ylläpidä HtmlSivun tpl",
"Are you sure you want to delete this HTML page?" => "Oletko varma että haluat poistaa tämän HTML sivun?",
"Are you sure you want to delete this repository?" => "Oletko varma, että haluat poistaa tämän säilytyspaikan?",
"Click here to delete this repository" => "Paina tästä poistaaksesi tämän säilytyspaikan",
"Click here to delete this rule" => "Paina tästä poistaaksesi tämän säännön",
"admin featured links tpl" => "ylläpidä ominaisuus linkkien tpl",
"WebMail accounts" => "WebMail tilit",
"admin mailin tpl" => "ylläpidä mail tpl",
"Are you sure you want to delete this menu?" => "Oletko varma, että haluat poistaa tämän valikon?",
"Click here to delete this menu" => "Paina tästä poistaaksesi tämän valikon",
"Edit tpl" => "Muuta tpl",
"Click here to edit this menu" => "Paina tästä muokataksesi tätä valikkoa",
"Click here to configure this menu" => "Paina tästä muuttaaksesi tämän valikon kokoonpanoa",
"admin modules tpl" => "ylläpidä moduulien tpl",
"\n<b>Note 1</b>: if you allow your users to configure modules then assigned\nmodules won't be reflected in the screen until you configure them\nfrom MyTiki->modules.<br/>\n<b>Note 2</b>: If you assign modules to groups make sure that you\nhave turned off the option 'display modules to all groups always'\nfrom Admin->General\n" => "\n<b>Huomaa 1</b>: jos annat käyttäjien muokata moduuleja liitetyt\nmoduulit eivät reagoi näytöllä ennen kuin muokkaat niitä\nMyTiki->modules valikosta.<br/>\n<b>Huomaa 2</b>: Jos liität moduuleja ryhmille pidä huoli että sinulla on \nvalinta merkattuna 'näytä kaikki moduulit kaikille aina'\nYlläpito->Yleiset\n",
"Add all your site users to this newsletter (broadcast)" => "Lisää kaikki sivuston käyttäjät tähän uutislehteen (lähetykseen)",
"Add users" => "Lisää käyttäjiä",
"admin newsletters tpl" => "ylläpidä uutislehden tpl",
"admin notifications tpl" => "ylläpidon ilmoitus tpl",
"admin polls tpl" => "ylläpidä äänestyksien tpl",
"tiki admin quicktags tpl" => "ylläpidä pikalisien tpl",
"admin RSSmodules tpl" => "ylläpidä RSSmoduulien tpl",
"admin structures tpl" => "ylläpidä rakenne tpl",
"admin surveys tpl" => "ylläpidä tutkimusten tpl",
"Create New Survey:" => "Luo Uusi Tutkimus:",
"stat" => "tila",
"admin topics tpl" => "ylläpidä aiheiden tpl",
"(Dropdown options : list of items separated with commas)" => "(Alasveto vaihtoehdot : lista osista eroteltuna pilkulla)",
"(Image options : xSize,ySize indicated in pixels)" => "(Kuva vaihtoehdot : xKoko,yKoko annetaan pixeleinä)",
"Show status when listing tracker items?" => "Näytä tila kun listataan kortiston osia?",
"admin groups tpl" => "ylläpidä ryhmien tpl",
"Add New Group" => "Lisää Uusi Ryhmä",
"Edit this group:" => "Muokkaa tätä ryhmää:",
"Are you sure you want to delete this group?" => "Oletko varma, että haluat poistaa tämän ryhmän?",
"admin users tpl" => "ylläpidä käyttäjä tpl",
"File gals" => "Tiedosto gal",
"Image gals" => "Kuva gal",
"Comm" => "Komm",
"Cms" => "Cms",
"ExtWikis" => "ExtWikit",
"assgn" => "assgn",
"Klick to enlarge" => "Paina suurentaaksesi",
"You can include the image in an HTML or Tiki page using" => "Voit lisätä kuvan HTML tai normaali sivulle käyttäen",
"Calendars Panel" => "Kalenterien Paneeli",
"Events Panel" => "Tapahtumien Paneeli",
"Add Calendar Item" => "Lisää Kalenterin Osa",
"-1m" => "-1m",
"-7d" => "-7d",
"-1d" => "-1d",
"+1d" => "+1d",
"+7d" => "+7d",
"+1m" => "+1m",
"today" => "tänään",
"save a custom copy" => "tallenna muunneltu kopio",
"For more information, please see <a\nhref=\"http://www.tikiwiki.org/tiki-index.php?page=WikiSyntax\">WikiSyntax</a>\non <a href=\"http://www.tikiwiki.org\">Tikiwiki.org</a>." => "Lisätietoja, katso <a\nhref=\"http://www.tikiwiki.org/tiki-index.php?page=WikiSyntax\">WikiSyntax</a>\non <a href=\"http://www.tikiwiki.org\">Tikiwiki.org</a>.",
"use square brackets for an" => "käytä hakasulkuja",
"link_description" => "linkki_kuvaus",
"Prevents parsing data" => "Estää tiedon jäsentämisen",
"Reuse question" => "Uudellen käytä kysymys",
"Edit Submissions" => "Muokkaa Ehdotuksia",
"file galleries tpl" => "tiedosto galleria tpl",
"act status" => "act tila",
"running" => "käynnissä",
"Add scaled images size X x Y" => "Lisää muutetut kuvat kokoa X x Y",
"admin DynamicContent" => "ylläpidä MuuttuvaSisältö",
"op" => "op",
"MyTikiDoc" => "OmaSivuOhje",
"Comparing versions" => "Verrataan versioita",
"Actual_version" => "Varsinainen_versio",
"Diff to version" => "Erot versioon",
"Send Objects" => "Lähetä Kohteet",
"The cord" => "Nauha",
"Show chart for the last " => "Näytä kaavio jossa viimeiset ",
"days (0=all)" => "päivää (0=all)",
"Control by Object" => "Hallinta Kohteella",
"Control by category" => "Hallinta Luokalla",
"use filename" => "käytä tiedostonimeä",
"remove bookmark" => "poista kirjanmerkki",
"Use dbl click to edit pages" => "Käytä kaksoisklikkausta muokataksesi sivuja",
"Change your email" => "Muuta sähköposti osoitettasi",
"change email" => "muuta sähköposti",
"Configure this page" => "Konfiguroi tätä sivua",
"All tasks" => "Kaikki tehtävät",
"mark as done" => "merkitse tehdyksi",
"open tasks" => "avaa tehtävät",
"Add or edit a task" => "Lisää tai muokkaa tehtävää",
"perm" => "pysyvä",
"FAQ Questions" => "UKK kysymykset",
"FAQ Answers" => "UKK Vastaukset",
"Show suggested questions/suggest a question" => "Näytä ehdotettuja kysymyksiä/ehdotettua kysymystä",
"Hide suggested questions" => "Piilota ehdotetut kysymykset",
"this post was reported" => "tämä lähetys oli raportoitu",
"report this post" => "raportoi tämä lähetys",
"checked" => "merkitty",
"unchecked" => "merkitsemätön",
"Are you sure you want to delete this tracker?" => "Oletko varma, että haluat poistaa tämän kortiston?",
"Click here to delete this tracker" => "Paina tästä poistaaksesi tämän kortiston",
"Editing tracker item" => "Muuta kortiston osaa",
"Click here to edit this comment" => "Paina tästä muokataksesi tätä kommenttia",
"Webmail Doc tpl" => "Webmail Doc tpl",
"Are you sure you want to delete this contact?" => "Oletko varma, että haluat poistaa tämän yhteyden?",
"Click here to delete this contact" => "Paina tästä poistaaksesi yhteys",
"someone from" => "joku",
"requested a reminder of the password for the" => "pyydetty muistutus salasanasta",
"since this is your registered email address we inform that the" => "mikäli tämä on sinun rekisteröity sähköpostiosoitteesi tiedotamme",
"password for this account is" => "salasana tähän jäsenyyteen on",
"Information:" => "Tiedot:",
"You can edit the page following this link:" => "Voit muokata sivua seuraamalla tätä linkkiä:",
"Diff:" => "Erot:",
"The new page content is:" => "Uuden sivun sisältö on:",
"You can view the page following this link:" => "Voit katsoa sivua seuraavasta linkistä:",
"You can view the page by following this link:\n    {\$mail_machine}/tiki-index.php?page={\$mail_page|escape:\"url\"}" => "Voit katsoa sivua seuraamalla tätä linkkiä:\n    {\$mail_machine}/tiki-index.php?page={\$mail_page|escape:\"url\"}",
"You can edit the page by following this link:\n    {\$mail_machine}/tiki-editpage.php?page={\$mail_page|escape:\"url\"}" => "Voit muokata sivua seuraamalla linkkiä:\n    {\$mail_machine}/tiki-editpage.php?page={\$mail_page|escape:\"url\"}",
"You can view a diff back to the previous version by following\nthis link:\n    {\$mail_machine}/tiki-pagehistory.php?page={\$mail_page|escape:\"url\"}&diff2={\$mail_last_version}" => "Voit katsoa erot edelliseen versioon\ntästä linkistä:\n    {\$mail_machine}/tiki-pagehistory.php?page={\$mail_page|escape:\"url\"}&diff2={\$mail_last_version}",
"Are you sure you want to delete this directory?" => "Oletko varma, että haluat poistaa tämän hakemiston?",
"Are you sure you want to delete this file?" => "Oletko varma, että haluat poistaa tämän tiedoston?",
"More info about" => "Lisää tietoa koskien",
"idle" => "odottava",
"Click the :: option on the menu for more options." => "Paina :: vaihtoehtoa valikosta saadaksesi lisää vaihtoehtoja.",
"Please also see" => "Katso myös",
"Admin->Modules" => "Ylläpidä->Moduuleja",
"Insert javascript into a page on the fly! You can both include an external file and/or just type the javascript in between the tags" => "Lisää javascript:in lennossa sivulle! Voit molempia joko antaa tiedostonimen/tai kirjoittaa suoraan javascripti tagien väliin",
"typed-inline javascript" => "kirjoitettu-sisä javascript",
"%A %d %B, %Y" => "%A %d %B, %Y",
"%A %d %B, %Y[%H:%M:%S %Z]" => "%A %d %B, %Y[%H:%M:%S %Z]",
"%a %d %b, %Y" => "%a %d %b, %Y",
"%a %d %b, %Y[%H:%M %Z]" => "%a %d %b, %Y[%H:%M %Z]",
"You do not have permission to write the template\".': '.\$file));\n\t\t\$smarty->display('error.tpl');\n\t\tdie;\n\t}\n\t\$_REQUEST[\"data\"] = str_replace(\"\r\n" => "Oikeutesi eivät riitä kirjoittamaan malleja\".': '.\$file));\n\t\t\$smarty->display('error.tpl');\n\t\tdie;\n\t}\n\t\$_REQUEST[\"data\"] = str_replace(\"\r\n",
"Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else.\r\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\r\n\r\nDone! You should be logged in." => "Paina seuraavaa linkkiä varmistaaksesi toivomuksesi uudesta salasanasta ja mene ruudulle kirjoittamaan uusi \"pysyvä\" salasana. Valitse salasanaksi sellainen jonka vain sinä tiedät äläkä kerro sitä muille.\r\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\r\n\r\nTehty! Olet kirjautunut sisään.",
"from\r\nthe mapfile:" => "\r\nkarttatiedostosta:",
"Please see the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://dev.tikiwiki.org/tiki-index.php?page=Features\">evaluation of each feature</a> on Tiki's developer site." => "Katso <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://dev.tikiwiki.org/tiki-index.php?page=Features\">ominaisuuden kehittelystä</a> Tikin kehittäjien toimesta.",
"Create a group for each user <br />(with the same\r\nname as the user)" => "Luo ryhmä jokaiselle käyttäjälle <br />(jolla on sama\r\nnimi kuin käyttäjä)",
"WARNING : Old and New trackers cannot coexist. Trackers created with new library\r\nwill not work with old library and conversely" => "WAROITUS : Vanha ja Uusi kortisto eivät voi esiintyä yhtaikaa. Uudella kirjastolla luodut kortistot\r\neivät toimi vanhojen kanssa ja päinvastoin",
"An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">ominaisuus linkki</a> ominaisuus." => "Helpoin tapa tuoda aineistoa toiselta sivustolta suoraan sivuston sivuksi <a class=\"rbox-link\" href=\"tiki-admin_links.php\">ominaisuuslinkit</a> ominaisuus.",
"To use menus in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu. To use <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes:" => "Käyttääksesi <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">moduulia</a> tai mallia, käytä {literal}{menu id=x}{/literal}, missä x on valikon ID. Käyttääksesi <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, voit käyttää yhtä näistä kolmesta esitystavasta:",
"\r\n<b>Note 1</b>: if you allow your users to configure modules then assigned\r\nmodules won't be reflected in the screen until you configure them\r\nfrom MyTiki->modules.<br />\r\n<b>Note 2</b>: If you assign modules to groups make sure that you\r\nhave turned off the option 'display modules to all groups always'\r\nfrom Admin->General\r\n" => "\r\n<b>Huomaa 1</b>: jos annat käyttäjien muokata moduulien asetuksia\r\nmoduulit eivät reagoi näytöllä ennen kuin ne määritellään\r\nOmaValikko->moduulit.<br />\r\n<b>Huomaa 2</b>: Jos liität moduuleja ryhmille \r\non valinta 'näytä moduulit kaikille aina' pois päältä\r\nYlläpito->Yleiset\r\n",
"tracker name must be unique, field names must be unique \r\nfor a tracker and they must be valid in SQL" => "kortiston nimi on oltava ainutkertainen, samoin kenttien nimet \r\nkortistossa, nimien on sovelluttava SQL kyselyyn",
"Note: if you want to use images please save the post first and you\r\nwill be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor\r\nor use the image URL to include images using the WYSIWYG editor" => "Huomaa: jos haluat käytää kuvia niin tallenna lähetys ensin ja voit\r\nmuokata/lähetettyjä kuvia. Käytä &lt;img&gt; leikettä lisätäksesi kuva tekstialueelle\r\ntai käytä kuvan URL osoitetta suoraan WYSIWYG muokkaimessa",
"Your message has been queued for approval, the message will be posted after\r\na moderator approves it." => "Viestisi on laitettu hyväksyntä jonoon, se lähetetään kun\r\na ylläpitäjä hyväksyy sen.",
"www.plazes.com" => "www.plazes.com",
"ver" => "ver",
"Jukebox" => "Jukebox",
"Workspace not selected" => "Työaluetta ei valittu",
"Permission denied you cannot edit assignments" => "Oikeutesi eivät riitä liitosten muokkaamiseen",
"Permission denied you cannot create assignments" => "Oikeuteisi eivät riitä luomaan liitoksia",
"Permission denied you cannot remove assignments" => "Oikeutesi eivär riitä poistamaan liitoksia",
"Workspace not found" => "Työaluetta ei löytynyt",
"Resource name not selected" => "Resurssin nimeä ei valittu",
"Resource not found" => "Resurssia ei löytynyt",
"Name requiered" => "Tarvitaan nimi",
"Module not set" => "Moduulia ei ole asetettu",
"Closed Workspace" => "Suljettu Työalue",
"Workspace type not found" => "Työalue tyyppiä ei löytynyt",
"Code in use, please select a different code" => "Koodi on käytössä, valitse toinen koodi",
"Code not selected" => "Koodia ei valittu",
"Sorry, the currency \$currency is not available." => "Valitan, valuutta \$currency ei ole saatavilla.",
"Sorry, you are not registered into currency \$currency." => "Valitan, et ole rekisteröitynyt valuuttaan \$currency.",
"DNS check failed for %s" => "DNS tarkistus epäonnistui %s",
"Request failed for %s" => "Pyyntö epäonnistui %s",
"Project Group for " => "Ryhmä Hanke ",
"Project Admin Group for " => "Hankkeen Ylläpito Ryhmä ",
"no description" => "ei kuvausta",
"Image options: xListSize,yListSize,xDetailsSize,yDetailsSize indicated in pixels." => "Kuva vaihtoehdot: xListaaKoko,yListaaKoko,xYksityiskohtainenKoko,yYksityiskohtainenKoko näytetään pixeleinä.",
"Puts an anchor and links to the anchor onto a wiki page" => "Laittaa ankkurin ja linkittää ankkurin sivulle",
"~np~{~/np~ARTICLES(max=>3,topic=>topicName)}{ARTICLES} Insert articles into a wikipage" => "~np~{~/np~ARTICLES(max=>3,aihe=>aiheNimi)}{ARTICLES} Laittaa artikkelit sivulle",
"Insert CSS styles into a wiki page on the fly! You can both include an external file and/or just type the CSS in between the tags" => "Liittää CSS tyylin sivulle lennossa! Voit molempia joko liittää ulkoisen tiedoston/tai kirjoittaa CSS määrittelyn tagien väliin",
"typed-inline style" => "kirjoitettu-sisä tyylinä",
"Insert an iframe into a wiki page. Put the web address in between the tags (the URL of the page you want to show." => "Laittaa iframe:in sivulle. Laittaa verkko osoitteen tagien väliin (eli URL:in sivusta jonka haluat näyttää.",
"Insert an AUTO-SIZING iframe into a wiki page. Only works right for internal pages (those under the same domain as your Tiki.)<br />The iframe height sizes to the height of the contained page. Put the web address in between the tags (the URL of the page you want to show." => "Laittaa AUTO-SIZING iframe:in sivulle. Toimii oikein vain sisäisillä sivuilla (omalla sivustolla.)<br />iframe korkeus on sisältönä olevan sivun korkeus. Laittaa verkko osoitteen tagien väliin (sivun URL jonka haluat näyttää.",
"Insert javascript into a page." => "Lisää javascript sivulle.",
"Loads a complete WebPage into the Wiki page.<BR>Parameter: page=Page to load, replaceLink=add this URL to all Links, onlyBody='yes' search for body tag to diplay only body." => "Lataa koko verkkosivun sivuston sivulle.<BR>Parametri: sivu=Ladattava sivu, korvaaLinkki=lisää tämä URL kaikkiin Linkkeihin, vainRunko='kyllä' etsii runko tagin näyttääkseen vain rungon.",
"Displays a Quicktime Movie on the wiki page" => "Näyttää Quicktime Elokuvan sivulla",
"URL to Movie" => "Elokuvan URL",
"with and height is optional if leaving blank 320 x 240 is used. controller is set to true by default." => "leveys ja korkeus ovat vaihtoehtoisia jos jätät tyhjäksi käytetään 320 x 240. Oletuksena hallinta on tosi.",
"Scroll" => "Vierittäjä",
"Put this on the page to modify the text size of the page on demand, by clicking on an Increase or Decrease Font Size link" => "Laittaa tämän sivulle tekstin koon muutosta varten, paina Suurenna tai Pienennä Kirjasimen Koko linkkiä",
"Displays an alphabetically sorted list of registered users" => "Näyttää aakkostetun luettelon rekisteröityneistä jäsenistä",
"Renders a graph, with linked pages navigation visually figured.\n" => "Luo kaavion, jossa sivut linkkeinä visuaalista siirtymistä varten.\n",
"the number of hops the graph follows\n" => "hyppyjen määrä joita seurataan\n",
"the title of the map\n" => "kartan otsikko\n",
"the space between nodes\n" => "sanaväli solmujen väliin\n",
"Left to Right, the direction of graph\n" => "Vasemmalta oikealle, kaavion suunta\n",
"the background color, use #rrvvbb color types.\n" => "taustaväri, käytä #rrvvbb väri arvoja.\n",
"nothing there, unlimited size. use 5,3 type sizes in inches\n" => "ei mitään siellä, rajoittamaton koko. käytä 5,3 koko tuumina\n",
"the font size in pts presumably\n" => "kirjasimen koko pisteinä\n",
"the name of the font used for labels\n" => "kirjasimen nimeä käytetään etiketeissä\n",
"the shape of a node. can be " => "solmun muoto. voi olla ",
"plaintext ellipse circle egg triangle box diamond trapezium parallelogram house hexagon octagon\n" => "tavallinenteksti ellipsi ympyrä muna kolmio laatikko timantti trapetsi rinnakkais talo hexagon octagon\n",
"style for drawing nodes.\n" => "solmujen piirtotyyli.\n",
"color of the border\n" => "kehyksen väri\n",
"background color of the node\n" => "solmun taustaväri\n",
"sortof relative width ??\n" => "lajitellaan suhteellinen leveys ??\n",
"same mystery as above\n" => "sama mysteerio kuin yllä\n",
"color for links (called edges here)\n" => "linkkien väri (kutsutaan reunoiksi täällä)\n",
"shape of the arrow that come with the link\n" => "nuolen muoto joka tulee linkin mukana\n",
"Displays an alphabetically sorted list of WikiPages" => "Näyttää aakkostetun listan sivuista",
"Resource type not selected" => "Resurssin tyyppiä ei valittu",
"Permission denied you cannot create new resources" => "Oikeutesi eivät riitä luomaan uutta resurssia",
"Permission denied, you cannot admin the workspace" => "Oikeutesi eivät riitä ylläpitämään resursseja",
"Not a portfolio workspace" => "Ei työnäyte työalue",
"Assignment not found" => "Liitosta ei löydy",
"Page not found\".\" \".\$page));\n\t}\n}else{\n\t\$smarty->assign('error_msg', tra(\"Param name not found" => "Sivua ei löydy\".\" \".\$page));\n\t}\n}tai{\n\t\$smarty->assign('error_msg', tra(\"Param nimeä ei löydy",
"Assignments Administration" => "Liitosten Ylläpito",
"are you sure to remove the assigment" => "oletko varma, että haluat poistaa liitoksen",
"Period" => "Ajanjakso",
"Grade Weight" => "Laatu Vaatimus",
"Exam" => "Koe",
"Exercise" => "Harjoitus",
"New Assignment" => "Uusi Liitos",
"Weight" => "Taso",
"Cuaderno de Problemas de" => "Niputetut Ongelmat",
"Admin resource" => "Ylläpidä resurssia",
"My Workspaces" => "Oma Työalueeni",
"Object type:" => "Kohteen tyyppi:",
"Roles Administration" => "Roolien Ylläpito",
"Permission levels" => "Oikeustasot",
"Subject Administration" => "Otsikon Ylläpito",
"Studies" => "Opinnot",
"Gradebook" => "Arvostelukirja",
"Select period" => "Valitse ajanjakso",
"Save grades" => "Tallenna arvostelut",
"Workspace path:" => "Työalue polku:",
"Workspace Types Administration" => "Työalue Tyyppien Ylläpito",
"MenuID" => "ValikkoID",
"Allow Anonymous" => "Salli Nimettömyys",
"Allow Registered" => "Salli Rekisteröityneet",
"Allow private user zone" => "Salli yksityinen käyttäjä alue",
"Workspace resources" => "Työalue resurssit",
"Workspace Types Resources" => "Työalue Tyyppien Resurssit",
"Workspace type name" => "Työalue tyypin nimi",
"Resource name" => "Resurssin nimi",
"Resource description" => "Resurssin kuvaus",
"Resource type" => "Resurssin tyyppi",
"Workspaces Administration" => "Työalueiden Ylläpito",
"User workspace" => "Käyttäjän työalue",
"Hide workspace" => "Piilota työalue",
"Assigned modules" => "Liitetyt moduulit",
"Remove all" => "Poista kaikki",
"Cache time" => "Puskurointi aika",
"AulaWiki Assistant" => "Aula Avustus",
"Welcome to AulaWiki" => "Tervetuloa Aulaan",
"First configuration steps" => "Kokoonpanon ensi askeleet",
"Workspace Calendar" => "Työalue Kalenteri",
"List events" => "Listaa tapahtumat",
"Child Workspaces" => "Ali Työtilat",
"Inactive workspace" => "Ei aktiivinen työtila",
"Clipboard" => "Leikepöytä",
"Workspace History" => "Työtila Historia",
"Current workspace:" => "Nykyinen työtila:",
"Active workspace" => "Aktiivinen työtila",
"My workspaces:" => "Omat työtilat:",
"Resources" => "Resurssit",
"are you sure to remove object " => "haluatko varmasti poistaa kohteen ",
"UserGroups" => "KäyttäjäRyhmät",
"Group Name:" => "Ryhmän Nimi:",
"are you sure to remove group " => "haluatko varmasti poista ryhmän ",
"are you sure to remove user from group " => "haluatko varmasti poistaa käyttäjän ryhmästä ",
"User Workspaces" => "Käyttäjän Työtilat",
"Assignment details" => "Liitos yksityiskohdat",
"Grade" => "Arvostelu",
"Save Grades" => "Tallenna Arvostelut",
"Grade for" => "Arvostele",
"View Structure" => "Näytä Rakenne",
"Workspace Members" => "Työtilan Jäsenet",
"offline users" => "koti käyttäjät",
"Personal portfolio" => "Oma työnäyte",
"Edit information" => "Muuta tietoja",
"Personal Learning Folder" => "Oma Opiskelu Kansio",
"Currencies Admin" => "Valuuttojen Ylläpito",
"Currency Provider Unique Name" => "Valuutan Tarjoajan uniikki nimi",
"Contact email" => "Yhteys sähköposti",
"Domain for list of CC service providers" => "Domain lista Valuutta palvelujen tarjoajista",
"Approval?" => "Hyväksy?",
"Listed?" => "Listattu?",
"Population" => "Asukasluku",
"Transaction" => "Tapahtuma",
"Examine" => "Tutki",
"Unregister" => "Poista rekisteröinti",
"Reregister" => "Uudelleen rekisteröi",
"Pending Registration" => "Odottava Rekisteröinti",
"Modify a Currency" => "Muokkaa Valuuttaa",
"Create a new Currency" => "Luo uusi Valuutta",
"List Currencies" => "Listaa Valuutat",
"My Currencies" => "Omat Valuutat",
"Requires approval" => "Tarvitsee hyväksynnän",
"Listed publicly" => "Listattu julkisesti",
"Register Owner" => "Rekisterin Omistaja",
"Examine Currency" => "Tutki Valuuttaa",
"Edit currency" => "Muokkaa valuuttaa",
"Balance" => "Vaihtotase",
"Amount of transactions" => "Tapahtumien määrä",
"Number of transactions" => "Tapahtumien lukumäärä",
"Last transaction" => "Viimeinen tapahtuma",
"Approved?" => "Hyväksytty?",
"Main Ledger" => "PääKirja",
"New Transaction with" => "Uusi Tapahtuma",
"last transaction date" => "viimeisen tapahtuman päiväys",
"balance" => "vaihtotase",
"total volume" => "kokonaismäärä",
"transactions" => "tapahtumia",
"out" => "ulos",
"{\$thelist[i].age|duration} ago" => "{\$thelist[i].age|duration} sitten",
"Revert Transaction" => "Palauta Tapahtuma",
"record" => "tallenne",
"revert" => "palauta",
"Displays your Plazes info" => "Näyttää Paikkasi tiedot",
"Displays your Plazes WhereIs page" => "Näyttää paikkasi MissäOn sivun",
"New blog post: {\$mail_title}: {\$title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Uusi blogi kirjoitus: {\$mail_title}: {\$title} , {\$mail_user}: {\$mail_date|tiki_short_datetime}",
"The page {\$mail_page} was changed by {\$mail_user} at\n{\$mail_date|tiki_short_datetime}" => "Sivua {\$mail_page} on muuttanut {\$mail_user}  \n{\$mail_date|tiki_short_datetime}",
"You can view the page by following this link:\n    {\$mail_machine}tiki-index.php?page={\$mail_page|escape:\"url\"}" => "Voit katsoa sivua seuraamalla tätä linkkiä:\n    {\$mail_machine}tiki-index.php?page={\$mail_page|escape:\"url\"}",
"You can edit the page by following this link:\n    {\$mail_machine}tiki-editpage.php?page={\$mail_page|escape:\"url\"}" => "Voit muokata sivua seuraamalla tätä linkkiä:\n    {\$mail_machine}tiki-editpage.php?page={\$mail_page|escape:\"url\"}",
"You can view a diff back to the previous version by following\nthis link:\n    {\$mail_machine}tiki-pagehistory.php?page={\$mail_page|escape:\"url\"}&diff2={\$mail_last_version}" => "Voit katsoa edellisiä versioita seuraamalla\ntätä linkkiä:\n    {\$mail_machine}tiki-pagehistory.php?page={\$mail_page|escape:\"url\"}&diff2={\$mail_last_version}",
"List Courses" => "Listaa Kurssit",
"Upcoming `\$module_rows` modified events" => "Tulossa olevat `\$module_rows` muutetut tapahtumat",
"Go \r\n                    back" => "Mene \r\n                    takaisin",
"Return to home \r\n                    page" => "Palaa etu \r\n                    sivulle",
"Confirmation required" => "Tarvitaan varmistus",
"Wiki quick help" => "Wiki pika apu",
"Quicklinks" => "Pikalinkit",
"Please" => "Pyydän",
"log in" => "kirjaudu",
"to access full functionalities" => "käyttääksesi täyttä toiminnallisuutta",
"Go \n                    back" => "Mene \n                    takaisin",
"Return to home \n                    page" => "Palaa omalle \n                    sivulle",
"Skip to navigation" => "Hyppää siirtymiin",
"MyTiki (click!)" => "OmatSivut (paina!)",
"Admin (click!)" => "Ylläpito (paina!)",
"TikiTabs" => "TikiTabit",
"Use Quote plugin for quoting" => "Käytä Lainaus plugia lainaukseen",
"Use {literal}{{/literal}ed id=name} or {literal}{{/literal}ted id=name} to insert dynamic zones" => "Käytä {literal}{{/literal}ed id=nimi} tai {literal}{{/literal}ted id=nimi} lisätäksesi muuttuvia alueita",
"Field is hidden? (visible by admin only)" => "Kenttä on piilotettu? (näkyy vain ylläpidolle)",
"slideshow backward" => "kuvaesitys taaksepäin",
"Emphasis" => "Korostaa",
"italics" => "kallistettu",
"both" => "molemmat",
"use ...page... to separate pages" => "käytä ...sivu... erottaaksesi sivut",
"make_headings" => "tee_pääosia",
"underlines text" => "alleviivaa tekstin",
"Simple box" => "Yksikertainen laatikko",
"Will display using the indicated HTML color" => "Näytetään käyttäen osoitettuja HTML värejä",
"Will display the text centered" => "Näytetään teksti keskitettynä",
"Insert Module Output" => "Liitä Moduuli Tulostus",
"{literal}{MODULE(module=>some_module)}text{MODULE}{/literal}  can be used to insert the output of module \"some_module\" into your Wiki page. See <a href=\"{\$helpurl}PluginModule\">PluginModule</a> for more information. " => "{literal}{MODUULI(module=>some_module)}text{MODUULI}{/literal}  käytetään lisätäksesi moduulin tulostus \"some_module\" sivullesi. Katso <a href=\"{\$helpurl}PluginModule\">PluginModule</a> lisätietoihin. ",
"Rendering Program Code" => "Muodosta Ohjelma Koodi",
"{literal}{CODE()}some code{CODE} {/literal} will render \"some code\" as program code. This plugin has other options; see <a href=\"{\$helpurl}PluginCode\">PluginCode</a>." => "{literal}{CODE()}jotain koodia{CODE} {/literal} muodostaa \"jotain koodia\" ohjelmakoodin. Tällä plugilla on muita vaihtoehtoja; katso <a href=\"{\$helpurl}PluginCode\">PluginCode</a>.",
"Import pages from a PHPWiki Dump" => "Tuo sivuja PHPWiki Dumpista",
"Path to where the dumped files are (relative to tiki basedir with trailing slash ex: dump/)" => "Polku missä dumppi tiedostot ovat (suhteellinen tiki basedir kautta viivan kanssa ex: dump/)",
"updated by the phpwiki import process" => "päivitetty phpwiki tuontiprosessissa",
"created from phpwiki import" => "luotu phpwiki tuonnista",
"Invalid variable value : " => "Väärä muuttujan arvo : ",
"Textarea options: quicktags,width,height,max - Use Quicktags is 1 or 0, width is indicated in chars, height is indicated in lines, max is the maximum number of characters that can be saved." => "Tekstialue valinnat: pikatagit,leveys,korkeus,max - Käytä Pikatageja on 1 tai 0, leveys ilmoitetaan merkkeinä, korkeus riveinä, max on maksimi määrä merkkejä jotka voidaan tallentaa.",
"You need to supply information for : " => "Sinun on annettava tietoja : ",
"Lists ''wanted'' Wiki pages" => "Listaus ''halutaan'' sivuja",
"Please follow the steps below to have your password properly reset:\n\n1. Click the following link to confirm you wish to reset your password:\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\n2. Click the following link to go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else.\n{\$mail_machine}/tiki-change_password.php?user={\$mail_user}&oldpass={\$mail_pass}\n\nAlternatively, go to {\$mail_site} and login using your username and temporary password:\n Username:   {\$mail_user}\n Temporary password:  {\$mail_pass}\n\n3. Done! You should be logged in." => "Ole hyvä ja seuraa alla olevia ohjeita salasanan muuttamiseksi:\n\n1. Paina seuraavaa linkkiä varmistaaksesi salasanan vaihdon:\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\n2. Paina seuraavaa linkkiä päästäksesi ruudulle johon kirjoitat uuden \"pysyvän\" salasanan. Valitse salasana jonka vain sinä tiedät, äläkä kerro sitä muille.\n{\$mail_machine}/tiki-change_password.php?user={\$mail_user}&oldpass={\$mail_pass}\n\nVaihtoehtoisesti mene {\$mail_site} ja kirjaudu käyttäen käyttäjänimeäsi ja väliaikaista salasanaa:\n Käyttäjänimi:   {\$mail_user}\n Väliaikainen salasana:  {\$mail_pass}\n\n3. Tehty! Olet kirjautunut sisään.",
"Like pages" => "Sivut kuin",
"creates an editable drawing named foo" => "luo muokattavan piirroksen nimeltä foo",
"Activs" => "Toimint",
"Ins" => "Pyy",
"time" => "aikka",
"Preview Poll" => "Äänestyksen esikatselu",
"Jukebox preference" => "Jukebox asetukset",
"You do not have permission to write the template" => "Oikeutesi eivät riitä kirjoittamaan mallia",
"Go to your <a href=\"tiki-friends.php\">friendship network</a> to accept or refuse this request" => "Mene <a href=\"tiki-friends.php\">ystävä verkosto</a> hyväksyäksesi tai hylätäksesi pyyntö",
"%H:%M:%S %Z" => "%H:%M:%S %Z",
"ok" => "ok",
"dsn" => "dsn",
"extwiki" => "extwiki",
"ppd" => "ppd",
"adm" => "adm",
"You do not have permission to use this feature." => "Oikeutesi eivät riitä käyttämään tätä ominaisuutta.",
"refresh" => "päivitä",
"uploaded by" => "lähettänyt",
"not specified" => "ei määritelty",
"There was a problem with your upload." => "Ilmeni ongelmia lähetyksesi kanssa.",
"The file you are trying to upload is too big." => "Tiedosto jota yrität lähettää on liian suuri.",
"The file you are trying to upload was only partially uploaded." => "Tiedosto jota yrität lähettää tuli vain osittain.",
"You must select a file for upload." => "On valittava tiedosto lähetettäväksi.",
"%s is an empty archive file" => "%s on tyhjä tiedosto",
"Invalid remote file on url %s" => "Väärä ulkoinen tiedosto url %s",
"%A %d of %B, %Y" => "%A %d %B, %Y",
"%A %d of %B, %Y[%H:%M:%S %Z]" => "%A %d %B, %Y[%H:%M:%S %Z]",
"%a %d of %b, %Y" => "%a %d %b, %Y",
"%a %d of %b, %Y[%H:%M %Z]" => "%a %d %b, %Y[%H:%M %Z]",
"Updated" => "Päivitetty",
"User Selector: use options for automatic field feeding : you can use 1 for author login or 2 for modificator login." => "Käyttäjä Valitsin: käytä valintoja automaattiseen kenttien täyttöön : valitse 1 kirjoittajan kirjautumiseksi tai 2 muokkaajan kirjautumiseksi.",
"Category options: parentId" => "Luokan vaihtoehdot: isäntäId",
"Item Link options: trackerId,fieldId,linkToItem links to item from trackerId which fieldId matches the content of that field. linkToItem 1|0 to create a link to the item in view mode and listing" => "Osa Linkki vaihtoehdot: kortistoId,kenttäId,linkkiOsaan linkittää osan kortistoId:stä jonka kenttäId täsmää kenttä osan kanssa. linkkiOsan 1|0 luodaksesi linkin osaan näytöllä ja listalla",
"num is optional and is the order number of the attachment in the list. If not provided, a list of all attachments is displayed.  Inline makes the comment be the text of the link." => "numero on vaihtoehtoinen ja on järjestysnumero liite listalla. Jos se puuttuu, lista kaikista liitteistä näytetään. Tekee kommentista tekstin linkin.",
"~np~{~/np~RSS(id=>feedId,max=>3,date=>1,body=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>syöteId,max=>3,päivä=>1,runko=>1)}{RSS} Laittaa rss syötteen tuloksen sivulle",
"missing tracker ID for plugin TRACKER" => "puuttuu kortiston ID TRACKER plugille",
"delete" => "poista",
"post" => "lähetä",
"stop monitoring this blog" => "Lopeta tämän blogin tarkkailu",
"posts" => "lähetyksiä",
"visits" => "vierailut",
"show categories" => "näytä luokittelut",
"Tip: hold down CTRL to select multiple categories" => "Vinkki: paina CTRL:ia valitaksesi useita luokitteluja",
"Tip: uncheck the above checkbox to uncategorize this page/object" => "Vinkki: poista merkintä alla olevasta laatikosta poistaaksesi luokittelun sivulta/kohteelta",
"author" => "kirjoittaja",
"user level" => "käyttäjä taso",
"send email to user" => "lähetä viesti käyttäjälle",
"score" => "tilanne",
"delete selected" => "poista valitut",
"move" => "siirrä",
"Posted messages" => "Lähetetyt viestit",
"set" => "aseta",
"replies" => "vastauksia",
"new reply" => "uusi vastaus",
"cancel" => "peruuta",
"up" => "ylös",
"down" => "alas",
"add" => "lisää",
"stop monitoring this map" => "lopeta tämän kartan tarkkailu",
"create" => "luo",
"save" => "tallenna",
"edit template" => "muokkaa mallia",
"send" => "lähetä",
"reply to" => "vastaa",
"Hide module contents" => "Piilota moduulin kommentit",
"Last visitors" => "Viime vierailijat",
"register" => "rekisteröi",
"standard" => "standardi",
"secure" => "salattu",
"stay in ssl mode" => "pysy ssl moodissa",
"go" => "mene",
"cache" => "puskuri",
"use" => "käytä",
"cached" => "puskuroitu",
"print" => "tulosta",
"create pdf" => "luo pdf",
"monitor this page" => "tarkkaile tätä sivua",
"stop monitoring this page" => "lopeta tämän sivun tarkkailu",
"backlinks" => "paluulinkit",
"last modification" => "muokattu viimeksi",
"rename" => "nimeä",
"unlock" => "aukaise",
"lock" => "lukitse",
"perms" => "oikeud",
"history" => "historia",
"similar" => "samanlainen",
"undo" => "peru",
"slides" => "kuvat",
"export" => "vie",
"discuss" => "pohtia",
"add comment" => "lisää kommentti",
"attach file" => "liite tiedosto",
"translation" => "käännös",
"attachments" => "liitteet",
"stats" => "tilastot",
"last changes" => "viimeiset muutokset",
"list pages" => "listaa sivut",
"back to homepage" => "takaisin etusivulle",
"cancel edit" => "peruuta muutos",
"No attachments for this page" => "Ei liitteitä tälle sivulle",
"switch" => "kytkin",
"reads" => "lukijaa",
"view comments" => "näytä kommentit",
"Click here to create it" => "Paina tästä luodaksesi sen",
"wiki help" => "wiki apu",
"Site Calendar" => "Sivusto Kalenteri",
"Best language" => "Paras kieli",
"Enable cache images to all galleries" => "Oikeuta puskurointi kaikille kuva gallerioille",
"Images cache directory" => "Kuvien puskuri hakemisto",
"images" => "kuvista",
"PHP error reporting level for non-admin:" => "PHP virhe raportointi taso ei ylläpidolle:",
"Report PHP errors only for admin" => "Raportoi PHP virheet vain ylläpidolle",
"Server name (for absolute URIs)" => "Palvelimen Nimi (tarkkaa URI:ia varten)",
"HTTPS Server" => "HTTPS Palvelin",
"Automatic (uses HTTPS variable)" => "Automaattinen (käyttää HTTPS muuttujaa)",
"Wiki_Tiki_Title" => "Wiki_Tiki_Otsikko",
"path" => "polku",
"Admin->Features" => "Ylläpito->Ominaisuudet",
"must be turned on and notification is sent to the admin's" => "on oltava päällä ja ilmoitus ylläpidolle lähetetään",
"inter-user message inbox" => "inter-käyttäjän postilaatikko",
"Create a group for each user <br />(with the same\nname as the user)" => "Luo ryhmä jokaiselle <br />(samalla\nnimellä kuin käyttäjä)",
"Validate email address (may not work)" => "Varmista sähköposti osoite (ei ehkä toimi)",
"Require HTTP Basic authentication" => "Vaaditaan HTTP perus varmistus",
"HTTP server name" => "HTTP palvelin nimi",
"HTTP URL prefix" => "HTTP URL etuliite",
"HTTPS server name" => "HTTPS palvelin nimi",
"HTTPS URL prefix" => "HTTPS URL etuliite",
"Only for users" => "Vain käyttäjille",
"Users and admins" => "Käyttäjät ja Ylläpitäjät",
"Full Text Search" => "Täysi Teksti Haku",
"Don't forget: to use feature you will need to enable it on" => "Äläkä unohda: käytääksesi ominaisuutta se on pantava päälle täältä",
"Custom Code" => "Muokattu Koodi",
"Site breadcrumbs" => "Sivusto palat",
"Site search bar" => "Sivuston etsintä palkki",
"Site logo" => "Sivusto logo",
"Site logo source" => "Sivusto logo lähde",
"Site ads and banners" => "Sivuston mainokset ja bannerit",
"Site Menu" => "Sivusto Valikko",
"Note: This feature also requires phplayers to be turned on in Admin->Features" => "Huomio: Tämä ominaisuus tarvitsee myös phplayers päällä olon se löytyy Ylläpitä->Ominaisuudet",
"Manage attachment preferences" => "Hallitse liite kokoonpanoa",
"HTML in Wiki Pages" => "HTML Sivuilla",
"Wiki syntax used when a page contains HTML" => "Sivu syntaxia käytetään kun sivu sisältää HTML:ää",
"full" => "koko",
"partial" => "osittain",
"Enable Feature" => "Käytä Ominaisuutta",
"Wiki attachments preferences" => "Liitteiden kokoonpanot",
"admin banning tpl" => "ylläpidon esto tpl",
"loc" => "pai",
"participants" => "osallistujat",
"cat" => "luet",
"lang" => "kieli",
"prio" => "ensis",
"subscription" => "tilaukset",
"perso" => "henkilö",
"permissions" => "oikeudet",
"admin categories" => "ylläpidä luokitteluja",
"admin categories tpl" => "ylläpidä luokittelujen tpl",
"create new" => "luo uusi",
"edit chart" => "muuta kaavio",
"update" => "päivitä",
"admin charts template" => "ylläpidä kaavion mallia",
"admin content templates" => "ylläpidä sisältö malleja",
"admin content templates template" => "ylläpidä sisälltö mallin mallia",
"use in cms" => "käytä cms:ssä",
"use in wiki" => "käytä wikissä",
"use in newsletters" => "käytä uutislehdessä",
"use in events" => "käytä tapahtumia",
"use in HTML pages" => "käytä HTML sivuilla",
"last modif" => "viimeki muokannut",
"sections" => "osastot",
"admin FortuneCookie" => "ylläpidä OnnenKeksejä",
"admin FortuneCookie tpl" => "ylläpidä OnnenKeksi tpl",
"upload" => "lähetä",
"admin Drawings tpl" => "ylläpidä Piirros tpl",
"admin External Wikis" => "ylläpidä ulkoisia sivuja",
"admin forums template" => "ylläpidä foorumien malli",
"Edit existing forums" => "Muokka olemassa olevia foorumeja",
"flag" => "lippu",
"online" => "linjalla",
"topics" => "aiheet",
"coms" => "kom",
"age" => "ikä",
"last post" => "viimeinen lähetys",
"Assign Permissions (Active)" => "Anna Oikeudet (Aktivoi)",
"Click here to delete this forum" => "Paina tästä poistaaksesi tämän foorumin",
"admin hotwords" => "ylläpidä hotwords",
"admin hotwords template" => "ylläpidä kuumasanojen malli",
"admin HTML page dynamic zones" => "ylläpidä HTML muuttuvia alueita",
"admin Html Pages" => "ylläpidä Html Sivuja",
"admin Html Pages template" => "ylläpidä Html Sivujen malli",
"list repositories" => "lista säilytyspaikoista",
"new repository" => "uusi säilytyspaikka",
"view repository" => "näytä säilytyspaikka",
"view this repository" => "näytä tämä säilytyspaikka",
"new rule" => "uusi sääntö",
"admin featured links" => "ylläpidä ominaisuus linkit",
"admin featured links template" => "ylläpidä ominaisuus linkkien malli",
"position" => "paikka",
"admin Webmail" => "ylläpidä Webmail",
"admin mailin template" => "ylläpidä postitsisään malli",
"section" => "osasto",
"sorted section" => "lajiteltu osasto",
"admin menu builder" => "ylläpidä valikon rakentajaa",
"admin menus template" => "ylläpidä valikko malli",
"options" => "vaihtoehdot",
"admin modules" => "ylläpidä moduuleja",
"admin modules template" => "ylläpidä moduulien malli",
"assign module" => "liitä moduuli",
"left modules" => "moduulit vasemmalla",
"right modules" => "moduulit oikealla",
"edit/create" => "muokkaa/luo",
"clear cache" => "tyhjennä puskuri",
"\n<b>Note 1</b>: if you allow your users to configure modules then assigned\nmodules won't be reflected in the screen until you configure them\nfrom MyTiki->modules.<br />\n<b>Note 2</b>: If you assign modules to groups make sure that you\nhave turned off the option 'display modules to all groups always'\nfrom Admin->General\n" => "\n<b>Huomaa 1</b>: jos annat käyttäjien muokata moduuleja silloin liitetyt\nmoduulit eivät reagoi muutoksiin ennen kuin muutat niitä vastaavasti\nOmaSivu->moduulit.<br />\n<b>Huomaa 2</b>: Jos liität moduuleja ryhmille pidä huoli että\nnäytä kaikki 'moduulit kaikille ryhmille aina on päällä'\nYlläpidä->Yleiset\n",
"assign" => "liitä",
"left" => "vasen",
"right" => "oikea",
"order" => "järjestys",
"parameters" => "parametrit",
"create/edit" => "luo/muokkaa",
"use poll" => "käytä äänestystä",
"use gallery" => "käytä galleriaa",
"use dynamic  content" => "käytä muuttuvaa sisältöä",
"use rss module" => "käytä rss moduulia",
"use menu" => "käyttäjä valikko",
"use phplayermenu" => "käytä phplayervalikkoa",
"use banner zone" => "käytä banneri aluetta",
"structure" => "rakenne",
"list newsletters" => "listaa uutislehdet",
"admin newsletters" => "ylläpidä uutislehtiä",
"send newsletters" => "lähetä uutislehdet",
"admin newsletters template" => "ylläpidä uutiskirjeen malli",
"editions" => "laitokset",
"last sent" => "viimeksi lähetetty",
"send newsletter" => "lähetä uutiskirje",
"admin Email Notifications" => "ylläpidon sähköposti ilmoitus",
"admin notifications template" => "ylläpidon huomautus malli",
"use admin email" => "käytä ylläpidon sähköpostia",
"event" => "tapahtuma",
"admin polls" => "ylläpidä äänestyksiä",
"admin polls template" => "ylläpidä äänestys malli",
"admin QuickTags" => "ylläpidä PikaLisiä",
"label" => "etiketti",
"admin RSS Modules" => "ylläpidä RSS moduuleje",
"admin RSSmodules template" => "ylläpidä RSSmoduulien malli",
"edit tpl" => "muuta tpl",
"admin shoutbox words" => "ylläpidä pikaviestin sanoja",
"admin shoutbox words template" => "ylläpidä pikaviesti sanojen malli",
"admin structures template" => "ylläpidä rakenne malli",
"export pages" => "tulosta sivut",
"dump tree" => "dumppi puu",
"create webhelp" => "luo webapu",
"view webhelp" => "näytä webapu",
"tree" => "puu",
"create new structure" => "luo uusi rakenne",
"survey stats" => "tutkimus tilastot",
"edit this survey" => "muuta tätä tutkimusta",
"admin surveys" => "ylläpidä tutkimuksia",
"list surveys" => "listaa tutkimukset",
"questions" => "kysymykset",
"files" => "tiedostot",
"admin topics template" => "ylläpidä aiheiden malli",
"Field is public? (for use thru trackerlist plugin)" => "Kenttä on julkinen? (käytetään trackerlist plugin kautta)",
"admin Trackers tpl" => "ylläpidä Kortistojen tpl",
"Edit fields for tracker" => "Muuta kortiston kenttiä",
"items" => "osat",
"The tracker needs a text field named Subject" => "Kortisto tarvitsee kentän nimeltä Otsikko",
"version" => "versio",
"admin groups" => "ylläpidä ryhmiä",
"admin groups template" => "ylläpidä ryhmä malli",
"assign permissions" => "anna oikeudet",
"admin" => "ylläpitäjä",
"remove from group" => "poista ryhmäsät",
"admin users" => "ylläpidä käyttäjiä",
"admin users template" => "ylläpidä käyttäjien malli",
"Added users" => "Lisätyt käyttäjät",
"edit account settings" => "muokkaa tili asetuksia",
"edit included group" => "muokkaa sisällytettyä ryhmää",
"assign to groups" => "liitä ryhmiä",
"Batch upload (CSV file<a {popup text='login,password,email,groups<br />user1,password1,email1,&quot;group1,group2&quot;<br />user2, password2,email2'}><img src=\"img/icons/help.gif\" border=\"0\" height=\"16\" width=\"16\" alt='{tr}help" => "Ryhmä lähetys (CSV tiedosto<a {popup text='kirjaus,salasana,sähköposti,ryhmät<br />user1,password1,email1,&quot;group1,group2&quot;<br />user2, password2,email2'}><img src=\"img/icons/help.gif\" border=\"0\" height=\"16\" width=\"16\" alt='{tr}help",
"edit article tpl" => "muokkaa artikkeli tpl",
"advanced feature" => "kehittyneempi ominaisuus",
"all" => "kaikki",
"Assign user" => "Liitä käyttäjä",
"Available groups" => "Saatavilla olevat ryhmät",
"assign perms to this group" => "anna oikeudet tälle ryhmälle",
"admin backups" => "ylläpidon varmuuskopio",
"admin admin tpl" => "ylläpidä ylläpitäjän tpl",
"Use of this feature is NOT recommended. Please use phpMyAdmin or mysqldump instead." => "Tämän ominaisuuden käyttöä EI suositella. Käytä ohjelmaa phpMyAdmin tai mysqldump tämän sijasta.",
"List of available backups" => "Listaa saatavilla olevat varmuuskopiot",
"Restoring a backup" => "Palautetaan varmuuskopio",
"Warning!" => "Varoitus!",
"Restoring a backup destoys all the data in your Tiki database. All your tables will be replaced with the information in the backup." => "Tietojen palautus varmuuskopiosta tuhoaa kaiken uudemman tiedon. Kaikki tiedot korvataan varmuuskopion teko hetken aikaisilla tiedoilla.",
"Click here to confirm restoring" => "Paina tästä aloittaaksesi palautus",
"Create new backup" => "Luo uusi varmuuskopio",
"Creating backups may take a long time. If the process is not completed you will see a blank screen. If so you need to increment the maximum script execution time from your php.ini file" => "Varmuuskopion luominen kestää kauan. Jos kopiointi ei mene loppuun asti näet tyhjän ruudun. Sinun on lisättävä scriptin maksimi ajo aikaa php.ini tiedostossa",
"Your image gallery storage is set to \"{\$gal_use_dir}\", you will need to backup this using FTP or SCP." => "Sinun kuvagalleriasi levytila on \"{\$gal_use_dir}\", tee varmuuskopio käyttäen FTP:tä tai SCP:tä.",
"Your file gallery storage is set to \"{\$fgal_use_dir}\", you will need to backup this using FTP or SCP." => "Sinun tiedostogalleriasi levytila on \"{\$fgal_use_dir}\", tee varmuuskopio käyttäen FTP:tä tai SCP:tä.",
"If any of your forums have attachments stored in the directory you will need to backup these using FTP or SCP." => "Jos foorumiesi liitetiedostot on tallennettu hakemistoon tee varmuuskopio käyttäen FTP:tä tai SCP:tä.",
"Upload a backup" => "Lähetä varmuuskopio",
"Upload backup" => "Lähetä varmuuskopio",
"remove file extension from image name" => "poista tiedostopääte kuvan nimestä",
"convert sub directories to sub galleries" => "muuntaa alihakemistot aligallerioiksi",
"eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named screenshots will be created" => "esim. \"misc/screenshots/digicam0001.jpg\" ja galleria nimeltä screenshots luodaan",
"use sub directory names as description" => "käyttää alihakemiston nimiä kuvauksena",
"eg. from \"misc/screenshots/digicam0001.jpg\" a description misc/screenshots will be created" => "esim. \"misc/screenshots/digicam0001.jpg\" ja luodaan kuvaus misc/screenshots ",
"view blog" => "näytä blogi",
"list blogs" => "listaa blogit",
"Note: if you want to use images please save the post first and you\nwill be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor\nor use the image URL to include images using the WYSIWYG editor. " => "Huomio: jos haluat käyttää kuvia tallenna lähetys ensin ja sinä\nvoit muokata/lähettää kuvia. Käytä &lt;img&gt; palaa lisätäksesi lähettämäsi kuvat editorin tekstialueelle\ntai voit käyttää URL lisätäksesi kuvat WYSIWYG editoriin. ",
"save and exit" => "tallenna ja poistu",
"admin the category system" => "ylläpidä luokka järjestelmää",
"admin category" => "ylläpidä luokittelua",
"search category" => "etsi luokka",
"deep" => "syvä",
"list galleries" => "listaa galleriat",
"edit gallery" => "muokkaa galleriaa",
"rebuild thumbnails" => "rakenna minikuvat",
"upload image" => "lähetä kuva",
"list gallery" => "listaa galleria",
"hit" => "osuma",
"original size" => "alkuperäinen kuva",
"return to gallery" => "palaa galleriaan",
"edit image" => "muokkaa kuvaa",
"smaller" => "pienempi",
"bigger" => "suurempi",
"prev image" => "edellinen kuva",
"popup window" => "popup ikkuna",
"next image" => "seuraava kuva",
"slideshow forward" => "kuvaesitys eteenpäin",
"stop" => "seis",
"imagescale" => "kuvamuunnos",
"add item" => "lisää osa",
"list view" => "listaus näyttö",
"Subscription List" => "Tilaaja Lista",
"or create a new category" => "tai luo uusi luokka",
"or create a new location" => "tai luo uusi sijainti",
"comma separated usernames" => "pilkku erottaa käyttäjänimet",
"comma separated username:role" => "pilkku erottaa käyttäjänimen:tehtävän",
"with roles" => "ja tehtävät",
"Chair" => "Istuin",
"Optional" => "Vaihtoehtoinen",
"Format: mm/dd/yyyy hh:mm<br />..." => "Muoto: kk/pp/vvvv tt:mm<br />...",
"See strtotime php function" => "Katso strtotime php toiminto",
"Format: mm/dd/yyy hh:mm<br />..." => "Muoto: kk/pp/vvv tt:mm<br />...",
"save_to" => "tallenna",
"permission" => "oikeudet",
"remove from this category &amp; all its children" => "poista tästä luokasta &amp; ja kaikki alaluokat",
"remove from this category only" => "poista vain tästä luokasta",
"Textheight" => "Tekstinkorkeus",
"Height of top Heading" => "Ylimmän pääosan korkeus",
"Height of mid Heading" => "Medium pääosan korkeus",
"Height of inner Heading" => "Sisäisen pääosan korkeus",
"tbheight" => "tbkorkeus",
"Automatic Page Breaks" => "Automaattiset Sivu Jaot",
"remove page" => "poista sivu",
"admin directory tpl" => "ylläpidä hakemisto tpl",
"browse" => "selaa",
"related" => "liittyvä",
"validate" => "vahvista",
"admin directory categories tpl" => "ylläpidä hakemisto luokittelujen tpl",
"add a site" => "lisää sivusto",
"add a category" => "lisää luokka",
"search" => "etsi",
"list articles" => "listaa artikkelit",
"view articles" => "näytä artikkelit",
"create zone" => "luo alue",
"save the banner" => "tallenna banneri",
"edit blog tpl" => "muuuta blog tpl",
"try" => "kokeile",
"display" => "näytä",
"For more information, please see <a href=\"{\$helpurl}WikiSyntax\">WikiSyntax</a>" => "Saadaksesi lisää tietoja, katso <a href=\"{\$helpurl}WikiSyntax\">SivuSyntaxi</a>",
"Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done)." => "Näyttää esimuotoillun tekstin/koodin; mitään prosesseja ei suoriteta näillä osastoilla (kuin np), ja tila on vakio (ei automaattista rivitystä).",
"admin quicktags" => "ylläpidon pikatagit",
"create new block" => "luo uusi blokki",
"list quizzes" => "listaa visailut",
"quiz stats" => "visailu tilastot",
"edit this quiz" => "muuta tätä visailua",
"admin quizzes" => "ylläpidä visailuja",
"admin quizzes tpl" => "ylläpidä visailut tpl",
"results" => "tulokset",
"edit quiz questions" => "muokkaa visailun kysymyksiä",
"edit quiz questions tpl" => "muokkaa visailun kysymyksiä tpl",
"create page" => "luo sivu",
"edit submissions tpl" => "muokkaa ehdotus tpl",
"list submissions" => "listaa ehdotukset",
"save only in the theme:" => "tallenna vain teemaan:",
"edit translations" => "muokkaa käännöksiä",
"edit translations template" => "muokkaa käännöksiä malli",
"add to the set" => "lisää sarjaan",
"Search " => "Etsi ",
"replace" => "korvaa",
"Admin ephemerides" => "Ylläpidä ephemerides",
"admin Ephemerides tpl" => "ylläpidä Ephemerides tpl",
"All ephemerides" => "Kaikki ephemerides",
"new question" => "uusi kysymys",
"approve" => "hyväksy",
"configure listing" => "kokoonpano listaus",
"create new gallery" => "luo uusi galleria",
"topic" => "aihe",
"save and approve" => "tallenna ja hyväksy",
"new topic" => "uusi aihe",
"reject" => "hylätty",
"accept" => "hyväksy",
"refuse" => "hylkää",
"add new" => "lisää uusi",
"add role" => "lisää tehtävä",
"new minor" => "uusi pieni",
"new major" => "uusi iso",
"admin processes" => "ylläpidä prosesseja",
"admin activities" => "ylläpidä toimintoja",
"admin roles" => "ylläpidä tehtäviä",
"edit this process" => "muuta tätä prosessia",
"monitor" => "tarkkailija",
"send instance" => "lähetä pyyntö",
"rebuild cache" => "rakenna puskuri",
"result" => "tulos",
"reload" => "lataa uudelleen",
"edit repository" => "muuta tallennuspaikka",
"source" => "lähde",
"list articles tpl" => "listaa artikkelit tpl",
"edit new article" => "muuta uutta artikkelia",
"admin Banners" => "ylläpidä Bannerit",
"admin Banners tpl" => "ylläpidä Bannerit tpl",
"create new blog" => "luo uusi blogi",
"admin cache" => "ylläpidä puskuri",
"admin cache tpl" => "ylläpidä puskuri tpl",
"admin DynamicContent tpl" => "ylläpidä MuuttuvaSisältö tpl",
"list faqs tpl" => "listaa ukk tpl",
"upload file" => "Lähetä tiedosto",
"Edit a file using this form" => "Muokkaa tiedostoa käyttäen tätä lomaketta",
"monitor this gallery" => "tarkkaile tätä galleriaa",
"stop monitoring this gallery" => "lopeta tämän gallerian tarkkailu",
"delete selected files" => "poista valitut tiedostot",
"browse gallery" => "selaa galleriaa",
"Flash binary (.sqf or .dcr)" => "Flash binary (.sqf tai .dcr)",
"list posts tpl" => "listaa lähetys tpl",
"edit blog" => "muokkaa blogia",
"list quizzes tpl" => "listaa visailu tpl",
"edit new submission" => "muuta uutta ehdotusta",
"edit quiz stats tpl" => "muokkaa visailu tilastoja tpl",
"actions" => "toiminnot",
"take survey" => "ota tutkimus",
"list trackers tpl" => "listaa kortistot tpl",
"admin live support tpl" => "ylläpidä elävä tuki tpl",
"set as operator" => "aseta operaattoriksi",
"add topic" => "lisää aihe",
"Apache has the right to write in your file tree, which enables the installation, removal or \nupgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \n\"./setup.sh\" for example)." => "Apachella on oikeus kirjoittaa hakemistopuuhusi, joka mahdollistaa asennukset, poiston tai \npakettien päivitykse. Kun nämä toimenpiteet on tehty, muuta oikeudet takaisin turvalliseen tilaan (käyttäen \n\"./setup.sh\" esimerkiksi).",
"To install, remove or upgrade packages you need to give the apache user the right\nto write files in your web tree (you can use \"./setup.sh open\" to set it up). After installation you need to remove that\npermission (using \"./setup.sh\")." => "Asentaaksesi, poistaaksesi tai päivittääksesi paketteja apache tarvitsee oikeudet\nkirjoittaa tiedostoja hakemistopuuhusi (voit käyttää \"./setup.sh open\" antaaksesi oikeudet). Asennuksen jälkeen palauta \noikeudet (käyttäen \"./setup.sh\").",
"install" => "asenna",
"wiki create" => "wiki luonti",
"wiki overwrite" => "wiki päällekirjoitus",
"back" => "takaisin",
"Assign permissions to page" => "Liitä sivuun oikeudet",
"Current permissions for this page" => "Nykyiset oikeudet tälle sivulle",
"remove from this page" => "poista tältä sivulta",
"remove from this structure" => "poista tästä rakenteesta",
"No individual permissions; category or global permissions apply" => "Ei yksittäisoikeuksia; luokka tai yleiset oikeudet annetaan",
"this page" => "tämä sivu",
"this structure" => "tämä rakenne",
"Current permissions for categories that this page belongs to" => "Nykyiset oikeudet tämän sivun luokkiin kuuluvat",
"Send email notifications when this page changes to" => "Lähetä sähköposti ilmoitus kun tämä sivu muuttuu tänne",
"add email" => "lisää sähköposti",
"Notifications" => "Huomautukset",
"clear" => "tyhjennä",
"clear stats" => "tyhjennä tilastot",
"Edit received page" => "Muokkaa vastaanotettua sivua",
"admin Referer stats" => "ylläpidä Suositus tilastoja",
"admin Referer stats tpl" => "ylläpidä Suositus tilastoja tpl",
"last" => "viimeinen",
"send me my password" => "lähetä salasanani",
"searched" => "etsitty",
"galleries" => "gallerioista",
"blog posts" => "blogi lähetyksistä",
"wiki pages" => "sisäiset sivut",
"admin send objects tpl" => "ylläpidä lähetä kohteet tpl",
"site" => "sivusto",
"add article" => "lisää artikkeli",
"create new sheet" => "luo uusi arkki",
"admin Tiki Shoutbox" => "ylläpidä Pikaviestintä",
"admin Tiki Shoutbox tpl" => "ylläpidä Pikaviestintä tpl",
"first" => "ensimmäinen",
"send answers" => "lähetä vastaukset",
"move to right column" => "siirrä oikeaan palstaan",
"unassign" => "poistaliitos",
"move to left column" => "siirrä vasempaan palstaan",
"remove folder" => "poista kansio",
"refresh cache" => "päivitä puskuri",
"General preferences" => "Yleiset asetukset",
"Other preferences" => "Muut asetukset",
"HomePage" => "EtuSivu",
"Change information" => "Muuta tietoja",
"admin mode" => "ylläpidollinen",
"trash" => "roskis",
"empty trash" => "tyhjennä roskis",
"remove from trash" => "poista roskiksesta",
"use start date and time" => "käytä aloituspäivää ja aikaa",
"use end date and time" => "käytä lopetuspäivää ja aikaa",
"edit user files" => "muokkaa käyttäjä tiedostoja",
"no comments" => "ei kommentteja",
"edit items" => "muokkaa osia",
"list charts" => "listaa kaaviot",
"last chart" => "viimeisin kaavio",
"item" => "osa",
"view faq" => "näytä ukk",
"view faq tpl" => "näytä ukk tpl",
"admin menus tpl" => "ylläpidä valikoiden tpl",
"add suggestion" => "lisää ehdotus",
"monitor this forum" => "tarkkaile tätä foorumia",
"stop monitoring this forum" => "lopeta tämän foorumin tarkkailu",
"delete selected topics" => "poista valitut aiheet",
"topics in this forum" => "Tämän foorumin aiheet",
"stop monitoring this topic" => "lopeta tämän aiheen tarkkailu",
"Comments below your current threshold" => "Kommentit nykyisen kynnyksen alta",
"list attachments" => "listaa liitteet",
"remove image" => "poista kuva",
"add contacts" => "lisää yhtyeksiin",
"DATE-of" => "PÄIVÄYS",
"The passwords dont match" => "Salasana ei kelpaa",
"The passwords didn't match" => "Salasana ei täsmää",
"You cannot edit this page because it is a user personal page" => "Et voi muokata tätä sivua, koska se on käyttäjän oma sivu",
"Permission denied you cannot assign permissions for this page" => "Oikeutesi eivät riitä asettamaan oikeuksia tälle sivulle",
"You do not have permission to edit messages" => "Oikeutesi eivät riitä muokkaamaan viestiä",
"Cannot read file" => "Tiedostoa ei voi lukea",
"Permission denied you cannot upload files" => "Et voi lähettää tiedostoja",
"cannot process upload" => "ei voi käsitellä lähetystä",
"Your email address has been removed from the list of addresses monitoring this tracker" => "Sähköpostiosoitteesi on poistettu tarkkailtavien listalta",
"Your email address has been added to the list of addresses monitoring this tracker" => "Sähköpostiosoitteesi on lisätty tarkkailtavien listalle",
"Cancel monitoring" => "Peruuta tarkkailu",
"Your email address has been removed from the list of addresses monitoring this item" => "Sähköpostiosoitteesi on poistettu tämän osan tarkkailtavien listalta",
"Your email address has been added to the list of addresses monitoring this item" => "Sähköpostiosoitteesi on lisätty tämän osan tarkkailtavien listalle",
"tikiwiki logo" => "tikiwiki logo",
"Dls" => "Dls",
"pdf" => "pdf",
"UTC" => "UTC",
"zoom" => "zoom",
"pop" => "pop",
"Russian Federation" => "Venäjä",
"new image uploaded by" => "uuden kuvan lähettäjä",
"new subscriptions" => "uudet tilaukset",
"new item in tracker" => "uusi osa kortistossa",
"show" => "näytä",
"hide" => "piilota",
"field is not numeric" => "kenttä ei ole numeerinen",
"Textarea options: quicktags,width,height,max,listmax - Use Quicktags is 1 or 0, widthis indicated in chars, height is indicated in lines, max is the maximum number of characters that can be saved, listmax isthe maximum number of characters that are displayed in list mode." => "Tekstialueen vaihtoehdot: pikatagit,leveys,korkeus,max,listaa maksimi - Käytä pikatagian on 1 tai 0, tämän leveys osoitetaan merkkeinä, korkeus osoitetaan riveinä, max on tallennettavissa olevien merkkien suurin määrä, listaa maksimi on maksimi määrä merkkejä jotka näytetään listauksessa.",
"Country Selector options: 1|2 where 1 show only country name and 2 show only country flag. By default show both country name and flag" => "Maa Valitsimen vaihtoehdot: 1|2 missä 1 näyttää vain maan nimen ja 2 näyttää vain maan lipun. Oletuksena näytetään molemmat",
"message" => "viesti",
"Include all post in a blog" => "Sisällytä kaikki blogin lähetykset",
"Include an article" => "Sisällytä artikkeli",
"no such attachment on this page" => "ei sellaista liitettä sivulla",
"select all" => "valitse kaikki",
"filter" => "suodin",
"missing fields list" => "puuttuu kenttä lista",
"move %s in %s" => "siirrä %s -> %s",
"no such file" => "ei sellaista tiedostoa",
"downloads" => "imuroinnit",
"download" => "imuroi",
"attach" => "liitä",
"monitor this blog" => "tarkkaile tätä blogia",
"hide categories" => "piilota luokittelut",
"Admin categories" => "Admin luokittelut",
"browse category" => "selaa luokkaa",
"reply" => "vastaa",
"monitor this topic" => "tarkkaile tätä aihetta",
"active perms" => "aktiiviset oikeudet",
"with checked" => "merkityt",
"move selected files" => "siirrä valitut tiedostot",
"Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else.\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\nDone! You should be logged in." => "Paina seuraavaa linkkiä varmistaaksesi salasanan uudelleen asetuksen ja mene näytölle jolla voit vaihtaa \"pysyvän\" salasanan. Valitse salasana jonka vain itse tiedät, äläkä kerro sitä kenellekään.\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\nTehty! Olet kirjautunut sisään.",
"Thank you for you registration. You may log in now." => "Kiitos rekisteröinnistäsi. Nyt voi kirjautua normaalisti.",
"Zoom out x4" => "Suurenna x4",
"Zoom out x3" => "Suurenna x3",
"Zoom in x3" => "Pienennä x3",
"Zoom in x4" => "Pienennä x4",
"from\nthe mapfile:" => " \nkarttatiedostosta:",
"compare" => "vertaa",
"diff" => "erot",
"older version" => "vanhempi versio",
"Click the :: options in the Menu for more options." => "Paina :: vaihtoehdosta saadaksesi lisää valikko vaihtoehtoja.",
"Please, also see" => "Katso myös",
"for more setup details." => "lisää asetus yksityiskohtia.",
"Note 1:" => "Huomio 1:",
"You can remove this module in" => "Voit poistaa moduulin täältä",
"as well as assign or edit many others." => "tai liitä ja muokkaa monia muita.",
"Note 2:" => "Huomio 2:",
"The menu module installed by default is named" => "Oletuksena asennettu valikko moduuli on nimetty",
"it is a \"custom module\" which includes menu ID " => "se on \"muokattu moduuli\" jolla on valikko ID ",
"That menu is stored in database and it can be edited from " => "Se valikko on varastoitu tietokantaan ja voi muuttaa ",
"Do not mix this with the original <em>application_menu</em> module" => "Älä sekoita tätä alkuperäiseen <em>ohjelmat valikko</em> moduuliin",
"That one can be heavily customized to match style used but it can be currently done only by editing mod-application_menu.tpl file \"manually\"" => "Sitä voi muokata jotta se sopisi tyyliin, mutta sen voi tehdä vain muokkaamalla mod-application_menu.tpl tiedostoa \"käsin\"",
"del" => "pois",
"Create pdf" => "Luo pdf",
"1 file attached" => "1 liite tiedosto",
"categories" => "luokkaa",
"List pages where I am a creator" => "Listaa sivut joilla olen luojana",
"by creator" => "luojana",
"List pages where I am a modificator" => "Listaa sivut joita olen muokannut",
"by modificator" => "muokkaajana",
"at tracker" => "kortistossa",
"calendar view" => "kalenteri näyttö",
"check / uncheck all" => "merkitse / poista merkintä kaikista",
"Tiki sections and features" => "Osastot ja ominaisuudet",
"tikiwiki.org help" => "tikiwiki.org apu",
"Site Logo and Identity" => "Sivusto Logo ja Identity",
"Use Quote plugin rather than &ldquo;>&rdquo; for quoting" => "Käytä Lainaus plugia mieluummin kuin &ldquo;>&rdquo; lainauksiin",
"Storing files in a directory" => "Tiedostot varastoidaan hakemistoon",
"please read" => "ole hyvä ja lue",
"yes" => "kyllä",
"Click here for more details." => "Paina tästä saadaksesi lisätietoja.",
"Tiki preferences value field in db is set to be max. 250 characters long by default until now. That applies for the custom code content too. Check this field if you want to update your preferences database table to support more than 250 chars (although it was tested and works fine with mysql, it's recommended to backup your data manually before any database update)" => "Sivuston kokoonpanon kenttäarvo tietokannassa on asetettu max. 250 pituiseksi oletuksena nyt. Se on myös muokatussa koodisisällössä. Tarkista tämä kenttä jos haluat päivittää kokoonpanoasi että tietokanta tukee suurempia kuin 250 merkkiä (testattu ja toimii ainakin mysql, Aina kun teet tietokanta muutoksia tee käsin varmuuskopiot)",
"Users &amp; groups" => "Käyttäjät &amp; ryhmät",
"private" => "yksityinen",
"<b>Item</b>" => "<b>Osa</b>",
"<b>Value</b>" => "<b>Arvo</b>",
"This page is to configure settings of RSS feeds generated/exported by Tiki. To read/import RSS feeds, look for \"RSS Modules\" on the application menu, or" => "Tämä sivu on kokoonpano sivu RSS syötteille jotka muodostetaa/tulostetaan sivuston. Lukeaksesi/hakeaksesi RSS syötteen, katso \"RSS moduulit\" ohjelmisto valikossa, tai",
"<b>Feed</b>" => "<b>Syöte</b>",
"<b>enable/disable</b>" => "<b>päälle/pois</b>",
"<b>Max number of items</b>" => "<b>Maksimi määrä osia</b>",
"Feed for Articles" => "Syöte Artikkeleille",
"Feed for Weblogs" => "Syöte Weblogeille",
"Feed for Image Galleries" => "Syöte Kuva Gallerioille",
"Feed for File Galleries" => "Syöte Tiedosto Gallerioille",
"Feed for the Wiki" => "Syöte Wiki",
"Feed for individual Image Galleries" => "Syöte yksittäiselle Kuva Gallerialle",
"Feed for individual File Galleries" => "Syöte yksittäiselle Tiedosto Gallerialle",
"Feed for individual weblogs" => "Syöte yksittäiselle weblogille",
"Feed for individual forums" => "Syöte yksittäiselle foorumille",
"Feed for mapfiles" => "Syöte karttatiedostoille",
"Feed for directories" => "Hakemistojen syöte",
"Feed for individual tracker items" => "Syöte yksittäisen kortiston osille",
"Feed for tracker items" => "Kortisto osien syöte",
"Feed for upcoming calendar events" => "Syöte tuleville kalenteri tapahtumille",
"Prefix breadcrumbs with 'Location:' label?" => "Etuliite palasta ja 'Sijainti:' etiketti?",
"Site Search" => "Sivusto Etsintä",
"Change style only" => "Muuta vain tyyli",
"WARNING : Old and New trackers cannot coexist. Trackers created with new library\nwill not work with old library and conversely" => "WAROITUS : Vanha ja uusi kortisto eivät voi esiintyä yhtaikaa. Kortistot jotka on luotu uuden kirjaston alaisena\nei näy vanhalla ja päinvastoin",
"PDF generation" => "PDF luonti",
"IP not displayed in history" => "IP:tä ei näytetä sivuhistoriassa",
"Use in CMS" => "Käytä cms:ssä",
"Use in Wiki" => "Käytä wikissä",
"Use in newsletters" => "Käytä uutislehdessä",
"Use in events" => "Käytä tapahtumia",
"Use in HTML pages" => "Käytä HTML sivuilla",
"Edit Existing Forums" => "Muuta olemassa olevia foorumeja",
"Refresh rate (if dynamic) [secs]" => "Päivitys väli (jos muuttuva) [sek]",
"configure repositories" => "säilytyspaikan kokoonpano",
"configure this repository" => "Muuta säilytyspaikan kokoonpanoa",
"copy rules" => "kopio säännöt",
"Create/edit newsletters" => "<Luo/muokkaa uutislehteä",
"subscriptions" => "tilaus",
"archives" => "arkistot",
"Use Admin Email" => "Käytä ylläpidon sähköpostia",
"Edit or add poll options" => "Muuta tai lisää äänestys vaihtoehtoja",
"configure polls" => "muokkaa äänestyksiä",
"Create/edit Polls" => "Luo/muuta Äänestyksiä",
"Tip: hold down CTRL to select multiple" => "Vihje: paina CTRL alas valitaksesi useampia",
"Rss channels" => "Rss kanavat",
"show pubdate" => "näytä julkaisupäivä",
"activate" => "aktivoi",
"Admin tracker" => "Ylläpidä kortistoa",
"Edit this tracker" => "Muokkaa tätä kortistoa",
"View this tracker items" => "Näytä tämän kortiston osat",
"Edit tracker fields" => "Muokkaa kortiston kenttiä",
"Import/export trackers fields" => "Tuonti/vienti kortiston kentistä",
"Edit tracker" => "Muuta kortisto",
"Create trackers" => "Luo kortistoja",
"Import/export" => "Tuonti/vienti",
"fields" => "kentät",
"active permissions" => "aktiiviset oikeudet",
"Create/edit trackers" => "Luo/muokkaa kortistoja",
"filename" => "tiedostonimi",
"filesize" => "tiedostokoko",
"filetype" => "tiedostoyyppi",
"longdesc" => "pitkäkuvaus",
"Add a new group" => "Lisää uusi ryhmä",
"Edit item" => "Muuta osaa",
"List all members" => "Listaa kaikki jäsenet",
"Add a new user" => "Lisää uusi käyttäjä",
"manage group assignments" => "hallitse ryhmä liitoksia",
"set default groups" => "aseta oletus ryhmät",
"Popup Window" => "Popup ikkuna",
"details" => "yksityiskohdat",
"change focus" => "muuta keskitystä",
"quater" => "neljäsosa",
"quarter" => "neljännes",
"semester" => "puolivuotis",
"No individual permissions global permissions apply" => "Ei erityisoikeuksia yleiset oikeudet liitetään",
"Welcome to the Tiki Chat Rooms" => "Tervetuloa Sivuston JuttuHuoneisiin",
"Please select a chat channel" => "Valitse juttu kanava",
"enter chat room" => "mene juttu huoneeseen",
"There are no channels setup, please contact a site admin" => "Ei ole kanava asetusta, ota yhteyttä ylläpitoon",
"Chatroom" => "Juttuhuone",
"Active Channels" => "Aktiiviset Kanavat",
"Users in this channel" => "Käyttäjiä tällä kanavalla",
"Channel Information" => "Kanava tiedot",
"Channel" => "Kanava",
"Ratio" => "Suhde",
"Use :nickname:message for private messages" => "Käytä :lempinimi:viesti yksityis viesteille",
"Use [URL|description] or [URL] for links" => "Käytä [URL|kuvaus] tai [URL] linkkejä",
"Use (:smileyname:) for smileys" => "Käytä (:hymiönimi:) hymiöille",
"Create PDF" => "Luo PDF",
"PDF Settings" => "PDF Asetukset",
"Select Wiki Pages" => "Valitse Sivu",
"Remove Page" => "Poista sivu",
"click here to send us an email" => "paina, lähettääksesi meille sähköpostia",
"Add or edit a site" => "Lisää tai muokkaa sivustoa",
"sites" => "sivustot",
"cool sites" => "siistit sivustot",
"Use ...page... to separate pages in a multi-page article" => "Käytä ...sivu... erotellaksesi sivut monisivuisessa artikkelissa",
"Create Zone" => "Luo alue",
"use square brackets for an external link: [URL] or [URL|link_description] or [URL|description|nocache]  (that last form prevents the local Wiki from caching the page; please use that form for large pages!)." => "käytä hakasulkuja ulkoisia linkkejä varten: [URL] tai [URL|linkin_kuvaus] tai [URL|kuvaus|eipuskuria]  (viimeisin muoto estää sivustoa puskuroimasta sivua; käytä sitä kun sivulla on paljon tavaraa!).",
"browse image" => "katso kuva",
"translate" => "käännä",
"Create or edit content" => "Luo tai muuta sisältöä",
"this quiz stats" => "tämän visailut tilasto",
"answer" => "vastaus",
"Edit Translation:" => "Muokkaa Käännöstä:",
"Use this section to set the language of the version you are currently working on." => "Käytä tätä osastoa asettaaksesi kielen versio jota työstät.",
"Set of Translations" => "Käännökset",
"Select the article for which the current article is the translation." => "Valitse artikkeli josta nykyinen artikkeli on käännös.",
"Translation of:" => "Käännetty:",
"Enter the name of the page for which the current page is the translation." => "Kirjoita sivun nimi josta nykyinen sivu on käännös.",
"Add to the Set" => "Lisää sarjaan",
"graph" => "graafi",
"Edit FAQ questions" => "Muokkaa UKK kysymyksiä",
"Edit this file gallery:" => "Muokkaa tätä tiedosto galleriaa:",
"icon" => "kuvake",
"Other users can upload files to this gallery" => "Muut käyttäjät voivat lähettää tiedostoja galleriaan",
"Available File Galleries" => "Saatavilla olevat Tiedosto Galleriat",
"configure forum" => "foorumin kokoonpano",
"start" => "aloita",
"end" => "loppu",
"roles" => "tehtävät",
"Add role" => "Lisää tehtävä",
"active process" => "aktiivinen prosessi",
"invalid" => "toimimaton",
"invalid process" => "toimimaton prosessi",
"valid process" => "toimiva prosessi",
"activities" => "toiminnot",
"aborted" => "keskeytetty",
"value" => "arvo",
"proc" => "pros",
"exceptions" => "poikkeukset",
"rollback" => "taaksekelaus",
"Create or edit content block" => "Luo tai muokkaa sisältö blokkia",
"Listing Gallery" => "Galleria Listaus",
"Gallery Files" => "Gallerian Tiedostot",
"Last ver" => "Viimeisin ver",
"Com" => "Kom",
"Vers" => "Ver",
"To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods</a>." => "Oppiaksesi lisää <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods</a>.",
"subscribe" => "tilaa",
"Sent edition" => "Lähetä esitys",
"Subscribe to newsletter" => "Tilaa uutislehti",
"Add or edit a news server" => "Lisää tai muuta uutispalvelinta",
"rollback to this version" => "takaisin tähän versioon",
"Print Wiki Pages" => "Tulosta Wiki Sivut",
"add page" => "lisää sivu",
"add structure" => "lisää rakenne",
"P" => "Os",
"F" => "Ko",
"entire site" => "koko sivusto",
"click to navigate" => "paina siirtyäksesi",
"Total threads" => "Ketjuja kaikkiaan",
"Average threads per topic" => "Ketjuja keskimäärin per aihe",
"You can include the file in an HTML/Tiki page using" => "Voit lisätä tiedoston HTML/normaali sivulle käyttäen",
"Now enter the file URL" => "Kirjoita tiedoston URL",
" or upload a local file from your disk" => " tai lähetä oma tiedostosi kovalevyltäsi",
"Add or edit folder" => "Lisää tai muokka kansiota",
"Add or edit a URL" => "Lisää tai muokkaa URL:ia",
"received" => "vastaanotettu",
"submitted" => "lähetetty",
"shared" => "jaettu",
"accepted by task user and creator" => "hyväksytty tehtävän tekijän ja luojan puolesta",
"accepted user and creator" => "hyväksytyt käyttäjä ja luoja",
"not accepted by one user" => "yksi käyttäjä ei ole hyväksynyt",
"not accepted user" => "ei hyväksyntää käyttäjä",
"waiting for me" => "odottaa minua",
"waiting for other user" => "odottaa muita käyttäjiä",
"red" => "punainen",
"move into trash" => "siirrä roskikseen",
"waiting / not started" => "odottaa / ei käynnistetty",
"waiting" => "odottaa",
"shared for group" => "jaettu ryhmälle",
"accepted by user" => "hyväksynyt käyttäjä",
"no / rejected" => "ei / hylätty",
"accepted by creator" => "hyväksynyt luojana",
"priority" => "ensisijaisuus",
"select one" => "valitse yksi",
"undo trash" => "peruuta roskis",
"show:" => "näytä:",
"all shared tasks" => "kaikki jaetut tehtävät",
"previous chart" => "edellinen kaavio",
"next chart" => "seuraava kaavio",
"pos" => "paik",
"pre" => "edel",
"permanency" => "pysyvyys",
"avg" => "keskim",
"post new comment" => "lähetä uusi kommentti",
"Post New Comment" => "Lähetä uusi kommentti",
"HTML tags are not allowed inside comments" => "HTML tagit eivät ole sallittuja kommenteissa",
"moderator actions" => "moderaattorin toiminnot",
"move selected topics" => "siirrä valitut aiheet",
"unlock selected topics" => "avaa valitut aiheet",
"lock selected topics" => "lukitse valitut aiheet",
"merge" => "yhdistä",
"merge selected topics" => "yhdistä valitut aiheet",
"reported messages:" => "raportoidut viestit:",
"queued messages:" => "Viestit jonossa:",
"emot" => "tunt",
"Edit fields" => "Muuta kenttiä",
"View item" => "Näytä osa",
"Add a comment" => "Lisää kommentti",
"account" => "tili",
"Projects" => "Projektit",
"Projects configuration" => "Projektien kokoonpano",
"Site Identity features" => "Sivusto Yksilöinti ominaisuus",
"Click here to delete this category" => "Paina tästä poistaaksei tämäm luokan",
"Group doesnt exist" => "Ryhmää ei ole olemassa",
"User doesnt exist" => "Käyttäjää ei ole olemassa",
"Event without Name" => "Nimetön tapahtuma",
"Invalid old password" => "Väärä vanha salasana",
"No channel indicated" => "Ei kanavaa osoitettu",
"No nickname indicated" => "Ei lempinimeä osoitettu",
"No permission to view the page" => "Ei oikeutta katsoa sivua",
"I have refused your friendship request!" => "Olen hylännyt ystävyyspyyntösi!",
"Please create a directory named \$map_path to hold your map files." => "Luo hakemisto nimeltä \$map_path säilyttääksesi karttatiedostoja.",
"Permision denied" => "Lupa evätty",
"A new (and temporary) password and your IP address has been sent " => "Uusi (ja väliaikainen) salasana ja IP osoite on lähetetty ",
"Phillippines" => "Filippiinit",
"sender" => "lähettäjä",
"subject" => "otsake",
"date" => "päiväys",
"flagged" => "merkitty",
"mark" => "merkitse",
"find replied message" => "etsi vastatut viestit",
"Click" => "Paina",
"posted by" => "lähettänyt",
"email this post" => "sähköpostita tämä lähetys",
"Tag name" => "Tagin nimi",
"Anonymous editors must input anti-bot code" => "Tuntemattoman käyttäjän on annettava anti-bot koodi",
"Edit idle timeout" => "Muokkauksen odotusaika loppui",
"Use page description" => "Käytä sivun kuvausta",
"Show page title" => "Näytä sivun otsikko",
"Show page ID" => "Näytä sivu ID",
"Users can lock pages (if perm)" => "Käyttäjä voi lukita sivut (jos lupa)",
"Use WikiWords" => "Käytä WikiSanoja",
"Use Wiki paragraph formatting" => "Käytä sivun kappale muotoilua",
"Use external link icons" => "Käytä ulkoisia linkki iconeja",
"User's Page" => "Käyttäjän Sivu",
"UserPage prefix" => "KäyttäjäSivun etuliite",
"Print Page" => "Tulosta Sivu",
"Maximum number of versions for history" => "Maksimi määrä versio historiaa",
"Never delete versions younger than days" => "Älä poista päivää nuorempia versioita",
"Diff style" => "Erilainen tyyli",
"This will work well (or not!) depending on your theme. To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>" => "Tämä toimii hyvin (tai ei!) riippuen käyttämästäsi teemasta. Oppiaksesi lisää <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>",
"Old vers" => "Vanha vers",
"Add or edit event" => "Lisää tai muuta tapahtumaa",
"merge selected notes into" => "yhdistä valitut huomiot",
"Faq Stats" => "Ukk Tilastot",
"Edit User Files" => "Muokkaa käyttäjä tiedostoja",
"Your message has been queued for approval, the message will be posted after\na moderator approves it." => "Viestisi on laitettu jonoon hyväksyntää varten, viesti lähtetetään kun \na ylläpito hyväksyy sen.",
"Webmail Doc" => "Verkkoposti Doc",
"Webmail Doc template" => "Verkkoposti Doc malli",
"settings" => "asetukset",
"mailbox" => "postilaatikko",
"compose" => "muodosta",
"contacts" => "yhteydet",
"clip" => "pala",
"back to mailbox" => "takaisin postilaatikkoon",
"full headers" => "täydet pääosat",
"normal headers" => "tavalliset pääosat",
"reply all" => "vastaa kaikille",
"forward" => "lähetä edelleen",
"select from address book" => "valitse osoitekirjasta",
"cc" => "kopio",
"item found" => "osa löytynyt",
"items found" => "osaa löytynyt",
"A wildcard pattern of originating pages to be ignored.<br />" => "Jokerimerkki kuvio huomiotta jätettävistä sivuista.<br />",
"The character, by which ignored patterns are separated.<br />" => "Merkki, jolla huomiotta jätettävät kuviot on eroteltu.<br />",
"Whether to include external wikis in the list.<br />" => "Liittääksesi ulkoiset sivut listaan.<br />",
"Collect either originating or wanted pages in a cell and display them in the second column.<br />" => "Kootaan lähtöarvojen tai haluttujen sivujen mukaan kennoon ja näytetään ne toisella palstalla.<br />",
"Switch-on debug output with details about the items.<br />" => "Laita yksityiskohtainen osien debug tulostus päälle.<br />",
"Multiple collected items are separated in distinct table rows, or by comma or line break in one cell.<br />" => "Useat kerätyt osat on eroteltu taulukko riveillä, tai pilkulla tai rivityksellä yhdessä kennossa.<br />",
"Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex.<br />" => "Suodattaa haluttujen sivujen listan näyte sivu_regex:llä tai omalla suotimella. Oletus arvo on sivuston __nykyinen__ sivu_regex.<br />",
"A custom filter for wanted pages to be listed (only used when level=>custom).<br />" => "Oma suodin haluttujen sivujen listaukseen (käytetään vain kun taso on =>muokattu).<br />",
"tiki-admin_dsn tpl" => "tiki-admin_dsn tpl",
"hist" => "hist",
"Text options: 1,size,prepend,append,max with size in chars, prepend will be displayed before the field append will be displayed just after, max is the maximum number of characters that can be saved, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Tekstivaihtoehdot: 1,koko,lisäalkuun,lisäys,maximi merkkien määränä, lisäysalkuun näytetään ensin, lisäys kenttä näytetään heti sen jälkeen, max on maksimi määrä merkkejä jotka voidaan tallentaa, ja merkintä 1 seuraavan kentän tai merkintälaatikon samalle riville. Jos valintasi on 1 se tarkoittaa, että seuraava kenttä on samalla rivillä myös.",
"Checkbox options: put 1 if you need that next field is on the same row." => "Merkintälaatikko valinnat: laita 1 jos tarvitset kentän samalle riville.",
"Numeric options: 1,size,prepend,append with size in chars, prepend will be displayed before the field append will be displayed just after, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Numeeriset valinnat: 1,koko,lisäalkuun,lisäys maximi merkkien määränä, lisäys alkuun näytetään ensin, lisäys kenttä näytetään heti sen jälkeen, ja merkintä 1 tehdäksesi seuraavan kentän tai merkintälaatikon samalle riville. Jos valitaan vain 1 se tarkoittaa, että seuraava kenttä on samalla rivillä myös.",
"Dropdown options: list of items separated with commas." => "Alasveto valinnat: listaus osista eroteltuna pilkulla.",
"Group Selector: use options for automatic field feeding : you can use 1 for group of creation and 2 for group where modification come from. The default group has to be set, or the first group that come is chosen for a user, or the default group is Registered." => "Ryhmä Valitsin: käytä valintoja automaattiseen kenttien täyttöön : valitse 1 luoja ryhmälle ja 2 muokkaaja ryhmälle. Oletus ryhmä on asetettava, tai ryhmä jonka käyttäjä valitsee, tai oletus ryhmä on rekisteröityneet.",
"Action options: Label,post,tiki-index.php,page:fieldname,highlight=test" => "Toiminto vaihtoehdot: Etiketti,postitukset,tiki-index.php,sivu:kenttänimi,korosta=testi",
"Items list options: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere, linkToItems displays the list of displayFieldIdThere from item in tracker trackerId where fieldIdThere matches fieldIdHere. linkToItems 1|0 to create a link to items in view mode and listing" => "Osien listaus vaihtoehdot: kortistoId,kenttäIdSiellä, kenttäIdTäällä, näyttökenttäIdSiellä, linkkiOsiin näyttää listauksen näyttöKenttäIdSiellä osasta kortistoa jonka kortistoId:n kenttäIdSiellä täsmää kenttäIdTäällä. linkkiOsiin 1|0 luodaksesi linkin näytöllä olevan osaan ja listaukseen",
"Email address options: 0|1|2 where 0 puts the address as plain text, 1 does a hex encoded mailto link (more difficult for web spiders to pick it up and spam) and 2 does the normal href mailto." => "Sähköposti Osoitteen vaihtoehdot: 0|1|2 missä 0 on tavallista tekstiä, 1 tekee hex-koodatun linkin osoitteeseen (vaikeampi vakoojille selvittää joten vähemmän roskapostia) ja 2 tekee normaalin href mailto linkin.",
"Formula" => "Kaava",
"No formula specified." => "Ei kaavaa määritelty.",
"Impossible to render the graphic." => "Mahdotonta muodostaa grafiikkaa.",
"View graphic" => "Näytä grafiikka",
"new sites" => "uudet sivustot",
"Message Broadcast" => "Viestilähetys",
"Paramaters" => "Parametrit",
"Are you sure you want to remove this module?" => "Oletko varma, että haluat poistaa tämän moduulin?",
"database queries used" => "tietokanta kyselyjä",
"{\$atts_cnt} files attached" => "{\$atts_cnt} liite tiedostoa",
"pass" => "salasana",
"Page generated in" => "Sivu luotu",
"sent" => "lähetä",
"Homework" => "Kotitehtävä",
"Assignments" => "Liitokset",
"Favorites" => "Mieltymykset",
"Member list" => "Jäsen luettelo",
"Back to Homepage" => "Takaisin etusivulle",
"Edit Summary" => "Muokkaa Yhteenvetoa",
"Minor" => "Pieni",
"RSS Trackers" => "RSS Kortistot",
"Last update from CVS" => "Viimeksi päivitetty CVS:stä",
"Translate in" => "Käännä",
"babelfish it" => "babelfish se",
"Welcome to" => "Tervetuloa",
"Content Features" => "Sisältö Ominaisuudet",
"Contact Us (Anonymous)" => "Ota Yhteyttä (Nimettömänä)",
"Prevent automatic/robot registration" => "Estä automaattinen/robotin rekisteröinti",
"Site Logo" => "Sivusto Logo",
"Admin Groups Template" => "Ylläpidä ryhmä malli",
"Help on Banning System" => "Avusta Poisto Järjestelmässä",
"Admin banning tpl" => "Ylläpidon esto tpl",
"Create/edit Calendars" => "Luo/muokkaa Kalentereita",
"Admin Categories tpl" => "Ylläpidä luokittelujen tpl",
"charts" => "kaaviot",
"Admin Charts Template" => "Ylläpidä kaavion mallia",
"Chat Administration" => "Juttelu Ylläpidolle",
"Chat Admin" => "Puhu Ylläpidolle",
"Chat Admin tpl" => "Puhu Ylläpidolle tpl",
"Create/edit channel" => "Luo/muokkaa kanavaa",
"Half a second" => "Puoli sekuntia",
"second" => "sekunti",
"Chat channels" => "Juttu kanavat",
"Admin Content Templates Template" => "Ylläpidä sisälltö mallin mallia",
"Help on Drawings" => "Auta Piirroksissa",
"Admin DSN" => "Ylläpidä DSN",
"Admin Forums Template" => "Ylläpidä foorumien malli",
"Admin Hotwords Template" => "Ylläpidä kuumasanojen malli",
"Admin Featured Links" => "Ylläpidä ominaisuus linkit",
"Admin Featured Links Template" => "Ylläpidä ominaisuus linkkien malli",
"To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\"> module</a>." => "Käyttääksesi näitä linkkejä, on ominaisuus linkki liitettävä modulina <a class=\"rbox-link\" href=\"tiki-admin_modules.php\"> moduuli</a>.",
"Admin Webmail" => "Ylläpidä Webmail",
"Admin Mailing Template" => "Ylläpidä postitsisään malli",
"Admin Menu Builder" => "Ylläpidä valikon rakentajaa",
"Admin Menus Template" => "Ylläpidä valikko malli",
"Admin Modules Template" => "Ylläpidä moduulien malli",
"Assign Module" => "Liitä moduuli",
"subscribed" => "tilattu",
"Admin Newsletters Template" => "Ylläpidä uutiskirjeen malli",
"Admin Notifications Template" => "Ylläpidon huomautus malli",
"Admin Polls Template" => "Ylläpidä äänestys malli",
"Configure Polls" => "Muokkaa äänestyksiä",
"tiki admin quicktags template" => "sivusto ylläpito pikatagien malli",
"Score System" => "Piste Järjestelmä",
"security admin" => "turvallisuus ylläpito",
"security admin tpl" => "turvallisuus ylläpito tpl",
"Admin Shoutbox Words Template" => "Ylläpidä pikaviesti sanojen malli",
"Edit survey questions" => "Muuta tutkimuksen kysymyksiä",
"administer surveys template" => "ylläpidä tutkimuksen malli",
"system admin" => "järjestelmän ylläpito",
"system admin tpl" => "järjestelmän ylläpito tpl",
"Admin Topics Template" => "Ylläpidä aiheiden malli",
"Admin Tracker" => "Ylläpidä kortistoa",
"Admin Users Template" => "Ylläpidä käyttäjien malli",
"Warning: changing the username will require the user to change his password and will mess with slave intertiki sites that use this one as master" => "Waroitus: nimen muutokseen tarvitaan käyttäjä vaihtamaan salasana ja sekoittaa orja intertiki sivuston joka käyttää tätä isäntänä",
"Warning: changing the username will require the user to change his password" => "Waroitus: jos muutat käyttäjänimen tarvitaan käyttäjä muuttamaan salasana",
"Again" => "Uudelleen",
"Article Types tpl" => "Artikkeli Tyyppien tpl",
"Assign permissions to group" => "Liitä oikeudet ryhmälle",
"Edit Article Tpl" => "Muokkaa artikkeli tpl",
"Browsing Gallery" => "Gallerian Selaus",
"Admin Directory tpl" => "Ylläpidä hakemisto tpl",
"Admin Directory Categories tpl" => "Ylläpidä hakemisto luokittelujen tpl",
"Admin Directory Related" => "Ylläpidä Hakemistoon Liittyvät",
"directory admin related tpl" => "hakemiston ylläpitoon liittyvä tpl",
"Admin Directory Sites" => "Ylläpidä Hakemisto Sivustoja",
"Admin Directory Sites tpl" => "Ylläpidä Hakemisto Sivusto tpl",
"Validate Sites" => "Hyväksy Sivustot",
"directory validate sites tpl" => "hakemisto hyväksy sivustot tpl",
"Edit Article" => "Muokkaa Artikkelia",
"Edit Blog Tpl" => "Muuuta blog tpl",
"Show Plugins Help" => "Näyttää Plugi Avun",
"Show Text Formatting Rules" => "Näyttää tekstin muotoilu säännöt",
"Program dynamic content for block" => "Ohjelmoi muuttuva sisältö blokille",
"Admin quizzes" => "Ylläpidä visailuja",
"Admin Quizzes tpl" => "Ylläpidä visailut tpl",
"Edit Quiz Questions" => "Muokkaa visailun kysymyksiä",
"Edit Quiz Questions Tpl" => "Muokkaa visailun kysymyksiä tpl",
"Help on Articles" => "Auta Artikkeleissa",
"Edit Submissions Tpl" => "Muokkaa ehdotus tpl",
"EditTemplates" => "MuutaMallia",
"EditTemplates tpl" => "MuutaMallia tpl",
"Edit Translations" => "Muokkaa käännöksiä",
"Edit Translations Template" => "Muokkaa käännöksiä malli",
"Message queue for" => "Viesti jono",
"back to forum" => "takaisin foorumille",
"Reported messages for" => "Raportoidut viestit",
"friends tpl" => "ystävät tpl",
"galleries tpl" => "galleriat tpl",
"ImportingPagesPhpWikiPageAdmin" => "TuoSivutPhpWikiSivuYlläpito",
"tiki-import_phpwiki tpl" => "tiki-tuonti_phpwiki tpl",
"List Articles Tpl" => "Listaa artikkelit tpl",
"Admin Cache" => "Ylläpidä puskuri",
"Admin Cache tpl" => "Ylläpidä puskuri tpl",
"Help on Dynamic Content" => "Auta Muuttuvassa Sisällössä",
"List FAQs Tpl" => "Listaa ukk tpl",
"games tpl" => "pelit tpl",
"List Posts Tpl" => "Listaa lähetys tpl",
"List Quizzes Tpl" => "Listaa visailu tpl",
"Edit Quiz Stats Tpl" => "Muokkaa visailu tilastoja tpl",
"List Trackers Tpl" => "Listaa kortistot tpl",
"Admin Live Support tpl" => "Ylläpidä elävä tuki tpl",
"back to admin" => "takaisin ylläpitoon",
"User Calendar" => "Käyttäjä Kalenteri",
"User Calendar Doc tpl" => "Käyttäjä Kalenteri Doc tpl",
"User Calendar Doc" => "Käyttäjä Kalenteri Doc",
"User Calendar Preferences Doc tpl" => "Käyttäjä Kalenteri Kokoonpano Doc tpl",
"my tiki tpl" => "oma sivu tpl",
"Subscribe to This Newsletter" => "Tilaa",
"Stats for quiz" => "Visailun tilasto",
"Received Articles" => "Vastaanotetut Artikkelit",
"received articles tpl" => "vastaanotetut artikkelit tpl",
"Help on Communication Center" => "Auta Yhteistoiminta Keskuksessa",
"received pages tpl" => "vastaanotetut sivut tpl",
"Rename page" => "Nimeä sivu",
"to_version" => "versioon",
"search stats tpl" => "etsintä tilastot tpl",
"Admin Send Objects tpl" => "Ylläpidä lähetä kohteet tpl",
"sheets tpl" => "arkkien tpl",
"Stats for survey" => "Tutkimuksen tilasto",
"system logs" => "järjestelmä logit",
"system logs tpl" => "järjestelmä logit tpl",
"Theme Control Center: categories" => "Teeman Hallinta Keskus: luokittelut",
"ThemeControl" => "TeemaHallinta",
"ThemeControl tpl" => "TeemaHallinta tpl",
"ThemeControl Objects" => "TeemaHallinta Kohteet",
"theme control objects tpl" => "teeman hallinta kohteet tpl",
"Theme Control Center: sections" => "Teeman Hallinta Keskus: osastot",
"theme control sections tpl" => "teeman hallinta osastot tpl",
"File Title" => "Tiedosto Otsikko",
"Image Gallery tpl" => "Kuva Galleria tpl",
"User Assigned Modules" => "Käyttäjän Liittämät Moduulit",
"User Assigned Modules tpl" => "Käyttäjän Liittämät Moduulit tpl",
"User Bookmarks tpl" => "Käyttäjän Kirjanmerkki tpl",
"UserPreferences tpl" => "KäyttäjäKokoonpanot tpl",
"User Tasks tpl" => "Käyttäjä Tehtävät tpl",
"User Watches tpl" => "Käyttäjä Vahdit tpl",
"View FAQ Tpl" => "Näytä ukk tpl",
"Admin Menus tpl" => "Ylläpidä valikoiden tpl",
"IRC log" => "IRC logi",
"Edit mail account" => "Muokkaa postitiliä",
"Add new mail account" => "Lisää uusi postitili",
"User accounts" => "Käyttäjä tilit",
"View All" => "Näytä Kaikki",
"Msg" => "Viesti",
"Can't parse remote HTML page" => "Ei voi jäsentää ulkoista HTML sivua",
"Permission denied you cannot remove pages" => "Oikeutesi eivät riitä poistamaan sivuja",
"Debugger console" => "Debugger console",
"OS" => "OS",
"LDAP Base DN" => "LDAP Base DN",
"LDAP User DN" => "LDAP User DN",
"Geourl" => "Geourl",
"Zoom" => "Zoom",
"SysLog" => "SysLog",
"Cannot write to this file" => "Tähän tiedostoon ei voi kirjoittaa",
"Missing title or body when trying to post a comment" => "Puuttuu joko otsikko tai kuva kommentista",
"\\n for rows" => "\\n riveille",
"Use this thread to discuss the %s page." => "Käytä tätä ketjua keskusteluun %s sivusta.",
"Newsletter subscription information at " => "Tilaustiedot uutislehdestä ",
"Changes" => "Muutokset",
"categorize this object" => "luokittele tämä kohde",
"Your account request have been stored and will be activated by the admin as soon as possible." => "Rekisteröinti pyyntösi on tallennettu ja ylläpito käsittelee ja aktivoi sen mahdollisimman pian.",
"New article post: {\$mail_title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Uuden artikkelin lähettänyt: {\$mail_user} {\$mail_date|tiki_short_datetime} {\$mail_title} ",
"New article post at %s" => "Uuden artikkelin lähettänyt %s",
"Syntax highlighting" => "Syntaksi korostus",
"MyTiki Home" => "OmaSivu perus",
"My Files" => "Omat tiedostot",
"Mini calendar" => "Mini kalenteri",
"FriendsMenu" => "YstäväValikko",
"User list" => "Käyttäjä lista",
"Dump" => "Dumppi",
"Send Pages" => "Lähetä sivut",
"Received pages" => "Vastaanotetut sivut",
"Admin Posts" => "Ylläpidä posteja",
"Submit a New Link" => "Lähetä uusi linkki",
"Browse directory" => "Selaa hakemistoa",
"Admin Directory" => "Ylläpidä hakemistoa",
"Layer Management" => "Tasojen hallinta",
"List quizzes" => "Listaa visailut",
"ShtMenu" => "ShtValikko",
"List trackers" => "Listaa kortistot",
"Ephemerides Admin" => "Lyhytaikaisten Ylläpito",
"Charts Admin" => "Kaavioiden Ylläpito",
"I forgot my pass" => "Olen unohtanut salasanani",
"Click to see the ratings" => "Paina nähdäksesi luokitukset",
"Send trackback pings to:" => "Lähetä viittaustoiminnon pingit:",
"(comma separated list of URIs)" => "(pilkku erottelee listan URI:ja)",
"This is" => "Tämä on",
"by the" => " ",
"Tiki community" => "Tiki yhteisö",
"User identity features" => "Käyttäjän yksilöinti ominaisuudet",
"Use URI as Home Page" => "Käytä URI EtuSivuna",
"Default charset for sending mail:" => "Oletus kirjainasetus postin lähetykseen:",
"Mail end of line:" => "Lähetä lopetus:",
"Disallow access to the site (except for those with permission)" => "Älä salli pääsyä sivustolle (paitsi niiltä joilla on lupa)",
"Message to display when site is closed" => "Näytettävä viesti kun sivusto on suljettu",
"Disallow access when load is above the threshold (except for those with permission)" => "Älä salli palvelimen käyttöä kun kuormituskynnys ylittyy (paitsi niiltä joilla on lupa)",
"Max average server load threshold in the last minute" => "Palvelimen kuormituskynnys on juuri ylittynyt",
"Message to display when server is too busy" => "Viesti joka näytetään, kun palvelin on ylikuormitettu",
"Use cache for external images" => "Käytä puskuria ulkoisille kuville",
"Use gzipped output" => "Käytä pakattua tulostusta",
"output compression is active." => "tulostuksen pakkaus on päällä.",
"compression is handled by" => "pakkauksen käsittelee",
"Sender Email" => "Lähettäjän Sähköposti",
"Allow anonymous users to \"Contact Us\"" => "Sallii nimettömien käyttäjien \"Ottaa Yhteyttä\"",
"contact feature disabled" => "yhteyden otto ominaisuus poistettu",
"Session lifetime in minutes" => "Istunnon elinikä minuutteina",
"Proxy Host" => "Proxy Isäntä",
"Please expect not found help-pages with the default-URL." => "Ei löytynyt avustesivuja oletus URL osoitteella.",
"Any help with the documentation is welcome." => "Kaikki apu ohjeiden tekoon on tervetullutta.",
"Locations separator" => "Sijainnin erottelija",
"User registration and login" => "Käyttäjän rekisteröinti ja kirjautuminen",
"Use WebServer authentication for Tiki" => "Käytä palvelinta varmennukseen",
"... but need admin validation" => "... mutta tarvitsee ylläpidon hyväksynnän",
"Use tracker for more user information" => "Käytä kortistoa muulle käyttäjä tiedoille",
"Use tracker for more group information" => "Käytä kortistoa muulle ryhmä tiedoille",
"Request passcode to register" => "Pyydä passikoodi rekisteröityäksesi",
"Php GD library required" => "Php GD kirjasto tarvitaan",
"Validate users by email" => "Varmista käyttäjät sähköpostilla",
"Remind passwords by email (if \"Store plaintext passwords\" is activated.) Else, Reset passwords by email" => "Muistuta salasanasta sähköpostilla (jos \"Tallenna teksti salasanat\" on aktivoitu.) Muutoin, Lähetä uusi salasana sähköpostilla",
"Store plaintext passwords" => "Varastoi teksti salasanat",
"Reg users can change password" => "Rekisteröitynyt käyttäjä voi vaihtaa salasanaa",
"Reg users can change language" => "Rekisteröityneet käyttäjät voivat vaihtaa kieltä",
"Restrict available languages" => "Rajoita saatavilla olevia kieliä",
"Available languages:" => "Saatavilla olevat kielet:",
"Force to use chars and nums in passwords" => "Pakota käyttämään kirjaimia ja numeroita salasanassa",
"Minimum password length" => "Salasanan minimi pituus",
"Password invalid after days" => "Salasana vanhenee päivien jälkeen",
"Remember me feature" => "Muista minut",
"Remember me name" => "Muista minut nimi",
"Remember me domain" => "Muista minut domain",
"Remember me path" => "Muista minut polku",
"Protect against CSRF with a confirmation step" => "Suojele CSRF varmistus portain",
"Highlight Group" => "Korosta Ryhmä",
"Create user if not in Tiki?" => "Luo käyttäjä jos ei ole?",
"Create user if not in Auth?" => "Luo käyttäjä jos ei Auth?",
"Just use Tiki auth for admin?" => "Käytä vain varmistusta ylläpitäjälle?",
"LDAP URL<br />(if set, this will override the Host and Port below)" => "LDAP URL<br />(jos asetettu, tämä ylikirjoittaa isännän ja portin alhaalta)",
"LDAP Host" => "LDAP Isäntä",
"LDAP Port" => "LDAP Portti",
"LDAP Scope" => "LDAP Kattavuus",
"LDAP User Attribute" => "LDAP Käyttäjä Ominaisuudet",
"LDAP User OC" => "LDAP Käyttäjä OC",
"LDAP Group DN" => "LDAP Ryhmä DN",
"LDAP Group Attribute" => "LDAP Ryhmä Ominaisuudet",
"LDAP Group OC" => "LDAP Ryhmä OC",
"LDAP Member Attribute" => "LDAP Jäsen Ominaisuudet",
"LDAP Member Is DN" => "LDAP Jäsen Is DN",
"LDAP Admin User" => "LDAP Ylläpito Käyttäjä",
"LDAP Admin Pwd" => "LDAP Ylläpito Pwd",
"CAS server hostname" => "CAS palvelimen isäntänimi",
"CAS server port" => "CAS palvelimen portti",
"CAS server path" => "CAS palvelimen polku",
"Change CAS preferences" => "Muuta CAS kokoonpanoa",
"Meta Keywords" => "Meta Avainsanat",
"Meta Description" => "Meta Kuvaus",
"Meta Author" => "Meta Kirjoittaja",
"meta robots" => "meta robotit",
"revisit after" => "uudelleen vieraillut",
"Allow Smileys" => "Salli Hymiöt",
"Hotwords in New Windows" => "Hotwords Uudessa Ikkunassa",
"Trackers attachments preferences" => "Kortisto liitteiden kokoonpanot",
"Trackers attachments" => "Kortistojen liitteet",
"To add/edit wiki pages easily, add the module quick_edit via \"Modules\" on the application menu, or" => "Lisätäksesi/muokataksesi sivuja helposti, lisää moduuli quick_edit \"Moduulit\" ohjelmisto valikosta, tai",
"Create a Tag for the Current Wiki" => "Luo Tagi Nykyiseen sivustoon",
"Restore the Wiki" => "Palauta Sivut",
"restore" => "palauta",
"Remove a Tag" => "Poista Tagi",
"Wiki Comments Settings" => "Kommenttien Asetukset",
"Wiki Administration" => "Ylläpito",
"Wiki Home Page" => "KotiSivu",
"Wiki Discussion" => "Wiki Keskustelut",
"Wiki Link Format" => "Wiki Linkin Muoto",
"Controls recognition of Wiki links using the two parenthesis Wiki link syntax <i>((page name))</i>." => "Hallitsee wiki linkin tunnistusta käyttäen sulkumerkkejä <i>((sivun nimi))</i>.",
"Wiki Page List Configuration" => "Sivusto Listaus Kokoonpano",
"Wiki Features" => "Wiki Ominaisuudet",
"Wiki History" => "Wiki Historia",
"Wiki Watch" => "Wiki Vahti",
"browse the category system" => "selaa luokittelu järjestelmää",
"Admin Charts" => "Ylläpidä kaavioita",
"Add new rule" => "Lisää uusi sääntö",
"EMail notifications" => "Sähköposti ilmoitus",
"Edit this RSS module:" => "Muokkaa tätä RSS moduulia:",
"Create new RSS module" => "Luo uusi RSS moduuli",
"Tikiwiki settings" => "Sivusto asetukset",
"Create/edit questions for survey" => "Luo/muuta tutkimuksen kysymyksiä",
"Active?" => "Aktiivinen?",
"Create Trackers" => "Luo kortistoja",
"Create/Edit Trackers" => "Luo/muokkaa kortistoja",
"tracker name must be unique, field names must be unique \nfor a tracker and they must be valid in SQL" => "kortiston nimen on oltava yksilöllinen, kenttien nimien tulee olla yksilöllisiä \nkortistossa ja niiden käytävä SQL kyselyyn",
"Create item" => "Luo osa",
"Warning: since this tiki site is in slave mode, all user information you enter manually will be automatically overriden by other site's data, including users permissions" => "Waroitus: koska tämä sivusto on orja muodossa, kaikki käsin lisätyt käyttäjätiedot ylikirjoitetaan isäntä sivuston tiedoilla, mukaan lukien käyttäjä oikeudet",
"Assign to Groups" => "Liitä ryhmiä",
"Delete this type" => "Poista tämä tyyppi",
"level configuration" => "taso kokoonpano",
"Browse gallery" => "Selaa galleriaa",
"Upload from disk" => "Lähetä kovalevyltä",
"Directory batch" => "Hakemisto erä",
"Browsing Image" => "Kuvan Selaus",
"Again please" => "Uudelleen, kiitos",
"Admin category relationships" => "Ylläpidä luokan suhteita",
"Validate links" => "Vahvista linkit",
"File with names appended by -{\$user} are modifiable, others are only duplicable and be used as model." => "Tiedoston nimien kanssa lisännyt -{\$user} muokattavissa, muut voivat kopioida tai käyttää mallina.",
"Im- Export Languages" => "Tuo- Vie Kieliä",
"disable" => "poista käytöstä",
"Create a file gallery" => "Luo tiedosto galleria",
"Support tickets" => "Tuki lipuille",
"Return to HomePage" => "Palaa EtuSivulle",
"Stats for this survey Questions " => "Tämän tutkimuksen kysymysten tilasto ",
"Batch upload" => "Joukko lähetys",
"1 suggestion" => "1 ehdotus",
"suggestions" => "ehdotusta",
"fields marked with a * are mandatory" => "kentät jotka on merkitty * ovat pakollisia",
"\$title" => "\$otsikko",
"Minor Edit" => "Pieni",
"The \"Snarf Wikiplugin\" is installed. It can be used by wiki editors to include pages from the local network and via regex replacement create any html." => " \"Snarf plugi\" on asennettu. Sitä voi ylläpito käyttää sisällyttämään sivuja paikallisesta verkosta ja regex korvaukseen mistätahansa html:stä.",
"The \"Regex Wikiplugin\" is installed. It can be used by wiki editors to create any html via regex replacement." => " \"Regex plugi\" on asennettu. Sitä voi ylläpito käyttää minkätahansa html:n regex korvaamiseen.",
"The \"Lsdir Wikiplugin\" is installed. It can be used by wiki editors to view the contents of any directory." => " \"Lsdir plugi\" on asennettu. Sitä voi ylläpito käyttää katsoakseen minkätahansa hakemiston sisältöä",
"The \"Bloglist Wikiplugin\" is installed. It can be used by wiki editors to disclose private blog posts." => " \"Bloglist plugi\" on asennettu. Sitä voi ylläpito käyttää avaamaan yksityis blogin postia.",
"You can not download files" => "Et voi imuroida tiedostoja",
"cannot be found" => "ei löydy",
"Invalid password.  Your current password is required to change administrative information" => "Väärä salasana.  Nykyinen salasanasi tarvitaan muuttaaksesi ylläpidollisa tietoja",
"Please wait 2 minutes between posts" => "Odota 2 minuuttia lähetysten välillä",
"The text in RED is" => "PUNAINEN teksti on",
"Old:" => "Vanha:",
"New:" => "Uusi:",
"Show Categories" => "Näytä luokittelut",
"Hide Categories" => "Piilota luokittelut",
"Wiki page %s changed" => "Sivu %s muuttunut",
"Blog features" => "Blogi ominaisuudet",
"Blog level comments" => "Blogi tason kommentit",
"Post level comments" => "Lähetys tason kommentit",
"Post level trackback pings" => "Lähetys tason viittaustoiminnon pingit",
"Spellchecking" => "Oikeinkirjoitus",
"Default ordering for blog listing" => "Oletus järjestys blogilistalle",
"Blog listing configuration (when listing available blogs)" => "Blogi listauksen asetukset (kun listataan saatavilla olevia blogeja)",
"Last modification time" => "Muokattu viimeksi",
"Blog comments settings" => "Blogi kommenttien asetukset",
"Group calendar sticky popup" => "Ryhmä kalenterin pysyvä popup",
"Group calendar item view tab" => "Ryhmä kalenterin osan näyttö tabi",
"Calendar manual selection of time/date" => "Kalenterin ajan/päiväyksen valinta käsin",
"Show Category Path" => "Näytä Luokan Polku",
"Show Category Objects" => "Näytä Luokan Kohteet",
"Search may show forbidden results. Much better performance though." => "Etsintä voi näyttää kiellettyjä tuloksia. Parempi suorituskyky.",
"CMS features" => "CMS ominaisuudet",
"Use templates" => "Käytä malleja",
"Settings for page articles home" => "Asetukset artikkelien perus sivulle",
"Maximum number of articles in home" => "Artikkeleiden suurin määrä kotona",
"Article comments settings" => "Artikkeli kommenttien asetukset",
"Fields to display on page" => "Sivulla näytettävät kentät",
"Expire Date" => "Poistumis päivä",
"Copyright Management" => "Copyright Hallinta",
"License Page" => "Lisenssi Sivu",
"Submit Notice" => "Toimita Huomautus",
"To add/remove file galleries, go to \"File Galleries\" on the application menu, or" => "Lisätäksesi/poistaaksesi tiedoston galleriasta, mene \"Tiedosto Galleriat\" ohjelmisto valikossa, tai",
"Uploaded filenames cannot match regex" => "Lähetettyjen tiedostojen nimet eivät saa sopia yhteen regex kanssa",
"File galleries comments settings" => "Tiedosto gallerian kommentti asetukset",
"File galleries search indexing" => "Tiedosto gallerioiden etsintä indeksointi",
"Leave command blank to delete handler" => "Jätä kehote tyhjäksi poistaaksesi käsittelijän",
"Use %1 for where internal file name should be substituted (example: \"strings %1\" to convert the document to text using the unix strings command)" => "Käytä %1 jolloin sisäinen tiedostonimi korvataan (esimerkki: \"strings %1\" muuntaa asiakirjan tekstiksi käyttäen unix strings komentoja)",
"Enable auto indexing on file upload or change" => "Valitse auto indeksointi tiedosto lähetyksiin tai muutoksiin",
"System command" => "Järjestelmän komento",
"Home Forum" => "Perus Foorumi",
"Forums features" => "Foorumin ominaisuudet",
"Forum quick jumps" => "Foorumin nopea vaihto",
"Ordering for forums in the forum listing" => "Valitsee foorumit foorumi listalta",
"Forum listing configuration" => "Foorumi listauksen asetukset",
"Show Babelfish Translation URLs" => "Näytä Babelfish käännös URL:it",
"Show Babelfish Translation Logo" => "Näytä Babelfish käännös Logo",
"Show Module Controls" => "Näytä Moduulin hallinta",
"Users can Configure Modules" => "Käyttäjä voi hallita Moduuleja",
"Users can Shade Modules" => "Käyttäjät voivat pienentää Moduulit",
"module decides" => "moduuli valitsee",
"Allow Anonymous Poll Voting" => "Sallii nimettömien äänestää",
"Performance issues" => "Suorituskyky asiat",
"Search features" => "Etsintä ominaisuudet",
"SearchStats" => "EtsintäTilastot",
"Settings for searching content" => "Asetukset sisällön etsintään",
"Search refresh rate" => "Etsinnän päivitys väli",
"this survey stats" => "tämän tutkimuksen tilastot",
"bold" => "lihava",
"italic" => "kallistus",
"underline" => "alleviivaus",
"hr" => "linja",
"Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"./setup.sh\" for example)." => "Apachella on oikeus kirjoittaa hakemistopuuhusi, mikä sallii asennuksen, poiston tai pakettien päivityksen. Kun nuo asennukset on tehty, kannattaa oikeudet palauttaa turvalliseen tilaan (käyttäen \"./setup.sh\" esimerkiksi).",
"To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"./setup.sh open\" to set it up). After installation you need to remove that permission (using \"./setup.sh\")." => "Asentaaksesi, poistaaksesi tai päivittääksesi paketteja sinun on annettava apache käyttäjälle oikeudet kirjoittaa tiedostoja web puuhun (voit käyttää \"./setup.sh open\" komentoa). Asennuksen jälkeen palauta oikeudet (käyttäen \"./setup.sh\").",
"To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>." => "Oppiaksesi lisää <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>.",
"You have {\$unread} unread private messages" => "Sinulla on {\$unread} lukematonta yksityisviestiä",
"unread private messages" => "lukematonta yksityisviestiä",
"chat" => "chat",
"debugger console" => "debugger console",
"(unchanged)" => "(muuttamattomat)",
"Remaining:" => "Jäljellä:",
"This module requires parameters trackerId and name set" => "Tämä moduuli tarvitsee kortistoId:n ja nimen",
"you or someone registered this email address at" => "sinä tai joku muu on rekisteröitynyt tällä sähköpostiosoitteella",
"Your Tiki information registration" => "Sinun tietosi rekisteröintiin",
"Your registration" => "Sinun tietosi rekisteröintiin",
"left/right" => "vasen/oikea",
"Unassign module" => "poista moduuli",
"home" => "koti",
"contact us" => "ota yhteyttä",
"MyMenu" => "OmaValikko",
"User menu" => "Käyttäjä valikko",
"WfMenu" => "WfValikko",
"WikiMenu" => "WikiValikko",
"dump" => "dumppi",
"rankings" => "arvostukset",
"orphan pages" => "yksinäiset sivut",
"sandbox" => "hiekkaloota",
"received pages" => "vastaanotetut sivut",
"structures" => "rakenteet",
"GalMenu" => "GalValikko",
"Articles Home" => "Artikkelien Koti",
"Send articles" => "Lähetä artikkelit",
"Create/Edit Blog" => "Luo/Muokkaa Blogia",
"ForMenu" => "Valikolle",
"DirMenu" => "HakValikko",
"Browse Directory" => "Selaa Hakemistoa",
"FileGalMenu" => "TiedostoGalValikko",
"Admin FAQs" => "Ylläpidä UKK:iä",
"Edit mapfiles" => "Muokkaa karttatiedostoja",
"QuizMenu" => "VisailuValikko",
"Admin quiz" => "Ylläpidä visailua",
"TrkMenu" => "KorValikko",
"Admin trackers" => "Ylläpidä kortistoja",
"SrvMenu" => "PalValikko",
"Send newsletters" => "Lähetä uutislehti",
"Send events" => "Laita tapahtumat",
"Admin events" => "Ylläpidä tapahtumia",
"EphMenu" => "EphValikko",
"Ephemerides" => "Lyhytaikaiset",
"ChartMenu" => "KaavioValikko",
"AdmMenu" => "YllValikko",
"Admin home" => "perus Ylläpito",
"Backups" => "Varmuuskopio",
"Edit languages" => "Muokkaa kieliä",
"External wikis" => "Ulkoiset wikit",
"Mods Admin" => "Modien Ylläpito",
"UsrMenu" => "KäytValikko",
"Click here to manage your personal menu" => "Paina tästä hallitaksesi henkilökohtaista valikkoa",
"Quick edit a Wiki page" => "PikaMuutos sivuun",
"Language: " => "Kieli: ",
"Sort posts by:" => "Lajittele postit:",
"read more" => "lue listää",
"Pass" => "Salasana",
"System Admin" => "Järjestelmän Ylläpito",
"Displays an miniquiz" => "Näyttää minivisailun",
"some text" => "joku teksti",
"Creates a box with the data" => "Luo laatikon tietoineen",
"creates a title bar" => "luo otsikko palkin",
"creates a table" => "luo taulukko",
"makes a horizontal rule" => "tekee vaaka viivan",
"page|desc" => "sivu|kuvaus",
"displays an image" => "näyttää kuvan",
"Non cacheable images" => "Puskuroimattomia kuvia",
"height width desc link and align are optional" => "korkeus leveys kuvaus linkki ja keskitys ovat vaihtoehtoja",
"Wiki File Attachments" => "Tiedosto Liitteet",
"Creates a link to the named file.  If page is not given, the file must be attached to the current page.  If desc is not given, the file name is used for the link text, unless showdesc is used, which makes the file description be used for the link text.  If image=1 is given, the attachment is treated as an image and is displayed directly on the page; no link is generated." => "Luo linkin nimettyyn tiedostoon.  Jos sivua ei anneta, tiedosto on liitettävä nykyiseen sivuun.  Jos kuvausta ei anneta, tiedoston nimeä käytetään linkin tekstissä, kunnes näytäkuvaus käytetään, jolloin kuvausta käytetään liitteen linkkitekstinä.  Jos kuva=1 on annettu, liite toimii kuten kuva ja näytetään suoraan sivulla; linkkiä ei muodosteta.",
"displays rss feed with id=n maximum=m items" => "näyttää rss syötteen id=n maximum=m osaa",
"Will be replaced by the actual value of the dynamic content block with id=n" => "Korvataan arvolla, joka saadaan muuttuva sisältöisestä osasta jolla on id=n",
"\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)" => "\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" tulostaa sisällysluettelon sivusta perustuen rakenteeseen (toc) tai ! pääosiin (maketoc)",
"Misc" => "Sekal",
"latin" => "latin",
"english" => "english",
"Unix" => "Unix",
"Windows" => "Windows",
"PEAR::Auth" => "PEAR::Auth",
"Webmaster" => "Webmaster",
"Ver" => "Ver",
"Int" => "Int",
"inter" => "inter",
"ver:" => "ver:",
"auto" => "auto",
"int" => "int",
"/" => "/",
"eek" => "eek",
"lol" => "lol",
"mr green" => "mr green",
"razz" => "razz",
"santa" => "santa",
"This instance of activity is already complete" => "Tämä esimerkki toiminnon kohde on jo valmis",
"Fatal error: cannot execute automatic activity \$activityId" => "Vakava virhe: ei voi käynnistää automaattista toimintoa \$activityId",
"Fatal error: setting next activity to an unexisting activity" => "Vakava virhe: asetettu seuraava toiminto on olematon",
"Fatal error: nextActivity does not match any candidate in autorouting switch activity" => "Vakava virhe: seuraava toiminto ei täsmää minkään ehdokkaan kanssa",
"Fatal error: non-deterministic decision for autorouting activity" => "Vakava virhe: väärä valinta automaattiseksi toiminteeksi",
"Fatal error: trying to send an instance to an activity but no transition found" => "Vakava virhe: yritys lähettää juttua toimintoon ei onnistu, koska siirtymää ei löydy",
"Cannot add transition only split activities can have more than one outbound transition" => "Ei voi lisätä siirtoa jaettuihin toimintoihin joilla voi olla useampi siirtymä",
"Circular reference found some activity has a transition leading to itself" => "Rengas asetus löydetty toiminto osoittaa itseään",
"Process does not have a start activity" => "Prosessilla ei ole käynnistävää toimintoa",
"Process does not have exactly one end activity" => "Prosessilla ei ole tasan yhtä lopetus toimintoa",
"End activity is not reachable from start activity" => "lopetus toiminto ei ole tavoitettavissa käynnistys toiminnosta",
"is interactive but has no role assigned" => "ei ole aktiivinen, mutta ei ole tehtävää liitettynä",
"is non-interactive and non-autorouted but has no role assigned" => "ei ole vuorovaikutteinen eikä ole tehtävää liitettynä",
"is standalone but has transitions" => "on yksinäinen, mutta sisältää siirtymiä",
"Role" => "Tehtävä",
"is not mapped" => "ei ole kartoitettu",
"Activity '.\$res['name'].' is standalone and is using the \$instance object" => "Toiminto '.\$res['name'].' on yksittäinen käyttäen \$instance object",
"Activity '.\$res['name'].' is interactive so it must use the \$instance->complete() method" => "Toiminto '.\$res['name'].' on vuorovaikutteinen joten on käytettävä \$instance->complete() työtapaa",
"Activity '.\$res['name'].' is non-interactive so it must not use the \$instance->complete() method" => "Toiminto '.\$res['name'].' ei ole vuorovaikutteinen joten ei voi käyttää \$instance->complete() työtapaa",
"Activity '.\$res['name'].' is switch so it must use \$instance->setNextActivity(\$actname) method" => "Toiminto '.\$res['name'].' on kytkin joten on käytettävä \$instance->setNextActivity(\$actname) työtapaa",
"Process %d has been activated" => "Prosessi %d on käynnistetty",
"Process %d has been deactivated" => "Prosessi %d on suljettu",
"Process %s %s imported" => "Prosessi %s %s tuotu",
"Process %s removed" => "Prosessi %s poistettu",
"Process %s has been updated" => "Prosessi %s on päivitetty",
"Process %s has been created" => "Prosessi %s on luotu",
"<return> for rows" => "\\n riveille",
"Any 2 versions" => "Mitkä tahansa 2 versiota",
"Report all errors except notices" => "Raportoi kaikki virheet muttei huomautuksia",
"1 day" => "1 päivän kuluttua",
"1 week" => "1 viikon kuluttua",
"1 month" => "1 kuukauden kuluttua",
"Just Tiki" => "Vain Tiki",
"Tiki and PEAR::Auth" => "Tiki ja PEAR::Auth",
"choose a group ..." => "valitse ryhmä ...",
"%s enabled" => "%s päälle",
"%s disabled" => "%s poispäältä",
"Charts" => "Kaaviot",
"Forums last topics" => "Foorumin viimeiset aiheet",
"An error occured in a database query!" => "Virhe tietokanta kyselyssä!",
"games" => "peleistä",
"Altering database table failed" => "Tietokannan muutos epäonnistui",
"Insert a division block on wiki page" => "Laittaa jaottelun eston sivulle",
"drawing not found" => "piirrosta ei löydy",
"heads and cells separated by ~|~" => "pääosat ja solut erotellaan käyttäen ~|~",
"Please provide an Id" => "Anna Id",
"Quicktags" => "Pikatagit",
"Listing configuration" => "Kokoonpano listaus",
"Perhaps you were looking for:" => "Ehkä etsit:",
"Tiki User Account Activated" => "Käyttäjä Tili Aktivoitu",
"best regards" => "parhain terveisin",
"your Tikiwiki" => "sinun sivustosi",
"Tiki User Registration Request" => "Käyttäjä Rekisteröinti Pyyntö",
"Tiki email notification" => "Sähköposti ilmoitus",
"Someone coming from IP Address" => "Joku osoitteesta IP Osoite",
"Your Tiki account information for %s" => " %s sinun tilitietosi ovat",
"QuickTags" => "PikaLisät",
"TikiWiki Assistant" => "Tikiwiki Avustaja",
"Recently visited pages" => "Äskettäin vieraillut sivut",
"Last `\$module_rows` Sites" => "Viimeksi `\$module_rows` Sivustoja",
"Last Sites" => "Viimeiset Sivustot",
"Directory Stats" => "Hakemisto Tilastot",
"Sites to validate" => "Vahvistettavat sivustot",
"Visited links" => "Vieraillut linkit",
"Top \$module_rows Sites" => "Top \$module_rows Sivustot",
"Top Sites" => "Top Sivustot",
"Top `\$module_rows` topics" => "Top `\$module_rows` aiheet",
"Last `\$module_rows` forum posts" => "Viimeiset `\$module_rows` foorumin lähetykset",
"Last `\$module_rows` forum topics" => "Viimeiset `\$module_rows` foorumin aiheet",
"Last `\$module_rows` actions" => "Viimeiset `\$module_rows` toiminnot",
"Last `\$module_rows` articles" => "Viimeiset `\$module_rows` artikkelit",
"Last articles" => "Viimeiset artikkelit",
"Last `\$module_rows` blog posts" => "Viimeiset `\$module_rows` blogi lähetykset",
"Last `\$module_rows` Created blogs" => "Viimeiset `\$module_rows` Luodut blogit",
"Last `\$module_rows` Created FAQs" => "Viimeiset `\$module_rows` Luodut UKK:t",
"Last `\$module_rows` Created Quizzes" => "Viimeksi `\$module_rows` Luodut Visailut",
"Last `\$module_rows` modified file galleries" => "Viimeksi `\$module_rows` muokatut tiedosto galleriat",
"Last `\$module_rows` Files" => "Viimeiset `\$module_rows` Tiedostot",
"Last `\$module_rows` galleries" => "Viimeiset `\$module_rows` galleriat",
"Last galleries" => "Viimeiset galleriat",
"Last `\$module_rows` Images" => "Viimeiset `\$module_rows` Kuvat",
"Last `\$module_rows` modified events" => "Viimeiset `\$module_rows` muutetut tapahtumat",
"Last `\$module_rows` changes" => "Viimeiset `\$module_rows` muutokset",
"Last `\$module_rows` Modified Items" => "Viimeksi `\$module_rows` Muokatut Osat",
"Last `\$module_rows` Modified blogs" => "Viimeksi `\$module_rows` Muokatut blogit",
"Last `\$module_rows` submissions" => "Viimeiset `\$module_rows` ehdotukset",
"Last `\$module_rows` Modified Comments" => "Viimeiset `\$module_rows` Muutetut Kommentit",
"Last Modified Comments" => "Viimeksi Muutetut Kommentit",
"Last `\$module_rows` Items" => "Viimeiset `\$module_rows` Osat",
"Menu" => "Valikko",
"New Messages" => "Uusia viestejä",
"New Message" => "Uusi viesti",
"Random Images" => "Satunnais Kuvat",
"Top `\$module_rows` articles" => "Top `\$module_rows` artikkelit",
"Top `\$module_rows` File Galleries" => "Top `\$module_rows` Tiedosto Galleriat",
"Top `\$module_rows` files" => "Top `\$module_rows` tiedostot",
"Top `\$module_rows` Forum Posters" => "Top `\$module_rows` Foorumin Lähettäjät",
"Top `\$module_rows` games" => "Top `\$module_rows` pelit",
"Top games" => "Top pelit",
"Top `\$module_rows` galleries" => "Top `\$module_rows` galleriat",
"Top `\$module_rows` Images" => "Top `\$module_rows` Kuvat",
"Top `\$module_rows` Objects" => "Top `\$module_rows` Kohteet",
"Top `\$module_rows` Pages" => "Top `\$module_rows` Sivut",
"Top `\$module_rows` Quizzes" => "Top `\$module_rows` Visailut",
"Most `\$module_rows` visited blogs" => "Most `\$module_rows` vieraillut blogit",
"Top `\$module_rows` Visited FAQs" => "Top `\$module_rows` Vieraillut UKK:t",
"Whats related" => "Mikä on liittyvää",
"Last `\$module_rows` wiki comments" => "Viimeiset `\$module_rows` wiki kommentit",
"on page" => "sivulle",
"show structures" => "näytä rakenteet",
"hide structures" => "piilota rakenteet",
"Creation date" => "Luonti päivä",
"My workflow" => "Oma työvuo",
"Number of columns per page when listing categories" => "Palstojen määrä kun listataan luokkia",
"enable cool sites" => "valitse siistit sivustot",
"Featured Help" => "Ominaisuus Apu",
"JsCalendar" => "JsKalenteri",
"PhpLayers Dynamic menus" => "PhpTasojen Muuttuvat valikot",
"Tiki Sheet" => "Laskenta Taulukko",
"Drawings" => "Piirrokset",
"Games" => "Pelit",
"Administration Features" => "Ylläpidon Ominaisuudet",
"Banning System" => "Esto Järjestelmä",
"User Features" => "Käyttäjä Ominaisuudet",
"Newsreader" => "Uutislukija",
"Workflow" => "Työvuo",
"Workflow engine" => "Työvuo moottori",
"Unknown/Other" => "Tuntematon/Muu",
"(standard)" => "(standardi)",
"(some Unix MTA)" => "(jotkin Unix MTA)",
"Tikiwiki.org help" => "Tikiwiki.org apu",
"Store session data in database" => "Varastoi istunnon tiedot tietokantaan",
"Long date format" => "Pitkä päiväys muoto",
"Short date format" => "Lyhyt päiväys muoto",
"Long time format" => "Pitkä aika muoto",
"Short time format" => "Lyhyt aika muoto",
"New password" => "Uusi salasana",
"Intertiki exchange feature" => "Intertiki keskus ominaisuus",
"HTTP port" => "HTTP portti",
"HTTPS port" => "HTTPS portti",
"PAM service" => "PAM palvelu",
"CAS server version" => "CAS palvelin versio",
"Reg users can change theme" => "Rekisteröityneet käyttäjät voivat vaihtaa teemaa",
"Slideshows theme" => "Kuvaesityksen teema",
"Template Viewing" => "Mallin näyttö",
"Site logo background color" => "Sivusto logo taustaväri",
"Site logo title (on mouse over)" => "Sivusto logo otsikko (kun hiiri päällä)",
"Site Breadcrumbs" => "Sivusto Palat",
"at top of page" => "sivun yläosassa",
"at top of center column" => "sivun yläosassa keskipalstalla",
"entire location" => "koko sijainti",
"page name" => "sivu nimi",
"installed" => "asennettu",
"Default RDF version" => "Oletus RDF versio",
"Editor" => "Muokkaaja",
"hits" => "osumia",
"Individual cache" => "Yksittäinen puskuri",
"Perms inherited from closest parent if possible or from global perms" => "Oikeudet katsotaan lähimmästä isännästä tai yleisistä oikeuksista",
"Assign permissions automatically" => "Anna oikeudet automaattisesti",
"recommended for best performance" => "suositellaan parhaan suorituskyvyn vuoksi",
"image gal" => "kuva gal",
"file gal" => "tied gal",
"Admin chart items" => "Ylläpidä kaavion osia",
"Edit Chart" => "Muuta kaavio",
"Chart items" => "Kaavion osat",
"No items defined yet" => "Ei määritelyjä osia vielä",
"Add or edit a chart" => "Lisää tai muuta kaavio",
"Users can vote for only one item from this chart per period" => "Käyttäjä voi äänestää vain yhtä osaa kaaviosta per aikajakso",
"Prevent users from voting for the same item more than once" => "Estä käyttäjää äänestämästä samaa osaa enemmän kuin kerran",
"Users can suggest new items" => "Käyttäjät voivat ehdottaa uusia osia",
"Auto validate user suggestions" => "Vahvista automaattisesti käyttäjä ehdotukset",
"Ranking shows" => "Arvostus näyttää",
"All items" => "Kaikki osat",
"Top 10 items" => "Top 10 osat",
"Top 20 items" => "Top 20 osat",
"Top 40 items" => "Top 40 osat",
"Top 50 items" => "Top 50 osat",
"Top 100 items" => "Top 100 osat",
"Top 250 items" => "Top 250 osat",
"Voting system" => "Äänestys järjestelmä",
"Vote items" => "Äänestä osia",
"Rank 1..5" => "Arvo 1..5",
"Rank 1..10" => "Arvo 1..10",
"Ranking frequency" => "Arvostus väli",
"Realtime" => "Reaaliaika",
"Each 5 minutes" => "Joka 5 minuutti",
"Show Average" => "Näytä Keskiarvo",
"Show Votes" => "Näytä Äänet",
"Use Cookies for unregistered users" => "Käytä keksejä rekisteröimättömille käyttäjille",
"Users can vote again after" => "Käyttäjä voi äänestää uudelleen kun",
"Anytime" => "Koskavain",
"Ranks" => "Arvostukset",
"No charts defined yet" => "Ei kaaviota määritelty vielä",
"Admin drawings" => "Ylläpidä piirroksia",
"To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link." => "Luodaksesi piirroksen sivulle, käytä {literal}{draw name=foo}{/literal}, missä foo piirroksen nimi. Tallennuksen jälkeen, paina piirroslinkkiä.",
"Available drawings" => "Saatavilla olevat piirrokset",
"no display" => "ei näytettävää",
"Available polls" => "Saatavilla olevat äänestykset",
"Random image from" => "Satunnais kuva",
"Dynamic content blocks" => "Muuttuva sisältöiset palat ",
"phpLayersMenus" => "phpLayersValikko",
"Banner zones" => "Banneri alueet",
"Group users" => "Ryhmitä käyttäjät",
"Admin Quicktags" => "Ylläpidä Pikalisiä",
"Create/Edit QuickTags" => "Luo/muokkaa PikaLisiä",
"Insert (use 'text' for figuring the selection)" => "Lisää (käytä 'teksti' kuvaamaan valintaa)",
"Path to the tag icon" => "Polku lisän kuvakkeeseen",
"Admin RSS Modules" => "Ylläpidä RSS moduuleja",
"This page is to configure settings of RSS feeds read/imported by Tiki. To generate/export RSS feeds, look for \"RSS feeds\" on the admin panel, or" => "Tämä sivu on kokoonpano muutoksiin RSS syötteissä lue/tuo sivustosta. Luodaksesi/viedäksesi RSS syöte, katso \"RSS syötteet\" ylläpito paneelista, tai",
"To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed." => "Käyttääksesi RSS syötettä teksti alueella (Sivu, jne), <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">moduuli</a> tai malli, käytä {literal}{rss id=x}{/literal}, missä x on RSS syötteen ID.",
"show feed title" => "näytä syötteen otsikko",
"show publish date" => "näytä julkaisu päivä",
"Note: You have to import security data via installation process (<a href=\"tiki-install.php\">tiki-install.php</a>). Import the *secdb* update files in your database." => "Huomaa: Sinun on annettava turvallisuus tiedot asennuksen yhteydessä (<a href=\"tiki-install.php\">tiki-install.php</a>). Tuo *secdb* päivittää tiedostot tietokantaan.",
"Templates compiler" => "Mallien muodostaja",
"Compile" => "Muodosta",
"Member of the default group of creator can modify items?" => "Oletus ryhmän jäsen luojana voi muokata osaa?",
"Group Homepage" => "Ryhmä Etusivu",
"Members List" => "Jäsen luettelo",
"Rejected users" => "Poistetut käyttäjät",
"Edit Account Settings" => "Muokkaa tili asetuksia",
"Set the default group of the selected users to" => "Aseta valittujen käyttäjien oletusryhmä->",
"Default Group" => "Oletus Ryhmä",
"Old password" => "Vanha salasana",
"Parent category" => "Isäntä luokka",
"Most visited sub-categories" => "Eniten vieraillut alaluokat",
"Category description" => "Luokan kuvaus",
"Random sub-categories" => "Satunnais alaluokka",
"Allow sites in this category" => "Salli sivustot tässä luokassa",
"Show number of sites in this category" => "Näytä montako sivustoa on tässä luokassa",
"Subcategories" => "Alaluokat",
"Admin related categories" => "Ylläpitoon liittyvät luokat",
"Add a related category" => "Lisää liittyvä luokka",
"Related categories" => "Asiaanliittyvät luokittelut",
"Add a Category" => "Lisää luokka",
"in current category" => "nykyiseen luokkaan",
"Total categories" => "Luokitteluja kaikkiaan",
"creates the editable drawing foo" => "luo muokattavat piirroksen",
"table" => "taulukko",
"table new" => "uusi taulukko",
"external link" => "ulkoinen linkki",
"wiki link'" => "linkki'",
"heading1" => "pääosa1",
"title bar" => "aihe palkki",
"box" => "laatikko",
"rss feed" => "rss syöte",
"dynamic content" => "muuttuva sisältö",
"tagline" => "tagirivi",
"center text" => "keskitä teksti",
"colored text" => "värillinen teksti",
"dynamic variable" => "muuttuva muuttuja",
"New wms Metadata" => "Uusi wms Metadata",
"New Class" => "Uusi Class",
"New Projection" => "Uusi Arvio",
"New Query" => "Uusi Kysely",
"New Scalebar" => "Uusi Muutospalkki",
"New Layer" => "Uusi Taso",
"New Label" => "Uusi Etiketti",
"New Reference" => "Uusi Viittaus",
"New Legend" => "Uusi Seloste",
"New Web" => "Uusi Verkko",
"New Outputformat" => "Uusi Tulostumuoto",
"New Mapfile" => "Uusi Karttatiedosto",
"special chars" => "erikoismerkit",
"special characters" => "erikois merkit",
"Questions per page" => "Kysymyksiä per sivu",
"Activity completed" => "Toiminto valmis",
"Admin process activities" => "Ylläpidä prosessi toimintoja",
"To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>" => "Oppiaksesi lisää <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>",
"Add or edit an activity" => "Lisää tai muokkaa toimintoa",
"activity" => "toiminto",
"split" => "jaa",
"join" => "liity",
"standalone" => "itsenäinen",
"interactive" => "vuorovaikutteinen",
"auto routed" => "autom reititetty",
"Expiration Time" => "PäättymisAika",
"Years" => "Vuotta",
"Months" => "Kuukautta",
"Minutes" => "Minuuttia",
"Add transitions" => "Lisää siirtymä",
"Add transition from:" => "Lisää siirtymä:",
"Add transition to:" => "Lisää siirtymä:",
"No roles associated to this activity" => "Tähän toimintoon ei liity tehtäviä",
"Add Role" => "Lisää tehtävä",
"Add New" => "Lisää uusi",
"Process activities" => "Prosessi toiminnot",
"Routing" => "Reititys",
"Interactive" => "vuorovaikutteinen",
"Automatic" => "Automaattisesti",
"Auto routed" => "Autom reititetty",
"Manual" => "Käsin",
"route" => "reitti",
"(no roles)" => "(ei tehtäviä)",
"No activities defined yet" => "Ei määritelytjä toimintoja vielä",
"Process Transitions" => "Prosessin Siirrot",
"List of transitions" => "Lista siirroista",
"Origin" => "Alkup",
"No transitions defined yet" => "Ei määriteltyjä siirtoja vielä",
"Add a transition" => "Lisää siirto",
"Process Graph" => "Menetelmä Käyrä",
"Galaxia Admin Graph" => "Galaxia Ylläpito Käyrä",
"Galaxia Admin Graph tpl" => "Galaxia Ylläpito Käyrä tpl",
"Edit Tpl" => "Muuta tpl",
"This process is invalid" => "Tämä prosessi ei toimi",
"Process Graph for" => "Menetelmä Käyrä",
"No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed." => "Ei sellaista käyrää saatavilla. Menetelmä sisältää virheitä, käyrää ei luotu vielä, tai <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> ei ole asennettu.",
"List of processes" => "Listaa prosessit",
"Inactive" => "EiAktiivinen",
"val" => "arv",
"Active Process" => "Aktiivinen prosessi",
"Invalid Process" => "Toimimaton prosessi",
"Valid Process" => "Toimiva prosessi",
"Activities" => "Toiminnot",
"New Minor" => "Uusi pieni",
"New Major" => "Uusi iso",
"No processes defined yet" => "Ei määriteltyä prosessia vielä",
"Admin instance" => "Ylläpidä tapauksia",
"Process:" => "Prosessi:",
"Instance" => "Tapaus",
"Workitems" => "Työkohteet",
"exception" => "poikkeus",
"completed" => "valmis",
"Send all to" => "Lähetä kaikille",
"Don't move" => "Älä siirrä",
"Act status" => "Act tila",
"Ended" => "Loppu",
"Not Defined" => "Ei Määritelty",
"Not Interactive" => "Ei Vuorovaikutteinen",
"Not Ended" => "Ei Lopussa",
"Property" => "Ominaisuus",
"Add property" => "Lisää ominaisuus",
"run instance" => "aja pyyntö",
"Executed" => "Käynnistetty",
"erase" => "hävitä",
"Admin processes" => "Ylläpidä prosesseja",
"Galaxia Admin Processes" => "Ylläpidä Galaxia Prosesseja",
"Galaxia Admin Processes tpl" => "Ylläpidä Galaxia Prosessi tpl",
"Add or edit a process" => "Lisää tai muokkaa prosessia",
"Process Name" => "Prosessin Nimi",
"is active?" => "onko aktiivinen?",
"Or upload a process using this form" => "Tai lähetä prosessi käyttäen tätä lomaketta",
"Admin process roles" => "Ylläpidä prosessi tehtäviä",
"Add or edit a role" => "Lisää tai muokkaa tehtävää",
"Process roles" => "Prosessin tehtävät",
"No roles defined yet" => "Ei määriteltyjä tehtäviä vielä",
"Map users to roles" => "Kartoita käyttäjät tehtäviin",
"map" => "kartta",
"Map groups to roles" => "Kartoita ryhmät tehtäviin",
"Operation" => "Toimenpide",
"No roles are defined yet so no roles can be mapped" => "Tehtäviä ei ole määritelty vielä, joten tehtäviä ei voi kartoittaa",
"List of mappings" => "Lista kartoituksista",
"No mappings defined yet" => "Ei kartoituksia määritelty vielä",
"Admin process sources" => "Ylläpidä prosessin lähteitä",
"select source" => "valitse lähde",
"Shared code" => "Jaettu koodi",
"Set next user" => "Aseta seuraava käyttäjä",
"Get property" => "Ota ominaisuus",
"Set property" => "Aseta ominaisuus",
"Process form" => "Prosessi lomake",
"Set Next act" => "Aseta Seuraava toiminto",
"If:SetNextact" => "Jos:AsSeutoim",
"Switch construct" => "Vaihda käsite",
"Map process roles" => "Kartoita prosessin tehtävät",
"Admin Processes" => "Ylläpidä prosesseja",
"Admin Activities" => "Ylläpidä toimintoja",
"Admin Roles" => "Ylläpidä tehtäviä",
"Edit this Process" => "Muuta tätä prosessia",
"Monitor Activities" => "Tarkkaile toimintoja",
"Galaxia Monitor Activities" => "Galaxia Tarkkaile Toimintoja",
"Galaxia Monitor Activities tpl" => "Galaxia Tarkkaile Toiminto tpl",
"List of activities" => "Lista toiminnoista",
"Proc" => "Pros",
"routing" => "reititys",
"Instances" => "Pyyntö",
"run" => "aja",
"run activity" => "aja toiminto",
"Enter the name of this instance" => "Anna pyynnön nimi",
"The name is not valid. Please, enter the name again" => "Nimi ei kelpaa. Anna nimi uudelleen",
"monitor processes" => "tarkkaile prosesseja",
"monitor activities" => "tarkkaile toimintoja",
"monitor instances" => "tarkkaile pyyntöjä",
"monitor workitems" => "tarkkaile työkohteita",
"Monitor Instances" => "Tarkkaile pyyntöjä",
"Galaxia Monitor Instances" => "Galaxia Tarkkaile Pyyntöjä",
"Galaxia Monitor Instances tpl" => "Galaxia Tarkkail Pyyntöjen tpl",
"List of instances" => "Lista pyyntöjä",
"Not ended" => "Ei lopussa",
"No instances created yet" => "Ei pyyntöjä luotu vielä",
"Monitor Processes" => "Tarkkaile prosesseja",
"Galaxia Monitor Processes" => "Galaxia Tarkkaile Prosesseja",
"Galaxia Monitor Processes tpl" => "Galaxia Tarkkaile Prosessien tpl",
"processes" => "prosessit",
"being run" => "on käynnissä",
"Exceptions" => "Poikkeukset",
"Monitor workitems" => "Tarkkaile työkohteita",
"List of workitems" => "Listaa työkohteet",
"instance" => "pyyntä",
"Instance Id" => "Esimerkki Id",
"Instance Name" => "Esimerkki Nimi",
"Instance Status" => "Esimerkin Tila",
"Elapsed time" => "Kulunut aika",
"My activities" => "Omat toiminnot",
"Current Activity" => "Nykyinen Toiminto",
"Assigned To" => "Liitetty",
"exception instance" => "poikkeus pyyntö",
"exceptions instance" => "pyyntö poikkeukset",
"Send Instance" => "Lähetä pyyntö",
"abort instance" => "keskeytä pyyntö",
"grab instance" => "nappaa pyyntö",
"release instance" => "vapauta pyyntö",
"No activities found" => "Ei löydy toimintoja",
"My instances" => "Omat pyynnöt",
"No instances found" => "Ei löydy pyyntöjä",
"User Activities" => "Käyttäjä Toiminnot",
"Galaxia User Activities" => "Galaxia Käyttäjä Toiminnot",
"Galaxia User Activities tpl" => "Galaxia Käyttäjä Toiminnot tpl",
"process" => "prosessi",
"No processes defined or activated yet" => "Prosessia ei ole määritelty tai se ei ole aktiivinen",
"user processes" => "käyttäjä prosessit",
"user activities" => "käyttäjä toiminteet",
"user instances" => "käyttäjä pyynnöt",
"User Instances" => "Käyttäjä pyynnöt",
"Galaxia User Instances" => "Galaxia Käyttäjä Pyynnöt",
"Galaxia User Instances tpl" => "Galaxia Käyttäjä Pyyntö tpl",
"Inst Status" => "Pyynt Tila",
"Not defined" => "Ei määritelty",
"No instances defined yet" => "Ei määriteltyjä pyyntöjä vielä",
"User Processes" => "Käyttäjä prosessit",
"Galaxia User Processes" => "Galaxia Käyttäjä Prosessit",
"Galaxia User Processes tpl" => "Galaxia Käyttäjä Prosessi tpl",
"Browsing Workitem" => "Selataan Työkohteita",
"Workitem information" => "Työkohteen tiedot",
"Use cache for external pages" => "Käytä puskuria ulkoisille sivuille",
"All games are from" => "Kaikki pelit ovat",
"visit the site for more games and fun" => "käy sivustolla, lisää pelejä ja hauskaa",
"Upload a game" => "Lähetä peli",
"Upload a new game" => "Lähetä uusi peli",
"Thumbnail (if the game is foo.swf the thumbnail must be named foo.swf.gif or foo.swf.png or foo.swf.jpg)" => "Minikuva (jos peli on foo.swf minikuva on nimettävä foo.swf.gif tai foo.swf.png tai foo.swf.jpg)",
"Edit game" => "Muokkaa peliä",
"Played" => "Pelattu",
"If you can't see the game then you need a flash plugin for your browser" => "Jos et nää peliä, tarvitset flash-plugin selaimeesi",
"Accepted requests" => "Hyväksytyt pyynnöt",
"since" => "jälkeen",
"Assigned items" => "Liitetyt osat",
"Select news group" => "Valitse uutisryhmä",
"Back to servers" => "Takaisin palvelimelle",
"Msgs" => "Viestit",
"News from" => "Uutisia",
"Back to groups" => "Takaisin ryhmiin",
"Save position" => "Tallenna paikka",
"Reading article from" => "Luetaan artikkeli",
"Back to list of articles" => "Takaisin artikkelien listaukseen",
"Newsgroup" => "Uutisryhmä",
"Configure news servers" => "Muuta uutispalvelimien kokoonpanoa",
"Configure Newsreader" => "Uutislukijan kokoonpano",
"configure newsreader server tpl" => "muokkaa uutislukijan tpl",
"Select a news server to browse" => "Valitse uutispalvelin selattavaksi",
"server" => "palvelin",
"Read the news" => "Lue uutisia",
"News server" => "Uutispalvelin",
"Current permissions for this object" => "Kohteen nykyiset oikeudet",
"No category permissions; global permissions apply" => "Ei luokka oikeuksia; yleiset oikeudet annetaan",
"Preview of version" => "Version esikatselu",
"Source of version" => "Versio Lähde",
"NOTE: Make sure to whitelist this domain to prevent registration emails being canned by your spam filter!" => "HUOMAA: Pidä huoli domain listauksesta estääksesi rekisteröinti viestien menemisen roskapostiin!",
"Replicate" => "Jäljennös",
"Slave" => "Alainen",
"Master" => "Mestari",
"Operations" => "Toimenpiteet",
"Operations Log" => "Toimenpiteiden Logi",
"Tiki Shoutbox" => "Pikaviestitn",
"Click to Navigate" => "Paina siirtyäksesi",
"Focus:" => "Keskitys:",
"big grin" => "iso hymy",
"cry" => "itku",
"evil" => "paha",
"redface" => "punakka",
"rolleyes" => "silmitys",
"smile" => "hymy",
"surprised" => "yllättynyt",
"twisted" => "kierto",
"arrow" => "nuoli",
"Note: Maximum image size is limited to" => "Huomaa: Suurin mahdollinen kuvankoko on",
"Current folder" => "Nykyinen kansio",
"This user is your friend" => "Tämä käyttäjä on ystävä",
"Your personal Wiki Page" => "Henkilökohtainen Sivusi",
"Your personal tracker information" => "Henkilökohtaiset kortistotiedot",
"Confirm new password" => "Toista uusi salasana",
"Current password (required)" => "Nykyinen salasana (pakollinen)",
"Edit Items" => "Muokkaa osia",
"List Charts" => "Listaa kaaviot",
"Last Chart" => "Viimeisin kaavio",
"Previous Chart" => "Edellinen kaavio",
"Chart created" => "Kaavio luotu",
"Next Chart" => "Seuraava kaavio",
"Permanency" => "Pysyvä",
"chg" => "muuta",
"Avg" => "Keskim",
"info/vote" => "tieto/ääni",
"Next chart will be generated on" => "Seuraava kaavio muodostetaan",
"View or vote items not listed in the chart" => "Katso tai äänestä osia joita ei ole kaaviossa",
"Select something to vote on" => "Valitse jotakin äänestettävää",
"Item information" => "Osan tiedot",
"Dif" => "Erot",
"Best Position" => "Paras Sijainti",
"Vote this item" => "Äänestä tätä osaa",
"Highest" => "Korkein",
"Number of voices" => "Ääniä kaikkiaan",
"RSS settings" => "RSS asetukset",
"No chart indicated" => "Ei kaaviota osoitettu",
"No category indicated" => "Ei luokkaa osoitettu",
"Permission denied; you cannot assign permissions for this category" => "Lupa evätty; et voi antaa oikeuksia tälle luokalle",
"Last sites of directory \".\$rc[\"name\"].\" ." => "Viimeiset sivustot hakemistossa \".\$rc[\"nimi\"].\" .",
"No process indicated" => "Ei prosessia osoitettu",
"Role name cannot be empty" => "Tehtävä nimi ei voi olla tyhjä",
"Activity name cannot be empty" => "Toiminnon nimi ei voi olla tyhjä",
"Activity name already exists" => "Toiminto tällä nimellä on olemassa",
"indicates if the process is active. Invalid processes cant be active" => "osoittaa, että menetelmä toimii, väärä menetelmä ei voi toimia",
"No instance indicated" => "Ei pyyntöä osoitettu",
"No activity indicated" => "Ei toimintoa osoitettu",
"The process name already exists" => "Prosessi tällä nimellä on olemassa",
"Process already exists" => "Prosessi on jo olemassa",
"You cant execute this activity" => "Et voi käynnistää toimintoa",
"You couldn't abort a instance" => "Et voi keskeyttää pyyntöä",
"You couldn't exception a instance" => "Et voi tehdä poikkeusta pyyntöön",
"No title indicated" => "Ei otsikkoa osoitettu",
"No comment indicated" => "Ei kommenttia osoitettu",
"No date indicated" => "Ei päiväystä osoitettu",
"The game file must have .swf or .dcr extension" => "Peli tiedostolla on oltava .swf tai .dcr pääte",
"The thumbnail name must be" => "Minikuvan nimi on oltava",
"Please supply both files" => "Lähetä molemmat tiedostot",
"No server indicated" => "Ei palvelinta osoitettu",
"Cannot connect to" => "Ei voi yhdistää",
"Missing information to read news (server,port,username,password,group) required" => "Tietoja puuttuu lukeaksesi uutisia (palvelin,portti,käyttäjänimi,salasana,ryhmä) tarvitaan",
"Cannot get messages" => "Viestejä ei saatu",
"A password and your IP address reminder email has been sent " => "Salasana ja IP osoite muistutus on lähetetty ",
"changed '%s' from '%s' to '%s'" => "vaihdettu '%s' '%s':sta '%s':oon",
"Tiki Logo" => "Tiki Logo",
"Tiki Calendar" => "Kalenteri",
"Admin Menu" => "Ylläpito Valikko",
"RSS Modules" => "RSS moduulit",
"Chat" => "Juttele",
"Import PHPWiki Dump" => "Tuo PHPWiki Dumppi",
"Last `\$module_rows` visitors" => "Viimeiset `\$module_rows` vierailijat",
"User informations" => "Käyttäjän tiedot",
"Group informations" => "Ryhmän tiedot",
"Email This Post" => "sähköpostita tämä lähetys",
"RSS feeds" => "RSS syötteet",
"Use titles in blog posts" => "Käytä otsikoita blogi lähetyksissä",
"Send blog post" => "Lähetä blogi lähetys",
"A link to this post was sent to the following addresses:" => "Linkki tähän lähetykseen on lähetetty osoitteeseen:",
"Send post to this addresses" => "Lähetä posti näihin osoitteisiin",
"List of email addresses separated by commas" => "Sähköposti osoitteiden lista eroteltuna pilkuilla",
"Compose Message" => "Muodosta viesti",
"If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>" => "Jos haluatte, että teille vastataan, teidän on merkittävä <a href='tiki-user_preferences.php'>Salli viestit muilta käyttäjiltä</a>",
"%s <b>%s</b> successfully deleted." => "%s <b>%s</b> on onnistuneesti poistettu.",
"%s <b>%s</b> assigned to %s <b>%s</b>." => "%s <b>%s</b> liitetty %s <b>%s</b>.",
"%s <b>%s</b> removed from %s <b>%s</b>." => "%s <b>%s</b> poistettu %s <b>%s</b>.",
"group <b>%s</b> set as the default group of user <b>%s</b>." => "ryhmä <b>%s</b> on asetettu oletusryhmäksi käyttäjälle <b>%s</b>.",
"Post recommendation at" => "Lähetä suositus",
"Prevent flooding" => "Estä vuoto",
"Minimum time between posts" => "Minimi aika lähetysten välillä",
"Moderator user" => "Esimies käyttäjä",
"Moderator group" => "Esimies ryhmä",
"Send this forums posts to this email" => "Lähetä tämän foorumin lähetykset tähän sähköpostiosoitteeseen",
"Prune unreplied messages after" => "Poista vastaamattomat viestit kun täyttyy",
"Prune old messages after" => "Poista vanhat viestit kun täyttyy",
"POP3 server" => "POP3 palvelin",
"Max attachment size (bytes)" => "Liitteen suurin koko (bytes)",
"Default ordering for topics" => "Aiheiden oletus järjestys",
"Topics per page" => "Aihetta per sivu",
"Default ordering for threads" => "Oletus järjestys ketjuille",
"Includes" => "Sisältää",
"Assign Perms to this Group" => "Anna oikeudet tälle ryhmälle",
"Assign permissions to category" => "Anna oikeudet luokalle",
"Current permissions for this category" => "Luokan nykyiset oikeudet",
"Remove from this Category Only" => "Poista vain tästä luokasta",
"Remove from this Category &amp; all its Children" => "Poista tästä luokasta &amp; ja kaikki alaluokat",
"Assign permissions" => "Liitä oikeudet",
"to group" => "ryhmälle",
"this category &amp; all its children" => "tämä luokka &amp; ja kaikki alaluokat",
"this category only" => "vain tämä luokka",
"Assigning permissions for <b>all children</b> is recommended for best performance." => "Anna oikeudet <b>kaikille alaluokille</b> paras tehokkuus.",
"ERROR: you must include a subject or a message at least" => "VIRHE: otsikko on oltava tai viesti vähintään",
"Your registration code:" => "Rekisteröinti koodisi:",
"Registration code" => "Rekisteröinti koodi",
// ### end of unused words

// ### start of untranslated words
// ### uncomment value pairs as you translate
// "For you to vote, cookies must be allowed" => "For you to vote, cookies must be allowed",
// "This forum is flat and doesn't allow replies to other replies" => "This forum is flat and doesn't allow replies to other replies",
// "Copyright management" => "Copyright management",
// "Tiki was unable to retrieve login data from the database " => "Tiki was unable to retrieve login data from the database ",
// "The following error message was returned" => "The following error message was returned",
// "Things to check" => "Things to check",
// "Are your database login credentials correct" => "Are your database login credentials correct",
// "Did you complete the <a href='tiki-install.php' >Tiki Installer" => "Did you complete the <a href='tiki-install.php' >Tiki Installer",
// "Please see <a href=\"http://doc.tikiwiki.org/\">the documentation</a> for more information" => "Please see <a href=\"http://doc.tikiwiki.org/\">the documentation</a> for more information",
// "Uploaded" => "Uploaded",
// "Explorer" => "Explorer",
// "Slideshow" => "Slideshow",
// "Default View" => "Default View",
// "Afghanistan" => "Afghanistan",
// "Aland Islands" => "Aland Islands",
// "Albania" => "Albania",
// "Andorra" => "Andorra",
// "Anguilla" => "Anguilla",
// "Aruba" => "Aruba",
// "Azerbaijan" => "Azerbaijan",
// "Belize" => "Belize",
// "Benin" => "Benin",
// "Bhutan" => "Bhutan",
// "Bosnia and Herzegovina" => "Bosnia and Herzegovina",
// "Botswana" => "Botswana",
// "Bouvet Island" => "Bouvet Island",
// "British Indian Ocean Territory" => "British Indian Ocean Territory",
// "British Virgin Islands" => "British Virgin Islands",
// "Burkina Faso" => "Burkina Faso",
// "Burundi" => "Burundi",
// "Cambodia" => "Cambodia",
// "Cameroon" => "Cameroon",
// "Cape Verde" => "Cape Verde",
// "Central African Republic" => "Central African Republic",
// "Chad" => "Chad",
// "Christmas Island" => "Christmas Island",
// "Cocos Islands" => "Cocos Islands",
// "Comoros" => "Comoros",
// "Congo" => "Congo",
// "Congo Democratic" => "Congo Democratic",
// "Djibouti" => "Djibouti",
// "Dominica" => "Dominica",
// "Equatorial Guinea" => "Equatorial Guinea",
// "Eritrea" => "Eritrea",
// "Ethiopia" => "Ethiopia",
// "Europe" => "Europe",
// "Falkland Islands" => "Falkland Islands",
// "Faroe Islands" => "Faroe Islands",
// "French Guiana" => "French Guiana",
// "French Southern Territories" => "French Southern Territories",
// "Gabon" => "Gabon",
// "Gambia" => "Gambia",
// "Georgia" => "Georgia",
// "Ghana" => "Ghana",
// "Gibraltar" => "Gibraltar",
// "Greenland" => "Greenland",
// "Grenada" => "Grenada",
// "Guadeloupe" => "Guadeloupe",
// "Guernsey" => "Guernsey",
// "Guinea" => "Guinea",
// "Guinea Bissau" => "Guinea Bissau",
// "Guyana" => "Guyana",
// "Heard Island and McDonald Islands" => "Heard Island and McDonald Islands",
// "Hong Kong" => "Hong Kong",
// "Isle of Man" => "Isle of Man",
// "Jersey" => "Jersey",
// "Kyrgyzstan" => "Kyrgyzstan",
// "Laos" => "Laos",
// "Lesotho" => "Lesotho",
// "Liberia" => "Liberia",
// "Libya" => "Libya",
// "Liechtenstein" => "Liechtenstein",
// "Macao" => "Macao",
// "Macedonia" => "Macedonia",
// "Madagascar" => "Madagascar",
// "Maldives" => "Maldives",
// "Mali" => "Mali",
// "Martinique" => "Martinique",
// "Mauritania" => "Mauritania",
// "Mayotte" => "Mayotte",
// "Moldova" => "Moldova",
// "Monaco" => "Monaco",
// "Mongolia" => "Mongolia",
// "Montenegro" => "Montenegro",
// "Montserrat" => "Montserrat",
// "Myanmar" => "Myanmar",
// "Namibia" => "Namibia",
// "Netherlands Antilles" => "Netherlands Antilles",
// "Niger" => "Niger",
// "Norfolk Island" => "Norfolk Island",
// "Northern Mariana Islands" => "Northern Mariana Islands",
// "North Korea" => "North Korea",
// "Oman" => "Oman",
// "Palau" => "Palau",
// "Palestine" => "Palestine",
// "Philippines" => "Philippines",
// "Pitcairn" => "Pitcairn",
// "Republic of Macedonia" => "Republic of Macedonia",
// "Reunion" => "Reunion",
// "Rwanda" => "Rwanda",
// "Saint Helena" => "Saint Helena",
// "Saint Kitts and Nevis" => "Saint Kitts and Nevis",
// "Saint Lucia" => "Saint Lucia",
// "Saint Pierre and Miquelon" => "Saint Pierre and Miquelon",
// "San Marino" => "San Marino",
// "Sao Tome and Principe" => "Sao Tome and Principe",
// "Senegal" => "Senegal",
// "Serbia" => "Serbia",
// "Seychelles" => "Seychelles",
// "Sierra Leone" => "Sierra Leone",
// "South Georgia and South Sandwich Islands" => "South Georgia and South Sandwich Islands",
// "Sudan" => "Sudan",
// "Svalbard and Jan Mayen" => "Svalbard and Jan Mayen",
// "Swaziland" => "Swaziland",
// "Syria" => "Syria",
// "Tajikistan" => "Tajikistan",
// "Tanzania" => "Tanzania",
// "Timor-Leste" => "Timor-Leste",
// "Togo" => "Togo",
// "Tokelau" => "Tokelau",
// "Tunisia" => "Tunisia",
// "Turkmenistan" => "Turkmenistan",
// "Turks and Caicos Islands" => "Turks and Caicos Islands",
// "Uganda" => "Uganda",
// "United Nations Organization" => "United Nations Organization",
// "United States Minor Outlying Islands" => "United States Minor Outlying Islands",
// "US Virgin Islands" => "US Virgin Islands",
// "Uzbekistan" => "Uzbekistan",
// "Vatican" => "Vatican",
// "Viet Nam" => "Viet Nam",
// "Wallis and Futuna" => "Wallis and Futuna",
// "Western Sahara" => "Western Sahara",
// "World" => "World",
// "Yemen" => "Yemen",
// "MySQL Improved (mysqli). Requires MySQL 4.1+" => "MySQL Improved (mysqli). Requires MySQL 4.1+",
// "MySQL classic (mysql)" => "MySQL classic (mysql)",
// "PostgreSQL" => "PostgreSQL",
// "Email address not valid, test mail not sent" => "Email address not valid, test mail not sent",
// "Email address empty and \"copy\" checkbox not set, test mail not sent" => "Email address empty and \"copy\" checkbox not set, test mail not sent",
// "Test mail from Tiki installer " => "Test mail from Tiki installer ",
// "Tiki version" => "Tiki version",
// "PHP version" => "PHP version",
// "Server" => "Server",
// "Congratulations!\n\nYour server can send emails.\n\n" => "Congratulations!\n\nYour server can send emails.\n\n",
// "Slovene" => "Slovene",
// "Farsi" => "Farsi",
// "Fijian" => "Fijian",
// "Galician" => "Galician",
// "Template %s not registered" => "Template %s not registered",
// "Error line: %d" => "Error line: %d",
// "All Day" => "All Day",
// "(not registered)" => "(not registered)",
// "Please wait %d seconds between posts" => "Please wait %d seconds between posts",
// "A contribution is mandatory" => "A contribution is mandatory",
// "Invalid Email" => "Invalid Email",
// "Your message has been queued for approval and will be posted after a moderator approves it" => "Your message has been queued for approval and will be posted after a moderator approves it",
// "This forum is locked" => "This forum is locked",
// "This thread is locked" => "This thread is locked",
// "Those comments are locked" => "Those comments are locked",
// "Newsletter subscription information at" => "Newsletter subscription information at",
// "Tiki Link - Insert internal link" => "Tiki Link - Insert internal link",
// "Select a Wiki page to link to" => "Select a Wiki page to link to",
// "Cannot open this file" => "Cannot open this file",
// "The global quota has been reached" => "The global quota has been reached",
// "The quota has been reached in" => "The quota has been reached in",
// "File gallery quota exceeded" => "File gallery quota exceeded",
// "Number of files transfered to the database" => "Number of files transfered to the database",
// "Number of files transfered to the file system" => "Number of files transfered to the file system",
// "Cannot read to this file" => "Cannot read to this file",
// "This is an approximation based on your server memory limit" => "This is an approximation based on your server memory limit",
// "This is the value of your server's PHP '%s' setting" => "This is the value of your server's PHP '%s' setting",
// "You are alerted by the server " => "You are alerted by the server ",
// "You can check the modifications at : " => "You can check the modifications at : ",
// "You are alerted of a change on " => "You are alerted of a change on ",
// "unknown destination directory. Please set it up in <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>" => "unknown destination directory. Please set it up in <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>",
// "unlink failed" => "unlink failed",
// "The uploaded file exceeds the upload_max_filesize directive in php.ini" => "The uploaded file exceeds the upload_max_filesize directive in php.ini",
// "The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form" => "The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form",
// "The uploaded file was only partially uploaded. Please try again" => "The uploaded file was only partially uploaded. Please try again",
// "No file was uploaded" => "No file was uploaded",
// "Missing a temporary folder" => "Missing a temporary folder",
// "Failed to write file to disk" => "Failed to write file to disk",
// "File upload stopped by extension" => "File upload stopped by extension",
// "Invalid file mime type" => "Invalid file mime type",
// "XML file does not validate against the Mediawiki XML schema" => "XML file does not validate against the Mediawiki XML schema",
// "Contributions" => "Contributions",
// "Query point" => "Query point",
// "layer" => "layer",
// "Record" => "Record",
// "You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it" => "You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it",
// "menu" => "menu",
// "The content retrieved at %s is not a list of mods" => "The content retrieved at %s is not a list of mods",
// "Can't chdir to '%s'" => "Can't chdir to '%s'",
// "%s impossible to remove" => "%s impossible to remove",
// "Description not available" => "Description not available",
// "Module Title" => "Module Title",
// "Title to display at the top of the box" => "Title to display at the top of the box",
// "No box" => "No box",
// "Show only the content" => "Show only the content",
// "Decorations" => "Decorations",
// "Show module decorations" => "Show module decorations",
// "No title" => "No title",
// "Show module title" => "Show module title",
// "Perspective" => "Perspective",
// "Only display the module if in one of the listed perspectives. Semi-colon separated" => "Only display the module if in one of the listed perspectives. Semi-colon separated",
// "Module only applicable for the specified languages. Languages are defined as two character language codes. Multiple values can be separated by semi-colons" => "Module only applicable for the specified languages. Languages are defined as two character language codes. Multiple values can be separated by semi-colons",
// "Module only applicable for the specified sections. Multiple values can be separated by semi-colons" => "Module only applicable for the specified sections. Multiple values can be separated by semi-colons",
// "Page filter" => "Page filter",
// "Module only applicable on the specified page names. Multiple values can be separated by semi-colons" => "Module only applicable on the specified page names. Multiple values can be separated by semi-colons",
// "No Page" => "No Page",
// "Module not applicable on the specified page names. Multiple values can be separated by semi-colons" => "Module not applicable on the specified page names. Multiple values can be separated by semi-colons",
// "Module enabled or disabled depending on the theme. Specified themes can be either included or excluded. Theme names prefixed by \\\"!\\\" are in the exclusion list. Multiple values can be separated by semi-colons" => "Module enabled or disabled depending on the theme. Specified themes can be either included or excluded. Theme names prefixed by \\\"!\\\" are in the exclusion list. Multiple values can be separated by semi-colons",
// "Module only available based on the relationship of the user with the wiki page. Either only creators (y) or only non-creators (n) will see the module" => "Module only available based on the relationship of the user with the wiki page. Either only creators (y) or only non-creators (n) will see the module",
// "Contributor" => "Contributor",
// "Module only available based on the relationship of the user with the wiki page. Either only contributors (y) or only non-contributors (n) will see the module" => "Module only available based on the relationship of the user with the wiki page. Either only contributors (y) or only non-contributors (n) will see the module",
// "Flip" => "Flip",
// "Users can shade module" => "Users can shade module",
// "No numbers" => "No numbers",
// "If set to \"y\", the module will not number list items" => "If set to \"y\", the module will not number list items",
// "Number of rows, or items, to display" => "Number of rows, or items, to display",
// "Default: 10" => "Default: 10",
// "section edit" => "section edit",
// "Users accept internal messages by default" => "Users accept internal messages by default",
// "Users can opt-out internal messages" => "Users can opt-out internal messages",
// "Title length" => "Title length",
// "Publication date" => "Publication date",
// "Expiration date" => "Expiration date",
// "Default number per page" => "Default number per page",
// "Default Ordering" => "Default Ordering",
// "Default article image width" => "Default article image width",
// "0 for original image size" => "0 for original image size",
// "Default article image height" => "Default article image height",
// "Multiple authentication backends are supported by Tikiwiki. The default value is to use the internal user database" => "Multiple authentication backends are supported by Tikiwiki. The default value is to use the internal user database",
// "Tiki" => "Tiki",
// "Tiki and OpenID" => "Tiki and OpenID",
// "Tiki and LDAP" => "Tiki and LDAP",
// "Shibboleth" => "Shibboleth",
// "Available languages" => "Available languages",
// "By default, all languages supported by tikiwiki are available on multilingual sites. This option allows to limit the languages to a subset" => "By default, all languages supported by tikiwiki are available on multilingual sites. This option allows to limit the languages to a subset",
// "Blogues" => "Blogues",
// "Categories used in templates (TPL)" => "Categories used in templates (TPL)",
// "Exclude these categories" => "Exclude these categories",
// "Users can change site language" => "Users can change site language",
// "Allow users to change the language of the menus and labels" => "Allow users to change the language of the menus and labels",
// "Spell checking" => "Spell checking",
// "Allow anonymous visitors to use the \"Contact Us\" feature" => "Allow anonymous visitors to use the \"Contact Us\" feature",
// "Default charset for sending mail" => "Default charset for sending mail",
// "utf-8" => "utf-8",
// "iso-8859-1" => "iso-8859-1",
// "Article RSS Description" => "Article RSS Description",
// "Description to be published as part of the RSS feed for articles" => "Description to be published as part of the RSS feed for articles",
// "Show Country Flag" => "Show Country Flag",
// "Show the country flag" => "Show the country flag",
// "Enable cool sites" => "Enable cool sites",
// "'),\n\t\t\t'type' => 'flag" => "'),\n\t\t\t'type' => 'flag",
// "Number of columns per page when listing directory categories" => "Number of columns per page when listing directory categories",
// "6" => "6",
// "'),\n\t\t\t'type' => 'text" => "'),\n\t\t\t'type' => 'text",
// "Method to Open Directory Links" => "Method to Open Directory Links",
// "PHP errors visible to admin only" => "PHP errors visible to admin only",
// "For development purposes, it\\'s better to display errors for all users. However, in production settings, they should only be displayed to administrators" => "For development purposes, it\\'s better to display errors for all users. However, in production settings, they should only be displayed to administrators",
// "PHP Error reporting level" => "PHP Error reporting level",
// "Level from which errors should be reported" => "Level from which errors should be reported",
// "Report all PHP errors except strict" => "Report all PHP errors except strict",
// "Report all PHP errors except notices" => "Report all PHP errors except notices",
// "Question and Answer prefix on Answers" => "Question and Answer prefix on Answers",
// "Q and A" => "Q and A",
// "Question ID" => "Question ID",
// "Faqs" => "Faqs",
// "Collaboratively authored documents with history of changes" => "Collaboratively authored documents with history of changes",
// "Online diaries or journals" => "Online diaries or journals",
// "Collections of graphic images for viewing or downloading (photo album)" => "Collections of graphic images for viewing or downloading (photo album)",
// "Machine Translation (by Google Translate)" => "Machine Translation (by Google Translate)",
// "Uses Google Translate to translate the content of wiki pages to other languages" => "Uses Google Translate to translate the content of wiki pages to other languages",
// "Experimental. This feature is still under development" => "Experimental. This feature is still under development",
// "Database & form generator" => "Database & form generator",
// "Online discussions on a variety of topics. Threaded or flat" => "Online discussions on a variety of topics. Threaded or flat",
// "Computer files, videos or software for downloading. With check-in & check-out (lock)" => "Computer files, videos or software for downloading. With check-in & check-out (lock)",
// "Articles can be used for date-specific news and announcements. You can configure articles to automatically publish and expire at specific times or to require that submissions be approved before becoming \"live.\"" => "Articles can be used for date-specific news and announcements. You can configure articles to automatically publish and expire at specific times or to require that submissions be approved before becoming \"live.\"",
// "Brief list of votable options; appears in module (left or right column)" => "Brief list of votable options; appears in module (left or right column)",
// "Content mailed to registered users" => "Content mailed to registered users",
// "Events calendar with public, private and group channels" => "Events calendar with public, private and group channels",
// "Insert, track, and manage advertising banners" => "Insert, track, and manage advertising banners",
// "Global category system. Items of different types (wiki pages, articles, tracker items, etc) can be added to one or many categories. Categories can have permissions" => "Global category system. Items of different types (wiki pages, articles, tracker items, etc) can be added to one or many categories. Categories can have permissions",
// "Score is a game to motivate participants to increase their contribution by comparing to other users" => "Score is a game to motivate participants to increase their contribution by comparing to other users",
// "Enables searching for content on the website" => "Enables searching for content on the website",
// "Freetags" => "Freetags",
// "Allows to set tags on pages and various objects within the website and generate tag cloud navigation patterns" => "Allows to set tags on pages and various objects within the website and generate tag cloud navigation patterns",
// "Action Log" => "Action Log",
// "Allows to keep track of what users are doing and produce reports on a per-user or per-category basis" => "Allows to keep track of what users are doing and produce reports on a per-user or per-category basis",
// "Contribution" => "Contribution",
// "Allows users to specify the type of contribution they are making while editing objects. The contributions are then displayed as color-coded in history and other reports" => "Allows users to specify the type of contribution they are making while editing objects. The contributions are then displayed as color-coded in history and other reports",
// "Enables internationalization features and multilingual support for then entire site" => "Enables internationalization features and multilingual support for then entire site",
// "Frequently asked questions and answers" => "Frequently asked questions and answers",
// "Questionnaire with multiple choice or open ended question" => "Questionnaire with multiple choice or open ended question",
// "User-submitted Web links" => "User-submitted Web links",
// "Quizzes " => "Quizzes ",
// "Timed questionnaire with recorded scores" => "Timed questionnaire with recorded scores",
// "Simple menu system which can optionally add an external web page in an iframe" => "Simple menu system which can optionally add an external web page in an iframe",
// "The Copyright Management System (or ©MS) is a way of licensing your content" => "The Copyright Management System (or ©MS) is a way of licensing your content",
// "Multimedia" => "Multimedia",
// "The applet is designed to read MP3 or FLV file" => "The applet is designed to read MP3 or FLV file",
// "Experimental. This feature is not actively maintained" => "Experimental. This feature is not actively maintained",
// "Quick comment (graffiti) box. Like a group chat, but not in real time" => "Quick comment (graffiti) box. Like a group chat, but not in real time",
// "Navigable, interactive maps with user-selectable layers" => "Navigable, interactive maps with user-selectable layers",
// "Requires mapserver" => "Requires mapserver",
// "Google Maps" => "Google Maps",
// "Interactive use of Google Maps" => "Interactive use of Google Maps",
// "One-on-one chatting with customer" => "One-on-one chatting with customer",
// "Tell a Friend" => "Tell a Friend",
// "Add a link \"Email this page\" in all the pages" => "Add a link \"Email this page\" in all the pages",
// "HTML pages" => "HTML pages",
// "Static and dynamic HTML content" => "Static and dynamic HTML content",
// "HTML can be used in wiki pages. This is a separate feature" => "HTML can be used in wiki pages. This is a separate feature",
// "Basic form from visitor to admin" => "Basic form from visitor to admin",
// "Minichat" => "Minichat",
// "Real-time group text chatting" => "Real-time group text chatting",
// "Comments Moderation " => "Comments Moderation ",
// "An admin must validate a comment before it is visible" => "An admin must validate a comment before it is visible",
// "Comments Locking" => "Comments Locking",
// "Comments can be closed (no new comments)" => "Comments can be closed (no new comments)",
// "Allow posting of comments as Anonymous" => "Allow posting of comments as Anonymous",
// "Permit anonymous visitors to add a comment without needing to create an account" => "Permit anonymous visitors to add a comment without needing to create an account",
// "Display page description" => "Display page description",
// "Display the page description below the heading when viewing the page" => "Display the page description below the heading when viewing the page",
// "Display page title" => "Display page title",
// "Display the page name at the top of each page. If not enabled, the content must be structured to contain a header" => "Display the page name at the top of each page. If not enabled, the content must be structured to contain a header",
// "Display page ID" => "Display page ID",
// "Display the internal page ID when viewing the page" => "Display the internal page ID when viewing the page",
// "Individual wiki cache" => "Individual wiki cache",
// "Allow users to change the duration of the cache on a per-page basis" => "Allow users to change the duration of the cache on a per-page basis",
// "JS Calendar" => "JS Calendar",
// "JavaScript popup date selector" => "JavaScript popup date selector",
// "Output should be HTMLPurified" => "Output should be HTMLPurified",
// "This enable HTPMPurifier on outputs to filter remaining security problems like XSS" => "This enable HTPMPurifier on outputs to filter remaining security problems like XSS",
// "Full Screen" => "Full Screen",
// "Allow users to activate fullscreen mode" => "Allow users to activate fullscreen mode",
// "Css Menus" => "Css Menus",
// "Css Menus (suckerfish)" => "Css Menus (suckerfish)",
// "Shadowbox" => "Shadowbox",
// "Quick Permission Assignment" => "Quick Permission Assignment",
// "Quickperms allow to define classes of privileges and grant them to roles on objects" => "Quickperms allow to define classes of privileges and grant them to roles on objects",
// "HTML Purifier" => "HTML Purifier",
// "Ajax" => "Ajax",
// "Morcego 3D browser" => "Morcego 3D browser",
// "Mindmap" => "Mindmap",
// "Print Indexed" => "Print Indexed",
// "Search engine friendly url" => "Search engine friendly url",
// "SpreadSheet" => "SpreadSheet",
// "Ajax auto-save" => "Ajax auto-save",
// "Save draft" => "Save draft",
// "Requires AJAX (experimental)" => "Requires AJAX (experimental)",
// "Kaltura" => "Kaltura",
// "Users can identify other users as their friends" => "Users can identify other users as their friends",
// "Neglected feature" => "Neglected feature",
// "Action calendar" => "Action calendar",
// "Redirect to a similar wiki page if an exact match is not found" => "Redirect to a similar wiki page if an exact match is not found",
// "User Contacts" => "User Contacts",
// "Group Watches" => "Group Watches",
// "Daily Reports for User Watches" => "Daily Reports for User Watches",
// "User Levels" => "User Levels",
// "Group Alert" => "Group Alert",
// "TikiTests" => "TikiTests",
// "Use Minified Scripts" => "Use Minified Scripts",
// "These JavaScript files have been previously minified and are stable. They make pages quicker to load than their non-minified versions" => "These JavaScript files have been previously minified and are stable. They make pages quicker to load than their non-minified versions",
// "Check for updates automatically" => "Check for updates automatically",
// "TikiWiki will check for updates when you access the main Administration page" => "TikiWiki will check for updates when you access the main Administration page",
// "Use PEAR::Date library" => "Use PEAR::Date library",
// "Require confirmation if possible CSRF detected" => "Require confirmation if possible CSRF detected",
// "Lookup the user\\'s preferred language through browser preferences" => "Lookup the user\\'s preferred language through browser preferences",
// "Show pages in user\\'s preferred language" => "Show pages in user\\'s preferred language",
// "When accessing a page which has an equivalent in the user\\'s preferred language, favor the translated page" => "When accessing a page which has an equivalent in the user\\'s preferred language, favor the translated page",
// "Changing the page language also changes the site language" => "Changing the page language also changes the site language",
// "Translation assistant" => "Translation assistant",
// "Track translation operations between pages" => "Track translation operations between pages",
// "Urgent translation notifications" => "Urgent translation notifications",
// "Allow to flag changes as urgent, leading translations to be marked with a notice visible to all users" => "Allow to flag changes as urgent, leading translations to be marked with a notice visible to all users",
// "Incomplete translation notice" => "Incomplete translation notice",
// "When a page is translated to a new language, a notice will be automatically be inserted into the page to indicate that the translation is not yet complete" => "When a page is translated to a new language, a notice will be automatically be inserted into the page to indicate that the translation is not yet complete",
// "Multilingual structures" => "Multilingual structures",
// "Structures to lookup equivalent pages in other languages. May cause performance problems on larger structures" => "Structures to lookup equivalent pages in other languages. May cause performance problems on larger structures",
// "Display all languages in a single page" => "Display all languages in a single page",
// "List all languages as a language option in the page language drop list to see all languages at once" => "List all languages as a language option in the page language drop list to see all languages at once",
// "GZip output" => "GZip output",
// "Translation URLs" => "Translation URLs",
// "Show clickable URLs to translate the page to another language using Babel Fish website" => "Show clickable URLs to translate the page to another language using Babel Fish website",
// "Translation icons" => "Translation icons",
// "Show clickable icons to translate the page to another language using Babelfish website" => "Show clickable icons to translate the page to another language using Babelfish website",
// "Also known as emoticons" => "Also known as emoticons",
// "Bloc of content which can be reused and programmed (timed)" => "Bloc of content which can be reused and programmed (timed)",
// "Use File Galleries to store pictures" => "Use File Galleries to store pictures",
// "External link icon" => "External link icon",
// "Semantic links" => "Semantic links",
// "Going beyond Backlinks, allows to define some semantic relationships between wiki pages" => "Going beyond Backlinks, allows to define some semantic relationships between wiki pages",
// "Web Services" => "Web Services",
// "Can consume webservices in JSON or YAML" => "Can consume webservices in JSON or YAML",
// "Breadcrumbs" => "Breadcrumbs",
// "Anonymous editors must enter anti-bot code (CAPTCHA)" => "Anonymous editors must enter anti-bot code (CAPTCHA)",
// "Protect email against spam" => "Protect email against spam",
// "Anonymous voting" => "Anonymous voting",
// "Allow re-voting" => "Allow re-voting",
// "Search engine friendly url Postfilter" => "Search engine friendly url Postfilter",
// "Display article title in the sefurl" => "Display article title in the sefurl",
// "Display blog title in the sefurl" => "Display blog title in the sefurl",
// "Show module controls" => "Show module controls",
// "Perspectives" => "Perspectives",
// "Permits to override preferences" => "Permits to override preferences",
// "Permits find and replace of content in the edit box" => "Permits find and replace of content in the edit box",
// "Specify notification emails when creating articles" => "Specify notification emails when creating articles",
// "Category path" => "Category path",
// "Show category objects" => "Show category objects",
// "Use PHPLayers for category browser" => "Use PHPLayers for category browser",
// "Screencasts" => "Screencasts",
// "Allow to upload screencasts from wiki edit. Screencasts can be uploaded locally or on a WebDAV share" => "Allow to upload screencasts from wiki edit. Screencasts can be uploaded locally or on a WebDAV share",
// "Screencasts upload location" => "Screencasts upload location",
// "Local path or webdav path to the file upload location" => "Local path or webdav path to the file upload location",
// "Trailing slash required" => "Trailing slash required",
// "Screencasts HTTP prefix" => "Screencasts HTTP prefix",
// "Prefix to use for the files when generating a link to it" => "Prefix to use for the files when generating a link to it",
// "Screencast upload type" => "Screencast upload type",
// "Mode used to upload files. WebDav is used to upload to remote servers" => "Mode used to upload files. WebDav is used to upload to remote servers",
// "Webdav" => "Webdav",
// "Screencasts authentication user" => "Screencasts authentication user",
// "When using webdav to upload files, used as the username of the authentication credentials" => "When using webdav to upload files, used as the username of the authentication credentials",
// "Screencasts authentication password" => "Screencasts authentication password",
// "When using webdav to upload files, used as the password of the authentication credentials" => "When using webdav to upload files, used as the password of the authentication credentials",
// "Screencasts max file size" => "Screencasts max file size",
// "Maximum file size used for screencasts" => "Maximum file size used for screencasts",
// "Value provided in bytes" => "Value provided in bytes",
// "Page List" => "Page List",
// "The pagelist feature allows to maintain lists of pages and their associated score and priority" => "The pagelist feature allows to maintain lists of pages and their associated score and priority",
// "Database search" => "Database search",
// "Object filter" => "Object filter",
// "Search box" => "Search box",
// "Pertinence" => "Pertinence",
// "Object type" => "Object type",
// "Last modified date" => "Last modified date",
// "Blog-level" => "Blog-level",
// "Batch uploading" => "Batch uploading",
// "Topic archiving" => "Topic archiving",
// "Quick jumps" => "Quick jumps",
// "Replies are empty" => "Replies are empty",
// "First post of a thread can have an empty body" => "First post of a thread can have an empty body",
// "Forum name search" => "Forum name search",
// "Forum content search" => "Forum content search",
// "Topic content search" => "Topic content search",
// "Use Tiki (database-independent) search" => "Use Tiki (database-independent) search",
// "Use database (full-text) search" => "Use database (full-text) search",
// "Store password as plain text" => "Store password as plain text",
// "Admins can search for features in the admin panels" => "Admins can search for features in the admin panels",
// "Encryption method" => "Encryption method",
// "tikihash (old)" => "tikihash (old)",
// "Display 'MyTiki' in the application menu" => "Display 'MyTiki' in the application menu",
// "Show user's contribution on the user information page" => "Show user's contribution on the user information page",
// "Permission to all (not just any) of an object's categories is required for access" => "Permission to all (not just any) of an object's categories is required for access",
// "Require file author's name for anonymous uploads" => "Require file author's name for anonymous uploads",
// "Add a Powered by Tiki link on your site's footer" => "Add a Powered by Tiki link on your site's footer",
// "Podcast directory" => "Podcast directory",
// "The server must be able to read/write the directory" => "The server must be able to read/write the directory",
// "Required for podcasts" => "Required for podcasts",
// "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload files in that dir, either by scp, ftp, or other protocols" => "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload files in that dir, either by scp, ftp, or other protocols",
// "The server must be able to read the directory" => "The server must be able to read the directory",
// "The directory can be outside the web space" => "The directory can be outside the web space",
// "Prevent download if score becomes negative" => "Prevent download if score becomes negative",
// "Allow download limit per file" => "Allow download limit per file",
// "Yes, even in the same gallery" => "Yes, even in the same gallery",
// "Only in different galleries" => "Only in different galleries",
// "Must match" => "Must match",
// "Cannot match" => "Cannot match",
// "Quota for all the files and archives" => "Quota for all the files and archives",
// "(0 for illimitted)" => "(0 for illimitted)",
// "Quota can be defined for each file gallery" => "Quota can be defined for each file gallery",
// "Default quota for each new gallery" => "Default quota for each new gallery",
// "Show quota bar in the list page" => "Show quota bar in the list page",
// "Manage thread defaults per-forum" => "Manage thread defaults per-forum",
// "Display thread configuration bar" => "Display thread configuration bar",
// "Display thread configuration bar only when number of posts exceed" => "Display thread configuration bar only when number of posts exceed",
// "Keep settings for all forums during the user session" => "Keep settings for all forums during the user session",
// "Default style" => "Default style",
// "Default sort mode" => "Default sort mode",
// "Description length" => "Description length",
// "Do not prefix messages titles by 'Re: '" => "Do not prefix messages titles by 'Re: '",
// "Default ordering" => "Default ordering",
// "Creation Date (asc)" => "Creation Date (asc)",
// "Multilingual tags" => "Multilingual tags",
// "Permits translation management of tags" => "Permits translation management of tags",
// "Label visible in the browser\\'s title bar on all pages. Also appears in search engines" => "Label visible in the browser\\'s title bar on all pages. Also appears in search engines",
// "Validate new user registrations by email" => "Validate new user registrations by email",
// "Upon registration, the new user will receive an email containing a link to confirm validity" => "Upon registration, the new user will receive an email containing a link to confirm validity",
// "Landing page used for the wiki when no page is specified. The page will be created if it does not exist" => "Landing page used for the wiki when no page is specified. The page will be created if it does not exist",
// "Default language" => "Default language",
// "Site language used when no other language is specified by the user" => "Site language used when no other language is specified by the user",
// "Cache external pages" => "Cache external pages",
// "Cache external images" => "Cache external images",
// "The default help system may not be complete. You can help with the TikiWiki documentation" => "The default help system may not be complete. You can help with the TikiWiki documentation",
// "License page" => "License page",
// "Submit notice" => "Submit notice",
// "[-180 180]" => "[-180 180]",
// "[0 360]" => "[0 360]",
// "Maximum number of articles on articles home page" => "Maximum number of articles on articles home page",
// "Url to go when clicking on a username" => "Url to go when clicking on a username",
// "Default: " => "Default: ",
// "Remind/forgot password" => "Remind/forgot password",
// "If passwords <em>are not</em> plain text, reset instructions will be emailed to the user" => "If passwords <em>are not</em> plain text, reset instructions will be emailed to the user",
// "If passwords <em>are stored</em> as plain text, the password will be emailed to the user" => "If passwords <em>are stored</em> as plain text, the password will be emailed to the user",
// "Verify for available translations in the database" => "Verify for available translations in the database",
// "Language inclusion threshold" => "Language inclusion threshold",
// "When the number of languages is restricted on the site, and is below this number, all languages will be added to the preferred language list, even if unspecified by the user. However, priority will be given to the specified languages" => "When the number of languages is restricted on the site, and is below this number, all languages will be added to the preferred language list, even if unspecified by the user. However, priority will be given to the specified languages",
// "Maximum average server load threshold in the last minute" => "Maximum average server load threshold in the last minute",
// "Log mail in Tiki logs" => "Log mail in Tiki logs",
// "Add HTML comment at start and end of each Smarty template (TPL)" => "Add HTML comment at start and end of each Smarty template (TPL)",
// "Log SQL" => "Log SQL",
// "Log queries using more than (seconds)" => "Log queries using more than (seconds)",
// "This may impact performance" => "This may impact performance",
// "Mail end of line" => "Mail end of line",
// "CRLF (standard)" => "CRLF (standard)",
// "LF (some Unix MTA)" => "LF (some Unix MTA)",
// "Memcache" => "Memcache",
// "Enable connection to memcached servers to store temporary information" => "Enable connection to memcached servers to store temporary information",
// "Requires the PHP memcache extension" => "Requires the PHP memcache extension",
// "Memcache flags" => "Memcache flags",
// "Configuration switches for memcache connection" => "Configuration switches for memcache connection",
// "Memcache servers" => "Memcache servers",
// "Server list which may be accessed. For each server, the address, port and weight must be specified" => "Server list which may be accessed. For each server, the address, port and weight must be specified",
// "One per line. address:port (weight)" => "One per line. address:port (weight)",
// "Memcache key prefix" => "Memcache key prefix",
// "When the memcache cluster is used by multiple applications, using unique prefixes for each of them helps avoiding conflicts" => "When the memcache cluster is used by multiple applications, using unique prefixes for each of them helps avoiding conflicts",
// "Memcache expiration" => "Memcache expiration",
// "Duration for which the data will be kept" => "Duration for which the data will be kept",
// "Cache wiki data in memcache" => "Cache wiki data in memcache",
// "Cache wiki output in memcache" => "Cache wiki output in memcache",
// "Cache forum output in memcache" => "Cache forum output in memcache",
// "Allow users to define icons for menus entries" => "Allow users to define icons for menus entries",
// "Default path for the icons" => "Default path for the icons",
// "Keywords" => "Keywords",
// "Include freetags" => "Include freetags",
// "Use thread title instead" => "Use thread title instead",
// "Use image title instead" => "Use image title instead",
// "Use individual page description for Wiki pages instead" => "Use individual page description for Wiki pages instead",
// "Meta robots" => "Meta robots",
// "Revisit after" => "Revisit after",
// "Multi-domain" => "Multi-domain",
// "Allows to map domain names to perspectives and simulate multiple domains hosted on the same instance" => "Allows to map domain names to perspectives and simulate multiple domains hosted on the same instance",
// "Multi-domain Configuration" => "Multi-domain Configuration",
// "Comma-separated values mapping the domain name to the perspective ID" => "Comma-separated values mapping the domain name to the perspective ID",
// "One domain per line. Comma separated with perspective ID" => "One domain per line. Comma separated with perspective ID",
// "Wiki buttons" => "Wiki buttons",
// "Page description, icons, backlinks, .." => "Page description, icons, backlinks, ..",
// "Top " => "Top ",
// "Neither" => "Neither",
// "Show categories" => "Show categories",
// "Show objects" => "Show objects",
// "Host" => "Host",
// "Proxy host" => "Proxy host",
// "Quantify change size" => "Quantify change size",
// "In addition to tracking the changes, track the change size and display the approximate up-to-date-ness of the page" => "In addition to tracking the changes, track the change size and display the approximate up-to-date-ness of the page",
// "Keep track of the unsuccessful attemps to translate strings" => "Keep track of the unsuccessful attemps to translate strings",
// "Restrict supported languages" => "Restrict supported languages",
// "Limit the languages made available on the site" => "Limit the languages made available on the site",
// "Refresh mode" => "Refresh mode",
// "Random" => "Random",
// "Parse the results" => "Parse the results",
// "Sender email" => "Sender email",
// "Email address that will be used as the sender for outgoing emails" => "Email address that will be used as the sender for outgoing emails",
// "Session storage location" => "Session storage location",
// "Select where the session information should be stored. Memcache sessions require memcache to be configured" => "Select where the session information should be stored. Memcache sessions require memcache to be configured",
// "Default (from php.ini)" => "Default (from php.ini)",
// "Session lifetime" => "Session lifetime",
// "Value provided in minutes" => "Value provided in minutes",
// "Silent session" => "Silent session",
// "Do not automatically start sessions" => "Do not automatically start sessions",
// "Session cookie name" => "Session cookie name",
// "Session cookie name used instead of the PHP default configuration" => "Session cookie name used instead of the PHP default configuration",
// "Display available translations" => "Display available translations",
// "Close site (except for those with permission)" => "Close site (except for those with permission)",
// "Message to display" => "Message to display",
// "Locations (breadcrumbs)" => "Locations (breadcrumbs)",
// "Choices" => "Choices",
// "Site title location" => "Site title location",
// "Location of the site title in the browser title bar relative to the current page\\'s descriptor" => "Location of the site title in the browser title bar relative to the current page\\'s descriptor",
// "Browser title display mode" => "Browser title display mode",
// "When breadcrumbs are used, method in which the browser title should be displayed" => "When breadcrumbs are used, method in which the browser title should be displayed",
// "Most specific first" => "Most specific first",
// "Least specific first (site)" => "Least specific first (site)",
// "Current only" => "Current only",
// "Include smarty notices in PHP error report" => "Include smarty notices in PHP error report",
// "In most cases, smarty notices can be safely ignored. However, they may be useful in the development process when strange issues occur" => "In most cases, smarty notices can be safely ignored. However, they may be useful in the development process when strange issues occur",
// "Smarty Security" => "Smarty Security",
// "Do not allow php code in smarty templates" => "Do not allow php code in smarty templates",
// "Check frequency" => "Check frequency",
// "Each day" => "Each day",
// "Each week" => "Each week",
// "Each month" => "Each month",
// "Minify javascript" => "Minify javascript",
// "Compress javascript files used in the page into a single file to be distributed statically. Changes to javascript files will require cache to be cleared" => "Compress javascript files used in the page into a single file to be distributed statically. Changes to javascript files will require cache to be cleared",
// "Use Jquery autocomplete user selector for better performance when number of users exceed" => "Use Jquery autocomplete user selector for better performance when number of users exceed",
// "Close site when server load is above the threshold  (except for those with permission)" => "Close site when server load is above the threshold  (except for those with permission)",
// "Show user\\'s real name instead of login (when possible)" => "Show user\\'s real name instead of login (when possible)",
// "Display UserTracker information on the user information page" => "Display UserTracker information on the user information page",
// "Users can configure modules" => "Users can configure modules",
// "Users can shade modules" => "Users can shade modules",
// "Always" => "Always",
// "Module decides" => "Module decides",
// "500Kb" => "500Kb",
// "1Mb" => "1Mb",
// "1.5Mb" => "1.5Mb",
// "2Mb" => "2Mb",
// "2.5Mb" => "2.5Mb",
// "3Mb" => "3Mb",
// "Include a flag by each e-mail to quickly flag/un-flag them" => "Include a flag by each e-mail to quickly flag/un-flag them",
// "Wiki link format" => "Wiki link format",
// "Character set used when detecting wiki links within pages" => "Character set used when detecting wiki links within pages",
// "Latin" => "Latin",
// "Display by default only pages in current language" => "Display by default only pages in current language",
// "In Wiki page lists, display by default only pages in current language" => "In Wiki page lists, display by default only pages in current language",
// "Display page version" => "Display page version",
// "Display the page version information when viewing the page" => "Display the page version information when viewing the page",
// "Page name display stripper" => "Page name display stripper",
// "Character to use as a delimiter in the page name. The portion of the name after this character will not be displayed" => "Character to use as a delimiter in the page name. The portion of the name after this character will not be displayed",
// "Wiki author list style" => "Wiki author list style",
// "Changes the list format used to display the authors of the page" => "Changes the list format used to display the authors of the page",
// "Creator & Author" => "Creator & Author",
// "none (disabled)" => "none (disabled)",
// "Specify wiki author list style per page" => "Specify wiki author list style per page",
// "Allows to modify the style in which the author list is displayed on a per-page basis" => "Allows to modify the style in which the author list is displayed on a per-page basis",
// "Wiki action bar location" => "Wiki action bar location",
// "Buttons: Save, Preview, Cancel, .." => "Buttons: Save, Preview, Cancel, ..",
// "Both" => "Both",
// "Wiki navigation bar location" => "Wiki navigation bar location",
// "When using the ...page... page break wiki syntax" => "When using the ...page... page break wiki syntax",
// "Wiki top line location" => "Wiki top line location",
// "Enable page cache globally for wiki pages" => "Enable page cache globally for wiki pages",
// "Allow comments per page" => "Allow comments per page",
// "Enable control for comments on wiki pages individually" => "Enable control for comments on wiki pages individually",
// "Disable" => "Disable",
// "Enable (default On)" => "Enable (default On)",
// "Enable (default Off)" => "Enable (default Off)",
// "Enable edit plugin icons" => "Enable edit plugin icons",
// "Permits editing of a plugin, via a popup form, without needing to edit the whole page" => "Permits editing of a plugin, via a popup form, without needing to edit the whole page",
// "Enable plugin %0" => "Enable plugin %0",
// "Inline plugin %0 (hide plugin edit icon)" => "Inline plugin %0 (hide plugin edit icon)",
// "When inlined, the plugin edit icon will not appear" => "When inlined, the plugin edit icon will not appear",
// "Wysiwyg Editor is optional" => "Wysiwyg Editor is optional",
// "... and is displayed by default" => "... and is displayed by default",
// "Reopen with the same editor" => "Reopen with the same editor",
// "Content is parsed like wiki page" => "Content is parsed like wiki page",
// "Content is partially parsed" => "Content is partially parsed",
// "Toolbar skin" => "Toolbar skin",
// "Default" => "Default",
// "Office 2003" => "Office 2003",
// "Silver" => "Silver",
// "Nothing was changed, please check profile for errors" => "Nothing was changed, please check profile for errors",
// "An error occurred: " => "An error occurred: ",
// "Applying profile" => "Applying profile",
// "Added (or modified)" => "Added (or modified)",
// "Preference set" => "Preference set",
// "Group changed (or modified)" => "Group changed (or modified)",
// "User %0 was added to %1" => "User %0 was added to %1",
// "Created by profile installer" => "Created by profile installer",
// "Page updated by profile installer" => "Page updated by profile installer",
// "No name" => "No name",
// "Bad object" => "Bad object",
// "The passwords do not match" => "The passwords do not match",
// "uploaded the file" => "uploaded the file",
// "changes" => "changes",
// "No changes" => "No changes",
// "Yesterday" => "Yesterday",
// "more changes of the same type.." => "more changes of the same type..",
// "changed the picture gallery" => "changed the picture gallery",
// "uploaded the picture" => "uploaded the picture",
// "onto" => "onto",
// "removed the picture" => "removed the picture",
// "edited the wikipage" => "edited the wikipage",
// "this history" => "this history",
// "all history" => "all history",
// "edited the file gallery" => "edited the file gallery",
// "removed the file" => "removed the file",
// "added the \".\$change['data']['objectType']).\" <a href=\"\$tikiUrl/\".\$change['data']['objectUrl'].\"\">\".\$change['data']['objectName'].\"</a> \".tra(\"to the category" => "added the \".\$change['data']['objectType']).\" <a href=\"\$tikiUrl/\".\$change['data']['objectUrl'].\"\">\".\$change['data']['objectName'].\"</a> \".tra(\"to the category",
// "removed the \".\$change['data']['objectType']).\" <a href=\"\$tikiUrl/\".\$change['data']['objectUrl'].\"\">\".\$change['data']['objectName'].\"</a> \".tra(\"from the category" => "removed the \".\$change['data']['objectType']).\" <a href=\"\$tikiUrl/\".\$change['data']['objectUrl'].\"\">\".\$change['data']['objectName'].\"</a> \".tra(\"from the category",
// "created the subcategory" => "created the subcategory",
// "removed the subcategory" => "removed the subcategory",
// "edited the category" => "edited the category",
// "removed the article" => "removed the article",
// "created the article" => "created the article",
// "edited the article" => "edited the article",
// "replied to the blog" => "replied to the blog",
// "created the topic" => "created the topic",
// "at forum" => "at forum",
// "to the topic" => "to the topic",
// "Nothing has happened" => "Nothing has happened",
// "Feed provided by %s. Click to visit" => "Feed provided by %s. Click to visit",
// "Wiki Comment" => "Wiki Comment",
// "Calendar item" => "Calendar item",
// "Tracker item" => "Tracker item",
// "Simple" => "Simple",
// "Advanced" => "Advanced",
// "_HOMEPAGE_CONTENT_" => "_HOMEPAGE_CONTENT_",
// "You are not in group of friends to have the content of this block displayed for you" => "You are not in group of friends to have the content of this block displayed for you",
// "Smarty block.display.php: Missing error param" => "Smarty block.display.php: Missing error param",
// "<!-- jq smarty plugin inactive: feature_jquery off -->" => "<!-- jq smarty plugin inactive: feature_jquery off -->",
// "Fast Next" => "Fast Next",
// "Fast Prev" => "Fast Prev",
// "First {\$params['itemname']}" => "First {\$params['itemname']}",
// "Last {\$params['itemname']}" => "Last {\$params['itemname']}",
// "Next {\$params['itemname']}" => "Next {\$params['itemname']}",
// "Prev {\$params['itemname']}" => "Prev {\$params['itemname']}",
// "tip" => "tip",
// "warning" => "warning",
// "note" => "note",
// "errors" => "errors",
// "information" => "information",
// "Tab View" => "Tab View",
// "No Tabs" => "No Tabs",
// "If you want the saved version instead of this autosaved one" => "If you want the saved version instead of this autosaved one",
// "AutoSave" => "AutoSave",
// "Your edit session will expire in" => "Your edit session will expire in",
// "You must PREVIEW or SAVE your work now, to avoid losing your edits" => "You must PREVIEW or SAVE your work now, to avoid losing your edits",
// "Your edit session has expired" => "Your edit session has expired",
// "You are about to leave this page. Changes since your last save will be lost. Are you sure you want to exit this page" => "You are about to leave this page. Changes since your last save will be lost. Are you sure you want to exit this page",
// "Help page" => "Help page",
// "Admin Feature" => "Admin Feature",
// "phplayers are not available on this site" => "phplayers are not available on this site",
// "Preference name not specified" => "Preference name not specified",
// "Preference %0 is not defined" => "Preference %0 is not defined",
// "Invert Sort" => "Invert Sort",
// "No rows found" => "No rows found",
// "{treetable}: Number of items in _checkboxColumnIndex doesn not match items in _checkbox" => "{treetable}: Number of items in _checkboxColumnIndex doesn not match items in _checkbox",
// "{treetable}: Number of items in _checkboxTitles doesn not match items in _checkbox" => "{treetable}: Number of items in _checkboxTitles doesn not match items in _checkbox",
// "Toggle sections" => "Toggle sections",
// "sec" => "sec",
// "Gender" => "Gender",
// "Permission denied: the specified wiki page cannot be used as Smarty template resource" => "Permission denied: the specified wiki page cannot be used as Smarty template resource",
// "You have to make %d choice(s) for the question" => "You have to make %d choice(s) for the question",
// "You have to make at least %d choice(s) for the question" => "You have to make at least %d choice(s) for the question",
// "You have to make less than %d choice(s) for the question" => "You have to make less than %d choice(s) for the question",
// "You have to choose at least %d choice(s) for the question" => "You have to choose at least %d choice(s) for the question",
// "Foo" => "Foo",
// "Sample plugin" => "Sample plugin",
// "Face" => "Face",
// "Font family to use" => "Font family to use",
// "As defined by CSS" => "As defined by CSS",
// "Page '%0' cannot be found" => "Page '%0' cannot be found",
// "For the security of your password direct access to the feed is only available via https" => "For the security of your password direct access to the feed is only available via https",
// "Help link" => "Help link",
// "Edit Plugin" => "Edit Plugin",
// "Edit Section" => "Edit Section",
// "smiling" => "smiling",
// "grinning" => "grinning",
// "crying" => "crying",
// "frightened" => "frightened",
// "evil stuff" => "evil stuff",
// "exclamation mark " => "exclamation mark ",
// "frowning" => "frowning",
// "light bulb" => "light bulb",
// "idea " => "idea ",
// "LOL" => "LOL",
// "laughing out loud " => "laughing out loud ",
// "mr. green laughing" => "mr. green laughing",
// "The file was uploaded with success" => "The file was uploaded with success",
// "The file you are trying upload was only partially uploaded" => "The file you are trying upload was only partially uploaded",
// "No file was uploaded. Was a file selected " => "No file was uploaded. Was a file selected ",
// "A temporary folder is missing" => "A temporary folder is missing",
// "Unknown error" => "Unknown error",
// "Flash player not available" => "Flash player not available",
// "__WARNING__: Plugin disabled \$plugin" => "__WARNING__: Plugin disabled \$plugin",
// "Bold" => "Bold",
// "pics/icons/text_bold.png" => "pics/icons/text_bold.png",
// "Italic" => "Italic",
// "pics/icons/text_italic.png" => "pics/icons/text_italic.png",
// "Strikethrough" => "Strikethrough",
// "pics/icons/text_strikethrough.png" => "pics/icons/text_strikethrough.png",
// "Non-parsed" => "Non-parsed",
// "pics/icons/noparse.png" => "pics/icons/noparse.png",
// "Align Center" => "Align Center",
// "pics/icons/text_align_center.png" => "pics/icons/text_align_center.png",
// "Horizontal Bar" => "Horizontal Bar",
// "pics/icons/page.png" => "pics/icons/page.png",
// "Page Break" => "Page Break",
// "lib/fckeditor_tiki/fckeditor-icons/Pagebreak.gif" => "lib/fckeditor_tiki/fckeditor-icons/Pagebreak.gif",
// "Block Quote" => "Block Quote",
// "pics/icons/box.png" => "pics/icons/box.png",
// "pics/icons/book.png" => "pics/icons/book.png",
// "Unordered List" => "Unordered List",
// "pics/icons/text_list_bullets.png" => "pics/icons/text_list_bullets.png",
// "Ordered List" => "Ordered List",
// "pics/icons/text_list_numbers.png" => "pics/icons/text_list_numbers.png",
// "Special Characters" => "Special Characters",
// "lib/fckeditor_tiki/fckeditor-icons/Specialchar.gif" => "lib/fckeditor_tiki/fckeditor-icons/Specialchar.gif",
// "img/smiles/icon_smile.gif" => "img/smiles/icon_smile.gif",
// "Foreground color" => "Foreground color",
// "pics/icons/palette.png" => "pics/icons/palette.png",
// "Background Color" => "Background Color",
// "pics/icons/palette_bg.png" => "pics/icons/palette_bg.png",
// "Wiki Link" => "Wiki Link",
// "pics/icons/page_link.png" => "pics/icons/page_link.png",
// "External Link" => "External Link",
// "pics/icons/world_link.png" => "pics/icons/world_link.png",
// "pics/icons/table.png" => "pics/icons/table.png",
// "Table Builder" => "Table Builder",
// "pics/icons/find.png" => "pics/icons/find.png",
// "Find Text" => "Find Text",
// "pics/icons/text_replace.png" => "pics/icons/text_replace.png",
// "Text Replace" => "Text Replace",
// "Full Screen Edit" => "Full Screen Edit",
// "pics/icons/arrow_in.png" => "pics/icons/arrow_in.png",
// "pics/icons/arrow_out.png" => "pics/icons/arrow_out.png",
// "Choose or upload images" => "Choose or upload images",
// "pics/icons/pictures.png" => "pics/icons/pictures.png",
// "Switch Editor (wiki or WYSIWYG)" => "Switch Editor (wiki or WYSIWYG)",
// "pics/icons/pencil_go.png" => "pics/icons/pencil_go.png",
// "Admin Toolbars" => "Admin Toolbars",
// "Upload was not successful. Duplicate file content " => "Upload was not successful. Duplicate file content ",
// "Field is not a link to mp3 in the gallery" => "Field is not a link to mp3 in the gallery",
// "Field is not a link to FLV in the gallery" => "Field is not a link to FLV in the gallery",
// "Field is not a link to FLV or MP3 in the gallery" => "Field is not a link to FLV or MP3 in the gallery",
// "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a one-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append,max,autocomplete</strong>\n\t\t\t\t<dt>Example: 0,80,\$,,80\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible length of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[autocomplete]</strong> if y autocomplete while typing;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a one-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append,max,autocomplete</strong>\n\t\t\t\t<dt>Example: 0,80,\$,,80\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible length of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[autocomplete]</strong> if y autocomplete while typing;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a multi-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>toolbars,width,height,max,listmax,wordmax</strong>\n\t\t\t\t<dt>Example: 0,80,5,30,200\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[toolbars]</strong> enables toolbars if a 1 is specified;\n\t\t\t\t<dd><strong>[width]</strong> is the width of the box, in chars;\n\t\t\t\t<dd><strong>[height]</strong> is the number of visible lines in the box;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[listmax]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd><strong>[wordmax]</strong> will alert if word count exceeded with a positive number (1+) or display a word count with a negative number (-1);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a multi-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>toolbars,width,height,max,listmax,wordmax</strong>\n\t\t\t\t<dt>Example: 0,80,5,30,200\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[toolbars]</strong> enables toolbars if a 1 is specified;\n\t\t\t\t<dd><strong>[width]</strong> is the width of the box, in chars;\n\t\t\t\t<dd><strong>[height]</strong> is the number of visible lines in the box;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[listmax]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd><strong>[wordmax]</strong> will alert if word count exceeded with a positive number (1+) or display a word count with a negative number (-1);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a checkbox field for yes/no, on/off input.\n\t\t\t\t<dt>Usage: <strong>samerow</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field on the same row if a 1 is specified.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a checkbox field for yes/no, on/off input.\n\t\t\t\t<dt>Usage: <strong>samerow</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field on the same row if a 1 is specified.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a one-line field for numeric input only.  Prepend or append values may be alphanumeric.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append</strong>\n\t\t\t\t<dt>Example: 0,60,,hours\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible size of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a one-line field for numeric input only.  Prepend or append values may be alphanumeric.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append</strong>\n\t\t\t\t<dt>Example: 0,60,,hours\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible size of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to select only from a specified set of options in a drop-down bar.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to select only from a specified set of options in a drop-down bar.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>",
// "drop down with other textfield" => "drop down with other textfield",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to select from a specified set of options in a drop-down bar, or provide an alternate selection in a one-line text field.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to select from a specified set of options in a drop-down bar, or provide an alternate selection in a one-line text field.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>",
// "radio buttons" => "radio buttons",
// "<dl>\n\t\t\t\t<dt>Function: Provides a multiple-choice-style set of options from which a user may only choose one.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list of items]</strong> is the list of all values you want in the set, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear as the one selected.\n\t\t\t\t<dd>If first option is &lt;br&gt;, options will be separated with a carriaage return\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a multiple-choice-style set of options from which a user may only choose one.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list of items]</strong> is the list of all values you want in the set, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear as the one selected.\n\t\t\t\t<dd>If first option is &lt;br&gt;, options will be separated with a carriaage return\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usernames.\n\t\t\t\t<dt>Usage: <strong>auto-assign,email_notify</strong>\n\t\t\t\t<dt>Example: 1,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1, or will set the selection to the user who last modified the item if set to 2, or will give the choice between all the users for other values;\n\t\t\t\t<dd><strong>[email_notify]</strong> will send an email to the assigned user when the item is saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usernames.\n\t\t\t\t<dt>Usage: <strong>auto-assign,email_notify</strong>\n\t\t\t\t<dt>Example: 1,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1, or will set the selection to the user who last modified the item if set to 2, or will give the choice between all the users for other values;\n\t\t\t\t<dd><strong>[email_notify]</strong> will send an email to the assigned user when the item is saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usergroups.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the field to the usergroup of the creator if set to 1, or will set the selection to the group of the user who last modified the item if set to 2, or will give the choice between all the groups for other values;\n\t\t\t\t<dd>if the user does not have a default group set, the first group the user belongs to will be chosen, otherwise Registered group will be used.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usergroups.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the field to the usergroup of the creator if set to 1, or will set the selection to the group of the user who last modified the item if set to 2, or will give the choice between all the groups for other values;\n\t\t\t\t<dd>if the user does not have a default group set, the first group the user belongs to will be chosen, otherwise Registered group will be used.\n\t\t\t\t</dl>",
// "IP selector" => "IP selector",
// "<dl>\n\t\t\t\t<dt>Function: Provides a field for entering an IP address.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-populate the field with the IP address of the user who created the item if set to 1, or will set the field to the IP of the user who last modified the item if set to 2, or will be a free IP for other values.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a field for entering an IP address.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-populate the field with the IP address of the user who created the item if set to 1, or will set the field to the IP of the user who last modified the item if set to 2, or will be a free IP for other values.\n\t\t\t\t</dl>",
// "page selector" => "page selector",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from the list of pages.\n\t\t\t\t<dt>Usage: <strong>auto-assign, size, create</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1\n\t\t\t\t<dd><strong>[size]</strong> is the visible input length of the field in characters (<=0 not limited);\n\t\t\t\t<dd><strong>[create]</strong>: will create the page if not exits copy of the page with name value of this param.which pagename is the value of this param\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from the list of pages.\n\t\t\t\t<dt>Usage: <strong>auto-assign, size, create</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1\n\t\t\t\t<dd><strong>[size]</strong> is the visible input length of the field in characters (<=0 not limited);\n\t\t\t\t<dd><strong>[create]</strong>: will create the page if not exits copy of the page with name value of this param.which pagename is the value of this param\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of countries.\n\t\t\t\t<dt>Usage: <strong>name_flag,sort</strong>\n\t\t\t\t<dt>Example: 1,0\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[name_flag]</strong> default is 0 and will display both the country name and its flag, 1 will display only the country name, while 2 will show only the country flag;\n\t\t\t\t<dd><strong>[sortorder]</strong> specifies the order the country list should be displayed in, where 0 is the default and sorts according to the translated name, and 1 sorts according to the english name;\n\t\t\t\t<dd>if the country names are translated and option 1 is selected for the sort order, the countries will still appear translated, but will merely be in english order.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of countries.\n\t\t\t\t<dt>Usage: <strong>name_flag,sort</strong>\n\t\t\t\t<dt>Example: 1,0\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[name_flag]</strong> default is 0 and will display both the country name and its flag, 1 will display only the country name, while 2 will show only the country flag;\n\t\t\t\t<dd><strong>[sortorder]</strong> specifies the order the country list should be displayed in, where 0 is the default and sorts according to the translated name, and 1 sorts according to the english name;\n\t\t\t\t<dd>if the country names are translated and option 1 is selected for the sort order, the countries will still appear translated, but will merely be in english order.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides drop-down options to accurately select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime,startyear,endyear,blankdate</strong>\n\t\t\t\t<dt>Example: d,2000,,blank\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\";\n\t\t\t\t<dd><strong>[startyear]</strong> allows you to specify a custom first year in the date range (eg. 1987), default is current year;\n\t\t\t\t<dd><strong>[endyear]</strong> allows you to specify a custom end year in the date range (eg. 2020), default is 4 years from now;\n\t\t\t\t<dd><strong>[blankdate]</strong> when set to \"blank\" will default the initial date field to an empty date, and allow selection of empty dates;\n\t\t\t\t<dd>blankdate is overridden if the field isMandatory;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dt>Example: \"d,2000,2009,blank\"\n\t\t\t\t<dd>sets a date only field from 2000 through 2009, allowing blank dates.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides drop-down options to accurately select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime,startyear,endyear,blankdate</strong>\n\t\t\t\t<dt>Example: d,2000,,blank\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\";\n\t\t\t\t<dd><strong>[startyear]</strong> allows you to specify a custom first year in the date range (eg. 1987), default is current year;\n\t\t\t\t<dd><strong>[endyear]</strong> allows you to specify a custom end year in the date range (eg. 2020), default is 4 years from now;\n\t\t\t\t<dd><strong>[blankdate]</strong> when set to \"blank\" will default the initial date field to an empty date, and allow selection of empty dates;\n\t\t\t\t<dd>blankdate is overridden if the field isMandatory;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dt>Example: \"d,2000,2009,blank\"\n\t\t\t\t<dd>sets a date only field from 2000 through 2009, allowing blank dates.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a javascript graphical date selector to select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime</strong>\n\t\t\t\t<dt>Example: dt\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\".\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a javascript graphical date selector to select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime</strong>\n\t\t\t\t<dt>Example: dt\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\".\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows user to upload an image into the tracker item.\n\t\t\t\t<dt>Usage: <strong>xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale,shadowBox</strong>\n\t\t\t\t<dt>Example: 30,30,100,100,1000,item\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[xListSize]</strong> sets the pixel width of the image in the list view;\n\t\t\t\t<dd><strong>[yListSize]</strong> sets the pixel height of the image in the list view;\n\t\t\t\t<dd><strong>[xDetailSize]</strong> sets the pixel width of the image in the item view;\n\t\t\t\t<dd><strong>[yDetailSize]</strong> sets the pixel height of the image in the item view;\n\t\t\t\t<dd><strong>[uploadLimitScale]</strong> sets the maximum total size of the image, in pixels (width or height);\n\t\t\t\t<dd><strong>[shadowbox]</strong> actives a shadowbox(if feature on) = \\'item\\': to use the same shadowbox for an item, =\\'individual\\': to use a shadowbox only for this image, other value= to set the group of images of the shadowbox ;\n\t\t\t\t<dd>images are stored in img/trackers;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows user to upload an image into the tracker item.\n\t\t\t\t<dt>Usage: <strong>xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale,shadowBox</strong>\n\t\t\t\t<dt>Example: 30,30,100,100,1000,item\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[xListSize]</strong> sets the pixel width of the image in the list view;\n\t\t\t\t<dd><strong>[yListSize]</strong> sets the pixel height of the image in the list view;\n\t\t\t\t<dd><strong>[xDetailSize]</strong> sets the pixel width of the image in the item view;\n\t\t\t\t<dd><strong>[yDetailSize]</strong> sets the pixel height of the image in the item view;\n\t\t\t\t<dd><strong>[uploadLimitScale]</strong> sets the maximum total size of the image, in pixels (width or height);\n\t\t\t\t<dd><strong>[shadowbox]</strong> actives a shadowbox(if feature on) = \\'item\\': to use the same shadowbox for an item, =\\'individual\\': to use a shadowbox only for this image, other value= to set the group of images of the shadowbox ;\n\t\t\t\t<dd>images are stored in img/trackers;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: ?\n\t\t\t\t<dt>Usage: <strong>label,post,tiki-index.php,page:fieldname,highlight=test</strong>\n\t\t\t\t<dt>Example:\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[label]</strong> needs explanation;\n\t\t\t\t<dd><strong>[post]</strong> needs explanation;\n\t\t\t\t<dd><strong>[tiki-index.php]</strong> needs explanation;\n\t\t\t\t<dd><strong>[page:fieldname]</strong> needs explanation;\n\t\t\t\t<dd><strong>[highlight=test]</strong> needs explanation;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: ?\n\t\t\t\t<dt>Usage: <strong>label,post,tiki-index.php,page:fieldname,highlight=test</strong>\n\t\t\t\t<dt>Example:\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[label]</strong> needs explanation;\n\t\t\t\t<dd><strong>[post]</strong> needs explanation;\n\t\t\t\t<dd><strong>[tiki-index.php]</strong> needs explanation;\n\t\t\t\t<dd><strong>[page:fieldname]</strong> needs explanation;\n\t\t\t\t<dd><strong>[highlight=test]</strong> needs explanation;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: will display trhe field name as a html header h2;\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: will display trhe field name as a html header h2;\n\t\t\t\t</dl>",
// "static text" => "static text",
// "<dl>\n\t\t\t\t<dt>Function: Allows insertion of a static block of text into a tracker to augment input fields. (non-editable)\n\t\t\t\t<dt>Usage: <strong>wikiparse,max</strong>\n\t\t\t\t<dt>Example: 1,20\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[wikiparse]</strong> will allow wiki syntax to be parsed if set to 1, otherwise default is 0 to only support line-breaks;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows insertion of a static block of text into a tracker to augment input fields. (non-editable)\n\t\t\t\t<dt>Usage: <strong>wikiparse,max</strong>\n\t\t\t\t<dt>Example: 1,20\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[wikiparse]</strong> will allow wiki syntax to be parsed if set to 1, otherwise default is 0 to only support line-breaks;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows one or more categories under a main category to be assigned to the tracker item.\n\t\t\t\t<dt>Usage: <strong>parentId,inputtype,selectall</strong>\n\t\t\t\t<dt>Example: 12,radio,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[parentId]</strong> is the ID of the main category, categories in the list will be children of this;\n\t\t\t\t<dd><strong>[inputtype]</strong> is one of [d|m|radio|checkbox], where d is a drop-down list, m is a multiple-selection drop-down list, radio and checkbox are self-explanatory;\n\t\t\t\t<dd><strong>[selectall]</strong> will provide a checkbox to automatically select all categories in the list if set to 1, default is 0;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows one or more categories under a main category to be assigned to the tracker item.\n\t\t\t\t<dt>Usage: <strong>parentId,inputtype,selectall</strong>\n\t\t\t\t<dt>Example: 12,radio,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[parentId]</strong> is the ID of the main category, categories in the list will be children of this;\n\t\t\t\t<dd><strong>[inputtype]</strong> is one of [d|m|radio|checkbox], where d is a drop-down list, m is a multiple-selection drop-down list, radio and checkbox are self-explanatory;\n\t\t\t\t<dd><strong>[selectall]</strong> will provide a checkbox to automatically select all categories in the list if set to 1, default is 0;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a way to choose a value from another tracker (eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldId,linkToItem,displayedFieldsList</strong>\n\t\t\t\t<dt>Example: 3,5,1,6|8\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldId]</strong> is the field in [trackerId] from which you can select a value among all the field values of the items of [trackerId];\n\t\t\t\t<dd><strong>[linkToItem]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to the item in the other tracker;\n\t\t\t\t<dd><strong>[displayedFieldsList]</strong> is a list of fields in [trackerId] to display instead of [fieldId], multiple fields can be separated with a |;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a way to choose a value from another tracker (eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldId,linkToItem,displayedFieldsList</strong>\n\t\t\t\t<dt>Example: 3,5,1,6|8\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldId]</strong> is the field in [trackerId] from which you can select a value among all the field values of the items of [trackerId];\n\t\t\t\t<dd><strong>[linkToItem]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to the item in the other tracker;\n\t\t\t\t<dd><strong>[displayedFieldsList]</strong> is a list of fields in [trackerId] to display instead of [fieldId], multiple fields can be separated with a |;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Displays a list of field values from another tracker that has a relation with this tracker(eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldIdThere,fieldIdHere,displayFieldIdThere,linkToItems</strong>\n\t\t\t\t<dt>Example: 5,3,4,10|11\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldIdThere]</strong> is the field (multiple fields can be separated with a \":\") you want to link with;\n\t\t\t\t<dd><strong>[fieldIdHere]</strong> is the field in this tracker you want to link with;\n\t\t\t\t<dd><strong>[displayFieldIdThere]</strong> the field(s) in [trackerId] you want to display, multiple fields can be separated by \"|\";\n\t\t\t\t<dd><strong>[linkToItems]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to that values item in the other tracker;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Displays a list of field values from another tracker that has a relation with this tracker(eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldIdThere,fieldIdHere,displayFieldIdThere,linkToItems</strong>\n\t\t\t\t<dt>Example: 5,3,4,10|11\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldIdThere]</strong> is the field (multiple fields can be separated with a \":\") you want to link with;\n\t\t\t\t<dd><strong>[fieldIdHere]</strong> is the field in this tracker you want to link with;\n\t\t\t\t<dd><strong>[displayFieldIdThere]</strong> the field(s) in [trackerId] you want to display, multiple fields can be separated by \"|\";\n\t\t\t\t<dd><strong>[linkToItems]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to that values item in the other tracker;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "dynamic items list" => "dynamic items list",
// "<dl>\n\t\t\t\t<dt>Function: Dynamically updates a selection list based on linked data from another tracker.\n\t\t\t\t<dt>Usage: <strong>trackerId,filterFieldIdThere,filterFieldIdHere,listFieldIdThere,statusThere</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the ID of the tracker to link with;\n\t\t\t\t<dd><strong>[filterFieldIdThere]</strong> is the field you want to link with in that tracker;\n\t\t\t\t<dd><strong>[filterFieldIdHere]</strong> is the field you want to link with in the current tracker;\n\t\t\t\t<dd><strong>[listFieldIdThere]</strong> is the field ID you wish to pull the selection list from, based on the value selected in fiterFieldIdHere matching field(s) in filterFieldIdThere;\n\t\t\t\t<dd><strong>[statusThere]</strong> restricts values appearing in the list to those coming from records in the other tracker that meet specified statuses of [o|p|c] or in combination (op, opc);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Dynamically updates a selection list based on linked data from another tracker.\n\t\t\t\t<dt>Usage: <strong>trackerId,filterFieldIdThere,filterFieldIdHere,listFieldIdThere,statusThere</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the ID of the tracker to link with;\n\t\t\t\t<dd><strong>[filterFieldIdThere]</strong> is the field you want to link with in that tracker;\n\t\t\t\t<dd><strong>[filterFieldIdHere]</strong> is the field you want to link with in the current tracker;\n\t\t\t\t<dd><strong>[listFieldIdThere]</strong> is the field ID you wish to pull the selection list from, based on the value selected in fiterFieldIdHere matching field(s) in filterFieldIdThere;\n\t\t\t\t<dd><strong>[statusThere]</strong> restricts values appearing in the list to those coming from records in the other tracker that meet specified statuses of [o|p|c] or in combination (op, opc);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an email address with option of making it active.\n\t\t\t\t<dt>Usage: <strong>link,watchopen,watchpending,watchclosed</strong>\n\t\t\t\t<dt>Example: 0,o\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[link]</strong> may be one of [0|1|2] and specifies how to display the email address, defaulting to 0 as plain text, 1 as an encoded hex mailto link, or 2 as a standard mailto link;\n\t\t\t\t<dd><strong>[watchopen]</strong> if set to \"o\" will email the address every time the status of the item changes to open;\n\t\t\t\t<dd><strong>[watchpending]</strong> if set to \"p\" will email the address every time the status of the item changes to pending;\n\t\t\t\t<dd><strong>[watchclosed]</strong> if set to \"c\" will email the address every time the status of the item changes to closed;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an email address with option of making it active.\n\t\t\t\t<dt>Usage: <strong>link,watchopen,watchpending,watchclosed</strong>\n\t\t\t\t<dt>Example: 0,o\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[link]</strong> may be one of [0|1|2] and specifies how to display the email address, defaulting to 0 as plain text, 1 as an encoded hex mailto link, or 2 as a standard mailto link;\n\t\t\t\t<dd><strong>[watchopen]</strong> if set to \"o\" will email the address every time the status of the item changes to open;\n\t\t\t\t<dd><strong>[watchpending]</strong> if set to \"p\" will email the address every time the status of the item changes to pending;\n\t\t\t\t<dd><strong>[watchclosed]</strong> if set to \"c\" will email the address every time the status of the item changes to closed;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an url in a wiki syntax.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an url in a wiki syntax.\n\t\t\t\t</dl>",
// "multimedia" => "multimedia",
// "<dl>\n\t\t\t\t<dt>Function: Will play MP3 or FLV files, as specified, in a player.\n\t\t\t\t<dt>Usage: <strong>source,xSize,ySize</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[source]</strong> is one of [0|1|2|3|4|5] where 0 is default and will support a URL in the file gallery for MP3, 1 for URL in file gallery for FLV, 2 for URL in file gallery of either MP3 or FLV, 3 to upload an MP3 file to be played, 4 to upload an FLV file to be played, 5 to upload either an MP3 or FLV file;\n\t\t\t\t<dd><strong>[xSize]</strong> is the width in pixels of the player applet (default 200);\n\t\t\t\t<dd><strong>[ySize]</strong> is the height in pixels of the player applet (default 100);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dd>this is best-used as a tracker item that is not generally editable and you want a specific file played;\n\t\t\t\t\tedit the tracker item and provide the URL for the file you wish to play.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Will play MP3 or FLV files, as specified, in a player.\n\t\t\t\t<dt>Usage: <strong>source,xSize,ySize</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[source]</strong> is one of [0|1|2|3|4|5] where 0 is default and will support a URL in the file gallery for MP3, 1 for URL in file gallery for FLV, 2 for URL in file gallery of either MP3 or FLV, 3 to upload an MP3 file to be played, 4 to upload an FLV file to be played, 5 to upload either an MP3 or FLV file;\n\t\t\t\t<dd><strong>[xSize]</strong> is the width in pixels of the player applet (default 200);\n\t\t\t\t<dd><strong>[ySize]</strong> is the height in pixels of the player applet (default 100);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dd>this is best-used as a tracker item that is not generally editable and you want a specific file played;\n\t\t\t\t\tedit the tracker item and provide the URL for the file you wish to play.\n\t\t\t\t</dl>",
// "auto-increment" => "auto-increment",
// "<dl>\n\t\t\t\t<dt>Function: Allows an incrementing value field, or itemId field. (non-editable)\n\t\t\t\t<dt>Usage: <strong>start,prepend,append,itemId</strong>\n\t\t\t\t<dt>Example: 1,,,itemId\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[start]</strong> is the starting value for the field, defaults to 1;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed after the field;\n\t\t\t\t<dd><strong>[itemId]</strong> if set to \"itemId\" will set this field to match the value of the actual database itemId field value;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows an incrementing value field, or itemId field. (non-editable)\n\t\t\t\t<dt>Usage: <strong>start,prepend,append,itemId</strong>\n\t\t\t\t<dt>Example: 1,,,itemId\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[start]</strong> is the starting value for the field, defaults to 1;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed after the field;\n\t\t\t\t<dd><strong>[itemId]</strong> if set to \"itemId\" will set this field to match the value of the actual database itemId field value;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "user subscription" => "user subscription",
// "<dl>\n\t\t\t\t<dt>Function: Allow registered users to subscribe themselves to a tracker item (think Evite.com).\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Use this field as you would to have people sign up for an event. It is best if the tracker is only editable by its creator or the admin.  To set the max number of subscribers, edit the tracker item and put the number at the beginning of the field.\n\t\t\t\t<dt>Example:\n\t\t\t\t<dd>Old field may have \"#\" or \"#2[0]\" in it.  Making it \"20#2[0]\" will set the max number to 20.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allow registered users to subscribe themselves to a tracker item (think Evite.com).\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Use this field as you would to have people sign up for an event. It is best if the tracker is only editable by its creator or the admin.  To set the max number of subscribers, edit the tracker item and put the number at the beginning of the field.\n\t\t\t\t<dt>Example:\n\t\t\t\t<dd>Old field may have \"#\" or \"#2[0]\" in it.  Making it \"20#2[0]\" will set the max number to 20.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Use Google Maps.\n\t\t\t\t<dt>Will display a Google Maps around a point.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Use Google Maps.\n\t\t\t\t<dt>Will display a Google Maps around a point.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: System only.\n\t\t\t\t<dt>Usage: None\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Needs a description.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: System only.\n\t\t\t\t<dt>Usage: None\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Needs a description.\n\t\t\t\t</dl>",
// "computed field" => "computed field",
// "<dl>\n\t\t\t\t<dt>Function: Provides a computed value based on numeric field values.\n\t\t\t\t<dt>Usage: <strong>formula</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[formula]</strong> is the formula you wish to compute, using numeric values, operators \"+ - * / ( )\", and tracker fields identified with a leading #;\n\t\t\t\t<dt>Example: \"#3*(#4+5)\"\n\t\t\t\t<dd>adds the numeric value in item 4 by 5, and multiplies it by the numeric value in item 3.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a computed value based on numeric field values.\n\t\t\t\t<dt>Usage: <strong>formula</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[formula]</strong> is the formula you wish to compute, using numeric values, operators \"+ - * / ( )\", and tracker fields identified with a leading #;\n\t\t\t\t<dt>Example: \"#3*(#4+5)\"\n\t\t\t\t<dd>adds the numeric value in item 4 by 5, and multiplies it by the numeric value in item 3.\n\t\t\t\t</dl>",
// "user preference" => "user preference",
// "<dl>\n\t\t\t\t<dt>Function: Allows user preference changes from a tracker.\n\t\t\t\t<dt>Usage: <strong>type</strong>\n\t\t\t\t<dt>Example: password\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[type]</strong> if value is password, will allow to change the user password, if value is email, will display/allow to change the user email;\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows user preference changes from a tracker.\n\t\t\t\t<dt>Usage: <strong>type</strong>\n\t\t\t\t<dt>Example: password\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[type]</strong> if value is password, will allow to change the user password, if value is email, will display/allow to change the user email;\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a file to be attached to the tracker item.\n\t\t\t\t<dt>Usage: <strong>listview</strong>\n\t\t\t\t<dt>Example: nu\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[listview]</strong> may be one of [n|t|s|u|m] on their own or in any combination (n, t, ns, nts), allowing you to see the attachment in the item list view as its name (n), its type (t), its size (n), the username of the uploader (u), or the mediaplayer plugin(m);\n\t\t\t\tnote that this option will cost an extra query to the database for each attachment and can severely impact performance with several attachments.\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a file to be attached to the tracker item.\n\t\t\t\t<dt>Usage: <strong>listview</strong>\n\t\t\t\t<dt>Example: nu\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[listview]</strong> may be one of [n|t|s|u|m] on their own or in any combination (n, t, ns, nts), allowing you to see the attachment in the item list view as its name (n), its type (t), its size (n), the username of the uploader (u), or the mediaplayer plugin(m);\n\t\t\t\tnote that this option will cost an extra query to the database for each attachment and can severely impact performance with several attachments.\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "in group" => "in group",
// "<dl>\n\t\t\t\t<dt>Function: Allows to display if a item user is in a group and when he was assigned to the group (needs a user selector field)\n\t\t\t\t<dt>Usage: <strong>groupName,date</strong>\n\t\t\t\t<dt>Example: Members,date\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>GroupName</strong> Group to test. <strong>date</strong> displays the date the user was assigned in the group (if known), otherwise will display yes/no.\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows to display if a item user is in a group and when he was assigned to the group (needs a user selector field)\n\t\t\t\t<dt>Usage: <strong>groupName,date</strong>\n\t\t\t\t<dt>Example: Members,date\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>GroupName</strong> Group to test. <strong>date</strong> displays the date the user was assigned in the group (if known), otherwise will display yes/no.\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "The administrator has not yet validated your account. Please wait" => "The administrator has not yet validated your account. Please wait",
// "You must validate your account first. An email has been sent to you" => "You must validate your account first. An email has been sent to you",
// "The registration mail can't be sent because there is no server email address set, and this feature is disabled" => "The registration mail can't be sent because there is no server email address set, and this feature is disabled",
// "The user email confirmation can't be sent. Contact the administrator" => "The user email confirmation can't be sent. Contact the administrator",
// "Personal Phone" => "Personal Phone",
// "Personal Mobile" => "Personal Mobile",
// "Personal Fax" => "Personal Fax",
// "Work Phone" => "Work Phone",
// "Work Mobile" => "Work Mobile",
// "Work Fax" => "Work Fax",
// "Company" => "Company",
// "Organization" => "Organization",
// "Department" => "Department",
// "Division" => "Division",
// "Job Title" => "Job Title",
// "Street Address" => "Street Address",
// "City" => "City",
// "Zip Code" => "Zip Code",
// "Mailbox uninitialised??" => "Mailbox uninitialised??",
// "No mail body found" => "No mail body found",
// "User-Agent Info" => "User-Agent Info",
// "Displays various information about the client" => "Displays various information about the client",
// "Info required - IP|SVRSW|BROWSER" => "Info required - IP|SVRSW|BROWSER",
// "Anchor Link" => "Anchor Link",
// "Creates a link to an anchor within a page. Anchors can be created using the ANAME plugin" => "Creates a link to an anchor within a page. Anchors can be created using the ANAME plugin",
// "Anchor link label" => "Anchor link label",
// "The anchor name as defined in the ANAME plugin" => "The anchor name as defined in the ANAME plugin",
// "The name of the wiki page containing the anchor" => "The name of the wiki page containing the anchor",
// "Anchor Name" => "Anchor Name",
// "Inserts an anchor in the wiki page. Anchors can be linked to using the ALINK plugin" => "Inserts an anchor in the wiki page. Anchors can be linked to using the ALINK plugin",
// "The name of the anchor" => "The name of the anchor",
// "Image Annotation" => "Image Annotation",
// "Autogenerated content. Leave blank initially" => "Autogenerated content. Leave blank initially",
// "Absolute URL to the image or relative path from tikiwiki root" => "Absolute URL to the image or relative path from tikiwiki root",
// "Width" => "Width",
// "Image width" => "Image width",
// "Height" => "Height",
// "Image height" => "Image height",
// "Alignment" => "Alignment",
// "Image alignment. Possible values: left, right, center" => "Image alignment. Possible values: left, right, center",
// "Save changes to annotations" => "Save changes to annotations",
// "Image annotations changed" => "Image annotations changed",
// "Creates an annotation block for an image" => "Creates an annotation block for an image",
// "Displays an image and enables users to define zones to highlight information on the image" => "Displays an image and enables users to define zones to highlight information on the image",
// "Includes an article\\'s content within the page" => "Includes an article\\'s content within the page",
// "The article field to display. Default field is Heading" => "The article field to display. Default field is Heading",
// "Article ID" => "Article ID",
// "The article to display. If no value is provided, most recent article will be used" => "The article to display. If no value is provided, most recent article will be used",
// "Includes an article" => "Includes an article",
// "~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~" => "~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~",
// "Id is optional. If not given, last article is used. Default field is heading" => "Id is optional. If not given, last article is used. Default field is heading",
// "Article List" => "Article List",
// "Inserts a list of articles in the page" => "Inserts a list of articles in the page",
// "Articles displayed" => "Articles displayed",
// "The number of articles to display in the list" => "The number of articles to display in the list",
// "Topics expression" => "Topics expression",
// "Topic ID expression" => "Topic ID expression",
// "Type expression" => "Type expression",
// "Category ID" => "Category ID",
// "The ID of the category to list from" => "The ID of the category to list from",
// "The article language to list" => "The article language to list",
// "Sort order" => "Sort order",
// "The column and order of the sort in columnName_asc or columnName_desc format. Defaults to \"publishDate_desc\" (other column examples are \"title\", \"lang\", \"authorName\" & \"topicName\")" => "The column and order of the sort in columnName_asc or columnName_desc format. Defaults to \"publishDate_desc\" (other column examples are \"title\", \"lang\", \"authorName\" & \"topicName\")",
// "Quiet" => "Quiet",
// "Whether to not report when there are no articles" => "Whether to not report when there are no articles",
// "Title only" => "Title only",
// "Whether to only show the title of the articles" => "Whether to only show the title of the articles",
// "Show body" => "Show body",
// "Whether to only show the body of the articles or just the heading" => "Whether to only show the body of the articles or just the heading",
// "Starting article" => "Starting article",
// "The article number that the list should start with" => "The article number that the list should start with",
// "Earliest date to select articles from" => "Earliest date to select articles from",
// "End date" => "End date",
// "Latest date to select articles from" => "Latest date to select articles from",
// "Override Dates" => "Override Dates",
// "Whether obey article type\\'s \"show before publish\" and \"show after expiry\" settings" => "Whether obey article type\\'s \"show before publish\" and \"show after expiry\" settings",
// "Container class" => "Container class",
// "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_articles\")" => "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_articles\")",
// "Includes articles listing into a wiki page" => "Includes articles listing into a wiki page",
// "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc), quiet=>y|n, titleonly=>y|n}{ARTICLES}~/np~" => "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc), quiet=>y|n, titleonly=>y|n}{ARTICLES}~/np~",
// "Bullets" => "Bullets",
// "Inline" => "Inline",
// "Number" => "Number",
// "Show icon" => "Show icon",
// "Gives the name of the attached file to link to" => "Gives the name of the attached file to link to",
// "Same as name" => "Same as name",
// "Gives the name of another page the attached file is on. The file on that page is linked to instead. Only works with wiki pages" => "Gives the name of another page the attached file is on. The file on that page is linked to instead. Only works with wiki pages",
// "Shows the description as the link text instead of the file name" => "Shows the description as the link text instead of the file name",
// "Makes the list of attachments a bulleted list" => "Makes the list of attachments a bulleted list",
// "Says that this file is an image, and should be displayed inline using the img tag" => "Says that this file is an image, and should be displayed inline using the img tag",
// "Makes the text between the {ATTACH} tags the link text instead of the file name or description" => "Makes the text between the {ATTACH} tags the link text instead of the file name or description",
// "Shows all attachments from the whole wiki" => "Shows all attachments from the whole wiki",
// "Gives the number, in the list of attachments, of the attachment to link to" => "Gives the number, in the list of attachments, of the attachment to link to",
// "Gives the actual id of the attachment to link in. You probably should never use this" => "Gives the actual id of the attachment to link in. You probably should never use this",
// "Puts the number of downloads in the alt comment" => "Puts the number of downloads in the alt comment",
// "Shows a file icon" => "Shows a file icon",
// "The wiki page the avatar will link to" => "The wiki page the avatar will link to",
// "Float" => "Float",
// "left|right" => "left|right",
// "Displays a link that allows to go back in the browser history" => "Displays a link that allows to go back in the browser history",
// "Insert back link on wiki page" => "Insert back link on wiki page",
// "List all pages linking to the specified page" => "List all pages linking to the specified page",
// "The page links will point to. Default value is the current page" => "The page links will point to. Default value is the current page",
// "Displayed information" => "Displayed information",
// "Pipe separated list of fields to display. ex: hits|user" => "Pipe separated list of fields to display. ex: hits|user",
// "Excluded pages" => "Excluded pages",
// "Pipe separated list of pages to be excluded from the listing. ex: HomePage|Sandbox" => "Pipe separated list of pages to be excluded from the listing. ex: HomePage|Sandbox",
// "Include Self" => "Include Self",
// "1|0" => "1|0",
// "No Header" => "No Header",
// "Banner" => "Banner",
// "Insert a banner" => "Insert a banner",
// "Target" => "Target",
// "missing parameter" => "missing parameter",
// "Blog List" => "Blog List",
// "Use BLOGLIST to include posts from a blog" => "Use BLOGLIST to include posts from a blog",
// "Blog ID" => "Blog ID",
// "Numeric value" => "Numeric value",
// "Maximum number of entries to list" => "Maximum number of entries to list",
// "Simple list" => "Simple list",
// "Show simple list of date, title and author (default=y) or formatted list of blog posts (n)" => "Show simple list of date, title and author (default=y) or formatted list of blog posts (n)",
// "Earliest date to select posts from" => "Earliest date to select posts from",
// "Latest date to select posts from" => "Latest date to select posts from",
// "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_bloglist\")" => "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_bloglist\")",
// "Use BLOGLIST to include posts from a blog. Syntax is" => "Use BLOGLIST to include posts from a blog. Syntax is",
// "where Id is the blog Id and Items is the max number of posts to display" => "where Id is the blog Id and Items is the max number of posts to display",
// "Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~" => "Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~",
// "Box" => "Box",
// "Box title" => "Box title",
// "Displayed above the content" => "Displayed above the content",
// "Background color" => "Background color",
// "As defined by CSS, name or Hex code" => "As defined by CSS, name or Hex code",
// "Box width" => "Box width",
// "In pixels or percentage. Default value is 100%" => "In pixels or percentage. Default value is 100%",
// "Text Alignment" => "Text Alignment",
// "Float Position" => "Float Position",
// "for box with width less than 100%, make text wrap around the box" => "for box with width less than 100%, make text wrap around the box",
// "CSS Class" => "CSS Class",
// "Apply custom CSS class to the box" => "Apply custom CSS class to the box",
// "Includes a calendar and/or a list of calendar events" => "Includes a calendar and/or a list of calendar events",
// "Calendar filter" => "Calendar filter",
// "If set to a calendar identifier, restricts the events displayed to those in the specified calendar" => "If set to a calendar identifier, restricts the events displayed to those in the specified calendar",
// "View type" => "View type",
// "Determines how to show events" => "Determines how to show events",
// "Possible values" => "Possible values",
// "\"table\" shows events in a calendar" => "\"table\" shows events in a calendar",
// "Default value" => "Default value",
// "Calendar view type time span" => "Calendar view type time span",
// "If in calendar (or \"table\") view type, determines the time span displayed by the calendar" => "If in calendar (or \"table\") view type, determines the time span displayed by the calendar",
// "View the navigation bar" => "View the navigation bar",
// "Decide or not to show the navigation bar" => "Decide or not to show the navigation bar",
// "Includes a calendar" => "Includes a calendar",
// "~np~{CALENDAR(calendarId=>1)}{CALENDAR}" => "~np~{CALENDAR(calendarId=>1)}{CALENDAR}",
// "Id is optional. If not given, all calendars viewable by default are used" => "Id is optional. If not given, all calendars viewable by default are used",
// "Category IDs" => "Category IDs",
// "List of category IDs separated by + signs. ex: 1+2+3. Default will use category of the current page" => "List of category IDs separated by + signs. ex: 1+2+3. Default will use category of the current page",
// "Types" => "Types",
// "List of object types to include in the list separated by plus signs. ex: article+blog+faq+fgal+forum+igal+newsletter+event+poll+quiz+survey+tracker+wiki+img" => "List of object types to include in the list separated by plus signs. ex: article+blog+faq+fgal+forum+igal+newsletter+event+poll+quiz+survey+tracker+wiki+img",
// "Sort Order" => "Sort Order",
// "fieldName_asc|fieldName_desc, valid fields: type, created, name, hits, shuffle" => "fieldName_asc|fieldName_desc, valid fields: type, created, name, hits, shuffle",
// "Split" => "Split",
// "And" => "And",
// "With sub-categories" => "With sub-categories",
// "Show object name" => "Show object name",
// "Show type" => "Show type",
// "Incorrect param" => "Incorrect param",
// "Category Orphans" => "Category Orphans",
// "wiki|article|blog|faq|fgal|forum|igal|newsletter|poll|quizz|survey|tracker" => "wiki|article|blog|faq|fgal|forum|igal|newsletter|poll|quizz|survey|tracker",
// "Category Path" => "Category Path",
// "Separator" => "Separator",
// "String used to separate the categories in the path. Default character is >" => "String used to separate the categories in the path. Default character is >",
// "Display top category" => "Display top category",
// "yes|no, default to no" => "yes|no, default to no",
// "Displays a chart from TikiSheet. This plugin can be generated by the TikiSheet chart tool" => "Displays a chart from TikiSheet. This plugin can be generated by the TikiSheet chart tool",
// "Chart caption" => "Chart caption",
// "Sheet ID" => "Sheet ID",
// "Data sheet ID" => "Data sheet ID",
// "Chart Type" => "Chart Type",
// "BarStackGraphic|MultibarGraphic|MultilineGraphic|PieChartGraphic" => "BarStackGraphic|MultibarGraphic|MultilineGraphic|PieChartGraphic",
// "Chart Width" => "Chart Width",
// "Width in pixels" => "Width in pixels",
// "Chart Height" => "Chart Height",
// "Height in pixels" => "Height in pixels",
// "Value series" => "Value series",
// "Required for pie charts" => "Required for pie charts",
// "Independant series" => "Independant series",
// "Required for types other than pie chart" => "Required for types other than pie chart",
// "Dependant series" => "Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y2' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y2' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y3' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y3' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y4' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y4' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'color' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Colors" => "'),\n\t\t\t),\n\t\t\t'color' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Colors",
// "List of colors to use" => "List of colors to use",
// "Styles" => "Styles",
// "List of styles to use" => "List of styles to use",
// "Labels" => "Labels",
// "Labels for the series or values in the legend" => "Labels for the series or values in the legend",
// "Chart as PDF" => "Chart as PDF",
// "Chart as PostScript" => "Chart as PostScript",
// "Caption" => "Caption",
// "Code snippet label" => "Code snippet label",
// "Word Wrap" => "Word Wrap",
// "0|1, Enable word wrapping on the code to avoid breaking the layout" => "0|1, Enable word wrapping on the code to avoid breaking the layout",
// "Colors" => "Colors",
// "Syntax highlighting to use. May not be used with line numbers. Available: php, html, sql, javascript, css, java, c, doxygen, delphi, .." => "Syntax highlighting to use. May not be used with line numbers. Available: php, html, sql, javascript, css, java, c, doxygen, delphi, ..",
// "Line numbers" => "Line numbers",
// "0|1, may not be used with colors" => "0|1, may not be used with colors",
// "Wiki syntax" => "Wiki syntax",
// "0|1, parse wiki syntax within the code snippet" => "0|1, parse wiki syntax within the code snippet",
// "Right to left" => "Right to left",
// "0|1, switch the text display from left to right to right to left" => "0|1, switch the text display from left to right to right to left",
// "Content is HTML" => "Content is HTML",
// "0|1, display the content as is instead of escaping HTML special chars" => "0|1, display the content as is instead of escaping HTML special chars",
// "Includes content from the dynamic content system" => "Includes content from the dynamic content system",
// "Content ID" => "Content ID",
// "Also known as fortune cookies or taglines" => "Also known as fortune cookies or taglines",
// "Pattern to display the copyright in. May contain ~title~, ~year~ and ~authors~" => "Pattern to display the copyright in. May contain ~title~, ~year~ and ~authors~",
// "Countdown" => "Countdown",
// "Displays a countdown from now until the specified date" => "Displays a countdown from now until the specified date",
// "Text to append to the countdown" => "Text to append to the countdown",
// "Target date. Multiple formats accepted" => "Target date. Multiple formats accepted",
// "Locate Time" => "Locate Time",
// "on|off" => "on|off",
// "Items to show" => "Items to show",
// "Select: d=days, h=hours, m=minuts, s=seconds. Enter multiple values as: dhms. If blank, all items are shown" => "Select: d=days, h=hours, m=minuts, s=seconds. Enter multiple values as: dhms. If blank, all items are shown",
// "Show time since event" => "Show time since event",
// "If y, will display amount of time since the event (default). If n will simply display that the event is over" => "If y, will display amount of time since the event (default). If n will simply display that the event is over",
// "since " => "since ",
// "until " => "until ",
// " is over" => " is over",
// "Data Channel" => "Data Channel",
// "Displays a form to trigger data channels" => "Displays a form to trigger data channels",
// "List of fields to display. One field per line. Comma delimited: fieldname,label" => "List of fields to display. One field per line. Comma delimited: fieldname,label",
// "Channel Name" => "Channel Name",
// "Name of the channel as registered by the administrator" => "Name of the channel as registered by the administrator",
// "DBReport" => "DBReport",
// "Run a database report" => "Run a database report",
// "report definition" => "report definition",
// "Full DSN" => "Full DSN",
// "A full DSN (Data Source Name) connection string. eg: mysql://user:pass@server/database" => "A full DSN (Data Source Name) connection string. eg: mysql://user:pass@server/database",
// "Wiki DSN name" => "Wiki DSN name",
// "The name of a DSN connection defined by the Wiki administrator" => "The name of a DSN connection defined by the Wiki administrator",
// "0|1, parse wiki syntax within the report" => "0|1, parse wiki syntax within the report",
// "Debug" => "Debug",
// "0|1, display the parsed report definition" => "0|1, display the parsed report definition",
// "Missing db or dsn parameter" => "Missing db or dsn parameter",
// "You do not have permission to use this DSN" => "You do not have permission to use this DSN",
// "No DSN connection string found" => "No DSN connection string found",
// "Div" => "Div",
// "div|span|pre|b|i|tt|p|blockquote" => "div|span|pre|b|i|tt|p|blockquote",
// "Span" => "Span",
// "Teletype" => "Teletype",
// "Paragraph" => "Paragraph",
// "Block quote" => "Block quote",
// "left|right|center|justify" => "left|right|center|justify",
// "Justify" => "Justify",
// "Float position" => "Float position",
// "left|right, for box with width less than 100%, make text wrap around the box" => "left|right, for box with width less than 100%, make text wrap around the box",
// "Determine how other elements can wrap around the element" => "Determine how other elements can wrap around the element",
// "Apply custom CSS class to the div" => "Apply custom CSS class to the div",
// "HTML id" => "HTML id",
// "Sets the div\\'s id attribute, as defined by HTML" => "Sets the div\\'s id attribute, as defined by HTML",
// "Insert a division block, span, blockquote or other text formatting on wiki page" => "Insert a division block, span, blockquote or other text formatting on wiki page",
// "Definition List" => "Definition List",
// "One entry per line. Each line is in \"Term: Definition\" format" => "One entry per line. Each line is in \"Term: Definition\" format",
// "Equation" => "Equation",
// "Renders an equation written in LaTeX syntax as an image" => "Renders an equation written in LaTeX syntax as an image",
// "equation" => "equation",
// "Percentage of increase from normal size. 100 produces the default size. 200 produces an image twice as large" => "Percentage of increase from normal size. 100 produces the default size. 200 produces an image twice as large",
// "Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size" => "Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size",
// "Includes the list of events from a calendar in the page" => "Includes the list of events from a calendar in the page",
// "Calendar ID" => "Calendar ID",
// "Numeric" => "Numeric",
// "Maximum days" => "Maximum days",
// "Maximum Rows" => "Maximum Rows",
// "Datetime" => "Datetime",
// "0|1" => "0|1",
// "~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insert rss feed output into a wikipage" => "~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insert rss feed output into a wikipage",
// "Fade" => "Fade",
// "Displays a label. On click, the block of content will fade in and fade out" => "Displays a label. On click, the block of content will fade in and fade out",
// "Wiki syntax containing the text to display" => "Wiki syntax containing the text to display",
// "Label to display on first display" => "Label to display on first display",
// "Unspecified label" => "Unspecified label",
// "Fancy List" => "Fancy List",
// "One item per line starting with anything followed by \")\"" => "One item per line starting with anything followed by \")\"",
// "Use div" => "Use div",
// "Use div instead of ol" => "Use div instead of ol",
// "Class" => "Class",
// "CSS class for the fancylist" => "CSS class for the fancylist",
// "Creates a fancy-looking list" => "Creates a fancy-looking list",
// "num" => "num",
// "item text" => "item text",
// "one item per line" => "one item per line",
// "Fancy Table" => "Fancy Table",
// "Rows separated by >> in the header; for the table body, one row per line. Cells separated by | in both cases" => "Rows separated by >> in the header; for the table body, one row per line. Cells separated by | in both cases",
// "Heading row" => "Heading row",
// "Header rows of the table. Use >> to separate multiple rows" => "Header rows of the table. Use >> to separate multiple rows",
// "Heading CSS class" => "Heading CSS class",
// "CSS class to apply to the heading row" => "CSS class to apply to the heading row",
// "Header horizontal align" => "Header horizontal align",
// "Horizonatal alignments for header cells separated by |. Choices: left, right, center, justify" => "Horizonatal alignments for header cells separated by |. Choices: left, right, center, justify",
// "Header vertical align" => "Header vertical align",
// "Vertical alignments for header cells separated by |. Choices: top, middle, bottom, baseline" => "Vertical alignments for header cells separated by |. Choices: top, middle, bottom, baseline",
// "Column sort" => "Column sort",
// "Pre-sorted columns" => "Pre-sorted columns",
// "Bracketed numbers for column number and sort direction (0 = ascending, 1 = descending), for example: [0,0],[1,0]" => "Bracketed numbers for column number and sort direction (0 = ascending, 1 = descending), for example: [0,0],[1,0]",
// "Column widths" => "Column widths",
// "Column widths followed by px for pixels or % for percentages. Each column separated by |" => "Column widths followed by px for pixels or % for percentages. Each column separated by |",
// "Cell horizontal align" => "Cell horizontal align",
// "Table body column horizonatal alignments separated by |. Choices: left, right, center, justify" => "Table body column horizonatal alignments separated by |. Choices: left, right, center, justify",
// "Cell vertical align" => "Cell vertical align",
// "Table body column vertical alignments separated by |. Choices: top, middle, bottom, baseline" => "Table body column vertical alignments separated by |. Choices: top, middle, bottom, baseline",
// "The feature must be activated" => "The feature must be activated",
// "heads and cells separated by |" => "heads and cells separated by |",
// "Displays a link to an attachment to a wiki page and can display an image attachment. " => "Displays a link to an attachment to a wiki page and can display an image attachment. ",
// "Gallery ID" => "Gallery ID",
// "name_asc" => "name_asc",
// "Shows ID" => "Shows ID",
// "Shows Icon" => "Shows Icon",
// "Shows Name" => "Shows Name",
// "Shows Filename" => "Shows Filename",
// "Shows Size" => "Shows Size",
// "Shows Description" => "Shows Description",
// "Shows Creation Date" => "Shows Creation Date",
// "Shows Hits" => "Shows Hits",
// "Shows Locked by" => "Shows Locked by",
// "Shows Modification Date" => "Shows Modification Date",
// "Shows Author" => "Shows Author",
// "Shows Creator" => "Shows Creator",
// "Shows Parent Gallery Name" => "Shows Parent Gallery Name",
// "Shows Number of Files" => "Shows Number of Files",
// "Shows the slideshow of a gallery" => "Shows the slideshow of a gallery",
// "List files in a file gallery (with a category) or in a category or a file gallery od this category" => "List files in a file gallery (with a category) or in a category or a file gallery od this category",
// "Displays a list of files from the File Gallery" => "Displays a list of files from the File Gallery",
// "Flash video" => "Flash video",
// "Movie URL" => "Movie URL",
// "Complete URL to the movie to include. e.g. files/test.swf" => "Complete URL to the movie to include. e.g. files/test.swf",
// "Default width: 425" => "Default width: 425",
// "Default height: 350" => "Default height: 350",
// "Quality" => "Quality",
// "Flash video quality. Default value: high" => "Flash video quality. Default value: high",
// "Missing parameter movie to the plugin flash" => "Missing parameter movie to the plugin flash",
// "Footnote" => "Footnote",
// "Inserts a superscripted footnote number next to text and takes in footnote as parameter" => "Inserts a superscripted footnote number next to text and takes in footnote as parameter",
// "The footnote" => "The footnote",
// "Footnotearea" => "Footnotearea",
// "Inserts a section for collected footnotes in the wiki page" => "Inserts a section for collected footnotes in the wiki page",
// "Download box for a file on ftp server" => "Download box for a file on ftp server",
// "ftp" => "ftp",
// "file name" => "file name",
// "Ftp Server Name" => "Ftp Server Name",
// "Ftp User name" => "Ftp User name",
// "Ftp password" => "Ftp password",
// "Download button label" => "Download button label",
// "missing parameters" => "missing parameters",
// "Connection failed" => "Connection failed",
// "Gauge" => "Gauge",
// "Displays a graphical gauge" => "Displays a graphical gauge",
// "current value (REQUIRED)" => "current value (REQUIRED)",
// "Maximum Value" => "Maximum Value",
// "Maximum possible value. Default: 100" => "Maximum possible value. Default: 100",
// "Label displayed on the left side of the gauge" => "Label displayed on the left side of the gauge",
// "Color" => "Color",
// "Bar width in pixels" => "Bar width in pixels",
// "Label Width" => "Label Width",
// "Width in pixels allocated to the label" => "Width in pixels allocated to the label",
// "Display Percentage" => "Display Percentage",
// "true|false, if true then a percentage of the maximum is displayed" => "true|false, if true then a percentage of the maximum is displayed",
// "Display Value" => "Display Value",
// "true|false, if the numeric value is displayed" => "true|false, if the numeric value is displayed",
// "Bar height in pixels" => "Bar height in pixels",
// "Google Analytics" => "Google Analytics",
// "Add the tracking code for Google Analytics" => "Add the tracking code for Google Analytics",
// "Account number" => "Account number",
// "The account number for the site" => "The account number for the site",
// "Missing parameter" => "Missing parameter",
// "googledoc" => "googledoc",
// "Leave this empty" => "Leave this empty",
// "Type of Google document" => "Type of Google document",
// "key" => "key",
// "Google doc key - for example: pXsHENf1bGGY92X1iEeJJI" => "Google doc key - for example: pXsHENf1bGGY92X1iEeJJI",
// "Name of iframe" => "Name of iframe",
// "Size of frame, use instead of width and height, they will fit the Google presentations sizes exactly. It can be small|medium|large" => "Size of frame, use instead of width and height, they will fit the Google presentations sizes exactly. It can be small|medium|large",
// "Pixels or %" => "Pixels or %",
// "Margin Height" => "Margin Height",
// "Pixels" => "Pixels",
// "Margin Width" => "Margin Width",
// "Scrolling" => "Scrolling",
// "editLink" => "editLink",
// "Required parameter \"type\" missing" => "Required parameter \"type\" missing",
// "Required parameter \"key\" missing" => "Required parameter \"key\" missing",
// "Displays a Google document" => "Displays a Google document",
// "Wiki text to display if conditions are met. The body may contain {ELSE}. Text after the marker will be displayed to users not matching the condition" => "Wiki text to display if conditions are met. The body may contain {ELSE}. Text after the marker will be displayed to users not matching the condition",
// "Allowed User Friends" => "Allowed User Friends",
// "Pipe separated list of users whose friends are allowed to view the block. ex: admin|johndoe|foo" => "Pipe separated list of users whose friends are allowed to view the block. ex: admin|johndoe|foo",
// "Allowed Groups" => "Allowed Groups",
// "Pipe separated list of groups allowed to view the block. ex: Admins|Developers" => "Pipe separated list of groups allowed to view the block. ex: Admins|Developers",
// "Denied Groups" => "Denied Groups",
// "Pipe separated list of groups denied from viewing the block. ex: Anonymous|Managers" => "Pipe separated list of groups denied from viewing the block. ex: Anonymous|Managers",
// "Display wiki text if user is in one of listed groups or group of friends" => "Display wiki text if user is in one of listed groups or group of friends",
// "GroupMailCore" => "GroupMailCore",
// "Displays GroupMail functions on a wiki page. Usually set up using a plugin alias created by the GroupMail profile" => "Displays GroupMail functions on a wiki page. Usually set up using a plugin alias created by the GroupMail profile",
// "From Email" => "From Email",
// "Email address to report" => "Email address to report",
// "Tracker Id" => "Tracker Id",
// "Id of GroupMail Logs tracker (set up in alias by profile)" => "Id of GroupMail Logs tracker (set up in alias by profile)",
// "From Field Id" => "From Field Id",
// "Id of GroupMail Logs tracker field (usually set up in alias by profile)" => "Id of GroupMail Logs tracker field (usually set up in alias by profile)",
// "operator Field Id" => "operator Field Id",
// "subject Field Id" => "subject Field Id",
// "message Field Id" => "message Field Id",
// "content Field Id" => "content Field Id",
// "account Field Id" => "account Field Id",
// "datetime Field Id" => "datetime Field Id",
// "Displays GroupMail functions on a wiki page" => "Displays GroupMail functions on a wiki page",
// "Group Stats" => "Group Stats",
// "Groups separated by " => "Groups separated by ",
// "Show Percentage" => "Show Percentage",
// "Show Bar" => "Show Bar",
// "Displays some stat about group belonging" => "Displays some stat about group belonging",
// "HTML" => "HTML",
// "Include literal HTML in a Wiki page" => "Include literal HTML in a Wiki page",
// "0|1, parse wiki syntax within the html code" => "0|1, parse wiki syntax within the html code",
// "Include literal HTML" => "Include literal HTML",
// "Iframe" => "Iframe",
// "Frame title" => "Frame title",
// "iframe" => "iframe",
// "Displays an iframe" => "Displays an iframe",
// " (experimental - possible successor to img in 5.0)" => " (experimental - possible successor to img in 5.0)",
// "File ID" => "File ID",
// "Numeric ID of an image in a File Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required" => "Numeric ID of an image in a File Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required",
// "Numeric ID of an image in an Image Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required" => "Numeric ID of an image in an Image Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required",
// "Image Source" => "Image Source",
// "Full URL to the image to display. \"fileId\", \"id\" or \"src\" required" => "Full URL to the image to display. \"fileId\", \"id\" or \"src\" required",
// "Maximum height or width in pixels (largest dimension is scaled).\tIf no scalesize is given one will be attempted from default or given height or width.  If scale does not match a defined scale for the gallery the full sized image is downloaded" => "Maximum height or width in pixels (largest dimension is scaled).\tIf no scalesize is given one will be attempted from default or given height or width.  If scale does not match a defined scale for the gallery the full sized image is downloaded",
// "Alias: lnk. Location the image should point to" => "Alias: lnk. Location the image should point to",
// "Link Relation" => "Link Relation",
// "\"rel\" attribute to add to the link" => "\"rel\" attribute to add to the link",
// "Link title" => "Link title",
// "Title text" => "Title text",
// "Image alt text" => "Image alt text",
// "Alternate text to display if impossible to load the image" => "Alternate text to display if impossible to load the image",
// "Alias:imalign. Image alignment in the page. (left, right)" => "Alias:imalign. Image alignment in the page. (left, right)",
// "Whether to block items from flowing next to image from the top or bottom. (top,bottom,both,none)" => "Whether to block items from flowing next to image from the top or bottom. (top,bottom,both,none)",
// "Image description to display on the page" => "Image description to display on the page",
// "Image Map" => "Image Map",
// "Name of the image map to use for the image" => "Name of the image map to use for the image",
// "CSS class to apply to the image'.\"'\".'s img tag. (Usually used in configuration rather than on individual images.)" => "CSS class to apply to the image'.\"'\".'s img tag. (Usually used in configuration rather than on individual images.)",
// "CSS Style" => "CSS Style",
// "CSS styling to apply to the plugin (usually used in configuration rather than on individual images)" => "CSS styling to apply to the plugin (usually used in configuration rather than on individual images)",
// "Border options" => "Border options",
// "Border configuration.  Values \"on\" and \"off\" control visibility, or else specify CSS styling options" => "Border configuration.  Values \"on\" and \"off\" control visibility, or else specify CSS styling options",
// "Description options" => "Description options",
// "Description configuration.\tValues \"on\" and \"off\" control visibility, or else specify CSS styling options. (Usually used in configuration rather than on individual images.)" => "Description configuration.\tValues \"on\" and \"off\" control visibility, or else specify CSS styling options. (Usually used in configuration rather than on individual images.)",
// "Default configuration" => "Default configuration",
// "Default configuration definitions. (Usually used in configuration rather than on individual images.)" => "Default configuration definitions. (Usually used in configuration rather than on individual images.)",
// "Mandatory configuration" => "Mandatory configuration",
// "Mandatory configuration definitions. (Usually used in configuration rather than on individual images.)" => "Mandatory configuration definitions. (Usually used in configuration rather than on individual images.)",
// "Display an image using configured format. Allows presentation of all images to be changed without having to alter existing content" => "Display an image using configured format. Allows presentation of all images to be changed without having to alter existing content",
// "Display an image" => "Display an image",
// "Display images" => "Display images",
// "Image source" => "Image source",
// "Full URL to the image to display. \"id\", \"fileId\", \"attId\" or \"src\" required" => "Full URL to the image to display. \"id\", \"fileId\", \"attId\" or \"src\" required",
// "Numeric ID of an image in an Image Gallery (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required" => "Numeric ID of an image in an Image Gallery (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required",
// "Numeric ID of an image in a File Gallery (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required" => "Numeric ID of an image in a File Gallery (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required",
// "Attachment ID" => "Attachment ID",
// "Numeric ID of an image attached to a wiki page (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required" => "Numeric ID of an image attached to a wiki page (or comma-separated list). \"id\", \"fileId\", \"attId\" or \"src\" required",
// "Makes the image a thumbnail that enlarges to full size when clicked or moused over (unless \"link\" is set to another target). \"browse\" and \"browsepopup\" only work with image gallery and \"download\" only works with file gallery" => "Makes the image a thumbnail that enlarges to full size when clicked or moused over (unless \"link\" is set to another target). \"browse\" and \"browsepopup\" only work with image gallery and \"download\" only works with file gallery",
// "Full size image appears when thumbnail is clicked" => "Full size image appears when thumbnail is clicked",
// "Mouseover" => "Mouseover",
// "Full size image will pop up while cursor is over the thumbnail (and disappear when not)" => "Full size image will pop up while cursor is over the thumbnail (and disappear when not)",
// "Mouseover (Sticky)" => "Mouseover (Sticky)",
// "Full size image will pop up once cursor passes over thumbnail and will remain up unless cursor passes over full size popup" => "Full size image will pop up once cursor passes over thumbnail and will remain up unless cursor passes over full size popup",
// "Popup" => "Popup",
// "Full size image will open in a separate winow or tab (depending on browser settings) when thumbnail is clicked" => "Full size image will open in a separate winow or tab (depending on browser settings) when thumbnail is clicked",
// "Image gallery browse window for the image will open when the thumbnail is clicked if the image is in a Tiki image gallery" => "Image gallery browse window for the image will open when the thumbnail is clicked if the image is in a Tiki image gallery",
// "Browse Popup" => "Browse Popup",
// "Same as \"browse\" except that the page opens in a new window or tab" => "Same as \"browse\" except that the page opens in a new window or tab",
// "Download dialog box will appear for file gallery images when thumbnail is clicked" => "Download dialog box will appear for file gallery images when thumbnail is clicked",
// "Enlarge button" => "Enlarge button",
// "Button for enlarging image" => "Button for enlarging image",
// "Enter a url to the address the image should link to. Not needed if thumb parameter is set; overrides thumb setting" => "Enter a url to the address the image should link to. Not needed if thumb parameter is set; overrides thumb setting",
// "Link relation" => "Link relation",
// "Enter \"box\" for colorbox effect (like shadowbox and lightbox) or appropriate syntax for link relation" => "Enter \"box\" for colorbox effect (like shadowbox and lightbox) or appropriate syntax for link relation",
// "Image map" => "Image map",
// "Maximum image size" => "Maximum image size",
// "Maximum height or width in pixels (largest dimension is scaled). Overrides height and width settings" => "Maximum height or width in pixels (largest dimension is scaled). Overrides height and width settings",
// "Align image" => "Align image",
// "Aligns the image itself. If the image is inside a box (because of other settings), use the align parameter to align the box" => "Aligns the image itself. If the image is inside a box (because of other settings), use the align parameter to align the box",
// "Image style" => "Image style",
// "Enter \"border\" to place a dark gray border around the image. Otherwise enter CSS styling syntax for other style effects" => "Enter \"border\" to place a dark gray border around the image. Otherwise enter CSS styling syntax for other style effects",
// "Align image block" => "Align image block",
// "Aligns the box containing the image" => "Aligns the box containing the image",
// "Image block style" => "Image block style",
// "Enter \"border\" to place a dark gray border frame around the image. Otherwise enter CSS styling syntax for other style effects" => "Enter \"border\" to place a dark gray border frame around the image. Otherwise enter CSS styling syntax for other style effects",
// "Description style" => "Description style",
// "Enter \"right\" or \"left\" to align text accordingly. Otherwise enter CSS styling syntax for other style effects" => "Enter \"right\" or \"left\" to align text accordingly. Otherwise enter CSS styling syntax for other style effects",
// "Wrapping control" => "Wrapping control",
// "Control how other items wrap around the image" => "Control how other items wrap around the image",
// "CSS class" => "CSS class",
// "CSS class to apply to the image" => "CSS class to apply to the image",
// "Image caption. \"desc\" or \"name\" for tiki images, \"idesc\" or \"ititle\" for iptc data, otherwise enter your own description" => "Image caption. \"desc\" or \"name\" for tiki images, \"idesc\" or \"ititle\" for iptc data, otherwise enter your own description",
// "Alternate text" => "Alternate text",
// "Alternate text that displays when image does not load" => "Alternate text that displays when image does not load",
// "Default config settings" => "Default config settings",
// "Default configuration settings (usually set by admin)" => "Default configuration settings (usually set by admin)",
// "Mandatory admin setting" => "Mandatory admin setting",
// "Mandatory configuration settings (usually set by admin)" => "Mandatory configuration settings (usually set by admin)",
// "File is not an image" => "File is not an image",
// "Server does not support image manipulation" => "Server does not support image manipulation",
// "''No image specified. Either the fileId, attId, id, or src parameter must be specified.''" => "''No image specified. Either the fileId, attId, id, or src parameter must be specified.''",
// "''Use one and only one of the following parameters: fileId, attId, id, or src.''" => "''Use one and only one of the following parameters: fileId, attId, id, or src.''",
// "Include a page\\'s content" => "Include a page\\'s content",
// "Page Name" => "Page Name",
// "Wiki page name to include" => "Wiki page name to include",
// "When only a portion of the page should be included, specify the marker from which inclusion should start" => "When only a portion of the page should be included, specify the marker from which inclusion should start",
// "When only a portion of the page should be included, specify the marker at which inclusion should end" => "When only a portion of the page should be included, specify the marker at which inclusion should end",
// "Invite" => "Invite",
// "Invite an email in groups" => "Invite an email in groups",
// "Confirmation message after posting form" => "Confirmation message after posting form",
// "Including group" => "Including group",
// "Default group" => "Default group",
// "Group from the item group selector / creator field" => "Group from the item group selector / creator field",
// "Jabber" => "Jabber",
// "Runs a Java applet to access a local Jabber service" => "Runs a Java applet to access a local Jabber service",
// "Applet height in pixels" => "Applet height in pixels",
// "'),\n\t\t\t\t'description' => tra('Applet width in pixels" => "'),\n\t\t\t\t'description' => tra('Applet width in pixels",
// "'),\n\t\t\t\t'description' => tra('jabber.org" => "'),\n\t\t\t\t'description' => tra('jabber.org",
// "Default Color" => "Default Color",
// "255,255,255" => "255,255,255",
// "JQuery" => "JQuery",
// "Insert JQuery javascript code. Requires feature_jquery" => "Insert JQuery javascript code. Requires feature_jquery",
// " (experimental - may change in future versions)" => " (experimental - may change in future versions)",
// "JQuery Code" => "JQuery Code",
// "NotOnReady" => "NotOnReady",
// "NoJQuery" => "NoJQuery",
// "Optional markup for when feature_jquery is off" => "Optional markup for when feature_jquery is off",
// "Insert JQuery javascript code" => "Insert JQuery javascript code",
// "jquery code e.g. \$jq(\"img\\" => "jquery code e.g. \$jq(\"img\\",
// "Do not execute on document ready (execute inline)" => "Do not execute on document ready (execute inline)",
// "Javascript" => "Javascript",
// "Javascript filename" => "Javascript filename",
// "Kaltura video" => "Kaltura video",
// "Displays a KALTURA video on the wiki page" => "Displays a KALTURA video on the wiki page",
// "Kaltura Entry Id" => "Kaltura Entry Id",
// "List of languages for which the block is displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs" => "List of languages for which the block is displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs",
// "Not Language" => "Not Language",
// "List of languages for which the block is not displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs" => "List of languages for which the block is not displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs",
// "Page name to display information of. Default value is current page" => "Page name to display information of. Default value is current page",
// "The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given" => "The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given",
// "Result Offset" => "Result Offset",
// "Result number at which the listing should start" => "Result number at which the listing should start",
// "Result Count" => "Result Count",
// "Number of results displayed in the list" => "Number of results displayed in the list",
// "Initial" => "Initial",
// "txt" => "txt",
// "Show Name Only" => "Show Name Only",
// "Structure Head" => "Structure Head",
// "Show Page Alias" => "Show Page Alias",
// "Two letter language code to filter pages listed" => "Two letter language code to filter pages listed",
// "Orphan Language" => "Orphan Language",
// "Two letter language code to filter pages listed. Only pages not available in the provided language will be listed" => "Two letter language code to filter pages listed. Only pages not available in the provided language will be listed",
// "Load Translations" => "Load Translations",
// "user or pipe separated list of two letter language codes for additional languages to display. If the language parameter is not defined, the first element of this list will be used as the primary filter" => "user or pipe separated list of two letter language codes for additional languages to display. If the language parameter is not defined, the first element of this list will be used as the primary filter",
// "Exact Match" => "Exact Match",
// "Related to Find" => "Related to Find",
// "Only Orphan Pages" => "Only Orphan Pages",
// "For List Pages" => "For List Pages",
// "List Progress" => "List Progress",
// "Indicates the internationalization progress of the page list" => "Indicates the internationalization progress of the page list",
// "List Name" => "List Name",
// "Name of the list as configured in the page list admin panel" => "Name of the list as configured in the page list admin panel",
// "Limit" => "Limit",
// "Maximum amount of results to display" => "Maximum amount of results to display",
// "Filter to apply to the page list" => "Filter to apply to the page list",
// "Score Limit" => "Score Limit",
// "Value used as the denominator for the score" => "Value used as the denominator for the score",
// "List Directory" => "List Directory",
// "Full path to the server-local directory" => "Full path to the server-local directory",
// "URL Prefix" => "URL Prefix",
// ".ext" => ".ext",
// "Maximum amount of files to display" => "Maximum amount of files to display",
// "Map File" => "Map File",
// "Extents" => "Extents",
// "Mayan Calendars Info" => "Mayan Calendars Info",
// "Convert date from Gregorian to Mayan Calendars: Tzolkin, Haab, Long Count" => "Convert date from Gregorian to Mayan Calendars: Tzolkin, Haab, Long Count",
// "You must use the variable substitution.<br/>'.\n                             'LongCount: %baktun%, %katun%, %tun%, %winal%, %kin%;<br/>'.\n                             'Tzolkin: %tzolkin13%, %tzolkin20%, %tzolkin20name%;<br/>'.\n                             'Haab: %haabkin%, %haabwinal%, %haabwinalname%;<br/>'.\n                             'Misc: %longkin%, %julianday%.<br/><br/>'.\n                             'Example: template \"%baktun%.%katun%.%tun%.%winal%.%kin%, %tzolkin13% %tzolkin20name%, %haabkin% %haabwinalname%\" for 22.05.2009 will return 12.19.16.6.11, 8 CHUEN, 9 SIP.<br/>'.\n                             'Default template: %baktun%.%katun%.%tun%.%winal%.%kin% %tzolkin13% %tzolkin20name% %haabkin% %haabwinalname%" => "You must use the variable substitution.<br/>'.\n                             'LongCount: %baktun%, %katun%, %tun%, %winal%, %kin%;<br/>'.\n                             'Tzolkin: %tzolkin13%, %tzolkin20%, %tzolkin20name%;<br/>'.\n                             'Haab: %haabkin%, %haabwinal%, %haabwinalname%;<br/>'.\n                             'Misc: %longkin%, %julianday%.<br/><br/>'.\n                             'Example: template \"%baktun%.%katun%.%tun%.%winal%.%kin%, %tzolkin13% %tzolkin20name%, %haabkin% %haabwinalname%\" for 22.05.2009 will return 12.19.16.6.11, 8 CHUEN, 9 SIP.<br/>'.\n                             'Default template: %baktun%.%katun%.%tun%.%winal%.%kin% %tzolkin13% %tzolkin20name% %haabkin% %haabwinalname%",
// "Gregorian date" => "Gregorian date",
// "Gregorian date for convert. Format: DD.MM.YYYY. Default: Today date" => "Gregorian date for convert. Format: DD.MM.YYYY. Default: Today date",
// "Mayan Calendars" => "Mayan Calendars",
// " is not a valid date format. should be dd.mm.yyyy" => " is not a valid date format. should be dd.mm.yyyy",
// "Inline Flash mp3 and flv Player" => "Inline Flash mp3 and flv Player",
// "Mediaplayer" => "Mediaplayer",
// "MP3 URL" => "MP3 URL",
// "Complete URL to the mp3 to include" => "Complete URL to the mp3 to include",
// "FLV URL" => "FLV URL",
// "Complete URL to the flv to include" => "Complete URL to the flv to include",
// "One of" => "One of",
// "Member List" => "Member List",
// "Lists the members of selected groups and allows to add or remove members if permissions are granted" => "Lists the members of selected groups and allows to add or remove members if permissions are granted",
// "List of groups to handle through the interface. Colon separated" => "List of groups to handle through the interface. Colon separated",
// "Mini Quiz" => "Mini Quiz",
// "Displays a miniquiz" => "Displays a miniquiz",
// "Instructions::Feedback" => "Instructions::Feedback",
// "Tracker ID" => "Tracker ID",
// "Insert Module" => "Insert Module",
// "Module name as known in Tikiwiki" => "Module name as known in Tikiwiki",
// "Decoration" => "Decoration",
// "Max" => "Max",
// "np" => "np",
// "notitle" => "notitle",
// "Displays a module inline in a wiki page. More parameters can be added, not supported by UI" => "Displays a module inline in a wiki page. More parameters can be added, not supported by UI",
// "Monospace" => "Monospace",
// "Font name as known in browsers" => "Font name as known in browsers",
// "Create a mouseover feature on some text" => "Create a mouseover feature on some text",
// "Mouseover text if param label exists. Page text if text param exists" => "Mouseover text if param label exists. Page text if text param exists",
// "Text displayed on the page. The body is the mouseover content" => "Text displayed on the page. The body is the mouseover content",
// "Destination link when mouseover text is clicked. Use http:// for external links" => "Destination link when mouseover text is clicked. Use http:// for external links",
// "DEPRECATED" => "DEPRECATED",
// "Text displayed on the mouseover. The body contains the text of the page" => "Text displayed on the mouseover. The body contains the text of the page",
// "Mouseover box width. Default: 400px" => "Mouseover box width. Default: 400px",
// "Mouseover box height. Default: 200px" => "Mouseover box height. Default: 200px",
// "Offset X" => "Offset X",
// "Shifts the overlay to the right by the specified number of pixels relative to the cursor. Default: 5px" => "Shifts the overlay to the right by the specified number of pixels relative to the cursor. Default: 5px",
// "Offset Y" => "Offset Y",
// "Shifts the overlay lower by the specified number of pixels relative to the cursor. Default: 0px" => "Shifts the overlay lower by the specified number of pixels relative to the cursor. Default: 0px",
// "Parse Body" => "Parse Body",
// "y|n, parse the body of the plugin as wiki content. (Default to y)" => "y|n, parse the body of the plugin as wiki content. (Default to y)",
// "Background color of the popup" => "Background color of the popup",
// "'),\n\t\t\t\t'filter' => 'striptags" => "'),\n\t\t\t\t'filter' => 'striptags",
// "Text color in the popup" => "Text color in the popup",
// "Padding" => "Padding",
// "Effect" => "Effect",
// "Effect speed" => "Effect speed",
// "No label specified" => "No label specified",
// "MWTable" => "MWTable",
// "fancy" => "fancy",
// "true|false" => "true|false",
// "wiki_classes" => "wiki_classes",
// "Displays the data using (sort of) MediaWiki syntax" => "Displays the data using (sort of) MediaWiki syntax",
// "Displays a table using MediaWiki syntax" => "Displays a table using MediaWiki syntax",
// "MySpace" => "MySpace",
// "MySpace Page" => "MySpace Page",
// "Displays a MySpace Flash mp3 playlist in the wiki page" => "Displays a MySpace Flash mp3 playlist in the wiki page",
// "Object Hits" => "Object Hits",
// "Object ID" => "Object ID",
// "Object Type" => "Object Type",
// "List pages part of a named list" => "List pages part of a named list",
// "Offset" => "Offset",
// "Pagination start element" => "Pagination start element",
// "list parameter missing or doesn\\'t exist" => "list parameter missing or doesn\\'t exist",
// "% of page hits" => "% of page hits",
// "Page Hits" => "Page Hits",
// "Search for images uploaded by users" => "Search for images uploaded by users",
// " (deprecated - scheduled to be removed or changed significantly)" => " (deprecated - scheduled to be removed or changed significantly)",
// "Filename or full path to file" => "Filename or full path to file",
// "Plugin Manager" => "Plugin Manager",
// "Multiple values separated with | can be used" => "Multiple values separated with | can be used",
// "Poll ID" => "Poll ID",
// "Profile Installer" => "Profile Installer",
// "Adds controls required to install a profile" => "Adds controls required to install a profile",
// "Domain" => "Domain",
// "Profile repository domain. Default value is profiles.tikiwiki.org" => "Profile repository domain. Default value is profiles.tikiwiki.org",
// "Profile Name" => "Profile Name",
// "Name of the profile" => "Name of the profile",
// "Profile plugin only available to administrators" => "Profile plugin only available to administrators",
// "Profile %0/%1 not found" => "Profile %0/%1 not found",
// "Proposal" => "Proposal",
// "Provides a widget for users to vote on a proposal and view the current decision" => "Provides a widget for users to vote on a proposal and view the current decision",
// "The list of votes cast. One vote per line. Either 0, +1 or -1 followed by a username" => "The list of votes cast. One vote per line. Either 0, +1 or -1 followed by a username",
// "Accept proposal" => "Accept proposal",
// "Still undecided" => "Still undecided",
// "Reject proposal" => "Reject proposal",
// "Displays a proposal acceptance widget" => "Displays a proposal acceptance widget",
// "Short description of the proposal to vote on. Will be displayed above the result table" => "Short description of the proposal to vote on. Will be displayed above the result table",
// "Quote" => "Quote",
// "Quoted text" => "Quoted text",
// "Reply to" => "Reply to",
// "Name of the quoted person" => "Name of the quoted person",
// "Random Dynamic Content" => "Random Dynamic Content",
// "Includes random content from the dynamic content system" => "Includes random content from the dynamic content system",
// "User List (showing Real Name)" => "User List (showing Real Name)",
// " (experimental, should be merged with UserList in Tiki5)" => " (experimental, should be merged with UserList in Tiki5)",
// "Login Filter" => "Login Filter",
// "String to use between elements of the list" => "String to use between elements of the list",
// "Maximum" => "Maximum",
// "Result limit" => "Result limit",
// "Layout" => "Layout",
// "Exclude" => "Exclude",
// "Displays a list of users showing their real name" => "Displays a list of users showing their real name",
// "Displays a list of registered users showing their Real Names" => "Displays a list of registered users showing their Real Names",
// "Redirect" => "Redirect",
// "Redirect the user to a wiki page or generic URL" => "Redirect the user to a wiki page or generic URL",
// "Wiki page name to redirect to" => "Wiki page name to redirect to",
// "Complete URL, internal or external" => "Complete URL, internal or external",
// "Redirects you to another wiki page" => "Redirects you to another wiki page",
// "Regular Expression" => "Regular Expression",
// "Takes regex expressions and parses the content between REGEX tags and replaces the text" => "Takes regex expressions and parses the content between REGEX tags and replaces the text",
// "Page name containing the regular expression" => "Page name containing the regular expression",
// "Displays a comment, tip, note or warning box" => "Displays a comment, tip, note or warning box",
// "remarks text" => "remarks text",
// "Remarks Box" => "Remarks Box",
// "Label displayed above the remark" => "Label displayed above the remark",
// "Highlight" => "Highlight",
// "Icon ID" => "Icon ID",
// "y|n Show close button (default y)" => "y|n Show close button (default y)",
// "Width (e.g. 100% or 250px - default \"\")" => "Width (e.g. 100% or 250px - default \"\")",
// "RSS Feed" => "RSS Feed",
// "Inserts an RSS feed output" => "Inserts an RSS feed output",
// "IDs" => "IDs",
// "List of feed IDs separated by colons. ex: feedId:feedId2" => "List of feed IDs separated by colons. ex: feedId:feedId2",
// "Number of results displayed" => "Number of results displayed",
// "You need to specify a RSS Id" => "You need to specify a RSS Id",
// "RSS Id incorrect" => "RSS Id incorrect",
// "~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage",
// "Screencast" => "Screencast",
// "Display a screencast uploaded on the page" => "Display a screencast uploaded on the page",
// "Label to use as a replacement to the default text" => "Label to use as a replacement to the default text",
// "ID as provided automatically during the upload" => "ID as provided automatically during the upload",
// "Insert Screencast" => "Insert Screencast",
// "Screencast ID wasn't specified or doesn't exist" => "Screencast ID wasn't specified or doesn't exist",
// "Watch a video of these instructions" => "Watch a video of these instructions",
// "SourceForge" => "SourceForge",
// "aid?" => "aid?",
// "adit?" => "adit?",
// "groupid?" => "groupid?",
// "Insert a ShareThis button from www.sharethis.com" => "Insert a ShareThis button from www.sharethis.com",
// "sharethis" => "sharethis",
// "Display a social networking tool" => "Display a social networking tool",
// "Send services" => "Send services",
// "By default, email, aim and sms are available. Input one or two of the services separated by a | to limit the choice of send services" => "By default, email, aim and sms are available. Input one or two of the services separated by a | to limit the choice of send services",
// "First post services shown" => "First post services shown",
// "Input a list of post services (like facebook, myspace, digg, etc.) separated by a | to customize the services that are shown in the opening panel of the widget" => "Input a list of post services (like facebook, myspace, digg, etc.) separated by a | to customize the services that are shown in the opening panel of the widget",
// "Rotate image" => "Rotate image",
// "A value of y will cause the button icon to rotate every 3 seconds between a few icons, cycling through twice before stopping" => "A value of y will cause the button icon to rotate every 3 seconds between a few icons, cycling through twice before stopping",
// "Button text" => "Button text",
// "Custom link text for the button" => "Custom link text for the button",
// "Header title" => "Header title",
// "Optional header title text for the widget" => "Optional header title text for the widget",
// "Header background" => "Header background",
// "HTML color code (not color name) for the background color for the header if an optional header title is used" => "HTML color code (not color name) for the background color for the header if an optional header title is used",
// "Header text color" => "Header text color",
// "HTML color code (not color name) for the header text if an optional header title is used" => "HTML color code (not color name) for the header text if an optional header title is used",
// "Link text color for services" => "Link text color for services",
// "HTML color code (not color name) for the link text for all send and post services shown in the widget" => "HTML color code (not color name) for the link text for all send and post services shown in the widget",
// "A value of true will cause the widget to show in a pop-up window" => "A value of true will cause the widget to show in a pop-up window",
// "Embedded elements" => "Embedded elements",
// "A value of true will allow embedded elements (like flash) to be seen while iframe is loading" => "A value of true will allow embedded elements (like flash) to be seen while iframe is loading",
// "Sheet" => "Sheet",
// "Displays the content of a spreadsheet in the page" => "Displays the content of a spreadsheet in the page",
// "Internal ID of the TikiSheet" => "Internal ID of the TikiSheet",
// "New sheet in page: " => "New sheet in page: ",
// "Incomplete call to plugin: No target sheet" => "Incomplete call to plugin: No target sheet",
// "Create new sheet" => "Create new sheet",
// "Show Pages" => "Show Pages",
// "Search criteria" => "Search criteria",
// "Maximum amount of results displayed" => "Maximum amount of results displayed",
// "name|desc" => "name|desc",
// "Skype" => "Skype",
// "Clickable Skype link" => "Clickable Skype link",
// "Name or number to call or chat with" => "Name or number to call or chat with",
// "Snarf" => "Snarf",
// "Include the content of a remote HTTP page. Regular expression selecting the content portion to include must be specified" => "Include the content of a remote HTTP page. Regular expression selecting the content portion to include must be specified",
// "Full URL to the page to include" => "Full URL to the page to include",
// "PCRE compliant regular expression" => "PCRE compliant regular expression",
// "Regular Expression Part" => "Regular Expression Part",
// "ex: \$1" => "ex: \$1",
// "Data to sort, one entry per line" => "Data to sort, one entry per line",
// "asc|desc|shuffle" => "asc|desc|shuffle",
// "Join Columns" => "Join Columns",
// "Generate the colspan attribute if columns are missing" => "Generate the colspan attribute if columns are missing",
// "Fixed Size" => "Fixed Size",
// "Generate the width attribute on the columns" => "Generate the width attribute on the columns",
// "Column Size" => "Column Size",
// "Editable" => "Editable",
// "Display edit icon for each section" => "Display edit icon for each section",
// "Custom class" => "Custom class",
// "add a class to customize the design" => "add a class to customize the design",
// "SQL" => "SQL",
// "DNS Name" => "DNS Name",
// "ADODB DNS" => "ADODB DNS",
// "Stat" => "Stat",
// "Displays some stats" => "Displays some stats",
// "separated by " => "separated by ",
// "Parent Id" => "Parent Id",
// "Added last hour" => "Added last hour",
// "Added last 24 hours" => "Added last 24 hours",
// "Added since the beginning of the day" => "Added since the beginning of the day",
// "Added(a) or viewed(v) since the beginning of the day" => "Added(a) or viewed(v) since the beginning of the day",
// "Added last 7 days" => "Added last 7 days",
// "Added(a) or viewed(v) last 7 days" => "Added(a) or viewed(v) last 7 days",
// "Added since the beginning of the week" => "Added since the beginning of the week",
// "Added(a) or viewed(v) since the beginning of the week" => "Added(a) or viewed(v) since the beginning of the week",
// "Added last month" => "Added last month",
// "Added(a) or viewed(v) last month" => "Added(a) or viewed(v) last month",
// "Added since the beginning of the month" => "Added since the beginning of the month",
// "Added(a) or viewed(v) since the beginning of the month" => "Added(a) or viewed(v) since the beginning of the month",
// "Added last year" => "Added last year",
// "Added(a) or viewed(v) last year" => "Added(a) or viewed(v) last year",
// "Added since the beginning of the year" => "Added since the beginning of the year",
// "Added(a) or viewed(v) since the beginning of the year" => "Added(a) or viewed(v) since the beginning of the year",
// "Subscript" => "Subscript",
// "Subscribe or unsubscribe to a group" => "Subscribe or unsubscribe to a group",
// "Subscribe Group" => "Subscribe Group",
// "Group Name" => "Group Name",
// "As known in Tikiwiki" => "As known in Tikiwiki",
// "Subscribe Text" => "Subscribe Text",
// "Subscribe text, containing %s as the placeholder for the group name" => "Subscribe text, containing %s as the placeholder for the group name",
// "Unsubscribe Text" => "Unsubscribe Text",
// "Unsubscribe text, containing %s as the placeholder for the group name" => "Unsubscribe text, containing %s as the placeholder for the group name",
// "Subscribe Action" => "Subscribe Action",
// "Subscribe button label, containing %s as the placeholder for the group name" => "Subscribe button label, containing %s as the placeholder for the group name",
// "Unsubscribe Action" => "Unsubscribe Action",
// "Unsubscribe button label, containing %s as the placeholder for the group name" => "Unsubscribe button label, containing %s as the placeholder for the group name",
// "Subscribe Groups" => "Subscribe Groups",
// "Show subscribe box" => "Show subscribe box",
// "Show default setting and buttons" => "Show default setting and buttons",
// "Show group description" => "Show group description",
// "Colon separated list of groups" => "Colon separated list of groups",
// "After changing default" => "After changing default",
// "Superscript" => "Superscript",
// "Displays text in superscript (exponent)" => "Displays text in superscript (exponent)",
// "Displays text in superscript" => "Displays text in superscript",
// "Wiki Page to redirect the user after his vote" => "Wiki Page to redirect the user after his vote",
// "Displays a survey" => "Displays a survey",
// "Tabs" => "Tabs",
// "Provides tabs built using the smarty tabset block" => "Provides tabs built using the smarty tabset block",
// "Tabs content separated by /////" => "Tabs content separated by /////",
// "Tabset name" => "Tabset name",
// "Unique tabset name (if you want it to remember its last state). Ex: user_profile_tabs" => "Unique tabset name (if you want it to remember its last state). Ex: user_profile_tabs",
// "Tab titles" => "Tab titles",
// "Pipe separated list of tab titles. Ex: tab 1|tab 2|tab 3" => "Pipe separated list of tab titles. Ex: tab 1|tab 2|tab 3",
// "Displays a set of tabs" => "Displays a set of tabs",
// "No tab title specified. At least one has to be set to make the tabs appear" => "No tab title specified. At least one has to be set to make the tabs appear",
// "Tag" => "Tag",
// "Displays the text between an html tag" => "Displays the text between an html tag",
// "Any valid HTML tag, span by default" => "Any valid HTML tag, span by default",
// "Equivalent to the style attribute of an HTML tag" => "Equivalent to the style attribute of an HTML tag",
// "File ID from the file gallery" => "File ID from the file gallery",
// "Image ID from the image gallery" => "Image ID from the image gallery",
// "URL to the image" => "URL to the image",
// "Maximum Size" => "Maximum Size",
// "Maximum width or height for the image" => "Maximum width or height for the image",
// "Floating" => "Floating",
// "Link target of the image" => "Link target of the image",
// "No image specified" => "No image specified",
// "Title Search" => "Title Search",
// "Search wiki page titles" => "Search wiki page titles",
// "Search Criteria" => "Search Criteria",
// "Portion of a page name" => "Portion of a page name",
// "hits|user" => "hits|user",
// "Pipe-separated list of page names to exclude from results" => "Pipe-separated list of page names to exclude from results",
// "Table of Contents (Structure)" => "Table of Contents (Structure)",
// "Displays the table of contents for the current structure\\'s subtree as part of the page content" => "Displays the table of contents for the current structure\\'s subtree as part of the page content",
// "Maximum Depth" => "Maximum Depth",
// "Maximum number of levels to display. On very large structures, this should be limited" => "Maximum number of levels to display. On very large structures, this should be limited",
// "By default, structure for the current page will be displayed. Alternate structure may be provided" => "By default, structure for the current page will be displayed. Alternate structure may be provided",
// "asc|desc" => "asc|desc",
// "Show Description" => "Show Description",
// "0|1, show the page description instead of the page name" => "0|1, show the page description instead of the page name",
// "Show Numbering" => "Show Numbering",
// "0|1, display the section numbers or not" => "0|1, display the section numbers or not",
// "plain|fancy" => "plain|fancy",
// "Top Friends" => "Top Friends",
// "List top-scoring users" => "List top-scoring users",
// "Maximum result count" => "Maximum result count",
// "Translate a string using Tikiwiki translation table" => "Translate a string using Tikiwiki translation table",
// "string" => "string",
// "Translate a string" => "Translate a string",
// "Colon-separated list of field IDs to be displayed. Example: 2:4:5" => "Colon-separated list of field IDs to be displayed. Example: 2:4:5",
// "Label on the submit button" => "Label on the submit button",
// "Show Title" => "Show Title",
// "Show Mandatory" => "Show Mandatory",
// "Embedded" => "Embedded",
// "URL used for the field links" => "URL used for the field links",
// "Url target" => "Url target",
// "Values" => "Values",
// "Colon-separated list of values" => "Colon-separated list of values",
// "Note that plugin arguments can be enclosed with double quotes \"; this allows them to contain , or " => "Note that plugin arguments can be enclosed with double quotes \"; this allows them to contain , or ",
// "Reset" => "Reset",
// "Label for the reset button, to return all fields to their default values" => "Label for the reset button, to return all fields to their default values",
// "user|page" => "user|page",
// "itemId" => "itemId",
// "itemId if you want to edit an item" => "itemId if you want to edit an item",
// "Template File" => "Template File",
// "Name of the template used to display the tracker items" => "Name of the template used to display the tracker items",
// "Name of the wiki page containing the template to display the tracker items" => "Name of the wiki page containing the template to display the tracker items",
// "New Status" => "New Status",
// "Default status applied to newly created items" => "Default status applied to newly created items",
// "Width of first column " => "Width of first column ",
// "Specify the width in pixels or percentage of the first column in the tracker form" => "Specify the width in pixels or percentage of the first column in the tracker form",
// "Incorrect fieldId" => "Incorrect fieldId",
// "You do not have permission to modify an item" => "You do not have permission to modify an item",
// "Display List" => "Display List",
// "Line" => "Line",
// "Tracker Filter" => "Tracker Filter",
// "notice" => "notice",
// "tracker field type not processed yet" => "tracker field type not processed yet",
// "Filters the items of a tracker, fields are indicated with numeric ids" => "Filters the items of a tracker, fields are indicated with numeric ids",
// "Wiki text" => "Wiki text",
// "Tracker Item Field" => "Tracker Item Field",
// "Wiki text containing an {ELSE} marker" => "Wiki text containing an {ELSE} marker",
// "Item ID" => "Item ID",
// "Field ID" => "Field ID",
// "Colon separated list of field IDs" => "Colon separated list of field IDs",
// "o|p|c|op|oc|pc|opc" => "o|p|c|op|oc|pc|opc",
// "Test" => "Test",
// "Value to compare against" => "Value to compare against",
// "Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker)" => "Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker)",
// "Tracker List" => "Tracker List",
// "Notice" => "Notice",
// "Colon-separated list of fields to display on click. Example: 6:7" => "Colon-separated list of fields to display on click. Example: 6:7",
// "Sticky Popup" => "Sticky Popup",
// "Show Links" => "Show Links",
// "shownbitems" => "shownbitems",
// "Show Initials" => "Show Initials",
// "Show Status" => "Show Status",
// "Show Creation Date" => "Show Creation Date",
// "Show Last Modification" => "Show Last Modification",
// "Show Field Name" => "Show Field Name",
// "Show Item Rank" => "Show Item Rank",
// "Status Filter" => "Status Filter",
// "Which item status to list. o = open, p = pending, c = closed" => "Which item status to list. o = open, p = pending, c = closed",
// "Sort Mode" => "Sort Mode",
// "Maximum number of items" => "Maximum number of items",
// "Show pagination" => "Show pagination",
// "Filter Field" => "Filter Field",
// "Colon separated list of fields to allow filtering on" => "Colon separated list of fields to allow filtering on",
// "Filter Value" => "Filter Value",
// "Exact Value" => "Exact Value",
// "Checkbox" => "Checkbox",
// "goIfOne" => "goIfOne",
// "More" => "More",
// "More URL" => "More URL",
// "More Url" => "More Url",
// "Select automatically the item of the current user or the page" => "Select automatically the item of the current user or the page",
// "View User" => "View User",
// "Item ID separated with " => "Item ID separated with ",
// "List of items Ids" => "List of items Ids",
// "link url" => "link url",
// "Left Deliminator" => "Left Deliminator",
// "Right Deliminator" => "Right Deliminator",
// "If y, value will be truncated" => "If y, value will be truncated",
// "Export Button" => "Export Button",
// "Compute" => "Compute",
// "Sum or average all the values of a field  and displays it at the bottom of the table" => "Sum or average all the values of a field  and displays it at the bottom of the table",
// "fieldId" => "fieldId",
// "Show nothing if no items" => "Show nothing if no items",
// "incorrect filterfield" => "incorrect filterfield",
// "Displays a button to link to a page with a tracker plugin with prefilled tracker fields" => "Displays a button to link to a page with a tracker plugin with prefilled tracker fields",
// "Tracker Prefill" => "Tracker Prefill",
// "Tracker page name" => "Tracker page name",
// "Button label" => "Button label",
// "Field 1" => "Field 1",
// "Value 1" => "Value 1",
// "Content of the field" => "Content of the field",
// "Field 2" => "Field 2",
// "Value 2" => "Value 2",
// "Field 3" => "Field 3",
// "Value 3" => "Value 3",
// "Field 4" => "Field 4",
// "Value 4" => "Value 4",
// "Field 5" => "Field 5",
// "Value 5" => "Value 5",
// "Tracker Stats" => "Tracker Stats",
// "Show link to tiki-view_tracker" => "Show link to tiki-view_tracker",
// "Displays some stat of a tracker content, fields are indicated with numeric ids" => "Displays some stat of a tracker content, fields are indicated with numeric ids",
// "incorrect fieldId" => "incorrect fieldId",
// "Tracker Timeline" => "Tracker Timeline",
// "Timeline view of a tracker, can be used to display event schedules or gantt charts" => "Timeline view of a tracker, can be used to display event schedules or gantt charts",
// "Title Field" => "Title Field",
// "Tracker Field ID containing the item title" => "Tracker Field ID containing the item title",
// "Summary Field" => "Summary Field",
// "Tracker Field ID containing the summary of the item. The summary will be displayed on the timeline when the item is focused" => "Tracker Field ID containing the summary of the item. The summary will be displayed on the timeline when the item is focused",
// "Tracker Field ID containing the element start date. The field must be a datetime/jscalendar field" => "Tracker Field ID containing the element start date. The field must be a datetime/jscalendar field",
// "Tracker Field ID containing the element end date. The field must be a datetime/jscalendar field" => "Tracker Field ID containing the element end date. The field must be a datetime/jscalendar field",
// "Element Group" => "Element Group",
// "Tracker Field ID containing the element\\'s group. Elements of a same group are displayed on the same row" => "Tracker Field ID containing the element\\'s group. Elements of a same group are displayed on the same row",
// "Lower Bound" => "Lower Bound",
// "Date from which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format" => "Date from which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format",
// "Upper Bound" => "Upper Bound",
// "Date until which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format" => "Date until which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format",
// "Primary Scale Unit" => "Primary Scale Unit",
// "hour, day, week, month or year (default to hour)" => "hour, day, week, month or year (default to hour)",
// "Secondary Scale Unit" => "Secondary Scale Unit",
// "hour, day, week, month, year or empty (default to empty)" => "hour, day, week, month, year or empty (default to empty)",
// "Link Group Name" => "Link Group Name",
// "Convert the group name to a link. (y|n)" => "Convert the group name to a link. (y|n)",
// "Page Link Field" => "Page Link Field",
// "Tracker Field ID containing the page name for item details" => "Tracker Field ID containing the page name for item details",
// "Missing parameter: %0" => "Missing parameter: %0",
// "Start date after end date" => "Start date after end date",
// "Translated" => "Translated",
// "[url] or ((wikiname)) or ((inter:interwiki)) (use wiki syntax)" => "[url] or ((wikiname)) or ((inter:interwiki)) (use wiki syntax)",
// "Two letter language code of the language, ex: fr" => "Two letter language code of the language, ex: fr",
// "Country name, ex: France" => "Country name, ex: France",
// "User Count" => "User Count",
// "Group name" => "Group name",
// "Displays a list of registered users" => "Displays a list of registered users",
// "Display the user\\'s real name instead of login name" => "Display the user\\'s real name instead of login name",
// "Userpref" => "Userpref",
// "Display wiki text if user has a pref set to a value" => "Display wiki text if user has a pref set to a value",
// "Block of text separated by ---(version x)--- markers. Text before the first marker is used by default" => "Block of text separated by ---(version x)--- markers. Text before the first marker is used by default",
// "Navigation" => "Navigation",
// "Displays a navigation box that allows users to select a specific version to display" => "Displays a navigation box that allows users to select a specific version to display",
// "Display the current version name as the title. Note: Do not work when nav=>y" => "Display the current version name as the title. Note: Do not work when nav=>y",
// "Specifies version label to show when displaying the page for the first time. e.g. \\'Default\\'" => "Specifies version label to show when displaying the page for the first time. e.g. \\'Default\\'",
// "This is the default text" => "This is the default text",
// "(version 3)" => "(version 3)",
// "This is version 3 info" => "This is version 3 info",
// "(version 2)" => "(version 2)",
// "This is version 2 info" => "This is version 2 info",
// "(version 1)" => "(version 1)",
// "This is version 1 info" => "This is version 1 info",
// "Show Stats" => "Show Stats",
// "Show Stats After" => "Show Stats After",
// "Show Creator" => "Show Creator",
// "Wanted Pages" => "Wanted Pages",
// "Custom level regex. A custom filter for wanted pages to be listed (only used when level=>custom).\n\t\tpossible values: a valid regex-expression (PCRE)" => "Custom level regex. A custom filter for wanted pages to be listed (only used when level=>custom).\n\t\tpossible values: a valid regex-expression (PCRE)",
// "Ignore" => "Ignore",
// "Split By" => "Split By",
// "Skip Extension" => "Skip Extension",
// "Collect" => "Collect",
// "Level" => "Level",
// "A wildcard pattern of originating pages to be ignored" => "A wildcard pattern of originating pages to be ignored",
// "The character, by which ignored patterns are separated" => "The character, by which ignored patterns are separated",
// "Whether to include external wikis in the list" => "Whether to include external wikis in the list",
// "Collect either originating or wanted pages in a cell and display them in the second column" => "Collect either originating or wanted pages in a cell and display them in the second column",
// "Switch-on debug output with details about the items" => "Switch-on debug output with details about the items",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell" => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell",
// "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex" => "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex",
// "A custom filter for wanted pages to be listed (only used when level=>custom)" => "A custom filter for wanted pages to be listed (only used when level=>custom)",
// "Lists ''wanted'' wiki pages" => "Lists ''wanted'' wiki pages",
// "A wildcard pattern of originating pages to be ignored. (refer to PHP fuction fnmatch() for details)" => "A wildcard pattern of originating pages to be ignored. (refer to PHP fuction fnmatch() for details)",
// "The character, by which ignored patterns are separated. possible values: characters" => "The character, by which ignored patterns are separated. possible values: characters",
// "Whether to include external wikis in the list. possible values" => "Whether to include external wikis in the list. possible values",
// "Collect either originating or wanted pages in a cell and display them in the second column. possible values" => "Collect either originating or wanted pages in a cell and display them in the second column. possible values",
// "Switch-on debug output with details about the items. possible values" => "Switch-on debug output with details about the items. possible values",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell. possible values" => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell. possible values",
// "Web Service" => "Web Service",
// "Obtains and display remote information exposed in JSON or YAML. The plugin can be used to display registered or unregistered services. Registered services may use more parameters not defined in this interface" => "Obtains and display remote information exposed in JSON or YAML. The plugin can be used to display registered or unregistered services. Registered services may use more parameters not defined in this interface",
// "Template to apply to the data provided. Template format uses smarty templating engine using double brackets as delimiter. Output must provide wiki syntax. Body can be sent to a parameter instead by using the bodyname parameter" => "Template to apply to the data provided. Template format uses smarty templating engine using double brackets as delimiter. Output must provide wiki syntax. Body can be sent to a parameter instead by using the bodyname parameter",
// "Complete service URL" => "Complete service URL",
// "Service Name" => "Service Name",
// "Registered service name" => "Registered service name",
// "Template Name" => "Template Name",
// "For use with registered services, name of the template to be used to display the service output. This parameter will be ignored if a body is provided" => "For use with registered services, name of the template to be used to display the service output. This parameter will be ignored if a body is provided",
// "Body as Parameter" => "Body as Parameter",
// "Name of the argument to send the body as for services with complex input. Named service required for this to be useful" => "Name of the argument to send the body as for services with complex input. Named service required for this to be useful",
// "Unknown Template" => "Unknown Template",
// "Unknown Service" => "Unknown Service",
// "Missing parameters" => "Missing parameters",
// "Youtube" => "Youtube",
// "Display youtube video in a wiki page" => "Display youtube video in a wiki page",
// "URL to the Youtube video" => "URL to the Youtube video",
// "quality" => "quality",
// "Missing parameter movie to the youtube plugin" => "Missing parameter movie to the youtube plugin",
// "Cannot create aliased page" => "Cannot create aliased page",
// "You attempted to create the following page" => "You attempted to create the following page",
// "That page is an alias for the following pages" => "That page is an alias for the following pages",
// "If you want to create the page, you must first edit each the pages above, and remove the alias link it may contain. This link should look something like this" => "If you want to create the page, you must first edit each the pages above, and remove the alias link it may contain. This link should look something like this",
// "Can't parse HTML data - no grammar file" => "Can't parse HTML data - no grammar file",
// "Removed version \$version" => "Removed version \$version",
// "rollback version " => "rollback version ",
// "Changed actual version to \$version" => "Changed actual version to \$version",
// "Plugin " => "Plugin ",
// "Semantic token already exists" => "Semantic token already exists",
// "Invalid semantic token name" => "Invalid semantic token name",
// "Semantic token not found" => "Semantic token not found",
// "Page locked" => "Page locked",
// "Page unlocked" => "Page unlocked",
// "Removed last version" => "Removed last version",
// "User %s does not have the permission" => "User %s does not have the permission",
// "The message has been sent to" => "The message has been sent to",
// "The message will be sent to" => "The message will be sent to",
// "User %s does not want to receive messages" => "User %s does not want to receive messages",
// "Displays a calendar of system events, such as wiki page modifications, forum posts and article publications. Days with events show links to the action calendar page" => "Displays a calendar of system events, such as wiki page modifications, forum posts and article publications. Days with events show links to the action calendar page",
// "Item types filter" => "Item types filter",
// "If set to a list of item types, restricts the items displayed to those of one of these types. Each set is a comma-separated list of item type codes" => "If set to a list of item types, restricts the items displayed to those of one of these types. Each set is a comma-separated list of item type codes",
// "Possible item type values" => "Possible item type values",
// "Google AdSense" => "Google AdSense",
// "Displays a text/image Google AdSense advertisement. This module should be updated to support new Google code" => "Displays a text/image Google AdSense advertisement. This module should be updated to support new Google code",
// "Advertisement channel, as optionally provided by Google" => "Advertisement channel, as optionally provided by Google",
// "As provided by Google. Format: \"pub-xxxxxxxxxxxxxxxx\"" => "As provided by Google. Format: \"pub-xxxxxxxxxxxxxxxx\"",
// "Global banner format as provided by Google. For example: \"display=468*60_as\"" => "Global banner format as provided by Google. For example: \"display=468*60_as\"",
// "Background color, as optionally provided by Google" => "Background color, as optionally provided by Google",
// "Border color, as optionally provided by Google" => "Border color, as optionally provided by Google",
// "Link color, as optionally provided by Google" => "Link color, as optionally provided by Google",
// "Text color, as optionally provided by Google" => "Text color, as optionally provided by Google",
// "URL color, as optionally provided by Google" => "URL color, as optionally provided by Google",
// "Article archives" => "Article archives",
// "Shows links to the published articles for each month" => "Shows links to the published articles for each month",
// "If set to \"y\", displays a button labelled \"More...\" that links to a paginated view of the selected articles" => "If set to \"y\", displays a button labelled \"More...\" that links to a paginated view of the selected articles",
// "Default: \"n\"" => "Default: \"n\"",
// "Category filter" => "Category filter",
// "If set to a category identifier, only consider the articles in the specified category" => "If set to a category identifier, only consider the articles in the specified category",
// "Example value: 13" => "Example value: 13",
// "Not set by default" => "Not set by default",
// "Topic filter (by names)" => "Topic filter (by names)",
// "If set to a list of article topic names separated by plus signs, only consider the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not considered" => "If set to a list of article topic names separated by plus signs, only consider the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not considered",
// "Example values" => "Example values",
// "Topic filter (by identifiers)" => "Topic filter (by identifiers)",
// "If set to a list of article topic identifiers separated by plus signs, only consider the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not considered" => "If set to a list of article topic identifiers separated by plus signs, only consider the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not considered",
// "Example values: 13, !13, 1+3, !1+5+7" => "Example values: 13, !13, 1+3, !1+5+7",
// "Types filter" => "Types filter",
// "If set to a list of article type names separated by plus signs, only consider the articles of the specified types. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles of the specified article types are not considered" => "If set to a list of article type names separated by plus signs, only consider the articles of the specified types. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles of the specified article types are not considered",
// "Example values: Event, !Event, Event+Review, !Event+Classified+Article" => "Example values: Event, !Event, Event+Review, !Event+Classified+Article",
// "Language filter" => "Language filter",
// "If set to a language code, only consider the articles in the specified language" => "If set to a language code, only consider the articles in the specified language",
// "Article Topics" => "Article Topics",
// "Lists all article topics with links to their articles" => "Lists all article topics with links to their articles",
// "Lists the specified number of published articles in the specified order" => "Lists the specified number of published articles in the specified order",
// "Show publication time" => "Show publication time",
// "If set to \"y\", article publication times are shown" => "If set to \"y\", article publication times are shown",
// "Show creation time" => "Show creation time",
// "If set to \"y\", article creation times are shown" => "If set to \"y\", article creation times are shown",
// "Show rating selector" => "Show rating selector",
// "If set to \"y\", offers the user to filter articles based on a minimum and a maximum rating" => "If set to \"y\", offers the user to filter articles based on a minimum and a maximum rating",
// "If set, displays an image for each article if one applies, with the given width (in pixels). The article\\'s own image is used, with a fallback to the article\\'s topic image" => "If set, displays an image for each article if one applies, with the given width (in pixels). The article\\'s own image is used, with a fallback to the article\\'s topic image",
// "If set to a category identifier, only lists the articles in the specified category" => "If set to a category identifier, only lists the articles in the specified category",
// "If set to a list of article topic names separated by plus signs, only lists the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not listed" => "If set to a list of article topic names separated by plus signs, only lists the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not listed",
// "If set to a list of article topic identifiers separated by plus signs, only lists the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not listed" => "If set to a list of article topic identifiers separated by plus signs, only lists the articles in the specified article topics. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles in the specified article topics are not listed",
// "If set to a list of article type names separated by plus signs, only lists the articles of the specified types. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles of the specified article types are not listed" => "If set to a list of article type names separated by plus signs, only lists the articles of the specified types. If the string is preceded by an exclamation mark (\"!\"), the effect is reversed, i.e. articles of the specified article types are not listed",
// "If set to a language code, only lists the articles in the specified language" => "If set to a language code, only lists the articles in the specified language",
// "Specifies how the articles should be sorted" => "Specifies how the articles should be sorted",
// "Possible values include created and created_asc (equivalent), created_desc, author, rating, topicId, lang and title. Unless \"_desc\" is specified, the sort is ascending. \"created\" sorts on article creation date" => "Possible values include created and created_asc (equivalent), created_desc, author, rating, topicId, lang and title. Unless \"_desc\" is specified, the sort is ascending. \"created\" sorts on article creation date",
// "If set to an integer, offsets the articles list by the given number. For example, if the module was otherwise set to list the 10 articles most recently published, setting the offset to 10 would make the module list the 11th to 20th articles in descending order of publication time instead" => "If set to an integer, offsets the articles list by the given number. For example, if the module was otherwise set to list the 10 articles most recently published, setting the offset to 10 would make the module list the 11th to 20th articles in descending order of publication time instead",
// "If set to \"y\", displays a button labelled \"More\" that links to a paginated view of the selected articles" => "If set to \"y\", displays a button labelled \"More\" that links to a paginated view of the selected articles",
// "Absolute URL" => "Absolute URL",
// "If set to \"y\", some of the links use an absolute URL instead of a relative one. This can avoid broken links if the module is to be sent in a newsletter, for example" => "If set to \"y\", some of the links use an absolute URL instead of a relative one. This can avoid broken links if the module is to be sent in a newsletter, for example",
// "TikiWiki assistant" => "TikiWiki assistant",
// "Displays an assistant to guide new Tiki admins" => "Displays an assistant to guide new Tiki admins",
// "Last blog post comments" => "Last blog post comments",
// "Displays the specified number of the blog post comments most recently added" => "Displays the specified number of the blog post comments most recently added",
// "More in tooltips" => "More in tooltips",
// "If set to \"y\", the post on which a comment is made is not displayed in the module box, but instead moved in the item\\'s tooltip" => "If set to \"y\", the post on which a comment is made is not displayed in the module box, but instead moved in the item\\'s tooltip",
// "No date" => "No date",
// "If set to \"y\", the date at which comments were posted is not displayed in the module box" => "If set to \"y\", the date at which comments were posted is not displayed in the module box",
// "Last visited pages" => "Last visited pages",
// "Displays the last Wiki pages visited by the user" => "Displays the last Wiki pages visited by the user",
// "Maximum length" => "Maximum length",
// "Maximum number of characters in page names allowed before truncating" => "Maximum number of characters in page names allowed before truncating",
// "Includes a calendar or a list of calendar events" => "Includes a calendar or a list of calendar events",
// "Displayed month (relative)" => "Displayed month (relative)",
// "Distance in month to the month to display. A distance of -1 would display the previous month. Setting this option implies a calendar view type with a month time span" => "Distance in month to the month to display. A distance of -1 would display the previous month. Setting this option implies a calendar view type with a month time span",
// "Displays links to categories as a tree" => "Displays links to categories as a tree",
// "Object type filter" => "Object type filter",
// "Object type filter to apply when accessing a linked category. Example values" => "Object type filter to apply when accessing a linked category. Example values",
// "Deep" => "Deep",
// "Show subcategories objects when accessing a linked category. Possible values: on (default), off" => "Show subcategories objects when accessing a linked category. Possible values: on (default), off",
// "PHP Layers menu style" => "PHP Layers menu style",
// "Sets the menu style if PHP Layers is enabled. Possible values: tree (default), vert, horiz, plain, phptree" => "Sets the menu style if PHP Layers is enabled. Possible values: tree (default), vert, horiz, plain, phptree",
// "Limits displayed categories to a subtree of categories starting with the category with the given ID. Example value: 11. Default: 0 (don\\'t limit display)" => "Limits displayed categories to a subtree of categories starting with the category with the given ID. Example value: 11. Default: 0 (don\\'t limit display)",
// "Category Transitions" => "Category Transitions",
// "Displays controls to trigger category transitions and change the page\\'s state according to predefined rules" => "Displays controls to trigger category transitions and change the page\\'s state according to predefined rules",
// "Change Category" => "Change Category",
// "Enables to categorize an object" => "Enables to categorize an object",
// "Category identifier" => "Category identifier",
// "Changes the root of the displayed categories from default \"TOP\" to the category with the given identifier" => "Changes the root of the displayed categories from default \"TOP\" to the category with the given identifier",
// "Note that the root category is not displayed" => "Note that the root category is not displayed",
// "Defaults to 0 (root)" => "Defaults to 0 (root)",
// "No top" => "No top",
// "In non-detailed view, disallow uncategorizing. Example value: 1" => "In non-detailed view, disallow uncategorizing. Example value: 1",
// "Display path" => "Display path",
// "Instead of category names, diplay their path in the category tree starting from the category root defined" => "Instead of category names, diplay their path in the category tree starting from the category root defined",
// "Example value: 1" => "Example value: 1",
// "Multiple categories" => "Multiple categories",
// "If set to \"n\", only allows categorizing in one category (from those displayed)" => "If set to \"n\", only allows categorizing in one category (from those displayed)",
// "String to display on the button to submit new categories, when multiple categories is enabled. Default value: Categorize" => "String to display on the button to submit new categories, when multiple categories is enabled. Default value: Categorize",
// "Shy" => "Shy",
// "If set to \"y\", the module is not shown on pages which are not already categorized.' . \" \" . tra('Not set by default" => "If set to \"y\", the module is not shown on pages which are not already categorized.' . \" \" . tra('Not set by default",
// "Detailed" => "Detailed",
// "If set to \"y\", shows a list of categories in which the object is. If deletion is not disabled, it is done with the list" => "If set to \"y\", shows a list of categories in which the object is. If deletion is not disabled, it is done with the list",
// "If set to \"n\", the detailed list of categories will not offer to unassign a category" => "If set to \"n\", the detailed list of categories will not offer to unassign a category",
// "If set to \"y\", allow to assign new categories" => "If set to \"y\", allow to assign new categories",
// "Example values: y, n" => "Example values: y, n",
// "Default value: y" => "Default value: y",
// "Default value: n" => "Default value: n",
// "Image URL not in category" => "Image URL not in category",
// "Very particular parameter. If both this and \"Image URL in the category\" are set and the root category contains a single child category, the module only displays an image with this URL if the object is not in the category" => "Very particular parameter. If both this and \"Image URL in the category\" are set and the root category contains a single child category, the module only displays an image with this URL if the object is not in the category",
// "Example value" => "Example value",
// "Image URL in category" => "Image URL in category",
// "Very particular parameter. If both this and \"Image URL not in the category\" are set and the root category contains a single child category, the module only displays an image with this URL if the object is in the category" => "Very particular parameter. If both this and \"Image URL not in the category\" are set and the root category contains a single child category, the module only displays an image with this URL if the object is in the category",
// "Categorize %s" => "Categorize %s",
// "Categorize %s in %s" => "Categorize %s in %s",
// "Displays the number of pages received (via Communications)" => "Displays the number of pages received (via Communications)",
// "Last directory sites" => "Last directory sites",
// "Displays the specified number of the directory sites most recently added" => "Displays the specified number of the directory sites most recently added",
// "Directory category identifier" => "Directory category identifier",
// "If set to a directory category identifier, only displays the sites in the specified directory category" => "If set to a directory category identifier, only displays the sites in the specified directory category",
// "If set to \"y\", displays a button labelled \"More\" that links to the directory" => "If set to \"y\", displays a button labelled \"More\" that links to the directory",
// "Directory statistics" => "Directory statistics",
// "Displays statistics about the directory, including the number of sites validated and to validate, the number of categories, of searches and of visited links" => "Displays statistics about the directory, including the number of sites validated and to validate, the number of categories, of searches and of visited links",
// "Top directory sites" => "Top directory sites",
// "Displays the specified number of the directory sites from most visited to least visited" => "Displays the specified number of the directory sites from most visited to least visited",
// "Displays the site\\'s first featured links" => "Displays the site\\'s first featured links",
// "Displays links to file galleries" => "Displays links to file galleries",
// "Best rated topics" => "Best rated topics",
// "Displays the specified number of the forum topics with the best ratings" => "Displays the specified number of the forum topics with the best ratings",
// "Displays the latest forum posts" => "Displays the latest forum posts",
// "If set to \"y\", only displays topics" => "If set to \"y\", only displays topics",
// "Displays the specified number of the forums with the most comments" => "Displays the specified number of the forums with the most comments",
// "Displays the specified number of the forum topics with the most reads" => "Displays the specified number of the forum topics with the most reads",
// "Displays the specified number of the forums with the most visits" => "Displays the specified number of the forums with the most visits",
// "Freetags editor" => "Freetags editor",
// "Shows current freetags and enables to add and remove some if permissions allow" => "Shows current freetags and enables to add and remove some if permissions allow",
// "Freetags Wiki" => "Freetags Wiki",
// "Displays current freetags on wiki pages and enables to add tags if permissions allow" => "Displays current freetags on wiki pages and enables to add tags if permissions allow",
// "Similar freetags" => "Similar freetags",
// "Shows wiki pages with similar freetags" => "Shows wiki pages with similar freetags",
// "Similar pages" => "Similar pages",
// "Most popular tags" => "Most popular tags",
// "Shows the most popular freetags. More popularity is indicated by a larger font" => "Shows the most popular freetags. More popularity is indicated by a larger font",
// "Display type" => "Display type",
// "If set to \"cloud\", links are displayed as a cloud" => "If set to \"cloud\", links are displayed as a cloud",
// "Default: \"list\"" => "Default: \"list\"",
// "Maximum elements" => "Maximum elements",
// "If set to a number, limits the number of tags displayed" => "If set to a number, limits the number of tags displayed",
// "User preferred tags" => "User preferred tags",
// "Displays to registered users the freetags they prefer, based on the number of objects they added the tag to. More preference is indicated by a larger font" => "Displays to registered users the freetags they prefer, based on the number of objects they added the tag to. More preference is indicated by a larger font",
// "My preferred tags" => "My preferred tags",
// "Displays a simple form to search on Google. By default, search results are limited to those on the Tiki site" => "Displays a simple form to search on Google. By default, search results are limited to those on the Tiki site",
// "Groups emulation" => "Groups emulation",
// "Enables temporarily changing one\\'s group memberships to see how users in fewer groups experience the site" => "Enables temporarily changing one\\'s group memberships to see how users in fewer groups experience the site",
// "Emulate Groups" => "Emulate Groups",
// "Displays the specified number of last actions" => "Displays the specified number of last actions",
// "Show user" => "Show user",
// "If set to \"y\", user names are displayed in the module box" => "If set to \"y\", user names are displayed in the module box",
// "Show date" => "Show date",
// "If set to \"y\", action dates are displayed in the module box" => "If set to \"y\", action dates are displayed in the module box",
// "Maximum number of characters in action descriptions before truncating" => "Maximum number of characters in action descriptions before truncating",
// "Lists the specified number of blogs posts from newest to oldest" => "Lists the specified number of blogs posts from newest to oldest",
// "If set to \"y\", the date of posts is not displayed in the module box" => "If set to \"y\", the date of posts is not displayed in the module box",
// "Blog identifier" => "Blog identifier",
// "If set to a blog identifier, restricts the blog posts to those in the identified blog" => "If set to a blog identifier, restricts the blog posts to those in the identified blog",
// "Last category objects" => "Last category objects",
// "Lists the specified number of objects of the given type in the given category, starting from the most recently created" => "Lists the specified number of objects of the given type in the given category, starting from the most recently created",
// "Identifier of the category from which objects are listed. Objects merely in child categories will not be displayed" => "Identifier of the category from which objects are listed. Objects merely in child categories will not be displayed",
// "Maximum number of characters in object names allowed before truncating" => "Maximum number of characters in object names allowed before truncating",
// "Type of the objects to list. Example values" => "Type of the objects to list. Example values",
// "Displays the specified number of blogs from newest to oldest" => "Displays the specified number of blogs from newest to oldest",
// "Displays the specified number of FAQs from newest to oldest" => "Displays the specified number of FAQs from newest to oldest",
// "Displays the specified number of quizzes from newest to oldest" => "Displays the specified number of quizzes from newest to oldest",
// "Displays the specified number of file galleries, starting from the most recently modified" => "Displays the specified number of file galleries, starting from the most recently modified",
// "List the specified number of files, starting from the most recently added" => "List the specified number of files, starting from the most recently added",
// "Gallery identifiers" => "Gallery identifiers",
// "If set to a set of file gallery identifiers, restricts the files to those in the identified galleries. The value is a colon-separated sequence of integers" => "If set to a set of file gallery identifiers, restricts the files to those in the identified galleries. The value is a colon-separated sequence of integers",
// "Example value: 13, 2:13, 1:2:3:5:6" => "Example value: 13, 2:13, 1:2:3:5:6",
// "Last modified image galleries" => "Last modified image galleries",
// "Displays the specified number of image galleries, starting from the most recently modified" => "Displays the specified number of image galleries, starting from the most recently modified",
// "List the specified number of images, starting from the most recently added" => "List the specified number of images, starting from the most recently added",
// "Gallery identifier" => "Gallery identifier",
// "If set to an image gallery identifier, restricts the images to those in the identified gallery" => "If set to an image gallery identifier, restricts the images to those in the identified gallery",
// "Link content" => "Link content",
// "Display the links as image names or thumbnails" => "Display the links as image names or thumbnails",
// "Possible values: \"names\" or \"thumbnails\". Default value: \"names\"" => "Possible values: \"names\" or \"thumbnails\". Default value: \"names\"",
// "Displays the specified number of calendar events, starting from the most recently modified" => "Displays the specified number of calendar events, starting from the most recently modified",
// "Calendar identifier" => "Calendar identifier",
// "If set to a calendar identifier, restricts the events to those in the identified calendar" => "If set to a calendar identifier, restricts the events to those in the identified calendar",
// "Maximum number of characters in event names allowed before truncating" => "Maximum number of characters in event names allowed before truncating",
// "Lists the specified number of pages, starting from the most recently modified" => "Lists the specified number of pages, starting from the most recently modified",
// "Link target" => "Link target",
// "Target URL of the \"...more\" link at the bottom of the module" => "Target URL of the \"...more\" link at the bottom of the module",
// "Displays the specified number of blogs, starting from the most recently modified" => "Displays the specified number of blogs, starting from the most recently modified",
// "Lists the specified number of article submissions from newest to oldest" => "Lists the specified number of article submissions from newest to oldest",
// "Last tracker comments" => "Last tracker comments",
// "Lists the specified number of tracker comments (optionally restricting to those in a specific tracker or tracker item) starting from the most recently posted" => "Lists the specified number of tracker comments (optionally restricting to those in a specific tracker or tracker item) starting from the most recently posted",
// "Tracker identifier" => "Tracker identifier",
// "If set to a tracker identifier, only displays the comments on the given tracker" => "If set to a tracker identifier, only displays the comments on the given tracker",
// "Item identifier" => "Item identifier",
// "If set to an item identifier, only displays the comments on the given item" => "If set to an item identifier, only displays the comments on the given item",
// "Last tracker items" => "Last tracker items",
// "Displays the value of a field of the specified number of tracker items. If the specified tracker has no main field, either Field name or Field identifier is required" => "Displays the value of a field of the specified number of tracker items. If the specified tracker has no main field, either Field name or Field identifier is required",
// "Identifier of the tracker from which items are listed" => "Identifier of the tracker from which items are listed",
// "Field identifier" => "Field identifier",
// "Identifier of the field from which values are listed. If Field name is set, this parameter is ignored" => "Identifier of the field from which values are listed. If Field name is set, this parameter is ignored",
// "Field name" => "Field name",
// "Name of the field from which values are listed" => "Name of the field from which values are listed",
// "Example value: age" => "Example value: age",
// "Specifies how the items should be sorted" => "Specifies how the items should be sorted",
// "Possible values include created and created_asc (equivalent), created_desc, status, lastModif, createdBy and lastModifBy. Unless \"_desc\" is specified, the sort is ascending. \"created\" sorts on item creation date. \"lastModif\" sorts on the last modification date of items. \"lastModif_desc\" sorts in descending order of last modification date" => "Possible values include created and created_asc (equivalent), created_desc, status, lastModif, createdBy and lastModifBy. Unless \"_desc\" is specified, the sort is ascending. \"created\" sorts on item creation date. \"lastModif\" sorts on the last modification date of items. \"lastModif_desc\" sorts in descending order of last modification date",
// "Status filter" => "Status filter",
// "If set, limits the listed items to those with the given statuses. Values are combinations of \"o\" (open), \"p\" (pending) and \"c\" (closed). Possible values" => "If set, limits the listed items to those with the given statuses. Values are combinations of \"o\" (open), \"p\" (pending) and \"c\" (closed). Possible values",
// "Unable to determine which field to show. Tracker identifier may be invalid, or the tracker has no main field and neither Field identifier nor Field name were set" => "Unable to determine which field to show. Tracker identifier may be invalid, or the tracker has no main field and neither Field identifier nor Field name were set",
// "You do not have permission to view this tracker" => "You do not have permission to view this tracker",
// "Last Validated FAQs Questions" => "Last Validated FAQs Questions",
// "Displays the specified number of validated questions FAQs from newest to oldest" => "Displays the specified number of validated questions FAQs from newest to oldest",
// "Faq identifier" => "Faq identifier",
// "If set to a faq identifier, restricts the chosen questions to those in the identified faq" => "If set to a faq identifier, restricts the chosen questions to those in the identified faq",
// "Number of characters to display" => "Number of characters to display",
// "Displays information about the specified number of users in decreasing order of last login time" => "Displays information about the specified number of users in decreasing order of last login time",
// "Show avatars" => "Show avatars",
// "If set to \"y\", show user avatars" => "If set to \"y\", show user avatars",
// "Maximum number of characters in user names allowed before truncating" => "Maximum number of characters in user names allowed before truncating",
// "Tells users whether a live support operator is present and allows them to request support if possible. If the user is an operator, links to the operator console" => "Tells users whether a live support operator is present and allows them to request support if possible. If the user is an operator, links to the operator console",
// "Login box" => "Login box",
// "Input size" => "Input size",
// "Number of characters for username and password input fields" => "Number of characters for username and password input fields",
// "Logo" => "Logo",
// "Site logo, title and subtitle" => "Site logo, title and subtitle",
// "Menu page" => "Menu page",
// "Displays a Wiki page" => "Displays a Wiki page",
// "Page to display in the menu. Example value: HomePage" => "Page to display in the menu. Example value: HomePage",
// "Unread inter-user messages" => "Unread inter-user messages",
// "Displays to users their number of new inter-user messages and a link to their message box" => "Displays to users their number of new inter-user messages and a link to their message box",
// "Small live chat box" => "Small live chat box",
// "Channels" => "Channels",
// "List of chat channels. Channel names are separated by a comma (\",\")" => "List of chat channels. Channel names are separated by a comma (\",\")",
// "By default, a single channel named \"default\" exists" => "By default, a single channel named \"default\" exists",
// "Months links" => "Months links",
// "Links to the objects of a given type for the current month and those preceding it" => "Links to the objects of a given type for the current month and those preceding it",
// "Type of objects to link to" => "Type of objects to link to",
// "\"blogs\" for blog posts, \"cms\" for published articles" => "\"blogs\" for blog posts, \"cms\" for published articles",
// "Object identifier" => "Object identifier",
// "Identifier of an object with children to link to" => "Identifier of an object with children to link to",
// "This is required for the blog Object type" => "This is required for the blog Object type",
// "For example, an identifier of 3 and a blogs Object type will show links to the blog posts in the blog with identifier 3" => "For example, an identifier of 3 and a blogs Object type will show links to the blog posts in the blog with identifier 3",
// "List by month" => "List by month",
// "Displays the number of article submissions waiting examination and a link to the list" => "Displays the number of article submissions waiting examination and a link to the list",
// "Displays the specified number of old articles (which do not show on articles home page anymore)" => "Displays the specified number of old articles (which do not show on articles home page anymore)",
// "Enables to change current perspective" => "Enables to change current perspective",
// "Quick Edit" => "Quick Edit",
// "Enables to quickly create or edit Wiki pages" => "Enables to quickly create or edit Wiki pages",
// "Template identifier" => "Template identifier",
// "If set to a template identifier, the specified template is used for creating new Wiki pages" => "If set to a template identifier, the specified template is used for creating new Wiki pages",
// "If set, send the form to the given location (relative to Tiki\\'s root) for processing" => "If set, send the form to the given location (relative to Tiki\\'s root) for processing",
// "SUBMIT label" => "SUBMIT label",
// "The label on the button to submit the form" => "The label on the button to submit the form",
// "Size attribute (horizontal, in characters) of the text input field for page names" => "Size attribute (horizontal, in characters) of the text input field for page names",
// "Optional heading to display at the top of the module\\'s content" => "Optional heading to display at the top of the module\\'s content",
// "If set to a category identifier, pages created through the module are automatically categorized in the specified category" => "If set to a category identifier, pages created through the module are automatically categorized in the specified category",
// "Random image" => "Random image",
// "Displays a random image" => "Displays a random image",
// "If set to an image gallery identifier, restricts the chosen images to those in the identified gallery" => "If set to an image gallery identifier, restricts the chosen images to those in the identified gallery",
// "Show link" => "Show link",
// "If set to \"n\", the image thumbnail does not link to the image" => "If set to \"n\", the image thumbnail does not link to the image",
// "Default: \"y\"" => "Default: \"y\"",
// "Show name" => "Show name",
// "If set to \"y\", the name of the image is displayed" => "If set to \"y\", the name of the image is displayed",
// "If set to \"y\", the description of the image is displayed" => "If set to \"y\", the description of the image is displayed",
// "Displays the specified number of random wiki pages" => "Displays the specified number of random wiki pages",
// "New user registrationmore tiki-re" => "New user registrationmore tiki-re",
// "Feeds List" => "Feeds List",
// "List of feeds available on this site" => "List of feeds available on this site",
// "Search Box" => "Search Box",
// "Advanced search (for wiki, articles, blogs etc)" => "Advanced search (for wiki, articles, blogs etc)",
// "Search Box (new)" => "Search Box (new)",
// "Search Wiki Page" => "Search Wiki Page",
// "Search for a wiki page by name" => "Search for a wiki page by name",
// "Search Wiki Page (new)" => "Search Wiki Page (new)",
// "Lists the relationships known for the Wiki page displayed. For each relation type contained in the page, it lists all the pages it links to or gets linked from" => "Lists the relationships known for the Wiki page displayed. For each relation type contained in the page, it lists all the pages it links to or gets linked from",
// "The shoutbox is a quick messaging tool. Messages reload each time the page changes. Anyone with the right permission can see all messages. Another permission allows to send messages" => "The shoutbox is a quick messaging tool. Messages reload each time the page changes. Anyone with the right permission can see all messages. Another permission allows to send messages",
// "Tooltip" => "Tooltip",
// "If set to \"1\", displays message post dates and times as tooltips instead of showing directly in the module content" => "If set to \"1\", displays message post dates and times as tooltips instead of showing directly in the module content",
// "Label on the button to post a message" => "Label on the button to post a message",
// "Wait label" => "Wait label",
// "Label on the button to post a message when the message is being posted if AJAX is enabled" => "Label on the button to post a message when the message is being posted if AJAX is enabled",
// "Maximum messages shown" => "Maximum messages shown",
// "Number of messages to display" => "Number of messages to display",
// "Please wait.." => "Please wait..",
// "Since last visit (simple)" => "Since last visit (simple)",
// "Displays to logged in users the number of new or updated objects since their last login date and time" => "Displays to logged in users the number of new or updated objects since their last login date and time",
// "Since last visit" => "Since last visit",
// "Displays to logged in users new or updated objects since a point in time, by default their last login date and time" => "Displays to logged in users new or updated objects since a point in time, by default their last login date and time",
// "Show users" => "Show users",
// "If set to \"n\", do not show new users" => "If set to \"n\", do not show new users",
// "Show trackers" => "Show trackers",
// "If set to \"n\", do not show tracker changes" => "If set to \"n\", do not show tracker changes",
// "Calendar focus" => "Calendar focus",
// "Unless set to \"ignore\", the module changes the reference point in time from the user\\'s last login date and time to a day where users browse to using the calendar" => "Unless set to \"ignore\", the module changes the reference point in time from the user\\'s last login date and time to a day where users browse to using the calendar",
// "Since your last visit.." => "Since your last visit..",
// "updated tracker items" => "updated tracker items",
// "Switch Language" => "Switch Language",
// "Displays a language picker to change the language of the site" => "Displays a language picker to change the language of the site",
// "Display mode" => "Display mode",
// "Changes how the list of languages is displayed. Possible values are droplist, flags and words. Defaults to droplist" => "Changes how the list of languages is displayed. Possible values are droplist, flags and words. Defaults to droplist",
// "Prefix" => "Prefix",
// "Changes the default displayed prefix from \\\"Site Language:\\\"" => "Changes the default displayed prefix from \\\"Site Language:\\\"",
// "Switch theme" => "Switch theme",
// "Enables to quickly change the theme" => "Enables to quickly change the theme",
// "Terminology" => "Terminology",
// "Support for multilingual terminology" => "Support for multilingual terminology",
// "Tiki Tests" => "Tiki Tests",
// "Tiki test suite helper" => "Tiki test suite helper",
// "Displays the specified number of blogs with links to them, from the most active one to the least" => "Displays the specified number of blogs with links to them, from the most active one to the least",
// "Blog activity measurement can be more or less accurate" => "Blog activity measurement can be more or less accurate",
// "Lists the specified number of articles with links to them, from the most visited one to the least" => "Lists the specified number of articles with links to them, from the most visited one to the least",
// "Displays the specified number of file galleries with links to them, starting with the one with most hits" => "Displays the specified number of file galleries with links to them, starting with the one with most hits",
// "Displays the specified number of files with links to them, starting with the one with most hits" => "Displays the specified number of files with links to them, starting with the one with most hits",
// "Displays the specified number of users who posted to forums, starting with the one having most posts" => "Displays the specified number of users who posted to forums, starting with the one having most posts",
// "Top image galleries" => "Top image galleries",
// "Displays the specified number of image galleries with links to them, starting with the one with most hits" => "Displays the specified number of image galleries with links to them, starting with the one with most hits",
// "Displays the specified number of images with links to them, from the most visited one to the least" => "Displays the specified number of images with links to them, from the most visited one to the least",
// "Displays the specified number of objects, starting with the one having the most hits" => "Displays the specified number of objects, starting with the one having the most hits",
// "Displays the specified number of wiki pages with links to them, starting with the one having the most hits" => "Displays the specified number of wiki pages with links to them, starting with the one having the most hits",
// "Displays the specified number of quizzes with links to them, starting with the one having the most hits" => "Displays the specified number of quizzes with links to them, starting with the one having the most hits",
// "Displays the specified number of blogs with links to them, from the most visited one to the least" => "Displays the specified number of blogs with links to them, from the most visited one to the least",
// "Displays the specified number of FAQs with links to them, from the most visited one to the least" => "Displays the specified number of FAQs with links to them, from the most visited one to the least",
// "Page translation" => "Page translation",
// "Links to versions of the wiki page being viewed in other languages, distinguishing between better, equivalent or worse translations. Optionally displays the up-to-dateness of the translation being viewed" => "Links to versions of the wiki page being viewed in other languages, distinguishing between better, equivalent or worse translations. Optionally displays the up-to-dateness of the translation being viewed",
// "Reference language" => "Reference language",
// "If set to a language code, restricts the localized pages shown to the reference page, unless that page is being displayed" => "If set to a language code, restricts the localized pages shown to the reference page, unless that page is being displayed",
// "Lists the specified number of calendar events, ordered by their start date" => "Lists the specified number of calendar events, ordered by their start date",
// "Calendars filter" => "Calendars filter",
// "If set to a list of calendar identifiers, restricts the events to those in the identified calendars. Identifiers are separated by vertical bars (\"|\"), commas (\",\") or colons (\":\")" => "If set to a list of calendar identifiers, restricts the events to those in the identified calendars. Identifiers are separated by vertical bars (\"|\"), commas (\",\") or colons (\":\")",
// "Maximum days in the future" => "Maximum days in the future",
// "Maximum distance to event start dates in days (looking forward)" => "Maximum distance to event start dates in days (looking forward)",
// "Maximum days in the past" => "Maximum days in the past",
// "Maximum distance to event end dates in days (looking backward)" => "Maximum distance to event end dates in days (looking backward)",
// "cellpadding" => "cellpadding",
// "cellspacing" => "cellspacing",
// "If set to \"y\", event descriptions are displayed" => "If set to \"y\", event descriptions are displayed",
// "Show end date and time" => "Show end date and time",
// "If set to \"y\", event end dates and times are displayed, when appropriate" => "If set to \"y\", event end dates and times are displayed, when appropriate",
// "Use custom calendar background colors" => "Use custom calendar background colors",
// "If set to \"y\", events are displayed with their calendar\\'s custom background color (if one is set)" => "If set to \"y\", events are displayed with their calendar\\'s custom background color (if one is set)",
// "Show information in tooltips" => "Show information in tooltips",
// "If set to \"n\", event tooltips will not display event information" => "If set to \"n\", event tooltips will not display event information",
// "Date format" => "Date format",
// "Format to use for most dates. See <a href=\"http://www.php.net/manual/en/function.strftime.php\">strftime() documentation</a>" => "Format to use for most dates. See <a href=\"http://www.php.net/manual/en/function.strftime.php\">strftime() documentation</a>",
// "site preference for short date format followed by site preference for short time format" => "site preference for short date format followed by site preference for short time format",
// "If set to an integer, event names are allowed that number of characters as a maximum before being truncated" => "If set to an integer, event names are allowed that number of characters as a maximum before being truncated",
// "Displays to registered users their blogs" => "Displays to registered users their blogs",
// "Lightweight interface to user bookmarks, enabling to view them concisely, do some manipulations and bookmark the page being viewed" => "Lightweight interface to user bookmarks, enabling to view them concisely, do some manipulations and bookmark the page being viewed",
// "User image galleries" => "User image galleries",
// "Displays to registered users their image galleries" => "Displays to registered users their image galleries",
// "Displays to registered users the specified number of wiki pages which they were the last to edit" => "Displays to registered users the specified number of wiki pages which they were the last to edit",
// "Lightweight interface to user tasks, enabling to view them concisely and do some manipulations" => "Lightweight interface to user tasks, enabling to view them concisely and do some manipulations",
// "Lists the public user tasks of a chosen group, with links to tasks" => "Lists the public user tasks of a chosen group, with links to tasks",
// "User-Group Tracker" => "User-Group Tracker",
// "User and Group tracker links" => "User and Group tracker links",
// "Displays the specified number of users and their score, starting from the one with the highest score" => "Displays the specified number of users and their score, starting from the one with the highest score",
// "Webmail Inbox" => "Webmail Inbox",
// "Displays Webmail Inbox" => "Displays Webmail Inbox",
// "Account Id" => "Account Id",
// "Webmail account identifier (if not set uses user\\'s current account)" => "Webmail account identifier (if not set uses user\\'s current account)",
// "GroupMail: Group (e.g. \"Help Team\")" => "GroupMail: Group (e.g. \"Help Team\")",
// "GroupMail: Tracker Id (to store GroupMail activity)" => "GroupMail: Tracker Id (to store GroupMail activity)",
// "GroupMail: From Field (Id of field in tracker to store email From header)" => "GroupMail: From Field (Id of field in tracker to store email From header)",
// "Subject Field Id" => "Subject Field Id",
// "GroupMail: Subject Field (Id of field in tracker to store email Subject header)" => "GroupMail: Subject Field (Id of field in tracker to store email Subject header)",
// "Message Field Id" => "Message Field Id",
// "GroupMail: Message Field (Id of field in tracker to store email message identifier)" => "GroupMail: Message Field (Id of field in tracker to store email message identifier)",
// "Content Field Id" => "Content Field Id",
// "GroupMail: Content Field (Id of field in tracker to store email message body content)" => "GroupMail: Content Field (Id of field in tracker to store email message body content)",
// "Account Field Id" => "Account Field Id",
// "GroupMail: Account Field (Id of field in tracker to store Webmail account name)" => "GroupMail: Account Field (Id of field in tracker to store Webmail account name)",
// "DateTime Field Id" => "DateTime Field Id",
// "GroupMail: Date Time Field (Id of field in tracker to store email sent timestamp)" => "GroupMail: Date Time Field (Id of field in tracker to store email sent timestamp)",
// "Operator Field Id" => "Operator Field Id",
// "GroupMail: Operator Field (Id of field in tracker to store operator name (username))" => "GroupMail: Operator Field (Id of field in tracker to store operator name (username))",
// "Maximum number of characters in subjects allowed before truncating" => "Maximum number of characters in subjects allowed before truncating",
// "Webmail error" => "Webmail error",
// "No accounts set up (or no current account set)" => "No accounts set up (or no current account set)",
// "Wiki Page" => "Wiki Page",
// "What is related" => "What is related",
// "Lists objects which share a category with the viewed object" => "Lists objects which share a category with the viewed object",
// "Displays information about users currently logged in" => "Displays information about users currently logged in",
// "Content to display" => "Content to display",
// "Display the number of users logged in, the list of users logged in, or both" => "Display the number of users logged in, the list of users logged in, or both",
// "Possible values: \"count\", \"list\" or \"both\". Default value: \"both\"" => "Possible values: \"count\", \"list\" or \"both\". Default value: \"both\"",
// "Cluster mode" => "Cluster mode",
// "If set to \"1\", separate users based on which host/server they logged on" => "If set to \"1\", separate users based on which host/server they logged on",
// "Last comments" => "Last comments",
// "Lists the specified number of comments starting from the most recently posted" => "Lists the specified number of comments starting from the most recently posted",
// "If set to \"y\", the name of the object on which a comment is made is not displayed in the module box, but instead moved in the item\\'s tooltip" => "If set to \"y\", the name of the object on which a comment is made is not displayed in the module box, but instead moved in the item\\'s tooltip",
// "Type of the objects from which comments will be listed. Possible values" => "Type of the objects from which comments will be listed. Possible values",
// "Last article comments" => "Last article comments",
// "YouTube" => "YouTube",
// "Displays YouTube videos and/or a link to a YouTube user\\'s page" => "Displays YouTube videos and/or a link to a YouTube user\\'s page",
// "Video identifiers" => "Video identifiers",
// "List of YouTube videos identifiers to display. Identifiers are separated by a comma (\",\")" => "List of YouTube videos identifiers to display. Identifiers are separated by a comma (\",\")",
// "YouTube user identifier" => "YouTube user identifier",
// "If set to a YouTube user identifier, display a link to the videos of this user" => "If set to a YouTube user identifier, display a link to the videos of this user",
// "Width of each video in pixels" => "Width of each video in pixels",
// "Height of each video in pixels" => "Height of each video in pixels",
// "Videos on YouTube" => "Videos on YouTube",
// "Cookie not found" => "Cookie not found",
// "Can create/admin calendars" => "Can create/admin calendars",
// "Can add events in the calendar" => "Can add events in the calendar",
// "Can change events in the calendar" => "Can change events in the calendar",
// "Can browse the calendar" => "Can browse the calendar",
// "Can view events details" => "Can view events details",
// "Can view Tikiwiki tools calendar" => "Can view Tikiwiki tools calendar",
// "Administrator, can create channels remove channels etc" => "Administrator, can create channels remove channels etc",
// "Can use the chat system" => "Can use the chat system",
// "Can admin the cms" => "Can admin the cms",
// "Can approve submissions" => "Can approve submissions",
// "Can admin article topics" => "Can admin article topics",
// "Can admin article types" => "Can admin article types",
// "Can read article headings" => "Can read article headings",
// "Submited articles automatically approved" => "Submited articles automatically approved",
// "Can edit articles" => "Can edit articles",
// "Can edit submissions" => "Can edit submissions",
// "Can read articles" => "Can read articles",
// "Can remove articles" => "Can remove articles",
// "Can remove submissions" => "Can remove submissions",
// "Can submit articles" => "Can submit articles",
// "Can read a topic (Applies only to individual topic perms)" => "Can read a topic (Applies only to individual topic perms)",
// "Can admin contributions" => "Can admin contributions",
// "Can admin the directory" => "Can admin the directory",
// "Can admin directory categories" => "Can admin directory categories",
// "Can admin directory sites" => "Can admin directory sites",
// "Submited links are valid" => "Submited links are valid",
// "Can submit sites to the directory" => "Can submit sites to the directory",
// "Can validate submited links" => "Can validate submited links",
// "Can use the directory" => "Can use the directory",
// "Can admin faqs" => "Can admin faqs",
// "Can suggest faq questions" => "Can suggest faq questions",
// "Can view faqs" => "Can view faqs",
// "Administrator, can manage users groups and permissions, Hotwords and all the weblog features" => "Administrator, can manage users groups and permissions, Hotwords and all the weblog features",
// "Can admin users" => "Can admin users",
// "Can access site when closed" => "Can access site when closed",
// "Administrator, can admin banners" => "Administrator, can admin banners",
// "Can ban users or ips" => "Can ban users or ips",
// "Can admin the dynamic content system" => "Can admin the dynamic content system",
// "Can admin integrator repositories and rules" => "Can admin integrator repositories and rules",
// "Can admin mail-in accounts" => "Can admin mail-in accounts",
// "Can edit object permissions" => "Can edit object permissions",
// "Can admin external feeds" => "Can admin external feeds",
// "Can clean cache" => "Can clean cache",
// "Can create new css suffixed with -user" => "Can create new css suffixed with -user",
// "Can remove association between two pages in a translation set" => "Can remove association between two pages in a translation set",
// "Can admin cookies" => "Can admin cookies",
// "Can edit translations and create new languages" => "Can edit translations and create new languages",
// "Can edit menu" => "Can edit menu",
// "Can edit menu option" => "Can edit menu option",
// "Can edit site templates" => "Can edit site templates",
// "Can search" => "Can search",
// "Can report a link to the webmaster" => "Can report a link to the webmaster",
// "Can subscribe to groups" => "Can subscribe to groups",
// "Can send a link to a friend" => "Can send a link to a friend",
// "Can use HTML in pages" => "Can use HTML in pages",
// "Can view action log" => "Can view action log",
// "Can view action log for users of his own groups" => "Can view action log for users of his own groups",
// "Can view integrated repositories" => "Can view integrated repositories",
// "Can view referer stats" => "Can view referer stats",
// "Can view site stats" => "Can view site stats",
// "Can view site templates" => "Can view site templates",
// "Can admin blogs" => "Can admin blogs",
// "Can assign perms to blog" => "Can assign perms to blog",
// "Can post to a blog" => "Can post to a blog",
// "Can create a blog" => "Can create a blog",
// "Can read blogs" => "Can read blogs",
// "Can admin file galleries" => "Can admin file galleries",
// "Can assign perms to file gallery" => "Can assign perms to file gallery",
// "Can use Directory Batch Load" => "Can use Directory Batch Load",
// "Can upload zip files with files" => "Can upload zip files with files",
// "Can create file galleries" => "Can create file galleries",
// "Can download files" => "Can download files",
// "Can edit a gallery file" => "Can edit a gallery file",
// "Can list file galleries" => "Can list file galleries",
// "Can upload files" => "Can upload files",
// "Can view file galleries explorer" => "Can view file galleries explorer",
// "Can view file galleries path" => "Can view file galleries path",
// "Can view file galleries" => "Can view file galleries",
// "Can admin forums" => "Can admin forums",
// "Can attach to forum posts" => "Can attach to forum posts",
// "Auto approve forum posts" => "Auto approve forum posts",
// "Can edit own forum posts" => "Can edit own forum posts",
// "Can post in forums" => "Can post in forums",
// "Can start threads in forums" => "Can start threads in forums",
// "Can read forums" => "Can read forums",
// "Can report msgs to moderator" => "Can report msgs to moderator",
// "Can vote comments in forums" => "Can vote comments in forums",
// "Can admin freetags" => "Can admin freetags",
// "Can admin Image Galleries" => "Can admin Image Galleries",
// "Can assign perms to image gallery" => "Can assign perms to image gallery",
// "Can upload zip files with images" => "Can upload zip files with images",
// "Can create image galleries" => "Can create image galleries",
// "Can tag objects" => "Can tag objects",
// "Can list image galleries" => "Can list image galleries",
// "Can unassign tags from an object" => "Can unassign tags from an object",
// "Can upload images" => "Can upload images",
// "Can browse freetags" => "Can browse freetags",
// "Can view image galleries" => "Can view image galleries",
// "Can admin newsletters" => "Can admin newsletters",
// "Can subscribe many e-mails at once (requires tiki_p_subscribe email)" => "Can subscribe many e-mails at once (requires tiki_p_subscribe email)",
// "Can send newsletters" => "Can send newsletters",
// "Can subscribe any email to newsletters" => "Can subscribe any email to newsletters",
// "Can subscribe to newsletters" => "Can subscribe to newsletters",
// "Can list newsletters" => "Can list newsletters",
// "Can admin polls" => "Can admin polls",
// "Can view poll results" => "Can view poll results",
// "Can vote polls" => "Can vote polls",
// "Can view poll voters" => "Can view poll voters",
// "Can admin toolbars" => "Can admin toolbars",
// "Can admin quizzes" => "Can admin quizzes",
// "Can take quizzes" => "Can take quizzes",
// "Can view quiz stats" => "Can view quiz stats",
// "Can view user quiz results" => "Can view user quiz results",
// "Can admin sheet" => "Can admin sheet",
// "Can create and edit sheets" => "Can create and edit sheets",
// "Can view sheet" => "Can view sheet",
// "Can view sheet history" => "Can view sheet history",
// "Can admin shoutbox (Edit/remove msgs)" => "Can admin shoutbox (Edit/remove msgs)",
// "Can post messages in shoutbox" => "Can post messages in shoutbox",
// "Can view shoutbox" => "Can view shoutbox",
// "Can admin surveys" => "Can admin surveys",
// "Can take surveys" => "Can take surveys",
// "Can view survey stats" => "Can view survey stats",
// "Can admin trackers" => "Can admin trackers",
// "Can attach files to tracker items" => "Can attach files to tracker items",
// "Can insert comments for tracker items" => "Can insert comments for tracker items",
// "Can view tracker items comments" => "Can view tracker items comments",
// "Can create new items for trackers" => "Can create new items for trackers",
// "Can list trackers" => "Can list trackers",
// "Can change tracker items" => "Can change tracker items",
// "Can change tracker pending items" => "Can change tracker pending items",
// "Can change tracker closed items" => "Can change tracker closed items",
// "Can view rating result for tracker items" => "Can view rating result for tracker items",
// "Can vote a rating for tracker items" => "Can vote a rating for tracker items",
// "Can view trackers" => "Can view trackers",
// "Can view trackers closed items" => "Can view trackers closed items",
// "Can view trackers pending items" => "Can view trackers pending items",
// "Can watch tracker" => "Can watch tracker",
// "Can export tracker items" => "Can export tracker items",
// "Can admin the wiki" => "Can admin the wiki",
// "Can assign perms to wiki pages" => "Can assign perms to wiki pages",
// "Can edit pages" => "Can edit pages",
// "Can edit copyright notices" => "Can edit copyright notices",
// "Can edit dynamic variables" => "Can edit dynamic variables",
// "Can create and edit structures" => "Can create and edit structures",
// "Can export wiki pages using the export feature" => "Can export wiki pages using the export feature",
// "Can lock pages" => "Can lock pages",
// "Can save as minor edit" => "Can save as minor edit",
// "Can remove" => "Can remove",
// "Can rename pages" => "Can rename pages",
// "Can rollback pages" => "Can rollback pages",
// "Can upload pictures to wiki pages" => "Can upload pictures to wiki pages",
// "Can use the page as a tracker template" => "Can use the page as a tracker template",
// "Can view page/pages" => "Can view page/pages",
// "Can watch structure" => "Can watch structure",
// "Can admin attachments to wiki pages" => "Can admin attachments to wiki pages",
// "Can add and change ratings on wiki pages" => "Can add and change ratings on wiki pages",
// "Can attach files to wiki pages" => "Can attach files to wiki pages",
// "Can view wiki attachments and download" => "Can view wiki attachments and download",
// "Can view wiki comments" => "Can view wiki comments",
// "Can view wiki history" => "Can view wiki history",
// "Can view rating of wiki pages" => "Can view rating of wiki pages",
// "Can view source of wiki pages" => "Can view source of wiki pages",
// "Can participate to rating of wiki pages" => "Can participate to rating of wiki pages",
// "Can view similar wiki pages" => "Can view similar wiki pages",
// "Can admin received articles" => "Can admin received articles",
// "Can admin received pages" => "Can admin received pages",
// "Can send articles to other sites" => "Can send articles to other sites",
// "Can send articles to this site" => "Can send articles to this site",
// "Can send pages to this site" => "Can send pages to this site",
// "Can send pages to other sites" => "Can send pages to other sites",
// "Can admin the TikiTests" => "Can admin the TikiTests",
// "Can edit TikiTests" => "Can edit TikiTests",
// "Can replay the TikiTests" => "Can replay the TikiTests",
// "Can cache user bookmarks" => "Can cache user bookmarks",
// "Can configure modules" => "Can configure modules",
// "Can create user bookmarks" => "Can create user bookmarks",
// "Can use the mini event calendar" => "Can use the mini event calendar",
// "Can use the notepad" => "Can use the notepad",
// "Can admin public tasks" => "Can admin public tasks",
// "Can use tasks" => "Can use tasks",
// "Can receive tasks from other users" => "Can receive tasks from other users",
// "Can send tasks to other users" => "Can send tasks to other users",
// "Can upload personal files" => "Can upload personal files",
// "Can create items in personal menu" => "Can create items in personal menu",
// "Can broadcast messages to all user" => "Can broadcast messages to all user",
// "Can broadcast messages to groups" => "Can broadcast messages to groups",
// "Can use the messaging system" => "Can use the messaging system",
// "Can admin comments" => "Can admin comments",
// "Can edit all comments" => "Can edit all comments",
// "Can post new comments" => "Can post new comments",
// "Can read comments" => "Can read comments",
// "Can delete comments" => "Can delete comments",
// "Can vote comments" => "Can vote comments",
// "Can admin content templates" => "Can admin content templates",
// "Can edit content templates" => "Can edit content templates",
// "Can use content templates" => "Can use content templates",
// "Can edit HTML pages" => "Can edit HTML pages",
// "Can view HTML pages" => "Can view HTML pages",
// "Can list registered users" => "Can list registered users",
// "Admin live support system" => "Admin live support system",
// "Can use live support system" => "Can use live support system",
// "Can create new mapfile" => "Can create new mapfile",
// "Can delete mapfiles" => "Can delete mapfiles",
// "Can edit mapfiles" => "Can edit mapfiles",
// "Can view mapfiles" => "Can view mapfiles",
// "Can view contents of mapfiles" => "Can view contents of mapfiles",
// "Can use webmail" => "Can use webmail",
// "Can use group webmail" => "Can use group webmail",
// "Can administrate group webmail accounts" => "Can administrate group webmail accounts",
// "Can use personal webmail accounts" => "Can use personal webmail accounts",
// "Can administrate personal webmail accounts" => "Can administrate personal webmail accounts",
// "Can view unapproved plugin details" => "Can view unapproved plugin details",
// "Can execute unapproved plugin" => "Can execute unapproved plugin",
// "Can approve plugin execution" => "Can approve plugin execution",
// "Trust all user inputs (no security checks)" => "Trust all user inputs (no security checks)",
// "View page backlinks" => "View page backlinks",
// "Can admin mail notifications" => "Can admin mail notifications",
// "Can invite user in groups" => "Can invite user in groups",
// "Can delete his own account" => "Can delete his own account",
// "Can use the Tiki Importer" => "Can use the Tiki Importer",
// "Can admin categories" => "Can admin categories",
// "Can see the category in a listing" => "Can see the category in a listing",
// "Can change the categories on the object" => "Can change the categories on the object",
// "Can add objects in the category" => "Can add objects in the category",
// "Can remove objects from the category" => "Can remove objects from the category",
// "Can create new categories" => "Can create new categories",
// "Can view the perspective" => "Can view the perspective",
// "Can view the group" => "Can view the group",
// "Can view the group members" => "Can view the group members",
// "Can add group members" => "Can add group members",
// "Can remove group members" => "Can remove group members",
// "Can join or leave the group" => "Can join or leave the group",
// "Can trigger the transition between two states" => "Can trigger the transition between two states",
// "Can admin kaltura feature" => "Can admin kaltura feature",
// "Can upload video on kaltura server" => "Can upload video on kaltura server",
// "Can edit information of kaltura entry" => "Can edit information of kaltura entry",
// "Can create kaltura remix video" => "Can create kaltura remix video",
// "Can delete kaltura entry" => "Can delete kaltura entry",
// "Can download kaltura entry" => "Can download kaltura entry",
// "Can list kaltura entries" => "Can list kaltura entries",
// "Can view kaltura entry" => "Can view kaltura entry",
// "Can upload screencasts to wiki pages" => "Can upload screencasts to wiki pages",
// "tiki release" => "tiki release",
// "feature version checks" => "feature version checks",
// "tiki needs upgrade" => "tiki needs upgrade",
// "tiki version last check" => "tiki version last check",
// "tiki version check frequency" => "tiki version check frequency",
// "lastUpdatePrefs" => "lastUpdatePrefs",
// "feature print indexed" => "feature print indexed",
// "groups are emulated" => "groups are emulated",
// "feature wiki" => "feature wiki",
// "default wiki diff style" => "default wiki diff style",
// "feature backlinks" => "feature backlinks",
// "feature dump" => "feature dump",
// "feature history" => "feature history",
// "feature lastChanges" => "feature lastChanges",
// "feature likePages" => "feature likePages",
// "feature listPages" => "feature listPages",
// "feature listorphanPages" => "feature listorphanPages",
// "feature listorphanStructure" => "feature listorphanStructure",
// "feature page title" => "feature page title",
// "feature sandbox" => "feature sandbox",
// "feature warn on edit" => "feature warn on edit",
// "feature wiki 1like redirection" => "feature wiki 1like redirection",
// "feature wiki allowhtml" => "feature wiki allowhtml",
// "feature wiki argvariable" => "feature wiki argvariable",
// "feature wiki attachments" => "feature wiki attachments",
// "feature wiki comments" => "feature wiki comments",
// "feature wiki description" => "feature wiki description",
// "feature wiki discuss" => "feature wiki discuss",
// "feature wiki export" => "feature wiki export",
// "feature wiki structure" => "feature wiki structure",
// "feature wiki import page" => "feature wiki import page",
// "feature wiki footnotes" => "feature wiki footnotes",
// "feature wiki icache" => "feature wiki icache",
// "feature wiki import html" => "feature wiki import html",
// "feature wiki mindmap" => "feature wiki mindmap",
// "feature wiki monosp" => "feature wiki monosp",
// "feature wiki multiprint" => "feature wiki multiprint",
// "feature wiki notepad" => "feature wiki notepad",
// "feature wiki make structure" => "feature wiki make structure",
// "feature wiki open as structure" => "feature wiki open as structure",
// "feature wiki pageid" => "feature wiki pageid",
// "feature wiki paragraph formatting" => "feature wiki paragraph formatting",
// "feature wiki paragraph formatting add br" => "feature wiki paragraph formatting add br",
// "feature wiki pictures" => "feature wiki pictures",
// "feature wiki plurals" => "feature wiki plurals",
// "feature wiki print" => "feature wiki print",
// "feature wiki protect email" => "feature wiki protect email",
// "feature wiki rankings" => "feature wiki rankings",
// "feature wiki ratings" => "feature wiki ratings",
// "feature wiki replace" => "feature wiki replace",
// "feature wiki show hide before" => "feature wiki show hide before",
// "feature wiki tables" => "feature wiki tables",
// "feature wiki templates" => "feature wiki templates",
// "feature wiki undo" => "feature wiki undo",
// "feature wiki userpage" => "feature wiki userpage",
// "feature wiki userpage prefix" => "feature wiki userpage prefix",
// "feature wiki usrlock" => "feature wiki usrlock",
// "feature wiki feedback polls" => "feature wiki feedback polls",
// "feature wiki save draft" => "feature wiki save draft",
// "feature wikiwords" => "feature wikiwords",
// "feature wikiwords usedash" => "feature wikiwords usedash",
// "feature wiki pagealias" => "feature wiki pagealias",
// "mailin autocheck" => "mailin autocheck",
// "mailin autocheckFreq" => "mailin autocheckFreq",
// "mailin autocheckLast" => "mailin autocheckLast",
// "page bar position" => "page bar position",
// "warn on edit time" => "warn on edit time",
// "wikiHomePage" => "wikiHomePage",
// "wikiLicensePage" => "wikiLicensePage",
// "wikiSubmitNotice" => "wikiSubmitNotice",
// "wiki authors style" => "wiki authors style",
// "wiki authors style by page" => "wiki authors style by page",
// "wiki dft list pages lang to current" => "wiki dft list pages lang to current",
// "wiki show version" => "wiki show version",
// "wiki bot bar" => "wiki bot bar",
// "wiki cache" => "wiki cache",
// "wiki comments default ordering" => "wiki comments default ordering",
// "wiki comments displayed default" => "wiki comments displayed default",
// "wiki comments per page" => "wiki comments per page",
// "wiki comments allow per page" => "wiki comments allow per page",
// "wiki creator admin" => "wiki creator admin",
// "wiki feature copyrights" => "wiki feature copyrights",
// "wiki forum id" => "wiki forum id",
// "wiki left column" => "wiki left column",
// "wiki list backlinks" => "wiki list backlinks",
// "wiki list comment" => "wiki list comment",
// "wiki list comment len" => "wiki list comment len",
// "wiki list description" => "wiki list description",
// "wiki list description len" => "wiki list description len",
// "wiki list creator" => "wiki list creator",
// "wiki list hits" => "wiki list hits",
// "wiki list lastmodif" => "wiki list lastmodif",
// "wiki list lastver" => "wiki list lastver",
// "wiki list links" => "wiki list links",
// "wiki list name" => "wiki list name",
// "wiki list name len" => "wiki list name len",
// "wiki list size" => "wiki list size",
// "wiki list status" => "wiki list status",
// "wiki list user" => "wiki list user",
// "wiki list versions" => "wiki list versions",
// "wiki list language" => "wiki list language",
// "wiki list categories" => "wiki list categories",
// "wiki list categories path" => "wiki list categories path",
// "wiki list id" => "wiki list id",
// "wiki list sortorder" => "wiki list sortorder",
// "wiki list sortdirection" => "wiki list sortdirection",
// "wiki pagealias tokens" => "wiki pagealias tokens",
// "wiki page regex" => "wiki page regex",
// "wiki page separator" => "wiki page separator",
// "wiki page navigation bar" => "wiki page navigation bar",
// "wiki actions bar" => "wiki actions bar",
// "wiki pagename strip" => "wiki pagename strip",
// "wiki right column" => "wiki right column",
// "wiki top bar" => "wiki top bar",
// "wiki topline position" => "wiki topline position",
// "wiki uses slides" => "wiki uses slides",
// "wiki watch author" => "wiki watch author",
// "wiki watch comments" => "wiki watch comments",
// "wiki watch editor" => "wiki watch editor",
// "wiki watch minor" => "wiki watch minor",
// "feature wiki history full" => "feature wiki history full",
// "feature wiki categorize structure" => "feature wiki categorize structure",
// "feature wiki watch structure" => "feature wiki watch structure",
// "feature wikiapproval" => "feature wikiapproval",
// "wikiapproval prefix" => "wikiapproval prefix",
// "wikiapproval hideprefix" => "wikiapproval hideprefix",
// "wikiapproval delete staging" => "wikiapproval delete staging",
// "wikiapproval master group" => "wikiapproval master group",
// "wikiapproval staging category" => "wikiapproval staging category",
// "wikiapproval approved category" => "wikiapproval approved category",
// "wikiapproval outofsync category" => "wikiapproval outofsync category",
// "wikiapproval block editapproved" => "wikiapproval block editapproved",
// "wikiapproval sync categories" => "wikiapproval sync categories",
// "wikiapproval update freetags" => "wikiapproval update freetags",
// "wikiapproval combine freetags" => "wikiapproval combine freetags",
// "wiki edit section" => "wiki edit section",
// "wiki edit section level" => "wiki edit section level",
// "wiki edit icons toggle" => "wiki edit icons toggle",
// "wiki edit plugin" => "wiki edit plugin",
// "wiki validate plugin" => "wiki validate plugin",
// "wiki edit minor" => "wiki edit minor",
// "feature pagelist" => "feature pagelist",
// "wikiplugin agentinfo" => "wikiplugin agentinfo",
// "wikiplugin alink" => "wikiplugin alink",
// "wikiplugin aname" => "wikiplugin aname",
// "wikiplugin annotation" => "wikiplugin annotation",
// "wikiplugin article" => "wikiplugin article",
// "wikiplugin articles" => "wikiplugin articles",
// "wikiplugin attach" => "wikiplugin attach",
// "wikiplugin avatar" => "wikiplugin avatar",
// "wikiplugin back" => "wikiplugin back",
// "wikiplugin backlinks" => "wikiplugin backlinks",
// "wikiplugin banner" => "wikiplugin banner",
// "wikiplugin bloglist" => "wikiplugin bloglist",
// "wikiplugin box" => "wikiplugin box",
// "wikiplugin calendar" => "wikiplugin calendar",
// "wikiplugin category" => "wikiplugin category",
// "wikiplugin catorphans" => "wikiplugin catorphans",
// "wikiplugin catpath" => "wikiplugin catpath",
// "wikiplugin center" => "wikiplugin center",
// "wikiplugin chart" => "wikiplugin chart",
// "wikiplugin code" => "wikiplugin code",
// "wikiplugin content" => "wikiplugin content",
// "wikiplugin cookie" => "wikiplugin cookie",
// "wikiplugin copyright" => "wikiplugin copyright",
// "wikiplugin countdown" => "wikiplugin countdown",
// "wikiplugin datachannel" => "wikiplugin datachannel",
// "wikiplugin dbreport" => "wikiplugin dbreport",
// "wikiplugin div" => "wikiplugin div",
// "wikiplugin dl" => "wikiplugin dl",
// "wikiplugin draw" => "wikiplugin draw",
// "wikiplugin equation" => "wikiplugin equation",
// "wikiplugin events" => "wikiplugin events",
// "wikiplugin fade" => "wikiplugin fade",
// "wikiplugin fancylist" => "wikiplugin fancylist",
// "wikiplugin fancytable" => "wikiplugin fancytable",
// "wikiplugin file" => "wikiplugin file",
// "wikiplugin files" => "wikiplugin files",
// "wikiplugin flash" => "wikiplugin flash",
// "wikiplugin footnote" => "wikiplugin footnote",
// "wikiplugin footnotearea" => "wikiplugin footnotearea",
// "wikiplugin ftp" => "wikiplugin ftp",
// "wikiplugin gauge" => "wikiplugin gauge",
// "wikiplugin googleanalytics" => "wikiplugin googleanalytics",
// "wikiplugin googledoc" => "wikiplugin googledoc",
// "wikiplugin group" => "wikiplugin group",
// "wikiplugin groupmailcore" => "wikiplugin groupmailcore",
// "wikiplugin groupstat" => "wikiplugin groupstat",
// "wikiplugin html" => "wikiplugin html",
// "wikiplugin iframe" => "wikiplugin iframe",
// "wikiplugin img" => "wikiplugin img",
// "wikiplugin image" => "wikiplugin image",
// "wikiplugin include" => "wikiplugin include",
// "wikiplugin invite" => "wikiplugin invite",
// "wikiplugin jabber" => "wikiplugin jabber",
// "wikiplugin js" => "wikiplugin js",
// "wikiplugin jq" => "wikiplugin jq",
// "wikiplugin lang" => "wikiplugin lang",
// "wikiplugin lastmod" => "wikiplugin lastmod",
// "wikiplugin listpages" => "wikiplugin listpages",
// "wikiplugin listprogress" => "wikiplugin listprogress",
// "wikiplugin lsdir" => "wikiplugin lsdir",
// "wikiplugin map" => "wikiplugin map",
// "wikiplugin mcalendar" => "wikiplugin mcalendar",
// "wikiplugin mediaplayer" => "wikiplugin mediaplayer",
// "wikiplugin memberlist" => "wikiplugin memberlist",
// "wikiplugin miniquiz" => "wikiplugin miniquiz",
// "wikiplugin module" => "wikiplugin module",
// "wikiplugin mono" => "wikiplugin mono",
// "wikiplugin mouseover" => "wikiplugin mouseover",
// "wikiplugin mwtable" => "wikiplugin mwtable",
// "wikiplugin myspace" => "wikiplugin myspace",
// "wikiplugin objecthits" => "wikiplugin objecthits",
// "wikiplugin pagelist" => "wikiplugin pagelist",
// "wikiplugin picture" => "wikiplugin picture",
// "wikiplugin pluginmanager" => "wikiplugin pluginmanager",
// "wikiplugin poll" => "wikiplugin poll",
// "wikiplugin profile" => "wikiplugin profile",
// "wikiplugin proposal" => "wikiplugin proposal",
// "wikiplugin quote" => "wikiplugin quote",
// "wikiplugin rcontent" => "wikiplugin rcontent",
// "wikiplugin realnamelist" => "wikiplugin realnamelist",
// "wikiplugin redirect" => "wikiplugin redirect",
// "wikiplugin regex" => "wikiplugin regex",
// "wikiplugin remarksbox" => "wikiplugin remarksbox",
// "wikiplugin rss" => "wikiplugin rss",
// "wikiplugin screencast" => "wikiplugin screencast",
// "wikiplugin sf" => "wikiplugin sf",
// "wikiplugin share" => "wikiplugin share",
// "wikiplugin sharethis" => "wikiplugin sharethis",
// "wikiplugin sheet" => "wikiplugin sheet",
// "wikiplugin showpages" => "wikiplugin showpages",
// "wikiplugin skype" => "wikiplugin skype",
// "wikiplugin snarf" => "wikiplugin snarf",
// "wikiplugin sort" => "wikiplugin sort",
// "wikiplugin split" => "wikiplugin split",
// "wikiplugin sql" => "wikiplugin sql",
// "wikiplugin stat" => "wikiplugin stat",
// "wikiplugin sub" => "wikiplugin sub",
// "wikiplugin subscribegroup" => "wikiplugin subscribegroup",
// "wikiplugin subscribegroups" => "wikiplugin subscribegroups",
// "wikiplugin sup" => "wikiplugin sup",
// "wikiplugin survey" => "wikiplugin survey",
// "wikiplugin tag" => "wikiplugin tag",
// "wikiplugin tabs" => "wikiplugin tabs",
// "wikiplugin thumb" => "wikiplugin thumb",
// "wikiplugin titlesearch" => "wikiplugin titlesearch",
// "wikiplugin toc" => "wikiplugin toc",
// "wikiplugin topfriends" => "wikiplugin topfriends",
// "wikiplugin trackerfilter" => "wikiplugin trackerfilter",
// "wikiplugin trackeritemfield" => "wikiplugin trackeritemfield",
// "wikiplugin trackerlist" => "wikiplugin trackerlist",
// "wikiplugin trackertimeline" => "wikiplugin trackertimeline",
// "wikiplugin tracker" => "wikiplugin tracker",
// "wikiplugin trackerprefill" => "wikiplugin trackerprefill",
// "wikiplugin trackerstat" => "wikiplugin trackerstat",
// "wikiplugin translated" => "wikiplugin translated",
// "wikiplugin tr" => "wikiplugin tr",
// "wikiplugin usercount" => "wikiplugin usercount",
// "wikiplugin userlist" => "wikiplugin userlist",
// "wikiplugin userpref" => "wikiplugin userpref",
// "wikiplugin versions" => "wikiplugin versions",
// "wikiplugin vote" => "wikiplugin vote",
// "wikiplugin wantedpages" => "wikiplugin wantedpages",
// "wikiplugin webservice" => "wikiplugin webservice",
// "wikiplugin youtube" => "wikiplugin youtube",
// "wikiplugininline agentinfo" => "wikiplugininline agentinfo",
// "wikiplugininline alink" => "wikiplugininline alink",
// "wikiplugininline aname" => "wikiplugininline aname",
// "wikiplugininline annotation" => "wikiplugininline annotation",
// "wikiplugininline article" => "wikiplugininline article",
// "wikiplugininline articles" => "wikiplugininline articles",
// "wikiplugininline attach" => "wikiplugininline attach",
// "wikiplugininline avatar" => "wikiplugininline avatar",
// "wikiplugininline back" => "wikiplugininline back",
// "wikiplugininline backlinks" => "wikiplugininline backlinks",
// "wikiplugininline banner" => "wikiplugininline banner",
// "wikiplugininline bloglist" => "wikiplugininline bloglist",
// "wikiplugininline box" => "wikiplugininline box",
// "wikiplugininline calendar" => "wikiplugininline calendar",
// "wikiplugininline category" => "wikiplugininline category",
// "wikiplugininline catorphans" => "wikiplugininline catorphans",
// "wikiplugininline catpath" => "wikiplugininline catpath",
// "wikiplugininline center" => "wikiplugininline center",
// "wikiplugininline chart" => "wikiplugininline chart",
// "wikiplugininline code" => "wikiplugininline code",
// "wikiplugininline content" => "wikiplugininline content",
// "wikiplugininline cookie" => "wikiplugininline cookie",
// "wikiplugininline copyright" => "wikiplugininline copyright",
// "wikiplugininline countdown" => "wikiplugininline countdown",
// "wikiplugininline datachannel" => "wikiplugininline datachannel",
// "wikiplugininline dbreport" => "wikiplugininline dbreport",
// "wikiplugininline div" => "wikiplugininline div",
// "wikiplugininline dl" => "wikiplugininline dl",
// "wikiplugininline draw" => "wikiplugininline draw",
// "wikiplugininline equation" => "wikiplugininline equation",
// "wikiplugininline events" => "wikiplugininline events",
// "wikiplugininline fade" => "wikiplugininline fade",
// "wikiplugininline fancylist" => "wikiplugininline fancylist",
// "wikiplugininline fancytable" => "wikiplugininline fancytable",
// "wikiplugininline file" => "wikiplugininline file",
// "wikiplugininline files" => "wikiplugininline files",
// "wikiplugininline flash" => "wikiplugininline flash",
// "wikiplugininline footnote" => "wikiplugininline footnote",
// "wikiplugininline footnotearea" => "wikiplugininline footnotearea",
// "wikiplugininline ftp" => "wikiplugininline ftp",
// "wikiplugininline gauge" => "wikiplugininline gauge",
// "wikiplugininline googleanalytics" => "wikiplugininline googleanalytics",
// "wikiplugininline googledoc" => "wikiplugininline googledoc",
// "wikiplugininline group" => "wikiplugininline group",
// "wikiplugininline groupmailcore" => "wikiplugininline groupmailcore",
// "wikiplugininline groupstat" => "wikiplugininline groupstat",
// "wikiplugininline html" => "wikiplugininline html",
// "wikiplugininline iframe" => "wikiplugininline iframe",
// "wikiplugininline img" => "wikiplugininline img",
// "wikiplugininline image" => "wikiplugininline image",
// "wikiplugininline include" => "wikiplugininline include",
// "wikiplugininline invite" => "wikiplugininline invite",
// "wikiplugininline jabber" => "wikiplugininline jabber",
// "wikiplugininline js" => "wikiplugininline js",
// "wikiplugininline jq" => "wikiplugininline jq",
// "wikiplugininline lang" => "wikiplugininline lang",
// "wikiplugininline lastmod" => "wikiplugininline lastmod",
// "wikiplugininline listpages" => "wikiplugininline listpages",
// "wikiplugininline listprogress" => "wikiplugininline listprogress",
// "wikiplugininline lsdir" => "wikiplugininline lsdir",
// "wikiplugininline map" => "wikiplugininline map",
// "wikiplugininline mcalendar" => "wikiplugininline mcalendar",
// "wikiplugininline mediaplayer" => "wikiplugininline mediaplayer",
// "wikiplugininline memberlist" => "wikiplugininline memberlist",
// "wikiplugininline miniquiz" => "wikiplugininline miniquiz",
// "wikiplugininline module" => "wikiplugininline module",
// "wikiplugininline mono" => "wikiplugininline mono",
// "wikiplugininline mouseover" => "wikiplugininline mouseover",
// "wikiplugininline mwtable" => "wikiplugininline mwtable",
// "wikiplugininline myspace" => "wikiplugininline myspace",
// "wikiplugininline objecthits" => "wikiplugininline objecthits",
// "wikiplugininline pagelist" => "wikiplugininline pagelist",
// "wikiplugininline picture" => "wikiplugininline picture",
// "wikiplugininline pluginmanager" => "wikiplugininline pluginmanager",
// "wikiplugininline poll" => "wikiplugininline poll",
// "wikiplugininline profile" => "wikiplugininline profile",
// "wikiplugininline proposal" => "wikiplugininline proposal",
// "wikiplugininline quote" => "wikiplugininline quote",
// "wikiplugininline rcontent" => "wikiplugininline rcontent",
// "wikiplugininline realnamelist" => "wikiplugininline realnamelist",
// "wikiplugininline redirect" => "wikiplugininline redirect",
// "wikiplugininline regex" => "wikiplugininline regex",
// "wikiplugininline remarksbox" => "wikiplugininline remarksbox",
// "wikiplugininline rss" => "wikiplugininline rss",
// "wikiplugininline screencast" => "wikiplugininline screencast",
// "wikiplugininline sf" => "wikiplugininline sf",
// "wikiplugininline share" => "wikiplugininline share",
// "wikiplugininline sharethis" => "wikiplugininline sharethis",
// "wikiplugininline sheet" => "wikiplugininline sheet",
// "wikiplugininline showpages" => "wikiplugininline showpages",
// "wikiplugininline skype" => "wikiplugininline skype",
// "wikiplugininline snarf" => "wikiplugininline snarf",
// "wikiplugininline sort" => "wikiplugininline sort",
// "wikiplugininline split" => "wikiplugininline split",
// "wikiplugininline sql" => "wikiplugininline sql",
// "wikiplugininline stat" => "wikiplugininline stat",
// "wikiplugininline sub" => "wikiplugininline sub",
// "wikiplugininline subscribegroup" => "wikiplugininline subscribegroup",
// "wikiplugininline subscribegroups" => "wikiplugininline subscribegroups",
// "wikiplugininline sup" => "wikiplugininline sup",
// "wikiplugininline survey" => "wikiplugininline survey",
// "wikiplugininline tag" => "wikiplugininline tag",
// "wikiplugininline tabs" => "wikiplugininline tabs",
// "wikiplugininline thumb" => "wikiplugininline thumb",
// "wikiplugininline titlesearch" => "wikiplugininline titlesearch",
// "wikiplugininline toc" => "wikiplugininline toc",
// "wikiplugininline topfriends" => "wikiplugininline topfriends",
// "wikiplugininline trackerfilter" => "wikiplugininline trackerfilter",
// "wikiplugininline trackeritemfield" => "wikiplugininline trackeritemfield",
// "wikiplugininline trackerlist" => "wikiplugininline trackerlist",
// "wikiplugininline trackertimeline" => "wikiplugininline trackertimeline",
// "wikiplugininline tracker" => "wikiplugininline tracker",
// "wikiplugininline trackerprefill" => "wikiplugininline trackerprefill",
// "wikiplugininline trackerstat" => "wikiplugininline trackerstat",
// "wikiplugininline translated" => "wikiplugininline translated",
// "wikiplugininline tr" => "wikiplugininline tr",
// "wikiplugininline usercount" => "wikiplugininline usercount",
// "wikiplugininline userlist" => "wikiplugininline userlist",
// "wikiplugininline userpref" => "wikiplugininline userpref",
// "wikiplugininline versions" => "wikiplugininline versions",
// "wikiplugininline vote" => "wikiplugininline vote",
// "wikiplugininline wantedpages" => "wikiplugininline wantedpages",
// "wikiplugininline webservice" => "wikiplugininline webservice",
// "wikiplugininline youtube" => "wikiplugininline youtube",
// "webservice consume defaultcache" => "webservice consume defaultcache",
// "feature webservices" => "feature webservices",
// "feature semantic" => "feature semantic",
// "feature wysiwyg" => "feature wysiwyg",
// "wysiwyg optional" => "wysiwyg optional",
// "wysiwyg default" => "wysiwyg default",
// "wysiwyg memo" => "wysiwyg memo",
// "wysiwyg wiki parsed" => "wysiwyg wiki parsed",
// "wysiwyg wiki semi parsed" => "wysiwyg wiki semi parsed",
// "wysiwyg toolbar skin" => "wysiwyg toolbar skin",
// "wiki feature 3d" => "wiki feature 3d",
// "wiki 3d width" => "wiki 3d width",
// "wiki 3d height" => "wiki 3d height",
// "wiki 3d navigation depth" => "wiki 3d navigation depth",
// "wiki 3d feed animation interval" => "wiki 3d feed animation interval",
// "wiki 3d existing page color" => "wiki 3d existing page color",
// "wiki 3d missing page color" => "wiki 3d missing page color",
// "feature blogs" => "feature blogs",
// "blog list order" => "blog list order",
// "home blog" => "home blog",
// "feature blog rankings" => "feature blog rankings",
// "feature blog comments" => "feature blog comments",
// "blog comments default ordering" => "blog comments default ordering",
// "blog comments per page" => "blog comments per page",
// "feature blogposts comments" => "feature blogposts comments",
// "blog list user" => "blog list user",
// "blog list title" => "blog list title",
// "blog list title len" => "blog list title len",
// "blog list description" => "blog list description",
// "blog list created" => "blog list created",
// "blog list lastmodif" => "blog list lastmodif",
// "blog list posts" => "blog list posts",
// "blog list visits" => "blog list visits",
// "blog list activity" => "blog list activity",
// "feature blog mandatory category" => "feature blog mandatory category",
// "feature blog heading" => "feature blog heading",
// "feature file galleries" => "feature file galleries",
// "home file gallery" => "home file gallery",
// "fgal root id" => "fgal root id",
// "fgal use db" => "fgal use db",
// "fgal batch dir" => "fgal batch dir",
// "fgal match regex" => "fgal match regex",
// "fgal nmatch regex" => "fgal nmatch regex",
// "fgal use dir" => "fgal use dir",
// "fgal podcast dir" => "fgal podcast dir",
// "feature file galleries comments" => "feature file galleries comments",
// "file galleries comments default ordering" => "file galleries comments default ordering",
// "file galleries comments per page" => "file galleries comments per page",
// "feature file galleries batch" => "feature file galleries batch",
// "feature file galleries rankings" => "feature file galleries rankings",
// "fgal enable auto indexing" => "fgal enable auto indexing",
// "fgal asynchronous indexing" => "fgal asynchronous indexing",
// "fgal allow duplicates" => "fgal allow duplicates",
// "fgal sort mode" => "fgal sort mode",
// "feature file galleries author" => "feature file galleries author",
// "fgal list id" => "fgal list id",
// "fgal list type" => "fgal list type",
// "fgal list name" => "fgal list name",
// "fgal list description" => "fgal list description",
// "fgal list size" => "fgal list size",
// "fgal list created" => "fgal list created",
// "fgal list lastModif" => "fgal list lastModif",
// "fgal list creator" => "fgal list creator",
// "fgal list author" => "fgal list author",
// "fgal list last user" => "fgal list last user",
// "fgal list comment" => "fgal list comment",
// "fgal list files" => "fgal list files",
// "fgal list hits" => "fgal list hits",
// "fgal list lockedby" => "fgal list lockedby",
// "fgal show path" => "fgal show path",
// "fgal show explorer" => "fgal show explorer",
// "fgal show slideshow" => "fgal show slideshow",
// "fgal default view" => "fgal default view",
// "fgal limit hits per file" => "fgal limit hits per file",
// "fgal prevent negative score" => "fgal prevent negative score",
// "fgal quota" => "fgal quota",
// "fgal quota per fgal" => "fgal quota per fgal",
// "fgal quota default" => "fgal quota default",
// "fgal quota show" => "fgal quota show",
// "feature galleries" => "feature galleries",
// "feature gal batch" => "feature gal batch",
// "feature gal slideshow" => "feature gal slideshow",
// "home gallery" => "home gallery",
// "gal use db" => "gal use db",
// "gal use lib" => "gal use lib",
// "gal match regex" => "gal match regex",
// "gal nmatch regex" => "gal nmatch regex",
// "gal use dir" => "gal use dir",
// "gal batch dir" => "gal batch dir",
// "feature gal rankings" => "feature gal rankings",
// "feature image galleries comments" => "feature image galleries comments",
// "image galleries comments default order" => "image galleries comments default order",
// "image galleries comments per page" => "image galleries comments per page",
// "gal list name" => "gal list name",
// "gal list parent" => "gal list parent",
// "gal list description" => "gal list description",
// "gal list created" => "gal list created",
// "gal list lastmodif" => "gal list lastmodif",
// "gal list user" => "gal list user",
// "gal list imgs" => "gal list imgs",
// "gal list visits" => "gal list visits",
// "feature image gallery mandatory category" => "feature image gallery mandatory category",
// "preset galleries info" => "preset galleries info",
// "gal image mouseover" => "gal image mouseover",
// "ProgressBarPlay" => "ProgressBarPlay",
// "ProgressBarLoad" => "ProgressBarLoad",
// "ProgressBarButton" => "ProgressBarButton",
// "ProgressBar" => "ProgressBar",
// "VolumeOn" => "VolumeOn",
// "VolumeOff" => "VolumeOff",
// "VolumeButton" => "VolumeButton",
// "Button" => "Button",
// "ButtonPressed" => "ButtonPressed",
// "ButtonOver" => "ButtonOver",
// "ButtonInfo" => "ButtonInfo",
// "ButtonInfoPressed" => "ButtonInfoPressed",
// "ButtonInfoOver" => "ButtonInfoOver",
// "ButtonInfoText" => "ButtonInfoText",
// "ID3" => "ID3",
// "PlayTime" => "PlayTime",
// "TotalTime" => "TotalTime",
// "PanelDisplay" => "PanelDisplay",
// "AlertMesg" => "AlertMesg",
// "PreloadDelay" => "PreloadDelay",
// "VideoHeight" => "VideoHeight",
// "VideoLength" => "VideoLength",
// "URLAppend" => "URLAppend",
// "LimitedMsg" => "LimitedMsg",
// "MaxPlay" => "MaxPlay",
// "MultimediaGalerie" => "MultimediaGalerie",
// "MultimediaDefaultLength" => "MultimediaDefaultLength",
// "MultimediaDefaultHeight" => "MultimediaDefaultHeight",
// "feature forums" => "feature forums",
// "home forum" => "home forum",
// "feature forum rankings" => "feature forum rankings",
// "feature forum parse" => "feature forum parse",
// "feature forum topics archiving" => "feature forum topics archiving",
// "feature forum replyempty" => "feature forum replyempty",
// "feature forum quickjump" => "feature forum quickjump",
// "feature forums allow thread titles" => "feature forums allow thread titles",
// "feature forum content search" => "feature forum content search",
// "feature forums name search" => "feature forums name search",
// "forums ordering" => "forums ordering",
// "forum list topics" => "forum list topics",
// "forum list posts" => "forum list posts",
// "forum list ppd" => "forum list ppd",
// "forum list lastpost" => "forum list lastpost",
// "forum list visits" => "forum list visits",
// "forum list desc" => "forum list desc",
// "forum list description len" => "forum list description len",
// "feature forum local search" => "feature forum local search",
// "feature forum local tiki search" => "feature forum local tiki search",
// "forum thread defaults by forum" => "forum thread defaults by forum",
// "forum thread user settings" => "forum thread user settings",
// "forum thread user settings threshold" => "forum thread user settings threshold",
// "forum thread user settings keep" => "forum thread user settings keep",
// "forum comments per page" => "forum comments per page",
// "forum comments no title prefix" => "forum comments no title prefix",
// "forum thread style" => "forum thread style",
// "forum thread sort mode" => "forum thread sort mode",
// "forum match regex" => "forum match regex",
// "feature articles" => "feature articles",
// "feature submissions" => "feature submissions",
// "feature cms rankings" => "feature cms rankings",
// "feature cms print" => "feature cms print",
// "feature cms emails" => "feature cms emails",
// "art list title" => "art list title",
// "art list title len" => "art list title len",
// "art list topic" => "art list topic",
// "art list date" => "art list date",
// "art list author" => "art list author",
// "art list rating" => "art list rating",
// "art list reads" => "art list reads",
// "art list size" => "art list size",
// "art list expire" => "art list expire",
// "art list img" => "art list img",
// "art list type" => "art list type",
// "art list visible" => "art list visible",
// "art view type" => "art view type",
// "art view title" => "art view title",
// "art view topic" => "art view topic",
// "art view date" => "art view date",
// "art view author" => "art view author",
// "art view reads" => "art view reads",
// "art view size" => "art view size",
// "art view img" => "art view img",
// "art list lang" => "art list lang",
// "feature article comments" => "feature article comments",
// "article comments default ordering" => "article comments default ordering",
// "article comments per page" => "article comments per page",
// "article image size x" => "article image size x",
// "article image size y" => "article image size y",
// "feature cms templates" => "feature cms templates",
// "cms bot bar" => "cms bot bar",
// "cms left column" => "cms left column",
// "cms right column" => "cms right column",
// "cms top bar" => "cms top bar",
// "cms spellcheck" => "cms spellcheck",
// "art home title" => "art home title",
// "feature trackers" => "feature trackers",
// "t use db" => "t use db",
// "t use dir" => "t use dir",
// "groupTracker" => "groupTracker",
// "userTracker" => "userTracker",
// "trk with mirror tables" => "trk with mirror tables",
// "trackerCreatorGroupName" => "trackerCreatorGroupName",
// "tracker jquery user selector threshold" => "tracker jquery user selector threshold",
// "feature userlevels" => "feature userlevels",
// "userlevels" => "userlevels",
// "userbreadCrumb" => "userbreadCrumb",
// "user assigned modules" => "user assigned modules",
// "user flip modules" => "user flip modules",
// "user show realnames" => "user show realnames",
// "feature mytiki" => "feature mytiki",
// "feature userPreferences" => "feature userPreferences",
// "feature user bookmarks" => "feature user bookmarks",
// "feature tasks" => "feature tasks",
// "w use db" => "w use db",
// "w use dir" => "w use dir",
// "w displayed default" => "w displayed default",
// "uf use db" => "uf use db",
// "uf use dir" => "uf use dir",
// "userfiles quota" => "userfiles quota",
// "feature usermenu" => "feature usermenu",
// "feature minical" => "feature minical",
// "feature notepad" => "feature notepad",
// "feature userfiles" => "feature userfiles",
// "feature community gender" => "feature community gender",
// "feature community mouseover" => "feature community mouseover",
// "feature community mouseover name" => "feature community mouseover name",
// "feature community mouseover gender" => "feature community mouseover gender",
// "feature community mouseover picture" => "feature community mouseover picture",
// "feature community mouseover friends" => "feature community mouseover friends",
// "feature community mouseover score" => "feature community mouseover score",
// "feature community mouseover country" => "feature community mouseover country",
// "feature community mouseover email" => "feature community mouseover email",
// "feature community mouseover lastlogin" => "feature community mouseover lastlogin",
// "feature community mouseover distance" => "feature community mouseover distance",
// "feature community list name" => "feature community list name",
// "feature community list score" => "feature community list score",
// "feature community list country" => "feature community list country",
// "feature community list distance" => "feature community list distance",
// "feature community friends permission" => "feature community friends permission",
// "feature community friends permission dep" => "feature community friends permission dep",
// "change language" => "change language",
// "change theme" => "change theme",
// "login is email" => "login is email",
// "validateUsers" => "validateUsers",
// "validateEmail" => "validateEmail",
// "forgotPass" => "forgotPass",
// "available languages" => "available languages",
// "available styles" => "available styles",
// "lowercase username" => "lowercase username",
// "username pattern" => "username pattern",
// "max username length" => "max username length",
// "min username length" => "min username length",
// "users prefs allowMsgs" => "users prefs allowMsgs",
// "users prefs country" => "users prefs country",
// "users prefs diff versions" => "users prefs diff versions",
// "users prefs display timezone" => "users prefs display timezone",
// "users prefs email is public" => "users prefs email is public",
// "users prefs homePage" => "users prefs homePage",
// "users prefs lat" => "users prefs lat",
// "users prefs lon" => "users prefs lon",
// "users prefs mess archiveAfter" => "users prefs mess archiveAfter",
// "users prefs mess maxRecords" => "users prefs mess maxRecords",
// "users prefs mess sendReadStatus" => "users prefs mess sendReadStatus",
// "users prefs minPrio" => "users prefs minPrio",
// "users prefs mytiki blogs" => "users prefs mytiki blogs",
// "users prefs mytiki articles" => "users prefs mytiki articles",
// "users prefs mytiki gals" => "users prefs mytiki gals",
// "users prefs mytiki items" => "users prefs mytiki items",
// "users prefs mytiki msgs" => "users prefs mytiki msgs",
// "users prefs mytiki pages" => "users prefs mytiki pages",
// "users prefs mytiki tasks" => "users prefs mytiki tasks",
// "users prefs mytiki forum topics" => "users prefs mytiki forum topics",
// "users prefs mytiki forum replies" => "users prefs mytiki forum replies",
// "users prefs realName" => "users prefs realName",
// "users prefs gender" => "users prefs gender",
// "users prefs show mouseover user info" => "users prefs show mouseover user info",
// "users prefs tasks maxRecords" => "users prefs tasks maxRecords",
// "users prefs user dbl" => "users prefs user dbl",
// "users prefs user information" => "users prefs user information",
// "users prefs userbreadCrumb" => "users prefs userbreadCrumb",
// "users prefs mailCharset" => "users prefs mailCharset",
// "users prefs mailCurrentAccount" => "users prefs mailCurrentAccount",
// "validateRegistration" => "validateRegistration",
// "validator emails" => "validator emails",
// "url after validation" => "url after validation",
// "urlOnUsername" => "urlOnUsername",
// "feature messages" => "feature messages",
// "messu mailbox size" => "messu mailbox size",
// "messu archive size" => "messu archive size",
// "messu sent size" => "messu sent size",
// "allowmsg by default" => "allowmsg by default",
// "allowmsg is optional" => "allowmsg is optional",
// "feature freetags" => "feature freetags",
// "freetags browse show cloud" => "freetags browse show cloud",
// "freetags cloud colors" => "freetags cloud colors",
// "freetags preload random search" => "freetags preload random search",
// "freetags browse amount tags in cloud" => "freetags browse amount tags in cloud",
// "freetags browse amount tags suggestion" => "freetags browse amount tags suggestion",
// "freetags normalized valid chars" => "freetags normalized valid chars",
// "freetags lowercase only" => "freetags lowercase only",
// "freetags feature 3d" => "freetags feature 3d",
// "freetags 3d width" => "freetags 3d width",
// "freetags 3d height" => "freetags 3d height",
// "freetags 3d navigation depth" => "freetags 3d navigation depth",
// "freetags 3d feed animation interval" => "freetags 3d feed animation interval",
// "freetags 3d existing page color" => "freetags 3d existing page color",
// "freetags 3d missing page color" => "freetags 3d missing page color",
// "freetags 3d autoload" => "freetags 3d autoload",
// "freetags 3d camera distance" => "freetags 3d camera distance",
// "freetags 3d elastic constant" => "freetags 3d elastic constant",
// "freetags 3d eletrostatic constant" => "freetags 3d eletrostatic constant",
// "freetags 3d fov" => "freetags 3d fov",
// "freetags 3d friction constant" => "freetags 3d friction constant",
// "freetags 3d node charge" => "freetags 3d node charge",
// "freetags 3d node mass" => "freetags 3d node mass",
// "freetags 3d node size" => "freetags 3d node size",
// "freetags 3d spring size" => "freetags 3d spring size",
// "freetags 3d text size" => "freetags 3d text size",
// "freetags 3d adjust camera" => "freetags 3d adjust camera",
// "freetags multilingual" => "freetags multilingual",
// "morelikethis algorithm" => "morelikethis algorithm",
// "morelikethis basic mincommon" => "morelikethis basic mincommon",
// "freetags show middle" => "freetags show middle",
// "feature search stats" => "feature search stats",
// "feature search" => "feature search",
// "feature search fulltext" => "feature search fulltext",
// "feature search show forbidden obj" => "feature search show forbidden obj",
// "feature search show forbidden cat" => "feature search show forbidden cat",
// "feature search show object filter" => "feature search show object filter",
// "feature search show search box" => "feature search show search box",
// "feature search show visit count" => "feature search show visit count",
// "feature search show pertinence" => "feature search show pertinence",
// "feature search show object type" => "feature search show object type",
// "feature search show last modification" => "feature search show last modification",
// "search refresh index mode" => "search refresh index mode",
// "search parsed snippet" => "search parsed snippet",
// "feature search preferences" => "feature search preferences",
// "feature webmail" => "feature webmail",
// "webmail max attachment" => "webmail max attachment",
// "webmail view html" => "webmail view html",
// "feature contacts" => "feature contacts",
// "feature faqs" => "feature faqs",
// "feature faq comments" => "feature faq comments",
// "faq comments per page" => "faq comments per page",
// "faq comments default ordering" => "faq comments default ordering",
// "faq prefix" => "faq prefix",
// "feature quizzes" => "feature quizzes",
// "feature polls" => "feature polls",
// "feature poll comments" => "feature poll comments",
// "feature poll anonymous" => "feature poll anonymous",
// "poll comments default ordering" => "poll comments default ordering",
// "poll comments per page" => "poll comments per page",
// "poll list categories" => "poll list categories",
// "poll list objects" => "poll list objects",
// "feature poll revote" => "feature poll revote",
// "feature surveys" => "feature surveys",
// "feature featuredLinks" => "feature featuredLinks",
// "feature directory" => "feature directory",
// "directory columns" => "directory columns",
// "directory links per page" => "directory links per page",
// "directory open links" => "directory open links",
// "directory validate urls" => "directory validate urls",
// "directory cool sites" => "directory cool sites",
// "directory country flag" => "directory country flag",
// "feature calendar" => "feature calendar",
// "feature default calendars" => "feature default calendars",
// "calendar sticky popup" => "calendar sticky popup",
// "default calendars" => "default calendars",
// "calendar view mode" => "calendar view mode",
// "calendar view tab" => "calendar view tab",
// "calendar firstDayofWeek" => "calendar firstDayofWeek",
// "calendar timespan" => "calendar timespan",
// "feature jscalendar" => "feature jscalendar",
// "feature action calendar" => "feature action calendar",
// "calendar start year" => "calendar start year",
// "calendar end year" => "calendar end year",
// "calendar list begins focus" => "calendar list begins focus",
// "feature cal manual time" => "feature cal manual time",
// "server timezone" => "server timezone",
// "long date format" => "long date format",
// "long time format" => "long time format",
// "short date format" => "short date format",
// "short time format" => "short time format",
// "display field order" => "display field order",
// "rss forums" => "rss forums",
// "rss forum" => "rss forum",
// "rss directories" => "rss directories",
// "rss articles" => "rss articles",
// "rss blogs" => "rss blogs",
// "rss image galleries" => "rss image galleries",
// "rss file galleries" => "rss file galleries",
// "rss wiki" => "rss wiki",
// "rss image gallery" => "rss image gallery",
// "rss file gallery" => "rss file gallery",
// "rss blog" => "rss blog",
// "rss tracker" => "rss tracker",
// "rss trackers" => "rss trackers",
// "rss calendar" => "rss calendar",
// "rss mapfiles" => "rss mapfiles",
// "rss cache time" => "rss cache time",
// "title rss forums" => "title rss forums",
// "title rss forum" => "title rss forum",
// "title rss directories" => "title rss directories",
// "title rss articles" => "title rss articles",
// "title rss blogs" => "title rss blogs",
// "title rss image galleries" => "title rss image galleries",
// "title rss file galleries" => "title rss file galleries",
// "title rss wiki" => "title rss wiki",
// "title rss image gallery" => "title rss image gallery",
// "title rss file gallery" => "title rss file gallery",
// "title rss blog" => "title rss blog",
// "title rss tracker" => "title rss tracker",
// "title rss trackers" => "title rss trackers",
// "title rss calendar" => "title rss calendar",
// "title rss mapfiles" => "title rss mapfiles",
// "max rss forums" => "max rss forums",
// "max rss forum" => "max rss forum",
// "max rss directories" => "max rss directories",
// "max rss articles" => "max rss articles",
// "max rss blogs" => "max rss blogs",
// "max rss image galleries" => "max rss image galleries",
// "max rss file galleries" => "max rss file galleries",
// "max rss wiki" => "max rss wiki",
// "max rss image gallery" => "max rss image gallery",
// "max rss file gallery" => "max rss file gallery",
// "max rss blog" => "max rss blog",
// "max rss mapfiles" => "max rss mapfiles",
// "max rss tracker" => "max rss tracker",
// "max rss trackers" => "max rss trackers",
// "max rss calendar" => "max rss calendar",
// "summary rss blogs" => "summary rss blogs",
// "rssfeed default version" => "rssfeed default version",
// "rssfeed language" => "rssfeed language",
// "rssfeed editor" => "rssfeed editor",
// "rssfeed webmaster" => "rssfeed webmaster",
// "rssfeed creator" => "rssfeed creator",
// "rssfeed css" => "rssfeed css",
// "rssfeed publisher" => "rssfeed publisher",
// "rssfeed img" => "rssfeed img",
// "rss basic auth" => "rss basic auth",
// "feature maps" => "feature maps",
// "map path" => "map path",
// "default map" => "default map",
// "map help" => "map help",
// "map comments" => "map comments",
// "gdaltindex" => "gdaltindex",
// "ogr2ogr" => "ogr2ogr",
// "mapzone" => "mapzone",
// "feature gmap" => "feature gmap",
// "gmap defaultx" => "gmap defaultx",
// "gmap defaulty" => "gmap defaulty",
// "gmap defaultz" => "gmap defaultz",
// "gmap key" => "gmap key",
// "allowRegister" => "allowRegister",
// "eponymousGroups" => "eponymousGroups",
// "useRegisterPasscode" => "useRegisterPasscode",
// "registerPasscode" => "registerPasscode",
// "rememberme" => "rememberme",
// "remembertime" => "remembertime",
// "feature clear passwords" => "feature clear passwords",
// "feature crypt passwords" => "feature crypt passwords",
// "feature challenge" => "feature challenge",
// "min user length" => "min user length",
// "min pass length" => "min pass length",
// "pass chr num" => "pass chr num",
// "pass due" => "pass due",
// "email due" => "email due",
// "unsuccessful logins" => "unsuccessful logins",
// "rnd num reg" => "rnd num reg",
// "generate password" => "generate password",
// "auth method" => "auth method",
// "auth pear" => "auth pear",
// "auth ldap url" => "auth ldap url",
// "auth pear host" => "auth pear host",
// "auth pear port" => "auth pear port",
// "auth ldap scope" => "auth ldap scope",
// "auth ldap basedn" => "auth ldap basedn",
// "auth ldap userdn" => "auth ldap userdn",
// "auth ldap userattr" => "auth ldap userattr",
// "auth ldap useroc" => "auth ldap useroc",
// "auth ldap groupdn" => "auth ldap groupdn",
// "auth ldap groupattr" => "auth ldap groupattr",
// "auth ldap groupnameatr" => "auth ldap groupnameatr",
// "auth ldap groupdescatr" => "auth ldap groupdescatr",
// "auth ldap usergroupattr" => "auth ldap usergroupattr",
// "auth ldap groupgroupattr" => "auth ldap groupgroupattr",
// "auth ldap groupoc" => "auth ldap groupoc",
// "auth ldap memberattr" => "auth ldap memberattr",
// "auth ldap memberisdn" => "auth ldap memberisdn",
// "auth ldap adminuser" => "auth ldap adminuser",
// "auth ldap adminpass" => "auth ldap adminpass",
// "auth ldap version" => "auth ldap version",
// "auth ldap nameattr" => "auth ldap nameattr",
// "auth ldap countryattr" => "auth ldap countryattr",
// "auth ldap emailattr" => "auth ldap emailattr",
// "ldap create user tiki" => "ldap create user tiki",
// "ldap create user ldap" => "ldap create user ldap",
// "ldap skip admin" => "ldap skip admin",
// "auth ldap permit tiki users" => "auth ldap permit tiki users",
// "auth ldap debug" => "auth ldap debug",
// "auth ldap ssl" => "auth ldap ssl",
// "auth ldap starttls" => "auth ldap starttls",
// "auth ldap type" => "auth ldap type",
// "auth ldap syncuserattr" => "auth ldap syncuserattr",
// "auth ldap syncgroupattr" => "auth ldap syncgroupattr",
// "https login" => "https login",
// "feature show stay in ssl mode" => "feature show stay in ssl mode",
// "feature switch ssl mode" => "feature switch ssl mode",
// "https port" => "https port",
// "http port" => "http port",
// "login url" => "login url",
// "login scr" => "login scr",
// "register url" => "register url",
// "error url" => "error url",
// "highlight group" => "highlight group",
// "cookie path" => "cookie path",
// "cookie domain" => "cookie domain",
// "cookie name" => "cookie name",
// "user tracker infos" => "user tracker infos",
// "desactive login autocomplete" => "desactive login autocomplete",
// "permission denied login box" => "permission denied login box",
// "permission denied url" => "permission denied url",
// "feature intertiki" => "feature intertiki",
// "feature intertiki server" => "feature intertiki server",
// "feature intertiki slavemode" => "feature intertiki slavemode",
// "interlist" => "interlist",
// "feature intertiki mymaster" => "feature intertiki mymaster",
// "feature intertiki import preferences" => "feature intertiki import preferences",
// "feature intertiki import groups" => "feature intertiki import groups",
// "known hosts" => "known hosts",
// "tiki key" => "tiki key",
// "intertiki logfile" => "intertiki logfile",
// "intertiki errfile" => "intertiki errfile",
// "feature intertiki sharedcookie" => "feature intertiki sharedcookie",
// "search lru length" => "search lru length",
// "search lru purge rate" => "search lru purge rate",
// "search max syllwords" => "search max syllwords",
// "search min wordlength" => "search min wordlength",
// "search refresh rate" => "search refresh rate",
// "search syll age" => "search syll age",
// "feature categories" => "feature categories",
// "feature categoryobjects" => "feature categoryobjects",
// "feature categorypath" => "feature categorypath",
// "feature category reinforce" => "feature category reinforce",
// "feature category use phplayers" => "feature category use phplayers",
// "categorypath excluded" => "categorypath excluded",
// "categories used in tpl" => "categories used in tpl",
// "category jail" => "category jail",
// "expanded category jail" => "expanded category jail",
// "expanded category jail key" => "expanded category jail key",
// "feature html pages" => "feature html pages",
// "feature filegals manager" => "feature filegals manager",
// "feature contact" => "feature contact",
// "contact user" => "contact user",
// "contact anon" => "contact anon",
// "mail crlf" => "mail crlf",
// "feature detect language" => "feature detect language",
// "feature homePage if bl missing" => "feature homePage if bl missing",
// "record untranslated" => "record untranslated",
// "feature best language" => "feature best language",
// "feature translation" => "feature translation",
// "feature urgent translation" => "feature urgent translation",
// "feature translation incomplete notice" => "feature translation incomplete notice",
// "lang use db" => "lang use db",
// "language" => "language",
// "feature babelfish" => "feature babelfish",
// "feature babelfish logo" => "feature babelfish logo",
// "quantify changes" => "quantify changes",
// "feature sync language" => "feature sync language",
// "show available translations" => "show available translations",
// "language inclusion threshold" => "language inclusion threshold",
// "metatag keywords" => "metatag keywords",
// "metatag threadtitle" => "metatag threadtitle",
// "metatag imagetitle" => "metatag imagetitle",
// "metatag freetags" => "metatag freetags",
// "metatag description" => "metatag description",
// "metatag pagedesc" => "metatag pagedesc",
// "metatag author" => "metatag author",
// "metatag geoposition" => "metatag geoposition",
// "metatag georegion" => "metatag georegion",
// "metatag geoplacename" => "metatag geoplacename",
// "metatag robots" => "metatag robots",
// "metatag revisitafter" => "metatag revisitafter",
// "head extra js" => "head extra js",
// "keep versions" => "keep versions",
// "feature custom home" => "feature custom home",
// "site crumb seper" => "site crumb seper",
// "site nav seper" => "site nav seper",
// "feature sitemycode" => "feature sitemycode",
// "sitemycode" => "sitemycode",
// "sitemycode publish" => "sitemycode publish",
// "feature sitelogo" => "feature sitelogo",
// "sitelogo bgcolor" => "sitelogo bgcolor",
// "sitelogo bgstyle" => "sitelogo bgstyle",
// "sitelogo align" => "sitelogo align",
// "sitelogo title" => "sitelogo title",
// "sitelogo src" => "sitelogo src",
// "sitelogo alt" => "sitelogo alt",
// "feature siteloc" => "feature siteloc",
// "feature sitenav" => "feature sitenav",
// "sitenav" => "sitenav",
// "feature sitead" => "feature sitead",
// "sitead" => "sitead",
// "sitead publish" => "sitead publish",
// "feature breadcrumbs" => "feature breadcrumbs",
// "feature siteloclabel" => "feature siteloclabel",
// "feature sitesearch" => "feature sitesearch",
// "feature site login" => "feature site login",
// "feature sitemenu" => "feature sitemenu",
// "feature topbar version" => "feature topbar version",
// "feature topbar debug" => "feature topbar debug",
// "feature topbar id menu" => "feature topbar id menu",
// "feature topbar custom code" => "feature topbar custom code",
// "feature sitetitle" => "feature sitetitle",
// "feature sitedesc" => "feature sitedesc",
// "feature bot logo" => "feature bot logo",
// "feature endbody code" => "feature endbody code",
// "feature custom html head content" => "feature custom html head content",
// "users prefs theme" => "users prefs theme",
// "feature left column" => "feature left column",
// "feature right column" => "feature right column",
// "feature top bar" => "feature top bar",
// "feature bot bar" => "feature bot bar",
// "feature bot bar icons" => "feature bot bar icons",
// "feature bot bar debug" => "feature bot bar debug",
// "feature bot bar rss" => "feature bot bar rss",
// "feature bot bar power by tw" => "feature bot bar power by tw",
// "maxRecords" => "maxRecords",
// "maxArticles" => "maxArticles",
// "maxVersions" => "maxVersions",
// "feature view tpl" => "feature view tpl",
// "slide style" => "slide style",
// "site favicon" => "site favicon",
// "site favicon type" => "site favicon type",
// "style" => "style",
// "style option" => "style option",
// "site style" => "site style",
// "site style option" => "site style option",
// "use context menu icon" => "use context menu icon",
// "use context menu text" => "use context menu text",
// "feature site report" => "feature site report",
// "feature site send link" => "feature site send link",
// "feature layoutshadows" => "feature layoutshadows",
// "main shadow start" => "main shadow start",
// "main shadow end" => "main shadow end",
// "header shadow start" => "header shadow start",
// "header shadow end" => "header shadow end",
// "middle shadow start" => "middle shadow start",
// "middle shadow end" => "middle shadow end",
// "center shadow start" => "center shadow start",
// "center shadow end" => "center shadow end",
// "footer shadow start" => "footer shadow start",
// "footer shadow end" => "footer shadow end",
// "box shadow start" => "box shadow start",
// "box shadow end" => "box shadow end",
// "feature custom center column header" => "feature custom center column header",
// "feature mods provider" => "feature mods provider",
// "mods dir" => "mods dir",
// "mods server" => "mods server",
// "feature experimental" => "feature experimental",
// "feature actionlog" => "feature actionlog",
// "feature actionlog bytes" => "feature actionlog bytes",
// "browsertitle" => "browsertitle",
// "site title location" => "site title location",
// "site title breadcrumb" => "site title breadcrumb",
// "tmpDir" => "tmpDir",
// "feature tell a friend" => "feature tell a friend",
// "feature copyright" => "feature copyright",
// "feature multimedia" => "feature multimedia",
// "feature smileys" => "feature smileys",
// "popupLinks" => "popupLinks",
// "feature autolinks" => "feature autolinks",
// "default rows textarea wiki" => "default rows textarea wiki",
// "default rows textarea comment" => "default rows textarea comment",
// "default rows textarea forum" => "default rows textarea forum",
// "default rows textarea forumthread" => "default rows textarea forumthread",
// "section comments parse" => "section comments parse",
// "toolbar global" => "toolbar global",
// "toolbar global comments" => "toolbar global comments",
// "direct pagination" => "direct pagination",
// "nextprev pagination" => "nextprev pagination",
// "pagination firstlast" => "pagination firstlast",
// "pagination hide if one page" => "pagination hide if one page",
// "pagination icons" => "pagination icons",
// "pagination fastmove links" => "pagination fastmove links",
// "direct pagination max middle links" => "direct pagination max middle links",
// "direct pagination max ending links" => "direct pagination max ending links",
// "feature kaltura" => "feature kaltura",
// "wikiplugin kaltura" => "wikiplugin kaltura",
// "wikiplugininline kaltura" => "wikiplugininline kaltura",
// "default kaltura editor" => "default kaltura editor",
// "partnerId" => "partnerId",
// "secret" => "secret",
// "adminSecret" => "adminSecret",
// "kdpUIConf" => "kdpUIConf",
// "kdpWidget" => "kdpWidget",
// "kcwUIConf" => "kcwUIConf",
// "kseUIConf" => "kseUIConf",
// "kaeUIConf" => "kaeUIConf",
// "anonCanEdit" => "anonCanEdit",
// "cacheimages" => "cacheimages",
// "cachepages" => "cachepages",
// "count admin pvs" => "count admin pvs",
// "default mail charset" => "default mail charset",
// "error reporting adminonly" => "error reporting adminonly",
// "error reporting level" => "error reporting level",
// "smarty notice reporting" => "smarty notice reporting",
// "smarty security" => "smarty security",
// "feature htmlpurifier output" => "feature htmlpurifier output",
// "feature ajax" => "feature ajax",
// "feature ajax autosave" => "feature ajax autosave",
// "feature antibot" => "feature antibot",
// "feature banners" => "feature banners",
// "feature banning" => "feature banning",
// "feature comm" => "feature comm",
// "feature contribution" => "feature contribution",
// "feature contribution display in comment" => "feature contribution display in comment",
// "feature contribution mandatory" => "feature contribution mandatory",
// "feature contribution mandatory blog" => "feature contribution mandatory blog",
// "feature contribution mandatory comment" => "feature contribution mandatory comment",
// "feature contribution mandatory forum" => "feature contribution mandatory forum",
// "feature debug console" => "feature debug console",
// "feature debugger console" => "feature debugger console",
// "feature display my to others" => "feature display my to others",
// "feature dynamic content" => "feature dynamic content",
// "feature edit templates" => "feature edit templates",
// "feature editcss" => "feature editcss",
// "feature events" => "feature events",
// "feature friends" => "feature friends",
// "feature fullscreen" => "feature fullscreen",
// "feature help" => "feature help",
// "feature hotwords" => "feature hotwords",
// "feature hotwords nw" => "feature hotwords nw",
// "feature integrator" => "feature integrator",
// "feature live support" => "feature live support",
// "feature mailin" => "feature mailin",
// "feature menusfolderstyle" => "feature menusfolderstyle",
// "feature mobile" => "feature mobile",
// "feature modulecontrols" => "feature modulecontrols",
// "feature morcego" => "feature morcego",
// "feature multilingual" => "feature multilingual",
// "feature multilingual one page" => "feature multilingual one page",
// "feature multilingual structures" => "feature multilingual structures",
// "feature machine translation" => "feature machine translation",
// "feature newsletters" => "feature newsletters",
// "feature obzip" => "feature obzip",
// "feature perspective" => "feature perspective",
// "feature phplayers" => "feature phplayers",
// "feature cssmenus" => "feature cssmenus",
// "feature projects" => "feature projects",
// "feature ranking" => "feature ranking",
// "feature redirect on error" => "feature redirect on error",
// "feature referer highlight" => "feature referer highlight",
// "feature referer stats" => "feature referer stats",
// "feature score" => "feature score",
// "feature sheet" => "feature sheet",
// "feature shoutbox" => "feature shoutbox",
// "feature source" => "feature source",
// "feature stats" => "feature stats",
// "feature tabs" => "feature tabs",
// "feature theme control" => "feature theme control",
// "feature ticketlib" => "feature ticketlib",
// "feature ticketlib2" => "feature ticketlib2",
// "feature top banner" => "feature top banner",
// "feature usability" => "feature usability",
// "feature use quoteplugin" => "feature use quoteplugin",
// "feature user watches" => "feature user watches",
// "feature group watches" => "feature group watches",
// "feature user watches translations" => "feature user watches translations",
// "feature daily report watches" => "feature daily report watches",
// "feature quick object perms" => "feature quick object perms",
// "feature xmlrpc" => "feature xmlrpc",
// "helpurl" => "helpurl",
// "layout section" => "layout section",
// "limitedGoGroupHome" => "limitedGoGroupHome",
// "minical reminders" => "minical reminders",
// "modallgroups" => "modallgroups",
// "modseparateanon" => "modseparateanon",
// "php docroot" => "php docroot",
// "proxy host" => "proxy host",
// "proxy port" => "proxy port",
// "ip can be checked" => "ip can be checked",
// "sender email" => "sender email",
// "feature site report email" => "feature site report email",
// "session storage" => "session storage",
// "session lifetime" => "session lifetime",
// "session silent" => "session silent",
// "session cookie name" => "session cookie name",
// "shoutbox autolink" => "shoutbox autolink",
// "show comzone" => "show comzone",
// "tikiIndex" => "tikiIndex",
// "urlIndex" => "urlIndex",
// "useGroupHome" => "useGroupHome",
// "useGroupTheme" => "useGroupTheme",
// "useUrlIndex" => "useUrlIndex",
// "use proxy" => "use proxy",
// "user list order" => "user list order",
// "webserverauth" => "webserverauth",
// "feature purifier" => "feature purifier",
// "feature shadowbox" => "feature shadowbox",
// "log sql" => "log sql",
// "log sql perf min" => "log sql perf min",
// "log mail" => "log mail",
// "log tpl" => "log tpl",
// "case patched" => "case patched",
// "site closed" => "site closed",
// "site closed msg" => "site closed msg",
// "use load threshold" => "use load threshold",
// "load threshold" => "load threshold",
// "site busy msg" => "site busy msg",
// "bot logo code" => "bot logo code",
// "feature blogposts pings" => "feature blogposts pings",
// "feature create webhelp" => "feature create webhelp",
// "page n times in a structure" => "page n times in a structure",
// "feature forums search" => "feature forums search",
// "feature trackbackpings" => "feature trackbackpings",
// "feature wiki ext icon" => "feature wiki ext icon",
// "feature wiki mandatory category" => "feature wiki mandatory category",
// "feature intertiki imported groups" => "feature intertiki imported groups",
// "feature wiki history ip" => "feature wiki history ip",
// "pam create user tiki" => "pam create user tiki",
// "pam service" => "pam service",
// "pam skip admin" => "pam skip admin",
// "shib affiliation" => "shib affiliation",
// "shib create user tiki" => "shib create user tiki",
// "shib group" => "shib group",
// "shib skip admin" => "shib skip admin",
// "shib usegroup" => "shib usegroup",
// "wiki 3d camera distance" => "wiki 3d camera distance",
// "wiki 3d elastic constant" => "wiki 3d elastic constant",
// "wiki 3d eletrostatic constant" => "wiki 3d eletrostatic constant",
// "wiki 3d fov" => "wiki 3d fov",
// "wiki 3d friction constant" => "wiki 3d friction constant",
// "wiki 3d node charge" => "wiki 3d node charge",
// "wiki 3d node mass" => "wiki 3d node mass",
// "wiki 3d node size" => "wiki 3d node size",
// "wiki 3d spring size" => "wiki 3d spring size",
// "wiki 3d text size" => "wiki 3d text size",
// "articles feature copyrights" => "articles feature copyrights",
// "blogues feature copyrights" => "blogues feature copyrights",
// "faqs feature copyrights" => "faqs feature copyrights",
// "feature contributor wiki" => "feature contributor wiki",
// "https login required" => "https login required",
// "maxRowsGalleries" => "maxRowsGalleries",
// "replimaster" => "replimaster",
// "rowImagesGalleries" => "rowImagesGalleries",
// "scaleSizeGalleries" => "scaleSizeGalleries",
// "thumbSizeXGalleries" => "thumbSizeXGalleries",
// "thumbSizeYGalleries" => "thumbSizeYGalleries",
// "wiki 3d adjust camera" => "wiki 3d adjust camera",
// "wiki 3d autoload" => "wiki 3d autoload",
// "javascript enabled" => "javascript enabled",
// "feature comments post as anonymous" => "feature comments post as anonymous",
// "feature comments moderation" => "feature comments moderation",
// "feature comments locking" => "feature comments locking",
// "feature template zoom" => "feature template zoom",
// "menus items icons" => "menus items icons",
// "menus items icons path" => "menus items icons path",
// "feature iepngfix" => "feature iepngfix",
// "iepngfix selectors" => "iepngfix selectors",
// "iepngfix elements" => "iepngfix elements",
// "valid email regex" => "valid email regex",
// "feature jquery" => "feature jquery",
// "jquery effect" => "jquery effect",
// "jquery effect direction" => "jquery effect direction",
// "jquery effect speed" => "jquery effect speed",
// "jquery effect tabs" => "jquery effect tabs",
// "jquery effect tabs direction" => "jquery effect tabs direction",
// "jquery effect tabs speed" => "jquery effect tabs speed",
// "feature jquery ui" => "feature jquery ui",
// "feature jquery ui theme" => "feature jquery ui theme",
// "feature jquery tooltips" => "feature jquery tooltips",
// "feature jquery autocomplete" => "feature jquery autocomplete",
// "feature jquery superfish" => "feature jquery superfish",
// "feature jquery reflection" => "feature jquery reflection",
// "feature jquery sheet" => "feature jquery sheet",
// "feature jquery tablesorter" => "feature jquery tablesorter",
// "feature jquery cycle" => "feature jquery cycle",
// "feature sefurl" => "feature sefurl",
// "feature sefurl filter" => "feature sefurl filter",
// "feature sefurl paths" => "feature sefurl paths",
// "feature sefurl title article" => "feature sefurl title article",
// "feature sefurl title blog" => "feature sefurl title blog",
// "feature wiki screencasts" => "feature wiki screencasts",
// "feature wiki screencasts base" => "feature wiki screencasts base",
// "feature wiki screencasts httpbase" => "feature wiki screencasts httpbase",
// "feature wiki screencasts upload type" => "feature wiki screencasts upload type",
// "feature wiki screencasts user" => "feature wiki screencasts user",
// "feature wiki screencasts pass" => "feature wiki screencasts pass",
// "feature wiki screencasts max size" => "feature wiki screencasts max size",
// "feature tikitests" => "feature tikitests",
// "profile sources" => "profile sources",
// "profile channels" => "profile channels",
// "feature minichat" => "feature minichat",
// "memcache enabled" => "memcache enabled",
// "memcache flags" => "memcache flags",
// "memcache servers" => "memcache servers",
// "memcache expiration" => "memcache expiration",
// "memcache prefix" => "memcache prefix",
// "memcache wiki data" => "memcache wiki data",
// "memcache wiki output" => "memcache wiki output",
// "memcache forum output" => "memcache forum output",
// "feature pear date" => "feature pear date",
// "feature bidi" => "feature bidi",
// "feature lastup" => "feature lastup",
// "magic last load" => "magic last load",
// "feature groupalert" => "feature groupalert",
// "zend mail handler" => "zend mail handler",
// "zend mail smtp server" => "zend mail smtp server",
// "zend mail smtp auth" => "zend mail smtp auth",
// "zend mail smtp user" => "zend mail smtp user",
// "zend mail smtp pass" => "zend mail smtp pass",
// "zend mail smtp port" => "zend mail smtp port",
// "zend mail smtp security" => "zend mail smtp security",
// "feature group transition" => "feature group transition",
// "feature category transition" => "feature category transition",
// "terminology profile installed" => "terminology profile installed",
// "multidomain active" => "multidomain active",
// "multidomain config" => "multidomain config",
// "feature use minified scripts" => "feature use minified scripts",
// "tiki minify javascript" => "tiki minify javascript",
// "lib spellcheck" => "lib spellcheck",
// "wiki spellcheck" => "wiki spellcheck",
// "blog spellcheck" => "blog spellcheck",
// "allowMsgs" => "allowMsgs",
// "diff versions" => "diff versions",
// "display timezone" => "display timezone",
// "email is public" => "email is public",
// "homePage" => "homePage",
// "lat" => "lat",
// "lon" => "lon",
// "mess archiveAfter" => "mess archiveAfter",
// "mess maxRecords" => "mess maxRecords",
// "mess sendReadStatus" => "mess sendReadStatus",
// "minPrio" => "minPrio",
// "mytiki blogs" => "mytiki blogs",
// "mytiki articles" => "mytiki articles",
// "mytiki gals" => "mytiki gals",
// "mytiki items" => "mytiki items",
// "mytiki msgs" => "mytiki msgs",
// "mytiki pages" => "mytiki pages",
// "mytiki tasks" => "mytiki tasks",
// "mytiki forum topics" => "mytiki forum topics",
// "mytiki forum replies" => "mytiki forum replies",
// "realName" => "realName",
// "gender" => "gender",
// "show mouseover user info" => "show mouseover user info",
// "tasks maxRecords" => "tasks maxRecords",
// "user dbl" => "user dbl",
// "user information" => "user information",
// "mailCharset" => "mailCharset",
// "mailCurrentAccount" => "mailCurrentAccount",
// "Click Here to Insert in Wiki Syntax" => "Click Here to Insert in Wiki Syntax",
// "Select Categories" => "Select Categories",
// "Select/deselect all categories" => "Select/deselect all categories",
// "top of page" => "top of page",
// "Report this post" => "Report this post",
// "Group Monitor" => "Group Monitor",
// "Watched by categories" => "Watched by categories",
// "Errors" => "Errors",
// "Comments Locked" => "Comments Locked",
// "Comments are locked" => "Comments are locked",
// "Note" => "Note",
// "required" => "required",
// "Maximum size" => "Maximum size",
// "Enter your name" => "Enter your name",
// "If you would like to be notified when someone replies to this topic<br />please tell us your e-mail address" => "If you would like to be notified when someone replies to this topic<br />please tell us your e-mail address",
// "Please note that the preview does not keep the attached file which you will have to choose before posting" => "Please note that the preview does not keep the attached file which you will have to choose before posting",
// "Post as Anonymous" => "Post as Anonymous",
// "Your comment will have to be approved by the moderator before it is displayed" => "Your comment will have to be approved by the moderator before it is displayed",
// "Type of contribution" => "Type of contribution",
// "Contributors" => "Contributors",
// "System error" => "System error",
// "Database is not currently up to date! Visit <a href=\"tiki-install.php\">Tiki Installer</a> to resolve this issue" => "Database is not currently up to date! Visit <a href=\"tiki-install.php\">Tiki Installer</a> to resolve this issue",
// "If you have shell (SSH) access, you can also use the following, on the command line, from the root of your Tiki installation" => "If you have shell (SSH) access, you can also use the following, on the command line, from the root of your Tiki installation",
// "The query was" => "The query was",
// "The built query was likely" => "The built query was likely",
// "Stacktrace" => "Stacktrace",
// "Duplicate File Gallery" => "Duplicate File Gallery",
// "File gallery" => "File gallery",
// "Duplicate categories" => "Duplicate categories",
// "Duplicate permissions" => "Duplicate permissions",
// "View inserted gallery" => "View inserted gallery",
// "Any file" => "Any file",
// "Podcast (audio)" => "Podcast (audio)",
// "Podcast (video)" => "Podcast (video)",
// "Gallery is visible to non-admin users" => "Gallery is visible to non-admin users",
// "Gallery is public" => "Gallery is public",
// "Any user with permission (not only the gallery owner) can upload files" => "Any user with permission (not only the gallery owner) can upload files",
// "Files can be locked at download" => "Files can be locked at download",
// "Maximum number of archives for each file" => "Maximum number of archives for each file",
// "Quota" => "Quota",
// "Used" => "Used",
// "Min" => "Min",
// "Group of users alerted when file gallery is modified" => "Group of users alerted when file gallery is modified",
// "Allows to select each user for small groups" => "Allows to select each user for small groups",
// "Display Properties" => "Display Properties",
// "Descending" => "Descending",
// "Ascending" => "Ascending",
// "Max rows per page" => "Max rows per page",
// "Select which items to display when listing galleries" => "Select which items to display when listing galleries",
// "Perhaps you are looking for" => "Perhaps you are looking for",
// "Go to Login Page" => "Go to Login Page",
// "Go to" => "Go to",
// "Private Gallery" => "Private Gallery",
// "Archives" => "Archives",
// "Upload New Version" => "Upload New Version",
// "Download and lock" => "Download and lock",
// "The checkbox is disabled because this preference is disabled globally" => "The checkbox is disabled because this preference is disabled globally",
// "Please, enable the preference globally first" => "Please, enable the preference globally first",
// "You can ask your site Admin to enable the preference" => "You can ask your site Admin to enable the preference",
// "Show as a column" => "Show as a column",
// "Show in popup box" => "Show in popup box",
// "Show an icon in a column" => "Show an icon in a column",
// "Start the Slideshow" => "Start the Slideshow",
// "Pause the Slideshow" => "Pause the Slideshow",
// "any type" => "any type",
// "all topic" => "all topic",
// "any language" => "any language",
// "not in" => "not in",
// "any category" => "any category",
// "Clear Filter" => "Clear Filter",
// "Show php error messages" => "Show php error messages",
// "Folksonomy Tags" => "Folksonomy Tags",
// "Put tags separated by spaces. For tags with more than one word, use no spaces and put words together or enclose them with double quotes" => "Put tags separated by spaces. For tags with more than one word, use no spaces and put words together or enclose them with double quotes",
// "Tags" => "Tags",
// "Translate tags" => "Translate tags",
// "Images Galleries" => "Images Galleries",
// "RSS Calendars" => "RSS Calendars",
// "Show Tree" => "Show Tree",
// "Hide Tree" => "Hide Tree",
// "Are you sure you want to delete the selected files" => "Are you sure you want to delete the selected files",
// "Download the zip" => "Download the zip",
// "Other Sorts" => "Other Sorts",
// "No Additionnal Sort" => "No Additionnal Sort",
// "No information" => "No information",
// "To validate your account and login to the site, please click on the following link" => "To validate your account and login to the site, please click on the following link",
// "The administrator approved your account" => "The administrator approved your account",
// "Confirm your email at %s" => "Confirm your email at %s",
// "A new topic was posted to forum" => "A new topic was posted to forum",
// "You are invited by" => "You are invited by",
// "You join this group" => "You join this group",
// "Join me on %s" => "Join me on %s",
// "{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first" => "{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first",
// "Assign to a group" => "Assign to a group",
// "Best regards" => "Best regards",
// "User Tracker" => "User Tracker",
// "Someone" => "Someone",
// "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else" => "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else",
// "Report for" => "Report for",
// "Last Report sent on" => "Last Report sent on",
// "Changes in detail" => "Changes in detail",
// "Look at this link" => "Look at this link",
// "A friend sends you a link from: " => "A friend sends you a link from: ",
// "ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}" => "ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}",
// "New status ItemID {\$mail_itemId} for the tracker {\$mail_trackerName}" => "New status ItemID {\$mail_itemId} for the tracker {\$mail_trackerName}",
// "Download the file at" => "Download the file at",
// "Please visit this link before login again" => "Please visit this link before login again",
// "Last attempt" => "Last attempt",
// "Confirm your account at %s" => "Confirm your account at %s",
// "An administrator of the site below has added you as a new user" => "An administrator of the site below has added you as a new user",
// "If you want to confirm your membership in this site, click on the following link to login for the first time" => "If you want to confirm your membership in this site, click on the following link to login for the first time",
// "Your authentication credentials are" => "Your authentication credentials are",
// "Welcome on the site" => "Welcome on the site",
// "Your personal access to" => "Your personal access to",
// "You'll receive email notification once your account is activated" => "You'll receive email notification once your account is activated",
// "Please do not attempt to login until you receive the email notification" => "Please do not attempt to login until you receive the email notification",
// "{\$mail_action} article post" => "{\$mail_action} article post",
// "{\$mail_title} by {\$mail_user} at" => "{\$mail_title} by {\$mail_user} at",
// "New article post" => "New article post",
// "Edited article post" => "Edited article post",
// "Deleted article post" => "Deleted article post",
// "{\$mail_action} article post at" => "{\$mail_action} article post at",
// "View item calendar at" => "View item calendar at",
// "Modified calendar item" => "Modified calendar item",
// "New calendar item" => "New calendar item",
// "A new category was created in" => "A new category was created in",
// "A category was removed in" => "A category was removed in",
// "removed" => "removed",
// "A category was updated" => "A category was updated",
// "Updated by" => "Updated by",
// "Old" => "Old",
// "updated" => "updated",
// "New forum topic in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}" => "New forum topic in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}",
// "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}" => "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}",
// "Image Gallery {\$galleryName} changed" => "Image Gallery {\$galleryName} changed",
// "A new file was posted to image gallery" => "A new file was posted to image gallery",
// "An object was added to category" => "An object was added to category",
// "Added by" => "Added by",
// "An object was removed from category" => "An object was removed from category",
// "A page has been added to your watched sub-structure" => "A page has been added to your watched sub-structure",
// "A page has been removed from your watched sub-structure" => "A page has been removed from your watched sub-structure",
// "A page has been promoted out your watched sub-structure" => "A page has been promoted out your watched sub-structure",
// "A page has been demoted to your watched structure" => "A page has been demoted to your watched structure",
// "Structure modified" => "Structure modified",
// "A new file have been attached to page" => "A new file have been attached to page",
// "File name" => "File name",
// "New attachment on %s, page" => "New attachment on %s, page",
// "The page {\$mail_page} was deleted by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was deleted by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "A file was attached to {\$mail_page}" => "A file was attached to {\$mail_page}",
// "The page {\$mail_page} was deleted but used to be here" => "The page {\$mail_page} was deleted but used to be here",
// "The old page content follows below" => "The old page content follows below",
// "Wiki page %s created by {\$mail_user}" => "Wiki page %s created by {\$mail_user}",
// "Wiki page %s deleted by {\$mail_user}" => "Wiki page %s deleted by {\$mail_user}",
// "A file was attached to %s" => "A file was attached to %s",
// "Wiki page %s changed by {\$mail_user}" => "Wiki page %s changed by {\$mail_user}",
// "Wiki page %s was commented on by" => "Wiki page %s was commented on by",
// "an anonymous user" => "an anonymous user",
// "Thank you for your registration. You may log in now" => "Thank you for your registration. You may log in now",
// "Query Results" => "Query Results",
// "Querying" => "Querying",
// "Scroll Up" => "Scroll Up",
// "Scroll Down" => "Scroll Down",
// "Zoom out" => "Zoom out",
// "Zoom in" => "Zoom in",
// "from the mapfile" => "from the mapfile",
// "Confirmation" => "Confirmation",
// "Please Confirm" => "Please Confirm",
// "If you want people to be able to reply to you, enable <a href='tiki-user_preferences.php'>Allow messages from other users</a> in your preferences" => "If you want people to be able to reply to you, enable <a href='tiki-user_preferences.php'>Allow messages from other users</a> in your preferences",
// "ERROR" => "ERROR",
// "is reply to" => "is reply to",
// "Toggle module contents" => "Toggle module contents",
// "toggle" => "toggle",
// "Toggle Vertically" => "Toggle Vertically",
// "More.." => "More..",
// "To configure your Tiki" => "To configure your Tiki",
// "Admin Home" => "Admin Home",
// "from the menu" => "from the menu",
// "Read the <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">configuration documentation</a>" => "Read the <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">configuration documentation</a>",
// "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies" => "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies",
// "To remove this module" => "To remove this module",
// "and remove the assistant module" => "and remove the assistant module",
// "You can also add other modules" => "You can also add other modules",
// "To customize the menu" => "To customize the menu",
// "and edit menu ID 42" => "and edit menu ID 42",
// "Or, create your own menu and add it to a module" => "Or, create your own menu and add it to a module",
// "To begin configuring Tiki, please" => "To begin configuring Tiki, please",
// "as admin" => "as admin",
// "The Tikiwiki Community" => "The Tikiwiki Community",
// "To learn more, visit: <a href=\"http://tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://tikiwiki.org</a>" => "To learn more, visit: <a href=\"http://tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://tikiwiki.org</a>",
// "Tikiwiki Documentation" => "Tikiwiki Documentation",
// "For help, visit <a href=\"http://doc.tikiwiki.org\" title=\"Tikiwiki Documentation\" target=\"_blank\">http://doc.tikiwiki.org</a>" => "For help, visit <a href=\"http://doc.tikiwiki.org\" title=\"Tikiwiki Documentation\" target=\"_blank\">http://doc.tikiwiki.org</a>",
// "on blogpost" => "on blogpost",
// "Add event" => "Add event",
// "Missing %0 of the following categories" => "Missing %0 of the following categories",
// "%0 extra of the following categories" => "%0 extra of the following categories",
// "Unknown comparison" => "Unknown comparison",
// "Impossible condition, %0 of" => "Impossible condition, %0 of",
// "Apply" => "Apply",
// "Assign into category" => "Assign into category",
// "Unassign category" => "Unassign category",
// "Tags This Page Has" => "Tags This Page Has",
// "Add tags" => "Add tags",
// "List everything tagged" => "List everything tagged",
// "All Groups" => "All Groups",
// "Your Groups" => "Your Groups",
// "Emulated Groups" => "Emulated Groups",
// "Switch to Groups" => "Switch to Groups",
// "Simulate" => "Simulate",
// "No records to display" => "No records to display",
// "insert original" => "insert original",
// "insert thumbnail" => "insert thumbnail",
// "more" => "more",
// "No avatar" => "No avatar",
// "You" => "You",
// "Logged in as" => "Logged in as",
// "Switch User" => "Switch User",
// "Enter user name and click 'Switch'.<br />Useful for testing permissions" => "Enter user name and click 'Switch'.<br />Useful for testing permissions",
// "Switch user" => "Switch user",
// "Login through Shibboleth" => "Login through Shibboleth",
// "Login as" => "Login as",
// "CapsLock is on" => "CapsLock is on",
// "OpenID Login" => "OpenID Login",
// "What is OpenID" => "What is OpenID",
// "Wiki feed" => "Wiki feed",
// "Feed" => "Feed",
// "Blogs feed" => "Blogs feed",
// "Articles feed" => "Articles feed",
// "Image Galleries feed" => "Image Galleries feed",
// "File Galleries feed" => "File Galleries feed",
// "Forums feed" => "Forums feed",
// "Maps feed" => "Maps feed",
// "Calendars" => "Calendars",
// "A leading plus sign indicates that this word must be present in every object returned" => "A leading plus sign indicates that this word must be present in every object returned",
// "A leading minus sign indicates that this word must not be present in any row returned" => "A leading minus sign indicates that this word must not be present in any row returned",
// "By default (when neither plus nor minus is specified) the word is optional, but the object that contain it will be rated higher" => "By default (when neither plus nor minus is specified) the word is optional, but the object that contain it will be rated higher",
// "These two operators are used to change a word's contribution to the relevance value that is assigned to a row" => "These two operators are used to change a word's contribution to the relevance value that is assigned to a row",
// "Parentheses are used to group words into subexpressions" => "Parentheses are used to group words into subexpressions",
// "A leading tilde acts as a negation operator, causing the word's contribution to the object relevance to be negative. It's useful for marking noise words. An object that contains such a word will be rated lower than others, but will not be excluded altogether, as it would be with the - operator" => "A leading tilde acts as a negation operator, causing the word's contribution to the object relevance to be negative. It's useful for marking noise words. An object that contains such a word will be rated lower than others, but will not be excluded altogether, as it would be with the - operator",
// "An asterisk is the truncation operator. Unlike the other operators, it should be appended to the word, not prepended" => "An asterisk is the truncation operator. Unlike the other operators, it should be appended to the word, not prepended",
// "The phrase, that is enclosed in double quotes &quot;, matches only objects that contain this phrase literally, as it was typed" => "The phrase, that is enclosed in double quotes &quot;, matches only objects that contain this phrase literally, as it was typed",
// "Advanced search" => "Advanced search",
// "Advanced Search Help" => "Advanced Search Help",
// "Page Relations" => "Page Relations",
// "Are you sure you want to delete this shout" => "Are you sure you want to delete this shout",
// "Shout date" => "Shout date",
// "Delete this shout" => "Delete this shout",
// "Edit this shout" => "Edit this shout",
// "New Calendar Events" => "New Calendar Events",
// "Nothing has changed" => "Nothing has changed",
// "`\$module_params.prefix`" => "`\$module_params.prefix`",
// "Site Language" => "Site Language",
// "Site default" => "Site default",
// "Find term" => "Find term",
// "If not found, you will be given a chance to create it" => "If not found, you will be given a chance to create it",
// "TikiTests Menu" => "TikiTests Menu",
// "List Tests" => "List Tests",
// "Create Test" => "Create Test",
// "There are no translations of this page" => "There are no translations of this page",
// "Up-to-date-ness" => "Up-to-date-ness",
// "Better translations" => "Better translations",
// "update from it" => "update from it",
// "None match your" => "None match your",
// "Set your preferred languages" => "Set your preferred languages",
// "preferred languages" => "preferred languages",
// "Equivalent translations" => "Equivalent translations",
// "Translations that need improvement" => "Translations that need improvement",
// "update it" => "update it",
// "Group information" => "Group information",
// "You need to activate user and/or group trackers" => "You need to activate user and/or group trackers",
// "Webmail inbox" => "Webmail inbox",
// "Refresh (non-ajax)" => "Refresh (non-ajax)",
// "TAKE" => "TAKE",
// "View contact" => "View contact",
// "User does not accept messages" => "User does not accept messages",
// "More Videos" => "More Videos",
// "Changes that need to be reproduced are highlighted below" => "Changes that need to be reproduced are highlighted below",
// "Use Ctrl+Click to select multiple options" => "Use Ctrl+Click to select multiple options",
// "Requires" => "Requires",
// "You need to set" => "You need to set",
// "Insert/Edit an internal wiki link" => "Insert/Edit an internal wiki link",
// "Wiki Link insert" => "Wiki Link insert",
// "Please make a selection of text in order to create a link" => "Please make a selection of text in order to create a link",
// "Insert an image" => "Insert an image",
// "Tiki Image - Insert an image" => "Tiki Image - Insert an image",
// "Switch to normal (wiki) editor" => "Switch to normal (wiki) editor",
// "By" => "By",
// "Read more" => "Read more",
// "Do not group by item" => "Do not group by item",
// "Group by item" => "Group by item",
// "Tiki Action Calendar" => "Tiki Action Calendar",
// "Select <a href=\"tiki-list_banners.php\" title=\"Banners\">Admin &gt; Banners</a> from the menu to create and edit banner zones" => "Select <a href=\"tiki-list_banners.php\" title=\"Banners\">Admin &gt; Banners</a> from the menu to create and edit banner zones",
// "<strong>Activate</strong> will display content for Admin only. Select <strong>Publish</strong> to display for all users" => "<strong>Activate</strong> will display content for Admin only. Select <strong>Publish</strong> to display for all users",
// "Global site configuration, date formats, admin password etc" => "Global site configuration, date formats, admin password etc",
// "Switches for major features" => "Switches for major features",
// "User resistration, remember me cookie settings and authentication methods" => "User resistration, remember me cookie settings and authentication methods",
// "User specific features and settings" => "User specific features and settings",
// "Profiles" => "Profiles",
// "Repository configuration, browse and apply profiles" => "Repository configuration, browse and apply profiles",
// "Look & Feel" => "Look & Feel",
// "Theme selection, layout settings and UI effect controls" => "Theme selection, layout settings and UI effect controls",
// "i18n" => "i18n",
// "Internationalization and localization - mulitlingual features" => "Internationalization and localization - mulitlingual features",
// "Editing and Plugins" => "Editing and Plugins",
// "Text editing settings applicable to many areas. Plugin activation and plugin alias management" => "Text editing settings applicable to many areas. Plugin activation and plugin alias management",
// "Module appearance settings" => "Module appearance settings",
// "Information to include in the header of each page" => "Information to include in the header of each page",
// "Performance" => "Performance",
// "Server performance settings" => "Server performance settings",
// "Site security settings" => "Site security settings",
// "Feeds" => "Feeds",
// "Web feeds" => "Web feeds",
// "Connect" => "Connect",
// "Wiki page settings and features" => "Wiki page settings and features",
// "Defaults and configuration for file galleries" => "Defaults and configuration for file galleries",
// "Settings for blogs" => "Settings for blogs",
// "Defaults and configuration for image galleries (will be phased out in favour of file galleries)" => "Defaults and configuration for image galleries (will be phased out in favour of file galleries)",
// "Settings and features for articles" => "Settings and features for articles",
// "Settings and features for forums" => "Settings and features for forums",
// "Settings and features for trackers" => "Settings and features for trackers",
// "Settings and features for polls" => "Settings and features for polls",
// "Settings and features for calendars" => "Settings and features for calendars",
// "Settings and features for categories" => "Settings and features for categories",
// "Values of actions for users rank score" => "Values of actions for users rank score",
// "Settings and features for freetags" => "Settings and features for freetags",
// "Search configuration" => "Search configuration",
// "Settings and features for FAQs" => "Settings and features for FAQs",
// "Settings and features for directory of links" => "Settings and features for directory of links",
// "Settings and features for maps" => "Settings and features for maps",
// "Defaults and API key for Google Maps" => "Defaults and API key for Google Maps",
// "?" => "?",
// "Site-wide copyright information" => "Site-wide copyright information",
// "Message settings" => "Message settings",
// "User files settings" => "User files settings",
// "Webmail settings" => "Webmail settings",
// "Options for WYSIWYG editor" => "Options for WYSIWYG editor",
// "Set up links between Tiki servers" => "Set up links between Tiki servers",
// "Manage semantic wiki links" => "Manage semantic wiki links",
// "Webservices" => "Webservices",
// "Register and manage web services" => "Register and manage web services",
// "Sef URL" => "Sef URL",
// "Search Engine Friendly URLs" => "Search Engine Friendly URLs",
// "Kaltura video configuration" => "Kaltura video configuration",
// "Create a blog" => "Create a blog",
// "Requires a separate download" => "Requires a separate download",
// "Force and limit categorization to within subtree of" => "Force and limit categorization to within subtree of",
// "Blogs Listings" => "Blogs Listings",
// "Select which items to display when listing blogs" => "Select which items to display when listing blogs",
// "General settings" => "General settings",
// "Default calendars to display" => "Default calendars to display",
// "All calendars" => "All calendars",
// "A subset of available calendars" => "A subset of available calendars",
// "Create calendar" => "Create calendar",
// "Default view mode" => "Default view mode",
// "Day" => "Day",
// "Week" => "Week",
// "Month" => "Month",
// "Quarter" => "Quarter",
// "Semester" => "Semester",
// "View list begins" => "View list begins",
// "Focus Date" => "Focus Date",
// "Period beginning" => "Period beginning",
// "First day of the week" => "First day of the week",
// "Depends user language" => "Depends user language",
// "Split hours in periods of" => "Split hours in periods of",
// "1 minute" => "1 minute",
// "10 minutes" => "10 minutes",
// "15 minutes" => "15 minutes",
// "30 minutes" => "30 minutes",
// "Manual selection of time/date" => "Manual selection of time/date",
// "JS calendar" => "JS calendar",
// "Year selection is valid when the JS Calendar <strong>is not</strong> enabled" => "Year selection is valid when the JS Calendar <strong>is not</strong> enabled",
// "First year in the dropdown" => "First year in the dropdown",
// "Enter a year or use +/- N to specify a year relative to the current\n\tyear" => "Enter a year or use +/- N to specify a year relative to the current\n\tyear",
// "Last year in the dropdown" => "Last year in the dropdown",
// "Sticky popup" => "Sticky popup",
// "Item view tab" => "Item view tab",
// "Browse categories" => "Browse categories",
// "Administer categories" => "Administer categories",
// "Separate category IDs with a comma (,)" => "Separate category IDs with a comma (,)",
// "Will improve performance, but may show forbidden results" => "Will improve performance, but may show forbidden results",
// "Admin topics" => "Admin topics",
// "Admin types" => "Admin types",
// "Title of articles home page" => "Title of articles home page",
// "Article properties" => "Article properties",
// "Give only one value (width or height) to keep the image proportions" => "Give only one value (width or height) to keep the image proportions",
// "File format: title,authorName,heading,body,lang,user" => "File format: title,authorName,heading,body,lang,user",
// "Articles Listing" => "Articles Listing",
// "Select which items to display when listing articles" => "Select which items to display when listing articles",
// "User features" => "User features",
// "Highlight group" => "Highlight group",
// "Use the format: trackerId, fieldId1, fieldId2, .." => "Use the format: trackerId, fieldId1, fieldId2, ..",
// "Users can choose to show their gender" => "Users can choose to show their gender",
// "Requires User Preferences feature" => "Requires User Preferences feature",
// "Show user's information on mouseover" => "Show user's information on mouseover",
// "Requires user's information to be public" => "Requires user's information to be public",
// "Real name" => "Real name",
// "Feature is disabled" => "Feature is disabled",
// "Enable now" => "Enable now",
// "Default user preferences" => "Default user preferences",
// "Users Default Preferences" => "Users Default Preferences",
// "Character set for mail" => "Character set for mail",
// "Detect user timezone if browser allows, otherwise site default" => "Detect user timezone if browser allows, otherwise site default",
// "User messages" => "User messages",
// "Notify sender when reading mail" => "Notify sender when reading mail",
// "My forum topics" => "My forum topics",
// "My forum replies" => "My forum replies",
// "Select which items to display when listing users" => "Select which items to display when listing users",
// "Score ascending" => "Score ascending",
// "Score descending" => "Score descending",
// "Name ascending" => "Name ascending",
// "Name descending" => "Name descending",
// "Login ascending" => "Login ascending",
// "Login descending" => "Login descending",
// "TikiWiki CMS/Groupware is Free and Open Source Software (FOSS). It is a community-driven project which exists and improves thanks to the participation of people just like YOU" => "TikiWiki CMS/Groupware is Free and Open Source Software (FOSS). It is a community-driven project which exists and improves thanks to the participation of people just like YOU",
// "Join the community" => "Join the community",
// "Promote your site" => "Promote your site",
// "To submit your site to TikiWiki.org" => "To submit your site to TikiWiki.org",
// "Submit site" => "Submit site",
// "Help Tiki spread" => "Help Tiki spread",
// "Help improve Tiki" => "Help improve Tiki",
// "To submit a feature request or to report a bug" => "To submit a feature request or to report a bug",
// "Click here to go to our development site" => "Click here to go to our development site",
// "Copyright allows to determine a copyright for all the objects of tikiwiki" => "Copyright allows to determine a copyright for all the objects of tikiwiki",
// "Enable copyright management for" => "Enable copyright management for",
// "Please see the <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>evaluation of each feature</a> on Tiki's developer site" => "Please see the <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>evaluation of each feature</a> on Tiki's developer site",
// "Global features" => "Global features",
// "Main feature" => "Main feature",
// "Additional" => "Additional",
// "Programmer" => "Programmer",
// "These features are relatively new, or recently underwent major renovations. You should expect growing pains and possibly a lack of up to date documentation, as you would of a version 1.0 application" => "These features are relatively new, or recently underwent major renovations. You should expect growing pains and possibly a lack of up to date documentation, as you would of a version 1.0 application",
// "Experimental" => "Experimental",
// "Will be phased out" => "Will be phased out",
// "These features generally work but will probably be phased out in the future, because they are superseded by other features or because of evolution in Web technology" => "These features generally work but will probably be phased out in the future, because they are superseded by other features or because of evolution in Web technology",
// "Seem ok but.." => "Seem ok but..",
// "These features are not reported to be broken, but they are not actively developed and/or widely used" => "These features are not reported to be broken, but they are not actively developed and/or widely used",
// "Need polish" => "Need polish",
// "These features are generally known to have issues, and/or need admin help and/or user patience to work" => "These features are generally known to have issues, and/or need admin help and/or user patience to work",
// "Feedbacks" => "Feedbacks",
// "To create or remove file galleries, select" => "To create or remove file galleries, select",
// "from the application menu" => "from the application menu",
// "Create a Gallery" => "Create a Gallery",
// "Move files from database to directory" => "Move files from database to directory",
// "Move files from directory to database" => "Move files from directory to database",
// "Store in database" => "Store in database",
// "Store in directory" => "Store in directory",
// "Score is disabled" => "Score is disabled",
// "Upload Regex" => "Upload Regex",
// "Gallery Listings" => "Gallery Listings",
// "Changing these settings will <em>not</em> affect existing file galleries. These changes will apply <em>only</em> to new file galleries" => "Changing these settings will <em>not</em> affect existing file galleries. These changes will apply <em>only</em> to new file galleries",
// "Select which items to display when listing galleries: " => "Select which items to display when listing galleries: ",
// "Search Indexing" => "Search Indexing",
// "Automatically index files on upload or change" => "Automatically index files on upload or change",
// "Handlers" => "Handlers",
// "Add custom handlers to make your files &quot;searchable&quot; content" => "Add custom handlers to make your files &quot;searchable&quot; content",
// "Use <strong>%1</strong> as the internal file name. For example, use <strong>strings %1</strong> to convert the document to text, using the Unix <strong>strings</strong> command" => "Use <strong>%1</strong> as the internal file name. For example, use <strong>strings %1</strong> to convert the document to text, using the Unix <strong>strings</strong> command",
// "To delete a handler, leave the <strong>System Command</strong> field blank" => "To delete a handler, leave the <strong>System Command</strong> field blank",
// "System Command" => "System Command",
// "Create a forum" => "Create a forum",
// "If disabled, replies will quote the original post" => "If disabled, replies will quote the original post",
// "Will be a thread title" => "Will be a thread title",
// "Threads" => "Threads",
// "Allows users to override the defaults" => "Allows users to override the defaults",
// "When listing forums" => "When listing forums",
// "Forums Listing" => "Forums Listing",
// "Select which items to display when listing forums" => "Select which items to display when listing forums",
// "Show tag cloud" => "Show tag cloud",
// "Maximum number of tags in cloud" => "Maximum number of tags in cloud",
// "Show freetags in middle column" => "Show freetags in middle column",
// "Preload freetag random tag" => "Preload freetag random tag",
// "When arriving on <a href=\"tiki-browse_freetags.php\">freetag search page</a>" => "When arriving on <a href=\"tiki-browse_freetags.php\">freetag search page</a>",
// "Random tag cloud colors" => "Random tag cloud colors",
// "Separate colors with a comma (,)" => "Separate colors with a comma (,)",
// "Number of Tags to show in Tag Suggestions" => "Number of Tags to show in Tag Suggestions",
// "Valid characters pattern" => "Valid characters pattern",
// "Alphanumeric ASCII characters only" => "Alphanumeric ASCII characters only",
// "No accents or special characters" => "No accents or special characters",
// "Accept all charactrs" => "Accept all charactrs",
// "Lowercase tags only" => "Lowercase tags only",
// "&quot;More Like This&quot; algorithm" => "&quot;More Like This&quot; algorithm",
// "basic" => "basic",
// "weighted" => "weighted",
// "Minimum amount of tags in common" => "Minimum amount of tags in common",
// "Tag Management" => "Tag Management",
// "Cleanup unused tags" => "Cleanup unused tags",
// "3D Tag Browser" => "3D Tag Browser",
// "Morcego 3D browser disabled" => "Morcego 3D browser disabled",
// "Enable freetags 3D browser" => "Enable freetags 3D browser",
// "Graph appearance" => "Graph appearance",
// "Node color" => "Node color",
// "Camera settinsg" => "Camera settinsg",
// "Physics engine" => "Physics engine",
// "No Gallery exists" => "No Gallery exists",
// "Note: if you change this directory, you have to move the contents to the new directory. You can also use the 'Mover' below" => "Note: if you change this directory, you have to move the contents to the new directory. You can also use the 'Mover' below",
// "Display image informations in a mouseover box" => "Display image informations in a mouseover box",
// "yes, and don't display those informations under the image" => "yes, and don't display those informations under the image",
// "Use default max rows, images per row, thumbnails size and scale size for all galleries (set values below)" => "Use default max rows, images per row, thumbnails size and scale size for all galleries (set values below)",
// "Pixels Default" => "Pixels Default",
// "Default scale size" => "Default scale size",
// "Mover" => "Mover",
// "Move images from database storage to filesystem storage" => "Move images from database storage to filesystem storage",
// "Move images from filesystem storage to database storage" => "Move images from filesystem storage to database storage",
// "Move images from old filesystem store to new directory" => "Move images from old filesystem store to new directory",
// "Moved" => "Moved",
// "Release Check" => "Release Check",
// "Reset or upgrade your database" => "Reset or upgrade your database",
// "Check for updates now" => "Check for updates now",
// "Go to <a href=\"tiki-admin.php?page=look\" title=\"\"><strong>Look & Feel</strong></a> section for additional site related customization preferences" => "Go to <a href=\"tiki-admin.php?page=look\" title=\"\"><strong>Look & Feel</strong></a> section for additional site related customization preferences",
// "Mail" => "Mail",
// "Mail Sender" => "Mail Sender",
// "Sendmail" => "Sendmail",
// "SMTP" => "SMTP",
// "SMTP Server" => "SMTP Server",
// "Authentication" => "Authentication",
// "These values will be stored in plain text in the database" => "These values will be stored in plain text in the database",
// "Logging and Reporting" => "Logging and Reporting",
// "Visible to admin only" => "Visible to admin only",
// "Include Smarty notices" => "Include Smarty notices",
// "Spam protection" => "Spam protection",
// "MultiDomain" => "MultiDomain",
// "Session" => "Session",
// "Advanced configuration warning" => "Advanced configuration warning",
// "Note that storing session data in the database is an advanced systems administration option, and is for admins who have comprehensive access and understanding of the database, in order to deal with any unexpected effects" => "Note that storing session data in the database is an advanced systems administration option, and is for admins who have comprehensive access and understanding of the database, in order to deal with any unexpected effects",
// "Changing this feature will immediately log you out when you save this preference" => "Changing this feature will immediately log you out when you save this preference",
// "Miscellaneous" => "Miscellaneous",
// "Use TikiWiki feature as homepage" => "Use TikiWiki feature as homepage",
// "Use different URL as home page" => "Use different URL as home page",
// "Redirects" => "Redirects",
// "If a requested page doesn't exist, redirect to a similarly named page" => "If a requested page doesn't exist, redirect to a similarly named page",
// "On permission denied, display login module (for Anonymous)" => "On permission denied, display login module (for Anonymous)",
// "Send to URL" => "Send to URL",
// "Site Access" => "Site Access",
// "Default timezone" => "Default timezone",
// "Use site default to show times" => "Use site default to show times",
// "Detect user timezone (if browser allows). Otherwise use site default" => "Detect user timezone (if browser allows). Otherwise use site default",
// "Sample" => "Sample",
// "Fields display order" => "Fields display order",
// "Change the <strong>Admin</strong> password" => "Change the <strong>Admin</strong> password",
// "Minimum {\$prefs.min_pass_length} characters long" => "Minimum {\$prefs.min_pass_length} characters long",
// "To use Google Maps, you must generate a Google Maps API Key for your web site. See <a href=\"http://www.google.com/apis/maps/signup.html\">http://www.google.com/apis/maps/signup.html</a> for details" => "To use Google Maps, you must generate a Google Maps API Key for your web site. See <a href=\"http://www.google.com/apis/maps/signup.html\">http://www.google.com/apis/maps/signup.html</a> for details",
// "Google Maps API Key" => "Google Maps API Key",
// "Defaults" => "Defaults",
// "Default x for map center" => "Default x for map center",
// "Default y from map center" => "Default y from map center",
// "Default zoom level" => "Default zoom level",
// "whole earth" => "whole earth",
// "country size" => "country size",
// "city size" => "city size",
// "max zoom" => "max zoom",
// "Internationalization" => "Internationalization",
// "Edit or export/import Languages" => "Edit or export/import Languages",
// "Babelfish links" => "Babelfish links",
// "Customized String Translation" => "Customized String Translation",
// "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)" => "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)",
// "Intertiki shared cookie for sliding auth under same domain" => "Intertiki shared cookie for sliding auth under same domain",
// "Kaltura Registration" => "Kaltura Registration",
// "If you don't have a Kaltura Partner Id, " => "If you don't have a Kaltura Partner Id, ",
// "to register" => "to register",
// "Kaltura Partner Settings" => "Kaltura Partner Settings",
// "Partner Id" => "Partner Id",
// "User Secret" => "User Secret",
// "Admin Secret" => "Admin Secret",
// "Kaltura Dynamic Player" => "Kaltura Dynamic Player",
// "KDP UI Configuration Id" => "KDP UI Configuration Id",
// "KDP Widget Id" => "KDP Widget Id",
// "Kaltura Contribution Wizard" => "Kaltura Contribution Wizard",
// "KCW UI Configuration Id" => "KCW UI Configuration Id",
// "Kaltura Remix Editors" => "Kaltura Remix Editors",
// "Kaltura Simple Editor UI Configuration Id" => "Kaltura Simple Editor UI Configuration Id",
// "Kaltura Advance Editor UI Configuration Id" => "Kaltura Advance Editor UI Configuration Id",
// "Wysiwyg" => "Wysiwyg",
// "Validate by email" => "Validate by email",
// "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a>" => "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a>",
// "Validate user's email server" => "Validate user's email server",
// "Require validation by Admin" => "Require validation by Admin",
// "Validator emails (separated by comma) if different than the sender email" => "Validator emails (separated by comma) if different than the sender email",
// "Require passcode to register" => "Require passcode to register",
// "Passcode" => "Passcode",
// "Users must enter this code to register" => "Users must enter this code to register",
// "Use CAPTCHA to prevent automatic/robot registrations" => "Use CAPTCHA to prevent automatic/robot registrations",
// "Requires PHP GD library" => "Requires PHP GD library",
// "Include &quot;Generate Password&quot; option on registration form" => "Include &quot;Generate Password&quot; option on registration form",
// "Users can select a group to join at registration" => "Users can select a group to join at registration",
// "By default, new users automatically join the Registered group" => "By default, new users automatically join the Registered group",
// "Url a user is redirected after account validation" => "Url a user is redirected after account validation",
// "Use tracker to collect more user information" => "Use tracker to collect more user information",
// "Use the <strong><a href=\"tiki-admingroups.php\" title=\"Admin Groups\">Admin: Groups</a></strong> page to select which tracker and fields to display" => "Use the <strong><a href=\"tiki-admingroups.php\" title=\"Admin Groups\">Admin: Groups</a></strong> page to select which tracker and fields to display",
// "Use tracker to collect more group information" => "Use tracker to collect more group information",
// "Re-validate user by email after" => "Re-validate user by email after",
// "Use <strong>-1</strong> for never" => "Use <strong>-1</strong> for never",
// "unsuccessful login attempts" => "unsuccessful login attempts",
// "Create a new group for each user" => "Create a new group for each user",
// "The group will be named identical to the user's username" => "The group will be named identical to the user's username",
// "Disable browser's autocomplete feature for username and password fields" => "Disable browser's autocomplete feature for username and password fields",
// "Confirm that the Admin account has a valid email address or you will not be permitted to login" => "Confirm that the Admin account has a valid email address or you will not be permitted to login",
// "Use HTTPS login" => "Use HTTPS login",
// "Encourage secure (https) login" => "Encourage secure (https) login",
// "Consider we are always in HTTPS, but do not check" => "Consider we are always in HTTPS, but do not check",
// "Users can choose to stay in SSL mode after an HTTPS login" => "Users can choose to stay in SSL mode after an HTTPS login",
// "Users can switch between secured or standard mode at login" => "Users can switch between secured or standard mode at login",
// "User's choice" => "User's choice",
// "Cookie name" => "Cookie name",
// "Use email as username" => "Use email as username",
// "Minimum length" => "Minimum length",
// "Force lowercase" => "Force lowercase",
// "Username pattern" => "Username pattern",
// "Store passwords in plain text is activated. You should never set this unless you know what you are doing" => "Store passwords in plain text is activated. You should never set this unless you know what you are doing",
// "Users can change their password" => "Users can change their password",
// "Require characters and numerals" => "Require characters and numerals",
// "Password expires after" => "Password expires after",
// "You must change the Authentication Method to LDAP for these changes to take effect" => "You must change the Authentication Method to LDAP for these changes to take effect",
// "Create user if not in Tiki" => "Create user if not in Tiki",
// "Create user if not in LDAP" => "Create user if not in LDAP",
// "Use Tiki authentication for Admin login" => "Use Tiki authentication for Admin login",
// "Use Tiki authentication for users created in tiki" => "Use Tiki authentication for users created in tiki",
// "LDAP Bind settings" => "LDAP Bind settings",
// "Will override the Host and Port settings" => "Will override the Host and Port settings",
// "Write LDAP debug Information in Tiki Logs" => "Write LDAP debug Information in Tiki Logs",
// "Use SSL (ldaps)" => "Use SSL (ldaps)",
// "Use TLS" => "Use TLS",
// "LDAP Bind Type" => "LDAP Bind Type",
// "Default: userattr=username,UserDN,BaseDN" => "Default: userattr=username,UserDN,BaseDN",
// "userattr=username,BaseDN" => "userattr=username,BaseDN",
// "Active Directory (username@domain)" => "Active Directory (username@domain)",
// "Plain Username" => "Plain Username",
// "Search scope" => "Search scope",
// "Subtree" => "Subtree",
// "One level" => "One level",
// "Base object" => "Base object",
// "LDAP version" => "LDAP version",
// "Base DN" => "Base DN",
// "LDAP User" => "LDAP User",
// "User DN" => "User DN",
// "User attribute" => "User attribute",
// "User OC" => "User OC",
// "Realname attribute" => "Realname attribute",
// "Country attribute" => "Country attribute",
// "E-mail attribute" => "E-mail attribute",
// "Synchronize user attributes to tiki everytime the user logs in" => "Synchronize user attributes to tiki everytime the user logs in",
// "LDAP Group" => "LDAP Group",
// "Synchronize group attributes to tiki everytime the user logs in" => "Synchronize group attributes to tiki everytime the user logs in",
// "Note: this enables the usage of LDAP groups" => "Note: this enables the usage of LDAP groups",
// "Group DN" => "Group DN",
// "Group attribute" => "Group attribute",
// "Group description attribute" => "Group description attribute",
// "Group OC" => "Group OC",
// "LDAP Group Member - if group membership can be found in group attributes" => "LDAP Group Member - if group membership can be found in group attributes",
// "Member attribute" => "Member attribute",
// "Member is DN" => "Member is DN",
// "LDAP User Group - if group membership can be found in user attributes" => "LDAP User Group - if group membership can be found in user attributes",
// "Group attribute in group entry" => "Group attribute in group entry",
// "LDAP Admin" => "LDAP Admin",
// "Admin user" => "Admin user",
// "Admin password" => "Admin password",
// "You must change the Authentication Method to PAM for these changes to take effect" => "You must change the Authentication Method to PAM for these changes to take effect",
// "Shibboleth Authentication " => "Shibboleth Authentication ",
// "You must change the Authentication Method to Shibboleth for these changes to take effect" => "You must change the Authentication Method to Shibboleth for these changes to take effect",
// "Valid affiliations" => "Valid affiliations",
// "Separate multiple affiliations with commas" => "Separate multiple affiliations with commas",
// "Create with default group" => "Create with default group",
// "CAS" => "CAS",
// "You must change the Authentication Method to CAS for these changes to take effect" => "You must change the Authentication Method to CAS for these changes to take effect",
// "CAS Server" => "CAS Server",
// "Hostname" => "Hostname",
// "You must enable PHP CAS first" => "You must enable PHP CAS first",
// "Themes" => "Themes",
// "Theme options" => "Theme options",
// "The \"users can change theme\" feature will override the theme displayed" => "The \"users can change theme\" feature will override the theme displayed",
// "Theme not saved yet - click \"Apply\"" => "Theme not saved yet - click \"Apply\"",
// "Theme Screenshot" => "Theme Screenshot",
// "Each group can have its theme" => "Each group can have its theme",
// "Slideshow theme" => "Slideshow theme",
// "View Templates" => "View Templates",
// "Custom HTML &lt;head&gt; Content" => "Custom HTML &lt;head&gt; Content",
// "Custom Site Header" => "Custom Site Header",
// "The Custom Site Header will display for the Admin only. Select <strong>Publish</strong> to display the content for </em>all<em> users" => "The Custom Site Header will display for the Admin only. Select <strong>Publish</strong> to display the content for </em>all<em> users",
// "Site Logo and Title" => "Site Logo and Title",
// "Logo source (image path)" => "Logo source (image path)",
// "Logo background color" => "Logo background color",
// "Examples" => "Examples",
// "Logo background style" => "Logo background style",
// "Logo alignment" => "Logo alignment",
// "Logo title (on mouse over)" => "Logo title (on mouse over)",
// "Site title" => "Site title",
// "Search Bar" => "Search Bar",
// "Login Bar" => "Login Bar",
// "Top Bar" => "Top Bar",
// "Requires CSS Menus or PHPLayers" => "Requires CSS Menus or PHPLayers",
// "Menu ID" => "Menu ID",
// "Display current Tiki version" => "Display current Tiki version",
// "Custom Center Column Header" => "Custom Center Column Header",
// "only if module" => "only if module",
// "Prefix breadcrumbs with &quot;Location : &quot" => "Prefix breadcrumbs with &quot;Location : &quot",
// "Top of page" => "Top of page",
// "Top of center column" => "Top of center column",
// "Entire location" => "Entire location",
// "Custom Site Footer" => "Custom Site Footer",
// "Custom End of &lt;body&gt; Code" => "Custom End of &lt;body&gt; Code",
// "Bottom bar (RSS)" => "Bottom bar (RSS)",
// "Site Report Bar" => "Site Report Bar",
// "Webmaster Report" => "Webmaster Report",
// "Webmaster Email" => "Webmaster Email",
// "Leave <strong>blank</strong> to use the default sender email" => "Leave <strong>blank</strong> to use the default sender email",
// "Email this page" => "Email this page",
// "Shadow layer" => "Shadow layer",
// "Additional layers for shadows, rounded corners or other decorative styling" => "Additional layers for shadows, rounded corners or other decorative styling",
// "Main shadow start" => "Main shadow start",
// "Main shadow end" => "Main shadow end",
// "Header shadow start" => "Header shadow start",
// "Header shadow end" => "Header shadow end",
// "Middle shadow start" => "Middle shadow start",
// "Middle shadow end" => "Middle shadow end",
// "Center shadow start" => "Center shadow start",
// "Center shadow end" => "Center shadow end",
// "Footer shadow start" => "Footer shadow start",
// "Footer shadow end" => "Footer shadow end",
// "Module (box) shadow start" => "Module (box) shadow start",
// "Module (box) shadow end" => "Module (box) shadow end",
// "Pagination links" => "Pagination links",
// "Use relative (next / previous) pagination links" => "Use relative (next / previous) pagination links",
// "Max. number of links around the current item" => "Max. number of links around the current item",
// "Max. number of links after the first or before the last item" => "Max. number of links after the first or before the last item",
// "Display 'First' and 'Last' links" => "Display 'First' and 'Last' links",
// "Display fast move links (by 10 percent of the total number of pages) " => "Display fast move links (by 10 percent of the total number of pages) ",
// "Hide pagination when there is only one page" => "Hide pagination when there is only one page",
// "Use Icons" => "Use Icons",
// "UI Effects" => "UI Effects",
// "JQuery plugins and add-ons" => "JQuery plugins and add-ons",
// "Requires jquery feature" => "Requires jquery feature",
// "Tooltips" => "Tooltips",
// "JQuery Tooltips: Customisable help tips" => "JQuery Tooltips: Customisable help tips",
// "Autocomplete" => "Autocomplete",
// "JQuery Autocomplete" => "JQuery Autocomplete",
// "Superfish" => "Superfish",
// "JQuery Superfish (effects on CSS menus)" => "JQuery Superfish (effects on CSS menus)",
// "Reflection" => "Reflection",
// "JQuery Reflection (reflection effect on images)" => "JQuery Reflection (reflection effect on images)",
// "JQuery UI" => "JQuery UI",
// "JQuery UI: More JQuery functionality" => "JQuery UI: More JQuery functionality",
// "JQuery UI Theme" => "JQuery UI Theme",
// "JQuery UI Theme: Themes for look and feel of JQuery UI widgets" => "JQuery UI Theme: Themes for look and feel of JQuery UI widgets",
// "For future use" => "For future use",
// "Cycle" => "Cycle",
// "slideshow" => "slideshow",
// "JQuery Cycle (slideshow)" => "JQuery Cycle (slideshow)",
// "JQuery Sheet" => "JQuery Sheet",
// "JQuery Spreadsheet" => "JQuery Spreadsheet",
// "JQuery Sortable Tables" => "JQuery Sortable Tables",
// "Standard UI effects" => "Standard UI effects",
// "Effect for modules" => "Effect for modules",
// "Slide" => "Slide",
// "Blind (UI)" => "Blind (UI)",
// "Clip (UI)" => "Clip (UI)",
// "Drop (UI)" => "Drop (UI)",
// "Explode (UI)" => "Explode (UI)",
// "Fold (UI)" => "Fold (UI)",
// "Puff (UI)" => "Puff (UI)",
// "Slide (UI)" => "Slide (UI)",
// "Main JQuery effect" => "Main JQuery effect",
// "Speed" => "Speed",
// "Fast" => "Fast",
// "Slow" => "Slow",
// "Tab UI effects" => "Tab UI effects",
// "Effect for tabs" => "Effect for tabs",
// "JQuery effect for tabs" => "JQuery effect for tabs",
// "Correct PNG images alpha transparency in IE6 (experimental)" => "Correct PNG images alpha transparency in IE6 (experimental)",
// "CSS selectors to be fixed" => "CSS selectors to be fixed",
// "Separate multiple elements with a comma (&nbsp;,&nbsp;)" => "Separate multiple elements with a comma (&nbsp;,&nbsp;)",
// "HTMLDomElements to be fixed" => "HTMLDomElements to be fixed",
// "Favicon" => "Favicon",
// "Context Menus" => "Context Menus",
// "Currently used in File Galleries only" => "Currently used in File Galleries only",
// "Use context menus for actions (icons)" => "Use context menus for actions (icons)",
// "Use context menus for actions (text)" => "Use context menus for actions (text)",
// "Separators" => "Separators",
// "Meta tags" => "Meta tags",
// "Geo URL" => "Geo URL",
// "&quot;Modules&quot; are the boxes of content in the right &amp; left columns" => "&quot;Modules&quot; are the boxes of content in the right &amp; left columns",
// "Admin &gt; Modules" => "Admin &gt; Modules",
// "from the menu to create and edit modules" => "from the menu to create and edit modules",
// "Hint: If you lose your login module, use tiki-login_scr.php to be able to login" => "Hint: If you lose your login module, use tiki-login_scr.php to be able to login",
// "It works with the File Gallery, wiki pages (via a plugin), and a new multimedia tracker item" => "It works with the File Gallery, wiki pages (via a plugin), and a new multimedia tracker item",
// "Save Preferences" => "Save Preferences",
// "ProgressBarPlay Color" => "ProgressBarPlay Color",
// "ProgressBarLoad Color" => "ProgressBarLoad Color",
// "ProgressBarButton Color" => "ProgressBarButton Color",
// "ProgressBar Color" => "ProgressBar Color",
// "Volume On Color" => "Volume On Color",
// "Volume Off Color" => "Volume Off Color",
// "Volume Button Color" => "Volume Button Color",
// "Button Color" => "Button Color",
// "Button Pressed Color" => "Button Pressed Color",
// "Button Over Color" => "Button Over Color",
// "Button Info Color" => "Button Info Color",
// "Button Info Pressed Color" => "Button Info Pressed Color",
// "Button Info Over Color" => "Button Info Over Color",
// "Button Info Text Color" => "Button Info Text Color",
// "ID3 Tag Color" => "ID3 Tag Color",
// "Play Time Color" => "Play Time Color",
// "Total Time Color" => "Total Time Color",
// "Panel Display Color" => "Panel Display Color",
// "Alert Message Color" => "Alert Message Color",
// "Flash Length" => "Flash Length",
// "Flash Heigth" => "Flash Heigth",
// "Video Length" => "Video Length",
// "Video Heigth" => "Video Heigth",
// "Preload Delay" => "Preload Delay",
// "Max Play time" => "Max Play time",
// "URL Append" => "URL Append",
// "Message after limited time" => "Message after limited time",
// "ID of System File Galleries to upload multimedia files" => "ID of System File Galleries to upload multimedia files",
// "Please see the <a class='rbox-link' target='tikihelp' href='http://dev.tikiwiki.org/Performance'>Performance page</a> on Tiki's developer site" => "Please see the <a class='rbox-link' target='tikihelp' href='http://dev.tikiwiki.org/Performance'>Performance page</a> on Tiki's developer site",
// "Output compression is active" => "Output compression is active",
// "Compression is handled by" => "Compression is handled by",
// "Many search options impact performance. Please see <a href=\"tiki-admin.php?page=search\">Search admin panel</a>" => "Many search options impact performance. Please see <a href=\"tiki-admin.php?page=search\">Search admin panel</a>",
// "Loading profile" => "Loading profile",
// "Are you sure you want to apply the profile" => "Are you sure you want to apply the profile",
// "Sending" => "Sending",
// "TikiWiki Profiles" => "TikiWiki Profiles",
// "The following list of changes has been applied" => "The following list of changes has been applied",
// "Apply Profiles" => "Apply Profiles",
// "A Friendly Warning" => "A Friendly Warning",
// "Some of your Profiles Repositories are not connecting. This may prevent you from applying certain profiles" => "Some of your Profiles Repositories are not connecting. This may prevent you from applying certain profiles",
// "Option 1: Quick Filter" => "Option 1: Quick Filter",
// "Option 2: Manual Filter" => "Option 2: Manual Filter",
// "Filter the list of profiles" => "Filter the list of profiles",
// "Profile" => "Profile",
// "Repository" => "Repository",
// "applied" => "applied",
// "Profile repository" => "Profile repository",
// "Javascript must be turned <b>ON</b> in order to apply Profiles. Please enable your javascript and try again" => "Javascript must be turned <b>ON</b> in order to apply Profiles. Please enable your javascript and try again",
// "Repositories" => "Repositories",
// "Repository URLs" => "Repository URLs",
// "Enter multiple repository URLs, one per line" => "Enter multiple repository URLs, one per line",
// "Data Channels" => "Data Channels",
// "Data channels create a named pipe to run profiles from user space. One channel per line. Each line is comma delimited and contain <strong>channel name, domain, profile, allowed groups</strong>. " => "Data channels create a named pipe to run profiles from user space. One channel per line. Each line is comma delimited and contain <strong>channel name, domain, profile, allowed groups</strong>. ",
// "More information" => "More information",
// "Profile tester" => "Profile tester",
// "This will run the profile and make potentially unrecoverable changes in your database" => "This will run the profile and make potentially unrecoverable changes in your database",
// "Test Profile Name" => "Test Profile Name",
// "Use this page to configure the feeds generated by Tiki. To syndicate feeds from other sites, use the <strong>Admin</strong> &gt; <strong>External Feeds</strong> menu option, or" => "Use this page to configure the feeds generated by Tiki. To syndicate feeds from other sites, use the <strong>Admin</strong> &gt; <strong>External Feeds</strong> menu option, or",
// "External feeds" => "External feeds",
// "Feed for articles" => "Feed for articles",
// "Maximum number of items to display" => "Maximum number of items to display",
// "Show Author" => "Show Author",
// "Homepage URL" => "Homepage URL",
// "Feed for blogs" => "Feed for blogs",
// "Individual blogs" => "Individual blogs",
// "Feed for image galleries" => "Feed for image galleries",
// "Individual image galleries" => "Individual image galleries",
// "Feed for file galleries" => "Feed for file galleries",
// "Individual file galleries" => "Individual file galleries",
// "Feed for wiki" => "Feed for wiki",
// "Individual forums" => "Individual forums",
// "Individual trackers items" => "Individual trackers items",
// "Calendar events" => "Calendar events",
// "Feed for directory" => "Feed for directory",
// "Map files" => "Map files",
// "Feed for maps" => "Feed for maps",
// "Image Path" => "Image Path",
// "Caching time" => "Caching time",
// "Use <strong>0</strong> for no caching" => "Use <strong>0</strong> for no caching",
// "Enabling caching will override existing permissions - all content will be public. Enable this option <strong>only</strong> if your syndicated content should be public" => "Enabling caching will override existing permissions - all content will be public. Enable this option <strong>only</strong> if your syndicated content should be public",
// "can be seen on page" => "can be seen on page",
// "in Admin menu" => "in Admin menu",
// "Search type" => "Search type",
// "This search uses the MySQL Full-Text feature" => "This search uses the MySQL Full-Text feature",
// "The indexation is always updated" => "The indexation is always updated",
// "Tiki search" => "Tiki search",
// "Specify the Tiki search settings" => "Specify the Tiki search settings",
// "Use <strong>0</strong> for no refresh" => "Use <strong>0</strong> for no refresh",
// "The Tiki search indexes must be refreshed if you turn the Tiki search on" => "The Tiki search indexes must be refreshed if you turn the Tiki search on",
// "Refresh all search index now" => "Refresh all search index now",
// "Refresh trackers search index now" => "Refresh trackers search index now",
// "Refresh tracker search index now" => "Refresh tracker search index now",
// "Refresh files search index now" => "Refresh files search index now",
// "May impact performance" => "May impact performance",
// "Enabling these options will improve performance, but may show forbidden results" => "Enabling these options will improve performance, but may show forbidden results",
// "Search Results" => "Search Results",
// "Select the items to display on the search results page" => "Select the items to display on the search results page",
// "Select the information to display for each result" => "Select the information to display for each result",
// "Please see the <a class='rbox-link' target='tikihelp' href='http://dev.tikiwiki.org/Security'>Security page</a> on Tiki's developer site" => "Please see the <a class='rbox-link' target='tikihelp' href='http://dev.tikiwiki.org/Security'>Security page</a> on Tiki's developer site",
// "See <a href=\"tiki-admin_security.php\" title=\"Security\"><strong>Admin &gt; Security Admin</strong></a> for additional security settings" => "See <a href=\"tiki-admin_security.php\" title=\"Security\"><strong>Admin &gt; Security Admin</strong></a> for additional security settings",
// "CSRF Security" => "CSRF Security",
// "Use these options to protect against cross-site request forgeries (CSRF)" => "Use these options to protect against cross-site request forgeries (CSRF)",
// "SEFURL will not work unless Tiki specific directives are deployed to the .htaccess file. You will need to execute htaccess.sh or manually configure the .htaccess file" => "SEFURL will not work unless Tiki specific directives are deployed to the .htaccess file. You will need to execute htaccess.sh or manually configure the .htaccess file",
// "List of Url Parameters that should go in the path" => "List of Url Parameters that should go in the path",
// "Known Types" => "Known Types",
// "Token" => "Token",
// "Invert" => "Invert",
// "Show Usage" => "Show Usage",
// "Delete &amp; Unreference" => "Delete &amp; Unreference",
// "Invert Relation" => "Invert Relation",
// "Self" => "Self",
// "New Types" => "New Types",
// "Fix" => "Fix",
// "No occurences found" => "No occurences found",
// "Text area (that apply throughout many features)" => "Text area (that apply throughout many features)",
// "Wiki paragraph formatting" => "Wiki paragraph formatting",
// "...but still create line breaks within paragraphs" => "...but still create line breaks within paragraphs",
// "Parse wiki syntax in comments in all sections apart from Forums" => "Parse wiki syntax in comments in all sections apart from Forums",
// "&lt;return&gt; for rows" => "&lt;return&gt; for rows",
// "Open Hotwords in new window" => "Open Hotwords in new window",
// "Use Quote plugin rather than &ldquo;&gt;&rdquo; for quoting" => "Use Quote plugin rather than &ldquo;&gt;&rdquo; for quoting",
// "Plugin disabled" => "Plugin disabled",
// "Default size" => "Default size",
// "Comments " => "Comments ",
// "Forum reply" => "Forum reply",
// "External links and images" => "External links and images",
// "External links will be identified with" => "External links will be identified with",
// "Plugins" => "Plugins",
// "About plugins" => "About plugins",
// "Tiki plugins add functionality to wiki pages, articles and blogs etc. You can enable and disable them below" => "Tiki plugins add functionality to wiki pages, articles and blogs etc. You can enable and disable them below",
// "You can approve plugin use at <a href=\"tiki-plugins.php\">tiki-plugins.php</a>" => "You can approve plugin use at <a href=\"tiki-plugins.php\">tiki-plugins.php</a>",
// "The edit plugin icon is an easy way for users to edit the parameters of each plugin in wiki pages. It can be disabled for individual plugins below" => "The edit plugin icon is an easy way for users to edit the parameters of each plugin in wiki pages. It can be disabled for individual plugins below",
// "Edit plugin icons" => "Edit plugin icons",
// "Enable" => "Enable",
// "Disable edit plugin icon (make plugin inline)" => "Disable edit plugin icon (make plugin inline)",
// "Plugin Aliases" => "Plugin Aliases",
// "About plugin aliases" => "About plugin aliases",
// "Tiki plugin aliases allow you to define your own custom configurations of existing plugins.<br />Find out more here: {help url=\"Plugin+Alias\"}" => "Tiki plugin aliases allow you to define your own custom configurations of existing plugins.<br />Find out more here: {help url=\"Plugin+Alias\"}",
// "This page is designed to work with JQuery {icon _id=\"arrow_right\" href=\"tiki-admin.php?page=features\"}" => "This page is designed to work with JQuery {icon _id=\"arrow_right\" href=\"tiki-admin.php?page=features\"}",
// "Available Alias" => "Available Alias",
// "Enable Plugins" => "Enable Plugins",
// "General Information" => "General Information",
// "Plugin Name" => "Plugin Name",
// "Base Plugin" => "Base Plugin",
// "Body Label" => "Body Label",
// "Dependencies" => "Dependencies",
// "Validation" => "Validation",
// "Inline (No Plugin Edit UI)" => "Inline (No Plugin Edit UI)",
// "Simple Plugin Arguments" => "Simple Plugin Arguments",
// "Argument" => "Argument",
// "New Argument" => "New Argument",
// "Plugin Parameter Documentation" => "Plugin Parameter Documentation",
// "Safe" => "Safe",
// "Plugin Body" => "Plugin Body",
// "Ignore User Input" => "Ignore User Input",
// "Default Content" => "Default Content",
// "Encoding" => "Encoding",
// "Argument Source (if different)" => "Argument Source (if different)",
// "Default Value" => "Default Value",
// "Composed Plugin Arguments" => "Composed Plugin Arguments",
// "Pattern" => "Pattern",
// "Tracker attachment preferences" => "Tracker attachment preferences",
// "Tracker attachments" => "Tracker attachments",
// "Switch storage" => "Switch storage",
// "No records" => "No records",
// "WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely" => "WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely",
// "Do not use this feature as it is very buggy and unmaintained. It will be pulled out of the code base later on" => "Do not use this feature as it is very buggy and unmaintained. It will be pulled out of the code base later on",
// "Enter the URL of a web services returning either JSON or YAML. Parameters can be specified by enclosing a name between percentage signs. For example: %name%. %service% and %template% are reserved keywords and cannot be used" => "Enter the URL of a web services returning either JSON or YAML. Parameters can be specified by enclosing a name between percentage signs. For example: %name%. %service% and %template% are reserved keywords and cannot be used",
// "Lookup" => "Lookup",
// "Test Input" => "Test Input",
// "Response Information" => "Response Information",
// "OIntegrate Version" => "OIntegrate Version",
// "Not supported" => "Not supported",
// "Schema Version" => "Schema Version",
// "Schema Documentation" => "Schema Documentation",
// "Available" => "Available",
// "Not specified, default used" => "Not specified, default used",
// "Content Type" => "Content Type",
// "Not specified" => "Not specified",
// "Returned Data" => "Returned Data",
// "Proposed Templates" => "Proposed Templates",
// "Register this web service. It will be possible to register the templates afterwards. Service name must only contain letters" => "Register this web service. It will be possible to register the templates afterwards. Service name must only contain letters",
// "Register Service" => "Register Service",
// "Registered Templates" => "Registered Templates",
// "Engine" => "Engine",
// "Output" => "Output",
// "Register Template" => "Register Template",
// "Use the 'Quick Edit' module to easily create or edit wiki pages" => "Use the 'Quick Edit' module to easily create or edit wiki pages",
// "Select <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">Admin &gt; Modules</a> to add this (or other) modules" => "Select <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">Admin &gt; Modules</a> to add this (or other) modules",
// "Page display" => "Page display",
// "Page ID" => "Page ID",
// "Page version" => "Page version",
// "Allow override per page" => "Allow override per page",
// "Edit section" => "Edit section",
// "Edit section level" => "Edit section level",
// "Toggle display of section and plugin edit icons" => "Toggle display of section and plugin edit icons",
// "Allow minor edits" => "Allow minor edits",
// "Minor edits do not flag new content for translation and do not send watch notifications" => "Minor edits do not flag new content for translation and do not send watch notifications",
// "Only user groups granted the tiki_p_minor permission (and admins) will be able to save minor edits when this is enabled" => "Only user groups granted the tiki_p_minor permission (and admins) will be able to save minor edits when this is enabled",
// "Log bytes changes (+/-) in action logs" => "Log bytes changes (+/-) in action logs",
// "Display by default" => "Display by default",
// "Manage attachments" => "Manage attachments",
// "Tag for current wiki" => "Tag for current wiki",
// "Restore wiki to tag" => "Restore wiki to tag",
// "Restore" => "Restore",
// "Use File Galleries to store pictures " => "Use File Galleries to store pictures ",
// "WikiWords" => "WikiWords",
// "Maximum number of versions" => "Maximum number of versions",
// "Never delete versions younger than" => "Never delete versions younger than",
// "Display IP address" => "Display IP address",
// "Default diff style" => "Default diff style",
// "HTML diff" => "HTML diff",
// "Side-by-side diff by characters" => "Side-by-side diff by characters",
// "Inline diff" => "Inline diff",
// "Inline diff by characters" => "Inline diff by characters",
// "Full side-by-side diff by characters" => "Full side-by-side diff by characters",
// "Full inline diff" => "Full inline diff",
// "Full inline diff by characters" => "Full inline diff by characters",
// "History all instead of only page data, description, and change comment" => "History all instead of only page data, description, and change comment",
// "Forums are disabled" => "Forums are disabled",
// "Forum for discussion" => "Forum for discussion",
// "View source" => "View source",
// "Polls are disabled" => "Polls are disabled",
// "like pages" => "like pages",
// "Make structure from page" => "Make structure from page",
// "Categorize structure pages together" => "Categorize structure pages together",
// "Create webhelp from structure" => "Create webhelp from structure",
// "A page can occur multiple times in a structure" => "A page can occur multiple times in a structure",
// "Import pages" => "Import pages",
// "Slideshows" => "Slideshows",
// "User's page" => "User's page",
// "Users can lock pages" => "Users can lock pages",
// "Wiki watch" => "Wiki watch",
// "Watch minor edits" => "Watch minor edits",
// "Staging &amp; Approval" => "Staging &amp; Approval",
// "Use wiki page staging and approval" => "Use wiki page staging and approval",
// "Force bounce of editing of approved pages to staging" => "Force bounce of editing of approved pages to staging",
// "Delete staging pages at approval" => "Delete staging pages at approval",
// "If not in the group, edit is always redirected to the staging page edit" => "If not in the group, edit is always redirected to the staging page edit",
// "Unique page name prefix to indicate staging copy" => "Unique page name prefix to indicate staging copy",
// "Hide page name prefix" => "Hide page name prefix",
// "Staging" => "Staging",
// "Approved" => "Approved",
// "(mandatory for feature to work)" => "(mandatory for feature to work)",
// "Out-of-sync" => "Out-of-sync",
// "Categorize approved pages with categories of staging copy on approval" => "Categorize approved pages with categories of staging copy on approval",
// "Freetags are disabled" => "Freetags are disabled",
// "Replace freetags with that of staging pages, on approval" => "Replace freetags with that of staging pages, on approval",
// "Add new freetags of approved copy (into tags field) when editing staging pages" => "Add new freetags of approved copy (into tags field) when editing staging pages",
// "Page Listings" => "Page Listings",
// "Pages not in structure" => "Pages not in structure",
// "Configuration" => "Configuration",
// "Select which items to display when listing pages" => "Select which items to display when listing pages",
// "Name length" => "Name length",
// "Edit comments" => "Edit comments",
// "Edit Comments length" => "Edit Comments length",
// "Categories path" => "Categories path",
// "Camera settings" => "Camera settings",
// "Upload Type" => "Upload Type",
// "Data location" => "Data location",
// "HTTP Prefix" => "HTTP Prefix",
// "WebDav username" => "WebDav username",
// "WebDav password" => "WebDav password",
// "Wysiwyg means What You See Is What You Get, and is handled in Tikiwiki by <a href=\"http://fckeditor.net\">FCKeditor</a>" => "Wysiwyg means What You See Is What You Get, and is handled in Tikiwiki by <a href=\"http://fckeditor.net\">FCKeditor</a>",
// "Wysiwyg Editor Features" => "Wysiwyg Editor Features",
// "Development Notice" => "Development Notice",
// "Unless a significant amount of preferences are documented and use dynamic preferences before the 4.0 release, this search feature will become disabled by default" => "Unless a significant amount of preferences are documented and use dynamic preferences before the 4.0 release, this search feature will become disabled by default",
// "Database Version Problem" => "Database Version Problem",
// "Your database requires an update to match the current TikiWiki version. Please proceed to <a href=\"tiki-install.php\">the installer</a>. Using Tiki with an incorrect database version usually provoke errors" => "Your database requires an update to match the current TikiWiki version. Please proceed to <a href=\"tiki-install.php\">the installer</a>. Using Tiki with an incorrect database version usually provoke errors",
// "A new version of Tikiwiki, <b>{\$prefs.tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>" => "A new version of Tikiwiki, <b>{\$prefs.tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>",
// "disabled" => "disabled",
// "enabled" => "enabled",
// "preference" => "preference",
// "preference name" => "preference name",
// "TikiCache/System" => "TikiCache/System",
// "Edit Languages" => "Edit Languages",
// "External Pages Cache" => "External Pages Cache",
// "External Wikis" => "External Wikis",
// "Report" => "Report",
// "Please select some actions to view" => "Please select some actions to view",
// "kb" => "kb",
// "Graph Contributions" => "Graph Contributions",
// "Group Bar Plot" => "Group Bar Plot",
// "Accumulated Bar Plot" => "Accumulated Bar Plot",
// "Legend background color" => "Legend background color",
// "Save graphs to image gallery" => "Save graphs to image gallery",
// "See Statistics" => "See Statistics",
// "contribution" => "contribution",
// "contributor" => "contributor",
// "Edit Action" => "Edit Action",
// "Save Action" => "Save Action",
// "Volumes are equally distributed on each contributors/author" => "Volumes are equally distributed on each contributors/author",
// "connection time" => "connection time",
// "connection seconds" => "connection seconds",
// "mns" => "mns",
// "Volumn per category" => "Volumn per category",
// "Volumn per category and per user" => "Volumn per category and per user",
// "Number of actions per user" => "Number of actions per user",
// "Total number of users" => "Total number of users",
// "Number of actions per object" => "Number of actions per object",
// "Total number of objects" => "Total number of objects",
// "Number of actions per category" => "Number of actions per category",
// "Number of actions per category and per user" => "Number of actions per category and per user",
// "Volumn per the users'group and per contribution" => "Volumn per the users'group and per contribution",
// "Volumn per group and per contribution" => "Volumn per group and per contribution",
// "Volumn per user and per contribution" => "Volumn per user and per contribution",
// "Volumn per users'contribution and time" => "Volumn per users'contribution and time",
// "Volumn per contribution and time" => "Volumn per contribution and time",
// "recorded" => "recorded",
// "Wiki page actions except viewed will always be recorded but can be not reported" => "Wiki page actions except viewed will always be recorded but can be not reported",
// "Create Calendar" => "Create Calendar",
// "View Calendars" => "View Calendars",
// "View Calendar" => "View Calendar",
// "Add Event" => "Add Event",
// "Create / Edit Calendar" => "Create / Edit Calendar",
// "Create/Edit Calendars" => "Create/Edit Calendars",
// "Custom URL" => "Custom URL",
// "Start of day" => "Start of day",
// "End of day" => "End of day",
// "Standard Colors" => "Standard Colors",
// "Green" => "Green",
// "Blue" => "Blue",
// "Purple" => "Purple",
// "Orange" => "Orange",
// "Yellow" => "Yellow",
// "Let me select my own colors" => "Let me select my own colors",
// "Custom foreground color" => "Custom foreground color",
// "Ex" => "Ex",
// "Custom background color" => "Custom background color",
// "Default event status" => "Default event status",
// "Show in calendar view" => "Show in calendar view",
// "Group of users alerted when calendar event is modified" => "Group of users alerted when calendar event is modified",
// "Delete events older than" => "Delete events older than",
// "Browse the category system" => "Browse the category system",
// "Current Category ID" => "Current Category ID",
// "Remove from this Category" => "Remove from this Category",
// "Use the Administration page of each enabled feature to allow the use of content templates" => "Use the Administration page of each enabled feature to allow the use of content templates",
// "Use in" => "Use in",
// "No features are configured to use templates" => "No features are configured to use templates",
// "Visible in no sections" => "Visible in no sections",
// "Remove section" => "Remove section",
// "Admin Contributions" => "Admin Contributions",
// "Edit the contribution" => "Edit the contribution",
// "Contributions are mandatory in wiki pages" => "Contributions are mandatory in wiki pages",
// "Contributions are mandatory in forums" => "Contributions are mandatory in forums",
// "Contributions are mandatory in comments" => "Contributions are mandatory in comments",
// "Contributions are mandatory in blogs" => "Contributions are mandatory in blogs",
// "Contributions are displayed in the comment/post" => "Contributions are displayed in the comment/post",
// "Create a new contribution" => "Create a new contribution",
// "List of contributions" => "List of contributions",
// "Admin External Wikis" => "Admin External Wikis",
// "Duplicate forum" => "Duplicate forum",
// "View this forum" => "View this forum",
// "Import forums" => "Import forums",
// ".." => "..",
// "Create/Edit Forums" => "Create/Edit Forums",
// "Only allow replies to the first message (flat forum)" => "Only allow replies to the first message (flat forum)",
// "Set topics preferences" => "Set topics preferences",
// "Show topics preferences" => "Show topics preferences",
// "hide topics preferences" => "hide topics preferences",
// "Set thread preferences" => "Set thread preferences",
// "Show threads preferences" => "Show threads preferences",
// "hide threads preferences" => "hide threads preferences",
// "Default style for threads" => "Default style for threads",
// "Duplicate Forum" => "Duplicate Forum",
// "Duplicate perms" => "Duplicate perms",
// "Duplicate" => "Duplicate",
// "Admin HTML Page Dynamic Zones" => "Admin HTML Page Dynamic Zones",
// "Use {literal}{ed id=name}{/literal} or {literal}{ted id=name}{/literal} to insert dynamic zones" => "Use {literal}{ed id=name}{/literal} or {literal}{ted id=name}{/literal} to insert dynamic zones",
// "Refresh rate (if dynamic)" => "Refresh rate (if dynamic)",
// "Admin dynamic zones" => "Admin dynamic zones",
// "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature" => "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature",
// "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>" => "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>",
// "For wiki page, use ((PageName))" => "For wiki page, use ((PageName))",
// "Separate multiple sections with a comma ( , ) for an AND or a vertical bar ( | ) for an OR" => "Separate multiple sections with a comma ( , ) for an AND or a vertical bar ( | ) for an OR",
// "Separate multiple permissions with a comma ( , ) for an AND or a vertical bar ( | ) for an OR" => "Separate multiple permissions with a comma ( , ) for an AND or a vertical bar ( | ) for an OR",
// "Use Ctrl+Click to select multiple groups" => "Use Ctrl+Click to select multiple groups",
// "Selecting 2 groups means that the option will be seen if the user belongs to the 2 groups. If you want the 2 groups to see the option, create 2 options with one group each" => "Selecting 2 groups means that the option will be seen if the user belongs to the 2 groups. If you want the 2 groups to see the option, create 2 options with one group each",
// "If the url is ((PageName)), you do not need to put the groups, the option will be displayed only if the page can be displayed" => "If the url is ((PageName)), you do not need to put the groups, the option will be displayed only if the page can be displayed",
// "section level 0" => "section level 0",
// "section level 1" => "section level 1",
// "section level 2" => "section level 2",
// "section level 3" => "section level 3",
// "sorted section level 0" => "sorted section level 0",
// "switch with previous option" => "switch with previous option",
// "switch with next option" => "switch with next option",
// "Export CSV data" => "Export CSV data",
// "Import CSV data" => "Import CSV data",
// "To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'" => "To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'",
// "Create/Edit Menu" => "Create/Edit Menu",
// "Icons" => "Icons",
// "Folder Icon" => "Folder Icon",
// "Path and filename of closed folder icon" => "Path and filename of closed folder icon",
// "To use custom folder icons in menus, enter the path to the icon for the <strong>closed</strong> folder" => "To use custom folder icons in menus, enter the path to the icon for the <strong>closed</strong> folder",
// "In the same directory, include an icon for the opened folder" => "In the same directory, include an icon for the opened folder",
// "The \"opened folder\" icon name must be identical to the \"closed folder\" icon name, prefixed with the letter <strong>o</strong>" => "The \"opened folder\" icon name must be identical to the \"closed folder\" icon name, prefixed with the letter <strong>o</strong>",
// "Configure icons for menu entries" => "Configure icons for menu entries",
// "To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=look\">Look and Feel</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu" => "To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=look\">Look and Feel</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu",
// "To use <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes" => "To use <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes",
// "This will work well (or not!) depending on your theme. To learn more about <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>" => "This will work well (or not!) depending on your theme. To learn more about <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>",
// "To use a menu in a tiki format" => "To use a menu in a tiki format",
// "To use menu in a css/suckerfish format" => "To use menu in a css/suckerfish format",
// "To customize the menu's CSS id (#)" => "To customize the menu's CSS id (#)",
// "The following required parameters are missing" => "The following required parameters are missing",
// "Assign/Edit modules" => "Assign/Edit modules",
// "Move Up" => "Move Up",
// "Move Down" => "Move Down",
// "assign_name\">Module Name" => "assign_name\">Module Name",
// "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme', 'notitle', 'nopage'). Separator between params:'&amp;'. E.g. maxlen=15&amp;nonums=y" => "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme', 'notitle', 'nopage'). Separator between params:'&amp;'. E.g. maxlen=15&amp;nonums=y",
// "The" => "The",
// "Display Modules to All Groups" => "Display Modules to All Groups",
// "setting will override your selection of specific groups" => "setting will override your selection of specific groups",
// "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either" => "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either",
// "to make sure users will notice any newly assigned modules" => "to make sure users will notice any newly assigned modules",
// "Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site" => "Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site",
// "Use Wiki Structure" => "Use Wiki Structure",
// "Edit Newsletter" => "Edit Newsletter",
// "You can add several email addresses by separating them with commas" => "You can add several email addresses by separating them with commas",
// "Batch e-mail subscribe" => "Batch e-mail subscribe",
// "txt file, one e-mail per line" => "txt file, one e-mail per line",
// "Export Subscriber Emails" => "Export Subscriber Emails",
// "Add subscribers of another newsletter" => "Add subscribers of another newsletter",
// "Create Newsletter" => "Create Newsletter",
// "Drafts" => "Drafts",
// "Allow customized text message to be sent with the html version" => "Allow customized text message to be sent with the html version",
// "Mail notifications" => "Mail notifications",
// "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a> before creating email notifications" => "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a> before creating email notifications",
// "Alert" => "Alert",
// "Preload Admin Account" => "Preload Admin Account",
// "User / Group" => "User / Group",
// "Multiple" => "Multiple",
// "Trackers Outbound Emails" => "Trackers Outbound Emails",
// "Forums Outbound Emails" => "Forums Outbound Emails",
// "Admin page lists" => "Admin page lists",
// "Current lists" => "Current lists",
// "Edit this list" => "Edit this list",
// "Remove this list" => "Remove this list",
// "Edit list" => "Edit list",
// "Add list" => "Add list",
// "Seed with pages from a category" => "Seed with pages from a category",
// "Add page" => "Add page",
// "Page priority" => "Page priority",
// "Page score" => "Page score",
// "Edit {\$list.name|escape}" => "Edit {\$list.name|escape}",
// "Add poll option" => "Add poll option",
// "Edit poll option" => "Edit poll option",
// "Create poll" => "Create poll",
// "Edit poll" => "Edit poll",
// "Toggle Quick Options" => "Toggle Quick Options",
// "Add Option" => "Add Option",
// "Leave box empty for deleting an option" => "Leave box empty for deleting an option",
// "Votes older than these days are no more considered" => "Votes older than these days are no more considered",
// "0 for no limit" => "0 for no limit",
// "Add poll to pages" => "Add poll to pages",
// "This menu shows only Polls with 'status': \"template\"" => "This menu shows only Polls with 'status': \"template\"",
// "Use Ctrl+Click to select multiple pages" => "Use Ctrl+Click to select multiple pages",
// "Lock the pages" => "Lock the pages",
// "Admin External Feeds" => "Admin External Feeds",
// "Tips" => "Tips",
// "This page is to configure settings of external feeds read/imported by Tiki. To generate/export feeds, look for \"Feeds\" on the admin panel, or" => "This page is to configure settings of external feeds read/imported by Tiki. To generate/export feeds, look for \"Feeds\" on the admin panel, or",
// "To use feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the feed" => "To use feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the feed",
// "Edit this feed" => "Edit this feed",
// "Create new external feed" => "Create new external feed",
// "Show Date" => "Show Date",
// "View feed" => "View feed",
// "PHP functions" => "PHP functions",
// "Function" => "Function",
// "To disallow a function, add a disable_functions=exec,passthru for instance in your php.ini" => "To disallow a function, add a disable_functions=exec,passthru for instance in your php.ini",
// "TikiWiki settings" => "TikiWiki settings",
// "About WikiPlugins and security: Make sure to only grant the \"tiki_p_plugin_approve\" permission to trusted editors" => "About WikiPlugins and security: Make sure to only grant the \"tiki_p_plugin_approve\" permission to trusted editors",
// "You can deactivate risky plugins at (<a href=\"tiki-admin.php?page=textarea\">tiki-admin.php?page=textarea</a>)" => "You can deactivate risky plugins at (<a href=\"tiki-admin.php?page=textarea\">tiki-admin.php?page=textarea</a>)",
// "Security checks" => "Security checks",
// "Check file permissions" => "Check file permissions",
// "This check tries to find files with problematic file permissions. Some file permissions that are shown here as problematic may be unproblematic or unavoidable in some environments" => "This check tries to find files with problematic file permissions. Some file permissions that are shown here as problematic may be unproblematic or unavoidable in some environments",
// "See end of table for detailed explanations" => "See end of table for detailed explanations",
// "owner" => "owner",
// "special" => "special",
// "other" => "other",
// "uid" => "uid",
// "gid" => "gid",
// "suid" => "suid",
// "sgid" => "sgid",
// "r" => "r",
// "w" => "w",
// "Set User ID (suid) files" => "Set User ID (suid) files",
// "World writable files or directories" => "World writable files or directories",
// "Files or directories the Webserver can write to" => "Files or directories the Webserver can write to",
// "Strange Inodes (not file, not link, not directory)" => "Strange Inodes (not file, not link, not directory)",
// "Executable files" => "Executable files",
// "What to do with these check results" => "What to do with these check results",
// "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\"" => "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\"",
// "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content" => "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content",
// "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information" => "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information",
// "Inodes that are not files or directories are not part of tiki. Review these Inodes" => "Inodes that are not files or directories are not part of tiki. Review these Inodes",
// "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod" => "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod",
// "XML Zip Import" => "XML Zip Import",
// "The structure" => "The structure",
// "has just been created" => "has just been created",
// "You will remove structure" => "You will remove structure",
// "Note that the following pages are also part of another structure. Make sure that access permissions (if any) do not conflict" => "Note that the following pages are also part of another structure. Make sure that access permissions (if any) do not conflict",
// "The following pages have automatically been categorized with the same categories as the structure" => "The following pages have automatically been categorized with the same categories as the structure",
// "The following pages have categories but the structure has none. You may wish to uncategorize them to be consistent" => "The following pages have categories but the structure has none. You may wish to uncategorize them to be consistent",
// "The following pages are in categories that the structure is not in. You may wish to recategorize them in order to be consistent" => "The following pages are in categories that the structure is not in. You may wish to recategorize them in order to be consistent",
// "Edit structure" => "Edit structure",
// "View structure" => "View structure",
// "PDF" => "PDF",
// "XML Zip" => "XML Zip",
// "Add a New Question" => "Add a New Question",
// "This survey stats" => "This survey stats",
// "Edit Survey Question" => "Edit Survey Question",
// "Add a New Question to this survey" => "Add a New Question to this survey",
// "Multiple choices of thumbnails from a file gallery" => "Multiple choices of thumbnails from a file gallery",
// "Wiki textarea" => "Wiki textarea",
// "Answer is mandatory" => "Answer is mandatory",
// "Number of required answers (for multiple choices)" => "Number of required answers (for multiple choices)",
// "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots" => "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots",
// "For a rate, you can give the maximum value" => "For a rate, you can give the maximum value",
// "For the 'multiple choices of thumbnail from a file gallery' type, options are: Gallery ID. Example: 4" => "For the 'multiple choices of thumbnail from a file gallery' type, options are: Gallery ID. Example: 4",
// "Create/Edit Surveys" => "Create/Edit Surveys",
// "Tiki Cache/System Admin" => "Tiki Cache/System Admin",
// "Exterminator of cached content" => "Exterminator of cached content",
// "Directory to exterminate" => "Directory to exterminate",
// "Clear all Tiki caches" => "Clear all Tiki caches",
// "All user prefs sessions" => "All user prefs sessions",
// "Directories to save" => "Directories to save",
// "Full Path to the Zip File" => "Full Path to the Zip File",
// "Generate a zip of those directories" => "Generate a zip of those directories",
// "A zip has been written to {\$zipPath}" => "A zip has been written to {\$zipPath}",
// "Directory is not writeable" => "Directory is not writeable",
// "View mode" => "View mode",
// "Wiki and WYSIWYG" => "Wiki and WYSIWYG",
// "Wiki only" => "Wiki only",
// "WYSIWYG only" => "WYSIWYG only",
// "Load" => "Load",
// "Reset to Global" => "Reset to Global",
// "Reset to defaults" => "Reset to defaults",
// "Auto Reloading" => "Auto Reloading",
// "Row" => "Row",
// "Formatting Tools" => "Formatting Tools",
// "Plugin Tools" => "Plugin Tools",
// "Edit tool" => "Edit tool",
// "Wysiwyg Token" => "Wysiwyg Token",
// "Plugin name" => "Plugin name",
// "Custom Tools" => "Custom Tools",
// "Add a new custom tool" => "Add a new custom tool",
// "To configure the toolbars on the various text editing areas select the section, and optionally check the comments checkbox, you want to edit and drag the icons from the left hand box to the toolbars on the right.<br />\nDrag icons back from the toolbar rows onto the full list to remove them.<br />\nIcons with <strong>bold</strong> labels are for wiki text areas, those that are <em>italic</em> are for WYSIWYG mode, and those that are <strong><em>bold and italic</em></strong> are for both.<br />\nTo save the current set use the dropdown (and optionally check the comments checkbox) at the bottom of the page to set where you want these toolbars to appear, and click Save" => "To configure the toolbars on the various text editing areas select the section, and optionally check the comments checkbox, you want to edit and drag the icons from the left hand box to the toolbars on the right.<br />\nDrag icons back from the toolbar rows onto the full list to remove them.<br />\nIcons with <strong>bold</strong> labels are for wiki text areas, those that are <em>italic</em> are for WYSIWYG mode, and those that are <strong><em>bold and italic</em></strong> are for both.<br />\nTo save the current set use the dropdown (and optionally check the comments checkbox) at the bottom of the page to set where you want these toolbars to appear, and click Save",
// "Inactive - Click to Activate" => "Inactive - Click to Activate",
// "Active - Click to Deactivate" => "Active - Click to Deactivate",
// "Field is public? (viewed in trackerlist plugin)" => "Field is public? (viewed in trackerlist plugin)",
// "New tracker field" => "New tracker field",
// "Select list items that will be displayed" => "Select list items that will be displayed",
// "Multilingual content" => "Multilingual content",
// "Field is hidden" => "Field is hidden",
// "not hidden" => "not hidden",
// "visible to admin only" => "visible to admin only",
// "editable by admin only" => "editable by admin only",
// "visible by creator &amp; admin only" => "visible by creator &amp; admin only",
// "The option creator needs a field of type user selector and option 1" => "The option creator needs a field of type user selector and option 1",
// "Visible by" => "Visible by",
// "Editable by" => "Editable by",
// "Description text is wiki-parsed" => "Description text is wiki-parsed",
// "Error message" => "Error message",
// "Export fieldId also" => "Export fieldId also",
// "Check the box to re-import in this tracker and change the fields" => "Check the box to re-import in this tracker and change the fields",
// "Uncheck the box to import in another database" => "Uncheck the box to import in another database",
// "Edit This Tracker's Fields" => "Edit This Tracker's Fields",
// "Create Tracker" => "Create Tracker",
// "Create/Edit Tracker" => "Create/Edit Tracker",
// "Auto create corresponding categories" => "Auto create corresponding categories",
// "Create a group for each item" => "Create a group for each item",
// "Groups will include" => "Groups will include",
// "Creator is assigned to the group" => "Creator is assigned to the group",
// "and it becomes his default group" => "and it becomes his default group",
// "and it becomes the new item group creator" => "and it becomes the new item group creator",
// "But copy the default group in this fiedlId before updating the group" => "But copy the default group in this fiedlId before updating the group",
// "tracker name must be unique, field names must be unique for a tracker and they must be valid in SQL" => "tracker name must be unique, field names must be unique for a tracker and they must be valid in SQL",
// "The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender" => "The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender",
// "User can take ownership of item created by anonymous" => "User can take ownership of item created by anonymous",
// "Only one item per user or IP" => "Only one item per user or IP",
// "The tracker needs a user or IP field with the option 1" => "The tracker needs a user or IP field with the option 1",
// "Member of the creator group can modify items" => "Member of the creator group can modify items",
// "Format if not the default short one" => "Format if not the default short one",
// "Show creation date when viewing tracker item" => "Show creation date when viewing tracker item",
// "Identify creation user in tracker item" => "Identify creation user in tracker item",
// "Show lastModif date when viewing tracker item" => "Show lastModif date when viewing tracker item",
// "Identify lastModif user in tracker item" => "Identify lastModif user in tracker item",
// "LastModif" => "LastModif",
// "ItemId" => "ItemId",
// "and display last comment user/date" => "and display last comment user/date",
// "Items can be created only during a certain time" => "Items can be created only during a certain time",
// "Do not show empty fields in item view" => "Do not show empty fields in item view",
// "Show these fields (ID comma separated) in a popup on item link when listing tracker items" => "Show these fields (ID comma separated) in a popup on item link when listing tracker items",
// "Group of users alerted when tracker is modified" => "Group of users alerted when tracker is modified",
// "Date Format" => "Date Format",
// "timestamp" => "timestamp",
// "Charset encoding" => "Charset encoding",
// "UTF-8" => "UTF-8",
// "ISO-8859-1" => "ISO-8859-1",
// "Duplicate Tracker" => "Duplicate Tracker",
// "Manage permissions" => "Manage permissions",
// "Inherits Permissions from" => "Inherits Permissions from",
// "User Choice" => "User Choice",
// "Inherit permissions directly from following groups" => "Inherit permissions directly from following groups",
// "Selected groups only. Use Ctrl+Click to select more than one" => "Selected groups only. Use Ctrl+Click to select more than one",
// "Also inheriting permissions from the following groups (indirect inheritance through the groups selected above)" => "Also inheriting permissions from the following groups (indirect inheritance through the groups selected above)",
// "For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>)" => "For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>)",
// "Default category assigned to uncategorized objects edited by a user with this default group" => "Default category assigned to uncategorized objects edited by a user with this default group",
// "Group Theme" => "Group Theme",
// "Use site default" => "Use site default",
// "Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with :)" => "Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with :)",
// "User can assign to the group himself" => "User can assign to the group himself",
// "Users are automatically unassigned from the group after" => "Users are automatically unassigned from the group after",
// "0 or empty for never" => "0 or empty for never",
// "Assign group <em>management</em> permissions" => "Assign group <em>management</em> permissions",
// "Create Item" => "Create Item",
// "Choose a field .." => "Choose a field ..",
// "Add to group" => "Add to group",
// "Download CSV export" => "Download CSV export",
// "Assign users to group" => "Assign users to group",
// "Each user in the file must already exist" => "Each user in the file must already exist",
// "To create users or/and assign them to groups, got to <a href=\"tiki-adminusers.php\">admin->users</a>" => "To create users or/and assign them to groups, got to <a href=\"tiki-adminusers.php\">admin->users</a>",
// "Since this tiki site is in slave mode and import groups, the master groups will be automatically reimported at each login" => "Since this tiki site is in slave mode and import groups, the master groups will be automatically reimported at each login",
// "Since this tiki site is in slave mode and import preferences, the master user preferences will be automatically reimported at each login" => "Since this tiki site is in slave mode and import preferences, the master user preferences will be automatically reimported at each login",
// "Feedback" => "Feedback",
// "Updated users" => "Updated users",
// "More Criteria" => "More Criteria",
// "Group (direct)" => "Group (direct)",
// "ago" => "ago",
// "Need to validate email" => "Need to validate email",
// "Assign to group" => "Assign to group",
// "Edit Group" => "Edit Group",
// "Validate user" => "Validate user",
// "Confirm user email" => "Confirm user email",
// "Invalid email" => "Invalid email",
// "Remove Users and their Userpages" => "Remove Users and their Userpages",
// "Send a wiki page by Email" => "Send a wiki page by Email",
// "Template wiki page" => "Template wiki page",
// "Assign user to Groups" => "Assign user to Groups",
// "Use the email as username" => "Use the email as username",
// "Lowercase only" => "Lowercase only",
// "Warning: changing the username could require the user to change his password (for user registered with an old tikiwiki&lt;=1.8)" => "Warning: changing the username could require the user to change his password (for user registered with an old tikiwiki&lt;=1.8)",
// "Warning: it will mess with slave intertiki sites that use this one as master" => "Warning: it will mess with slave intertiki sites that use this one as master",
// "No password is required" => "No password is required",
// "Tikiwiki is configured to delegate the password managment to LDAP" => "Tikiwiki is configured to delegate the password managment to LDAP",
// "Repeat Password" => "Repeat Password",
// "User must change password at first login" => "User must change password at first login",
// "Send an email to the user in order to allow him to validate his account" => "Send an email to the user in order to allow him to validate his account",
// "Last Login" => "Last Login",
// "You do not have permission to edit this user" => "You do not have permission to edit this user",
// "CSV file layout" => "CSV file layout",
// "login,password,email<br />user1,pass1,email1<br />user2,pass2,email2" => "login,password,email<br />user1,pass1,email1<br />user2,pass2,email2",
// "Overwrite but keep the previous login if the login exists in another case" => "Overwrite but keep the previous login if the login exists in another case",
// "Don't overwrite" => "Don't overwrite",
// "Overwrite groups" => "Overwrite groups",
// "You can export users of a group in <a href=\"tiki-admingroups.php\">admin->groups->a_group</a>" => "You can export users of a group in <a href=\"tiki-admingroups.php\">admin->groups->a_group</a>",
// "Loading.." => "Loading..",
// "More languages are available. To view them, update languages you can read from <a href=\"tiki-user_preferences.php\">user preferences</a> or your browser's preferences" => "More languages are available. To view them, update languages you can read from <a href=\"tiki-user_preferences.php\">user preferences</a> or your browser's preferences",
// "Approve page changes in staging" => "Approve page changes in staging",
// "Page has been approved" => "Page has been approved",
// "New attachments" => "New attachments",
// "Old attachments" => "Old attachments",
// "Changes from the following versions under staging have been merged into the approved version" => "Changes from the following versions under staging have been merged into the approved version",
// "Show Help" => "Show Help",
// "Article type" => "Article type",
// "Actions on this article type" => "Actions on this article type",
// "This page will be replaced with the Object Permissions page although currently it does not support the \"advanced\" mode of this page.<br />Please try it out and feedback with any improvements or problems" => "This page will be replaced with the Object Permissions page although currently it does not support the \"advanced\" mode of this page.<br />Please try it out and feedback with any improvements or problems",
// "Click this button to try it now" => "Click this button to try it now",
// "Global object permissions" => "Global object permissions",
// "inherited from" => "inherited from",
// "inherited" => "inherited",
// "Level configuration" => "Level configuration",
// "Assign User {\$assign_user|escape} to Groups" => "Assign User {\$assign_user|escape} to Groups",
// "Assign User to Group" => "Assign User to Group",
// "Convert the last sub directory to a sub gallery" => "Convert the last sub directory to a sub gallery",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created",
// "Use the last sub directory name as description" => "Use the last sub directory name as description",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created",
// "Browse File Gallery" => "Browse File Gallery",
// "Please do not use this feature to upload data into the database" => "Please do not use this feature to upload data into the database",
// "Available Files" => "Available Files",
// "Select a File Gallery" => "Select a File Gallery",
// "Process files" => "Process files",
// "If you want to use images please save the post first and you will be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor or use the image URL to include images using the WYSIWYG editor. " => "If you want to use images please save the post first and you will be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor or use the image URL to include images using the WYSIWYG editor. ",
// "Report to Webmaster" => "Report to Webmaster",
// "The TikiWiki Community" => "The TikiWiki Community",
// "TikiWiki CMS/Groupware" => "TikiWiki CMS/Groupware",
// "database queries used in " => "database queries used in ",
// "Last update from SVN" => "Last update from SVN",
// "Watch Only This Category" => "Watch Only This Category",
// "Watch This Category and Their Descendants" => "Watch This Category and Their Descendants",
// "Stop Watching Only This Category" => "Stop Watching Only This Category",
// "Stop Watching This Category and Their Descendants" => "Stop Watching This Category and Their Descendants",
// "in the current category - and its subcategories: " => "in the current category - and its subcategories: ",
// "Browse related tags" => "Browse related tags",
// "Network of Tags related to" => "Network of Tags related to",
// "With all selected tags" => "With all selected tags",
// "With one selected tag" => "With one selected tag",
// "With last selected tag" => "With last selected tag",
// "More Popular Tags" => "More Popular Tags",
// "Alphabetically" => "Alphabetically",
// "By Size" => "By Size",
// "Cloud" => "Cloud",
// "\$feature_label" => "\$feature_label",
// "results found" => "results found",
// "All Images" => "All Images",
// "You can view this gallery's configured image (first, random, etc.) in your browser using" => "You can view this gallery's configured image (first, random, etc.) in your browser using",
// "You can include the gallery's image in an HTML page using one of these lines" => "You can include the gallery's image in an HTML page using one of these lines",
// "Cyclic" => "Cyclic",
// "Include the image in a tiki page using the following syntax" => "Include the image in a tiki page using the following syntax",
// "To include the image in an HTML page" => "To include the image in an HTML page",
// "To link to this page from another tiki page" => "To link to this page from another tiki page",
// "Browsing Video" => "Browsing Video",
// "Edit Video" => "Edit Video",
// "First Video" => "First Video",
// "Prev Video" => "Prev Video",
// "Next Video" => "Next Video",
// "Last Video" => "Last Video",
// "Video Title" => "Video Title",
// "Move video" => "Move video",
// "You can view this video in your browser using" => "You can view this video in your browser using",
// "You can include the video in a tiki page using one of these lines" => "You can include the video in a tiki page using one of these lines",
// "Admin Calendar" => "Admin Calendar",
// "Export Calendars" => "Export Calendars",
// "Click to export calendars" => "Click to export calendars",
// "Visible Calendars" => "Visible Calendars",
// "Click to select visible calendars" => "Click to select visible calendars",
// "Export calendars" => "Export calendars",
// "advanced parameters" => "advanced parameters",
// "Edit event" => "Edit event",
// "Delete event" => "Delete event",
// "View event" => "View event",
// "All-Day" => "All-Day",
// "Website" => "Website",
// "View this Week" => "View this Week",
// "View this Day" => "View this Day",
// "o" => "o",
// "Calendar Item" => "Calendar Item",
// "Edit Calendar" => "Edit Calendar",
// "New event" => "New event",
// "Recurrence" => "Recurrence",
// "This event depends on a recurrence rule" => "This event depends on a recurrence rule",
// "This event is not recurrent" => "This event is not recurrent",
// "On a weekly basis" => "On a weekly basis",
// "Each" => "Each",
// "of the week" => "of the week",
// "On a monthly basis" => "On a monthly basis",
// "of the month" => "of the month",
// "On a yearly basis" => "On a yearly basis",
// "There's no such date as" => "There's no such date as",
// "Starting on" => "Starting on",
// "ending by" => "ending by",
// "ending after" => "ending after",
// "events" => "events",
// "Start period" => "Start period",
// "End after" => "End after",
// "occurrences" => "occurrences",
// "End before" => "End before",
// "Event is repeated" => "Event is repeated",
// "every" => "every",
// "of every month" => "of every month",
// "on each" => "on each",
// "Date and time of end" => "Date and time of end",
// "Events cannot end before they start" => "Events cannot end before they start",
// "No description" => "No description",
// "or new" => "or new",
// "Choose users to alert" => "Choose users to alert",
// "chair" => "chair",
// "default role" => "default role",
// "required participant" => "required participant",
// "optional participant" => "optional participant",
// "non participant" => "non participant",
// "Give participant list separated by commas. Roles have to be given in a prefix separated by a column like in" => "Give participant list separated by commas. Roles have to be given in a prefix separated by a column like in",
// "role:login_or_email,login_or_email" => "role:login_or_email,login_or_email",
// "If no role is provided, default role will be \"Chair participant\"" => "If no role is provided, default role will be \"Chair participant\"",
// "Update this event only" => "Update this event only",
// "Update every unchanged events of this recurrence rule" => "Update every unchanged events of this recurrence rule",
// "Update every events of this recurrence rule" => "Update every events of this recurrence rule",
// "Delete Recurrent events" => "Delete Recurrent events",
// "D" => "D",
// "W" => "W",
// "M" => "M",
// "%d/%m" => "%d/%m",
// "Advanced parameters for iCal export" => "Advanced parameters for iCal export",
// "Calendars to be exported" => "Calendars to be exported",
// "Your account has been validated" => "Your account has been validated",
// "You have to choose a password to use this account" => "You have to choose a password to use this account",
// "Send another message" => "Send another message",
// "Group View" => "Group View",
// "Publish this contact to groups" => "Publish this contact to groups",
// "<a href=\"tiki-directory_admin_categories.php\">Add a directory category now</a>" => "<a href=\"tiki-directory_admin_categories.php\">Add a directory category now</a>",
// "The following site was added, but may require validation by the admin before appearing on the lists" => "The following site was added, but may require validation by the admin before appearing on the lists",
// "Edit a site" => "Edit a site",
// "Add a site" => "Add a site",
// "Directory Categories" => "Directory Categories",
// "Use Ctrl+Click to select multiple directory categories" => "Use Ctrl+Click to select multiple directory categories",
// "Parent directory category" => "Parent directory category",
// "Most visited directory sub-categories" => "Most visited directory sub-categories",
// "Directory Category description" => "Directory Category description",
// "Random directory sub-categories" => "Random directory sub-categories",
// "Allow sites in this directory category" => "Allow sites in this directory category",
// "Show number of sites in this directory category" => "Show number of sites in this directory category",
// "Directory Subcategories" => "Directory Subcategories",
// "Admin related directory categories" => "Admin related directory categories",
// "Add a related directory category" => "Add a related directory category",
// "Directory Category" => "Directory Category",
// "Related directory categories" => "Related directory categories",
// "Perform action with selected" => "Perform action with selected",
// "Add a Directory Category" => "Add a Directory Category",
// "in current directory category" => "in current directory category",
// "Total directory categories" => "Total directory categories",
// "Emails to be notified (separated with commas)" => "Emails to be notified (separated with commas)",
// "-1 for unlimited" => "-1 for unlimited",
// "Max impressions for a user" => "Max impressions for a user",
// "Max clicks" => "Max clicks",
// "Or, create a new zone" => "Or, create a new zone",
// "Use Flash" => "Use Flash",
// "Movie Size" => "Movie Size",
// "FlashPlugin min version" => "FlashPlugin min version",
// "ex" => "ex",
// "A category is mandatory" => "A category is mandatory",
// "The file will be saved in" => "The file will be saved in",
// "Wiki Syntax" => "Wiki Syntax",
// "For more information, please see" => "For more information, please see",
// "Wiki Page Editor" => "Wiki Page Editor",
// "More help on editing wiki pages" => "More help on editing wiki pages",
// "The syntax system used for creating pages in TikiWiki" => "The syntax system used for creating pages in TikiWiki",
// "Also available here" => "Also available here",
// "Plugins help" => "Plugins help",
// "Bold text" => "Bold text",
// "Italic text" => "Italic text",
// "single quotes" => "single quotes",
// "Underlined text" => "Underlined text",
// "Will display using the indicated HTML color or color name. Color name can contain two colors separated by a comma. In this case, the first color would be the foreground and the second one the background" => "Will display using the indicated HTML color or color name. Color name can contain two colors separated by a comma. In this case, the first color would be the foreground and the second one the background",
// "Deleted text" => "Deleted text",
// "2 dashes" => "2 dashes",
// "Autonumbered Headings" => "Autonumbered Headings",
// "{literal}{toc}{/literal}, {literal}{maketoc}{/literal} prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)" => "{literal}{toc}{/literal}, {literal}{maketoc}{/literal} prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)",
// "Horizontal rule" => "Horizontal rule",
// "Text box" => "Text box",
// "Centered text" => "Centered text",
// "use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox)" => "use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox)",
// "page|#anchor" => "page|#anchor",
// "page|#anchor|desc" => "page|#anchor|desc",
// "for wiki heading/anchor references" => "for wiki heading/anchor references",
// "Indentation" => "Indentation",
// "Creates an indentation for each plus (useful in list to continue at the same level)" => "Creates an indentation for each plus (useful in list to continue at the same level)",
// "row" => "row",
// "col" => "col",
// "Monospace font" => "Monospace font",
// "Code sample" => "Code sample",
// "to separate pages" => "to separate pages",
// "~pp~ data ~/pp~ Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  ~pre~ data ~/pre~ also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text" => "~pp~ data ~/pp~ Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  ~pre~ data ~/pre~ also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text",
// "~tc~ Tiki Comment ~/tc~ makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  ~hc~ HTML Comment ~/hc~ makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar" => "~tc~ Tiki Comment ~/tc~ makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  ~hc~ HTML Comment ~/hc~ makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar",
// "Insert resp. right-to-left and left-to-right text direction DIV (up to end of text) and markers for langages as arabic or hebrew" => "Insert resp. right-to-left and left-to-right text direction DIV (up to end of text) and markers for langages as arabic or hebrew",
// "Special characters" => "Special characters",
// "hard space" => "hard space",
// "numeric between ~ for html numeric characters entity" => "numeric between ~ for html numeric characters entity",
// "Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines" => "Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines",
// "Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line" => "Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line",
// "Note that plugin arguments can be enclosed with double quotes (&quot;); this allows them to contain , or = or &gt" => "Note that plugin arguments can be enclosed with double quotes (&quot;); this allows them to contain , or = or &gt",
// "More help here" => "More help here",
// "Wiki plugins extend the function of wiki syntax with more specialized commands" => "Wiki plugins extend the function of wiki syntax with more specialized commands",
// "Upload from disk to change the image" => "Upload from disk to change the image",
// "Save and Go Next" => "Save and Go Next",
// "Im-Export Languages" => "Im-Export Languages",
// "Toggle interactive translation off" => "Toggle interactive translation off",
// "Toggle interactive translation on" => "Toggle interactive translation on",
// "Edit quiz results" => "Edit quiz results",
// "and its subpages from the structure" => "and its subpages from the structure",
// "The page already exists. The page that has been added to the structure is the existing one" => "The page already exists. The page that has been added to the structure is the existing one",
// "The following pages added have automatically been categorized with the same categories as the structure" => "The following pages added have automatically been categorized with the same categories as the structure",
// "Monitor the Sub-Structure" => "Monitor the Sub-Structure",
// "Stop Monitoring the Sub-Structure" => "Stop Monitoring the Sub-Structure",
// "Move in this structure" => "Move in this structure",
// "Move to another structure" => "Move to another structure",
// "at the beginning" => "at the beginning",
// "at the end" => "at the end",
// "Categorize all pages in structure together" => "Categorize all pages in structure together",
// "Remove existing categories from ALL pages before recategorizing" => "Remove existing categories from ALL pages before recategorizing",
// "Submit Article" => "Submit Article",
// "Auto-Approve Article" => "Auto-Approve Article",
// "If you go to edit this (or any other TPL file) file via the Tiki built-in TPL editor below, all the javascript can be sanitized or completely stripped out by Tiki security filtering" => "If you go to edit this (or any other TPL file) file via the Tiki built-in TPL editor below, all the javascript can be sanitized or completely stripped out by Tiki security filtering",
// "This would cause you problems (e.g. menus can stop collapsing/expanding)" => "This would cause you problems (e.g. menus can stop collapsing/expanding)",
// "You should only modify default header.tpl and other important files via text code editor, through console, or SSH, or FTP edit commands. And only if you know what you are doing ! ;-)" => "You should only modify default header.tpl and other important files via text code editor, through console, or SSH, or FTP edit commands. And only if you know what you are doing ! ;-)",
// "Maybe You just want to modify the top of your Tiki site" => "Maybe You just want to modify the top of your Tiki site",
// "Please consider using the Look & Feel preferences custom code areas or modify tiki-top_bar.tpl which you can do safely via the web-based interface" => "Please consider using the Look & Feel preferences custom code areas or modify tiki-top_bar.tpl which you can do safely via the web-based interface",
// "Add Notification Email" => "Add Notification Email",
// "Admin notifications" => "Admin notifications",
// "View Article" => "View Article",
// "Language of newly translated page" => "Language of newly translated page",
// "Unspecified" => "Unspecified",
// "Name of newly translated page" => "Name of newly translated page",
// "Create translation" => "Create translation",
// "\"You forgot to specify the language of the translation. Please choose a language in the picklist.\"" => "\"You forgot to specify the language of the translation. Please choose a language in the picklist.\"",
// "\"The page already exists. It was selected in the list below.\"" => "\"The page already exists. It was selected in the list below.\"",
// "Or" => "Or",
// "Add existing page as a translation of this page" => "Add existing page as a translation of this page",
// "Manage existing translations of this page" => "Manage existing translations of this page",
// "Change language for this page" => "Change language for this page",
// "Select from available options.." => "Select from available options..",
// "Change Language" => "Change Language",
// "No language is assigned to this page" => "No language is assigned to this page",
// "Please select a language before performing translation" => "Please select a language before performing translation",
// "Set Current Page's Language" => "Set Current Page's Language",
// "Edit Video Information" => "Edit Video Information",
// "Browse Videos" => "Browse Videos",
// "The following video was successfully edited" => "The following video was successfully edited",
// "You can include the video in an HTML page using one of these lines" => "You can include the video in an HTML page using one of these lines",
// "View object" => "View object",
// "Preview your changes" => "Preview your changes",
// "Save the page" => "Save the page",
// "Cancel the edit, you will lose your changes" => "Cancel the edit, you will lose your changes",
// "This edit session will expire in" => "This edit session will expire in",
// "<strong>Preview</strong> or <strong>Save</strong> your work to restart the edit session timer" => "<strong>Preview</strong> or <strong>Save</strong> your work to restart the edit session timer",
// "Update '{\$page|escape}'" => "Update '{\$page|escape}'",
// "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval" => "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval",
// "This is a new staging page that has not been approved before" => "This is a new staging page that has not been approved before",
// "The current staging copy may contain changes that have yet to be approved" => "The current staging copy may contain changes that have yet to be approved",
// "View changes since last approval" => "View changes since last approval",
// "You are editing the approved copy of this page" => "You are editing the approved copy of this page",
// "There are currently changes in the staging copy that have yet to be approved" => "There are currently changes in the staging copy that have yet to be approved",
// "Are you sure you do not want to edit" => "Are you sure you do not want to edit",
// "the staging copy" => "the staging copy",
// "instead" => "instead",
// "Draft written on" => "Draft written on",
// "Warning: new versions of this page have been made after this draft" => "Warning: new versions of this page have been made after this draft",
// "Edit wiki page" => "Edit wiki page",
// "Change the style used to display differences to be translated" => "Change the style used to display differences to be translated",
// "Change diff styles" => "Change diff styles",
// "Edit page" => "Edit page",
// "Edit Comment" => "Edit Comment",
// "Edit comment: Enter some text to describe the changes you are currently making" => "Edit comment: Enter some text to describe the changes you are currently making",
// "Monitor this page" => "Monitor this page",
// "Add another image" => "Add another image",
// "Categories will be inherited from the structure top page" => "Categories will be inherited from the structure top page",
// "Tools" => "Tools",
// "Lock this page" => "Lock this page",
// "Allow comments on this page" => "Allow comments on this page",
// "Regex search " => "Regex search ",
// "Replace with" => "Replace with",
// "Upload Screencast" => "Upload Screencast",
// "Incorrect file extension was used for your flash screencast, expecting .swf or .flv" => "Incorrect file extension was used for your flash screencast, expecting .swf or .flv",
// "An unexpected error occurred while uploading your flash screencast" => "An unexpected error occurred while uploading your flash screencast",
// "Incorrect file extension was used for your Ogg screencast, expecting .ogg" => "Incorrect file extension was used for your Ogg screencast, expecting .ogg",
// "A flash screencast is mandatory" => "A flash screencast is mandatory",
// "An unexpected error occurred while uploading your Ogg screencast" => "An unexpected error occurred while uploading your Ogg screencast",
// "Preview not possible" => "Preview not possible",
// "Flash video (required)" => "Flash video (required)",
// "Ogg video (optional)" => "Ogg video (optional)",
// "Add another screencast" => "Add another screencast",
// "Authors' style" => "Authors' style",
// "Description (used for metatags)" => "Description (used for metatags)",
// "or use" => "or use",
// "Translation request" => "Translation request",
// "Send urgent translation request" => "Send urgent translation request",
// "List Sheets" => "List Sheets",
// "Export to file" => "Export to file",
// "Format" => "Format",
// "Autodetect" => "Autodetect",
// "Export Tracker Items" => "Export Tracker Items",
// "Delimitors" => "Delimitors",
// "Carriage Return inside Field Value" => "Carriage Return inside Field Value",
// "Parse as Wiki Text" => "Parse as Wiki Text",
// "Fields visible in items list" => "Fields visible in items list",
// "Fields searchable or visible in items list" => "Fields searchable or visible in items list",
// "Fields visible in an item view" => "Fields visible in an item view",
// "All fields" => "All fields",
// "These fields" => "These fields",
// "Use Ctrl+Click to select multiple fields" => "Use Ctrl+Click to select multiple fields",
// "Edit FAQ question" => "Edit FAQ question",
// "Add FAQ question" => "Add FAQ question",
// "File Archive" => "File Archive",
// "Be careful to set the right permissions on the files you link to" => "Be careful to set the right permissions on the files you link to",
// "Create New File Gallery" => "Create New File Gallery",
// "Size (width x height)" => "Size (width x height)",
// "Forum Importer" => "Forum Importer",
// "Import from a Local SQL File" => "Import from a Local SQL File",
// "Forum Type" => "Forum Type",
// "DB Prefix" => "DB Prefix",
// "Local SQL Filename on Server (path will be stripped)" => "Local SQL Filename on Server (path will be stripped)",
// "Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up" => "Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up",
// "Verification" => "Verification",
// "File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>" => "File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>",
// "File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred" => "File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred",
// "Select a Forum You Wish to Move (ONE at a time!)" => "Select a Forum You Wish to Move (ONE at a time!)",
// "Which Forum Do You Wish to Import this Into" => "Which Forum Do You Wish to Import this Into",
// "Message queue for forum" => "Message queue for forum",
// "Back to forum" => "Back to forum",
// "Search by name" => "Search by name",
// "Search in content" => "Search in content",
// "Reported messages for forum" => "Reported messages for forum",
// "Perfom action with checked" => "Perfom action with checked",
// "Un-report" => "Un-report",
// "Tag translation" => "Tag translation",
// "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag" => "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag",
// "Until then, they cannot be translated" => "Until then, they cannot be translated",
// "Show checkboxes to clear language information on tags" => "Show checkboxes to clear language information on tags",
// "There are no tags on this page in your preferred languages" => "There are no tags on this page in your preferred languages",
// "Set language" => "Set language",
// "Universal" => "Universal",
// "Show the following languages" => "Show the following languages",
// "Cancel friendship request" => "Cancel friendship request",
// "Global default" => "Global default",
// "Google Map Locator" => "Google Map Locator",
// "enter address" => "enter address",
// "Find address" => "Find address",
// "Save clicked point" => "Save clicked point",
// "Reset view to default" => "Reset view to default",
// "Save current view as default" => "Save current view as default",
// "Center map to saved point" => "Center map to saved point",
// "Reset view to site default" => "Reset view to site default",
// "Users Map" => "Users Map",
// "Wiki plug-in" => "Wiki plug-in",
// "Ical import / Export" => "Ical import / Export",
// "Select The calendar to export" => "Select The calendar to export",
// "Calendar Import" => "Calendar Import",
// "ICal File" => "ICal File",
// "Modify String in Source Language" => "Modify String in Source Language",
// "Original String" => "Original String",
// "New String" => "New String",
// "If you are NOT running a new Tiki installation, make a backup of your database before using this importer" => "If you are NOT running a new Tiki installation, make a backup of your database before using this importer",
// "Your PHP is running with safe mode enabled. This might cause problems to the import process as safe mode limits the possibly to change in run time some PHP settings (like max_execution_time). It is recommended to run this script without safe mode" => "Your PHP is running with safe mode enabled. This might cause problems to the import process as safe mode limits the possibly to change in run time some PHP settings (like max_execution_time). It is recommended to run this script without safe mode",
// "Depending on the size of the file from the source software, the import process may take a while to complete. This might be a problem according to your PHP and web server settings. This script tries to change the relevant settings but there are some settings that the script cannot change. So, if you are having problems with the script, please try to increase the value of the following PHP settings: max_input_time, max_execution_time (this setting is limited by the web server setting, if you are running Apache also change its Timeout setting), post_max_size, upload_max_filesize, memory_limit. It is recommended that you run this script on a server where you can change the values of those settings (if needed)" => "Depending on the size of the file from the source software, the import process may take a while to complete. This might be a problem according to your PHP and web server settings. This script tries to change the relevant settings but there are some settings that the script cannot change. So, if you are having problems with the script, please try to increase the value of the following PHP settings: max_input_time, max_execution_time (this setting is limited by the web server setting, if you are running Apache also change its Timeout setting), post_max_size, upload_max_filesize, memory_limit. It is recommended that you run this script on a server where you can change the values of those settings (if needed)",
// "Select the software to import from" => "Select the software to import from",
// "WARNING: make sure to have a backup before running the script. If you do not have a backup this is the last chance to cancel the importer by clicking on the cancel button" => "WARNING: make sure to have a backup before running the script. If you do not have a backup this is the last chance to cancel the importer by clicking on the cancel button",
// "Congratulations! You have successful imported your data to Tikiwiki" => "Congratulations! You have successful imported your data to Tikiwiki",
// "pages imported from a total of" => "pages imported from a total of",
// "You can see the list of wiki pages in your site" => "You can see the list of wiki pages in your site",
// "here" => "here",
// "Importer log" => "Importer log",
// "Tiki installer" => "Tiki installer",
// "Welcome" => "Welcome",
// "Welcome to the Tiki installation and upgrade script" => "Welcome to the Tiki installation and upgrade script",
// "Use this script to install a new Tiki database or upgrade your existing database to release" => "Use this script to install a new Tiki database or upgrade your existing database to release",
// "For the latest information about this release, please read the" => "For the latest information about this release, please read the",
// "Release Notes" => "Release Notes",
// "For complete documentation, please visit" => "For complete documentation, please visit",
// "For more information about Tiki, please visit" => "For more information about Tiki, please visit",
// "Select your language" => "Select your language",
// "Read the License" => "Read the License",
// "Tiki is software distributed under the LGPL license" => "Tiki is software distributed under the LGPL license",
// " <a href=\"http://creativecommons.org/licenses/LGPL/2.1/\" target=\"_blank\">Here is a human-readable summary of the license below, including many translations.</a>" => " <a href=\"http://creativecommons.org/licenses/LGPL/2.1/\" target=\"_blank\">Here is a human-readable summary of the license below, including many translations.</a>",
// "Review the System Requirements" => "Review the System Requirements",
// "Before installing Tiki, <a href=\"http://doc.tikiwiki.org/Requirements\" target=\"_blank\">review the documentation</a> and confirm that your system meets the minimum requirements" => "Before installing Tiki, <a href=\"http://doc.tikiwiki.org/Requirements\" target=\"_blank\">review the documentation</a> and confirm that your system meets the minimum requirements",
// "This installer will perform some basic checks automatically" => "This installer will perform some basic checks automatically",
// "Memory" => "Memory",
// "Success" => "Success",
// "Tiki has not detected your PHP memory_limit" => "Tiki has not detected your PHP memory_limit",
// "This probably means you have no set limit (all is well)" => "This probably means you have no set limit (all is well)",
// "Tiki has detected your PHP memory limit at" => "Tiki has detected your PHP memory limit at",
// "Tiki requires <strong>at least</strong> 32MB of PHP memory for script execution" => "Tiki requires <strong>at least</strong> 32MB of PHP memory for script execution",
// "Allocating too little memory will cause Tiki to display blank pages" => "Allocating too little memory will cause Tiki to display blank pages",
// "To change the memory limit, use the <strong>memory_limit</strong> key in your <strong>php.ini </strong> file (for example: memory_limit = 32M) and restart your webserver" => "To change the memory limit, use the <strong>memory_limit</strong> key in your <strong>php.ini </strong> file (for example: memory_limit = 32M) and restart your webserver",
// "Tiki has detected your PHP memory_limit at" => "Tiki has detected your PHP memory_limit at",
// "Tiki uses the PHP <strong>mail</strong> function to send email notifications and messages" => "Tiki uses the PHP <strong>mail</strong> function to send email notifications and messages",
// "To test your system configuration, Tiki will attempt to send a test message to you" => "To test your system configuration, Tiki will attempt to send a test message to you",
// "Test email" => "Test email",
// "Email address to send test to" => "Email address to send test to",
// "Copy test mail to " => "Copy test mail to ",
// "Send Test Message" => "Send Test Message",
// "Tiki was able to send a test message to" => "Tiki was able to send a test message to",
// "Tiki was not able to send a test message" => "Tiki was not able to send a test message",
// "Review your mail log for details" => "Review your mail log for details",
// "Review the mail settings in your <strong>php.ini</strong> file (for example: confirm that the <strong>sendmail_path</strong> is correct)" => "Review the mail settings in your <strong>php.ini</strong> file (for example: confirm that the <strong>sendmail_path</strong> is correct)",
// "If your host requires SMTP authentication, additional configuration may be necessary" => "If your host requires SMTP authentication, additional configuration may be necessary",
// "Image Processing" => "Image Processing",
// "Tiki detected" => "Tiki detected",
// "Tiki was not able to detect the GD library" => "Tiki was not able to detect the GD library",
// "Tiki uses the GD library to process images for the Image Gallery and CAPTCHA support" => "Tiki uses the GD library to process images for the Image Gallery and CAPTCHA support",
// "Set the Database Connection" => "Set the Database Connection",
// "Tiki requires an active database connection" => "Tiki requires an active database connection",
// "You must create the database and user <em>before</em> completing this page" => "You must create the database and user <em>before</em> completing this page",
// "Tiki cannot find a database connection" => "Tiki cannot find a database connection",
// "This is normal for a new installation" => "This is normal for a new installation",
// "Tiki found an existing database connection in your local.php file" => "Tiki found an existing database connection in your local.php file",
// "Use Existing Connection" => "Use Existing Connection",
// "Use this page to create a new database connection, or use the <a href=\"http://doc.tikiwiki.org/Manual+Installation\" target=\"_blank\" title=\"manual installation\">manual installation process</a>" => "Use this page to create a new database connection, or use the <a href=\"http://doc.tikiwiki.org/Manual+Installation\" target=\"_blank\" title=\"manual installation\">manual installation process</a>",
// "Database information" => "Database information",
// "Enter your database connection information" => "Enter your database connection information",
// "Database type" => "Database type",
// "Select the type of database to use with Tiki" => "Select the type of database to use with Tiki",
// "Only databases supported by your PHP installation are listed here. If your database is not in the list, try to install the appropriate PHP extension" => "Only databases supported by your PHP installation are listed here. If your database is not in the list, try to install the appropriate PHP extension",
// "Host name" => "Host name",
// "Enter the host name or IP for your database" => "Enter the host name or IP for your database",
// "Use <strong>localhost</strong> if the database is running on the same machine as Tiki" => "Use <strong>localhost</strong> if the database is running on the same machine as Tiki",
// "Database name" => "Database name",
// "Enter the name of the database that Tiki will use" => "Enter the name of the database that Tiki will use",
// "The database must already exist. You can create the database using mysqladmin, PHPMyAdmin, cPanel, or ask your hosting provider.  Normally Tiki tables won't conflict with other product names" => "The database must already exist. You can create the database using mysqladmin, PHPMyAdmin, cPanel, or ask your hosting provider.  Normally Tiki tables won't conflict with other product names",
// "Database user" => "Database user",
// "Enter a database user with administrator permission for the Database" => "Enter a database user with administrator permission for the Database",
// "Install &amp; Upgrade" => "Install &amp; Upgrade",
// "Failed to set max_execution_time to 0 for PHP. You may experience problems when creating/upgrading the database on a slow system. This will manitest itself by a blank page" => "Failed to set max_execution_time to 0 for PHP. You may experience problems when creating/upgrading the database on a slow system. This will manitest itself by a blank page",
// "This install will populate (or upgrade) the database" => "This install will populate (or upgrade) the database",
// "If you want to upgrade from a previous Tiki release, ensure that you have read and understood the <a href=\"http://doc.tikiwiki.org/Upgrade\" target=\"_blank\">Upgrade instructions</a>" => "If you want to upgrade from a previous Tiki release, ensure that you have read and understood the <a href=\"http://doc.tikiwiki.org/Upgrade\" target=\"_blank\">Upgrade instructions</a>",
// "A new install will populate the database" => "A new install will populate the database",
// "Reinstall the database" => "Reinstall the database",
// "This will destroy your current database" => "This will destroy your current database",
// "Reinstall" => "Reinstall",
// "Upgrade" => "Upgrade",
// "Warning: Category Permissions Will Not Be Upgraded" => "Warning: Category Permissions Will Not Be Upgraded",
// "Category permissions have been revamped in version 4. If you have been using category permissions, note that they may not work properly after upgrading to version 4, and it will be necessary to reconfigure them" => "Category permissions have been revamped in version 4. If you have been using category permissions, note that they may not work properly after upgrading to version 4, and it will be necessary to reconfigure them",
// "Automatically upgrade your existing database to v" => "Automatically upgrade your existing database to v",
// "This site has an admin account configured" => "This site has an admin account configured",
// "Please login with your admin password to continue" => "Please login with your admin password to continue",
// "Review the Upgrade" => "Review the Upgrade",
// "Review the Installation" => "Review the Installation",
// "Upgrade complete" => "Upgrade complete",
// "Installation complete" => "Installation complete",
// "Your database has been configured and Tiki is ready to run" => "Your database has been configured and Tiki is ready to run",
// "If this is your first install, your admin password is <strong>admin</strong>" => "If this is your first install, your admin password is <strong>admin</strong>",
// "You can now log in into Tiki as user <strong>admin</strong> and start configuring the application" => "You can now log in into Tiki as user <strong>admin</strong> and start configuring the application",
// "Upgrade operations executed successfully" => "Upgrade operations executed successfully",
// "Installation operations executed successfully" => "Installation operations executed successfully",
// "SQL queries" => "SQL queries",
// "Database was left unchanged" => "Database was left unchanged",
// "Failed" => "Failed",
// "Operations failed" => "Operations failed",
// "Display details" => "Display details",
// "During an upgrade, it is normal to have SQL failures resulting with <strong>Table already exists</strong> messages" => "During an upgrade, it is normal to have SQL failures resulting with <strong>Table already exists</strong> messages",
// ".htaccess File" => ".htaccess File",
// "We recommend enabling the <strong>.htaccess</strong> file for your Tiki" => "We recommend enabling the <strong>.htaccess</strong> file for your Tiki",
// "This will enable you to use SEFURLs (search engine friendly URLs) and help improve site security" => "This will enable you to use SEFURLs (search engine friendly URLs) and help improve site security",
// "To enable this file, simply rename the <strong>_htaccess</strong> file (located in the main directory of your Tiki installation) to <strong>.htaccess</strong>" => "To enable this file, simply rename the <strong>_htaccess</strong> file (located in the main directory of your Tiki installation) to <strong>.htaccess</strong>",
// "Complete these fields to configure common, general settings for your site" => "Complete these fields to configure common, general settings for your site",
// "The information you enter here can be changed later" => "The information you enter here can be changed later",
// "Refer to the <a href=\"http://doc.tikiwiki.org/Admin+Panels\" target=\"_blank\">documentation</a> for complete information on these, and other, settings" => "Refer to the <a href=\"http://doc.tikiwiki.org/Admin+Panels\" target=\"_blank\">documentation</a> for complete information on these, and other, settings",
// "This will appear in the browser title bar" => "This will appear in the browser title bar",
// "Email sent by your site will use this address" => "Email sent by your site will use this address",
// "Secure Login" => "Secure Login",
// "HTTPS login" => "HTTPS login",
// "Administrator" => "Administrator",
// "Admin email" => "Admin email",
// "This is the email address for your administrator account" => "This is the email address for your administrator account",
// "Enter Your Tiki" => "Enter Your Tiki",
// "The installation is complete" => "The installation is complete",
// "Tiki is an open source project, <em>you</em> can <a href='http://info.tikiwiki.org/Join+the+Community' target='_blank'>join the community</a> and help <a href='http://info.tikiwiki.org/Develop+Tiki' target='_blank'>develop Tiki</a>" => "Tiki is an open source project, <em>you</em> can <a href='http://info.tikiwiki.org/Join+the+Community' target='_blank'>join the community</a> and help <a href='http://info.tikiwiki.org/Develop+Tiki' target='_blank'>develop Tiki</a>",
// "Installation" => "Installation",
// "If this is a first time installation, go to <strong>tiki-admin.php</strong> after login to start configuring your new Tiki installation" => "If this is a first time installation, go to <strong>tiki-admin.php</strong> after login to start configuring your new Tiki installation",
// "If this is an upgrade, clean the Tiki caches manually (the <strong>templates_c</strong> directory) or by using the <strong>Admin &gt; System</strong> option from the Admin menu" => "If this is an upgrade, clean the Tiki caches manually (the <strong>templates_c</strong> directory) or by using the <strong>Admin &gt; System</strong> option from the Admin menu",
// "Enter Tiki and Lock Installer" => "Enter Tiki and Lock Installer",
// "Recommended" => "Recommended",
// "Enter Tiki Without Locking Installer" => "Enter Tiki Without Locking Installer",
// "MultiTiki Setup" => "MultiTiki Setup",
// "Default Installation" => "Default Installation",
// "DB OK" => "DB OK",
// "No DB" => "No DB",
// "Adding a new host" => "Adding a new host",
// "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter" => "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter",
// "MultiTiki" => "MultiTiki",
// "Are you upgrading an existing Tiki site" => "Are you upgrading an existing Tiki site",
// "Go directly to the <strong>Install/Upgrade</strong> step" => "Go directly to the <strong>Install/Upgrade</strong> step",
// "Install/Upgrade" => "Install/Upgrade",
// "Restart the installer" => "Restart the installer",
// "Database Connection" => "Database Connection",
// "Reset the Database Connection" => "Reset the Database Connection",
// "Install Profile" => "Install Profile",
// "Configure the General Settings" => "Configure the General Settings",
// "Tiki Icon" => "Tiki Icon",
// "TikiWiki Project Web Site" => "TikiWiki Project Web Site",
// "Support Forums" => "Support Forums",
// "TikiWiki CMS/Groupware Project" => "TikiWiki CMS/Groupware Project",
// "Powered by TikiWiki" => "Powered by TikiWiki",
// "Interactive translator" => "Interactive translator",
// "has been updated" => "has been updated",
// "Close this window" => "Close this window",
// "Go Back" => "Go Back",
// "Clicking 'Close this window' will reload the main window from where it was opened" => "Clicking 'Close this window' will reload the main window from where it was opened",
// "Upload to Kaltura" => "Upload to Kaltura",
// "List Entries" => "List Entries",
// "Upload Successful" => "Upload Successful",
// "You have successfully added {\$count} new entry/entries" => "You have successfully added {\$count} new entry/entries",
// "Change Details" => "Change Details",
// "Remix" => "Remix",
// "Advanced Editor" => "Advanced Editor",
// "Simple Editor" => "Simple Editor",
// "Views" => "Views",
// "Plays" => "Plays",
// "Last 2 days" => "Last 2 days",
// "Last 3 days" => "Last 3 days",
// "Last 5 days" => "Last 5 days",
// "Last week" => "Last week",
// "Last 2 weeks" => "Last 2 weeks",
// "Last month" => "Last month",
// "Max Clicks" => "Max Clicks",
// "The cache is used by" => "The cache is used by",
// "Approval" => "Approval",
// "Rejected" => "Rejected",
// "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block" => "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block",
// "Edit content block" => "Edit content block",
// "Create content block" => "Create content block",
// "Current Value" => "Current Value",
// "SlideShow" => "SlideShow",
// "Keep gallery window open" => "Keep gallery window open",
// "Your comment" => "Your comment",
// "Modifications" => "Modifications",
// "Property <b>{\$fgp_name}</b> Changed" => "Property <b>{\$fgp_name}</b> Changed",
// "Media Entries" => "Media Entries",
// "Mix Entries" => "Mix Entries",
// "Kaltura Remix Entries" => "Kaltura Remix Entries",
// "Kaltura Media Entries" => "Kaltura Media Entries",
// "Loads" => "Loads",
// "Browse Entries" => "Browse Entries",
// "Additional Info" => "Additional Info",
// "Media Type" => "Media Type",
// "No entries" => "No entries",
// "No media entries found. " => "No media entries found. ",
// "Click here " => "Click here ",
// "to upload" => "to upload",
// "No mix entries found. " => "No mix entries found. ",
// "to create a new mix" => "to create a new mix",
// "Playlist Type" => "Playlist Type",
// "No playlists found. " => "No playlists found. ",
// "to create a playlist" => "to create a playlist",
// "Object Permissions List" => "Object Permissions List",
// "Manage Permissions" => "Manage Permissions",
// "If an object is not in the special section, then only the default perms are on" => "If an object is not in the special section, then only the default perms are on",
// "Special" => "Special",
// "Those movies are very good tutorials of tikiwiki use. They have been generated by siridhar with camtasia studio for public use ! Thanks to him. The up-to-date list of movies is on" => "Those movies are very good tutorials of tikiwiki use. They have been generated by siridhar with camtasia studio for public use ! Thanks to him. The up-to-date list of movies is on",
// "Page aliases found" => "Page aliases found",
// "Page creator" => "Page creator",
// "Status of the page" => "Status of the page",
// "Links to other items in page" => "Links to other items in page",
// "Links to this page in other pages" => "Links to this page in other pages",
// "Backl" => "Backl",
// "Page size" => "Page size",
// " {if \$find ne ''}and {/if}starting with" => " {if \$find ne ''}and {/if}starting with",
// "However, some page aliases fitting the query were found (see Aliases section above)" => "However, some page aliases fitting the query were found (see Aliases section above)",
// "Perform action with checked" => "Perform action with checked",
// "Xml Zip" => "Xml Zip",
// "offline" => "offline",
// "Back to admin" => "Back to admin",
// "For security purposes we must periodically validate your email address to allow continued access to this site" => "For security purposes we must periodically validate your email address to allow continued access to this site",
// "A validation email has been sent to you. Please open that email and follow the instructions to once again gain access to the site" => "A validation email has been sent to you. Please open that email and follow the instructions to once again gain access to the site",
// "Thank you" => "Thank you",
// "Missing dependency. Obtain <a href=\"http://tikiwiki.org/tiki-download_file.php?fileId=50\">visorFreemind.swf</a> and upload it in files/" => "Missing dependency. Obtain <a href=\"http://tikiwiki.org/tiki-download_file.php?fileId=50\">visorFreemind.swf</a> and upload it in files/",
// "Tiki \"mods\" are additional features not included in the public release. Learn more at <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>" => "Tiki \"mods\" are additional features not included in the public release. Learn more at <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>",
// "Tiki \"mods\" are undergoing refurbishment" => "Tiki \"mods\" are undergoing refurbishment",
// "You will probably some find mods shown as being compatible with older versions of Tiki will work with later versions with little or no modification" => "You will probably some find mods shown as being compatible with older versions of Tiki will work with later versions with little or no modification",
// "Your help is needed! Please visit <a href=\"http://dev.tikiwiki.org/tiki-index.php?page=Mods\">dev.tikiwiki.org</a> to find out more" => "Your help is needed! Please visit <a href=\"http://dev.tikiwiki.org/tiki-index.php?page=Mods\">dev.tikiwiki.org</a> to find out more",
// "Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"sh setup.sh\" for example)" => "Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"sh setup.sh\" for example)",
// "To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"sh setup.sh open\" to set it up). After installation you need to remove that permission (using \"sh setup.sh\")" => "To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"sh setup.sh open\" to set it up). After installation you need to remove that permission (using \"sh setup.sh\")",
// "for version" => "for version",
// "all versions" => "all versions",
// "or later" => "or later",
// "No mods found" => "No mods found",
// "licence" => "licence",
// "Mods Install/uninstall" => "Mods Install/uninstall",
// "Records" => "Records",
// "My Articles" => "My Articles",
// "User Articles" => "User Articles",
// "My User Items" => "My User Items",
// "User Items" => "User Items",
// "User forum topics" => "User forum topics",
// "Forum topics" => "Forum topics",
// "Date of post" => "Date of post",
// "User forum replies" => "User forum replies",
// "Forum replies" => "Forum replies",
// "To display the objects you created or contributed to" => "To display the objects you created or contributed to",
// "MyInfo" => "MyInfo",
// "Contacts Preferences" => "Contacts Preferences",
// "Sent Edition" => "Sent Edition",
// "HTML version" => "HTML version",
// "Text version" => "Text version",
// "Delete errors" => "Delete errors",
// "Not sent" => "Not sent",
// "Removal of your email address failed" => "Removal of your email address failed",
// "Subscription failed" => "Subscription failed",
// "Object Watches" => "Object Watches",
// "Watching Groups" => "Watching Groups",
// "Edit Permissions" => "Edit Permissions",
// "Currently editing Global permissions" => "Currently editing Global permissions",
// "This object's direct permissions override any global permissions or category permissions affecting this object" => "This object's direct permissions override any global permissions or category permissions affecting this object",
// "This category's direct permissions override any global permissions affecting objects in it" => "This category's direct permissions override any global permissions affecting objects in it",
// "To edit global permissions" => "To edit global permissions",
// "No permissions yet applied to this object but category permissions affect this object and are displayed below" => "No permissions yet applied to this object but category permissions affect this object and are displayed below",
// "To edit category permissions" => "To edit category permissions",
// "No direct permissions yet applied to this object. Global permissions apply" => "No direct permissions yet applied to this object. Global permissions apply",
// "Currently inherited permissions displayed" => "Currently inherited permissions displayed",
// "Assign global permissions" => "Assign global permissions",
// "Reset to Global Perms" => "Reset to Global Perms",
// "Reset Perms" => "Reset Perms",
// "This will remove all the settings here and permissions will be reset to inherit any category permissions that are set, or the global sitewide permissions" => "This will remove all the settings here and permissions will be reset to inherit any category permissions that are set, or the global sitewide permissions",
// "This will remove all the settings here and permissions will be reset to inherit the global sitewide permissions" => "This will remove all the settings here and permissions will be reset to inherit the global sitewide permissions",
// "Permissions Clipboard" => "Permissions Clipboard",
// "Copy the permissions set here" => "Copy the permissions set here",
// "Paste" => "Paste",
// "Paste copied permissions from " => "Paste copied permissions from ",
// "Assign or remove permissions on <em>all</em> child categories" => "Assign or remove permissions on <em>all</em> child categories",
// "Are you sure you want to effect all child categories?\\nThere is no undo" => "Are you sure you want to effect all child categories?\\nThere is no undo",
// "Assign or remove permissions on all pages of the sub-structure" => "Assign or remove permissions on all pages of the sub-structure",
// "Are you sure you want to effect all pages in this sub-structure?\\nThere is no undo" => "Are you sure you want to effect all pages in this sub-structure?\\nThere is no undo",
// "Select groups" => "Select groups",
// "Some of your groups have been automatically hidden.<br /> Select the groups below to assign permissions for" => "Some of your groups have been automatically hidden.<br /> Select the groups below to assign permissions for",
// "Select all" => "Select all",
// "Select features" => "Select features",
// "Some of your features have been automatically hidden.<br /> Select the features below to assign permissions for" => "Some of your features have been automatically hidden.<br /> Select the features below to assign permissions for",
// "Show permissions for disabled features" => "Show permissions for disabled features",
// "Feature name" => "Feature name",
// "Quick Permissions" => "Quick Permissions",
// "These permissions override any global permissions or category permissions affecting this object" => "These permissions override any global permissions or category permissions affecting this object",
// "To edit global permissions <a class=\"rbox-link\" href=\"tiki-objectpermissions.php?objectType=global\">click here</a>" => "To edit global permissions <a class=\"rbox-link\" href=\"tiki-objectpermissions.php?objectType=global\">click here</a>",
// "Assign Quick-Permissions to this object" => "Assign Quick-Permissions to this object",
// "A couple of userdefined permissions are currently assigned (See tab Assign Permissions)" => "A couple of userdefined permissions are currently assigned (See tab Assign Permissions)",
// "Your OpenID identity is valid" => "Your OpenID identity is valid",
// "However, no account is associated to the OpenID identifier" => "However, no account is associated to the OpenID identifier",
// "Create a new Tikiwiki account from OpenID" => "Create a new Tikiwiki account from OpenID",
// "Associate OpenID with an existing Tikiwiki account" => "Associate OpenID with an existing Tikiwiki account",
// "Your identity gives you access to multiple user accounts" => "Your identity gives you access to multiple user accounts",
// "Select account" => "Select account",
// "Make Structure" => "Make Structure",
// "{\$atts|@count} files attached" => "{\$atts|@count} files attached",
// "Updated from" => "Updated from",
// "Used to update" => "Used to update",
// "Update Translation" => "Update Translation",
// "Hide translation history" => "Hide translation history",
// "Show translation history" => "Show translation history",
// "File (only .gif, .jpg and .png images approximately 45px × 45px)" => "File (only .gif, .jpg and .png images approximately 45px × 45px)",
// "Plugin execution was denied" => "Plugin execution was denied",
// "Plugin execution pending approval" => "Plugin execution pending approval",
// "After argument validation by an editor, the execution of this plugin was denied. This plugin will eventually be removed or corrected" => "After argument validation by an editor, the execution of this plugin was denied. This plugin will eventually be removed or corrected",
// "This plugin was recently added or modified. Until an editor of the site validates the parameters, execution will not be possible" => "This plugin was recently added or modified. Until an editor of the site validates the parameters, execution will not be possible",
// "You are allowed to" => "You are allowed to",
// "View arguments" => "View arguments",
// "Execute the plugin in preview mode (may be dangerous)" => "Execute the plugin in preview mode (may be dangerous)",
// "Approve the plugin for public execution" => "Approve the plugin for public execution",
// "View Details" => "View Details",
// "This plugin does not contain any arguments" => "This plugin does not contain any arguments",
// "This plugin's body is empty" => "This plugin's body is empty",
// "Any" => "Any",
// "Items found" => "Items found",
// "Rank" => "Rank",
// "Sum" => "Sum",
// "Plugin Approval" => "Plugin Approval",
// "For security, grant the <strong>tiki_p_plugin_approve</strong> permission only to trusted user groups" => "For security, grant the <strong>tiki_p_plugin_approve</strong> permission only to trusted user groups",
// "Use the <a href=\"tiki-admin.php?page=textarea\">Admin: Text Area page</a> to deactivate potentially risky plugins" => "Use the <a href=\"tiki-admin.php?page=textarea\">Admin: Text Area page</a> to deactivate potentially risky plugins",
// "This page lists the plugins that require validation, the first time they are encountered" => "This page lists the plugins that require validation, the first time they are encountered",
// "Each plugin contains a unique <em>signature</em> that is preserved" => "Each plugin contains a unique <em>signature</em> that is preserved",
// "If a plugin is no longer in use (for example, it has been removed from the wiki page), use <strong>Clear</strong> to remove it from this list" => "If a plugin is no longer in use (for example, it has been removed from the wiki page), use <strong>Clear</strong> to remove it from this list",
// "The plugin will automatically be added if it is encountered" => "The plugin will automatically be added if it is encountered",
// "Plugins can be individually previewed, approved, or rejected from the particular location that contains the plugin" => "Plugins can be individually previewed, approved, or rejected from the particular location that contains the plugin",
// "For security, you should review each plugin to ensure it is safe to approve" => "For security, you should review each plugin to ensure it is safe to approve",
// "Plugin" => "Plugin",
// "Added By" => "Added By",
// "Signature" => "Signature",
// "Wiki page: <a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page" => "Wiki page: <a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page",
// "<a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page" => "<a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page",
// "Approve all pending plugins" => "Approve all pending plugins",
// "Using <strong>Approve</strong> or <strong>Approve All</strong> will approve and activate the pending plugins" => "Using <strong>Approve</strong> or <strong>Approve All</strong> will approve and activate the pending plugins",
// "Use this feature <strong>only</strong> if you have verified that all the pending plugins are safe" => "Use this feature <strong>only</strong> if you have verified that all the pending plugins are safe",
// "No plugins pending approval" => "No plugins pending approval",
// "Poll Results" => "Poll Results",
// "Top Voted Polls" => "Top Voted Polls",
// "Edit Poll" => "Edit Poll",
// "Find the poll" => "Find the poll",
// "Number of top voted polls to show" => "Number of top voted polls to show",
// "Vote range displayed" => "Vote range displayed",
// "All votes with no span consideration" => "All votes with no span consideration",
// "All votes with span consideration" => "All votes with span consideration",
// "All votes" => "All votes",
// "List Votes" => "List Votes",
// "Permission denied. You do not have permission to read complete articles" => "Permission denied. You do not have permission to read complete articles",
// "Selected Structures" => "Selected Structures",
// "No structures" => "No structures",
// "Add Pages" => "Add Pages",
// "No pages" => "No pages",
// "Add Pages from Structures" => "Add Pages from Structures",
// "Add Structure Pages" => "Add Structure Pages",
// "Selected Pages" => "Selected Pages",
// "No pages selected" => "No pages selected",
// "Passed" => "Passed",
// "star" => "star",
// "half star" => "half star",
// "Send a link" => "Send a link",
// "Edit Received Page" => "Edit Received Page",
// "The highlight pages already exist" => "The highlight pages already exist",
// "Please, change the name if you want the page to be uploaded" => "Please, change the name if you want the page to be uploaded",
// "Received Structures" => "Received Structures",
// "Prefix the checked" => "Prefix the checked",
// "Postfix the checked" => "Postfix the checked",
// "Use your email as login" => "Use your email as login",
// "Minimum {\$prefs.min_username_length} characters long" => "Minimum {\$prefs.min_username_length} characters long",
// "Passcode to register" => "Passcode to register",
// "Not your password" => "Not your password",
// "To request a passcode, {if \$prefs.feature_contact eq 'y'}<a href=\"tiki-contact.php\">{/if}\n\t\t\t\t\t\tcontact the sytem administrator{if \$prefs.feature_contact eq 'y'}</a>{/if}" => "To request a passcode, {if \$prefs.feature_contact eq 'y'}<a href=\"tiki-contact.php\">{/if}\n\t\t\t\t\t\tcontact the sytem administrator{if \$prefs.feature_contact eq 'y'}</a>{/if}",
// "Generate a\tpassword" => "Generate a\tpassword",
// "Select your group" => "Select your group",
// "Make sure to whitelist this domain to prevent registration emails being canned by your spam filter" => "Make sure to whitelist this domain to prevent registration emails being canned by your spam filter",
// "Enter your username or email" => "Enter your username or email",
// "Enter your email" => "Enter your email",
// "Request Password Reset" => "Request Password Reset",
// "Back to page" => "Back to page",
// "to version" => "to version",
// "Date Search" => "Date Search",
// "All dates" => "All dates",
// "Calendar Items" => "Calendar Items",
// "octets" => "octets",
// "Data HTML" => "Data HTML",
// "Data Txt" => "Data Txt",
// "Attached Files" => "Attached Files",
// "To add a file, click here" => "To add a file, click here",
// "Reply To Email" => "Reply To Email",
// "if not" => "if not",
// "Save as Draft" => "Save as Draft",
// "Save your changes" => "Save your changes",
// "Save any changes and send to all subscribers" => "Save any changes and send to all subscribers",
// "Send a structure" => "Send a structure",
// "Ex: http://tikiwiki.org or localhost" => "Ex: http://tikiwiki.org or localhost",
// "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need" => "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need",
// "This is the staging copy of" => "This is the staging copy of",
// "the approved version of this page" => "the approved version of this page",
// "Viewing of changes since last approval is possible only after first approval" => "Viewing of changes since last approval is possible only after first approval",
// "Approve changes" => "Approve changes",
// "Latest changes will be synchronized after approval" => "Latest changes will be synchronized after approval",
// "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time" => "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time",
// "Content may be out of date" => "Content may be out of date",
// "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages" => "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages",
// "TOC" => "TOC",
// "This text was automatically translated by Google Translate from the following page: " => "This text was automatically translated by Google Translate from the following page: ",
// "page: %0/%1" => "page: %0/%1",
// "Page last modified on %0 by %1" => "Page last modified on %0 by %1",
// "Created by %0" => "Created by %0",
// "Last Modification: %0 by %1" => "Last Modification: %0 by %1",
// "You will not see the latest queries" => "You will not see the latest queries",
// "Clean" => "Clean",
// "Total replies" => "Total replies",
// "Average number of replies per topic" => "Average number of replies per topic",
// "FAQ Stats" => "FAQ Stats",
// "Most viewed objects in period" => "Most viewed objects in period",
// "Tiki Logs" => "Tiki Logs",
// "Clean logs older than" => "Clean logs older than",
// "months" => "months",
// "Send a link to a friend" => "Send a link to a friend",
// "The link was sent to the following addresses" => "The link was sent to the following addresses",
// "Friend's email" => "Friend's email",
// "Separate multiple email addresses with a comma" => "Separate multiple email addresses with a comma",
// "Your name" => "Your name",
// "Your email" => "Your email",
// "I found an interesting page that I thought you would like" => "I found an interesting page that I thought you would like",
// "TikiTests Edit" => "TikiTests Edit",
// "Summary mode" => "Summary mode",
// "Show Page Differences" => "Show Page Differences",
// "Show Tidy Errors and Warnings" => "Show Tidy Errors and Warnings",
// "Show POST Data" => "Show POST Data",
// "Use Current Session/Logout" => "Use Current Session/Logout",
// "Recorded Links" => "Recorded Links",
// "Request" => "Request",
// "Element to compare (Xpath expression)" => "Element to compare (Xpath expression)",
// "Test Xpath Expression" => "Test Xpath Expression",
// "Post Variables" => "Post Variables",
// "Tidy Results" => "Tidy Results",
// "Delete this link" => "Delete this link",
// "TikiTests List" => "TikiTests List",
// "Config" => "Config",
// "Replay" => "Replay",
// "Tidy extension not present" => "Tidy extension not present",
// "PECL HTTP extension present" => "PECL HTTP extension present",
// "cURL extension present" => "cURL extension present",
// "PECL HTTP and cURL extension not present. Replay of the TikiTest will not be possible" => "PECL HTTP and cURL extension not present. Replay of the TikiTest will not be possible",
// "List TikiTests" => "List TikiTests",
// "Create a TikiTest" => "Create a TikiTest",
// "Replay the TikiTest" => "Replay the TikiTest",
// "Edit the TikiTest" => "Edit the TikiTest",
// "TikiTests Record Configuration" => "TikiTests Record Configuration",
// "Start Recording Test" => "Start Recording Test",
// "TikiTests Replay Configuration" => "TikiTests Replay Configuration",
// "Failure" => "Failure",
// "Reference" => "Reference",
// "The pages are different" => "The pages are different",
// "The pages are identical" => "The pages are identical",
// "Recording to pause press the pause button" => "Recording to pause press the pause button",
// "Pause the recording" => "Pause the recording",
// "Paused to resume press the play button" => "Paused to resume press the play button",
// "Resume the recording" => "Resume the recording",
// "Stop the recording" => "Stop the recording",
// "Theme Control Center: Categories" => "Theme Control Center: Categories",
// "Theme Control Center: Sections" => "Theme Control Center: Sections",
// "Advanced mode" => "Advanced mode",
// "Retry" => "Retry",
// "The following files have been successfully uploaded" => "The following files have been successfully uploaded",
// "You can link to the file from a Wiki page using" => "You can link to the file from a Wiki page using",
// "You can display an image in a Wiki page using" => "You can display an image in a Wiki page using",
// "Or using as a thumbnail with ShadowBox" => "Or using as a thumbnail with ShadowBox",
// "You can link to the file from an HTML page using" => "You can link to the file from an HTML page using",
// "You locked the file" => "You locked the file",
// "The file is locked by {\$fileInfo.lockedby}" => "The file is locked by {\$fileInfo.lockedby}",
// "File title" => "File title",
// "required field for podcasts" => "required field for podcasts",
// "File description" => "File description",
// "Unzip zip files" => "Unzip zip files",
// "Author, if different from the Creator" => "Author, if different from the Creator",
// "Maximum number of downloads" => "Maximum number of downloads",
// "Add File" => "Add File",
// "Maximum file size is around" => "Maximum file size is around",
// "Uploading file.." => "Uploading file..",
// "No File to Upload.." => "No File to Upload..",
// " Syntax tips" => " Syntax tips",
// "Link to file from a Wiki page" => "Link to file from a Wiki page",
// "For image files" => "For image files",
// "To display in a Wiki page" => "To display in a Wiki page",
// "Display thumbnail that enlarges" => "Display thumbnail that enlarges",
// "No gallery available" => "No gallery available",
// "The column is disabled" => "The column is disabled",
// "a folder" => "a folder",
// "a bookmark" => "a bookmark",
// "User Contacts Preferences" => "User Contacts Preferences",
// "Default view" => "Default view",
// "Manage Fields" => "Manage Fields",
// "Basic Data" => "Basic Data",
// "User Icon" => "User Icon",
// "(non public)" => "(non public)",
// "This user is your friend " => "This user is your friend ",
// "The user requested friendship with you" => "The user requested friendship with you",
// "Accept friendship from this user" => "Accept friendship from this user",
// "Refuse friendship from this user" => "Refuse friendship from this user",
// "Currently waiting for user approval" => "Currently waiting for user approval",
// "Cancel friendship request towards this user" => "Cancel friendship request towards this user",
// "Additional Information" => "Additional Information",
// "User Contribution" => "User Contribution",
// "has contributed to the following content" => "has contributed to the following content",
// "has not contributed to any content yet" => "has not contributed to any content yet",
// "Forum comments" => "Forum comments",
// "Send Me A Message" => "Send Me A Message",
// "Send me a message " => "Send me a message ",
// "The following message will be sent to user" => "The following message will be sent to user",
// "Message Body" => "Message Body",
// "Male" => "Male",
// "Female" => "Female",
// "Use Google Map locator" => "Use Google Map locator",
// "Your preferred language" => "Your preferred language",
// "Can you read more languages" => "Can you read more languages",
// "Other languages you can read (select on the left to add to the list on the right)" => "Other languages you can read (select on the left to add to the list on the right)",
// "Select language.." => "Select language..",
// "Display info tooltip on mouseover for every user who allows his/her information to be public" => "Display info tooltip on mouseover for every user who allows his/her information to be public",
// "My user items" => "My user items",
// "My level" => "My level",
// "Account Deletion" => "Account Deletion",
// "Are you really sure you want to delete your account " => "Are you really sure you want to delete your account ",
// "Check this box if you really want to delete your account" => "Check this box if you really want to delete your account",
// "Delete my account" => "Delete my account",
// "User Watches and preferences" => "User Watches and preferences",
// "You need to set your email to receive email notifications" => "You need to set your email to receive email notifications",
// "Report Preferences" => "Report Preferences",
// "You are not allowed to remove this notification " => "You are not allowed to remove this notification ",
// "Use reports to summarise notifications about objects you are watching" => "Use reports to summarise notifications about objects you are watching",
// "Use reports" => "Use reports",
// "Interval in witch you want to get the reports" => "Interval in witch you want to get the reports",
// "Short report" => "Short report",
// "Detailed report" => "Detailed report",
// "HTML-Email" => "HTML-Email",
// "Send me an email also if nothing happened" => "Send me an email also if nothing happened",
// "Reports are disabled, only standard reporting is available" => "Reports are disabled, only standard reporting is available",
// "Sites you are watching" => "Sites you are watching",
// "Use \"watches\" to monitor wiki pages or other objects" => "Use \"watches\" to monitor wiki pages or other objects",
// "Watch new items by clicking the {icon _id=eye} button on specific pages" => "Watch new items by clicking the {icon _id=eye} button on specific pages",
// "Select event type" => "Select event type",
// "All watched events" => "All watched events",
// "A user edited an article" => "A user edited an article",
// "A user deleted an article" => "A user deleted an article",
// "A user created a wiki page in a language" => "A user created a wiki page in a language",
// "A user edits an article" => "A user edits an article",
// "A user deletes an article" => "A user deletes an article",
// "Used space" => "Used space",
// "up to" => "up to",
// "no limit for admin" => "no limit for admin",
// "No articles yet" => "No articles yet",
// "Add an article" => "Add an article",
// "There are no questions in this FAQ" => "There are no questions in this FAQ",
// "Manage Message Queue" => "Manage Message Queue",
// "Manage Reported Messages" => "Manage Reported Messages",
// "Monitor Topics of this Forum" => "Monitor Topics of this Forum",
// "Stop Monitoring Topics of this Forum" => "Stop Monitoring Topics of this Forum",
// "Monitor Topics and Threads of this Forum" => "Monitor Topics and Threads of this Forum",
// "Stop Monitoring Topics and Threads of this Forum" => "Stop Monitoring Topics and Threads of this Forum",
// "Group Monitor Topics of this Forum" => "Group Monitor Topics of this Forum",
// "Group Monitor Topics and Threads of this Forum" => "Group Monitor Topics and Threads of this Forum",
// "Editing" => "Editing",
// "Post New" => "Post New",
// "Watch for replies" => "Watch for replies",
// "Send me an e-mail when someone replies to my topic" => "Send me an e-mail when someone replies to my topic",
// "Don't send me any e-mails" => "Don't send me any e-mails",
// "Editing posts" => "Editing posts",
// "Forum Lock" => "Forum Lock",
// "Unarchive" => "Unarchive",
// "posts in this forum" => "posts in this forum",
// "Filter Posts" => "Filter Posts",
// "Posts Filtering" => "Posts Filtering",
// "Last post date" => "Last post date",
// "Show archived posts" => "Show archived posts",
// "Containing posts by" => "Containing posts by",
// "Me" => "Me",
// "Posts with no replies" => "Posts with no replies",
// "Archived" => "Archived",
// "Topic List" => "Topic List",
// "The post has been reported and will be reviewed by a moderator" => "The post has been reported and will be reviewed by a moderator",
// "Print this page only" => "Print this page only",
// "Print all pages" => "Print all pages",
// "Stop Monitor" => "Stop Monitor",
// "Pending" => "Pending",
// "Edit/Delete" => "Edit/Delete",
// "Add a new" => "Add a new",
// "Edit this" => "Edit this",
// " mail account" => " mail account",
// "Incoming servers (used in this order)" => "Incoming servers (used in this order)",
// "IMAP server" => "IMAP server",
// "Mbox filepath" => "Mbox filepath",
// "Maildir mail directory" => "Maildir mail directory",
// "Use SSL" => "Use SSL",
// "Outgoing server" => "Outgoing server",
// "Account details" => "Account details",
// "Group (shared mail inbox) or private" => "Group (shared mail inbox) or private",
// "This will be a group mail account" => "This will be a group mail account",
// "This will be a personal mail account" => "This will be a personal mail account",
// "Auto-refresh page time" => "Auto-refresh page time",
// "You do not have the correct permissions to Add or Edit a webmail account. <BR />Please contact your administrator and ask for \"admin_personal_webmail\" or \"admin_group_webmail\" permission" => "You do not have the correct permissions to Add or Edit a webmail account. <BR />Please contact your administrator and ask for \"admin_personal_webmail\" or \"admin_group_webmail\" permission",
// "Personal e-mail accounts" => "Personal e-mail accounts",
// "This is the active account" => "This is the active account",
// "IMAP" => "IMAP",
// "Mbox" => "Mbox",
// "Maildir" => "Maildir",
// "POP3" => "POP3",
// "Group e-mail accounts" => "Group e-mail accounts",
// "Show Unread" => "Show Unread",
// "Show Flagged" => "Show Flagged",
// "Auto refresh set for every \$autoRefresh seconds" => "Auto refresh set for every \$autoRefresh seconds",
// "Refresh now" => "Refresh now",
// "Group messages" => "Group messages",
// "unFlagged" => "unFlagged",
// "Part" => "Part",
// "View edit icons" => "View edit icons",
// "Group Monitor on Structure" => "Group Monitor on Structure",
// "Jump to Content" => "Jump to Content",
// "Fullscreen" => "Fullscreen",
// "Cancel Fullscreen" => "Cancel Fullscreen",
// "Latitude" => "Latitude",
// "Longitude" => "Longitude",
// "Word Limit Exceeded" => "Word Limit Exceeded",
// "Character Limit Exceeded" => "Character Limit Exceeded",
// "Character Count" => "Character Count",
// "Word Count" => "Word Count",
// "Format: x,y,zoom where x is the longitude, and y is the latitude. Zoom is between 0(view Earth) and 19. You can use <a href=\"tiki-gmap_locator.php?for=item&amp;itemId={\$item.itemId}&amp;trackerId={\$item.trackerId}&amp;fieldId={\$field_value.fieldId}\">{tr}Google Map Locator" => "Format: x,y,zoom where x is the longitude, and y is the latitude. Zoom is between 0(view Earth) and 19. You can use <a href=\"tiki-gmap_locator.php?for=item&amp;itemId={\$item.itemId}&amp;trackerId={\$item.trackerId}&amp;fieldId={\$field_value.fieldId}\">{tr}Google Map Locator",
// "Number of votes" => "Number of votes",
// "Your rating" => "Your rating",
// "You did not vote yet" => "You did not vote yet",
// "My rating" => "My rating",
// "Click to vote for this value" => "Click to vote for this value",
// "Clik to delete your vote" => "Clik to delete your vote",
// "You have ever subscribed" => "You have ever subscribed",
// "You have not yet subscribed" => "You have not yet subscribed",
// "friends" => "friends",
// "Unsubscribe" => "Unsubscribe",
// "Google Maps is not enabled" => "Google Maps is not enabled",
// "The main text of this page is available in the following languages" => "The main text of this page is available in the following languages",
// "Missing or incorrect trackerId parameter for the plugin" => "Missing or incorrect trackerId parameter for the plugin",
// "list" => "list",
// "Email address the person you want to invite" => "Email address the person you want to invite",
// "Set in these groups" => "Set in these groups",
// "Leave" => "Leave",
// "Undecided" => "Undecided",
// "Last Day" => "Last Day",
// "Last Week" => "Last Week",
// "Last Month" => "Last Month",
// "Last Year" => "Last Year",
// "Your default group" => "Your default group",
// "Change default group" => "Change default group",
// "Subscribe to a group" => "Subscribe to a group",
// "Toggle display" => "Toggle display",
// "Creator &amp; Last Editor" => "Creator &amp; Last Editor",
// "Save the page as a partial translation" => "Save the page as a partial translation",
// "Partial Translation" => "Partial Translation",
// "Save the page as a completed translation" => "Save the page as a completed translation",
// "Complete Translation" => "Complete Translation",
// "Save the page, but do not send notifications and do not count it as new content to be translated" => "Save the page, but do not send notifications and do not count it as new content to be translated",
// "Save the page as a draft" => "Save the page as a draft",
// "Save Draft" => "Save Draft",
// "Permission denied you cannot view the Tiki calendar" => "Permission denied you cannot view the Tiki calendar",
// "%0 enabled" => "%0 enabled",
// "%0 disabled" => "%0 disabled",
// "%0 set" => "%0 set",
// "%0 unset" => "%0 unset",
// "Help on Configuration Sections" => "Help on Configuration Sections",
// "Current version is up to date : <b>%0</b>" => "Current version is up to date : <b>%0</b>",
// "A new major release branch is available" => "A new major release branch is available",
// "A new %0 major release branch is available" => "A new %0 major release branch is available",
// "Feeds settings" => "Feeds settings",
// "Freetags settings" => "Freetags settings",
// "Customize look and feel of your Tiki" => "Customize look and feel of your Tiki",
// "Text area" => "Text area",
// "Configure Site Ads and Banners" => "Configure Site Ads and Banners",
// "Kaltura settings" => "Kaltura settings",
// "Must specify actionId" => "Must specify actionId",
// "Users Contributions: Addition" => "Users Contributions: Addition",
// "%s Contributions: Addition" => "%s Contributions: Addition",
// "Users Contributions: Suppression" => "Users Contributions: Suppression",
// "%s Contributions: Suppression" => "%s Contributions: Suppression",
// "Total Contributions Addition per Day" => "Total Contributions Addition per Day",
// "Total Contributions Addition per Week" => "Total Contributions Addition per Week",
// "Total Contributions Suppression per Day" => "Total Contributions Suppression per Day",
// "Total Contributions Suppression per Week" => "Total Contributions Suppression per Week",
// "Total Contributions: Addition" => "Total Contributions: Addition",
// "Total Contributions: Suppression" => "Total Contributions: Suppression",
// "Groups Contributions: Addition" => "Groups Contributions: Addition",
// "Groups Contributions: Suppression" => "Groups Contributions: Suppression",
// "white" => "white",
// "gray" => "gray",
// "silver" => "silver",
// "ivory" => "ivory",
// "whitesmoke" => "whitesmoke",
// "beige" => "beige",
// "darkgrey" => "darkgrey",
// "Object doesn't exists" => "Object doesn't exists",
// "Click here to delete the category" => "Click here to delete the category",
// "You can not create a category with a name already existing at this level" => "You can not create a category with a name already existing at this level",
// "The file does not have the required header" => "The file does not have the required header",
// "No display" => "No display",
// "You must specify a directory" => "You must specify a directory",
// "moved %d images, %d errors occured" => "moved %d images, %d errors occured",
// "a timeout occured. Hit the reload button to move the rest" => "a timeout occured. Hit the reload button to move the rest",
// "Test Image" => "Test Image",
// "Path to mapfiles is invalid" => "Path to mapfiles is invalid",
// "Cannot create or update module: You need to specify a name to the module" => "Cannot create or update module: You need to specify a name to the module",
// "Cannot create or update module: You cannot leave the data field empty" => "Cannot create or update module: You cannot leave the data field empty",
// "Error opening uploaded file" => "Error opening uploaded file",
// "A comment in a wiki page is posted or edited" => "A comment in a wiki page is posted or edited",
// "You need to provide a username or an email" => "You need to provide a username or an email",
// "The list name must be specified" => "The list name must be specified",
// "Sorry, your list could not be added. Please check that it doesn\\'t already exist" => "Sorry, your list could not be added. Please check that it doesn\\'t already exist",
// "Sorry, your list could not be updated. Please check that it already exists" => "Sorry, your list could not be updated. Please check that it already exists",
// "off" => "off",
// "The \"Snarf Wikiplugin\" is activated. It can be used by wiki editors to include pages from the local network and via regex replacement create any html" => "The \"Snarf Wikiplugin\" is activated. It can be used by wiki editors to include pages from the local network and via regex replacement create any html",
// "The \"Regex Wikiplugin\" is activated. It can be used by wiki editors to create any html via regex replacement" => "The \"Regex Wikiplugin\" is activated. It can be used by wiki editors to create any html via regex replacement",
// "The \"Lsdir Wikiplugin\" is activated. It can be used by wiki editors to view the contents of any directory" => "The \"Lsdir Wikiplugin\" is activated. It can be used by wiki editors to view the contents of any directory",
// "The \"Bloglist Wikiplugin\" is activated. It can be used by wiki editors to disclose private blog posts" => "The \"Bloglist Wikiplugin\" is activated. It can be used by wiki editors to disclose private blog posts",
// "The \"iframe Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks" => "The \"iframe Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks",
// "The \"js Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc" => "The \"js Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc",
// "The \"JQ Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc" => "The \"JQ Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc",
// "The \"Redirect Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks" => "The \"Redirect Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks",
// "The \"Module Wikiplugin\" is activated. It can be used by wiki editors to add modules which permit to access information (see module list)" => "The \"Module Wikiplugin\" is activated. It can be used by wiki editors to add modules which permit to access information (see module list)",
// "The \"Userlist Wikiplugin\" is activated. It can be used by wiki editors to display the list of users" => "The \"Userlist Wikiplugin\" is activated. It can be used by wiki editors to display the list of users",
// "The \"Usercount Wikiplugin\" is activated. It can be used by wiki editors to display a count of the number of users" => "The \"Usercount Wikiplugin\" is activated. It can be used by wiki editors to display a count of the number of users",
// "The \"SQL Wikiplugin\" is activated. It can be used by wiki editors to execute SQL commands" => "The \"SQL Wikiplugin\" is activated. It can be used by wiki editors to execute SQL commands",
// "Are you sure you want to delete this custom tool" => "Are you sure you want to delete this custom tool",
// "JavaScript is required for this page" => "JavaScript is required for this page",
// "Are you sure you want to remove this topic" => "Are you sure you want to remove this topic",
// "Are you sure you want to remove this topic AND all the articles related" => "Are you sure you want to remove this topic AND all the articles related",
// "Tracker does not allow attachments" => "Tracker does not allow attachments",
// "Remove group: " => "Remove group: ",
// "Remove permission: %s on %s" => "Remove permission: %s on %s",
// "Group name can not be empty" => "Group name can not be empty",
// "The description is mandatory as it is used as mail subject" => "The description is mandatory as it is used as mail subject",
// "Invalid or unknown email" => "Invalid or unknown email",
// "User login or email is required" => "User login or email is required",
// "User does not exist on master" => "User does not exist on master",
// "Email validation requested but email address not set" => "Email validation requested but email address not set",
// "Password not set" => "Password not set",
// "User login contains invalid characters" => "User login contains invalid characters",
// "Deleted account %s" => "Deleted account %s",
// "%s %s assigned to %s %s" => "%s %s assigned to %s %s",
// "group %s set as the default group of user %s" => "group %s set as the default group of user %s",
// "Login contains invalid characters" => "Login contains invalid characters",
// "approved by " => "approved by ",
// "This function is only for staging pages" => "This function is only for staging pages",
// "Permission denied you cannot approve staging pages" => "Permission denied you cannot approve staging pages",
// "Approved page was last saved after most recent staging edit" => "Approved page was last saved after most recent staging edit",
// "Unassign perm %s from group %s" => "Unassign perm %s from group %s",
// "File Galleries Admin Panel" => "File Galleries Admin Panel",
// "Could not read file %s" => "Could not read file %s",
// "Could not write to file %s" => "Could not write to file %s",
// "File %s upload failed" => "File %s upload failed",
// "Upload was successful" => "Upload was successful",
// "File %s removed from Batch directory" => "File %s removed from Batch directory",
// "Impossible to remove file %s from Batch directory" => "Impossible to remove file %s from Batch directory",
// "Incorrect directory chosen for batch upload of files" => "Incorrect directory chosen for batch upload of files",
// "Last modifications to the blog" => "Last modifications to the blog",
// "Nothing tagged yet" => "Nothing tagged yet",
// "You must clear your browser cache" => "You must clear your browser cache",
// "You need to <a href=\"tiki-admin_calendars.php\">create a calendar</a>" => "You need to <a href=\"tiki-admin_calendars.php\">create a calendar</a>",
// "Calendar event : " => "Calendar event : ",
// "Permission denied you can not view this page" => "Permission denied you can not view this page",
// "Mo" => "Mo",
// "Tu" => "Tu",
// "We" => "We",
// "Th" => "Th",
// "Fr" => "Fr",
// "Sa" => "Sa",
// "Su" => "Su",
// "Invalid old password or unknown user" => "Invalid old password or unknown user",
// "Invalid request. Expecting channels array" => "Invalid request. Expecting channels array",
// "Missing channel name" => "Missing channel name",
// "Authentication required" => "Authentication required",
// "One of the requested channels cannot be requested. It does not exist or permission is denied" => "One of the requested channels cannot be requested. It does not exist or permission is denied",
// "One of the install profiles could not be obtained" => "One of the install profiles could not be obtained",
// "This feature is disabled'.\$prefs['validateUsers']));\n\t\$smarty->display('error.tpl" => "This feature is disabled'.\$prefs['validateUsers']));\n\t\$smarty->display('error.tpl",
// "Problem. Try to log in again to receive new confirmation instructions" => "Problem. Try to log in again to receive new confirmation instructions",
// "ERROR: you must include a subject or a message. You must also make sure to have a valid e-mail in the FROM field" => "ERROR: you must include a subject or a message. You must also make sure to have a valid e-mail in the FROM field",
// "Last sites of directory \" . \$rc[\"name\"] . \" " => "Last sites of directory \" . \$rc[\"name\"] . \" ",
// "You cannot download this file right now. Your score is low or file limit was reached" => "You cannot download this file right now. Your score is low or file limit was reached",
// "Error : The file %s doesn't exist" => "Error : The file %s doesn't exist",
// "Page is a staging copy. Translation must begin from the approved copy" => "Page is a staging copy. Translation must begin from the approved copy",
// "Translation of this page is incomplete" => "Translation of this page is incomplete",
// "Not enable for this type of object" => "Not enable for this type of object",
// "Override lock and carry on with edit" => "Override lock and carry on with edit",
// "Page is currently being edited" => "Page is currently being edited",
// "This page is being edited by " => "This page is being edited by ",
// "Please check with the user before editing the page,\n\t\t\totherwise the changes will be stored as two separate versions in the history and\n\t\t\tyou will have to manually merge them later. " => "Please check with the user before editing the page,\n\t\t\totherwise the changes will be stored as two separate versions in the history and\n\t\t\tyou will have to manually merge them later. ",
// "The file you selected is too large to upload" => "The file you selected is too large to upload",
// "Incorrect file extension was used for your 0gg screencast, expecting .ogg" => "Incorrect file extension was used for your 0gg screencast, expecting .ogg",
// "Page already exists. Go back and choose a different name" => "Page already exists. Go back and choose a different name",
// "The translation set already contains a page in this language" => "The translation set already contains a page in this language",
// "Remove archive: " => "Remove archive: ",
// "Remove file gallery: " => "Remove file gallery: ",
// "Form error - no import method selected for some reason" => "Form error - no import method selected for some reason",
// "Form error - no server-side filename entered for selected import method" => "Form error - no server-side filename entered for selected import method",
// "Last replied forum topics" => "Last replied forum topics",
// "Not supported yet" => "Not supported yet",
// "Canceled friendship request with %s" => "Canceled friendship request with %s",
// "I have refused your friendship request" => "I have refused your friendship request",
// "I have canceled my friendship request" => "I have canceled my friendship request",
// "Back to preferences" => "Back to preferences",
// "Back to item" => "Back to item",
// "Only the administrator can upload language files" => "Only the administrator can upload language files",
// "Operations executed successfully" => "Operations executed successfully",
// "Invalid software name" => "Invalid software name",
// "Page saved (version %d)" => "Page saved (version %d)",
// "You have requested that this page be machine translated" => "You have requested that this page be machine translated",
// "However, the Machine Translation feature is not enabled. Please enable this feature, or ask a site admin to do it" => "However, the Machine Translation feature is not enabled. Please enable this feature, or ask a site admin to do it",
// "Error writing in the databse: \$query" => "Error writing in the databse: \$query",
// "Permission denied: You cannot upload videos" => "Permission denied: You cannot upload videos",
// "You need to set your Kaltura account details: " => "You need to set your Kaltura account details: ",
// "Could not establish Kaltura session. Try again" => "Could not establish Kaltura session. Try again",
// "Permission denied: You cannot remix videos" => "Permission denied: You cannot remix videos",
// "Permission denied: You cannot change video version" => "Permission denied: You cannot change video version",
// "Permission denied: You cannot delete kaltura video" => "Permission denied: You cannot delete kaltura video",
// "Permission denied: You cannot download kaltura video" => "Permission denied: You cannot download kaltura video",
// "Permission denied: You cannot edit video information" => "Permission denied: You cannot edit video information",
// "Permission denied: You cannot view video" => "Permission denied: You cannot view video",
// "Delete comments" => "Delete comments",
// "Approved Status" => "Approved Status",
// "Queued" => "Queued",
// "The file is already locked by %s" => "The file is already locked by %s",
// "Remove file: " => "Remove file: ",
// "Quota too big" => "Quota too big",
// "Quota too small" => "Quota too small",
// "Warning: Empty file" => "Warning: Empty file",
// "Please re-upload your file" => "Please re-upload your file",
// "Permission denied you can edit this file" => "Permission denied you can edit this file",
// "Cannot read the file" => "Cannot read the file",
// "Upload was not successful. Duplicate file content" => "Upload was not successful. Duplicate file content",
// "Permission denied: You cannot view this page" => "Permission denied: You cannot view this page",
// "Invalid action" => "Invalid action",
// "Unable to create login" => "Unable to create login",
// "More than %d unsuccessful login attempts have been made" => "More than %d unsuccessful login attempts have been made",
// "An email has been sent to you with the instructions to follow" => "An email has been sent to you with the instructions to follow",
// "Resend" => "Resend",
// "You should have received an email. Check your mailbox and your spam box.Otherwise click on the button to resend the email" => "You should have received an email. Check your mailbox and your spam box.Otherwise click on the button to resend the email",
// "Your default nickname is already in use. A new one has to be selected" => "Your default nickname is already in use. A new one has to be selected",
// "The selected account is not associated with your identity" => "The selected account is not associated with your identity",
// "unknown action" => "unknown action",
// "Authentication method is not OpenID" => "Authentication method is not OpenID",
// "Invalid password" => "Invalid password",
// "Account disabled" => "Account disabled",
// "You must use the right case for your user name" => "You must use the right case for your user name",
// "Feature Ajax Disabled. Please ask your site administrator to enable" => "Feature Ajax Disabled. Please ask your site administrator to enable",
// "You must first setup MapServer" => "You must first setup MapServer",
// "invalid mapfile name" => "invalid mapfile name",
// "An error as occured with the mapfile" => "An error as occured with the mapfile",
// "Please create a directory named ' . \$prefs['map_path'] . ' to hold your map files" => "Please create a directory named ' . \$prefs['map_path'] . ' to hold your map files",
// "map edit" => "map edit",
// "No page provided" => "No page provided",
// "Page \"%0\" does not exist" => "Page \"%0\" does not exist",
// "Are you sure you want to delete this note" => "Are you sure you want to delete this note",
// "Note not found" => "Note not found",
// "Permission denied you cannot assign permissions for this object" => "Permission denied you cannot assign permissions for this object",
// "Permission denied you cannot view the source of this page" => "Permission denied you cannot view the source of this page",
// "Missing object list type argument" => "Missing object list type argument",
// "Index" => "Index",
// "Index (' . \$code . " => "Index (' . \$code . ",
// "You are already logged in" => "You are already logged in",
// "You must choose a group" => "You must choose a group",
// "This is not a valid mail adress" => "This is not a valid mail adress",
// "Username cannot contain uppercase letters" => "Username cannot contain uppercase letters",
// "Username must be at least" => "Username must be at least",
// "Username cannot contain more than" => "Username cannot contain more than",
// "characters" => "characters",
// "Please enter a valid %s.  No spaces, more than %d characters and contain %s" => "Please enter a valid %s.  No spaces, more than %d characters and contain %s",
// "Missing User Name" => "Missing User Name",
// "User Already Exists" => "User Already Exists",
// "Valid User Name" => "Valid User Name",
// "Missing Email" => "Missing Email",
// "Valid Email" => "Valid Email",
// "Please contact the Administrator if you do not get the email, or if there is an issue with resetting the password" => "Please contact the Administrator if you do not get the email, or if there is an issue with resetting the password",
// "The mail can't be sent. Contact the administrator" => "The mail can't be sent. Contact the administrator",
// "An email with a link to reset your password has been sent " => "An email with a link to reset your password has been sent ",
// "to the email" => "to the email",
// "You cannot rename staging pages. Please rename the approved page instead" => "You cannot rename staging pages. Please rename the approved page instead",
// "Cannot rename page because maybe new staging page name already exists" => "Cannot rename page because maybe new staging page name already exists",
// "A problem occured during file uploading" => "A problem occured during file uploading",
// "File which was causing trouble was at rank" => "File which was causing trouble was at rank",
// "The error was" => "The error was",
// "invalid email" => "invalid email",
// "Notice: this variable may not be empty" => "Notice: this variable may not be empty",
// "Notice: invalid variable value" => "Notice: invalid variable value",
// "Permission denied you cannot remove this sheet" => "Permission denied you cannot remove this sheet",
// "You do not have permission to edit messages \$owner" => "You do not have permission to edit messages \$owner",
// "Clean the sql logs" => "Clean the sql logs",
// "Report to the webmaster" => "Report to the webmaster",
// "You must lock the file before editing it" => "You must lock the file before editing it",
// "Batch file processed" => "Batch file processed",
// "Incorrect file extension" => "Incorrect file extension",
// "Your screencast has been uploaded successfully" => "Your screencast has been uploaded successfully",
// "Your screencasts have been uploaded successfully" => "Your screencasts have been uploaded successfully",
// "Password has been changed" => "Password has been changed",
// "Invalid password. Your current password is required to change administrative information" => "Invalid password. Your current password is required to change administrative information",
// "A new page is created in a language" => "A new page is created in a language",
// "Language watch" => "Language watch",
// "Permission denied: you cannot view this blog post while it is marked private" => "Permission denied: you cannot view this blog post while it is marked private",
// "You must suggest a question; please try again" => "You must suggest a question; please try again",
// "Incorrect thread" => "Incorrect thread",
// "There are a problem connecting to that account" => "There are a problem connecting to that account",
// "There are a problem deleting that mail" => "There are a problem deleting that mail",
// "Mail ID" => "Mail ID",
// "There are a problem deleting mails" => "There are a problem deleting mails",
// "Are you sure you want to delete this account" => "Are you sure you want to delete this account",
// "Taking" => "Taking",
// "Putting back" => "Putting back",
// "Checking" => "Checking",
// "Plugin modified by editor" => "Plugin modified by editor",
// "Tidy Extension not present" => "Tidy Extension not present",
// "The TikiTests Replay File is Empty" => "The TikiTests Replay File is Empty",
// "The TikiTests Replay File has an error" => "The TikiTests Replay File has an error",
// "You are about to delete a TikiTest file, do you want to continue " => "You are about to delete a TikiTest file, do you want to continue ",
// "Error deleting the file" => "Error deleting the file",
// "TikiTest List" => "TikiTest List",
// "TikiTest Record" => "TikiTest Record",
// "You need one of the extension pecl HTTP or Curl to replay the TikiTest" => "You need one of the extension pecl HTTP or Curl to replay the TikiTest",
// "The TikiTest Replay File is Empty" => "The TikiTest Replay File is Empty",
// "TikiTest Replay" => "TikiTest Replay",
// "The page is empty" => "The page is empty",
// ### end of untranslated words
// ###

// ###
// ### start of possibly untranslated words
// ###

"ID" => "ID",
"Algeria" => "Algeria",
"Angola" => "Angola",
"Antigua" => "Antigua",
"Armenia" => "Armenia",
"Australia" => "Australia",
"Bahrain" => "Bahrain",
"Bangladesh" => "Bangladesh",
"Barbados" => "Barbados",
"Belarus" => "Belarus",
"Bermuda" => "Bermuda",
"Bolivia" => "Bolivia",
"Brunei" => "Brunei",
"Bulgaria" => "Bulgaria",
"Chile" => "Chile",
"Colombia" => "Colombia",
"Fiji" => "Fiji",
"Guatemala" => "Guatemala",
"Haiti" => "Haiti",
"Honduras" => "Honduras",
"Indonesia" => "Indonesia",
"Iran" => "Iran",
"Israel" => "Israel",
"Kazakstan" => "Kazakstan",
"Kiribati" => "Kiribati",
"Kuwait" => "Kuwait",
"Latvia" => "Latvia",
"Luxemburg" => "Luxemburg",
"Malawi" => "Malawi",
"Malta" => "Malta",
"Mauritius" => "Mauritius",
"Nauru" => "Nauru",
"Nicaragua" => "Nicaragua",
"Nigeria" => "Nigeria",
"Niue" => "Niue",
"Pakistan" => "Pakistan",
"Panama" => "Panama",
"Peru" => "Peru",
"Romania" => "Romania",
"Samoa" => "Samoa",
"Singapore" => "Singapore",
"Slovakia" => "Slovakia",
"Slovenia" => "Slovenia",
"Somalia" => "Somalia",
"Surinam" => "Surinam",
"Taiwan" => "Taiwan",
"Tonga" => "Tonga",
"Tuvalu" => "Tuvalu",
"Vanuatu" => "Vanuatu",
"Venezuela" => "Venezuela",
"Wales" => "Wales",
"Zambia" => "Zambia",
"Zimbabwe" => "Zimbabwe",
"Pijin Solomon" => "Pijin Solomon",
"CAS (Central Authentication Service)" => "CAS (Central Authentication Service)",
"1" => "1",
"2" => "2",
"3" => "3",
"4" => "4",
"5" => "5",
"Copyright" => "Copyright",
"Mobile" => "Mobile",
"Intertiki" => "Intertiki",
"XMLRPC API" => "XMLRPC API",
"Debugger Console" => "Debugger Console",
"Mb" => "Mb",
"Top" => "Top",
"min" => "min",
"km" => "km",
"index" => "index",
"max" => "max",
"url" => "url",
"(AT)" => "(AT)",
"(DOT)" => "(DOT)",
"Info" => "Info",
"URL" => "URL",
"%" => "%",
"Pop-up" => "Pop-up",
"Url" => "Url",
"Id" => "Id",
", " => ", ",
"id" => "id",
"debug" => "debug",
"Tiki Debugger Console" => "Tiki Debugger Console",
"RSS Wiki" => "RSS Wiki",
"Hi," => "Hi,",
"Hi" => "Hi",
"Bye bye!" => "Bye bye!",
"Ip" => "Ip",
"[-]" => "[-]",
"URI" => "URI",
"InterTiki" => "InterTiki",
"IP" => "IP",
"LDAP" => "LDAP",
"URL:" => "URL:",
"PAM" => "PAM",
"dls" => "dls",
"MultiPrint" => "MultiPrint",
"phpinfo" => "phpinfo",
"DSN" => "DSN",
"bytes" => "bytes",
"x" => "x",
"h" => "h",
"CMS" => "CMS",
"Regex" => "Regex",
"mn" => "mn",
"Alias" => "Alias",
"Tbl vis" => "Tbl vis",
"Powered by" => "Powered by",
"Wiki RSS" => "Wiki RSS",
"RSS" => "RSS",
"popup" => "popup",
"+" => "+",
"%m/%d" => "%m/%d",
"Sun" => "Sun",
"idea" => "idea",
"v" => "v",
"Top 10" => "Top 10",
"Top 20" => "Top 20",
"Top 50" => "Top 50",
"Top 100" => "Top 100",
"tikiwiki.org" => "tikiwiki.org",
"#" => "#",
"%m/%d/%Y [%H:%M]" => "%m/%d/%Y [%H:%M]",
"Pos" => "Pos",
"sun" => "sun",
"TOP" => "TOP",
"%H:%M %Z" => "%H:%M %Z",
"unicode" => "unicode",
// ###
// ### end of possibly untranslated words
// ###

"This feature is disabled" => "Tämä ominaisuus ei ole käytössä",
"Permission denied. You cannot view pages" => "Oikeutesi eivät riitä katsomaan sivuja",
"Re:" => "Vast:",
"This script cannot be called directly" => "Tätä merkkijonoa ei voi kutsua suoraan",
"The copyright management feature is not enabled." => "Copyright hallintaominaisuus ei ole käytössä.",
"No page indicated" => "Ei sivua osoitettu",
"You must supply all the information, including title and year." => "On lisättävä kaikki tieto, myös otsikko ja vuosi.",
"You do not have permission to use this feature" => "Oikeutesi eivät riitä käyttämääm tätä ominaisuutta",
"This feature is for admins only" => "Tämä ominaisuus on vain ylläpidolle",
"Type" => "Tyyppi",
"Name" => "Nimi",
"Description" => "Kuvaus",
"Size" => "Koko",
"Created" => "Luotu",
"Last Modified" => "Viimeksi muokannut",
"Creator" => "Luonut",
"Author" => "Kirjoittaja",
"Last editor" => "Viimeksi muokannut",
"Comment" => "Kommentti",
"Files" => "Tiedostot",
"Hits" => "Osumia",
"Locked by" => "Lukitsijana",
"Path" => "Polku",
"American Samoa" => "Amerikan_Samoa",
"Argentina" => "Argentiina",
"Austria" => "Itävalta",
"Bahamas" => "Bahama",
"Belgium" => "Belgia",
"Brazil" => "Brasilia",
"Canada" => "Kanada",
"Catalan Countries" => "Catalan_Countries",
"Cayman Islands" => "Cayman_Saaret",
"China" => "Kiina",
"Cook Islands" => "Cook_Saaret",
"Costa Rica" => "Costa_Rica",
"Croatia" => "Kroatia",
"Cuba" => "Kuuba",
"Cyprus" => "Kypros",
"Czech Republic" => "Tsekin_Tasavalta",
"Denmark" => "Tanska",
"Dominican Republic" => "Dominikaaninen_Tasavalta",
"Ecuador" => "Ekuadori",
"Egypt" => "Egypti",
"El Salvador" => "El_Salvador",
"Estonia" => "Eesti",
"Federated States of Micronesia" => "Federated_States_of_Micronesia",
"Finland" => "Suomi",
"France" => "Ranska",
"French Polynesia" => "Ranskan_Polynesia",
"Germany" => "Saksa",
"Greece" => "Kreikka",
"Guam" => "Guami",
"Hungary" => "Unkari",
"Iceland" => "Islanti",
"India" => "Intia",
"Iraq" => "Irak",
"Ireland" => "Irlanti",
"Italy" => "Italia",
"Ivory Coast" => "Norsunluu_Rannikko",
"Jamaica" => "Jamaika",
"Japan" => "Japani",
"Jordan" => "Jordania",
"Kenya" => "Kenia",
"Lebanon" => "Libanon",
"Lithuania" => "Liettua",
"Malaysia" => "Malesia",
"Marshall Islands" => "Marshall_Saaret",
"Mexico" => "Mexiko",
"Morocco" => "Marocco",
"Mozambique" => "Mozambiq",
"Nepal" => "Nepali",
"Netherlands" => "Alankomaat",
"New Caledonia" => "Uusi_Kaledonia",
"New Zealand" => "Uusi_Seelanti",
"None" => "EiMitään",
"Norway" => "Norja",
"Other" => "Muu",
"Papua New Guinea" => "Papua_Uusi_Ginea",
"Paraguay" => "Paraguai",
"Poland" => "Puola",
"Portugal" => "Portugali",
"Puerto Rico" => "Puerto_Rico",
"Quatar" => "Qatari",
"Russia" => "Venäjä",
"Saudi Arabia" => "Saudi_Arabia",
"Solomon Islands" => "Salomon_Saaret",
"South Africa" => "Etelä_Afrikka",
"South Korea" => "Etelä_Korea",
"Spain" => "Espanja",
"Sri Lanka" => "Sri_Lanka",
"St Vincent Grenadines" => "St_Vincent_Grenadiinit",
"Sweden" => "Ruotsi",
"Switzerland" => "Sveitsi",
"Thailand" => "Thaimaa",
"Trinidad Tobago" => "Trinidad_Tobago",
"Turkey" => "Turkki",
"Ukraine" => "Ukraina",
"United Arab Emirates" => "Yhdistyneet_Arab_Emiraatit",
"United Kingdom" => "Yhdistynyt_Kuningaskunta",
"United States" => "Yhdysvallat",
"Uruguay" => "Uruguai",
"Yugoslavia" => "Jugoslavia",
"Arabic" => "Arabia",
"Catalan" => "Katalonia",
"Simplified Chinese" => "Yksinkertaistettu Kiina",
"Chinese" => "Kiina",
"Czech" => "Tsekki",
"Danish" => "Tanska",
"German" => "Saksa",
"English" => "Englanti",
"English British" => "Brittiläinen Englanti",
"Spanish" => "Espanja",
"Greek" => "Kreikka",
"Finnish" => "Suomi",
"French" => "Ranska",
"Hebrew" => "Hebrea",
"Croatian" => "Kroatialainen",
"Italian" => "Italia",
"Japanese" => "Japani",
"Korean" => "Korealainen",
"Hungarian" => "Unkarilainen",
"Dutch" => "Hollanti",
"Norwegian" => "Norja",
"Polish" => "Puola",
"Português" => "Portugalilainen",
"Brazilian Portuguese" => "Brazilian Portugali",
"Russian" => "Venäjä",
"Slovak" => "Slovakia",
"Serbian" => "Serbia",
"Serbian Latin" => "Serbian Latino",
"Swedish" => "Ruotsi",
"Tuvaluan" => "Tuvalualainen",
"Traditional Chinese" => "Perinteinen Kiina",
"Ukrainian" => "Ukrainalainen",
"Permission denied" => "Lupa evätty",
"The file is not a CSV file or has not a correct syntax" => "Tiedosto ei ole CSV tai parametrit ovat väärin",
"locked" => "lukittu",
"locked by" => "lukitsijana",
"Administration:" => "Ylläpito:",
"in" => "sisään",
"continued" => "jatkuu",
"New Image Uploaded by" => "Uuden kuvan lähettäjä",
"New Subscriptions" => "Uudet tilaukset",
"New Item in Tracker" => "Uusi osa kortistossa",
"tracker" => "kortisto",
"by" => " ",
"Wiki" => "Sivusto",
"Image Gallery" => "Kuva Galleria",
"Articles" => "Artikkelit",
"Blogs" => "Blogit",
"Forums" => "Foorumit",
"Directory" => "Hakemisto",
"File Gallery" => "Tiedosto Galleria",
"FAQs" => "UKK:t",
"Quizzes" => "Visailut",
"Trackers" => "Kortistot",
"Survey" => "Tutkimukset",
"Newsletter" => "Uutislehti",
"article" => "artikkeli",
"blog" => "blogi",
"directory" => "hakemisto",
"faq" => "ukk",
"file gallery" => "tiedosto galleria",
"forum" => "foorumi",
"image gallery" => "kuva galleria",
"newsletter" => "uutiskirja",
"poll" => "äänestys",
"quiz" => "visailu",
"survey" => "tutkimus",
"wiki page" => "sivu",
"image" => "kuva",
"calendar" => "kalenteri",
"Invalid filename (using filters for filenames)" => "Väärä tiedostonimi (käyttäen suodinta tiedostonimissä)",
"Cannot upload this file - maximum upload size exceeded" => "Et voi lähettää tiedostoa, maximi lähetyskoko ylittyy",
"Anonymous" => "Nimetön",
"You have mistyped the anti-bot verification code; please try again." => "Sinulla on kirjoitusvirhe anti-bot varmistus koodissa; yritä uudelleen.",
"Wrong password. Cannot post comment" => "Väärä salasana. Et voi lähettää kommenttia",
"You have to enter a title and text" => "Kirjoita otsikko ja teksti",
"WikiDiff::apply: line count mismatch: %s != %s" => "Diff::lisää: rivilaskuri sopimaton: %s != %s",
"WikiDiff::_check: failed" => "Diff::_tarkistus: epäonnistui",
"WikiDiff::_check: edit sequence is non-optimal" => "Diff::_tarkistus: muokkaus järjestys ei optimaalinen",
"WikiDiff Okay: LCS = %s" => "Diff Okei: LCS = %s",
"Line:" => "Viiva:",
"Lines:" => "Viivat:",
"Find" => "Etsi",
"find" => "löytyi",
"prev" => "edellinen",
"Page" => "Sivu",
"next" => "seuraava",
"Link" => "Linkki",
"Page name" => "Sivun nimi",
"File Galleries" => "Tiedosto Galleriat",
"Wiki Home" => "EtuSivu",
"Home" => "Etusivu",
"Blog" => "Blogi",
"previous page" => "edellinen sivu",
"next page" => "seuraava sivu",
"posted on" => "lähettänyt",
"Continue" => "Jatkuu",
"By:" => " :",
"Read" => "Lukijaa",
"List articles" => "Listaa artikkelit",
"Last post" => "Viimeiset lähetykset",
"Invalid imagename (using filters for filenames)" => "Väärä kuvanimi (käyttäen suodinta tiedostonimissä)",
"Errors detected" => "Virheitä havaittu",
"Upload was not successful" => "Lähetys ei onnistunut",
"No image yet, sorry." => "Ei kuvaa vielä, valitan.",
"No valid ogr2ogr executable" => "Ei hyväksyttävä ogr2ogr ohjelma",
"Could not create \$tdo.mif in data directory" => "Ei voi luoda \$tdo.mif tietohakemistoon",
"Could not create \$tdo.mid in data directory" => "Ei voi luoda \$tdo.mid tietohakemistoon",
"unknown" => "tuntematon",
"User Map Generated in:" => "Käyttäjäkartta muodostettu:",
"Image Map Generated in:" => "Kuvakartta muodostettu:",
"NONE" => "EIMITÄÄN",
"File %s not found" => "Tiedostoa %s ei löydy",
"File %s is not a valid archive" => "Tiedosto %s ei ole arkistoitavissa",
"Impossible to open %s : %s" => "Mahdoton aukaista %s : %s",
"Language" => "Kieli",
"Section" => "Osasto",
"Theme" => "Teema",
"Rows" => "Rivejä",
"This poll is closed." => "Tämä äänestys on suljettu.",
"Title" => "Otsikko",
"Topic" => "Aihe",
"Visible" => "Näkyvä",
"Rating" => "Arvostus",
"Reads" => "Lukijaa",
"Images" => "Kuvat",
"Newest first" => "Uusin ensimmäiseksi",
"Oldest first" => "Vanhin ensimmäiseksi",
"Points" => "Pisteet",
"Authentication method" => "Varmennus menetelmä",
"Tiki and PAM" => "Tiki ja PAM",
"Web Server" => "Web Palvelin",
"Creation date (desc)" => "Luontipäivä (aleneva)",
"Last modification date (desc)" => "Viimeisin muokkaus päivä (aleneva)",
"Blog title (asc)" => "Blogin aihe (nouseva)",
"Number of posts (desc)" => "Lähetysten määrä (aleneva)",
"Visits (desc)" => "Vierailuja (aleneva)",
"Activity (desc)" => "Aktiivisuus (aleneva)",
"Disabled" => "Poistettu",
"Plain text" => "Tavallinen teksti",
"Link to user information" => "Linkki käyttäjä tietoihin",
"User avatar" => "Käytä Hahmoa",
"Contact user" => "Ota yhteys käyttäjään",
"Count admin pageviews" => "Laske ylläpidon sivunäytöt",
"default mapfile" => "oletus karttatiedosto",
"Validate URLs" => "Tarkista URL:it",
"Links per page" => "Linkkiä per sivu",
"Method to open directory links" => "Menetelmä avataksesi hakemisto linkkejä",
"replace current window" => "korvaa nykyinen ikkuna",
"new window" => "uusi ikkuna",
"inline frame" => "sisäinen kehys",
"No error reporting" => "Ei virhe raportointia",
"Report all PHP errors" => "Raportoi kaikki PHP virheet",
"Default number of comments per page" => "Oletus määrä kommentteja per sivu",
"Comments default ordering" => "Kommenttien oletus järjestys",
"Polls" => "Äänestykset",
"Newsletters" => "Uutiskirje",
"Calendar" => "Kalenteri",
"Banners" => "Bannerit",
"Category" => "Luokka",
"Score" => "Pisteytys",
"Search" => "Etsi",
"Multilingual" => "Monikielinen",
"FAQ" => "UKK",
"Surveys" => "Tutkimukset",
"Featured links" => "Ominaisuus linkit",
"Shoutbox" => "Pikaviestin",
"Maps" => "Kartat",
"Live support system" => "Elävä tuki systeemi",
"Contact Us" => "Ota Yhteyttä",
"PHPLayers" => "PHPTasot",
"Webmail" => "Verkkoposti",
"Mail-in" => "Posti-sisään",
"Wysiwyg editor" => "Wysiwyg muokkain",
"Friendship Network" => "Ystävä Verkosto",
"Banning system" => "Esto järjestelmä",
"Stats" => "Tilastot",
"Referer Stats" => "Suositus Tilastot",
"Redirect On Error" => "Uudelleen suuntaa virheet",
"Communications (send/receive objects)" => "Yhteistoiminta (lähetä/vastaanota kohteita)",
"Custom Home" => "Muunneltu Koti",
"Mini Calendar" => "Mini Kalenteri",
"User Preferences Screen" => "Käyttäjän Asetusnäyttö",
"User Notepad" => "Käyttäjän Muistio",
"User Bookmarks" => "Käyttäjän Kirjanmerkit",
"User Watches" => "Käyttäjän Vahdit",
"User Watches Translations" => "Käyttäjä Vahtien Käännökset",
"User Menu" => "Käyttäjän Valikko",
"User Tasks" => "Käyttäjän Tehtävät",
"User Messages" => "Käyttäjän Viestit",
"User Files" => "Käyttäjän Tiedostot",
"Integrator" => "Yhdistäjä",
"Protect against CSRF with a ticket" => "Suojele CSRF:ta vastaan lipulla",
"Detect browser language" => "Katso selaimen kieli",
"Help System" => "Avuste Systeemi",
"Smileys" => "Hymiöt",
"Dynamic Content System" => "Muuttuvan Sisällön Systeemi",
"Display menus as folders" => "Näytä valikot kansioina",
"Activate" => "Aktivoi",
"Comments" => "Kommentit",
"Search and replace" => "Etsi ja korvaa",
"Submissions" => "Ehdotukset",
"Rankings" => "Arvostukset",
"Content templates" => "Sisältö mallit",
"Print" => "Tulosta",
"Ignore category viewing restrictions" => "Älä huomio luokittelunäytön rajoituksia",
"Local" => "Paikallinen",
"List pages" => "Sivu listaus",
"Last changes" => "Viimeiset muutokset",
"Orphan pages" => "Yksinäiset sivut",
"Referer Search Highlighting" => "Etsintä Viittausten Korostus",
"Search stats" => "Etsintä tilastot",
"Ignore individual object permissions" => "Älä huomio yksittäisen kohteen oikeuksia",
"Visits" => "Vierailut",
"Accept wiki syntax" => "Hyväksy syntaksi",
"Allow same file to be uploaded more than once" => "Sallii saman tiedoston lähetyksen useammin kuin kerran",
"Never" => "EiKoskaan",
"Uploaded filenames must match regex" => "Lähetettyjen tiedostojen nimien täytyy sopia yhteen regex kanssa",
"Plain" => "Tavallinen",
"Threaded" => "Ketjutettu",
"Headers Only" => "Vain Pääosat",
"Title (desc)" => "Otsikko (aleneva)",
"Title (asc)" => "Otsikko (nouseva)",
"Topics" => "Aiheet",
"Posts" => "Lähetyksiä",
"Posts per day" => "Lähetystä päivässä",
"Creation Date (desc)" => "Luonti Päivä (aleneva)",
"Topics (desc)" => "Aiheet (aleneva)",
"Threads (desc)" => "Ketjut (aleneva)",
"Last post (desc)" => "Viimeiset lähetykset (aleneva)",
"Name (desc)" => "Nimi (aleneva)",
"Name (asc)" => "Nimi (nouseva)",
"Browser title" => "Selain otsikko",
"Home page" => "EtuSivu",
"Use group homepages" => "Käytä ryhmä etusivuja",
"Go to group homepage only if login from default homepage" => "Mene ryhmä etusivulle vain jos kirjautuminen tapahtuu oletus etusivulle",
"Temporary directory" => "Väliaikainen hakemisto",
"Help URL" => "Apu URL",
"Open external links in new window" => "Avaa ulkoiset linkit uuteen ikkunaan",
"Full path to gdaltindex" => "Koko polku gdaltindexiin",
"Full path to ogr2ogr" => "Koko polku ogr2ogr",
"Map Zone" => "Kartta Vyöhyke",
"Display modules to all groups always" => "Näyttää kaikki moduulit kaikille ryhmille aina",
"Hide anonymous-only modules from registered users" => "Piilota nimettömien moduulit rekisteröityneiltä käyttäjiltä",
"Content" => "Sisältö",
"Use database for translation" => "Käytä tietokantaa käännökseen",
"full path to mapfiles" => "täydellinen polku karttatiedostoihin",
"Wiki Page for Help" => "Apu Sivu",
"Wiki Page for Comments" => "Sivu kommenteille",
"Maximum mailbox size (messages, 0=unlimited)" => "Postilaatikon suurin koko (viestiä, 0=rajoittamaton)",
"Maximum mail archive size (messages, 0=unlimited)" => "Arkiston suurin koko (viestiä, 0=rajoittamaton)",
"Maximum sent box size (messages, 0=unlimited)" => "Lähetyslaatikon suurin koko (viestiä, 0=rajoittamaton)",
"geo.position" => "geo.sijainti",
"geo.region" => "geo.alue",
"geo.placename" => "geo.paikkanimi",
"Bottom" => "Alaosa",
"Port" => "Portti",
"Proxy port" => "Proxy portti",
"Record untranslated strings" => "Tallenne kääntämättä",
"Normal" => "Normaali",
"Refresh rate" => "Päivitys väli",
"Minimum length of search word" => "Etsittävän sanan minimi pituus",
"Max. number of words containing a syllable" => "´Maksimi määrä sanoja sisältäen tavuja",
"Max. age in hours of syllable search cache" => "Maksimi ikä tunteina tavutus etsinnän puskurille",
"LRU list purging rate" => "LRU listaa tyhjennys välit",
"LRU list length" => "LRU listan pituus",
"Database" => "Tietokanta",
"After" => "Jälkeen",
"Before" => "Ennen",
"Publish" => "Julkaise",
"Use proxy" => "Käytä proxyä",
"Allow viewing HTML mails?" => "Salli HTML lähetysten näyttäminen?",
"Maximum size for each attachment" => "Jokaisen liitteen maksimi koko",
"Unlimited" => "Rajoittamaton",
"Complete" => "Valmis",
"Business style" => "Bisnes tyyli",
"Collaborative style" => "Yhteisöllinen tyyli",
"Page last modified on" => "Sivua viimeksi muutettu",
"Cache wiki pages (global)" => "Puskuroi sivut (yleinen)",
"no cache" => "ei puskuri",
"minute" => "minuutti",
"minutes" => "minuuttia",
"hour" => "tunti",
"hours" => "tuntia",
"Enable wiki 3D browser" => "Oikeuta 3D selain",
"Load page on navigation" => "Lataa navikointi sivu",
"Browser height" => "Selain korkeus",
"Navigation depth" => "Siirtymis syvyys",
"Node size" => "Solmun koko",
"Text size" => "Tekstin koko",
"Spring (connection) size" => "Lähteen (yhteys) koko",
"Existing page node color" => "Olemassa olevan sivun solmu väri",
"Missing page node color" => "Puuttuvan sivun solmu väri",
"Camera distance adjusted relative to nearest node" => "Kameran etäisyys annettu suhteellisesti lähimpään solmuun",
"Camera distance" => "Kameran etäisyys",
"Field of view" => "Näytön kenttä",
"Feed animation interval (milisecs)" => "Syötä animaation tauko (milisecs)",
"Friction constant" => "Pysyvä",
"Elastic constant" => "Joustava pysyvä",
"Eletrostatic constant" => "Sähköisesti pysyvä",
"Node mass" => "Solmun massa",
"Node charge" => "Solmun kulutus",
"Wiki top pages" => "Top sivut",
"Most relevant pages" => "Eniten asiaan kuuluvat sivut",
"Relevance" => "Asianmukainen",
"Wiki last pages" => "Viimeiset sivut",
"Modified" => "Muokattu",
"Forums last posts" => "Foorumin viime lähetykset",
"Topic date" => "Aihee päiväys",
"Forums most read topics" => "Foorumin eniten luetut aiheet",
"Forums best topics" => "Foorumin parhaat aiheet",
"Forums most visited forums" => "Luetuimmat foorumit",
"Forums with most posts" => "Vastatuimmat foorumit",
"Wiki top galleries" => "Top galleriat",
"Wiki top file galleries" => "Top tiedosto galleriat",
"Wiki top images" => "Top kuvat",
"Wiki top files" => "Top tiedostot",
"Downloads" => "Imuroinnit",
"Wiki last images" => "Viimeiset kuvat",
"Upload date" => "Lähetys päivä",
"Wiki last files" => "Viimeiset tiedostot",
"Wiki top articles" => "Top artikkelit",
"Most visited blogs" => "Luetuimmat blogit",
"Most active blogs" => "Aktiivisimmat blogit",
"Activity" => "Toiminto",
"Blogs last posts" => "Blogien viimeiset postit",
"Post date" => "Postitus päivä",
"Wiki top authors" => "Top kirjoittajat",
"Pages" => "Sivut",
"Top article authors" => "Top artikkelikirjoittajat",
"User already exists" => "Käyttäjä on jo olemassa",
"Wrong registration code" => "Väärä rekisteröinti koodi",
"Invalid username" => "Väärä käyttäjänimi",
"Username is too long" => "Käyttäjänimi liian pitkä",
"Username cannot contain whitespace" => "Käyttäjänimi ei voi sisältää sanavälejä",
"Wrong passcode. You need to know the passcode to register at this site" => "Väärä passikoodi, sinulla on oltava oikea passikoodi rekisteröityäksesi sivustolle",
"Invalid email address. You must enter a valid email address" => "Väärä sähköpostiosoite. On käytettävä voimassa olevaa sähköpostiosoitetta",
"The registration mail can't be sent. Contact the administrator" => "Rekisteröinti sähköpostia ei voida lähettää. Ota yhteys ylläpitoon",
"change" => "vaihda",
"Today" => "Tänään",
"and" => "ja",
"from" => "keneltä",
"replied" => "vastattu",
"Login" => "Kirjautuminen",
"See other users' profiles" => "Katso muiden käyttäjien profiileja",
"Have your profile seen" => "Voiko profiiliasi katsoa",
"Make friends" => "Ystävysty",
"Receive message" => "Vastaanota viesti",
"Send message" => "Lähetä viesti",
"Read an article" => "Lue artikkeli",
"Publish an article" => "Julkaise artikkeli",
"Have your article read" => "Onko artikkeliasi luettu",
"Create new file gallery" => "Luo uusi tiedosto galleria",
"Upload new file to gallery" => "Lähetä uusi tiedosto galleriaan",
"Download other user's file" => "Imuroi toisen käyttäjän tiedosto",
"Have your file downloaded" => "Onko tiedostoasi imuroitu",
"Create a new image gallery" => "Luo uusi kuva galleria",
"Upload new image to gallery" => "Lähetä uusi kuva galleriaan",
"See other users' galleries" => "Katso toisen käyttäjän galleriaa",
"See other users' images" => "Katso toisen käyttäjän kuvaa",
"Have your gallery seen by other users" => "Onko galleriaasi katsonut toinen käyttäjä",
"Have your image seen" => "Onko kuvaasi katsottu",
"Create new blog" => "Luo uusi blogi",
"Post in a blog" => "Postita blogiin",
"Read other users' blogs" => "Lue toisen käyttäjän blogia",
"Have your blog read" => "Onko blogiasi luettu",
"Create a new wiki page" => "Luo uusi sivu",
"Edit an existing page" => "Muokkaa olemassa olevaa sivua",
"Attach file" => "Liitä tiedosto",
"Gallery" => "Galleria",
"Image" => "Kuva",
"Forum" => "Foorumi",
"Article" => "Artikkeli",
"Blog post" => "Blogi lähetys",
"Tracker" => "Kortisto",
"Unknown" => "Tuntematon",
"Trackeritem" => "Kortistonosa",
"Directory category" => "Hakemisto luokittelu",
"Prev" => "Edel",
"Next" => "Seuraava",
"comment" => "kommentti",
"Click Here" => "Paina tästä",
"Edit Template" => "Muokkaa mallia",
"Hide" => "Piilota",
"help" => "auta",
"All" => "Kaikki",
"The text is" => "Teksti on",
"character(s) too long - please edit it." => "liikaa kirjaimia - muokkaa sitä.",
"Date Selector" => "Päivä Valitsin",
"Select All" => "Valitse kaikki",
"days" => "päivää",
"day" => "päivä",
"mins" => "min",
"secs" => "sek",
"done" => "tehty",
"Text cut here" => "Teksti katkaistaan tästä",
"Task" => "Tehtävä",
"for" => "varten",
"Priority" => "Ensisijaisuus",
"Start date:" => "Aloitus päivä:",
"End date:" => "Lopetus päivä:",
"Friend" => "Ystävä",
"Last seen on" => "Katsottu viimeksi",
"(idle for %s seconds)" => "(odottanut %s sekuntia)",
"User information - Click for more info" => "Käyttäjä tiedot - Painamalla lisää tietoa",
"More info about \$other_user" => "Lisää tietoa \$other_user",
"(idle for \$idletime seconds)" => "(odottanut \$idletime sekuntia)",
"Yes" => "Kyllä",
"No" => "Ei",
"First day of week: Sunday (its ID is 0) - translators you need to localize this string!" => "Viikon ensimmäinen päivä: Sunnuntai (sen ID on 0) - kääntäjät muuttakaa paikalliseksi!",
"Use this tree to copy the structure" => "Käytä tätä puuta kopioidaksesi rakenteen",
"created from structure" => "luotu rakenteesta",
"Table of contents" => "Sisällysluettelo",
"text" => "teksti",
"unknown error" => "tuntematon virhe",
"You are not logged in" => "Et ole kirjautunut sisään",
"Page cannot be found" => "Sivua ei löytynyt",
"Permission denied. You cannot view this section" => "Ei oikeutta katsoa tätä osastoa",
"Help" => "Auta",
"You are banned from" => "Sinut on poistettu",
"wiki" => "sivusto",
"img-g" => "kuva-g",
"file-g" => "tied-g",
"faqs" => "ukk:sta",
"quizzes" => "visailuista",
"arts" => "artik",
"blogs" => "blogeista",
"forums" => "foorumeilta",
"Click to edit dynamic variable" => "Paina muokataksesi dynaamista muuttujaa",
"Update variables" => "Päivitä muuttujat",
"Show" => "Näytä",
"sad" => "surullinen",
"confused" => "hämmentynyt",
"cool" => "siisti",
"mad" => "vihainen",
"%d points" => "%d pistettä",
"Removed" => "Poistettu",
"__WARNING__: No such module \$plugin!" => "__WAROITUS__: Ei sellaista moduuli \$plugia!",
"at" => " ",
"new" => "uusi",
"Create page:" => "Luo sivu:",
"Unknown language" => "Tuntematon kieli",
"Click here to confirm your action" => "Paina tästä, varmistaaksesi toiminnon",
"Sea Surfing (CSRF) detected. Operation blocked." => "Sea Surfing (CSRF) havaittu. Menetelmä suljettu.",
"Heading" => "Pääosa",
"Reduce area height" => "Pienennä alueen korkeutta",
"Enlarge area height" => "Suurenna alueen korkeutta",
"Wiki Help" => "Wiki apu",
"Item Modification" => "Osan Muokkaus",
"Item" => "Osa",
"Item creation" => "Osan luonti",
"Subject" => "Otsake",
"Tracker was modified at " => "Kortiston muokkaajana ",
"View the tracker item at:" => "Näytä kortisto osa:",
"Field is not numeric" => "Kenttä ei ole numeerinen",
"text field" => "teksti kenttä",
"half column" => "puoli palstaa",
"size" => "koko",
"prepend" => "lisäalkuun",
"append" => "lisäys",
"textarea" => "tekstialue",
"checkbox" => "merkintäneliö",
"numeric field" => "numeerinen kenttä",
"drop down" => "alas veto",
"user selector" => "käyttäjä valitsin",
"group selector" => "ryhmä valitsin",
"country selector" => "maa valitsin",
"date and time" => "päivä ja aika",
"jscalendar" => "jskalenteri",
"action" => "toiminto",
"header" => "pääosa",
"category" => "luokka",
"item link" => "osan linkki",
"items list" => "osien lista",
"email" => "sähköposti",
"system" => "järjestelmä",
"attachment" => "liite",
"open" => "avaa",
"pending" => "vireillä",
"closed" => "suljettu",
"Message" => "Viesti",
"No extra information for that attached file. " => "Ei lisätietoja tälle tiedostoliitteelle. ",
"child categories" => "alaluokat",
"objects in category" => "kohteita",
"Password should be at least" => "Salasanan oltava vähintään",
"characters long" => "merkkiä pitkä",
"Password must contain both letters and numbers" => "Salasanaan käytettävä sekä kirjaimia että numeroita",
"State" => "Tila",
"Country" => "Maa",
"No subject" => "Ei otsaketta",
"Displays browser client info" => "Näyttää selain asiakkaan tiedot",
"Creates a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which specifies the location and name of the anchor" => "Laittaa linkkiankkurin sivulle. Käytetään ANAME pluginin yhteydessä, joka laittaa paikan ja nimen ankkuriin",
"linktext" => "linkinteksti",
"Creates an anchor in a wiki page. Use in conjunction with the ALINK plugin, which specifies a link to the anchor" => "Laittaa ankkurin sivulle. Käytetään ALINK pluginin yhteydessä, joka tekee linkin ankkuriin",
"Location" => "Sijainti",
"Field" => "Kenttä",
"Start date" => "Aloitus päivä",
"Attachment" => "Liite",
"File" => "Tiedosto",
"Show description" => "Näytä kuvaus",
"No such attachment on this page" => "Ei sellaista liitettä sivulla",
"Displays an attachment or a list of them" => "Näyttää liitteen tai listan niistä",
"Avatar" => "Hahmo",
"Displays the user Avatar" => "Näyttää käyttäjän Hahmon",
"username" => "käyttäjänimi",
"Back" => "Takaisin",
"Backlinks" => "Paluulinkit",
"List all pages that link to specific pages" => "Listaa kaikki sivut jotka osoittavat kyseiselle sivuille",
"No pages links to" => "Ei linkkejä sivuille",
"One page links to" => "Yksi linkki sivulle",
"pages link to" => "linkit sivuille",
"Zone" => "Alue",
"Items" => "Osat",
"Insert theme-styled box on wiki page" => "Lisää teeman mukainen laatikko sivulle",
"Insert list of items with the current/given category in the wiki page" => "Lisää lista osista nykyisen/annetun luokittelun sivulle",
"Categories are disabled" => "Luokittelut poistettu",
"Display Tiki objects that have not been categorized" => "Näyttää luokittelemattomat kohteet",
"Objects" => "Kohteet",
"Insert the full category path for each category that this wiki page belongs to" => "Lisää koko luokittelupolku jokaiseen luokkaan johon tämä sivu kuuluu",
"Center" => "Keskitä",
"Centers the plugin content in the wiki page" => "Keskittää plugin sisällön sivulle",
"Chart" => "Kaavio",
"title" => "otsikko",
"Code" => "Koodi",
"Displays a snippet of code" => "Näyttää palan koodia",
"code" => "koodi",
"note: colors and ln are exclusive" => "huomaa: värit ja linja ovat valikoivia",
"Dynamic Content" => "Muuttuva sisältö",
"Cookie" => "Keksi",
"Insert copyright notices" => "Lisää copyright huomautus",
"Example" => "Esimerkki",
"seconds" => "sekuntia",
"Pre" => "Edel",
"Right" => "Oikea",
"Left" => "Vasen",
"Clear" => "Tyhjennä",
"Creates a definition list" => "Luo määrittelylistan",
"term" => "ehto",
"definition" => "määrittely",
"one definition per line" => "yksi määrittely per rivi",
"Events" => "Tapahtumat",
"Desc" => "Aleneva",
"Upcoming events" => "Tulossa olevat tapahtumat",
"Label" => "Etiketti",
"Displays the data using the Tikiwiki odd/even table style" => "Näyttää tiedot käyttäen pariton/parillinen taulukko tyyliä",
"cells" => "solut",
"sort" => "lajiteltu",
"Displays a Flash (.swf) file in the wiki page" => "Näyttää SWF sivulla",
"failed" => "epäonnistui",
"description" => "kuvaus",
"Value" => "Arvo",
"Displays a graphical GAUGE" => "Näyttää graafisen PALKIN",
"type" => "tyyppi",
"Group" => "Ryhmä",
"Display wiki text if user is in one of listed groups" => "Näyttää sivutekstin jos käyttäjä kuuluu johonkin listan ryhmistä",
"groups" => "ryhmät",
"HTML code" => "HTML koodi",
"name" => "nimi",
"Image ID" => "Kuva ID",
"Image size" => "Kuvan koko",
"Thumbnail" => "Minikuva",
"Browse" => "Selaa",
"Download" => "Imurointi",
"Include" => "Sisällytä",
"Start" => "Aloitus",
"Stop" => "Seis",
"Include a page" => "Sisällytä sivu",
"Following mandatory fields are missing" => "Seuraavat pakolliset kentät puuttuvat",
"Email address" => "Sähköposti osoite",
"Insert a javascript file or/and some javascript code." => "Lisää javascript tiedosto tai/ja jotain javascript koodia.",
"javascript code" => "javascript koodi",
"Displays the text only if the language matchs" => "Näyttää tekstin vain jos kieli täsmää",
"Last Modification" => "Muokattu viimeksi",
"List Pages" => "Listaa sivut",
"Sort" => "lajittele",
"or" => "tai",
"Filter" => "Suodin",
"complete" => "valmis",
"articles" => "artikkeleista",
"Lists files in a directory" => "Listaa kaikki tiedostot hakemistosta",
"could not be opened because it doesn't exist or permission was denied" => "ei voida avata, tiedostoa ei ole tai lupa avaamiseen puuttuu",
"Map" => "Kartta",
"Displays a map" => "Näyttää kartan",
"Feature disabled" => "Ominaisuus poistettu",
"Template" => "Malli",
"Style" => "Tyyli",
"Groups" => "Ryhmät",
"Module Name" => "Moduulin Nimi",
"Please choose a module" => "Valitse moduuli",
"to be used as argument" => "käytettäväksi perustana",
"Displays a module inline in a wiki page" => "Näyttää modulin sivun sisällä",
"Sorry, no such module" => "Ei ole sellaista moduulia",
"Font" => "Kirjasin",
"Displays the data using a monospace font" => "Näyttää tiedot käyttäen vakio levyistä kirjasinta",
"Text" => "Teksti",
"Sticky" => "Pysyvä",
"data" => "tieto",
"Object" => "Kohde",
"Days" => "Päivää",
"Displays object hit info by object and days" => "Näyttää kohteen osumatiedot kohteelle ja päivät",
"Status" => "Tila",
"Picture" => "Kuva",
"picture not found" => "kuvaa ei löydy",
"Information" => "Tiedot",
"Displays a list of plugins available in this wiki." => "Näyttää listan plugeista tällä sivustolla.",
"No version indicated" => "Ei versiota osoitettu",
"No arguments indicated" => "Ei perustetta osoitettu",
"Poll" => "äänestys",
"Displays the output of a poll, fields are indicated with numeric ids." => "Näyttää äänestyksen tulokset, kentät on merkitty numeerisella id:llä.",
"missing poll ID for plugin POLL" => "puuttuu äänestys ID POLL plugille",
"wrote:" => "kirjoitti:",
"Quote:" => "Lainaus:",
"Quote text by surrounding the text with a box, like the [QUOTE] BBCode" => "Ympäröi lainattavan tekstin laatikolla, kuten [QUOTE] BBCode",
"Preferences" => "Kokoonpanot",
"User Information" => "Käyttäjä Tiedot",
"one data per line" => "yksi tieto per rivi",
"Takes regex expressions and parses the content between the REGEX tags and replaces the text." => "Ottaa oikean ilmaisun ja muokkaa sisällön REGEX tagien väliin ja korvaa tekstin.",
"Icon" => "Kuvake",
"Close" => "Sulje",
"Date" => "Päiväys",
"Automatically creates a link to the appropriate SourceForge object" => "Luo automaattisesti linkin SourceForge kohteeseen",
"Sheet Heading" => "Taulukon Pääosa",
"TikiSheet" => "LaskentaTaulukko",
"Edit Sheet" => "Muokkaa Taulukkoa",
"List wiki pages" => "Listaa sivut",
"Display" => "Näytä",
"Last modified by" => "Viimeksi muokannut",
"Action" => "Toiminto",
"The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace." => "SNARF plugi korvaa itsensä HTML rungolla URL:sta.  Mielivaltainen regex korvaus voidaan tehdä käyttäen regex ja regexres, viimeisintä käytetään argumenttina korvauksessa preg_replace.",
"This data is put in a CODE caption." => "Tämä tieto on pantu KOODI kapseliin.",
"Missing url parameter for SNARF plugin." => "Puuttuu url parametri SNARF plugiin.",
"Sorts the plugin content in the wiki page" => "Lajittelee plugin sisällön sivulle",
"Order" => "Järjestys",
"Split a page into rows and columns" => "Jaa sivu riveihin ja palstoihin",
"First" => "Ensimmäinen",
"Edit" => "Muokkaa",
"row1col1" => "riv1pal1",
"row1col2" => "riv1pal2",
"row2col1" => "riv2pal1",
"row2col2" => "riv2pal2",
"Run a sql query" => "Aja sql kysely",
"sql query" => "sql kysely",
"Missing db param" => "Puuttuu db parametrit",
"Displays text in subscript." => "Näyttää tekstin subscriptinä.",
"Subscribe" => "Tilaa",
"Tag Name" => "Kiinnikkeen nimi",
"Displays text between HTML tags" => "Näyttää tekstin html tagin sisällä",
"Displays the thumbnail for an image" => "Näyttää kuvan minikuvan",
"Original" => "Alkuperäinen",
"Search the titles of all pages in this wiki" => "Etsi otsikoita kaikilta sivuilta tällä sivustolla",
"No pages found for title search" => "Sivuja ei löytynyt aihe haulla",
"One page found for title search" => "Yksi sivu löytyi otsikkohaulla",
"pages found for title search" => "sivua löytynyt otsikkohaulla",
"Structure ID" => "Rakenne ID",
"Public" => "Julkinen",
"Translate" => "Käännä",
"Fields" => "Kentät",
"Email" => "Sähköposti",
"to" => " ",
"template" => "malli",
"Preview" => "Näytä",
"preview" => "näytä",
"View" => "Näytä",
"Error" => "Virhe",
"Following fields are incorrect" => "Seuraavat kentät ovat väärin",
"Displays an input form for tracker submit" => "Näyttää kortiston syöttölomakkeen",
"You do not have permission to insert an item" => "Oikeutesi eivät riitä lisäämään osaa",
"Fields marked with a * are mandatory." => "Kentät jotka on merkitty * ovat pakollisia.",
"Filters" => "Suotimet",
"Displays the output of a tracker content, fields are indicated with numeric ids." => "Näyttää kortiston sisällön, kentät on merkitty numeerisella id:llä.",
"Mode" => "Moodi",
"Delete" => "Poista",
"Error in tracker ID" => "Virhe kortisto ID:ssä",
"No field indicated" => "Ei kenttää",
"Start Date" => "Aloitus Päivä",
"End Date" => "Lopetus Päivä",
"Links to a translated content" => "Linkki käännös sisältöön",
"Flag" => "Lippu",
"Displays the number of registered users" => "Näyttää rekisteröityneiden käyttäjien määrän",
"User List" => "Käyttäjä Lista",
"Real Name" => "Oikea Nimi",
"users" => "käyttäjät",
"Versions" => "Versiot",
"Split the text in parts visible only under some conditions" => "Jakaa tekstin osiin, jotka näytetään vain joissakin tapauksissa",
"Vote" => "Äänestä",
"Table" => "Taulukko",
"Lists ''wanted'' Wiki pages: " => "Listaa ''halutaan'' sivut: ",
"Page-Pattern" => "Sivu-Kuvio",
"Custom-Level-Regex" => "Erikois-Tason-Regex",
"^Parameters: key=>value,...\n" => "^Parametrit: key=>arvo,...\n",
"__key__ | __default__ | __comments__\n" => "__avain__ | __oletus__ | __kommentit__\n",
"empty string" => "tyhjä merkkijono",
"(refer to PHP function fnmatch() for details)\n" => "(tarkista PHP functioiden fnmatch() yksityiskohdat)\n",
"possible values: characters\n" => "mahdolliset arvot: merkit\n",
"possible values: " => "mahdolliset arvot: ",
"a valid regex-expression (PCRE)" => "hyväksytty regex-ilmaisu (PCRE)",
"non-valid custom regex" => "ei hyväksytty muokattu regex",
"ignored" => "huomioimaton",
"External Wiki" => "Ulkoinen Wiki",
"dash-WikiWord" => "viiva-WSana",
"WikiWord" => "WSana",
"not in level" => "ei tasolla",
"valid" => "hyväksytty",
"End of debug output." => "Debug tulostuksen päätös.",
"Wanted Page" => "Haluttu Sivu",
"Referenced By Page" => "Lainaus Sivulta",
"width" => "leveys",
"height" => "korkeus",
"ERROR: Either the subject or body must be non-empty" => "VIRHE: Kumpaakaan osikkoa tai tekstiä ei voi jättää tyhjäksi",
"ERROR: No valid users to send the message" => "VIRHE: Ei hyväksyttyjä jäseniä joille lähettää viesti",
"Invalid user" => "Väärä käyttäjä",
"Sent box is full. Archive or delete some sent messages first if you want to send more messages." => "Postilaatikko on täynnä. Arkistoi tai poista vanhempia viestejä ensin jos haluat lähettää lisää viestejä.",
"You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'" => "Sinun on voitava vastaanottaa viestejä lähettääksesi niitä. Mene omiin asetuksiisi ja valitse 'Salli viestit muilta jäseniltä'",
"User %s can not receive messages, mailbox is full" => "Käyttäjä %s ei voi vastaanottaa viestejä, postilaatikko on täynnä",
"User %s can not receive messages" => "Käyttäjä %s ei voi vastaanottaa viestejä",
"Invalid user: %s" => "Väärä käyttäjä: %s",
"Message will be sent to: " => "Viesti lähetetään: ",
"Archive is full. Delete some messages from archive first." => "Arkisto on täynnä. Poista vanhempia viestejä ensin.",
"No more messages" => "Ei enempää viestejä",
"Categories" => "Luokittelut",
"Categorize" => "Luokittele",
"Unassign" => "Poistaliitos",
"Assign" => "Liitä",
"Received objects" => "Vastaanotetut kohteet",
"File galleries" => "Tiedosto galleriat",
"Last forum posts" => "Viime foorumin lähetykset",
"Topics only" => "Vain aiheet",
"Most commented forums" => "Eniten kommentoidut foorumit",
"Most read topics" => "Luetuimmat aiheet",
"Most visited forums" => "Luetuimmat foorumit",
"Google Search" => "Google Etsintä",
"Last actions" => "Viime toiminnot",
"Last blog posts" => "Viimeiset blogi lähetykset",
"no object here yet" => "ei kohteita täällä vielä",
"Last Created blogs" => "Viimeiset Luodut blogit",
"Last Created FAQs" => "Viimeksi Luodut UKK:t",
"Last Created Quizzes" => "Viimeksi Luodut Visailut",
"Last modified file galleries" => "Viimeksi muokatut tiedosto galleriat",
"Last Files" => "Viimeiset Tiedostot",
"Last Images" => "Viime Kuvat",
"Last modified events" => "Viime muutetut tapahtumat",
"Last Modified blogs" => "Viimeksi muokatut blogit",
"Last submissions" => "Viimeiset ehdotukset",
"Last Items" => "Viimeiset Osat",
"Last Modified Items" => "Viimeksi Muokatut Osat",
"Last Visitors" => "Viime vierailijat",
"Live support" => "Elävä tuki",
"Messages" => "Viestit",
"Waiting Submissions" => "Odottaa Ehdotuksia",
"Old articles" => "Vanhat artikkelit",
"Create/Edit" => "Luo/muokkaa",
"Quick Edit a Wiki Page" => "PikaMuutos sivuun",
"Random Pages" => "Satunnais Sivut",
"New user registration" => "Uuden käyttäjän rekisteröinti",
"Post" => "Lähetä",
"Since your last visit" => "Viime käyntisi jälkeen",
"Changes since" => "Muutokset jälkeen",
"new comments" => "uusia kommentteja",
"new posts" => "uudet postit",
"wiki pages changed" => "wiki sivuja muuttunut",
"new articles" => "uudet artikkelit",
"new FAQs" => "uudet UKK:ot",
"new blogs" => "uudet blogit",
"new blog posts" => "uudet blogi lähetykset",
"new image galleries" => "uudet kuva galleriat",
"new images" => "uudet kuvat",
"new file galleries" => "uudet tiedosto galleriat",
"new files" => "uusia tiedostoja",
"new polls" => "uudet äänestykset",
"new users" => "uusia käyttäjiä",
"new tracker items" => "uudet kortiston osat",
"Most Active blogs" => "Aktiivisimmat blogit",
"Top articles" => "Top artikkelit",
"Top File Galleries" => "Top Tiedosto Galleriat",
"Top files" => "Top tiedostot",
"Top Forum Posters" => "Top Foorumin Lähettäjät",
"Top Images" => "Top Kuvat",
"Top Objects" => "Top Kohteet",
"Top Pages" => "Top Sivut",
"Top Quizzes" => "Top Visailut",
"Top Visited FAQs" => "Top Vieraillut UKK:t",
"User Blogs" => "Käyttäjä Blogit",
"My blogs" => "Omat blogit",
"User bookmarks" => "Käyttäjän kirjanmerkit",
"My galleries" => "Omat galleriat",
"User Pages" => "Käyttäjä Sivut",
"My Pages" => "Omat Sivut",
"User tasks" => "Käyttäjä tehtävät",
"The task title must have at least 3 characters" => "Tehtävä otsikon oltava vähintään 3 merkkiä",
"Public tasks" => "Julkisia tehtäviä",
"Top users" => "Top käyttäjät",
"Online users" => "Käyttäjät linjalla",
"Last wiki comments" => "Viimeiset wiki kommentit",
"Invalid server key" => "Väärä palvelin avain",
"Invalid username or password" => "Väärä käyttäjänimi tai salasana",
"change password" => "muuta salasana",
"country" => "maa",
"theme" => "teema",
"Anti-Bot verification code" => "Anti-Bot varmistus coodi",
"Random Image" => "Satunnais Kuva",
"Enter the code you see above" => "Kirjoita alla näkyvä koodi",
"List of attached files" => "Listaus tiedostoliitteistä",
"desc" => "aleneva",
"uploaded" => "lähetetty",
"Remove" => "Poista",
"Upload file" => "Lähetä tiedosto",
"Attach" => "Liitä",
"Attach a file to this item" => "Liitä tiedosto tähän osaan",
"Version" => "Versio",
"Attachments" => "Liitteet",
"more info" => "lisä info",
"No attachments for this item" => "Ei liitteitteitä tähän osaan",
"Fatal error" => "Vakava virhe",
"Created by" => "Luonut",
"on" => " ",
"Activity=" => "Toiminto=",
"Actions" => "Toiminnot",
"Properties" => "Tarpeisto",
"No records found" => "Ei löytynyt tallennetta",
"Admin Categories" => "Ylläpidä luokitteluja",
"No categories defined" => "Ei luokittelua määritelty",
"Browse Category" => "Selaa luokkaa",
"posts:" => "lähetyksiä:",
"stars" => "tähtiä",
"User Level" => "Käyttäjä taso",
"private message" => "yksityis viesti",
"Send eMail to User" => "Lähetä viesti käyttäjälle",
"user online" => "käyttäjä linjalla",
"user offline" => "käyttäjä pois linjalta",
"Reply" => "Vastaa",
"Approve" => "Hyväksy",
"Reject" => "Hylätty",
"Save to notepad" => "Tallenna muistioon",
"Monitor this Topic" => "Tarkkaile tätä aihetta",
"Stop Monitoring this Topic" => "Lopeta tämän aiheen tarkkailu",
"Moderator actions" => "Moderaattorin toiminnot",
"reported:" => "raportoitu:",
"queued:" => "jonossa:",
"Move to topic:" => "Siirrä aiheeksi:",
"Move" => "Siirrä",
"Delete Selected" => "Poista valitut",
"Unlock" => "Aukaise",
"Lock" => "Lukitse",
"Threshold" => "Kynnys",
"Set" => "Aseta",
"Replies" => "Vastauksia",
"below your current threshold" => "alle nykyisen kynnyksesi",
"New Reply" => "Uusi vastaus",
"Editing reply" => "Muokkaa vastausta",
"Reply to the selected post" => "Vastaa valittuihin lähetyksiin",
"Post new message" => "Lähetä uusi viesti",
"Editing comment" => "Muokkaa kommenttia",
"Comment on the selected post" => "Kommentoi valittuja lähetyksiä",
"Post new comment" => "Lähetä uusi kommentti",
"Toolbars" => "Pikatagit",
"optional" => "vaihtoehtoinen",
"Reply to parent post" => "Vastaa isäntä lähetykseen",
"Post new reply" => "Lähetä uusi vastaus",
"Cancel" => "Peruuta",
"Posting replies" => "Lähettää vastauksia",
"Posting comments" => "Lähetetään kommentteja",
"Add Comment" => "Lisää kommentti",
"1 comment" => "1 kommentti",
"Go back" => "Takaisin",
"Return to home page" => "Palaa EtuSivulle",
"Copyrights" => "Copyright",
"Year" => "Vuosi",
"Authors" => "Kirjoittajat",
"Add" => "Lisää",
"Current URL" => "Nykyinen URL",
"Command" => "Komento",
"exec" => "suorita",
"Type <code>help</code> to get list of available commands" => "Kirjoita <code>help</code> saadaksesi listan komennoista",
"Syntax" => "Syntaksi",
"Page generation debugging log" => "Sivun luoma debugging logi",
"Features state" => "Ominaisuuksien tilanne",
"Total" => "Kaikkiaan",
"features matched" => "ominaisuuksia osui",
"Watchlist" => "Vahtilista",
"duplicate" => "kaksoiskappale",
"There are individual permissions set for this file gallery" => "Tälle gallerialle on asetettu erikoisoikeudet",
"Save" => "Tallenna",
"System" => "Järjestelmä",
"Use" => "Käytä",
"unlimited" => "rajoittamaton",
"none" => "eimitään",
"Parent gallery" => "Isäntä galleria",
"Owner of the gallery" => "Gallerian omistaja",
"Default sort order" => "Oletus lajittelu järjestys",
"Max description display size" => "Suurin kuvauksen näyttökoko",
"Please login" => "Ole Hyvä ja kirjaudu",
"There are no wiki pages similar to '{\$page}'" => "Ei ole samanlaisia sivuja kuin '{\$page}'",
"Create this page" => "Luo tämä sivu",
"(page will be orphaned)" => "(sivu muuttuu yksittäiseksi)",
"Close Window" => "Sulje Ikkuna",
"Active Perms" => "Aktiiviset oikeudet",
"Perms" => "Oikeud",
"Replace" => "Korvaa",
"List" => "Lista",
"Name-filename" => "Nimi-tiedostonimi",
"Filename only" => "Vain tiedostonimi",
"Exact&nbsp;match" => "Tarkka&nbsp;täsmäys",
"Number of displayed rows" => "Näytettävien rivien määrä",
"in:" => " :",
"Go" => "Mene",
"RSS Blogs" => "RSS Blogit",
"RSS Articles" => "RSS Artikkelit",
"RSS Image Galleries" => "RSS Kuva Galleriat",
"RSS File Galleries" => "RSS Tiedosto Galleriat",
"RSS Forums" => "RSS Foorumit",
"RSS Maps" => "RSS Kartat",
"RSS Directories" => "RSS Hakemistot",
"Perform action with checked:" => "Suorita toiminnot valituilla:",
"Move Selected Files" => "Siirrä valitut tiedostot",
"Assign Permissions" => "Anna Oikeudet",
"Move to" => "Siirrä",
"Filename" => "Tiedostonimi",
"Hi {\$mail_user} has sent you this link:" => "Hi {\$mail_user} lähetti sinulle linkin:",
"Blog post:" => "Blogi lähetys:",
"at:" => " :",
"Somebody or you tried to subscribe this email address at our site:" => "Joku tai sinä yrität tilata tällä sähköpostiosoitteella:",
"To the newsletter:" => "uutislehden:",
"Description:" => "Kuvaus:",
"In order to confirm your subscription you must access the following URL:" => "Varmistaaksesi tilauksesi sinun on käytettävä tätä URL:ia:",
"User:" => "Käyttäjä:",
"A new message was posted to forum" => "Uusi viesti oli lähetetty foorumille",
"New topic:" => "Uusi aihe:",
"Topic:" => "Aihe:",
"You sent a request with the subject:" => "Lähetit pyynnön otsikolla:",
"Use the subject to indicate the operation to apply:" => "Käytä otsikkoa osoittaaksesi lisättävän käsittelyn:",
"GET:WikiName to get a wiki page" => "HAE:SivuNimi saadaksesi sivun",
"PUT:WikiName to update/create a wiki page (use the body for the page data)" => "VIE:SivuNimi päivittääksesi/luodaksesi (käytä runkona sivun tietoja)",
"APPEND:WikiName to append data to a Wiki page (use the body for the data to add)" => "LISÄÄ:SivuNimi lisätäksesi tietoja sivun loppuun (käytä runkona sivun tietoja lisäykseen)",
"PREPEND:WikiName to append the data at the top" => "LISALK:SivuNimi lisätäksesi tietoja sivun alkuun",
"Tiki mail-in instructions" => "Tiki postit sisään ohjeet",
"Tiki mail-in auto-reply." => "Sivuston-sisään autom-vastaus.",
"Page not found:" => "Sivua ei löydy:",
"A new message was posted to you at {\$mail_machine}" => "Uusi viesti on lähetetty sinulle {\$mail_machine}",
"From" => "Keneltä",
"New message arrived from %s" => "Uuden viestin lähettänyt %s",
"Your account registration request for {\$mail_site} was validated by the site admin and your account is active now." => "Rekisteröinti pyyntösi {\$mail_site} käsitelty ylläpidon toimesta ja jäsenyytesi on aktivoitu.",
"To login with your username and password, please follow this link:" => "Kirjautuaksesi käyttäjänimeä ja salasanaa käyttäen, seuraa tätä linkkiä:",
"Enjoy the site!" => "Nauti sivustosta!",
"User Account Activated" => "Käyttäjä Tili Aktivoitu",
"has requested an account on" => "on pyytänyt jäsenyyttä",
"To validate that account, please follow the link:" => "Varmistaaksesi jäsenyys, seuraa tätä linkkiä:",
"User Registration Request" => "Käyttäjä Rekisteröinti Pyyntö",
"Go to your friendship network to accept or refuse this request" => "Mene ystävä verkostoosi ja hyväksy tai hylkää tämä pyyntö",
"You're invited to join my network of friends!" => "Sinut on kutsuttu liittymään ystävyysverkostooni!",
"The user" => "Käyttäjä",
"registered at your site" => "rekisteröity sinun sivustollesi",
"This email address has been removed to the list of subscriptors of:" => "Tämä sähköpostiosoite on poistettu seuraavista tilaajien listalta:",
"Newsletter:" => "Uutislehti:",
"Bye bye from %s at %s" => "Terveisin %s -> %s",
"You can unsubscribe from this newsletter following this link" => "Voit peruuttaa uutislehden tilauksen painamalla tätä linkkiä",
"Welcome to our newsletter!" => "Tervetuloa Uutislehteemme!",
"This email address has been added to the list of subscriptors of:" => "Tämä sähköpostiosoite on liitetty tilaajien listalle:",
"You can always cancel your subscription using:" => "Voit peruuttaa tilauksen aina käyttäen:",
"Welcome to %s at %s" => "Tervetuloa %s , %s",
"Email notification" => "Sähköposti ilmoitus",
"requested a reminder of the password for your account" => "rekisteröinnistäsi on pyydetty salasana muistutusta",
"requested password reset for your account" => "rekisteröintisi salasana muutettu",
"Since this is your registered email address we inform that the password for this account is" => "Tämä on rekisteröity sähköpostiosoitteesi ja salasanasi on",
"Important: Username & password are CaSe SenSitiVe" => "Tärkeää: Käyttäjänimi & salasana ovat Tarkkoja oikeinkirjoituksesta",
"Important: The old password remains active if you don't click the link above." => "Tärkeää: Vanha salasana pysyy aktiivisena jos et seuraa alla olevaa linkkiä.",
"Your account information for %s" => " %s sinun tilitietosi ovat",
"A new article was submitted by {\$mail_user} to {\$mail_site} at {\$mail_date|tiki_short_datetime}" => "Uuden artkkelin lähettäjänä {\$mail_user}   {\$mail_site}   {\$mail_date|tiki_short_datetime}",
"You can edit the submission following this link:" => "Voit muokata ehdotuksia seuraamalla tätä linkkiä:",
"Title:" => "Otsikko:",
"Heading:" => "Pääosa:",
"Body:" => "Runko:",
"New article submitted at %s" => "Uutta artikkelia ehdottanut %s",
"Tracker was modified at" => "Koristoa muokattu",
"You or someone registered this email address at" => "sinä tai joku muu on rekisteröitynyt tällä sähköpostiosoitteella",
"If you want to be a registered user in this site you will have to use the following link to login for the first time:" => "Jos haluat olla rekisteröitynyt käyttäjä tällä sivustolla sinun on seurattava tätä linkkiä kirjautuaksesi ensimmäisen kerran:",
"Your registration confirmation" => "Sinun tietosi rekisteröintiin",
"You will receive an email with information to login for the first time into this site" => "Saat kohta sähköpostia, jossa on linkki ensimmäistä kirjautumista varten tälle sivustolle",
"Your account request has been stored and will be activated by the admin as soon as possible." => "Rekisteröinti pyyntösi on tallennettu ja ylläpito käsittelee ja aktivoi sen mahdollisimman pian.",
"View the article at:" => "Näytä artikkeli:",
"If you don't want to receive these notifications follow this link:" => "Jos et halua vastaanotta näitä ilmoituksia seuraa tätä linnkiä:",
"New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user|username} at {\$mail_date|tiki_short_datetime}" => "Uudet blogi lähetykset: {\$mail_title}, \"{\$mail_post_title}\",   {\$mail_user|username}   {\$mail_date|tiki_short_datetime}",
"View the blog at:" => "Näytä blogia:",
"New blog post at %s" => "Uuden blokikirjoituksen lähettänyt %s",
"changed" => "muutettu",
"created" => "luotu",
"Removed by" => "Poistanut",
"New" => "Uusi",
"File Gallery %s changed" => "Tiedosto Galleria %s muuttunut",
"A file was removed from the file gallery" => "Tiedosto on poistettu tiedosto galleriasta",
"File Name" => "Tiedosto Nimi",
"A new file was posted to file gallery" => "Uusi tiedosto lähetetty tiedosto galleriaan",
"Posted by" => "Lähettänyt",
"File Description" => "Tiedoston Kuvaus",
"The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Karttaa {\$mail_page} on muuttanut {\$mail_user}  {\$mail_date|tiki_short_datetime}",
"You can view the updated map following this link:" => "Voit katsoa päivitettyä karttaa seuraamalla tätä linkkiä:",
"You can edit the map following this link:" => "Voit muokata karttaa seuraamalla tätä linkkiä:",
"The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Sivun {\$mail_page} on luonut {\$mail_user}: {\$mail_date|tiki_short_datetime}",
"The page {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Sivua {\$mail_page} on muuttanut {\$mail_user}  {\$mail_date|tiki_short_datetime}",
"Comment:" => "Kommentti:",
"You can view the page by following this link:" => "Voit katsoa sivua seuraamalla tätä linkkiä:",
"You can view a diff back to the previous version by following this link:" => "Voit katsoa edellisiä versioita seuraamalla tätä linkkiä:",
"The changes in this version follow below, followed after by the current full page text." => "Tämän version muutokset seuraavat alla, nykyisen koko sivun tekstin jälkeen.",
"-Lines: {\$oldd} changed to +Lines: {\$newd}" => "-Riviä: {\$oldd} muutettu +Riviä: {\$newd}",
"The new page content follows below." => "Uuden sivun sisältö seuraa alla.",
"The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Sivua {\$mail_page} on kommentoinut {\$mail_user}  {\$mail_date|tiki_short_datetime}",
"Wiki page renamed" => "Sivu uudelleen nimetty",
"Old name" => "Vanha nimi",
"New name" => "Uusi nimi",
"click on the map to zoom or pan, do not drag" => "klikkaa karttaa zoomataksesi tai pan, älä tartu karttaan",
"Scale" => "Muunnos",
"Query" => "Kysely",
"Pan" => "Panoroi",
"Redraw" => "Päivitä",
"select zoom/pan/query and image size" => "valitse zoom/pan/kysely ja kuvan koko",
"View the Map Only" => "Näytä Vain Kartta",
"Reset Map" => "Palauta Kartta",
"Click on the map or click redraw" => "Klikkaa karttaa tai klikkaa päivittääksesi",
"Last modification date" => "Viimeinen muokkaus päivä",
"Overview" => "Yleiskuva",
"Legend" => "Seloste",
"Layer Manager" => "Tason Hallinta",
"Layer" => "Taso",
"On" => " ",
"Download Layer" => "Imuroi Taso",
"This layer has been set by the maps administrator to not be downloadable" => "Tämän tason on asettanut kartan ylläpitäjä eikä sitä voi imuroida",
"you have requested to download the layer:" => "olet pyytänyt tason imurointia:",
"Here are the files to download, do not forget to rename them:" => "Tässä ovat tiedostot imurointia varten, älä unohda nimetä niitä:",
"Mapfiles" => "Karttatiedostot",
"Mapfile" => "Karttatiedosto",
"Available mapfiles" => "Saatavat karttatiedostot",
"hits last 7 days" => "osumia viimeisenä 7 päivänä",
"monitor this map" => "tarkkaile tätä karttaa",
"Stop Monitoring this Map" => "Lopeta tämän kartan tarkkailu",
"Create a new mapfile" => "Luo uusi karttatiedosto",
"Create" => "Luo",
"Mapfile listing" => "Karttatiedoston listaus",
"Reload" => "Lataa uudelleen",
"History" => "Historia",
"You can view this map in your browser using" => "Voit katsoa kartaa selaimelle käyttäen ",
"Zoom out x2" => "Suurenna x2",
"Zoom in x2" => "Pienennä x2",
"Mapfile History" => "Karttatiedoston Historia",
"of" => " ",
"Compare" => "Vertaa",
"Comparing version {\$old.version} with version {\$new.version}" => "Verrataan versiota {\$old.version} versioon {\$new.version}",
"Version:" => "Versio:",
"Current" => "Nykyinen",
"Versions are identical" => "Versiot ovat identtiset",
"Legend:" => "Seloste:",
"v=view" => "n=näyttö",
"c=compare" => "v=vertaa",
"d=diff" => "e=erot",
"Full side-by-side diff" => "Kaikki erot rinnakkain",
"Unified diff" => "Yhdistetyt erot",
"Side-by-side view" => "Rinnakkaisnäyttö",
"User" => "Käyttäjä",
"Diff" => "Erot",
"Older Version" => "Vanhempi versio",
"Directories" => "Hakemistot",
"back to" => "takaisin",
"Upload From Disk:" => "Lähetä Kovalevyltä:",
"Upload Files" => "Lähetä Tiedostot",
"Bytes maximum" => "Suurin koko",
"Create Directory:" => "Luo Hakemisto:",
"index file (.shp):" => "index tiedosto (.shp):",
"files to index (regexp):" => "tiedostot index:iin (regexp):",
"Message Archive" => "Viesti Arkisto",
"messages" => "viestejä",
"Archive is full!" => "Arkisto on täynnä!",
"Unread" => "Lukemattomat",
"Flagged" => "Merkityt",
"Unflagged" => "Merkitsemättömät",
"Containing" => "Sisältäen",
"Sender" => "lähettäjä",
"No messages to display" => "Ei näytettäviä viestejä",
"Broadcast message" => "Lähetys viesti",
"OK" => "Ok",
"All users" => "Kaikki käyttäjät",
"Lowest" => "Alin",
"Low" => "Alhainen",
"High" => "Korkea",
"Very High" => ">Korkein",
"Send" => "Lähetä",
"Compose message" => "Muodosta viesti",
"Invalid" => "Toimimaton",
"No messages to download" => "Ei imuroitavia viestejä",
"Mailbox is full! Delete or archive some messages if you want to receive more messages." => "Postilaatikko on täynnä! Poista tai arkistoi viestejä jotta voit vastaanottaa lisää.",
"Find replied message" => "etsi vastatut viestit",
"Archive" => "Arkisto",
"Mark as read" => "Merkitse luetuksi",
"Mark as unread" => "Merkitse lukemattomaksi",
"Mark as flagged" => "Merkitse merkityksi",
"Mark as unflagged" => "Merkitse merkitsemättömäksi",
"Mark" => "merkitse",
"Mailbox" => "Postilaatikko",
"Compose" => "Muodosta",
"Broadcast" => "Lähetys",
"Sent" => "Lähtenyt",
"Auto-archive age for read messages:" => "Auto-arkistoi iän mukaan luetut viestit:",
"Read message" => "Lue viesti",
"Return to mailbox" => "Palaa postilaatikkoon",
"replyall" => "vastaakaikille",
"Unflag" => "Merkitsemätön",
"Flag this message" => "Merkitse tämä viesti",
"From:" => "Keneltä:",
"Return to archive" => "Palaa arkistoon",
"Return to outbox" => "Palaa lähteneisiin",
"Sent Messages" => "Lähteneet Viestit",
"Replied" => "Vastatut",
"Not replied" => "Vastaamattomat",
"move to archive" => "siirrä arkistoon",
"receiver" => "vastaanottaja",
"'name' parameter for tikimodule missed" => "'nimi' parametri puuttuvalle moduulille",
"Move module up" => "Siirrä moduuli ylöspäin",
"Up" => "Ylös",
"Move module down" => "Siirrä moduuli alaspäin",
"Down" => "Alas",
"Move module to opposite side" => "Siirrä moduuli toiselle puolelle",
"opp side" => "vastakkainen puoli",
"Unassign this module" => "Poista tämä moduuli",
"Are you sure you want to unassign this module?" => "Oletko varma, että haluat poistaa modulin?",
"Display type unknown, you have to enter the banner type" => "Tuntematon näyttö tyyppi, anna bannerin tyyppi",
"You forgot your Google ad_client number !" => "Olet unohtanut Google ad_client numeron !",
"Thank you for installing Tikiwiki" => "Kiitos kun installoit Tikiwikin",
"Select" => "Valitse",
"Admin" => "Ylläpitäjä",
"Admin Modules" => "Ylläpidä Moduuleja",
"Modules" => "Moduulit",
"Admin Menus" => "Ylläpidä Valikoita",
"Menus" => "Valikot",
"login" => "kirjaus",
"Pages:" => "Sivut:",
"Categories:" => "Luokittelut:",
"Register" => "Rekisteröity",
"Open operator console" => "Avaa operaattorin konsoli",
"Logout" => "Poistu",
"Switch" => "Kytkin",
"Login through CAS" => "Kirjautuminen CAS:in kautta",
"Login as admin" => "Kirjautunut ylläpitäjänä",
"eMail" => "Sähköposti",
"Password" => "Salasana",
"Remember me" => "Muista minut",
"week" => "viikko",
"month" => "kuukausi",
"year" => "vuosi",
"Click here to register" => "Paina tästä rekisteröityäksesi",
"Click here if you've forgotten your password" => "Paina tästä jos olet unohtanut salasanasi",
"I forgot my password" => "Unohdin salasanan",
"Click here to login using the default security protocol" => "Paina tästä kirjautuaksesi oletuksena olevaa turvallisuus protokollaa käyttäen",
"Standard" => "Standardi",
"Click here to login using a secure protocol" => "Paina tästä kirjautuaksesi käyttäen salattua protokollaa",
"Secure" => "Salattu",
"Stay in ssl Mode" => "Pysy ssl moodissa",
"local account" => "paikallinen tili",
"You have" => "Sinulla on",
"new messages" => "uusia viestejä",
"new message" => "uusi viesti",
"You have 0 new messages" => "Sinulla on 0 uutta viestiä",
"We have" => "Meillä on",
"submissions waiting to be examined" => "ehdotukset odottavat käsittelyä",
"Image Galleries" => "Kuva Galleriat",
"Entire Site" => "Koko Sivusto",
"Wiki Pages" => "Wiki Sivut",
"Image Gals" => "Kuva Gal",
"Blog Posts" => "Blogi Lähetykset",
"Search Wiki PageName" => "Etsi Wiki SivuNimeä",
"Read More" => "Lue Lisää",
"Since your last visit on" => "Sen jälkeen kun viimeksi olet käynyt",
"New Images" => "Uudet kuvat",
"Wiki Pages Changed" => "Wiki sivuja muuttunut",
"New Files" => "Uusia tiedostoja",
"New Comments" => "Uusia kommentteja",
"New Tracker Items" => "Uudet kortiston osat",
"New Users" => "Uusia käyttäjiä",
"click to edit" => "paina muokataksesi",
"Top galleries" => "Top galleriat",
"view" => "näytä",
"click to view" => "paina katsoaksesi",
"Bookmarks" => "Kirjanmerkit",
"Cache" => "Puskuri",
"Done" => "tehty",
"Del" => "Pois",
"select" => "valitse",
"Refresh" => "Päivitä",
"online users" => "linjalla olevaa käyttäjää",
"online user" => "käyttäjä linjalla",
"on host" => "järjestäjänä",
"Send a message to" => "Lähetä viesti",
"Send a message" => "Lähetä viesti",
"vote" => "äänestä",
"Warning" => "Varoitus",
"Users" => "Käyttäjät",
"Send Newsletter" => "Lähetä uutiskirje",
"RSS feed" => "RSS syöte",
"Edit blog" => "Muokkaa blogia",
"Monitor this Blog" => "Tarkkaile tätä blogia",
"Stop Monitoring this Blog" => "Lopeta tämän blogin tarkkailu",
"Find:" => "Löytyi:",
"pages" => "sivuja",
"To edit the copyright notices" => "Muuttaaksesi copyright huomautusta",
"The content on this page is licensed under the terms of the" => "Tämän sivun sisältö on lisenssoitu seuraavien ehtojen mukaan",
"Permalink" => "Peruslinkki",
"comments" => "kommenttia",
"First page" => "Ensimmäinen sivu",
"Previous page" => "Edellinen sivu",
"page" => "sivu",
"Next page" => "Seuraava sivu",
"Last page" => "Viimeinen sivu",
"referenced by" => "lainattu",
"references" => "viittaukset",
"View Comments" => "Näytä kommentit",
"Trackback pings" => "Viittaustoiminnon pingit",
"Blog name" => "Blogin nimi",
"Calendar View" => "Kalenteri näyttö",
"List View" => "Listaus näyttö",
"Tools Calendars" => "Työkalu Kalenterit",
"Check / Uncheck All" => "Merkitse / poista merkintä kaikista",
"Tip" => "Vihje",
"Cancel Edit" => "Peruuta muutos",
"Change preferences" => "Muuta asetuksia",
"Site Ads and Banners" => "Sivuston Mainokset ja Bannerit",
"General" => "Yleiset",
"Features" => "Ominaisuudet",
"Community" => "Yhteisö",
"Module" => "Moduuli",
"Meta Tags" => "Meta Tagit",
"Security" => "Turvallisuus",
"User files" => "Käyttäjä tiedostot",
"To add/remove blogs, go to \"Create/Edit Blog\" under \"Blogs\" on the application menu, or" => "Lisätäksesi/poistaaksesi blogeja, mene \"Luo/Muokkaa blogia\" siellä \"Blogit\" ohjelma valikossa, tai",
"General Settings" => "Yleiset Asetukset",
"Home Blog (main blog)" => "Koti Blogi (pää blogi)",
"To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or" => "Lisätäksesi/poistaaksesi kalentereita, katso \"Ylläpito\" \"Kalenteri\" ohjelmavalikosta, tai",
"Change settings" => "Muuta asetuksia",
"Saturday" => "Lauantai",
"Sunday" => "Sunnuntai",
"Monday" => "Maanantai",
"5 minutes" => "5 minuutin kuluttua",
"Permissions" => "Oikeudet",
"Look under \"Articles\" on the application menu for links to" => "Katso \"Artikkelit\" ohjelma valikon linkit",
"Import CSV file" => "Tuo CSV tiedosto",
"Batch upload (CSV file)" => "Joukko lähetys (CSV tiedosto)",
"Import" => "Tuo",
"Admin Groups" => "Ylläpidä ryhmiä",
"Admin Users" => "Ylläpidä käyttäjiä",
"avatar" => "hahmo",
"Number of friends" => "Ystävien lukumäärä",
"E-mail" => "Sähköposti",
"Last login" => "Viimeksi kirjautunut",
"Distance" => "Etäisyys",
"default" => "oletus",
"Number of visited pages to remember" => "Muistettavien sivujen määrä",
"Displayed time zone" => "Näytä aika vyöhyke",
"User information" => "Käyttäjä tiedot",
"Private" => "Yksityinen",
"public" => "julkinen",
"Use double-click to edit pages" => "Käytä kaksoisklikkausta muokataksesi",
"Show user's info on mouseover" => "Näyttää käyttäjän tiedot kun hiiri on päällä",
"Tasks per page" => "Tehtäviä per sivu",
"Messages per page" => "Viestejä per sivu",
"Allow messages from other users" => "Salli viestit muilta käyttäjiltä",
"Send me an email for messages with priority equal or greater than" => "Lähetä minulle sähköpostia viesteistä joiden ensisijaisuus on sama tai suurempi kuin",
"Auto-archive read messages after x days" => "Auto-arkistoi luetut viestit x päivän jälkeen",
"never" => "ei koskaan",
"My Tiki" => "OmatSivut",
"My pages" => "Omat sivut",
"My messages" => "Omat viestit",
"My tasks" => "Omat tehtävät",
"My items" => "Omat osat",
"To configure your directory, find \"Admin Directory\" under \"Directory\" on the application menu, or" => "Muokataksesi hakemistoasi, etsi \"Ylläpidä hakemistoja\" \"Hakemiston\" alta ohjelmisto valikosta, tai",
"To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or" => "Lisätäksesi/poistaaksesi UKK:siä, katso \"Ylläpidä UKK\" \"UKK:on\" alta ohjelmisto valikosta, tai",
"Settings" => "Asetukset",
"Watches" => "Vahdit",
"If you decide to store files in a directory you must ensure that the user cannot access directly to the directory." => "Jos valitset tallennuspaikaksi hakemiston sinun on oltava varma ettei käyttäjät pääse suoraan siihen hakemistoon.",
"You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>" => "Sinulla on kaksi vaihtoehtoa tähän:<br /><ul><li>Käytä hakemistoa joka on sivuston ulkopuolella, varmista, että php scripti voi lukea ja kirjoittaa siihen hakemistoon</li><li>Käytä hakemistoa sivuston sisäpuolella ja käytä .htaccess tiedostoa sulkemaan ulkopuoliset pois</li></ul>",
"To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/" => "Muokatessasi hakemisto polkua käytä UNIX polkuja esimerkki tiedostoissa/ tai c:/foo/tiedostot tai /www/tiedostot/",
"Home Gallery (main gallery)" => "Koti Galleria (pää galleria)",
"MIME Type" => "MIME Tyyppi",
"Reindex all files for search" => "Uudelleen indeksoi kaikki tiedostot etsintää varten",
"To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or" => "Lisätäksesi/poistaaksesi foorumeja, katso \"Ylläpidä foorumeja\"  \"Foorumien\" alta ohjelmisto valikosta, tai",
"Home Forum (main forum)" => "Koti Foorumi (pää foorumi)",
"Searches" => "Etsinnät",
"Browser width" => "Selain leveys",
"To add/remove image galleries, go to \"Image Galleries\" on the application menu, or" => "Lisätäksesi/poistaaksesi kuva gallerioita, mene \"Kuva Galleriat\" ohjelmisto valikosta, tai",
"You can upload images of a size of " => "Voit lähettää kuvia joiden koko on max ",
"Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value" => "Muokkaa php.ini muuttujaa file_uploads, upload_max_filesize, post_max_size ja tietokanta muuttujaa (max_allowed_packet for mysql) muuttaaksesi tätä arvoa",
"Home Gallery" => "Perus Galleria",
"Galleries features" => "Gallerioiden ominaisuudet",
"Uses Slideshow" => "Käytä Kuvaesitystä",
"Use database to store images" => "Käytä tietokantaa kuvien varastointiin",
"Use a directory to store images" => "Käytä hakemistoa kuvien varastointiin",
"Directory path" => "Hakemisto polku",
"Library to use for processing images" => "Kirjasto jota käytetään kuvien käsittelyyn",
"Uploaded image names must match regex" => "Lähetettyjen kuvien nimien täytyy olla yhteen sopiva regex kanssa",
"Uploaded image names cannot match regex" => "Lähetettyjen kuvien nimet eivät saa olla yhteen sopivia regex kanssa",
"Directory Batch Loading" => "Hakemiston Ryhmä Lataus",
"If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols" => "Jos käytät Hakemisto Ryhmä Latausta, sinun on tehtävä hakemisto sivuston ulkopuolelle (ulkopuolinen hakemisto on parempi). Aseta polku siihen hakemistoon, molemmat scp, ftp, tai muut protokollat",
"Enable directory batch loading" => "Oikeuta hakemisto ryhmä lataus",
"Batch loading directory" => "Ryhmä lataus hakemisto",
"Max Rows per page" => "Suurin rivi määrä per sivu",
"Images per row" => "Kuvia rivillä",
"Thumbnails size X" => "Minikuvien koko X",
"Thumbnails size Y" => "Minikuvien koko Y",
"pixels" => "pixeliä",
"Set features" => "Aseta ominaisuudet",
"Exterminator" => "Tuhoaja",
"Remove images in the system gallery not being used in Wiki pages, articles or blog posts" => "Poista kuvat sivuston galleriasta jos niitä ei ole käytetty sivuilla, artikkeleissa tai blogi lähetyksissä",
"All galleries" => "Kaikki galleriat",
"System Gallery" => "Järjestelmä galleria",
"Gallery listing configuration" => "Gallerian listaus asetukset",
"Parent" => "Isäntä",
"Last modified" => "Viimeksi muokattu",
"Change configuration" => "Muuta kokoonpanoa",
"Image galleries comments settings" => "Kuva gallerian kommenttien asetukset",
"General Preferences" => "Yleiset Oikeudet",
"Site Identity" => "Sivusto Identity",
"Username" => "Käyttäjänimi",
"Contact" => "Yhteys",
"Home Page" => "EtuSivu",
"Custom home" => "Muunneltu etusivu",
"Date and Time Formats" => "Päiväys ja Aika Muodot",
"Date and Time Format Help" => "Päiväys ja Aika Muoto Apu",
"Change admin password" => "Muuta admin salasana",
"Change password" => "Muuta Salasana",
"Syntax error" => "Syntaxi virhe",
"Intertiki client" => "Intertiki asiakas",
"Tiki Unique key" => "Tiki Ainutkertainen avain",
"InterTiki Slave mode" => "InterTiki Orja muoto",
"Warning: overrides manually registered local users" => "Waroitus: ylikirjoittaa käsin liitetyt paikalliset käyttäjät",
"as master" => "mestarina",
"Import user preferences" => "Tuo käyttäjä kokoonpanot",
"Import user groups" => "Tuo käyttäjäryhmät",
"InterTiki Server" => "InterTiki Palvelin",
"host" => "isäntä",
"port" => "portti",
"Add new server" => "Lisää uusi palvelin",
"Intertiki server" => "Intertiki palvelin",
"Intertiki Server enabled" => "Intertiki Palvelin käynnissä",
"Access Log file" => "Avaa Logi tiedosto",
"Errors Log file" => "Virheiden Logi tiedosto",
"Known hosts" => "Tunnetut isännät",
"Key" => "Avain",
"click here" => "paina tästä",
"Enable/disable Tiki features in " => "Päälle/pois Tiki ominaisuudet ",
", but configure them elsewhere" => ", mutta muokkaa kokoonpanoa muualla",
"Tiki and HTTP Auth" => "Tiki ja HTTP Auth",
"Registration" => "Rekisteröinti",
"Users can register" => "Käyttäjät voivat rekisteröityä",
"Account validated successfully." => "Tili varmistettu onnistuneesti.",
"Use challenge/response authentication" => "Käytä mahdollisuus/vastine varmistusta",
"Allow secure (https) login" => "Salli salattu (https) kirjautuminen",
"Require secure (https) login" => "Vaaditaan salattu (https) kirjautuminen",
"Duration:" => "Kesto:",
"Currently unused" => "Nyt käyttämätön",
"You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/." => "Sinun on lähetettävä myös <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> erikseen lib/phpcas/.",
"Version 1.0" => "Versio 1.0",
"Version 2.0" => "Versio 2.0",
"Users can change theme" => "Rekisteröityneet käyttäjät voivat vaihtaa teemaa",
"Restrict available themes" => "Rajoita saatavilla olevia teemoja",
"Available styles:" => "Saatavilla olevat tyylit:",
"Edit CSS" => "Muokkaa CSS",
"Theme Control" => "Teeman Hallinta",
"Tiki Template Viewing" => "Mallin näyttö",
"Edit Templates" => "Muokkaa malleja",
"General Layout options" => "Yleiset ulkoasun valinnat",
"logged as" => "kirjautunut",
"Alt. description (e.g. for text browsers)" => "Alt. kuvaus (e.g. teksti selaimille)",
"Subtitle" => "Alaotsikko",
"Site menu bar" => "Sivusto valikko palkki",
"Custom code" => "Muokattu koodi",
"Left column" => "Vasen palsta",
"always" => "aina",
"user decides" => "käyttäjä valitsee",
"Users can Flip Columns" => "Käyttäjä voi Vaihtaa Palstoja",
"Right column" => "Oikea palsta",
"Site location bar" => "Sivuston sijainti palkki",
"Larger font for" => "Suurempi kirjasin",
"Use page description:" => "Käytä sivun kuvausta:",
"Bottom bar" => "Ala palkki",
"Bottom bar icons" => "Alareunan ikonit",
"Bottom bar debug" => "Alareunan debug",
"Maximum number of records in listings" => "Asiakirjojen suurin määrä listauksessa",
"Use direct pagination links" => "Käytä suoria sivutuslinkkejä",
"Direction" => "Suunta",
"Vertical" => "Pystysuora",
"Horizontal" => "Vaakasuora",
"Use Tabs" => "Käytä Tabeja",
"Layout per section" => "Ulkoasu osastoittain",
"Admin layout per section" => "Ylläpidon ulkoasu osastoittain",
"Favicon icon file name:" => "Favicon icon tiedostonimi:",
"Favicon icon MIME type:" => "Favicon icon MIME tyyppi:",
"image/png" => "kuva/png",
"image/bmp" => "kuva/bmp",
"image/x-icon" => "kuva/x-icon",
"Generate User Map" => "Luo Käyttäjä Kartta",
"Robots" => "Robotit",
"To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or" => "Lisätäksesi/poistaaksesi äänestyksiä, katso \"Äänestykset\" \"Ylläpito\" ohjelmisto valikossa, tai",
"Waiting" => "Odottaa",
"Last update" => "Viimeisin päivitys",
"Image galleries" => "Kuva galleriat",
"Feed for forums" => "Syöte foorumeille",
"Specification" => "Tuoteseloste",
"You can see users rank by score in the module users_rank, for that go to" => "Voit nähdä käyttäjien arvostuksen pisteinä käyttäen users_rank moduulia.",
"Admin modules" => "Ylläpidä moduuleja",
"Expiration" => "Päättyminen",
"Refresh wiki search index now" => "Päivitä etsintä indeksi nyt",
"Automonospaced text" => "Autotasalevyinen teksti",
"Tables syntax" => "Taulukon syntaksi",
"|| for rows" => "|| riveille",
"AutoLinks" => "AutoLinkit",
"Hotwords" => "Kuumasanat",
"rows" => "rivit",
"Required" => "Pakollinen",
"Parameters" => "Kokoonpanot",
"To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or" => "Muokataksesi kortistoja, katso \"Ylläpidä kortistoja\" \"Kortiston\" alla ohjelmisto valikossa, tai",
"Use database to store files" => "Käytä tietokantaa tiedostojen varastointiin",
"Use a directory to store files" => "Käytä hakemistoa tiedostojen varastointiin",
"Storage" => "Varasto",
"Change all to db" => "Muuta kaikki tietokantaan",
"Change all to file" => "Muuta kaikki tiedostoon",
"Trackers with mirror tables" => "Kortistot ja peilaus taulukot",
"Use trackers with mirror tables" => "Käyttäjä kortistot ja peilaus taulukot",
"Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki" => "Arvot tallennetaan niille omistettuun taulukkoon jokaiseen kortistoon, joten voi helposti muokata niitä sivuston ulkopuolella",
"Validate choice" => "Varmista valinta",
"Quota (Mb)" => "Levytila (Mb)",
"Use database to store userfiles" => "Käytä tietokantaa käyttäjätiedostojen varastointiin",
"Use a directory to store userfiles" => "Käytä hakemistoa käyttäjätiedostojen varastointiin",
"Create New" => "Luo uusi",
"List authors" => "Listaa kirjoittajat",
"Not Installed" => "Ei Asennettu",
"Warn on edit conflict" => "Varoita muokkaus ristiriidoista",
"Undo" => "Peruuta",
"Footnotes" => "Alaviitteet",
"Permission" => "Oikeudet",
"Allow HTML" => "Salli HTML",
"Sandbox" => "Hiekkaloota",
"Dumps" => "Dumpit",
"Remove a tag" => "Poista kiinnike",
"Generate dump" => "Luo dumppi",
"Download last dump" => "Imuroi viimeisin dumppi",
"Pictures" => "Kuvat",
"Remove unused pictures" => "Poista käyttämättömät kuvat",
"Export" => "Vie",
"Export Wiki Pages" => "Vie Wiki Sivut",
"Accept dashes and underscores in WikiWords" => "Hyväksy alleviivaus ja keno Sanoissa",
"Link plural WikiWords to their singular forms" => "Linkitä monikko WikiSanat yksikkö muotoon",
"Only with last version" => "Vain viimeisimmän version kanssa",
"Side-by-side diff" => "Erot rinnakkain",
"Discuss pages on forums" => "Keskustelua fooruminsivuista",
"Similar" => "Samanlainen",
"Structures" => "Rakenteet",
"Open page as structure" => "Avaa sivu rakenteena",
"Import HTML" => "Tuo HTML",
"Page creators are admin of their pages" => "Sivu luoja on ylläpitäjä luomilleen sivuille",
"Create watch for author on page creation" => "Luo vahti sivun luojaan",
"Enable watch events when I am the editor" => "Mahdollista vahti kun olen muokkaajana",
"Enable watches on comments" => "Salli vahdit kommenteille",
"Links" => "Linkit",
"Wiki 3D Browser Configuration" => "3D Selain Kokoonpano",
"Wiki attachments" => "Wiki liitteet",
"Change" => "Muuta",
"Crosslinks to other features and settings" => "Ristiviittaukset muihin ominaisuuksiin ja asetuksiin",
"Other sections" => "Muut osastot",
"Spreadsheet" => "Laskentataulukko",
"Shoutbox Words" => "Pikaviestin Sanat",
"Live Support" => "Elävä Tuki",
"Contact us" => "Ota yhteyttä",
"Administration features" => "Ylläpidon ominaisuudet",
"SysLogs" => "JärLogit",
"Mods" => "Modulit",
"Banning" => "Esto",
"Transversal features" => "Käännös ominaisuudet",
"which apply to more than one section" => "jotka lisätään useampaan kuin yhteen osastoon",
"Mail Notifications" => "Posti ilmoitukset",
"Navigation features" => "Siirtymis omaisuudet",
"Look & feel" => "Ulkonäkö &amp; fiilis",
"themes" => "teemat",
"Text area features" => "Tekstialue ominaisuudet",
"features you can use in all text areas, like wiki pages, blogs, articles, forums, etc" => "ominaisuudet joita voi käyttää kaikkialla, sivuston sivuilla, blogeissa, artikkeleissa, foorumeilla, jne",
"Cookies" => "Keksit",
"Content Templates" => "Sisältö Mallit",
"Stats &amp; banners" => "Tilastot &amp; bannerit",
"Search Stats" => "Etsintä Tilastot",
"Category:" => "Luokka:",
"Statistics" => "Tilastot",
"Weeks" => "Viikkoa",
"Setting" => "Asetus",
"viewed" => "näytetty",
"Add or edit a rule" => "Lisää tai muuta sääntö",
"Rule title" => "Säännön otsikko",
"Username regex matching" => "Käyttänimi regex yhdenmukaisuuus",
"IP regex matching" => "IP regex yhdenmukaisuus",
"Banned from sections" => "Osastot estetty",
"Rule activated by dates" => "Säännön aktivointi päivä",
"Rule active from" => "Sääntö voimassa",
"Rule active until" => "Sääntö voimassa kunnes",
"Custom message to the user" => "Muunneltu viesti käyttäjälle",
"Rules" => "Säännöt",
"User/IP" => "Käyttäjä/IP",
"Sections" => "Osastot",
"Admin Calendars" => "Ylläpidä Kalentereita",
"List of Calendars" => "Kalenterien lista",
"Loc" => "Pai",
"Participants" => "Osalliset",
"Cat" => "Luet",
"Lang" => "Kieli",
"Prio" => "Ensis",
"Subscription" => "Tilaukset",
"Perso" => "Henkilö",
"Custom Locations" => "Muunnellut Sijainnit",
"Custom Participants" => "Muutetut Osallistujat",
"Custom Categories" => "Muunnellut Luokittelut",
"Custom Languages" => "Muunnellut Kielet",
"Custom Subscription List" => "Muutettujen Tilausten Lista",
"Custom Priorities" => "Muunnellut Etuoikeudet",
"Personal Calendar" => "Henkilökohtainen Kalenteri",
"Red" => "Punainen",
"Current category" => "Nykyinen luokka",
"Child categories" => "Ala luokittelut",
"Edit permissions for this category" => "Muokkaa tämän luokan oikeuksia",
"Edit this category:" => "Muokkaa tätä luokkaa:",
"Add new category" => "Lisää uusi luokka",
"Objects in category" => "Kohteita luokassa",
"No records found." => "Ei löydy tallennetta.",
"Add objects to category" => "Lisää kohteita luokkaan",
"Admin templates" => "Ylläpidä malleja",
"Edit this template:" => "Muuta tätä mallia:",
"Create new template" => "Luo uusi malli",
"Use wysiwyg editor" => "Käytä wysiwyg muokkainta",
"Use normal editor" => "Käytä tavallista muokkainta",
"HTML Pages" => "HTML Sivut",
"Templates" => "Mallit",
"Admin cookies" => "Ylläpidä keksejä",
"To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}." => "Keksien käyttö tekstialueella kuten (sivulla, jne), <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">moduuli</a> tai malli, käytä {literal}{cookie}{/literal}.",
"Create/edit cookies" => "Luo/muuta keksejä",
"Upload Cookies from textfile" => "Lähetä Keksit tekstiedostosta",
"Upload from disk:" => "Lähetä kovalevyltä:",
"Upload" => "Lähetä",
"Remove all cookies" => "Poista kaikki keksit",
"cookie" => "keksi",
"Admin dsn" => "Ylläpidä dsn",
"Use Admin DSN to define the database to be used by the SQL plugin." => "Käytä Ylläpidä DSN määrittääksesi tietokannan jota SQL plugin käyttää.",
"Create/edit dsn" => "Luo/muokkaa dsn",
"Admin external wikis" => "Ylläpidä ulkoiset wikit",
"View template" => "Näytä malli",
"tiki admin external wikis template" => "sivusto ylläpito ulkoisten sivujen malli",
"Edit template" => "Muokkaa mallia",
"Create/Edit External Wiki" => "Luo/muuta Ulkoinen Wiki",
"URL (use \$page to be replaced by the page name in the URL example: http://www.example.com/tiki-index.php?page=\$page)" => "URL (käytä \$sivua korvaamaan sivun nimeltä URL esimerkki: http://www.example.com/tiki-index.php?page=\$page)",
"ExtWiki" => "Extwiki",
"Admin Forums" => "Ylläpidä Foorumeja",
"Create new forum" => "Luo uusi foorumi",
"List forums" => "Listaa foorumit",
"Coms" => "Kom",
"Age" => "Ikä",
"PPD" => "Ppd",
"Edit this Forum:" => "Muokkaa tätä Foorumia:",
"Create New Forum" => "Luo Uusi Foorumi",
"There are individual permissions set for this forum" => "Tälle foorumille on erityisoikeudet",
"Name:" => "Nimi:",
"Create new" => "Luo uusi",
"Password protected" => "Salasana suojattu",
"Forum password" => "Foorumin salasana",
"Topic list configuration" => "Aihe listan kokoonpano",
"Posts can be rated" => "Lähetykset voi arvostella",
"Display last post titles" => "Näytä viimeiset otsikot",
"Forward messages to this forum to this e-mail address, in a format that can be used for sending back to the inbound forum e-mail address" => "Lähetä tämän foorumin lähetykset tähän osoitteeseen, siinä muodossa, että vastauksen voi lähettää sähköpostilla foorumille",
"Send mails even when the post is generated by inbound mail" => "Lähetä viestit vaikka posti olisi luotu saapuneista",
"Append a reply link to outbound mails" => "Lisää vastaus linkki lähteviin posteihin",
"Originating e-mail address for mails from this forum" => "Alkuperäinen sähköpostiosoite lähetyksille tältä foorumilta",
"Add messages from this email to the forum" => "Liisää viestit tästä sähköpostiosoitteesta foorumille",
"Use topic smileys" => "Käytä aihe hymiöitä",
"Show topic summary" => "Näytä aiheen yhteenveto",
"User information display" => "Käyttäjä tietojen näyttö",
"Online" => "Linjalla",
"Approval type" => "Hyväksyttävä tyyppi",
"Store attachments in:" => "Varastoi liitteet:",
"Admin Hotwords" => "Ylläpidä Hotwords",
"Add Hotword" => "Lisää Hotword",
"Word" => "Sana",
"Admin HTML pages" => "Ylläpidä HTML sivuja",
"Edit this page" => ">Muokkaa tätä sivua",
"View page" => "Näytä sivu",
"Edit zone" => "Muokkaa aluetta",
"Dynamic zones" => "Muuttuvat alueet",
"zone" => "alue",
"content" => "sisältö",
"Mass update" => "Massa päivitys",
"Create new HTML page" => "Luo uusi HTML sivu",
"Edit this HTML page:" => "Muokkaa tätä HTML sivua:",
"Apply template" => "Lisää malli",
"Dynamic" => "Muuttuva",
"Static" => "Muuttumaton",
"Last Modif" => "Viimeki muokannut",
"Edit Repository:" => "Muokkaa Säilytyspaikkaa:",
"Create New Repository" => "Luo Uusi Säilytyspaikka",
"List Repositories" => "Lista säilytyspaikoista",
"New Repository" => "Uusi säilytyspaikka",
"View Repository" => "Näytä säilytyspaikka",
"Human readable repository name" => "Luettavissa oleva säilytyspaikan nimi",
"Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')" => "Polku säilytyspaikkaan (paikallinen järjestelmä: suhteellinen/täydellinen web root, etäinen: alkuosa 'http://')",
"File name of start page" => "Aloitus sivun tiedosto nimi",
"Start page" => "Aloitus sivu",
"CSS file to load when browse this repository" => "CSS tiedosto joka ladataan kun selataan tätä säilytyspaikkaa",
"CSS file" => "CSS tiedosto",
"Is repository visible to users" => "Onko tämä säilytyspaikka kaikille näkyvä",
"Can files from repository be cached" => "Voiko säilytyspaikan tiedostoja puskuroida",
"Cacheable" => "Puskuroitavissa",
"Are files from repository can be cached" => "Onko säilytyspaikan tiedostot puskuroitavissa",
"Clear all cached pages of this repository" => "Tyhjennä sivu puskurit tästä tallennuspaikasta",
"Clear cache" => "Tyhjennä puskuri",
"Seconds count 'till cached page will be expired" => "Aika laskuri 'kunnes puskurointi päättyy",
"Cache expiration" => "Puskuroinnin päättyminen",
"Human readable text description of repository" => "Luettavissa oleva säilytyspaikan kuvaus",
"Available Repositories" => "Saatavilla olevat säilytyspaikat",
"CSS File" => "CSS tiedosto",
"Edit rules" => "Muuta sääntöjä",
"Edit Rules for Repository:" => "Muuta Säilytyspaikan Sääntöjä:",
"Configure Repositories" => "Säilytyspaikan kokoonpano",
"Configure this Repository" => "Muuta säilytyspaikan kokoonpanoa",
"View this Repository" => "Näytä tämä säilytyspaikka",
"New Rule" => "Uusi sääntö",
"Copy Rules" => "Kopio säännöt",
"view/hide copy rules dialog" => "näytä/piilota kopio sääntöjen vuoropuhelusta",
"Source repository" => "Lähde säilytyspaikka",
"Copy" => "Kopio",
"According this order rules will be applied ('0' or empty = auto)" => "Tämän määräyksen mukaan sääntöjä käytetään ('0' tai tyhjä = auto)",
"Rule order" => "Sääntö järjestys",
"Text to search for" => "Teksti jota etsitään",
"Text to replace" => "Korvattava teksti",
"Is this regular expression or simple search/replacer" => "Onko tämä normaali ilmaisu vai yksinkertainen etsi ja korvaa",
"Is case sensitive (for simple replacer)" => "Erotetaanko isot ja pienet (yksinkertaiseen korvaamiseen)",
"Case sensitive" => "Erota isot ja pienet",
"subset of chars: imsxeADSXUu, which is regex modifiers" => "osajoukko kirjaimia: imsxeADSXUu, jotka ovaat regex modifiers",
"Regex modifiers" => "Regex muokkaajat",
"Human readable text description of rule" => "Luettavissa oleva teksti kuvauksen sääntö",
"Check to enable this rule" => "Merkitse sääntö käyttöön",
"Enabled" => "Käynnistetty",
"Preview options" => "Näyttö asetukset",
"Apply all rules or just this to generate preview" => "Lisää kaikki säännöt tai vain tähän näytön muodostukseen",
"Apply all rules" => "Liitä kaikki säännöt",
"View source code after rules applied" => "Näytä koodi sääntöjen lisäämisen jälkeen",
"Code preview" => "Koodi näyttö",
"Generate HTML preview" => "Muodosta HTML näyttö",
"HTML preview" => "HTML näyttö",
"Test file from repository to generate preview for (empty = configured start page)" => "Testaa säilytyspaikan tiedosto muodostaaksesi näyttö (tyhjä = aloitus sivun asetukset)",
"Preview Results" => "Näytä Tulokset",
"Rules List" => "Sääntö luettelo",
"Case" => "Tapaus",
"Configure/Options" => "Kokoonpano/Asetukset",
"Admin layout" => "Ylläpidä layout",
"Theme control" => "Teema hallinta",
"layout options" => "layout asetukset",
"Top bar" => "Ylä palkki",
"Generate positions by hits" => "Muodosta paikat osumien perusteella",
"List of featured links" => "Ominaisuuslinkkien lista",
"Position" => "Paikka",
"Add Featured Link" => "Lisää Ominaisuus Linkki",
"Edit this Featured Link:" => "Muuta tätä Ominaisuus Linkkiä:",
"Create new Featured Link" => "Luo Uusi Ominaisuus Linkki",
"disables the link" => "poistaa linkin",
"Link type" => "Linkin tyyppi",
"replace current page" => "korvaa nykyisen sivun",
"framed" => "kehystetty",
"open new window" => "avaa uuden ikkunan",
"Mail-in accounts" => "Postit-sisään tilit",
"Account" => "Tili",
"Add new Mail-in account" => "Lisää uusi postit-sisään tili",
"Edit Mail-in account" => "Muokkaa postit-sisään tiliä",
"Account name" => "Tilin nimi",
"POP server" => "POP palvelin",
"SMTP server" => "SMTP palvelin",
"SMTP requires authentication" => "SMTP tarvitsee kirjautumisen",
"article-put" => "artikkeli-laita",
"wiki-get" => "w-get",
"wiki-put" => "w-put",
"wiki-append" => "w-append",
"Article Topic" => "Artikkelin Aihe",
"Admin Topics" => "Ylläpidä Aiheita",
"Article Type" => "Artikkelin Tyyppi",
"Admin Types" => "Ylläpidon tyypit",
"Active" => "Aktiivinen",
"Allow anonymous acces" => "Salli nimetön pääsy",
"Allow attachments" => "Salli liitteet",
"Discard to the end from" => "Poista loppuosa tästä",
"Check Mail-in accounts" => "Tarkista postit-sisään tilit",
"Check automatically" => "Tarkista automaattisesti",
"Frequency" => "Yleisyys",
"List menus" => "Listaa valikot",
"Edit this menu" => "Muokkaa tätä valikkoa",
"Edit menu options" => "Muuta valikko asetuksia",
"Show Quick Urls" => "Näytä Pika Url:it",
"Some useful URLs" => "Käyttökelpoisia URL:ja",
"Hide Quick Urls" => "Piilota Pika Url:it",
"option" => "valinnainen",
"separator" => "erotin",
"Choose" => "Valitse",
"Home Blog" => "OmaBlogi",
"Home Image Gal" => "Oma Kuva Gal",
"Home Image Gallery" => "Oma Kuva Galleria",
"Home File Gal" => "Oma Tiedosto Gal",
"Home File Gallery" => "Oma Tiedosto Galleria",
"User preferences" => "Käyttäjä kokoonpano",
"User prefs" => "Käyttäjä kokoonpano",
"List galleries" => "Listaa galleriat",
"List image galleries" => "Listaa kuva galleriat",
"Upload image" => "Lähetä kuva",
"Gallery Rankings" => "Galleria Arvostukset",
"Browse a gallery" => "Selaa galleriaa",
"Articles home" => "Artikkelien koti",
"All articles" => "Kaikki artikkelit",
"Submit" => "Lähetä",
"List Blogs" => "Listaa Blogit",
"Create blog" => "Luo blogi",
"View a forum" => "Näytä foorumi",
"View a thread" => "Näytä ketju",
"View a FAQ" => "Näytä UKK",
"Take a quiz" => "Ota visailu",
"Quiz stats" => "Visailu tilastot",
"Stats for a Quiz" => "Tilastot visailuun",
"Preview menu" => "Edellinen valikko",
"Menu options" => "Valikko valinnat",
"Options" => "Vaihtoehdot",
"Active Permissions" => "Aktiiviset oikeudet",
"Edit this Menu:" => "Muuta tätä Valikkoa:",
"Create new Menu" => "Luo uusi Valikko",
"dynamic collapsed" => "muuttuva kokoon taittuva",
"dynamic extended" => "muuttuva laajentuva",
"fixed" => "vakio",
"Clear Cache" => "Tyhjennä puskuri",
"Assigned Modules" => "Liitetyt Moduulit",
"Left Modules" => "Moduulit Vasemmalla",
"Move to Right Column" => "Siirrä oikeaan palstaan",
"Right Modules" => "Moduulit Oikealla",
"Move to Left Column" => "Siirrä vasempaan palstaan",
"Assign new module" => "Liitä uusi moduuli",
"Edit this assigned module:" => "Muokkaa tätä liitettyä moduulia:",
"Cache Time" => "Puskurointi Aika",
"Visibility" => "Näkyvyys",
"Displayed now for all eligible users even with personal assigned modules" => "Näytetään halutuille käyttäjille vaikka heillä on omia moduuleja",
"Displayed for the eligible users with no personal assigned modules" => "Näytetään halutuille käyttäjille joilla ei ole omia moduuleja",
"Displayed now, can't be unassigned" => "Näytetään nyt, ei voi poistaa liitosta",
"Not displayed until a user chooses it" => "Ei näytetä ellei käyttäjä valitse sitä",
"User Modules" => "Käyttäjä Moduulit",
"Create new user module" => "Luo uusi käyttäjä moduuli",
"Edit this user module:" => "Muokkaa tätä käyttäjä moduulia:",
"Must be wiki parsed" => "Oltava wiki jäsennetty",
"Objects that can be included" => "Kohteet jotka voidaan lisätä",
"Random active poll" => "Satunnaisaktiivinen äänestys",
"Random current poll" => "Satunnasinykyinen äänestys",
"Use Poll" => "Käytä äänestystä",
"Use Gallery" => "Käytä galleriaa",
"Use Dynamic Content" => "Käytä muuttuvaa sisältöä",
"Use RSS Module" => "Käytä rss moduulia",
"Use Menu" => "Käyttäjä valikko",
"Use phplayermenu" => "Käytä phplayervalikkoa",
"Use Banner Zone" => "Käytä banneri aluetta",
"Structures:" => "Rakenteet:",
"Data" => "Tietue",
"Admin newsletter subscriptions" => "Ylläpidä uutislehden tilauksia",
"List Newsletters" => "Listaa uutislehdet",
"Admin Newsletters" => "Ylläpidä uutislehtiä",
"Send Newsletters" => "Lähetä Uutislehti",
"Add a subscription newsletters" => "Lisää tilaus uutislehtiin",
"Email:" => "Sähköposti:",
"Add email:" => "Lisää sähköposti:",
"Add user:" => "Lisää käyttäjä:",
"Group subscription also subscribes included groups" => "Ryhmä tilaus sisältää myös sisältävät ryhmät",
"Don't send confirmation mail" => "Älä lähetä varmistus postia",
"The user email will be refreshed at each newsletter sending" => "Käyttäjän sähköposti varmistetaan jokaisen uutiskirjeen yhteydessä",
"Subscribe group" => "Tilaa ryhmälle",
"Included group, group users and emails will be refreshed at each newsletter sending" => "Sisällytetyt ryhmät, ryhmän jäsenet ja sähköpostit varmistetaan jokaisen uutiskirjeen yhteydessä",
"Subscriptions" => "Tilaukset",
"Valid" => "Hyväksytty",
"Subscribed" => "tilattu",
"Admin newsletters" => "Ylläpidä uutislehteä",
"Editions" => "Laitokset",
"Last Sent" => "Viimeksi lähetetty",
"Create/Edit Newsletters" => "<Luo/muokkaa uutislehteä",
"There are individual permissions set for this newsletter" => "Tälle uutislehdelle on asetettu erityioikeudet",
"Users can subscribe/unsubscribe to this list" => "Käyttäjät voivat tilata/peruuttaa tämän listan",
"Users can subscribe any email address" => "Käyttäjä voi tilata millä tahansa sähköpostiosoitteella",
"Add unsubscribe instructions to each newsletter" => "Lisää peruutus ohjeet jokaiseen uutislehteen",
"Validate email addresses" => "Varmista sähköpostiosoitteet",
"Add notification" => "Lisää ilmoitus",
"Event" => "Tapahtuma",
"edit" => "muokkaa",
"remove" => "poista",
"Update" => "Päivitä",
"List polls" => "Listaa äänestykset",
"Edit this poll" => "Muokkaa tätä äänestystä",
"Preview poll" => "Näytä äänestystä",
"Poll options" => "Äänestys vaihtoehdot",
"Votes" => "Ääniä",
"Admin Polls" => "Ylläpidä Äänestyksiä",
"Set last poll as current" => "Aseta viimeisin äänestys nykyiseksi",
"Close all polls but last" => "Sulje kaikki äänestykset paitsi viimeinen",
"Activate all polls" => "Käynnistä kaikki äänestykset",
"active" => "aktiivinen",
"current" => "nykyinen",
"object" => "kohde",
"PublishDate" => "JulkaisuPäivä",
"Results" => "Tulokset",
"Wiki pages" => "Sivuja",
"Content for the feed" => "Syötteen sisältö",
"Security Admin" => "Turvallisuus Ylläpito",
"To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>." => "<a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">ilmoita turvallisuus aiheista</a>.",
"PHP settings" => "PHP asetukset",
"PHP variable" => "PHP muuttujat",
"Risk Factor" => "Riski Kerroin",
"Explanation" => "Selvitys",
"Tiki variable" => "Sivusto muuttuja",
"Check all tiki files" => "Tarkista kaikki sivuston tiedostot",
"Note, that this can take a very long time. You should check your max_execution_time setting in php.ini." => "Huomaa, tämä voi viedä kauan aikaa. Sinun on tarkistettava max_execution_time asetus php.ini:ssä.",
"File checks" => "Tiedosto tarkistukset",
"user" => "käyttäjä",
"group" => "ryhmä",
"sticky" => "pysyvä",
"Admin Shoutbox Words" => "Ylläpidä Pikaviestin Sanoja",
"Add Banned Word" => "Lisää Poisto Sana",
"Are you sure you want to delete this word?" => "Oletko varma, että haluat poistaa tämän sanan?",
"Destroy the structure leaving the wiki pages" => "Poista rakenne poistuessa sivuilta",
"Destroy the structure and remove the pages" => "Poista rakenne ja poista sivut poistuessa",
"Export Pages" => "Tulosta sivut",
"Dump Tree" => "Dumppi puu",
"Create WebHelp" => "Luo WebApu",
"View WebHelp" => "Näytä webapu",
"Create new structure" => "Luo uusi rakenne",
"Tree" => "Puu",
"Use single spaces to indent structure levels" => "Käytä sanaväliä sisennykseen osoittamaan rakenne tasoja",
"Create New Structure" => "Luo uusi rakenne",
"List surveys" => "Listaa tutkimukset",
"Survey Stats" => "Tutkimus tilastot",
"Edit this Survey" => "Muuta tätä tutkimusta",
"Admin Surveys" => "Ylläpidä tutkimuksia",
"Question" => "Kysymys",
"One choice" => "Yksi valinta",
"Multiple choices" => "Moni valinta",
"Short text" => "Lyhyt teksti",
"Rate (1..5)" => "Luokittele (1..5)",
"Rate (1..10)" => "Luokittele (1..10)",
"Rate" => "Kerroin",
"Options (if apply)" => "Vaihtoehdot (jos lisätty)",
"Questions" => "Kysymykset",
"Admin surveys" => "Ylläpidä tutkimuksia",
"List Surveys" => "Listaa Tutkimukset",
"Edit this Survey:" => "Muokkaa tätä tutkimusta:",
"Create New Survey" => "Luo Uusi Tutkimus",
"There are individual permissions set for this survey" => "Tälle tutkimukselle on erityisoikeudet",
"Open" => "Avaa",
"Closed" => "Suljettu",
"If your Tiki is acting weird, first thing to try is to clear your cache below. Also very important is to clear your cache after an upgrade (by FTP/SSH when needed)." => "Jos sivustosi käyttäytyy oudosti, kokeile ensimmäiseksi tyhjentää puskuri alhaalta. Tärkeää on myös päivityksen jälkeinen puskurin tyhjennys (FTP/SSH tarvittaessa).",
"Empty" => "Tyhjennä",
"Advanced feature" => "Kehittyneempi ominaisuus",
"Fix UTF-8 Errors in Tables" => "Korjaa UTF-8 Virheet taulukoihin",
"Warning: Make a backup of your Database before using this function!" => "Waroitus: Tee varmuuskopio tietokannastasi ennen kuin käytät tätä!",
"Warning: If you try to convert large tables, raise the maximum execution time in your php.ini!" => "Waroitus: Jos yrität muuntaa suuria taulukoita, nosta scriptin maximi ajoaikaa php.ini:ssä!",
"This function converts ISO-8859-1 encoded strings in your tables to UTF-8" => "Tämä muuntaa ISO-8859-1 merkkijonot tietokannassa UTF-8 muotoon",
"This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1" => "Tämä voi olla välttämätöntä jos olet käyttänyt aiemmin &lt; 1.8.4 ja Oletus kirjaimisto oli ISO-8859-1",
"UTF-8 Errors fixed" => "UTF-8 Virheet korjattu",
"Investigate" => "Tutki",
"Fix it" => "Korjaa se",
"Create a new topic" => "Luo uusi aihe",
"Topic Name" => "Aiheen Nimi",
"Upload Image" => "Lähetä Kuva",
"List of topics" => "Listaa aiheet",
"Articles (subs)" => "Artikkelit (subs)",
"topic image" => "aihe kuva",
"Deactivate" => "PuraAktivointi",
"Remove with articles" => "Poista artikkelin mukana",
"List Trackers" => "Listaa Kortistot",
"Admin Trackers" => "Ylläpidä kortistoja",
"Edit This Tracker" => "Muokkaa tätä kortistoa",
"View This Tracker's Items" => "Näytä tämän kortiston osat",
"Tracker fields" => "Kortiston kentät",
"Mandatory" => "Pakollinen",
"Is column visible when listing tracker items?" => "Onko palsta näkyvä kun listataan kortiston osia?",
"Column links to edit/view item?" => "Palstan linkit muuta/näytä osa?",
"isMain" => "onPää",
"Searchable" => "Etsittävissä",
"Hidden" => "Piilotettu",
"Edit tracker field" => "Muokkaa kortiston kenttiä",
"Field is mandatory?" => "Kenttä on pakollinen?",
"Column is searchable?" => "Palsta on etsittävissä?",
"Import/Export Trackers Fields" => "Tuonti/vienti kortiston kentistä",
"Found" => "Löytyi",
"trackers" => "kortistot",
"with" => " ",
"Edit Tracker" => "Muuta kortisto",
"There are individual permissions set for this tracker" => "Tälle kortistolle on erityisoikeudet",
"No individual permissions. Global permissions apply." => "Ei erityisoikeuksia yleiset oikeudet liitetään",
"Use \"explicit\" names in the mirror table" => "Käytä \"avoimia\" nimiä peili taulukolle",
"Show status" => "Näytä tila",
"Default status displayed in list mode" => "Oletus tila näytetään listauksen yhteydessä",
"Show status to tracker admin only" => "Näytä kortiston tila vain ylläpitäjälle",
"Send copies of all activity in this tracker to this e-mail address" => "Lähetä kopio kaikesta toiminnosta tässä kortistossa tähän sähköpostiosoitteeseen",
"Use simplified e-mail format" => "Käytä yksinkertaista sähköposti muotoa",
"New items are created with status" => "Uudet osat luodaa tilan kanssa",
"Authoritative status for modified items" => "Arvovaltainen tila muokatuille osille",
"No change" => "Ei muutosta",
"Item creator can modify his items?" => "Voiko osan luoja muokata osaansa?",
"The tracker needs a user field with the option 1" => "Kortisto tarvitsee käyttäjä kentän jolla on vaihtoehto 1",
"The tracker needs a group field with the option 1" => "Kortisto tarvitsee ryhmä kentän jolla on vaihtoehto 1",
"Show creation date when listing tracker items?" => "Näytä luonti päivä kun listataan kortiston osia?",
"Show lastModif date when listing tracker items?" => "Näytä viimeksi muokkauspäivä kun listataan kortiston osia?",
"What field is used for default sort?" => "Mitä kenttää käytetään oletus lajittelussa?",
"What is default sort order in list?" => "Mikä on oletus järjestys listauksessa?",
"ascending" => "nouseva",
"descending" => "laskeva",
"Tracker items allow ratings?" => "Kortisto osat sallii luokitukset?",
"with values" => "arvoilla",
"and display rating results in listing?" => "ja näyttää luokitus tulokset listalla?",
"Tracker items allow comments?" => "Sallitaanko kortiston osien kommentointi?",
"and display comments in listing?" => "ja näyttää kommentit listauksessa?",
"Tracker items allow attachments?" => "Sallitaanko kortiston osien liitteet?",
"and display attachments in listing?" => "ja näyttää liitteet listauksessa?",
"Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)" => "Liitteiden näyttö vaihtoehdot (Käytä numeroita osien järjestämiseen, 0 ei näytetä, ja negatiivinen näytetään popupeissa)",
"Filesize" => "Tiedostokoko",
"Filetype" => "Tiedostoyyppi",
"LongDesc" => "Pitkäkuvaus",
"Import/Export" => "Tuonti/vienti",
"Import/export trackers" => "Tuo/vie kortistoja",
"Admin groups" => "Ylläpidä ryhmiä",
"Admin users" => "Ylläpidä käyttäjiä",
"Add new group" => "Lisää uusi ryhmä",
"List of existing groups" => "Lista olemassa olevista ryhmistä",
"Edit group" => "Muokkaa ryhmää",
"Add a New Group" => "Lisää uusi ryhmä",
"Use wiki page name or full URL" => "Käytä sivunnimeä tai koko URL polkua",
"Group Information Tracker" => "Ryhmä Tietojen Kortisto",
"choose a group tracker ..." => "valitse ryhmä kortisto ...",
"choose a field ..." => "valitse kenttä ...",
"Users Information Tracker" => "Käyttäjän Tietojen Kortisto",
"choose a users tracker ..." => "valitse käyttäjien kortisto ...",
"Group tracker item : {\$groupitemid}" => "Ryhmitä kortisto osa : {\$groupitemid}",
"Edit Item" => "Muuta osaa",
"Group tracker item not found" => "Ryhmä kortiston osaa ei löydy",
"Members" => "Jäsenet",
"Remove from Group" => "Poista ryhmäsät",
"users in group" => "käyttäjät ryhmässä",
"CSV File" => "CSV Tiedosto",
"Add a New User" => "Lisää uusi käyttäjä",
"Reason" => "Syy",
"Registered" => "Rekisteröity",
"to groups" => "ryhmiin",
"Edit Included Group" => "Muokkaa sisällytettyä ryhmää",
"Manage Group Assignments" => "Hallitse ryhmä liitoksia",
"Set Default Groups" => "Aseta oletus ryhmät",
"Assign selected to" => "Liitä valitut",
"Remove selected from" => "Poista valitut",
"the following groups:" => "seuraaviin ryhmistä:",
"Tip: Hold down CTRL to select multiple" => "Vihje: paina CTRL alas valitaksesi useampia",
"bcc" => "varmuuskopio",
"Edit user" => "Muokkaa käyttäjää",
"Generate a password" => "Luo salasana",
"User tracker item : {\$usersitemid}" => "Käyttäjän kortiston osa : {\$usersitemid}",
"Overwrite" => "Päällekirjoita",
"Source" => "Lähde",
"Admin Article Types" => "Ylläpidä Artikkeli Tyyppejä",
"List of types" => "Listaa tyypit",
"Shows up in the drop down list of article types" => "Tulee näkyviin artikkeli tyyppien alasveto valikossa",
"Allow ratings by the author" => "Sallii arvostelun kirjoittajalta",
"Show before publish date" => "Näytä ennen julkaisu päivää",
"non-admins can view before the publish date" => "muut kuin ylläpito voivat nähdä ennen julkaisupäivää",
"Show after expire date" => "Näytä poistumis päivän jälkeen",
"non-admins can view after the expire date" => "muut kuin ylläpito voivat nähdä päättymispäivän jälkeen",
"Heading only" => "Vain pääosat",
"No article body, heading only" => "Ei artikkelirunkoa, vain pääosa",
"Allow comments for this type" => "Salli kommentit tälle tyypille",
"Comment Can Rate Article" => "Kommentti voi vauhdittaa Artikkelia",
"Allow comments to include a rating value" => "Salli kommentin sisältävän arvostus arvon",
"Show image" => "Näytä kuva",
"Show topic or own image" => "Näytä aihe tai kuva",
"Show avatar" => "Näytä hahmo",
"Show author's avatar" => "Näytä kirjoittajan hahmo",
"Show author" => "Näytä kirjoittaja",
"Show author name" => "Näytä kirjoittajan nimi",
"Show publish date" => "Näytä julkaisu päivä",
"Show expire date" => "Näytä poistumis päivä",
"Show reads" => "Lukijoita",
"Show the number of times the article was read" => "Näytä montako kertaa artikkeli on luettu",
"Show size" => "Näytä koko",
"Show the size of the article" => "Näytä artikkelin koko",
"Show topline" => "Näytä ylärivi",
"Show a small title over the title" => "Näytä pieni aihe varsinaisen aiheen yläpuolella",
"Show subtitle" => "Näytä alaotsikko",
"Show the subtitle" => "Näytä Alaotsikko",
"Show source" => "Näytä lähde",
"Show link to source after article body" => "Näytä lähteen linkki artikkelin lopussa",
"Show Image Caption" => "Näytä KuvaTeksti",
"Show a legend under the image" => "Näytä seloste kuvan alla",
"Show Language" => "Näytä Kieli",
"Show the language" => "Näytä kieli",
"Creator can edit" => "Luoja voi muokata",
"The person who submits an article of this type can edit it" => "Henkilö, joka lähettää tämän tyypin artikkelin voi myös muokata sitä",
"Show lang" => "Näytä kieli",
"Review" => "EsiKatselu",
"Classified" => "Luokiteltu",
"Create a new type" => "Luo uusi tyyppi",
"Group Information" => "Ryhmän Tiedot",
"level" => "taso",
"Create level" => "Luo taso",
"all permissions in level" => "kaikki oikeudet tasolla",
"backlinks to" => "paluulinkit",
"No backlinks to this page" => "Ei paluulinkkejä tälle sivulle",
"Directory batch upload" => "Hakemisto ryhmä lataus",
"Browse Gallery" => "Selaa galleriaa",
"Upload From Disk" => "Lähetä kovalevyltä",
"available images" => "saatavilla olevat kuvat",
"Remove File Extension from Image Name" => "Poista tiedostopääte kuvan nimestä",
"eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field" => "esim. \"digicam0001.jpg\" joten nimeä digicam0001 käytetään nimikentässä",
"Select a Gallery" => "Valitse Galleria",
"Process" => "Prosessi",
"Edit Post" => "Muokkaa lähetystä",
"View Blog" => "Näytä blogi",
"Use ...page... to separate pages in a multi-page post" => "Käytä ...sivu... erotellaksesi sivut monisivuisessa lähetyksessä",
"Body" => "Runko",
"Upload image for this post" => "Lähetä kuva tähän lähetykseen",
"Trash" => "Roskis",
"Mark entry as private:" => "Merkitse sisäänpääsy yksityiseksi:",
"Spellcheck" => "Oikeinkirjoitus",
"Save and Exit" => "Tallenna ja poistu",
"Made with" => "Tehty",
"powered by" => "moottorina",
"Blogs RSS" => "Blogit RSS",
"Articles RSS" => "Artikkelien RSS",
"Image Galleries RSS" => "Kuva Gallerioiden RSS",
"File Galleries RSS" => "Tiedosto Gallerioiden RSS",
"Forums RSS" => "Foorumien RSS",
"Maps RSS" => "Karttojen RSS",
"Execution time" => "Ajo aika",
"Memory usage" => "Muistin käyttö",
"Server load" => "Palvelin kuorma",
"Admin Category" => "Ylläpidä luokittelua",
"Admin the Category System" => "Ylläpidä luokka järjestelmää",
"Browse in" => "Selaa",
"Trackers Items" => "Kortiston Osia",
"Sheets" => "Arkit",
"Hide subcategories objects" => "Piilota aliluokkien kohteet",
"Show subcategories objects" => "Näytä aliluokkien kohteet",
"Upper level" => "Ylempi taso",
"List Galleries" => "Listaa galleriat",
"Edit Gallery" => "Muokkaa galleriaa",
"Rebuild Thumbnails" => "Rakenna minikuvat",
"Directory Batch" => "Hakemisto erä",
"List Gallery" => "Listaa galleria",
"Monitor this Gallery" => "Tarkkaile tätä galleriaa",
"Stop Monitoring this Gallery" => "Lopeta tämän gallerian tarkkailu",
"Sort Images by" => "Lajittele Kuvat",
"subgallery" => "aligalleria",
"Subgallery" => "Aligalleria",
"Hit" => "Osuma",
"Original Size" => "Alkuperäinen kuva",
"rotate right" => "pyöritä oikealle",
"rotate" => "pyöritä",
"Details" => "Yksityiskohdat",
"You can include the image in a tiki page using one of these lines" => "Voit käyttää kuvaa normaali sivulla käyttäen yhtä näistä riveistä",
"Return to Gallery" => "Palaa galleriaan",
"Edit Image" => "Muokkaa Kuvaa",
"First Image" => "Ensimmäinen kuva",
"Prev Image" => "Edellinen kuva",
"Smaller" => "Pienempi",
"Bigger" => "Suurempi",
"Popup window" => "Popup ikkuna",
"Next Image" => "Seuraava kuva",
"Slideshow Forward" => "Kuvaesitys eteenpäin",
"Last Image" => "Viimeisin kuva",
"Click to zoom" => "Paina, zoom",
"Image Name" => "Kuvan Nimi",
"Image Scale" => "Kuvamuunnos",
"Latitude (WGS84/decimal degrees)" => "Latitude (WGS84/desimaali astetta)",
"Longitude (WGS84/decimal degrees)" => "Longitude (WGS84/desimaali astetta)",
"Move image" => "Siirrä kuva",
"Stop Monitoring this Page" => "Lopeta tämän sivun tarkkailu",
"Monitor this Page" => "Tarkkaile tätä sivua",
"Group Calendars" => "Ryhmä Kalenterit",
"Tentative" => "Alustava",
"Confirmed" => "Hyväksytty",
"Cancelled" => "Peruttu",
"Change Focus" => "Muuta keskitystä",
"Edit Calendar Item" => "Muokkaa Kalenterin Osaa",
"New Calendar Item" => "Uusi Kalenterin Osa",
"Tuesday" => "Tiistai",
"Wednesday" => "Keskiviikko",
"Thursday" => "Torstai",
"Friday" => "Perjantai",
"January" => "Tammikuu",
"February" => "Helmikuu",
"March" => "Maaliskuu",
"April" => "Huhtikuu",
"May" => "Toukokuu",
"June" => "Kesäkuu",
"July" => "Heinäkuu",
"August" => "Elokuu",
"September" => "Syyskuu",
"October" => "Lokakuu",
"November" => "Marraskuu",
"December" => "Joulukuu",
"times" => "kertaa",
"End" => "Loppu",
"Duration" => "Kesto",
"Organized by" => "Järjestänyt",
"Roles" => "Tehtävät",
"Calendar import" => "Tuo kalenteri",
"Calendar has been updated" => "Kalenteri on päivitetty",
"import" => "tuo",
"Change password enforced" => "Vaihda salasana pakottamatta",
"Change your password" => "Muuta salasanasi",
"Send a message to us" => "Lähetä meille viesti",
"Contact us by email" => "Ota yhteyttä sähköpostilla",
"Click here to send us an email" => "Paina, lähettääksesi meille sähköpostia",
"Contacts" => "Yhteydet",
"Create/edit contacts" => "Luo/muokkaa yhteyksiä",
"First Name" => "Etu Nimi",
"Last Name" => "SukuNimi",
"Nickname" => "Lempinimi",
"You can browse the generated WebHelp here" => "Voit selata WebApua tästä",
"Structure" => "Rakenne",
"Top page" => "Ylin sivu",
"Add a new site" => "Lisää uusi sivusto",
"You cannot add sites until Directory Categories are setup." => "Et voi lisätä sivustoja ennen kuin Hakemisto Luokittelut on tehty.",
"Please contact the Site Administrator" => "Ota yhteyttä Sivuston Ylläpitäjään",
"Site added" => "Sivusto lisätty",
"Directory Administration" => "Hakemisto Ylläpito",
"There are" => "Siellä on",
"invalid sites" => "kelpaamaton sivusto",
"valid sites" => "hyväksytty sivusto",
"Users have visited" => "Käyttäjät vierailleet",
"sites from the directory" => "hakemiston sivustoilla",
"Users have searched" => "Käyttäjät etsineet",
"times from the directory" => "kertaa hakemistosta",
"Related" => "Liittyvä",
"Sites" => "Sivustot",
"Validate" => "Vahvista",
"Admin directory categories" => "Ylläpidä hakemisto luokitteluja",
"Add a directory category" => "Lisää hakemisto luokka",
"Edit this directory category" => "Muokkaa tätä hakemisto luokkaa",
"Children type" => "Ali tyyppi",
"Maximum number of children to show" => "Näytettävien alaluokkien maksimi määrä",
"Editor group" => "Muokkaa ryhmää",
"cType" => "cTyyppi",
"allow" => "salli",
"count" => "laske",
"editor" => "editori",
"relate" => "liitä",
"Mutual" => "Samanlainen",
"Admin sites" => "Ylläpidä sivustoja",
"Is valid" => "On hyväksytty",
"New Sites" => "Uudet sivustot",
"Cool Sites" => "Siistit sivustot",
"Add a Site" => "Lisää sivusto",
"any" => "mikävain",
"in entire directory" => "koko hakemisto",
"Sort by" => "Lajittele",
"name (desc)" => "nimi (aleneva)",
"name (asc)" => "nimi (nouseva)",
"hits (desc)" => "osumia (aleneva)",
"hits (asc)" => "osumia (nouseva)",
"creation date (desc)" => "luonti päivä (aleneva)",
"creation date (asc)" => "luonti päivä (nouseva)",
"last updated (desc)" => "viimeksi päivitetty (aleneva)",
"last updated (asc)" => "viimeksi päivitetty (nouseva)",
"Added" => "Lisätty",
"Last updated" => "Viimeksi päivitetty",
"Total links" => "Linkkejä kaikkiaan",
"Links to validate" => "Linkkejä hyväksyttäväksi",
"Searches performed" => "Etsintöjä suoritettu",
"Total links visited" => "Linkki vierailuja kaikkiaan",
"Directory ranking" => "Hakemisto arvostus",
"Search results" => "Etsintä tulokset",
"Validate sites" => "Hyväksy sivustot",
"Edit article" => "Muokkaa artikkelia",
"List Articles" => "Listaa Artikkelit",
"View Articles" => "Näytä artikkelit",
"One of the email addresses you typed is invalid" => "Jokin kirjoittamistasi sähköposti osoiteista on väärin",
"Topline" => "Ylärivi",
"Author Name" => "Kirjoittajan Nimi",
"Own Image" => "Oma Kuva",
"Article image" => "Artikkeli kuva",
"Use own image" => "Käytä omaa kuvaa",
"Float text around image" => "Kuljeta teksti kuvan ympäri",
"Own image size x" => "Oman kuvan koko x",
"Own image size y" => "Oman kuvan koko y",
"Image caption" => "Kuvateksti",
"Publish Date" => "Julkaisu päivä",
"Expiration Date" => "Viimeinen Päivä",
"Edit or create banners" => "Muokkaa tai luo bannereita",
"List banners" => "Listaa bannerit",
"URL to link the banner" => "URL linkki banneriin",
"Client" => "Asiakas",
"Max impressions" => "Maksimi vaikutelmat",
"Show the banner only between these dates" => "Näytä banneri vain näiden päivämäärien välissä",
"From date" => "Alkaen päivästä",
"To date" => "Päättyen päivään",
"Use dates" => "Käytä päiviä",
"Show the banner only in this hours" => "Näytä banneri vain näinä tunteina",
"Show the banner only on" => "Näytä banneri vain",
"Mon" => "Maa",
"Tue" => "Tii",
"Wed" => "Kes",
"Thu" => "Tor",
"Fri" => "Per",
"Sat" => "Lau",
"Select ONE method for the banner" => "Valitse vain YKSI menetelmä",
"Use HTML" => "Käytä HTML",
"Use image" => "Käytä kuvaa",
"Image:" => "Kuva:",
"Current Image" => "Nykyinen Kuva",
"Use image generated by URL (the image will be requested at the URL for each impression)" => "Käytä URL osoitteesta luotua kuvaa (kuva haetaan URL osoitteesta jokaista näyttökertaa varten)",
"Use text" => "Käytä tekstiä",
"Save the Banner" => "Tallenna banneri",
"Remove Zones (you lose entered info for the banner)" => "Poista Alueet (menetät bannerin tiedot)",
"Create Blog" => "Luo Blogi",
"Current heading" => "Nykyinen pääosa",
"There are individual permissions set for this blog" => "Tähän blogiin on erityisoikeudet",
"Number of posts to show" => "Näytettävien lähetysten määrä",
"Allow other user to post in this blog" => "Salli muiden käyttäjien lähettää tähän blogiin",
"Allow search" => "Salli etsintä",
"Allow comments" => "Salli kommentit",
"Show user avatar" => "Näytä käyttäjän hahmo",
"Blog heading" => "Blogin pääosa",
"Edit Style Sheet" => "Muuta Tyyli Arkkia",
"Style Sheet" => "Tyyli Arkki",
"choose a stylesheet" => "valitse tyyliarkki",
"Try" => "Kokeile",
"Colored text" => "Värillinen teksti",
"Headings" => "Pääosat",
"Show/Hide" => "Näytä/Piilota",
"show/hide heading section. + (shown) or - (hidden) by default" => "näytä/piilota pääosat. + (näyttää) tai - (piilottaa) oletuksena",
"Box content" => "Laatikon sisältö",
"Dynamic variables" => "Muuttuvat muuttujat",
"Inserts an editable variable" => "Lisää muokattavan muuttujan",
"External links" => "Ulkoiset linkit",
"For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))" => "Ulkoiset Wikit, käytä ExternalWikiName:SivuNimi tai ((External Wiki Name: Sivu Nimi))",
"Square Brackets" => "HakaSulut",
"Use [[foo] to show [foo]." => "Käytä [[foo] näyttääksesi [foo].",
"Wiki References" => "Wiki Suositukset",
"JoinCapitalizedWords or use" => "JoinCapitalizedWords tai käytä",
"page|description" => "sivu|kuvaus",
"for wiki references" => "wiki suosituksia varten",
"SomeName" => "JokuNimi",
"prevents referencing" => "estää suositukset",
"Lists" => "Listat",
"for bullet lists" => "sisennettyjä listauksia varten",
"for numbered lists" => "numeroituja listauksia varten",
"for definiton lists" => "määrittely listauksia varten",
"Tables" => "Taulukot",
"Title bar" => "Otsikko palkki",
"Line break" => "Rivin katkaisu",
"(very useful especially in tables)" => "(erittäin käyttökelpoinen taulukoissa)",
"Multi-page pages" => "MoniSivu sivut",
"Non parsed sections" => "Jäsentämättömät osastot",
"Prevents wiki parsing of the enclosed data." => "Estää sivustoa jäsentämästä oheista tietuetta.",
"Preformated sections" => "Esimuotoillut osastot",
"Block Preformatting" => "Estä Esimuotoilu",
"Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that." => "Tee sisennys sanavälejä lisäten muuttaaksesi sen tasalevyiseksi plokiksti joka muutoin tekee muotoilut. Sisennys tehdään sen mukaan montako sanaväliä on käytetty.  Huomaa, että tämä muoto ei säilytä tarkkoja välejä eikä rivivaihtoja; käytä ~pp~...~/pp~ siihen.",
"No description available" => "Ei kuvausta saatavilla",
"Browse Images" => "Katso kuva",
"Edit successful!" => "Muutos onnistui!",
"The following image was successfully edited" => "Seuraava kuva on onnistuneesti muutettu",
"Image Description" => "Kuvan Kuvaus",
"You can view this image in your browser using" => "Voit katsoa kuvaa selaimessasi käyttäen",
"You can include the image in an HTML page using one of these lines" => "Voit käyttää kuvaa HTML sivulla, käyttämällä yhtä näistä riveistä",
"Edit or ex/import Languages" => "Muokkaa tai vie/tuo Kieliä",
"Edit and create Languages" => "Muuta ja luo Kieliä",
"Edit and create languages" => "Muuta ja luo kieliä",
"Create Language" => "Luo Kieli",
"Shortname" => "Lyhytnimi",
"like" => "kuten",
"Longname" => "Pitkänimi",
"Select the language to edit" => "Valitse muokattava kieli",
"Add a translation" => "Lisää käännös",
"Edit translations" => "Muuta käännöstä",
"Translate recorded" => "Käännös taltioitu",
"Translation" => "Käännös",
"reset table" => "nollaa taulukko",
"Create New Block" => "Luo uusi blokki",
"Return to block listing" => "Palaa blokki listaukseen",
"Block description: " => "Blokin kuvaus: ",
"You are editing block:" => "Olet muuttamassa blokkia:",
"Publishing date" => "Julkaisu päivä",
"Publishing Date" => "Julkaisu Päivä",
"Edit question options" => "Muokkaa kysymys vaihtoehtoja",
"List Quizzes" => "Listaa Visailut",
"Quiz Stats" => "Visailu Tilastot",
"This Quiz Stats" => "Tämän visailut tilasto",
"Edit this Quiz" => "Muuta tätä visailua",
"Admin Quizzes" => "Ylläpidä visailuja",
"Create/edit options for question" => "Luo/muuta kysymys vaihtoehtoja",
"Option" => "Vaihtoehto",
"points" => "pisteitä",
"Quiz" => "Visailu",
"canRepeat" => "voiToistaa",
"timeLimit" => "aikaRaja",
"Create/edit quizzes" => "Luo/muuta visailuja",
"There are individual permissions set for this quiz" => "Visailulle on asetettu erikoisoikeudet",
"Quiz can be repeated" => "Visailun voi toistaa",
"Store quiz results" => "Tallenna visailu tulokset",
"Immediate feedback" => "Välitön palaute",
"Show correct answers" => "Näytä oikeat vastaukset",
"Shuffle questions" => "Sekoita kysymykset",
"Shuffle answers" => "Sekoita vastaukset",
"Quiz is time limited" => "Visailulla on aikaraja",
"Maximum time" => "Maksimi aika",
"Passing Percentage" => "Läpäisy Prosentti",
"Edit quiz questions" => "Muuta visailun kysymyksiä",
"Create/edit questions for quiz" => "Luo/muuta visailun kysymyksiä",
"Question Type" => "Kysymyksen Tyyppi",
"Import questions from text" => "Tuo kysymykset tekstinä",
"Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character." => "Ohjeet: Kirjoita, tai liitä, monivalinta kysymyksesi alle.  Yksi kysymys riviä kohti, aloita vastaus vaihtoehdot seuraaville riveille.  Erottele lisäkysymykset tyhjällä rivillä.  Merkitse oikea vastaus aloittamalla rivi \"*\" (ilman lainausmerkkejä) merkillä.",
"Input" => "Syötä",
"maxScore" => "maxTilanne",
"From Points" => "Pisteistä",
"To Points" => "Pisteiksi",
"Answer" => "Vastaus",
"Modify Structure" => "Muokkaa Rakennetta",
"You will remove" => "Sinä poistat",
"and its subpages from the structure, now you have two options:" => "ja sen alasivut rakenteesta, nyt sinulla on kaksi vaihtoehtoa:",
"Remove only from structure" => "Poista vain rakenteesta",
"Remove from structure and remove page too" => "Poista rakenteesta ja poista myös sivu",
"Structure Layout" => "Rakenteen Layout",
"Promote" => "Mainosta",
"Demote" => "Alenna",
"Previous" => "Edellinen",
"Current Node" => "Nykyinen Solmu",
"Page alias" => "Sivun lisänimi",
"Add pages to current node" => "Lisää sivuja nykyiseen solmuun",
"After page" => "Sivun jälkeen",
"Create Page" => "Luo sivu",
"Use pre-existing page" => "Käytä aiemmin ollutta sivua",
"Submit article" => "Lähetä artikkeli",
"List Submissions" => "Listaa ehdotukset",
"<b>*</b>=optional" => "<b>*</b>=vaihtoehtoinen",
"<b>Topline</b>=small line above Title" => "<b>Ylärivi</b>=pieni rivi Aiheen yllä",
"<b>Subtitle</b>=small line below Title" => "<b>Alaotsikko</b>=pieni rivi Aiheen alla",
"<b>Source</b>=URL to article source" => "<b>Lähde</b>=artikkeli lähteen URL osoite",
"Edit templates" => "Muuta mallia",
"Template listing" => "Malli listaus",
"Available templates" => "Saatavilla olevat mallit",
"Save Only in the Theme:" => "Tallenna vain teemaan:",
"Delete the copy in the theme:" => "Poista kopio teemasta:",
"Edit a topic" => "Muuta aihe",
"View Page" => "Näytä Sivu",
"You must specify the object language" => "On valittava kohde kieli",
"The object doesn't exist" => "Kohdetta ei ole",
"The object doesn't have a language" => "Kohteella ei ole kieltä",
"The object has already a translation for this language" => "Kohteella on jo käännös tällä kielellä",
"The object is already in the set of translations" => "Kohde on jo kieliluettelossa",
"detach" => "erota",
"The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appearance of the page, no versions are stored for this page." => "Hiekkalaatikko on sivu jolla voi harjoitella sivun muokkaus taitoja, käyttää mahdollisuutta katsoa eri kokeiluja, mitään versiota tästä sivusta ei tallenneta.",
"Upload picture" => "Lähetä kuva",
"Admin Content Templates" => "Ylläpidä sisältö malleja",
"Case Insensitivity" => "Voi olla isot tai pienet",
"Try to convert HTML to wiki" => "Yritä muuttaa HTML normaali sivuksi",
"Import page" => "Tuo sivu",
"export all versions" => "vie kaikki versiot",
"Year:" => "Vuosi:",
"Authors:" => "Kirjoittajat:",
"Manage structures" => "Hallitse rakenteita",
"License" => "Lisenssi",
"Important" => "Tärkeää",
"My Footnotes" => "Omat Alaviitteet",
"Use rating" => "Käytä arvostelua",
"There is no available poll template." => "Ei ole saatavilla äänestys mallia.",
"You should ask an admin to create them." => "Pyydä ylläpitoa luomaan ne.",
"an existing poll" => "olemassa oleva äänestys",
"votes" => "ääniä",
"Graph" => "Graafi",
"status" => "tila",
"lastModif" => "viimeksiMuokannut",
"Admin FAQ" => "Ylläpidä UKK:ä",
"List FAQs" => "Listaa UKK:t",
"View FAQ" => "Näytä UKK",
"Edit this FAQ" => "Muuta tätä UKK:ta",
"New Question" => "Uusi kysymys",
"Use a question from another FAQ" => "Käytä kysymystä toisesta UKK:sta",
"FAQ questions" => "UKK kysymykset",
"Suggested questions" => "Ehdotetut kysymykset",
"No suggested questions" => "Ei ehdotettuja kysymyksiä",
"Upload File" => "Lähetä Tiedosto",
"View tpl" => "Näytä tpl",
"File Galleries tpl" => "Tiedosto Galleria tpl",
"You can access the file gallery using the following URL" => "Pääset käsiksi tiedosto galleriaan seuraavasta URL:sta",
"Admin forums" => "Ylläpidä foorumit",
"Edit queued message" => "Muokkaa jonottavia viestejä",
"make this a thread of" => "Laita tämä ketju",
"None, this is a thread message" => "EiMitään, tämä on ketjuviesti",
"summary" => "yhteenveto",
"normal" => "normaali",
"announce" => "tiedote",
"hot" => "kuuma",
"no feeling" => "ei tunnetta",
"frown" => "paheksuva",
"exclaim" => "huudahdus",
"neutral" => "neutraali",
"question" => "kysymys",
"happy" => "onnellinen",
"wink" => "silmänisku",
"Save and Approve" => "Tallenna ja hyväksy",
"convert to topic" => "muuta aiheeksi",
"List of messages" => "Lista viesteistä",
"New Topic" => "Uusi aihe",
"no summary" => "ei yhteenvetoa",
"No messages queued yet" => "Ei viestejä jonossa vielä",
"Last Post" => "Viimeinen lähetys",
"Configure Forum" => "Foorumin kokoonpano",
"Reported by" => "Raportoijana",
"Pending requests" => "Odotus pyynnöt",
"Request Time" => "Pyyntö Aika",
"Accept" => "Hyväksy",
"Refuse" => "Hylkää",
"Waiting requests" => "Odottavat pyynnöt",
"Your friends" => "Ystäväsi",
"break friendship" => "riko ystävyys",
"Galleries" => "Galleriat",
"Create New Gallery" => "Luo uusi galleria",
"Create a gallery" => "Luo galleria",
"Edit this gallery:" => "Muokkaa tätä galleriaa:",
"There are individual permissions set for this gallery" => "Tälle gallerialle on asetettu erikoisoikeudet",
"Gallery is visible to non-admin users?" => "Näytetäänkö galleria muille kuin ylläpijille?",
"Geographic" => "Maantieteellinen",
"Fields to show during browsing the gallery" => "Kentät jotka näytetään selattaessa galleriaa",
"Creation Date" => "Luonti Päivä",
"XY-Size" => "XY-Koko",
"Gallery Image" => "Galleria Kuva",
"Available scales" => "Saatavat muutokset",
"Bounding box" => "Ympäröivä laatikko",
"default scale" => "oletus koko",
"No scales available" => "Ei muutoksia tarjolla",
"Original image is default scale" => "Alkuperäinen kuva on oletuskoko",
"Add scaled images with bounding box of square size" => "Lisää muunnetut kuvat suorakaide laatikkoon",
"Other users can upload images to this gallery" => "Muut käyttäjät voivat lähettää kuvia tähän galleriaan",
"You can access the gallery using the following URL" => "Voit päästä käsiksi galleriaan seuraavasta URL:sta",
"Available Galleries" => "Saatavilla olevat Galleriat",
"Choose a filter" => "Valitse suodin",
"Imgs" => "Kuvia",
"Make Map" => "Tee Kartta",
"Select Graphic Type" => "Valitse Grafiikan Tyyppi",
"Pie Chart" => "Piirakka kaavio",
"Multiline" => "Monilinjainen",
"Multibar" => "Monipalkki",
"Bar Stack" => "Palkki Pino",
"Landscape" => "Vaakamalli",
"Portrait" => "Pystymalli",
"Independant Scale" => "Riippumaton Muunnos",
"Horizontal Scale" => "Vaakasuora Muunnos",
"Vertical Scale" => "Pystysuora Muunnos",
"Series" => "Sarjat",
"To" => "Kenelle",
"Im- Export languages" => "Tuo- Vie kieliä",
"Select the language to Import" => "Valitse tuotava kieli",
"Select the language to Export" => "Valitse vietävä kieli",
"Import From File" => "Tuo Tiedostosta",
"Grab Wiki Tables" => "Tartu Taulukkoon",
"Import pages from a Structured Text Dump" => "Tuo sivuja Teksti Dumpista jossa on rakenne",
"Name of the dump file (it has to be in dump/)" => "Dumpin nimi (on oltava dumpissa/)",
"Overwrite existing pages if the name is the same" => "Päällekirjoitetaan jos tuotavalla sivulla on sama nimi",
"Previously remove existing page versions" => "Poista aiemmin olemassa olevat sivuversiot",
"excerpt" => "ote",
"Result" => "Tulos",
"body" => "runko",
"Locked" => "Lukittu",
"User name:" => "Käyttäjä nimi:",
"Install" => "Asenna",
"Configure General Settings" => "Yleiset Asetukset",
"Documentation" => "Käsikirja",
"Clear cached version and refresh cache" => "Poista puskuroidut versiot ja päivitä puskuri",
"configure rules" => "kokoonpano säännöt",
"Edit Repository" => "Muuta tallennuspaikka",
"Last Changes" => "Viimeiset Muutokset",
"Search by Date" => "Etsintä Päiväyksen mukaan",
"LastChanges" => "ViimeisetMuutokset",
"Rollback" => "Taaksekelaus",
"Pages like" => "Sivut kuin",
"No pages found" => "Ei löytynyt sivuja",
"Edit New Article" => "Muuta uutta artikkelia",
"View Submissions" => "Näytä ehdotukset",
"ExpireDate" => "PoistumisPäivä",
"AuthorName" => "KirjoittajaNimi",
"Img" => "Kuva",
"To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone." => "Käyttääksesi <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">moduulia</a> tai mallia, käytä {literal}{banner zone=ABC}{/literal}, missä ABC on alueen nimi.",
"Create banner" => "Luo banneri",
"Method" => "Menetelmä",
"Use Dates?" => "Käytä Päiväystä?",
"Max Impressions" => "Max Vaikutelmat",
"Impressions" => "Vaikutelmat",
"Clicks" => "Klikkejä",
"Create New Blog" => "Luo uusi blogi",
"Dynamic content system" => "Muuttuvan sisällön järjestelmä",
"To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block." => "Käyttääksesi sisältö plokkeja tekstialueella (sivulla, jne), <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">moduuli</a> tai malli, käytä {literal}{content id=x}{/literal}, missä x on sisältöplokin ID.",
"Available content blocks" => "Saatavilla olevat blokit",
"Current ver" => "Nykyinen ver",
"Next ver" => "Seuraava ver",
"Future vers" => "Tulevaisuuden versiot",
"Program" => "Ohjelma",
"Available FAQs" => "Saatavilla olevat UKK:t",
"Edit/Create" => "Muokkaa/Luo",
"Edit this FAQ:" => "Muuta tätä UKK:ta:",
"Create new FAQ" => "Luo uusi UKK",
"Create New FAQ:" => "Luo Uusi UKK:",
"Users can suggest questions" => "Käyttäjät voivat ehdottaa kysymyksiä",
"Create a File Gallery" => "Luo tiedosto galleria",
"Gallery Images" => "Gallerian Kuvat",
"Edit Blog" => "Muokkaa Blogia",
"Blog Title" => "Blogin Otsikko",
"Edit New Submission" => "Muuta uutta ehdotusta",
"Survey stats" => "Tutkimus tilastot",
"Take Survey" => "Ota tutkimus",
"users registered" => "käyttäjät rekisteröityneet",
"Distance (km)" => "Suunta (km)",
"List Movies" => "Listaa Elokuvat",
"Choose a movie" => "Valitse elokuva",
"Last mod" => "Viimeksi muok",
"Last modification" => "Viimeisin muokkaus",
"Last author" => "Viimeisin kirjoittaja",
"Last version" => "Viimeisin versio",
"unlocked" => "lukitsematon",
"Open client window" => "Avaa asiakas ikkuna",
"Generate HTML" => "Muodosta HTML",
"Transcripts" => "Käsikirjoitukset",
"Online operators" => "Online operaattorit",
"Operator" => "Operaattori",
"transcripts" => "käsikirjoitukset",
"Offline operators" => "Offline operaattorit",
"Add an operator to the system" => "Lisää operaattori järjestelmään",
"Operators must be tiki users" => "Operaattorin oltava sivuston jäsen",
"Set as Operator" => "Aseta operaattoriksi",
"Chat started" => "Juttelu aloitettu",
"Operator:" => "Operaatori:",
"Live support:User window" => "Elävä tuki:Käyttäjän ikkuna",
"Request live support" => "Pyydä elävä tuki",
"Request support" => "Pyydä tukea",
"Open a support ticket instead" => "Avaa sen sijaan tukilippu",
"Your request is being processed" => "Pyyntösi on käsitelty",
"cancel request and exit" => "peruuta pyyntö ja poistu",
"cancel request and leave a message" => "peruuta pyyntö ja jätä viesti",
"Live support:Console" => "Elävä tuki:Konsoli",
"be online" => "pysy linjalla",
"be offline" => "poissa linjalta",
"Support requests" => "Tukee pyyntöjä",
"Requested" => "Pyydetty",
"Join" => "Liity",
"Support chat transcripts" => "Tukee jutun käsikirjoitusta",
"operator" => "operaattori",
"started" => "aloitettu",
"reason" => "syy",
"msgs" => "viesti",
"Transcript" => "Käsikirjoitus",
"Mail-in feature" => "Posti-sisään ominaisuus",
"Prefs" => "Kokoonp",
"Daily" => "Päivittäin",
"Weekly" => "Viikottain",
"Remove old events" => "Poista vanhat tapahtumat",
"duration" => "kesto",
"Mini Calendar: Preferences" => "Mini Kalenteri: Kokoonpano",
"Calendar Interval in daily view" => "Kalenterin aikaväli päivittäis näytössä",
"Start hour for days" => "Päivän aloitusaika",
"End hour for days" => "Päivän lopetusaika",
"Reminders" => "Muistutukset",
"no reminders" => "ei muistuksia",
"Or enter path or URL" => "Tai kirjoita polku tai URL",
"Add Topic" => "Lisää aihe",
"Tikiwiki Mods" => "Sivusto Modit",
"Mods Configuration" => "Moduulien Kokoonpano",
"Update remote index" => "Päivitä ulkoinen indexi",
"Rebuild local list" => "Rakenna paikallinen listaus",
"Republish all" => "Uudelleen julkaise kaikki",
"Publish all" => "Julkaise kaikki",
"Unpublish all" => "Äläjulkaise mitään",
"Attention" => "Huomio",
"all types" => "kaikki tyypit",
"Display only this type" => "Näytä vain tämän tyypin",
"Unpublish" => "Äläjulkaise",
"Republish" => "Uusintajulkaisu",
"Tikiwiki Mods Configuration" => "Modien Kokoonpano",
"Enable Mods providing" => "Oikeuta Modien tarjonta",
"Mods local directory" => "Modien paikallinen hakemisto",
"Mods remote server" => "Modien ulkoinen palvelin",
"Package Config" => "Paketti Kokoonopano",
"y" => "k",
"User Galleries" => "Käyttäjä Galleriat",
"Unread Messages" => "Lukemattomat Viestit",
"Tasks" => "Tehtävät",
"MyTiki" => "OmatSivut",
"Notepad" => "Muistio",
"MyFiles" => "OmatTiedostot",
"My Watches" => "Omat vahdit",
"Sent editions" => "Lähetä muokatut",
"The newsletter was sent to {\$sent} email addresses" => "Uutislehti on lähetetty {\$sent} sähköposti osoitteisiin",
"Thanks for your subscription. You will receive an email soon to confirm your subscription. No newsletters will be sent to you until the subscription is confirmed." => "Kiitos tilauksestasi. Saat kohta sähköpostia jolla varmistetaan tilauksesi. Uutislehteä ei lähetetä ennen kuin tilaus on varmistettu.",
"Your email address was removed from the list of subscriptors." => "Sähköpostiosoitteesi on poistettu tilaajien listalta.",
"Subscription confirmed!" => "Tilaus varmistettu!",
"Subscribe to Newsletter" => "Tilaa uutislehti",
"Subscribe to this Newsletter" => "Tilaa",
"Available Newsletters" => "Saatavilla olevat Uutislehdet",
"Notes" => "Huomiot",
"Write a note" => "Kirjoita huomio",
"quota" => "levytila",
"No notes yet" => "Ei huomioita vielä",
"Merge selected notes into" => "yhdistä valitut huomiot",
"Reading note:" => "Lukee huomiota:",
"List notes" => "Listaa huomiot",
"Write note" => "Kirjoita huomio",
"Wiki Create" => "Wiki luonti",
"Wiki Overwrite" => "Wiki päällekirjoitus",
"Added:" => "Lisätty:",
"Removed:" => "Poistettu:",
"Assign permissions to " => "Liitä oikeudet ",
"Assign permissions to this object" => "Liitä oikeudet tälle kohteelle",
"Published" => "Julkaistu",
"Passcode to register (not your user password)" => "Passikoodi rekisteröintiin (ei ole salasana)",
"Orphan Pages" => "Yksinäiset Sivut",
"Browser not supported" => "Selaimesi ei ole tuettu",
"Rename" => "Nimeä",
"Slides" => "Kuvat",
"Discuss" => "Pohtia",
"Attach File" => "Liite tiedosto",
"1 File Attached" => "1 liite tiedosto",
"(current)" => "(nykyinen)",
"Rollback to this version" => "Takaisin tähän versioon",
"s=source" => "l=lähde",
"b=rollback" => "t=takaisin",
"Pick your avatar" => "Valitse hahmosi",
"User Preferences" => "Käyttäjä Kokoonpanot",
"Your current avatar" => "Nykyinen hahmosi",
"no avatar" => "ei hahmoa",
"reset" => "nollaus",
"Pick avatar from the library" => "Valitse hahmo kirjastosta",
"Pick user Avatar" => "Ota käyttäjä Hahmo",
"Hide all" => "Piilota kaikki",
"icons" => "ikonit",
"Show all" => "Näytä kaikki",
"Avatar Image" => "Hahmo Kuva",
"random" => "satunnainen",
"Upload your own avatar" => "Lähetä oma hahmosi",
"Insert" => "Lisäys",
"atts" => "liite",
"List Attachments" => "Listaa Liitteet",
"Average" => "Keskimäärin",
"View Results" => "Näytä Tulokset",
"Vote poll" => "Ota äänestys",
"Other Polls" => "Muut äänestykset",
"Note: Remember that this is only a preview, and has not yet been saved!" => "Huomaa: Muista, että tämä on vasta esikatselu, ja sitä ei ole tallennettu!",
"on:" => ":",
"Topic image" => "Aiheen kuva",
"Viewing blog post" => "Näyttää blogilähetyksiä",
"Return to blog" => "Palaa blogiin",
"The original document is available at" => "Alkuperäinen asiakirja on saatavilla",
"Print multiple pages" => "Tulosta useita sivuja",
"Add Structure" => "Lisää rakenne",
"Add Page" => "Lisää Sivu",
"Edit quiz" => "Muokka visailua",
"Current Version" => "Nykyinen Versio",
"General Options" => "Yleiset Vaihtoehdot",
"Publication Date" => "Julkaisupäivä",
"at " => " ",
"Use " => "Käytä ",
"randomly selected questions." => "satunnaisesti valitut kysymykset.",
"Test-time Options" => "Testin-aika Vaihtoehdot",
"Limit questions displayed per page to " => "Rajoita kysymysten määrä per sivu ",
"&nbsp question(s)." => "&nbsp kysymys(tä).",
"Impose a time limit of " => "Määrää aikaraja ",
"Allow students to store partial results and return to quiz." => "Salli opiskelijoiden tallentaa osittaiset tulokset ja palata visailuun.",
"Allow students to retake this quiz " => "Salli opiskelijoiden ottaa uudelleen visailu ",
"Grading and Feedback" => "Arvostelu ja Palaute",
"Grading method " => "Arvostelu menetelmä ",
"Show students their score " => "Näytä opiskelijoille heidän pisteensä ",
"Show students the correct answers " => "Näytä opiskelijoille oikeat vastaukset ",
"Publish statistics " => "Julkaise tilastot ",
"Extra Options" => "Lisä Vaihtoehdot",
"Solicit additional questions from students" => "Pyydä lisäkysymyksiä opiskelijoilta",
"Link quiz to forum named: " => "Linkitä visailu foorumiin nimeltä: ",
"Prologue:" => "Esipuhe:",
"Epilogue:" => "Jälkipuhe:",
"Quiz result stats" => "Visailu tulosten tilasto",
"Time" => "Aika",
"User answers" => "Käyttäjä vastaukset",
"Stats for quizzes" => "Visailujen tilastot",
"taken" => "otettu",
"Av score" => "Keskim tilanne",
"Av time" => "Keskim aika",
"Clear Stats" => "Tyhjennä tilastot",
"time taken" => "aikaa meni",
"P/F" => "Osittain/Koko",
"Stats for this quiz Questions " => "Tämän visailun kysymysten tilasto ",
"Received articles" => "Vastaanotetut artikkelit",
"Edit received article" => "Muokkaa vastaanotettua artikkelia",
"Use Image" => "Käytä Kuvaa",
"Image x size" => "Kuva x koko",
"Image y size" => "Kuva y koko",
"Image name" => "Kuvan nimi",
"Accept Article" => "Hyväksy Artikkeli",
"Site" => "Sivusto",
"Received Pages" => "Vastaanotetut Sivut",
"Referer stats" => "Suosittelu tilastot",
"Last" => "Viimeksi",
"Your email could not be validated; make sure you email is correct and click register below." => "Sähköpostiosoitettasi ei voida varmistaa; tarkista että sähköpostiosoite on oikein ja paina alhaalta rekisteröi.",
"Register as a new user" => "Rekisteröi uutena käyttäjänä",
"Repeat password" => "Toista salasana",
"A valid email is mandatory to register" => "Voimassa oleva sähköposti osoite on pakollinen rekisteröinnissä",
"Tiki site registered" => "Tiki sivusto rekisteröity",
"The following site was added and validation by admin may be needed before appearing on the lists" => "Seuraava sivusto on lisätty ja ylläpidon hyväksyntä ennen kuin se ilmestyy listalle",
"You don't have permission to use this feature." => "Oikeutesi eivät riitä käyttämään tätä ominaisuutta.",
"Please register." => "Ole Hyvä ja rekisteröidy.",
"Register this site at tikiwiki.org" => "Rekisteröi tämä sivusto tikiwiki.org:iin",
"Read this first!" => "Lue tämä ensin!",
"On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites." => "Tällä sivulla voit tehdä sivustosi tunnetuksi tikiwiki.org:iin. Se tulee sinne näkyviin tunnettuna sivustona.",
"Registering is voluntary." => "Rekisteröinti on vapaaehtoinen.",
"Registering does not give you any benefits except one more link to your site." => "Rekisteröinti ei tuo mitään lisäetua vain yhden linkin lisää.",
"You don't get any emails, we don't sell the data about your site." => "Et saa mitään postituksia, me emme myy sivustosi tietoja eteenpäin.",
"Registering is just for us to get an overview of Tiki's usage." => "Rekisteröinti on vain meille jotta saamme paremman kuvat Tiki:en käytöstä.",
"If your site is private or inside your intranet, you should not register!" => "Jos sivustosi on yksityinen tai vain sisäisessä verkossa sitä ei pidä rekisteröidä!",
"Information about your site" => "Tietoja sivustostasi",
"Send me my Password" => "Lähetä salasanani",
"Remove page" => "Poista sivu",
"Last Version" => "Viimeinen versio",
"You are about to remove the page" => "Olet aikeissa poistaa sivun",
"permanently" => "pysyvästi",
"Remove all versions of this page" => "Poista kaikki versiot tästä sivusta",
"Rollback page" => "Takaisinkelaa sivu",
"Searched" => "Etsitty",
"Search in" => "Etsitty",
"Simple search" => "Yksikertainen haku",
"No pages matched the search criteria" => "Ei sivuja näillä hakuehdoilla",
"This newsletter will be sent to {\$subscribers} email addresses." => "Tämä uutislehti lähetetään {\$subscribers} sähköposti osoitteisiin.",
"Prepare a newsletter to be sent" => "Valmistele uutislehti lähetettäväksi",
"Apply content template" => "Liitä sisältö malli",
"Send objects" => "Lähetä kohteet",
"Transmission results" => "Siirtojen tulokset",
"Send Wiki Pages" => "Lähetä Wiki Sivut",
"Send Articles" => "Lähetä Artikkelit",
"Add Article" => "Lisää artikkeli",
"Send objects to this site" => "Lähetä kohteet tälle sivustolle",
"Create a sheet" => "Luo arkki",
"Edit this sheet:" => "Muokkaa tätä arkkia:",
"Create New Sheet" => "Luo uusi arkki",
"There are individual permissions set for this sheet" => "Tälle arkille on erityisoikeudet",
"Class Name" => "Luokka Nimi",
"Header Rows" => "Pääosan Rivejä",
"Footer Rows" => "Alaosan Rivejä",
"Create new Sheet" => "Luo uusi Arkki",
"You can access the sheet using the following URL" => "Voit päästä arkille seuraamalla tätä URL",
"Available Sheets" => "Saatavilla olevat Arkit",
"Change shoutbox general settings" => "Muuta pikaviestimen yleisiä asetuksia",
"auto-link urls" => "auto-link url:it",
"Post or edit a message" => "Lähetä tai muokkaa viestiä",
"Location : " => "Sijainti : ",
"Parent page" => "Isäntä sivu",
"Child" => "Ala",
"Last edited by" => "Viimeksi muokannut",
"based on work by" => "perustyön tehnyt",
"Contributors to this page" => "Tämän sivun avustajat",
"Params" => "Param",
"Most viewed objects" => "Eniten näytetyt kohteet",
"Most viewed objects in the last 7 days" => "Eniten näytetyt kohteet viimeisten 7 päivän aikana",
"Site Stats" => "Sivuston Tilastot",
"Started" => "Aloitettu",
"Days online" => "Päivää linjalla",
"Total pageviews" => "Sivunäytöt kaikkiaan",
"Average pageviews per day" => "Sivunäyttöjä keskimäärin päivässä",
"pvs" => "snp",
"Best day" => "Paras päivä",
"Worst day" => "Huonoin päivä",
"Wiki Stats" => "Wiki Tilastot",
"Size of Wiki Pages" => "Wiki Sivujen koko",
"Average page length" => "Keskimääräinen sivun pituus",
"Average versions per page" => "Versioita keskimäärin per sivu",
"Visits to wiki pages" => "Vierailut wikisivuilla",
"Average links per page" => "Linkkejä keskimäärin per sivu",
"Image galleries Stats" => "Kuva galleria Tilastot",
"Average images per gallery" => "Kuvia keskimäärin per galleria",
"Total size of images" => "Kuvien koko kaikkiaan",
"Average image size" => "Kuvien keskimääräinen koko",
"Visits to image galleries" => "Vierailuja kuva gallerioissa",
"File galleries Stats" => "Tiedosto galleria Tilastot",
"Average files per gallery" => "Tiedostoja keskimäärin per galleria",
"Total size of files" => "Tiedostojen koko kaikkiaan",
"Average file size" => "Tiedoston koko keskimäärin",
"Visits to file galleries" => "Vierailuja tiedosto gallerioissa",
"CMS Stats" => "CMS Tilastot",
"Total reads" => "Luettu kaikkiaan",
"Average reads per article" => "Lukijoita keskimäärin per artikkeli",
"Total articles size" => "Artikkelien koko kaikkiaan",
"Average article size" => "Artikkelin koko keskimäärin",
"Forum Stats" => "Foorumin Tilastot",
"Total topics" => "Aiheita kaikkiaan",
"Average topics per forums" => "Aiheita keskimäärin per foorumi",
"Visits to forums" => "Vierailuja foorumeilla",
"Blog Stats" => "Blogi Tilastot",
"Weblogs" => "Weblogit",
"Total posts" => "Lähetyksiä kaikkiaan",
"Average posts per weblog" => "Lähetyksiä keskimäärin per webblogi",
"Total size of blog posts" => "Blogi lähetysten koko kaikkiaan",
"Average posts size" => "Keskimääräinen lähetyksen koko",
"Visits to weblogs" => "Vierailua weblogeissa",
"Poll Stats" => "Äänestys Tilastot",
"Total votes" => "Ääniä kaikkiaan",
"Average votes per poll" => "Ääniä keskimäärin per äänestys",
"Total questions" => "Kysymyksiä kaikkiaan",
"Average questions per FAQ" => "Kysymyksiä keskimäärin per UKK",
"User Stats" => "Käyttäjä Tilastot",
"Average bookmarks per user" => "Kirjanmerkkejä keskimäärin per käyttäjä",
"Average questions per quiz" => "Kysymyksiä keskimäärin per visailu",
"Quizzes taken" => "Visailuja otettu",
"Average quiz score" => "Keskimääräinen visailu tilanne",
"Average time per quiz" => "Keskimääräinen aika per visailu",
"Usage chart" => "Kaavion käyttö",
"Usage chart image" => "Kaavio kuvan käyttö",
"Daily Usage" => "Päivittäinen Käyttö",
"Stats for surveys" => "Tutkimusten Tilasto",
"Last taken" => "Viimeksi otettu",
"Time Left" => "Aikaa Jäljellä",
"Send Answers" => "Lähetä vastaukset",
"Thank you for your submission" => "Kiitoksia ehdotuksestasi",
"Your email was sent" => "Sähköpostiosoitteesi on lähetetty",
"Theme is selected as follows" => "Teema on valittu seuraaviin",
"If a theme is assigned to the individual object that theme is used." => "Jos teema on liitetty teeman kohteita käytetään.",
"If not then if a theme is assigned to the object's category that theme is used" => "Jos ei niin kohteen luokittelun teemaa käytetään",
"If not then a theme for the section is used" => "Jos ei niin kohteen osaston teemaa käytetään",
"If none of the above was selected the user theme is used" => "Jos mitään näistä ei ole käytetään käyttäjän teemaa",
"Finally if the user didn't select a theme the default theme is used" => "Lopuksi jos mikään näistä ei täyty käytetään oletus teemaa",
"Control by Objects" => "Hallinta Kohteella",
"Control by Sections" => "Hallinta Osastolla",
"Assign themes to categories" => "Liitä teemaa luokkiin",
"Assigned categories" => "Liitetyt luokat",
"Theme Control Center: Objects" => "Teeman Hallinta Keskus: Kohteet",
"Control by Categories" => "Hallinta luokilla",
"Assign themes to objects" => "Liitä teema kohteille",
"Assigned objects" => "Liitetyt kohteet",
"Assign themes to sections" => "Liitä teema osastoihin",
"Assigned sections" => "Liitetyt osastot",
"Edit File:" => "Muokkaa Tiedostoa:",
"The following file was successfully uploaded" => "Seuraavat tiedostot onnistuneesti vastaanotettu",
"You can download this file using" => "Voit imuroida tiedoston käyttäen",
"Batch Upload Results" => "Joukko Lähetyksen Tulokset",
"Upload successful!" => "Lähetys onnistui!",
"The following image was successfully uploaded" => "Seuraavat kuvat on onnistuneesti vastaanotettu",
"Image ID thumb" => "Kuva ID mini",
"You can include the image in an Wiki page using" => "Voit lisätä kuvan sivulle käyttäen",
"or use filename" => "tai käytä tiedostonimeä",
"Now enter the image URL" => "Kirjoita kuvan URL",
"or upload a local image from your disk" => "tai lähetä oma kuva kovalevyltäsi",
"Batch Upload" => "Joukko lähetys",
"Thumbnail (optional, overrides automatic thumbnail generation)" => "Minikuva (vaihtoehtoinen, ohittaa automaattisen minikuvan luonnin)",
"You have to create a gallery first!" => "Sinun on luotava galleria ensin!",
"User assigned modules" => "Käyttäjän liittämät moduulit",
"Restore defaults" => "Palauta oletukset",
"act" => "toi",
"Assign module" => "Liitä moduuli",
"Column" => "Palsta",
"top" => "ylä",
"Folders" => "Kansiot",
"Folder in" => "Kansio",
"Remove Folder" => "Poista kansio",
"Refresh Cache" => "Päivitä puskuri",
"Admin folders and bookmarks" => "Ylläpidö kansioita ja kirjanmerkkejä",
"Send me a message" => "Lähetä minulle viesti",
"Assign Group" => "Liitä Ryhmä",
"Change user preferences" => "Muuta käyttäjän asetuksia",
"Homepage" => "EtuSivu",
"Users HomePage" => "Käyttäjän EtuSivu",
"Personal Wiki Page" => "Henkilökohtainen Sivu",
"Create page" => "Luo sivu",
"Request friendship from this user" => "Pyydä ystävyyttä tältä käyttäjältä",
"Toggle" => "Nappurla",
"Toggle options" => "Nappula vaihtoehdot",
"Personal Information" => "Henkilökohtaiset Tiedot",
"View extra information" => "Näytä lisätiedot",
"Is email public? (uses scrambling to prevent spam)" => "Onko sähköposti julkinen? (käytä sekoitusta roskapostin estoon)",
"Unavailable - please set your e-mail below" => "EiSaatavilla - anna sähköpostiosoite alle",
"Does your mail reader need a special charset" => "Tarvitseeko postiohjelmasi erikois merkistöä",
"Notify sender when reading his mail" => "Ilmoita kirjoittajalle kun hänen viestiään luetaan",
"Account Information" => "Tili Tiedot",
"Leave \"New password\" and \"Confirm new password\" fields blank to keep current password" => "Jätä \"Uusi salasana\" ja \"Toista uusi salasana\" kentät tyhjiksi säilyttääksesi nykyinen salasanasi",
"Change administrative info" => "Muuta ylläpidollista tietoa",
"New task" => "Uusi tehtävä",
"Task list" => "Tehtävä lista",
"Admin mode off" => "Ylläpito pois",
"Admin mode on" => "Ylläpito päällä",
"Task help" => "Tehtävä apu",
"Empty Trash" => "Tyhjennä roskis",
"Received task" => "Vastaanotettu tehtävä",
"You received this task, please read and execute it" => "Olet vastaanottanut tämän tehtävän, lue ja tee se",
"Send task" => "Lähetä tehtävä",
"You send this task to a other user" => "Lähetit tämän tehtävän toiselle käyttäjälle",
"Shared task" => "Jaettu tehtävä",
"This task is public to a special group" => "Tämä tehtävä on julkinen määrätylle ryhmälle",
"Accepted by Task User and Creator" => "Hyväksytty tehtävän tekijän ja luojan puolesta",
"Accepted User and Creator" => "Hyväksytyt käyttäjä ja luoja",
"Task is accepted by user and creator" => "Tehtävä on hyväksytty sekä käyttäjän että luojan puolesta",
"Not Accepted by One User" => "Yksi käyttäjä ei ole hyväksynyt",
"Not Accepted User" => "Ei hyväksyntää käyttäjä",
"Task is rejected by one user" => "Yksi käyttäjä on hylännyt tehtävän",
"Waiting for Me" => "Odottaa minua",
"Task is not accepted by you, read the task and accept or reject it" => "Et ole hyväksynyt tehtävää, lue tehtävä ja hyväksy tai hylkää se",
"Waiting for Other User" => "Odottaa muita käyttäjiä",
"Task is not accepted/rejected by other user" => "Muut käyttäjät eivä ole hyväksyneet/hylänneet tehtävää",
"Admin Mode" => "Ylläpidollinen",
"Edit task" => "Muokkaa tehtävää",
"NOT accept" => "EI hyväksytty",
"Remove from Trash" => "Poista roskiksesta",
"Move into Trash" => "Siirrä roskikseen",
"Task saved" => "Tehtävä tallennettu",
"Edit Task" => "Muokka Tehtävää",
"View Task" => "Näytä Tehtävä",
"Open a new task" => "Avaa uusi tehtävä",
"taskId" => "tehtäväId",
"Task user" => "Tehtävän käyttäjä",
"Only the creator can delete this task" => "Vain tehtävän luoja voi sen poistaa",
"Use start date and time" => "Käytä aloituspäivää ja aikaa",
"Use end date and time" => "Käytä lopetuspäivää ja aikaa",
"Open / In Process" => "Avaa / menetelmään",
"Waiting / Not Started" => "Odottaa / ei käynnistetty",
"Percentage completed" => "Valmistuminen prosentteina",
"Shared for Group" => "Jaettu ryhmälle",
"Accepted by User" => "Hyväksynyt käyttäjä",
"No / Rejected" => "Ei / hylätty",
"Accepted by Creator" => "Hyväksynyt luojana",
"This message will be send to users if you are makeing changes of assigned tasks" => "Tämä viesti lähetetään käyttäjille jos teet muutoksia annettuihin tehtäviin",
"Send message with changes" => "Lähetä viesti ja muutokset",
"Modified by" => "Muokkaajana",
"Marked as deleted" => "Merkitty poistetuksi",
"Inform task user by email" => "Tiedota tehtävän käyttäjää sähköpostilla",
"You can only view this task" => "Voit katsoa vain tätä tehtävää",
"Completed" => "Valmis",
"No tasks entered" => "Ei lisättyjä tehtäviä",
"Select One" => "Valitse yksi",
"Undo Trash" => "Peruuta roskis",
"Show:" => "Näytä:",
"Received" => "Vastaanotettu",
"Submitted" => "Lähetetty",
"Shared" => "Jaettu",
"All Shared Tasks" => "Kaikki jaetut tehtävät",
"Start:" => "Aloitus:",
"End:" => "Lopetus:",
"Status:" => "Tila:",
"completed (100%)" => "valmis (100%)",
"Monthly" => "Kuukausittain",
"Add Watch" => "Lisää Vahti",
"A user submits an article" => "Käyttäjä ehdottaa artikkelia",
"A user submits a blog post" => "Käyttäjä ehdottaa bloki lähetystä",
"A user posts a forum thread" => "Käyttäjä lähetti foorumi ketjun",
"A user posts a forum topic" => "Käyttäjä lähetti foorumin aiheen",
"A user edited a wiki page" => "Käyttäjä muokkasi sivuston sivua",
"May need to refresh twice to see changes" => "Saattaa tarvita kaksi päivitystä nähdäksesi muutoksen",
"Add top level bookmarks to menu" => "Lisää ylimmän tason kirjanmerkki valikkoon",
"Add or edit an item" => "Lisää tai muuta osaa",
"New Window" => "Uusi ikkuna",
"replace window" => "korvaa ikkuna",
"User_versions_for" => "Käyttäjä_versio",
"This page is being edited by" => "Tätä sivua on muokannut",
"Proceed at your own peril" => "Jatka omalla vastuulla",
"Insert Row" => "Lisää Rivi",
"Insert Column" => "Lisää Palsta",
"Remove Row" => "Poista Rivi",
"Remove Column" => "Poista Palsta",
"Merge Cells" => "Yhdistä Kennot",
"Restore Cells" => "Palauta Kennot",
"Copy Calculation" => "Kopio Kaava",
"Format Cell" => "Kennon Muoto",
"expires:" => "sulkeutuu:",
"Banner stats" => "Banneri tilastot",
"Create new banner" => "Luo uusi banneri",
"Banner Information" => "Bannerin Tiedot",
"Click ratio" => "Paina suhde",
"Hours" => "Tuntia",
"Weekdays" => "Viikopäivät",
"mon" => "maa",
"tue" => "tii",
"wed" => "kes",
"thu" => "tor",
"fri" => "per",
"sat" => "lau",
"Banner raw data" => "Bannerin raaka data",
"Cached" => "Puskuroitu",
"This is a cached version of the page." => "Tämä on puskuroitu versio sivusta.",
"Click here to view the Google cache of the page instead." => "Paina tästä nähdäksesi Googlen puskuroiman version sivusta.",
"Answers" => "Vastaukset",
"Add Suggestion" => "Lisää ehdotus",
"Forum List" => "Foorumin Lista",
"Edit Forum" => "Muokkaa Foorumia",
"Summary" => "Yhteenveto",
"for links" => "linkkeihin",
"HTML tags are not allowed inside posts" => "HTML tagit eivät ole sallittuja lähetyksissä",
"Moderator Actions" => "Moderaattorin toiminnot",
"Move Selected Topics" => "Siirrä valitut aiheet",
"Unlock Selected Topics" => "Avaa valitut aiheet",
"Lock Selected Topics" => "Lukitse valitut aiheet",
"Delete Selected Topics" => "Poista valitut aiheet",
"Merge" => "Yhdistä",
"Merge Selected Topics" => "Yhdistä valitut aiheet",
"Reported Messages:" => "Raportoidut viestit:",
"Queued Messages:" => "Viestit jonossa:",
"Merge into topic" => "Yhdistä aiheeseen",
"Emot" => "Tunt",
"pts" => "pist",
"Announce" => "Tiedote",
"Hot" => "Kuuma",
"No topics yet" => "Ei aiheita vielä",
"Jump to forum" => "Hyppää foorumille",
"All posts" => "Kaikki lähetykset",
"Last hour" => "Viime tunti",
"Last 24 hours" => "Viimeiset 24 tuntia",
"Last 48 hours" => "Viimeiset 48 tuntia",
"prev topic" => "edel aihe",
"next topic" => "seur aihe",
"Show posts" => "Näytä lähetykset",
"Monitor" => "Tarkkale",
"Insert New Item" => "Liitä uusi osa",
"Edit Fields" => "Muuta kenttiä",
"Tracker Items" => "Kortiston osat",
"View inserted item" => "Näytä lisätty osa",
"Insert new item" => "Liitä uusi osa",
"Tracker Item:" => "Kortisto osa:",
"View Item" => "Näytä osa",
"Filter Tracker Items" => "Suodata Kortisto osia",
"Add a Comment" => "Lisää kommentti",
"Items list" => "Osien lista",
"Special Operations" => "Erikois Menetelmät",
"close" => "sulje",
"Show All" => "Näytä Kaikki",
"Clip" => "pala",
"Back To Mailbox" => "takaisin postilaatikkoon",
"Full Headers" => "täydet pääosat",
"Normal Headers" => "tavalliset pääosat",
"Reply To All" => "vastaa kaikille",
"Forward" => "lähetä edelleen",
"Cc" => "Kopio",
"Select from address book" => "valitse osoitekirjasta",
"CC" => "Kopio",
"BCC" => "Varmuuskopio",
"Use HTML mail" => "Käytä HTML lähetystä",
"The following addresses are not in your address book" => "Seuraava osoite ei ole osoitekirjassa",
"Add Contacts" => "Lisää yhtyeksiin",
"Attachment 1" => "Liite 1",
"Attachment 2" => "Liite 2",
"Attachment 3" => "Liite 3",
"Address book" => "Osoite kirja",
"page id" => "sivu id",
"3d browser" => "3d selain",
"Show/Hide Left Column" => "Näytä/Piilota Valikot Vasemmalla",
"Show/Hide Right Column" => "Näytä/Piilota Valikot Oikealla",
"Remove Image" => "Poista kuva",
"Use this thread to discuss the page:" => "Käytä tätä ketjua keskustellaksesi sivusta:",
"as Creator &amp; Last Editor" => "Luojana &amp; Viimeksi Muokannut",
"no (disabled)" => "ei (poistettu)",
"Save Minor Edit" => "Pieni",
"Administration" => "Ylläpito",
"Enable/disable Tiki features here, but configure them elsewhere" => "Aseta Tikin ominaisuudet päälle/poispäältä täällä, mutta muokkaa ominaisuutta muualla",
"General preferences and settings" => "Yleiset oikeudet ja asetukset",
"User registration, login and authentication" => "Käyttäjän rekisteröinti, kirjaus ja varmistus",
"Wiki settings" => "WAsetukset",
"Wiki Attachments" => "Sivusto Liitteet",
"Article/CMS settings" => "Artikkeli/CMS asetukset",
"Poll comments settings" => "Äänestys kommenttien asetukset",
"Configuration options for all blogs on your site" => "Kokoonpano vaihtoehdot sivuston kaikille blogeille",
"Forums settings" => "Foorumin asetukset",
"FAQ comments settings" => "UKK kommenttien asetukset",
"Trackers settings" => "Kortiston asetukset",
"Directory settings" => "Hakemisto asetukset",
"Maps configuration" => "Karttojen kokoonpano",
"Meta Tags settings" => "Meta Tagien asetukset",
"Search settings" => "Etsintä asetukset",
"Score settings" => "Piste asetukset",
"Community settings" => "Yhteisö asetukset",
"Calendar settings" => "Kalenteri asetukset",
"Intertiki settings" => "Intertiki asetukset",
"Help on \$admintitle Config" => "Auta \$ylläpitoaiheen asetuksessa",
"Category can`t be parent of itself" => "Luokka ei voi olla itsensä isäntä",
"Upload failed" => "Lähetys epäonnistui",
"All posted" => "Kaikki lähetetyt",
"Queue anonymous posts" => "Nimettömien postit jonoon",
"Queue all posts" => "Kaikki postit jonoon",
"No attachments" => "Ei liitteitä",
"Everybody can attach" => "Kaikki voivat liittää",
"Only users with attach permission" => "Vain käyttäjät joilla on liite lupa",
"Moderators and admin can attach" => "Esimiehet ja ylläpito voivat liittää",
"Date (desc)" => "Päiväys (aleneva)",
"Date (asc)" => "Päiväys (nouseva)",
"Score (desc)" => "Tilanne (aleneva)",
"Replies (desc)" => "Vastaukset (aleneva)",
"Reads (desc)" => "Lukijaa (aleneva)",
"You have to provide a hotword and a URL" => "Sinun on osoitettava hotword ja URL",
"Owner" => "Omistaja",
"Detected, Version:" => "Löydetty, Versio:",
"Not detected." => "Ei löytynyt.",
"Your admin password has been changed" => "Admin salasanasi on vaihdettu",
"You cannot have a blank password" => "Salasana ei voi olla tyhjä",
"All Fields except gdaltindex must be filled" => "Kaikki kentät paitsi gdaltindex on täytettävä",
"No valid gdaltindex executable" => "Ei oikea gdaltindex ohjelma",
"You cannot mix old and new trackers" => "Et voi sekoittaa uusia ja vanhoja kortistoja",
"Tag already exists" => "Lisäys on jo olemassa",
"Tag not found" => "Lisäystä ei löydy",
"Repository name can't be an empty" => "Säilytyspaikan nimi ei voi olla tyhjä",
"Requested action is not supported on repository" => "Pyydetty toiminto ei ole tuettu säilytyspaikalle",
"No repository" => "Ei säilytyspaikkaa",
"Search is mandatory field" => "Etsintäkenttä on pakollinen",
"File not found " => "Tiedostoa ei löydy ",
"Requested action in not supported on repository" => "Pyydetty toiminto ei ole tuettu säilytyspaikalle",
"Non-existent link" => "Olematon linkki",
"Mail-in account %s incorrect" => "Posti-sisään tili %s väärä",
"Mail-in account %s saved" => "Posti-sisään tili %s tallennettu",
"Frequency should be a positive integer!" => "Muutosväli on oltava positiivinen kokonaisluku!",
"Mail-in accounts set to be checked every %s minutes" => "Postit-sisään tilit tarkistetaan joka %s minuutti",
"Automatic Mail-in accounts checking disabled" => "Automaattinen postit-sisään tilien tarkistus pois päältä",
"No menu indicated" => "Ei valikkoa osoitettu",
"No newsletter indicated" => "Ei uutislehteä osoitettu",
"A user registers" => "Käyttäjän rekisteröinti",
"Any wiki page is changed" => "Mikä tahansa sivu muuttuu",
"Any wiki page is changed, even minor changes" => "Mikä tahansa sivu muuttuu, jopa pienet muutokset",
"PHP error" => "PHP virhe",
"No poll indicated" => "Ei äänestystä osoitettu",
"unsafe" => "turvaton",
"register_globals should be off by default. See the php manual for details." => "register_globals pitää olla pois päältä oletuksena. Katso php:n käsikirjasta tarkemmin.",
"safe" => "turvallinen",
"risky" => "riski",
"session.use_trans_sid should be off by default. See the php manual for details." => "istunnon.use_trans_sid pitää olla pois päältä oletuksena. Katso php:n käsikirjasta tarkemmin.",
"upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser" => "upload_tmp_dir on sivustohakemiston sisällä. On olemassa vaara, että joku voi lähettää minkätahansa tiedoston sinne ja päästä sinne selaimella",
"cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config." => "ei voi tarkistaa onko upload_tmp_dir selattavissa selaimella. Ollaksesi varma tarkista palvelimen asetukset.",
"setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them" => "asetus xbithack ei ole turvallinen. Riippuen tiedoston käsittelystä palvelimella ja sivuston asetuksista, saattaa hyökkääjä voida lähettää tiedoston galleriaan ja käynnistää se sieltä",
"allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off." => "allow_url_fopen mahdollistaa ohjelmien ja skripitien lähetyksen. Jos blogit eivät ole käytössä, voit ottaa sen pois päältä.",
"The Path to store files in the filegallery should be outside the tiki root directory" => "Tiedostojen tallennuspolku on oltava sivuston juuren ulkopuolella",
"The Path to store files in the imagegallery should be outside the tiki root directory" => "Kuvien tallennuspolku on oltava sivuston juuren ulkopuolella",
"The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code." => "Ominaisuus \"Muuta Malleja\" on päällä. Älä anna kenenkään johon et varmasti luota käyttää tätä. Sitä voi helposti käyttää ajamaan php koodia.",
"Path disclosure" => "Polun näyttäminen",
"Path disclosure through error message" => "Polku näytetään virheviestissä",
"SQL injection" => "SQL lisäys",
"SQL injection by authenticated user" => "SQL lisäys varmistetulta käyttäjältä",
"SQL injection by authenticated user with special privileges" => "SQL lisäys varmistetulta käyttäjältä, jolla on erikoisoikeudet",
"SQL injection without authentication" => "SQL lisäys ilman varmistusta",
"PHP command injection" => "PHP komentolisäys",
"PHP command injection by authenticated user" => "PHP komentolisäys varmistetulta käyttäjältä",
"PHP command injection by authenticated user with special privileges" => "PHP komentolisäys varmistetulta käyttäjältä, jolla on erikoisoikeudet",
"PHP command injection without authentication" => "PHP komentolisäys ilman varmistusta",
"File upload" => "Tiedosto lähetys",
"File is not readable. Unable to check." => "Tiedosto ei ole luettavissa. Ei voi tarkistaa.",
"This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous." => "Tämä ei ole normaali tiedosto. Tarkista onko tiedosto lähetetty, jos niin saattaa olla vaaraksi.",
"This is a modified File. Cannot check version. Check if it is dangerous." => "Tätä Tiedostoa on muokattu. Ei voi tarkistaa versiota. Tarkista onko vaaraksi.",
"This file is from another Tikiwiki version: " => "Tämä tiedosto on sivustoversiosta: ",
"You have to provide a word" => "Sinun on annettava sana",
"Permission denied. You cannot view this page." => "Oikeutesi eivät riitä katsomaan tätä sivua",
"Permission denied you cannot edit this page" => "Oikeutesi eivät riitä tämän sivun muokkaamiseen",
"You must specify a page name, it will be created if it doesn't exist." => "Sinun on annettava sivulle nimi, jos sitä ei ole ennestään se luodaan.",
"page not added (Exists)" => "sivua ei lisätty (On olemassa)",
"No survey indicated" => "Ei tutkimusta osoitettu",
"You don't have permission to use this feature" => "Oikeutesi eivät riitä käyttämään tätä ominaisuutta",
"No Errors detected" => "Virheitä Ei havaittu",
"Error:" => "Virhe:",
"No tracker indicated" => "Ei kortistoa osoitettu",
"Group already exists" => "Ryhmä on jo olemassa",
"User doesn't exist" => "Käyttäjää ei ole olemassa",
"No records were found. Check the file please!" => "Tallennusta ei löytynyt. Tarkista tiedosto!",
"User login is required" => "Tarvitaan kirjautuminen",
"Password is required" => "Tarvitaan salasana",
"Email is required" => "Tarvitaan sähköpostiosoite",
"User is duplicated" => "Käyttäjä on kopioitu",
"Created account %s <%s>" => "Luotu tili %s <%s>",
"Assigned %s in group %s" => "Liitetty %s ryhmään %s",
"User %s already exists" => "Käyttäjä %s on jo olemassa",
"New %s created with %s %s." => "Uusi %s luotu jolla on %s %s.",
"Impossible to create new %s with %s %s." => "Mahdotonta luoda uutta %s jolla on %s %s.",
"%s %s successfully deleted." => "%s %s on onnistuneesti poistettu.",
"%s %s removed from %s %s." => "%s %s poistettu %s %s.",
"%s changed from %s to %s" => "%s vaihdettu %s  %s",
"Impossible to change %s from %s to %s" => "Mahdotonta vaihtaa %s  %s  %s",
"%s modified successfully." => "%s on muutettu onnistuneesti.",
"password" => "salasana",
"%s modification failed." => "%s muutos ei onnistunut.",
"rss feed disabled" => "rss syöte poistettu",
"Tiki RSS feed for articles" => "RSS artikkelien syöte",
"Last articles." => "Viimeiset artikkelit.",
"Unknown group" => "Tuntematon ryhmä",
"Group doesn't exist" => "Ryhmää ei ole olemassa",
"You have to indicate a group" => "On osoitettava ryhmä",
"This group is invalid" => "Tämä ryhmä on väärä",
"Permission denied you cannot view backlinks for this page" => "Oikeutesi eivät riitä paluulinkkien katsomiseen tältä sivulta",
"The page cannot be found" => "Sivua ei löydy",
"Image Galleries Admin Panel" => "Kuva Gallerioiden Ylläpito Paneeli",
"Could not read image %s." => "Kuvaa %s ei voi lukea.",
"Image %s upload failed." => "Kuvan %s lähetys epäonnistui.",
"Image %s uploaded successfully." => "Kuvan %s lähetys onnistui.",
"Image %s removed from Batch directory." => "Kuva %s on poistettu ryhmälähetys hakemistosta.",
"Impossible to remove image %s from Batch directory." => "Mahdotonta poistaa kuvaa %s ryhmälähetys hakemistosta.",
"Permission denied you cannot use the batch directory loading" => "Sinulla ei ole oikeutta käyttää ryhmälähetys hakemisto latausta",
"Incorrect directory chosen for batch upload of images." => "Väärä hakemisto valittu kuvien ryhmälähetystä varten.",
"Please setup that dir on " => "Tee hakemisto asetukset ",
"Please contact the website administrator." => "Ota yhteyttä sivuston ylläpitoon.",
"Invalid directory name" => "Väärä hakemiston nimi",
"It isn't possible to post in any blog. You may need to create a blog first." => "Et voi lähettää mihinkään blogiin, ehkä sinun on luotava blogi ensin",
"Permission denied you cannot post" => "Oikeutesi eivät riitä lähettämiseen",
"Permission denied you cannot edit this post" => "Oikeutesi eivät riitä lähetyksen muokkamiseen",
"Top visited blogs" => "Eniten katsotut blogit",
"Last posts" => "Viimeiset lähetykset",
"Top active blogs" => "Aktiivisimmat blogit",
"Tiki RSS feed for blog: " => "RSS syöte blogille: ",
"No blogId specified" => "Ei blogId tarkennusta",
"Tiki RSS feed for weblogs" => "RSS syöte verkkoblogeille",
"Last posts to weblogs." => "Viimeiset lähetykset verkkoblogeihin.",
"Permission denied you cannot access this gallery" => "Oikeutesi eivät riitä tähän galleriaan",
"No gallery indicated" => "Ei galleriaa osoitettu",
"Permission denied you can not view this section" => "Oikeutesi eivät riitä katsomaan tätä osastoa",
"Permission denied you cannot remove images from this gallery" => "Oikeutesi eivät riitä poistamaan kuvia tästä galleriasta",
"Permission denied you cannot rebuild thumbnails in this gallery" => "Oikeutesi eivät riitä tekemään minikuvia tästä galleriasta",
"Permission denied you cannot rotate images in this gallery" => "Oikeutesi eivät riitä kääntämään kuvia tässä galleriassa",
"No image indicated" => "Ei kuvaa osoitettu",
"Permission denied you cannot move images from this gallery" => "Oikeutesi eivät riitä siirtämään kuvia tästä galleriasta",
"Permission denied you cannot view the calendar" => "Oikeutesi eivät riitä katsomaan kalenteria",
"event without name" => "nimetön tapahtuma",
"Access Denied" => "Pääsy Estetty",
"Tiki RSS feed for calendars" => "RSS syöte kalentereille",
"Upcoming events." => "Tulossa olevat tapahtumat.",
"Invalid username or activation code. Maybe this code has already been used." => "Väärä käyttäjänimi tai aktivointi koodi. Ehkä tämä koodi on jo käytetty.",
"You can not use the same password again" => "Et voi käyttää samaa salasanaa uudelleen",
"Top authors" => "Top kirjoittajat",
"Message sent to" => "Viesti lähetetty",
"You need to change chmod 'whelp' manually to 777" => "Sinun muutettava chmod 'whelp' oikeudet käsin 777",
"This feature has been disabled" => "Tämä ominaisuus poistettu",
"Tiki RSS feed for directory sites" => "RSS syöte hakemisto sivustoille",
"Last sites." => "Viimeiset sivustot.",
"Must enter a name to add a site. " => "Annettava nimi lisätäksesi sivuston. ",
"Must enter a url to add a site. " => "Annettava url lisätäksesi sivuston. ",
"URL already added to the directory. Duplicate site? " => "URL on jo hakemistossa. Kopio sivusto? ",
"URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. " => "URL osoite ei toimi URL on väärin tai sivusto ei ole verkossa eikä sitä voi lisätä hakemistoon. ",
"Must select a category. " => "On valittava luokittelu. ",
"Must enter a name to add a site" => "Annettava nimi lisätäksesi sivuston",
"Must enter a url to add a site" => "Annettava url lisätäksesi sivuston",
"URL already added to the directory. Duplicate site?" => "URL on jo olemassa. Kopioidaanko sivusto?",
"URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory" => "URL osoite ei toimi URL on väärin tai sivusto ei ole verkossa eikä sitä voi lisätä hakemistoon",
"Must select a category" => "On valittava luokittelu",
"No site indicated" => "Ei sivustoa osoitettu",
"No parent specified" => "Ei isäntää",
"Article not found" => "Artikkelia ei löytynyt",
"Permission denied you cannot edit this article" => "Oikeutesi eivät riitä tämän artikkelin muokkaamiseen",
"The language can't be changed as its set of translations has already this language" => "Kieltä ei voi muuttaa, koska sen niminen on jo kieli hakemistossa",
"You do not have permissions to edit banners" => "Oikeutesi eivät riitä bannerien muokkaamiseen",
"Banner not found" => "Banneria ei löydy",
"You do not have permission to edit this banner" => "Oikeutesi eivät riitä tämän bannerin muokkaamiseen",
"Permission denied you cannot create or edit blogs" => "Oikeutesi eivät riitä blogien luomiseen tai muokkaamiseen",
"Permission denied you cannot edit this blog" => "Oikeutesi eivät riitä tämän blogin muokkaamiseen",
"You do not have permission to write the style sheet" => "Oikeutesi eivät riitä tyylitiedoston kirjoittamiseen",
"Invalid request to edit an image" => "Väärä pyyntö muokataksesi kuvaa",
"Permission denied you cannot edit images" => "Oikeutesi eivät riitä kuvan muokkaamiseen",
"Permission denied you can edit images but not in this gallery" => "Oikeutesi riittävät kuvan muokkaamiseen, muttei tässä galleriassa",
"Failed to edit the image" => "Kuvan muokkaus epäonnistui",
"Permission denied to use this feature" => "Oikeutesi eivät riitä käyttämään tätä ominaisuutta",
"Shortname must be 2 Characters" => "Lyhenne pitää olla 2 merkkiä",
"You must provide a longname" => "Tarjottava pitempi nimi",
"Language created" => "Kieli luotu",
"No content id indicated" => "Ei sisältö id:tä osoitettu",
"No question indicated" => "Ei kysymystä osoitettu",
"No quiz indicated" => "Ei visailua osoitettu",
"No structure indicated" => "Ei rakennetta osoitettu",
"Invalid structure_id or page_ref_id" => "Väärä rakenne_id tai sivu_ref_id",
"Permission denied you cannot send submissions" => "Oikeutesi eivät riitä ehdotuksen lähettämiseen",
"Permission denied you cannot edit submissions" => "Oikeutesi eivät riitä ehdotuksen muokkaamiseen",
"You have to create a topic first" => "On luotava ensin aihe",
"You do not have permission to do that" => "Oikeutesi eivät riitä siihen",
"You do not have permission to write the template:" => "Sinulla ei ole oikeutta kirjoittaa mallia:",
"You do not have permission to read the template" => "Oikeutesi eivät riitä lukemaan mallia",
"No topic id specified" => "Ei aihe id:tä määritelty",
"Invalid topic id specified" => "Väärä aiha id määritelty",
"No object indicated" => "Ei kohdetta osoitettu",
"No type indicated" => "Ei tyyppiä osoitettu",
"page imported" => "sivu tuotu",
"created from import" => "luotu tuodusta",
"Can't import remote HTML page" => "Ei voi tuoda ulkoista HTML sivua",
"The SandBox is disabled" => "Hiekkaloota poistettu",
"Cannot edit page because it is locked" => "Et voi muokata tätä sivua, koska se on lukittu",
"No questions group indicated" => "Ei kysymysten ryhmää osoitettu",
"Permission denied you cannot edit this file" => "Oikeutesi eivät riitä muokkaamaan tätä tiedostoa",
"Permission denied you cannot remove files from this gallery" => "Oikeutesi eivät riitä poistamaan tiedostoja tästä galleriasta",
"Top visited file galleries" => "Katsotuimmat tiedosto galleriat",
"Most downloaded files" => "Imuroiduimmat tiedostot",
"Last files" => "Viimeiset tiedostot",
"Tiki RSS feed for file galleries" => "RSS syöte tiedosto gallerioille",
"Last files uploaded to the file galleries." => "Viimeksi lähetetyt tiedostot tiedostogallerioissa.",
"No galleryId specified" => "Ei galleriaId tarkennusta",
"Tiki RSS feed for the file gallery: " => "RSS syöte tiedostogallerialle: ",
"No forum indicated" => "Ei foorumia osoitettu",
"Last forum topics" => "Viimeiset foorumin aiheet",
"Top topics" => "Top aiheet",
"Forum posts" => "Foorumi lähetykset",
"No forumId specified" => "Ei foorumiId tarkennusta",
"Tiki RSS feed for forum: " => "RSS syöte foorumille: ",
"Tiki RSS feed for forums" => "RSS syöte foorumeille",
"Last topics in forums." => "Viimeiset foorumien aiheet.",
"Accepted friendship request from %s" => "Hyväksytty ystävyyspyyntö %s :lta",
"Refused friendship request from %s" => "Hylätty ystävyyspyyntö from %s :lta",
"Broke friendship with %s" => "Riko ystävyys %s :n",
"I have broken our friendship!" => "Olen rikkonut ystävyytemme!",
"You must be logged in to use this feature" => "Sinun on kirjauduttava sisään käyttääksesi tätä ominaisuutta",
"Friendship request sent to %s" => "Ystävyys pyyntö on lähetetty %s :lle",
"You're already friend of %s" => "Olet jo %s :n ystävä",
"I have accepted your friendship request!" => "Olen hyväksynyt ystävyyspyyntösi!",
"first uploaded image" => "lähetä ensin kuva",
"last uploaded image" => "viimeksi lähetetty kuva",
"first image" => "ensimmäinen kuva",
"last image" => "viimeisin kuva",
"random image" => "satunnais kuva",
"Permission denied you cannot create galleries and so you cant edit them" => "Oikeutesi eivät riitä gallerian luomiseen,joten et voi myöskään muokata",
"Permission denied you cannot edit this gallery" => "Oikeutesi eivät riitä gallerian muokkaamiseen",
"Permission denied you cannot remove this gallery" => "Oikeutesi eivät riitä gallerian poistamiseen",
"Permission denied you cannot make the map of this gallery" => "Lupa evätty, et voi tehdä karttaa tästä galleriasta",
"Top images" => "Top kuvat",
"Last images" => "Viimeiset kuvat",
"No valid renderer found. GD or PDFLib required." => "Ei löytynyt muodostajaa. GD tai PDFLib tarvitaan.",
"No sheet specified." => "Ei määriteltyä arkkia.",
"You must select a renderer." => "Valitse muodostaja.",
"Invalid Series for current graphic." => "Viallinen sarja nykyiselle grafiikalle.",
"Tiki RSS feed for image galleries" => "RSS syöte kuva gallerioille",
"Last images uploaded to the image galleries." => "Viimeiset lähetetyt kuvat kuva gallerioihin.",
"Tiki RSS feed for the image gallery: " => "RSS syöte kuva gallerialle: ",
"overwriting old page" => "päällekirjoitetaan vanha sivu",
"updated from structured text import" => "päivitetty rakenteen sisältävästä tekstituonnista",
"page created" => "sivu luotu",
"created from structured text import" => "luotu rakenteen sisältävästä tekstituonnista",
"No name indicated for wiki page" => "Ei nimeä osoitettu wiki sivulle",
"No repository given" => "Ei säilytyspaikkaa annettu",
"Permission denied. You cannot view pages like this page" => "Oikeutesi eivät riitä tämän kaltaisten sivujen katsomiseen",
"Permission denied you cannot remove articles" => "Oikeutesi eivät riitä poistamaan artikkeleja",
"Permission denied you cannot remove banners" => "Oikeutesi eivät riitä poistamaan bannereita",
"Permission denied you cannot remove this blog" => "Oikeutesi eivät riitä poistamaan tätä blogia",
"Non-existent gallery" => "Ei olemassa oleva galleria",
"Permission denied you can upload files but not to this file gallery" => "Voit lähettää tiedostoja, mutta et tähän galleriaan",
"Could not upload the file" => "Ei voi lähettää tiedostoa",
"Could not find the file requested" => "Pyydettyä tiedostoa ei löytynyt",
"File update was successful" => "Tiedosto päivitys onnistui",
"Permission denied you can't upload files so you can't edit them" => "Oikeutesi eivät riitä lähtettämään tiedostoja, joten et voi myöskään muokata niitä",
"This gallery does not exist" => "Tällaista galleriaa ei ole",
"You cannot admin blogs" => "Et voi hallinnoida blogeja",
"Permission denied you cannot remove submissions" => "Oikeutesi eivät riitä poistamaan ehdotuksia",
"Permission denied you cannot approve submissions" => "Oikeutesi eivät riitä hyväksymään ehdotuksia",
"You have to enable cookies to be able to login to this site" => "Sinun on hyväksyttävä keksit voidaksesi kirjautua tälle sivustolle",
"Unable to contact remote server." => "Yhteyttä ulkoisiin palvelimiin ei saada.",
"XMLRPC Error: " => "XMLRPC Virhe: ",
"Tiki mail-in auto-reply" => "Postit-sisään autom-vastaus",
"Sorry, you can't use this feature." => "Valitan, et voi käyttää tätä ominaisuutta.",
"You do not have permissions to view the maps" => "Oikeutesi eivät riitä katsomaan karttoja",
"Maps feature is not correctly setup : Maps path is missing." => "Kartta ominaisuuden asetukset ovat väärin : Karttojen polku puuttuu.",
"mapfile name incorrect" => "karttatiedoston nimi väärin",
"This mapfile already exists" => "Karttatiedosto on jo olemassa",
"You do not have permission to write to the mapfile" => "Oikeutesi eivät riitä karttatiedoston kirjoittamiseen",
"You do not have permission to delete the mapfile" => "Oikeutesi eivät riitä poistamaan karttatiedostoa",
"I could not make a copy" => "Ei voitu kopioida",
"You do not have permission to read the mapfile" => "Oikeutesi eivät riitä lukemaan karttatiedostoa",
"You dont have permission to do that" => "Oikeutesi eivät riitä sen tekemiseen",
"Tiki RSS feed for maps" => "RSS syöte kartoille",
"List of maps available." => "Saatavilla olevien karttojen luettelo.",
"You do not have permissions to view the layers" => "Oikeutesi eivär riitä katsomaan tasoja",
"You do not have permissions to delete a file" => "Oikeutesi eivät riitä poistamaan tiedostoa",
"File not found" => "Tiedostoa ei löydy",
"You do not have permissions to create a directory" => "Oikeutesi eivät riitä luomaan hakemistoa",
"The Directory is not empty" => "Hakemisto ei ole tyhjä",
"You do not have permissions to delete a directory" => "Oikeutesi eivät riitä poistamaan hakemistoa",
"You do not have permissions to create an index file" => "Oikeutesi eivät riitä luomaan index tiedostoa",
"Invalid file name" => "Väärä tiedoston nimi",
"Invalid files to index" => "Väärä tiedosto indeksiksi",
"I do not know where is gdaltindex. Set correctly the Map feature" => "En tiedä missä on gdaltindex. Aseta oikea kartta ominaisuus",
"I could not create the index file" => "Ei voi luoda index tiedostoa",
"Must be logged to use this feature" => "On kirjauduttava käyttääksesi ominaisuutta",
"Welcome at Hawiki" => "Tervetuloa Mobileen",
"This Tikiwiki site is prepared for access from a lot of mobile devices, e.g. WAP phones, PDA's, i-mode devices and much more." => "Sivusto on luotu käytettäväksi myös, esimerkiksi WAP puhelimilla, PDA, i-mode laitteilla ja paljon muuta.",
"You can browse this site on your mobile device by directing your device's browser towards the following URL here on this site:" => "Voit selata sivustoa mobiili laitteella osoittamalla seuraavalle sivulle:",
"tiki-mobile.php" => "mobile.php",
"About" => " ",
"You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody" => "Sinun on ajettava setup.sh :<br />./setup.sh \$APACHEUSER all<br />Yleinen Apache käyttäjä on www-data, apache tai nobody",
"Your PHP installation does not have zlib enabled." => "Sinun PHP asennuksessa ei ole zlib päällä.",
"You must log in to use this feature" => "On kirjauduttava käyttääksesi tätä ominaisuutta",
"You do not have permission to view other users data" => "Oikeutesi eivät riitä katsomaan muiden käyttäjien tietoja",
"You must be logged in to subscribe to newsletters" => "On kirjauduttava tilataksesi uutislehden",
"No note indicated" => "Ei merkintää osoitettu",
"merged note:" => "yhdistetty merkintä:",
"File is too big" => "Tiedosto liian suuri",
"No item indicated" => "Ei osaa osoitettu",
"created from notepad" => "luotu muistiosta",
"Page already exists" => "Sivu on jo olemassa",
"Not enough information to display this page" => "Ei tarpeeksi tietoja sivun näyttämiseen",
"Permission denied you cannot browse this page history" => "Oikeutesi eivät riitä selaamaan tämän sivun historiaa",
"No article indicated" => "Ei artikkelia osoitettu",
"Article is not published yet" => "Artikkelia ei ole vielä julkaistu",
"No post indicated" => "Ei postia osoitettu",
"Blog not found" => "Blogia ei löydy",
"No pages indicated" => "Ei sivuja osoitettu",
"Pageviews" => "Sivunäyttöjä",
"You don't have permission to edit quizzes." => "Oikeutesi eivät riitä muokkaamaan visailuja.",
"No result indicated" => "Ei tulosta osoitettu",
"The passwords don't match" => "Salasana ei kelpaa",
"Invalid or unknown username" => "Väärä tai tuntematon käyttäjänimi",
"Unable to send mail. User has not configured email" => "Sähköpostia ei voi lähettää. Käyttäjä ei ole antanut sähköpostiosoitetta",
"A password reminder email has been sent " => "Salasanan muistutus lähetetty ",
"to the registered email address for" => "rekisteröityyn sähköpostiosoitteeseen",
"last version" => "viimeinen versio",
"Permission denied you cannot remove versions from this page" => "Oikeutesi eivät riitä poistamaan tämän sivun versioita",
"Permission denied you cannot rename this page" => "Oikeutesi eivät riitä muuttamaan sivun nimeä",
"Cannot rename page because the new name begins with reserved prefix" => "Et voi uudelleen nimetä sivua koska uusi nimi alkaa jo varatulla etuliitteellä",
"Cannot rename page maybe new page already exists" => "Ei voi nimetä uudelleen sivua, kenties sillä nimellä on jo sivu",
"Non-existent version" => "Olemanton versio",
"Permission denied you cannot rollback this page" => "Oikeutesi eivät riitä kelata takaisin tätä sivua",
"Error Message" => "Virhe Viesti",
"Tiki RSS Feed Error Message: \$errmsg" => "RSS Syötteen Virhe Viesti: \$errmsg",
"No newsletters available." => "Ei uutislehtiä saatavilla.",
"successfully sent" => "onnistuneesti lähetetty",
"not sent" => "ei lähetetty",
"Error: " => "Virhe: ",
"Page must be defined inside a structure to use this feature" => "Sivu on määriteltävä rakenteen sisällä käyttääksesi tätä ominaisuutta",
"You cannot take this quiz twice" => "Et voi osallistua visailuun kahdesti",
"Quiz time limit exceeded quiz cannot be computed" => "Visailun aikaraja ylitetty, ei voi pisteyttää",
"You cannot take this survey twice" => "Et voi ottaa tutkimusta kahdesti",
"Please create a category first" => "Luo luokittelu ensin",
"Tracker item:" => "Kortisto osa:",
"empty" => "tyhjennä",
"No trackerId specified" => "Ei kortistoId määrittelyä",
"Tiki RSS feed for individual trackers: " => "RSS syöte yksittäis kortistoille: ",
"No permission to upload zipped file packages" => "Ei oikeutta lähettää zip-paketteja",
"Error processing zipped image package" => "Virhe zip-pakettien purkamisessa",
"No permission to upload zipped image packages" => "Ei oikeutta lähettää zip-pakattuja kuvatiedostoja",
"The uploaded file ist not recognized as a image" => "Lähetettyä tiedostoa ei tunnistettu kuvaksi",
"Permission denied you cannot upload images" => "Et voi lähettää kuvia",
"Permission denied you can upload images but not to this gallery" => "Voit lähettää kuvia, mutta et tähän galleriaan",
"Cannot get image from URL" => "Kuvaa ei saatu osoitteesta URL",
"That is not an image (or you have php < 4.0.5)" => "Tämä ei ole kuva (tai sinulla on php < 4.0.5)",
"Usage" => "Käyttö",
"No url indicated" => "Ei url osoitettu",
"Unknown user" => "Tuntematon käyttäjä",
"You are not logged in and no user indicated" => "Et ole kirjautunut eikä käytäjää ole osoitettu",
"The user has chosen to make his information private" => "Käyttäjä on valinnut tietonsa yksityisiksi",
"Email is set to %s" => "Sähköpostiksi on asetettu %s",
"The passwords did not match" => "Salasana ei täsmää",
"no" => "ei",
"was moved into trash" => "on siirretty roskiin",
"trashed by" => "siirtänyt roskiin",
"open / in process" => "avaa / menetelmään",
"Public for group" => "Julkaistu ryhmälle",
"Rights by creator" => "Oikeudet luojalla",
"END" => "LOPPU",
"Percentage" => "Prosentteina",
"Task accepted by creator" => "Tehtävän hyväksynyt sen luoja",
"Task accepted by task user" => "Tehtävän hyväksynyt tehtävän käyttäjä",
"Task NOT accepted by creator" => "Tehtävää EI hyväksynyt sen luoja",
"Task NOT accepted by task user" => "Tehtävää EI hyväksynyt tehtävän käyttäjä",
"Sorry this task does not exist or you have no rights to view this task" => "Valitan tällaista tehtävää ei ole tai sinulla ei ole oikeutta nähdä sitä",
"Task entries:" => "Tehtävät:",
"Changes:" => "Muutokset:",
"Info message" => "Info viesti",
"NEW Task" => "UUSI Tehtävä",
"Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks!" => "Valitan, mutta et voi lähettää tehtäviä muille käyttäjille, tai käyttäjällä ei ole oikeutta vastaanottaa tehtävää!",
"Changes on Task" => "Tehtävän Muutokset",
"You received a new task" => "Olet vastaanottanut uuden tehtävän",
"The priority is" => "Kiireellisyys",
"very low" => "erittäin alhainen",
"low" => "alhainen",
"high" => "korkea",
"very high" => "erittäin korkea",
"You've to start your work at least on" => "Sinun on aloitettava työsi viimeistään",
"You've to finish your work on" => "Työsi on saatava valmiiksi",
"Login and click the link below" => "Kirjaudu ja paina linkkiä alhaalta",
"Please read the task and work on it!" => "Lue tehtävä ja tee se!",
"Sorry, there was an error while trying to write data into the database" => "Valitan, ilmeni virhe kirjoitettaessa tietokantaan",
"Cannot upload this file not enough quota" => "Et voi lähettää tiedostoa, levytilasi on liian pieni",
"No user indicated" => "Ei käyttäjää osoitettu",
"Non-existent user" => "Olematon käyttäjä",
"No banner indicated" => "Ei banneria osoitettu",
"No blog indicated" => "Ei blogia osoitettu",
"Permission denied you cannot remove the post" => "Et voi poistaa lähetystä",
"No cache information available" => "Ei puskuritietoja saatavilla",
"No faq indicated" => "Ei ukk:ta osoitettu",
"You are not permitted to remove someone else\\'s post!" => "Et voi poistaa kenenkään toisen posteja!",
"No thread indicated" => "Ei ketjua osoitettu",
"A SheetId is required." => "ArkkiId tarvitaan.",
"That tracker don't use extras." => "Se kortisto ei käytä ekstroja.",
"Aborted" => "Keskeytetty",
"Top pages" => "Top sivut",
"Last pages" => "Viimeiset sivut",
"Tiki RSS feed for the wiki pages" => "RSS syöte sivuston sivuille",
"Last modifications to the Wiki." => "Viimeiset muutokset sivustolla.",
"###end###"=>"###end###");
