#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Mopi
# SPDX-FileCopyrightText: © 2018 Dominique Derrier
# SPDX-FileCopyrightText: © 2018 Andrey Butirsky
# SPDX-FileCopyrightText: © 2018 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2020 macaron
set -o errexit

###
# Little Big Adventure series:
# - Little Big Adventure
# - Little Big Adventure 2
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250826.2

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID_LBA1='little-big-adventure-1'
GAME_NAME_LBA1='Little Big Adventure'

GAME_ID_LBA2='little-big-adventure-2'
GAME_NAME_LBA2='Little Big Adventure 2'

ARCHIVE_BASE_LBA1_1_NAME='setup_little_big_adventure_1.0_(28186).exe'
ARCHIVE_BASE_LBA1_1_MD5='43d4926dc8a56a95800e746ac9797201'
ARCHIVE_BASE_LBA1_1_TYPE='innosetup'
ARCHIVE_BASE_LBA1_1_SIZE='510000'
ARCHIVE_BASE_LBA1_1_VERSION='1.0-gog28186'
ARCHIVE_BASE_LBA1_1_URL='https://www.gog.com/game/little_big_adventure'

ARCHIVE_BASE_LBA1_0_NAME='setup_lba_2.1.0.22.exe'
ARCHIVE_BASE_LBA1_0_MD5='c40177522adcbe50ea52590be57045f8'
ARCHIVE_BASE_LBA1_0_TYPE='innosetup'
ARCHIVE_BASE_LBA1_0_SIZE='510000'
ARCHIVE_BASE_LBA1_0_VERSION='1.0-gog2.1.0.22'

ARCHIVE_BASE_LBA2_1_NAME='setup_little_big_adventure_2_1.0_(28192).exe'
ARCHIVE_BASE_LBA2_1_MD5='80b95bb8faa2353284b321748021da16'
ARCHIVE_BASE_LBA2_1_TYPE='innosetup'
ARCHIVE_BASE_LBA2_1_SIZE='750000'
ARCHIVE_BASE_LBA2_1_VERSION='1.0-gog28192'
ARCHIVE_BASE_LBA2_1_URL='https://www.gog.com/game/little_big_adventure_2'

ARCHIVE_BASE_LBA2_0_NAME='setup_lba2_2.1.0.8.exe'
ARCHIVE_BASE_LBA2_0_MD5='9909163b7285bd37417f6d3c1ccfa3ee'
ARCHIVE_BASE_LBA2_0_TYPE='innosetup'
ARCHIVE_BASE_LBA2_0_SIZE='750000'
ARCHIVE_BASE_LBA2_0_VERSION='1.0-gog2.1.0.8'

CONTENT_PATH_DEFAULT='.'
CONTENT_PATH_DEFAULT_LBA1_0='app'
CONTENT_PATH_DEFAULT_LBA2_0='app'
CONTENT_GAME_MAIN_FILES_LBA1='
VOX
SAMPLE.AD
SETSOUND.BAT
LBA.CFG
LBA.DAT
A32ALGFM.DLL
A32GFX.DLL
A32MT32.DLL
A32OP3FM.DLL
A32PASFM.DLL
A32PASOP.DLL
A32SBFM.DLL
A32SP1FM.DLL
A32SP2FM.DLL
A32TANDY.DLL
ATI.DLL
CIRRUS.DLL
COMPAQ.DLL
GENOA.DLL
GUSMID32.DLL
M_GOLD.DLL
M_MWSS.DLL
M_PAS.DLL
M_SB16.DLL
M_SB2CD.DLL
M_SBPRO.DLL
NCR.DLL
OAK.DLL
PARADISE.DLL
REALTEK.DLL
S3.DLL
TRIDENT.DLL
TSENG.DLL
W_GOLD.DLL
W_GUS.DLL
W_MWSS.DLL
W_PAS16.DLL
W_PAS.DLL
W_SB16_8.DLL
W_SB16.DLL
W_SB16_M.DLL
W_SB16_S.DLL
W_SB2.DLL
W_SB.DLL
W_SBPRO.DLL
DOS4GW.EXE
LANGUAGE.EXE
LOADPATS.EXE
RELENT.EXE
SETUP.EXE
LBA.GOG
PATCHES.INI
SETUP.LST
SAMPLE.OPL
*.HQR'
CONTENT_GAME_MAIN_FILES_LBA2='
DRIVERS
SETSOUND.BAT
LBA2.CFG
LBA2.DAT
LBA2.DOS
DOS4GW.EXE
LANGUAGE.EXE
LBA2.EXE
SETUP.EXE
LBA2.GOG
INSTALL.INI
LBA2.OGG
*.HQR
*.ILE
*.OBL'
CONTENT_DOC_MAIN_FILES='
MANUAL.PDF
README.TXT'

DOSBOX_DISK_IMAGE_PATH_LBA1='LBA.DAT'
DOSBOX_DISK_IMAGE_PATH_LBA2='LBA2.DAT'

USER_PERSISTENT_DIRECTORIES_LBA2='
SAVE'
USER_PERSISTENT_FILES_LBA1='
*.CFG
*.INI
*.LBA'
USER_PERSISTENT_FILES_LBA2='
*.CFG'

APP_MAIN_EXE_LBA1='RELENT.EXE'
APP_MAIN_EXE_LBA2='LBA2.EXE'
APP_MAIN_ICON_LBA1='APP/GOGGAME-1207658971.ICO'
APP_MAIN_ICON_LBA1_0='GOGGAME-1207658971.ICO'
APP_MAIN_ICON_LBA2='APP/GOGGAME-1207658974.ICO'
APP_MAIN_ICON_LBA2_0='GOGGAME-1207658974.ICO'
## Force application type, as LBA2.EXE is detected as a Windows executable.
APP_MAIN_TYPE_LBA2='dosbox'

APP_SETUP_ID_LBA1="${GAME_ID_LBA1}-setup"
APP_SETUP_ID_LBA2="${GAME_ID_LBA2}-setup"
APP_SETUP_NAME_LBA1="$GAME_NAME_LBA1 - Setup"
APP_SETUP_NAME_LBA2="$GAME_NAME_LBA2 - Setup"
APP_SETUP_EXE='SETUP.EXE'
APP_SETUP_CAT='Settings'
APP_SETUP_ICON_LBA1='APP/GOGGAME-1207658971.ICO'
APP_SETUP_ICON_LBA1_0='GOGGAME-1207658971.ICO'
APP_SETUP_ICON_LBA2='APP/GOGGAME-1207658974.ICO'
APP_SETUP_ICON_LBA2_0='GOGGAME-1207658974.ICO'

## Easier upgrades from pre-20200210.3 packages
PKG_MAIN_PROVIDES_LBA1='
little-big-adventure-1-data'

## convmv is used to convert file paths to uppercase.
REQUIREMENTS_LIST='
convmv'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default
## Convert all file paths to uppercase.
toupper "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"
## Little Big Adventure 2 - Store voices outside of the game image.
case "$(current_archive)" in
	('ARCHIVE_BASE_LBA2_'*)
		sed --in-place 's/\(FlagKeepVoice:\) OFF/\1 ON/' \
			"${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/LBA2.CFG"
	;;
esac

# Include game data.

content_inclusion_icons
content_inclusion_default

# Write launchers.

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
