#ifndef H_CDW_DRIVE
#define H_CDW_DRIVE

#include <stdbool.h>

#include <linux/cdrom.h>
// #include <sys/ioctl.h>

#include "main.h"
#include "cdw_widgets.h"
#include "cdw_config.h"
#include "cdw_ncurses.h"
#include "cdw_disc.h"

/* ID of drives dropdown item that says "use custom drive path";
   the item is always present, and it is the only item in the
   dropdown when cdw_cdio_drives didn't detect any drives;
   it is -1 because list of drives returned by cdw_cdio_drives
   is indexed from 0 - so -1 is a convenient value for "custom" */
#define CDW_DRIVE_ID_CUSTOM -1

void cdw_drive_init(void);
void cdw_drive_clean(void);

const char *cdw_drive_get_drive_fullpath(void);
cdw_id_t   cdw_drive_get_current_drive_id(void);
void       cdw_drive_set_config_fields(cdw_config_t *config, cdw_id_t id);
void       cdw_drive_save_configuration(cdw_id_t id);
int        cdw_drive_status(const char *device_fullpath);

/* redefining CDW_* values here so we don't have to include */
/* <linux/cdrom.h> every time when we want to use cdrom_ctrl cdrom_status() */
#define CDW_CD_NO_INFO CDS_NO_INFO
#define CDW_CD_NO_DISC  CDS_NO_DISC
#define CDW_CD_TRAY_OPEN CDS_TRAY_OPEN
#define CDW_CD_DRIVE_NOT_READY CDS_DRIVE_NOT_READY
#define CDW_CD_DISC_OK CDS_DISC_OK

cdw_rv_t cdw_drive_eject_tray(const char *device_fullpath);
cdw_rv_t cdw_drive_close_tray(const char *device_fullpath);
void cdw_drive_eject_tray_with_ui_update(const char *device_fullpath);
void cdw_drive_close_tray_with_ui_update(const char *device_fullpath);

cdw_disc_t *cdw_drive_get_disc(int rv);

void cdw_drive_toggle_tray_with_ui_update2(void);
void cdw_drive_reload_tray_with_ui_update(const char *device_fullpath, bool final_eject, bool config_eject);

int cdw_drive_update_ui_with_disc(bool rescan_selected_files);

cdw_rv_t cdw_drive_disc_availability(void);

CDW_DROPDOWN *cdw_drive_make_drives_dropdown(WINDOW *window, int row, int col, int width);
char *cdw_drive_get_help_message(void);

#endif /* H_CDW_DRIVE */
