//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcontainerservice

import "time"

// AbsoluteMonthlySchedule - For schedules like: 'recur every month on the 15th' or 'recur every 3 months on the 20th'.
type AbsoluteMonthlySchedule struct {
	// REQUIRED; The date of the month.
	DayOfMonth *int32

	// REQUIRED; Specifies the number of months between each set of occurrences.
	IntervalMonths *int32
}

// AccessProfile - Profile for enabling a user to access a managed cluster.
type AccessProfile struct {
	// Base64-encoded Kubernetes configuration file.
	KubeConfig []byte
}

// AgentPool - Agent Pool.
type AgentPool struct {
	// Properties of an agent pool.
	Properties *ManagedClusterAgentPoolProfileProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

type AgentPoolArtifactStreamingProfile struct {
	// Artifact streaming speeds up the cold-start of containers on a node through on-demand image loading. To use this feature,
	// container images must also enable artifact streaming on ACR. If not specified,
	// the default is false.
	Enabled *bool
}

// AgentPoolAvailableVersions - The list of available versions for an agent pool.
type AgentPoolAvailableVersions struct {
	// REQUIRED; Properties of agent pool available versions.
	Properties *AgentPoolAvailableVersionsProperties

	// READ-ONLY; The ID of the agent pool version list.
	ID *string

	// READ-ONLY; The name of the agent pool version list.
	Name *string

	// READ-ONLY; Type of the agent pool version list.
	Type *string
}

// AgentPoolAvailableVersionsProperties - The list of available agent pool versions.
type AgentPoolAvailableVersionsProperties struct {
	// List of versions available for agent pool.
	AgentPoolVersions []*AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem
}

type AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem struct {
	// Whether this version is the default agent pool version.
	Default *bool

	// Whether Kubernetes version is currently in preview.
	IsPreview *bool

	// The Kubernetes version (major.minor.patch).
	KubernetesVersion *string
}

// AgentPoolDeleteMachinesParameter - Specifies a list of machine names from the agent pool to be deleted.
type AgentPoolDeleteMachinesParameter struct {
	// REQUIRED; The agent pool machine names.
	MachineNames []*string
}

type AgentPoolGPUProfile struct {
	// The default value is true when the vmSize of the agent pool contains a GPU, false otherwise. GPU Driver Installation can
	// only be set true when VM has an associated GPU resource. Setting this field to
	// false prevents automatic GPU driver installation. In that case, in order for the GPU to be usable, the user must perform
	// GPU driver installation themselves.
	InstallGPUDriver *bool
}

// AgentPoolListResult - The response from the List Agent Pools operation.
type AgentPoolListResult struct {
	// The list of agent pools.
	Value []*AgentPool

	// READ-ONLY; The URL to get the next set of agent pool results.
	NextLink *string
}

// AgentPoolNetworkProfile - Network settings of an agent pool.
type AgentPoolNetworkProfile struct {
	// The port ranges that are allowed to access. The specified ranges are allowed to overlap.
	AllowedHostPorts []*PortRange

	// The IDs of the application security groups which agent pool will associate when created.
	ApplicationSecurityGroups []*string

	// IPTags of instance-level public IPs.
	NodePublicIPTags []*IPTag
}

// AgentPoolSecurityProfile - The security settings of an agent pool.
type AgentPoolSecurityProfile struct {
	// SSH access method of an agent pool.
	SSHAccess *AgentPoolSSHAccess
}

// AgentPoolUpgradeProfile - The list of available upgrades for an agent pool.
type AgentPoolUpgradeProfile struct {
	// REQUIRED; The properties of the agent pool upgrade profile.
	Properties *AgentPoolUpgradeProfileProperties

	// READ-ONLY; The ID of the agent pool upgrade profile.
	ID *string

	// READ-ONLY; The name of the agent pool upgrade profile.
	Name *string

	// READ-ONLY; The type of the agent pool upgrade profile.
	Type *string
}

// AgentPoolUpgradeProfileProperties - The list of available upgrade versions.
type AgentPoolUpgradeProfileProperties struct {
	// REQUIRED; The Kubernetes version (major.minor.patch).
	KubernetesVersion *string

	// REQUIRED; The operating system type. The default is Linux.
	OSType *OSType

	// The latest AKS supported node image version.
	LatestNodeImageVersion *string

	// List of orchestrator types and versions available for upgrade.
	Upgrades []*AgentPoolUpgradeProfilePropertiesUpgradesItem
}

type AgentPoolUpgradeProfilePropertiesUpgradesItem struct {
	// Whether the Kubernetes version is currently in preview.
	IsPreview *bool

	// The Kubernetes version (major.minor.patch).
	KubernetesVersion *string
}

// AgentPoolUpgradeSettings - Settings for upgrading an agentpool
type AgentPoolUpgradeSettings struct {
	// The amount of time (in minutes) to wait on eviction of pods and graceful termination per node. This eviction wait time
	// honors waiting on pod disruption budgets. If this time is exceeded, the upgrade
	// fails. If not specified, the default is 30 minutes.
	DrainTimeoutInMinutes *int32

	// This can either be set to an integer (e.g. '5') or a percentage (e.g. '50%'). If a percentage is specified, it is the percentage
	// of the total agent pool size at the time of the upgrade. For
	// percentages, fractional nodes are rounded up. If not specified, the default is 1. For more information, including best
	// practices, see:
	// https://docs.microsoft.com/azure/aks/upgrade-cluster#customize-node-surge-upgrade
	MaxSurge *string

	// The amount of time (in minutes) to wait after draining a node and before reimaging it and moving on to next node. If not
	// specified, the default is 0 minutes.
	NodeSoakDurationInMinutes *int32
}

// AgentPoolWindowsProfile - The Windows agent pool's specific profile.
type AgentPoolWindowsProfile struct {
	// The default value is false. Outbound NAT can only be disabled if the cluster outboundType is NAT Gateway and the Windows
	// agent pool does not have node public IP enabled.
	DisableOutboundNat *bool
}

// AzureKeyVaultKms - Azure Key Vault key management service settings for the security profile.
type AzureKeyVaultKms struct {
	// Whether to enable Azure Key Vault key management service. The default is false.
	Enabled *bool

	// Identifier of Azure Key Vault key. See key identifier format [https://docs.microsoft.com/en-us/azure/key-vault/general/about-keys-secrets-certificates#vault-name-and-object-name]
	// for more details.
	// When Azure Key Vault key management service is enabled, this field is required and must be a valid key identifier. When
	// Azure Key Vault key management service is disabled, leave the field empty.
	KeyID *string

	// Network access of key vault. The possible values are Public and Private. Public means the key vault allows public access
	// from all networks. Private means the key vault disables public access and
	// enables private link. The default value is Public.
	KeyVaultNetworkAccess *KeyVaultNetworkAccessTypes

	// Resource ID of key vault. When keyVaultNetworkAccess is Private, this field is required and must be a valid resource ID.
	// When keyVaultNetworkAccess is Public, leave the field empty.
	KeyVaultResourceID *string
}

// ClusterUpgradeSettings - Settings for upgrading a cluster.
type ClusterUpgradeSettings struct {
	// Settings for overrides.
	OverrideSettings *UpgradeOverrideSettings
}

// CommandResultProperties - The results of a run command
type CommandResultProperties struct {
	// READ-ONLY; The exit code of the command
	ExitCode *int32

	// READ-ONLY; The time when the command finished.
	FinishedAt *time.Time

	// READ-ONLY; The command output.
	Logs *string

	// READ-ONLY; provisioning State
	ProvisioningState *string

	// READ-ONLY; An explanation of why provisioningState is set to failed (if so).
	Reason *string

	// READ-ONLY; The time when the command started.
	StartedAt *time.Time
}

// CompatibleVersions - Version information about a product/service that is compatible with a service mesh revision.
type CompatibleVersions struct {
	// The product/service name.
	Name *string

	// Product/service versions compatible with a service mesh add-on revision.
	Versions []*string
}

// CreationData - Data used when creating a target resource from a source resource.
type CreationData struct {
	// This is the ARM ID of the source object to be used to create the target object.
	SourceResourceID *string
}

// CredentialResult - The credential result response.
type CredentialResult struct {
	// READ-ONLY; The name of the credential.
	Name *string

	// READ-ONLY; Base64-encoded Kubernetes configuration file.
	Value []byte
}

// CredentialResults - The list credential result response.
type CredentialResults struct {
	// READ-ONLY; Base64-encoded Kubernetes configuration file.
	Kubeconfigs []*CredentialResult
}

// DailySchedule - For schedules like: 'recur every day' or 'recur every 3 days'.
type DailySchedule struct {
	// REQUIRED; Specifies the number of days between each set of occurrences.
	IntervalDays *int32
}

// DateSpan - For example, between '2022-12-23' and '2023-01-05'.
type DateSpan struct {
	// REQUIRED; The end date of the date span.
	End *time.Time

	// REQUIRED; The start date of the date span.
	Start *time.Time
}

// DelegatedResource - Delegated resource properties - internal use only.
type DelegatedResource struct {
	// The source resource location - internal use only.
	Location *string

	// The delegation id of the referral delegation (optional) - internal use only.
	ReferralResource *string

	// The ARM resource id of the delegated resource - internal use only.
	ResourceID *string

	// The tenant id of the delegated resource - internal use only.
	TenantID *string
}

// EndpointDependency - A domain name that AKS agent nodes are reaching at.
type EndpointDependency struct {
	// The domain name of the dependency.
	DomainName *string

	// The Ports and Protocols used when connecting to domainName.
	EndpointDetails []*EndpointDetail
}

// EndpointDetail - connect information from the AKS agent nodes to a single endpoint.
type EndpointDetail struct {
	// Description of the detail
	Description *string

	// An IP Address that Domain Name currently resolves to.
	IPAddress *string

	// The port an endpoint is connected to.
	Port *int32

	// The protocol used for connection
	Protocol *string
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDetail

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// ExtendedLocation - The complex type of the extended location.
type ExtendedLocation struct {
	// The name of the extended location.
	Name *string

	// The type of the extended location.
	Type *ExtendedLocationTypes
}

// GuardrailsAvailableVersion - Available Guardrails Version
type GuardrailsAvailableVersion struct {
	// REQUIRED; Whether the version is default or not and support info.
	Properties *GuardrailsAvailableVersionsProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GuardrailsAvailableVersionsList - Hold values properties, which is array of GuardrailsVersions
type GuardrailsAvailableVersionsList struct {
	// Array of AKS supported Guardrails versions.
	Value []*GuardrailsAvailableVersion

	// READ-ONLY; The URL to get the next Guardrails available version.
	NextLink *string
}

// GuardrailsAvailableVersionsProperties - Whether the version is default or not and support info.
type GuardrailsAvailableVersionsProperties struct {
	// READ-ONLY
	IsDefaultVersion *bool

	// READ-ONLY; Whether the version is preview or stable.
	Support *GuardrailsSupport
}

// GuardrailsProfile - The Guardrails profile.
type GuardrailsProfile struct {
	// REQUIRED; The guardrails level to be used. By default, Guardrails is enabled for all namespaces except those that AKS excludes
	// via systemExcludedNamespaces
	Level *Level

	// List of namespaces excluded from guardrails checks
	ExcludedNamespaces []*string

	// The version of constraints to use
	Version *string

	// READ-ONLY; List of namespaces specified by AKS to be excluded from Guardrails
	SystemExcludedNamespaces []*string
}

// IPTag - Contains the IPTag associated with the object.
type IPTag struct {
	// The IP tag type. Example: RoutingPreference.
	IPTagType *string

	// The value of the IP tag associated with the public IP. Example: Internet.
	Tag *string
}

// IstioCertificateAuthority - Istio Service Mesh Certificate Authority (CA) configuration. For now, we only support plugin
// certificates as described here https://aka.ms/asm-plugin-ca
type IstioCertificateAuthority struct {
	// Plugin certificates information for Service Mesh.
	Plugin *IstioPluginCertificateAuthority
}

// IstioComponents - Istio components configuration.
type IstioComponents struct {
	// Istio egress gateways.
	EgressGateways []*IstioEgressGateway

	// Istio ingress gateways.
	IngressGateways []*IstioIngressGateway
}

// IstioEgressGateway - Istio egress gateway configuration.
type IstioEgressGateway struct {
	// REQUIRED; Whether to enable the egress gateway.
	Enabled *bool

	// NodeSelector for scheduling the egress gateway.
	NodeSelector map[string]*string
}

// IstioIngressGateway - Istio ingress gateway configuration. For now, we support up to one external ingress gateway named
// aks-istio-ingressgateway-external and one internal ingress gateway named
// aks-istio-ingressgateway-internal.
type IstioIngressGateway struct {
	// REQUIRED; Whether to enable the ingress gateway.
	Enabled *bool

	// REQUIRED; Mode of an ingress gateway.
	Mode *IstioIngressGatewayMode
}

// IstioPluginCertificateAuthority - Plugin certificates information for Service Mesh.
type IstioPluginCertificateAuthority struct {
	// Certificate chain object name in Azure Key Vault.
	CertChainObjectName *string

	// Intermediate certificate object name in Azure Key Vault.
	CertObjectName *string

	// Intermediate certificate private key object name in Azure Key Vault.
	KeyObjectName *string

	// The resource ID of the Key Vault.
	KeyVaultID *string

	// Root certificate object name in Azure Key Vault.
	RootCertObjectName *string
}

// IstioServiceMesh - Istio service mesh configuration.
type IstioServiceMesh struct {
	// Istio Service Mesh Certificate Authority (CA) configuration. For now, we only support plugin certificates as described
	// here https://aka.ms/asm-plugin-ca
	CertificateAuthority *IstioCertificateAuthority

	// Istio components configuration.
	Components *IstioComponents

	// The list of revisions of the Istio control plane. When an upgrade is not in progress, this holds one value. When canary
	// upgrade is in progress, this can only hold two consecutive values. For more
	// information, see: https://learn.microsoft.com/en-us/azure/aks/istio-upgrade
	Revisions []*string
}

// KubeletConfig - See AKS custom node configuration [https://docs.microsoft.com/azure/aks/custom-node-configuration] for
// more details.
type KubeletConfig struct {
	// Allowed list of unsafe sysctls or unsafe sysctl patterns (ending in *).
	AllowedUnsafeSysctls []*string

	// The default is true.
	CPUCfsQuota *bool

	// The default is '100ms.' Valid values are a sequence of decimal numbers with an optional fraction and a unit suffix. For
	// example: '300ms', '2h45m'. Supported units are 'ns', 'us', 'ms', 's', 'm', and
	// 'h'.
	CPUCfsQuotaPeriod *string

	// The default is 'none'. See Kubernetes CPU management policies [https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/#cpu-management-policies]
	// for more information. Allowed
	// values are 'none' and 'static'.
	CPUManagerPolicy *string

	// The maximum number of container log files that can be present for a container. The number must be ≥ 2.
	ContainerLogMaxFiles *int32

	// The maximum size (e.g. 10Mi) of container log file before it is rotated.
	ContainerLogMaxSizeMB *int32

	// If set to true it will make the Kubelet fail to start if swap is enabled on the node.
	FailSwapOn *bool

	// To disable image garbage collection, set to 100. The default is 85%
	ImageGcHighThreshold *int32

	// This cannot be set higher than imageGcHighThreshold. The default is 80%
	ImageGcLowThreshold *int32

	// The maximum number of processes per pod.
	PodMaxPids *int32

	// For more information see Kubernetes Topology Manager [https://kubernetes.io/docs/tasks/administer-cluster/topology-manager].
	// The default is 'none'. Allowed values are 'none', 'best-effort',
	// 'restricted', and 'single-numa-node'.
	TopologyManagerPolicy *string
}

// KubernetesPatchVersion - Kubernetes patch version profile
type KubernetesPatchVersion struct {
	// Possible upgrade path for given patch version
	Upgrades []*string
}

// KubernetesVersion - Kubernetes version profile for given major.minor release.
type KubernetesVersion struct {
	// Capabilities on this Kubernetes version.
	Capabilities *KubernetesVersionCapabilities

	// Whether this version is in preview mode.
	IsPreview *bool

	// Patch versions of Kubernetes release
	PatchVersions map[string]*KubernetesPatchVersion

	// major.minor version of Kubernetes release
	Version *string
}

// KubernetesVersionCapabilities - Capabilities on this Kubernetes version.
type KubernetesVersionCapabilities struct {
	SupportPlan []*KubernetesSupportPlan
}

// KubernetesVersionListResult - Hold values properties, which is array of KubernetesVersion
type KubernetesVersionListResult struct {
	// Array of AKS supported Kubernetes versions.
	Values []*KubernetesVersion
}

// LinuxOSConfig - See AKS custom node configuration [https://docs.microsoft.com/azure/aks/custom-node-configuration] for
// more details.
type LinuxOSConfig struct {
	// The size in MB of a swap file that will be created on each node.
	SwapFileSizeMB *int32

	// Sysctl settings for Linux agent nodes.
	Sysctls *SysctlConfig

	// Valid values are 'always', 'defer', 'defer+madvise', 'madvise' and 'never'. The default is 'madvise'. For more information
	// see Transparent Hugepages
	// [https://www.kernel.org/doc/html/latest/admin-guide/mm/transhuge.html#admin-guide-transhuge].
	TransparentHugePageDefrag *string

	// Valid values are 'always', 'madvise', and 'never'. The default is 'always'. For more information see Transparent Hugepages
	// [https://www.kernel.org/doc/html/latest/admin-guide/mm/transhuge.html#admin-guide-transhuge].
	TransparentHugePageEnabled *string
}

// LinuxProfile - Profile for Linux VMs in the container service cluster.
type LinuxProfile struct {
	// REQUIRED; The administrator username to use for Linux VMs.
	AdminUsername *string

	// REQUIRED; The SSH configuration for Linux-based VMs running on Azure.
	SSH *SSHConfiguration
}

// Machine - A machine. Contains details about the underlying virtual machine. A machine may be visible here but not in kubectl
// get nodes; if so it may be because the machine has not been registered with the
// Kubernetes API Server yet.
type Machine struct {
	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// READ-ONLY; The properties of the machine
	Properties *MachineProperties

	// READ-ONLY; Resource type
	Type *string
}

// MachineIPAddress - The machine IP address details.
type MachineIPAddress struct {
	// READ-ONLY; To determine if address belongs IPv4 or IPv6 family.
	Family *IPFamily

	// READ-ONLY; IPv4 or IPv6 address of the machine
	IP *string
}

// MachineListResult - The response from the List Machines operation.
type MachineListResult struct {
	// The list of Machines in cluster.
	Value []*Machine

	// READ-ONLY; The URL to get the next set of machine results.
	NextLink *string
}

// MachineNetworkProperties - network properties of the machine
type MachineNetworkProperties struct {
	// READ-ONLY; IPv4, IPv6 addresses of the machine
	IPAddresses []*MachineIPAddress
}

// MachineProperties - The properties of the machine
type MachineProperties struct {
	// READ-ONLY; network properties of the machine
	Network *MachineNetworkProperties

	// READ-ONLY; Arm resource id of the machine. It can be used to GET underlying VM Instance
	ResourceID *string
}

// MaintenanceConfiguration - See planned maintenance [https://docs.microsoft.com/azure/aks/planned-maintenance] for more
// information about planned maintenance.
type MaintenanceConfiguration struct {
	// Properties of a default maintenance configuration.
	Properties *MaintenanceConfigurationProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string

	// READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData

	// READ-ONLY; Resource type
	Type *string
}

// MaintenanceConfigurationListResult - The response from the List maintenance configurations operation.
type MaintenanceConfigurationListResult struct {
	// The list of maintenance configurations.
	Value []*MaintenanceConfiguration

	// READ-ONLY; The URL to get the next set of maintenance configuration results.
	NextLink *string
}

// MaintenanceConfigurationProperties - Properties used to configure planned maintenance for a Managed Cluster.
type MaintenanceConfigurationProperties struct {
	// Maintenance window for the maintenance configuration.
	MaintenanceWindow *MaintenanceWindow

	// Time slots on which upgrade is not allowed.
	NotAllowedTime []*TimeSpan

	// If two array entries specify the same day of the week, the applied configuration is the union of times in both entries.
	TimeInWeek []*TimeInWeek
}

// MaintenanceWindow - Maintenance window used to configure scheduled auto-upgrade for a Managed Cluster.
type MaintenanceWindow struct {
	// REQUIRED; Length of maintenance window range from 4 to 24 hours.
	DurationHours *int32

	// REQUIRED; Recurrence schedule for the maintenance window.
	Schedule *Schedule

	// REQUIRED; The start time of the maintenance window. Accepted values are from '00:00' to '23:59'. 'utcOffset' applies to
	// this field. For example: '02:00' with 'utcOffset: +02:00' means UTC time '00:00'.
	StartTime *string

	// Date ranges on which upgrade is not allowed. 'utcOffset' applies to this field. For example, with 'utcOffset: +02:00' and
	// 'dateSpan' being '2022-12-23' to '2023-01-03', maintenance will be blocked
	// from '2022-12-22 22:00' to '2023-01-03 22:00' in UTC time.
	NotAllowedDates []*DateSpan

	// The date the maintenance window activates. If the current date is before this date, the maintenance window is inactive
	// and will not be used for upgrades. If not specified, the maintenance window will
	// be active right away.
	StartDate *time.Time

	// The UTC offset in format +/-HH:mm. For example, '+05:30' for IST and '-07:00' for PST. If not specified, the default is
	// '+00:00'.
	UTCOffset *string
}

// ManagedCluster - Managed cluster.
type ManagedCluster struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// The extended location of the Virtual Machine.
	ExtendedLocation *ExtendedLocation

	// The identity of the managed cluster, if configured.
	Identity *ManagedClusterIdentity

	// Properties of a managed cluster.
	Properties *ManagedClusterProperties

	// The managed cluster SKU.
	SKU *ManagedClusterSKU

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ManagedClusterAADProfile - For more details see managed AAD on AKS [https://docs.microsoft.com/azure/aks/managed-aad].
type ManagedClusterAADProfile struct {
	// The list of AAD group object IDs that will have admin role of the cluster.
	AdminGroupObjectIDs []*string

	// (DEPRECATED) The client AAD application ID. Learn more at https://aka.ms/aks/aad-legacy.
	ClientAppID *string

	// Whether to enable Azure RBAC for Kubernetes authorization.
	EnableAzureRBAC *bool

	// Whether to enable managed AAD.
	Managed *bool

	// (DEPRECATED) The server AAD application ID. Learn more at https://aka.ms/aks/aad-legacy.
	ServerAppID *string

	// (DEPRECATED) The server AAD application secret. Learn more at https://aka.ms/aks/aad-legacy.
	ServerAppSecret *string

	// The AAD tenant ID to use for authentication. If not specified, will use the tenant of the deployment subscription.
	TenantID *string
}

// ManagedClusterAIToolchainOperatorProfile - When enabling the operator, a set of AKS managed CRDs and controllers will be
// installed in the cluster. The operator automates the deployment of OSS models for inference and/or training purposes. It
// provides a set of preset models and enables distributed inference against them.
type ManagedClusterAIToolchainOperatorProfile struct {
	// Indicates if AI toolchain operator enabled or not.
	Enabled *bool
}

// ManagedClusterAPIServerAccessProfile - Access profile for managed cluster API server.
type ManagedClusterAPIServerAccessProfile struct {
	// IP ranges are specified in CIDR format, e.g. 137.117.106.88/29. This feature is not compatible with clusters that use Public
	// IP Per Node, or clusters that are using a Basic Load Balancer. For more
	// information see API server authorized IP ranges [https://docs.microsoft.com/azure/aks/api-server-authorized-ip-ranges].
	AuthorizedIPRanges []*string

	// Whether to disable run command for the cluster or not.
	DisableRunCommand *bool

	// For more details, see Creating a private AKS cluster [https://docs.microsoft.com/azure/aks/private-clusters].
	EnablePrivateCluster *bool

	// Whether to create additional public FQDN for private cluster or not.
	EnablePrivateClusterPublicFQDN *bool

	// Whether to enable apiserver vnet integration for the cluster or not.
	EnableVnetIntegration *bool

	// The default is System. For more details see configure private DNS zone [https://docs.microsoft.com/azure/aks/private-clusters#configure-private-dns-zone].
	// Allowed values are 'system' and 'none'.
	PrivateDNSZone *string

	// It is required when: 1. creating a new cluster with BYO Vnet; 2. updating an existing cluster to enable apiserver vnet
	// integration.
	SubnetID *string
}

// ManagedClusterAccessProfile - Managed cluster Access Profile.
type ManagedClusterAccessProfile struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// AccessProfile of a managed cluster.
	Properties *AccessProfile

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ManagedClusterAddonProfile - A Kubernetes add-on profile for a managed cluster.
type ManagedClusterAddonProfile struct {
	// REQUIRED; Whether the add-on is enabled or not.
	Enabled *bool

	// Key-value pairs for configuring an add-on.
	Config map[string]*string

	// READ-ONLY; Information of user assigned identity used by this add-on.
	Identity *ManagedClusterAddonProfileIdentity
}

// ManagedClusterAddonProfileIdentity - Information of user assigned identity used by this add-on.
type ManagedClusterAddonProfileIdentity struct {
	// The client ID of the user assigned identity.
	ClientID *string

	// The object ID of the user assigned identity.
	ObjectID *string

	// The resource ID of the user assigned identity.
	ResourceID *string
}

// ManagedClusterAgentPoolProfile - Profile for the container service agent pool.
type ManagedClusterAgentPoolProfile struct {
	// REQUIRED; Windows agent pool names must be 6 characters or less.
	Name *string

	// Configuration for using artifact streaming on AKS.
	ArtifactStreamingProfile *AgentPoolArtifactStreamingProfile

	// The list of Availability zones to use for nodes. This can only be specified if the AgentPoolType property is 'VirtualMachineScaleSets'.
	AvailabilityZones []*string

	// AKS will associate the specified agent pool with the Capacity Reservation Group.
	CapacityReservationGroupID *string

	// Number of agents (VMs) to host docker containers. Allowed values must be in the range of 0 to 1000 (inclusive) for user
	// pools and in the range of 1 to 1000 (inclusive) for system pools. The default
	// value is 1.
	Count *int32

	// CreationData to be used to specify the source Snapshot ID if the node pool will be created/upgraded using a snapshot.
	CreationData *CreationData

	// Whether to enable auto-scaler
	EnableAutoScaling *bool

	// When set to true, AKS adds a label to the node indicating that the feature is enabled and deploys a daemonset along with
	// host services to sync custom certificate authorities from user-provided list of
	// base64 encoded certificates into node trust stores. Defaults to false.
	EnableCustomCATrust *bool

	// This is only supported on certain VM sizes and in certain Azure regions. For more information, see: https://docs.microsoft.com/azure/aks/enable-host-encryption
	EnableEncryptionAtHost *bool

	// See Add a FIPS-enabled node pool [https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview]
	// for more details.
	EnableFIPS *bool

	// Some scenarios may require nodes in a node pool to receive their own dedicated public IP addresses. A common scenario is
	// for gaming workloads, where a console needs to make a direct connection to a
	// cloud virtual machine to minimize hops. For more information see assigning a public IP per node
	// [https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-pools]. The default
	// is false.
	EnableNodePublicIP *bool

	// Whether to enable UltraSSD
	EnableUltraSSD *bool

	// GPUInstanceProfile to be used to specify GPU MIG instance profile for supported GPU VM SKU.
	GpuInstanceProfile *GPUInstanceProfile

	// The GPU settings of an agent pool.
	GpuProfile *AgentPoolGPUProfile

	// This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}.
	// For more information see Azure dedicated hosts
	// [https://docs.microsoft.com/azure/virtual-machines/dedicated-hosts].
	HostGroupID *string

	// The Kubelet configuration on the agent pool nodes.
	KubeletConfig *KubeletConfig

	// Determines the placement of emptyDir volumes, container runtime data root, and Kubelet ephemeral storage.
	KubeletDiskType *KubeletDiskType

	// The OS configuration of Linux agent nodes.
	LinuxOSConfig *LinuxOSConfig

	// The maximum number of nodes for auto-scaling
	MaxCount *int32

	// The maximum number of pods that can run on a node.
	MaxPods *int32

	// A base64-encoded string which will be written to /etc/motd after decoding. This allows customization of the message of
	// the day for Linux nodes. It must not be specified for Windows nodes. It must be a
	// static string (i.e., will be printed raw and not be executed as a script).
	MessageOfTheDay *string

	// The minimum number of nodes for auto-scaling
	MinCount *int32

	// A cluster must have at least one 'System' Agent Pool at all times. For additional information on agent pool restrictions
	// and best practices, see: https://docs.microsoft.com/azure/aks/use-system-pools
	Mode *AgentPoolMode

	// Network-related settings of an agent pool.
	NetworkProfile *AgentPoolNetworkProfile

	// These taints will not be reconciled by AKS and can be removed with a kubectl call. This field can be modified after node
	// pool is created, but nodes will not be recreated with new taints until another
	// operation that requires recreation (e.g. node image upgrade) happens. These taints allow for required configuration to
	// run before the node is ready to accept workloads, for example
	// 'key1=value1:NoSchedule' that then can be removed with kubectl taint nodes node1 key1=value1:NoSchedule-
	NodeInitializationTaints []*string

	// The node labels to be persisted across all nodes in agent pool.
	NodeLabels map[string]*string

	// This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}
	NodePublicIPPrefixID *string

	// The taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
	NodeTaints []*string

	// OS Disk Size in GB to be used to specify the disk size for every machine in the master/agent pool. If you specify 0, it
	// will apply the default osDisk size according to the vmSize specified.
	OSDiskSizeGB *int32

	// The default is 'Ephemeral' if the VM supports it and has a cache disk larger than the requested OSDiskSizeGB. Otherwise,
	// defaults to 'Managed'. May not be changed after creation. For more information
	// see Ephemeral OS [https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os].
	OSDiskType *OSDiskType

	// Specifies the OS SKU used by the agent pool. If not specified, the default is Ubuntu if OSType=Linux or Windows2019 if
	// OSType=Windows. And the default Windows OSSKU will be changed to Windows2022
	// after Windows2019 is deprecated.
	OSSKU *OSSKU

	// The operating system type. The default is Linux.
	OSType *OSType

	// Both patch version and are supported. When is specified, the latest supported patch version is chosen automatically. Updating
	// the agent pool with the same once it has been created will not trigger an
	// upgrade, even if a newer patch version is available. As a best practice, you should upgrade all node pools in an AKS cluster
	// to the same Kubernetes version. The node pool version must have the same
	// major version as the control plane. The node pool minor version must be within two minor versions of the control plane
	// version. The node pool version cannot be greater than the control plane version.
	// For more information see upgrading a node pool [https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool].
	OrchestratorVersion *string

	// If omitted, pod IPs are statically assigned on the node subnet (see vnetSubnetID for more details). This is of the form:
	// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}
	PodSubnetID *string

	// When an Agent Pool is first created it is initially Running. The Agent Pool can be stopped by setting this field to Stopped.
	// A stopped Agent Pool stops all of its VMs and does not accrue billing
	// charges. An Agent Pool can only be stopped if it is Running and provisioning state is Succeeded
	PowerState *PowerState

	// The ID for Proximity Placement Group.
	ProximityPlacementGroupID *string

	// This also effects the cluster autoscaler behavior. If not specified, it defaults to Delete.
	ScaleDownMode *ScaleDownMode

	// This cannot be specified unless the scaleSetPriority is 'Spot'. If not specified, the default is 'Delete'.
	ScaleSetEvictionPolicy *ScaleSetEvictionPolicy

	// The Virtual Machine Scale Set priority. If not specified, the default is 'Regular'.
	ScaleSetPriority *ScaleSetPriority

	// The security settings of an agent pool.
	SecurityProfile *AgentPoolSecurityProfile

	// Possible values are any decimal value greater than zero or -1 which indicates the willingness to pay any on-demand price.
	// For more details on spot pricing, see spot VMs pricing
	// [https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing]
	SpotMaxPrice *float32

	// The tags to be persisted on the agent pool virtual machine scale set.
	Tags map[string]*string

	// The type of Agent Pool.
	Type *AgentPoolType

	// Settings for upgrading the agentpool
	UpgradeSettings *AgentPoolUpgradeSettings

	// VM size availability varies by region. If a node contains insufficient compute resources (memory, cpu, etc) pods might
	// fail to run correctly. For more details on restricted VM sizes, see:
	// https://docs.microsoft.com/azure/aks/quotas-skus-regions
	VMSize *string

	// The status of nodes in a VirtualMachines agent pool.
	VirtualMachineNodesStatus []*VirtualMachineNodes

	// Specifications on VirtualMachines agent pool.
	VirtualMachinesProfile *VirtualMachinesProfile

	// If this is not specified, a VNET and subnet will be generated and used. If no podSubnetID is specified, this applies to
	// nodes and pods, otherwise it applies to just nodes. This is of the form:
	// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}
	VnetSubnetID *string

	// The Windows agent pool's specific profile.
	WindowsProfile *AgentPoolWindowsProfile

	// Determines the type of workload a node can run.
	WorkloadRuntime *WorkloadRuntime

	// READ-ONLY; If orchestratorVersion was a fully specified version , this field will be exactly equal to it. If orchestratorVersion
	// was , this field will contain the full version being used.
	CurrentOrchestratorVersion *string

	// READ-ONLY; The version of node image
	NodeImageVersion *string

	// READ-ONLY; The current deployment or provisioning state.
	ProvisioningState *string
}

// ManagedClusterAgentPoolProfileProperties - Properties for the container service agent pool profile.
type ManagedClusterAgentPoolProfileProperties struct {
	// Configuration for using artifact streaming on AKS.
	ArtifactStreamingProfile *AgentPoolArtifactStreamingProfile

	// The list of Availability zones to use for nodes. This can only be specified if the AgentPoolType property is 'VirtualMachineScaleSets'.
	AvailabilityZones []*string

	// AKS will associate the specified agent pool with the Capacity Reservation Group.
	CapacityReservationGroupID *string

	// Number of agents (VMs) to host docker containers. Allowed values must be in the range of 0 to 1000 (inclusive) for user
	// pools and in the range of 1 to 1000 (inclusive) for system pools. The default
	// value is 1.
	Count *int32

	// CreationData to be used to specify the source Snapshot ID if the node pool will be created/upgraded using a snapshot.
	CreationData *CreationData

	// Whether to enable auto-scaler
	EnableAutoScaling *bool

	// When set to true, AKS adds a label to the node indicating that the feature is enabled and deploys a daemonset along with
	// host services to sync custom certificate authorities from user-provided list of
	// base64 encoded certificates into node trust stores. Defaults to false.
	EnableCustomCATrust *bool

	// This is only supported on certain VM sizes and in certain Azure regions. For more information, see: https://docs.microsoft.com/azure/aks/enable-host-encryption
	EnableEncryptionAtHost *bool

	// See Add a FIPS-enabled node pool [https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview]
	// for more details.
	EnableFIPS *bool

	// Some scenarios may require nodes in a node pool to receive their own dedicated public IP addresses. A common scenario is
	// for gaming workloads, where a console needs to make a direct connection to a
	// cloud virtual machine to minimize hops. For more information see assigning a public IP per node
	// [https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-pools]. The default
	// is false.
	EnableNodePublicIP *bool

	// Whether to enable UltraSSD
	EnableUltraSSD *bool

	// GPUInstanceProfile to be used to specify GPU MIG instance profile for supported GPU VM SKU.
	GpuInstanceProfile *GPUInstanceProfile

	// The GPU settings of an agent pool.
	GpuProfile *AgentPoolGPUProfile

	// This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}.
	// For more information see Azure dedicated hosts
	// [https://docs.microsoft.com/azure/virtual-machines/dedicated-hosts].
	HostGroupID *string

	// The Kubelet configuration on the agent pool nodes.
	KubeletConfig *KubeletConfig

	// Determines the placement of emptyDir volumes, container runtime data root, and Kubelet ephemeral storage.
	KubeletDiskType *KubeletDiskType

	// The OS configuration of Linux agent nodes.
	LinuxOSConfig *LinuxOSConfig

	// The maximum number of nodes for auto-scaling
	MaxCount *int32

	// The maximum number of pods that can run on a node.
	MaxPods *int32

	// A base64-encoded string which will be written to /etc/motd after decoding. This allows customization of the message of
	// the day for Linux nodes. It must not be specified for Windows nodes. It must be a
	// static string (i.e., will be printed raw and not be executed as a script).
	MessageOfTheDay *string

	// The minimum number of nodes for auto-scaling
	MinCount *int32

	// A cluster must have at least one 'System' Agent Pool at all times. For additional information on agent pool restrictions
	// and best practices, see: https://docs.microsoft.com/azure/aks/use-system-pools
	Mode *AgentPoolMode

	// Network-related settings of an agent pool.
	NetworkProfile *AgentPoolNetworkProfile

	// These taints will not be reconciled by AKS and can be removed with a kubectl call. This field can be modified after node
	// pool is created, but nodes will not be recreated with new taints until another
	// operation that requires recreation (e.g. node image upgrade) happens. These taints allow for required configuration to
	// run before the node is ready to accept workloads, for example
	// 'key1=value1:NoSchedule' that then can be removed with kubectl taint nodes node1 key1=value1:NoSchedule-
	NodeInitializationTaints []*string

	// The node labels to be persisted across all nodes in agent pool.
	NodeLabels map[string]*string

	// This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}
	NodePublicIPPrefixID *string

	// The taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
	NodeTaints []*string

	// OS Disk Size in GB to be used to specify the disk size for every machine in the master/agent pool. If you specify 0, it
	// will apply the default osDisk size according to the vmSize specified.
	OSDiskSizeGB *int32

	// The default is 'Ephemeral' if the VM supports it and has a cache disk larger than the requested OSDiskSizeGB. Otherwise,
	// defaults to 'Managed'. May not be changed after creation. For more information
	// see Ephemeral OS [https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os].
	OSDiskType *OSDiskType

	// Specifies the OS SKU used by the agent pool. If not specified, the default is Ubuntu if OSType=Linux or Windows2019 if
	// OSType=Windows. And the default Windows OSSKU will be changed to Windows2022
	// after Windows2019 is deprecated.
	OSSKU *OSSKU

	// The operating system type. The default is Linux.
	OSType *OSType

	// Both patch version and are supported. When is specified, the latest supported patch version is chosen automatically. Updating
	// the agent pool with the same once it has been created will not trigger an
	// upgrade, even if a newer patch version is available. As a best practice, you should upgrade all node pools in an AKS cluster
	// to the same Kubernetes version. The node pool version must have the same
	// major version as the control plane. The node pool minor version must be within two minor versions of the control plane
	// version. The node pool version cannot be greater than the control plane version.
	// For more information see upgrading a node pool [https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool].
	OrchestratorVersion *string

	// If omitted, pod IPs are statically assigned on the node subnet (see vnetSubnetID for more details). This is of the form:
	// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}
	PodSubnetID *string

	// When an Agent Pool is first created it is initially Running. The Agent Pool can be stopped by setting this field to Stopped.
	// A stopped Agent Pool stops all of its VMs and does not accrue billing
	// charges. An Agent Pool can only be stopped if it is Running and provisioning state is Succeeded
	PowerState *PowerState

	// The ID for Proximity Placement Group.
	ProximityPlacementGroupID *string

	// This also effects the cluster autoscaler behavior. If not specified, it defaults to Delete.
	ScaleDownMode *ScaleDownMode

	// This cannot be specified unless the scaleSetPriority is 'Spot'. If not specified, the default is 'Delete'.
	ScaleSetEvictionPolicy *ScaleSetEvictionPolicy

	// The Virtual Machine Scale Set priority. If not specified, the default is 'Regular'.
	ScaleSetPriority *ScaleSetPriority

	// The security settings of an agent pool.
	SecurityProfile *AgentPoolSecurityProfile

	// Possible values are any decimal value greater than zero or -1 which indicates the willingness to pay any on-demand price.
	// For more details on spot pricing, see spot VMs pricing
	// [https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing]
	SpotMaxPrice *float32

	// The tags to be persisted on the agent pool virtual machine scale set.
	Tags map[string]*string

	// The type of Agent Pool.
	Type *AgentPoolType

	// Settings for upgrading the agentpool
	UpgradeSettings *AgentPoolUpgradeSettings

	// VM size availability varies by region. If a node contains insufficient compute resources (memory, cpu, etc) pods might
	// fail to run correctly. For more details on restricted VM sizes, see:
	// https://docs.microsoft.com/azure/aks/quotas-skus-regions
	VMSize *string

	// The status of nodes in a VirtualMachines agent pool.
	VirtualMachineNodesStatus []*VirtualMachineNodes

	// Specifications on VirtualMachines agent pool.
	VirtualMachinesProfile *VirtualMachinesProfile

	// If this is not specified, a VNET and subnet will be generated and used. If no podSubnetID is specified, this applies to
	// nodes and pods, otherwise it applies to just nodes. This is of the form:
	// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}
	VnetSubnetID *string

	// The Windows agent pool's specific profile.
	WindowsProfile *AgentPoolWindowsProfile

	// Determines the type of workload a node can run.
	WorkloadRuntime *WorkloadRuntime

	// READ-ONLY; If orchestratorVersion was a fully specified version , this field will be exactly equal to it. If orchestratorVersion
	// was , this field will contain the full version being used.
	CurrentOrchestratorVersion *string

	// READ-ONLY; The version of node image
	NodeImageVersion *string

	// READ-ONLY; The current deployment or provisioning state.
	ProvisioningState *string
}

// ManagedClusterAutoUpgradeProfile - Auto upgrade profile for a managed cluster.
type ManagedClusterAutoUpgradeProfile struct {
	// The default is Unmanaged, but may change to either NodeImage or SecurityPatch at GA.
	NodeOSUpgradeChannel *NodeOSUpgradeChannel

	// For more information see setting the AKS cluster auto-upgrade channel [https://docs.microsoft.com/azure/aks/upgrade-cluster#set-auto-upgrade-channel].
	UpgradeChannel *UpgradeChannel
}

// ManagedClusterAzureMonitorProfile - Prometheus addon profile for the container service cluster
type ManagedClusterAzureMonitorProfile struct {
	// Logs profile for the Azure Monitor Infrastructure and Application Logs. Collect out-of-the-box Kubernetes infrastructure
	// & application logs to send to Azure Monitor. See
	// aka.ms/AzureMonitorContainerInsights for an overview.
	Logs *ManagedClusterAzureMonitorProfileLogs

	// Metrics profile for the prometheus service addon
	Metrics *ManagedClusterAzureMonitorProfileMetrics
}

// ManagedClusterAzureMonitorProfileAppMonitoring - Application Monitoring Profile for Kubernetes Application Container. Collects
// application logs, metrics and traces through auto-instrumentation of the application using Azure Monitor OpenTelemetry
// based SDKs. See aka.ms/AzureMonitorApplicationMonitoring for an overview.
type ManagedClusterAzureMonitorProfileAppMonitoring struct {
	// Indicates if Application Monitoring enabled or not.
	Enabled *bool
}

// ManagedClusterAzureMonitorProfileAppMonitoringOpenTelemetryMetrics - Application Monitoring Open Telemetry Metrics Profile
// for Kubernetes Application Container Metrics. Collects OpenTelemetry metrics through auto-instrumentation of the application
// using Azure Monitor
// OpenTelemetry based SDKs. See aka.ms/AzureMonitorApplicationMonitoring for an overview.
type ManagedClusterAzureMonitorProfileAppMonitoringOpenTelemetryMetrics struct {
	// Indicates if Application Monitoring Open Telemetry Metrics is enabled or not.
	Enabled *bool
}

// ManagedClusterAzureMonitorProfileContainerInsights - Azure Monitor Container Insights Profile for Kubernetes Events, Inventory
// and Container stdout & stderr logs etc. See aka.ms/AzureMonitorContainerInsights for an overview.
type ManagedClusterAzureMonitorProfileContainerInsights struct {
	// Indicates if Azure Monitor Container Insights Logs Addon is enabled or not.
	Enabled *bool

	// Fully Qualified ARM Resource Id of Azure Log Analytics Workspace for storing Azure Monitor Container Insights Logs.
	LogAnalyticsWorkspaceResourceID *string

	// Windows Host Logs Profile for Kubernetes Windows Nodes Log Collection. Collects ETW, Event Logs and Text logs etc. See
	// aka.ms/AzureMonitorContainerInsights for an overview.
	WindowsHostLogs *ManagedClusterAzureMonitorProfileWindowsHostLogs
}

// ManagedClusterAzureMonitorProfileKubeStateMetrics - Kube State Metrics for prometheus addon profile for the container service
// cluster
type ManagedClusterAzureMonitorProfileKubeStateMetrics struct {
	// Comma-separated list of additional Kubernetes label keys that will be used in the resource's labels metric.
	MetricAnnotationsAllowList *string

	// Comma-separated list of Kubernetes annotations keys that will be used in the resource's labels metric.
	MetricLabelsAllowlist *string
}

// ManagedClusterAzureMonitorProfileLogs - Logs profile for the Azure Monitor Infrastructure and Application Logs. Collect
// out-of-the-box Kubernetes infrastructure & application logs to send to Azure Monitor. See
// aka.ms/AzureMonitorContainerInsights for an overview.
type ManagedClusterAzureMonitorProfileLogs struct {
	// Application Monitoring Profile for Kubernetes Application Container. Collects application logs, metrics and traces through
	// auto-instrumentation of the application using Azure Monitor OpenTelemetry
	// based SDKs. See aka.ms/AzureMonitorApplicationMonitoring for an overview.
	AppMonitoring *ManagedClusterAzureMonitorProfileAppMonitoring

	// Azure Monitor Container Insights Profile for Kubernetes Events, Inventory and Container stdout & stderr logs etc. See aka.ms/AzureMonitorContainerInsights
	// for an overview.
	ContainerInsights *ManagedClusterAzureMonitorProfileContainerInsights
}

// ManagedClusterAzureMonitorProfileMetrics - Metrics profile for the prometheus service addon
type ManagedClusterAzureMonitorProfileMetrics struct {
	// REQUIRED; Whether to enable the Prometheus collector
	Enabled *bool

	// Application Monitoring Open Telemetry Metrics Profile for Kubernetes Application Container Metrics. Collects OpenTelemetry
	// metrics through auto-instrumentation of the application using Azure Monitor
	// OpenTelemetry based SDKs. See aka.ms/AzureMonitorApplicationMonitoring for an overview.
	AppMonitoringOpenTelemetryMetrics *ManagedClusterAzureMonitorProfileAppMonitoringOpenTelemetryMetrics

	// Kube State Metrics for prometheus addon profile for the container service cluster
	KubeStateMetrics *ManagedClusterAzureMonitorProfileKubeStateMetrics
}

// ManagedClusterAzureMonitorProfileWindowsHostLogs - Windows Host Logs Profile for Kubernetes Windows Nodes Log Collection.
// Collects ETW, Event Logs and Text logs etc. See aka.ms/AzureMonitorContainerInsights for an overview.
type ManagedClusterAzureMonitorProfileWindowsHostLogs struct {
	// Indicates if Windows Host Log Collection is enabled or not for Azure Monitor Container Insights Logs Addon.
	Enabled *bool
}

// ManagedClusterCostAnalysis - The cost analysis configuration for the cluster
type ManagedClusterCostAnalysis struct {
	// The Managed Cluster sku.tier must be set to 'Standard' to enable this feature. Enabling this will add Kubernetes Namespace
	// and Deployment details to the Cost Analysis views in the Azure portal. If not
	// specified, the default is false. For more information see aka.ms/aks/docs/cost-analysis.
	Enabled *bool
}

// ManagedClusterHTTPProxyConfig - Cluster HTTP proxy configuration.
type ManagedClusterHTTPProxyConfig struct {
	// The HTTP proxy server endpoint to use.
	HTTPProxy *string

	// The HTTPS proxy server endpoint to use.
	HTTPSProxy *string

	// The endpoints that should not go through proxy.
	NoProxy []*string

	// Alternative CA cert to use for connecting to proxy servers.
	TrustedCa *string

	// READ-ONLY; A read-only list of all endpoints for which traffic should not be sent to the proxy. This list is a superset
	// of noProxy and values injected by AKS.
	EffectiveNoProxy []*string
}

// ManagedClusterIdentity - Identity for the managed cluster.
type ManagedClusterIdentity struct {
	// The delegated identity resources assigned to this managed cluster. This can only be set by another Azure Resource Provider,
	// and managed cluster only accept one delegated identity resource. Internal
	// use only.
	DelegatedResources map[string]*DelegatedResource

	// For more information see use managed identities in AKS [https://docs.microsoft.com/azure/aks/use-managed-identity].
	Type *ResourceIdentityType

	// The keys must be ARM resource IDs in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*ManagedServiceIdentityUserAssignedIdentitiesValue

	// READ-ONLY; The principal id of the system assigned identity which is used by master components.
	PrincipalID *string

	// READ-ONLY; The tenant id of the system assigned identity which is used by master components.
	TenantID *string
}

// ManagedClusterIngressProfile - Ingress profile for the container service cluster.
type ManagedClusterIngressProfile struct {
	// Web App Routing settings for the ingress profile.
	WebAppRouting *ManagedClusterIngressProfileWebAppRouting
}

// ManagedClusterIngressProfileWebAppRouting - Web App Routing settings for the ingress profile.
type ManagedClusterIngressProfileWebAppRouting struct {
	// Resource IDs of the DNS zones to be associated with the Web App Routing add-on. Used only when Web App Routing is enabled.
	// Public and private DNS zones can be in different resource groups, but all
	// public DNS zones must be in the same resource group and all private DNS zones must be in the same resource group.
	DNSZoneResourceIDs []*string

	// Whether to enable Web App Routing.
	Enabled *bool

	// READ-ONLY; Managed identity of the Web Application Routing add-on. This is the identity that should be granted permissions,
	// for example, to manage the associated Azure DNS resource and get certificates from
	// Azure Key Vault. See this overview of the add-on [https://learn.microsoft.com/en-us/azure/aks/web-app-routing?tabs=with-osm]
	// for more instructions.
	Identity *UserAssignedIdentity
}

// ManagedClusterListResult - The response from the List Managed Clusters operation.
type ManagedClusterListResult struct {
	// The list of managed clusters.
	Value []*ManagedCluster

	// READ-ONLY; The URL to get the next set of managed cluster results.
	NextLink *string
}

// ManagedClusterLoadBalancerProfile - Profile of the managed cluster load balancer.
type ManagedClusterLoadBalancerProfile struct {
	// The desired number of allocated SNAT ports per VM. Allowed values are in the range of 0 to 64000 (inclusive). The default
	// value is 0 which results in Azure dynamically allocating ports.
	AllocatedOutboundPorts *int32

	// The type of the managed inbound Load Balancer BackendPool.
	BackendPoolType *BackendPoolType

	// The effective outbound IP resources of the cluster load balancer.
	EffectiveOutboundIPs []*ResourceReference

	// Enable multiple standard load balancers per AKS cluster or not.
	EnableMultipleStandardLoadBalancers *bool

	// Desired outbound flow idle timeout in minutes. Allowed values are in the range of 4 to 120 (inclusive). The default value
	// is 30 minutes.
	IdleTimeoutInMinutes *int32

	// Desired managed outbound IPs for the cluster load balancer.
	ManagedOutboundIPs *ManagedClusterLoadBalancerProfileManagedOutboundIPs

	// Desired outbound IP Prefix resources for the cluster load balancer.
	OutboundIPPrefixes *ManagedClusterLoadBalancerProfileOutboundIPPrefixes

	// Desired outbound IP resources for the cluster load balancer.
	OutboundIPs *ManagedClusterLoadBalancerProfileOutboundIPs
}

// ManagedClusterLoadBalancerProfileManagedOutboundIPs - Desired managed outbound IPs for the cluster load balancer.
type ManagedClusterLoadBalancerProfileManagedOutboundIPs struct {
	// The desired number of IPv4 outbound IPs created/managed by Azure for the cluster load balancer. Allowed values must be
	// in the range of 1 to 100 (inclusive). The default value is 1.
	Count *int32

	// The desired number of IPv6 outbound IPs created/managed by Azure for the cluster load balancer. Allowed values must be
	// in the range of 1 to 100 (inclusive). The default value is 0 for single-stack and
	// 1 for dual-stack.
	CountIPv6 *int32
}

// ManagedClusterLoadBalancerProfileOutboundIPPrefixes - Desired outbound IP Prefix resources for the cluster load balancer.
type ManagedClusterLoadBalancerProfileOutboundIPPrefixes struct {
	// A list of public IP prefix resources.
	PublicIPPrefixes []*ResourceReference
}

// ManagedClusterLoadBalancerProfileOutboundIPs - Desired outbound IP resources for the cluster load balancer.
type ManagedClusterLoadBalancerProfileOutboundIPs struct {
	// A list of public IP resources.
	PublicIPs []*ResourceReference
}

// ManagedClusterManagedOutboundIPProfile - Profile of the managed outbound IP resources of the managed cluster.
type ManagedClusterManagedOutboundIPProfile struct {
	// The desired number of outbound IPs created/managed by Azure. Allowed values must be in the range of 1 to 16 (inclusive).
	// The default value is 1.
	Count *int32
}

// ManagedClusterMetricsProfile - The metrics profile for the ManagedCluster.
type ManagedClusterMetricsProfile struct {
	// The cost analysis configuration for the cluster
	CostAnalysis *ManagedClusterCostAnalysis
}

// ManagedClusterNATGatewayProfile - Profile of the managed cluster NAT gateway.
type ManagedClusterNATGatewayProfile struct {
	// The effective outbound IP resources of the cluster NAT gateway.
	EffectiveOutboundIPs []*ResourceReference

	// Desired outbound flow idle timeout in minutes. Allowed values are in the range of 4 to 120 (inclusive). The default value
	// is 4 minutes.
	IdleTimeoutInMinutes *int32

	// Profile of the managed outbound IP resources of the cluster NAT gateway.
	ManagedOutboundIPProfile *ManagedClusterManagedOutboundIPProfile
}

type ManagedClusterNodeProvisioningProfile struct {
	// Once the mode it set to Auto, it cannot be changed back to Manual.
	Mode *NodeProvisioningMode
}

// ManagedClusterNodeResourceGroupProfile - Node resource group lockdown profile for a managed cluster.
type ManagedClusterNodeResourceGroupProfile struct {
	// The restriction level applied to the cluster's node resource group
	RestrictionLevel *RestrictionLevel
}

// ManagedClusterOIDCIssuerProfile - The OIDC issuer profile of the Managed Cluster.
type ManagedClusterOIDCIssuerProfile struct {
	// Whether the OIDC issuer is enabled.
	Enabled *bool

	// READ-ONLY; The OIDC issuer url of the Managed Cluster.
	IssuerURL *string
}

// ManagedClusterPodIdentity - Details about the pod identity assigned to the Managed Cluster.
type ManagedClusterPodIdentity struct {
	// REQUIRED; The user assigned identity details.
	Identity *UserAssignedIdentity

	// REQUIRED; The name of the pod identity.
	Name *string

	// REQUIRED; The namespace of the pod identity.
	Namespace *string

	// The binding selector to use for the AzureIdentityBinding resource.
	BindingSelector *string

	// READ-ONLY
	ProvisioningInfo *ManagedClusterPodIdentityProvisioningInfo

	// READ-ONLY; The current provisioning state of the pod identity.
	ProvisioningState *ManagedClusterPodIdentityProvisioningState
}

// ManagedClusterPodIdentityException - See disable AAD Pod Identity for a specific Pod/Application [https://azure.github.io/aad-pod-identity/docs/configure/application_exception/]
// for more details.
type ManagedClusterPodIdentityException struct {
	// REQUIRED; The name of the pod identity exception.
	Name *string

	// REQUIRED; The namespace of the pod identity exception.
	Namespace *string

	// REQUIRED; The pod labels to match.
	PodLabels map[string]*string
}

// ManagedClusterPodIdentityProfile - See use AAD pod identity [https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity]
// for more details on pod identity integration.
type ManagedClusterPodIdentityProfile struct {
	// Running in Kubenet is disabled by default due to the security related nature of AAD Pod Identity and the risks of IP spoofing.
	// See using Kubenet network plugin with AAD Pod Identity
	// [https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity#using-kubenet-network-plugin-with-azure-active-directory-pod-managed-identities]
	// for more information.
	AllowNetworkPluginKubenet *bool

	// Whether the pod identity addon is enabled.
	Enabled *bool

	// The pod identities to use in the cluster.
	UserAssignedIdentities []*ManagedClusterPodIdentity

	// The pod identity exceptions to allow.
	UserAssignedIdentityExceptions []*ManagedClusterPodIdentityException
}

// ManagedClusterPodIdentityProvisioningError - An error response from the pod identity provisioning.
type ManagedClusterPodIdentityProvisioningError struct {
	// Details about the error.
	Error *ManagedClusterPodIdentityProvisioningErrorBody
}

// ManagedClusterPodIdentityProvisioningErrorBody - An error response from the pod identity provisioning.
type ManagedClusterPodIdentityProvisioningErrorBody struct {
	// An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string

	// A list of additional details about the error.
	Details []*ManagedClusterPodIdentityProvisioningErrorBody

	// A message describing the error, intended to be suitable for display in a user interface.
	Message *string

	// The target of the particular error. For example, the name of the property in error.
	Target *string
}

type ManagedClusterPodIdentityProvisioningInfo struct {
	// Pod identity assignment error (if any).
	Error *ManagedClusterPodIdentityProvisioningError
}

// ManagedClusterPoolUpgradeProfile - The list of available upgrade versions.
type ManagedClusterPoolUpgradeProfile struct {
	// REQUIRED; The Kubernetes version (major.minor.patch).
	KubernetesVersion *string

	// REQUIRED; The operating system type. The default is Linux.
	OSType *OSType

	// The Agent Pool name.
	Name *string

	// List of orchestrator types and versions available for upgrade.
	Upgrades []*ManagedClusterPoolUpgradeProfileUpgradesItem
}

type ManagedClusterPoolUpgradeProfileUpgradesItem struct {
	// Whether the Kubernetes version is currently in preview.
	IsPreview *bool

	// The Kubernetes version (major.minor.patch).
	KubernetesVersion *string
}

// ManagedClusterProperties - Properties of the managed cluster.
type ManagedClusterProperties struct {
	// The Azure Active Directory configuration.
	AADProfile *ManagedClusterAADProfile

	// The access profile for managed cluster API server.
	APIServerAccessProfile *ManagedClusterAPIServerAccessProfile

	// The profile of managed cluster add-on.
	AddonProfiles map[string]*ManagedClusterAddonProfile

	// The agent pool properties.
	AgentPoolProfiles []*ManagedClusterAgentPoolProfile

	// AI toolchain operator settings that apply to the whole cluster.
	AiToolchainOperatorProfile *ManagedClusterAIToolchainOperatorProfile

	// Parameters to be applied to the cluster-autoscaler when enabled
	AutoScalerProfile *ManagedClusterPropertiesAutoScalerProfile

	// The auto upgrade configuration.
	AutoUpgradeProfile *ManagedClusterAutoUpgradeProfile

	// Prometheus addon profile for the container service cluster
	AzureMonitorProfile *ManagedClusterAzureMonitorProfile

	// CreationData to be used to specify the source Snapshot ID if the cluster will be created/upgraded using a snapshot.
	CreationData *CreationData

	// This cannot be updated once the Managed Cluster has been created.
	DNSPrefix *string

	// If set to true, getting static credentials will be disabled for this cluster. This must only be used on Managed Clusters
	// that are AAD enabled. For more details see disable local accounts
	// [https://docs.microsoft.com/azure/aks/managed-aad#disable-local-accounts-preview].
	DisableLocalAccounts *bool

	// This is of the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{encryptionSetName}'
	DiskEncryptionSetID *string

	// The default value is false. It can be enabled/disabled on creation and updating of the managed cluster. See https://aka.ms/NamespaceARMResource
	// [https://aka.ms/NamespaceARMResource] for more details
	// on Namespace as a ARM Resource.
	EnableNamespaceResources *bool

	// (DEPRECATED) Whether to enable Kubernetes pod security policy (preview). PodSecurityPolicy was deprecated in Kubernetes
	// v1.21, and removed from Kubernetes in v1.25. Learn more at
	// https://aka.ms/k8s/psp and https://aka.ms/aks/psp.
	EnablePodSecurityPolicy *bool

	// Whether to enable Kubernetes Role-Based Access Control.
	EnableRBAC *bool

	// This cannot be updated once the Managed Cluster has been created.
	FqdnSubdomain *string

	// The guardrails profile holds all the guardrails information for a given cluster
	GuardrailsProfile *GuardrailsProfile

	// Configurations for provisioning the cluster with HTTP proxy servers.
	HTTPProxyConfig *ManagedClusterHTTPProxyConfig

	// Identities associated with the cluster.
	IdentityProfile map[string]*UserAssignedIdentity

	// Ingress profile for the managed cluster.
	IngressProfile *ManagedClusterIngressProfile

	// When you upgrade a supported AKS cluster, Kubernetes minor versions cannot be skipped. All upgrades must be performed sequentially
	// by major version number. For example, upgrades between 1.14.x ->
	// 1.15.x or 1.15.x -> 1.16.x are allowed, however 1.14.x -> 1.16.x is not allowed. See upgrading an AKS cluster [https://docs.microsoft.com/azure/aks/upgrade-cluster]
	// for more details.
	KubernetesVersion *string

	// The profile for Linux VMs in the Managed Cluster.
	LinuxProfile *LinuxProfile

	// Optional cluster metrics configuration.
	MetricsProfile *ManagedClusterMetricsProfile

	// The network configuration profile.
	NetworkProfile *NetworkProfile

	// Node provisioning settings that apply to the whole cluster.
	NodeProvisioningProfile *ManagedClusterNodeProvisioningProfile

	// The name of the resource group containing agent pool nodes.
	NodeResourceGroup *string

	// The node resource group configuration profile.
	NodeResourceGroupProfile *ManagedClusterNodeResourceGroupProfile

	// The OIDC issuer profile of the Managed Cluster.
	OidcIssuerProfile *ManagedClusterOIDCIssuerProfile

	// See use AAD pod identity [https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity] for more details on AAD pod identity
	// integration.
	PodIdentityProfile *ManagedClusterPodIdentityProfile

	// Private link resources associated with the cluster.
	PrivateLinkResources []*PrivateLinkResource

	// Allow or deny public network access for AKS
	PublicNetworkAccess *PublicNetworkAccess

	// Security profile for the managed cluster.
	SecurityProfile *ManagedClusterSecurityProfile

	// Service mesh profile for a managed cluster.
	ServiceMeshProfile *ServiceMeshProfile

	// Information about a service principal identity for the cluster to use for manipulating Azure APIs.
	ServicePrincipalProfile *ManagedClusterServicePrincipalProfile

	// Storage profile for the managed cluster.
	StorageProfile *ManagedClusterStorageProfile

	// The support plan for the Managed Cluster. If unspecified, the default is 'KubernetesOfficial'.
	SupportPlan *KubernetesSupportPlan

	// Settings for upgrading a cluster.
	UpgradeSettings *ClusterUpgradeSettings

	// The profile for Windows VMs in the Managed Cluster.
	WindowsProfile *ManagedClusterWindowsProfile

	// Workload Auto-scaler profile for the managed cluster.
	WorkloadAutoScalerProfile *ManagedClusterWorkloadAutoScalerProfile

	// READ-ONLY; The Azure Portal requires certain Cross-Origin Resource Sharing (CORS) headers to be sent in some responses,
	// which Kubernetes APIServer doesn't handle by default. This special FQDN supports CORS,
	// allowing the Azure Portal to function properly.
	AzurePortalFQDN *string

	// READ-ONLY; The version of Kubernetes the Managed Cluster is running.
	CurrentKubernetesVersion *string

	// READ-ONLY; The FQDN of the master pool.
	Fqdn *string

	// READ-ONLY; The max number of agent pools for the managed cluster.
	MaxAgentPools *int32

	// READ-ONLY; The Power State of the cluster.
	PowerState *PowerState

	// READ-ONLY; The FQDN of private cluster.
	PrivateFQDN *string

	// READ-ONLY; The current provisioning state.
	ProvisioningState *string

	// READ-ONLY; The resourceUID uniquely identifies ManagedClusters that reuse ARM ResourceIds (i.e: create, delete, create
	// sequence)
	ResourceUID *string
}

// ManagedClusterPropertiesAutoScalerProfile - Parameters to be applied to the cluster-autoscaler when enabled
type ManagedClusterPropertiesAutoScalerProfile struct {
	// Valid values are 'true' and 'false'
	BalanceSimilarNodeGroups *string

	// If set to true, all daemonset pods on empty nodes will be evicted before deletion of the node. If the daemonset pod cannot
	// be evicted another node will be chosen for scaling. If set to false, the node
	// will be deleted without ensuring that daemonset pods are deleted or evicted.
	DaemonsetEvictionForEmptyNodes *bool

	// If set to true, all daemonset pods on occupied nodes will be evicted before deletion of the node. If the daemonset pod
	// cannot be evicted another node will be chosen for scaling. If set to false, the
	// node will be deleted without ensuring that daemonset pods are deleted or evicted.
	DaemonsetEvictionForOccupiedNodes *bool

	// Available values are: 'least-waste', 'most-pods', 'priority', 'random'.
	Expander *Expander

	// If set to true, the resources used by daemonset will be taken into account when making scaling down decisions.
	IgnoreDaemonsetsUtilization *bool

	// The default is 10.
	MaxEmptyBulkDelete *string

	// The default is 600.
	MaxGracefulTerminationSec *string

	// The default is '15m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
	MaxNodeProvisionTime *string

	// The default is 45. The maximum is 100 and the minimum is 0.
	MaxTotalUnreadyPercentage *string

	// For scenarios like burst/batch scale where you don't want CA to act before the kubernetes scheduler could schedule all
	// the pods, you can tell CA to ignore unscheduled pods before they're a certain
	// age. The default is '0s'. Values must be an integer followed by a unit ('s' for seconds, 'm' for minutes, 'h' for hours,
	// etc).
	NewPodScaleUpDelay *string

	// This must be an integer. The default is 3.
	OkTotalUnreadyCount *string

	// The default is '10m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
	ScaleDownDelayAfterAdd *string

	// The default is the scan-interval. Values must be an integer followed by an 'm'. No unit of time other than minutes (m)
	// is supported.
	ScaleDownDelayAfterDelete *string

	// The default is '3m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
	ScaleDownDelayAfterFailure *string

	// The default is '10m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
	ScaleDownUnneededTime *string

	// The default is '20m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
	ScaleDownUnreadyTime *string

	// The default is '0.5'.
	ScaleDownUtilizationThreshold *string

	// The default is '10'. Values must be an integer number of seconds.
	ScanInterval *string

	// The default is true.
	SkipNodesWithLocalStorage *string

	// The default is true.
	SkipNodesWithSystemPods *string
}

// ManagedClusterPropertiesForSnapshot - managed cluster properties for snapshot, these properties are read only.
type ManagedClusterPropertiesForSnapshot struct {
	// Whether the cluster has enabled Kubernetes Role-Based Access Control or not.
	EnableRbac *bool

	// The current kubernetes version.
	KubernetesVersion *string

	// The current managed cluster sku.
	SKU *ManagedClusterSKU

	// READ-ONLY; The current network profile.
	NetworkProfile *NetworkProfileForSnapshot
}

// ManagedClusterSKU - The SKU of a Managed Cluster.
type ManagedClusterSKU struct {
	// The name of a managed cluster SKU.
	Name *ManagedClusterSKUName

	// If not specified, the default is 'Free'. See AKS Pricing Tier [https://learn.microsoft.com/azure/aks/free-standard-pricing-tiers]
	// for more details.
	Tier *ManagedClusterSKUTier
}

// ManagedClusterSecurityProfile - Security profile for the container service cluster.
type ManagedClusterSecurityProfile struct {
	// Azure Key Vault key management service [https://kubernetes.io/docs/tasks/administer-cluster/kms-provider/] settings for
	// the security profile.
	AzureKeyVaultKms *AzureKeyVaultKms

	// A list of up to 10 base64 encoded CAs that will be added to the trust store on nodes with the Custom CA Trust feature enabled.
	// For more information see Custom CA Trust Certificates
	// [https://learn.microsoft.com/en-us/azure/aks/custom-certificate-authority]
	CustomCATrustCertificates [][]byte

	// Microsoft Defender settings for the security profile.
	Defender *ManagedClusterSecurityProfileDefender

	// Image Cleaner settings for the security profile.
	ImageCleaner *ManagedClusterSecurityProfileImageCleaner

	// Image integrity is a feature that works with Azure Policy to verify image integrity by signature. This will not have any
	// effect unless Azure Policy is applied to enforce image signatures. See
	// https://aka.ms/aks/image-integrity for how to use this feature via policy.
	ImageIntegrity *ManagedClusterSecurityProfileImageIntegrity

	// Node Restriction [https://kubernetes.io/docs/reference/access-authn-authz/admission-controllers/#noderestriction] settings
	// for the security profile.
	NodeRestriction *ManagedClusterSecurityProfileNodeRestriction

	// Workload identity settings for the security profile. Workload identity enables Kubernetes applications to access Azure
	// cloud resources securely with Azure AD. See https://aka.ms/aks/wi for more
	// details.
	WorkloadIdentity *ManagedClusterSecurityProfileWorkloadIdentity
}

// ManagedClusterSecurityProfileDefender - Microsoft Defender settings for the security profile.
type ManagedClusterSecurityProfileDefender struct {
	// Resource ID of the Log Analytics workspace to be associated with Microsoft Defender. When Microsoft Defender is enabled,
	// this field is required and must be a valid workspace resource ID. When
	// Microsoft Defender is disabled, leave the field empty.
	LogAnalyticsWorkspaceResourceID *string

	// Microsoft Defender threat detection for Cloud settings for the security profile.
	SecurityMonitoring *ManagedClusterSecurityProfileDefenderSecurityMonitoring
}

// ManagedClusterSecurityProfileDefenderSecurityMonitoring - Microsoft Defender settings for the security profile threat detection.
type ManagedClusterSecurityProfileDefenderSecurityMonitoring struct {
	// Whether to enable Defender threat detection
	Enabled *bool
}

// ManagedClusterSecurityProfileImageCleaner - Image Cleaner removes unused images from nodes, freeing up disk space and helping
// to reduce attack surface area. Here are settings for the security profile.
type ManagedClusterSecurityProfileImageCleaner struct {
	// Whether to enable Image Cleaner on AKS cluster.
	Enabled *bool

	// Image Cleaner scanning interval in hours.
	IntervalHours *int32
}

// ManagedClusterSecurityProfileImageIntegrity - Image integrity related settings for the security profile.
type ManagedClusterSecurityProfileImageIntegrity struct {
	// Whether to enable image integrity. The default value is false.
	Enabled *bool
}

// ManagedClusterSecurityProfileNodeRestriction - Node Restriction settings for the security profile.
type ManagedClusterSecurityProfileNodeRestriction struct {
	// Whether to enable Node Restriction
	Enabled *bool
}

// ManagedClusterSecurityProfileWorkloadIdentity - Workload identity settings for the security profile.
type ManagedClusterSecurityProfileWorkloadIdentity struct {
	// Whether to enable workload identity.
	Enabled *bool
}

// ManagedClusterServicePrincipalProfile - Information about a service principal identity for the cluster to use for manipulating
// Azure APIs.
type ManagedClusterServicePrincipalProfile struct {
	// REQUIRED; The ID for the service principal.
	ClientID *string

	// The secret password associated with the service principal in plain text.
	Secret *string
}

// ManagedClusterSnapshot - A managed cluster snapshot resource.
type ManagedClusterSnapshot struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Properties of a managed cluster snapshot.
	Properties *ManagedClusterSnapshotProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ManagedClusterSnapshotListResult - The response from the List Managed Cluster Snapshots operation.
type ManagedClusterSnapshotListResult struct {
	// The list of managed cluster snapshots.
	Value []*ManagedClusterSnapshot

	// READ-ONLY; The URL to get the next set of managed cluster snapshot results.
	NextLink *string
}

// ManagedClusterSnapshotProperties - Properties for a managed cluster snapshot.
type ManagedClusterSnapshotProperties struct {
	// CreationData to be used to specify the source resource ID to create this snapshot.
	CreationData *CreationData

	// The type of a snapshot. The default is NodePool.
	SnapshotType *SnapshotType

	// READ-ONLY; What the properties will be showed when getting managed cluster snapshot. Those properties are read-only.
	ManagedClusterPropertiesReadOnly *ManagedClusterPropertiesForSnapshot
}

// ManagedClusterStorageProfile - Storage profile for the container service cluster.
type ManagedClusterStorageProfile struct {
	// AzureBlob CSI Driver settings for the storage profile.
	BlobCSIDriver *ManagedClusterStorageProfileBlobCSIDriver

	// AzureDisk CSI Driver settings for the storage profile.
	DiskCSIDriver *ManagedClusterStorageProfileDiskCSIDriver

	// AzureFile CSI Driver settings for the storage profile.
	FileCSIDriver *ManagedClusterStorageProfileFileCSIDriver

	// Snapshot Controller settings for the storage profile.
	SnapshotController *ManagedClusterStorageProfileSnapshotController
}

// ManagedClusterStorageProfileBlobCSIDriver - AzureBlob CSI Driver settings for the storage profile.
type ManagedClusterStorageProfileBlobCSIDriver struct {
	// Whether to enable AzureBlob CSI Driver. The default value is false.
	Enabled *bool
}

// ManagedClusterStorageProfileDiskCSIDriver - AzureDisk CSI Driver settings for the storage profile.
type ManagedClusterStorageProfileDiskCSIDriver struct {
	// Whether to enable AzureDisk CSI Driver. The default value is true.
	Enabled *bool

	// The version of AzureDisk CSI Driver. The default value is v1.
	Version *string
}

// ManagedClusterStorageProfileFileCSIDriver - AzureFile CSI Driver settings for the storage profile.
type ManagedClusterStorageProfileFileCSIDriver struct {
	// Whether to enable AzureFile CSI Driver. The default value is true.
	Enabled *bool
}

// ManagedClusterStorageProfileSnapshotController - Snapshot Controller settings for the storage profile.
type ManagedClusterStorageProfileSnapshotController struct {
	// Whether to enable Snapshot Controller. The default value is true.
	Enabled *bool
}

// ManagedClusterUpgradeProfile - The list of available upgrades for compute pools.
type ManagedClusterUpgradeProfile struct {
	// REQUIRED; The properties of the upgrade profile.
	Properties *ManagedClusterUpgradeProfileProperties

	// READ-ONLY; The ID of the upgrade profile.
	ID *string

	// READ-ONLY; The name of the upgrade profile.
	Name *string

	// READ-ONLY; The type of the upgrade profile.
	Type *string
}

// ManagedClusterUpgradeProfileProperties - Control plane and agent pool upgrade profiles.
type ManagedClusterUpgradeProfileProperties struct {
	// REQUIRED; The list of available upgrade versions for agent pools.
	AgentPoolProfiles []*ManagedClusterPoolUpgradeProfile

	// REQUIRED; The list of available upgrade versions for the control plane.
	ControlPlaneProfile *ManagedClusterPoolUpgradeProfile
}

// ManagedClusterWindowsProfile - Profile for Windows VMs in the managed cluster.
type ManagedClusterWindowsProfile struct {
	// REQUIRED; Specifies the name of the administrator account.
	// Restriction: Cannot end in "."
	// Disallowed values: "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123",
	// "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest",
	// "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5".
	// Minimum-length: 1 character
	// Max-length: 20 characters
	AdminUsername *string

	// Specifies the password of the administrator account.
	// Minimum-length: 8 characters
	// Max-length: 123 characters
	// Complexity requirements: 3 out of 4 conditions below need to be fulfilled
	// Has lower characters
	// Has upper characters
	// Has a digit
	// Has a special character (Regex match [\W_])
	// Disallowed values: "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1",
	// "Password22", "iloveyou!"
	AdminPassword *string

	// For more details on CSI proxy, see the CSI proxy GitHub repo [https://github.com/kubernetes-csi/csi-proxy].
	EnableCSIProxy *bool

	// The Windows gMSA Profile in the Managed Cluster.
	GmsaProfile *WindowsGmsaProfile

	// The license type to use for Windows VMs. See Azure Hybrid User Benefits [https://azure.microsoft.com/pricing/hybrid-benefit/faq/]
	// for more details.
	LicenseType *LicenseType
}

// ManagedClusterWorkloadAutoScalerProfile - Workload Auto-scaler profile for the managed cluster.
type ManagedClusterWorkloadAutoScalerProfile struct {
	// KEDA (Kubernetes Event-driven Autoscaling) settings for the workload auto-scaler profile.
	Keda                  *ManagedClusterWorkloadAutoScalerProfileKeda
	VerticalPodAutoscaler *ManagedClusterWorkloadAutoScalerProfileVerticalPodAutoscaler
}

// ManagedClusterWorkloadAutoScalerProfileKeda - KEDA (Kubernetes Event-driven Autoscaling) settings for the workload auto-scaler
// profile.
type ManagedClusterWorkloadAutoScalerProfileKeda struct {
	// REQUIRED; Whether to enable KEDA.
	Enabled *bool
}

type ManagedClusterWorkloadAutoScalerProfileVerticalPodAutoscaler struct {
	// REQUIRED; Whether to enable VPA add-on in cluster. Default value is false.
	Enabled *bool

	// Whether VPA add-on is enabled and configured to scale AKS-managed add-ons.
	AddonAutoscaling *AddonAutoscaling
}

type ManagedServiceIdentityUserAssignedIdentitiesValue struct {
	// READ-ONLY; The client id of user assigned identity.
	ClientID *string

	// READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string
}

// ManualScaleProfile - Specifications on number of machines.
type ManualScaleProfile struct {
	// Number of nodes.
	Count *int32

	// The list of allowed vm sizes. AKS will use the first available one when scaling. If a VM size is unavailable (e.g. due
	// to quota or regional capacity reasons), AKS will use the next size.
	Sizes []*string
}

// MeshRevision - Holds information on upgrades and compatibility for given major.minor mesh release.
type MeshRevision struct {
	// List of items this revision of service mesh is compatible with, and their associated versions.
	CompatibleWith []*CompatibleVersions

	// The revision of the mesh release.
	Revision *string

	// List of revisions available for upgrade of a specific mesh revision
	Upgrades []*string
}

// MeshRevisionProfile - Mesh revision profile for a mesh.
type MeshRevisionProfile struct {
	// Mesh revision profile properties for a mesh
	Properties *MeshRevisionProfileProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// MeshRevisionProfileList - Holds an array of MeshRevisionsProfiles
type MeshRevisionProfileList struct {
	// Array of service mesh add-on revision profiles for all supported mesh modes.
	Value []*MeshRevisionProfile

	// READ-ONLY; The URL to get the next set of mesh revision profile.
	NextLink *string
}

// MeshRevisionProfileProperties - Mesh revision profile properties for a mesh
type MeshRevisionProfileProperties struct {
	MeshRevisions []*MeshRevision
}

// MeshUpgradeProfile - Upgrade profile for given mesh.
type MeshUpgradeProfile struct {
	// Mesh upgrade profile properties for a major.minor release.
	Properties *MeshUpgradeProfileProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// MeshUpgradeProfileList - Holds an array of MeshUpgradeProfiles
type MeshUpgradeProfileList struct {
	// Array of supported service mesh add-on upgrade profiles.
	Value []*MeshUpgradeProfile

	// READ-ONLY; The URL to get the next set of mesh upgrade profile.
	NextLink *string
}

// MeshUpgradeProfileProperties - Mesh upgrade profile properties for a major.minor release.
type MeshUpgradeProfileProperties struct {
	// List of items this revision of service mesh is compatible with, and their associated versions.
	CompatibleWith []*CompatibleVersions

	// The revision of the mesh release.
	Revision *string

	// List of revisions available for upgrade of a specific mesh revision
	Upgrades []*string
}

// NetworkMonitoring - This addon can be used to configure network monitoring and generate network monitoring data in Prometheus
// format
type NetworkMonitoring struct {
	// Enable or disable the network monitoring plugin on the cluster
	Enabled *bool
}

// NetworkProfile - Profile of network configuration.
type NetworkProfile struct {
	// An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified
	// in serviceCidr.
	DNSServiceIP *string

	// IP families are used to determine single-stack or dual-stack clusters. For single-stack, the expected value is IPv4. For
	// dual-stack, the expected values are IPv4 and IPv6.
	IPFamilies []*IPFamily

	// Holds configuration customizations for kube-proxy. Any values not defined will use the kube-proxy defaulting behavior.
	// See https://v
	// .docs.kubernetes.io/docs/reference/command-line-tools-reference/kube-proxy/ where is represented by a - string. Kubernetes
	// version 1.23 would be '1-23'.
	KubeProxyConfig *NetworkProfileKubeProxyConfig

	// Profile of the cluster load balancer.
	LoadBalancerProfile *ManagedClusterLoadBalancerProfile

	// The default is 'standard'. See Azure Load Balancer SKUs [https://docs.microsoft.com/azure/load-balancer/skus] for more
	// information about the differences between load balancer SKUs.
	LoadBalancerSKU *LoadBalancerSKU

	// This addon can be used to configure network monitoring and generate network monitoring data in Prometheus format
	Monitoring *NetworkMonitoring

	// Profile of the cluster NAT gateway.
	NatGatewayProfile *ManagedClusterNATGatewayProfile

	// Network dataplane used in the Kubernetes cluster.
	NetworkDataplane *NetworkDataplane

	// This cannot be specified if networkPlugin is anything other than 'azure'.
	NetworkMode *NetworkMode

	// Network plugin used for building the Kubernetes network.
	NetworkPlugin *NetworkPlugin

	// Network plugin mode used for building the Kubernetes network.
	NetworkPluginMode *NetworkPluginMode

	// Network policy used for building the Kubernetes network.
	NetworkPolicy *NetworkPolicy

	// This can only be set at cluster creation time and cannot be changed later. For more information see egress outbound type
	// [https://docs.microsoft.com/azure/aks/egress-outboundtype].
	OutboundType *OutboundType

	// A CIDR notation IP range from which to assign pod IPs when kubenet is used.
	PodCidr *string

	// One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack
	// networking.
	PodCidrs []*string

	// A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
	ServiceCidr *string

	// One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack
	// networking. They must not overlap with any Subnet IP ranges.
	ServiceCidrs []*string
}

// NetworkProfileForSnapshot - network profile for managed cluster snapshot, these properties are read only.
type NetworkProfileForSnapshot struct {
	// loadBalancerSku for managed cluster snapshot.
	LoadBalancerSKU *LoadBalancerSKU

	// networkMode for managed cluster snapshot.
	NetworkMode *NetworkMode

	// networkPlugin for managed cluster snapshot.
	NetworkPlugin *NetworkPlugin

	// NetworkPluginMode for managed cluster snapshot.
	NetworkPluginMode *NetworkPluginMode

	// networkPolicy for managed cluster snapshot.
	NetworkPolicy *NetworkPolicy
}

// NetworkProfileKubeProxyConfig - Holds configuration customizations for kube-proxy. Any values not defined will use the
// kube-proxy defaulting behavior. See https://v
// .docs.kubernetes.io/docs/reference/command-line-tools-reference/kube-proxy/ where is represented by a - string. Kubernetes
// version 1.23 would be '1-23'.
type NetworkProfileKubeProxyConfig struct {
	// Whether to enable on kube-proxy on the cluster (if no 'kubeProxyConfig' exists, kube-proxy is enabled in AKS by default
	// without these customizations).
	Enabled *bool

	// Holds configuration customizations for IPVS. May only be specified if 'mode' is set to 'IPVS'.
	IpvsConfig *NetworkProfileKubeProxyConfigIpvsConfig

	// Specify which proxy mode to use ('IPTABLES' or 'IPVS')
	Mode *Mode
}

// NetworkProfileKubeProxyConfigIpvsConfig - Holds configuration customizations for IPVS. May only be specified if 'mode'
// is set to 'IPVS'.
type NetworkProfileKubeProxyConfigIpvsConfig struct {
	// IPVS scheduler, for more information please see http://www.linuxvirtualserver.org/docs/scheduling.html.
	Scheduler *IpvsScheduler

	// The timeout value used for IPVS TCP sessions after receiving a FIN in seconds. Must be a positive integer value.
	TCPFinTimeoutSeconds *int32

	// The timeout value used for idle IPVS TCP sessions in seconds. Must be a positive integer value.
	TCPTimeoutSeconds *int32

	// The timeout value used for IPVS UDP packets in seconds. Must be a positive integer value.
	UDPTimeoutSeconds *int32
}

// OSOptionProfile - The OS option profile.
type OSOptionProfile struct {
	// REQUIRED; The list of OS options.
	Properties *OSOptionPropertyList

	// READ-ONLY; The ID of the OS option resource.
	ID *string

	// READ-ONLY; The name of the OS option resource.
	Name *string

	// READ-ONLY; The type of the OS option resource.
	Type *string
}

// OSOptionProperty - OS option property.
type OSOptionProperty struct {
	// REQUIRED; Whether the image is FIPS-enabled.
	EnableFipsImage *bool

	// REQUIRED; The OS type.
	OSType *string
}

// OSOptionPropertyList - The list of OS option properties.
type OSOptionPropertyList struct {
	// REQUIRED; The list of OS options.
	OSOptionPropertyList []*OSOptionProperty
}

// OperationListResult - The List Operation response.
type OperationListResult struct {
	// READ-ONLY; The list of operations
	Value []*OperationValue
}

// OperationStatusResult - The current status of an async operation.
type OperationStatusResult struct {
	// REQUIRED; Operation status.
	Status *string

	// The end time of the operation.
	EndTime *time.Time

	// If present, details of the operation error.
	Error *ErrorDetail

	// Fully qualified ID for the async operation.
	ID *string

	// Name of the async operation.
	Name *string

	// The operations list.
	Operations []*OperationStatusResult

	// Percent of the operation that is complete.
	PercentComplete *float32

	// The start time of the operation.
	StartTime *time.Time

	// READ-ONLY; Fully qualified ID of the resource against which the original async operation was started.
	ResourceID *string
}

// OperationStatusResultList - The operations list. It contains an URL link to get the next set of results.
type OperationStatusResultList struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string

	// READ-ONLY; List of operations
	Value []*OperationStatusResult
}

// OperationValue - Describes the properties of a Operation value.
type OperationValue struct {
	// Describes the properties of a Operation Value Display.
	Display *OperationValueDisplay

	// READ-ONLY; The name of the operation.
	Name *string

	// READ-ONLY; The origin of the operation.
	Origin *string
}

// OperationValueDisplay - Describes the properties of a Operation Value Display.
type OperationValueDisplay struct {
	// READ-ONLY; The description of the operation.
	Description *string

	// READ-ONLY; The display name of the operation.
	Operation *string

	// READ-ONLY; The resource provider for the operation.
	Provider *string

	// READ-ONLY; The display name of the resource the operation applies to.
	Resource *string
}

// OutboundEnvironmentEndpoint - Egress endpoints which AKS agent nodes connect to for common purpose.
type OutboundEnvironmentEndpoint struct {
	// The category of endpoints accessed by the AKS agent node, e.g. azure-resource-management, apiserver, etc.
	Category *string

	// The endpoints that AKS agent nodes connect to
	Endpoints []*EndpointDependency
}

// OutboundEnvironmentEndpointCollection - Collection of OutboundEnvironmentEndpoint
type OutboundEnvironmentEndpointCollection struct {
	// REQUIRED; Collection of resources.
	Value []*OutboundEnvironmentEndpoint

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// PortRange - The port range.
type PortRange struct {
	// The maximum port that is included in the range. It should be ranged from 1 to 65535, and be greater than or equal to portStart.
	PortEnd *int32

	// The minimum port that is included in the range. It should be ranged from 1 to 65535, and be less than or equal to portEnd.
	PortStart *int32

	// The network protocol of the port.
	Protocol *Protocol
}

// PowerState - Describes the Power State of the cluster
type PowerState struct {
	// Tells whether the cluster is Running or Stopped
	Code *Code
}

// PrivateEndpoint - Private endpoint which a connection belongs to.
type PrivateEndpoint struct {
	// The resource ID of the private endpoint
	ID *string
}

// PrivateEndpointConnection - A private endpoint connection
type PrivateEndpointConnection struct {
	// The properties of a private endpoint connection.
	Properties *PrivateEndpointConnectionProperties

	// READ-ONLY; The ID of the private endpoint connection.
	ID *string

	// READ-ONLY; The name of the private endpoint connection.
	Name *string

	// READ-ONLY; The resource type.
	Type *string
}

// PrivateEndpointConnectionListResult - A list of private endpoint connections
type PrivateEndpointConnectionListResult struct {
	// The collection value.
	Value []*PrivateEndpointConnection
}

// PrivateEndpointConnectionProperties - Properties of a private endpoint connection.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState

	// The resource of private endpoint.
	PrivateEndpoint *PrivateEndpoint

	// READ-ONLY; The current provisioning state.
	ProvisioningState *PrivateEndpointConnectionProvisioningState
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// The group ID of the resource.
	GroupID *string

	// The ID of the private link resource.
	ID *string

	// The name of the private link resource.
	Name *string

	// The RequiredMembers of the resource
	RequiredMembers []*string

	// The resource type.
	Type *string

	// READ-ONLY; The private link service ID of the resource, this field is exposed only to NRP internally.
	PrivateLinkServiceID *string
}

// PrivateLinkResourcesListResult - A list of private link resources
type PrivateLinkResourcesListResult struct {
	// The collection value.
	Value []*PrivateLinkResource
}

// PrivateLinkServiceConnectionState - The state of a private link service connection.
type PrivateLinkServiceConnectionState struct {
	// The private link service connection description.
	Description *string

	// The private link service connection status.
	Status *ConnectionStatus
}

// RelativeMonthlySchedule - For schedules like: 'recur every month on the first Monday' or 'recur every 3 months on last
// Friday'.
type RelativeMonthlySchedule struct {
	// REQUIRED; Specifies on which day of the week the maintenance occurs.
	DayOfWeek *WeekDay

	// REQUIRED; Specifies the number of months between each set of occurrences.
	IntervalMonths *int32

	// REQUIRED; Specifies on which instance of the allowed days specified in daysOfWeek the maintenance occurs.
	WeekIndex *Type
}

// ResourceReference - A reference to an Azure resource.
type ResourceReference struct {
	// The fully qualified Azure resource id.
	ID *string
}

// RunCommandRequest - A run command request
type RunCommandRequest struct {
	// REQUIRED; The command to run.
	Command *string

	// AuthToken issued for AKS AAD Server App.
	ClusterToken *string

	// A base64 encoded zip file containing the files required by the command.
	Context *string
}

// RunCommandResult - run command result.
type RunCommandResult struct {
	// Properties of command result.
	Properties *CommandResultProperties

	// READ-ONLY; The command id.
	ID *string
}

// SSHConfiguration - SSH configuration for Linux-based VMs running on Azure.
type SSHConfiguration struct {
	// REQUIRED; The list of SSH public keys used to authenticate with Linux-based VMs. A maximum of 1 key may be specified.
	PublicKeys []*SSHPublicKey
}

// SSHPublicKey - Contains information about SSH certificate public key data.
type SSHPublicKey struct {
	// REQUIRED; Certificate public key used to authenticate with VMs through SSH. The certificate must be in PEM format with
	// or without headers.
	KeyData *string
}

// ScaleProfile - Specifications on how to scale a VirtualMachines agent pool.
type ScaleProfile struct {
	// Specifications on how to scale the VirtualMachines agent pool to a fixed size.
	Manual []*ManualScaleProfile
}

// Schedule - One and only one of the schedule types should be specified. Choose either 'daily', 'weekly', 'absoluteMonthly'
// or 'relativeMonthly' for your maintenance schedule.
type Schedule struct {
	// For schedules like: 'recur every month on the 15th' or 'recur every 3 months on the 20th'.
	AbsoluteMonthly *AbsoluteMonthlySchedule

	// For schedules like: 'recur every day' or 'recur every 3 days'.
	Daily *DailySchedule

	// For schedules like: 'recur every month on the first Monday' or 'recur every 3 months on last Friday'.
	RelativeMonthly *RelativeMonthlySchedule

	// For schedules like: 'recur every Monday' or 'recur every 3 weeks on Wednesday'.
	Weekly *WeeklySchedule
}

// ServiceMeshProfile - Service mesh profile for a managed cluster.
type ServiceMeshProfile struct {
	// REQUIRED; Mode of the service mesh.
	Mode *ServiceMeshMode

	// Istio service mesh configuration.
	Istio *IstioServiceMesh
}

// Snapshot - A node pool snapshot resource.
type Snapshot struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Properties of a snapshot.
	Properties *SnapshotProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SnapshotListResult - The response from the List Snapshots operation.
type SnapshotListResult struct {
	// The list of snapshots.
	Value []*Snapshot

	// READ-ONLY; The URL to get the next set of snapshot results.
	NextLink *string
}

// SnapshotProperties - Properties used to configure a node pool snapshot.
type SnapshotProperties struct {
	// CreationData to be used to specify the source agent pool resource ID to create this snapshot.
	CreationData *CreationData

	// The type of a snapshot. The default is NodePool.
	SnapshotType *SnapshotType

	// READ-ONLY; Whether to use a FIPS-enabled OS.
	EnableFIPS *bool

	// READ-ONLY; The version of Kubernetes.
	KubernetesVersion *string

	// READ-ONLY; The version of node image.
	NodeImageVersion *string

	// READ-ONLY; Specifies the OS SKU used by the agent pool. If not specified, the default is Ubuntu if OSType=Linux or Windows2019
	// if OSType=Windows. And the default Windows OSSKU will be changed to Windows2022
	// after Windows2019 is deprecated.
	OSSKU *OSSKU

	// READ-ONLY; The operating system type. The default is Linux.
	OSType *OSType

	// READ-ONLY; The size of the VM.
	VMSize *string
}

// SysctlConfig - Sysctl settings for Linux agent nodes.
type SysctlConfig struct {
	// Sysctl setting fs.aio-max-nr.
	FsAioMaxNr *int32

	// Sysctl setting fs.file-max.
	FsFileMax *int32

	// Sysctl setting fs.inotify.maxuserwatches.
	FsInotifyMaxUserWatches *int32

	// Sysctl setting fs.nr_open.
	FsNrOpen *int32

	// Sysctl setting kernel.threads-max.
	KernelThreadsMax *int32

	// Sysctl setting net.core.netdevmaxbacklog.
	NetCoreNetdevMaxBacklog *int32

	// Sysctl setting net.core.optmem_max.
	NetCoreOptmemMax *int32

	// Sysctl setting net.core.rmem_default.
	NetCoreRmemDefault *int32

	// Sysctl setting net.core.rmem_max.
	NetCoreRmemMax *int32

	// Sysctl setting net.core.somaxconn.
	NetCoreSomaxconn *int32

	// Sysctl setting net.core.wmem_default.
	NetCoreWmemDefault *int32

	// Sysctl setting net.core.wmem_max.
	NetCoreWmemMax *int32

	// Sysctl setting net.ipv4.iplocalport_range.
	NetIPv4IPLocalPortRange *string

	// Sysctl setting net.ipv4.neigh.default.gc_thresh1.
	NetIPv4NeighDefaultGcThresh1 *int32

	// Sysctl setting net.ipv4.neigh.default.gc_thresh2.
	NetIPv4NeighDefaultGcThresh2 *int32

	// Sysctl setting net.ipv4.neigh.default.gc_thresh3.
	NetIPv4NeighDefaultGcThresh3 *int32

	// Sysctl setting net.ipv4.tcpfintimeout.
	NetIPv4TCPFinTimeout *int32

	// Sysctl setting net.ipv4.tcpkeepaliveprobes.
	NetIPv4TCPKeepaliveProbes *int32

	// Sysctl setting net.ipv4.tcpkeepalivetime.
	NetIPv4TCPKeepaliveTime *int32

	// Sysctl setting net.ipv4.tcpmaxsyn_backlog.
	NetIPv4TCPMaxSynBacklog *int32

	// Sysctl setting net.ipv4.tcpmaxtw_buckets.
	NetIPv4TCPMaxTwBuckets *int32

	// Sysctl setting net.ipv4.tcptwreuse.
	NetIPv4TCPTwReuse *bool

	// Sysctl setting net.ipv4.tcpkeepaliveintvl.
	NetIPv4TcpkeepaliveIntvl *int32

	// Sysctl setting net.netfilter.nfconntrackbuckets.
	NetNetfilterNfConntrackBuckets *int32

	// Sysctl setting net.netfilter.nfconntrackmax.
	NetNetfilterNfConntrackMax *int32

	// Sysctl setting vm.maxmapcount.
	VMMaxMapCount *int32

	// Sysctl setting vm.swappiness.
	VMSwappiness *int32

	// Sysctl setting vm.vfscachepressure.
	VMVfsCachePressure *int32
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TagsObject - Tags object for patch operations.
type TagsObject struct {
	// Resource tags.
	Tags map[string]*string
}

// TimeInWeek - Time in a week.
type TimeInWeek struct {
	// The day of the week.
	Day *WeekDay

	// Each integer hour represents a time range beginning at 0m after the hour ending at the next hour (non-inclusive). 0 corresponds
	// to 00:00 UTC, 23 corresponds to 23:00 UTC. Specifying [0, 1] means the
	// 00:00 - 02:00 UTC time range.
	HourSlots []*int32
}

// TimeSpan - For example, between 2021-05-25T13:00:00Z and 2021-05-25T14:00:00Z.
type TimeSpan struct {
	// The end of a time span
	End *time.Time

	// The start of a time span
	Start *time.Time
}

// TrustedAccessRole - Trusted access role definition.
type TrustedAccessRole struct {
	// READ-ONLY; Name of role, name is unique under a source resource type
	Name *string

	// READ-ONLY; List of rules for the role. This maps to 'rules' property of Kubernetes Cluster Role [https://kubernetes.io/docs/reference/kubernetes-api/authorization-resources/cluster-role-v1/#ClusterRole].
	Rules []*TrustedAccessRoleRule

	// READ-ONLY; Resource type of Azure resource
	SourceResourceType *string
}

// TrustedAccessRoleBinding - Defines binding between a resource and role
type TrustedAccessRoleBinding struct {
	// REQUIRED; Properties for trusted access role binding
	Properties *TrustedAccessRoleBindingProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// TrustedAccessRoleBindingListResult - List of trusted access role bindings
type TrustedAccessRoleBindingListResult struct {
	// Role binding list
	Value []*TrustedAccessRoleBinding

	// READ-ONLY; Link to next page of resources.
	NextLink *string
}

// TrustedAccessRoleBindingProperties - Properties for trusted access role binding
type TrustedAccessRoleBindingProperties struct {
	// REQUIRED; A list of roles to bind, each item is a resource type qualified role name. For example: 'Microsoft.MachineLearningServices/workspaces/reader'.
	Roles []*string

	// REQUIRED; The ARM resource ID of source resource that trusted access is configured for.
	SourceResourceID *string

	// READ-ONLY; The current provisioning state of trusted access role binding.
	ProvisioningState *TrustedAccessRoleBindingProvisioningState
}

// TrustedAccessRoleListResult - List of trusted access roles
type TrustedAccessRoleListResult struct {
	// READ-ONLY; Link to next page of resources.
	NextLink *string

	// READ-ONLY; Role list
	Value []*TrustedAccessRole
}

// TrustedAccessRoleRule - Rule for trusted access role
type TrustedAccessRoleRule struct {
	// READ-ONLY; List of allowed apiGroups
	APIGroups []*string

	// READ-ONLY; List of allowed nonResourceURLs
	NonResourceURLs []*string

	// READ-ONLY; List of allowed names
	ResourceNames []*string

	// READ-ONLY; List of allowed resources
	Resources []*string

	// READ-ONLY; List of allowed verbs
	Verbs []*string
}

// UpgradeOverrideSettings - Settings for overrides when upgrading a cluster.
type UpgradeOverrideSettings struct {
	// Whether to force upgrade the cluster. Note that this option instructs upgrade operation to bypass upgrade protections such
	// as checking for deprecated API usage. Enable this option only with caution.
	ForceUpgrade *bool

	// Until when the overrides are effective. Note that this only matches the start time of an upgrade, and the effectiveness
	// won't change once an upgrade starts even if the until expires as upgrade
	// proceeds. This field is not set by default. It must be set for the overrides to take effect.
	Until *time.Time
}

// UserAssignedIdentity - Details about a user assigned identity.
type UserAssignedIdentity struct {
	// The client ID of the user assigned identity.
	ClientID *string

	// The object ID of the user assigned identity.
	ObjectID *string

	// The resource ID of the user assigned identity.
	ResourceID *string
}

// VirtualMachineNodes - Current status on a group of nodes of the same vm size.
type VirtualMachineNodes struct {
	// Number of nodes.
	Count *int32

	// The VM size of the agents used to host this group of nodes.
	Size *string
}

// VirtualMachinesProfile - Specifications on VirtualMachines agent pool.
type VirtualMachinesProfile struct {
	// Specifications on how to scale a VirtualMachines agent pool.
	Scale *ScaleProfile
}

// WeeklySchedule - For schedules like: 'recur every Monday' or 'recur every 3 weeks on Wednesday'.
type WeeklySchedule struct {
	// REQUIRED; Specifies on which day of the week the maintenance occurs.
	DayOfWeek *WeekDay

	// REQUIRED; Specifies the number of weeks between each set of occurrences.
	IntervalWeeks *int32
}

// WindowsGmsaProfile - Windows gMSA Profile in the managed cluster.
type WindowsGmsaProfile struct {
	// Specifies the DNS server for Windows gMSA.
	// Set it to empty if you have configured the DNS server in the vnet which is used to create the managed cluster.
	DNSServer *string

	// Specifies whether to enable Windows gMSA in the managed cluster.
	Enabled *bool

	// Specifies the root domain name for Windows gMSA.
	// Set it to empty if you have configured the DNS server in the vnet which is used to create the managed cluster.
	RootDomainName *string
}
