//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/dnsresolver/armdnsresolver"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// DNSForwardingRulesetsServer is a fake server for instances of the armdnsresolver.DNSForwardingRulesetsClient type.
type DNSForwardingRulesetsServer struct {
	// BeginCreateOrUpdate is the fake for method DNSForwardingRulesetsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated, http.StatusAccepted
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, dnsForwardingRulesetName string, parameters armdnsresolver.DNSForwardingRuleset, options *armdnsresolver.DNSForwardingRulesetsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armdnsresolver.DNSForwardingRulesetsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method DNSForwardingRulesetsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, dnsForwardingRulesetName string, options *armdnsresolver.DNSForwardingRulesetsClientBeginDeleteOptions) (resp azfake.PollerResponder[armdnsresolver.DNSForwardingRulesetsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method DNSForwardingRulesetsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, dnsForwardingRulesetName string, options *armdnsresolver.DNSForwardingRulesetsClientGetOptions) (resp azfake.Responder[armdnsresolver.DNSForwardingRulesetsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method DNSForwardingRulesetsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armdnsresolver.DNSForwardingRulesetsClientListOptions) (resp azfake.PagerResponder[armdnsresolver.DNSForwardingRulesetsClientListResponse])

	// NewListByResourceGroupPager is the fake for method DNSForwardingRulesetsClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armdnsresolver.DNSForwardingRulesetsClientListByResourceGroupOptions) (resp azfake.PagerResponder[armdnsresolver.DNSForwardingRulesetsClientListByResourceGroupResponse])

	// NewListByVirtualNetworkPager is the fake for method DNSForwardingRulesetsClient.NewListByVirtualNetworkPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByVirtualNetworkPager func(resourceGroupName string, virtualNetworkName string, options *armdnsresolver.DNSForwardingRulesetsClientListByVirtualNetworkOptions) (resp azfake.PagerResponder[armdnsresolver.DNSForwardingRulesetsClientListByVirtualNetworkResponse])

	// BeginUpdate is the fake for method DNSForwardingRulesetsClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, dnsForwardingRulesetName string, parameters armdnsresolver.DNSForwardingRulesetPatch, options *armdnsresolver.DNSForwardingRulesetsClientBeginUpdateOptions) (resp azfake.PollerResponder[armdnsresolver.DNSForwardingRulesetsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewDNSForwardingRulesetsServerTransport creates a new instance of DNSForwardingRulesetsServerTransport with the provided implementation.
// The returned DNSForwardingRulesetsServerTransport instance is connected to an instance of armdnsresolver.DNSForwardingRulesetsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDNSForwardingRulesetsServerTransport(srv *DNSForwardingRulesetsServer) *DNSForwardingRulesetsServerTransport {
	return &DNSForwardingRulesetsServerTransport{
		srv:                          srv,
		beginCreateOrUpdate:          newTracker[azfake.PollerResponder[armdnsresolver.DNSForwardingRulesetsClientCreateOrUpdateResponse]](),
		beginDelete:                  newTracker[azfake.PollerResponder[armdnsresolver.DNSForwardingRulesetsClientDeleteResponse]](),
		newListPager:                 newTracker[azfake.PagerResponder[armdnsresolver.DNSForwardingRulesetsClientListResponse]](),
		newListByResourceGroupPager:  newTracker[azfake.PagerResponder[armdnsresolver.DNSForwardingRulesetsClientListByResourceGroupResponse]](),
		newListByVirtualNetworkPager: newTracker[azfake.PagerResponder[armdnsresolver.DNSForwardingRulesetsClientListByVirtualNetworkResponse]](),
		beginUpdate:                  newTracker[azfake.PollerResponder[armdnsresolver.DNSForwardingRulesetsClientUpdateResponse]](),
	}
}

// DNSForwardingRulesetsServerTransport connects instances of armdnsresolver.DNSForwardingRulesetsClient to instances of DNSForwardingRulesetsServer.
// Don't use this type directly, use NewDNSForwardingRulesetsServerTransport instead.
type DNSForwardingRulesetsServerTransport struct {
	srv                          *DNSForwardingRulesetsServer
	beginCreateOrUpdate          *tracker[azfake.PollerResponder[armdnsresolver.DNSForwardingRulesetsClientCreateOrUpdateResponse]]
	beginDelete                  *tracker[azfake.PollerResponder[armdnsresolver.DNSForwardingRulesetsClientDeleteResponse]]
	newListPager                 *tracker[azfake.PagerResponder[armdnsresolver.DNSForwardingRulesetsClientListResponse]]
	newListByResourceGroupPager  *tracker[azfake.PagerResponder[armdnsresolver.DNSForwardingRulesetsClientListByResourceGroupResponse]]
	newListByVirtualNetworkPager *tracker[azfake.PagerResponder[armdnsresolver.DNSForwardingRulesetsClientListByVirtualNetworkResponse]]
	beginUpdate                  *tracker[azfake.PollerResponder[armdnsresolver.DNSForwardingRulesetsClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for DNSForwardingRulesetsServerTransport.
func (d *DNSForwardingRulesetsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DNSForwardingRulesetsClient.BeginCreateOrUpdate":
		resp, err = d.dispatchBeginCreateOrUpdate(req)
	case "DNSForwardingRulesetsClient.BeginDelete":
		resp, err = d.dispatchBeginDelete(req)
	case "DNSForwardingRulesetsClient.Get":
		resp, err = d.dispatchGet(req)
	case "DNSForwardingRulesetsClient.NewListPager":
		resp, err = d.dispatchNewListPager(req)
	case "DNSForwardingRulesetsClient.NewListByResourceGroupPager":
		resp, err = d.dispatchNewListByResourceGroupPager(req)
	case "DNSForwardingRulesetsClient.NewListByVirtualNetworkPager":
		resp, err = d.dispatchNewListByVirtualNetworkPager(req)
	case "DNSForwardingRulesetsClient.BeginUpdate":
		resp, err = d.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DNSForwardingRulesetsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if d.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := d.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/dnsForwardingRulesets/(?P<dnsForwardingRulesetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdnsresolver.DNSForwardingRuleset](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dnsForwardingRulesetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dnsForwardingRulesetName")])
		if err != nil {
			return nil, err
		}
		ifMatchParam := getOptional(getHeaderValue(req.Header, "If-Match"))
		ifNoneMatchParam := getOptional(getHeaderValue(req.Header, "If-None-Match"))
		var options *armdnsresolver.DNSForwardingRulesetsClientBeginCreateOrUpdateOptions
		if ifMatchParam != nil || ifNoneMatchParam != nil {
			options = &armdnsresolver.DNSForwardingRulesetsClientBeginCreateOrUpdateOptions{
				IfMatch:     ifMatchParam,
				IfNoneMatch: ifNoneMatchParam,
			}
		}
		respr, errRespr := d.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, dnsForwardingRulesetNameParam, body, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		d.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated, http.StatusAccepted}, resp.StatusCode) {
		d.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		d.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (d *DNSForwardingRulesetsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if d.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := d.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/dnsForwardingRulesets/(?P<dnsForwardingRulesetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dnsForwardingRulesetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dnsForwardingRulesetName")])
		if err != nil {
			return nil, err
		}
		ifMatchParam := getOptional(getHeaderValue(req.Header, "If-Match"))
		var options *armdnsresolver.DNSForwardingRulesetsClientBeginDeleteOptions
		if ifMatchParam != nil {
			options = &armdnsresolver.DNSForwardingRulesetsClientBeginDeleteOptions{
				IfMatch: ifMatchParam,
			}
		}
		respr, errRespr := d.srv.BeginDelete(req.Context(), resourceGroupNameParam, dnsForwardingRulesetNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		d.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		d.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		d.beginDelete.remove(req)
	}

	return resp, nil
}

func (d *DNSForwardingRulesetsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if d.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/dnsForwardingRulesets/(?P<dnsForwardingRulesetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	dnsForwardingRulesetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dnsForwardingRulesetName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Get(req.Context(), resourceGroupNameParam, dnsForwardingRulesetNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DNSForwardingRuleset, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DNSForwardingRulesetsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := d.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/dnsForwardingRulesets`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armdnsresolver.DNSForwardingRulesetsClientListOptions
		if topParam != nil {
			options = &armdnsresolver.DNSForwardingRulesetsClientListOptions{
				Top: topParam,
			}
		}
		resp := d.srv.NewListPager(options)
		newListPager = &resp
		d.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armdnsresolver.DNSForwardingRulesetsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		d.newListPager.remove(req)
	}
	return resp, nil
}

func (d *DNSForwardingRulesetsServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := d.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/dnsForwardingRulesets`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armdnsresolver.DNSForwardingRulesetsClientListByResourceGroupOptions
		if topParam != nil {
			options = &armdnsresolver.DNSForwardingRulesetsClientListByResourceGroupOptions{
				Top: topParam,
			}
		}
		resp := d.srv.NewListByResourceGroupPager(resourceGroupNameParam, options)
		newListByResourceGroupPager = &resp
		d.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armdnsresolver.DNSForwardingRulesetsClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		d.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (d *DNSForwardingRulesetsServerTransport) dispatchNewListByVirtualNetworkPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListByVirtualNetworkPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByVirtualNetworkPager not implemented")}
	}
	newListByVirtualNetworkPager := d.newListByVirtualNetworkPager.get(req)
	if newListByVirtualNetworkPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/virtualNetworks/(?P<virtualNetworkName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listDnsForwardingRulesets`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		virtualNetworkNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualNetworkName")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armdnsresolver.DNSForwardingRulesetsClientListByVirtualNetworkOptions
		if topParam != nil {
			options = &armdnsresolver.DNSForwardingRulesetsClientListByVirtualNetworkOptions{
				Top: topParam,
			}
		}
		resp := d.srv.NewListByVirtualNetworkPager(resourceGroupNameParam, virtualNetworkNameParam, options)
		newListByVirtualNetworkPager = &resp
		d.newListByVirtualNetworkPager.add(req, newListByVirtualNetworkPager)
		server.PagerResponderInjectNextLinks(newListByVirtualNetworkPager, req, func(page *armdnsresolver.DNSForwardingRulesetsClientListByVirtualNetworkResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByVirtualNetworkPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListByVirtualNetworkPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByVirtualNetworkPager) {
		d.newListByVirtualNetworkPager.remove(req)
	}
	return resp, nil
}

func (d *DNSForwardingRulesetsServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if d.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := d.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/dnsForwardingRulesets/(?P<dnsForwardingRulesetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdnsresolver.DNSForwardingRulesetPatch](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dnsForwardingRulesetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dnsForwardingRulesetName")])
		if err != nil {
			return nil, err
		}
		ifMatchParam := getOptional(getHeaderValue(req.Header, "If-Match"))
		var options *armdnsresolver.DNSForwardingRulesetsClientBeginUpdateOptions
		if ifMatchParam != nil {
			options = &armdnsresolver.DNSForwardingRulesetsClientBeginUpdateOptions{
				IfMatch: ifMatchParam,
			}
		}
		respr, errRespr := d.srv.BeginUpdate(req.Context(), resourceGroupNameParam, dnsForwardingRulesetNameParam, body, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		d.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		d.beginUpdate.remove(req)
	}

	return resp, nil
}
