//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/labservices/armlabservices"
	"net/http"
	"net/url"
	"regexp"
)

// UsersServer is a fake server for instances of the armlabservices.UsersClient type.
type UsersServer struct {
	// BeginCreateOrUpdate is the fake for method UsersClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated, http.StatusAccepted
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, labName string, userName string, body armlabservices.User, options *armlabservices.UsersClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armlabservices.UsersClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method UsersClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, labName string, userName string, options *armlabservices.UsersClientBeginDeleteOptions) (resp azfake.PollerResponder[armlabservices.UsersClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method UsersClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, labName string, userName string, options *armlabservices.UsersClientGetOptions) (resp azfake.Responder[armlabservices.UsersClientGetResponse], errResp azfake.ErrorResponder)

	// BeginInvite is the fake for method UsersClient.BeginInvite
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginInvite func(ctx context.Context, resourceGroupName string, labName string, userName string, body armlabservices.InviteBody, options *armlabservices.UsersClientBeginInviteOptions) (resp azfake.PollerResponder[armlabservices.UsersClientInviteResponse], errResp azfake.ErrorResponder)

	// NewListByLabPager is the fake for method UsersClient.NewListByLabPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByLabPager func(resourceGroupName string, labName string, options *armlabservices.UsersClientListByLabOptions) (resp azfake.PagerResponder[armlabservices.UsersClientListByLabResponse])

	// BeginUpdate is the fake for method UsersClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, labName string, userName string, body armlabservices.UserUpdate, options *armlabservices.UsersClientBeginUpdateOptions) (resp azfake.PollerResponder[armlabservices.UsersClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewUsersServerTransport creates a new instance of UsersServerTransport with the provided implementation.
// The returned UsersServerTransport instance is connected to an instance of armlabservices.UsersClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewUsersServerTransport(srv *UsersServer) *UsersServerTransport {
	return &UsersServerTransport{
		srv:                 srv,
		beginCreateOrUpdate: newTracker[azfake.PollerResponder[armlabservices.UsersClientCreateOrUpdateResponse]](),
		beginDelete:         newTracker[azfake.PollerResponder[armlabservices.UsersClientDeleteResponse]](),
		beginInvite:         newTracker[azfake.PollerResponder[armlabservices.UsersClientInviteResponse]](),
		newListByLabPager:   newTracker[azfake.PagerResponder[armlabservices.UsersClientListByLabResponse]](),
		beginUpdate:         newTracker[azfake.PollerResponder[armlabservices.UsersClientUpdateResponse]](),
	}
}

// UsersServerTransport connects instances of armlabservices.UsersClient to instances of UsersServer.
// Don't use this type directly, use NewUsersServerTransport instead.
type UsersServerTransport struct {
	srv                 *UsersServer
	beginCreateOrUpdate *tracker[azfake.PollerResponder[armlabservices.UsersClientCreateOrUpdateResponse]]
	beginDelete         *tracker[azfake.PollerResponder[armlabservices.UsersClientDeleteResponse]]
	beginInvite         *tracker[azfake.PollerResponder[armlabservices.UsersClientInviteResponse]]
	newListByLabPager   *tracker[azfake.PagerResponder[armlabservices.UsersClientListByLabResponse]]
	beginUpdate         *tracker[azfake.PollerResponder[armlabservices.UsersClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for UsersServerTransport.
func (u *UsersServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "UsersClient.BeginCreateOrUpdate":
		resp, err = u.dispatchBeginCreateOrUpdate(req)
	case "UsersClient.BeginDelete":
		resp, err = u.dispatchBeginDelete(req)
	case "UsersClient.Get":
		resp, err = u.dispatchGet(req)
	case "UsersClient.BeginInvite":
		resp, err = u.dispatchBeginInvite(req)
	case "UsersClient.NewListByLabPager":
		resp, err = u.dispatchNewListByLabPager(req)
	case "UsersClient.BeginUpdate":
		resp, err = u.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (u *UsersServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if u.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := u.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.LabServices/labs/(?P<labName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/users/(?P<userName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armlabservices.User](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		labNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("labName")])
		if err != nil {
			return nil, err
		}
		userNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("userName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := u.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, labNameParam, userNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		u.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated, http.StatusAccepted}, resp.StatusCode) {
		u.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		u.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (u *UsersServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if u.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := u.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.LabServices/labs/(?P<labName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/users/(?P<userName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		labNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("labName")])
		if err != nil {
			return nil, err
		}
		userNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("userName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := u.srv.BeginDelete(req.Context(), resourceGroupNameParam, labNameParam, userNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		u.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		u.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		u.beginDelete.remove(req)
	}

	return resp, nil
}

func (u *UsersServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if u.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.LabServices/labs/(?P<labName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/users/(?P<userName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	labNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("labName")])
	if err != nil {
		return nil, err
	}
	userNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("userName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := u.srv.Get(req.Context(), resourceGroupNameParam, labNameParam, userNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).User, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (u *UsersServerTransport) dispatchBeginInvite(req *http.Request) (*http.Response, error) {
	if u.srv.BeginInvite == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginInvite not implemented")}
	}
	beginInvite := u.beginInvite.get(req)
	if beginInvite == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.LabServices/labs/(?P<labName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/users/(?P<userName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/invite`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armlabservices.InviteBody](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		labNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("labName")])
		if err != nil {
			return nil, err
		}
		userNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("userName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := u.srv.BeginInvite(req.Context(), resourceGroupNameParam, labNameParam, userNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginInvite = &respr
		u.beginInvite.add(req, beginInvite)
	}

	resp, err := server.PollerResponderNext(beginInvite, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		u.beginInvite.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginInvite) {
		u.beginInvite.remove(req)
	}

	return resp, nil
}

func (u *UsersServerTransport) dispatchNewListByLabPager(req *http.Request) (*http.Response, error) {
	if u.srv.NewListByLabPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByLabPager not implemented")}
	}
	newListByLabPager := u.newListByLabPager.get(req)
	if newListByLabPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.LabServices/labs/(?P<labName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/users`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		labNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("labName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armlabservices.UsersClientListByLabOptions
		if filterParam != nil {
			options = &armlabservices.UsersClientListByLabOptions{
				Filter: filterParam,
			}
		}
		resp := u.srv.NewListByLabPager(resourceGroupNameParam, labNameParam, options)
		newListByLabPager = &resp
		u.newListByLabPager.add(req, newListByLabPager)
		server.PagerResponderInjectNextLinks(newListByLabPager, req, func(page *armlabservices.UsersClientListByLabResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByLabPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		u.newListByLabPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByLabPager) {
		u.newListByLabPager.remove(req)
	}
	return resp, nil
}

func (u *UsersServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if u.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := u.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.LabServices/labs/(?P<labName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/users/(?P<userName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armlabservices.UserUpdate](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		labNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("labName")])
		if err != nil {
			return nil, err
		}
		userNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("userName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := u.srv.BeginUpdate(req.Context(), resourceGroupNameParam, labNameParam, userNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		u.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		u.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		u.beginUpdate.remove(req)
	}

	return resp, nil
}
