//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/netapp/armnetapp/v5"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
	"strconv"
)

// VolumesServer is a fake server for instances of the armnetapp.VolumesClient type.
type VolumesServer struct {
	// BeginAuthorizeReplication is the fake for method VolumesClient.BeginAuthorizeReplication
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginAuthorizeReplication func(ctx context.Context, resourceGroupName string, accountName string, poolName string, volumeName string, body armnetapp.AuthorizeRequest, options *armnetapp.VolumesClientBeginAuthorizeReplicationOptions) (resp azfake.PollerResponder[armnetapp.VolumesClientAuthorizeReplicationResponse], errResp azfake.ErrorResponder)

	// BeginBreakFileLocks is the fake for method VolumesClient.BeginBreakFileLocks
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginBreakFileLocks func(ctx context.Context, resourceGroupName string, accountName string, poolName string, volumeName string, options *armnetapp.VolumesClientBeginBreakFileLocksOptions) (resp azfake.PollerResponder[armnetapp.VolumesClientBreakFileLocksResponse], errResp azfake.ErrorResponder)

	// BeginBreakReplication is the fake for method VolumesClient.BeginBreakReplication
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginBreakReplication func(ctx context.Context, resourceGroupName string, accountName string, poolName string, volumeName string, options *armnetapp.VolumesClientBeginBreakReplicationOptions) (resp azfake.PollerResponder[armnetapp.VolumesClientBreakReplicationResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdate is the fake for method VolumesClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated, http.StatusAccepted
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, accountName string, poolName string, volumeName string, body armnetapp.Volume, options *armnetapp.VolumesClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armnetapp.VolumesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method VolumesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, accountName string, poolName string, volumeName string, options *armnetapp.VolumesClientBeginDeleteOptions) (resp azfake.PollerResponder[armnetapp.VolumesClientDeleteResponse], errResp azfake.ErrorResponder)

	// BeginDeleteReplication is the fake for method VolumesClient.BeginDeleteReplication
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginDeleteReplication func(ctx context.Context, resourceGroupName string, accountName string, poolName string, volumeName string, options *armnetapp.VolumesClientBeginDeleteReplicationOptions) (resp azfake.PollerResponder[armnetapp.VolumesClientDeleteReplicationResponse], errResp azfake.ErrorResponder)

	// BeginFinalizeRelocation is the fake for method VolumesClient.BeginFinalizeRelocation
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginFinalizeRelocation func(ctx context.Context, resourceGroupName string, accountName string, poolName string, volumeName string, options *armnetapp.VolumesClientBeginFinalizeRelocationOptions) (resp azfake.PollerResponder[armnetapp.VolumesClientFinalizeRelocationResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method VolumesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, accountName string, poolName string, volumeName string, options *armnetapp.VolumesClientGetOptions) (resp azfake.Responder[armnetapp.VolumesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method VolumesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, accountName string, poolName string, options *armnetapp.VolumesClientListOptions) (resp azfake.PagerResponder[armnetapp.VolumesClientListResponse])

	// BeginListGetGroupIDListForLdapUser is the fake for method VolumesClient.BeginListGetGroupIDListForLdapUser
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginListGetGroupIDListForLdapUser func(ctx context.Context, resourceGroupName string, accountName string, poolName string, volumeName string, body armnetapp.GetGroupIDListForLDAPUserRequest, options *armnetapp.VolumesClientBeginListGetGroupIDListForLdapUserOptions) (resp azfake.PollerResponder[armnetapp.VolumesClientListGetGroupIDListForLdapUserResponse], errResp azfake.ErrorResponder)

	// NewListReplicationsPager is the fake for method VolumesClient.NewListReplicationsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListReplicationsPager func(resourceGroupName string, accountName string, poolName string, volumeName string, options *armnetapp.VolumesClientListReplicationsOptions) (resp azfake.PagerResponder[armnetapp.VolumesClientListReplicationsResponse])

	// BeginPoolChange is the fake for method VolumesClient.BeginPoolChange
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginPoolChange func(ctx context.Context, resourceGroupName string, accountName string, poolName string, volumeName string, body armnetapp.PoolChangeRequest, options *armnetapp.VolumesClientBeginPoolChangeOptions) (resp azfake.PollerResponder[armnetapp.VolumesClientPoolChangeResponse], errResp azfake.ErrorResponder)

	// BeginPopulateAvailabilityZone is the fake for method VolumesClient.BeginPopulateAvailabilityZone
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginPopulateAvailabilityZone func(ctx context.Context, resourceGroupName string, accountName string, poolName string, volumeName string, options *armnetapp.VolumesClientBeginPopulateAvailabilityZoneOptions) (resp azfake.PollerResponder[armnetapp.VolumesClientPopulateAvailabilityZoneResponse], errResp azfake.ErrorResponder)

	// BeginReInitializeReplication is the fake for method VolumesClient.BeginReInitializeReplication
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginReInitializeReplication func(ctx context.Context, resourceGroupName string, accountName string, poolName string, volumeName string, options *armnetapp.VolumesClientBeginReInitializeReplicationOptions) (resp azfake.PollerResponder[armnetapp.VolumesClientReInitializeReplicationResponse], errResp azfake.ErrorResponder)

	// BeginReestablishReplication is the fake for method VolumesClient.BeginReestablishReplication
	// HTTP status codes to indicate success: http.StatusAccepted
	BeginReestablishReplication func(ctx context.Context, resourceGroupName string, accountName string, poolName string, volumeName string, body armnetapp.ReestablishReplicationRequest, options *armnetapp.VolumesClientBeginReestablishReplicationOptions) (resp azfake.PollerResponder[armnetapp.VolumesClientReestablishReplicationResponse], errResp azfake.ErrorResponder)

	// BeginRelocate is the fake for method VolumesClient.BeginRelocate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRelocate func(ctx context.Context, resourceGroupName string, accountName string, poolName string, volumeName string, options *armnetapp.VolumesClientBeginRelocateOptions) (resp azfake.PollerResponder[armnetapp.VolumesClientRelocateResponse], errResp azfake.ErrorResponder)

	// ReplicationStatus is the fake for method VolumesClient.ReplicationStatus
	// HTTP status codes to indicate success: http.StatusOK
	ReplicationStatus func(ctx context.Context, resourceGroupName string, accountName string, poolName string, volumeName string, options *armnetapp.VolumesClientReplicationStatusOptions) (resp azfake.Responder[armnetapp.VolumesClientReplicationStatusResponse], errResp azfake.ErrorResponder)

	// BeginResetCifsPassword is the fake for method VolumesClient.BeginResetCifsPassword
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginResetCifsPassword func(ctx context.Context, resourceGroupName string, accountName string, poolName string, volumeName string, options *armnetapp.VolumesClientBeginResetCifsPasswordOptions) (resp azfake.PollerResponder[armnetapp.VolumesClientResetCifsPasswordResponse], errResp azfake.ErrorResponder)

	// BeginResyncReplication is the fake for method VolumesClient.BeginResyncReplication
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginResyncReplication func(ctx context.Context, resourceGroupName string, accountName string, poolName string, volumeName string, options *armnetapp.VolumesClientBeginResyncReplicationOptions) (resp azfake.PollerResponder[armnetapp.VolumesClientResyncReplicationResponse], errResp azfake.ErrorResponder)

	// BeginRevert is the fake for method VolumesClient.BeginRevert
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRevert func(ctx context.Context, resourceGroupName string, accountName string, poolName string, volumeName string, body armnetapp.VolumeRevert, options *armnetapp.VolumesClientBeginRevertOptions) (resp azfake.PollerResponder[armnetapp.VolumesClientRevertResponse], errResp azfake.ErrorResponder)

	// BeginRevertRelocation is the fake for method VolumesClient.BeginRevertRelocation
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRevertRelocation func(ctx context.Context, resourceGroupName string, accountName string, poolName string, volumeName string, options *armnetapp.VolumesClientBeginRevertRelocationOptions) (resp azfake.PollerResponder[armnetapp.VolumesClientRevertRelocationResponse], errResp azfake.ErrorResponder)

	// BeginUpdate is the fake for method VolumesClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, accountName string, poolName string, volumeName string, body armnetapp.VolumePatch, options *armnetapp.VolumesClientBeginUpdateOptions) (resp azfake.PollerResponder[armnetapp.VolumesClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewVolumesServerTransport creates a new instance of VolumesServerTransport with the provided implementation.
// The returned VolumesServerTransport instance is connected to an instance of armnetapp.VolumesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewVolumesServerTransport(srv *VolumesServer) *VolumesServerTransport {
	return &VolumesServerTransport{
		srv:                                srv,
		beginAuthorizeReplication:          newTracker[azfake.PollerResponder[armnetapp.VolumesClientAuthorizeReplicationResponse]](),
		beginBreakFileLocks:                newTracker[azfake.PollerResponder[armnetapp.VolumesClientBreakFileLocksResponse]](),
		beginBreakReplication:              newTracker[azfake.PollerResponder[armnetapp.VolumesClientBreakReplicationResponse]](),
		beginCreateOrUpdate:                newTracker[azfake.PollerResponder[armnetapp.VolumesClientCreateOrUpdateResponse]](),
		beginDelete:                        newTracker[azfake.PollerResponder[armnetapp.VolumesClientDeleteResponse]](),
		beginDeleteReplication:             newTracker[azfake.PollerResponder[armnetapp.VolumesClientDeleteReplicationResponse]](),
		beginFinalizeRelocation:            newTracker[azfake.PollerResponder[armnetapp.VolumesClientFinalizeRelocationResponse]](),
		newListPager:                       newTracker[azfake.PagerResponder[armnetapp.VolumesClientListResponse]](),
		beginListGetGroupIDListForLdapUser: newTracker[azfake.PollerResponder[armnetapp.VolumesClientListGetGroupIDListForLdapUserResponse]](),
		newListReplicationsPager:           newTracker[azfake.PagerResponder[armnetapp.VolumesClientListReplicationsResponse]](),
		beginPoolChange:                    newTracker[azfake.PollerResponder[armnetapp.VolumesClientPoolChangeResponse]](),
		beginPopulateAvailabilityZone:      newTracker[azfake.PollerResponder[armnetapp.VolumesClientPopulateAvailabilityZoneResponse]](),
		beginReInitializeReplication:       newTracker[azfake.PollerResponder[armnetapp.VolumesClientReInitializeReplicationResponse]](),
		beginReestablishReplication:        newTracker[azfake.PollerResponder[armnetapp.VolumesClientReestablishReplicationResponse]](),
		beginRelocate:                      newTracker[azfake.PollerResponder[armnetapp.VolumesClientRelocateResponse]](),
		beginResetCifsPassword:             newTracker[azfake.PollerResponder[armnetapp.VolumesClientResetCifsPasswordResponse]](),
		beginResyncReplication:             newTracker[azfake.PollerResponder[armnetapp.VolumesClientResyncReplicationResponse]](),
		beginRevert:                        newTracker[azfake.PollerResponder[armnetapp.VolumesClientRevertResponse]](),
		beginRevertRelocation:              newTracker[azfake.PollerResponder[armnetapp.VolumesClientRevertRelocationResponse]](),
		beginUpdate:                        newTracker[azfake.PollerResponder[armnetapp.VolumesClientUpdateResponse]](),
	}
}

// VolumesServerTransport connects instances of armnetapp.VolumesClient to instances of VolumesServer.
// Don't use this type directly, use NewVolumesServerTransport instead.
type VolumesServerTransport struct {
	srv                                *VolumesServer
	beginAuthorizeReplication          *tracker[azfake.PollerResponder[armnetapp.VolumesClientAuthorizeReplicationResponse]]
	beginBreakFileLocks                *tracker[azfake.PollerResponder[armnetapp.VolumesClientBreakFileLocksResponse]]
	beginBreakReplication              *tracker[azfake.PollerResponder[armnetapp.VolumesClientBreakReplicationResponse]]
	beginCreateOrUpdate                *tracker[azfake.PollerResponder[armnetapp.VolumesClientCreateOrUpdateResponse]]
	beginDelete                        *tracker[azfake.PollerResponder[armnetapp.VolumesClientDeleteResponse]]
	beginDeleteReplication             *tracker[azfake.PollerResponder[armnetapp.VolumesClientDeleteReplicationResponse]]
	beginFinalizeRelocation            *tracker[azfake.PollerResponder[armnetapp.VolumesClientFinalizeRelocationResponse]]
	newListPager                       *tracker[azfake.PagerResponder[armnetapp.VolumesClientListResponse]]
	beginListGetGroupIDListForLdapUser *tracker[azfake.PollerResponder[armnetapp.VolumesClientListGetGroupIDListForLdapUserResponse]]
	newListReplicationsPager           *tracker[azfake.PagerResponder[armnetapp.VolumesClientListReplicationsResponse]]
	beginPoolChange                    *tracker[azfake.PollerResponder[armnetapp.VolumesClientPoolChangeResponse]]
	beginPopulateAvailabilityZone      *tracker[azfake.PollerResponder[armnetapp.VolumesClientPopulateAvailabilityZoneResponse]]
	beginReInitializeReplication       *tracker[azfake.PollerResponder[armnetapp.VolumesClientReInitializeReplicationResponse]]
	beginReestablishReplication        *tracker[azfake.PollerResponder[armnetapp.VolumesClientReestablishReplicationResponse]]
	beginRelocate                      *tracker[azfake.PollerResponder[armnetapp.VolumesClientRelocateResponse]]
	beginResetCifsPassword             *tracker[azfake.PollerResponder[armnetapp.VolumesClientResetCifsPasswordResponse]]
	beginResyncReplication             *tracker[azfake.PollerResponder[armnetapp.VolumesClientResyncReplicationResponse]]
	beginRevert                        *tracker[azfake.PollerResponder[armnetapp.VolumesClientRevertResponse]]
	beginRevertRelocation              *tracker[azfake.PollerResponder[armnetapp.VolumesClientRevertRelocationResponse]]
	beginUpdate                        *tracker[azfake.PollerResponder[armnetapp.VolumesClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for VolumesServerTransport.
func (v *VolumesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "VolumesClient.BeginAuthorizeReplication":
		resp, err = v.dispatchBeginAuthorizeReplication(req)
	case "VolumesClient.BeginBreakFileLocks":
		resp, err = v.dispatchBeginBreakFileLocks(req)
	case "VolumesClient.BeginBreakReplication":
		resp, err = v.dispatchBeginBreakReplication(req)
	case "VolumesClient.BeginCreateOrUpdate":
		resp, err = v.dispatchBeginCreateOrUpdate(req)
	case "VolumesClient.BeginDelete":
		resp, err = v.dispatchBeginDelete(req)
	case "VolumesClient.BeginDeleteReplication":
		resp, err = v.dispatchBeginDeleteReplication(req)
	case "VolumesClient.BeginFinalizeRelocation":
		resp, err = v.dispatchBeginFinalizeRelocation(req)
	case "VolumesClient.Get":
		resp, err = v.dispatchGet(req)
	case "VolumesClient.NewListPager":
		resp, err = v.dispatchNewListPager(req)
	case "VolumesClient.BeginListGetGroupIDListForLdapUser":
		resp, err = v.dispatchBeginListGetGroupIDListForLdapUser(req)
	case "VolumesClient.NewListReplicationsPager":
		resp, err = v.dispatchNewListReplicationsPager(req)
	case "VolumesClient.BeginPoolChange":
		resp, err = v.dispatchBeginPoolChange(req)
	case "VolumesClient.BeginPopulateAvailabilityZone":
		resp, err = v.dispatchBeginPopulateAvailabilityZone(req)
	case "VolumesClient.BeginReInitializeReplication":
		resp, err = v.dispatchBeginReInitializeReplication(req)
	case "VolumesClient.BeginReestablishReplication":
		resp, err = v.dispatchBeginReestablishReplication(req)
	case "VolumesClient.BeginRelocate":
		resp, err = v.dispatchBeginRelocate(req)
	case "VolumesClient.ReplicationStatus":
		resp, err = v.dispatchReplicationStatus(req)
	case "VolumesClient.BeginResetCifsPassword":
		resp, err = v.dispatchBeginResetCifsPassword(req)
	case "VolumesClient.BeginResyncReplication":
		resp, err = v.dispatchBeginResyncReplication(req)
	case "VolumesClient.BeginRevert":
		resp, err = v.dispatchBeginRevert(req)
	case "VolumesClient.BeginRevertRelocation":
		resp, err = v.dispatchBeginRevertRelocation(req)
	case "VolumesClient.BeginUpdate":
		resp, err = v.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (v *VolumesServerTransport) dispatchBeginAuthorizeReplication(req *http.Request) (*http.Response, error) {
	if v.srv.BeginAuthorizeReplication == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginAuthorizeReplication not implemented")}
	}
	beginAuthorizeReplication := v.beginAuthorizeReplication.get(req)
	if beginAuthorizeReplication == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetApp/netAppAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capacityPools/(?P<poolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumes/(?P<volumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/authorizeReplication`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetapp.AuthorizeRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		poolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("poolName")])
		if err != nil {
			return nil, err
		}
		volumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginAuthorizeReplication(req.Context(), resourceGroupNameParam, accountNameParam, poolNameParam, volumeNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginAuthorizeReplication = &respr
		v.beginAuthorizeReplication.add(req, beginAuthorizeReplication)
	}

	resp, err := server.PollerResponderNext(beginAuthorizeReplication, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginAuthorizeReplication.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginAuthorizeReplication) {
		v.beginAuthorizeReplication.remove(req)
	}

	return resp, nil
}

func (v *VolumesServerTransport) dispatchBeginBreakFileLocks(req *http.Request) (*http.Response, error) {
	if v.srv.BeginBreakFileLocks == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginBreakFileLocks not implemented")}
	}
	beginBreakFileLocks := v.beginBreakFileLocks.get(req)
	if beginBreakFileLocks == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetApp/netAppAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capacityPools/(?P<poolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumes/(?P<volumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/breakFileLocks`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetapp.BreakFileLocksRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		poolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("poolName")])
		if err != nil {
			return nil, err
		}
		volumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeName")])
		if err != nil {
			return nil, err
		}
		var options *armnetapp.VolumesClientBeginBreakFileLocksOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armnetapp.VolumesClientBeginBreakFileLocksOptions{
				Body: &body,
			}
		}
		respr, errRespr := v.srv.BeginBreakFileLocks(req.Context(), resourceGroupNameParam, accountNameParam, poolNameParam, volumeNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginBreakFileLocks = &respr
		v.beginBreakFileLocks.add(req, beginBreakFileLocks)
	}

	resp, err := server.PollerResponderNext(beginBreakFileLocks, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginBreakFileLocks.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginBreakFileLocks) {
		v.beginBreakFileLocks.remove(req)
	}

	return resp, nil
}

func (v *VolumesServerTransport) dispatchBeginBreakReplication(req *http.Request) (*http.Response, error) {
	if v.srv.BeginBreakReplication == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginBreakReplication not implemented")}
	}
	beginBreakReplication := v.beginBreakReplication.get(req)
	if beginBreakReplication == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetApp/netAppAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capacityPools/(?P<poolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumes/(?P<volumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/breakReplication`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetapp.BreakReplicationRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		poolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("poolName")])
		if err != nil {
			return nil, err
		}
		volumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeName")])
		if err != nil {
			return nil, err
		}
		var options *armnetapp.VolumesClientBeginBreakReplicationOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armnetapp.VolumesClientBeginBreakReplicationOptions{
				Body: &body,
			}
		}
		respr, errRespr := v.srv.BeginBreakReplication(req.Context(), resourceGroupNameParam, accountNameParam, poolNameParam, volumeNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginBreakReplication = &respr
		v.beginBreakReplication.add(req, beginBreakReplication)
	}

	resp, err := server.PollerResponderNext(beginBreakReplication, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginBreakReplication.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginBreakReplication) {
		v.beginBreakReplication.remove(req)
	}

	return resp, nil
}

func (v *VolumesServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if v.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := v.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetApp/netAppAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capacityPools/(?P<poolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumes/(?P<volumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetapp.Volume](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		poolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("poolName")])
		if err != nil {
			return nil, err
		}
		volumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, accountNameParam, poolNameParam, volumeNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		v.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated, http.StatusAccepted}, resp.StatusCode) {
		v.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		v.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (v *VolumesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if v.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := v.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetApp/netAppAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capacityPools/(?P<poolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumes/(?P<volumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		poolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("poolName")])
		if err != nil {
			return nil, err
		}
		volumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeName")])
		if err != nil {
			return nil, err
		}
		forceDeleteUnescaped, err := url.QueryUnescape(qp.Get("forceDelete"))
		if err != nil {
			return nil, err
		}
		forceDeleteParam, err := parseOptional(forceDeleteUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		var options *armnetapp.VolumesClientBeginDeleteOptions
		if forceDeleteParam != nil {
			options = &armnetapp.VolumesClientBeginDeleteOptions{
				ForceDelete: forceDeleteParam,
			}
		}
		respr, errRespr := v.srv.BeginDelete(req.Context(), resourceGroupNameParam, accountNameParam, poolNameParam, volumeNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		v.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		v.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		v.beginDelete.remove(req)
	}

	return resp, nil
}

func (v *VolumesServerTransport) dispatchBeginDeleteReplication(req *http.Request) (*http.Response, error) {
	if v.srv.BeginDeleteReplication == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteReplication not implemented")}
	}
	beginDeleteReplication := v.beginDeleteReplication.get(req)
	if beginDeleteReplication == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetApp/netAppAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capacityPools/(?P<poolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumes/(?P<volumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deleteReplication`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		poolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("poolName")])
		if err != nil {
			return nil, err
		}
		volumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginDeleteReplication(req.Context(), resourceGroupNameParam, accountNameParam, poolNameParam, volumeNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteReplication = &respr
		v.beginDeleteReplication.add(req, beginDeleteReplication)
	}

	resp, err := server.PollerResponderNext(beginDeleteReplication, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginDeleteReplication.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteReplication) {
		v.beginDeleteReplication.remove(req)
	}

	return resp, nil
}

func (v *VolumesServerTransport) dispatchBeginFinalizeRelocation(req *http.Request) (*http.Response, error) {
	if v.srv.BeginFinalizeRelocation == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginFinalizeRelocation not implemented")}
	}
	beginFinalizeRelocation := v.beginFinalizeRelocation.get(req)
	if beginFinalizeRelocation == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetApp/netAppAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capacityPools/(?P<poolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumes/(?P<volumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/finalizeRelocation`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		poolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("poolName")])
		if err != nil {
			return nil, err
		}
		volumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginFinalizeRelocation(req.Context(), resourceGroupNameParam, accountNameParam, poolNameParam, volumeNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginFinalizeRelocation = &respr
		v.beginFinalizeRelocation.add(req, beginFinalizeRelocation)
	}

	resp, err := server.PollerResponderNext(beginFinalizeRelocation, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginFinalizeRelocation.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginFinalizeRelocation) {
		v.beginFinalizeRelocation.remove(req)
	}

	return resp, nil
}

func (v *VolumesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if v.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetApp/netAppAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capacityPools/(?P<poolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumes/(?P<volumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	poolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("poolName")])
	if err != nil {
		return nil, err
	}
	volumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.Get(req.Context(), resourceGroupNameParam, accountNameParam, poolNameParam, volumeNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Volume, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *VolumesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if v.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := v.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetApp/netAppAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capacityPools/(?P<poolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumes`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		poolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("poolName")])
		if err != nil {
			return nil, err
		}
		resp := v.srv.NewListPager(resourceGroupNameParam, accountNameParam, poolNameParam, nil)
		newListPager = &resp
		v.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armnetapp.VolumesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		v.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		v.newListPager.remove(req)
	}
	return resp, nil
}

func (v *VolumesServerTransport) dispatchBeginListGetGroupIDListForLdapUser(req *http.Request) (*http.Response, error) {
	if v.srv.BeginListGetGroupIDListForLdapUser == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginListGetGroupIDListForLdapUser not implemented")}
	}
	beginListGetGroupIDListForLdapUser := v.beginListGetGroupIDListForLdapUser.get(req)
	if beginListGetGroupIDListForLdapUser == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetApp/netAppAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capacityPools/(?P<poolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumes/(?P<volumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getGroupIdListForLdapUser`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetapp.GetGroupIDListForLDAPUserRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		poolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("poolName")])
		if err != nil {
			return nil, err
		}
		volumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginListGetGroupIDListForLdapUser(req.Context(), resourceGroupNameParam, accountNameParam, poolNameParam, volumeNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginListGetGroupIDListForLdapUser = &respr
		v.beginListGetGroupIDListForLdapUser.add(req, beginListGetGroupIDListForLdapUser)
	}

	resp, err := server.PollerResponderNext(beginListGetGroupIDListForLdapUser, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginListGetGroupIDListForLdapUser.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginListGetGroupIDListForLdapUser) {
		v.beginListGetGroupIDListForLdapUser.remove(req)
	}

	return resp, nil
}

func (v *VolumesServerTransport) dispatchNewListReplicationsPager(req *http.Request) (*http.Response, error) {
	if v.srv.NewListReplicationsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListReplicationsPager not implemented")}
	}
	newListReplicationsPager := v.newListReplicationsPager.get(req)
	if newListReplicationsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetApp/netAppAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capacityPools/(?P<poolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumes/(?P<volumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listReplications`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		poolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("poolName")])
		if err != nil {
			return nil, err
		}
		volumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeName")])
		if err != nil {
			return nil, err
		}
		resp := v.srv.NewListReplicationsPager(resourceGroupNameParam, accountNameParam, poolNameParam, volumeNameParam, nil)
		newListReplicationsPager = &resp
		v.newListReplicationsPager.add(req, newListReplicationsPager)
	}
	resp, err := server.PagerResponderNext(newListReplicationsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		v.newListReplicationsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListReplicationsPager) {
		v.newListReplicationsPager.remove(req)
	}
	return resp, nil
}

func (v *VolumesServerTransport) dispatchBeginPoolChange(req *http.Request) (*http.Response, error) {
	if v.srv.BeginPoolChange == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginPoolChange not implemented")}
	}
	beginPoolChange := v.beginPoolChange.get(req)
	if beginPoolChange == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetApp/netAppAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capacityPools/(?P<poolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumes/(?P<volumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/poolChange`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetapp.PoolChangeRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		poolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("poolName")])
		if err != nil {
			return nil, err
		}
		volumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginPoolChange(req.Context(), resourceGroupNameParam, accountNameParam, poolNameParam, volumeNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginPoolChange = &respr
		v.beginPoolChange.add(req, beginPoolChange)
	}

	resp, err := server.PollerResponderNext(beginPoolChange, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginPoolChange.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginPoolChange) {
		v.beginPoolChange.remove(req)
	}

	return resp, nil
}

func (v *VolumesServerTransport) dispatchBeginPopulateAvailabilityZone(req *http.Request) (*http.Response, error) {
	if v.srv.BeginPopulateAvailabilityZone == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginPopulateAvailabilityZone not implemented")}
	}
	beginPopulateAvailabilityZone := v.beginPopulateAvailabilityZone.get(req)
	if beginPopulateAvailabilityZone == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetApp/netAppAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capacityPools/(?P<poolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumes/(?P<volumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/populateAvailabilityZone`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		poolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("poolName")])
		if err != nil {
			return nil, err
		}
		volumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginPopulateAvailabilityZone(req.Context(), resourceGroupNameParam, accountNameParam, poolNameParam, volumeNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginPopulateAvailabilityZone = &respr
		v.beginPopulateAvailabilityZone.add(req, beginPopulateAvailabilityZone)
	}

	resp, err := server.PollerResponderNext(beginPopulateAvailabilityZone, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginPopulateAvailabilityZone.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginPopulateAvailabilityZone) {
		v.beginPopulateAvailabilityZone.remove(req)
	}

	return resp, nil
}

func (v *VolumesServerTransport) dispatchBeginReInitializeReplication(req *http.Request) (*http.Response, error) {
	if v.srv.BeginReInitializeReplication == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginReInitializeReplication not implemented")}
	}
	beginReInitializeReplication := v.beginReInitializeReplication.get(req)
	if beginReInitializeReplication == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetApp/netAppAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capacityPools/(?P<poolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumes/(?P<volumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/reinitializeReplication`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		poolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("poolName")])
		if err != nil {
			return nil, err
		}
		volumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginReInitializeReplication(req.Context(), resourceGroupNameParam, accountNameParam, poolNameParam, volumeNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginReInitializeReplication = &respr
		v.beginReInitializeReplication.add(req, beginReInitializeReplication)
	}

	resp, err := server.PollerResponderNext(beginReInitializeReplication, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginReInitializeReplication.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginReInitializeReplication) {
		v.beginReInitializeReplication.remove(req)
	}

	return resp, nil
}

func (v *VolumesServerTransport) dispatchBeginReestablishReplication(req *http.Request) (*http.Response, error) {
	if v.srv.BeginReestablishReplication == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginReestablishReplication not implemented")}
	}
	beginReestablishReplication := v.beginReestablishReplication.get(req)
	if beginReestablishReplication == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetApp/netAppAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capacityPools/(?P<poolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumes/(?P<volumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/reestablishReplication`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetapp.ReestablishReplicationRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		poolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("poolName")])
		if err != nil {
			return nil, err
		}
		volumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginReestablishReplication(req.Context(), resourceGroupNameParam, accountNameParam, poolNameParam, volumeNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginReestablishReplication = &respr
		v.beginReestablishReplication.add(req, beginReestablishReplication)
	}

	resp, err := server.PollerResponderNext(beginReestablishReplication, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted}, resp.StatusCode) {
		v.beginReestablishReplication.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginReestablishReplication) {
		v.beginReestablishReplication.remove(req)
	}

	return resp, nil
}

func (v *VolumesServerTransport) dispatchBeginRelocate(req *http.Request) (*http.Response, error) {
	if v.srv.BeginRelocate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRelocate not implemented")}
	}
	beginRelocate := v.beginRelocate.get(req)
	if beginRelocate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetApp/netAppAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capacityPools/(?P<poolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumes/(?P<volumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/relocate`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetapp.RelocateVolumeRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		poolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("poolName")])
		if err != nil {
			return nil, err
		}
		volumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeName")])
		if err != nil {
			return nil, err
		}
		var options *armnetapp.VolumesClientBeginRelocateOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armnetapp.VolumesClientBeginRelocateOptions{
				Body: &body,
			}
		}
		respr, errRespr := v.srv.BeginRelocate(req.Context(), resourceGroupNameParam, accountNameParam, poolNameParam, volumeNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRelocate = &respr
		v.beginRelocate.add(req, beginRelocate)
	}

	resp, err := server.PollerResponderNext(beginRelocate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginRelocate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRelocate) {
		v.beginRelocate.remove(req)
	}

	return resp, nil
}

func (v *VolumesServerTransport) dispatchReplicationStatus(req *http.Request) (*http.Response, error) {
	if v.srv.ReplicationStatus == nil {
		return nil, &nonRetriableError{errors.New("fake for method ReplicationStatus not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetApp/netAppAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capacityPools/(?P<poolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumes/(?P<volumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationStatus`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	poolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("poolName")])
	if err != nil {
		return nil, err
	}
	volumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.ReplicationStatus(req.Context(), resourceGroupNameParam, accountNameParam, poolNameParam, volumeNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ReplicationStatus, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *VolumesServerTransport) dispatchBeginResetCifsPassword(req *http.Request) (*http.Response, error) {
	if v.srv.BeginResetCifsPassword == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginResetCifsPassword not implemented")}
	}
	beginResetCifsPassword := v.beginResetCifsPassword.get(req)
	if beginResetCifsPassword == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetApp/netAppAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capacityPools/(?P<poolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumes/(?P<volumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resetCifsPassword`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		poolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("poolName")])
		if err != nil {
			return nil, err
		}
		volumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginResetCifsPassword(req.Context(), resourceGroupNameParam, accountNameParam, poolNameParam, volumeNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginResetCifsPassword = &respr
		v.beginResetCifsPassword.add(req, beginResetCifsPassword)
	}

	resp, err := server.PollerResponderNext(beginResetCifsPassword, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginResetCifsPassword.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginResetCifsPassword) {
		v.beginResetCifsPassword.remove(req)
	}

	return resp, nil
}

func (v *VolumesServerTransport) dispatchBeginResyncReplication(req *http.Request) (*http.Response, error) {
	if v.srv.BeginResyncReplication == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginResyncReplication not implemented")}
	}
	beginResyncReplication := v.beginResyncReplication.get(req)
	if beginResyncReplication == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetApp/netAppAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capacityPools/(?P<poolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumes/(?P<volumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resyncReplication`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		poolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("poolName")])
		if err != nil {
			return nil, err
		}
		volumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginResyncReplication(req.Context(), resourceGroupNameParam, accountNameParam, poolNameParam, volumeNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginResyncReplication = &respr
		v.beginResyncReplication.add(req, beginResyncReplication)
	}

	resp, err := server.PollerResponderNext(beginResyncReplication, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginResyncReplication.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginResyncReplication) {
		v.beginResyncReplication.remove(req)
	}

	return resp, nil
}

func (v *VolumesServerTransport) dispatchBeginRevert(req *http.Request) (*http.Response, error) {
	if v.srv.BeginRevert == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRevert not implemented")}
	}
	beginRevert := v.beginRevert.get(req)
	if beginRevert == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetApp/netAppAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capacityPools/(?P<poolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumes/(?P<volumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/revert`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetapp.VolumeRevert](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		poolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("poolName")])
		if err != nil {
			return nil, err
		}
		volumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginRevert(req.Context(), resourceGroupNameParam, accountNameParam, poolNameParam, volumeNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRevert = &respr
		v.beginRevert.add(req, beginRevert)
	}

	resp, err := server.PollerResponderNext(beginRevert, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginRevert.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRevert) {
		v.beginRevert.remove(req)
	}

	return resp, nil
}

func (v *VolumesServerTransport) dispatchBeginRevertRelocation(req *http.Request) (*http.Response, error) {
	if v.srv.BeginRevertRelocation == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRevertRelocation not implemented")}
	}
	beginRevertRelocation := v.beginRevertRelocation.get(req)
	if beginRevertRelocation == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetApp/netAppAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capacityPools/(?P<poolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumes/(?P<volumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/revertRelocation`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		poolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("poolName")])
		if err != nil {
			return nil, err
		}
		volumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginRevertRelocation(req.Context(), resourceGroupNameParam, accountNameParam, poolNameParam, volumeNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRevertRelocation = &respr
		v.beginRevertRelocation.add(req, beginRevertRelocation)
	}

	resp, err := server.PollerResponderNext(beginRevertRelocation, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginRevertRelocation.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRevertRelocation) {
		v.beginRevertRelocation.remove(req)
	}

	return resp, nil
}

func (v *VolumesServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if v.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := v.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetApp/netAppAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capacityPools/(?P<poolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumes/(?P<volumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetapp.VolumePatch](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		poolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("poolName")])
		if err != nil {
			return nil, err
		}
		volumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginUpdate(req.Context(), resourceGroupNameParam, accountNameParam, poolNameParam, volumeNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		v.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		v.beginUpdate.remove(req)
	}

	return resp, nil
}
