//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/resourcehealth/armresourcehealth"
	"net/http"
	"net/url"
	"regexp"
)

// AvailabilityStatusesServer is a fake server for instances of the armresourcehealth.AvailabilityStatusesClient type.
type AvailabilityStatusesServer struct {
	// GetByResource is the fake for method AvailabilityStatusesClient.GetByResource
	// HTTP status codes to indicate success: http.StatusOK
	GetByResource func(ctx context.Context, resourceURI string, options *armresourcehealth.AvailabilityStatusesClientGetByResourceOptions) (resp azfake.Responder[armresourcehealth.AvailabilityStatusesClientGetByResourceResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method AvailabilityStatusesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceURI string, options *armresourcehealth.AvailabilityStatusesClientListOptions) (resp azfake.PagerResponder[armresourcehealth.AvailabilityStatusesClientListResponse])

	// NewListByResourceGroupPager is the fake for method AvailabilityStatusesClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armresourcehealth.AvailabilityStatusesClientListByResourceGroupOptions) (resp azfake.PagerResponder[armresourcehealth.AvailabilityStatusesClientListByResourceGroupResponse])

	// NewListBySubscriptionIDPager is the fake for method AvailabilityStatusesClient.NewListBySubscriptionIDPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionIDPager func(options *armresourcehealth.AvailabilityStatusesClientListBySubscriptionIDOptions) (resp azfake.PagerResponder[armresourcehealth.AvailabilityStatusesClientListBySubscriptionIDResponse])
}

// NewAvailabilityStatusesServerTransport creates a new instance of AvailabilityStatusesServerTransport with the provided implementation.
// The returned AvailabilityStatusesServerTransport instance is connected to an instance of armresourcehealth.AvailabilityStatusesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAvailabilityStatusesServerTransport(srv *AvailabilityStatusesServer) *AvailabilityStatusesServerTransport {
	return &AvailabilityStatusesServerTransport{
		srv:                          srv,
		newListPager:                 newTracker[azfake.PagerResponder[armresourcehealth.AvailabilityStatusesClientListResponse]](),
		newListByResourceGroupPager:  newTracker[azfake.PagerResponder[armresourcehealth.AvailabilityStatusesClientListByResourceGroupResponse]](),
		newListBySubscriptionIDPager: newTracker[azfake.PagerResponder[armresourcehealth.AvailabilityStatusesClientListBySubscriptionIDResponse]](),
	}
}

// AvailabilityStatusesServerTransport connects instances of armresourcehealth.AvailabilityStatusesClient to instances of AvailabilityStatusesServer.
// Don't use this type directly, use NewAvailabilityStatusesServerTransport instead.
type AvailabilityStatusesServerTransport struct {
	srv                          *AvailabilityStatusesServer
	newListPager                 *tracker[azfake.PagerResponder[armresourcehealth.AvailabilityStatusesClientListResponse]]
	newListByResourceGroupPager  *tracker[azfake.PagerResponder[armresourcehealth.AvailabilityStatusesClientListByResourceGroupResponse]]
	newListBySubscriptionIDPager *tracker[azfake.PagerResponder[armresourcehealth.AvailabilityStatusesClientListBySubscriptionIDResponse]]
}

// Do implements the policy.Transporter interface for AvailabilityStatusesServerTransport.
func (a *AvailabilityStatusesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AvailabilityStatusesClient.GetByResource":
		resp, err = a.dispatchGetByResource(req)
	case "AvailabilityStatusesClient.NewListPager":
		resp, err = a.dispatchNewListPager(req)
	case "AvailabilityStatusesClient.NewListByResourceGroupPager":
		resp, err = a.dispatchNewListByResourceGroupPager(req)
	case "AvailabilityStatusesClient.NewListBySubscriptionIDPager":
		resp, err = a.dispatchNewListBySubscriptionIDPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AvailabilityStatusesServerTransport) dispatchGetByResource(req *http.Request) (*http.Response, error) {
	if a.srv.GetByResource == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetByResource not implemented")}
	}
	const regexStr = `/(?P<resourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ResourceHealth/availabilityStatuses/current`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceUri")])
	if err != nil {
		return nil, err
	}
	filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
	if err != nil {
		return nil, err
	}
	filterParam := getOptional(filterUnescaped)
	expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
	if err != nil {
		return nil, err
	}
	expandParam := getOptional(expandUnescaped)
	var options *armresourcehealth.AvailabilityStatusesClientGetByResourceOptions
	if filterParam != nil || expandParam != nil {
		options = &armresourcehealth.AvailabilityStatusesClientGetByResourceOptions{
			Filter: filterParam,
			Expand: expandParam,
		}
	}
	respr, errRespr := a.srv.GetByResource(req.Context(), resourceURIParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AvailabilityStatus, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AvailabilityStatusesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := a.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/(?P<resourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ResourceHealth/availabilityStatuses`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceUri")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
		if err != nil {
			return nil, err
		}
		expandParam := getOptional(expandUnescaped)
		var options *armresourcehealth.AvailabilityStatusesClientListOptions
		if filterParam != nil || expandParam != nil {
			options = &armresourcehealth.AvailabilityStatusesClientListOptions{
				Filter: filterParam,
				Expand: expandParam,
			}
		}
		resp := a.srv.NewListPager(resourceURIParam, options)
		newListPager = &resp
		a.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armresourcehealth.AvailabilityStatusesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		a.newListPager.remove(req)
	}
	return resp, nil
}

func (a *AvailabilityStatusesServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := a.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ResourceHealth/availabilityStatuses`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
		if err != nil {
			return nil, err
		}
		expandParam := getOptional(expandUnescaped)
		var options *armresourcehealth.AvailabilityStatusesClientListByResourceGroupOptions
		if filterParam != nil || expandParam != nil {
			options = &armresourcehealth.AvailabilityStatusesClientListByResourceGroupOptions{
				Filter: filterParam,
				Expand: expandParam,
			}
		}
		resp := a.srv.NewListByResourceGroupPager(resourceGroupNameParam, options)
		newListByResourceGroupPager = &resp
		a.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armresourcehealth.AvailabilityStatusesClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		a.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (a *AvailabilityStatusesServerTransport) dispatchNewListBySubscriptionIDPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListBySubscriptionIDPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionIDPager not implemented")}
	}
	newListBySubscriptionIDPager := a.newListBySubscriptionIDPager.get(req)
	if newListBySubscriptionIDPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ResourceHealth/availabilityStatuses`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
		if err != nil {
			return nil, err
		}
		expandParam := getOptional(expandUnescaped)
		var options *armresourcehealth.AvailabilityStatusesClientListBySubscriptionIDOptions
		if filterParam != nil || expandParam != nil {
			options = &armresourcehealth.AvailabilityStatusesClientListBySubscriptionIDOptions{
				Filter: filterParam,
				Expand: expandParam,
			}
		}
		resp := a.srv.NewListBySubscriptionIDPager(options)
		newListBySubscriptionIDPager = &resp
		a.newListBySubscriptionIDPager.add(req, newListBySubscriptionIDPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionIDPager, req, func(page *armresourcehealth.AvailabilityStatusesClientListBySubscriptionIDResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionIDPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListBySubscriptionIDPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionIDPager) {
		a.newListBySubscriptionIDPager.remove(req)
	}
	return resp, nil
}
