//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
)

// VulnerabilityAssessmentsServer is a fake server for instances of the armsql.VulnerabilityAssessmentsClient type.
type VulnerabilityAssessmentsServer struct {
	// Delete is the fake for method VulnerabilityAssessmentsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName armsql.VulnerabilityAssessmentName, options *armsql.VulnerabilityAssessmentsClientDeleteOptions) (resp azfake.Responder[armsql.VulnerabilityAssessmentsClientDeleteResponse], errResp azfake.ErrorResponder)
}

// NewVulnerabilityAssessmentsServerTransport creates a new instance of VulnerabilityAssessmentsServerTransport with the provided implementation.
// The returned VulnerabilityAssessmentsServerTransport instance is connected to an instance of armsql.VulnerabilityAssessmentsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewVulnerabilityAssessmentsServerTransport(srv *VulnerabilityAssessmentsServer) *VulnerabilityAssessmentsServerTransport {
	return &VulnerabilityAssessmentsServerTransport{srv: srv}
}

// VulnerabilityAssessmentsServerTransport connects instances of armsql.VulnerabilityAssessmentsClient to instances of VulnerabilityAssessmentsServer.
// Don't use this type directly, use NewVulnerabilityAssessmentsServerTransport instead.
type VulnerabilityAssessmentsServerTransport struct {
	srv *VulnerabilityAssessmentsServer
}

// Do implements the policy.Transporter interface for VulnerabilityAssessmentsServerTransport.
func (v *VulnerabilityAssessmentsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "VulnerabilityAssessmentsClient.Delete":
		resp, err = v.dispatchDelete(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (v *VulnerabilityAssessmentsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if v.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlVulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
	if err != nil {
		return nil, err
	}
	vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsql.VulnerabilityAssessmentName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsql.VulnerabilityAssessmentName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.Delete(req.Context(), resourceGroupNameParam, serverNameParam, vulnerabilityAssessmentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
