// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/documentai/v1/document_processor_service.proto

package documentai

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The final state of human review on a processed document.
type HumanReviewStatus_State int32

const (
	// Human review state is unspecified. Most likely due to an internal error.
	HumanReviewStatus_STATE_UNSPECIFIED HumanReviewStatus_State = 0
	// Human review is skipped for the document. This can happen because human
	// review is not enabled on the processor or the processing request has
	// been set to skip this document.
	HumanReviewStatus_SKIPPED HumanReviewStatus_State = 1
	// Human review validation is triggered and passed, so no review is needed.
	HumanReviewStatus_VALIDATION_PASSED HumanReviewStatus_State = 2
	// Human review validation is triggered and the document is under review.
	HumanReviewStatus_IN_PROGRESS HumanReviewStatus_State = 3
	// Some error happened during triggering human review, see the
	// [state_message] for details.
	HumanReviewStatus_ERROR HumanReviewStatus_State = 4
)

// Enum value maps for HumanReviewStatus_State.
var (
	HumanReviewStatus_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "SKIPPED",
		2: "VALIDATION_PASSED",
		3: "IN_PROGRESS",
		4: "ERROR",
	}
	HumanReviewStatus_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"SKIPPED":           1,
		"VALIDATION_PASSED": 2,
		"IN_PROGRESS":       3,
		"ERROR":             4,
	}
)

func (x HumanReviewStatus_State) Enum() *HumanReviewStatus_State {
	p := new(HumanReviewStatus_State)
	*p = x
	return p
}

func (x HumanReviewStatus_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HumanReviewStatus_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_documentai_v1_document_processor_service_proto_enumTypes[0].Descriptor()
}

func (HumanReviewStatus_State) Type() protoreflect.EnumType {
	return &file_google_cloud_documentai_v1_document_processor_service_proto_enumTypes[0]
}

func (x HumanReviewStatus_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HumanReviewStatus_State.Descriptor instead.
func (HumanReviewStatus_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{1, 0}
}

// Possible states of the batch processing operation.
type BatchProcessMetadata_State int32

const (
	// The default value. This value is used if the state is omitted.
	BatchProcessMetadata_STATE_UNSPECIFIED BatchProcessMetadata_State = 0
	// Request operation is waiting for scheduling.
	BatchProcessMetadata_WAITING BatchProcessMetadata_State = 1
	// Request is being processed.
	BatchProcessMetadata_RUNNING BatchProcessMetadata_State = 2
	// The batch processing completed successfully.
	BatchProcessMetadata_SUCCEEDED BatchProcessMetadata_State = 3
	// The batch processing was being cancelled.
	BatchProcessMetadata_CANCELLING BatchProcessMetadata_State = 4
	// The batch processing was cancelled.
	BatchProcessMetadata_CANCELLED BatchProcessMetadata_State = 5
	// The batch processing has failed.
	BatchProcessMetadata_FAILED BatchProcessMetadata_State = 6
)

// Enum value maps for BatchProcessMetadata_State.
var (
	BatchProcessMetadata_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "WAITING",
		2: "RUNNING",
		3: "SUCCEEDED",
		4: "CANCELLING",
		5: "CANCELLED",
		6: "FAILED",
	}
	BatchProcessMetadata_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"WAITING":           1,
		"RUNNING":           2,
		"SUCCEEDED":         3,
		"CANCELLING":        4,
		"CANCELLED":         5,
		"FAILED":            6,
	}
)

func (x BatchProcessMetadata_State) Enum() *BatchProcessMetadata_State {
	p := new(BatchProcessMetadata_State)
	*p = x
	return p
}

func (x BatchProcessMetadata_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BatchProcessMetadata_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_documentai_v1_document_processor_service_proto_enumTypes[1].Descriptor()
}

func (BatchProcessMetadata_State) Type() protoreflect.EnumType {
	return &file_google_cloud_documentai_v1_document_processor_service_proto_enumTypes[1]
}

func (x BatchProcessMetadata_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BatchProcessMetadata_State.Descriptor instead.
func (BatchProcessMetadata_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{5, 0}
}

// The priority level of the human review task.
type ReviewDocumentRequest_Priority int32

const (
	// The default priority level.
	ReviewDocumentRequest_DEFAULT ReviewDocumentRequest_Priority = 0
	// The urgent priority level. The labeling manager should allocate labeler
	// resource to the urgent task queue to respect this priority level.
	ReviewDocumentRequest_URGENT ReviewDocumentRequest_Priority = 1
)

// Enum value maps for ReviewDocumentRequest_Priority.
var (
	ReviewDocumentRequest_Priority_name = map[int32]string{
		0: "DEFAULT",
		1: "URGENT",
	}
	ReviewDocumentRequest_Priority_value = map[string]int32{
		"DEFAULT": 0,
		"URGENT":  1,
	}
)

func (x ReviewDocumentRequest_Priority) Enum() *ReviewDocumentRequest_Priority {
	p := new(ReviewDocumentRequest_Priority)
	*p = x
	return p
}

func (x ReviewDocumentRequest_Priority) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReviewDocumentRequest_Priority) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_documentai_v1_document_processor_service_proto_enumTypes[2].Descriptor()
}

func (ReviewDocumentRequest_Priority) Type() protoreflect.EnumType {
	return &file_google_cloud_documentai_v1_document_processor_service_proto_enumTypes[2]
}

func (x ReviewDocumentRequest_Priority) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReviewDocumentRequest_Priority.Descriptor instead.
func (ReviewDocumentRequest_Priority) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{6, 0}
}

// Request message for the process document method.
type ProcessRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The document payload.
	//
	// Types that are assignable to Source:
	//	*ProcessRequest_InlineDocument
	//	*ProcessRequest_RawDocument
	Source isProcessRequest_Source `protobuf_oneof:"source"`
	// Required. The processor resource name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Whether Human Review feature should be skipped for this request. Default to
	// false.
	SkipHumanReview bool `protobuf:"varint,3,opt,name=skip_human_review,json=skipHumanReview,proto3" json:"skip_human_review,omitempty"`
}

func (x *ProcessRequest) Reset() {
	*x = ProcessRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProcessRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessRequest) ProtoMessage() {}

func (x *ProcessRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessRequest.ProtoReflect.Descriptor instead.
func (*ProcessRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{0}
}

func (m *ProcessRequest) GetSource() isProcessRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *ProcessRequest) GetInlineDocument() *Document {
	if x, ok := x.GetSource().(*ProcessRequest_InlineDocument); ok {
		return x.InlineDocument
	}
	return nil
}

func (x *ProcessRequest) GetRawDocument() *RawDocument {
	if x, ok := x.GetSource().(*ProcessRequest_RawDocument); ok {
		return x.RawDocument
	}
	return nil
}

func (x *ProcessRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ProcessRequest) GetSkipHumanReview() bool {
	if x != nil {
		return x.SkipHumanReview
	}
	return false
}

type isProcessRequest_Source interface {
	isProcessRequest_Source()
}

type ProcessRequest_InlineDocument struct {
	// An inline document proto.
	InlineDocument *Document `protobuf:"bytes,4,opt,name=inline_document,json=inlineDocument,proto3,oneof"`
}

type ProcessRequest_RawDocument struct {
	// A raw document content (bytes).
	RawDocument *RawDocument `protobuf:"bytes,5,opt,name=raw_document,json=rawDocument,proto3,oneof"`
}

func (*ProcessRequest_InlineDocument) isProcessRequest_Source() {}

func (*ProcessRequest_RawDocument) isProcessRequest_Source() {}

// The status of human review on a processed document.
type HumanReviewStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The state of human review on the processing request.
	State HumanReviewStatus_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.documentai.v1.HumanReviewStatus_State" json:"state,omitempty"`
	// A message providing more details about the human review state.
	StateMessage string `protobuf:"bytes,2,opt,name=state_message,json=stateMessage,proto3" json:"state_message,omitempty"`
	// The name of the operation triggered by the processed document. This field
	// is populated only when the [state] is [HUMAN_REVIEW_IN_PROGRESS]. It has
	// the same response type and metadata as the long running operation returned
	// by [ReviewDocument] method.
	HumanReviewOperation string `protobuf:"bytes,3,opt,name=human_review_operation,json=humanReviewOperation,proto3" json:"human_review_operation,omitempty"`
}

func (x *HumanReviewStatus) Reset() {
	*x = HumanReviewStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HumanReviewStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HumanReviewStatus) ProtoMessage() {}

func (x *HumanReviewStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HumanReviewStatus.ProtoReflect.Descriptor instead.
func (*HumanReviewStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{1}
}

func (x *HumanReviewStatus) GetState() HumanReviewStatus_State {
	if x != nil {
		return x.State
	}
	return HumanReviewStatus_STATE_UNSPECIFIED
}

func (x *HumanReviewStatus) GetStateMessage() string {
	if x != nil {
		return x.StateMessage
	}
	return ""
}

func (x *HumanReviewStatus) GetHumanReviewOperation() string {
	if x != nil {
		return x.HumanReviewOperation
	}
	return ""
}

// Response message for the process document method.
type ProcessResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The document payload, will populate fields based on the processor's
	// behavior.
	Document *Document `protobuf:"bytes,1,opt,name=document,proto3" json:"document,omitempty"`
	// The status of human review on the processed document.
	HumanReviewStatus *HumanReviewStatus `protobuf:"bytes,3,opt,name=human_review_status,json=humanReviewStatus,proto3" json:"human_review_status,omitempty"`
}

func (x *ProcessResponse) Reset() {
	*x = ProcessResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProcessResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessResponse) ProtoMessage() {}

func (x *ProcessResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessResponse.ProtoReflect.Descriptor instead.
func (*ProcessResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{2}
}

func (x *ProcessResponse) GetDocument() *Document {
	if x != nil {
		return x.Document
	}
	return nil
}

func (x *ProcessResponse) GetHumanReviewStatus() *HumanReviewStatus {
	if x != nil {
		return x.HumanReviewStatus
	}
	return nil
}

// Request message for batch process document method.
type BatchProcessRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The processor resource name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The input documents for batch process.
	InputDocuments *BatchDocumentsInputConfig `protobuf:"bytes,5,opt,name=input_documents,json=inputDocuments,proto3" json:"input_documents,omitempty"`
	// The overall output config for batch process.
	DocumentOutputConfig *DocumentOutputConfig `protobuf:"bytes,6,opt,name=document_output_config,json=documentOutputConfig,proto3" json:"document_output_config,omitempty"`
	// Whether Human Review feature should be skipped for this request. Default to
	// false.
	SkipHumanReview bool `protobuf:"varint,4,opt,name=skip_human_review,json=skipHumanReview,proto3" json:"skip_human_review,omitempty"`
}

func (x *BatchProcessRequest) Reset() {
	*x = BatchProcessRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchProcessRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchProcessRequest) ProtoMessage() {}

func (x *BatchProcessRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchProcessRequest.ProtoReflect.Descriptor instead.
func (*BatchProcessRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{3}
}

func (x *BatchProcessRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BatchProcessRequest) GetInputDocuments() *BatchDocumentsInputConfig {
	if x != nil {
		return x.InputDocuments
	}
	return nil
}

func (x *BatchProcessRequest) GetDocumentOutputConfig() *DocumentOutputConfig {
	if x != nil {
		return x.DocumentOutputConfig
	}
	return nil
}

func (x *BatchProcessRequest) GetSkipHumanReview() bool {
	if x != nil {
		return x.SkipHumanReview
	}
	return false
}

// Response message for batch process document method.
type BatchProcessResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *BatchProcessResponse) Reset() {
	*x = BatchProcessResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchProcessResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchProcessResponse) ProtoMessage() {}

func (x *BatchProcessResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchProcessResponse.ProtoReflect.Descriptor instead.
func (*BatchProcessResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{4}
}

// The long running operation metadata for batch process method.
type BatchProcessMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The state of the current batch processing.
	State BatchProcessMetadata_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.documentai.v1.BatchProcessMetadata_State" json:"state,omitempty"`
	// A message providing more details about the current state of processing.
	// For example, the error message if the operation is failed.
	StateMessage string `protobuf:"bytes,2,opt,name=state_message,json=stateMessage,proto3" json:"state_message,omitempty"`
	// The creation time of the operation.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The last update time of the operation.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The list of response details of each document.
	IndividualProcessStatuses []*BatchProcessMetadata_IndividualProcessStatus `protobuf:"bytes,5,rep,name=individual_process_statuses,json=individualProcessStatuses,proto3" json:"individual_process_statuses,omitempty"`
}

func (x *BatchProcessMetadata) Reset() {
	*x = BatchProcessMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchProcessMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchProcessMetadata) ProtoMessage() {}

func (x *BatchProcessMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchProcessMetadata.ProtoReflect.Descriptor instead.
func (*BatchProcessMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{5}
}

func (x *BatchProcessMetadata) GetState() BatchProcessMetadata_State {
	if x != nil {
		return x.State
	}
	return BatchProcessMetadata_STATE_UNSPECIFIED
}

func (x *BatchProcessMetadata) GetStateMessage() string {
	if x != nil {
		return x.StateMessage
	}
	return ""
}

func (x *BatchProcessMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *BatchProcessMetadata) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *BatchProcessMetadata) GetIndividualProcessStatuses() []*BatchProcessMetadata_IndividualProcessStatus {
	if x != nil {
		return x.IndividualProcessStatuses
	}
	return nil
}

// Request message for review document method.
type ReviewDocumentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The document payload.
	//
	// Types that are assignable to Source:
	//	*ReviewDocumentRequest_InlineDocument
	Source isReviewDocumentRequest_Source `protobuf_oneof:"source"`
	// Required. The resource name of the HumanReviewConfig that the document will be
	// reviewed with.
	HumanReviewConfig string `protobuf:"bytes,1,opt,name=human_review_config,json=humanReviewConfig,proto3" json:"human_review_config,omitempty"`
	// Whether the validation should be performed on the ad-hoc review request.
	EnableSchemaValidation bool `protobuf:"varint,3,opt,name=enable_schema_validation,json=enableSchemaValidation,proto3" json:"enable_schema_validation,omitempty"`
	// The priority of the human review task.
	Priority ReviewDocumentRequest_Priority `protobuf:"varint,5,opt,name=priority,proto3,enum=google.cloud.documentai.v1.ReviewDocumentRequest_Priority" json:"priority,omitempty"`
}

func (x *ReviewDocumentRequest) Reset() {
	*x = ReviewDocumentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReviewDocumentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReviewDocumentRequest) ProtoMessage() {}

func (x *ReviewDocumentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReviewDocumentRequest.ProtoReflect.Descriptor instead.
func (*ReviewDocumentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{6}
}

func (m *ReviewDocumentRequest) GetSource() isReviewDocumentRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *ReviewDocumentRequest) GetInlineDocument() *Document {
	if x, ok := x.GetSource().(*ReviewDocumentRequest_InlineDocument); ok {
		return x.InlineDocument
	}
	return nil
}

func (x *ReviewDocumentRequest) GetHumanReviewConfig() string {
	if x != nil {
		return x.HumanReviewConfig
	}
	return ""
}

func (x *ReviewDocumentRequest) GetEnableSchemaValidation() bool {
	if x != nil {
		return x.EnableSchemaValidation
	}
	return false
}

func (x *ReviewDocumentRequest) GetPriority() ReviewDocumentRequest_Priority {
	if x != nil {
		return x.Priority
	}
	return ReviewDocumentRequest_DEFAULT
}

type isReviewDocumentRequest_Source interface {
	isReviewDocumentRequest_Source()
}

type ReviewDocumentRequest_InlineDocument struct {
	// An inline document proto.
	InlineDocument *Document `protobuf:"bytes,4,opt,name=inline_document,json=inlineDocument,proto3,oneof"`
}

func (*ReviewDocumentRequest_InlineDocument) isReviewDocumentRequest_Source() {}

// Response message for review document method.
type ReviewDocumentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Cloud Storage uri for the human reviewed document.
	GcsDestination string `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3" json:"gcs_destination,omitempty"`
}

func (x *ReviewDocumentResponse) Reset() {
	*x = ReviewDocumentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReviewDocumentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReviewDocumentResponse) ProtoMessage() {}

func (x *ReviewDocumentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReviewDocumentResponse.ProtoReflect.Descriptor instead.
func (*ReviewDocumentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{7}
}

func (x *ReviewDocumentResponse) GetGcsDestination() string {
	if x != nil {
		return x.GcsDestination
	}
	return ""
}

// The long running operation metadata for review document method.
type ReviewDocumentOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The basic metadata of the long running operation.
	CommonMetadata *CommonOperationMetadata `protobuf:"bytes,5,opt,name=common_metadata,json=commonMetadata,proto3" json:"common_metadata,omitempty"`
}

func (x *ReviewDocumentOperationMetadata) Reset() {
	*x = ReviewDocumentOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReviewDocumentOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReviewDocumentOperationMetadata) ProtoMessage() {}

func (x *ReviewDocumentOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReviewDocumentOperationMetadata.ProtoReflect.Descriptor instead.
func (*ReviewDocumentOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{8}
}

func (x *ReviewDocumentOperationMetadata) GetCommonMetadata() *CommonOperationMetadata {
	if x != nil {
		return x.CommonMetadata
	}
	return nil
}

// The status of a each individual document in the batch process.
type BatchProcessMetadata_IndividualProcessStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The source of the document, same as the [input_gcs_source] field in the
	// request when the batch process started. The batch process is started by
	// take snapshot of that document, since a user can move or change that
	// document during the process.
	InputGcsSource string `protobuf:"bytes,1,opt,name=input_gcs_source,json=inputGcsSource,proto3" json:"input_gcs_source,omitempty"`
	// The status of the processing of the document.
	Status *status.Status `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	// The output_gcs_destination (in the request as 'output_gcs_destination')
	// of the processed document if it was successful, otherwise empty.
	OutputGcsDestination string `protobuf:"bytes,3,opt,name=output_gcs_destination,json=outputGcsDestination,proto3" json:"output_gcs_destination,omitempty"`
	// The status of human review on the processed document.
	HumanReviewStatus *HumanReviewStatus `protobuf:"bytes,5,opt,name=human_review_status,json=humanReviewStatus,proto3" json:"human_review_status,omitempty"`
}

func (x *BatchProcessMetadata_IndividualProcessStatus) Reset() {
	*x = BatchProcessMetadata_IndividualProcessStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchProcessMetadata_IndividualProcessStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchProcessMetadata_IndividualProcessStatus) ProtoMessage() {}

func (x *BatchProcessMetadata_IndividualProcessStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchProcessMetadata_IndividualProcessStatus.ProtoReflect.Descriptor instead.
func (*BatchProcessMetadata_IndividualProcessStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP(), []int{5, 0}
}

func (x *BatchProcessMetadata_IndividualProcessStatus) GetInputGcsSource() string {
	if x != nil {
		return x.InputGcsSource
	}
	return ""
}

func (x *BatchProcessMetadata_IndividualProcessStatus) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *BatchProcessMetadata_IndividualProcessStatus) GetOutputGcsDestination() string {
	if x != nil {
		return x.OutputGcsDestination
	}
	return ""
}

func (x *BatchProcessMetadata_IndividualProcessStatus) GetHumanReviewStatus() *HumanReviewStatus {
	if x != nil {
		return x.HumanReviewStatus
	}
	return nil
}

var File_google_cloud_documentai_v1_document_processor_service_proto protoreflect.FileDescriptor

var file_google_cloud_documentai_v1_document_processor_service_proto_rawDesc = []byte{
	0x0a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69,
	0x2f, 0x76, 0x31, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6f, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f, 0x76,
	0x31, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa6, 0x02, 0x0a, 0x0e,
	0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f,
	0x0a, 0x0f, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52,
	0x0e, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x4c, 0x0a, 0x0c, 0x72, 0x61, 0x77, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x61, 0x77, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x48, 0x00,
	0x52, 0x0b, 0x72, 0x61, 0x77, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3f, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x25, 0x0a, 0x23, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2a,
	0x0a, 0x11, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x5f, 0x72, 0x65, 0x76,
	0x69, 0x65, 0x77, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x73, 0x6b, 0x69, 0x70, 0x48,
	0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x22, 0x99, 0x02, 0x0a, 0x11, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x49, 0x0a, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69,
	0x65, 0x77, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x34, 0x0a, 0x16, 0x68, 0x75,
	0x6d, 0x61, 0x6e, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x68, 0x75, 0x6d, 0x61,
	0x6e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x5e, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0b, 0x0a, 0x07, 0x53, 0x4b, 0x49, 0x50, 0x50, 0x45, 0x44, 0x10, 0x01, 0x12, 0x15, 0x0a,
	0x11, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x41, 0x53, 0x53,
	0x45, 0x44, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52,
	0x45, 0x53, 0x53, 0x10, 0x03, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x04,
	0x22, 0xb2, 0x01, 0x0a, 0x0f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x40, 0x0a, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x08, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x5d, 0x0a, 0x13, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x5f,
	0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x11, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0xca, 0x02, 0x0a, 0x13, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x25, 0x0a, 0x23, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x5e,
	0x0a, 0x0f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0e,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x66,
	0x0a, 0x16, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x14, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2a, 0x0a, 0x11, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x68,
	0x75, 0x6d, 0x61, 0x6e, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0f, 0x73, 0x6b, 0x69, 0x70, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69,
	0x65, 0x77, 0x22, 0x16, 0x0a, 0x14, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x89, 0x06, 0x0a, 0x14, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x4c, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x65, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x88, 0x01, 0x0a, 0x1b, 0x69, 0x6e, 0x64, 0x69, 0x76, 0x69, 0x64, 0x75, 0x61, 0x6c, 0x5f,
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x64, 0x69, 0x76, 0x69, 0x64,
	0x75, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x52, 0x19, 0x69, 0x6e, 0x64, 0x69, 0x76, 0x69, 0x64, 0x75, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x1a, 0x84, 0x02, 0x0a, 0x17,
	0x49, 0x6e, 0x64, 0x69, 0x76, 0x69, 0x64, 0x75, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x28, 0x0a, 0x10, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x5f, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0e, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x2a, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x34, 0x0a,
	0x16, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x67, 0x63, 0x73, 0x5f, 0x64, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x47, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x5d, 0x0a, 0x13, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x5f, 0x72, 0x65, 0x76,
	0x69, 0x65, 0x77, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x75,
	0x6d, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52,
	0x11, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x22, 0x72, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x57, 0x41, 0x49, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12,
	0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09,
	0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x43,
	0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x43,
	0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41,
	0x49, 0x4c, 0x45, 0x44, 0x10, 0x06, 0x22, 0x94, 0x03, 0x0a, 0x15, 0x52, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4f, 0x0a, 0x0f, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x48,
	0x00, 0x52, 0x0e, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x63, 0x0a, 0x13, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x11, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x38, 0x0a, 0x18, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x16, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x56, 0x0a, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x52, 0x08,
	0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x22, 0x23, 0x0a, 0x08, 0x50, 0x72, 0x69, 0x6f,
	0x72, 0x69, 0x74, 0x79, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10,
	0x00, 0x12, 0x0a, 0x0a, 0x06, 0x55, 0x52, 0x47, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x42, 0x08, 0x0a,
	0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4a, 0x04, 0x08, 0x02, 0x10, 0x03, 0x22, 0x41, 0x0a,
	0x16, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x67, 0x63, 0x73, 0x5f, 0x64,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0e, 0x67, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x7f, 0x0a, 0x1f, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x5c, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x32, 0xab, 0x06, 0x0a, 0x18, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xb4,
	0x01, 0x0a, 0x0f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x48, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x3b, 0x22, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xe5, 0x01, 0x0a, 0x15, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x7c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x22, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41,
	0x2c, 0x0a, 0x14, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x14, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xa0, 0x02,
	0x0a, 0x0e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0xbb, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x63, 0x22, 0x5e, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x52,
	0x65, 0x76, 0x69, 0x65, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0x3a, 0x72, 0x65, 0x76,
	0x69, 0x65, 0x77, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x3a, 0x01, 0x2a, 0xda, 0x41,
	0x13, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0xca, 0x41, 0x39, 0x0a, 0x16, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x1f, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x1a, 0x4d, 0xca, 0x41, 0x19, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41,
	0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42,
	0x98, 0x04, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x42, 0x1a, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x69, 0x50, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x01,
	0x5a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e,
	0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x3b, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x49,
	0x2e, 0x56, 0x31, 0xca, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x5c, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x49, 0x5c, 0x56, 0x31,
	0xea, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x49, 0x3a, 0x3a, 0x56, 0x31,
	0xea, 0x41, 0x4d, 0x0a, 0x22, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0xea, 0x41, 0x65, 0x0a, 0x23, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x12, 0x3e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x7d, 0xea, 0x41, 0x7f, 0x0a, 0x2b, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69,
	0x65, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x50, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x7d, 0x2f, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_cloud_documentai_v1_document_processor_service_proto_rawDescOnce sync.Once
	file_google_cloud_documentai_v1_document_processor_service_proto_rawDescData = file_google_cloud_documentai_v1_document_processor_service_proto_rawDesc
)

func file_google_cloud_documentai_v1_document_processor_service_proto_rawDescGZIP() []byte {
	file_google_cloud_documentai_v1_document_processor_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_documentai_v1_document_processor_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_documentai_v1_document_processor_service_proto_rawDescData)
	})
	return file_google_cloud_documentai_v1_document_processor_service_proto_rawDescData
}

var file_google_cloud_documentai_v1_document_processor_service_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_cloud_documentai_v1_document_processor_service_proto_goTypes = []interface{}{
	(HumanReviewStatus_State)(0),                         // 0: google.cloud.documentai.v1.HumanReviewStatus.State
	(BatchProcessMetadata_State)(0),                      // 1: google.cloud.documentai.v1.BatchProcessMetadata.State
	(ReviewDocumentRequest_Priority)(0),                  // 2: google.cloud.documentai.v1.ReviewDocumentRequest.Priority
	(*ProcessRequest)(nil),                               // 3: google.cloud.documentai.v1.ProcessRequest
	(*HumanReviewStatus)(nil),                            // 4: google.cloud.documentai.v1.HumanReviewStatus
	(*ProcessResponse)(nil),                              // 5: google.cloud.documentai.v1.ProcessResponse
	(*BatchProcessRequest)(nil),                          // 6: google.cloud.documentai.v1.BatchProcessRequest
	(*BatchProcessResponse)(nil),                         // 7: google.cloud.documentai.v1.BatchProcessResponse
	(*BatchProcessMetadata)(nil),                         // 8: google.cloud.documentai.v1.BatchProcessMetadata
	(*ReviewDocumentRequest)(nil),                        // 9: google.cloud.documentai.v1.ReviewDocumentRequest
	(*ReviewDocumentResponse)(nil),                       // 10: google.cloud.documentai.v1.ReviewDocumentResponse
	(*ReviewDocumentOperationMetadata)(nil),              // 11: google.cloud.documentai.v1.ReviewDocumentOperationMetadata
	(*BatchProcessMetadata_IndividualProcessStatus)(nil), // 12: google.cloud.documentai.v1.BatchProcessMetadata.IndividualProcessStatus
	(*Document)(nil),                                     // 13: google.cloud.documentai.v1.Document
	(*RawDocument)(nil),                                  // 14: google.cloud.documentai.v1.RawDocument
	(*BatchDocumentsInputConfig)(nil),                    // 15: google.cloud.documentai.v1.BatchDocumentsInputConfig
	(*DocumentOutputConfig)(nil),                         // 16: google.cloud.documentai.v1.DocumentOutputConfig
	(*timestamppb.Timestamp)(nil),                        // 17: google.protobuf.Timestamp
	(*CommonOperationMetadata)(nil),                      // 18: google.cloud.documentai.v1.CommonOperationMetadata
	(*status.Status)(nil),                                // 19: google.rpc.Status
	(*longrunning.Operation)(nil),                        // 20: google.longrunning.Operation
}
var file_google_cloud_documentai_v1_document_processor_service_proto_depIdxs = []int32{
	13, // 0: google.cloud.documentai.v1.ProcessRequest.inline_document:type_name -> google.cloud.documentai.v1.Document
	14, // 1: google.cloud.documentai.v1.ProcessRequest.raw_document:type_name -> google.cloud.documentai.v1.RawDocument
	0,  // 2: google.cloud.documentai.v1.HumanReviewStatus.state:type_name -> google.cloud.documentai.v1.HumanReviewStatus.State
	13, // 3: google.cloud.documentai.v1.ProcessResponse.document:type_name -> google.cloud.documentai.v1.Document
	4,  // 4: google.cloud.documentai.v1.ProcessResponse.human_review_status:type_name -> google.cloud.documentai.v1.HumanReviewStatus
	15, // 5: google.cloud.documentai.v1.BatchProcessRequest.input_documents:type_name -> google.cloud.documentai.v1.BatchDocumentsInputConfig
	16, // 6: google.cloud.documentai.v1.BatchProcessRequest.document_output_config:type_name -> google.cloud.documentai.v1.DocumentOutputConfig
	1,  // 7: google.cloud.documentai.v1.BatchProcessMetadata.state:type_name -> google.cloud.documentai.v1.BatchProcessMetadata.State
	17, // 8: google.cloud.documentai.v1.BatchProcessMetadata.create_time:type_name -> google.protobuf.Timestamp
	17, // 9: google.cloud.documentai.v1.BatchProcessMetadata.update_time:type_name -> google.protobuf.Timestamp
	12, // 10: google.cloud.documentai.v1.BatchProcessMetadata.individual_process_statuses:type_name -> google.cloud.documentai.v1.BatchProcessMetadata.IndividualProcessStatus
	13, // 11: google.cloud.documentai.v1.ReviewDocumentRequest.inline_document:type_name -> google.cloud.documentai.v1.Document
	2,  // 12: google.cloud.documentai.v1.ReviewDocumentRequest.priority:type_name -> google.cloud.documentai.v1.ReviewDocumentRequest.Priority
	18, // 13: google.cloud.documentai.v1.ReviewDocumentOperationMetadata.common_metadata:type_name -> google.cloud.documentai.v1.CommonOperationMetadata
	19, // 14: google.cloud.documentai.v1.BatchProcessMetadata.IndividualProcessStatus.status:type_name -> google.rpc.Status
	4,  // 15: google.cloud.documentai.v1.BatchProcessMetadata.IndividualProcessStatus.human_review_status:type_name -> google.cloud.documentai.v1.HumanReviewStatus
	3,  // 16: google.cloud.documentai.v1.DocumentProcessorService.ProcessDocument:input_type -> google.cloud.documentai.v1.ProcessRequest
	6,  // 17: google.cloud.documentai.v1.DocumentProcessorService.BatchProcessDocuments:input_type -> google.cloud.documentai.v1.BatchProcessRequest
	9,  // 18: google.cloud.documentai.v1.DocumentProcessorService.ReviewDocument:input_type -> google.cloud.documentai.v1.ReviewDocumentRequest
	5,  // 19: google.cloud.documentai.v1.DocumentProcessorService.ProcessDocument:output_type -> google.cloud.documentai.v1.ProcessResponse
	20, // 20: google.cloud.documentai.v1.DocumentProcessorService.BatchProcessDocuments:output_type -> google.longrunning.Operation
	20, // 21: google.cloud.documentai.v1.DocumentProcessorService.ReviewDocument:output_type -> google.longrunning.Operation
	19, // [19:22] is the sub-list for method output_type
	16, // [16:19] is the sub-list for method input_type
	16, // [16:16] is the sub-list for extension type_name
	16, // [16:16] is the sub-list for extension extendee
	0,  // [0:16] is the sub-list for field type_name
}

func init() { file_google_cloud_documentai_v1_document_processor_service_proto_init() }
func file_google_cloud_documentai_v1_document_processor_service_proto_init() {
	if File_google_cloud_documentai_v1_document_processor_service_proto != nil {
		return
	}
	file_google_cloud_documentai_v1_document_proto_init()
	file_google_cloud_documentai_v1_document_io_proto_init()
	file_google_cloud_documentai_v1_operation_metadata_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProcessRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HumanReviewStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProcessResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchProcessRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchProcessResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchProcessMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReviewDocumentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReviewDocumentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReviewDocumentOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchProcessMetadata_IndividualProcessStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*ProcessRequest_InlineDocument)(nil),
		(*ProcessRequest_RawDocument)(nil),
	}
	file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*ReviewDocumentRequest_InlineDocument)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_documentai_v1_document_processor_service_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_documentai_v1_document_processor_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_documentai_v1_document_processor_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_documentai_v1_document_processor_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_documentai_v1_document_processor_service_proto_msgTypes,
	}.Build()
	File_google_cloud_documentai_v1_document_processor_service_proto = out.File
	file_google_cloud_documentai_v1_document_processor_service_proto_rawDesc = nil
	file_google_cloud_documentai_v1_document_processor_service_proto_goTypes = nil
	file_google_cloud_documentai_v1_document_processor_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DocumentProcessorServiceClient is the client API for DocumentProcessorService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DocumentProcessorServiceClient interface {
	// Processes a single document.
	ProcessDocument(ctx context.Context, in *ProcessRequest, opts ...grpc.CallOption) (*ProcessResponse, error)
	// LRO endpoint to batch process many documents. The output is written
	// to Cloud Storage as JSON in the [Document] format.
	BatchProcessDocuments(ctx context.Context, in *BatchProcessRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Send a document for Human Review. The input document should be processed by
	// the specified processor.
	ReviewDocument(ctx context.Context, in *ReviewDocumentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type documentProcessorServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDocumentProcessorServiceClient(cc grpc.ClientConnInterface) DocumentProcessorServiceClient {
	return &documentProcessorServiceClient{cc}
}

func (c *documentProcessorServiceClient) ProcessDocument(ctx context.Context, in *ProcessRequest, opts ...grpc.CallOption) (*ProcessResponse, error) {
	out := new(ProcessResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1.DocumentProcessorService/ProcessDocument", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) BatchProcessDocuments(ctx context.Context, in *BatchProcessRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1.DocumentProcessorService/BatchProcessDocuments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentProcessorServiceClient) ReviewDocument(ctx context.Context, in *ReviewDocumentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.documentai.v1.DocumentProcessorService/ReviewDocument", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DocumentProcessorServiceServer is the server API for DocumentProcessorService service.
type DocumentProcessorServiceServer interface {
	// Processes a single document.
	ProcessDocument(context.Context, *ProcessRequest) (*ProcessResponse, error)
	// LRO endpoint to batch process many documents. The output is written
	// to Cloud Storage as JSON in the [Document] format.
	BatchProcessDocuments(context.Context, *BatchProcessRequest) (*longrunning.Operation, error)
	// Send a document for Human Review. The input document should be processed by
	// the specified processor.
	ReviewDocument(context.Context, *ReviewDocumentRequest) (*longrunning.Operation, error)
}

// UnimplementedDocumentProcessorServiceServer can be embedded to have forward compatible implementations.
type UnimplementedDocumentProcessorServiceServer struct {
}

func (*UnimplementedDocumentProcessorServiceServer) ProcessDocument(context.Context, *ProcessRequest) (*ProcessResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ProcessDocument not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) BatchProcessDocuments(context.Context, *BatchProcessRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method BatchProcessDocuments not implemented")
}
func (*UnimplementedDocumentProcessorServiceServer) ReviewDocument(context.Context, *ReviewDocumentRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ReviewDocument not implemented")
}

func RegisterDocumentProcessorServiceServer(s *grpc.Server, srv DocumentProcessorServiceServer) {
	s.RegisterService(&_DocumentProcessorService_serviceDesc, srv)
}

func _DocumentProcessorService_ProcessDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ProcessRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).ProcessDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1.DocumentProcessorService/ProcessDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).ProcessDocument(ctx, req.(*ProcessRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_BatchProcessDocuments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchProcessRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).BatchProcessDocuments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1.DocumentProcessorService/BatchProcessDocuments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).BatchProcessDocuments(ctx, req.(*BatchProcessRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentProcessorService_ReviewDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReviewDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentProcessorServiceServer).ReviewDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.documentai.v1.DocumentProcessorService/ReviewDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentProcessorServiceServer).ReviewDocument(ctx, req.(*ReviewDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DocumentProcessorService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.documentai.v1.DocumentProcessorService",
	HandlerType: (*DocumentProcessorServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ProcessDocument",
			Handler:    _DocumentProcessorService_ProcessDocument_Handler,
		},
		{
			MethodName: "BatchProcessDocuments",
			Handler:    _DocumentProcessorService_BatchProcessDocuments_Handler,
		},
		{
			MethodName: "ReviewDocument",
			Handler:    _DocumentProcessorService_ReviewDocument_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/documentai/v1/document_processor_service.proto",
}
