;;; GNU Guix --- Functional package management for GNU
;;; Copyright © 2015, 2016, 2017, 2018, 2019, 2020, 2021, 2022 Ricardo Wurmus <rekado@elephly.net>
;;; Copyright © 2015 Andreas Enge <andreas@enge.fr>
;;; Copyright © 2015, 2016 Pjotr Prins <pjotr.guix@thebird.nl>
;;; Copyright © 2016, 2017 Ben Woodcroft <donttrustben@gmail.com>
;;; Copyright © 2016, 2017, 2018, 2020, 2021 Roel Janssen <roel@gnu.org>
;;; Copyright © 2017, 2018, 2019, 2020 Tobias Geerinckx-Rice <me@tobias.gr>
;;; Copyright © 2017 Raoul Bonnal <ilpuccio.febo@gmail.com>
;;; Copyright © 2018 Vijayalakshmi Vedantham <vijimay12@gmail.com>
;;; Copyright © 2018 Sahithi Yarlagadda <sahi@swecha.net>
;;; Copyright © 2018 Sandeep Subramanian <sandeepsubramanian94@gmail.com>
;;; Copyright © 2018 Charlie Ritter <chewzeirta@posteo.net>
;;; Copyright © 2018 Konrad Hinsen <konrad.hinsen@fastmail.net>
;;; Copyright © 2018, 2020, 2021, 2022 Mădălin Ionel Patrașcu <madalinionel.patrascu@mdc-berlin.de>
;;; Copyright © 2018 Laura Lazzati <laura.lazzati.15@gmail.com>
;;; Copyright © 2018 Leo Famulari <leo@famulari.name>
;;; Copyright © 2018 Marius Bakke <mbakke@fastmail.com>
;;; Copyright © 2018, 2019 Brett Gilio <brettg@gnu.org>
;;; Copyright © 2019 Nicolò Balzarotti <anothersms@gmail.com>
;;; Copyright © 2019, 2020, 2021 Wiktor Żelazny <wzelazny@vurv.cz>
;;; Copyright © 2019 Arne Babenhauserheide <arne_bab@web.de>
;;; Copyright © 2019, 2020 Efraim Flashner <efraim@flashner.co.il>
;;; Copyright © 2020 Todor Kondić <tk.code@protonmail.com>
;;; Copyright © 2020 Danjela Lura <danielaluraa@gmail.com>
;;; Copyright © 2020 Naga Malleswari <nagamalli@riseup.net>
;;; Copyright © 2020 Eric Brown <ecbrown@ericcbrown.com>
;;; Copyright © 2020 Peter Lo <peterloleungyau@gmail.com>
;;; Copyright © 2020 Rafael Luque Leiva <rafael.luque@osoco.es>
;;; Copyright © 2020, 2021 Lars-Dominik Braun <ldb@leibniz-psychology.org>
;;; Copyright © 2020 Vinicius Monego <monego@posteo.net>
;;; Copyright © 2020 Antoine Côté <antoine.cote@posteo.net>
;;; Copyright © 2020 Arun Isaac <arunisaac@systemreboot.net>
;;; Copyright © 2020 Magali Lemes <magalilemes00@gmail.com>
;;; Copyright © 2020, 2021, 2022 Simon Tournier <zimon.toutoune@gmail.com>
;;; Copyright © 2020 Aniket Patil <aniket112.patil@gmail.com>
;;; Copyright © 2021 Marcel Schilling <marcel.schilling@uni-luebeck.de>
;;; Copyright © 2021 Guillaume Le Vaillant <glv@posteo.net>
;;; Copyright © 2022 Navid Afkhami <navid.afkhami@mdc-berlin.de>
;;; Copyright © 2022 Greg Hogan <code@greghogan.com>
;;;
;;; This file is part of GNU Guix.
;;;
;;; GNU Guix is free software; you can redistribute it and/or modify it
;;; under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 3 of the License, or (at
;;; your option) any later version.
;;;
;;; GNU Guix is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Guix.  If not, see <http://www.gnu.org/licenses/>.

(define-module (gnu packages cran)
  #:use-module ((guix licenses) #:prefix license:)
  #:use-module (guix packages)
  #:use-module (guix download)
  #:use-module (guix gexp)
  #:use-module (guix git-download)
  #:use-module (guix utils)
  #:use-module (guix build-system gnu)
  #:use-module (guix build-system r)
  #:use-module (gnu packages)
  #:use-module (gnu packages algebra)
  #:use-module (gnu packages autotools)
  #:use-module (gnu packages base)
  #:use-module (gnu packages bioinformatics)
  #:use-module (gnu packages c)
  #:use-module (gnu packages compression)
  #:use-module (gnu packages crypto)
  #:use-module (gnu packages curl)
  #:use-module (gnu packages databases)
  #:use-module (gnu packages fontutils)
  #:use-module (gnu packages fribidi)
  #:use-module (gnu packages gcc)
  #:use-module (gnu packages geo)
  #:use-module (gnu packages ghostscript)
  #:use-module (gnu packages gl)
  #:use-module (gnu packages gnome)
  #:use-module (gnu packages graph)
  #:use-module (gnu packages gtk)
  #:use-module (gnu packages haskell-xyz)
  #:use-module (gnu packages icu4c)
  #:use-module (gnu packages image)
  #:use-module (gnu packages imagemagick)
  #:use-module (gnu packages java)
  #:use-module (gnu packages javascript)
  #:use-module (gnu packages libevent)
  #:use-module (gnu packages machine-learning)
  #:use-module (gnu packages maths)
  #:use-module (gnu packages mpi)
  #:use-module (gnu packages multiprecision)
  #:use-module (gnu packages networking)
  #:use-module (gnu packages node)
  #:use-module (gnu packages pcre)
  #:use-module (gnu packages pdf)
  #:use-module (gnu packages perl)
  #:use-module (gnu packages pkg-config)
  #:use-module (gnu packages pulseaudio)  ;libsndfile
  #:use-module (gnu packages protobuf)
  #:use-module (gnu packages python)
  #:use-module (gnu packages python-xyz)
  #:use-module (gnu packages sqlite)
  #:use-module (gnu packages statistics)
  #:use-module (gnu packages tbb)
  #:use-module (gnu packages tcl)
  #:use-module (gnu packages tex)
  #:use-module (gnu packages textutils)
  #:use-module (gnu packages tls)
  #:use-module (gnu packages uglifyjs)
  #:use-module (gnu packages version-control)
  #:use-module (gnu packages video)
  #:use-module (gnu packages web)
  #:use-module (gnu packages xml)
  #:use-module (gnu packages xorg))

(define-public r-aer
  (package
    (name "r-aer")
    (version "1.2-10")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "AER" version))
              (sha256
               (base32
                "1p6vxr0220lim5i4gwsvphqrfd65zbs8h3qydz4gipca9asmy2k5"))))
    (properties `((upstream-name . "AER")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-car
           r-formula
           r-lmtest
           r-sandwich
           r-survival
           r-zoo))
    (home-page "https://cran.r-project.org/package=AER")
    (synopsis "Applied econometrics with R")
    (description
     "This package provides functions, data sets, examples, demos, and
vignettes for the book Christian Kleiber and Achim Zeileis (2008), Applied
Econometrics with R, Springer-Verlag, New York.  ISBN 978-0-387-77316-2. (See
the vignette \"AER\" for a package overview.)")
    ;; Either version of the GPL
    (license (list license:gpl2 license:gpl3))))

(define-public r-afpt
  (package
    (name "r-afpt")
    (version "1.1.0.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "afpt" version))
              (sha256
               (base32
                "1z0r4r7prxbhadmkdg6345g0b5vq9dqyyw9hh3fpad9zkc7k6xbc"))))
    (properties `((upstream-name . "afpt")))
    (build-system r-build-system)
    (native-inputs (list r-knitr))
    (home-page "https://github.com/MarcoKlH/afpt-r/")
    (synopsis "Tools for modelling of animal flight performance")
    (description
     "This package allows estimation and modelling of flight costs in animal
(vertebrate) flight, implementing the aerodynamic power model.  Flight
performance is estimated based on basic morphological measurements such as
body mass, wingspan and wing area.  @code{Afpt} can be used to make
predictions on how animals should adjust their flight behaviour and wingbeat
kinematics to varying flight conditions.")
    (license license:gpl3+)))

(define-public r-aod
  (package
    (name "r-aod")
    (version "1.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "aod" version))
       (sha256
        (base32 "0p2i536s0aa54rah1l465g77k2ldn6jm6s25y9vc06mk29xvx1cv"))))
    (properties `((upstream-name . "aod")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=aod")
    (synopsis "Analysis of overdispersed data")
    (description
     "This package provides a set of functions to analyze overdispersed counts
or proportions.  Most of the methods are already available elsewhere but are
scattered in different packages.  The proposed functions should be considered
as complements to more sophisticated methods such as @dfn{generalized
estimating equations} (GEE) or @dfn{generalized linear mixed effect
models} (GLMM).")
    (license license:gpl2+)))

(define-public r-brio
  (package
    (name "r-brio")
    (version "1.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "brio" version))
       (sha256
        (base32
         "1inwzvlf6zj6gi47gd0byzqv02qajb3l475z8pjvx2b1hm0r1a7a"))))
    (properties `((upstream-name . "brio")))
    (build-system r-build-system)
    (home-page "https://github.com/r-lib/brio")
    (synopsis "Basic R input output")
    (description
     "This package provides functions to handle basic input output.  These
functions always read and write UTF-8 (8-bit Unicode Transformation Format)
files and provide more explicit control over line endings.")
    (license license:expat)))

(define-public r-ca
  (package
    (name "r-ca")
    (version "0.71.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ca" version))
              (sha256
               (base32
                "095lk7p2b9835hc3a03c4019wg0baf0dhz6c2vqpaq1m9k4jy304"))))
    (properties `((upstream-name . "ca")))
    (build-system r-build-system)
    (home-page "http://www.carme-n.org/")
    (synopsis "Simple, multiple and joint correspondence analysis")
    (description
     "This is a package for computation and visualization of simple,
multiple and joint correspondence analysis.")
    ;; Any version of the GPL
    (license license:gpl3+)))

(define-public r-cachem
  (package
    (name "r-cachem")
    (version "1.0.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cachem" version))
       (sha256
        (base32
         "0r0q5w8lsxak46crnkbi739qzys90hlw7cqqqhv99xzkpkvm554s"))))
    (properties `((upstream-name . "cachem")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-fastmap r-rlang))
    (home-page "https://cachem.r-lib.org/")
    (synopsis "Cache R objects with automatic pruning")
    (description
     "This package provides key-value stores with automatic pruning.  Caches
can limit either their total size or the age of the oldest object (or both),
automatically pruning objects to maintain the constraints.")
    (license license:expat)))

(define-public r-collections
  (package
    (name "r-collections")
    (version "0.3.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "collections" version))
       (sha256
        (base32 "19y7nds67700zy6354s1i0aglgjylzv65psccz5x3ih8f48sakr3"))))
    (properties `((upstream-name . "collections")))
    (build-system r-build-system)
    (home-page "https://github.com/randy3k/collections")
    (synopsis "High performance container data types")
    (description
     "This package provides high performance container data types such as
queues, stacks, deques, dicts and ordered dicts.")
    (license license:expat)))

(define-public r-curry
  (package
    (name "r-curry")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "curry" version))
       (sha256
        (base32
         "1ps9hvbnb02m0b8hlw4admwbziyjvswj08ldi2dk3ymnrpawcc29"))))
    (properties `((upstream-name . "curry")))
    (build-system r-build-system)
    (home-page "https://github.com/thomasp85/curry")
    (synopsis "Partial function application")
    (description
     "Partial application is the process of reducing the arity of a function
by fixing one or more arguments, thus creating a new function lacking the
fixed arguments.  The @code{curry} package provides three different ways of
performing partial function application by fixing arguments from either end of
the argument list (currying and tail currying) or by fixing multiple named
arguments (partial application).  This package provides this functionality
through the @code{%<%}, @code{%-<%}, and @code{%><%} operators which allows
for a programming style comparable to modern functional languages.  Compared
to other implementations such a @code{purrr::partial()} the operators in
@code{curry} composes functions with named arguments, aiding in autocomplete
etc.")
    (license license:gpl2+)))

(define-public r-datawizard
  (package
    (name "r-datawizard")
    (version "0.6.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "datawizard" version))
       (sha256
        (base32
         "0cn9ixljf4l333d401pz5rcwqkzpl6d90as153j1wrkz9rjzm6i7"))))
    (properties `((upstream-name . "datawizard")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-insight))
    (native-inputs
     (list r-knitr))
    (home-page "https://easystats.github.io/datawizard/")
    (synopsis "Easy data wrangling")
    (description
     "This package provides a lightweight package to easily manipulate,
clean, transform, and prepare your data for analysis.  It also forms the data
wrangling backend for the packages in the @code{easystats} ecosystem.")
    (license license:gpl3)))

(define-public r-dbscan
  (package
    (name "r-dbscan")
    (version "1.1-11")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dbscan" version))
       (sha256
        (base32 "0bz66lvvg7290c5260ph92k4r7adgisbx3vml9096qhjwrkqwjgh"))))
    (properties `((upstream-name . "dbscan")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/mhahsler/dbscan")
    (synopsis "Density-based spatial clustering of applications with noise")
    (description
     "This package provides a fast reimplementation of several density-based
algorithms of the DBSCAN family.  It includes the clustering algorithms DBSCAN
(density-based spatial clustering of applications with noise) and
@dfn{hierarchical DBSCAN} (HDBSCAN), the ordering algorithm @dfn{ordering
points to identify the clustering structure} (OPTICS), shared nearest neighbor
clustering, and the outlier detection algorithms @dfn{local outlier
factor} (LOF) and @dfn{global-local outlier score from hierarchies} (GLOSH).
The implementations use the kd-tree data structure for faster k-nearest
neighbor search.  An R interface to fast kNN and fixed-radius NN search is
also provided.")
    (license license:gpl2+)))

(define-public r-diffobj
  (package
    (name "r-diffobj")
    (version "0.3.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "diffobj" version))
       (sha256
        (base32
         "0q6gwd9pqh41f6j5p9jl92aji4p8kx9inffpha93d7jc3ndsfq6q"))))
    (properties `((upstream-name . "diffobj")))
    (build-system r-build-system)
    (propagated-inputs (list r-crayon))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/brodieG/diffobj")
    (synopsis "Diffs for R objects")
    (description
     "Generate a colorized diff of two R objects for an intuitive
visualization of their differences.")
    (license license:gpl2+)))

(define-public r-dirichletreg
  (package
    (name "r-dirichletreg")
    (version "0.7-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "DirichletReg" version))
       (sha256
        (base32 "1ql5mwb7zb06y9j6inrlngq7c15as4j17wd8kc71fxs0a2jdj7xi"))))
    (properties `((upstream-name . "DirichletReg")))
    (build-system r-build-system)
    (propagated-inputs (list r-formula r-maxlik))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=DirichletReg")
    (synopsis "Dirichlet regression")
    (description "This package implements Dirichlet regression models.")
    (license license:gpl2+)))

(define-public r-dixontest
  (package
    (name "r-dixontest")
    (version "1.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dixonTest" version))
       (sha256
        (base32 "0gz39s1z987bg56vwrpcs14wzyf7p07s7l7z9napz0i38564wsdq"))))
    (properties `((upstream-name . "dixonTest")))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/package=dixonTest")
    (synopsis "Dixon's ratio test for outlier detection")
    (description
     "For outlier detection in small and normally distributed samples the ratio
test of Dixon (Q-test) can be used.  Density, distribution function, quantile
function and random generation for Dixon's ratio statistics are provided as
wrapper functions.  The core applies McBane's Fortran functions that use
Gaussian quadrature for a numerical solution.")
    (license license:gpl3)))

(define-public r-dmwr2
  (package
    (name "r-dmwr2")
    (version "0.0.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "DMwR2" version))
              (sha256
               (base32
                "1vzfbz2k05j8r2hpig3d2grb99rnnh2s1sviii3prcyqicxfh0i9"))))
    (properties `((upstream-name . "DMwR2")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-class
           r-dbi
           r-dplyr
           r-quantmod
           r-readr
           r-rpart
           r-xts
           r-zoo))
    (home-page "https://github.com/ltorgo/DMwR2")
    (synopsis
     "Functions and data for the second edition of \"Data Mining with R\"")
    (description
     "This package provides functions and data accompanying the second
edition of the book \"Data Mining with R, learning with case studies\"
by Luis Torgo, published by CRC Press.")
    (license license:gpl2+)))

(define-public r-emdist
  (package
    (name "r-emdist")
    (version "0.3-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "emdist" version))
       (sha256
        (base32
         "05mv6xhm15b0mq9kzyiblkb14bdqmjrwl64ghdk66il0w8i7p6nh"))))
    (properties `((upstream-name . "emdist")))
    (build-system r-build-system)
    (home-page "http://www.rforge.net/emd")
    (synopsis "Earth mover's distance")
    (description
     "This package provides tools to calculate the Earth Mover's
Distance (EMD).")
    (license license:expat)))

(define-public r-ggalt
  (package
    (name "r-ggalt")
    (version "0.4.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ggalt" version))
              (sha256
               (base32
                "0ssa274d41vhd6crzjz7jqzbwgnjimxwxl23p2cx35aqs5wdfjpc"))))
    (properties `((upstream-name . "ggalt")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ash
           r-dplyr
           r-extrafont
           r-ggplot2
           r-gtable
           r-kernsmooth
           r-maps
           r-mass
           r-plotly
           r-proj4
           r-rcolorbrewer
           r-scales
           r-tibble))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/hrbrmstr/ggalt")
    (synopsis
     "Geometries, coordinate systems, fonts and more for ggplot2")
    (description
     "This package provides a compendium of new geometries, coordinate systems,
statistical transformations, scales and fonts for ggplot2, including splines,
1d and 2d densities, univariate average shifted histograms, a new map
coordinate system based on the PROJ.4-library along with
@code{geom_cartogram()} that mimics the original functionality of
@code{geom_map()}, formatters for \"bytes\", a @code{stat_stepribbon()}
function, increased @code{plotly} compatibility and the @code{StateFace} open
source font ProPublica.  Further new functionality includes lollipop charts,
dumbbell charts, the ability to encircle points and coordinate-system-based
text annotations.")
    (license license:agpl3)))

(define-public r-glmpca
  (package
    (name "r-glmpca")
    (version "0.2.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "glmpca" version))
              (sha256
               (base32
                "02xjf0gg52925hw9nw2j0znfmzfzfwbv0fxjl9d2fy9j63drr2h4"))))
    (properties `((upstream-name . "glmpca")))
    (build-system r-build-system)
    (propagated-inputs (list r-mass))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/willtownes/glmpca")
    (synopsis "Dimension Reduction of Non-Normally Distributed Data")
    (description
     "This package implements a generalized version of principal components
analysis (GLM-PCA) for dimension reduction of non-normally distributed data
such as counts or binary matrices.")
    (license license:lgpl3+)))

(define-public r-googledrive
  (package
    (name "r-googledrive")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "googledrive" version))
       (sha256
        (base32
         "09jsiknzyfgxd0nzdr3wrrjw24allch2x74h96qg8vh8dad4cp30"))))
    (properties `((upstream-name . "googledrive")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-gargle
           r-glue
           r-httr
           r-jsonlite
           r-lifecycle
           r-magrittr
           r-pillar
           r-purrr
           r-rlang
           r-tibble
           r-uuid
           r-vctrs
           r-withr))
    (native-inputs
     (list r-knitr))
    (home-page "https://googledrive.tidyverse.org")
    (synopsis "Interface to Google Drive")
    (description "This package lets you manage Google Drive files from R.")
    (license license:expat)))

(define-public r-googlevis
  (package
    (name "r-googlevis")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "googleVis" version))
       (sha256
        (base32 "1s82xcs6zrlmnhay764bspzwvabfyi35nq6fwdrrk3v79q13c5jz"))))
    (properties `((upstream-name . "googleVis")))
    (build-system r-build-system)
    (propagated-inputs (list r-jsonlite))
    (native-inputs (list r-knitr))
    (home-page "https://mages.github.io/googleVis/")
    (synopsis "R interface to Google Charts")
    (description
     "The @code{googleVis} package provides an interface between R and the Google
Charts API.  Google Charts offer interactive charts which can be embedded into
web pages.  The functions of the @code{googleVis} package allow the user to
visualise data stored in R data frames with Google Charts without uploading
the data to Google.  The output of a @code{googleVis} function is HTML code
that contains the data and references to JavaScript functions hosted by
Google.  @code{googleVis} makes use of the internal R HTTP server to display
the output locally.")
    (license license:gpl2+)))

(define-public r-gson
  (package
    (name "r-gson")
    (version "0.0.9")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "gson" version))
              (sha256
               (base32
                "065ify3i7zqwi7h5jzr7kdgr358kwgw6xrkvvmrznbl7s9f7d57n"))))
    (properties `((upstream-name . "gson")))
    (build-system r-build-system)
    (propagated-inputs (list r-jsonlite r-rlang r-tidyr))
    (home-page "https://cran.r-project.org/package=gson")
    (synopsis "Base Class and Methods for 'gson' Format")
    (description
     "This packages proposes a new file format named @code{gson} for storing
gene set and related information, and provides read, write and other utilities
to process this file format.")
    (license license:artistic2.0)))

(define-public r-guix-install
  (package
    (name "r-guix-install")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "guix.install" version))
       (sha256
        (base32 "0s3wb5781yc43c9zwrn7i87zcbrlx7xr0ms0v9hvgs7qsv02id9j"))))
    (properties `((upstream-name . "guix.install")))
    (build-system r-build-system)
    (propagated-inputs (list r-runit))
    (home-page "https://github.com/BIMSBbioinfo/guix.install")
    (synopsis "Install R packages with GNU Guix")
    (description
     "This R package provides a single procedure @code{guix.install()}, which
allows users to install R packages via Guix right from within their running R
session.  If the requested R package does not exist in Guix at this time, the
package and all its missing dependencies will be imported recursively and the
generated package definitions will be written to @file{~/.Rguix/packages.scm}.
This record of imported packages can be used later to reproduce the
environment, and to add the packages in question to a proper Guix channel (or
Guix itself).  @code{guix.install()} not only supports installing packages
from CRAN, but also from Bioconductor or even arbitrary git or mercurial
repositories, replacing the need for installation via @code{devtools}.")
    (license license:gpl3+)))

(define-public r-ids
  (package
    (name "r-ids")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ids" version))
       (sha256
        (base32
         "1s6ga94gds5ydr9f8qbjfgfpg2dvbnkcrlybqlb33hk3c0c2l8dn"))))
    (properties `((upstream-name . "ids")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-openssl r-uuid))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/richfitz/ids")
    (synopsis "Generate random identifiers")
    (description
     "This package lets you generate random or human readable and
pronounceable identifiers.")
    (license license:expat)))

(define-public r-googlesheets4
  (package
    (name "r-googlesheets4")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "googlesheets4" version))
       (sha256
        (base32
         "14b5lzn6vjn72mw7vf3lzm2ppbjf0wr0n6sw0v5r6h4lk37cnki8"))))
    (properties `((upstream-name . "googlesheets4")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cellranger
           r-cli
           r-curl
           r-gargle
           r-glue
           r-googledrive
           r-httr
           r-ids
           r-magrittr
           r-purrr
           r-rematch2
           r-rlang
           r-tibble
           r-vctrs))
    (home-page "https://github.com/tidyverse/googlesheets4")
    (synopsis "Access Google Sheets using the Sheets API V4")
    (description
     "This package lets you interact with Google Sheets through the
@url{https://developers.google.com/sheets/api,Sheets API v4}.  This package
can read and write both the metadata and the cell data in a Sheet.")
    (license license:expat)))

(define-public r-proj4
  (package
    (name "r-proj4")
    (version "1.0-11")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "proj4" version))
              (sha256
               (base32
                "07fil52jswbg2h807cd82m2wlm5j2fb891ifri9ms037099qdwf5"))))
    (properties `((upstream-name . "proj4")))
    (build-system r-build-system)
    (inputs (list proj-7 zlib))
    (native-inputs (list pkg-config))
    (home-page "http://www.rforge.net/proj4/")
    (synopsis "Simple interface to the PROJ.4 cartographic projections library")
    (description
     "This package provides a simple interface to lat/long projection and
datum transformation of the PROJ.4 cartographic projections library.  It
allows transformation of geographic coordinates from one projection and/or
datum to another.")
    (license license:gpl2)))

(define-public r-rorcid
  (package
    (name "r-rorcid")
    (version "0.7.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "rorcid" version))
              (sha256
               (base32
                "1d0s5w48ksyj152nc4xq5w0nsimab8jc5fgspdwnbas2g8a52igr"))))
    (properties `((upstream-name . "rorcid")))
    (build-system r-build-system)
    (propagated-inputs (list r-crul
                             r-data-table
                             r-fauxpas
                             r-httr
                             r-jsonlite
                             r-tibble
                             r-xml2))
    (home-page "https://github.com/ropensci/rorcid")
    (synopsis "Interface to the @url{Orcid.org, https://orcid.org} API")
    (description
     "This package provides an API for @url{Orcid.org, https://orcid.org}.
Functions include searching for people, searching by DOI, or searching by
Orcid ID.")
    (license license:expat)))

(define-public r-waldo
  (package
    (name "r-waldo")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "waldo" version))
       (sha256
        (base32
         "1aky28rn70l24s0sygl36267cf7hjzhchagsz26abfxwr7p8kvjp"))))
    (properties `((upstream-name . "waldo")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-diffobj
           r-fansi
           r-glue
           r-rematch2
           r-rlang
           r-tibble))
    (home-page "https://github.com/r-lib/waldo")
    (synopsis "Find differences between R objects")
    (description
     "Compare complex R objects and reveal the key differences.  This package
was designed particularly for use in testing packages where being able to
quickly isolate key differences makes understanding test failures much
easier.")
    (license license:expat)))

(define-public r-rticles
  (package
    (name "r-rticles")
    (version "0.24")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rticles" version))
       (sha256
        (base32
         "05idvyfjfa4f244km4sxripg8gndvganx5s0ch00xbi4cqnlr2pq"))))
    (properties `((upstream-name . "rticles")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-knitr r-rmarkdown r-tinytex r-xfun r-yaml))
    (home-page "https://github.com/rstudio/rticles")
    (synopsis "Article formats for R Markdown")
    (description
     "This package provides a suite of custom R Markdown formats and templates
for authoring journal articles and conference submissions.")
    (license license:gpl3)))

(define-public r-babelwhale
  (package
    (name "r-babelwhale")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "babelwhale" version))
       (sha256
        (base32 "01l8vwyz3bx0iks6cjs5y9ifdsnc1p1yqp4i0kzqd1gjhycizv6y"))))
    (properties `((upstream-name . "babelwhale")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-crayon
           r-digest
           r-dplyr
           r-dynutils
           r-fs
           r-glue
           r-processx
           r-purrr))
    (home-page "https://github.com/dynverse/babelwhale")
    (synopsis "Talking to Docker and Singularity containers")
    (description
     "This package provides a unified interface to interact with Docker and
Singularity containers.  You can execute a command inside a container, mount a
volume or copy a file.")
    (license license:expat)))

(define-public r-benchmarkmedata
  (package
    (name "r-benchmarkmedata")
    (version "1.0.4")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "benchmarkmeData" version))
              (sha256
               (base32
                "1n4vjkagqlm6kw2hilf4gjfcdjad0bcg652j9nl2ygbq3kdnh1vf"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr r-tibble))
    (home-page "https://github.com/csgillespie/benchmarkme-data")
    (synopsis "Data set for the @code{benchmarkme} package")
    (description "This package contains the data set for the crowd-sourced
benchmarks from running the @code{benchmarkme} package.")
    (license license:gpl2+)))

(define-public r-benchmarkme
  (package
    (name "r-benchmarkme")
    (version "1.0.8")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "benchmarkme" version))
              (sha256
               (base32
                "0qaz8wy3n08k9lr8qljk5i8z8db18scbdc8m734aymd307h00w8x"))))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr))
    (propagated-inputs
     (list r-benchmarkmedata
           r-doparallel
           r-dplyr
           r-foreach
           r-httr
           r-matrix
           r-stringr
           r-tibble))
    (home-page "https://csgillespie.github.io/benchmarkme/")
    (synopsis "Crowd-sourced system benchmarks")
    (description "This package provides functionality to benchmark your CPU
and compare against other CPUs.  Also provides functions for obtaining system
specifications, such as RAM, CPU type, and R version.")
    (license license:gpl2+)))

(define-public r-bezier
  (package
    (name "r-bezier")
    (version "1.1.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "bezier" version))
              (sha256
               (base32
                "1vw5128v8h973xwa1fdm9cw2jvrldj87nd55lddlp3qsz3ag4br6"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/bezier/")
    (synopsis "Bezier curve and spline toolkit")
    (description
     "This package is a toolkit for working with Bezier curves and splines.
The package provides functions for point generation, arc length estimation,
degree elevation and curve fitting.")
    (license license:gpl2+)))

(define-public r-bwstest
  (package
    (name "r-bwstest")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "BWStest" version))
       (sha256
        (base32 "02amzlfprmw5pyis0dg0kg0x8xqh50a4vfdcxxmklrzik3b1vzzs"))))
    (properties `((upstream-name . "BWStest")))
    (build-system r-build-system)
    (propagated-inputs (list r-memoise r-rcpp))
    (home-page "https://github.com/shabbychef/BWStest")
    (synopsis "Baumgartner Weiss Schindler Test of equal distributions")
    (description
     "This package performs the Baumgartner-Weiss-Schindler two-sample test of
equal probability distributions (doi:10.2307/2533862).  It also performs
similar rank-based tests for equal probability distributions due to Neuhauser
(doi:10.1080/10485250108832874) and Murakami
(doi:10.1080/00949655.2010.551516).")
    (license license:lgpl3)))

(define-public r-v8
  (package
    (name "r-v8")
    (version "4.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "V8" version))
       (sha256
        (base32
         "1w1zihmhrygn2i674wimbv7xqjnwlld4x3ndvh5dl4cdg7s1m24r"))))
    (properties `((upstream-name . "V8")))
    (build-system r-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'find-v8
           (lambda* (#:key inputs #:allow-other-keys)
             (substitute* "configure"
               (("^PKG_LIBS=.*")
                (string-append "PKG_LIBS="
                               (assoc-ref inputs "libnode")
                               "/lib/libnode.so.64\n")))
             (setenv "INCLUDE_DIR"
                     (string-append
                      (assoc-ref inputs "libnode")
                      "/include/node"))
             (setenv "LIB_DIR"
                     (string-append
                      (assoc-ref inputs "libnode") "/lib")))))))
    (inputs
     (list libnode zlib))
    (propagated-inputs
     (list r-curl r-jsonlite r-rcpp))
    (native-inputs
     (list r-knitr))
    (home-page "https://jeroen.cran.dev/V8")
    (synopsis "Embedded JavaScript and WebAssembly engine for R")
    (description
     "This package provides an R interface to V8: Google's JavaScript and
WebAssembly engine.")
    (license license:expat)))

(define-public r-rvenn
  (package
    (name "r-rvenn")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RVenn" version))
       (sha256
        (base32
         "016m00xv59lkwm2is32v5nr4lw5a1ymdnz34r3ffflcv9bfrc6n4"))))
    (properties `((upstream-name . "RVenn")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggforce
           r-ggplot2
           r-magrittr
           r-pheatmap
           r-purrr
           r-rlang
           r-vegan))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=RVenn")
    (synopsis "Set operations for many sets")
    (description
     "The base functions for set operations in @code{R} can be used for only two
sets.  This package @code{RVenn} provides functions for dealing with multiple sets.
It uses @code{purr} to find the union, intersection and difference of three or
more sets.  This package also provides functions for pairwise set operations among
several sets.  Further, based on @code{ggplot2} and @code{ggforce}, a Venn diagram
can be drawn for two or three sets.  For bigger data sets, a clustered heatmap
showing the presence or absence of the elements of the sets can be drawn based on
the @code{pheatmap} package.  Finally, enrichment test can be applied to two sets
whether an overlap is statistically significant or not.")
    (license license:gpl3)))

(define-public r-dot
  (package
    (name "r-dot")
    (version "0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "DOT" version))
       (sha256
        (base32
         "0qh5n57cp9c2n5yn59q4wggz82943pwfanp3kx869aba2x3sj30i"))))
    (properties `((upstream-name . "DOT")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-v8))
    (home-page "http://haghish.com/dot")
    (synopsis "Render and Export DOT Graphs in R")
    (description
     "This package provides tools to render DOT diagram markup language in R
and also provides the possibility to export the graphs in PostScript and
SVG (Scalable Vector Graphics) formats.  In addition, it supports literate
programming packages such as @code{knitr} and @code{rmarkdown}.")
    (license license:expat)))

(define-public r-carrier
  (package
    (name "r-carrier")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "carrier" version))
       (sha256
        (base32 "0bqnwnnjqjk9q0lxq6kkz9s75ss10lfyyywyyi24m8wppxpw1vqc"))))
    (properties `((upstream-name . "carrier")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-pryr r-rlang))
    (home-page "https://github.com/r-lib/carrier")
    (synopsis "Isolate functions for remote execution")
    (description
     "Sending functions to remote processes can be wasteful of resources
because they carry their environments with them.  With this package, it is
easy to create functions that are isolated from their environment.  These
isolated functions, also called crates, print to the console with their total
size and can be easily tested locally before being sent to a remote.")
    (license license:gpl3)))

(define-public r-clipr
  (package
    (name "r-clipr")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "clipr" version))
       (sha256
        (base32
         "1s9vvv3cxnz8w11gsi8z9ddv9jzib5qf5qqxnwqrrv7vj8cr7hij"))))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/mdlincoln/clipr")
    (synopsis "Read and write from the system clipboard")
    (description
     "This package provides simple utility functions to read from and write to
the system clipboards.")
    (license license:gpl3)))

(define-public r-clvalid
  (package
    (name "r-clvalid")
    (version "0.7")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "clValid" version))
              (sha256
               (base32
                "18aiyjhnh5mfdxbzns4cy0r8bymfikhwkybpn4g04qhli5ls8z83"))))
    (properties `((upstream-name . "clValid")))
    (build-system r-build-system)
    (propagated-inputs (list r-class r-cluster))
    (home-page "https://cran.r-project.org/package=clValid")
    (synopsis "Validation of clustering results")
    (description
     "Statistical and biological validation of clustering results.  This
package implements Dunn Index, Silhouette, Connectivity, Stability, BHI and
BSI.  Further information can be found in Brock, G et al. (2008) <doi:
10.18637/jss.v025.i04>.")
    (license license:lgpl3)))

(define-public r-dlm
  (package
    (name "r-dlm")
    (version "1.1-5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dlm" version))
       (sha256
        (base32 "1aksm66sfa7ipl5xgs4j5giac7q2m744wjl40mva56xn6i674h4r"))))
    (properties `((upstream-name . "dlm")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=dlm")
    (synopsis "Bayesian and Likelihood Analysis of Dynamic Linear Models")
    (description
     "This package provides routines for Maximum likelihood, Kalman filtering
and smoothing, and Bayesian analysis of Normal linear State Space models, also
known as Dynamic Linear Models.")
    (license license:gpl2+)))

(define-public r-zcompositions
  (package
    (name "r-zcompositions")
    (version "1.4.0-1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "zCompositions" version))
              (sha256
               (base32
                "1rrhja9iaq123r2gqw1bzrn1ri0s3z4wzq8p0sfcr1yb6pv13vik"))))
    (properties `((upstream-name . "zCompositions")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mass
           r-nada
           r-truncnorm))
    (home-page "https://github.com/Japal/zCompositions")
    (synopsis
     "Treatment of zeros, left-censored and missing values in compositional data")
    (description
     "This is an R package for the imputation of left-censored data
under a compositional approach.  The implemented methods consider
aspects of relevance for a compositional approach such as scale
invariance, subcompositional coherence or preserving the multivariate
relative structure of the data.  Based on solid statistical
frameworks, it comprises the ability to deal with single and varying
censoring thresholds, consistent treatment of closed and non-closed
data, exploratory tools, multiple imputation, @dfn{Markov Chain Monte
Carlo} (MCMC), robust and non-parametric alternatives, and recent
proposals for count data.")
    (license license:gpl2+)))

(define-public r-zoo
  (package
    (name "r-zoo")
    (version "1.8-11")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "zoo" version))
              (sha256
               (base32
                "19cw09bhwj2qyd72765ym1cm2wmhh801ccif889nzq5gfpw513l4"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lattice))
    (home-page "http://zoo.R-Forge.R-project.org/")
    (synopsis "S3 infrastructure for regular and irregular time series")
    (description "This package contains an S3 class with methods for totally
ordered indexed observations.  It is particularly aimed at irregular time
series of numeric vectors/matrices and factors.")
    (license license:gpl2+)))

(define-public r-fontawesome
  (package
    (name "r-fontawesome")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fontawesome" version))
       (sha256
        (base32 "0br4sjl2z5av5kf42mnp35sichk3syrz68xic08wxnqdnp2hn2kn"))))
    (properties `((upstream-name . "fontawesome")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-htmltools r-rlang))
    (home-page "https://github.com/rstudio/fontawesome")
    (synopsis "Easily work with Font Awesome icons")
    (description
     "Easily and flexibly insert Font Awesome icons into R Markdown documents
and Shiny apps.  These icons can be inserted into HTML content through inline
SVG tags or @code{i} tags.  There is also a utility function for exporting
Font Awesome icons as PNG images for those situations where raster graphics
are needed.")
    (license license:expat)))

(define-public r-fingerprint
  (package
    (name "r-fingerprint")
    (version "3.5.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fingerprint" version))
       (sha256
        (base32 "04jcwkydjrs31pia6kq8z2n9s54im950q08hs2ay15xjxxkmb8ic"))))
    (properties `((upstream-name . "fingerprint")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=fingerprint")
    (synopsis "Functions to Operate on Binary Fingerprint Data")
    (description
     "This package provides functions to manipulate binary fingerprints of
arbitrary length.  A fingerprint is represented by an object of S4 class
@code{fingerprint}.  The bitwise logical functions in R are overridden so that
they can be used directly with @code{fingerprint} objects.  A number of
distance metrics are also available.  Fingerprints can be converted to
Euclidean vectors (i.e., points on the unit hypersphere) and can also be
folded.  Arbitrary fingerprint formats can be handled via line handlers.
Currently handlers are provided for CDK, MOE and BCI fingerprint data.")
    ;; Any version of the GPL
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-fpeek
  (package
    (name "r-fpeek")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fpeek" version))
       (sha256
        (base32 "0kv46g21ndxchg3q8ynq7hjjkh6i2zlc21axn5y1jjzigrw047ii"))))
    (properties `((upstream-name . "fpeek")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (home-page "https://github.com/davidgohel/fpeek")
    (synopsis "Check text files content at a glance")
    (description
     "This package provides tools to help working with text files.  It can
return the number of lines; print the first and last lines; convert encoding.
Operations are made without reading the entire file before starting, resulting
in good performances with large files.")
    (license license:expat)))

(define-public r-ggalluvial
  (package
   (name "r-ggalluvial")
   (version "0.12.3")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "ggalluvial" version))
            (sha256
             (base32
              "0mkan9gxg3yxjism22yxbhvlh2lh7wpbrqpb355za790prcmjbh3"))))
   (properties `((upstream-name . "ggalluvial")))
   (build-system r-build-system)
   (propagated-inputs
    (list r-dplyr
          r-ggplot2
          r-lazyeval
          r-rlang
          r-tidyr
          r-tidyselect))
   (native-inputs
    (list r-knitr))
   (home-page "http://corybrunson.github.io/ggalluvial/")
   (synopsis "Alluvial plots for ggplot2")
   (description "This package provides alluvial plots for @code{ggplot2}.
Alluvial plots use variable-width ribbons and stacked bar plots to represent
multi-dimensional or repeated-measures data with categorical or ordinal
variables.")
   (license license:gpl3)))

(define-public r-ggpp
  (package
    (name "r-ggpp")
    (version "0.4.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggpp" version))
       (sha256
        (base32
         "02inwvfz2zxsj7bq0nz11c5spnyaf8zhjnlfllpwfjfy46qrx2p9"))))
    (properties `((upstream-name . "ggpp")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr
           r-ggplot2
           r-glue
           r-gridextra
           r-lubridate
           r-magrittr
           r-mass
           r-polynom
           r-rlang
           r-scales
           r-stringr
           r-tibble
           r-xts
           r-zoo))
    (native-inputs
     (list r-knitr))
    (home-page "https://docs.r4photobiology.info/ggpp/")
    (synopsis "Grammar extensions to ggplot2")
    (description
     "This package contains extensions to ggplot2.

@enumerate
@item Geomas: @code{geom_table}, @code{geom_plot} and @code{geom_grob} add
  insets to plots using native data coordinates, while @code{geom_table_npc},
  @code{geom_plot_npc} and @code{geom_grob_npc} do the same using @code{npc}
  coordinates through new aesthetics @code{npcx} and @code{npcy}.
@item Statistics: select observations based on 2D density.
@item Positions: radial nudging away from a center point and nudging away from
  a line or curve.
@end enumerate
")
    (license license:gpl2+)))

(define-public r-ggprism
  (package
    (name "r-ggprism")
    (version "1.0.4")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ggprism" version))
              (sha256
               (base32
                "0ycklp7764cw65hqh9r61im8vqfd7sjayyw1gvprxzg7k217gnl3"))))
    (properties `((upstream-name . "ggprism")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-digest
           r-ggplot2
           r-glue
           r-gtable
           r-rlang
           r-scales
           r-tibble))
    (native-inputs (list r-knitr))
    (home-page "https://csdaw.github.io/ggprism/")
    (synopsis "ggplot2 extension inspired by GraphPad Prism")
    (description
     "This package provides various themes, palettes, and other functions that are
used to customise ggplots to look like they were made in GraphPad Prism.  The
Prism-look is achieved with @code{theme_prism()} and
@code{scale_fill|colour_prism()}, axes can be changed with custom guides like
@code{guide_prism_minor()}, and significance indicators added with
@code{add_pvalue()}.")
    (license license:gpl3+)))

(define-public r-ggrastr
  (package
    (name "r-ggrastr")
    (version "1.0.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ggrastr" version))
              (sha256
               (base32
                "07sx5wlawfyb0zy5am2q1ajhkdym5r9ih47p57l8bv4dlc7ykml2"))))
    (properties `((upstream-name . "ggrastr")))
    (build-system r-build-system)
    (propagated-inputs (list r-cairo r-ggbeeswarm r-ggplot2 r-png r-ragg))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/VPetukhov/ggrastr")
    (synopsis "Rasterize layers for ggplot2")
    (description
     "Rasterize only specific layers of a ggplot2 plot while simultaneously keeping
all labels and text in vector format.  This allows users to keep plots within
the reasonable size limit without losing vector properties of the
scale-sensitive information.")
    (license license:expat)))

(define-public r-ggvenn
  (package
    (name "r-ggvenn")
    (version "0.1.9")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ggvenn" version))
              (sha256
               (base32
                "0bm52j3idchignp6nrw7c76jlbfkjf5zng258957vq019vx9qxrq"))))
    (properties `((upstream-name . "ggvenn")))
    (build-system r-build-system)
    (propagated-inputs (list r-dplyr r-ggplot2))
    (home-page "https://cran.r-project.org/package=ggvenn")
    (synopsis "Draw Venn diagram with ggplot2")
    (description
     "This package offers an easy to use way to draw a Venn diagram with
@code{ggplot2}.")
    (license license:expat)))

(define-public r-ggvenndiagram
  (package
    (name "r-ggvenndiagram")
    (version "1.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggVennDiagram" version))
       (sha256
        (base32
         "1l4cincm7c2q9x3djiv1lm9bvivaqk7kincx19b8f760wz9hp74k"))))
    (properties `((upstream-name . "ggVennDiagram")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr
           r-ggplot2
           r-magrittr
           r-plotly
           r-purrr
           r-rvenn
           r-sf
           r-tibble
           r-yulab-utils))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/gaospecial/ggVennDiagram")
    (synopsis "Implementention of the Venn diagram using ggplot2")
    (description
     "This package implements easy-to-use functions to generate 2-7 sets Venn
plot in publication quality.  @code{ggVennDiagram} plot Venn using
well-defined geometry dataset and @code{ggplot2}.  The shapes of 2-4 sets Venn
use circles and ellipses, while the shapes of 4-7 sets Venn use irregular
polygons (4 has both forms), which are developed and imported from another
package @code{venn}.  We provide internal functions to integrate shape data
with user provided sets data, and calculated the geometry of every
regions/intersections of them, then separately plot Venn in three components:
set edges, set labels, and regions.  From version 1.0, it is possible to
customize these components as you demand in ordinary @code{ggplot2} grammar.")
    (license license:gpl3)))

(define-public r-lmds
  (package
    (name "r-lmds")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lmds" version))
       (sha256
        (base32 "130azb0nc2wwxv0qi8v5s4rd02p9lc92zwn634pv7b8awbw81i65"))))
    (properties `((upstream-name . "lmds")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertthat r-dynutils r-irlba r-matrix))
    (home-page "https://github.com/dynverse/lmds")
    (synopsis "Landmark multi-dimensional scaling")
    (description
     "This package provides a fast dimensionality reduction method scalable
to large numbers of samples.  @dfn{Landmark Multi-Dimensional Scaling} (LMDS)
is an extension of classical Torgerson MDS, but rather than calculating a
complete distance matrix between all pairs of samples, only the distances
between a set of landmarks and the samples are calculated.")
    (license license:gpl3)))

(define-public r-lmodel2
  (package
    (name "r-lmodel2")
    (version "1.7-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lmodel2" version))
       (sha256
        (base32 "1fiin2nkffbihz1s8ixmw9lgf8mn3j9krr8iiflizk10mdv54hnb"))))
    (properties `((upstream-name . "lmodel2")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=lmodel2")
    (synopsis "Model II regression")
    (description
     "This package computes model II simple linear regression using
@dfn{ordinary least squares} (OLS), @dfn{major axis} (MA), @dfn{standard major
axis} (SMA), and @dfn{ranged major axis} (RMA).")
    (license license:gpl2)))

(define-public r-ggpmisc
  (package
    (name "r-ggpmisc")
    (version "0.5.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ggpmisc" version))
              (sha256
               (base32
                "18085n6id5v3g3w1z1010im85i4yii4wib2cmcxwqk7qvk9rsrqi"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-confintr
           r-dplyr
           r-generics
           r-ggplot2
           r-ggpp
           r-lmodel2
           r-lubridate
           r-mass
           r-plyr
           r-polynom
           r-quantreg
           r-rlang
           r-scales
           r-splus2r
           r-tibble))
    (native-inputs
     (list r-knitr))
    (home-page "https://www.r4photobiology.info/")
    (synopsis "Miscellaneous Extensions to @code{ggplot2}")
    (description "This package provides extensions to @code{ggplot2},
respecting the grammar of its graphics paradigm.")
    (license license:gpl2+)))

(define-public r-ggside
  (package
    (name "r-ggside")
    (version "0.2.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ggside" version))
              (sha256
               (base32
                "1vl7kzgmi5xxxsqvyg4cm4xwd3lfjgysay1lw6hri5vj22mnga5h"))))
    (properties `((upstream-name . "ggside")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2
           r-glue
           r-gtable
           r-rlang
           r-scales
           r-tibble))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=ggside")
    (synopsis "Side grammar graphics that extends @code{ggplot2}")
    (description
     "The grammar of graphics as shown in @code{ggplot2} has provided an
expressive API for users to build plots.  This package @{ggside} extends
@code{ggplot2} by allowing users to add graphical information about one of the
main panel's axis using a familiar @code{ggplot2} style API with tidy data.
This package is particularly useful for visualizing metadata on a discrete
axis, or summary graphics on a continuous axis such as a boxplot or a density
distribution.")
    (license license:expat)))

(define-public r-gprofiler
  (package
    (name "r-gprofiler")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gProfileR" version))
       (sha256
        (base32
         "1h1v0kgpsn04ald2izznh7fr2riwisj5hcgz4k7h3qc931rf0r4k"))))
    (properties `((upstream-name . "gProfileR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-plyr r-rcurl))
    (home-page "https://cran.r-project.org/web/packages/gProfileR/")
    (synopsis "Interface to the g:Profiler toolkit")
    (description
     "This package provides tools for functional enrichment analysis,
gene identifier conversion and mapping homologous genes across related
organisms via the @code{g:Profiler} toolkit.")
    (license license:gpl2+)))

(define-public r-gprofiler2
  (package
    (name "r-gprofiler2")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gprofiler2" version))
       (sha256
        (base32
         "0r0h34b35xzgd9rh55yndn0anxy0z45zdlqa6qfmpn91b6v1bb1g"))))
    (properties `((upstream-name . "gprofiler2")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-crosstalk
           r-dplyr
           r-ggplot2
           r-gridextra
           r-jsonlite
           r-plotly
           r-rcurl
           r-tidyr
           r-viridislite))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/gprofiler2/")
    (synopsis "Interface to the g:Profiler toolset")
    (description
     "This package provides a toolset for functional enrichment analysis and
visualization, gene/protein/SNP identifier conversion and mapping orthologous
genes across species via @url{https://biit.cs.ut.ee/gprofiler,g:Profiler}.
The main tools are:

@enumerate
@item @code{g:GOSt}, functional enrichment analysis and visualization of gene
  lists;
@item @code{g:Convert}, gene/protein/transcript identifier conversion across
  various namespaces;
@item @code{g:Orth}, orthology search across species;
@item @code{g:SNPense}, mapping SNP rs identifiers to chromosome positions,
  genes and variant effects.
@end enumerate

This package is an R interface corresponding to the 2019 update of
@code{g:Profiler} and provides access to versions @code{e94_eg41_p11} and
higher.")
    (license license:gpl2+)))

(define-public r-oenb
  (package
    (name "r-oenb")
    (version "0.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "oenb" version))
       (sha256
        (base32
         "1jgxw7ycx2lcdzglg9nix8k08fs4r6i5jdsjzrd6w1dg6smsinl5"))))
    (properties `((upstream-name . "oenb")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr r-xml))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/franzmohr/oenb")
    (synopsis "Tools for the OeNB Data Web Service")
    (description
     "Tools to access data from the data web service of the
@acronym{OeNB, Oesterreichische Nationalbank},
@url{https://www.oenb.at/en/Statistics/User-Defined-Tables/webservice.html}.")
    (license license:gpl2+)))

(define-public r-orgmassspecr
  (package
    (name "r-orgmassspecr")
    (version "0.5-3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "OrgMassSpecR" version))
              (sha256
               (base32
                "1dx9d8rb1dfqyhyc26zhfnxiv3rz2ikvs2mwqnsrq3lsjs9dvyc8"))))
    (properties `((upstream-name . "OrgMassSpecR")))
    (build-system r-build-system)
    (native-inputs (list r-knitr))
    (home-page "http://OrgMassSpec.github.io/")
    (synopsis "Organic or biological mass spectrometry data analysis")
    (description
     "This package @code{OrgMassSpecR} is an extension of the @code{R}
statistical computing language.  It contains functions to assist with organic
or biological mass spectrometry data analysis.  Mass spectral libraries are
available as companion packages.")
    (license license:bsd-2)))

(define-public r-scales
  (package
    (name "r-scales")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "scales" version))
       (sha256
        (base32 "027daznawr9dy0z9s99lh64i4am691hdir01n7gr7vmgpmnkwiar"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-farver
           r-labeling
           r-lifecycle
           r-munsell
           r-rcolorbrewer
           r-rlang
           r-r6
           r-viridislite))
    (home-page "https://github.com/hadley/scales")
    (synopsis "Scale functions for visualization")
    (description
     "This package provides graphical scales that map data to aesthetics, and
provides methods for automatically determining breaks and labels for axes and
legends.")
    (license license:expat)))

(define-public r-pacman
  (package
    (name "r-pacman")
    (version "0.5.1")
    (source (origin
             (method url-fetch)
             (uri (cran-uri "pacman" version))
             (sha256
              (base32
               "0z7gngd6h83cpjhq1vg75wvzhdjbgjh7gj5d4zvvi9gd2lmagjcy"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-remotes))
    (home-page "https://github.com/trinker/pacman")
    (synopsis "Package Management Tool")
    (description "This package provides tools to more conveniently perform
tasks associated with add-on packages.  @code{pacman} conveniently wraps
library and package related functions and names them in an intuitive and
consistent fashion.  It seeks to combine functionality from lower level
functions which can speed up workflow.")
    (license license:gpl2)))

(define-public r-pals
  (package
    (name "r-pals")
    (version "1.7")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "pals" version))
              (sha256
               (base32
                "18pbivmqs9yqsb6p8anv42alny0njaq3dajibhzysax0b7rsk2js"))))
    (properties `((upstream-name . "pals")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-colorspace
           r-dichromat
           r-mapproj
           r-maps))
    (native-inputs (list r-knitr))
    (home-page "https://kwstat.github.io/pals/")
    (synopsis "Color palettes, color maps, and tools to evaluate them")
    (description
     "This package provides a comprehensive collection of color
palettes, color maps, and tools to evaluate them.")
    (license license:gpl3)))

(define-public r-paralleldist
  (package
    (name "r-paralleldist")
    (version "0.2.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "parallelDist" version))
       (sha256
        (base32 "01ly4hxwa64a0ya5gla8rvv72s9mcknsfznivjkh937pbjwb7iih"))))
    (properties `((upstream-name . "parallelDist")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp r-rcpparmadillo r-rcppparallel))
    (home-page "https://github.com/alexeckert/parallelDist")
    (synopsis "Parallel Distance Matrix Computation using multiple threads")
    (description
     "This package provides a fast parallelized alternative to R's native
@code{dist} function to calculate distance matrices for continuous, binary,
and multi-dimensional input matrices, which supports a broad variety of
predefined distance functions from other R packages, as well as user- defined
functions written in C++.  For ease of use, the @code{parDist} function
extends the signature of the @code{dist} function and uses the same parameter
naming conventions as distance methods of existing R packages.")
    (license license:gpl2+)))

(define-public r-pheatmap
  (package
    (name "r-pheatmap")
    (version "1.0.12")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pheatmap" version))
       (sha256
        (base32
         "1hdh74az3vyzz6dqa311rhxdm74n46lyr03p862kn80p0kp9d7ap"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-gtable r-rcolorbrewer r-scales))
    (home-page "https://cran.r-project.org/web/packages/pheatmap")
    (synopsis "Pretty heatmaps")
    (description
     "This package provides an implementation of heatmaps that offers more
control over dimensions and appearance.")
    (license license:gpl2+)))

(define-public r-philentropy
  (package
    (name "r-philentropy")
    (version "0.6.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "philentropy" version))
              (sha256
               (base32
                "1dpf4hfflp4mcql4na46wzcq1flabkipiwyycz9wj5xbxlmcz2hk"))))
    (properties `((upstream-name . "philentropy")))
    (build-system r-build-system)
    (propagated-inputs (list r-kernsmooth r-poorman r-rcpp))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/drostlab/philentropy")
    (synopsis
     "Similarity and distance quantification between probability functions")
    (description
     "This package computes optimized distance and similarity measures for
comparing probability functions (Drost (2018) <doi:10.21105/joss.00765>).
These comparisons between probability functions have their foundations in a
broad range of scientific disciplines from mathematics to ecology.  The aim of
this package is to provide a core framework for clustering, classification,
statistical inference, goodness-of-fit, non-parametric statistics, information
theory, and machine learning tasks that are based on comparing univariate or
multivariate probability functions.")
    (license license:gpl2)))

(define-public r-pnwcolors
  (package
    (name "r-pnwcolors")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "PNWColors" version))
       (sha256
        (base32
         "1phplnclkficfv8s6wsyrckk4ixzbayiy5iix6dddg40485l9nyj"))))
    (properties `((upstream-name . "PNWColors")))
    (build-system r-build-system)
    (home-page "https://github.com/jakelawlor/PNWColors")
    (synopsis "Color palettes for data visualizations")
    (description
     "This package provides color palettes.  They are checked for colorblind
accessibility from hue, saturation, and lightness value scaling using the
Chroma.js Color Palette Helper.  See @url{https://gka.github.io/palettes}.")
    (license license:cc0)))

(define-public r-plotfunctions
  (package
    (name "r-plotfunctions")
    (version "1.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "plotfunctions" version))
       (sha256
        (base32 "0asmxw8283fpvl83h478j5nyg59xqifqaa8f2f6l199gvvswhhg2"))))
    (properties `((upstream-name . "plotfunctions")))
    (build-system r-build-system)
    (native-inputs (list r-knitr))
    (home-page "https://jacolienvanrij.com/tutorials.html")
    (synopsis "Various functions to facilitate visualization of data and analysis")
    (description
     "When analyzing data, plots are a helpful tool for visualizing data and
interpreting statistical models.  This package provides a set of simple tools
for building plots incrementally, starting with an empty plot region, and
adding bars, data points, regression lines, error bars, gradient legends,
density distributions in the margins, and even pictures.  The package builds
further on R graphics by simply combining functions and settings in order to
reduce the amount of code to produce for the user.  As a result, the package
does not use formula input or special syntax, but can be used in combination
with default R plot functions.")
    (license license:gpl2+)))

(define-public r-polychrome
  (package
    (name "r-polychrome")
    (version "1.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Polychrome" version))
       (sha256
        (base32 "0hyi02m2jpdhk1ky6ihz6dv5pwqwjwk4csjim2qr8ywx8midmrvg"))))
    (properties `((upstream-name . "Polychrome")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-colorspace r-scatterplot3d))
    (native-inputs
     (list r-knitr))
    (home-page "http://oompa.r-forge.r-project.org/")
    (synopsis "Qualitative palettes with many colors")
    (description
     "This package provides tools for creating, viewing, and assessing
qualitative palettes with many (20-30 or more) colors.  See Coombes and
colleagues (2019) @url{https://doi:10.18637/jss.v090.c01}.")
    (license license:asl2.0)))

(define-public r-polylabelr
  (package
    (name "r-polylabelr")
    (version "0.2.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "polylabelr" version))
              (sha256
               (base32
                "01b2v0l5g8nxwbd6nwqv8ahypgh6gfhd4qabg75brlj7z1iyfzf2"))))
    (properties `((upstream-name . "polylabelr")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (home-page "https://github.com/jolars/polylabelr")
    (synopsis "Finding pole of inaccessibility (visual center) of a polygon")
    (description
     "This package provides a wrapper around the @code{C++} library @code{
polylabel} from @code{Mapbox}, providing an efficient routine for finding the
approximate pole of inaccessibility of a polygon, which usually serves as an
excellent candidate for labeling of a polygon.")
    (license license:expat)))

(define-public r-poorman
  (package
    (name "r-poorman")
    (version "0.2.6")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "poorman" version))
              (sha256
               (base32
                "0x1pk00ca7wjxnqfh1jphgsxcrq37s0c1nawv52yh5qgc4z0m3ij"))))
    (properties `((upstream-name . "poorman")))
    (build-system r-build-system)
    (native-inputs (list r-knitr))
    (home-page "https://nathaneastwood.github.io/poorman/")
    (synopsis "Dependency-free recreation of dplyr")
    (description
     "This package provides a replication of key functionality from
@code{dplyr} and the wider @code{tidyverse} using only @code{base}.")
    (license license:expat)))

(define-public r-ecosolver
  (package
    (name "r-ecosolver")
    (version "0.5.4")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ECOSolveR" version))
              (sha256
               (base32
                "0973m346vakgddp92dzqlky0wa196hj341r9y7rz67bc2zl8jx2x"))))
    (properties `((upstream-name . "ECOSolveR")))
    (build-system r-build-system)
    (native-inputs (list r-knitr))
    (home-page "https://bnaras.github.io/ECOSolveR/")
    (synopsis "Embedded conic solver in R")
    (description
     "This package provides an R interface to the @dfn{Embedded COnic
Solver} (ECOS), an efficient and robust C library for convex problems.
Conic and equality constraints can be specified in addition to integer
and boolean variable constraints for mixed-integer problems.  This R
interface is inspired by the Python interface and has similar calling
conventions.")
    (license license:gpl3+)))

(define-public r-ecp
  (package
    (name "r-ecp")
    (version "3.1.3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ecp" version))
              (sha256
               (base32
                "0n602jssl6rf596nwm6hbl7s9vdlqi20w8mrhxicj373mw5v22m8"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp))
    (home-page "https://cran.r-project.org/web/packages/ecp/")
    (synopsis "Multiple change-point analysis of multivariate data")
    (description
     "This package implements various procedures for finding multiple
change-points.  Two methods make use of dynamic programming and pruning, with
no distributional assumptions other than the existence of certain absolute
moments in one method.  Hierarchical and exact search methods are included.
All methods return the set of estimated change-points as well as other summary
information.")
    (license license:gpl2+)))

(define-public r-ellipsis
  (package
    (name "r-ellipsis")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ellipsis" version))
       (sha256
        (base32
         "0n0mm9jngklv7j9wa64jdji035z0smmnsp2dfwcz9isrxgjnc0m9"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rlang))
    (home-page "https://github.com/hadley/ellipsis")
    (synopsis "Tools for working with additional arguments")
    (description
     "In S3 generics, it's useful to take @code{...} so that methods can have
additional arguments.  But this flexibility comes at a cost: misspelled
arguments will be silently ignored.  The @code{ellipsis} package is an
experiment that allows a generic to warn if any arguments passed in @code{...}
are not used.")
    (license license:gpl3)))

(define-public r-ga
  (package
    (name "r-ga")
    (version "3.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "GA" version))
       (sha256
        (base32 "0q0br75zklnp0g3j98x6lll5fhyayxqzaqs3hc2z39s2imwi2fpb"))))
    (properties `((upstream-name . "GA")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-crayon
           r-foreach
           r-iterators
           r-rcpp
           r-rcpparmadillo))
    (native-inputs
     (list r-knitr))
    (home-page "https://luca-scr.github.io/GA/")
    (synopsis "Genetic algorithms for stochastic optimisation")
    (description
     "Flexible general-purpose toolbox implementing genetic algorithms (GAs)
for stochastic optimisation.  Binary, real-valued, and permutation
representations are available to optimize a fitness function, i.e., a function
provided by users depending on their objective function.  Several genetic
operators are available and can be combined to explore the best settings for
the current task.  Furthermore, users can define new genetic operators and
easily evaluate their performances.  Local search using general-purpose
optimisation algorithms can be applied stochastically to exploit interesting
regions.  GAs can be run sequentially or in parallel, using an explicit
master-slave parallelisation or a coarse-grain islands approach.")
    (license license:gpl2+)))

(define-public r-grr
  (package
    (name "r-grr")
    (version "0.9.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "grr" version))
       (sha256
        (base32
         "0arbcgrvhkwb5xk4nry1ffg2qj0v8ivhjghdr505ib4357g0c9i9"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/grr")
    (synopsis "Alternative implementations of base R functions")
    (description
     "This package provides alternative implementations of some base R
functions, including @code{sort}, @code{order}, and @code{match}.  The
functions are simplified but can be faster or have other advantages.")
    (license license:gpl3)))

(define-public r-matrix-utils
  (package
    (name "r-matrix-utils")
    (version "0.9.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Matrix.utils" version))
       (sha256
        (base32
         "0a5fq1scykqk0kc9j051j6fix6j2dqwz5wbgb0amaxsiywz9vigb"))))
    (properties `((upstream-name . "Matrix.utils")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-grr r-matrix))
    (home-page "https://github.com/cvarrichio/Matrix.utils")
    (synopsis
     "Data.frame-Like Operations on Sparse and Dense Matrix Objects")
    (description
     "This package implements data manipulation methods such as @code{cast},
@code{aggregate}, and @code{merge}/@code{join} for Matrix and Matrix-like
objects.")
    (license license:gpl3)))

(define-public r-mboost
  (package
   (name "r-mboost")
   (version "2.9-7")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "mboost" version))
            (sha256
             (base32
              "01ln0vxbbx1fq77q17sx61si82lhfibbchsnf2yw9032cn8wnhh2"))))
   (build-system r-build-system)
   (propagated-inputs
    (list r-lattice
          r-matrix
          r-nnls
          r-partykit
          r-quadprog
          r-stabs
          r-survival))
   (home-page "https://github.com/boost-R/mboost")
   (synopsis "Model-based boosting")
   (description
    "This package provides a functional gradient descent algorithm (boosting)
for optimizing general risk functions utilizing component-wise (penalised)
least squares estimates or regression trees as base-learners for fitting
generalized linear, additive and interaction models to potentially
high-dimensional data.")
   (license license:gpl2)))

(define-public r-shadowtext
  (package
   (name "r-shadowtext")
   (version "0.1.2")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "shadowtext" version))
            (sha256
             (base32
              "0zdfidrcnmxmfhngv86ppxrjmpmz9kl78l4yfah2lc5vgmrlwg15"))))
   (properties `((upstream-name . "shadowtext")))
   (build-system r-build-system)
   (propagated-inputs
    (list r-ggplot2 r-scales))
   (native-inputs
    (list r-knitr))
   (home-page "https://github.com/GuangchuangYu/shadowtext/")
   (synopsis "Shadow text grob and layer")
   (description "This package implements @code{shadowtextGrob()} for
@code{grid} and @code{geom_shadowtext()} layer for @code{ggplot2}.
These functions draw text grob with background shadow.")
   (license license:artistic2.0)))

(define-public r-sys
  (package
    (name "r-sys")
    (version "3.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sys" version))
       (sha256
        (base32
         "0lng3ri17jxq06c6hhhmvsb65lazkiqpp1h4pii4w9jqvs7nskij"))))
    (build-system r-build-system)
    (home-page "https://github.com/jeroen/sys")
    (synopsis "Powerful and reliable tools for running system commands in R")
    (description
     "This package provides drop-in replacements for the base @code{system2()}
function with fine control and consistent behavior across platforms.  It
supports clean interruption, timeout, background tasks, and streaming STDIN /
STDOUT / STDERR over binary or text connections.  The package also provides
functions for evaluating expressions inside a temporary fork.  Such
evaluations have no side effects on the main R process, and support reliable
interrupts and timeouts.  This provides the basis for a sandboxing
mechanism.")
    (license license:expat)))

(define-public r-ashr
  (package
   (name "r-ashr")
   (version "2.2-54")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "ashr" version))
            (sha256
             (base32
              "177xs3apnc6yy6737qqv4z8snf0hkpbghab63hrplbyb9wfssfga"))))
   (properties `((upstream-name . "ashr")))
   (build-system r-build-system)
   (propagated-inputs
    (list r-etrunct
          r-invgamma
          r-matrix
          r-mixsqp
          r-rcpp
          r-squarem
          r-truncnorm))
   (native-inputs
    (list r-knitr))
   (home-page "https://github.com/stephens999/ashr")
   (synopsis "Methods for adaptive shrinkage, using empirical bayes")
   (description "This package implements an empirical Bayes approach for
large-scale hypothesis testing and false discovery rate estimation.")
   (license license:gpl3+)))

(define-public r-askpass
  (package
    (name "r-askpass")
    (version "1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "askpass" version))
       (sha256
        (base32
         "07q0ik8jzk44vpwh48rr3fnpd7dzsdhjjsl4l850rffv3dyq4h6v"))))
    (build-system r-build-system)
    (propagated-inputs (list r-sys))
    (home-page "https://github.com/jeroen/askpass")
    (synopsis "Safe password entry for R")
    (description
     "This package provides cross-platform utilities for prompting the user
for credentials or a passphrase, for example to authenticate with a server or
read a protected key.")
    (license license:expat)))

(define-public r-astsa
  (package
    (name "r-astsa")
    (version "1.16")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "astsa" version))
       (sha256
        (base32 "09872vkqb180cwprdfr3cn85jhazlc4vjdj6pjc70s06bh834f3w"))))
    (properties `((upstream-name . "astsa")))
    (build-system r-build-system)
    (home-page "https://github.com/nickpoison/astsa/")
    (synopsis "Applied statistical time series analysis")
    (description
     "This package provides data sets and scripts to accompany Time Series
Analysis and Its Applications: With R Examples (4th ed), by R.H. Shumway and
D.S. Stoffer.  Springer Texts in Statistics, 2017,
@url{https://doi.org/10.1007/978-3-319-52452-8}, and Time Series: A Data
Analysis Approach Using R.  Chapman-Hall, 2019,
@url{https://doi.org/10.1201/9780429273285}.")
    (license license:gpl3)))

(define-public r-vegan
  (package
    (name "r-vegan")
    (version "2.6-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "vegan" version))
       (sha256
        (base32
         "01hxlb5sy0d28ajq993fqs4z0qjcyl610d0ahjyjpbkrpszd92jx"))))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr ; needed for vignettes
           gfortran))
    (propagated-inputs
     (list r-cluster r-lattice r-mass r-mgcv r-permute))
    (home-page "https://cran.r-project.org/web/packages/vegan")
    (synopsis "Functions for community ecology")
    (description
     "The vegan package provides tools for descriptive community ecology.  It
has most basic functions of diversity analysis, community ordination and
dissimilarity analysis.  Most of its multivariate tools can be used for other
data types as well.")
    (license license:gpl2+)))

(define-public r-tidyverse
  (package
    (name "r-tidyverse")
    (version "1.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tidyverse" version))
       (sha256
        (base32
         "0qfgq4p2aq95j39xd5kcing2cacy7rzy7f6zf0bnpsa95svziyrp"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-broom
           r-cli
           r-crayon
           r-dbplyr
           r-dplyr
           r-dtplyr
           r-forcats
           r-ggplot2
           r-googledrive
           r-googlesheets4
           r-haven
           r-hms
           r-httr
           r-jsonlite
           r-lubridate
           r-magrittr
           r-modelr
           r-pillar
           r-purrr
           r-readr
           r-readxl
           r-reprex
           r-rlang
           r-rstudioapi
           r-rvest
           r-stringr
           r-tibble
           r-tidyr
           r-xml2))
    (native-inputs
     (list r-knitr))
    (home-page "https://tidyverse.tidyverse.org")
    (synopsis "Install and load packages from the \"Tidyverse\"")
    (description
     "The @code{tidyverse} is a set of packages that work in harmony because
they share common data representations and API design.  This package is
designed to make it easy to install and load multiple tidyverse packages in a
single step.")
    (license license:gpl3)))

(define-public r-rvest
  (package
    (name "r-rvest")
    (version "1.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rvest" version))
       (sha256
        (base32 "07hws9infwchy19smrcd9m6c0jii0bdn335yxqk3ramgj5ryyrd4"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-glue
           r-httr
           r-lifecycle
           r-magrittr
           r-rlang
           r-selectr
           r-tibble
           r-withr
           r-xml2))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/hadley/rvest")
    (synopsis "Simple web scraping for R")
    (description
     "@code{r-rvest} helps you scrape information from web pages.  It is
designed to work with @code{magrittr} to make it easy to express common web
scraping tasks, inspired by libraries like @code{BeautifulSoup}.")
    (license license:gpl3)))

(define-public r-selectr
  (package
    (name "r-selectr")
    (version "0.4-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "selectr" version))
       (sha256
        (base32 "09y1n3iy297g49xlpl7xrjpwgnm57pskx5991lyfcpizbz8ax22m"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-stringr r-r6))
    (home-page "https://sjp.co.nz/projects/selectr/")
    (synopsis "Translate CSS selectors to XPath expressions")
    (description
     "@code{r-selectr} translates a CSS3 selector into an equivalent XPath
expression.  This allows you to use CSS selectors when working with the XML
package as it can only evaluate XPath expressions.  Also provided are
convenience functions useful for using CSS selectors on XML nodes.  This
package is a port of the Python package @code{cssselect}.")
    (license license:bsd-3)))

(define-public r-reprex
  (package
    (name "r-reprex")
    (version "2.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "reprex" version))
       (sha256
        (base32
         "14khx09yzn97xhags48lvym1g37h1l2ymvw6r1jlldhjc7i1cnx8"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-callr
           r-cli
           r-clipr
           r-fs
           r-glue
           r-knitr
           r-lifecycle
           r-rlang
           r-rmarkdown
           r-rstudioapi
           r-withr))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/tidyverse/reprex")
    (synopsis "Prepare reproducible R code examples for sharing")
    (description
     "This package provides a convenience wrapper that uses the
@code{rmarkdown} package to render small snippets of code to target formats
that include both code and output.  The goal is to encourage the sharing of
small, reproducible, and runnable examples on code-oriented websites or email.
@code{reprex} also extracts clean, runnable R code from various common formats,
such as copy/paste from an R session.")
    (license license:expat)))

(define-public r-reordercluster
  (package
   (name "r-reordercluster")
   (version "2.0")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "ReorderCluster" version))
            (sha256
             (base32
              "0zq143xvv2br7016f9b1501ymcpkjqm3al1dn5qfm21axyi2p1iq"))))
   (build-system r-build-system)
   (propagated-inputs
    (list r-gplots r-gtools r-rcpp))
   (home-page "https://cran.r-project.org/web/packages/ReorderCluster")
   (synopsis "Reordering the dendrogram according to the class labels")
   (description "This package provides tools for performing the leaf reordering
for the dendrogram that preserves the hierarchical clustering result and at the
same time tries to group instances from the same class together.")
   (license license:gpl3+)))

(define-public r-callr
  (package
    (name "r-callr")
    (version "3.7.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "callr" version))
       (sha256
        (base32
         "01q3b0w1cbrryvv1dwvnyd3j1f09xmhnwg1wskc51r3r4qhqmnhj"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-r6 r-processx))
    (home-page "https://github.com/r-lib/callr#readme")
    (synopsis "Call R from R")
    (description
     "It is sometimes useful to perform a computation in a separate R process,
without affecting the current R process at all.  This package does exactly
that.")
    (license license:expat)))

(define-public r-depmixs4
  (package
    (name "r-depmixs4")
    (version "1.5-0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "depmixS4" version))
              (sha256
               (base32
                "1pacvhw5m4fsk3ysbal50fdqbvlaz8ywyqp6bn1wh42wipqbb2i8"))))
    (propagated-inputs
     (list r-nnet r-nlme r-mass r-rsolnp))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/depmixS4/")
    (synopsis "Dependent Mixture Models")
    (description "This package fits latent (hidden) Markov models on mixed
categorical and continuous (time series) data, otherwise known as dependent
mixture models.")
    (license license:gpl2+)))

(define-public r-readxl
  (package
    (name "r-readxl")
    (version "1.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "readxl" version))
       (sha256
        (base32
         "1ym11mldwj31lgk5av264v8b2zn7fmq5nd30rnm1pchgjizvpgpn"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cellranger r-cpp11 r-progress r-tibble))
    (native-inputs
     (list r-knitr))
    (home-page "https://readxl.tidyverse.org")
    (synopsis "Read Excel files")
    (description
     "This package lets you import Excel files into R.  It supports
@file{.xls} via the embedded @code{libxls} C library and @file{.xlsx} via
the embedded @code{RapidXML} C++ library.")
    ;; XXX: This package bundles a copy of 'libxsl' which is BSD-2 and
    ;; 'rapidxml' which is Boost.
    (license (list license:gpl3 license:bsd-2 license:boost1.0))))

(define-public r-model4you
  (package
    (name "r-model4you")
    (version "0.9-7")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "model4you" version))
              (sha256
               (base32
                "0pni9v3nradvy8sp2m07903vc7z610xrh426lf19dxss12kgrfi8"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-formula
           r-ggplot2
           r-gridextra
           r-partykit
           r-sandwich
           r-survival))
    (home-page "https://cran.r-project.org/web/packages/model4you/")
    (synopsis "Stratified and personalised models based on trees and forests")
    (description
     "This package provides procedures for model-based trees for subgroup
analyses in clinical trials and model-based forests for the estimation and
prediction of personalised treatment effects.  Currently partitioning of linear
models, @code{lm()}, generalised linear models, @code{glm()}, and
Weibull models, @code{survreg()}, are supported.  Advanced plotting functionality is
supported for the trees and a test for parameter heterogeneity is provided for
the personalised models.")
    (license license:gpl2+)))

(define-public r-modelr
  (package
    (name "r-modelr")
    (version "0.1.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "modelr" version))
       (sha256
        (base32
         "1jd9vxirj5ii4ac0ka07g0rcq1c8yqv06jg27nmvp5a6kvlgvs8h"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-broom
           r-magrittr
           r-purrr
           r-rlang
           r-tibble
           r-tidyr
           r-tidyselect
           r-vctrs))
    (home-page "https://github.com/tidyverse/modelr")
    (synopsis "Helper functions for modelling in pipelines")
    (description
     "Functions for modelling that help you seamlessly integrate modelling
into a pipeline of data manipulation and visualisation.")
    (license license:gpl3)))

(define-public r-hmm
  (package
    (name "r-hmm")
    (version "1.0.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "HMM" version))
              (sha256
               (base32
                "03b548bnwqpnd7zypb4gvy9chyi5li2hp99a9vrh4qszxg2ihas7"))))
    (properties `((upstream-name . "HMM")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/HMM/")
    (synopsis "Hidden Markov Models")
    (description "This package provides an easy to use library to setup, apply
and make inference with discrete time and discrete space hidden Markov
models.")
    (license license:gpl2+)))

(define-public r-hiddenmarkov
  (package
   (name "r-hiddenmarkov")
   (version "1.8-13")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "HiddenMarkov" version))
            (sha256
             (base32
              "05dm3nl0ffsz2ziw3bz5bivyxk7r5bxs8xhky3hz660qaqzd51ki"))))
   (build-system r-build-system)
   (native-inputs
    (list gfortran))
   (home-page "https://cran.r-project.org/web/packages/HiddenMarkov/")
   (synopsis "Hidden markov models for R")
   (description "This package contains functions for the analysis of Discrete
Time Hidden Markov Models, Markov Modulated GLMs and the Markov Modulated
Poisson Process.  It includes functions for simulation, parameter estimation,
and the Viterbi algorithm.  The algorithms are based of those of Walter
Zucchini.")
   (license license:gpl2+)))

(define-public r-httpuv
  (package
    (name "r-httpuv")
    (version "1.6.6")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "httpuv" version))
              (sha256
               (base32
                "14qjf7bpl7pay89b7vi2vccl342q8xs6101a9x6qijy54k9myfa1"))
              ;; Unvendor bundled libraries. As of 1.5.4 the vendored libuv
              ;; only contains fixes for building on Solaris.
              (patches (search-patches "r-httpuv-1.6.6-unvendor-libuv.patch"))
              (modules '((guix build utils)))
              ;; Cannot unbundle http-parser, because it contains local
              ;; modifications.
              (snippet
               '(delete-file-recursively "src/libuv"))))
    (build-system r-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'unbundle-libuv
           (lambda* (#:key outputs #:allow-other-keys)
             (substitute* (find-files "src" "\\.cpp$|\\.h$")
               (("\"libuv/include/uv\\.h\"")
                "<uv.h>"))
             ;; Fix https://github.com/rstudio/httpuv/issues/282
             (substitute* "src/http.cpp"
               (("uv_pipe_init\\(pLoop, &pSocket->handle\\.pipe, true\\);")
                "uv_pipe_init(pLoop, &pSocket->handle.pipe, 0);")))))))
    (inputs
     (list libuv zlib))
    (propagated-inputs
     (list r-later r-promises r-r6 r-rcpp))
    (home-page "https://github.com/rstudio/httpuv")
    (synopsis "HTTP and WebSocket server library for R")
    (description
     "The httpuv package provides low-level socket and protocol support for
handling HTTP and WebSocket requests directly from within R.  It is primarily
intended as a building block for other packages, rather than making it
particularly easy to create complete web applications using httpuv alone.")
    ;; This package includes third-party code that was originally released
    ;; under various non-copyleft licenses.  Full licensing information can be
    ;; obtained here: https://github.com/rstudio/httpuv/blob/master/LICENSE
    (license license:gpl3+)))

(define-public r-jsonlite
  (package
    (name "r-jsonlite")
    (version "1.8.3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "jsonlite" version))
              (sha256
               (base32
                "1w685bwhvqxh8y3b4rmzmbbxsj0sqrdad4rni7dxbiqzd2piszy5"))))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr))
    (home-page "https://arxiv.org/abs/1403.2805")
    (synopsis "Robust, high performance JSON parser and generator for R")
    (description
     "The jsonlite package provides a fast JSON parser and generator optimized
for statistical data and the web.  It offers flexible, robust, high
performance tools for working with JSON in R and is particularly powerful for
building pipelines and interacting with a web API.  In addition to converting
JSON data from/to R objects, jsonlite contains functions to stream, validate,
and prettify JSON data.  The unit tests included with the package verify that
all edge cases are encoded and decoded consistently for use with dynamic data
in systems and applications.")
    (license license:expat)))

(define-public r-servr
  (package
    (name "r-servr")
    (version "0.24")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "servr" version))
              (sha256
               (base32
                "11x0857m3xzdbzr4z0vx4fcdk36arfagyf2qgamvprich0qisknr"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-httpuv r-jsonlite r-mime r-xfun))
    (home-page "https://github.com/yihui/servr")
    (synopsis "Simple HTTP server to serve static files or dynamic documents")
    (description
     "Servr provides an HTTP server in R to serve static files, or dynamic
documents that can be converted to HTML files (e.g., R Markdown) under a given
directory.")
    (license license:expat)))

(define-public r-howmany
  (package
    (name "r-howmany")
    (version "0.3-1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "howmany" version))
              (sha256
               (base32
                "045ck8qahfg2swbgyf7dpl32ryq1m4sbalhr7m5qdgpm62vz8h7f"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/howmany/")
    (synopsis "Lower bound for the number of correct rejections")
    (description "When testing multiple hypotheses simultaneously, this package
provides functionality to calculate a lower bound for the number of correct
rejections (as a function of the number of rejected hypotheses), which holds
simultaneously -with high probability- for all possible number of rejections.
As a special case, a lower bound for the total number of false null hypotheses
can be inferred.  Dependent test statistics can be handled for multiple tests
of associations.  For independent test statistics, it is sufficient to provide
a list of p-values.")
    (license license:gpl2+)))

(define-public r-htmltools
  (package
    (name "r-htmltools")
    (version "0.5.3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "htmltools" version))
              (sha256
               (base32
                "0krjyz99q7zvdfg60b128c0zwr36h54gb05jw9c874d8kqv1ni9c"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-base64enc r-digest r-fastmap r-rlang))
    (home-page "https://cran.r-project.org/web/packages/htmltools")
    (synopsis "R tools for HTML")
    (description
     "This package provides tools for HTML generation and output in R.")
    (license license:expat)))

(define-public r-htmlwidgets
  (package
    (name "r-htmlwidgets")
    (version "1.5.4")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "htmlwidgets" version))
              (sha256
               (base32
                "1hgz8sx8xrvfcdwa4q15k942w4qsqg8lyxbbf7qyfzbi807wcgqs"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-htmltools r-jsonlite r-yaml))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/ramnathv/htmlwidgets")
    (synopsis "HTML Widgets for R")
    (description
     "HTML widgets is a framework for creating HTML widgets that render in
various contexts including the R console, R Markdown documents, and Shiny web
applications.")
    (license license:expat)))

(define-public r-htmltable
  (package
    (name "r-htmltable")
    (version "2.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "htmlTable" version))
       (sha256
        (base32 "14qg65nw0bpikqs1hb1x7apzdzrnnl3ykjnks67kkp46v1skwzrs"))))
    (properties `((upstream-name . "htmlTable")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-checkmate
           r-htmltools
           r-htmlwidgets
           r-knitr
           r-magrittr
           r-rstudioapi
           r-stringr))
    (native-inputs
     (list r-knitr))
    (home-page "http://gforge.se/packages/")
    (synopsis "Advanced tables for Markdown/HTML")
    (description
     "This package provides functions to build tables with advanced layout
elements such as row spanners, column spanners, table spanners, zebra
striping, and more.  While allowing advanced layout, the underlying
CSS-structure is simple in order to maximize compatibility with word
processors such as LibreOffice.  The package also contains a few text
formatting functions that help outputting text compatible with HTML or
LaTeX.")
    (license license:gpl3+)))

(define-public r-curl
  (package
    (name "r-curl")
    (version "4.3.3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "curl" version))
              (sha256
               (base32
                "17kwc7njblfndnlij0m5a7a3jj42ag412xg0ry5ddnj0mnnbcrrm"))))
    (build-system r-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         ;; The environment variable CURL_CA_BUNDLE is only respected when
         ;; running Windows, so we disable the platform checks.
         ;; This can be removed once the libcurl has been patched.
         (add-after 'unpack 'allow-CURL_CA_BUNDLE
           (lambda _
             (substitute* "R/onload.R"
               (("if \\(!grepl\\(\"mingw\".*")
                "if (FALSE)\n"))
             (substitute* "src/handle.c"
               (("/\\* Only set" m)
                (string-append "\
const char *_ca_bundle = getenv(\"CURL_CA_BUNDLE\");
if(_ca_bundle != NULL) { curl_easy_setopt(handle, CURLOPT_CAINFO, _ca_bundle); }
" m))))))))
    (inputs
     (list curl zlib))
    (native-inputs
     (list pkg-config r-knitr))
    (home-page "https://github.com/jeroenooms/curl")
    (synopsis "HTTP client for R")
    (description
     "The @code{curl()} and @code{curl_download()} functions provide highly
configurable drop-in replacements for base @code{url()} and
@code{download.file()} with better performance, support for encryption, gzip
compression, authentication, and other @code{libcurl} goodies.  The core of
the package implements a framework for performing fully customized requests
where data can be processed either in memory, on disk, or streaming via the
callback or connection interfaces.")
    (license license:expat)))

(define-public r-hwriter
  (package
    (name "r-hwriter")
    (version "1.3.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "hwriter" version))
       (sha256
        (base32
         "1wxnv8h9cs65m3z01dpnnkgn2cpwfsck70g1jz9nbkr7mdaa4bzd"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/hwriter")
    (synopsis "Output R objects in HTML format")
    (description
     "This package provides easy-to-use and versatile functions to output R
objects in HTML format.")
    (license license:lgpl2.1+)))

(define-public r-rjson
  (package
    (name "r-rjson")
    (version "0.2.21")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rjson" version))
       (sha256
        (base32
         "1qm27r1w677zg31gsiln60hcciszbymkw78cnaq7s36cbk9mcawq"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/rjson")
    (synopsis "JSON library for R")
    (description
     "This package provides functions to convert R objects into JSON objects
and vice-versa.")
    (license license:gpl2+)))

(define-public r-fastmap
  (package
    (name "r-fastmap")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fastmap" version))
       (sha256
        (base32
         "0aw29hnq3ppn7bsnwg9d9sp84k1cvq30lrmfzqn315n0nhkfa4wi"))))
    (properties `((upstream-name . "fastmap")))
    (build-system r-build-system)
    (home-page "https://r-lib.github.io/fastmap/")
    (synopsis "Fast implementation of a key-value store")
    (description
     "This package provides a fast implementation of a key-value store.
Environments are commonly used as key-value stores, but every time a new key
is used, it is added to R's global symbol table, causing a small amount of
memory leakage.  This can be problematic in cases where many different keys
are used.  Fastmap avoids this memory leak issue by implementing the map using
data structures in C++.")
    (license license:expat)))

(define-public r-fastghquad
  (package
    (name "r-fastghquad")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fastGHQuad" version))
       (sha256
        (base32
         "1zj7nsbnx4g253m3dpz9vi3zk3jxwrixwjw1ks6n4shpb4dlkp2w"))))
    (properties `((upstream-name . "fastGHQuad")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp))
    (home-page "https://github.com/awblocker/fastGHQuad")
    (synopsis "Fast Rcpp implementation of Gauss-Hermite Quadrature")
    (description
     "This package implements numerically-stable Gauss-Hermite quadrature
rules and utility functions for adaptive GH quadrature.")
    (license license:expat)))

(define-public r-rstpm2
  (package
    (name "r-rstpm2")
    (version "1.5.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rstpm2" version))
       (sha256
        (base32
         "038qq5kar9f5ygd18aicwfqrr7fl37p0r9shgpc6wf2vmj564crn"))))
    (properties `((upstream-name . "rstpm2")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bbmle
           r-bh
           r-desolve
           r-fastghquad
           r-mgcv
           r-rcpp
           r-rcpparmadillo
           r-survival))
    (native-inputs
     (list gfortran))
    (home-page "https://github.com/mclements/rstpm2")
    (synopsis "Link-based survival models")
    (description
     "This package provides R implementations of @dfn{generalized survival
models} (GSMs), smooth @dfn{accelerated failure time} (AFT) models and Markov
multi-state models.")
    ;; One of these licenses
    (license (list license:gpl2 license:gpl3))))

;; This package includes minified JavaScript files.  When upgrading please
;; check that there are no new minified JavaScript files.
(define-public r-jquerylib
  (package
    (name "r-jquerylib")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "jquerylib" version))
       (sha256
        (base32
         "04a40v4znpj98j7y6009d74a6g9dchj5rr3p08cgz9p3rlfw3g7h"))
       (snippet
        '(for-each delete-file
                   '("inst/lib/1.12.4/jquery-1.12.4.min.js"
                     "inst/lib/2.2.4/jquery-2.2.4.min.js"
                     "inst/lib/3.6.0/jquery-3.6.0.min.js")))))
    (properties `((upstream-name . "jquerylib")))
    (build-system r-build-system)
    (arguments
     `(#:modules ((guix build utils)
                  (guix build r-build-system)
                  (srfi srfi-1))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst/lib/"
               (call-with-values
                   (lambda ()
                     (unzip2
                      `(("1.12.4/jquery-1.12.4.js"
                         "1.12.4/jquery-1.12.4.min.js")
                        ("2.2.4/jquery-2.2.4.js"
                         "2.2.4/jquery-2.2.4.min.js")
                        ("3.6.0/jquery-3.6.0.js"
                         "3.6.0/jquery-3.6.0.min.js"))))
                 (lambda (sources targets)
                   (for-each (lambda (source target)
                               (format #t "Processing ~a --> ~a~%"
                                       source target)
                               (invoke "esbuild" source "--minify"
                                       (string-append "--outfile=" target)))
                             sources targets)))))))))
    (propagated-inputs
     (list r-htmltools))
    (native-inputs
     (list esbuild))
    (home-page "https://cran.r-project.org/package=jquerylib")
    (synopsis "Obtain jQuery as an HTML dependency object")
    (description
     "Obtain any major version of jQuery and use it in any webpage generated
by htmltools (e.g. shiny, htmlwidgets, and rmarkdown).  Most R users don't
need to use this package directly, but other R packages (e.g. shiny,
rmarkdown, etc.) depend on this package to avoid bundling redundant copies of
jQuery.")
    (license license:expat)))

(define-public r-sass
  (package
    (name "r-sass")
    (version "0.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sass" version))
       (sha256
        (base32
         "0iln5ky6k1ix0gddlyw4rr2953kc499x66bcyi9yiyp91nfh82dl"))))
    (properties `((upstream-name . "sass")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-fs r-htmltools r-r6 r-rappdirs r-rlang))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/rstudio/sass")
    (synopsis "Syntactically Awesome Style Sheets (SASS)")
    (description
     "This package provides an SCSS compiler, powered by the libsass library.
With this, R developers can use variables, inheritance, and functions to
generate dynamic style sheets.  The package uses the Sass CSS extension
language, which is stable, powerful, and CSS compatible.")
    (license license:expat)))

(define-public r-saver
  (package
    (name "r-saver")
    (version "1.1.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "SAVER" version))
              (sha256
               (base32
                "1s1kw8idkaj7j90fw4qn9k0wd4vz0sblsk06ry6lm4afcar0p158"))))
    (properties `((upstream-name . "SAVER")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-doparallel
           r-foreach
           r-glmnet
           r-iterators
           r-matrix))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/mohuangx/SAVER")
    (synopsis
     "Recovery of gene expression profile in noisy and sparse scRNA-seq data")
    (description
     "This package is an implementation of a regularized regression prediction
and empirical Bayes method to recover the true gene expression profile in noisy
and sparse single-cell RNA-seq data.  In @dfn{single-cell RNA sequencing}
(scRNA-seq) studies, only a small fraction of the transcripts present in each
cell are sequenced.  This leads to unreliable quantification of genes with low
or moderate expression, which hinders downstream analysis.  This package
@dfn{single-cell analysis via expression recovery} (SAVER) implements an
expression recovery method for unique molecule index (UMI)-based scRNA-seq
data that borrows information across genes and cells to provide accurate
expression estimates for all genes.")
    (license license:gpl2)))

;; This package includes minified JavaScript files.  When upgrading please
;; check that there are no new minified JavaScript files.
(define-public r-bslib
  (package
    (name "r-bslib")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bslib" version))
       (sha256
        (base32
         "1hkmaj0mpygbf6qr1955biv9z4q3khflyqi5x0c3dwi6qz74xspv"))
       (snippet
        '(for-each delete-file
                   '("inst/lib/bs-a11y-p/plugins/js/bootstrap-accessibility.min.js"
                     "inst/lib/bs-colorpicker/js/bootstrap-colorpicker.min.js"
                     "inst/lib/bs3/assets/javascripts/bootstrap.min.js"
                     "inst/lib/bs4/dist/js/bootstrap.bundle.min.js"
                     "inst/lib/bs5/dist/js/bootstrap.bundle.min.js")))))
    (properties `((upstream-name . "bslib")))
    (build-system r-build-system)
    (arguments
     `(#:modules ((guix build utils)
                  (guix build r-build-system)
                  (srfi srfi-1))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst/lib/"
               (call-with-values
                   (lambda ()
                     (unzip2
                      `(("bs-a11y-p/plugins/js/bootstrap-accessibility.js"
                         "bs-a11y-p/plugins/js/bootstrap-accessibility.min.js")
                        ("bs-colorpicker/js/bootstrap-colorpicker.js"
                         "bs-colorpicker/js/bootstrap-colorpicker.min.js")
                        ("bs3/assets/javascripts/bootstrap.js"
                         "bs3/assets/javascripts/bootstrap.min.js")
                        (,(assoc-ref inputs "js-bootstrap4-bundle")
                         "bs4/dist/js/bootstrap.bundle.min.js")
                        (,(assoc-ref inputs "js-bootstrap5-bundle")
                         "bs5/dist/js/bootstrap.bundle.min.js"))))
                 (lambda (sources targets)
                   (for-each (lambda (source target)
                               (format #t "Processing ~a --> ~a~%"
                                       source target)
                               (invoke "esbuild" source "--minify"
                                       (string-append "--outfile=" target)))
                             sources targets)))))))))
    (propagated-inputs
     (list r-cachem
           r-htmltools
           r-jquerylib
           r-jsonlite
           r-memoise
           r-rlang
           r-sass))
    (native-inputs
     `(("esbuild" ,esbuild)
       ("js-bootstrap4-bundle"
        ,(origin
           (method url-fetch)
           (uri "https://raw.githubusercontent.com/twbs/bootstrap/v4.6.0/dist/js/bootstrap.bundle.js")
           (sha256
            (base32
             "04abvgp923w36qfqkkl2syim3bl119nwxbgials90z1jyb8jgss1"))))
       ("js-bootstrap5-bundle"
        ,(origin
           (method url-fetch)
           (uri "https://raw.githubusercontent.com/twbs/bootstrap/v5.1.3/dist/js/bootstrap.bundle.js")
           (sha256
            (base32
             "116979i2vr1y9i6g7n5iir19p85xwr642scbl9jcqdr0w9801nw6"))))))
    (home-page "https://rstudio.github.io/bslib/")
    (synopsis "Custom Bootstrap Sass themes for shiny and rmarkdown")
    (description
     "This package simplifies custom CSS styling of both shiny and rmarkdown
via Bootstrap Sass.  It supports both Bootstrap 3 and 4 as well as their
various Bootswatch themes.  An interactive widget is also provided for
previewing themes in real time.")
    (license license:expat)))

;; This package includes minified JavaScript files.  When upgrading please
;; check that there are no new minified JavaScript files.
(define-public r-shiny
  (package
    (name "r-shiny")
    (version "1.7.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/rstudio/shiny")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0wvc6jlgs41p05wbk8gahnl7sfnc4hpliyh9dbi5w52ngsg6wcr7"))
       (snippet
        '(for-each delete-file
                   '("inst/www/shared/bootstrap/js/bootstrap.min.js"
                     "inst/www/shared/bootstrap/accessibility/js/bootstrap-accessibility.min.js" ; TODO
                     "inst/www/shared/datatables/js/jquery.dataTables.min.js"
                     "inst/www/shared/datepicker/js/bootstrap-datepicker.min.js"
                     "inst/www/shared/highlight/highlight.pack.js"
                     "inst/www/shared/ionrangeslider/js/ion.rangeSlider.min.js"
                     "inst/www/shared/jquery.min.js"
                     "inst/www/shared/jqueryui/jquery-ui.min.js"
                     "inst/www/shared/legacy/jquery.min.js"
                     "inst/www/shared/selectize/accessibility/js/selectize-plugin-a11y.min.js"
                     "inst/www/shared/selectize/js/selectize.min.js"
                     "inst/www/shared/shiny.min.js"
                     "inst/www/shared/showdown/compressed/showdown.js"
                     "inst/www/shared/strftime/strftime-min.js")))))
    (build-system r-build-system)
    (arguments
     `(#:modules ((guix build r-build-system)
                  (guix build minify-build-system)
                  (guix build utils)
                  (ice-9 match))
       #:imported-modules (,@%r-build-system-modules
                           (guix build minify-build-system))
       #:phases
       (modify-phases (@ (guix build r-build-system) %standard-phases)
         (add-after 'unpack 'replace-bundled-minified-JavaScript
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((replace-file (lambda (old new)
                                   (format #t "replacing ~a with ~a\n" old new)
                                   (symlink new old))))
               ;; NOTE: Files in ./inst/www/shared/datepicker/js/locales/
               ;; contain just data.  They are not minified code, so we don't
               ;; replace them.
               (with-directory-excursion "inst/www/shared"
                 (replace-file "strftime/strftime-min.js"
                               (search-input-file inputs
                                                  "/share/javascript/strftime.min.js"))
                 (replace-file "highlight/highlight.pack.js"
                               (search-input-file inputs
                                                  "/share/javascript/highlight.min.js"))
                 (replace-file "datatables/js/jquery.dataTables.min.js"
                               (search-input-file inputs
                                                  "/share/javascript/jquery.dataTables.min.js"))
                 (replace-file "selectize/js/selectize.min.js"
                               (search-input-file inputs
                                                  "/share/javascript/selectize.min.js"))
                 (for-each (match-lambda
                             ((source . target)
                              (minify source #:target target)))
                           `(("jqueryui/jquery-ui.js" .
                              "jqueryui/jquery-ui.min.js")
                             ("datepicker/js/bootstrap-datepicker.js" .
                              "datepicker/js/bootstrap-datepicker.min.js")
                             ("ionrangeslider/js/ion.rangeSlider.js" .
                              "ionrangeslider/js/ion.rangeSlider.min.js")
                             ("bootstrap/js/bootstrap.js" .
                              "bootstrap/js/bootstrap.min.js")
                             (,(assoc-ref inputs "js-bootstrap-accessibility") .
                              "bootstrap/accessibility/js/bootstrap-accessibility.min.js")
                             ("shiny.js" .
                              "shiny.min.js")
                             ("jquery.js" .
                              "jquery.min.js")
                             ("legacy/jquery.js" .
                              "legacy/jquery.min.js")
                             ("selectize/accessibility/js/selectize-plugin-a11y.js" .
                              "selectize/accessibility/js/selectize-plugin-a11y.min.js")
                             ("showdown/src/showdown.js" .
                              "showdown/compressed/showdown.js"))))))))))
    (propagated-inputs
     (list r-bslib
           r-cachem
           r-commonmark
           r-crayon
           r-ellipsis
           r-fastmap
           r-fontawesome
           r-glue
           r-htmltools
           r-httpuv
           r-jsonlite
           r-later
           r-lifecycle
           r-mime
           r-promises
           r-r6
           r-rlang
           r-sourcetools
           r-withr
           r-xtable))
    (inputs
     (list js-datatables js-selectize js-strftime js-highlight))
    (native-inputs
     `(("uglifyjs" ,node-uglify-js)
       ("gfortran" ,gfortran)
       ("js-bootstrap-accessibility"
        ,(origin
           (method url-fetch)
           (uri "https://raw.githubusercontent.com/paypal/bootstrap-accessibility-plugin/\
v1.0.7/_site/plugins/js/bootstrap-accessibility.js")
           (sha256
            (base32
             "1489wyzwrpf86y7vhc13n4v3mszmsfybhd3f75jkpnbvyp5sncm8"))))))
    (home-page "https://shiny.rstudio.com")
    (synopsis "Easy interactive web applications with R")
    (description
     "Makes it incredibly easy to build interactive web applications
with R.  Automatic \"reactive\" binding between inputs and outputs and
extensive prebuilt widgets make it possible to build beautiful,
responsive, and powerful applications with minimal effort.")
    (license license:artistic2.0)))

(define-public r-shinyhelper
  (package
    (name "r-shinyhelper")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shinyhelper" version))
       (sha256
        (base32 "1c4hvf19j3yyh8r12nx85ldkxs89g98q74csnqs5ml5l79a65vgp"))))
    (properties `((upstream-name . "shinyhelper")))
    (build-system r-build-system)
    (propagated-inputs (list r-markdown r-shiny))
    (home-page "https://cran.r-project.org/package=shinyhelper")
    (synopsis "Easily add Markdown help files to shiny app elements")
    (description
     "This package creates a lightweight way to add markdown helpfiles to
Shiny apps, using modal dialog boxes, with no need to observe each help button
separately.")
    (license license:gpl3)))

;; This package includes minified JavaScript files.  When upgrading please
;; check that there are no new minified JavaScript files.
(define-public r-shinytree
  (package
    (name "r-shinytree")
    (version "0.2.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shinyTree" version))
       (sha256
        (base32
         "0jfx2capckv7hf2yx3fn8i4rcmhi222ah91jnmhg497x8wgz31s3"))
       (modules '((guix build utils)))
       (snippet
        '(begin
           ;; Delete minified JavaScript
           (for-each delete-file
                     '("inst/www/jsTree-3.3.7/libs/require.js"
                       "inst/www/jsTree-3.3.7/libs/jquery.js"
                       "inst/www/jsTree-3.3.7/jstree.min.js"))
           #t))))
    (properties `((upstream-name . "shinyTree")))
    (build-system r-build-system)
    (arguments
     `(#:modules ((guix build utils)
                  (guix build r-build-system)
                  (srfi srfi-1)
                  (ice-9 popen))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'replace-minified-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst/www/jsTree-3.3.7/"
               (symlink (search-input-file inputs
                                           "/share/javascript/require.min.js")
                        "libs/require.js")
               (call-with-values
                   (lambda ()
                     (unzip2
                      `((,(assoc-ref inputs "js-jquery")
                         "libs/jquery.js")
                        ("jstree.js"
                         "jstree.min.js"))))
                 (lambda (sources targets)
                   (for-each (lambda (source target)
                               (format #t "Processing ~a --> ~a~%"
                                       source target)
                               (let ((minified (open-pipe* OPEN_READ "uglifyjs" source)))
                                 (call-with-output-file target
                                   (lambda (port)
                                     (dump-port minified port)))))
                             sources targets))))
             #t)))))
    (propagated-inputs
     (list r-htmlwidgets r-jsonlite r-promises r-shiny r-stringr))
    (inputs
     (list js-requirejs))
    (native-inputs
     `(("uglifyjs" ,node-uglify-js)
       ("js-jquery"
        ,(origin
           (method url-fetch)
           (uri "https://code.jquery.com/jquery-3.3.1.js")
           (sha256
            (base32
             "1b8zxrp6xwzpw25apn8j4qws0f6sr7qr7h2va5h1mjyfqvn29anq"))))))
    (home-page "https://cran.r-project.org/web/packages/shinyTree/")
    (synopsis "jsTree bindings for Shiny")
    (description
     "This package exposes R bindings to jsTree, a JavaScript library that
supports interactive trees, to enable rich, editable trees in Shiny.")
    (license license:expat)))

(define-public r-shinydashboard
  (package
    (name "r-shinydashboard")
    (version "0.7.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "shinydashboard" version))
              (sha256
               (base32
                "0hrqkwlpb8rnmp5j74p134g4c4cl16icmwc2ip6k1634fa2y8vm5"))))
    (build-system r-build-system)
    ;; The directory inst/AdminLTE/ contains a minified JavaScript file.
    ;; Regenerate it from the included sources.
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'generate-minified-javascript
           (lambda _
             (with-directory-excursion "inst/AdminLTE"
               (let ((target "app.min.js")
                     (source "app.js"))
                 (format #t "Processing ~a --> ~a~%"
                         source target)
                 (delete-file target)
                 (invoke "esbuild" source "--minify"
                         (string-append "--outfile=" target)))))))))
    (propagated-inputs
     (list r-htmltools r-promises r-shiny))
    (native-inputs
     (list esbuild))
    (home-page "https://rstudio.github.io/shinydashboard/")
    (synopsis "Create dashboards with shiny")
    (description "This package provides an extension to the Shiny web
application framework for R, making it easy to create attractive dashboards.")
    ;; This package includes software that was released under the Expat
    ;; license, but the whole package is released under GPL version 2 or
    ;; later.
    (license license:gpl2+)))

(define-public r-shinyfiles
  (package
    (name "r-shinyfiles")
    (version "0.9.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shinyFiles" version))
       (sha256
        (base32 "11kjq0vw5c98lzrg80m9w917lkgw5im2h9wgk1b84vlaxrjy2wja"))))
    (properties `((upstream-name . "shinyFiles")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-fs r-htmltools r-jsonlite r-shiny r-tibble))
    (home-page "https://github.com/thomasp85/shinyFiles")
    (synopsis "Server-side file system viewer for Shiny")
    (description
     "This package provides functionality for client-side navigation of the
server side file system in shiny apps.  In case the app is running locally
this gives the user direct access to the file system without the need to
\"download\" files to a temporary location.  Both file and folder selection as
well as file saving is available.")
    (license license:gpl2+)))

(define-public r-shinythemes
  (package
    (name "r-shinythemes")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shinythemes" version))
       (sha256
        (base32
         "0qr9bfxw8afxns44i2j4msignf6g5qb2nzpay2lpv343rrlqbmip"))))
    (properties `((upstream-name . "shinythemes")))
    (build-system r-build-system)
    (propagated-inputs (list r-shiny))
    (home-page "https://rstudio.github.io/shinythemes/")
    (synopsis "Themes for Shiny")
    (description
     "This package provides themes for use with Shiny.  It includes several
Bootstrap themes, which are packaged for use with Shiny applications.")
    ;; The package is released under version 3 of the GPL, but it includes
    ;; source files that are covered by the Expat license.  It also includes
    ;; fonts under SIL or the ASL.
    (license (list license:gpl3 license:expat
                   license:silofl1.1 license:asl2.0))))

;; The package sources include minified variants of d3.js and non-minified
;; source code of d3-jetpack.
(define-public r-d3r
  (package
    (name "r-d3r")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "d3r" version))
       (sha256
        (base32
         "1qijkllfaaw0lb29j8mappm8jz9kg8gkihxq5wqhb4gabsazdwva"))))
    (build-system r-build-system)
    (arguments
     `(#:modules ((guix build utils)
                  (guix build r-build-system)
                  (srfi srfi-1))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst/www/d3/"
               (call-with-values
                   (lambda ()
                     (unzip2
                      `((,(assoc-ref inputs "d3.v3.js")
                         "v3/dist/d3.min.js")
                        (,(assoc-ref inputs "d3.v4.js")
                         "v4/dist/d3.min.js")
                        (,(assoc-ref inputs "d3.v5.js")
                         "v5/dist/d3.min.js")
                        (,(assoc-ref inputs "d3.v6.js")
                         "v6/dist/d3.min.js")
                        (,(assoc-ref inputs "d3.v7.js")
                         "v7/dist/d3.min.js"))))
                 (lambda (sources targets)
                   (for-each (lambda (source target)
                               (format #t "Processing ~a --> ~a~%"
                                       source target)
                               (delete-file target)
                               (invoke "esbuild" source "--minify"
                                       (string-append "--outfile=" target)))
                             sources targets)))))))))
    (propagated-inputs
     (list r-dplyr r-htmltools r-rlang r-tidyr))
    (native-inputs
     `(("esbuild" ,esbuild)
       ("d3.v3.js"
        ,(origin
           (method url-fetch)
           (uri "https://d3js.org/d3.v3.js")
           (sha256
            (base32
             "1arr7sr08vy7wh0nvip2mi7dpyjw4576vf3bm45rp4g5lc1k1x41"))))
       ("d3.v4.js"
        ,(origin
           (method url-fetch)
           (uri "https://d3js.org/d3.v4.js")
           (sha256
            (base32
             "0y7byf6kcinfz9ac59jxc4v6kppdazmnyqfav0dm4h550fzfqqlg"))))
       ("d3.v5.js"
        ,(origin
           (method url-fetch)
           (uri "https://d3js.org/d3.v5.js")
           (sha256
            (base32
             "177ypw6mjrp2ch9lj6znibwacwrvm4ypjxflsxsnl2sigx5dcwic"))))
       ("d3.v6.js"
        ,(origin
           (method url-fetch)
           (uri "https://d3js.org/d3.v6.js")
           (sha256
            (base32
             "13hick3glizzm442b9swlwz584rzwwvhpq9qvfbh3m5jay10wxw0"))))
       ("d3.v7.js"
        ,(origin
           (method url-fetch)
           (uri "https://d3js.org/d3.v7.js")
           (sha256
            (base32
             "1hif1phswlkkpvcf1hbqmfsxdb5s5gr5g2frcwbh0rh8g6nbkyqi"))))))
    (home-page "https://github.com/timelyportfolio/d3r")
    (synopsis "d3.js utilities for R")
    (description
     "This package provides a suite of functions to help ease the use of the
d3.js visualization library in R.  These helpers include
@code{htmltools::htmlDependency} functions, hierarchy builders, and conversion
tools for @code{partykit}, @code{igraph}, @code{table}, and @code{data.frame}
R objects into the JSON format that the d3.js library expects.")
    (license license:bsd-3)))

;; We use the latest commit here because the last release was in 2016 while
;; the latest commit was in 2018.
(define-public r-sankeyd3
  (let ((commit "fd50a74e29056e0d67d75b4d04de47afb2f932bc")
        (revision "1"))
    (package
      (name "r-sankeyd3")
      (version (git-version "0.3.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/fbreitwieser/sankeyD3")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0jrcnfax321pszbpjdifnkbrgbjr43bjzvlzv1p5a8wskksqwiyx"))))
      (build-system r-build-system)
      (propagated-inputs
       (list r-d3r r-htmlwidgets r-shiny r-magrittr))
      (home-page "https://github.com/fbreitwieser/sankeyD3")
      (synopsis "Sankey network graphs from R")
      (description
       "This package provides an R library to generate Sankey network graphs
in R and Shiny via the D3 visualization library.")
      ;; The R code is licensed under GPLv3+.  It includes the non-minified
      ;; JavaScript source code of d3-sankey, which is released under the
      ;; 3-clause BSD license.
      (license (list license:gpl3+ license:bsd-3)))))

(define-public r-wesanderson
  (package
    (name "r-wesanderson")
    (version "0.3.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "wesanderson" version))
       (sha256
        (base32
         "09mr6p2jmqdjq27cz974w5hyxgn929zp9z3inhxqmmh1582fmdi2"))))
    (properties `((upstream-name . "wesanderson")))
    (build-system r-build-system)
    (home-page "https://github.com/karthik/wesanderson")
    (synopsis "Wes Anderson color palette generator")
    (description
     "This package provides color palettes that have been generated mostly
from Wes Anderson movies.")
    (license license:expat)))

(define-public r-gg-gap
  (package
    (name "r-gg-gap")
    (version "1.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gg.gap" version))
       (sha256
        (base32
         "0m66050ryn31xmsmmikjsssllasvjdmp9yjbwfdwfpwdv106zn9h"))))
    (properties `((upstream-name . "gg.gap")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cowplot r-ggplot2))
    (home-page "https://github.com/ChrisLou-bioinfo/gg.gap")
    (synopsis "Define segments on the y-axis for ggplot2")
    (description
     "The @code{gg.gap} function enables you to define segments for the y-axis
in a ggplot2 plot.")
    (license license:gpl3)))

(define-public r-mbess
  (package
    (name "r-mbess")
    (version "4.9.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "MBESS" version))
       (sha256
        (base32 "0cq4z7nx361rcw42jflrrdjbqs2q5973dlvhcr7i2wbkj3gzkwla"))))
    (properties `((upstream-name . "MBESS")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-boot r-lavaan r-mass r-mnormt r-nlme r-openmx r-sem r-semtools))
    (home-page "https://www3.nd.edu/~kkelley/site/MBESS.html")
    (synopsis "Methods for designing research studies")
    (description
     "This package implements methods that are useful in designing research
studies and analyzing data, with particular emphasis on methods that are
developed for or used within the behavioral, educational, and social
sciences (broadly defined).  That being said, many of the methods implemented
within MBESS are applicable to a wide variety of disciplines.  MBESS has a
suite of functions for a variety of related topics, such as effect sizes,
confidence intervals for effect sizes (including standardized effect sizes and
noncentral effect sizes), sample size planning (from the @dfn{accuracy in
parameter estimation} (AIPE), power analytic, equivalence, and minimum-risk
point estimation perspectives), mediation analysis, various properties of
distributions, and a variety of utility functions.")
    ;; Either version of the GPL.
    (license (list license:gpl2 license:gpl3))))

(define-public r-homologene
  (package
    (name "r-homologene")
    (version "1.4.68.19.3.27")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "homologene" version))
       (sha256
        (base32 "0d7wxisk0vqk1n165v1i19bc02zv78h5r5d3jqai5y6nkmwn01sh"))))
    (properties `((upstream-name . "homologene")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr r-magrittr r-purrr r-r-utils r-readr))
    (home-page "https://github.com/oganm/homologene")
    (synopsis "Quick access to homologene and gene annotation updates")
    (description
     "This package provides a wrapper for the homologene database by the
National Center for Biotechnology Information (NCBI).  It allows searching for
gene homologs across species.  The package also includes an updated version of
the homologene database where gene identifiers and symbols are replaced with
their latest (at the time of submission) version and functions to fetch latest
annotation data to keep updated.")
    (license license:expat)))

(define-public r-ggtern
  (package
    (name "r-ggtern")
    (version "3.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggtern" version))
       (sha256
        (base32 "01j1rvff3vz72vwqsy3bh81aav7gfymg4sbvc267vg0r3a16ywcg"))))
    (properties `((upstream-name . "ggtern")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-compositions
           r-ggplot2
           r-gridextra
           r-gtable
           r-hexbin
           r-latex2exp
           r-lattice
           r-mass
           r-plyr
           r-proto
           r-scales))
    (home-page "http://www.ggtern.com")
    (synopsis "Extension to ggplot2 for ternary diagrams")
    (description
     "This package extends the functionality of ggplot2, providing the
capability to plot ternary diagrams for (a subset of) the ggplot2 geometries.
Additionally, ggtern has implemented several new geometries which are
unavailable to the standard ggplot2 release.")
    (license license:gpl2)))

(define-public r-tablerdash
  (package
    (name "r-tablerdash")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tablerDash" version))
       (sha256
        (base32
         "1mnp6lxa7d669r325aynq1n3f35r9sy4v1fvdh4cymbf33s8mkmm"))
       (snippet
        '(begin
           ;; Delete minified JavaScript
           (for-each delete-file
                     '("inst/tablerDash-0.1.0/require.min.js"
                       "inst/bootstrap-4.0.0/bootstrap.bundle.min.js"))
           #true))))
    (properties `((upstream-name . "tablerDash")))
    (build-system r-build-system)
    (arguments
     `(#:modules ((guix build utils)
                  (guix build r-build-system)
                  (srfi srfi-1))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst"
               (call-with-values
                   (lambda ()
                     (unzip2
                      `((,(assoc-ref inputs "js-requirejs")
                         "tablerDash-0.1.0/require.min.js")
                        (,(assoc-ref inputs "js-bootstrap")
                         "bootstrap-4.0.0/bootstrap.bundle.min.js"))))
                 (lambda (sources targets)
                   (for-each (lambda (source target)
                               (format #t "Processing ~a --> ~a~%"
                                       source target)
                               (invoke "esbuild" source "--minify"
                                       (string-append "--outfile=" target)))
                             sources targets))))
             #t)))))
    (propagated-inputs
     (list r-htmltools r-knitr r-shiny))
    (native-inputs
     `(("esbuild" ,esbuild)
       ("js-requirejs"
        ,(origin
           (method url-fetch)
           (uri "https://raw.githubusercontent.com/requirejs/requirejs/2.3.5/require.js")
           (sha256
            (base32
             "06w32mwqii9cx409ivda88z58qbkcdb4p6hf6jawchsgagaziyds"))))
       ("js-bootstrap"
        ,(origin
           (method url-fetch)
           (uri "https://raw.githubusercontent.com/twbs/bootstrap/\
v4.0.0/dist/js/bootstrap.bundle.js")
           (sha256
            (base32
             "0cvfqffn45vfbj3fk6wmrhkyndhk4id89vgydssbbzxjkfwprfrj"))))))
    (home-page "https://rinterface.github.io/tablerDash/")
    (synopsis "Tabler API for Shiny")
    (description
     "This package provides an R interface to the
@url{https://tabler.io,Tabler} HTML template.  tablerDash is a light Bootstrap
4 dashboard template.  There are different layouts available such as a one
page dashboard or a multi-page template, where the navigation menu is
contained in the navigation bar.")
    (license license:gpl2+)))

(define-public r-spelling
  (package
    (name "r-spelling")
    (version "2.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "spelling" version))
       (sha256
        (base32
         "179nj9w1v27qq9q5240ddvggp0795998sxyqjvbqjvq9dmach3bl"))))
    (properties `((upstream-name . "spelling")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-commonmark r-hunspell r-knitr r-xml2))
    (home-page "https://docs.ropensci.org/spelling/")
    (synopsis "Tools for spell checking in R")
    (description
     "This is an R package for spell checking common document formats
including LaTeX, markdown, manual pages, and DESCRIPTION files.  It includes
utilities to automate checking of documentation and vignettes as a unit test
during @code{R CMD check}.  Both British and American English are supported
out of the box and other languages can be added.  In addition, packages may
define a wordlist to allow custom terminology without having to abuse
punctuation.")
    (license license:expat)))

(define-public r-crosstalk
  (package
    (name "r-crosstalk")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "crosstalk" version))
       (sha256
        (base32
         "180y7mhpj17axpadwhh7s0qvrpdnag7g977vk256l96d6nmvlds2"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-htmltools r-jsonlite r-lazyeval r-r6))
    (home-page "https://rstudio.github.io/crosstalk/")
    (synopsis "Inter-widget interactivity for HTML widgets")
    (description
     "This package provides building blocks for allowing HTML widgets to
communicate with each other, with Shiny or without (i.e., static @code{.html}
files).  It currently supports linked brushing and filtering.")
    (license license:expat)))

(define-public r-rook
  (package
    (name "r-rook")
    (version "1.1-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Rook" version))
       (sha256
        (base32
         "00s9a0kr9rwxvlq433daxjk4ji8m0w60hjdprf502msw9kxfrx00"))))
    (properties `((upstream-name . "Rook")))
    (build-system r-build-system)
    (propagated-inputs (list r-brew))
    (home-page "https://cran.r-project.org/web/packages/Rook")
    (synopsis "Web server interface for R")
    (description
     "This package contains the Rook specification and convenience software
for building and running Rook applications.  A Rook application is an R
reference class object that implements a @code{call} method or an R closure
that takes exactly one argument, an environment, and returns a list with three
named elements: the @code{status}, the @code{headers}, and the @code{body}.")
    (license license:gpl2)))

(define-public r-miniui
  (package
    (name "r-miniui")
    (version "0.1.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "miniUI" version))
       (sha256
        (base32
         "1h5h2sc57h95d6bsgs95l26911g38hvjc1v50bc31xl9689l2as5"))))
    (properties `((upstream-name . "miniUI")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-htmltools r-shiny))
    (home-page "https://cran.r-project.org/web/packages/miniUI/")
    (synopsis "Shiny UI widgets for small screens")
    (description
     "This package provides UI widget and layout functions for writing Shiny apps that
work well on small screens.")
    (license license:gpl3)))

(define-public r-feather
  (package
    (name "r-feather")
    (version "0.3.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "feather" version))
       (sha256
        (base32
         "1gxd0h2m56sjjlzn4dry6s13nddxc4l5i11gsvavaf2dwbahdzsh"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-hms r-rcpp r-tibble))
    (home-page "https://github.com/wesm/feather")
    (synopsis "R Bindings to the Feather API")
    (description "Read and write feather files, a lightweight binary columnar
data store designed for maximum speed.")
    (license license:asl2.0)))

(define-public r-maps
  (package
    (name "r-maps")
    (version "3.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "maps" version))
       (sha256
        (base32
         "0034114pdakxcx480b45qy9j4vq1v5ss961ssy92w4nqiqhsb4z6"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/maps")
    (synopsis "Draw geographical maps")
    (description "This package provides an R module for display of maps.
Projection code and larger maps are in separate packages (@code{mapproj} and
@code{mapdata}).")
    (license license:gpl2)))

(define-public r-mapproj
  (package
    (name "r-mapproj")
    (version "1.2.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mapproj" version))
       (sha256
        (base32
         "10nzfbyfkc545qxf51i33g0f8iiidcnhj971ylphnbh7j2sgla6s"))))
    (build-system r-build-system)
    (propagated-inputs (list r-maps))
    (home-page "https://cran.r-project.org/web/packages/mapproj")
    (synopsis "Map projection in R")
    (description "This package converts latitude/longitude into projected
coordinates.")
    (license (list license:gpl2          ; The R interface
                   (license:non-copyleft ; The C code
                    "https://www.gnu.org/licenses/license-list.en.html#lucent102"
                    "Lucent Public License Version 1.02")))))

(define-public r-rgooglemaps
  (package
    (name "r-rgooglemaps")
    (version "1.4.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RgoogleMaps" version))
       (sha256
        (base32
         "02v8k0bw70q4qwx4lcdy8p25q7n3ql2ll46lfpqllxa1p26svmfi"))))
    (properties `((upstream-name . "RgoogleMaps")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-png r-sp))
    (home-page "https://cran.r-project.org/web/packages/RgoogleMaps")
    (synopsis "Use Google Maps in R")
    (description "This package serves two purposes:
@enumerate
@item Provide a comfortable R interface to query the Google server for static
  maps, and
@item Use the map as a background image to overlay plots within R.  This
  requires proper coordinate scaling.
@end enumerate\n")
    (license license:gpl2+)))

(define-public r-gensa
  (package
    (name "r-gensa")
    (version "1.1.7")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "GenSA" version))
              (sha256
               (base32
                "03xqwxm7v7rnihx730a4p65dfwhjh4345r3d78y0qxxplk8d76cx"))))
    (properties `((upstream-name . "GenSA")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=GenSA")
    (synopsis "Generalized simulated annealing")
    (description "This package performs search for the global minimum of a very
complex non-linear objective function with a very large number of optima.")
    (license license:gpl2)))

(define-public r-geosphere
  (package
    (name "r-geosphere")
    (version "1.5-14")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "geosphere" version))
       (sha256
        (base32
         "0bg4vfmrw140j2ax0p6bflvb77w03ir39wa87l96rj473jpa9hzj"))))
    (build-system r-build-system)
    (propagated-inputs (list r-sp))
    (home-page "https://cran.r-project.org/web/packages/geosphere")
    (synopsis "Spherical trigonometry")
    (description "This package computes spherical trigonometry for geographic
applications.  That is, compute distances and related measures for angular
(longitude/latitude) locations.")
    (license license:gpl3+)))

(define-public r-jpeg
  (package
    (name "r-jpeg")
    (version "0.1-9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "jpeg" version))
       (sha256
        (base32
         "0wihj538wdnr71wdldym83qadb4kh68a6rkallwbh2f25r27b881"))))
    (build-system r-build-system)
    (inputs (list libjpeg-turbo))
    (home-page "https://www.rforge.net/jpeg/")
    (synopsis "Read and write JPEG images with R")
    (description "This package provides a way to read, write and display
bitmap images stored in the JPEG format with R.  It can read and write both
files and in-memory raw vectors.")
    (license license:gpl2+)))

(define-public r-ggmap
  (package
    (name "r-ggmap")
    (version "3.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggmap" version))
       (sha256
        (base32
         "13dmzl6z62pzjiffilarkji46vy0sacxa8a7mhrhc3biq3ylzhln"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bitops
           r-digest
           r-dplyr
           r-ggplot2
           r-glue
           r-httr
           r-jpeg
           r-magrittr
           r-plyr
           r-png
           r-purrr
           r-rgooglemaps
           r-rjson
           r-scales
           r-stringr
           r-tibble
           r-tidyr))
    (home-page "https://github.com/dkahle/ggmap")
    (synopsis "Spatial visualization with ggplot2")
    (description "This package provides a collection of functions to visualize
spatial data and models on top of static maps from various online sources (e.g
Google Maps and Stamen Maps).  It includes tools common to those tasks,
including functions for geolocation and routing.")
    (license license:gpl2)))

(define-public r-haven
  (package
    (name "r-haven")
    (version "2.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "haven" version))
       (sha256
        (base32
         "0w0aqm0z4h0rm1f7fylm1mbv79p43y2r795w64wczcd0jwh4ch4z"))
       (modules '((guix build utils)))
       (snippet
        ;; unvendor readstat
        '(delete-file-recursively "src/readstat"))))
    (build-system r-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'unbundle-readstat
           (lambda _
             ;; We’re not building readstat.
             (substitute* "configure"
               (("exit 1") "")) ;don't be so dramatic!
             (substitute* '("src/Makevars.in"
                            "configure")
               (("^PKG_LIBS=.*") "PKG_LIBS=\"-lreadstat\"\n")))))))
    (inputs
     (list readstat))
    (native-inputs
     (list r-knitr))
    (propagated-inputs
     (list r-cli
           r-cpp11
           r-forcats
           r-hms
           r-lifecycle
           r-rlang
           r-readr
           r-tibble
           r-tidyselect
           r-vctrs))
    (home-page "https://haven.tidyverse.org")
    (synopsis "Import and export SPSS, Stata and SAS files")
    (description
     "This package lets you import foreign statistical formats into R via the
@url{https://github.com/WizardMac/ReadStat,ReadStat} C library.")
    (license license:expat)))

(define-public r-amap
  (package
    (name "r-amap")
    (version "0.8-19")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "amap" version))
              (sha256
               (base32
                "000r5705lq2mc15skin07dfxjf5816nbfy4gqkya1sv99dlfljbk"))))
    (build-system r-build-system)
    (native-inputs
     (list gfortran))
    (home-page "http://mulcyber.toulouse.inra.fr/projects/amap/")
    (synopsis "Another multidimensional analysis package")
    (description "This package provides tools for clustering and principal
component analysis (with robust methods, and parallelized functions).")
    (license license:gpl2+)))

(define-public r-ape
  (package
    (name "r-ape")
    (version "5.6-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ape" version))
       (sha256
        (base32
         "0mqjsh7maczd02iwa4fb896q3kgd9jnlilq7y1yz18ch0c54aqlv"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lattice r-nlme r-rcpp))
    (home-page "http://ape-package.ird.fr/")
    (synopsis "Analyses of phylogenetics and evolution")
    (description
     "This package provides functions for reading, writing, plotting, and
manipulating phylogenetic trees, analyses of comparative data in a
phylogenetic framework, ancestral character analyses, analyses of
diversification and macroevolution, computing distances from DNA sequences,
and several other tools.")
    (license license:gpl2+)))

(define-public r-abbyyr
  (package
    (name "r-abbyyr")
    (version "0.5.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abbyyR" version))
       (sha256
        (base32
         "1vldnd3dg89aj6a73nhirirqddbfdrnzhb5m3679i60sark8nk6r"))))
    (properties `((upstream-name . "abbyyR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-curl
           r-httr
           r-plyr
           r-progress
           r-readr
           r-xml))
    (home-page "https://github.com/soodoku/abbyyR")
    (synopsis "Access to Abbyy Optical Character Recognition (OCR) API")
    (description
     "This package provides tools to get text from images of text using Abbyy
Cloud Optical Character Recognition (OCR) API.  With abbyyyR, one can easily
OCR images, barcodes, forms, documents with machine readable zones, e.g.
passports and get the results in a variety of formats including plain text and
XML.  To learn more about the Abbyy OCR API, see @url{http://ocrsdk.com/}.")
    (license license:expat)))

(define-public r-colorspace
  (package
    (name "r-colorspace")
    (version "2.0-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "colorspace" version))
       (sha256
        (base32 "0zw52s8g2gxp8i1ax96azxmxqrbhb7aad5px0c1vgr6n9p682mp7"))))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/colorspace")
    (synopsis "Color space manipulation")
    (description
     "This package carries out a mapping between assorted color spaces
including RGB, HSV, HLS, CIEXYZ, CIELUV, HCL (polar CIELUV), CIELAB and polar
CIELAB.  Qualitative, sequential, and diverging color palettes based on HCL
colors are provided.")
    (license license:bsd-3)))

(define-public r-glue
  (package
    (name "r-glue")
    (version "1.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "glue" version))
       (sha256
        (base32
         "1gzxk5jgdh2xq9r7z09xs306ygzf27vhg3pyfl7ck1755gqii9cx"))))
    (build-system r-build-system)
    ;; knitr depends on glue, so we can't add knitr here to build the
    ;; vignettes.
    #;
    (native-inputs
     `(("r-knitr" ,r-knitr)))
    (home-page "https://github.com/tidyverse/glue")
    (synopsis "Interpreted string literals")
    (description
     "This package provides an implementation of interpreted string literals,
inspired by Python's Literal String Interpolation (PEP-0498) and
Docstrings (PEP-0257) and Julia's Triple-Quoted String Literals.")
    (license license:expat)))

(define-public r-glmnetutils
  (package
    (name "r-glmnetutils")
    (version "1.1.8")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "glmnetUtils" version))
              (sha256
               (base32
                "1k8ivzjgpkm2a948qxx3wmkhlppbk31qc76spv2pscmp24x0lxyn"))))
    (properties `((upstream-name . "glmnetUtils")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-glmnet
           r-matrix))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/hongooi73/glmnetUtils")
    (synopsis
     "Streamline the process of fitting elastic net models with glmnet")
    (description
     "This package provides a collection of tools to streamline the
process of fitting elastic net models with @code{glmnet}.  In addition
to providing a formula interface, it also features a function
@code{cva.glmnet} to do crossvalidation for both α and λ, as well as
some utility functions.")
    (license license:gpl2)))

(define-public r-paletteer
  (package
    (name "r-paletteer")
    (version "1.5.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "paletteer" version))
              (sha256
               (base32
                "1mm0k651356cjasv7wibscw82m1k8mwpp4xafpv66dsq24h28ikl"))))
    (properties `((upstream-name . "paletteer")))
    (build-system r-build-system)
    (propagated-inputs (list r-prismatic r-rematch2 r-rlang r-rstudioapi))
    (home-page "https://github.com/EmilHvitfeldt/paletteer")
    (synopsis "Comprehensive collection of color palettes")
    (description
     "The choices of color palettes in R can be quite overwhelming with palettes
spread over many packages with many different API's.  This package aims to
collect all color palettes across the R ecosystem under the same package with
a streamlined API.")
    (license license:gpl3)))

(define-public r-palmerpenguins
  (package
    (name "r-palmerpenguins")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "palmerpenguins" version))
       (sha256
        (base32
         "1d1h3bfx750is4qqj4w00rcigk9rrdy69bvd5bgqz5y7ls5x8h1a"))))
    (properties
     `((upstream-name . "palmerpenguins")))
    (build-system r-build-system)
    (home-page "https://allisonhorst.github.io/palmerpenguins/")
    (synopsis "Palmer Archipelago (Antarctica) penguin data")
    (description
     "This package includes size measurements, clutch observations, and blood
isotope ratios for adult foraging Adélie, Chinstrap, and Gentoo penguins
observed on islands in the Palmer Archipelago near Palmer Station, Antarctica.
Data were collected and made available by Dr. Kristen Gorman and the Palmer
Station Long Term Ecological Research (LTER) Program.")
    (license license:cc0)))

(define-public r-pastecs
  (package
   (name "r-pastecs")
   (version "1.3.21")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "pastecs" version))
            (sha256
             (base32
              "0z4dic94ar646w7zc2ggi5hgvf2qnznsani94c5pyql8zspz47lc"))))
   (build-system r-build-system)
   (propagated-inputs
    (list r-boot))
   (home-page "https://github.com/phgrosjean/pastecs")
   (synopsis "Analysis of space-time ecological series")
   (description
    "This package provides functions for regulation, decomposition and analysis
of space-time series.  The @code{pastecs} library is a PNEC-Art4 and IFREMER
initiative to bring PASSTEC 2000 functionalities to R.")
   (license license:gpl2+)))

(define-public r-partykit
  (package
   (name "r-partykit")
   (version "1.2-16")
   (source (origin
             (method url-fetch)
             (uri (cran-uri "partykit" version))
             (sha256
              (base32
               "1cnx6qbw5svwh3nq40n5vr20179ihd3jgznm7mz4k50qkkid8hz6"))))
   (build-system r-build-system)
   (propagated-inputs
    (list r-formula
          r-inum
          r-libcoin
          r-mvtnorm
          r-rpart
          r-survival))
   (home-page "http://partykit.R-Forge.R-project.org/partykit")
   (synopsis "Toolkit for recursive partytioning")
   (description
    "This package provides a toolkit with infrastructure for representing,
summarizing, and visualizing tree-structured regression and classification
models.")
   (license license:gpl2+)))

(define-public r-plogr
  (package
    (name "r-plogr")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "plogr" version))
       (sha256
        (base32
         "0a8dhzlna79ggyhfr0nncgh15a9n6r0dsz664pz0ah323wpblqqf"))))
    (build-system r-build-system)
    (home-page "https://github.com/krlmlr/plogr")
    (synopsis "R bindings for the plog C++ logging library")
    (description
     "This package provides the header files for a stripped-down version of
the plog header-only C++ logging library, and a method to log to R's standard
error stream.")
    (license license:expat)))

(define-public r-pls
  (package
    (name "r-pls")
    (version "2.8-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pls" version))
       (sha256
        (base32 "137jg3x7aqwyki29i4kzp8d6imn17nq6wzzfjw5q19pixvmpybp2"))))
    (build-system r-build-system)
    (home-page "https://mevik.net/work/software/pls.html")
    (synopsis "Partial Least Squares and Principal Component Regression")
    (description
     "The pls package implements multivariate regression methods: Partial Least
Squares Regression (@dfn{PLSR}), Principal Component Regression (@dfn{PCR}), and
Canonical Powered Partial Least Squares (@dfn{CPPLS}).  It supports:

@itemize
@item several algorithms: the traditional orthogonal scores (@dfn{NIPALS}) PLS
algorithm, kernel PLS, wide kernel PLS, Simpls, and PCR through @code{svd}
@item multi-response models (or @dfn{PLS2})
@item flexible cross-validation
@item Jackknife variance estimates of regression coefficients
@item extensive and flexible plots: scores, loadings, predictions, coefficients,
(R)MSEP, R², and correlation loadings
@item formula interface, modelled after @code{lm()}, with methods for predict,
print, summary, plot, update, etc.
@item extraction functions for coefficients, scores, and loadings
@item MSEP, RMSEP, and R² estimates
@item multiplicative scatter correction (@dfn{MSC})
@end itemize\n")
    (license license:gpl2)))

(define-public r-ps
  (package
    (name "r-ps")
    (version "1.7.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ps" version))
       (sha256
        (base32 "06mjwsn074195vd4yv7zzkmcf3sc124cw0cbnddj86swvggfn9cj"))))
    (build-system r-build-system)
    (home-page "https://ps.r-lib.org")
    (synopsis "List, query, and manipulate system processes")
    (description
     "The ps package implements an API to list, query, and manipulate system
processes.  Most of its code is based on the @code{psutil} Python package.")
    (license license:bsd-3)))

(define-public r-pkgbuild
  (package
    (name "r-pkgbuild")
    (version "1.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pkgbuild" version))
       (sha256
        (base32 "0j6v5nbp8kg1m3j999gd1qsbdmqcqm1mf28ngmm177miwv8q4skw"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-callr
           r-cli
           r-crayon
           r-desc
           r-prettyunits
           r-r6
           r-rprojroot
           r-withr))
    (home-page "https://github.com/r-pkgs/pkgbuild")
    (synopsis "Find tools needed to build R packages")
    (description
     "This package provides functions used to build R packages.  It locates
compilers needed to build R packages on various platforms and ensures the PATH
is configured appropriately so R can use them.")
    (license license:gpl3)))

(define-public r-pkgload
  (package
    (name "r-pkgload")
    (version "1.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pkgload" version))
       (sha256
        (base32
         "16k7n5hrwkzdwm54qyf5p6d1v5rf6vq688x48iylw6bygc6vgf66"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-crayon
           r-desc
           r-fs
           r-glue
           r-rlang
           r-rprojroot
           r-withr))
    (home-page "https://github.com/r-lib/pkgload")
    (synopsis "Simulate package installation and attach")
    (description
     "This package simulates the process of installing a package and then
attaching it.  This is a key part of the @code{devtools} package as it allows
you to rapidly iterate while developing a package.")
    (license license:gpl3)))

(define-public r-pvclust
  (package
   (name "r-pvclust")
   (version "2.2-0")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "pvclust" version))
            (sha256
             (base32
              "0082icm54k2yq60k06qpr92a626k39j2jr0046lva4ylmhxqb4kq"))))
   (build-system r-build-system)
   (home-page "https://github.com/shimo-lab/pvclust")
   (synopsis
    "Hierarchical clustering with P-values via multiscale bootstrap resampling")
   (description "This package provides an implementation of multiscale bootstrap
resampling for assessing the uncertainty in hierarchical cluster analysis.  It
provides an AU (approximately unbiased) P-value as well as a BP (bootstrap probability)
value for each cluster in a dendrogram.")
   (license license:gpl2+)))

(define-public r-rcpp
  (package
    (name "r-rcpp")
    (version "1.0.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Rcpp" version))
       (sha256
        (base32 "0xli48y9nsj8x8p5vkhisiz4l23g8r2623rn0i4xb5javh3fqz40"))))
    (build-system r-build-system)
    (home-page "http://www.rcpp.org")
    (synopsis "Seamless R and C++ integration")
    (description
     "The Rcpp package provides R functions as well as C++ classes which offer
a seamless integration of R and C++.  Many R data types and objects can be
mapped back and forth to C++ equivalents which facilitates both writing of new
code as well as easier integration of third-party libraries.  Documentation
about Rcpp is provided by several vignettes included in this package, via the
@code{Rcpp Gallery} site at <http://gallery.rcpp.org>, the paper by Eddelbuettel
and Francois (2011, JSS), and the book by Eddelbuettel (2013, Springer); see
@code{citation(\"Rcpp\")} for details on these last two.")
    (license license:gpl2+)))

(define-public r-rcppml
  (package
    (name "r-rcppml")
    (version "0.3.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RcppML" version))
       (sha256
        (base32 "1ih8i7i6m221iw227mnl3rvnaw2l53h8fpnc4f8yn9sm10anap1j"))))
    (properties `((upstream-name . "RcppML")))
    (build-system r-build-system)
    (propagated-inputs (list r-matrix r-rcpp r-rcppeigen))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/zdebruine/RcppML")
    (synopsis "Rcpp machine learning library")
    (description
     "This package provides fast machine learning algorithms including matrix
factorization and divisive clustering for large sparse and dense matrices.")
    (license license:gpl2+)))

(define-public r-rcppthread
  (package
    (name "r-rcppthread")
    (version "2.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RcppThread" version))
       (sha256
        (base32
         "0iprpidf7q1wlrgr9dwiikb6apqk80pyjcyni56k64nl7lrkszhj"))))
    (properties `((upstream-name . "RcppThread")))
    (build-system r-build-system)
    (home-page
     "https://github.com/tnagler/RcppThread")
    (synopsis "R threading in C++")
    (description
     "This package provides a C++11-style thread class and thread pool that can
safely be interrupted from R.")
    (license license:expat)))

(define-public r-rcppnumerical
  (package
    (name "r-rcppnumerical")
    (version "0.4-0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "RcppNumerical" version))
              (sha256
               (base32
                "1a92fql6mijhnr1kxkcxwivf95pk9lhgmhzkshs51h0ybfv5krik"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp r-rcppeigen))
    (home-page "https://github.com/yixuan/RcppNumerical")
    (synopsis"Numerical computing libraries integration with @code{Rcpp}")
    (description "This package provides a collection of libraries for numerical
computing (numerical integration, optimization, etc.) and their integration
with @code{Rcpp}.")
    (license license:gpl2+)))

(define-public r-rcppxptrutils
  (package
    (name "r-rcppxptrutils")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RcppXPtrUtils" version))
       (sha256
        (base32 "0hm57nf4dzgsmg4hjj6wikwjx93fgfwkmybw6ly4b58wi6qwml1l"))))
    (properties `((upstream-name . "RcppXPtrUtils")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (home-page "https://github.com/Enchufa2/RcppXPtrUtils")
    (synopsis "XPtr add-ons for Rcpp")
    (description
     "This package provides the means to compile user-supplied C++ functions
with Rcpp and retrieve an @code{XPtr} that can be passed to other C++
components.")
    (license license:expat)))

(define-public r-bindr
  (package
    (name "r-bindr")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bindr" version))
       (sha256
        (base32
         "1l05fpk2yql3jka321c0bdgx6mqq9pvfrg2844lbjfpbgjkmqy3w"))))
    (build-system r-build-system)
    (home-page "https://github.com/krlmlr/bindr")
    (synopsis "Parametrized active bindings")
    (description
     "This package provides a simple interface for creating active bindings
where the bound function accepts additional arguments.")
    (license license:expat)))

(define-public r-bindrcpp
  (package
    (name "r-bindrcpp")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bindrcpp" version))
       (sha256
        (base32
         "0rz4ibjdjsxl99ff3ha79z7cnjmilx4rx58fk9kk7ld9xc4hf4s8"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bindr r-plogr r-rcpp))
    (home-page "https://github.com/krlmlr/bindrcpp")
    (synopsis "Rcpp interface to active bindings")
    (description
     "This package provides an easy way to fill an environment with active
bindings that call a C++ function.")
    (license license:expat)))

(define-public r-auc
  (package
    (name "r-auc")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "AUC" version))
       (sha256
        (base32
         "07xf47kypqbsg2mixmq6mnh4s89aqan9bgl6kfv6lbx8ajv2asw3"))))
    (properties `((upstream-name . "AUC")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/AUC")
    (synopsis "Compute the area under the curve of selected measures")
    (description
     "This package includes functions to compute the area under the curve of
selected measures: the area under the sensitivity curve (AUSEC), the area
under the specificity curve (AUSPC), the area under the accuracy
curve (AUACC), and the area under the receiver operating characteristic
curve (AUROC).  The curves can also be visualized.  Support for partial areas
is provided.")
    (license license:gpl2+)))

(define-public r-calibrate
  (package
    (name "r-calibrate")
    (version "1.7.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "calibrate" version))
       (sha256
        (base32 "19kgrnsyq67iqv1biyssqi30a6v2836ql20nabpy2m692ns0jfvi"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mass))
    (home-page "https://cran.r-project.org/web/packages/calibrate")
    (synopsis "Calibration of scatterplot and biplot axes")
    (description
     "This is a package for drawing calibrated scales with tick marks
on (non-orthogonal) variable vectors in scatterplots and biplots.")
    (license license:gpl2)))

(define-public r-shape
  (package
    (name "r-shape")
    (version "1.4.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shape" version))
       (sha256
        (base32
         "0yqbrrx2ywmfl99s6d1n6jblc63k1mxbiqyv8y0kq8jws1g3w45r"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/shape")
    (synopsis "Functions for plotting graphical shapes")
    (description
     "This package provides functions for plotting graphical shapes such as
ellipses, circles, cylinders, arrows, ...")
    (license license:gpl3+)))

(define-public r-globaloptions
  (package
    (name "r-globaloptions")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "GlobalOptions" version))
       (sha256
        (base32 "0gkm77w6db9ajyncy1xdcivplap06a51zi99m009kylccschd2a7"))))
    (properties `((upstream-name . "GlobalOptions")))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/jokergoo/GlobalOptions")
    (synopsis "Generate functions to get or set global options")
    (description
     "This package provides more controls on the option values such as
validation and filtering on the values, making options invisible or private.")
    (license license:gpl2+)))

(define-public r-circlize
  (package
    (name "r-circlize")
    (version "0.4.15")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "circlize" version))
       (sha256
        (base32
         "1iswb7dy08as3pbzxvhx5qlsbnwvp79nwg8m158nfz7y2d9xa0nn"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-colorspace r-globaloptions r-shape))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/jokergoo/circlize")
    (synopsis "Circular visualization")
    (description
     "Circular layout is an efficient way to visualise huge amounts of
information.  This package provides an implementation of circular layout
generation in R as well as an enhancement of available software.  Its
flexibility is based on the usage of low-level graphics functions such that
self-defined high-level graphics can be easily implemented by users for
specific purposes.  Together with the seamless connection between the powerful
computational and visual environment in R, it gives users more convenience and
freedom to design figures for better understanding complex patterns behind
multi-dimensional data.")
    (license license:gpl2+)))

(define-public r-powerlaw
  (package
    (name "r-powerlaw")
    (version "0.70.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "poweRlaw" version))
       (sha256
        (base32 "14d1myxllvm1grnfiszzzxaiqpb2jpmsi19wq70r8r2wki293h7g"))))
    (properties `((upstream-name . "poweRlaw")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-pracma))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/csgillespie/poweRlaw")
    (synopsis "Tools for the analysis of heavy tailed distributions")
    (description
     "This package provides an implementation of maximum likelihood estimators
for a variety of heavy tailed distributions, including both the discrete and
continuous power law distributions.  Additionally, a goodness-of-fit based
approach is used to estimate the lower cut-off for the scaling region.")
    ;; Any of these GPL versions.
    (license (list license:gpl2 license:gpl3))))

(define-public r-compare
  (package
    (name "r-compare")
    (version "0.2-6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "compare" version))
       (sha256
        (base32
         "0k9zms930b5dz9gy8414li21wy0zg9x9vp7301v5cvyfi0g7xzgw"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/compare")
    (synopsis "Comparing objects for differences")
    (description
     "This package provides functions to compare a model object to a
comparison object.  If the objects are not identical, the functions can be
instructed to explore various modifications of the objects (e.g., sorting
rows, dropping names) to see if the modified versions are identical.")
    (license license:gpl2+)))

(define-public r-dendextend
  (package
    (name "r-dendextend")
    (version "1.16.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dendextend" version))
       (sha256
        (base32
         "0rl4f0b73s1gdjfxgpnz87lhv131qazxb6vsv2935ad266fd0bzc"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-magrittr r-viridis))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/dendextend")
    (synopsis "Extending 'dendrogram' functionality in R")
    (description
     "This package offers a set of functions for extending @code{dendrogram}
objects in R, letting you visualize and compare trees of hierarchical
clusterings.  You can adjust a tree's graphical parameters (the color, size,
type, etc of its branches, nodes and labels) and visually and statistically
compare different dendrograms to one another.")
    ;; Any of these versions
    (license (list license:gpl2 license:gpl3))))

(define-public r-getoptlong
  (package
    (name "r-getoptlong")
    (version "1.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "GetoptLong" version))
       (sha256
        (base32
         "00fpm6nd3kqa2ikasxa62jzywi46fvvmx1mdavcp5yrxxn37j8wc"))))
    (properties `((upstream-name . "GetoptLong")))
    (build-system r-build-system)
    (inputs
     (list perl))
    (propagated-inputs
     (list r-crayon r-globaloptions r-rjson))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/jokergoo/GetoptLong")
    (synopsis "Parsing command-line arguments and variable interpolation")
    (description
     "This is yet another command-line argument parser which wraps the
powerful Perl module @code{Getopt::Long} and with some adaptation for easier
use in R.  It also provides a simple way for variable interpolation in R.")
    (license license:gpl2+)))

(define-public r-fastmatch
  (package
    (name "r-fastmatch")
    (version "1.1-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fastmatch" version))
       (sha256
        (base32
         "0qcq1gwl9pijgp34giyq5y9rk0ly3d7xza2b7r68xx63ifqa1vqx"))))
    (build-system r-build-system)
    (home-page "https://www.rforge.net/fastmatch")
    (synopsis "Fast match function")
    (description
     "This package provides a fast @code{match} replacement for cases that
require repeated look-ups.  It is slightly faster that R's built-in
@code{match} function on first match against a table, but extremely fast on
any subsequent lookup as it keeps the hash table in memory.")
    (license license:gpl2)))

(define-public r-ff
  (package
    (name "r-ff")
    (version "4.0.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ff" version))
       (sha256
        (base32
         "1yl3ipzz9bjkfy9bbna7xz5n7iz4lchnw5l7agww7by764yk6iqa"))))
    (build-system r-build-system)
    (propagated-inputs (list r-bit))
    (home-page "http://ff.r-forge.r-project.org/")
    (synopsis "Memory-efficient storage of large data on disk and access functions")
    (description
     "This package provides data structures that are stored on disk but
behave (almost) as if they were in RAM by transparently mapping only a section
in main memory.")
    ;; error Architecture not supported.
    (supported-systems (delete "aarch64-linux" %supported-systems))
    (license license:gpl2)))

(define-public r-ffbase
  (package
    (name "r-ffbase")
    (version "0.13.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ffbase" version))
       (sha256
        (base32
         "1dp6lblfq2j7r1b4b8ls47jlx8j27n88d5vp8w116lb8pa01zxmk"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bit r-fastmatch r-ff))
    (home-page "https://github.com/edwindj/ffbase")
    (synopsis "Basic statistical functions for package 'ff'")
    (description
     "This package extends the out of memory vectors of @code{ff} with
statistical functions and other utilities to ease their usage.")
    (license license:gpl3)))

(define-public r-prettyunits
  (package
    (name "r-prettyunits")
    (version "1.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "prettyunits" version))
       (sha256
        (base32
         "1ibmzgknw5896q2i6r59jz2izblxwgb29ivvjzx50pkd1jl9l6cs"))))
    (build-system r-build-system)
    (home-page "https://github.com/gaborcsardi/prettyunits")
    (synopsis "Pretty, human readable formatting of quantities")
    (description
     "This package provides tools for pretty, human readable formatting of
quantities.")
    (license license:expat)))

(define-public r-princurve
  (package
   (name "r-princurve")
   (version "2.1.6")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "princurve" version))
            (sha256
             (base32
              "0wzk329bxljkzz57y220lsfckpsn45w348m6dcxh29zbj0ik65h2"))))
   (build-system r-build-system)
   (propagated-inputs
    (list r-rcpp))
   (home-page "https://github.com/rcannood/princurve")
   (synopsis "Fit a principal curve in arbitrary dimension")
   (description "This package provides procedures for fitting a principal
curve to a data matrix in arbitrary dimensions.")
   (license license:gpl2)))

(define-public r-prismatic
  (package
    (name "r-prismatic")
    (version "1.1.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "prismatic" version))
              (sha256
               (base32
                "013i0mq4n8s2zbzvfrz1vjcn2a6l98bamslkcv1a3cn70gpphja9"))))
    (properties `((upstream-name . "prismatic")))
    (build-system r-build-system)
    (propagated-inputs (list r-farver))
    (home-page "https://github.com/EmilHvitfeldt/prismatic")
    (synopsis "Color manipulation tools")
    (description
     "Manipulate and visualize colors in a intuitive, low-dependency and functional
way.")
    (license license:expat)))

(define-public r-reshape
  (package
    (name "r-reshape")
    (version "0.8.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "reshape" version))
       (sha256
        (base32
         "0j203qmc076x5lp6q2xi4dq4xdb73jmsa42rpxp1c37knnrph4br"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-plyr))
    (home-page "http://had.co.nz/reshape")
    (synopsis "Flexibly reshape data")
    (description
     "Flexibly restructure and aggregate data using just two functions:
@code{melt} and @code{cast}.  This package provides them.")
    (license license:expat)))

(define-public r-restrserve
  (package
    (name "r-restrserve")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RestRserve" version))
       (sha256
        (base32 "1xfcp0y9l31815g1jk33mnkb6z68qpjl0gb4fj7f4578kx3v1c8p"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-checkmate
           r-digest
           r-jsonlite
           r-mime
           r-r6
           r-rcpp
           r-rserve
           r-uuid))
    (native-inputs
     (list r-knitr))
    (home-page "https://restrserve.org")
    (synopsis "R web API framework")
    (description
     "RestRserve is an R web API framework for building high-performance AND
robust microservices and app backends.  With Rserve backend on UNIX-like
systems it is parallel by design.  It will handle incoming requests in
parallel - each request in a separate fork.")
    (license license:gpl2+)))

(define-public r-progress
  (package
    (name "r-progress")
    (version "1.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "progress" version))
       (sha256
        (base32
         "0dgzb362641aqm8xd88iqa8jmpdm43xs0aba0d5kk6fvapnxi95l"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-crayon r-hms r-prettyunits r-r6))
    (home-page "https://github.com/gaborcsardi/progress")
    (synopsis "Terminal progress bars")
    (description
     "This package provides configurable progress bars.  They may include
percentage, elapsed time, and/or the estimated completion time.  They work in
terminals, in Emacs ESS, RStudio, Windows Rgui, and the macOS R.app.  The
package also provides a C++ API, that works with or without Rcpp.")
    (license license:expat)))

(define-public r-ggally
  (package
    (name "r-ggally")
    (version "2.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "GGally" version))
       (sha256
        (base32
         "1r98zgh2grn8330cf26r1c20gl131zm778szvn5wj6q6pwv2yd9h"))))
    (properties `((upstream-name . "GGally")))
    (build-system r-build-system)
    (inputs
     (list openssl))
    (propagated-inputs
     (list r-dplyr
           r-forcats
           r-ggplot2
           r-gtable
           r-lifecycle
           r-plyr
           r-progress
           r-rcolorbrewer
           r-reshape
           r-rlang
           r-scales
           r-tidyr))
    (home-page "https://ggobi.github.io/ggally")
    (synopsis "Extension to ggplot2")
    (description
     "The R package ggplot2 is a plotting system based on the grammar of
graphics.  GGally extends ggplot2 by adding several functions to reduce the
complexity of combining geometric objects with transformed data.  Some of
these functions include a pairwise plot matrix, a two group pairwise plot
matrix, a parallel coordinates plot, a survival plot, and several functions to
plot networks.")
    (license license:gpl2+)))

(define-public r-proxy
  (package
    (name "r-proxy")
    (version "0.4-27")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "proxy" version))
       (sha256
        (base32
         "0gsng2aggnljl4z82la9hpnd26hngzhj8fizx4wx22npqjj93694"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/proxy")
    (synopsis "Distance and similarity measures")
    (description
     "This package provides an extensible framework for the efficient
calculation of auto- and cross-proximities, along with implementations of the
most popular ones.")
    (license license:gpl2)))

(define-public r-sp
  (package
    (name "r-sp")
    (version "1.5-0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sp" version))
       (sha256
        (base32 "077q1wh9ihhcn1338xspnd90hy16ljxsav1xcrxdxj4fyynhd6lk"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lattice))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/sp")
    (synopsis "Classes and methods for spatial data")
    (description
     "This package provides classes and methods for spatial data; the classes
document where the spatial location information resides, for 2D or 3D data.
Utility functions are provided, e.g. for plotting data as maps, spatial
selection, as well as methods for retrieving coordinates, for subsetting,
print, summary, etc.")
    (license license:gpl2+)))

(define-public r-laplacesdemon
  (package
    (name "r-laplacesdemon")
    (version "16.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "LaplacesDemon" version))
       (sha256
        (base32 "1dsfp65cg06f25zjzd5ib4qyn1alfhbhpgyvpcw5n6bszn13idap"))))
    (properties `((upstream-name . "LaplacesDemon")))
    (build-system r-build-system)
    (home-page "https://github.com/LaplacesDemonR/LaplacesDemon")
    (synopsis "Complete environment for Bayesian inference")
    (description
     "This package provides a complete environment for Bayesian inference using
a variety of different samplers.")
    (license license:expat)))

(define-public r-rmtstat
  (package
    (name "r-rmtstat")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RMTstat" version))
       (sha256
        (base32
         "1r1a2sdqv64m9cpm2pz6r8abf7l810126ayd8iq3gx86c7bjfj5v"))))
    (properties `((upstream-name . "RMTstat")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/RMTstat")
    (synopsis "Distributions, statistics and tests derived from random matrix theory")
    (description
     "This package provides functions for working with the Tracy-Widom laws
and other distributions related to the eigenvalues of large Wishart
matrices.")
    (license license:bsd-3)))

(define-public r-rmpi
  (package
    (name "r-rmpi")
    (version "0.6-9.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "Rmpi" version))
              (sha256
               (base32
                "06mxqgrimhfsag5giv810c7ycdbaycqs4qcj41pnfbj0jypw32im"))))
    (properties `((upstream-name . "Rmpi")))
    (build-system r-build-system)
    (arguments
     `(#:configure-flags '("--configure-args=\"--with-Rmpi-type=OPENMPI\"")
       #:phases (modify-phases %standard-phases
                  (add-before 'install 'mpi-setup
                    ,%openmpi-setup))))
    (inputs
     (list openmpi))
    (native-inputs
     (list pkg-config))
    (home-page "http://www.stats.uwo.ca/faculty/yu/Rmpi")
    (synopsis "R interface to message-passing interface (MPI)")
    (description
     "This package provides an interface (wrapper) to MPI APIs.  It also
provides an interactive R manager and worker environment.")
    (license license:gpl2+)))

(define-public r-lmoments
  (package
    (name "r-lmoments")
    (version "1.3-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Lmoments" version))
       (sha256
        (base32
         "0pc63bj9a8hzr5m3yssrc4kin39fffwkl8rggs3sagzr12d4i7bw"))))
    (properties `((upstream-name . "Lmoments")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp r-rcpparmadillo))
    (home-page "http://www.tilastotiede.fi/juha_karvanen.html")
    (synopsis "L-moments and quantile mixtures")
    (description
     "This package contains functions to estimate L-moments and trimmed
L-moments from the data.  It also contains functions to estimate the
parameters of the normal polynomial quantile mixture and the Cauchy polynomial
quantile mixture from L-moments and trimmed L-moments.")
    (license license:gpl2)))

(define-public r-distillery
  (package
    (name "r-distillery")
    (version "1.2-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "distillery" version))
       (sha256
        (base32
         "1ymmxyamkq0zbz2m4gllln1ihks2hcib6gs0mls92as79srz122b"))))
    (build-system r-build-system)
    (home-page "https://ral.ucar.edu/staff/ericg/")
    (synopsis "Functions for confidence intervals and object information")
    (description
     "This package provides some very simple method functions for confidence
interval calculation and to distill pertinent information from a potentially
complex object; primarily used in common with the packages extRemes and
SpatialVx.")
    (license license:gpl2+)))

(define-public r-etrunct
  (package
   (name "r-etrunct")
   (version "0.1")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "etrunct" version))
            (sha256
             (base32
              "0ayazgyqlc8jcqr03cwfmfhm4pck6xri1r6vkgqy4arqkrrnrcqr"))))
   (properties `((upstream-name . "etrunct")))
   (build-system r-build-system)
   (home-page "https://cran.r-project.org/web/packages/etrunct")
   (synopsis "Computes moments of univariate truncated T distribution")
   (description "This package computes moments of univariate truncated
T distribution.  There is only one exported function, @code{e_trunct},
which should be seen for details.")
   (license license:expat)))

(define-public r-excelr
  (package
    (name "r-excelr")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "excelR" version))
       (sha256
        (base32 "1pb4sy54zjv5vrh7gjjv7qlpab74km6mfsmfyl0yhmr0jx01hrw0"))
       (snippet
        '(delete-file "inst/htmlwidgets/lib/jexcel/js/jexcel.min.js"))))
    (properties `((upstream-name . "excelR")))
    (build-system r-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst/htmlwidgets/lib/jexcel/js/"
               (let ((source (assoc-ref inputs "js-jexcel"))
                     (target "jexcel.min.js"))
                 (format #true "Processing ~a --> ~a~%"
                         source target)
                 (invoke "esbuild" source "--minify"
                         (string-append "--outfile=" target)))))))))
    (native-inputs
     `(("esbuild" ,esbuild)
       ;; There is no tag for this particular commit, but comparison of the
       ;; contents of the JavaScript files point to this commit as the most
       ;; likely source.
       ("js-jexcel"
        ,(origin
           (method url-fetch)
           (uri (string-append "https://raw.githubusercontent.com/jspreadsheet/ce/"
                               "8af1960f76e6803bebc5750013d2ebe95354e88a/dist/jexcel.js"))
           (sha256
            (base32
             "0y88hsr9d8cpnvdmbm17m328pc4kc5wbcv02kzmhm0bryzhviw7h"))))))
    (propagated-inputs (list r-htmlwidgets r-jsonlite))
    (home-page "https://github.com/Swechhya/excelR")
    (synopsis "Wrapper of the JavaScript library jExcel")
    (description
     "This package provides an R interface to the jExcel library to
create web-based interactive tables and spreadsheets compatible with
spreadsheet software.")
    (license license:expat)))

(define-public r-extremes
  (package
    (name "r-extremes")
    (version "2.1-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "extRemes" version))
       (sha256
        (base32
         "19q560prq02h3bwk01jb68693qb5bhsv8wiqhia7v5knm34qv8x7"))))
    (properties `((upstream-name . "extRemes")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-distillery r-lmoments))
    (home-page "https://www.assessment.ucar.edu/toolkit/")
    (synopsis "Extreme value analysis")
    (description
     "ExtRemes is a suite of functions for carrying out analyses on the
extreme values of a process of interest; be they block maxima over long blocks
or excesses over a high threshold.")
    (license license:gpl2+)))

(define-public r-lmtest
  (package
    (name "r-lmtest")
    (version "0.9-40")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lmtest" version))
       (sha256
        (base32
         "15yr2kx08wy085bnziqmj1p6hf9mg3qp2a8465jk2df6di6hsh34"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-zoo))
    (native-inputs
     (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/lmtest")
    (synopsis "Testing linear regression models")
    (description
     "This package provides a collection of tests, data sets, and examples for
diagnostic checking in linear regression models.  Furthermore, some generic
tools for inference in parametric models are provided.")
    ;; Either version is okay
    (license (list license:gpl2 license:gpl3))))

(define-public r-idr
  (package
    (name "r-idr")
    (version "1.3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "idr" version))
              (sha256
               (base32
                "1r6icxf0c0y9wvihwmkk5xqscr1qhacqk3w2076kjm2993f10fbb"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/idr/")
    (synopsis "Irreproducible discovery rate")
    (description
     "This is a package for estimating the copula mixture model and plotting
correspondence curves in \"Measuring reproducibility of high-throughput
experiments\" (2011), Annals of Applied Statistics, Vol. 5, No. 3, 1752-1779,
by Li, Brown, Huang, and Bickel")
    (license license:gpl2+)))

(define-public r-inline
  (package
    (name "r-inline")
    (version "0.3.19")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "inline" version))
              (sha256
               (base32
                "1mcr9hgq6kkq03n7pkcccxa7vg8jma0q7lfxc5vvkc6snydk1s8f"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/inline")
    (synopsis "Functions to inline C, C++, Fortran function calls from R")
    (description
     "This package provides functionality to dynamically define R functions
and S4 methods with inlined C, C++ or Fortran code supporting @code{.C} and
@code{.Call} calling conventions.")
    ;; Any version of the LGPL.
    (license license:lgpl3+)))

(define-public r-inum
  (package
    (name "r-inum")
    (version "1.0-4")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "inum" version))
              (sha256
               (base32
                "1khkzja8lwn9075864vbyajqina9m588ahf1fsrrajrsqilyzssz"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-libcoin))
    (home-page "https://cran.r-project.org/web/packages/inum/")
    (synopsis "Interval and enum-type representation of vectors")
    (description
     "This package provides an enum-type representation of vectors and
representation of intervals, including a method of coercing variables
in data frames.")
    (license license:gpl2)))
(define-public r-invgamma
  (package
   (name "r-invgamma")
   (version "1.1")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "invgamma" version))
            (sha256
             (base32
              "12ga2y4wc9bc5zz6vimvxwgjpsx3ys3209nq63gscbw559ydxa5a"))))
   (properties `((upstream-name . "invgamma")))
   (build-system r-build-system)
   (home-page "https://github.com/dkahle/invgamma")
   (synopsis "Inverse gamma distribution")
   (description "This package provides a light weight implementation of the
standard distribution functions for the inverse gamma distribution, wrapping
those for the gamma distribution in the @code{stats} package.")
   (license license:gpl2)))

(define-public r-bdsmatrix
  (package
    (name "r-bdsmatrix")
    (version "1.3-6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bdsmatrix" version))
       (sha256
        (base32
         "1g300x11rv56f826mbv7mbb67a5xz3dv74hpjc18jh3q8gap3j7r"))))
    (properties `((upstream-name . "bdsmatrix")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/bdsmatrix/")
    (synopsis "Routines for block diagonal symmetric matrices")
    (description
     "This package provides procedures to work with block diagonal symmetric
matrices, a special case of sparse matrices.")
    (license license:lgpl2.0)))

(define-public r-bbmle
  (package
    (name "r-bbmle")
    (version "1.0.25")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bbmle" version))
       (sha256
        (base32
         "0mdj21q7k0fp4cj7la14vmcjmp49zqm57g7r6zrwmxpv0acwda46"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bdsmatrix
           r-lattice
           r-mass
           r-matrix
           r-mvtnorm
           r-numderiv))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/bbmle")
    (synopsis "Tools for General Maximum Likelihood Estimation")
    (description
     "This package provides methods and functions for fitting maximum
likelihood models in R.  This package modifies and extends the @code{mle}
classes in the @code{stats4} package.")
    ;; Any version of the GPL
    (license license:gpl2+)))

(define-public r-emdbook
  (package
    (name "r-emdbook")
    (version "1.3.12")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "emdbook" version))
       (sha256
        (base32
         "0ls3zxxlwmdv7zn1v9i1y9zc2sn0hbgmyjvsj7zn3ajsw7wwlih6"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bbmle r-coda r-lattice r-mass r-plyr))
    (home-page "http://www.math.mcmaster.ca/bolker/emdbook")
    (synopsis "Support functions and data for \"Ecological Models and Data\"")
    (description
     "This package provides auxiliary functions and data sets for \"Ecological
Models and Data\", a book presenting maximum likelihood estimation and related
topics for ecologists (ISBN 978-0-691-12522-0).")
    ;; Any GPL version
    (license (list license:gpl2 license:gpl3))))

(define-public r-lpsolve
  (package
    (name "r-lpsolve")
    (version "5.6.17")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lpSolve" version))
       (sha256
        (base32
         "124jdjvxi1kqfd10jv85jqllvba1hi2z4j5g7n8wc1fwv4mq09gp"))))
    (properties `((upstream-name . "lpSolve")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/lpSolve")
    (synopsis "R interface to Lp_solve to solve linear/integer programs")
    (description
     "Lp_solve is software for solving linear, integer and mixed integer
programs.  This implementation supplies a \"wrapper\" function in C and some R
functions that solve general linear/integer problems, assignment problems, and
transportation problems.")
    (license license:lgpl2.0)))

(define-public r-limsolve
  (package
    (name "r-limsolve")
    (version "1.5.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "limSolve" version))
       (sha256
        (base32
         "1829rd2cnd8qj80z9a7sgc7gx4sf3kvl5g6d2a0lqqw30f9sjzmr"))))
    (properties `((upstream-name . "limSolve")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lpsolve r-mass r-quadprog))
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/limSolve")
    (synopsis "Solving linear inverse models")
    (description
     "This package provides functions that:

@enumerate
@item find the minimum/maximum of a linear or quadratic function,
@item sample an underdetermined or overdetermined system,
@item solve a linear system Ax=B for the unknown x.
@end enumerate

It includes banded and tridiagonal linear systems.  The package calls Fortran
functions from LINPACK.")
    ;; Any GPL version.
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-fitdistrplus
  (package
    (name "r-fitdistrplus")
    (version "1.1-8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fitdistrplus" version))
       (sha256
        (base32
         "0nhgjvwya95v6b9khbsgp44lw10xg35w61lmka1v6wq7yh827izk"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mass r-survival))
    (native-inputs
     (list r-knitr))
    (home-page "http://riskassessment.r-forge.r-project.org")
    (synopsis "Fitting a parametric distribution from data")
    (description
     "This package extends the @code{fitdistr} function of the MASS package
with several functions to help the fit of a parametric distribution to
non-censored or censored data.  Censored data may contain left-censored,
right-censored and interval-censored values, with several lower and upper
bounds.  In addition to @dfn{maximum likelihood estimation} (MLE), the package
provides moment matching (MME), quantile matching (QME) and maximum
goodness-of-fit estimation (MGE) methods (available only for non-censored
data).  Weighted versions of MLE, MME and QME are available.")
    (license license:gpl2+)))

(define-public r-energy
  (package
    (name "r-energy")
    (version "1.7-10")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "energy" version))
       (sha256
        (base32
         "19xyw5bkyzfk22gly2ca2nsznqnrhaq4a77727kr1k26bj3y8gal"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-boot r-gsl r-rcpp))
    (home-page "https://cran.r-project.org/web/packages/energy")
    (synopsis "Multivariate inference via the energy of data")
    (description
     "This package provides e-statistics (energy) tests and statistics for
multivariate and univariate inference, including distance correlation,
one-sample, two-sample, and multi-sample tests for comparing multivariate
distributions, are implemented.  Measuring and testing multivariate
independence based on distance correlation, partial distance correlation,
multivariate goodness-of-fit tests, clustering based on energy distance,
testing for multivariate normality, distance components (disco) for
non-parametric analysis of structured data, and other energy
statistics/methods are implemented.")
    (license license:gpl2+)))

(define-public r-suppdists
  (package
    (name "r-suppdists")
    (version "1.1-9.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "SuppDists" version))
       (sha256
        (base32
         "025b9nlxz62wk84295csyzbncpn80i3iby3sxdigf3swcgi2fmbb"))))
    (properties `((upstream-name . "SuppDists")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/SuppDists")
    (synopsis "Supplementary distributions")
    (description
     "This package provides ten distributions supplementing those built into
R.  Inverse Gauss, Kruskal-Wallis, Kendall's Tau, Friedman's chi squared,
Spearman's rho, maximum F ratio, the Pearson product moment correlation
coefficient, Johnson distributions, normal scores and generalized
hypergeometric distributions.  In addition two random number generators of
George Marsaglia are included.")
    (license license:gpl2+)))

(define-public r-ksamples
  (package
    (name "r-ksamples")
    (version "1.2-9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "kSamples" version))
       (sha256
        (base32
         "1zs22p68d6320kcylisnk0b5wmpapxkyz15py09czxzw7npw8gms"))))
    (properties `((upstream-name . "kSamples")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-suppdists))
    (home-page "https://cran.r-project.org/web/packages/kSamples")
    (synopsis "K-Sample rank tests and their combinations")
    (description
     "This package provides tools to compares k samples using the
Anderson-Darling test, Kruskal-Wallis type tests with different rank score
criteria, Steel's multiple comparison test, and the Jonckheere-Terpstra (JT)
test.  It computes asymptotic, simulated or (limited) exact P-values, all
valid under randomization, with or without ties, or conditionally under random
sampling from populations, given the observed tie pattern.  Except for Steel's
test and the JT test it also combines these tests across several blocks of
samples.")
    (license license:gpl2+)))

(define-public r-cvst
  (package
    (name "r-cvst")
    (version "0.2-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "CVST" version))
       (sha256
        (base32
         "0bgk0d6w3dyhb5s30idnp6jpb3m8wf3b79wqlg127wwm0cird8pg"))))
    (properties `((upstream-name . "CVST")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-kernlab r-matrix))
    (home-page "https://cran.r-project.org/web/packages/CVST")
    (synopsis "Fast cross-validation via sequential testing")
    (description
     "This package implements the fast cross-validation via sequential
testing (CVST) procedure.  CVST is an improved cross-validation procedure
which uses non-parametric testing coupled with sequential analysis to
determine the best parameter set on linearly increasing subsets of the data.
Additionally to the CVST the package contains an implementation of the
ordinary k-fold cross-validation with a flexible and powerful set of helper
objects and methods to handle the overall model selection process.  The
implementations of the Cochran's Q test with permutations and the sequential
testing framework of Wald are generic and can therefore also be used in other
contexts.")
    (license license:gpl2+)))

(define-public r-cvxr
  (package
    (name "r-cvxr")
    (version "1.0-11")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "CVXR" version))
              (sha256
               (base32
                "0alp1g4bszxqcrjbn54bz1zswg8y10372fwwlbi0jjazycw9cap9"))))
    (properties `((upstream-name . "CVXR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bit64
           r-ecosolver
           r-gmp
           r-matrix
           r-osqp
           r-r6
           r-rcpp
           r-rcppeigen
           r-rmpfr
           r-scs))
    (native-inputs (list r-knitr))
    (home-page "https://cvxr.rbind.io")
    (synopsis "Disciplined convex optimization")
    (description
     "This package provides an object-oriented modeling language for
@dfn{disciplined convex programming} (DCP) as described in Fu,
Narasimhan, and Boyd (2020, <doi:10.18637/jss.v094.i14>).  It allows
the user to formulate convex optimization problems in a natural way
following mathematical convention and DCP rules.  The system analyzes
the problem, verifies its convexity, converts it into a canonical
form, and hands it off to an appropriate solver to obtain the
solution.  Interfaces to solvers on CRAN and elsewhere are provided.")
    (license license:asl2.0)))

(define-public r-squarem
  (package
    (name "r-squarem")
    (version "2021.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "SQUAREM" version))
       (sha256
        (base32
         "0n1s32l9p4vdm3h5q6g43s0qbpzry08difsh0yay80wrla6f3rb6"))))
    (properties `((upstream-name . "SQUAREM")))
    (build-system r-build-system)
    (home-page "https://coah.jhu.edu/people/Faculty_personal_Pages/Varadhan.html")
    (synopsis "Squared Extrapolation Methods for Accelerating EM-Like Monotone Algorithms")
    (description
     "This package provides algorithms for accelerating the convergence of
slow, monotone sequences from smooth, contraction mapping such as the EM
algorithm.  It can be used to accelerate any smooth, linearly convergent
acceleration scheme.  A tutorial style introduction to this package is
available in a vignette.")
    (license license:gpl2+)))

(define-public r-progressr
  (package
    (name "r-progressr")
    (version "0.11.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "progressr" version))
       (sha256
        (base32 "1nbc6vvsyqa1gvh1a1m4prnvng88wsa0r35i9fiwq84a6j18qrnq"))))
    (properties `((upstream-name . "progressr")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-digest))
    (home-page "https://progressr.futureverse.org")
    (synopsis "Inclusive, unifying API for progress updates")
    (description
     "This package provides a minimal, unifying API for scripts and packages
to report progress updates from anywhere including when using parallel
processing.  The package is designed such that the developer can to focus on
what progress should be reported on without having to worry about how to
present it.  The end user has full control of how, where, and when to render
these progress updates.")
    (license license:gpl3+)))

(define-public r-lava
  (package
    (name "r-lava")
    (version "1.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lava" version))
       (sha256
        (base32
         "092y5v5mp9a9mqia47fqh22br31crp8w5b4ks2y15242ydlxly1h"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-future-apply r-numderiv r-progressr r-squarem r-survival))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/kkholst/lava")
    (synopsis "Latent variable models")
    (description
     "This package provides tools for the estimation and simulation of latent
variable models.")
    (license license:gpl3)))

(define-public r-drr
  (package
    (name "r-drr")
    (version "0.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "DRR" version))
       (sha256
        (base32
         "1y70si1gig4l7jx5jiqsqliyywfsvimkx53x3zh1lc3yj2j6bqwk"))))
    (properties `((upstream-name . "DRR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cvst r-kernlab r-matrix))
    (home-page "https://cran.r-project.org/web/packages/DRR")
    (synopsis "Dimensionality reduction via regression")
    (description
     "This package provides an implementation of dimensionality reduction via
regression using Kernel Ridge Regression.")
    (license license:gpl3)))

(define-public r-prodlim
  (package
    (name "r-prodlim")
    (version "2019.11.13")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "prodlim" version))
       (sha256
        (base32
         "03wvh3kirp1prac5nky6a5whs97rvaf4hc27x0fnh51sa17r42b8"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-kernsmooth r-lava r-rcpp r-survival))
    (home-page "https://cran.r-project.org/web/packages/prodlim")
    (synopsis "Product-limit estimation for censored event history analysis")
    (description
     "This package provides a fast and user-friendly implementation of
nonparametric estimators for censored event history (survival) analysis with
the Kaplan-Meier and Aalen-Johansen methods.")
    (license license:gpl2+)))

(define-public r-dimred
  (package
    (name "r-dimred")
    (version "0.2.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dimRed" version))
       (sha256
        (base32
         "05zlkf6hjdqqr1sgw7ww9f17vjnsiqfaj9kvdvi146phh53v2zls"))))
    (properties `((upstream-name . "dimRed")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-drr r-magrittr))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/gdkrmr/dimRed")
    (synopsis "Framework for dimensionality reduction")
    (description
     "This package provides a collection of dimensionality reduction
techniques from R packages and provides a common interface for calling the
methods.")
    (license license:gpl3)))

(define-public r-timedate
  (package
    (name "r-timedate")
    (version "4021.106")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "timeDate" version))
       (sha256
        (base32
         "1qhh1d85s8r4wkcf4fljfm67lnkj8flnx9iz4hdg305xdkng3b8l"))))
    (properties `((upstream-name . "timeDate")))
    (build-system r-build-system)
    (home-page "https://www.rmetrics.org")
    (synopsis "Chronological and calendar objects")
    (description
     "This package provides an environment for teaching \"Financial
Engineering and Computational Finance\" and for managing chronological and
calendar objects.")
    (license license:gpl2+)))

(define-public r-magic
  (package
    (name "r-magic")
    (version "1.6-0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "magic" version))
       (sha256
        (base32
         "1gybia2aq80ldk1d845y5srncfzbbmpqhgl7vfaz7qqqjs6d85j5"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-abind))
    (home-page "https://github.com/RobinHankin/magic.git")
    (synopsis "Create and investigate magic squares")
    (description
     "This package provides a collection of efficient, vectorized algorithms
for the creation and investigation of magic squares and hypercubes, including
a variety of functions for the manipulation and analysis of arbitrarily
dimensioned arrays.")
    (license license:gpl2)))

(define-public r-rmysql
  (package
    (name "r-rmysql")
    (version "0.10.24")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RMySQL" version))
       (sha256
        (base32
         "0hbjcf0gzkkg8h50msj4a6ymax9s3j4aw44jl1mqcxkdmfn9l6ya"))))
    (properties `((upstream-name . "RMySQL")))
    (build-system r-build-system)
    (inputs
     (list `(,mariadb "dev") zlib))
    (propagated-inputs
     (list r-dbi))
    (home-page "https://github.com/r-dbi/RMySQL")
    (synopsis "Database interface and MySQL driver for R")
    (description
     "This package provides a DBI interface to MySQL / MariaDB.  The RMySQL
package contains an old implementation based on legacy code from S-PLUS which
is being phased out.  A modern MySQL client based on Rcpp is available from
the RMariaDB package.")
    (license license:gpl2)))

(define-public r-rpostgresql
  (package
    (name "r-rpostgresql")
    (version "0.7-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RPostgreSQL" version))
       (sha256
        (base32
         "1ijnsly8wgy6cfib4xvdaz2g9hk1gzg7q52r37zkvc7jjh0gdbdn"))))
    (properties `((upstream-name . "RPostgreSQL")))
    (build-system r-build-system)
    (inputs
     (list postgresql))
    (propagated-inputs
     (list r-dbi))
    (home-page "https://github.com/tomoakin/RPostgreSQL")
    (synopsis "R interface to the PostgreSQL database system")
    (description
     "This package provides a Database Interface (DBI) compliant driver for R
to access PostgreSQL database systems.")
    ;; The whole package is released under GPL version 2.  It includes code
    ;; under the PostgreSQL license.
    (license license:gpl2)))

(define-public r-linprog
  (package
    (name "r-linprog")
    (version "0.9-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "linprog" version))
       (sha256
        (base32
         "1d34m2nyk7m6j2dci69bhy5mlw479xax1517j7f14pq7vhpsm9l1"))))
    (build-system r-build-system)
    (propagated-inputs (list r-lpsolve))
    (home-page "http://linprog.r-forge.r-project.org/")
    (synopsis "Linear programming and optimization")
    (description
     "This package can be used to solve Linear Programming / Linear
Optimization problems by using the simplex algorithm.")
    (license license:gpl2+)))

(define-public r-geometry
  (package
    (name "r-geometry")
    (version "0.4.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "geometry" version))
       (sha256
        (base32
         "0wplszaxi6phxffp3zww5alwnfbh9521qi43h65w057lrm1pmj2j"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-magic r-linprog r-lpsolve r-rcpp r-rcppprogress))
    (home-page "http://geometry.r-forge.r-project.org/")
    (synopsis "Mesh generator and surface tessellator")
    (description
     "This package makes the qhull library available in R, in a similar manner
as in Octave.  Qhull computes convex hulls, Delaunay triangulations, halfspace
intersections about a point, Voronoi diagrams, furthest-site Delaunay
triangulations, and furthest-site Voronoi diagrams.  It runs in 2-d, 3-d, 4-d,
and higher dimensions.  It implements the Quickhull algorithm for computing
the convex hull.  Qhull does not support constrained Delaunay triangulations,
or mesh generation of non-convex objects, but the package does include some R
functions that allow for this.  Currently the package only gives access to
Delaunay triangulation and convex hull computation.")
    ;; The Qhull sources are included and are distributed under a custom
    ;; non-copyleft license.  The R sources are released under GPL version 2.
    (license (list license:gpl2
                   (license:non-copyleft "http://www.qhull.org/COPYING.txt")))))

(define-public r-ddalpha
  (package
    (name "r-ddalpha")
    (version "1.3.13")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ddalpha" version))
       (sha256
        (base32
         "1bjfgb3lbzhjb5wx9hzp90jppq7vnj59bmd2n9ymi8sh1570m9p4"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bh
           r-class
           r-geometry
           r-mass
           r-rcpp
           r-robustbase
           r-sfsmisc))
    (native-inputs
     (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/ddalpha")
    (synopsis "Depth-Based classification and calculation of data depth")
    (description
     "This package contains procedures for depth-based supervised learning,
which are entirely non-parametric, in particular the DDalpha-procedure (Lange,
Mosler and Mozharovskyi, 2014).  The training data sample is transformed by a
statistical depth function to a compact low-dimensional space, where the final
classification is done.  It also offers an extension to functional data and
routines for calculating certain notions of statistical depth functions.  50
multivariate and 5 functional classification problems are included.")
    (license license:gpl2)))

(define-public r-gower
  (package
    (name "r-gower")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gower" version))
       (sha256
        (base32
         "0p9qx9aafkdm7wibfwk59jzw6vspsff6zwp84bc40lg0myxbf737"))))
    (build-system r-build-system)
    (home-page "https://github.com/markvanderloo/gower")
    (synopsis "Gower's distance")
    (description
     "This package provides tools to compute Gower's distance (or similarity)
coefficient between records, and to compute the top-n matches between records.
Core algorithms are executed in parallel on systems supporting OpenMP.")
    (license license:gpl3)))

(define-public r-rcpproll
  (package
    (name "r-rcpproll")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RcppRoll" version))
       (sha256
        (base32
         "0srzfhzkk42kzrdjnhbb37946jp1p688rgysy6k3i2is8jb21zyb"))))
    (properties `((upstream-name . "RcppRoll")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp))
    (home-page "https://cran.r-project.org/web/packages/RcppRoll")
    (synopsis "Efficient rolling and windowed operations")
    (description
     "This package provides fast and efficient routines for common rolling /
windowed operations.  Routines for the efficient computation of windowed mean,
median, sum, product, minimum, maximum, standard deviation and variance are
provided.")
    (license license:gpl2+)))

(define-public r-ipred
  (package
    (name "r-ipred")
    (version "0.9-13")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ipred" version))
       (sha256
        (base32
         "162ckhqn24l0l5ih7qi2k3lxw5iprm1g5a34q1ik0b9wv5ia0s31"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-class
           r-mass
           r-nnet
           r-prodlim
           r-rpart
           r-survival))
    (home-page "https://cran.r-project.org/web/packages/ipred")
    (synopsis "Improved predictors")
    (description
     "This package provides improved predictive models by indirect
classification and bagging for classification, regression and survival
problems as well as resampling based estimators of prediction error.")
    (license license:gpl2+)))

(define-public r-psych
  (package
    (name "r-psych")
    (version "2.2.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "psych" version))
       (sha256
        (base32
         "0wamcwbwn2x5y91d5hv3l3sfc41k685hlsv9cx8gkzl7yfziimac"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lattice r-mnormt r-nlme))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/psych/")
    (synopsis "Procedures for psychological, psychometric, and personality research")
    (description
     "This package provides a general purpose toolbox for personality,
psychometric theory and experimental psychology.  Functions are primarily for
multivariate analysis and scale construction using factor analysis, principal
component analysis, cluster analysis and reliability analysis, although others
provide basic descriptive statistics.  Item Response Theory is done using
factor analysis of tetrachoric and polychoric correlations.  Functions for
analyzing data at multiple levels include within and between group statistics,
including correlations and factor analysis.  Functions for simulating and
testing particular item and test structures are included.  Several functions
serve as a useful front end for structural equation modeling.  Graphical
displays of path diagrams, factor analysis and structural equation models are
created using basic graphics.")
    (license license:gpl2+)))

(define-public r-generics
  (package
    (name "r-generics")
    (version "0.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "generics" version))
       (sha256
        (base32
         "0lyhhwik0w7m5h3fbwl2f52gc1v2g6g6h6sc47sa9f58pxin213m"))))
    (build-system r-build-system)
    (home-page "https://github.com/r-lib/generics")
    (synopsis "Common S3 generics not provided by base R methods")
    (description
     "In order to reduce potential package dependencies and conflicts,
generics provides a number of commonly used S3 generics that are not provided
by base R methods related to model fitting.")
    (license license:gpl2)))

(define-public r-broom
  (package
    (name "r-broom")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "broom" version))
       (sha256
        (base32
         "14i8729m38nxf5q344isgq4006p3b50wi3q8jgckxqphhnj5lpjb"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-backports
           r-dplyr
           r-ellipsis
           r-generics
           r-ggplot2
           r-glue
           r-purrr
           r-rlang
           r-stringr
           r-tibble
           r-tidyr))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/tidyverse/broom")
    (synopsis "Convert statistical analysis objects into tidy data frames")
    (description
     "This package provides tools to convert statistical analysis objects from
R into tidy data frames, so that they can more easily be combined, reshaped
and otherwise processed with tools like @code{dplyr}, @code{tidyr} and
@code{ggplot2}.  The package provides three S3 generics: @code{tidy}, which
summarizes a model's statistical findings such as coefficients of a
regression; @code{augment}, which adds columns to the original data such as
predictions, residuals and cluster assignments; and @code{glance}, which
provides a one-row summary of model-level statistics.")
    (license license:expat)))

(define-public r-recipes
  (package
    (name "r-recipes")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "recipes" version))
       (sha256
        (base32
         "03k7spw5vivj35lwqj8xj259smgc04qxkdimk5ck9yj656d5lyqs"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-dplyr
           r-ellipsis
           r-generics
           r-glue
           r-gower
           r-hardhat
           r-ipred
           r-lifecycle
           r-lubridate
           r-magrittr
           r-matrix
           r-purrr
           r-rlang
           r-tibble
           r-tidyr
           r-tidyselect
           r-timedate
           r-vctrs
           r-withr))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/topepo/recipes")
    (synopsis "Preprocessing tools to create design matrices")
    (description
     "Recipes is an extensible framework to create and preprocess design
matrices.  Recipes consist of one or more data manipulation and analysis
\"steps\".  Statistical parameters for the steps can be estimated from an
initial data set and then applied to other data sets.  The resulting design
matrices can then be used as inputs into statistical or machine learning
models.")
    (license license:gpl2)))

(define-public r-pdist
  (package
    (name "r-pdist")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pdist" version))
       (sha256
        (base32
         "0bvg8si81hs79v39d7svv4zbv2p0sk2r6m9vamibvkh9qvl4x406"))))
    (build-system r-build-system)
    (home-page "https://github.com/jeffwong/pdist")
    (synopsis "Partitioned distance function")
    (description
     "Pdist computes the euclidean distance between rows of a matrix X and
rows of another matrix Y.  Previously, this could be done by binding the two
matrices together and calling @code{dist}, but this creates unnecessary
computation by computing the distances between a row of X and another row of
X, and likewise for Y.  Pdist strictly computes distances across the two
matrices, not within the same matrix, making computations significantly faster
for certain use cases.")
    (license license:gpl3+)))

(define-public r-ggrepel
  (package
    (name "r-ggrepel")
    (version "0.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggrepel" version))
       (sha256
        (base32
         "1z5xyr5f4aryy0v1gzz9m8m4s5fzzwbrf0fxll1nbflr8xnr3yr9"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-rcpp r-rlang r-scales))
    (native-inputs
     (list r-knitr)) ; for vignettes
    (home-page "https://github.com/slowkow/ggrepel")
    (synopsis "Repulsive text and label geometries for ggplot2")
    (description
     "This package provides text and label geometries for ggplot2 that help to
avoid overlapping text labels.  Labels repel away from each other and away
from the data points.")
    (license license:gpl3)))

(define-public r-coro
  (package
    (name "r-coro")
    (version "1.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "coro" version))
       (sha256
        (base32 "0wvxdpdh3xrskz5s5wfkva856x849knx1jigbf0ff6s6n6qjjxsf"))))
    (properties `((upstream-name . "coro")))
    (build-system r-build-system)
    (propagated-inputs (list r-rlang))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/r-lib/coro")
    (synopsis "Coroutines for R")
    (description
     "This package provides coroutines for R, a family of functions that can
be suspended and resumed later on.  This includes async functions (which
await) and generators (which yield).  Async functions are based on the
concurrency framework of the @code{promises} package.  Generators are based on
a dependency free iteration protocol defined in @code{coro} and are compatible
with iterators from the @code{reticulate} package.")
    (license license:expat)))

(define-public r-corrplot
  (package
    (name "r-corrplot")
    (version "0.92")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "corrplot" version))
       (sha256
        (base32
         "1g98jk6xsl08z4n6sy5vriif99m31zhbz7j3dh1kfj4w7yb9zh78"))))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/taiyun/corrplot")
    (synopsis "Visualization of a correlation matrix")
    (description
     "This package provides a graphical display of a correlation matrix or
general matrix.  It also contains some algorithms to do matrix reordering.  In
addition, corrplot is good at details, including choosing color, text labels,
color labels, layout, etc.")
    ;; Any version of the GPL
    (license license:gpl2+)))

(define-public r-stringdist
  (package
    (name "r-stringdist")
    (version "0.9.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "stringdist" version))
       (sha256
        (base32 "0pkggr25azadczhnsxc9wh1753wigf3wijyvwfc2ip5a42c1f55x"))))
    (build-system r-build-system)
    (home-page "https://github.com/markvanderloo/stringdist")
    (synopsis "Approximate string matching and string distance functions")
    (description
     "This package implements an approximate string matching version of R's
native @code{match} function.  It can calculate various string distances based
on edits (Damerau-Levenshtein, Hamming, Levenshtein, optimal string alignment),
qgrams (q- gram, cosine, jaccard distance) or heuristic metrics (Jaro,
Jaro-Winkler).  An implementation of soundex is provided as well.  Distances
can be computed between character vectors while taking proper care of encoding
or between integer vectors representing generic sequences.")
    (license license:gpl3+)))

(define-public r-ucminf
  (package
    (name "r-ucminf")
    (version "1.1-4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ucminf" version))
       (sha256
        (base32
         "1cknk42allcflgk16i4gwi4a389idrxqz6y2w8i7s9mdfgrvd981"))))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/ucminf/")
    (synopsis "General-purpose unconstrained non-linear optimization")
    (description
     "This package provides an implementation of an algorithm for
general-purpose unconstrained non-linear optimization.  The algorithm is of
quasi-Newton type with BFGS updating of the inverse Hessian and soft line
search with a trust region type monitoring of the input to the line search
algorithm.  The interface of @code{ucminf} is designed for easy interchange
with the package @code{optim}.")
    (license license:gpl2+)))

(define-public r-usedist
  (package
    (name "r-usedist")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "usedist" version))
       (sha256
        (base32 "0ddf1zcalbrn293qmr9kdzz3x16fzc4k1bwb1pjmwnspisqfi8kj"))))
    (properties `((upstream-name . "usedist")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=usedist")
    (synopsis "Distance matrix utilities")
    (description
     "This package provides functions to re-arrange, extract, and work with
distances.")
    (license license:gpl3)))

(define-public r-useful
  (package
   (name "r-useful")
   (version "1.2.6")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "useful" version))
            (sha256
             (base32
              "0n50v1q75k518sq23id14jphwla35q4sasahrnrnllwrachl67v1"))))
   (properties `((upstream-name . "useful")))
   (build-system r-build-system)
   (propagated-inputs
    (list r-assertthat
          r-dplyr
          r-ggplot2
          r-magrittr
          r-matrix
          r-plyr
          r-purrr
          r-scales))
   (home-page "https://github.com/jaredlander/useful")
   (synopsis "Collection of handy, useful functions")
   (description "This package provides a set of little functions that have been
found useful to do little odds and ends such as plotting the results of K-means
clustering, substituting special text characters, viewing parts of a
@code{data.frame}, constructing formulas from text and building design and
response matrices.")
   (license license:bsd-3)))

(define-public r-ordinal
  (package
    (name "r-ordinal")
    (version "2019.12-10")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ordinal" version))
       (sha256
        (base32
         "09bpmjmbf4x82kgf6bm4bkncq2apdv9mk20zj4zgma2jx2vyfhbs"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mass r-matrix r-numderiv r-ucminf))
    (home-page "https://github.com/runehaubo/ordinal")
    (synopsis "Regression models for ordinal data")
    (description
     "This package provides an implementation of cumulative link (mixed)
models also known as ordered regression models, proportional odds models,
proportional hazards models for grouped survival times and ordered models.
Estimation is via maximum likelihood and mixed models are fitted with the
Laplace approximation and adaptive Gauss-Hermite quadrature.")
    (license license:gpl2+)))

(define-public r-jomo
  (package
    (name "r-jomo")
    (version "2.7-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "jomo" version))
       (sha256
        (base32
         "1zck7p872k080hyfs0hibq7v13zmsry1jdlnq7k33ff1iljbq99d"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lme4 r-mass r-ordinal r-survival r-tibble))
    (home-page "https://cran.r-project.org/web/packages/jomo/")
    (synopsis "Multilevel Joint Modelling Multiple Imputation")
    (description
     "Similarly to Schafer's package pan, jomo is a package for multilevel
joint modelling multiple imputation @url{Carpenter and Kenward (2013),
http://doi.org/10.1002/9781119942283}.  Novel aspects of jomo are the
possibility of handling binary and categorical data through latent normal
variables, the option to use cluster-specific covariance matrices and to
impute compatibly with the substantive model.")
    (license license:gpl2)))

(define-public r-pan
  (package
    (name "r-pan")
    (version "1.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pan" version))
       (sha256
        (base32
         "1dk3jjj826p7xrz10qz04vyc068xnypg7bp0pj4c32z3da0xzh5d"))))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/pan/")
    (synopsis "Multiple imputation for multivariate panel or clustered data")
    (description
     "This package implements multiple imputation for multivariate panel or
clustered data.")
    (license license:gpl3)))

(define-public r-mitml
  (package
    (name "r-mitml")
    (version "0.4-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mitml" version))
       (sha256
        (base32
         "00i18nnvrdrg91crgcp2a431xs71cawaip3xkqk2myv0iav3xga9"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-haven r-jomo r-pan))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/mitml/")
    (synopsis "Tools for multiple imputation in multilevel modeling")
    (description
     "This package provides tools for multiple imputation of missing data in
multilevel modeling.  It includes a user-friendly interface to the packages
pan and jomo, and several functions for visualization, data management and the
analysis of multiply imputed data sets.")
    (license license:gpl2+)))

(define-public r-mice
  (package
    (name "r-mice")
    (version "3.14.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mice" version))
       (sha256
        (base32
         "01fnfrr7adp29s5kic95r9q0rdznkz2pjmziyimnrqzyicyvfyzq"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-broom
           r-cpp11
           r-dplyr
           r-generics
           r-lattice
           r-rcpp
           r-rlang
           r-tidyr
           r-withr))
    (home-page "https://cran.r-project.org/web/packages/mice/")
    (synopsis "Multivariate imputation by chained equations")
    (description
     "Multiple imputation using @dfn{Fully Conditional Specification} (FCS)
implemented by the MICE algorithm as described in @url{Van Buuren and
Groothuis-Oudshoorn (2011), http://doi.org/10.18637/jss.v045.i03}.  Each
variable has its own imputation model.  Built-in imputation models are
provided for continuous data (predictive mean matching, normal), binary
data (logistic regression), unordered categorical data (polytomous logistic
regression) and ordered categorical data (proportional odds).  MICE can also
impute continuous two-level data (normal model, pan, second-level variables).
Passive imputation can be used to maintain consistency between variables.
Various diagnostic plots are available to inspect the quality of the
imputations.")
    ;; Any of these two versions.
    (license (list license:gpl2 license:gpl3))))

(define-public r-truncnorm
  (package
    (name "r-truncnorm")
    (version "1.0-8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "truncnorm" version))
       (sha256
        (base32
         "0zn88wdd58223kibk085rhsikl4yhlrwiyq109hzjg06hy6lwmj9"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/truncnorm/")
    (synopsis "Truncated normal distribution")
    (description "This package provides functions for the truncated normal
distribution with mean equal to @code{mean} and standard deviation equal to
@code{sd}.  It includes density, distribution, quantile, and expected value
functions, as well as a random generation function.")
    (license license:gpl2)))

(define-public r-rsolnp
  (package
    (name "r-rsolnp")
    (version "1.16")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Rsolnp" version))
       (sha256
        (base32
         "0w7nkj6igr0gi7r7jg950lsx7dj6aipgxi6vbjsf5f5yc9h7fhii"))))
    (properties `((upstream-name . "Rsolnp")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-truncnorm))
    (home-page "https://cran.r-project.org/web/packages/Rsolnp/")
    (synopsis "General non-linear optimization")
    (description "The Rsolnp package implements a general non-linear augmented
Lagrange multiplier method solver, a @dfn{sequential quadratic
programming} (SQP) based solver).")
    ;; Any version of the GPL.
    (license license:gpl2+)))

(define-public r-hardyweinberg
  (package
    (name "r-hardyweinberg")
    (version "1.7.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "HardyWeinberg" version))
       (sha256
        (base32
         "0b3szw090dsc3bkas2kvx787ww2i6zzg2qmdyivmqc8amx5arn6g"))))
    (properties `((upstream-name . "HardyWeinberg")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mice r-nnet r-rcpp r-rsolnp))
    (home-page "https://cran.r-project.org/package=HardyWeinberg")
    (synopsis "Statistical tests and graphics for Hardy-Weinberg equilibrium")
    (description
     "This package contains tools for exploring Hardy-Weinberg equilibrium for
diallelic genetic marker data.  All classical tests (chi-square, exact,
likelihood-ratio and permutation tests) for Hardy-Weinberg equilibrium are
included in the package, as well as functions for power computation and for
the simulation of marker data under equilibrium and disequilibrium.  Routines
for dealing with markers on the X-chromosome are included.  Functions for
testing equilibrium in the presence of missing data by using multiple
imputation are also provided.  Implements several graphics for exploring the
equilibrium status of a large set of diallelic markers: ternary plots with
acceptance regions, log-ratio plots and Q-Q plots.")
    (license license:gpl2+)))

(define-public r-sm
  (package
    (name "r-sm")
    (version "2.2-5.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sm" version))
       (sha256
        (base32
         "0mql7rlm8wkdwmx1lv7pscdk9ibvsdpfdv8bpaz1hv2gn4pc637a"))))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "http://www.stats.gla.ac.uk/~adrian/sm/")
    (synopsis "Smoothing methods for nonparametric regression and density estimation")
    (description
     "This is software accompanying the book 'Applied Smoothing Techniques for
Data Analysis---The Kernel Approach with S-Plus Illustrations', Oxford
University Press.  It provides smoothing methods for nonparametric regression
and density estimation")
    (license license:gpl2+)))

(define-public r-smurf
  (package
    (name "r-smurf")
    (version "1.1.3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "smurf" version))
              (sha256
               (base32
                "0n99dzsb17r0a6d8nkijfg6rdvvc2g4pard2dnmyjq0p69j3f3gb"))))
    (properties `((upstream-name . "smurf")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-catdata
           r-glmnet
           r-mass
           r-matrix
           r-mgcv
           r-rcolorbrewer
           r-rcpp
           r-rcpparmadillo
           r-speedglm))
    (native-inputs (list r-knitr))
    (home-page "https://gitlab.com/TReynkens/smurf")
    (synopsis "Sparse multi-type regularized feature modeling")
    (description
     "The @code{smurf} package contains the implementation of the
@dfn{Sparse Multi-type Regularized Feature} (SMuRF) modeling algorithm
to fit @dfn{generalized linear models} (GLMs) with multiple types of
predictors via regularized maximum likelihood.  Next to the fitting
procedure, following functionality is available:

@itemize
@item Selection of the regularization tuning parameter lambda using
  three different approaches: in-sample, out-of-sample or using
  cross-validation.
@item S3 methods to handle the fitted object including visualization
  of the coefficients and a model summary.
@end itemize")
    (license license:gpl2+)))

(define-public r-venndiagram
  (package
    (name "r-venndiagram")
    (version "1.7.3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "VennDiagram" version))
              (sha256
               (base32
                "0ilcxcp8qskmb5cp7fyb7i0qizg42lrx0ny8ws3if90kfrglghp7"))))
    (properties `((upstream-name . "VennDiagram")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-futile-logger))
    (home-page "https://cran.r-project.org/web/packages/VennDiagram/")
    (synopsis "Generate High-Resolution Venn and Euler Plots")
    (description
     "This package provides a set of functions to generate high-resolution
Venn and Euler plots.  It includes handling for several special cases,
including two-case scaling, and extensive customization of plot shape and
structure.")
    (license license:gpl2+)))

(define-public r-vioplot
  (package
    (name "r-vioplot")
    (version "0.3.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "vioplot" version))
       (sha256
        (base32
         "1dmdasp3jldc41233z6r08w3j76vyyp9m3jrj7n4ahk48yd5siq6"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-sm r-zoo))
    (native-inputs
     (list r-knitr))
    (home-page "http://wsopuppenkiste.wiso.uni-goettingen.de/~dadler")
    (synopsis "Violin plot")
    (description
     "This package provides a violin plot, which is a combination of a box
plot and a kernel density plot.")
    (license license:bsd-3)))

(define-public r-rsofia
  (package
    (name "r-rsofia")
    (version "1.1")
    (source (origin
              (method url-fetch)
              ;; This package has been removed from CRAN, so we can
              ;; only fetch it from the archives.
              (uri (string-append "https://cran.r-project.org/src/"
                                  "contrib/Archive/RSofia/RSofia_"
                                  version ".tar.gz"))
              (sha256
               (base32
                "0q931y9rcf6slb0s2lsxhgqrzy4yqwh8hb1124nxg0bjbxvjbihn"))))
    (properties `((upstream-name . "RSofia")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp))
    (home-page "https://cran.r-project.org/src/contrib/Archive/RSofia")
    (synopsis "Port of sofia-ml to R")
    (description "This package is a port of sofia-ml to R.  Sofia-ml is a
suite of fast incremental algorithms for machine learning that can be used for
training models for classification or ranking.")
    (license license:asl2.0)))

(define-public r-xts
  (package
    (name "r-xts")
    (version "0.12.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "xts" version))
       (sha256
        (base32
         "0hx7vh8cm4c80rnhwqg78l5xb0snvf4adrkbb74z93vmxgm7qa4w"))))
    (build-system r-build-system)
    (propagated-inputs (list r-zoo))
    (home-page "https://github.com/joshuaulrich/xts")
    (synopsis "Extensible time series")
    (description
     "This package provides for uniform handling of R's different time-based
data classes by extending @code{zoo}, maximizing native format information
preservation and allowing for user-level customization and extension, while
simplifying cross-class interoperability.")
    (license license:gpl2+)))

(define-public r-performanceanalytics
  (package
    (name "r-performanceanalytics")
    (version "2.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "PerformanceAnalytics" version))
       (sha256
        (base32
         "0ci26hsj4wnw9g0mh4vrn0cg986cpcpx169rvw6v6rbnjxq718bq"))))
    (properties
     `((upstream-name . "PerformanceAnalytics")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-quadprog r-xts r-zoo))
    (home-page "https://r-forge.r-project.org/projects/returnanalytics/")
    (synopsis "Econometric tools for performance and risk analysis")
    (description "This is a collection of econometric functions for
performance and risk analysis.  This package aims to aid practitioners and
researchers in utilizing the latest research in analysis of non-normal return
streams.  In general, it is most tested on return (rather than price) data on
a regular scale, but most functions will work with irregular return data as
well, and increasing numbers of functions will work with P&L or price data
where possible.")
    ;; Either version may be picked.
    (license (list license:gpl2 license:gpl3))))

(define-public r-laeken
  (package
    (name "r-laeken")
    (version "0.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "laeken" version))
       (sha256
        (base32
         "1p3ccbaydlr52p8qmgmm2l6kryvq6jjjx7mqn2vv0gpjaxqhyy92"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-boot r-mass))
    (home-page "https://cran.r-project.org/web/packages/laeken/")
    (synopsis "Estimation of indicators on social exclusion and poverty")
    (description "This package provides tools for the estimation of indicators
on social exclusion and poverty, as well as an implementation of Pareto tail
modeling for empirical income distributions.")
    (license license:gpl2+)))

(define-public r-vcd
  (package
    (name "r-vcd")
    (version "1.4-10")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "vcd" version))
       (sha256
        (base32
         "0nxkl1x39xf8l0apgvlbr30i8lasix7hyyc93g6514r8z8m1k23i"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-colorspace r-lmtest r-mass))
    (home-page "https://cran.r-project.org/web/packages/vcd/")
    (synopsis "Visualizing categorical data")
    (description "This package provides visualization techniques, data sets,
summary and inference procedures aimed particularly at categorical data.
Special emphasis is given to highly extensible grid graphics.  The package was
originally inspired by the book \"Visualizing Categorical Data\" by Michael
Friendly and is now the main support package for a new book, \"Discrete Data
Analysis with R\" by Michael Friendly and David Meyer (2015).")
    (license license:gpl2)))

(define-public r-vcfr
  (package
   (name "r-vcfr")
   (version "1.13.0")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "vcfR" version))
            (sha256
             (base32
              "1g4y11vpr3wrvf5prj7y33c2bah6rn4xfb4a1y7n7niafd2yhg3l"))))
   (build-system r-build-system)
   (native-inputs
    (list r-knitr))
   (inputs
    (list zlib))
   (propagated-inputs
    (list r-ape
          r-dplyr
          r-magrittr
          r-memuse
          r-pinfsc50
          r-rcpp
          r-stringr
          r-tibble
          r-vegan
          r-viridislite))
   (home-page "https://github.com/knausb/vcfR")
   (synopsis "Manipulate and visualize VCF data")
   (description "This package facilitates easy manipulation of variant call
format (VCF) data.  Functions are provided to rapidly read from and write to
VCF files.  Once VCF data is read into R, a parser function extracts matrices
of data.  This information can then be used for quality control or other
purposes.  Additional functions provide visualization of genomic data.  Once
processing is complete data may be written to a VCF file.  It also may be
converted into other popular R objects.  This package provides a link between
VCF data and familiar R software.")
   (license license:gpl3)))

(define-public r-ica
  (package
    (name "r-ica")
    (version "1.0-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ica" version))
       (sha256
        (base32
         "0rdqd3kz2cv3xvf6yz55bwhsg3k7j90d450i3azs2xkbn4q3aka7"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/ica/")
    (synopsis "Independent component analysis")
    (description "This package provides tools for @dfn{Independent Component
Analysis} (ICA) using various algorithms: FastICA,
Information-Maximization (Infomax), and @dfn{Joint Approximate Diagonalization
of Eigenmatrices} (JADE).")
    (license license:gpl2+)))

(define-public r-ips
  (package
    (name "r-ips")
    (version "0.0.11")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ips" version))
              (sha256
               (base32
                "02jxanfhsjrabj33nwjv71vdc87hiyzikyqrfdj9ix6dky6lm199"))))
    (properties `((upstream-name . "ips")))
    (build-system r-build-system)
    (propagated-inputs (list r-ape r-phangorn r-plyr r-seqinr r-xml))
    (home-page "https://cran.r-project.org/package=ips")
    (synopsis "Interfaces to phylogenetic software in R")
    (description
     "This package provides functions that wrap popular phylogenetic software
for sequence alignment, masking of sequence alignments, and estimation of
phylogenies and ancestral character states.")
    (license license:gpl3)))

(define-public r-dtw
  (package
    (name "r-dtw")
    (version "1.23-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dtw" version))
       (sha256
        (base32
         "0vc2is1hf1g0sw92kzl8mddck264qwiqgm5q2wkcwwz65fss7mkf"))))
    (build-system r-build-system)
    (propagated-inputs (list r-proxy))
    (home-page "http://dtw.r-forge.r-project.org/")
    (synopsis "Dynamic Time Warping Algorithms")
    (description "This package provides a comprehensive implementation of
@dfn{dynamic time warping} (DTW) algorithms in R.  DTW computes the
optimal (least cumulative distance) alignment between points of two time
series.  Common DTW variants covered include local (slope) and global (window)
constraints, subsequence matches, arbitrary distance definitions,
normalizations, minimum variance matching, and so on.")
    (license license:gpl2+)))

(define-public r-sdmtools
  (package
    (name "r-sdmtools")
    (version "1.1-221.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "SDMTools" version))
       (sha256
        (base32
         "1xvcd97ikqsfdpk2fddy3k0z1ajqga7nv9bgac9c1wnjk1gqrpgh"))))
    (properties `((upstream-name . "SDMTools")))
    (build-system r-build-system)
    (propagated-inputs (list r-r-utils))
    (home-page "https://www.rforge.net/SDMTools/")
    (synopsis "Species distribution modelling tools")
    (description "This package provides a set of tools for post processing
the outcomes of species distribution modeling exercises.  It includes novel
methods for comparing models and tracking changes in distributions through
time.  It further includes methods for visualizing outcomes, selecting
thresholds, calculating measures of accuracy and landscape fragmentation
statistics, etc.")
    (license license:gpl3+)))

(define-public r-scatterplot3d
  (package
    (name "r-scatterplot3d")
    (version "0.3-42")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "scatterplot3d" version))
       (sha256
        (base32
         "05jjdiam5w0znb114vc90zahclj22pqj1zzvr96nr10s1vkxvzm9"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/scatterplot3d/")
    (synopsis "3D scatter plot")
    (description "This package provides an implementation of scatter plots for
plotting.  a three dimensional point cloud.")
    (license license:gpl2)))

(define-public r-ggridges
  (package
    (name "r-ggridges")
    (version "0.5.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggridges" version))
       (sha256
        (base32
         "0lfqx21g09s3fp74mld47qfx1nnav18xqj37griyqk406hh1rxrb"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-scales r-withr))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/clauswilke/ggridges")
    (synopsis "Ridgeline plots in ggplot2")
    (description
     "Ridgeline plots provide a convenient way of visualizing changes in
distributions over time or space.  This package enables the creation of such
plots in @code{ggplot2}.")
    (license license:gpl2)))

(define-public r-ggjoy
  (package
    (name "r-ggjoy")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggjoy" version))
       (sha256
        (base32
         "012md2m0jqfcccb933j423m3ck31v3p0pd41gjxpyg9082y7ixyj"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-ggridges))
    (home-page "https://github.com/clauswilke/ggjoy")
    (synopsis "Joyplots in ggplot2")
    (description "Joyplots provide a convenient way of visualizing changes in
distributions over time or space.  This package enables the creation of such
plots in @code{ggplot2}.")
    (license license:gpl2)))

(define-public r-cli
  (package
    (name "r-cli")
    (version "3.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cli" version))
       (sha256
        (base32
         "0kklv5zy9rhly8fr7fdl3dlm3hr81yvbqd5cdz38b1lbzpxmwn0w"))))
    (build-system r-build-system)
    (home-page "https://github.com/r-lib/cli#readme")
    (synopsis "Helpers for developing command line interfaces")
    (description "This package provides a suite of tools designed to build
attractive command line interfaces (CLIs).  It includes tools for drawing
rules, boxes, trees, and Unicode symbols with ASCII alternatives.")
    (license license:expat)))

(define-public r-argparser
  (package
    (name "r-argparser")
    (version "0.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "argparser" version))
       (sha256
        (base32
         "0xcl0ivsbc4iw8s7027q4cx68j6s5lihbby0xa9pmlv4wjmcvdr6"))))
    (build-system r-build-system)
    (home-page "https://bitbucket.org/djhshih/argparser")
    (synopsis "Command-line argument parser")
    (description
     "This package provides a cross-platform command-line argument parser
written purely in R with no external dependencies.  It is useful with the
Rscript front-end and facilitates turning an R script into an executable
script.")
    (license license:gpl3+)))

(define-public r-aricode
  (package
    (name "r-aricode")
    (version "1.0.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "aricode" version))
              (sha256
               (base32
                "0772l9gyrih48l1kymih0mb7szjqqnwcm4lzj0yzp4cs8l2mdf4f"))))
    (properties `((upstream-name . "aricode")))
    (build-system r-build-system)
    (propagated-inputs (list r-matrix r-rcpp))
    (home-page "https://github.com/jchiquet/aricode")
    (synopsis "Efficient computations of standard clustering comparison measures")
    (description
     "This package implements an efficient O(n) algorithm based on
bucket-sorting for fast computation of standard clustering comparison
measures.  Available measures include @dfn{adjusted Rand index} (ARI),
@dfn{normalized information distance} (NID), @dfn{normalized mutual
information} (NMI), @dfn{adjusted mutual information} (AMI), @dfn{normalized
variation information} (NVI) and entropy.")
    (license license:gpl3+)))

(define-public r-debugme
  (package
    (name "r-debugme")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "debugme" version))
       (sha256
        (base32
         "1c9sg55zvf10h8198jdnpamm6f66lzw3c3jnmdp9ls6na0j0xbjd"))))
    (build-system r-build-system)
    (propagated-inputs (list r-crayon))
    (home-page "https://github.com/r-lib/debugme#readme")
    (synopsis "Debug R packages")
    (description
     "This package allows the user to specify debug messages as special string
constants, and control debugging of packages via environment variables.")
    (license license:expat)))

(define-public r-processx
  (package
    (name "r-processx")
    (version "3.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "processx" version))
       (sha256
        (base32 "02zviyqk1ljvrdc3bgqxnkyb8mkmqlgmq6l0c881a523dk9djw4j"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ps r-r6))
    (home-page "https://github.com/r-lib/processx3")
    (synopsis "Execute and control system processes")
    (description
     "This package provides portable tools to run system processes in the
background.  It can check if a background process is running; wait on a
background process to finish; get the exit status of finished processes; kill
background processes and their children; restart processes.  It can read the
standard output and error of the processes, using non-blocking connections.
@code{processx} can poll a process for standard output or error, with a
timeout.  It can also poll several processes at once.")
    (license license:expat)))

(define-public r-tsp
  (package
    (name "r-tsp")
    (version "1.2-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "TSP" version))
       (sha256
        (base32
         "1pa6pb4qrh2iybpjzjiny6hshj0shjdm0pxqnidcrg5hyfzzxd9b"))))
    (properties `((upstream-name . "TSP")))
    (build-system r-build-system)
    (propagated-inputs (list r-foreach))
    (home-page "https://cran.r-project.org/web/packages/TSP/")
    (synopsis "Traveling salesperson problem (TSP)")
    (description "This package provides basic infrastructure and some
algorithms for the @dfn{traveling salesperson problem}(TSP) (also known as the
traveling salesman problem).")
    (license license:gpl3)))

(define-public r-qap
  (package
    (name "r-qap")
    (version "0.1-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "qap" version))
       (sha256
        (base32
         "19adb1bw46pcnmmhqz2jklr0vmma3llxajqp0j9mqfksmsisv927"))))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/qap/")
    (synopsis "Heuristics for the quadratic assignment problem (QAP)")
    (description "This package implements heuristics for the @dfn{quadratic
assignment problem} (QAP).  Currently only a simulated annealing heuristic is
available.")
    (license license:gpl3)))

(define-public r-gclus
  (package
    (name "r-gclus")
    (version "1.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gclus" version))
       (sha256
        (base32
         "1cz0g0i972955hhaji30rx8448x7f3as7z1sww9i5h86ybgirilw"))))
    (build-system r-build-system)
    (propagated-inputs (list r-cluster))
    (home-page "https://cran.r-project.org/web/packages/gclus/")
    (synopsis "Clustering graphics")
    (description "This package orders panels in scatterplot matrices and
parallel coordinate displays by some merit index.  It contains various indices
of merit, ordering functions, and enhanced versions of @code{pairs} and
@code{parcoord} which color panels according to their merit level.")
    (license license:gpl2+)))

(define-public r-webshot
  (package
    (name "r-webshot")
    (version "0.5.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "webshot" version))
       (sha256
        (base32
         "094ggb6yby5irf3hj45p6vp5wdy6rjwpc0h6xbgf2mbqxyxbkhix"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-callr r-jsonlite r-magrittr))
    (home-page "https://github.com/wch/webshot/")
    (synopsis "Take screenshots of web pages")
    (description
     "Webshot makes it easy to take screenshots of web pages from within R.
It can also run Shiny applications locally and take screenshots of the
application; and it can render and screenshot static as well as interactive R
Markdown documents.")
    (license license:gpl2)))

(define-public r-seriation
  (package
    (name "r-seriation")
    (version "1.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "seriation" version))
       (sha256
        (base32
         "1bcd559wsjjdmpc1892vsf8wrkh4ijgn1y71h3y3v5clmd21ycmx"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ca
           r-cluster
           r-colorspace
           r-gclus
           r-mass
           r-qap
           r-registry
           r-tsp))
    (native-inputs (list gfortran))
    (home-page "https://s2.smu.edu/IDA/seriation/")
    (synopsis "Infrastructure for ordering objects using seriation")
    (description
     "This package provides infrastructure for seriation with an
implementation of several seriation/sequencing techniques to reorder matrices,
dissimilarity matrices, and dendrograms.  It also provides (optimally)
reordered heatmaps, color images and clustering visualizations like
dissimilarity plots, and visual assessment of cluster tendency plots (VAT and
iVAT).")
    (license license:gpl3)))

(define-public r-xfun
  (package
    (name "r-xfun")
    (version "0.34")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "xfun" version))
       (sha256
        (base32 "0gc5lbk73bf0yhvc7wwz7hbq39hvphd8xdsgwi2c125rxcgnrrsh"))))
    (build-system r-build-system)
    ;; knitr itself depends on xfun
    #;
    (native-inputs
     `(("r-knitr" ,r-knitr)))
    (home-page "https://github.com/yihui/xfun")
    (synopsis "Miscellaneous functions")
    (description
     "This package provides miscellaneous functions commonly used in other
packages maintained by Yihui Xie.")
    (license license:expat)))

(define-public r-utf8
  (package
    (name "r-utf8")
    (version "1.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "utf8" version))
       (sha256
        (base32
         "1x6qg19z4qih9lk3mvnmx0vailm1khp5lylw4hlwz6rssj3yw6m7"))))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr r-rmarkdown)) ; for vignettes
    (home-page "https://github.com/patperry/r-utf8")
    (synopsis "Unicode text processing")
    (description
     "This package provides tools to process and print UTF-8 encoded
international text (Unicode).  Input, validate, normalize, encode, format, and
display.")
    (license license:asl2.0)))

(define-public r-zeallot
  (package
    (name "r-zeallot")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "zeallot" version))
       (sha256
        (base32
         "1sd1igcfnv27pa3bqxlbyxchi562h7grnjg1l7wxx3bwr49i57s3"))))
    (build-system r-build-system)
    (home-page "https://github.com/nteetor/zeallot")
    (synopsis "Multiple, unpacking, and destructuring assignment")
    (description
     "This package provides a @code{%<-%} operator to perform multiple,
unpacking, and destructuring assignment in R.  The operator unpacks the
right-hand side of an assignment into multiple values and assigns these values
to variables on the left-hand side of the assignment.")
    (license license:expat)))

(define-public r-zlog
  (package
    (name "r-zlog")
    (version "1.0.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "zlog" version))
              (sha256
               (base32
                "1d5j31p0h3rrn230087h3ngpvwknlisjv0f1qdbicdj9m177spci"))))
    (properties `((upstream-name . "zlog")))
    (build-system r-build-system)
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=zlog")
    (synopsis "Transformation for laboratory easurements")
    (description
     "The @code{zlog} package offers functions to transform laboratory
measurements into standardised z or @math{z(log)-values}.  Therefore the lower
and upper reference limits are needed.  If these are not known they could be
estimated from a given sample.")
    (license license:gpl3+)))

(define-public r-vctrs
  (package
    (name "r-vctrs")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "vctrs" version))
       (sha256
        (base32
         "11pnblg2fpa3lr5hbiyw6w7wvlkdvqw35wxrkffcxnlxqc9jwdvw"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli r-glue r-lifecycle r-rlang))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/r-lib/vctrs")
    (synopsis "Vector helpers")
    (description
     "There are three main goals to the @code{vctrs} package:

@enumerate
@item To propose @code{vec_size()} and @code{vec_type()} as alternatives to
  @code{length()} and @code{class()}.  These definitions are paired with a
  framework for type-coercion and size-recycling.
@item To define type- and size-stability as desirable function properties, use
  them to analyse existing base function, and to propose better alternatives.
  This work has been particularly motivated by thinking about the ideal
  properties of @code{c()}, @code{ifelse()}, and @code{rbind()}.
@item To provide a new @code{vctr} base class that makes it easy to create new
  S3 vectors.  @code{vctrs} provides methods for many base generics in terms of
  a few new @code{vctrs} generics, making implementation considerably simpler
  and more robust.
@end enumerate\n")
    (license license:gpl3)))

(define-public r-pillar
  (package
    (name "r-pillar")
    (version "1.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pillar" version))
       (sha256
        (base32
         "1v47dm2v4nlswd1gmgcx5c7yrgn1ksdfr9lqkc63jf2nkv6af1ig"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-fansi
           r-glue
           r-lifecycle
           r-rlang
           r-utf8
           r-vctrs))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/r-lib/pillar")
    (synopsis "Coloured formatting for columns")
    (description
     "This package provides a @code{pillar} generic designed for formatting
columns of data using the full range of colours provided by modern
terminals.")
    (license license:gpl3)))

(define-public r-pinfsc50
  (package
   (name "r-pinfsc50")
   (version "1.2.0")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "pinfsc50" version))
            (sha256
             (base32
              "1547xyxmfb7zi8h9bsm6k67dcw4hpp129xzvmgwfw7r6p4af47zd"))))
   (build-system r-build-system)
   (home-page "https://cran.r-project.org/web/packages/pinfsc50/")
   (synopsis "Genomic data for the plant pathogen Phytophthora infestans")
   (description "This package contains genomic data for the plant pathogen
Phytophthora infestans.  It includes a variant file, a sequence file and an
annotation file.  This package is intended to be used as example data for
packages that work with genomic data.")
   (license license:gpl2+)))

(define-public r-uuid
  (package
    (name "r-uuid")
    (version "1.1-0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "uuid" version))
       (sha256
        (base32
         "0bzlc2knmr338h4ykx8v8c2a1inizxafj8rh13kwii68gpp50nz7"))))
    (build-system r-build-system)
    (home-page "https://www.rforge.net/uuid")
    (synopsis "Tools for generating and handling of UUIDs")
    (description
     "This package provides tools for generating and handling of
@dfn{Universally Unique Identifiers} (UUIDs).")
    (license license:expat)))

(define-public r-tinytex
  (package
    (name "r-tinytex")
    (version "0.42")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tinytex" version))
       (sha256
        (base32
         "1c925r62h84mhwd7v5j35ckdldf6cwb3wzczdn5s72hig0cplpr0"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-xfun))
    (home-page "https://github.com/yihui/tinytex")
    (synopsis "Helper functions for TeX Live and compiling LaTeX documents")
    (description
     "This package provides helper functions to install and maintain the LaTeX
distribution named TinyTeX, a lightweight, cross-platform, portable, and
easy-to-maintain version of TeX Live.  This package also contains helper
functions to compile LaTeX documents, and install missing LaTeX packages
automatically.")
    (license license:expat)))

(define-public r-tinytest
  (package
    (name "r-tinytest")
    (version "1.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tinytest" version))
       (sha256
        (base32
         "1mq31f7bzcz5bkgzl9khm1i80axfzra7gcjqxd2yqb4wrw1m3x4s"))))
    (properties `((upstream-name . "tinytest")))
    (build-system r-build-system)
    (home-page "https://github.com/markvanderloo/tinytest")
    (synopsis "Lightweight unit testing framework")
    (description
     "This package provides a lightweight unit testing framework.  Main
features:

@enumerate
@item install tests with the package;
@item test results are treated as data that can be stored and manipulated;
@item test files are R scripts interspersed with test commands, that can be
  programmed over;
@item fully automated build-install-test sequence for packages;
@item skip tests when not run locally (e.g. on CRAN);
@item flexible and configurable output printing;
@item compare computed output with output stored with the package;
@item run tests in parallel;
@item extensible by other packages;
@item report side effects.
@end enumerate
")
    (license license:gpl3)))

(define-public r-network
  (package
    (name "r-network")
    (version "1.18.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "network" version))
       (sha256
        (base32
         "0nyf8i94lnqm4gfjz1szbwvl4c438xg3rjdkqr18fz68fh0v3x2r"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-magrittr r-statnet-common r-tibble))
    (home-page "https://statnet.org/")
    (synopsis "Classes for relational data")
    (description
     "This package provides tools to create and modify network objects.  The
@code{network} class can represent a range of relational data types, and
supports arbitrary vertex/edge/graph attributes.")
    (license license:gpl2+)))

(define-public r-stabs
  (package
    (name "r-stabs")
    (version "0.6-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "stabs" version))
       (sha256
        (base32
         "1nf1yg14cgxrs4np1yghpzw1nczaslfv3rvf3918wrlzg0vp6l7q"))))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/hofnerb/stabs")
    (synopsis "Stability selection with error control")
    (description
     "This package provides resampling procedures to assess the stability of
selected variables with additional finite sample error control for
high-dimensional variable selection procedures such as Lasso or boosting.
Both, standard stability selection (Meinshausen & Buhlmann, 2010) and
complementary pairs stability selection with improved error bounds
(Shah & Samworth, 2013) are implemented.  The package can be combined with
arbitrary user specified variable selection approaches.")
    (license license:gpl2)))

(define-public r-rle
  (package
    (name "r-rle")
    (version "0.9.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rle" version))
       (sha256
        (base32
         "0sagl0jggg40lihzy7pfq4593rfvc3b3f7g6ggi85s7n18qvwg40"))))
    (properties `((upstream-name . "rle")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/rle/")
    (synopsis "Common functions for run-length encoded vectors")
    (description
     "This package provides common @code{base} and @code{stats} methods for
@code{rle} objects, aiming to make it possible to treat them transparently as
vectors.")
    (license license:gpl3)))

(define-public r-statnet-common
  (package
    (name "r-statnet-common")
    (version "4.7.0")
    (source
      (origin
        (method url-fetch)
        (uri (cran-uri "statnet.common" version))
        (sha256
          (base32
            "1cx1h1yzs8jjxk10y2h0wl69caspzgx5wdqp36dp4sxm0sk335xn"))))
    (properties
      `((upstream-name . "statnet.common")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-coda))
    (home-page "https://statnet.org")
    (synopsis "R scripts and utilities used by the Statnet software")
    (description "This package provides non-statistical utilities used by the
software developed by the Statnet Project.")
    (license license:gpl3)))

(define-public r-statcheck
  (package
    (name "r-statcheck")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "statcheck" version))
       (sha256
        (base32
         "0ivybdcrymlsfv6pg6p5bv70qdvgxf2vgp0kf4r0pf2fcvav1mcp"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-plyr r-rmarkdown))
    (home-page "https://cran.r-project.org/web/packages/statcheck/")
    (synopsis "Extract statistics from articles and recompute p-values")
    (description "This package can automatically extract statistical
null-hypothesis significant testing (NHST) results from articles and recompute
the p-values based on the reported test statistic and degrees of freedom to
detect possible inconsistencies.")
    (license license:gpl2)))

(define-public r-sna
  (package
    (name "r-sna")
    (version "2.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sna" version))
       (sha256
        (base32
         "0ka319s1w857fj28ja1i1ljgv2h6ji4d69riqy9pwhvvghsa83s4"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-network r-statnet-common))
    (home-page "https://statnet.org")
    (synopsis "Tools for social network analysis")
    (description
     "This package provides a range of tools for social network analysis,
including node and graph-level indices, structural distance and covariance
methods, structural equivalence detection, network regression, random graph
generation, and 2D/3D network visualization.")
    (license license:gpl2+)))

(define-public r-tfisher
  (package
    (name "r-tfisher")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "TFisher" version))
       (sha256
        (base32
         "0vz74ww1lf1prfwz74hfsi3a8nzq8ss7aqjr85c1d87vss2796xx"))))
    (properties `((upstream-name . "TFisher")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-matrix r-mvtnorm r-sn))
    (home-page "https://cran.r-project.org/web/packages/TFisher/")
    (synopsis "Optimal thresholding Fisher's p-value combination method")
    (description
     "This package provides the @dfn{cumulative distribution function} (CDF),
quantile, and statistical power calculator for a collection of thresholding
Fisher's p-value combination methods, including Fisher's p-value combination
method, truncated product method and, in particular, soft-thresholding
Fisher's p-value combination method which is proven to be optimal in some
context of signal detection.  The p-value calculator for the omnibus version
of these tests are also included.")
    (license license:gpl2)))

(define-public r-ttr
  (package
    (name "r-ttr")
    (version "0.24.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "TTR" version))
       (sha256
        (base32
         "11xsmbvmxq2j119j2z58bx1fkkb2xlhmzc35z5fbwr3nchrfz6jd"))))
    (properties `((upstream-name . "TTR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-curl r-xts r-zoo))
    (home-page "https://github.com/joshuaulrich/TTR")
    (synopsis "Technical trading rules")
    (description
     "This package provides functions and data to construct technical trading
rules with R.")
    (license license:gpl2)))

(define-public r-leaflet-providers
  (package
    (name "r-leaflet-providers")
    (version "1.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "leaflet.providers" version))
       (sha256
        (base32 "0yynrwv4xd5cdh49cwvfxm4ranarah9iiry2cd3b4fiihdfcg3wy"))))
    (properties `((upstream-name . "leaflet.providers")))
    (build-system r-build-system)
    (home-page "https://github.com/rstudio/leaflet.providers")
    (synopsis "Leaflet map tile providers")
    (description
     "This package contains third-party map tile provider information from
Leaflet.js, to be used with the @code{leaflet} R package.  Additionally,
@code{leaflet.providers} enables users to retrieve up-to-date provider
information between package updates.")
    (license license:bsd-2)))

;; This package contains a lot of minified JavaScript with unclear provenance.
;; When upgrading please make sure that all minified JavaScript files are
;; removed in a snippet and that the replacement sources correspond to the
;; original minified scripts.
(define-public r-leaflet
  (package
    (name "r-leaflet")
    (version "2.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "leaflet" version))
       (sha256
        (base32 "0xsng9n08i1w7qj4hbi706m6d8jm9ixrnwq5xac2s3csfm1s1xij"))
       (snippet
        '(for-each
          delete-file
          (list "inst/htmlwidgets/lib/leaflet/leaflet.js"
                "inst/htmlwidgets/lib/leaflet-measure/leaflet-measure.min.js"
                "inst/htmlwidgets/lib/leaflet-omnivore/leaflet-omnivore.min.js"
                "inst/htmlwidgets/lib/jquery/jquery.min.js"
                "inst/htmlwidgets/plugins/Leaflet-MiniMap/Control.MiniMap.min.js"
                "inst/htmlwidgets/plugins/Leaflet.awesome-markers/bootstrap.min.js"
                "inst/htmlwidgets/plugins/Leaflet.awesome-markers/leaflet.awesome-markers.min.js"
                "inst/htmlwidgets/plugins/Leaflet.markercluster/leaflet.markercluster.js"
                "inst/htmlwidgets/plugins/Leaflet.markercluster/leaflet.markercluster.freezable.js"
                "inst/htmlwidgets/plugins/Leaflet.markercluster/leaflet.markercluster.layersupport.js"
                "inst/legacy/www/leaflet.js")))))
    (properties `((upstream-name . "leaflet")))
    (build-system r-build-system)
    (arguments
     `(#:modules ((guix build utils)
                  (guix build r-build-system)
                  (srfi srfi-1))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             ;; The inst directory contains some minified JavaScript files.
             ;; Regenerate them from sources.
             (invoke "unzip" "-d" "/tmp" (assoc-ref inputs "js-leaflet"))
             (with-directory-excursion "inst/"
               (call-with-values
                   (lambda ()
                     (unzip2
                      `(("/tmp/leaflet-src.js"
                         "htmlwidgets/lib/leaflet/leaflet.js")
                        (,(assoc-ref inputs "js-leaflet-measure")
                         "htmlwidgets/lib/leaflet-measure/leaflet-measure.min.js")
                        (,(assoc-ref inputs "js-leaflet-omnivore")
                         "htmlwidgets/lib/leaflet-omnivore/leaflet-omnivore.min.js")
                        (,(assoc-ref inputs "js-jquery")
                         "htmlwidgets/lib/jquery/jquery.min.js")
                        ("htmlwidgets/plugins/Leaflet-MiniMap/Control.MiniMap.js"
                         "htmlwidgets/plugins/Leaflet-MiniMap/Control.MiniMap.min.js")
                        (,(assoc-ref inputs "js-bootstrap3")
                         "htmlwidgets/plugins/Leaflet.awesome-markers/bootstrap.min.js")
                        ("htmlwidgets/plugins/Leaflet.awesome-markers/leaflet.awesome-markers.js"
                         "htmlwidgets/plugins/Leaflet.awesome-markers/leaflet.awesome-markers.min.js")
                        (,(string-append (assoc-ref inputs "js-leaflet-markercluster")
                                         "/dist/leaflet.markercluster-src.js")
                         "htmlwidgets/plugins/Leaflet.markercluster/leaflet.markercluster.js")
                        (,(assoc-ref inputs "js-leaflet-markercluster-freezable")
                         "htmlwidgets/plugins/Leaflet.markercluster/leaflet.markercluster.freezable.js")
                        (,(assoc-ref inputs "js-leaflet-markercluster-layersupport")
                         "htmlwidgets/plugins/Leaflet.markercluster/leaflet.markercluster.layersupport.js")
                        (,(assoc-ref inputs "js-proj4leaflet")
                         "htmlwidgets/plugins/Proj4Leaflet/proj4.min.js")
                        ("legacy/www/leaflet-src.js"
                         "legacy/www/leaflet.js"))))
                 (lambda (sources targets)
                   (for-each (lambda (source target)
                               (format #true "Processing ~a --> ~a~%"
                                       source target)
                               (invoke "esbuild" source "--minify"
                                       (string-append "--outfile=" target)))
                             sources targets)))))))))
    (native-inputs
     `(("esbuild" ,esbuild)
       ("unzip" ,unzip)
       ("js-bootstrap3"
        ,(origin
           (method url-fetch)
           (uri "https://raw.githubusercontent.com/twbs/bootstrap/v3.3.7/dist/js/bootstrap.js")
           (sha256
            (base32
             "1j1qjagwj0m3q322z9wxxnpkd8zbk6g3kl047dsbmqad6gmqvgha"))))
       ("js-jquery"
        ,(origin
           (method url-fetch)
           (uri "https://code.jquery.com/jquery-1.12.4.js")
           (sha256
            (base32
             "0x9mrc1668icvhpwzvgafm8xm11x9lfai9nwr66aw6pjnpwkc3s3"))))
       ("js-leaflet"
        ,(origin
           (method url-fetch)
           (uri "http://cdn.leafletjs.com/leaflet/v1.3.1/leaflet.zip")
           (sha256
            (base32
             "10phzd2vczy3zm1b64whp2nna69cf9hlj2bndc9yq47vf3ddqx8f"))))
       ("js-leaflet-omnivore"
        ,(origin
           (method url-fetch)
           (uri (string-append "https://api.tiles.mapbox.com/mapbox.js/plugins/"
                               "leaflet-omnivore/v0.3.1/leaflet-omnivore.js"))
           (sha256
            (base32
             "1b8zxrp6xwzpw25apn8j4qws0f6sr7qr7h2va5h1mjyfqvn29anq"))))
       ("js-leaflet-markercluster"
        ,(origin
           (method git-fetch)
           (uri (git-reference
                 (url "https://github.com/Leaflet/Leaflet.markercluster.git")
                 (commit "v1.1.0")))
           (file-name (git-file-name "js-leaflet-markercluster" "1.1.0"))
           (sha256
            (base32
             "0ds8c7picqjmc86bm5n6hm8k71fwsa2cpgib19sbdamzr9hm0rs1"))))
       ("js-leaflet-markercluster-freezable"
        ,(origin
           (method url-fetch)
           (uri (string-append
                 "https://raw.githubusercontent.com/ghybs/Leaflet.MarkerCluster.Freezable/"
                 "9db80a3fba7dff4aee940e05d3d4dceaa1fffcf9/src/freezable.js"))
           (file-name "leaflet-markercluster-freezable.js")
           (sha256
            (base32
             "1k6sn5n0z2x3an91vwvkzmqq4b8ppswgk5hi5qrr79klas1hbx1k"))))
       ("js-leaflet-markercluster-layersupport"
        ,(origin
           (method url-fetch)
           (uri (string-append
                 "https://raw.githubusercontent.com/ghybs/Leaflet.MarkerCluster.LayerSupport/"
                 "87f3848b92e0516d9c98f6d4cd175f7b8a4e3805/src/layersupport.js"))
           (file-name "leaflet-markercluster-layersupport.js")
           (sha256
            (base32
             "15qa21xif94y762c65yxxysxykz3mma6y6agw3nxpr3s7wbb75ff"))))
       ("js-leaflet-measure"
        ,(origin
           (method url-fetch)
           (uri "https://unpkg.com/leaflet-measure@1.5.2/dist/leaflet-measure.js")
           (file-name "js-leaflet-measure-1.5.2.js")
           (sha256
            (base32
             "0ggg3ffmm7pj9ry4gssrh0a17pnad3p6gwi0dg98y819pmpqa7y0"))))
       ("js-proj4leaflet"
        ,(origin
           (method url-fetch)
           (uri "https://raw.githubusercontent.com/kartena/Proj4Leaflet/1.0.2/lib/proj4.js")
           (file-name "js-proj4leaflet-1.0.2.js")
           (sha256
            (base32
             "0vyrbf6gv2lyh4c2bzp5349ivwvvg28gpn87y52a7jdb13rlkpab"))))))
    (propagated-inputs
     (list r-base64enc
           r-crosstalk
           r-htmltools
           r-htmlwidgets
           r-leaflet-providers
           r-magrittr
           r-markdown
           r-png
           r-raster
           r-rcolorbrewer
           r-scales
           r-sp
           r-viridis))
    (home-page "https://rstudio.github.io/leaflet/")
    (synopsis "Create interactive web maps with the JavaScript Leaflet library")
    (description
     "Create and customize interactive maps using the Leaflet JavaScript
library and the @code{htmlwidgets} package.  These maps can be used directly
from the R console, from RStudio, in Shiny applications and R Markdown
documents.")
    (license license:gpl3)))

(define-public r-leaps
  (package
    (name "r-leaps")
    (version "3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "leaps" version))
       (sha256
        (base32
         "1dn3yl1p03n0iynd1vsdkrr0fhmvgrmfkv37y7n371765h83lz1x"))))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/leaps/")
    (synopsis "Regression subset selection")
    (description
     "This package provides tools for regression subset selection, including
exhaustive search.")
    (license license:gpl2+)))

(define-public r-splus2r
  (package
    (name "r-splus2r")
    (version "1.3-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "splus2R" version))
       (sha256
        (base32
         "035zd22zcpkh74rik9ws6g8al6vjz7jgrqs5si361bzb5n290p3x"))))
    (properties `((upstream-name . "splus2R")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/splus2R/")
    (synopsis "Supplemental S-PLUS functionality in R")
    (description
     "Currently there are many functions in S-PLUS that are missing in R.  To
facilitate the conversion of S-PLUS packages to R packages, this package
provides some missing S-PLUS functionality in R.")
    (license license:gpl2)))

(define-public r-ifultools
  (package
    (name "r-ifultools")
    (version "2.0-26")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ifultools" version))
       (sha256
        (base32
         "1lkmzrh65j6vdb8523axxk9gig5q4zxy08wiqsp16w482d2q2sl1"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      `(modify-phases %standard-phases
         (add-after 'unpack 'compatibility
           (lambda _
             ;; These definitions are no longer part of R since 4.2.0.  See
             ;; https://cran.r-project.org/doc/manuals/r-devel/NEWS.html for
             ;; details.
             (substitute* "inst/include/ut_RS.h"
               (("#include \"R.h\"" m)
                (string-append "\
#define R_PROBLEM_BUFSIZE 4096
#define PROBLEM	{char R_problem_buf[R_PROBLEM_BUFSIZE];(sprintf)(R_problem_buf,
#define MESSAGE {char R_problem_buf[R_PROBLEM_BUFSIZE];(sprintf)(R_problem_buf,
#define ERROR	),error(R_problem_buf);}
#define WARNING(x)		),warning(R_problem_buf);}
#define WARN			WARNING(NULL)
" m))))))))
    (propagated-inputs
     (list r-mass r-splus2r))
    (home-page "https://cran.r-project.org/web/packages/ifultools/")
    (synopsis "Insightful research tools")
    (description "This package provides C code used by the wmtsa, fractal, and
sapa R packages.")
    (license license:gpl2)))

(define-public r-sapa
  (package
    (name "r-sapa")
    (version "2.0-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sapa" version))
       (sha256
        (base32
         "0kj681rd4c2lvqr926lb6f4qwp281x5274dg6vbk8pf5y7s0qlpc"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ifultools r-splus2r))
    (home-page "https://cran.r-project.org/web/packages/sapa/")
    (synopsis "Spectral analysis for physical applications")
    (description "This package provides software for the book Spectral
Analysis for Physical Applications, Donald B. Percival and Andrew T. Walden,
Cambridge University Press, 1993.")
    (license license:gpl2)))

(define-public r-aggregation
  (package
    (name "r-aggregation")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "aggregation" version))
       (sha256
        (base32
         "0j9g604m2ccc7hcy02539yja9cf3xcbl25gvp838bp4x8w18my46"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/aggregation/")
    (synopsis "Methods for p-value aggregation")
    (description
     "This package contains functionality for performing the following methods
of p-value aggregation: Fisher's method, the Lancaster method (weighted
Fisher's method), and Sidak correction.")
    (license license:gpl3)))

(define-public r-quantmod
  (package
    (name "r-quantmod")
    (version "0.4.20")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "quantmod" version))
       (sha256
        (base32
         "154fqhw46kc7r08zsj5fsg97hg93phsli3z14xwmz22xb50xymzp"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-curl r-ttr r-xts r-zoo))
    (home-page "https://cran.r-project.org/web/packages/quantmod/")
    (synopsis "Quantitative financial modelling framework")
    (description "This package provides a quantitative financial modelling
framework to allow users to specify, build, trade, and analyse quantitative
financial trading strategies.")
    (license license:gpl3)))

(define-public r-tseries
  (package
    (name "r-tseries")
    (version "0.10-52")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tseries" version))
       (sha256
        (base32
         "0icgmng0dzvfkkn6dam74wvlz8g0cy46wkw57f5lpd5kxpdwi6ck"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-quadprog r-quantmod r-zoo))
    (native-inputs
     (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/tseries/")
    (synopsis "Time series analysis and computational finance")
    (description
     "This package provides functions relating to time series analysis and
computational finance.")
    (license license:gpl2)))

(define-public r-wmtsa
  (package
    (name "r-wmtsa")
    (version "2.0-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "wmtsa" version))
       (sha256
        (base32
         "1q436krz5p1f4a7a7sya6a9rh9x9mi8zzcgq66gbk9w9w4hcqcj6"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ifultools r-mass r-splus2r))
    (home-page "https://cran.r-project.org/web/packages/wmtsa/")
    (synopsis "Wavelet methods for time series analysis")
    (description
     "This package provides software to accompany the book \"Wavelet Methods
for Time Series Analysis\", Donald B. Percival and Andrew T. Walden, Cambridge
University Press, 2000.")
    (license license:gpl2)))

(define-public r-tsa
  (package
    (name "r-tsa")
    (version "1.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "TSA" version))
       (sha256
        (base32
         "14g58s2w7wma1fgcg3b51267b3676zrv0w8v4hpypxygz023d9bx"))))
    (properties `((upstream-name . "TSA")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-leaps r-locfit r-mgcv r-tseries))
    (home-page "https://homepage.divms.uiowa.edu/~kchan/TSA.htm")
    (synopsis "Time series analysis")
    (description
     "This package contains R functions and datasets detailed in the book
\"Time Series Analysis with Applications in R (second edition)\" by Jonathan
Cryer and Kung-Sik Chan.")
    (license license:gpl2+)))

(define-public r-extradistr
  (package
    (name "r-extradistr")
    (version "1.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "extraDistr" version))
       (sha256
        (base32
         "1gypnbvdzczl0mvznvy8r7hzsvc5gvdvi2mmzj21cqdw9n63944r"))))
    (properties `((upstream-name . "extraDistr")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp))
    (home-page "https://github.com/twolodzko/extraDistr")
    (synopsis "Additional univariate and multivariate distributions")
    (description
     "This package implements density, distribution functions, quantile
functions and random generation functions for a large number of univariate and
multivariate distributions.")
    (license license:gpl2)))

(define-public r-fractal
  (package
    (name "r-fractal")
    (version "2.0-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fractal" version))
       (sha256
        (base32
         "18lr9z0gslvfc3z8vyj3krqj3bfhg60zv1fzinrwwkc4cpk1w7mp"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ifultools
           r-mass
           r-sapa
           r-scatterplot3d
           r-splus2r
           r-wmtsa))
    (home-page "https://cran.r-project.org/web/packages/fractal/")
    (synopsis "Fractal time series modeling and analysis")
    (description
     "This package provides tools for stochastic fractal and deterministic
chaotic time series analysis.")
    (license license:gpl2)))

(define-public r-fresh
  (package
    (name "r-fresh")
    (version "0.2.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "fresh" version))
              (sha256
               (base32
                "1787mm6w2s5x9scxy7r9cb77rgpmy4ngwkn4z8g3gs48mrab4bd9"))))
    (properties `((upstream-name . "fresh")))
    (build-system r-build-system)
    (propagated-inputs (list r-htmltools r-rstudioapi r-sass r-shiny))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/dreamRs/fresh")
    (synopsis "Create custom Bootstrap themes to use in Shiny")
    (description
     "Customize Bootstrap and Bootswatch themes, like colors, fonts,
grid layout, to use in Shiny applications, rmarkdown documents and
flexdashboard.")
    (license license:gpl3)))

(define-public r-urca
  (package
    (name "r-urca")
    (version "1.3-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "urca" version))
       (sha256
        (base32
         "1wg9f691pif59xds43gnnw77mmzc9xpnhhvaksk2b0szffvaifj3"))))
    (build-system r-build-system)
    (propagated-inputs (list r-nlme))
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/urca/")
    (synopsis "Unit root and cointegration tests for time series data")
    (description
     "This package provides unit root and cointegration tests encountered in
applied econometric analysis.")
    (license license:gpl2+)))

(define-public r-cubature
  (package
    (name "r-cubature")
    (version "2.0.4.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cubature" version))
       (sha256
        (base32
         "08whkhvn218089r930spn97m91vv1njgh2amksia8l3rbf7127x8"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/bnaras/cubature")
    (synopsis "Adaptive multivariate integration over hypercubes")
    (description
     "This package is an R wrapper around the cubature C library for adaptive
multivariate integration over hypercubes.  This version provides both
@code{hcubature} and @code{pcubature} routines in addition to a vector
interface.")
    ;; The included cubature C library is released under GPLv2+, but the
    ;; wrapper declares the license to be GPLv3+.
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-trend
  (package
    (name "r-trend")
    (version "1.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "trend" version))
       (sha256
        (base32
         "1mr5g5gaxiqj6x83ngcbwwh57vhrhcz0x9dh0rmvs9y2ivk29ccs"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-extradistr))
    (native-inputs
     (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/trend/")
    (synopsis "Non-parametric trend tests and change-point detection")
    (description
     "The analysis of environmental data often requires the detection of
trends and change-points.  This package includes tests for trend
detection (Cox-Stuart Trend Test, Mann-Kendall Trend Test, (correlated)
Hirsch-Slack Test, partial Mann-Kendall Trend Test, multivariate (multisite)
Mann-Kendall Trend Test, (Seasonal) Sen's slope, partial Pearson and Spearman
correlation trend test), change-point detection (Lanzante's test procedures,
Pettitt's test, Buishand Range Test, Buishand U Test, Standard Normal
Homogeinity Test), detection of non-randomness (Wallis-Moore Phase Frequency
Test, Bartels rank von Neumann's ratio test, Wald-Wolfowitz Test) and the two
sample Robust Rank-Order Distributional Test.")
    (license license:gpl3)))

(define-public r-expm
  (package
    (name "r-expm")
    (version "0.999-6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "expm" version))
       (sha256
        (base32
         "1p5dapwv8ycxaysgi6imnby04i4kh1c5a2czqa4wygz0s8pr2y9c"))))
    (build-system r-build-system)
    (propagated-inputs (list r-matrix))
    (native-inputs (list gfortran))
    (home-page "https://r-forge.r-project.org/projects/expm/")
    (synopsis "Tools for matrix exponentials and related quantities")
    (description
     "This package provides tools for the computation of the matrix
exponential, logarithm, square root, and related quantities.")
    (license license:gpl2+)))

(define-public r-exposition
  (package
    (name "r-exposition")
    (version "2.8.23")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ExPosition" version))
              (sha256
               (base32
                "0x9400ggmgrnaish0cfgnyvw549g4ibfv9aj6vzq7j68n58vq405"))))
    (properties `((upstream-name . "ExPosition")))
    (build-system r-build-system)
    (propagated-inputs (list r-prettygraphs))
    (home-page "https://cran.r-project.org/package=ExPosition")
    (synopsis "Exploratory analysis with the singular value decomposition")
    (description
     "This package provides a variety of descriptive multivariate analyses
with the singular value decomposition, such as principal components analysis,
correspondence analysis, and multidimensional scaling.  See An ExPosition of
the Singular Value Decomposition in R (Beaton et al 2014)
<doi:10.1016/j.csda.2013.11.006>.")
    (license license:gpl2)))

(define-public r-complexplus
  (package
    (name "r-complexplus")
    (version "2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "complexplus" version))
       (sha256
        (base32
         "16w9v7d1ckavqmr86l34frr37pkvdn0iqnb17ssb8xaggns5lgqx"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-expm r-matrix))
    (home-page "https://cran.r-project.org/web/packages/complexplus/")
    (synopsis "Functions of complex or real variables")
    (description
     "This package extends several functions to the complex domain, including
the matrix exponential and logarithm, and the determinant.")
    (license license:gpl2)))

(define-public r-phontools
  (package
    (name "r-phontools")
    (version "0.2-2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "phonTools" version))
       (sha256
        (base32
         "01i481mhswsys3gpasw9gn6nxkfmi7bz46g5c84m13pg0cv8hxc7"))))
    (properties `((upstream-name . "phonTools")))
    (build-system r-build-system)
    (home-page "http://www.santiagobarreda.com/rscripts.html")
    (synopsis "Tools for phonetic and acoustic analyses")
    (description
     "This package contains tools for the organization, display, and analysis
of the sorts of data frequently encountered in phonetics research and
experimentation, including the easy creation of IPA vowel plots, and the
creation and manipulation of WAVE audio files.")
    (license license:bsd-2)))

(define-public r-np
  (package
    (name "r-np")
    (version "0.60-16")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "np" version))
       (sha256
        (base32
         "1c01drwvh2jj0s40q19ghdf429s6px07akg6d0yfanah3706gydy"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-boot r-cubature r-quadprog r-quantreg))
    (home-page "https://github.com/JeffreyRacine/R-Package-np")
    (synopsis "Non-parametric kernel smoothing methods for mixed data types")
    (description "This package provides non-parametric (and semi-parametric)
kernel methods that seamlessly handle a mix of continuous, unordered, and
ordered factor data types.")
    ;; Any version of the GPL.
    (license license:gpl3+)))

(define-public r-powerplus
  (package
    (name "r-powerplus")
    (version "3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "powerplus" version))
       (sha256
        (base32
         "0ayp6x34hkzgris4j3zbbs0r23n81bhww3wgfyy630ri4sk6brrn"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-complexplus r-expm r-mass r-matrix r-phontools))
    (home-page "https://cran.r-project.org/web/packages/powerplus/")
    (synopsis "Exponentiation operations")
    (description
     "This package provides tools for the computation of matrix and scalar
exponentiation.")
    (license license:gpl2)))

(define-public r-egg
  (package
    (name "r-egg")
    (version "0.4.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "egg" version))
       (sha256
        (base32
         "1fy7srpiavfn8kyrr1m84an7acgwi6ydzrg71m3b0vk7y9ybmj0m"))))
    (properties `((upstream-name . "egg")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-gridextra r-gtable))
    (home-page "https://cran.r-project.org/web/packages/egg")
    (synopsis "Extensions for ggplot2")
    (description
     "This package provides miscellaneous functions to help customize ggplot2
objects.  High-level functions are provided to post-process ggplot2 layouts
and allow alignment between plot panels, as well as setting panel sizes to
fixed values.  Other functions include a custom @code{geom}, and helper
functions to enforce symmetric scales or add tags to facetted plots.")
    (license license:gpl3)))

(define-public r-heatmap3
  (package
    (name "r-heatmap3")
    (version "1.1.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "heatmap3" version))
       (sha256
        (base32
         "0sfvizmmwfk1bjhn6zfx5a4qqfgj1ldg8x90b65crqibgfa36k2r"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-fastcluster))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/heatmap3/")
    (synopsis "Improved heatmap package")
    (description
     "This package provides an improved heatmap package.  It is completely
compatible with the original R function @code{heatmap}, and provides more
powerful and convenient features.")
    (license license:gpl2+)))

(define-public r-heatmaply
  (package
    (name "r-heatmaply")
    (version "1.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "heatmaply" version))
       (sha256
        (base32
         "0q1vkf55a5r0ssybdbi2fyhn13p29kw04yp46c34n7apm0k2ymgi"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertthat
           r-colorspace
           r-dendextend
           r-egg
           r-ggplot2
           r-htmlwidgets
           r-magrittr
           r-plotly
           r-rcolorbrewer
           r-reshape2
           r-scales
           r-seriation
           r-viridis
           r-webshot))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/package=heatmaply")
    (synopsis "Interactive cluster heat maps using plotly")
    (description
     "This package enables you to create interactive cluster heatmaps that can
be saved as a stand-alone HTML file, embedded in R Markdown documents or in a
Shiny app, and made available in the RStudio viewer pane.  Hover the mouse
pointer over a cell to show details or drag a rectangle to zoom.  A heatmap is
a popular graphical method for visualizing high-dimensional data, in which a
table of numbers is encoded as a grid of colored cells.  The rows and columns
of the matrix are ordered to highlight patterns and are often accompanied by
dendrograms.")
    ;; Either version of the license.
    (license (list license:gpl2 license:gpl3))))

(define-public r-h5
  (package
    (name "r-h5")
    (version "0.9.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "h5" version))
       (sha256
        (base32
         "14p7i1sj24ky87kd7qr3n9fc9l64s0bp0rwbyl6i2x69xn75gpsx"))))
    (build-system r-build-system)
    (inputs
     (list zlib hdf5))
    (native-inputs
     (list which))
    (propagated-inputs
     (list r-rcpp))
    (home-page "https://github.com/mannau/h5")
    (synopsis "Interface to the HDF5 Library")
    (description
     "This package provides an S4 interface to the HDF5 library supporting
fast storage and retrieval of R-objects like vectors, matrices and arrays to
binary files in a language independent format.  The HDF5 format can therefore
be used as an alternative to R's save/load mechanism.  Since h5 is able to
access only subsets of stored data it can also handle data sets which do not
fit into memory.")
    (license license:bsd-2)))

(define-public r-cgdsr
  (package
    (name "r-cgdsr")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cgdsr" version))
       (sha256
        (base32
         "07yc819hkabpzzh0g0cbqza6bcfy67b2marrzz1lj97f9iba78ja"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-httr r-r-methodss3 r-r-oo))
    (home-page "https://github.com/cBioPortal/cgdsr")
    (synopsis "R-based API for accessing the MSKCC Cancer Genomics Data Server")
    (description
     "This package provides a basic set of R functions for querying the Cancer
Genomics Data Server (CGDS), hosted by the Computational Biology Center at
Memorial-Sloan-Kettering Cancer Center (MSKCC).")
    (license license:lgpl3)))

(define-public r-import
  (package
    (name "r-import")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "import" version))
       (sha256
        (base32
         "19g4jnfg9pkvvsncw62yc15xlb97hfbdqxivpjd9jqi36i6mdjrg"))))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/smbache/import")
    (synopsis "Import mechanism for R")
    (description
     "This is an alternative mechanism for importing objects from packages.
The syntax allows for importing multiple objects from a package with a single
command in an expressive way.  The import package bridges some of the gap
between using @code{library} (or @code{require}) and direct (single-object)
imports.  Furthermore the imported objects are not placed in the current
environment.  It is also possible to import objects from stand-alone @code{.R}
files.")
    (license license:expat)))

(define-public r-shinyace
  (package
    (name "r-shinyace")
    (version "0.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shinyAce" version))
       (sha256
        (base32
         "12mqvdh6rxsr61pc3pzla95r5f4l7xagjs2rcdr7c2lbqyxpx6aa"))))
    (properties `((upstream-name . "shinyAce")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-shiny r-jsonlite))
    (home-page "https://cran.r-project.org/web/packages/shinyAce/")
    (synopsis "Ace editor bindings for Shiny")
    (description
     "This package provides Ace editor bindings to enable a rich text editing
environment within Shiny.")
    (license license:expat)))

(define-public r-rafalib
  (package
    (name "r-rafalib")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rafalib" version))
       (sha256
        (base32 "1dmxjl66bfdgrybhwyaa8d4i460liqcdw8b29a6w7shgksh29m0k"))))
    (properties `((upstream-name . "rafalib")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcolorbrewer))
    (home-page "https://cran.r-project.org/package=rafalib")
    (synopsis "Convenience functions for routine data exploration")
    (description
     "This package provides a series of shortcuts for routine tasks to
facilitate data exploration.")
    (license license:artistic2.0)))

(define-public r-randomizr
  (package
    (name "r-randomizr")
    (version "0.22.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "randomizr" version))
       (sha256
        (base32
         "1grm0h3xkb0pdbbv0gd531g1kn6njp0gcy5fh153rrmajxgd8hhw"))))
    (properties `((upstream-name . "randomizr")))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr))
    (home-page "https://declaredesign.org/r/randomizr/")
    (synopsis "Tools for common forms of random assignment and sampling")
    (description
     "This package provides tools for generating random assignments for common
experimental designs and random samples for common sampling designs.")
    (license license:expat)))

(define-public r-base64url
  (package
    (name "r-base64url")
    (version "1.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "base64url" version))
       (sha256
        (base32
         "0n1c2b68vza1dh7sk38v6biiwm72c4jpl79kpdg1bsb0hq9qy18x"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-backports))
    (home-page "https://github.com/mllg/base64url")
    (synopsis "Fast and URL-safe base64 encoder and decoder")
    (description
     "This package provides a URL-safe base64 encoder and decoder.  In
contrast to RFC3548, the 62nd character (@code{+}) is replaced with @code{-},
the 63rd character (@code{/}) is replaced with @code{_}.  Furthermore, the
encoder does not fill the string with trailing @code{=}.  The resulting
encoded strings comply to the regular expression pattern @code{[A-Za-z0-9_-]}
and thus are safe to use in URLs or for file names.  The package also comes
with a simple base32 encoder/decoder suited for case insensitive file
systems.")
    (license license:gpl3)))

(define-public r-radiant-data
  (package
    (name "r-radiant-data")
    (version "1.4.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "radiant.data" version))
       (sha256
        (base32
         "1vas0bkpngwxybmpdcaimha2r008prnli4b3lgjbjfkzpgm966d1"))
       (modules '((guix build utils)))
       (snippet
        '(begin
           ;; Delete files that are under CC-NC-SA.
           (delete-file-recursively "inst/app/tools/help")
           #t))))
    (properties `((upstream-name . "radiant.data")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-base64enc
           r-broom
           r-bslib
           r-car
           r-curl
           r-dplyr
           r-dt
           r-glue
           r-ggplot2
           r-import
           r-jsonlite
           r-knitr
           r-lubridate
           r-magrittr
           r-markdown
           r-mass
           r-patchwork
           r-plotly
           r-png
           r-psych
           r-randomizr
           r-readr
           r-readxl
           r-rlang
           r-rmarkdown
           r-rstudioapi
           r-scales
           r-shiny
           r-shinyfiles
           r-shinyace
           r-stringi
           r-tibble
           r-tidyr
           r-writexl))
    (home-page "https://github.com/radiant-rstats/radiant.data")
    (synopsis "Data menu for Radiant: business analytics using R and Shiny")
    (description
     "The Radiant Data menu includes interfaces for loading, saving, viewing,
visualizing, summarizing, transforming, and combining data.  It also contains
functionality to generate reproducible reports of the analyses conducted in
the application.")
    (license license:agpl3)))

(define-public r-algdesign
  (package
    (name "r-algdesign")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "AlgDesign" version))
       (sha256
        (base32 "01cx63wqr6yvgl5ml1lj6gh9p1sn42b6qcnsppcw7mvba9n652ar"))))
    (properties `((upstream-name . "AlgDesign")))
    (build-system r-build-system)
    (home-page "https://github.com/jvbraun/AlgDesign")
    (synopsis "Algorithmic experimental design")
    (description
     "This package provides tools to calculate exact and approximate theory
experimental designs for D, A, and I criteria.  Very large designs may be
created.  Experimental designs may be blocked or blocked designs created from
a candidate list, using several criteria.  The blocking can be done when whole
and within plot factors interact.")
    (license license:gpl2+)))

(define-public r-alluvial
  (package
    (name "r-alluvial")
    (version "0.1-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "alluvial" version))
       (sha256
        (base32 "039frwrsxq1lb97s7vf2vbyyadimkigs628ymym06fxka53drdkp"))))
    (properties `((upstream-name . "alluvial")))
    (build-system r-build-system)
    (native-inputs (list r-knitr))
    (home-page "https://github.com/mbojan/alluvial")
    (synopsis "Create parallel sets plots (Alluvial Diagrams)")
    (description
     "This package creates alluvial diagrams (also known as parallel sets
plots) for multivariate and time series-like data.")
    (license license:expat)))

(define-public r-signal
  (package
    (name "r-signal")
    (version "0.7-7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "signal" version))
       (sha256
        (base32
         "0qaf39vfmhn3d0bdjqd805ayfkaj48dkmf5dqd47bpk7dp21b837"))))
    (build-system r-build-system)
    (propagated-inputs (list r-mass))
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/signal/")
    (synopsis "Signal processing")
    (description
     "This package provides a set of signal processing functions originally
written for Matlab and GNU Octave.  It includes filter generation utilities,
filtering functions, resampling routines, and visualization of filter models.
It also includes interpolation functions.")
    (license license:gpl2)))

(define-public r-gsubfn
  (package
    (name "r-gsubfn")
    (version "0.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gsubfn" version))
       (sha256
        (base32
         "00j6b8b6xsx6v370h220x233rpk6asca78165y3d48jpwvwisdc9"))))
    (build-system r-build-system)
    (propagated-inputs (list r-proto))
    (home-page "https://code.google.com/archive/p/gsubfn/")
    (synopsis "Utilities for strings and function arguments")
    (description
     "This package provides @code{gsubfn} which is like @code{gsub} but can
take a replacement function or certain other objects instead of the
replacement string.  Matches and back references are input to the replacement
function and replaced by the function output.  @code{gsubfn} can be used to
split strings based on content rather than delimiters and for quasi-perl-style
string interpolation.  The package also has facilities for translating
formulas to functions and allowing such formulas in function calls instead of
functions.")
    (license license:gpl2+)))

(define-public r-sqldf
  (package
    (name "r-sqldf")
    (version "0.4-11")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sqldf" version))
       (sha256
        (base32
         "0q12vsb53p2wchgp8wfz5bk08wfnm0jxjrakclj4jyy6x3a7ksff"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-chron r-dbi r-gsubfn r-proto r-rsqlite))
    (home-page "https://github.com/ggrothendieck/sqldf")
    (synopsis "Manipulate R data frames using SQL")
    (description
     "The @code{sqldf} function is typically passed a single argument which is
an SQL select statement where the table names are ordinary R data frame names.
@code{sqldf} transparently sets up a database, imports the data frames into
that database, performs the SQL statement and returns the result using a
heuristic to determine which class to assign to each column of the returned
data frame.  The @code{sqldf} or @code{read.csv.sql} functions can also be
used to read filtered files into R even if the original files are larger than
R itself can handle.")
    (license license:gpl2)))

(define-public r-abind
  (package
    (name "r-abind")
    (version "1.4-5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abind" version))
       (sha256
        (base32
         "0b1zd8jbnl6l292cr9rb50m09fy3ylxvzkpgi5lfb1nbzddcwfis"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/abind/")
    (synopsis "Combine multidimensional arrays")
    (description
     "This package provides tools to combine multidimensional arrays into a
single array.  This is a generalization of @code{cbind} and @code{rbind}.  It
works with vectors, matrices, and higher-dimensional arrays.  It also provides
the functions @code{adrop}, @code{asub}, and @code{afill} for manipulating,
extracting and replacing data in arrays.")
    (license license:lgpl2.0+)))

(define-public r-prroc
  (package
    (name "r-prroc")
    (version "1.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "PRROC" version))
       (sha256
        (base32
         "1m28h8pcd78049lz2qixhkcr9h5b3jik3maqzfbvq9y58z71i4a7"))))
    (properties `((upstream-name . "PRROC")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/PRROC/")
    (synopsis "Precision-Recall and ROC curves for weighted and unweighted data")
    (description
     "This package computes the areas under the @dfn{precision-recall} (PR)
and ROC curve for weighted (e.g. soft-labeled) and unweighted data.  In
contrast to other implementations, the interpolation between points of the PR
curve is done by a non-linear piecewise function.  In addition to the areas
under the curves, the curves themselves can also be computed and plotted by a
specific S3-method.")
    (license license:gpl3)))

(define-public r-vim
  (package
    (name "r-vim")
    (version "6.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "VIM" version))
       (sha256
        (base32
         "1r0myxcx8y1a3fkf9ssk882f09snn2j6zilsygpld32hahn4k9xg"))))
    (properties `((upstream-name . "VIM")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-car
           r-colorspace
           r-data-table
           r-e1071
           r-laeken
           r-magrittr
           r-mass
           r-nnet
           r-ranger
           r-rcpp
           r-robustbase
           r-sp
           r-vcd))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/alexkowa/VIM")
    (synopsis "Visualization and imputation of missing values")
    (description
     "This package provides tools for the visualization of missing and/or
imputed values are introduced, which can be used for exploring the data and
the structure of the missing and/or imputed values.  Depending on this
structure of the missing values, the corresponding methods may help to
identify the mechanism generating the missing values and explore the
data including missing values.  In addition, the quality of imputation can be
visually explored using various univariate, bivariate, multiple and
multivariate plot methods.")
    (license license:gpl2+)))

(define-public r-fnn
  (package
    (name "r-fnn")
    (version "1.1.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "FNN" version))
       (sha256
        (base32
         "0nmynpiy3d2dnd5ngjf4m79jy02byhk43gj0xny9a6j8243f5c2j"))))
    (properties `((upstream-name . "FNN")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/FNN")
    (synopsis "Fast nearest neighbor search algorithms and applications")
    (description
     "This package provides cover-tree and kd-tree fast k-nearest neighbor
search algorithms.  Related applications including KNN classification,
regression and information measures are implemented.")
    ;; The DESCRIPTION file erroneously states that GPL version 2.1 or
    ;; later can be used.
    (license license:gpl2+)))

(define-public r-smoother
  (package
    (name "r-smoother")
    (version "1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "smoother" version))
       (sha256
        (base32
         "0nqr1bvlr5bnasqg74zmknjjl4x28kla9h5cxpga3kq5z215pdci"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ttr))
    (home-page "https://cran.r-project.org/web/packages/smoother")
    (synopsis "Functions relating to the smoothing of numerical data")
    (description
     "This package provides a collection of methods for smoothing numerical
data, commencing with a port of the Matlab gaussian window smoothing function.
In addition, several functions typically used in smoothing of financial data
are included.")
    (license license:gpl2)))

(define-public r-riverplot
  (package
    (name "r-riverplot")
    (version "0.10")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "riverplot" version))
       (sha256
        (base32
         "04ap1dsa7fx03l73jhv1ql3adaaaz2100qawdplxa9xmrllgcgbj"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcolorbrewer))
    (native-inputs
     (list r-knitr))
    (home-page "https://logfc.wordpress.com")
    (synopsis "Sankey or ribbon plots")
    (description
     "Sankey plots are a type of diagram that is convenient to illustrate how
flow of information, resources etc. separates and joins, much like observing
how rivers split and merge.  For example, they can be used to compare
different clusterings.  This package provides an implementation of Sankey
plots for R.")
    (license license:gpl2+)))

(define-public r-dyn
  (package
    (name "r-dyn")
    (version "0.2-9.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dyn" version))
       (sha256
        (base32
         "16fqv9k7yxdgybwzafjkyqm16qpgqz13lcjpi6a1nc8xbzlzh0gb"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-zoo))
    (home-page "https://cran.r-project.org/web/packages/dyn")
    (synopsis "Time series regression")
    (description
     "This package provides the dyn class interfaces @code{ts}, @code{irts},
@code{zoo} and @code{zooreg} time series classes to @code{lm}, @code{glm},
@code{loess}, @code{quantreg::rq}, @code{MASS::rlm},
@code{MCMCpack::MCMCregress()}, @code{quantreg::rq()},
@code{randomForest::randomForest()} and other regression functions, allowing
those functions to be used with time series including specifications that may
contain lags, diffs and missing values.")
    ;; Any GPL version.
    (license license:gpl2+)))

(define-public r-dynutils
  (package
    (name "r-dynutils")
    (version "1.0.11")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dynutils" version))
       (sha256
        (base32 "06an2bm1d131v28m240vii2wisbz3zs32wbamm2w7r8rl3yrxkh9"))))
    (properties `((upstream-name . "dynutils")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertthat
           r-crayon
           r-desc
           r-dplyr
           r-magrittr
           r-matrix
           r-proxyc
           r-purrr
           r-rcpp
           r-remotes
           r-stringr
           r-tibble))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/dynverse/dynutils")
    (synopsis "Common functionality for the dynverse packages")
    (description
     "This package provides common functionality for the
@url{https://dynverse.org,dynverse} packages.  dynverse is created to support
the development, execution, and benchmarking of trajectory inference
methods.")
    (license license:expat)))

(define-public r-catdap
  (package
    (name "r-catdap")
    (version "1.3.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "catdap" version))
       (sha256
        (base32
         "0fyhl69z2lznymvpzxra9qvcg85ggzkfjy68c6mzdmf1ja44d2k5"))))
    (build-system r-build-system)
    (native-inputs
     (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/catdap/")
    (synopsis "Tools for categorical data analysis")
    (description
     "This package provides functions for analyzing multivariate data.
Dependencies of the distribution of the specified variable (response
variable) to other variables (explanatory variables) are derived and
evaluated by the @dfn{Akaike Information Criterion} (AIC).")
    (license license:gpl2+)))

(define-public r-catdata
  (package
    (name "r-catdata")
    (version "1.2.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "catdata" version))
              (sha256
               (base32
                "14kx7yi0cv6dyh9wjasb8gn6cp1bhglgwql7dc2a7lqvdcp0d5vj"))))
    (properties `((upstream-name . "catdata")))
    (build-system r-build-system)
    (propagated-inputs (list r-mass))
    (home-page "https://cran.r-project.org/package=catdata")
    (synopsis
     "Datasets and examples used in the book @emph{Regression for Categorical Data}")
    (description
     "This R package contains examples from the book @emph{Regression
for Categorical Data}, Tutz 2012, Cambridge University Press.  The
names of the examples refer to the chapter and the data set that is
used.")
    (license license:gpl2)))

(define-public r-arules
  (package
    (name "r-arules")
    (version "1.7-5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "arules" version))
       (sha256
        (base32
         "0d04w28hl9gcrvkj0v0q77x4a89jhvzf1imw58xfgncap8mc6555"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-generics r-matrix))
    (home-page "https://github.com/mhahsler/arules")
    (synopsis "Mining association rules and frequent itemsets")
    (description
     "This package provides an infrastructure for representing, manipulating
and analyzing transaction data and patterns (frequent itemsets and association rules).
It also provides C implementations of the association mining algorithms Apriori
and Eclat.")
    (license license:gpl3)))

(define-public r-parsedate
  (package
    (name "r-parsedate")
    (version "1.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "parsedate" version))
       (sha256
        (base32
         "1cfinqlbchmkhkgmdwiy3mnxb17lp02jfk2gpw56hq9vh6wimhqz"))))
    (build-system r-build-system)
    (home-page "https://github.com/gaborcsardi/parsedate")
    (synopsis
     "Recognize and parse dates in various formats")
    (description
     "This package provides three functions for dealing with dates:
@code{parse_iso_8601} recognizes and parses all valid ISO 8601 date and
time formats, @code{parse_date} parses dates in unspecified formats,
and @code{format_iso_8601} formats a date in ISO 8601 format.")
    (license license:gpl2)))

(define-public r-abc-data
  (package
    (name "r-abc-data")
    (version "1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abc.data" version))
       (sha256
        (base32
         "1bv1n68ah714ws58cf285n2s2v5vn7382lfjca4jxph57lyg8hmj"))))
    (properties `((upstream-name . "abc.data")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/abc.data/")
    (synopsis "Data for Approximate Bayesian Computation (ABC) package")
    (description
     "This package contains data which are used by functions of the abc
package which implements several @dfn{Approximate Bayesian Computation} (ABC)
algorithms for performing parameter estimation, model selection, and
goodness-of-fit.")
    (license license:gpl3+)))

(define-public r-abc
  (package
    (name "r-abc")
    (version "2.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abc" version))
       (sha256
        (base32
         "16753lyzk2dfwgdjfyanwacqw3bvrwby52inq4709804labs6lnv"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-abc-data r-locfit r-mass r-nnet r-quantreg))
    (home-page "https://cran.r-project.org/web/packages/abc/")
    (synopsis "Tools for Approximate Bayesian Computation (ABC)")
    (description
     "This package implements several @dfn{Approximate Bayesian
Computation} (ABC) algorithms for performing parameter estimation, model
selection, and goodness-of-fit.  Cross-validation tools are also available for
measuring the accuracy of ABC estimates, and to calculate the
misclassification probabilities of different models.")
    (license license:gpl3+)))

(define-public r-zip
  (package
    (name "r-zip")
    (version "2.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "zip" version))
       (sha256
        (base32
         "194f19649jqw8wa2bd1kj3873hqnqxsrbqdwnvlzngi8pcixwv71"))))
    (build-system r-build-system)
    (home-page "https://github.com/gaborcsardi/zip")
    (synopsis "Cross-platform Zip compression")
    (description
     "This package provides a cross-platform Zip compression library for R.
It is a replacement for the @code{zip} function, that does not require any
additional external tools on any platform.")
    (license license:cc0)))

(define-public r-openxlsx
  (package
    (name "r-openxlsx")
    (version "4.2.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "openxlsx" version))
       (sha256
        (base32
         "1j2516plvlrp7l0mw7xqjhjjcidfdnfsybdhi2bx3n0910w29lk4"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp r-stringi r-zip))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/awalker89/openxlsx")
    (synopsis "Read, write and edit XLSX files")
    (description
     "This package simplifies the creation of Excel @code{.xlsx} files by
providing a high level interface to writing, styling and editing worksheets.
Through the use of Rcpp, read/write times are comparable to the @code{xlsx}
and @code{XLConnect} packages with the added benefit of removing the
dependency on Java.")
    (license license:gpl3)))

(define-public r-rio
  (package
    (name "r-rio")
    (version "0.5.29")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rio" version))
       (sha256
        (base32
         "04jlrhyl0791yxwcpp1s8p1hhkljnijlc5iaxpk56h41w63k39lz"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-curl
           r-data-table
           r-foreign
           r-haven
           r-openxlsx
           r-readxl
           r-tibble))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/leeper/rio")
    (synopsis "Swiss-army knife for data I/O")
    (description
     "This package provides streamlined data import and export infrastructure
by making assumptions that the user is probably willing to make: @code{import}
and @code{export} determine the data structure from the file extension,
reasonable defaults are used for data import and export (e.g.,
@code{stringsAsFactors=FALSE}), web-based import is natively
supported (including from SSL/HTTPS), compressed files can be read directly
without explicit decompression, and fast import packages are used where
appropriate.  An additional convenience function, @code{convert}, provides a
simple method for converting between file types.")
    (license license:gpl2)))

(define-public r-maptools
  (package
    (name "r-maptools")
    (version "1.1-5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "maptools" version))
       (sha256
        (base32
         "1p155w26hpmqc589kxha0xgw5b4x6610a3im7ap4mjx1sfavvn9w"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-foreign r-lattice r-sp))
    (home-page "https://r-forge.r-project.org/projects/maptools/")
    (synopsis "Tools for reading and handling spatial objects")
    (description
     "This package provides a set of tools for manipulating and reading
geographic data, in particular ESRI Shapefiles.  It includes binary access to
GSHHG shoreline files.  The package also provides interface wrappers for
exchanging spatial objects with other R packages.")
    ;; The C source files from shapelib are released under the Expat license.
    ;; The R code is released under GPL version 2 or later.
    (license (list license:gpl2+
                   license:expat))))

(define-public r-later
  (package
    (name "r-later")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "later" version))
       (sha256
        (base32
         "0acqg29hcm2iq1418b54np7zb5pnr3xzrwc3ijv2pz9wra10ix88"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp r-rlang))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/r-lib/later")
    (synopsis "Utilities for delaying function execution")
    (description
     "This package provides tools to execute arbitrary R or C functions some
time after the current time, after the R execution stack has emptied.")
    (license license:gpl2+)))

(define-public r-promises
  (package
    (name "r-promises")
    (version "1.2.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "promises" version))
       (sha256
        (base32
         "1dy4cbqw17awh4q8m7cy3anaj0n9iynabfzflb1g94cyj0bq4fld"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-later r-magrittr r-r6 r-rcpp r-rlang))
    (native-inputs
     (list r-knitr))
    (home-page "https://rstudio.github.io/promises")
    (synopsis "Abstractions for promise-based asynchronous programming")
    (description
     "This package provides fundamental abstractions for doing asynchronous
programming in R using promises.  Asynchronous programming is useful for
allowing a single R process to orchestrate multiple tasks in the background
while also attending to something else.  Semantics are similar to JavaScript
promises, but with a syntax that is idiomatic R.")
    (license license:expat)))

(define-public r-dosnow
  (package
    (name "r-dosnow")
    (version "1.0.20")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "doSNOW" version))
       (sha256
        (base32
         "1f5v0k2w0b2478p6iqa3hn2lwd1x3rzc348n57nd38ka2vnsnz4i"))))
    (properties `((upstream-name . "doSNOW")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-foreach r-iterators r-snow))
    (home-page "https://cran.r-project.org/web/packages/doSNOW")
    (synopsis "Foreach parallel adaptor for the snow package")
    (description
     "This package provides a parallel backend for the @code{%dopar%} function
using the @code{snow} package.")
    (license license:gpl2)))

(define-public r-fstcore
  (package
    (name "r-fstcore")
    (version "0.9.12")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fstcore" version))
       (sha256
        (base32 "1a5m68n2dqhi3r8wf5jwg4vjvl550c7wypcf5j0xmkvl836yg1lg"))))
    (properties `((upstream-name . "fstcore")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (inputs (list zlib))
    (native-inputs (list pkg-config))
    (home-page "https://www.fstpackage.org/fstcore/")
    (synopsis "R bindings to the fstlib library")
    (description
     "The fstlib library provides multithreaded serialization of compressed
data frames using the fst format.  The fst format allows for random access of
stored data and compression with the LZ4 and ZSTD compressors.")
    (license license:mpl2.0)))

(define-public r-fst
  (package
    (name "r-fst")
    (version "0.9.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fst" version))
       (sha256
        (base32
         "0r96inwrr960m7wmc80603bw2vvvwab225bh9dq3lalwhy4yiis4"))))
    (properties `((upstream-name . "fst")))
    (build-system r-build-system)
    (propagated-inputs (list r-fstcore r-rcpp))
    (home-page "http://www.fstpackage.org")
    (synopsis "Fast serialization of data frames")
    (description
     "The fst package for R provides a fast, easy and flexible way to
serialize data frames.  With access speeds of multiple GB/s, fst is
specifically designed to unlock the potential of high speed solid state disks.
Data frames stored in the fst format have full random access, both in column
and rows.  The fst format allows for random access of stored data and
compression with the LZ4 and ZSTD compressors.")
    (license license:agpl3)))

(define-public r-snftool
  (package
    (name "r-snftool")
    (version "2.3.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "SNFtool" version))
              (sha256
               (base32
                "05hz230aq5wbzhknxzr4iqv3nqjhbpf66n6bp1rc5h2jgz2yfbwq"))))
    (properties `((upstream-name . "SNFtool")))
    (build-system r-build-system)
    (propagated-inputs (list r-alluvial r-exposition))
    (home-page "https://cran.r-project.org/package=SNFtool")
    (synopsis "Similarity network fusion")
    (description
     "Similarity Network Fusion takes multiple views of a network and fuses
them together to construct an overall status matrix.  The input to our
algorithm can be feature vectors, pairwise distances, or pairwise
similarities.  The learned status matrix can then be used for retrieval,
clustering, and classification.")
    ;; Any version of the GPL
    (license license:gpl3+)))

(define-public r-snowfall
  (package
   (name "r-snowfall")
   (version "1.84-6.2")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "snowfall" version))
            (sha256
             (base32 "0frmasv04wd47h04zbwaryhiyxllarf3ggpa39p5qicjp6r7lilv"))))
   (build-system r-build-system)
   (propagated-inputs
    (list r-snow))
   (home-page "https://cran.r-project.org/web/packages/snowfall/")
   (synopsis "Easier cluster computing")
   (description "This package is a usability wrapper around snow for easier
development of parallel R programs.  This package offers e.g. extended error
checks, and additional functions.  All functions work in sequential mode, too,
if no cluster is present or wished.  The package is also designed as connector
to the cluster management tool @code{sfCluster}, but can also used without
it.")
   (license license:gpl2+)))

(define-public r-rgexf
  (package
    (name "r-rgexf")
    (version "0.16.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rgexf" version))
       (sha256
        (base32
         "00c2zka1n3k7p1l0mlchr063s6x58p9r3fb64d4wgl4rvsq55q3f"))
       ;; Delete minified JavaScript files
       (snippet
        '(for-each delete-file
                   '("inst/gexf-js/js/jquery-2.0.2.min.js"
                     "inst/gexf-js/js/jquery-ui-1.10.3.custom.min.js"
                     "inst/gexf-js/js/jquery.mousewheel.min.js")))))
    (properties `((upstream-name . "rgexf")))
    (build-system r-build-system)
    (arguments
     `(#:modules ((guix build utils)
                  (guix build r-build-system)
                  (srfi srfi-1)
                  (ice-9 popen))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (invoke "unzip" "-d" "/tmp" (assoc-ref inputs "js-jquery-ui"))
             (with-directory-excursion "inst/gexf-js/js/"
               (call-with-values
                   (lambda ()
                     (unzip2
                      `((,(assoc-ref inputs "js-jquery")
                         "jquery-2.0.2.min.js")
                        ("/tmp/jquery-ui-1.10.3/ui/jquery-ui.js"
                         "jquery-ui-1.10.3.custom.min.js")
                        (,(assoc-ref inputs "js-jquery-mousewheel")
                         "jquery.mousewheel.min.js"))))
                 (lambda (sources targets)
                   (for-each (lambda (source target)
                               (format #true "Processing ~a --> ~a~%"
                                       source target)
                               (invoke "esbuild" source "--minify"
                                       (string-append "--outfile=" target)))
                             sources targets)))))))))
    (propagated-inputs
     (list r-igraph r-servr r-xml))
    (native-inputs
     `(("r-knitr" ,r-knitr)
       ("esbuild" ,esbuild)
       ("unzip" ,unzip)
       ("js-jquery"
        ,(origin
           (method url-fetch)
           (uri "https://code.jquery.com/jquery-2.0.2.js")
           (sha256
            (base32
             "0v818bxpw48gdk8i95qqqij80r9jcgisi2r4ac6xnxca20h0gvfj"))))
       ("js-jquery-ui"
        ,(origin
           (method url-fetch)
           (uri "https://jqueryui.com/resources/download/jquery-ui-1.10.3.zip")
           (sha256
            (base32
             "00xpfy0l69nj2yan4s8k65ldsrlfsjkmyw2dwcg93dc8mv454vxx"))))
       ("js-jquery-mousewheel"
        ,(origin
           (method url-fetch)
           (uri "https://raw.githubusercontent.com/jquery/jquery-mousewheel/\
3.0.6/jquery.mousewheel.js")
           (sha256
            (base32
             "19lk5xy2s47bx8hsa7j6bg012f8yw6d770g230bcnm559kf4nc6v"))))))
    (home-page "https://gvegayon.github.io/rgexf")
    (synopsis "Build, import and export GEXF graph files")
    (description
     "Create, read and write GEXF (Graph Exchange XML Format) graph
files (used in Gephi and others).  It allows the user to easily build/read
graph files including attributes, GEXF visual attributes (such as color, size,
and position), network dynamics (for both edges and nodes) and edge weighting.
Users can build/handle graphs element-by-element or massively through
data-frames, visualize the graph on a web browser through gexf-js (a
JavaScript library) and interact with the igraph package.")
    (license license:expat)))

(define-public r-data-tree
  (package
    (name "r-data-tree")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "data.tree" version))
       (sha256
        (base32
         "0pizmx2312zsym4m42b97q2184bg3hibvbdrblcga05xln84qrs0"))))
    (properties `((upstream-name . "data.tree")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-r6 r-stringi))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/gluc/data.tree")
    (synopsis "General purpose hierarchical data structure")
    (description
     "Create tree structures from hierarchical data, and traverse the tree in
various orders.  Aggregate, cumulate, print, plot, convert to and from
data.frame and more.  This is useful for decision trees, machine learning,
finance, conversion from and to JSON, and many other applications.")
    (license license:gpl2+)))

(define-public r-dtplyr
  (package
    (name "r-dtplyr")
    (version "1.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dtplyr" version))
       (sha256
        (base32
         "1m72ac7461mlvanj1krpmfp2ljl3c2k5nw6zrahc66vhcgz2hngq"))))
    (properties `((upstream-name . "dtplyr")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-crayon
           r-data-table
           r-dplyr
           r-ellipsis
           r-glue
           r-lifecycle
           r-rlang
           r-tibble
           r-tidyselect
           r-vctrs))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/tidyverse/dtplyr")
    (synopsis "Data Table back-end for dplyr")
    (description
     "This package provides a @code{data.table} backend for @code{dplyr}.  The
goal of @code{dtplyr} is to allow you to write @code{dplyr} code that is
automatically translated to the equivalent, but usually much faster,
@code{data.table} code.")
    (license license:expat)))

(define-public r-collapsibletree
  (package
    (name "r-collapsibletree")
    (version "0.1.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "collapsibleTree" version))
       (sha256
        (base32
         "0b65pbp1wnpsrayqi630ds4r98jvcvynnlp6wxdqrnnr9nzw5343"))
       (snippet
        '(begin
           ;; Delete minified JavaScript file
           (delete-file "inst/htmlwidgets/lib/d3-4.10.2/d3.min.js")
           #true))))
    (properties
     `((upstream-name . "collapsibleTree")))
    (build-system r-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst/htmlwidgets/lib/d3-4.10.2/"
               (let ((source (assoc-ref inputs "d3.v4.js"))
                     (target "d3.min.js"))
                 (format #t "Processing ~a --> ~a~%"
                         source target)
                 (invoke "esbuild" source "--minify"
                         (string-append "--outfile=" target)))))))))
    (propagated-inputs
     (list r-data-tree r-htmlwidgets))
    (native-inputs
     `(("esbuild" ,esbuild)
       ("d3.v4.js"
        ,(origin
           (method url-fetch)
           (uri "https://d3js.org/d3.v4.js")
           (sha256
            (base32
             "0y7byf6kcinfz9ac59jxc4v6kppdazmnyqfav0dm4h550fzfqqlg"))))))
    (home-page "https://github.com/AdeelK93/collapsibleTree")
    (synopsis "Interactive collapsible tree diagrams using D3.js")
    (description
     "This is a package for interactive Reingold-Tilford tree diagrams created
using D3.js, where every node can be expanded and collapsed by clicking on it.
Tooltips and color gradients can be mapped to nodes using a numeric column in
the source data frame.")
    (license license:gpl3+)))

(define-public r-rappdirs
  (package
    (name "r-rappdirs")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rappdirs" version))
       (sha256
        (base32
         "1161i3jgjvzjv4p8qbz9r976fnggkcrw3mlj4yd1h2svnijrz5a9"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/rappdirs/")
    (synopsis "Determine where to save data, caches, and logs")
    (description
     "This package provides an easy way to determine which directories on the
user's computer should be used to save data, caches and logs.  It is a port of
Python's @url{https://github.com/ActiveState/appdirs,Appdirs} to R.")
    (license license:expat)))

(define-public r-rastervis
  (package
    (name "r-rastervis")
    (version "0.51.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rasterVis" version))
       (sha256
        (base32
         "0kgg6cm7xjqya2d46w0i1i1wjpkb8f99lyqy7rgwa7l9xmwzj5n1"))))
    (properties `((upstream-name . "rasterVis")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-hexbin
           r-lattice
           r-latticeextra
           r-raster
           r-rcolorbrewer
           r-sp
           r-terra
           r-viridislite
           r-zoo))
    (home-page "https://oscarperpinan.github.io/rastervis/")
    (synopsis "Visualization methods for raster data")
    (description
     "This package provides methods for enhanced visualization and interaction
with raster data.  It implements visualization methods for quantitative data
and categorical data, both for univariate and multivariate rasters.  It also
provides methods to display spatiotemporal rasters, and vector fields.")
    (license license:gpl3)))

(define-public r-rentrez
  (package
    (name "r-rentrez")
    (version "1.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rentrez" version))
       (sha256
        (base32
         "0x1g2f6hvkqqlb39z8m5qxhcvsizddic5i7rpqw0wy77xfbna9gv"))))
    (properties `((upstream-name . "rentrez")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-httr r-jsonlite r-xml))
    (native-inputs
     (list r-knitr))
    (home-page "https://docs.ropensci.org/rentrez/")
    (synopsis "Entrez in R")
    (description
     "This package provides an R interface to the NCBI's EUtils API,
allowing users to search databases like GenBank PubMed, process the results of
those searches and pull data into their R sessions.")
    (license license:expat)))

(define-public r-renv
  (package
    (name "r-renv")
    (version "0.16.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "renv" version))
       (sha256
        (base32
         "05m0idzjmg3wjlip9dy60nydk8dq7hdf3n9vnw6ldgp9f5mkx8gk"))))
    (properties `((upstream-name . "renv")))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr))
    (home-page "https://rstudio.github.io/renv")
    (synopsis "Project environments")
    (description
     "This package provides a dependency management toolkit for R.  Using
renv, you can create and manage project-local R libraries, save the state of
these libraries to a lockfile, and later restore your library as required.
Together, these tools can help make your projects more isolated, portable, and
reproducible.")
    (license license:expat)))

(define-public r-learnr
  (package
    (name "r-learnr")
    (version "0.11.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "learnr" version))
       (sha256
        (base32
         "1p3943hv3ybmbcyfbxidd55dripi0570pf5l51hwz9r3635cx3zs"))))
    (build-system r-build-system)
    (native-inputs (list r-knitr))
    (propagated-inputs
     (list r-checkmate
           r-curl
           r-digest
           r-ellipsis
           r-evaluate
           r-htmltools
           r-htmlwidgets
           r-jsonlite
           r-knitr
           r-lifecycle
           r-markdown
           r-promises
           r-rappdirs
           r-renv
           r-rlang
           r-rmarkdown
           r-rprojroot
           r-shiny
           r-withr))
    (home-page "https://rstudio.github.io/learnr/")
    (synopsis "Interactive tutorials for R")
    (description
     "This package provides tools to create interactive tutorials using R
Markdown.  Use a combination of narrative, figures, videos, exercises, and
quizzes to create self-paced tutorials for learning about R and R packages.")
    (license license:asl2.0)))

(define-public r-analytics
  (package
    (name "r-analytics")
    (version "3.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "analytics" version))
       (sha256
        (base32
         "0js3c8lwj3knccb55nq03cbjlf4w390p9aid2mi5x80l3ayd9in1"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-car
           r-cluster
           r-fractal
           r-lmtest
           r-mass
           r-np
           r-powerplus
           r-robust
           r-trend
           r-tsa
           r-urca
           r-vim))
    (home-page "https://cran.r-project.org/web/packages/analytics/")
    (synopsis "Collection of data analysis tools")
    (description
     "This package is a collection of data analysis tools.  It includes tools
for regression outlier detection in a fitted linear model, stationary
bootstrap using a truncated geometric distribution, a comprehensive test for
weak stationarity, column means by group, weighted biplots, and a heuristic to
obtain a better initial configuration in non-metric MDS.")
    (license license:gpl2)))

(define-public r-here
  (package
    (name "r-here")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "here" version))
       (sha256
        (base32 "0srlr8h8qmr0wrmp7gs4g2ry5dni2hx8n947bik3s3a26f091v88"))))
    (properties `((upstream-name . "here")))
    (build-system r-build-system)
    (propagated-inputs (list r-rprojroot))
    (native-inputs (list r-knitr))
    (home-page "https://here.r-lib.org/")
    (synopsis "Simpler way to find files")
    (description
     "This package lets you construct paths to your project's files.  Use the
@code{here} function as a drop-in replacement for @code{file.path}, it will
always locate the files relative to your project root.")
    (license license:expat)))

(define-public r-reticulate
  (package
    (name "r-reticulate")
    (version "1.26")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "reticulate" version))
       (sha256
        (base32
         "1ibliic3qp597nskak2bfa6iyl721ssgcavwvfaf1c71plilimrz"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'build-reproducibly
           (lambda _
             (setenv "PYTHONHASHSEED" "0")
             (setenv "PYTHONDONTWRITEBYTECODE" "1"))))))
    (inputs (list python))
    (propagated-inputs
     (list r-here
           r-jsonlite
           r-matrix
           r-png
           r-rappdirs
           r-rcpp
           r-rcpptoml
           r-withr))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/rstudio/reticulate")
    (synopsis "R interface to Python")
    (description
     "This package provides an interface from R to Python modules, classes,
and functions.  When calling into Python, R data types are automatically
converted to their equivalent Python types.  When values are returned from
Python to R they are converted back to R types.")
    (license license:asl2.0)))

(define-public r-bibtex
  (package
    (name "r-bibtex")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bibtex" version))
       (sha256
        (base32
         "0rwinwj0kw2872q2whhk03ianl9lcgs6dlhqzm513wj3bgpb90gc"))))
    (build-system r-build-system)
    (propagated-inputs (list r-backports))
    (home-page "https://github.com/romainfrancois/bibtex")
    (synopsis "Bibtex parser")
    (description "This package provides a utility for R to parse a bibtex
file.")
    (license license:gpl2+)))

(define-public r-billboarder
  (package
    (name "r-billboarder")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "billboarder" version))
       (sha256
        (base32 "189ngvg84rcwhrivxskmjv3srhadvzr4p1v8pf11axyv2qn01b0x"))
       (snippet
        '(delete-file "inst/htmlwidgets/lib/billboard/billboard.pkgd.min.js"))))
    (properties `((upstream-name . "billboarder")))
    (build-system r-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst/htmlwidgets/lib/billboard/"
               (let ((source (assoc-ref inputs "js-billboard"))
                     (target "billboard.pkgd.min.js"))
                 (format #true "Processing ~a --> ~a~%"
                         source target)
                 (invoke "esbuild" source "--minify"
                         (string-append "--outfile=" target)))))))))
    (propagated-inputs
     (list r-ggplot2
           r-htmltools
           r-htmlwidgets
           r-jsonlite
           r-magrittr
           r-rlang
           r-scales
           r-shiny))
    (native-inputs
     `(("r-knitr" ,r-knitr)
       ("esbuild" ,esbuild)
       ;; It is not ideal to use this concatenated (but not minified)
       ;; JavaScript file, as the original source is written in TypeScript.
       ;; However, this can still be considered source code as it is readable
       ;; and can be modified.
       ("js-billboard"
        ,(origin
           (method url-fetch)
           (uri "https://unpkg.com/billboard.js@3.2.0/dist/billboard.js")
           (sha256
            (base32
             "1kx5rqmn87pgal2cwmcij2rrnwa0fgcsw6y99m4i0l2sdm0qffv2"))))))
    (home-page "https://github.com/dreamRs/billboarder")
    (synopsis "Create interactive charts with the JavaScript Billboard library")
    (description
     "This package provides an @code{htmlwidgets} interface to billboard.js,
a re-usable easy interface JavaScript chart library, based on D3 v4+.  Chart
types include line charts, scatterplots, bar/lollipop charts,
histogram/density plots, pie/donut charts and gauge charts.  All charts are
interactive, and a proxy method is implemented to smoothly update a chart
without rendering it again in shiny apps.")
    (license license:expat)))

(define-public r-ggseqlogo
  (package
    (name "r-ggseqlogo")
    (version "0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggseqlogo" version))
       (sha256
        (base32
         "13q6kcpxrqxqbji889fx63p0nsi08lk5yymkchig75r5k1d18ky1"))))
    (build-system r-build-system)
    (propagated-inputs (list r-ggplot2))
    (home-page "https://github.com/omarwagih/ggseqlogo")
    (synopsis "ggplot2 extension for drawing genetic sequence logos")
    (description
     "The range of functions provided by this package makes it possible to
draw highly versatile genomic sequence logos.  Features include, but are not
limited to, modifying colour schemes and fonts used to draw the logo,
generating multiple logo plots, and aiding the visualisation with annotations.
Sequence logos can easily be combined with other ggplot2 plots.")
    ;; Unspecified version of the LGPL.
    (license license:lgpl3+)))

(define-public r-ggsci
  (package
    (name "r-ggsci")
    (version "2.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggsci" version))
       (sha256
        (base32
         "0g73x6grbka7ahjh6z23m3wrcifp5rdfdiasbl8lq4sp6rplxwaa"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-scales))
    (home-page "https://nanx.me/ggsci/")
    (synopsis "Scientific journal and sci-fi themed color palettes for ggplot2")
    (description
     "This package provides a collection of ggplot2 color palettes inspired by
plots in scientific journals, data visualization libraries, science fiction
movies, and TV shows.")
    (license license:gpl3)))

(define-public r-ggsignif
  (package
    (name "r-ggsignif")
    (version "0.6.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggsignif" version))
       (sha256
        (base32
         "02mjailzyqkdnzky60dgampw2sq6mnn7s66fk0lhy32s8apm280i"))))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr))
    (propagated-inputs
     (list r-ggplot2))
    (home-page "https://github.com/const-ae/ggsignif")
    (synopsis "Significance brackets for ggplot2")
    (description
     "Enrich your ggplots with group-wise comparisons.  This package provides
an easy way to indicate if two groups are significantly different.  Commonly
this is shown by a bracket on top connecting the groups of interest which
itself is annotated with the level of significance.  The package provides a
single layer that takes the groups for comparison and the test as arguments
and adds the annotation to the plot.")
    (license license:gpl3)))

(define-public r-rstatix
  (package
    (name "r-rstatix")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rstatix" version))
       (sha256
        (base32
         "0330y8iziffqg8j9j5h9zv4qcdyf8ybhmzxrr9fzq9nc6bf1gbm5"))))
    (properties `((upstream-name . "rstatix")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-broom
           r-car
           r-corrplot
           r-dplyr
           r-generics
           r-magrittr
           r-purrr
           r-rlang
           r-tibble
           r-tidyr
           r-tidyselect))
    (home-page "https://rpkgs.datanovia.com/rstatix/")
    (synopsis "Pipe-friendly framework for basic statistical tests")
    (description
     "This package provides a simple and intuitive pipe-friendly framework,
coherent with the @code{tidyverse} design philosophy, for performing basic
statistical tests, including t-test, Wilcoxon test, ANOVA, Kruskal-Wallis and
correlation analyses.  The output of each test is automatically transformed
into a tidy data frame to facilitate visualization.  Additional functions are
available for reshaping, reordering, manipulating and visualizing correlation
matrix.")
    (license license:gpl2)))

(define-public r-ggpubr
  (package
    (name "r-ggpubr")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggpubr" version))
       (sha256
        (base32
         "0x86lmghr25k8w90yrp360dn42dhp5cjvjpdiv2s2gxfn701xcmb"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cowplot
           r-dplyr
           r-ggplot2
           r-ggrepel
           r-ggsci
           r-ggsignif
           r-glue
           r-gridextra
           r-magrittr
           r-polynom
           r-purrr
           r-rlang
           r-scales
           r-rstatix
           r-tibble
           r-tidyr))
    (home-page "http://www.sthda.com/english/rpkgs/ggpubr")
    (synopsis "ggplot2-based publication-ready plots")
    (description
     "The ggplot2 package is an excellent and flexible package for elegant
data visualization in R.  However the default generated plots require some
formatting before we can send them for publication.  The ggpubr package
provides some easy-to-use functions for creating and customizing ggplot2-based
publication-ready plots.")
    (license license:gpl2)))

(define-public r-ellipse
  (package
    (name "r-ellipse")
    (version "0.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ellipse" version))
       (sha256
        (base32
         "0im9d36dixpksms52v6nsb3l0z2c7wc25r9j0f08naj6qc8jpvq2"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/ellipse/")
    (synopsis "Functions for drawing ellipses and ellipse-like confidence regions")
    (description
     "This package contains various routines for drawing ellipses and
ellipse-like confidence regions, implementing the plots described in Murdoch
and Chow (1996), A graphical display of large correlation matrices, The
American Statistician 50, 178-180.  There are also routines implementing the
profile plots described in Bates and Watts (1988), Nonlinear Regression
Analysis and its Applications.")
    (license license:gpl2+)))

(define-public r-flashclust
  (package
    (name "r-flashclust")
    (version "1.01-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "flashClust" version))
       (sha256
        (base32
         "0l4lpz451ll7f7lfxmb7ds24ppzhfg1c3ypvydglcc35p2dq99s8"))))
    (properties `((upstream-name . "flashClust")))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/flashClust/")
    (synopsis "Implementation of optimal hierarchical clustering")
    (description
     "This package provides a fast implementation of hierarchical
clustering.")
    (license license:gpl2+)))

(define-public r-factominer
  (package
    (name "r-factominer")
    (version "2.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "FactoMineR" version))
       (sha256
        (base32
         "0xcg4vjs5v9k28hhxhkfkks7nvpxpp2cvim00kh67f4pq041c9l1"))))
    (properties `((upstream-name . "FactoMineR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-car
           r-cluster
           r-dt
           r-ellipse
           r-emmeans
           r-flashclust
           r-ggplot2
           r-ggrepel
           r-lattice
           r-leaps
           r-mass
           r-multcompview
           r-scatterplot3d))
    (native-inputs
     (list r-knitr))
    (home-page "http://factominer.free.fr")
    (synopsis "Multivariate exploratory data analysis and data mining")
    (description
     "This package provides exploratory data analysis methods to summarize,
visualize and describe datasets.  The main principal component methods are
available, those with the largest potential in terms of applications:
principal component analysis (PCA) when variables are quantitative,
correspondence analysis (CA) and multiple correspondence analysis (MCA) when
variables are categorical, Multiple Factor Analysis when variables are
structured in groups, etc. and hierarchical cluster analysis.")
    (license license:gpl2+)))

(define-public r-factoextra
  (package
    (name "r-factoextra")
    (version "1.0.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "factoextra" version))
       (sha256
        (base32
         "1allvdjhd3pq8xz30b1cymwcik5iaahghrjrlnn54cwkfhfg0kv2"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-abind
           r-cluster
           r-dendextend
           r-factominer
           r-ggplot2
           r-ggpubr
           r-ggrepel
           r-reshape2
           r-tidyr))
    (home-page "http://www.sthda.com/english/rpkgs/factoextra")
    (synopsis "Extract and visualize the results of multivariate data analyses")
    (description
     "This package provides some easy-to-use functions to extract and
visualize the output of multivariate data analyses, including
@code{PCA} (Principal Component Analysis), @code{CA} (Correspondence
Analysis), @code{MCA} (Multiple Correspondence Analysis), @code{FAMD} (Factor
Analysis of Mixed Data), @code{MFA} (Multiple Factor Analysis) and
@code{HMFA} (Hierarchical Multiple Factor Analysis) functions from different R
packages.  It contains also functions for simplifying some clustering analysis
steps and provides ggplot2-based elegant data visualization.")
    (license license:gpl2)))

(define-public r-fansi
  (package
    (name "r-fansi")
    (version "1.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fansi" version))
       (sha256
        (base32
         "0sn0kflgcn2qrrv646pzqylm02cx8l5ws473ppmvla4xihyvi9w6"))))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr)) ; for vignettes
    (home-page "https://github.com/brodieG/fansi")
    (synopsis "ANSI control sequence aware string functions")
    (description
     "This package provides counterparts to R string manipulation functions
that account for the effects of ANSI text formatting control sequences.")
    (license license:gpl2+)))

(define-public r-nbclust
  (package
    (name "r-nbclust")
    (version "3.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "NbClust" version))
       (sha256
        (base32
         "0k5hr4zgx4gp1n62xchgz2zvyl35ba2cnczhhvj8rfbg2n4hx6qs"))))
    (properties `((upstream-name . "NbClust")))
    (build-system r-build-system)
    (home-page "https://sites.google.com/site/malikacharrad/research/nbclust-package")
    (synopsis "Determine the best number of clusters in a data set")
    (description
     "NbClust provides 30 indexes for determining the optimal number of
clusters in a data set and offers the best clustering scheme from different
results to the user.")
    (license license:gpl2)))

(define-public r-hdf5r
  (package
    (name "r-hdf5r")
    (version "1.3.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "hdf5r" version))
       (sha256
        (base32
         "0nr9iywl2z7hrydvq5z61jvx6ls8wg72lzpr875p1jfi7s2052kf"))))
    (build-system r-build-system)
    (inputs
     (list hdf5 zlib))
    (propagated-inputs
     (list r-bit64 r-r6))
    (native-inputs
     (list r-knitr))
    (home-page "https://hhoeflin.github.io/hdf5r")
    (synopsis "Interface to the HDF5 binary data format")
    (description
     "HDF5 is a data model, library and file format for storing and managing
large amounts of data.  This package provides a nearly feature complete,
object oriented wrapper for the HDF5 API using R6 classes.  Additionally,
functionality is added so that HDF5 objects behave very similar to their
corresponding R counterparts.")
    (license license:asl2.0)))

(define-public r-itertools
  (package
    (name "r-itertools")
    (version "0.1-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "itertools" version))
       (sha256
        (base32
         "1ls5biiva10pb1dj3ph4griykb9vam02hkrdmlr5a5wf660hg6xn"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-iterators))
    (home-page "https://cran.r-project.org/web/packages/itertools/")
    (synopsis "Iterator tools")
    (description
     "This package provides various tools for creating iterators, many
patterned after functions in the Python @code{itertools} module, and others
patterned after functions in the snow package.")
    (license license:gpl2)))

(define-public r-itsadug
  (package
    (name "r-itsadug")
    (version "2.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "itsadug" version))
       (sha256
        (base32 "1sdqs279qxr3993hw08xg7b54yq03jw1597cqn6cf24sh9vpw9m1"))))
    (properties `((upstream-name . "itsadug")))
    (build-system r-build-system)
    (propagated-inputs (list r-mgcv r-plotfunctions))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=itsadug")
    (synopsis "Interpreting time series and autocorrelated data using GAMMs")
    (description
     "@dfn{Generalized Additive Mixed Modeling} (GAMM; Lin & Zhang, 1999) as
implemented in the R package @code{mgcv} is a nonlinear regression analysis
which is particularly useful for time course data such as EEG, pupil dilation,
gaze data (eye tracking), and articulography recordings, but also for
behavioral data such as reaction times and response data.  As time course
measures are sensitive to autocorrelation problems, GAMMs implements methods
to reduce the autocorrelation problems.  This package includes functions for
the evaluation of GAMM models (e.g., model comparisons, determining regions of
significance, inspection of autocorrelational structure in residuals) and
interpreting of GAMMs (e.g., visualization of complex interactions, and
contrasts).")
    (license license:gpl2+)))

(define-public r-polynom
  (package
    (name "r-polynom")
    (version "1.4-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "polynom" version))
       (sha256
        (base32
         "0y4j07syjwpnq5w6a1d90z6h1hjzijmm42pq0f8jk2vcn5xxn7mw"))))
    (build-system r-build-system)
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/polynom/")
    (synopsis "Functions for univariate polynomial manipulations")
    (description
     "This package provides a collection of functions to implement a class for
univariate polynomial manipulations.")
    (license license:gpl2)))

(define-public r-pupillometryr
  (package
    (name "r-pupillometryr")
    (version "0.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "PupillometryR" version))
       (sha256
        (base32 "0yk30sgl2qqa6pva649swq523vh446ifmydildycfvfmlm1h4qza"))))
    (properties `((upstream-name . "PupillometryR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-data-table
           r-dplyr
           r-fda
           r-ggplot2
           r-itsadug
           r-lazyeval
           r-mgcv
           r-rlang
           r-signal
           r-tidyr
           r-zoo))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=PupillometryR")
    (synopsis "Unified pipeline for pupillometry data")
    (description
     "This package provides a unified pipeline to clean, prepare, plot, and
run basic analyses on pupillometry experiments.")
    (license license:expat)))

(define-public r-gbrd
  (package
    (name "r-gbrd")
    (version "0.4-11")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gbRd" version))
       (sha256
        (base32
         "06x97rw5i6v6cgjxkfhxnw4dn7lghn5q6ra7ri5ag1x9dkfzcl82"))))
    (properties `((upstream-name . "gbRd")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/gbRd/")
    (synopsis "Utilities for processing Rd objects and files")
    (description
     "This package provides utilities for processing Rd objects and files.
Extract argument descriptions and other parts of the help pages of
functions.")
    (license license:gpl2+)))

(define-public r-rjags
  (package
    (name "r-rjags")
    (version "4-13")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rjags" version))
       (sha256
        (base32
         "0cibz6xhmh86fh7ynmdgpmlchizi57pi6dpslgc2if17a56c6p7q"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-coda))
    (inputs
     (list jags))
    (native-inputs
     (list pkg-config))
    (home-page "http://mcmc-jags.sourceforge.net")
    (synopsis "Bayesian graphical models using MCMC")
    (description
     "This package provides an R interface to the JAGS MCMC library.  JAGS is
Just Another Gibbs Sampler.  It is a program for analysis of Bayesian
hierarchical models using Markov Chain Monte Carlo (MCMC) simulation.")
    (license license:gpl2)))

(define-public r-rbibutils
  (package
    (name "r-rbibutils")
    (version "2.2.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rbibutils" version))
       (sha256
        (base32
         "11pzbqykmn7m9gp5jspfcj6vij865wqf9ry6m3jkihvfj7zhfb5j"))))
    (properties `((upstream-name . "rbibutils")))
    (build-system r-build-system)
    (home-page "https://geobosh.github.io/rbibutils/")
    (synopsis "Convert between bibliography formats")
    (description
     "This package converts between a number of bibliography formats,
including BibTeX, BibLaTeX and Bibentry.  It includes a port of the bibutils
utilities and supports all bibliography formats and character encodings
implemented in bibutils.")
    (license license:gpl2)))

(define-public r-rdpack
  (package
    (name "r-rdpack")
    (version "2.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Rdpack" version))
       (sha256
        (base32
         "109mylzmlncq5a09ayy4g2g0frj1k843lj8j78gvmz1h5g8sslkn"))))
    (properties `((upstream-name . "Rdpack")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rbibutils))
    (home-page "https://github.com/GeoBosh/Rdpack")
    (synopsis "Update and manipulate Rd documentation objects")
    (description
     "This package provides functions for manipulation of R documentation
objects, including functions @code{reprompt()} and @code{ereprompt()} for
updating Rd documentation for functions, methods and classes; it also includes
Rd macros for citations and import of references from bibtex files for use in
Rd files and roxygen2 comments, as well as many functions for manipulation of
references and Rd files.")
    (license license:gpl2+)))

(define-public r-officer
  (package
    (name "r-officer")
    (version "0.4.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "officer" version))
       (sha256
        (base32
         "1h6fcqw4bg644lwr5jggphyxp2d0ycya9q869z8099a50gc6h03f"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-r6 r-uuid r-xml2 r-zip))
    (home-page "https://davidgohel.github.io/officer")
    (synopsis "Manipulation of Word and PowerPoint documents")
    (description
     "This package provides tools to access and manipulate Word and PowerPoint
documents from R.  The package focuses on tabular and graphical reporting from
R; it also provides two functions that let users get document content into
data objects.  A set of functions lets add and remove images, tables and
paragraphs of text in new or existing documents.  When working with PowerPoint
presentations, slides can be added or removed; shapes inside slides can also
be added or removed.  When working with Word documents, a cursor can be used
to help insert or delete content at a specific location in the document.")
    (license license:gpl3)))

(define-public r-profilemodel
  (package
    (name "r-profilemodel")
    (version "0.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "profileModel" version))
       (sha256
        (base32
         "01m5nb8cmq0aq555pxk2a99182si65hhmn68yn9nal2j3zl2bp4i"))))
    (properties `((upstream-name . "profileModel")))
    (build-system r-build-system)
    (home-page "https://github.com/ikosmidis/profileModel")
    (synopsis "Profiling inference functions for various model classes")
    (description
     "This package provides tools that can be used to calculate, evaluate,
plot and use for inference the profiles of *arbitrary* inference functions for
arbitrary @code{glm}-like fitted models with linear predictors.  More information
on the methods that are implemented can be found in Kosmidis (2008)
@url{https://www.r-project.org/doc/Rnews/Rnews_2008-2.pdf}.")
    (license license:gpl2+)))

(define-public r-brglm
  (package
    (name "r-brglm")
    (version "0.7.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "brglm" version))
       (sha256
        (base32
         "08shcz0j1npdn7xkhsvlzs3z4rdwq3g4rk6a4xx8wirqw8n8s2an"))))
    (properties `((upstream-name . "brglm")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-profilemodel))
    (home-page "https://github.com/ikosmidis/brglm")
    (synopsis "Bias reduction in binomial-response generalized linear models")
    (description
     "Fit generalized linear models with binomial responses using either an
adjusted-score approach to bias reduction or maximum penalized likelihood
where penalization is by Jeffreys invariant prior.  These procedures return
estimates with improved frequentist properties (bias, mean squared error) that
are always finite even in cases where the maximum likelihood estimates are
infinite (data separation).  Fitting takes place by fitting generalized linear
models on iteratively updated pseudo-data.  The interface is essentially the
same as @code{glm}.  More flexibility is provided by the fact that custom
pseudo-data representations can be specified and used for model fitting.
Functions are provided for the construction of confidence intervals for the
reduced-bias estimates.")
    (license license:gpl2+)))

(define-public r-entropy
  (package
    (name "r-entropy")
    (version "1.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "entropy" version))
       (sha256
        (base32
         "1f0j8jsn6pzf4gi5g0akixx6x5vc69ci5f4m2vnwp40frvsqjnkg"))))
    (properties `((upstream-name . "entropy")))
    (build-system r-build-system)
    (home-page "https://www.strimmerlab.org/software/entropy/")
    (synopsis "Estimation of entropy, mutual information and related quantities")
    (description
     "This package implements various estimators of entropy, such as the
shrinkage estimator by Hausser and Strimmer, the maximum likelihood and the
Millow-Madow estimator, various Bayesian estimators, and the Chao-Shen
estimator.  It also offers an R interface to the NSB estimator.  Furthermore,
it provides functions for estimating Kullback-Leibler divergence, chi-squared,
mutual information, and chi-squared statistic of independence.  In addition
there are functions for discretizing continuous random variables.")
    (license license:gpl3+)))

(define-public r-acd
  (package
    (name "r-acd")
    (version "1.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ACD" version))
       (sha256
        (base32
         "1a67bi3hklq8nlc50r0qnyr4k7m9kpvijy8sqqpm54by5hsysfd6"))))
    (properties `((upstream-name . "ACD")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/ACD/")
    (synopsis "Categorical data analysis with complete or missing responses")
    (description
     "This package provides tools for categorical data analysis with complete
or missing responses.")
    (license license:gpl2+)))

(define-public r-acdm
  (package
    (name "r-acdm")
    (version "1.0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ACDm" version))
       (sha256
        (base32
         "129ykw0j8z30mr4c01qzx6qy6h4bl87zxvmps0vkh8cqb7akninq"))))
    (properties `((upstream-name . "ACDm")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr r-ggplot2 r-plyr r-rsolnp r-zoo))
    (home-page "https://cran.r-project.org/web/packages/ACDm/")
    (synopsis "Tools for Autoregressive Conditional Duration Models")
    (description
     "ACDm is a package for Autoregressive Conditional Duration (ACD, Engle
and Russell, 1998) models.  It creates trade, price or volume durations from
transactions (tic) data, performs diurnal adjustments, fits various ACD models
and tests them.")
    (license license:gpl2+)))

(define-public r-overlap
  (package
    (name "r-overlap")
    (version "0.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "overlap" version))
       (sha256
        (base32
         "1arxprhz035ab78ks88n6scwnlwmnb97mlac5gsx90ipb6gkgcyk"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/overlap/")
    (synopsis "Estimates of coefficient of overlapping for animal activity patterns")
    (description
     "This package provides functions to fit kernel density functions to data
on temporal activity patterns of animals; estimate coefficients of overlapping
of densities for two species; and calculate bootstrap estimates of confidence
intervals.")
    (license license:gpl3+)))

(define-public r-snakecase
  (package
    (name "r-snakecase")
    (version "0.11.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "snakecase" version))
       (sha256
        (base32
         "1ky1x2cp5rd0ffd9m1fji9sq4z4jsrpxzg30brw8bb4ihfjj114r"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-stringi r-stringr))
    (home-page "https://github.com/Tazinho/snakecase")
    (synopsis "Convert strings into any case")
    (description
     "This package provides a consistent, flexible and easy to use tool to
parse and convert strings into cases like snake or camel among others.")
    (license license:gpl3)))

(define-public r-prediction
  (package
    (name "r-prediction")
    (version "0.3.14")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "prediction" version))
       (sha256
        (base32
         "0awlq5lxfia6m2b91w73rksp93rbwv5gwqb36wbji4rgq41rzbrx"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-data-table))
    (home-page "https://github.com/leeper/prediction")
    (synopsis "Tidy, type-safe prediction methods")
    (description
     "This package provides the @code{prediction()} function, a type-safe
alternative to @code{predict()} that always returns a data frame.  The package
currently supports common model types (e.g., @code{\"lm\"}, @code{\"glm\"})
from the @code{stats} package, as well as numerous other model classes from
other add-on packages.")
    (license license:expat)))

(define-public r-prettygraphs
  (package
    (name "r-prettygraphs")
    (version "2.1.6")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "prettyGraphs" version))
              (sha256
               (base32
                "0yjpwxdy9mkj2k33zvd5klyv4ava46i19yls87n0bvf79y90ikpy"))))
    (properties `((upstream-name . "prettyGraphs")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=prettyGraphs")
    (synopsis "Publication-quality graphics")
    (description
     "This package provides simple and crisp publication-quality graphics for
the ExPosition family of packages.  See An ExPosition of the Singular Value
Decomposition in R (Beaton et al 2014) <doi:10.1016/j.csda.2013.11.006>.")
    (license license:gpl2)))

(define-public r-insight
  (package
    (name "r-insight")
    (version "0.18.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "insight" version))
       (sha256
        (base32
         "1bhwfx75lnjrvn6byl2dn8fzfh2in2msghxwyy9jwpvnxk4c63db"))))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr))
    (home-page "https://easystats.github.io/insight/")
    (synopsis "Easy access to model information for various model objects")
    (description
     "This package provides a tool to provide an easy, intuitive and
consistent access to information contained in various R models, like model
formulas, model terms, information about random effects, data that was used to
fit the model or data from response variables.  The package mainly revolves
around two types of functions: Functions that find (the names of) information,
starting with @code{find_}, and functions that get the underlying data,
starting with @code{get_}.  The package has a consistent syntax and works with
many different model objects, where otherwise functions to access these
information are missing.")
    (license license:gpl3)))

(define-public r-sjlabelled
  (package
    (name "r-sjlabelled")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sjlabelled" version))
       (sha256
        (base32
         "1va86q5wddyvqgdpy8d0an2c7v1qbb4hpn0ai6y1v5v1ff87w73k"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-datawizard r-insight))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/strengejacke/sjlabelled")
    (synopsis "Labelled data utility functions")
    (description
     "This package provides a collection of functions dealing with labelled
data, like reading and writing data between R and other statistical software
packages.  This includes easy ways to get, set or change value and variable
label attributes, to convert labelled vectors into factors or numeric (and
vice versa), or to deal with multiple declared missing values.")
    (license license:gpl3)))

(define-public r-sjmisc
  (package
    (name "r-sjmisc")
    (version "2.8.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sjmisc" version))
       (sha256
        (base32
         "1gzkq95ckxr0vhrzggflzli9hs7zr8c0yym9zn1wf74yrr0mgc3q"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr
           r-insight
           r-magrittr
           r-purrr
           r-rlang
           r-sjlabelled
           r-tidyselect))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/strengejacke/sjmisc")
    (synopsis "Data and variable transformation functions")
    (description
     "This package is a collection of miscellaneous utility functions,
supporting data transformation tasks like recoding, dichotomizing or grouping
variables, setting and replacing missing values.  The data transformation
functions also support labelled data, and all integrate seamlessly into a
tidyverse workflow.")
    (license license:gpl3)))

(define-public r-nortest
  (package
    (name "r-nortest")
    (version "1.0-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "nortest" version))
       (sha256
        (base32
         "17r0wpz72z9312c70nwi1i1kp1v9fm1h6jg7q5cx1mc1h420m1d3"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/nortest/")
    (synopsis "Tests for normality")
    (description
     "This package provides five omnibus tests for testing the composite
hypothesis of normality.")
    (license license:gpl2+)))

(define-public r-moonbook
  (package
    (name "r-moonbook")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "moonBook" version))
       (sha256
        (base32
         "1ml4vvm0mvrprpyi0l50aw38brx18bk2qny4gybmkvlbakalz9bx"))))
    (properties `((upstream-name . "moonBook")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-crayon
           r-magrittr
           r-nortest
           r-sjmisc
           r-stringr
           r-survival))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/cardiomoon/moonBook")
    (synopsis "Functions and datasets for the book by Keon-Woong Moon")
    (description
     "This package provides several analysis-related functions for the book
entitled \"R statistics and graph for medical articles\" (written in Korean),
version 1, by Keon-Woong Moon with Korean demographic data with several plot
functions.")
    (license license:gpl2)))

(define-public r-flextable
  (package
    (name "r-flextable")
    (version "0.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "flextable" version))
       (sha256
        (base32
         "054rkx98qhwp8i4fj9jkv5297sc4g193wfs6b537q62iyqmcjlx3"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-base64enc
           r-data-table
           r-gdtools
           r-htmltools
           r-knitr
           r-officer
           r-rlang
           r-rmarkdown
           r-uuid
           r-xml2))
    (native-inputs
     (list r-knitr))
    (home-page "https://davidgohel.github.io/flextable")
    (synopsis "Functions for tabular reporting")
    (description
     "This package provides tools to create pretty tables for HTML documents
and other formats.  Functions are provided to let users create tables, modify
and format their content.  It extends the @code{officer} package and can be
used within R markdown documents when rendering to HTML and to Word
documents.")
    (license license:gpl3)))

(define-public r-writexl
  (package
    (name "r-writexl")
    (version "1.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "writexl" version))
       (sha256
        (base32
         "1qhf7p14mijdyl5i40gfpzgvdflcs6s8xnwrabsnjxpa17xbamkn"))))
    (build-system r-build-system)
    (inputs (list zlib))
    (home-page "https://github.com/ropensci/writexl")
    (synopsis "Export data frames to xlsx format")
    (description
     "This package provides a data frame to xlsx exporter based on
libxlsxwriter.")
    (license license:bsd-2)))

(define-public r-biasedurn
  (package
    (name "r-biasedurn")
    (version "2.0.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "BiasedUrn" version))
       (sha256
        (base32
         "0mmq8zf52p6y76nqm0fcvvg8bdlrfl12mlfr9fznz9zvm26pypi0"))))
    (properties `((upstream-name . "BiasedUrn")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/BiasedUrn/")
    (synopsis "Biased Urn model distributions")
    (description
     "This package provides statistical models of biased sampling in the form
of univariate and multivariate noncentral hypergeometric distributions,
including Wallenius' noncentral hypergeometric distribution and Fisher's
noncentral hypergeometric distribution (also called extended hypergeometric
distribution).")
    (license license:gpl3)))

(define-public r-goplot
  (package
    (name "r-goplot")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "GOplot" version))
       (sha256
        (base32
         "1y8dv0kbzpr9za91njw0x233vx5d13vqml9hmpddcyi9s6va5nix"))))
    (properties `((upstream-name . "GOplot")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggdendro r-ggplot2 r-gridextra r-rcolorbrewer))
    (home-page "https://github.com/wencke/wencke.github.io")
    (synopsis "Visualization of functional analysis data")
    (description
     "This package provides an implementation of multilayered visualizations
for enhanced graphical representation of functional analysis data.  It
combines and integrates omics data derived from expression and functional
annotation enrichment analyses.  Its plotting functions have been developed
with an hierarchical structure in mind: starting from a general overview to
identify the most enriched categories (modified bar plot, bubble plot) to a
more detailed one displaying different types of relevant information for the
molecules in a given set of categories (circle plot, chord plot, cluster plot,
Venn diagram, heatmap).")
    (license license:gpl2)))

(define-public r-getopt
  (package
    (name "r-getopt")
    (version "1.20.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "getopt" version))
       (sha256
        (base32
         "0zzmzgwl9a4y3s34600vmih22d6y32294f9bvxrnmffnvkgmy7sk"))))
    (build-system r-build-system)
    (home-page "https://github.com/trevorld/getopt")
    (synopsis "Command-line option processor for R")
    (description
     "This package is designed to be used with Rscript to write shebang
scripts that accept short and long options.  Many users will prefer to
use the packages @code{optparse} or @code{argparse} which add extra
features like automatically generated help options and usage texts,
support for default values, positional argument support, etc.")
    (license license:gpl2+)))

(define-public r-findpython
  (package
    (name "r-findpython")
    (version "1.0.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "findpython" version))
       (sha256
        (base32
         "0jf10jpqla90x03kl3k77gnd255zmw9rvr8d724vb17cqawh9yar"))))
    (build-system r-build-system)
    (home-page "https://github.com/trevorld/findpython")
    (synopsis "Functions to find an acceptable Python binary")
    (description
     "This package was designed to find an acceptable Python binary that
matches version and feature constraints.")
    (license license:expat)))

;; This in not the same as "r-argparser"
(define-public r-argparse
  (package
    (name "r-argparse")
    (version "2.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "argparse" version))
       (sha256
        (base32
         "14p57nm0w3siqd473snzhpmnvsgl72x92pdcd64vhy2qg6nzmmra"))))
    (build-system r-build-system)
    (inputs (list python))
    (propagated-inputs
     (list r-findpython r-jsonlite r-r6))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/trevorld/argparse")
    (synopsis "Command line optional and positional argument parser")
    (description
     "This package provides a command line parser to be used with Rscript to
write shebang scripts that gracefully accept positional and optional arguments
and automatically generate usage notices.")
    (license license:gpl2+)))

(define-public r-hash
  (package
    (name "r-hash")
    (version "2.2.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "hash" version))
       (sha256
        (base32
         "17scs675a86c34hjbxmwi8kny4yyv97x3515s449zafj2i0ad8vm"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/hash/")
    (synopsis "Implementation of hash/associated arrays/dictionaries")
    (description
     "This package implements a data structure similar to hashes in Perl and
dictionaries in Python but with a purposefully R flavor.  For objects of
appreciable size, access using hashes outperforms native named lists and
vectors.")
    (license license:gpl2+)))

(define-public r-orddom
  (package
    (name "r-orddom")
    (version "3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "orddom" version))
       (sha256
        (base32
         "165axs15fvwhrp89xd87l81q3h2qjll1vrwcsap645cwvb85nwsh"))))
    (build-system r-build-system)
    (propagated-inputs (list r-psych))
    (home-page "https://cran.r-project.org/web/packages/orddom/")
    (synopsis "Ordinal dominance statistics")
    (description
     "This package provides tools to compute ordinal, statistics and effect
sizes as an alternative to mean comparison: Cliff's delta or success rate
difference (SRD), Vargha and Delaney's A or the Area Under a Receiver
Operating Characteristic Curve (AUC), the discrete type of McGraw & Wong's
Common Language Effect Size (CLES) or Grissom & Kim's Probability of
Superiority (PS), and the Number needed to treat (NNT) effect size.  Moreover,
comparisons to Cohen's d are offered based on Huberty & Lowman's Percentage of
Group (Non-)Overlap considerations.")
    (license license:gpl2)))

(define-public r-deriv
  (package
    (name "r-deriv")
    (version "4.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Deriv" version))
       (sha256
        (base32
         "130g3mv0z9sqs6y23a0a94512iiw05yr6fp378vhdxxbignzbnyv"))))
    (properties `((upstream-name . "Deriv")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/Deriv")
    (synopsis "Symbolic differentiation")
    (description
     "This package provides an R-based solution for symbolic differentiation.
It admits user-defined functions as well as function substitution in arguments
of functions to be differentiated.  Some symbolic simplification is part of
the work.")
    (license license:gpl3+)))

(define-public r-doby
  (package
    (name "r-doby")
    (version "4.6.14")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "doBy" version))
       (sha256
        (base32
         "1ps6r7yxs0a6rpfi2yzrb9j41862za3gdl1aq9vw3j5cmgrk8w1n"))))
    (properties `((upstream-name . "doBy")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-broom
           r-deriv
           r-dplyr
           r-ggplot2
           r-magrittr
           r-mass
           r-matrix
           r-microbenchmark
           r-pbkrtest
           r-tibble))
    (native-inputs
     (list r-knitr))
    (home-page "https://people.math.aau.dk/~sorenh/software/doBy/")
    (synopsis "Groupwise statistics, LSmeans, linear contrasts, and utilities")
    (description
     "This package contains:

@itemize
@item facilities for working with grouped data: @code{do}
  something to data stratified @code{by} some variables.
@item implementations of least-squares means, general linear contrasts, and
@item miscellaneous other utilities.
@end itemize\n")
    (license license:gpl2+)))

(define-public r-refgenome
  (package
    (name "r-refgenome")
    (version "1.7.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "refGenome" version))
       (sha256
        (base32
         "1za89bn3am1zgvm641qi1ab6kaqpll4rb9p9f1sjwvcgqq6065g5"))))
    (properties `((upstream-name . "refGenome")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dbi r-doby r-rsqlite))
    (home-page "https://cran.r-project.org/web/packages/refGenome/")
    (synopsis
     "Gene and splice site annotation using annotation data from Ensembl and UCSC")
    (description
     "This package contains functionality for importing and managing of
downloaded genome annotation data from the Ensembl genome browser (European
Bioinformatics Institute) and from the UCSC genome browser (University of
California, Santa Cruz) and annotation routines for genomic positions and
splice site positions.")
    (license license:gpl2)))

(define-public r-basix
  (package
    (name "r-basix")
    (version "1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "BASIX" version))
       (sha256
        (base32
         "18dkvv1iwskfnlpl6xridcgqpalbbpm2616mvc3hfrc0b26v01id"))))
    (properties `((upstream-name . "BASIX")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/BASIX/")
    (synopsis "Efficient C/C++ toolset for R")
    (description
     "BASIX provides some efficient C/C++ implementations of native R
procedures to speed up calculations in R.")
    (license license:gpl2)))

(define-public r-blockfest
  (package
    (name "r-blockfest")
    (version "2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "BlockFeST" version))
       (sha256
        (base32
         "1fcl3yc1cf09znqbj787d3fd2kl5rp63la7pxawsgmap7nxwkp65"))))
    (properties `((upstream-name . "BlockFeST")))
    (build-system r-build-system)
    (propagated-inputs (list r-basix))
    (home-page "https://cran.r-project.org/web/packages/BlockFeST/")
    (synopsis "Bayesian calculation of region-specific fixation index")
    (description
     "This package provides an R implementation of an extension of the
BayeScan software for codominant markers, adding the option to group
individual SNPs into pre-defined blocks.  A typical application of this new
approach is the identification of genomic regions, genes, or gene sets
containing one or more SNPs that evolved under directional selection.")
    (license license:gpl2)))

(define-public r-proc
  (package
    (name "r-proc")
    (version "1.18.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pROC" version))
       (sha256
        (base32
         "1abvbzdss12n64pp9vlgnn0q3abh0nj4n0a8cinwwvhphjrm9vym"))))
    (properties `((upstream-name . "pROC")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-plyr r-rcpp))
    (home-page "https://web.expasy.org/pROC/")
    (synopsis "Display and analyze ROC curves")
    (description
     "This package provides tools for visualizing, smoothing and comparing
receiver operating characteristic (ROC curves).  The area under the
curve (AUC) can be compared with statistical tests based on U-statistics or
bootstrap.  Confidence intervals can be computed for (p)AUC or ROC curves.")
    (license license:gpl3+)))

(define-public r-rootsolve
  (package
    (name "r-rootsolve")
    (version "1.8.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rootSolve" version))
       (sha256
        (base32
         "182bb727sgqi5f3pzmw8jnn328wdjrgj9lfvg49gv8s22rjd3cxm"))))
    (properties `((upstream-name . "rootSolve")))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/rootSolve/")
    (synopsis "Tools for the analysis of ordinary differential equations")
    (description
     "This package provides routines to find the root of nonlinear functions,
and to perform steady-state and equilibrium analysis of @dfn{ordinary
differential equations} (ODE).  It includes routines that:

@enumerate
@item generate gradient and jacobian matrices (full and banded),
@item find roots of non-linear equations by the Newton-Raphson method,
@item estimate steady-state conditions of a system of (differential) equations
  in full, banded or sparse form, using the Newton-Raphson method, or by
  dynamically running,
@item solve the steady-state conditions for uni- and multicomponent 1-D, 2-D,
  and 3-D partial differential equations, that have been converted to ordinary
  differential equations by numerical differencing (using the method-of-lines
  approach).
@end enumerate\n")
    (license license:gpl2+)))

(define-public r-abcanalysis
  (package
    (name "r-abcanalysis")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ABCanalysis" version))
       (sha256
        (base32 "0wac1ksmnxa36v99ca4hv8k0rsh3igwpcllmlv9wf7i9kgqviqwi"))))
    (properties `((upstream-name . "ABCanalysis")))
    (build-system r-build-system)
    (propagated-inputs (list r-plotrix))
    (home-page "https://www.uni-marburg.de/fb12/arbeitsgruppen/datenbionik/software-en/")
    (synopsis "Computed ABC Analysis")
    (description
     "Multivariate data sets often differ in several factors or derived statistical
parameters, which have to be selected for a valid interpretation.  Basing this
selection on traditional statistical limits leads occasionally to the perception
of losing information from a data set.  This package provides tools to calculate
these limits on the basis of the mathematical properties of the distribution of
the analyzed items.")
    (license license:gpl3)))

(define-public r-slam
  (package
    (name "r-slam")
    (version "0.1-50")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "slam" version))
       (sha256
        (base32 "1ggqcf8l1z2hpi7qy4mg0d2ps48bjjb8z1y1xz6fq162cqrbz6bq"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/slam/")
    (synopsis "Sparse lightweight arrays and matrices")
    (description
     "This package contains data structures and algorithms for sparse arrays and matrices,
based on index arrays and simple triplet representations, respectively.")
    (license license:gpl2)))

(define-public r-manipulatewidget
  (package
    (name "r-manipulatewidget")
    (version "0.11.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "manipulateWidget" version))
       (sha256
        (base32 "1dpgzmiv08afm57yxr017b014lfn9h3pa4w65prk5k3dgn6p4wsv"))))
    (properties
     `((upstream-name . "manipulateWidget")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-base64enc
           r-codetools
           r-htmltools
           r-htmlwidgets
           r-knitr
           r-miniui
           r-shiny
           r-shinyjs
           r-webshot))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/rte-antares-rpackage/manipulateWidget/")
    (synopsis "Add even more interactivity to interactive charts")
    (description
     "This package lets you create in just a few lines of R code a nice user interface to
modify the data or the graphical parameters of one or multiple interactive
charts.  It is useful to quickly explore visually some data or for package
developers to generate user interfaces easy to maintain.")
    (license license:gpl2+)))

(define-public r-a3
  (package
    (name "r-a3")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "A3" version))
       (sha256
        (base32 "017hq9pjsv1h9i7cqk5cfx27as54shlhdsdvr6jkhb8jfkpdb6cw"))))
    (properties `((upstream-name . "A3")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-pbapply r-xtable))
    (home-page "https://cran.r-project.org/web/packages/A3/")
    (synopsis "Error metrics for predictive models")
    (description
     "This package supplies tools for tabulating and analyzing the results of predictive
models.  The methods employed are applicable to virtually any predictive model
and make comparisons between different methodologies straightforward.")
    (license license:gpl2+)))

(define-public r-infotheo
  (package
    (name "r-infotheo")
    (version "1.2.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "infotheo" version))
       (sha256
        (base32
         "1m1979vf8rvq3534mp1hihfadikhxrg3p6ac3hirz96kgb4qxyy0"))))
    (build-system r-build-system)
    (home-page "http://homepage.meyerp.com/software")
    (synopsis "Information-theoretic measures")
    (description
     "This package implements various measures of information theory based on
several entropy estimators.")
    (license license:gpl3+)))

(define-public r-nsprcomp
  (package
    (name "r-nsprcomp")
    (version "0.5.1-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "nsprcomp" version))
       (sha256
        (base32
         "1zlc1ximx96f235c0l8qfs6vbp1kpnbf943wxsfahnnlnxvwi59f"))))
    (properties `((upstream-name . "nsprcomp")))
    (build-system r-build-system)
    (home-page "https://sigg-iten.ch/research/")
    (synopsis "Non-negative and sparse PCA")
    (description
     "This package implements two methods for performing a constrained
principal component analysis (PCA), where non-negativity and/or sparsity
constraints are enforced on the principal axes (PAs).  The function
@code{nsprcomp} computes one principal component (PC) after the other.  Each
PA is optimized such that the corresponding PC has maximum additional variance
not explained by the previous components.  In contrast, the function
@code{nscumcomp} jointly computes all PCs such that the cumulative variance is
maximal.  Both functions have the same interface as the @code{prcomp} function
from the @code{stats} package (plus some extra parameters).")
    (license license:gpl2+)))

(define-public r-cmplot
  (package
    (name "r-cmplot")
    (version "4.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "CMplot" version))
       (sha256
        (base32
         "1icb7r8wj7x9vgcysr9qi28nvgxb9j3dhqw090smpp6d7b39zrjd"))))
    (properties `((upstream-name . "CMplot")))
    (build-system r-build-system)
    (home-page "https://github.com/YinLiLin/CMplot")
    (synopsis "Circle Manhattan plot")
    (description
     "Circle Manhattan Plot is an R package that can lay out genome-wide
association study P-value results in both traditional rectangular patterns,
QQ-plot and novel circular ones.  United in only one bull's eye style plot,
association results from multiple traits can be compared interactively,
thereby to reveal both similarities and differences between signals.
Additional functions include: highlight signals, a group of SNPs, chromosome
visualization and candidate genes around SNPs.")
    (license license:gpl2+)))

(define-public r-precrec
  (package
    (name "r-precrec")
    (version "0.12.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "precrec" version))
       (sha256
        (base32
         "1dfz2rqx2ww2l5r40ahg0qdj3rjrwiwh427mw7j5ynhpcj21j2qm"))))
    (properties `((upstream-name . "precrec")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertthat
           r-data-table
           r-ggplot2
           r-gridextra
           r-rcpp
           r-withr))
    (native-inputs (list r-knitr))
    (home-page "https://evalclass.github.io/precrec/")
    (synopsis "Calculate accurate precision-recall and ROC curves")
    (description
     "This package provides tools for accurate calculations and visualization
of precision-recall and ROC (Receiver Operator Characteristics) curves.")
    (license license:gpl3)))

(define-public r-netrep
  (package
    (name "r-netrep")
    (version "1.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "NetRep" version))
       (sha256
        (base32
         "1swlb2k9bc7whvslxbklz864j9ynvna73hvq5rhv61cv5vy05ksd"))))
    (properties `((upstream-name . "NetRep")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-abind
           r-bh
           r-foreach
           r-rcolorbrewer
           r-rcpp
           r-rcpparmadillo
           r-rhpcblasctl
           r-statmod))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=NetRep")
    (synopsis "Permutation testing network module preservation across datasets")
    (description
     "This package provides functions for assessing the
replication/preservation of a network module's topology across datasets
through permutation testing.")
    (license license:gpl2)))

(define-public r-intergraph
  (package
    (name "r-intergraph")
    (version "2.0-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "intergraph" version))
       (sha256
        (base32
         "18a7xgb2rp0w9jl2rkh8nzyjprrs5w7h2iidvc8c38bzx3qpggkc"))))
    (properties `((upstream-name . "intergraph")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-igraph r-network))
    (native-inputs
     (list r-knitr))
    (home-page "http://mbojan.github.io/intergraph")
    (synopsis "Coercion routines for network data objects")
    (description
     "Functions implemented in this package allow coercing (i.e. convert)
network data between classes provided by other R packages.  Currently
supported classes are those defined in packages @code{network} and
@code{igraph}.")
    (license license:gpl3)))

(define-public r-interp
  (package
    (name "r-interp")
    (version "1.1-3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "interp" version))
              (sha256
               (base32
                "0gzsnlg8f7knb100n6vv6307c3v2jd8f9qzrq62jkc6g71mn0kmp"))))
    (properties `((upstream-name . "interp")))
    (build-system r-build-system)
    (propagated-inputs (list r-deldir r-rcpp r-rcppeigen))
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/package=interp")
    (synopsis "Interpolation methods")
    (description
     "Bivariate data interpolation on regular and irregular grids, either
linear or using splines are the main part of this package.  It is intended to
provide replacement functions for the ACM licensed @code{akima::interp} and
@code{tripack::tri.mesh} functions.")
    (license license:gpl2+)))

(define-public r-abcoptim
  (package
    (name "r-abcoptim")
    (version "0.15.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ABCoptim" version))
       (sha256
        (base32 "1ih0xk88qhsmpvnxf56041wx5sk8as2f4f2gdnpnwdym9mbr9n4b"))))
    (properties `((upstream-name . "ABCoptim")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (home-page "https://github.com/gvegayon/ABCoptim/")
    (synopsis "Optimization of Artificial Bee Colony algorithm")
    (description
     "Artificial Bee Colony (ABC) is one of the most recently defined algorithms by Dervis
Karaboga in 2005, motivated by the intelligent behavior of honey bees.  It is as
simple as Particle Swarm Optimization (PSO) and Differential Evolution (DE)
algorithms, and uses only common control parameters such as colony size and
maximum cycle number.  The @code{r-abcoptim} implements the Artificial bee
colony optimization algorithm @url{http://mf.erciyes.edu.tr/abc/pub/tr06_2005.pdf}.
  This version is a work-in-progress and is written in R code.")
    (license license:expat)))

(define-public r-abcp2
  (package
    (name "r-abcp2")
    (version "1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ABCp2" version))
       (sha256
        (base32 "1s2skkxpzss7c29i8600psgrp0hl46jcrxqrmy2b4db8hc0kcnbx"))))
    (properties `((upstream-name . "ABCp2")))
    (build-system r-build-system)
    (propagated-inputs (list r-mass))
    (home-page "https://cran.r-project.org/web/packages/ABCp2/")
    (synopsis "Approximate Bayesian Computational Model for Estimating P2")
    (description
     "This package tests the goodness of fit of a distribution of offspring to the Normal,
Poisson, and Gamma distribution and estimates the proportional paternity of the
second male (P2) based on the best fit distribution.")
    (license license:gpl2)))

(define-public r-abcrf
  (package
    (name "r-abcrf")
    (version "1.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abcrf" version))
       (sha256
        (base32 "08mh1a6gxp0mfx6qnp1qzcrfx7xp64qj9kad4ziyswfx22ykdsxi"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-doparallel
           r-foreach
           r-mass
           r-matrixstats
           r-ranger
           r-rcpp
           r-rcpparmadillo
           r-readr
           r-stringr))
    (home-page "https://cran.r-project.org/web/packages/abcrf/")
    (synopsis "Approximate bayesian computation via random forests")
    (description
     "This package performs approximate bayesian computation (ABC) model choice and
parameter inference via random forests.  This machine learning tool named random
forests (RF) can conduct selection among the highly complex models covered by
ABC algorithms.")
    (license license:gpl2+)))

(define-public r-abctools
  (package
    (name "r-abctools")
    (version "1.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abctools" version))
       (sha256
        (base32 "07s9dg10i8lsxl73b4n2hynca2fjgb0ykb0dz8c3zv6cgw3cyx97"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-abc r-abind r-hmisc r-plyr))
    (home-page "https://github.com/dennisprangle/abctools/")
    (synopsis "Tools for ABC analyses")
    (description
     "This @code{r-abctools} package provides tools for approximate Bayesian computation
including summary statistic selection and assessing coverage.  This includes
recent dimension reduction algorithms to tune the choice of summary statistics,
and coverage methods to tune the choice of threshold.")
    (license license:gpl2+)))

(define-public r-ggstance
  (package
    (name "r-ggstance")
    (version "0.3.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggstance" version))
       (sha256
        (base32 "0jz9vvnmcc6a38n8nzr458r65sna23bgn5r8mxdhzdlyqibihr7d"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-plyr r-rlang r-withr))
    (home-page "https://cran.r-project.org/web/packages/ggstance/")
    (synopsis "Horizontal and vertical versions of @code{r-ggplot2}")
    (description
     "This package is a @code{r-ggplot2} extension that provides flipped components:
@enumerate
@item horizontal versions of @code{r-ggplot2} stats and @code{r-ggplot2} geoms;
@item vertical versions of @code{r-ggplot2} positions.
@end enumerate")
    (license license:gpl3)))

(define-public r-ggnetwork
  (package
    (name "r-ggnetwork")
    (version "0.5.10")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggnetwork" version))
       (sha256
        (base32
         "0gqdgy5yh700dg0f7xb80hczlnqfisn8l55j7amd1n7fp2x5sr8v"))))
    (properties `((upstream-name . "ggnetwork")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-ggrepel r-igraph r-network r-sna))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/briatte/ggnetwork")
    (synopsis "Geometries to plot networks with ggplot2")
    (description
     "This package provides geometries to plot network objects with the
ggplot2 package.")
    (license license:gpl3)))

(define-public r-cvauc
  (package
    (name "r-cvauc")
    (version "1.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cvAUC" version))
       (sha256
        (base32
         "1m2y50a1yapf1c74km9a4r47ds2z2bfp4wwwkqin7swv9v1s7d28"))))
    (properties `((upstream-name . "cvAUC")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-data-table r-rocr))
    (home-page "https://github.com/ledell/cvAUC")
    (synopsis "Cross-validated area under the ROC curve confidence intervals")
    (description
     "This package contains various tools for working with and evaluating
cross-validated area under the ROC curve (AUC) estimators.  The primary
functions of the package are @code{ci.cvAUC} and @code{ci.pooled.cvAUC}, which
report cross-validated AUC and compute confidence intervals for
cross-validated AUC estimates based on influence curves for i.i.d. and pooled
repeated measures data, respectively.")
    (license license:asl2.0)))

(define-public r-gam
  (package
    (name "r-gam")
    (version "1.20.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gam" version))
       (sha256
        (base32
         "1ndgnaq5fk1w6l6z93w5gd22887yxkykrchbdbx366qmz8v8wcyg"))))
    (properties `((upstream-name . "gam")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-foreach))
    (native-inputs
     (list gfortran))
    (home-page "https://cran.r-project.org/package=gam")
    (synopsis "Generalized additive models")
    (description
     "This package provides functions for fitting and working with generalized
additive models, as described in chapter 7 of \"Statistical Models in
S\" (Chambers and Hastie (eds), 1991), and \"Generalized Additive
Models\" (Hastie and Tibshirani, 1990).")
    (license license:gpl2)))

(define-public r-superlearner
  (package
    (name "r-superlearner")
    (version "2.0-28")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "SuperLearner" version))
       (sha256
        (base32
         "00any24msgflyagy87nznpfjz5g9v15frqda6c679wa8plx26hjz"))))
    (properties `((upstream-name . "SuperLearner")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cvauc r-gam r-nnls))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/ecpolley/SuperLearner")
    (synopsis "Super learner prediction")
    (description
     "This package implements the super learner prediction method and contains
a library of prediction algorithms to be used in the super learner.")
    (license license:gpl3)))

(define-public r-drtmle
  (package
    (name "r-drtmle")
    (version "1.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "drtmle" version))
       (sha256
        (base32
         "12vplpz9bg5444jy29mbdr70hqby073vb3iw76v2csrwy3ws3f21"))))
    (properties `((upstream-name . "drtmle")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-future-apply r-np r-superlearner))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/benkeser/drtmle")
    (synopsis "Doubly-robust nonparametric estimation and inference")
    (description
     "This package implements targeted minimum loss-based estimators of
counterfactual means and causal effects that are doubly-robust with respect
both to consistency and asymptotic normality.")
    (license license:expat)))

(define-public r-dofuture
  (package
    (name "r-dofuture")
    (version "0.12.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "doFuture" version))
       (sha256
        (base32
         "0w07pmzpsfq4kvfc745s1i9b6dfn1df1wrfi4s9ys4ir3g2s8nk1"))))
    (properties `((upstream-name . "doFuture")))
    (build-system r-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (propagated-inputs
     (list r-foreach r-future r-globals r-iterators))
    (native-inputs
     (list r-r-rsp)) ; vignette builder
    (home-page "https://github.com/HenrikBengtsson/doFuture")
    (synopsis "Foreach parallel adapter using the future API")
    (description
     "This package provides a @code{%dopar%} adapter such that any type of
futures can be used as backends for the @code{foreach} framework.")
    (license license:lgpl2.1+)))

(define-public r-superheat
  (package
    (name "r-superheat")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "superheat" version))
       (sha256
        (base32
         "01v8s6px1k5fajlm6py3ksr1i853kwwlky1yryzhy3p1cxhwgg83"))))
    (properties `((upstream-name . "superheat")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr
           r-ggdendro
           r-ggplot2
           r-gtable
           r-magrittr
           r-plyr
           r-scales))
    (home-page "https://cran.r-project.org/package=superheat")
    (synopsis "Graphical tool for exploring complex datasets using heatmaps")
    (description
     "This package provides a system for generating extendable and
customizable heatmaps for exploring complex datasets, including big data and
data with multiple data types.")
    (license license:cc0)))

(define-public r-qualv
  (package
    (name "r-qualv")
    (version "0.3-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "qualV" version))
       (sha256
        (base32
         "0rkjzva2h158d5c631jmjjh7qjibbyisl0503san80rk9fgxl45b"))))
    (properties `((upstream-name . "qualV")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-kernsmooth))
    (home-page "http://qualV.R-Forge.R-Project.org/")
    (synopsis "Qualitative Validation Methods")
    (description
     "This package provides qualitative methods for the validation of dynamic
models.  It contains

@enumerate
@item an orthogonal set of deviance measures for absolute, relative and
  ordinal scale and
@item approaches accounting for time shifts.
@end enumerate

The first approach transforms time to take time delays and speed differences
into account.  The second divides the time series into interval units
according to their main features and finds the @dfn{longest common
subsequence} (LCS) using a dynamic programming algorithm.")
    (license license:gpl2+)))

(define-public r-mosaiccore
  (package
    (name "r-mosaiccore")
    (version "0.9.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mosaicCore" version))
       (sha256
        (base32 "1yns15yxr6215xf9qsxfvl24a9zvh1chw49n31dql7fy1zr1dkmp"))))
    (properties `((upstream-name . "mosaicCore")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr r-mass r-rlang r-tidyr))
    (home-page "https://github.com/ProjectMOSAIC/mosaicCore/")
    (synopsis "Common utilities for mosaic family packages")
    (description
     "Common utilities used in other Mosaic family packages are collected here.")
    (license license:gpl2+)))

(define-public r-labelled
  (package
    (name "r-labelled")
    (version "2.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "labelled" version))
       (sha256
        (base32
         "02n4r4bizsysnlmxpw86w7zkiqi6aill9dq2nmrn43xzrffy54sy"))))
    (properties `((upstream-name . "labelled")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr
           r-haven
           r-lifecycle
           r-rlang
           r-stringr
           r-tidyr
           r-vctrs))
    (native-inputs
     (list r-knitr))
    (home-page "http://larmarange.github.io/labelled/")
    (synopsis "Manipulating labelled data")
    (description
     "This package provides useful functions to deal with the
@code{haven_labelled} and @code{haven_labelled_spss} classes introduced by the
haven package.")
    (license license:gpl3)))

(define-public r-ggformula
  (package
    (name "r-ggformula")
    (version "0.10.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggformula" version))
       (sha256
        (base32 "0xb39gjn6q7va1d1fhvf2dw9428s1q13wasx4y3cz2f0lls1r2wl"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggforce
           r-ggplot2
           r-ggridges
           r-ggstance
           r-labelled
           r-magrittr
           r-mosaiccore
           r-rlang
           r-scales
           r-stringr
           r-tibble))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/ProjectMOSAIC/ggformula/")
    (synopsis "Formula interface for the @code{r-ggplot2}")
    (description
     "The @code{r-ggformula} introduces a family of graphics functions, gf_point(),
gf_density(), and so on, bring the formula interface to ggplot().  This captures
and extends the excellent simplicity of the lattice-graphics formula interface,
while providing the intuitive capabilities of @code{r-ggplot2}.")
    (license license:expat)))

(define-public r-mosaicdata
  (package
    (name "r-mosaicdata")
    (version "0.20.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mosaicData" version))
       (sha256
        (base32 "1s97yq24z7yhzmx0dpspfadpd8hndyhn7aiw0nslwrhvilhwa409"))))
    (properties `((upstream-name . "mosaicData")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/mosaicData/")
    (synopsis "Data sets for project Mosaic")
    (description
     "This package provides data sets from project Mosaic @url{http://mosaic-web.org}
used to teach mathematics, statistics, computation and modeling.")
    (license license:gpl2+)))

(define-public r-raster
  (package
    (name "r-raster")
    (version "3.6-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "raster" version))
       (sha256
        (base32
         "1in3n0hqzcdhibjl3y82nwn6m6wcv4k3l6s2jw57jn32qgvy01lz"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp r-sp r-terra))
    (home-page "https://www.rspatial.org/")
    (synopsis "Geographic data analysis and modeling")
    (description
     "The package implements basic and high-level functions for reading,
writing, manipulating, analyzing and modeling of gridded spatial data.
Processing of very large files is supported.")
    (license license:gpl3+)))

(define-public r-mosaic
  (package
    (name "r-mosaic")
    (version "1.8.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mosaic" version))
       (sha256
        (base32 "12kpkb7vm54na9hjjkvzw6gm5plx0m6i0l9kihz2r30zanfx5jca"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr
           r-ggformula
           r-ggplot2
           r-lattice
           r-mass
           r-matrix
           r-mosaiccore
           r-mosaicdata
           r-purrr
           r-rlang
           r-tidyr))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/ProjectMOSAIC/mosaic/")
    (synopsis "Mathematics, statistics, and computation teaching utilities")
    (description
     "This package contain data sets and utilities from
@url{http://mosaic-web.org, Project MOSAIC} used to teach mathematics,
statistics, computation and modeling.  Project MOSAIC is a community of
educators working to tie together aspects of quantitative work that students
in science, technology, engineering and mathematics will need in their
professional lives, but which are usually taught in isolation, if at all.")
    (license license:gpl2+)))

(define-public r-abd
  (package
    (name "r-abd")
    (version "0.2-8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abd" version))
       (sha256
        (base32 "191gspqzdv573vaw624ri0f5cm6v4j524bjs74d4a1hn3kn6r9b7"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lattice r-mosaic r-nlme))
    (home-page "https://cran.r-project.org/web/packages/abd/")
    (synopsis "Analysis of biological data")
    (description
     "The @code{r-abd} package contains data sets and sample code for the Analysis of
biological data by Michael Whitlock and Dolph Schluter.")
    (license license:gpl2)))

(define-public r-svgui
  (package
    (name "r-svgui")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "svGUI" version))
       (sha256
        (base32 "0ch5gdfk834xj9w3vxpm3x4770fz3nnlyn8b0jsw9f3n2as7g979"))))
    (properties `((upstream-name . "svGUI")))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/SciViews/svGUI/")
    (synopsis "Functions for managing GUI clients in R")
    (description
     "The SciViews @code{svGUI} package eases the management of Graphical User
Interfaces (GUI) in R.  It is independent from any particular GUI widgets.  It
centralizes info about GUI elements currently used, and it dispatches GUI
calls to the particular toolkits in use in function of the context.")
    (license license:gpl2)))

(define-public r-svdialogs
  (package
    (name "r-svdialogs")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "svDialogs" version))
       (sha256
        (base32 "0z3a5glsi0ab43mdk2yvslxyzg12nbqqqc35jvgzj475mpkbgjif"))))
    (properties `((upstream-name . "svDialogs")))
    (build-system r-build-system)
    (inputs
     (list yad zenity))
    (propagated-inputs
     (list r-rstudioapi r-svgui))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/SciViews/svDialogs/")
    (synopsis "Portable dialog boxes")
    (description
     "This package helps to construct standard dialog boxes for your GUI, including
message boxes, input boxes, list, file or directory selection, and others.  In
case R cannot display GUI dialog boxes, a simpler command line version of these
interactive elements is also provided as a fallback solution.")
    (license license:gpl2)))

(define-public r-abe
  (package
    (name "r-abe")
    (version "3.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abe" version))
       (sha256
        (base32
         "1f19h3xzzmjhvwc1rrb8z0rai3ip03y4gdi2gg9bfr5sg2nfklk6"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/abe/")
    (synopsis "Augmented backward elimination")
    (description
     "This package performs augmented backward elimination and checks the
stability of the obtained model.  Augmented backward elimination combines
significance or information based criteria with the change in estimate to
either select the optimal model for prediction purposes or to serve as a tool
to obtain a practically sound, highly interpretable model.")
    (license license:gpl2+)))

(define-public r-abf2
  (package
    (name "r-abf2")
    (version "0.7-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abf2" version))
       (sha256
        (base32 "0d65mc1w4pbiv7xaqzdlw1bfsxf25587rv597hh41vs0j0zlfpxx"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/abf2/")
    (synopsis "Load gap-free axon @code{r-abf2} files")
    (description
     "This package loads electrophysiology data from ABF2 files, as created by
Axon Instruments/Molecular Devices software.  Only files recorded in gap-free
mode are currently supported.")
    (license license:artistic2.0)))

(define-public r-abhgenotyper
  (package
    (name "r-abhgenotyper")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ABHgenotypeR" version))
       (sha256
        (base32 "08cpmnaaxsm5c5bjifnfxdlvg5inrf13biqpcl2yq5zpqjmiki0l"))))
    (properties `((upstream-name . "ABHgenotypeR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-reshape2))
    (home-page "https://github.com/StefanReuscher/ABHgenotypeR/")
    (synopsis "Visualize and manipulate ABH genotypes")
    (description
     "The @code{r-abhgenotyper} package provides simple imputation,
error-correction and plotting capacities for genotype data.  The package is
supposed to serve as an intermediate but independent analysis tool between the
TASSEL GBS pipeline and the @code{r-qtl} package.  It provides functionalities
not found in either TASSEL or @code{r-qtl} in addition to visualization of
genotypes as \"graphical genotypes\".")
    (license license:gpl3)))

(define-public r-furrr
  (package
    (name "r-furrr")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "furrr" version))
       (sha256
        (base32
         "12z4q0fn7asxis17hisi82bvfabl5if1338lmfqmkrwv5rg7748d"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-future
           r-globals
           r-lifecycle
           r-purrr
           r-rlang
           r-vctrs))
    (home-page "https://github.com/DavisVaughan/furrr")
    (synopsis "Apply mapping functions in parallel using futures")
    (description
     "This package provides implementations of the family of @code{map()}
functions from the @code{purrr} package that can be resolved using any
@code{future}-supported backend, e.g. parallel on the local machine or
distributed on a compute cluster.")
    (license license:lgpl2.1+)))

(define-public r-abjutils
  (package
    (name "r-abjutils")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abjutils" version))
       (sha256
        (base32 "0lmf4va8qnzwg698i2h4fcwvd6dhsgdkqsfh41aa3wg1flimhsr7"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr
           r-magrittr
           r-purrr
           r-rlang
           r-rstudioapi
           r-stringi
           r-stringr
           r-tidyr))
    (home-page "https://github.com/abjur/abjutils/")
    (synopsis "Collection of tools for jurimetrical analysis")
    (description
     "This package implements general purpose tools, such as functions for
sampling and basic manipulation of Brazilian lawsuits identification number.
It also implements functions for text cleaning, such as accentuation
removal.")
    (license license:expat)))

(define-public r-abnormality
  (package
    (name "r-abnormality")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abnormality" version))
       (sha256
        (base32 "1fzfskl9akl06nliy8hkv2a0pznpj8pwcypg3gj5r2nzvr3kan9v"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mass r-matrix))
    (home-page "https://cran.r-project.org/web/packages/abnormality/")
    (synopsis "Measure a subject's abnormality with respect to a reference population")
    (description
     "This package contains functions to implement the methodology and
considerations laid out by Marks et al. in the article \"Measuring abnormality
in high dimensional spaces: applications in biomechanical gait analysis\".
Using high-dimensional datasets to measure a subject's overall level of
abnormality as compared to a reference population is often needed in outcomes
research.")
    (license license:expat)))

(define-public r-abodoutlier
  (package
    (name "r-abodoutlier")
    (version "0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abodOutlier" version))
       (sha256
        (base32 "1pvhgxmh23br84r0fbmv7g53z2427birdja96a67vqgz18r3fdvj"))))
    (properties `((upstream-name . "abodOutlier")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cluster))
    (home-page "https://cran.r-project.org/web/packages/abodOutlier/")
    (synopsis "Angle-based outlier detection")
    (description
     "This package performs angle-based outlier detection on a given data
frame.  It offers three methods to process data:
@enumerate
@item full but slow implementation using all the data that has cubic
  complexity;
@item a fully randomized method;
@item a method using k-nearest neighbours.
@end enumerate
These algorithms are well suited for high dimensional data outlier
detection.")
    (license license:expat)))

(define-public r-abps
  (package
    (name "r-abps")
    (version "0.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ABPS" version))
       (sha256
        (base32 "0n3f66nmfi5v94il1mxy026mi84w01ph2aljk60vn3mrz8kwf2ll"))))
    (properties `((upstream-name . "ABPS")))
    (build-system r-build-system)
    (propagated-inputs (list r-kernlab))
    (home-page "https://cran.r-project.org/web/packages/ABPS/")
    (synopsis "Abnormal blood profile score to detect blood doping")
    (description
     "This package offers an implementation of the @dfn{Abnormal blood profile score} (ABPS).
The ABPS is a part of the Athlete biological passport program of the World
anti-doping agency, which combines several blood parameters into a single
score in order to detect blood doping.  The package also contains functions to
calculate other scores used in anti-doping programs, such as the ratio of
hemoglobin to reticulocytes (OFF-score), as well as example data.")
    (license license:gpl2+)))

(define-public r-parmigene
  (package
    (name "r-parmigene")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "parmigene" version))
       (sha256
        (base32
         "067rqxqyzy1fsjj0s1g7af4527whwdhzjzc5b8a8n7683na59ns4"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/parmigene/")
    (synopsis "Mutual information estimation for gene network reconstruction")
    (description
     "This package provides a parallel estimation of the mutual information
based on entropy estimates from k-nearest neighbors distances and algorithms
for the reconstruction of gene regulatory networks.")
    (license license:agpl3+)))

(define-public r-pscl
  (package
    (name "r-pscl")
    (version "1.5.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pscl" version))
       (sha256
        (base32 "0vzf5wazs92bhqhqd66v3vwmbfmnh67gb2466g1xxawim649nk05"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mass))
    (home-page "https://github.com/atahk/pscl/")
    (synopsis "Political science computational laboratory")
    (description
     "The @code{pscl} is an R package providing classes and methods for:
@enumerate
@item Bayesian analysis of roll call data (item-response models);
@item elementary Bayesian statistics;
@item maximum likelihood estimation of zero-inflated and hurdle models for count
data;
@item utility functions.
@end enumerate")
    (license license:gpl2)))

(define-public r-accelmissing
  (package
    (name "r-accelmissing")
    (version "1.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "accelmissing" version))
       (sha256
        (base32 "1nql9inx6azdzi3z4sfm2vdml2mms6krl8wzlf1dn1c97ahn57fy"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mice r-pscl))
    (home-page "https://cran.r-project.org/web/packages/accelmissing/")
    (synopsis "Missing value imputation for accelerometer data")
    (description
     "This package provides a statistical method to impute the missing values in
accelerometer data.  The methodology includes both parametric and
semi-parametric multiple imputations under the zero-inflated Poisson lognormal
model.  It also provides multiple functions to preprocess the accelerometer data
previous to the missing data imputation.  These include detecting the wearing
and the non-wearing time, selecting valid days and subjects, and creating plots.")
    (license license:gpl2+)))

(define-public r-mhsmm
  (package
    (name "r-mhsmm")
    (version "0.4.16")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mhsmm" version))
       (sha256
        (base32 "009dj0zkj1zry7jr9hf4cknb686z50a2l967if64xm0dvjmp7dgs"))))
    (build-system r-build-system)
    (propagated-inputs (list r-mvtnorm))
    (home-page "https://github.com/jaredo/mhsmm/")
    (synopsis "Inference for hidden Markov and semi-Markov models")
    (description
     "The @code{r-mhsmm} package implements estimation and prediction methods for
hidden Markov and semi-Markov models for multiple observation sequences.  Such
techniques are of interest when observed data is thought to be dependent on some
unobserved (or hidden) state.  Also, this package is suitable for equidistant
time series data, with multivariate and/or missing data.  Allows user defined
emission distributions.")
    (license license:gpl2+)))

(define-public r-nleqslv
  (package
    (name "r-nleqslv")
    (version "3.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "nleqslv" version))
       (sha256
        (base32 "0cy65bqkmnnr8v0x1cag84caxwdxyr0yw4w443apxzfxjp7dyiif"))))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/nleqslv/")
    (synopsis "Solve systems of nonlinear equations")
    (description
     "The @code{r-nleqslv} package solves a system of nonlinear equations using a
Broyden or a Newton method with a choice of global strategies such as line
search and trust region.  There are options for using a numerical or user
supplied Jacobian, for specifying a banded numerical Jacobian and for allowing a
singular or ill-conditioned Jacobian.")
    (license license:gpl2+)))

(define-public r-phyclust
  (package
    (name "r-phyclust")
    (version "0.1-32")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "phyclust" version))
              (sha256
               (base32
                "1ga2pzksp97psqbl484fikfnr4bl3bgyys86wb3ya904xxwghy6c"))))
    (properties `((upstream-name . "phyclust")))
    (build-system r-build-system)
    (propagated-inputs (list r-ape))
    (home-page "https://snoweye.github.io/phyclust/")
    (synopsis "Studying phyloclustering and exploring DNA sequence data")
    (description
     "@dfn{Phylogenetic clustering} (phyloclustering) is an evolutionary continuous
time Markov Chain model-based approach to identify population structure from
molecular data without assuming linkage equilibrium.  The package @code{phyclust}
provides a convenient implementation of phyloclustering for DNA and SNP data,
capable of clustering individuals into subpopulations and identifying molecular
sequences representative of those subpopulations.  It is designed in @code{C} for
performance and interfaced with @code{R} for visualization.")
    (license license:gpl2+)))

(define-public r-physicalactivity
  (package
    (name "r-physicalactivity")
    (version "0.2-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "PhysicalActivity" version))
       (sha256
        (base32 "0b27prkv3x6v2afz0y53ccs9scibpc7nj54n0hpd9fgn1wyg4c40"))))
    (properties
     `((upstream-name . "PhysicalActivity")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/PhysicalActivity/")
    (synopsis "Processing accelerometer data for physical activity measurement")
    (description
     "This @code{r-physicalactivity} package provides a function @code{wearingMarking}
for classification of monitored wear and nonwear time intervals in accelerometer
data collected to assess physical activity.  The package also contains functions
for making plots of accelerometer data and obtaining the summary of various
information including daily monitor wear time and the mean monitor wear time
during valid days.  The revised package version 0.2-1 improved the functions
regarding speed, robustness and add better support for time zones and daylight
saving.  In addition, several functions were added:
@enumerate
@item the @code{markDelivery} can classify days for ActiGraph delivery by mail;
@item the @code{markPAI} can categorize physical activity intensity level based
on user-defined cut-points of accelerometer counts.
@end enumerate
  It also supports importing ActiGraph (AGD) files with @code{readActigraph} and
@code{queryActigraph} functions.")
    (license license:gpl3+)))

(define-public r-acc
  (package
    (name "r-acc")
    (version "1.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "acc" version))
       (sha256
        (base32 "1ii2vm47djxbixa75h690q1s2f9m9x6i8nkygik93j6dayr6kr1m"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-circlize
           r-dbi
           r-ggplot2
           r-iterators
           r-mhsmm
           r-nleqslv
           r-physicalactivity
           r-plyr
           r-r-utils
           r-rcpp
           r-rcpparmadillo
           r-rsqlite
           r-zoo))
    (home-page "https://cran.r-project.org/web/packages/acc/")
    (synopsis "Exploring accelerometer data")
    (description
     "This package processes accelerometer data from uni-axial and tri-axial devices
and generates data summaries.  Also, includes functions to plot, analyze, and
simulate accelerometer data.")
    (license license:gpl2+)))

(define-public r-rbenchmark
  (package
    (name "r-rbenchmark")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rbenchmark" version))
       (sha256
        (base32 "010fn3qwnk2k411cbqyvra1d12c3bhhl3spzm8kxffmirj4p2al9"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/rbenchmark/")
    (synopsis "Benchmarking routine for R")
    (description
     "This @code{r-rbenchmark} package is inspired by the Perl module Benchmark,
and is intended to facilitate benchmarking of arbitrary R code.  The library
consists of just one function, benchmark, which is a simple wrapper around
system.time.  Given a specification of the benchmarking process (counts of
replications, evaluation environment) and an arbitrary number of expressions,
benchmark evaluates each of the expressions in the specified environment,
replicating the evaluation as many times as specified, and returning the results
conveniently wrapped into a data frame.")
    (license license:gpl2+)))

(define-public r-mitools
  (package
    (name "r-mitools")
    (version "2.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mitools" version))
       (sha256
        (base32
         "0c2x2n1p53lcw0vx4vmy5j7m2f95i7g2iwbryl89imr99rvz617j"))))
    (build-system r-build-system)
    (propagated-inputs (list r-dbi))
    (home-page "https://cran.r-project.org/web/packages/mitools/")
    (synopsis "Tools for multiple imputation of missing data")
    (description
     "This package provides tools to perform analyses and combine results from
multiple-imputation datasets.")
    (license license:gpl2)))

(define-public r-mixsqp
  (package
   (name "r-mixsqp")
   (version "0.3-43")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "mixsqp" version))
            (sha256
             (base32
              "1qics04w0swyp216d6g8dmsph8q2kpadpacp66h2qih3521js12q"))))
   (properties `((upstream-name . "mixsqp")))
   (build-system r-build-system)
   (propagated-inputs
    (list r-irlba r-rcpp r-rcpparmadillo))
   (native-inputs
    (list r-knitr))
   (home-page "https://github.com/stephenslab/mixsqp")
   (synopsis
    "Sequential quadratic programming for maximum-likelihood estimation")
   (description
    "This package provides an optimization method based on sequential
quadratic programming for maximum likelihood estimation of the mixture
proportions in a finite mixture model where the component densities are
known.  The algorithm is expected to obtain solutions that are at least
as accurate as the state-of-the-art MOSEK interior-point solver, and they
are expected to arrive at solutions more quickly when the number of
samples is large and the number of mixture components is not too large.")
   (license license:expat)))

(define-public r-magick
  (package
    (name "r-magick")
    (version "2.7.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "magick" version))
       (sha256
        (base32
         "0h942bn7wfnzbbgq9hrs75c7igmg5r1c5sad2v0znhza4cp7p1w3"))))
    (build-system r-build-system)
    (inputs
     (list imagemagick zlib))
    (propagated-inputs
     (list r-curl r-magrittr r-rcpp))
    (native-inputs
     (list pkg-config r-knitr))
    (home-page "https://github.com/ropensci/magick")
    (synopsis "Advanced graphics and image-processing in R")
    (description
     "This package provides bindings to ImageMagick, a comprehensive image
processing library.  It supports many common formats (PNG, JPEG, TIFF, PDF,
etc.)  and manipulations (rotate, scale, crop, trim, flip, blur, etc).  All
operations are vectorized via the Magick++ STL meaning they operate either on
a single frame or a series of frames for working with layers, collages, or
animation.  In RStudio, images are automatically previewed when printed to the
console, resulting in an interactive editing environment.")
    (license license:expat)))

(define-public r-survey
  (package
    (name "r-survey")
    (version "4.1-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "survey" version))
       (sha256
        (base32
         "0ljsszybzri531q6xab04r6zq11vchfs7y0snjzk57m3g0b9ms05"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lattice
           r-matrix
           r-minqa
           r-mitools
           r-numderiv
           r-survival))
    (home-page "http://r-survey.r-forge.r-project.org/survey/")
    (synopsis "Analysis of complex survey samples")
    (description
     "This package provides tools for the analysis of complex survey samples.
The provided features include: summary statistics, two-sample tests, rank
tests, generalised linear models, cumulative link models, Cox models,
loglinear models, and general maximum pseudolikelihood estimation for
multistage stratified, cluster-sampled, unequally weighted survey samples;
variances by Taylor series linearisation or replicate weights;
post-stratification, calibration, and raking; two-phase subsampling designs;
graphics; PPS sampling without replacement; principal components, and factor
analysis.")
    ;; Either version of the GPL.
    (license (list license:gpl2 license:gpl3))))

(define-public r-gee
  (package
    (name "r-gee")
    (version "4.13-25")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gee" version))
       (sha256
        (base32
         "128f810h88jxz1wdcmqjj3drb69b0rwx38l682i97rzb5wg8hh71"))))
    (properties `((upstream-name . "gee")))
    (build-system r-build-system)
    (native-inputs
     (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/gee/")
    (synopsis "Generalized estimation equation solver")
    (description
     "This package provides a solver for generalized estimation equations.")
    (license license:gpl2)))

(define-public r-tab
  (package
    (name "r-tab")
    (version "5.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tab" version))
       (sha256
        (base32
         "1kg8c1safi9klkx2mdkmsf5dn9piy4jljwd4ma7g4jz2rwl4jzhv"))))
    (properties `((upstream-name . "tab")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr r-kableextra r-knitr r-mass r-survey))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/tab/")
    (synopsis "Create summary tables for statistical reports")
    (description
     "This package contains functions for creating various types of summary
tables, e.g. comparing characteristics across levels of a categorical variable
and summarizing fitted generalized linear models, generalized estimating
equations, and Cox proportional hazards models.  Functions are available to
handle data from simple random samples as well as complex surveys.")
    (license license:gpl3+)))

(define-public r-dvmisc
  (package
    (name "r-dvmisc")
    (version "1.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dvmisc" version))
       (sha256
        (base32 "01v6sixx0f3nrn6ymfifb3pvd2msfrwm21kmdv38laxq29vc4rsi"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cubature
           r-data-table
           r-dplyr
           r-ggplot2
           r-mass
           r-mvtnorm
           r-pracma
           r-rbenchmark
           r-rcpp
           r-survey
           r-tab))
    (home-page "https://cran.r-project.org/web/packages/dvmisc/")
    (synopsis "Faster computation of common statistics and miscellaneous functions")
    (description
     "This package implements faster versions of base R functions (e.g. mean, standard
deviation, covariance, weighted mean), mostly written in C++, along with
miscellaneous functions for various purposes (e.g. create the histogram with
fitted probability density function or probability mass function curve, create
the body mass index groups, assess the linearity assumption in logistic
regression).")
    (license license:gpl2)))

(define-public r-accelerometry
  (package
    (name "r-accelerometry")
    (version "3.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "accelerometry" version))
       (sha256
        (base32 "13xzrwhr4i1nj9c8vrmfdg2rmrc8n446iihcyxmy99sm99hpzyip"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dvmisc r-rcpp))
    (home-page "https://cran.r-project.org/web/packages/accelerometry/")
    (synopsis "Functions for processing accelerometer data")
    (description
     "This package provides a collection of functions that perform operations on
time-series accelerometer data, such as identify the non-wear time, flag minutes
that are part of an activity bout, and find the maximum 10-minute average count
value.  The functions are generally very flexible, allowing for a variety of
algorithms to be implemented.")
    (license license:gpl3)))

(define-public r-absim
  (package
    (name "r-absim")
    (version "0.2.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "AbSim" version))
       (sha256
        (base32 "16ddjk8b6xw80ch4jis1y751i9561wdxh0gifbf15qiz3vjckq8m"))))
    (properties `((upstream-name . "AbSim")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ape r-powerlaw))
    (home-page "https://cran.r-project.org/web/packages/AbSim/")
    (synopsis "Time resolved simulations of antibody repertoires")
    (description
     "This package provides simulation methods for the evolution of antibody repertoires.
  The heavy and light chain variable region of both human and C57BL/6 mice can
be simulated in a time-dependent fashion.  Both single lineages using one set of
V-, D-, and J-genes or full repertoires can be simulated.  The algorithm begins
with an initial V-D-J recombination event, starting the first phylogenetic tree.
  Upon completion, the main loop of the algorithm begins, with each iteration
representing one simulated time step.  Various mutation events are possible at
each time step, contributing to a diverse final repertoire.")
    (license license:gpl2)))

(define-public r-quic
  (package
    (name "r-quic")
    (version "1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "QUIC" version))
       (sha256
        (base32 "021bp9xbaih60qmss015ycblbv6d1dvb1z89y93zpqqnc2qhpv3c"))))
    (properties `((upstream-name . "QUIC")))
    (build-system r-build-system)
    (home-page "https://www.cs.utexas.edu/users/sustik/QUIC/")
    (synopsis "Regularized sparse inverse covariance matrix estimation")
    (description
     "This package implements the regularized Gaussian maximum likelihood
estimation of the inverse of a covariance matrix.  It uses Newton's method and
coordinate descent to solve the regularized inverse covariance matrix
estimation problem.")
    ;; The project home page states that the release is under GPLv3 or later.
    ;; The CRAN page only says GPL-3.
    (license license:gpl3+)))

(define-public r-abundant
  (package
    (name "r-abundant")
    (version "1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abundant" version))
       (sha256
        (base32 "15m3ngj5aipjg961yy5kvdg9xlfcpliw30dq6gchzxabhnfzcipd"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-glasso))
    (home-page "https://cran.r-project.org/web/packages/abundant/")
    (synopsis "Abundant regression and high-dimensional principal fitted components")
    (description
     "This package provides tools to fit and predict with the high-dimensional
principal fitted components model.  This model is described by Cook, Forzani,
and Rothman (2012) @url{doi:10.1214/11-AOS962}.")
    ;; The DESCRIPTION file states GPL-2, but since it directly depends on a
    ;; GPLv3+ package (QUIC) this likely means GPLv2+.
    (license license:gpl2+)))

(define-public r-ac3net
  (package
    (name "r-ac3net")
    (version "1.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Ac3net" version))
       (sha256
        (base32 "1ns4n0xxz6p34c11bj0k7nzgmyqr9mis2b0g5nfz37dbikndyqyz"))))
    (properties `((upstream-name . "Ac3net")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-data-table))
    (home-page "https://cran.r-project.org/web/packages/Ac3net/")
    (synopsis "Inferring directional conservative causal core gene networks")
    (description "This package infers directional Conservative causal core
(gene) networks (C3NET).  This is a version of the algorithm C3NET with
directional network.")
    (license license:gpl3+)))

(define-public r-aca
  (package
    (name "r-aca")
    (version "1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ACA" version))
       (sha256
        (base32 "1i3hm27nvnkvc39xlh0d1blq8q0q02czmvgi3cazmjx3jvxay0vq"))))
    (properties `((upstream-name . "ACA")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/ACA/")
    (synopsis "Abrupt change-point or aberration detection in point series")
    (description
     "This package offers an interactive function for the detection of breakpoints in
series.")
    ;; Any version of the GPL
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-acceptancesampling
  (package
    (name "r-acceptancesampling")
    (version "1.0-8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "AcceptanceSampling" version))
       (sha256
        (base32 "1ja1g0v8qvf7yj81x37wc6i7fkwpc573756jgvazazi8yf1gm12p"))))
    (properties
     `((upstream-name . "AcceptanceSampling")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/AcceptanceSampling/")
    (synopsis "Creation and evaluation of acceptance sampling plans")
    (description
     "This @code{r-acceptancesampling} provides functionality for creating and evaluating
acceptance sampling plans.  Acceptance sampling is a methodology commonly used
in quality control and improvement.  International standards of acceptance
sampling provide sampling plans for specific circumstances.  The aim of this
package is to provide an easy-to-use interface to visualize single, double or
multiple sampling plans.  In addition, methods have been provided to enable the
user to assess sampling plans against pre-specified levels of performance, as
measured by the probability of acceptance for a given level of quality in the
lot.")
    (license license:gpl3+)))

(define-public r-acclma
  (package
    (name "r-acclma")
    (version "1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ACCLMA" version))
       (sha256
        (base32 "1na27sp18fq12gp6vxgqw1ffsz2yi1d8xvrxbrzx5g1kqxrayy0v"))))
    (properties `((upstream-name . "ACCLMA")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/ACCLMA/")
    (synopsis "ACC & LMA graph plotting")
    (description
     "This package contains a function that imports data from a @acronym{CSV,
Comma-Separated Values} file, or uses manually entered data from the format (x,
y, weight) and plots the appropriate @acronym{ACC, Absolute Concentration
Curve} vs @acronym{LOI, Line of Independence} graph and
@acronym{LMA, @acronym{LOI} Minus @acronym{ACC}} graph.  The main
function is @code{plotLMA} (source file, header) that takes a data set and plots the
appropriate @acronym{LMA} and @acronym{ACC} graphs.  If no source file (a
string) was passed, a manual data entry window is opened.  The header parameter
indicates by TRUE/FALSE (false by default) if the source @acronym{CSV} file has
a header row or not.  The dataset should contain only one independent variable
(x) and one dependent variable (y) and can contain a weight for each
observation.")
    (license license:gpl2)))

(define-public r-aspi
  (package
    (name "r-aspi")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "aspi" version))
       (sha256
        (base32 "0rhvxw243vvdv3hxa6pi343gcjc2cbxq1jzqirl9k1l4i3897l87"))))
    (build-system r-build-system)
    (home-page
     "https://cran.r-project.org/web/packages/aspi/")
    (synopsis
     "Analysis of symmetry of parasitic infections")
    (description
     "This package provides tools for the analysis and visualization of bilateral
      asymmetry in parasitic infections.")
    (license license:gpl3+)))

(define-public r-sandwich
  (package
    (name "r-sandwich")
    (version "3.0-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sandwich" version))
       (sha256
        (base32
         "1d72vwxidsyac9mbyxrm06qds63rzcr82nn4c05466gbajsvcc3f"))
       (modules '((guix build utils)))
       (snippet
        '(with-directory-excursion "inst/doc"
           ;; These files are generated from Rnw files.
           (for-each delete-file
                     (list "sandwich-OOP.pdf"
                           "sandwich-OOP.R"
                           "sandwich-OOP.Rnw"
                           "sandwich-CL.R"
                           "sandwich-CL.Rnw"
                           "sandwich-CL.pdf"
                           "sim-CL.rda"
                           "sim-CL.R"
                           "sandwich.pdf"
                           "sandwich.R"))))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-zoo))
    (home-page "https://cran.r-project.org/web/packages/sandwich/")
    (synopsis "Robust Covariance Matrix Estimators")
    (description
     "This package provides model-robust standard error estimators for
cross-sectional, time series, clustered, panel, and longitudinal data.")
    ;; Either version of the license.
    (license (list license:gpl2 license:gpl3))))

(define-public r-th-data
  (package
    (name "r-th-data")
    (version "1.1-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "TH.data" version))
       (sha256
        (base32
         "0ynxacnz002bjsp2ybql7rdqw4zd14af8r7w44nwbx22n4bapwzd"))))
    (properties `((upstream-name . "TH.data")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mass r-survival))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/TH.data/")
    (synopsis "Shared data sets")
    (description
     "This package contains supporting data sets that are used in other
packages maintained by Torsten Hothorn.")
    (license license:gpl3)))

(define-public r-multcomp
  (package
    (name "r-multcomp")
    (version "1.4-20")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "multcomp" version))
       (sha256
        (base32
         "1z1cqklahnp4qi48r335xlqvw7h7xbjrlpb4pjky9gc987xf92rj"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-codetools r-mvtnorm r-sandwich r-survival r-th-data))
    (home-page "https://cran.r-project.org/web/packages/multcomp/")
    (synopsis "Simultaneous inference in general parametric models")
    (description
     "Simultaneous tests and confidence intervals for general linear
hypotheses in parametric models, including linear, generalized linear, linear
mixed effects, and survival models.  The package includes demos reproducing
analyzes presented in the book \"Multiple Comparisons Using R\" (Bretz,
Hothorn, Westfall, 2010, CRC Press).")
    (license license:gpl2)))

(define-public r-multcompview
  (package
    (name "r-multcompview")
    (version "0.1-8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "multcompView" version))
       (sha256
        (base32 "1rfq9wvvrghq0542ff40wy8vdmsyd8spzz6ihcywcvxdfa8m6g8j"))))
    (properties `((upstream-name . "multcompView")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=multcompView")
    (synopsis "Visualizations of paired comparisons")
    (description
     "Convert a logical vector or a vector of p-values or a correlation,
difference, or distance matrix into a display identifying the pairs for which
the differences were not significantly different.")
    ;; Any version of the GPL.
    (license license:gpl3+)))

(define-public r-emmeans
  (package
    (name "r-emmeans")
    (version "1.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "emmeans" version))
       (sha256
        (base32
         "02fj957f67m1ik9n31h1p726hjnlhwlvd1wz93glfrcagm2p6nbq"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-estimability r-mvtnorm r-numderiv r-xtable))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/rvlenth/emmeans")
    (synopsis "Estimated marginal means, aka least-squares means")
    (description
     "This package provides tools to obtain @dfn{estimated marginal
means} (EMMs) for many linear, generalized linear, and mixed models.  It can
be used to compute contrasts or linear functions of EMMs, trends, and
comparisons of slopes.")
    ;; Either version of the license.
    (license (list license:gpl2 license:gpl3))))

(define-public r-pwr
  (package
    (name "r-pwr")
    (version "1.3-0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pwr" version))
       (sha256
        (base32
         "1kfzy73v3z6ipc3kdfkcjrp4b4p5k54nwk796gqi36srm93hgc2v"))))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/heliosdrm/pwr")
    (synopsis "Basic functions for power analysis")
    (description
     "This package provides power analysis functions along the lines of
Cohen (1988).")
    (license license:gpl3+)))

(define-public r-libcoin
  (package
    (name "r-libcoin")
    (version "1.0-9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "libcoin" version))
       (sha256
        (base32 "1syrcdj5qg5m3zd3dlxgpfklswbalfg42w058dr09hnzqsvx0z9d"))))
    (build-system r-build-system)
    (propagated-inputs (list r-mvtnorm))
    (home-page "https://cran.r-project.org/web/packages/libcoin")
    (synopsis "Linear test statistics for permutation inference")
    (description
     "This package provides basic infrastructure for linear test statistics
and permutation inference in the framework of Strasser and Weber (1999).")
    (license license:gpl2)))

(define-public r-coin
  (package
    (name "r-coin")
    (version "1.4-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "coin" version))
       (sha256
        (base32
         "1cpv7jx840inzg98bkhrb5yscx0gpag6br237r5qpnc2gbrd2ikm"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-libcoin
           r-matrixstats
           r-modeltools
           r-multcomp
           r-mvtnorm
           r-survival))
    (home-page "http://coin.r-forge.r-project.org")
    (synopsis "Conditional inference procedures in a permutation test framework")
    (description
     "This package provides conditional inference procedures for the general
independence problem including two-sample, K-sample (non-parametric ANOVA),
correlation, censored, ordered and multivariate problems.")
    (license license:gpl2)))

(define-public r-bayesplot
  (package
    (name "r-bayesplot")
    (version "1.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bayesplot" version))
       (sha256
        (base32
         "0hqy597ang53phxnl084hak35ffqz9lw9hygax7370gpkjws908a"))))
    (build-system r-build-system)
    (inputs
     (list pandoc))
    (native-inputs
     (list r-knitr))
    (propagated-inputs
     (list r-dplyr
           r-ggplot2
           r-ggridges
           r-glue
           r-posterior
           r-reshape2
           r-rlang
           r-tibble
           r-tidyselect))
    (home-page "https://mc-stan.org/bayesplot")
    (synopsis "Plotting for Bayesian models")
    (description
     "This package provides plotting functions for posterior analysis, model
checking, and MCMC diagnostics.  The package is designed not only to provide
convenient functionality for users, but also a common set of functions that
can be easily used by developers working on a variety of R packages for
Bayesian modeling.")
    (license license:gpl3+)))

(define-public r-tmb
  (package
    (name "r-tmb")
    (version "1.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "TMB" version))
       (sha256
        (base32
         "03zv38gig31ir5gdhgw5j6j8xn1f4y91j2r87fv31gywmg1bhzl9"))))
    (properties `((upstream-name . "TMB")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-matrix r-rcppeigen))
    (home-page "http://tmb-project.org")
    (synopsis "Template model builder: a general random effect tool")
    (description
     "With this tool, a user should be able to quickly implement complex
random effect models through simple C++ templates.  The package combines
@code{CppAD} (C++ automatic differentiation), @code{Eigen} (templated
matrix-vector library) and @code{CHOLMOD} (sparse matrix routines available
from R) to obtain an efficient implementation of the applied Laplace
approximation with exact derivatives.  Key features are: Automatic sparseness
detection, parallelism through BLAS and parallel user templates.")
    (license license:gpl2)))

(define-public r-sjstats
  (package
    (name "r-sjstats")
    (version "0.18.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sjstats" version))
       (sha256
        (base32 "1cv80yjnyh6qihxf57zivihhia20gibr5f03x8aspy6382wnwlka"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bayestestr
           r-broom
           r-dplyr
           r-effectsize
           r-emmeans
           r-insight
           r-lme4
           r-magrittr
           r-mass
           r-modelr
           r-parameters
           r-performance
           r-purrr
           r-rlang
           r-sjlabelled
           r-sjmisc
           r-tidyr))
    (home-page "https://github.com/strengejacke/sjstats")
    (synopsis "Functions for common statistical computations")
    (description
     "This package provides a collection of convenient functions for common
statistical computations, which are not directly provided by R's @code{base}
or @code{stats} packages.  This package aims at providing, first, shortcuts
for statistical measures, which otherwise could only be calculated with
additional effort.  Second, these shortcut functions are generic, and can be
applied not only to vectors, but also to other objects as well.  The focus of
most functions lies on summary statistics or fit measures for regression
models, including generalized linear models, mixed effects models and Bayesian
models.")
    (license license:gpl3)))

(define-public r-glmmtmb
  (package
    (name "r-glmmtmb")
    (version "1.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "glmmTMB" version))
       (sha256
        (base32
         "1ldly6qn8iwqr41ndqlwsdz4v2n36giavsmx33vybn9g7r2fq4m7"))))
    (properties `((upstream-name . "glmmTMB")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lme4
           r-matrix
           r-nlme
           r-numderiv
           r-rcppeigen
           r-tmb))
    (native-inputs
     (list r-knitr r-rmarkdown)) ; for vignettes
    (home-page "https://github.com/glmmTMB")
    (synopsis "Generalized linear mixed models")
    (description
     "Fit linear and generalized linear mixed models with various extensions,
including zero-inflation.  The models are fitted using maximum likelihood
estimation via the Template Model Builder.  Random effects are assumed to be
Gaussian on the scale of the linear predictor and are integrated out using the
Laplace approximation.  Gradients are calculated using automatic
differentiation.")
    (license license:agpl3+)))

(define-public r-bayestestr
  (package
    (name "r-bayestestr")
    (version "0.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bayestestR" version))
       (sha256
        (base32
         "1951zm88qlbmr4ragrzfzgw72awm7mqhh464s6kck0mcx7shas90"))))
    (properties `((upstream-name . "bayestestR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-datawizard r-insight))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/easystats/bayestestR")
    (synopsis "Describe Bayesian models and posterior distributions")
    (description
     "This package provides utilities to understand and describe posterior
distributions and Bayesian models.  It includes point-estimates such as
@dfn{Maximum A Posteriori} (MAP), measures of dispersion such as @dfn{Highest
Density Interval} (HDI), and indices used for null-hypothesis testing (such as
ROPE percentage and pd).")
    (license license:gpl3)))

(define-public r-performance
  (package
    (name "r-performance")
    (version "0.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "performance" version))
       (sha256
        (base32
         "15yx75y17h3l1v7jpp8zbygy64lz7kds5yrgd7wrzw56564d2rhb"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bayestestr r-datawizard r-insight))
    (home-page "https://easystats.github.io/performance/")
    (synopsis "Assessment of regression models performance")
    (description
     "This package provides utilities for computing measures to assess model
quality, which are not directly provided by R's @code{base} or @code{stats}
packages.  These include e.g. measures like r-squared, intraclass correlation
coefficient, root mean squared error or functions to check models for
overdispersion, singularity or zero-inflation and more.  Functions apply to a
large variety of regression models, including generalized linear models, mixed
effects models and Bayesian models.")
    (license license:gpl3)))

(define-public r-ggeffects
  (package
    (name "r-ggeffects")
    (version "1.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggeffects" version))
       (sha256
        (base32
         "1j3l5v00f3xx2pwwfg1z9y31h8qja88nx7lycwj1y55ry5i6drr1"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-insight))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/strengejacke/ggeffects")
    (synopsis "Create tidy data frames of marginal effects for ggplot")
    (description
     "This package provides tools to compute marginal effects from statistical
models and return the result as tidy data frames.  These data frames are ready
to use with the @code{ggplot2} package.  Marginal effects can be calculated
for many different models.  Interaction terms, splines and polynomial terms
are also supported.  The two main functions are @code{ggpredict()} and
@code{ggeffect()}.  There is a generic @code{plot()} method to plot the
results using @code{ggplot2}.")
    (license license:gpl3)))

(define-public r-effectsize
  (package
    (name "r-effectsize")
    (version "0.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "effectsize" version))
       (sha256
        (base32
         "1ibkvvpkd4md73d53823wnwzk3iqi1k4vr99jkyiiybcn6mv5qkc"))))
    (properties `((upstream-name . "effectsize")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bayestestr r-datawizard r-insight r-parameters
           r-performance))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/easystats/effectsize")
    (synopsis "Indices of effect size and standardized parameters")
    (description
     "This package provides utilities to work with indices of effect size and
standardized parameters for a wide variety of models, allowing computation and
conversion of indices such as Cohen's d, r, odds, etc.")
    (license license:gpl3)))

(define-public r-sjplot
  (package
    (name "r-sjplot")
    (version "2.8.11")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sjPlot" version))
       (sha256
        (base32 "05iimcf1if1cx9bmsjb6f5gcq58hjiw10vx7kqd4nqnyhzcvy8yr"))))
    (properties `((upstream-name . "sjPlot")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bayestestr
           r-datawizard
           r-dplyr
           r-effectsize
           r-ggeffects
           r-ggplot2
           r-insight
           r-knitr
           r-mass
           r-parameters
           r-performance
           r-purrr
           r-rlang
           r-scales
           r-sjlabelled
           r-sjmisc
           r-sjstats
           r-tidyr))
    (native-inputs
     (list r-knitr))
    (home-page "https://strengejacke.github.io/sjPlot/")
    (synopsis "Data visualization for statistics in social science")
    (description
     "This package represents a collection of plotting and table output
functions for data visualization.  Results of various statistical
analyses (that are commonly used in social sciences) can be visualized using
this package, including simple and cross tabulated frequencies, histograms,
box plots, (generalized) linear models, mixed effects models, principal
component analysis and correlation matrices, cluster analyses, scatter plots,
stacked scales, effects plots of regression models (including interaction
terms) and much more.  This package supports labelled data.")
    (license license:gpl3)))

(define-public r-ini
  (package
    (name "r-ini")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ini" version))
       (sha256
        (base32
         "04yqij344dwm0xqgara8xia42mlmij3i8711qbb5534w05a1l6bv"))))
    (build-system r-build-system)
    (home-page "https://github.com/dvdscripter/ini")
    (synopsis "Read and write configuration files")
    (description
     "This package provides tools to parse simple @code{.ini} configuration
files to an structured list.  Users can manipulate this resulting list with
@code{lapply()} functions.  This same structured list can be used to write
back to file after modifications.")
    (license license:gpl3)))

(define-public r-gillespiessa2
  (package
    (name "r-gillespiessa2")
    (version "0.2.10")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "GillespieSSA2" version))
       (sha256
        (base32 "0mvsjkjkm27j1y6mfipmxjmki4hpxw0cnmcmls7i5pacnrxc1gcb"))))
    (properties `((upstream-name . "GillespieSSA2")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertthat
           r-dplyr
           r-dynutils
           r-matrix
           r-purrr
           r-rcpp
           r-rcppxptrutils
           r-readr
           r-rlang
           r-stringr
           r-tidyr))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/rcannood/GillespieSSA2")
    (synopsis "Gillespie's stochastic simulation algorithm")
    (description
     "This package provides a fast, scalable, and versatile framework for
simulating large systems with Gillespie's @dfn{Stochastic Simulation
Algorithm} (SSA).  This package is the spiritual successor to the GillespieSSA
package.  Benefits of this package include major speed improvements (>100x),
easier to understand documentation, and many unit tests that try to ensure the
package works as intended.")
    (license license:gpl3+)))

(define-public r-gitcreds
  (package
    (name "r-gitcreds")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gitcreds" version))
       (sha256
        (base32
         "0pf70g4a2kxjcid5rc4ppmgcl3kpjhkszdgz4fqn4l33lp6apij1"))))
    (properties `((upstream-name . "gitcreds")))
    (build-system r-build-system)
    (inputs (list git-minimal))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/r-lib/gitcreds")
    (synopsis "Query git credentials from R")
    (description
     "Query, set, and delete credentials from the git credential store.
Manage GitHub tokens and other git credentials.  This package is to be used by
other packages that need to authenticate to GitHub and/or other git
repositories.")
    (license license:expat)))

(define-public r-gh
  (package
    (name "r-gh")
    (version "1.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gh" version))
       (sha256
        (base32
         "1vqjhqlhvvqq8w2cqbgrkqphj0ga5s6fbl4zhcl3vc6fvsms5bpv"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli r-gitcreds r-httr r-ini r-jsonlite))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/r-lib/gh#readme")
    (synopsis "Access the GitHub API via R")
    (description
     "This package provides a minimal R client to access the GitHub API.")
    (license license:expat)))

(define-public r-fs
  (package
    (name "r-fs")
    (version "1.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fs" version))
       (sha256
        (base32
         "11qr3v0xn65vfhgcxl4l6yv48s4w0w3ldp3anpzc25vd3mwd3jim"))))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr))
    (home-page "https://fs.r-lib.org")
    (synopsis "Cross-platform file system operations based on libuv")
    (description
     "This package provides a cross-platform interface to file system
operations, built on top of the libuv C library.")
    (license license:gpl3)))

(define-public r-clisymbols
  (package
    (name "r-clisymbols")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "clisymbols" version))
       (sha256
        (base32
         "1q7gi2zmykhzas9v8fdnbpdq7pzdcpbhim1yxvd2062l777g4j86"))))
    (build-system r-build-system)
    (home-page "https://github.com/gaborcsardi/clisymbols")
    (synopsis "Unicode symbols at the R prompt")
    (description
     "This package provides a small subset of Unicode symbols, that are useful
when building command line applications.  They fall back to alternatives on
terminals that do not support Unicode.")
    (license license:expat)))

(define-public r-credentials
  (package
    (name "r-credentials")
    (version "1.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "credentials" version))
       (sha256
        (base32
         "1f18j3zrq8c9kah57xwahmmljsjg5qphlgamvx507ynvpq8pryig"))))
    (properties `((upstream-name . "credentials")))
    (build-system r-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'setenv-HOME
           (lambda _
             ;; This is necessary because git looks for $HOME/.gitconfig
             (setenv "HOME" "/tmp"))))))
    (inputs
     (list git-minimal))
    (propagated-inputs
     (list r-askpass r-curl r-jsonlite r-openssl r-sys))
    (native-inputs
     (list r-knitr))
    (home-page "https://docs.ropensci.org/credentials/")
    (synopsis "Tools for managing SSH and Git credentials")
    (description
     "This package assists you in setting up and retrieving of HTTPS and SSH
credentials for use with git and other services.  For HTTPS remotes the
package interfaces the @command{git-credential} utility which @command{git}
uses to store HTTP usernames and passwords.  For SSH remotes this package
provides convenient functions to find or generate appropriate SSH keys.  The
package both helps the user to setup a local git installation, and also
provides a back-end for git/ssh client libraries to authenticate with existing
user credentials.")
    (license license:expat)))

(define-public r-gert
  (package
    (name "r-gert")
    (version "1.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gert" version))
       (sha256
        (base32
         "1p8z5qap06qf680r25y78wgnprzl9ib3xp3kvsw01bh819v1h7bm"))))
    (properties `((upstream-name . "gert")))
    (build-system r-build-system)
    (inputs
     (list libgit2 zlib))
    (propagated-inputs
     (list r-askpass
           r-credentials
           r-openssl
           r-rstudioapi
           r-sys
           r-zip))
    (native-inputs
     (list pkg-config r-knitr))
    (home-page "https://docs.ropensci.org/gert/")
    (synopsis "Simple Git client for R")
    (description
     "This package provides a simple git client for R based on libgit2 with
support for SSH and HTTPS remotes.  All functions in gert use basic R data
types (such as vectors and data-frames) for their arguments and return values.
User credentials are shared with command line git through the
@code{git-credential} store and SSH keys stored on disk or ssh-agent.")
    (license license:expat)))

(define-public r-usethis
  (package
    (name "r-usethis")
    (version "2.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "usethis" version))
       (sha256
        (base32
         "0638dzl4nm4c36990sf2biy74hjr2fzlqzfb98fsqrbhaw3ngp1i"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-clipr
           r-crayon
           r-curl
           r-desc
           r-fs
           r-gert
           r-gh
           r-glue
           r-jsonlite
           r-lifecycle
           r-purrr
           r-rappdirs
           r-rlang
           r-rprojroot
           r-rstudioapi
           r-whisker
           r-withr
           r-yaml))
    (home-page "https://github.com/r-lib/usethis")
    (synopsis "Automate R package and project setup")
    (description
     "This package helps you to automate R package and project setup tasks
that are otherwise performed manually.  This includes setting up unit testing,
test coverage, continuous integration, Git, GitHub integration, licenses,
Rcpp, RStudio projects, and more.")
    (license license:gpl3)))

(define-public r-sessioninfo
  (package
    (name "r-sessioninfo")
    (version "1.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sessioninfo" version))
       (sha256
        (base32
         "1jy7n37qnrb4fgzmn8s8yf7kv29yw27x8zklwf8qdb2kgj2q6qpm"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli))
    (home-page "https://github.com/r-lib/sessioninfo#readme")
    (synopsis "R session information")
    (description
     "This package provides tools to query and print information about the
current R session.  It is similar to @code{utils::sessionInfo()}, but includes
more information about packages, and where they were installed from.")
    (license license:gpl2)))

(define-public r-remotes
  (package
    (name "r-remotes")
    (version "2.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "remotes" version))
       (sha256
        (base32
         "05m5dgv0nba5vhjbdkd8z5lbhpfxgkw31j58am7vz1d44igqgvzj"))))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/r-lib/remotes#readme")
    (synopsis "R package installation from remote repositories")
    (description
     "Download and install R packages stored in GitHub, BitBucket, or plain
subversion or git repositories.  This package is a lightweight replacement of
the @code{install_*} functions in the @code{devtools} package.  Indeed most of
the code was copied over from @code{devtools}.")
    (license license:gpl2+)))

(define-public r-xopen
  (package
    (name "r-xopen")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "xopen" version))
       (sha256
        (base32
         "1vrvgdika1d63dwygynbv2wmd87ll8dji5dy89hj576n8hw601z2"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-processx))
    (home-page "https://github.com/r-lib/xopen#readme")
    (synopsis "Open system files, URLs, anything")
    (description
     "This package provides a cross-platform solution to open files,
directories or URLs with their associated programs.")
    (license license:expat)))

(define-public r-rcmdcheck
  (package
    (name "r-rcmdcheck")
    (version "1.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rcmdcheck" version))
       (sha256
        (base32
         "1l696byn3kjq2xvz4wxybzaj6ink85h4lz3a35v2132ba5yyzm5v"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-callr
           r-cli
           r-curl
           r-desc
           r-digest
           r-pkgbuild
           r-prettyunits
           r-r6
           r-rprojroot
           r-sessioninfo
           r-withr
           r-xopen))
    (home-page "https://github.com/r-Lib/rcmdcheck#readme")
    (synopsis "Run R CMD check from R and capture results")
    (description
     "Run @code{R CMD check} from R programmatically, and capture the results
of the individual checks.")
    (license license:expat)))

(define-public r-rapportools
  (package
    (name "r-rapportools")
    (version "1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rapportools" version))
       (sha256
        (base32
         "0qr86idng12g6hdd764j0wmli700v7rjhw7jdjxj0ka8xm5v7ymm"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mass r-pander r-plyr r-reshape2))
    (home-page "https://cran.r-project.org/web/packages/rapportools/")
    (synopsis "Miscellaneous helper functions with sane defaults for reporting")
    (description
     "This package provides helper functions that act as wrappers to more
advanced statistical methods with the advantage of having sane defaults for
quick reporting.")
    (license license:agpl3+)))

(define-public r-pander
  (package
    (name "r-pander")
    (version "0.6.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pander" version))
       (sha256
        (base32
         "144zkq5w7v6fpzk3x40i0baybbp0y6x2ckh4b9qljryas9mhgp9a"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-digest r-rcpp))
    (native-inputs
     (list r-knitr))
    (home-page "https://rapporter.github.io/pander")
    (synopsis "Render R objects into Pandoc's markdown")
    (description
     "The main aim of the pander R package is to provide a minimal and easy
tool for rendering R objects into Pandoc's markdown.  The package is also
capable of exporting/converting complex Pandoc documents (reports) in various
ways.")
    ;; This package is licensed under either the AGPLv3+ or the very rarely
    ;; used OSL 3.0.
    (license license:agpl3+)))

(define-public r-summarytools
  (package
    (name "r-summarytools")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "summarytools" version))
       (sha256
        (base32
         "0gr95cd1ja8di6s0xghk6w7nj3bh3z4g7j7ixdy7f88q681aixgx"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-base64enc
           r-checkmate
           r-dplyr
           r-htmltools
           r-lubridate
           r-magick
           r-matrixstats
           r-pander
           r-pryr
           r-rapportools
           r-tibble
           r-tidyr))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/dcomtois/summarytools")
    (synopsis "Tools to quickly and neatly summarize data")
    (description
     "This package provides tools for data frame summaries, cross-tabulations,
weight-enabled frequency tables and common univariate statistics in concise
tables available in a variety of formats (plain ASCII, Markdown and HTML).  A
good point-of-entry for exploring data, both for experienced and new R
users.")
    (license license:gpl2)))

(define-public r-lsei
  (package
    (name "r-lsei")
    (version "1.3-0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lsei" version))
       (sha256
        (base32
         "1dka0rigfw4vj809qma2dkiwjb3nw5635ynnba5cm299cn7hb2b2"))))
    (build-system r-build-system)
    (native-inputs
     (list gfortran))
    (home-page "https://www.stat.auckland.ac.nz/~yongwang")
    (synopsis "Solve regression problems under equality/inequality constraints")
    (description
     "It contains functions that solve least squares linear regression
problems under linear equality/inequality constraints.  Functions for solving
quadratic programming problems are also available, which transform such
problems into least squares ones first.")
    (license license:gpl2+)))

(define-public r-npsurv
  (package
    (name "r-npsurv")
    (version "0.5-0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "npsurv" version))
       (sha256
        (base32
         "1ihxhb42cga1hssj2jv4ah0f4hlwsky899ij5261fzh1wxvdp1xw"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lsei))
    (home-page "https://www.stat.auckland.ac.nz/~yongwang")
    (synopsis "Nonparametric survival analysis")
    (description
     "This package contains functions for non-parametric survival analysis of
exact and interval-censored observations.")
    (license license:gpl2+)))

(define-public r-clusteval
  (package
    (name "r-clusteval")
    (version "0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "clusteval" version))
       (sha256
        (base32
         "1ld0bdl4fy8dsfzm3k7a37cyxc6pfc9qs31x4pxd3z5rslghz7rj"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mvtnorm r-rcpp))
    (home-page "https://cran.r-project.org/web/packages/clusteval/")
    (synopsis "Evaluation of clustering algorithms")
    (description
     "This R package provides a suite of tools to evaluate clustering
algorithms, clusterings, and individual clusters.")
    (license license:expat)))

(define-public r-tweedie
  (package
    (name "r-tweedie")
    (version "2.3.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tweedie" version))
       (sha256
        (base32
         "0ghwggdx6d391m7nay9n5li2xjqh3kmw416xx130sy2sxrgp8g4q"))))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/tweedie/")
    (synopsis "Evaluation of Tweedie exponential family models")
    (description
     "Maximum likelihood computations for Tweedie families, including the
series expansion (Dunn and Smyth, 2005; <doi10.1007/s11222-005-4070-y>) and
the Fourier inversion (Dunn and Smyth, 2008; <doi:10.1007/s11222-007-9039-6>),
and related methods.")
    (license license:gpl2+)))

(define-public r-rcppgsl
  (package
    (name "r-rcppgsl")
    (version "0.3.12")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RcppGSL" version))
       (sha256
        (base32 "1qmrwd0zc0kwbhpwxg5s5fxp0pmfh0hwcli8vqh1q41997yyy14m"))))
    (properties `((upstream-name . "RcppGSL")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp gsl))
    (home-page "https://cran.r-project.org/web/packages/RcppGSL/")
    (synopsis "Rcpp integration for GSL vectors and matrices")
    (description
     "The GNU Scientific Library (or GSL) is a collection of numerical
routines for scientific computing.  It is particularly useful for C and C++
programs as it provides a standard C interface to a wide range of mathematical
routines.  There are over 1000 functions in total with an extensive test
suite.  The RcppGSL package provides an easy-to-use interface between GSL data
structures and R using concepts from Rcpp which is itself a package that eases
the interfaces between R and C++.")
    (license license:gpl2+)))

(define-public r-mvabund
  (package
    (name "r-mvabund")
    (version "4.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mvabund" version))
       (sha256
        (base32
         "01kss9dx4an1ir5zs46jypvhj8sdc8wcs00i1223ai09av4lcsgd"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mass r-rcpp r-rcppgsl r-statmod r-tweedie))
    (home-page "https://cran.r-project.org/web/packages/mvabund/")
    (synopsis "Statistical methods for analysing multivariate abundance data")
    (description
     "This package provides a set of tools for displaying, modeling and
analysing multivariate abundance data in community ecology.")
    (license license:lgpl2.1+)))

(define-public r-afex
  (package
    (name "r-afex")
    (version "1.2-0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "afex" version))
       (sha256
        (base32
         "1hii6mx4qbmv4m1hy44sp19xf0r7mc68p767bwc58qrgpawgymwb"))))
    (build-system r-build-system)
    ;; This is needed for the vignette builder
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (propagated-inputs
     (list r-car r-lme4 r-lmertest r-pbkrtest r-reshape2))
    (native-inputs
     (list r-knitr
           r-r-rsp)) ;vignette builder
    (home-page "https://afex.singmann.science/")
    (synopsis "Analysis of factorial experiments")
    (description
     "This package provides convenience functions for analyzing factorial
experiments using ANOVA or mixed models.")
    (license license:gpl2+)))

(define-public r-lmertest
  (package
    (name "r-lmertest")
    (version "3.1-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lmerTest" version))
       (sha256
        (base32
         "1zd8gqjkazhxgpnnr484xwsq30p62fq8592nzyc171zjyplpbaim"))))
    (properties `((upstream-name . "lmerTest")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-lme4 r-mass r-numderiv))
    (home-page "https://github.com/runehaubo/lmerTestR")
    (synopsis "Tests in linear mixed effects models")
    (description
     "This package provides p-values in type I, II or III anova and summary
tables for @code{lmer} model fits via Satterthwaite's degrees of freedom
method.  A Kenward-Roger method is also available via the @code{pbkrtest}
package.  Model selection methods include step, drop1 and anova-like tables
for random effects (ranova).  Methods for Least-Square means (LS-means) and
tests of linear contrasts of fixed effects are also available.")
    (license license:gpl2+)))

(define-public r-r2glmm
  (package
    (name "r-r2glmm")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "r2glmm" version))
       (sha256
        (base32
         "0iim92blpa59vgz97c2pi05yhbjjmaffdbkbmk5kplfb2vmazgiy"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-afex
           r-data-table
           r-dplyr
           r-ggplot2
           r-gridextra
           r-lmertest
           r-mass
           r-matrix
           r-mgcv
           r-pbkrtest))
    (home-page "https://github.com/bcjaeger/r2glmm")
    (synopsis "Compute R squared for mixed (multilevel) models")
    (description
     "This package computes model and semi partial R squared with confidence
limits for the linear and generalized linear mixed model (LMM and GLMM).  The
R squared measure from L. J. Edwards et al. (2008) is extended to the GLMM
using @dfn{penalized quasi-likelihood} (PQL) estimation (see Jaeger et
al. (2016)).")
    (license license:gpl2)))

(define-public r-cmdfun
  (package
    (name "r-cmdfun")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cmdfun" version))
       (sha256
        (base32
         "1pbcq7hi2lcmqnghmy3q2fsk0c9fy5m0637acyzmc096fxbx723j"))))
    (properties `((upstream-name . "cmdfun")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-magrittr
           r-purrr
           r-r-utils
           r-rlang
           r-testthat
           r-usethis))
    (native-inputs
     (list r-knitr))
    (home-page "https://snystrom.github.io/cmdfun/")
    (synopsis "Framework for building interfaces to shell commands")
    (description
     "Writing interfaces to command line software is cumbersome.  The cmdfun
package provides a framework for building function calls to seamlessly
interface with shell commands by allowing lazy evaluation of command line
arguments.  It also provides methods for handling user-specific paths to tool
installs or secrets like API keys.  Its focus is to equally serve package
builders who wish to wrap command line software, and to help analysts stay
inside R when they might usually leave to execute non-R software.")
    (license license:expat)))

(define-public r-rslurm
  (package
    (name "r-rslurm")
    (version "0.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rslurm" version))
       (sha256
        (base32
         "19451icfh7snjbbmpzpr1hrdf52q8ijv0ag1di3y55r2la3jxxcf"))))
    (properties `((upstream-name . "rslurm")))
    (build-system r-build-system)
    (propagated-inputs (list r-whisker))
    (native-inputs (list r-knitr))
    (home-page "http://cyberhelp.sesync.org/rslurm/")
    (synopsis "Submit R calculations to a Slurm cluster")
    (description
     "This package provides functions that simplify submitting R scripts to a
Slurm workload manager, in part by automating the division of embarrassingly
parallel calculations across cluster nodes.")
    (license license:gpl3)))

(define-public r-chk
  (package
    (name "r-chk")
    (version "0.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "chk" version))
       (sha256
        (base32
         "0nw3aj8sbd2x8rsvpglsiavk7kivd330mgx676k46m7lhhj7nmpw"))))
    (properties `((upstream-name . "chk")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lifecycle r-rlang))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/poissonconsulting/chk")
    (synopsis "Check user-supplied function arguments")
    (description
     "This is a package for developers to check user-supplied function
arguments.  It is designed to be simple, fast and customizable.  Error
messages follow the tidyverse style guide.")
    (license license:expat)))

(define-public r-weights
  (package
    (name "r-weights")
    (version "1.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "weights" version))
       (sha256
        (base32
         "1fnchf7f0hyl514bk8sc3l884kg25kb5xm4mc2l28n6hm7l6bgpg"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-gdata r-hmisc r-lme4 r-mice))
    (home-page "https://cran.r-project.org/web/packages/weights/")
    (synopsis "Weighting and weighted statistics")
    (description "This package Provides a variety of functions for producing
simple weighted statistics, such as weighted Pearson's correlations, partial
correlations, Chi-Squared statistics, histograms, and t-tests.  Also now
includes some software for quickly recoding survey data and plotting point
estimates from interaction terms in regressions (and multiply imputed
regressions).  NOTE: Weighted partial correlation calculations pulled to
address a bug.")
  (license license:gpl2+)))

(define-public r-rcppalgos
  (package
    (name "r-rcppalgos")
    (version "2.6.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "RcppAlgos" version))
              (sha256
               (base32
                "11dvh0ba3chsqf3vw8g9h1754arxgwqryayavx3n6vm5daz2krqa"))))
    (properties `((upstream-name . "RcppAlgos")))
    (build-system r-build-system)
    (inputs (list gmp))
    (propagated-inputs (list r-cpp11 r-gmp))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/jwood000/RcppAlgos")
    (synopsis
     "High performance tools for combinatorics and computational mathematics")
    (description
     "This package provides optimized functions and flexible combinatorial
iterators implemented in C++ for solving problems in combinatorics and
computational mathematics.  It utilizes the @code{RMatrix} class from
@code{RcppParallel} for thread safety.  There are combination/permutation
functions with constraint parameters that allow for generation of all results
of a vector meeting specific criteria.  It is capable of generating specific
combinations/permutations which sets up nicely for parallelization as well as
random sampling.  Gmp support permits exploration where the total number of
results is large.  Additionally, there are several high performance number
theoretic functions that are useful for problems common in computational
mathematics.")
    (license license:gpl2+)))

(define-public r-rcppannoy
  (package
    (name "r-rcppannoy")
    (version "0.0.20")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RcppAnnoy" version))
       (sha256
        (base32
         "11fgxbx3w36937h22v9pqx0nk5vpxp3hybj7k1b0lk8mj7hcginw"))))
    (properties `((upstream-name . "RcppAnnoy")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp))
    (home-page "https://cran.r-project.org/web/packages/RcppAnnoy/")
    (synopsis "Rcpp bindings for Annoy, a library for Approximate Nearest Neighbors")
    (description
     "Annoy is a small C++ library for Approximate Nearest Neighbors written
for efficient memory usage as well an ability to load from and save to disk.
This package provides an R interface.")
    ;; Annoy is released under ASL 2.0, but this wrapper is released under
    ;; GPLv2+.
    (license (list license:gpl2+ license:asl2.0))))

(define-public r-rcpphnsw
  (package
    (name "r-rcpphnsw")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RcppHNSW" version))
       (sha256
        (base32
         "0x3w14cz6hkrl8hi6217j0dl65l3yphbzka1dmsvgp3p9waq402g"))))
    (properties `((upstream-name . "RcppHNSW")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (home-page "https://cran.r-project.org/web/packages/RcppHNSW/")
    (synopsis "Rcpp bindings for hnswlib, a library for approximate nearest neighbors")
    (description
     "Hnswlib is a C++ library for approximate nearest neighbors.  This
package provides a minimal R interface by relying on the Rcpp package.")
    ;; hnswlib is released under Version 2.0 of the Apache License.
    (license (list license:gpl3 license:asl2.0))))

(define-public r-rcppparallel
  (package
    (name "r-rcppparallel")
    (version "5.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RcppParallel" version))
       (sha256
        (base32
         "1sn211ajlb1p12sglxqns175rg078yvww268m8cp0vvd7cmk55k3"))
       (modules '((guix build utils)))
       (snippet
        '(delete-file-recursively "src/tbb/"))))
    (properties `((upstream-name . "RcppParallel")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'use-system-tbb
           (lambda* (#:key inputs #:allow-other-keys)
             (setenv "TBB_ROOT" (assoc-ref inputs "tbb")))))))
    (inputs (list tbb-2020))
    (home-page "https://rcppcore.github.io/RcppParallel/")
    (synopsis "Parallel programming tools for Rcpp")
    (description
     "This package provides high level functions for parallel programming with
Rcpp.  For example, the @code{parallelFor()} function can be used to convert
the work of a standard serial @code{for} loop into a parallel one and the
@code{parallelReduce()} function can be used for accumulating aggregates or
other values.")
    (license license:gpl2)))

(define-public r-ncdf4
  (package
    (name "r-ncdf4")
    (version "1.19")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ncdf4" version))
       (sha256
        (base32
         "0qzvin2fjzcb7h2knlnw14s6043pwi1nm7yf6p27ax7w269173fb"))))
    (build-system r-build-system)
    (inputs
     (list netcdf zlib))
    (home-page "https://cran.r-project.org/web/packages/ncdf4/index.html")
    (synopsis "R interface to Unidata netCDF format data files")
    (description
     "This package provides a high-level R interface to data files written
using Unidata's netCDF library (version 4 or earlier), which are binary data
files that are portable across platforms and include metadata information in
addition to the data sets.  Using this package, netCDF files can be opened and
data sets read in easily.  It is also easy to create new netCDF dimensions,
variables, and files, in either version 3 or 4 format, and manipulate existing
netCDF files.")
    (license license:gpl3+)))

(define-public r-biocmanager
  (package
    (name "r-biocmanager")
    (version "1.30.19")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "BiocManager" version))
       (sha256
        (base32 "1qhq1k1sr23bi2kmnd99mjs3ns0c2p20pmr2iq8a6bxbb0fap5v8"))))
    (properties `((upstream-name . "BiocManager")))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/BiocManager/")
    (synopsis "Access the Bioconductor project package repository")
    (description
     "This package provides a convenient tool to install and update
Bioconductor packages.")
    (license license:artistic2.0)))

(define-public r-rgl
  (package
    (name "r-rgl")
    (version "0.110.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rgl" version))
       (sha256
        (base32
         "0v9lrsdmhw0wqfbrrjirgppd40cn00ignq3rg2jn3q8ak70ih4fs"))))
    (build-system r-build-system)
    (native-inputs
     (list pkg-config
           r-knitr
           r-rmarkdown)) ;for vignettes
    (inputs
     (list freetype
           libpng
           glu
           libx11
           pandoc
           zlib))
    (propagated-inputs
     (list r-base64enc
           r-htmltools
           r-htmlwidgets
           r-jsonlite
           r-knitr
           r-magrittr
           r-mime
           r-r6))
    (home-page "https://r-forge.r-project.org/projects/rgl/")
    (synopsis "3D visualization using OpenGL")
    (description
     "This package provides medium to high level functions for 3D interactive graphics,
including functions modelled on base graphics (@code{plot3d()}, etc.) as well
as functions for constructing representations of geometric
objects (@code{cube3d()}, etc.).  Output may be on screen using OpenGL, or to
various standard 3D file formats including WebGL, PLY, OBJ, STL as well as 2D
image formats, including PNG, Postscript, SVG, PGF.")
    ;; Any version of the GPL.
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-multicool
  (package
    (name "r-multicool")
    (version "0.1-12")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "multicool" version))
       (sha256
        (base32
         "0djacq0irfqz4nlnx238kja73yvr1n5qybbfyl6bw1n6qgcjhza8"))))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (home-page "https://cran.r-project.org/web/packages/multicool/")
    (synopsis "Permutations of multisets in cool-lex order")
    (description
     "This package provides a set of tools to permute multisets without loops
or hash tables and to generate integer partitions.  Cool-lex order is similar
to colexicographical order.")
    (license license:gpl2)))

(define-public r-misc3d
  (package
    (name "r-misc3d")
    (version "0.9-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "misc3d" version))
       (sha256
        (base32
         "0r9x57s63kx9f6dgam2nhbziq8nrs9wd8pk7g76hds2kw46vnyx0"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/misc3d/")
    (synopsis "Miscellaneous 3D Plots")
    (description
     "This package provides a collection of miscellaneous 3d plots, including
isosurfaces.")
    ;; Any version of the GPL.
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-ks
  (package
    (name "r-ks")
    (version "1.13.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ks" version))
       (sha256
        (base32 "05bqrjkbx2kn5aax0hy3xd6pf7nxka9bm1sp8ll1cc2gf1nx1i6i"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-fnn
           r-kernlab
           r-kernsmooth
           r-matrix
           r-mclust
           r-mgcv
           r-multicool
           r-mvtnorm
           r-plot3d
           r-pracma))
    (home-page "https://www.mvstat.net/tduong/")
    (synopsis "Kernel smoothing")
    (description
     "This package provides kernel smoothers for univariate and multivariate
data, including density functions, density derivatives, cumulative
distributions, modal clustering, discriminant analysis, and two-sample
hypothesis testing.")
    ;; Either version of the GPL.
    (license (list license:gpl2 license:gpl3))))

(define-public r-feature
  (package
    (name "r-feature")
    (version "1.2.15")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "feature" version))
       (sha256
        (base32
         "0yzn1w1sasilcp8v0pcjnxjv9l6lspkskqi412i6h040gqmjjf6y"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ks r-plot3d))
    (native-inputs
     (list r-knitr))
    (home-page "https://www.mvstat.net/tduong/")
    (synopsis "Inferential feature significance for kernel density estimation")
    (description
     "The feature package contains functions to display and compute kernel
density estimates, significant gradient and significant curvature regions.
Significant gradient and/or curvature regions often correspond to significant
features (e.g. local modes).")
    ;; Either version of the GPL.
    (license (list license:gpl2 license:gpl3))))

(define-public r-arm
  (package
    (name "r-arm")
    (version "1.13-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "arm" version))
       (sha256
        (base32
         "0dz9dnsky77da2mc198dr3600kz9vk75z1iihjarnsdrq68a4bf0"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-abind
           r-coda
           r-lme4
           r-mass
           r-matrix
           r-nlme))
    (home-page "https://cran.r-project.org/web/packages/arm/")
    (synopsis "Data analysis using regression and multilevel/hierarchical models")
    (description
     "This package provides functions to accompany A. Gelman and J. Hill,
Data Analysis Using Regression and Multilevel/Hierarchical Models, Cambridge
University Press, 2007.")
    (license license:gpl3+)))

(define-public r-circular
  (package
    (name "r-circular")
    (version "0.4-95")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "circular" version))
       (sha256
        (base32
         "1qmwj1pf37lc2s5r83y7nqckscznqhbsv66bdfgfbby7x4qkwga8"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-boot r-mvtnorm))
    (native-inputs
     (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/circular/")
    (synopsis "Circular statistics")
    (description
     "This package provides tools for circular statistics, from \"Topics in
circular Statistics\" (2001) S. Rao Jammalamadaka and A. SenGupta, World
Scientific.")
    (license license:gpl2+)))

(define-public r-activity
  (package
    (name "r-activity")
    (version "1.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "activity" version))
       (sha256
        (base32
         "11n6wmqz7p3428rr615f92m61a5gb908xpn4l8q484h61bwg38c3"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-insol r-pbapply))
    (home-page "https://cran.r-project.org/web/packages/activity/")
    (synopsis "Animal activity statistics")
    (description
     "This package provides functions to fit kernel density functions to
animal activity time data; plot activity distributions; quantify overall
levels of activity; statistically compare activity metrics through
bootstrapping; and evaluate variation in linear variables with time (or other
circular variables).")
    (license license:gpl3)))

(define-public r-ouch
  (package
    (name "r-ouch")
    (version "2.18")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ouch" version))
       (sha256
        (base32
         "119s9llpjy0b4q830xig2xr66fq6izp6mr2k4k79ggmf3gxww8as"))))
    (build-system r-build-system)
    (propagated-inputs (list r-subplex))
    (home-page "https://kingaa.github.io/ouch/")
    (synopsis "Ornstein-Uhlenbeck models for phylogenetic comparative hypotheses")
    (description
     "This package provides tools to fit and compare Ornstein-Uhlenbeck models
for evolution along a phylogenetic tree.")
    (license license:gpl2+)))

(define-public r-fmri
  (package
    (name "r-fmri")
    (version "1.9.6")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "fmri" version))
              (sha256
               (base32
                "1wh77xwpm8f9d9vky3r7vfmkik3hls008ifk8hkm2rq6i06jj53n"))))
    (properties `((upstream-name . "fmri")))
    (build-system r-build-system)
    (propagated-inputs (list r-aws r-metafor r-nlme))
    (native-inputs (list gfortran))
    (home-page "http://www.wias-berlin.de/software/imaging/")
    (synopsis "Analysis of fMRI experiments")
    (description
     "This package contains R-functions to perform an fMRI analysis as
described in Polzehl and Tabelow (2019) <DOI:10.1007/978-3-030-29184-6>,
Tabelow et al. (2006) <DOI:10.1016/j.neuroimage.2006.06.029>, Polzehl et
al. (2010) <DOI:10.1016/j.neuroimage.2010.04.241>, Tabelow and Polzehl (2011)
<DOI:10.18637/jss.v044.i11>.")
    (license license:gpl2+)))

(define-public r-fmsb
  (package
    (name "r-fmsb")
    (version "0.7.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fmsb" version))
       (sha256
        (base32
         "1gi94xr0b1yk9xzwfprfafxi25yic1lcivd66p73n6iqfzdaimbk"))))
    (build-system r-build-system)
    (home-page "http://minato.sip21c.org/msb/")
    (synopsis "Functions for medical statistics book with demographic data")
    (description
     "This package provides several utility functions for the book entitled
\"Practices of Medical and Health Data Analysis using R\" (Pearson Education
Japan, 2007) with Japanese demographic data and some demographic analysis
related functions.")
    (license license:gpl2+)))

(define-public r-stabledist
  (package
    (name "r-stabledist")
    (version "0.7-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "stabledist" version))
       (sha256
        (base32
         "0scar396wiq6wkbkvwp4qrxqc1m075y56p37i6iry5rw796p1i86"))))
    (build-system r-build-system)
    (home-page "https://www.rmetrics.org")
    (synopsis "Stable distribution functions")
    (description
     "This package provides density, probability and quantile functions, and
random number generation for (skew) stable distributions, using the
parametrizations of Nolan.")
    (license license:gpl2+)))

(define-public r-gsl
  (package
    (name "r-gsl")
    (version "2.1-7.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gsl" version))
       (sha256
        (base32
         "118rj9kjx9rzlynvhrly19qz3yxg8jzws35971ssgzrp5lwd367f"))))
    (build-system r-build-system)
    (inputs
     (list gsl))
    (home-page "https://cran.r-project.org/web/packages/gsl")
    (synopsis "Wrapper for the GNU Scientific Library")
    (description
     "This package provides an R wrapper for the special functions and quasi
random number generators of the GNU Scientific Library.")
    (license license:gpl2+)))

(define-public r-adgoftest
  (package
    (name "r-adgoftest")
    (version "0.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ADGofTest" version))
       (sha256
        (base32
         "0ik817qzqp6kfbckjp1z7srlma0w6z2zcwykh0jdiv7nahwk3ncw"))))
    (properties `((upstream-name . "ADGofTest")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/ADGofTest")
    (synopsis "Anderson-Darling GoF test")
    (description
     "This package provides an implementation of the Anderson-Darling GoF test
with p-value calculation based on Marsaglia's 2004 paper \"Evaluating the
Anderson-Darling Distribution\".")
    ;; Any version of the GPL.
    (license license:gpl3+)))

(define-public r-adimpro
  (package
    (name "r-adimpro")
    (version "0.9.3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "adimpro" version))
              (sha256
               (base32
                "0njw38vcdm02sni193nj10mpv7hiklpamrkjlz5bnhjxx9mvf4cl"))))
    (properties `((upstream-name . "adimpro")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-awsmethods
           imagemagick))
    (native-inputs (list gfortran))
    (home-page "https://www.wias-berlin.de/software/imaging/")
    (synopsis "Adaptive smoothing of digital images")
    (description
     "This package implements tools for manipulation of digital images and the
Propagation Separation approach by Polzehl and Spokoiny (2006)
<DOI:10.1007/s00440-005-0464-1> for smoothing digital images, see Polzehl and
Tabelow (2007) <DOI:10.18637/jss.v019.i01>.")
    (license license:gpl2+)))

(define-public r-admisc
  (package
    (name "r-admisc")
    (version "0.30")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "admisc" version))
       (sha256
        (base32 "01b2qjxz0qicqjm1swvm04qkiwhr7zjn7lhqv26l6rj4yb43y339"))))
    (properties `((upstream-name . "admisc")))
    (build-system r-build-system)
    (home-page "https://github.com/dusadrian/admisc")
    (synopsis "Adrian Dusa's miscellaneous")
    (description
     "This package contains miscellaneous functions used to interpret and
translate, factorize and negate Sum of Products expressions, for both binary
and multi-value crisp sets, and to extract information (set names, set values)
from those expressions.  Other functions perform various other checks if
possibly numeric (even if all numbers reside in a character vector) and coerce
to numeric, or check if the numbers are whole.  It also offers, among many
others, a highly flexible recoding routine and a more flexible alternative to
the base function @code{with()}.")
    (license license:gpl3+)))

(define-public r-oro-nifti
  (package
    (name "r-oro-nifti")
    (version "0.11.4")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "oro.nifti" version))
              (sha256
               (base32
                "01mn90qxb7i15zr83xrl2cn4akayfzpm83r5x71zczz3qb9gbr7g"))))
    (properties `((upstream-name . "oro.nifti")))
    (build-system r-build-system)
    (propagated-inputs (list r-abind r-bitops r-rnifti))
    (home-page "https://rigorousanalytics.blogspot.com")
    (synopsis "Vizualization of medical imaging data")
    (description
     "This package provides functions for the input/output and visualization
of medical imaging data that follow either the ANALYZE, NIfTI or AFNI formats.
This package is part of the Rigorous Analytics bundle.")
    (license license:bsd-3)))

(define-public r-mritc
  (package
    (name "r-mritc")
    (version "0.5-2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "mritc" version))
              (sha256
               (base32
                "07b1b2k1ka43ikj2mhwnazw3ig7w10bf759fimxpksvk5k6wanx2"))))
    (properties `((upstream-name . "mritc")))
    (build-system r-build-system)
    (propagated-inputs (list r-lattice r-misc3d r-oro-nifti))
    (home-page "https://cran.r-project.org/package=mritc")
    (synopsis "MRI tissue classification")
    (description "This package provides various methods for MRI tissue
classification.")
    ;; Any version of the GPL.
    (license license:gpl3+)))

(define-public r-sodium
  (package
    (name "r-sodium")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sodium" version))
       (sha256
        (base32
         "1a03z2asvmalnmsn89lapzp8a4fr0qvzdv3xgin8pbqhjyb9hvpp"))))
    (properties `((upstream-name . "sodium")))
    (build-system r-build-system)
    (inputs
     (list libsodium))
    (native-inputs
     (list pkg-config r-knitr))
    (home-page "https://github.com/jeroen/sodium")
    (synopsis "R bindings to the libsodium crypto library")
    (description
     "This package provides bindings to libsodium: a library for encryption,
decryption, signatures, password hashing and more.  Sodium uses curve25519, a
Diffie-Hellman function by Daniel Bernstein, which has become very popular
after it was discovered that the NSA had backdoored Dual EC DRBG.")
    (license license:expat)))

(define-public r-softimpute
  (package
    (name "r-softimpute")
    (version "1.4-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "softImpute" version))
       (sha256
        (base32
         "1v2a4d688ij5zcvkzpra9yx40xckdfnllnfnyq2450zf3n1kjk7a"))))
    (properties `((upstream-name . "softImpute")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-matrix))
    (native-inputs
     (list gfortran r-knitr))
    (home-page "https://cran.r-project.org/web/packages/softImpute")
    (synopsis "Matrix completion via iterative soft-thresholded SVD")
    (description
     "This package provides iterative methods for matrix completion that use
nuclear-norm regularization.  The package includes procedures for centering
and scaling rows, columns or both, and for computing low-rank @dfn{single
value decompositions} (SVDs) on large sparse centered matrices (i.e. principal
components).")
    (license license:gpl2)))

(define-public r-fftwtools
  (package
    (name "r-fftwtools")
    (version "0.9-11")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fftwtools" version))
       (sha256
        (base32
         "0zrchp4l0jdbir2gibjf00x225y9giqk80zvqmr2yyvc12lwkw7i"))))
    (build-system r-build-system)
    (inputs (list fftw))
    (native-inputs
     (list pkg-config))
    (home-page "https://github.com/krahim/fftwtools")
    (synopsis "Wrapper for FFTW3")
    (description
     "This package provides a wrapper for several FFTW functions.  It provides
access to the two-dimensional FFT, the multivariate FFT, and the
one-dimensional real to complex FFT using the FFTW3 library.  The package
includes the functions @code{fftw()} and @code{mvfftw()} which are designed to
mimic the functionality of the R functions @code{fft()} and @code{mvfft()}.
The FFT functions have a parameter that allows them to not return the
redundant complex conjugate when the input is real data.")
    (license license:gpl2+)))

(define-public r-tiff
  (package
    (name "r-tiff")
    (version "0.1-11")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tiff" version))
       (sha256
        (base32
         "0xgc7vyndxxahfhc2qqzmwi56bnfyl0pn72l820jz5sd24aymhxq"))))
    (build-system r-build-system)
    (inputs
     (list libtiff libjpeg-turbo zlib))
    (native-inputs
     (list pkg-config))
    (home-page "https://www.rforge.net/tiff/")
    (synopsis "Read and write TIFF images")
    (description
     "This package provides an easy and simple way to read, write and display
bitmap images stored in the TIFF format.  It can read and write both files and
in-memory raw vectors.")
    ;; Either of these two license versions.
    (license (list license:gpl2 license:gpl3))))

(define-public r-nlp
  (package
    (name "r-nlp")
    (version "0.2-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "NLP" version))
       (sha256
        (base32
         "1dpj04fmld2lnhg072ahgjbhmciqqy9h1lrz0wf32mr7mm9s9sh5"))))
    (properties `((upstream-name . "NLP")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/NLP/")
    (synopsis "Natural language processing infrastructure")
    (description
     "This package provides basic classes and methods for Natural Language
Processing.")
    (license license:gpl3)))

(define-public r-tm
  (package
    (name "r-tm")
    (version "0.7-9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tm" version))
       (sha256
        (base32
         "0a3ylj9735i21fh6iz63fkh1pnf2hs8ipp8wjdj25dahl18yhlyv"))))
    (properties `((upstream-name . "tm")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bh r-nlp r-rcpp r-slam r-xml2))
    (home-page "http://tm.r-forge.r-project.org/")
    (synopsis "Text mining package")
    (description
     "This package provides a framework for text mining applications within R.")
    (license license:gpl3)))

(define-public r-waveslim
  (package
    (name "r-waveslim")
    (version "1.8.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "waveslim" version))
       (sha256
        (base32
         "1510xpkgrhdw394m5anxccdczjikcxazyd09ix2z73i15akyx3j0"))))
    (build-system r-build-system)
    (native-inputs
     (list gfortran))
    (home-page "http://waveslim.blogspot.com")
    (synopsis "Basic wavelet routines for signal processing")
    (description
     "This package provides basic wavelet routines for time series (1D),
image (2D) and array (3D) analysis.  The code provided here is based on
wavelet methodology developed in Percival and Walden (2000); Gencay, Selcuk
and Whitcher (2001); the dual-tree complex wavelet transform (DTCWT) from
Kingsbury (1999, 2001) as implemented by Selesnick; and Hilbert wavelet
pairs (Selesnick 2001, 2002).")
    (license license:bsd-3)))

(define-public r-wordcloud
  (package
    (name "r-wordcloud")
    (version "2.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "wordcloud" version))
       (sha256
        (base32
         "0j96yyvm6bcrrpbdx4w26piqx44a0vbsr3px9cb4zk8a8da6jwak"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcolorbrewer r-rcpp
           ;; The "tm" package is only "suggested" according to CRAN, but the
           ;; wordcloud package cannot be loaded without it.
           r-tm))
    (home-page "https://cran.r-project.org/web/packages/wordcloud")
    (synopsis "Word clouds")
    (description
     "This package provides functionality to create pretty word clouds,
visualize differences and similarity between documents, and avoid
over-plotting in scatter plots with text.")
    (license license:lgpl2.1)))

(define-public r-colorramps
  (package
    (name "r-colorramps")
    (version "2.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "colorRamps" version))
       (sha256
        (base32
         "12jnkj50yh2hc5l7j56lrrrmn58akrj9dwj98vzf42iq4h42kwb1"))))
    (properties `((upstream-name . "colorRamps")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/colorRamps")
    (synopsis "Build color tables")
    (description "This package provides features to build gradient color
maps.")
    ;; Any version of the GPL
    (license license:gpl3+)))

(define-public r-tidytree
  (package
    (name "r-tidytree")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tidytree" version))
       (sha256
        (base32 "1sq982x0pqvrn4d77m6v5xbbr9c8dkrwvw3as1pc5cg12x6kdi7v"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ape
           r-dplyr
           r-lazyeval
           r-magrittr
           r-pillar
           r-rlang
           r-tibble
           r-tidyr
           r-tidyselect
           r-yulab-utils))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/GuangchuangYu/tidytree")
    (synopsis "Tidy tool for phylogenetic tree data manipulation")
    (description
     "Phylogenetic trees generally contain multiple components including nodes,
edges, branches and associated data.  This package provides an approach to
convert tree objects to tidy data frames.  It also provides tidy interfaces to
manipulate tree data.")
    (license license:artistic2.0)))

(define-public r-rvcheck
  (package
    (name "r-rvcheck")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rvcheck" version))
       (sha256
        (base32 "09khjklvzbafd7r55496by01a9g3y291d87hpy43w44dmz9fzn9a"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-biocmanager r-yulab-utils))
    (home-page "https://cran.r-project.org/web/packages/rvcheck")
    (synopsis "R package version check")
    (description
     "This package provides tools to check the latest release version of R and
R packages (on CRAN, Bioconductor or Github).")
    (license license:artistic2.0)))

(define-public r-docopt
  (package
    (name "r-docopt")
    (version "0.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "docopt" version))
       (sha256
        (base32
         "1zxhwizs916qm5by7nfslqnarl2q5202xc2azlhrnzk0wj3khiwz"))))
    (build-system r-build-system)
    (home-page "https://github.com/docopt/docopt.R")
    (synopsis "Command-line interface specification language")
    (description
     "This package enables you to define a command-line interface by just
giving it a description in the specific format.")
    (license license:expat)))

(define-public r-sparsesvd
  (package
    (name "r-sparsesvd")
    (version "0.2-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sparsesvd" version))
       (sha256
        (base32
         "0yz0mgayxriyrz6bbrd41cck0s56b916xvyh13hw86gydd6kpl5k"))))
    (build-system r-build-system)
    (propagated-inputs (list r-matrix))
    (home-page "http://tedlab.mit.edu/~dr/SVDLIBC/")
    (synopsis "Sparse truncated singular value decomposition")
    (description
     "This package provides a Wrapper around the SVDLIBC library
for (truncated) singular value decomposition of a sparse matrix.  Currently,
only sparse real matrices in Matrix package format are supported.")
    ;; SVDLIBC is released under BSD-2.  The R interface is released under
    ;; BSD-3.
    (license (list license:bsd-3 license:bsd-2))))

(define-public r-speedglm
  (package
    (name "r-speedglm")
    (version "0.3-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "speedglm" version))
       (sha256
        (base32
         "1kj662nfkfhvx37jrbvxd4dyjclz5cm3xh50z7s5rbzapiyxn4hs"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mass r-matrix))
    (home-page "https://cran.r-project.org/web/packages/speedglm")
    (synopsis "Fit linear and generalized linear models to large data sets")
    (description
     "This package provides tools for fitting linear models and generalized
linear models to large data sets by updating algorithms.")
    ;; Any version of the GPL
    (license license:gpl2+)))

(define-public r-densityclust
  (package
    (name "r-densityclust")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "densityClust" version))
       (sha256
        (base32
         "05x2fi1zdnkrg2nimf8k904j3lpyw0f7nmk6ax5p7x7a98wb2iqs"))))
    (properties `((upstream-name . "densityClust")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-fnn
           r-ggplot2
           r-ggrepel
           r-gridextra
           r-rcolorbrewer
           r-rcpp
           r-rtsne))
    (home-page "https://cran.r-project.org/web/packages/densityClust")
    (synopsis "Clustering by fast search and find of density peaks")
    (description
     "This package provides an improved implementation (based on k-nearest
neighbors) of the density peak clustering algorithm, originally described by
Alex Rodriguez and Alessandro Laio (Science, 2014 vol. 344).  It can handle
large datasets (> 100,000 samples) very efficiently.")
    (license license:gpl2+)))

(define-public r-combinat
  (package
    (name "r-combinat")
    (version "0.0-8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "combinat" version))
       (sha256
        (base32
         "1h9hr88gigihc4na7lb5i7rn4az1xa7sb34zvnznaj6pdrmwy4qm"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/combinat")
    (synopsis "Combinatorics utilities")
    (description "This package provides assorted routines for combinatorics.")
    (license license:gpl2)))

(define-public r-qlcmatrix
  (package
    (name "r-qlcmatrix")
    (version "0.9.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "qlcMatrix" version))
       (sha256
        (base32
         "0iqkcvvy8rxlk0s83sjq57dd6fadb18p5z31lzy0gnzv1hsy1x8y"))))
    (properties `((upstream-name . "qlcMatrix")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-docopt r-matrix r-slam r-sparsesvd))
    (home-page "https://cran.r-project.org/web/packages/qlcMatrix")
    (synopsis "Sparse matrix functions for quantitative language comparison")
    (description
     "This package provides an extension of the functionality of the Matrix
package for using sparse matrices.  Some of the functions are very general,
while other are highly specific for the special data format used for
@dfn{quantitative language comparison} (QLC).")
    (license license:gpl3)))

(define-public r-qmri
  (package
    (name "r-qmri")
    (version "1.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "qMRI" version))
              (sha256
               (base32
                "10x59g8awxjib5j5mc1yd5wsibk3z6ki6zifxsg8azl0zblxbscf"))))
    (properties `((upstream-name . "qMRI")))
    (build-system r-build-system)
    (propagated-inputs (list r-adimpro r-aws r-awsmethods r-oro-nifti
                             r-stringr))
    (native-inputs (list gfortran r-knitr))
    (home-page "http://www.wias-berlin.de/research/ats/imaging/")
    (synopsis "Methods for quantitative magnetic resonance imaging (qMRI)")
    (description
     "This package provides implementation of methods for estimation of
quantitative maps from @dfn{Multi-Parameter Mapping} (MPM) acquisitions
including adaptive smoothing methods in the framework of the ESTATICS model.
The smoothing method is described in Mohammadi et
al. (2017). <doi:10.20347/WIAS.PREPRINT.2432>.  Usage of the package is also
described in Polzehl and Tabelow (2019), Magnetic Resonance Brain Imaging,
Chapter 6, Springer, Use R! Series. <doi:10.1007/978-3-030-29184-6_6>.")
    (license license:gpl2+)))

(define-public r-ddrtree
  (package
    (name "r-ddrtree")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "DDRTree" version))
       (sha256
        (base32
         "16s5fjw7kwlxhrkzdny62sx32fvmg3rxjc3wrh6krd31jh1fqlfk"))))
    (properties `((upstream-name . "DDRTree")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bh r-irlba r-rcpp r-rcppeigen))
    (home-page "https://cran.r-project.org/web/packages/DDRTree")
    (synopsis "Learning principal graphs with DDRTree")
    (description
     "This package provides an implementation of the framework of
@dfn{reversed graph embedding} (RGE) which projects data into a reduced
dimensional space while constructs a principal tree which passes through the
middle of the data simultaneously.  DDRTree shows superiority to
alternatives (Wishbone, DPT) for inferring the ordering as well as the
intrinsic structure of single cell genomics data.  In general, it could be
used to reconstruct the temporal progression as well as the bifurcation
structure of any data type.")
    (license license:asl2.0)))

(define-public r-corpcor
  (package
    (name "r-corpcor")
    (version "1.6.10")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "corpcor" version))
       (sha256
        (base32
         "028fw61n61i79fhnaqx7gmdifdpbvp3yiaq9vvfrbv4k7i84r83i"))))
    (build-system r-build-system)
    (home-page "http://strimmerlab.org/software/corpcor/")
    (synopsis "Efficient estimation of covariance and (partial) correlation")
    (description
     "This package implements a James-Stein-type shrinkage estimator for the
covariance matrix, with separate shrinkage for variances and correlations.
Furthermore, functions are available for fast singular value decomposition,
for computing the pseudoinverse, and for checking the rank and positive
definiteness of a matrix.")
    (license license:gpl3+)))

(define-public r-rspectra
  (package
    (name "r-rspectra")
    (version "0.16-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RSpectra" version))
       (sha256
        (base32
         "16ij84wgpsmqmnxqiii8dgihy3bfxazry9znmckhwzba7m0d79fb"))))
    (properties `((upstream-name . "RSpectra")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-matrix r-rcpp r-rcppeigen))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/yixuan/RSpectra")
    (synopsis "Solvers for large-scale Eigenvalue and SVD problems")
    (description
     "This package provides an R interface to the Spectra library for
large-scale eigenvalue and SVD problems.  It is typically used to compute a
few eigenvalues/vectors of an n by n matrix, e.g., the k largest eigenvalues,
which is usually more efficient than @code{eigen()} if k << n.")
    ;; MPL 2 or later.
    (license license:mpl2.0)))

(define-public r-vbsr
  (package
    (name "r-vbsr")
    (version "0.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "vbsr" version))
       (sha256
        (base32
         "1avskbxxyinjjdga4rnghcfvd4sypv4m39ysfaij5avvmi89bx3b"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/vbsr")
    (synopsis "Variational Bayes spike regression regularized linear models")
    (description
     "This package provides an efficient algorithm for solving ultra-sparse
regularized regression models using a variational Bayes algorithm with a spike
prior.  The algorithm is solved on a path, with coordinate updates, and is
capable of generating very sparse models.  Very general model
diagnostics for controlling type-1 errors are also provided.")
    (license license:gpl2)))

(define-public r-flare
  (package
    (name "r-flare")
    (version "1.7.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "flare" version))
       (sha256
        (base32
         "1xvrbvq2y7zfp98ijal3z8y1w2xbzfcdykzw4pqc3mnh0qrhq2d5"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-igraph r-lattice r-mass r-matrix))
    (home-page "https://cran.r-project.org/web/packages/flare")
    (synopsis "Family of Lasso regression implementations")
    (description
     "This package provides implementations of a family of Lasso variants
including Dantzig Selector, LAD Lasso, SQRT Lasso, Lq Lasso for estimating
high dimensional sparse linear models.")
    (license license:gpl2)))

(define-public r-lassopv
  (package
    (name "r-lassopv")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lassopv" version))
       (sha256
        (base32
         "0yawnjw063jypk3riy9xab9cmliv6c9dnabi18670khd3gzb2r9z"))))
    (build-system r-build-system)
    (propagated-inputs (list r-lars))
    (home-page "https://github.com/lingfeiwang/lassopv")
    (synopsis "Non-parametric p-value estimation for predictors in Lasso")
    (description
     "This package enables you to estimate the p-values for predictors x
against target variable y in Lasso regression, using the regularization
strength when each predictor enters the active set of regularization path for
the first time as the statistic.")
    (license license:gpl3)))

(define-public r-splitstackshape
  (package
    (name "r-splitstackshape")
    (version "1.4.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "splitstackshape" version))
       (sha256
        (base32
         "0mpyf2kkfdl69pdc6brl1r6101vyc6pgr7z17s55ppg3y71k4q35"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-data-table))
    (home-page "https://github.com/mrdwab/splitstackshape")
    (synopsis "Stack and reshape datasets after splitting concatenated values")
    (description
     "Online data collection tools like Google Forms often export
multiple-response questions with data concatenated in cells.  The
@code{concat.split} (cSplit) family of functions provided by this package
splits such data into separate cells.  This package also includes functions to
stack groups of columns and to reshape wide data, even when the data are
\"unbalanced\"---something which @code{reshape} (from base R) does not handle,
and which @code{melt} and @code{dcast} from @code{reshape2} do not easily
handle.")
    (license license:gpl3)))

(define-public r-tfmpvalue
  (package
    (name "r-tfmpvalue")
    (version "0.0.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "TFMPvalue" version))
       (sha256
        (base32
         "1rsxqvq1nkyhwmhm7mf7rd02rvh7xinnhqbqic6q9vicbvkmdnxr"))))
    (properties `((upstream-name . "TFMPvalue")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (home-page "https://github.com/ge11232002/TFMPvalue")
    (synopsis "P-value computation for position weight matrices")
    (description
     "In putative @dfn{Transcription Factor Binding Sites} (TFBSs)
identification from sequence/alignments, we are interested in the significance
of certain match scores.  TFMPvalue provides the accurate calculation of a
p-value with a score threshold for position weight matrices, or the score with
a given p-value.  It is an interface to code originally made available by
Helene Touzet and Jean-Stephane Varre, 2007, Algorithms Mol Biol:2, 15.
Touzet and Varre (2007).")
    (license license:gpl2)))

(define-public r-rncl
  (package
    (name "r-rncl")
    (version "0.8.6")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "rncl" version))
              (sha256
               (base32
                "1ywgwqn82z8h6zpcxxq4hgngdpfa6dj0lr7bfq4cwfml9z075jgw"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-progress r-rcpp))
    (home-page "https://github.com/fmichonneau/rncl")
    (synopsis "Interface to the Nexus class library")
    (description "This package provides an interface to the Nexus class
library which allows parsing of NEXUS, Newick and other phylogenetic tree
 file formats.  It provides elements of the file that can be used to build
 phylogenetic objects such as @code{ape}'s @code{phylo} or @code{phylobase}'s
@code{phylo4(d)}.  This functionality is demonstrated with
@code{read_newick_phylo()} and @code{read_nexus_phylo()}.")
    (license license:bsd-2)))

(define-public r-phylobase
  (package
    (name "r-phylobase")
    (version "0.8.10")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "phylobase" version))
              (sha256
               (base32
                "0jzr1gdvmi4l640hwwzh9bxqmpja69bn3ygnaqx37awvyh7khi2s"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ade4 r-ape r-rcpp r-rncl r-rnexml))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/fmichonneau/phylobase")
    (synopsis "Base package for phylogenetic structures and comparative data")
    (description "This package provides a base @code{S4} class for comparative
methods, incorporating one or more trees and trait data.")
    (license license:gpl2+)))

(define-public r-phylotools
  (package
    (name "r-phylotools")
    (version "0.2.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "phylotools" version))
              (sha256
               (base32
                "1dhk1ncp5zi4zl1xfnjz64v983dm7bq7iimfjin80j0bdcpps44w"))))
    (properties `((upstream-name . "phylotools")))
    (build-system r-build-system)
    (propagated-inputs (list r-ape))
    (home-page "https://github.com/helixcn/phylotools")
    (synopsis "Phylogenetic tools for eco-phylogenetics")
    (description
     "This package provides a collection of tools for building RAxML
supermatrix using PHYLIP or aligned FASTA files.  These functions will be
useful for building large phylogenies using multiple markers.")
    (license license:gpl2)))

(define-public r-rnexml
  (package
    (name "r-rnexml")
    (version "2.4.8")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "RNeXML" version))
              (sha256
               (base32
                "0l5qpg6f107k927vnnki7g9yfs20xkpd7c5pkvbj8bpybbwjkm16"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ape
           r-dplyr
           r-httr
           r-plyr
           r-reshape2
           r-rlang
           r-stringi
           r-stringr
           r-tidyr
           r-uuid
           r-xml
           r-xml2))
    (native-inputs
     (list r-knitr))
    (home-page "https://docs.ropensci.org/RNeXML/")
    (synopsis "Semantically rich I/O for the NeXML Format")
    (description "This package provides access to phyloinformatic data in
NeXML format.  The package should add new functionality to R such as the
possibility to manipulate NeXML objects in more various and refined way
and compatibility with @code{ape} objects.")
    (license license:bsd-3)))

(define-public r-rnifti
  (package
    (name "r-rnifti")
    (version "1.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RNifti" version))
       (sha256
        (base32
         "1zr9g102zhb1h6a06p141g1jq0ik94kah8r3z3q2zharj30y2waz"))))
    (properties `((upstream-name . "RNifti")))
    (build-system r-build-system)
    (inputs (list zlib))
    (propagated-inputs (list r-rcpp))
    (home-page "https://github.com/jonclayden/RNifti")
    (synopsis "Fast R and C++ access to NIfTI images")
    (description
     "This package provides very fast read and write access to images stored
in the NIfTI-1 and ANALYZE-7.5 formats, with seamless synchronisation between
compiled C and interpreted R code.  It also provides a C/C++ API that can be
used by other packages.")
    (license license:gpl2)))

(define-public r-shades
  (package
    (name "r-shades")
    (version "1.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shades" version))
       (sha256
        (base32
         "1zg95sjhrfvbdlfc387g9p0vnb8nb6agdk1mb3wq3kwkm2da0bqj"))))
    (build-system r-build-system)
    (home-page "https://github.com/jonclayden/shades")
    (synopsis "Simple color manipulation")
    (description
     "This package provides functions for easily manipulating colors,
creating color scales and calculating color distances.")
    (license license:bsd-3)))

(define-public r-ore
  (package
    (name "r-ore")
    (version "1.7.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ore" version))
       (sha256
        (base32 "0rs5r5h11x4l4nsbl4xqzbl4ahajd5374fq05abcmfjnjr9j64w5"))))
    (build-system r-build-system)
    (home-page "https://github.com/jonclayden/ore")
    (synopsis "R interface to the Onigmo regular expression library")
    (description
     "This package provides an alternative to R's built-in functionality for
handling regular expressions, based on the Onigmo library.  It offers
first-class compiled regex objects, partial matching and function-based
substitutions, amongst other features.")
    (license license:bsd-3)))

(define-public r-reportr
  (package
    (name "r-reportr")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "reportr" version))
       (sha256
        (base32
         "0zynplxqvbmf23cm2rsz3wz2jx6mv55z94mn1k44ny3lx625cnpw"))))
    (build-system r-build-system)
    (propagated-inputs (list r-ore))
    (home-page "https://github.com/jonclayden/reportr")
    (synopsis "General message and error reporting system")
    (description
     "This package provides a system for reporting messages, which offers
certain useful features over the standard R system, such as the incorporation
of output consolidation, message filtering, assertions, expression
substitution, automatic generation of stack traces for debugging, and
conditional reporting based on the current \"output level\".")
    (license license:gpl2)))

(define-public r-tractor-base
  (package
    (name "r-tractor-base")
    (version "3.3.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tractor.base" version))
       (sha256
        (base32
         "0fxbzbhpi6l55m14nmww8y3kdxgchzj4mw1yf4xkm2y6s68phvgc"))))
    (properties `((upstream-name . "tractor.base")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ore r-reportr r-rnifti r-shades))
    (home-page "https://www.tractor-mri.org.uk")
    (synopsis "Read, manipulate and visualize magnetic resonance images")
    (description
     "This package provides functions for working with magnetic resonance
images.  It supports reading and writing of popular file formats (DICOM,
Analyze, NIfTI-1, NIfTI-2, MGH); interactive and non-interactive
visualization; flexible image manipulation; metadata and sparse image
handling.")
    (license license:gpl2)))

(define-public r-grimport
  (package
    (name "r-grimport")
    (version "0.9-5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "grImport" version))
       (sha256
        (base32
         "0pbzc45wgp0cpycnw0bzn65ckdszzay0zrp7c7ssxdkifp8bai3a"))))
    (properties `((upstream-name . "grImport")))
    (build-system r-build-system)
    (inputs
     (list ghostscript))
    (propagated-inputs
     (list r-xml))
    (home-page "https://cran.r-project.org/web/packages/grImport")
    (synopsis "Convert, import, and draw PostScript pictures")
    (description
     "This package provides functions for converting, importing, and drawing
PostScript pictures in R plots.")
    (license license:gpl2+)))

(define-public r-grimport2
  (package
    (name "r-grimport2")
    (version "0.2-0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "grImport2" version))
       (sha256
        (base32
         "19q0dd8fpp1g4xf6sg5f8dxybwxjfw553ra6wgjd8b74fzca40m1"))))
    (properties `((upstream-name . "grImport2")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-base64enc r-jpeg r-png r-xml))
    (home-page "https://cran.r-project.org/web/packages/grImport2/")
    (synopsis "Import SVG graphics")
    (description
     "This package provides functions for importing external vector images and
drawing them as part of R plots.  This package is different from the
@code{grImport} package because, where that package imports PostScript format
images, this package imports SVG format images.  Furthermore, this package
imports a specific subset of SVG, so external images must be preprocessed
using a package like @code{rsvg} to produce SVG that this package can import.
SVG features that are not supported by R graphics, such as gradient fills, can
be imported and then exported via the @code{gridSVG} package.")
    (license license:gpl2+)))

(define-public r-kohonen
  (package
    (name "r-kohonen")
    (version "3.0.11")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "kohonen" version))
       (sha256
        (base32
         "1bk3j0n8w4fhffv89rgyn4n21c0wcx6lr8jv4wbagpxprl585381"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp))
    (home-page "https://cran.r-project.org/web/packages/kohonen")
    (synopsis "Supervised and unsupervised self-organising maps")
    (description
     "This package provides functions to train @dfn{self-organising
maps} (SOMs).  Also interrogation of the maps and prediction using trained
maps are supported.  The name of the package refers to Teuvo Kohonen, the
inventor of the SOM.")
    (license license:gpl2+)))

(define-public r-nnls
  (package
    (name "r-nnls")
    (version "1.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "nnls" version))
       (sha256
        (base32
         "07vcrrxvswrvfiha6f3ikn640yg0m2b4yd9lkmim1g0jmsmpfp8f"))))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/nnls")
    (synopsis "Lawson-Hanson algorithm for non-negative least squares")
    (description
     "This package provides an R interface to the Lawson-Hanson implementation
of an algorithm for @dfn{non-negative least squares} (NNLS).  It also allows
the combination of non-negative and non-positive constraints.")
    (license license:gpl2+)))

(define-public r-iso
  (package
    (name "r-iso")
    (version "0.0-18.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Iso" version))
       (sha256
        (base32
         "0vy6jdyvp751430sf2f690yhasjr70cpk3p3lnaaxjq3fs5gg99g"))))
    (properties `((upstream-name . "Iso")))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://www.stat.auckland.ac.nz/~rolf/")
    (synopsis "Functions to perform isotonic regression")
    (description
     "This package provides support for linear order and unimodal
order (univariate) isotonic regression and bivariate isotonic regression with
linear order on both variables.")
    (license license:gpl2+)))

(define-public r-chemometricswithr
  (package
    (name "r-chemometricswithr")
    (version "0.1.13")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ChemometricsWithR" version))
       (sha256
        (base32
         "166va1g3m1wv21qkmw4wpz0bsrclh3jih8smxphdc13l9pqgclpq"))))
    (properties
     `((upstream-name . "ChemometricsWithR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-devtools r-kohonen r-mass r-pls))
    (home-page "https://github.com/rwehrens/CWR")
    (synopsis "Chemometrics with R")
    (description
     "This package provides functions and scripts used in the book
\"Chemometrics with R - Multivariate Data Analysis in the Natural Sciences and
Life Sciences\" by Ron Wehrens, Springer (2011).")
    (license license:gpl2+)))

(define-public r-als
  (package
    (name "r-als")
    (version "0.0.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ALS" version))
       (sha256
        (base32
         "184d6xr4mgs78jvi7xa4njrq6p625i9sx69wak6mdn53qpl9b8ap"))))
    (properties `((upstream-name . "ALS")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-iso r-nnls))
    (home-page "https://cran.r-project.org/web/packages/ALS")
    (synopsis "Multivariate curve resolution alternating least squares")
    (description
     "Alternating least squares is often used to resolve components
contributing to data with a bilinear structure; the basic technique may be
extended to alternating constrained least squares.  This package provides an
implementation of @dfn{multivariate curve resolution alternating least
squares} (MCR-ALS).

Commonly applied constraints include unimodality, non-negativity, and
normalization of components.  Several data matrices may be decomposed
simultaneously by assuming that one of the two matrices in the bilinear
decomposition is shared between datasets.")
    (license license:gpl2+)))

(define-public r-strucchange
  (package
    (name "r-strucchange")
    (version "1.5-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "strucchange" version))
       (sha256
        (base32
         "11hgz64snlwhfqsmqajmkciflwkz1wficxr340wqvk38iw1b9ina"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-sandwich r-zoo))
    (home-page "https://cran.r-project.org/web/packages/strucchange")
    (synopsis "Testing, monitoring, and dating structural changes")
    (description
     "This package provides tools for testing, monitoring and dating
structural changes in (linear) regression models.  It features tests/methods
from the generalized fluctuation test framework as well as from the F
test (Chow test) framework.  This includes methods to fit, plot and test
fluctuation processes (e.g., CUSUM, MOSUM, recursive/moving estimates) and F
statistics, respectively.  It is possible to monitor incoming data online
using fluctuation processes.  Finally, the breakpoints in regression models
with structural changes can be estimated together with confidence intervals.
Emphasis is always given to methods for visualizing the data.")
    ;; Either of these two GPL versions
    (license (list license:gpl2 license:gpl3))))

(define-public r-pixmap
  (package
    (name "r-pixmap")
    (version "0.4-12")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pixmap" version))
       (sha256
        (base32
         "1v1a1adsgh5jlvvi98j4nhb1h681s97ip76zdrga12rlsjaahfw9"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/pixmap")
    (synopsis "Tools for bitmap images")
    (description
     "This package provides functions for importing, exporting, plotting and
other manipulations of bitmapped images.")
    (license license:gpl2)))

(define-public r-rapidjsonr
  (package
    (name "r-rapidjsonr")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rapidjsonr" version))
       (sha256
        (base32
         "07zdirhbzmvq3cp4xn8ngk1lgxbbabzays315zxbs3sxrz6lzjb2"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/rapidjsonr")
    (synopsis "JSON parser")
    (description
     "This package provides JSON parsing capability through the Rapidjson
library.")
    (license license:expat)))

(define-public r-ontologyindex
  (package
    (name "r-ontologyindex")
    (version "2.10")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ontologyIndex" version))
       (sha256
        (base32
         "0hisb9scxyyqkxhxhvgsgwix54pkq0zma3xq3ywczyazvzcxd5f9"))))
    (properties `((upstream-name . "ontologyIndex")))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/ontologyIndex")
    (synopsis "Functions for processing ontologies in R")
    (description
     "This package provides functions for reading ontologies into R as lists
and manipulating sets of ontological terms.")
    (license license:gpl2+)))

(define-public r-gargle
  (package
    (name "r-gargle")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gargle" version))
       (sha256
        (base32
         "087hlbqpwjj7jnsg1ax2b12nc0h4zfj070q5hjp6fca05z4f4rzk"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-fs
           r-glue
           r-httr
           r-jsonlite
           r-rappdirs
           r-rlang
           r-rstudioapi
           r-withr))
    (native-inputs
     (list r-knitr))
    (home-page "https://gargle.r-lib.org")
    (synopsis "Utilities for working with Google APIs")
    (description
     "This package provides utilities for working with Google APIs.  This
includes functions and classes for handling common credential types and for
preparing, executing, and processing HTTP requests.")
    (license license:expat)))

(define-public r-bigrquery
  (package
    (name "r-bigrquery")
    (version "1.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bigrquery" version))
       (sha256
        (base32
         "1rcz1zq0azrrchhxz4b0g4m9c3ymp4pasi7ji1nvx25w5x41sdmv"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertthat
           r-bit64
           r-brio
           r-curl
           r-dbi
           r-gargle
           r-glue
           r-httr
           r-jsonlite
           r-lifecycle
           r-prettyunits
           r-progress
           r-rapidjsonr
           r-rcpp
           r-rlang
           r-tibble))
    (home-page "https://github.com/rstats-db/bigrquery")
    (synopsis "R interface to Google's BigQuery API")
    (description
     "This package provides an R interface to Google's BigQuery database.")
    (license license:gpl3)))

(define-public r-gmp
  (package
    (name "r-gmp")
    (version "0.6-7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gmp" version))
       (sha256
        (base32
         "119z6q3xca1ysdpjfmq3crplj355vlwggxvqh2gs4yi63xlzwcv3"))))
    (build-system r-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'set-CC
           (lambda _ (setenv "CC" "gcc") #t)))))
    (inputs (list gmp))
    (home-page "https://cran.r-project.org/web/packages/gmp")
    (synopsis "Multiple precision arithmetic")
    (description
     "This package supports multiple precision arithmetic (big integers and
rationals, prime number tests, matrix computation), \"arithmetic without
limitations\" using the GNU Multiple Precision library.")
    ;; Any version of the GPL.
    (license license:gpl3+)))

(define-public r-rmpfr
  (package
    (name "r-rmpfr")
    (version "0.8-9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Rmpfr" version))
       (sha256
        (base32
         "12mwvgyalzh4zf5d002fm1hpr3wwhiypy9ia6wy47ij9gns5mvng"))))
    (properties `((upstream-name . "Rmpfr")))
    (build-system r-build-system)
    (inputs
     (list mpfr gmp))
    (propagated-inputs
     (list r-gmp))
    (native-inputs
     (list pkg-config))
    (home-page "http://rmpfr.r-forge.r-project.org/")
    (synopsis "R bindings to the MPFR library")
    (description
     "This package supports arithmetic (via S4 classes and methods) for
arbitrary precision floating point numbers, including transcendental
functions.  To this end, the package interfaces with the @dfn{Multiple
Precision Floating-Point Reliable} (MPFR) library.")
    (license license:gpl2+)))

(define-public r-assertive-base
  (package
    (name "r-assertive-base")
    (version "0.0-9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "assertive.base" version))
       (sha256
        (base32
         "07m0ddz092bgbl2fn1yk932h0iajdcqkri632477wl5a1q5r3w2b"))))
    (properties
     `((upstream-name . "assertive.base")))
    (build-system r-build-system)
    (home-page "https://bitbucket.org/richierocks/assertive.base")
    (synopsis "Core of the assertive package")
    (description
     "This package provides a minimal set of predicates and assertions used by
the assertive package.  This is mainly for use by other package developers who
want to include run-time testing features in their own packages.")
    (license license:gpl3+)))

(define-public r-assertive-properties
  (package
    (name "r-assertive-properties")
    (version "0.0-5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "assertive.properties" version))
       (sha256
        (base32
         "1pgljbwwbvbl4kc5c8mcv0qbzq3k6fzi29k88811yml263sm92dn"))))
    (properties
     `((upstream-name . "assertive.properties")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertive-base))
    (home-page "https://bitbucket.org/richierocks/assertive.properties")
    (synopsis "Assertions to check properties of variables")
    (description
     "This package provides a set of predicates and assertions for checking
the properties of variables, such as length, names and attributes.  This is
mainly for use by other package developers who want to include run-time
testing features in their own packages.")
    (license license:gpl3+)))

(define-public r-assertive-numbers
  (package
    (name "r-assertive-numbers")
    (version "0.0-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "assertive.numbers" version))
       (sha256
        (base32
         "0jc3ss64j4m7bjydhagwwmka5n7c72vpw4kfcch0m5jvkq5qrqds"))))
    (properties
     `((upstream-name . "assertive.numbers")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertive-base))
    (home-page "https://bitbucket.org/richierocks/assertive.numbers")
    (synopsis "Assertions to check properties of numbers")
    (description
     "This package provides a set of predicates and assertions for checking
the properties of numbers.  This is mainly for use by other package developers
who want to include run-time testing features in their own packages.")
    (license license:gpl3+)))

(define-public r-assertive-sets
  (package
    (name "r-assertive-sets")
    (version "0.0-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "assertive.sets" version))
       (sha256
        (base32
         "1cqvh2syvh5b6d85h601zjmsdbbf3h8q98ids4dfl4frdshpasc7"))))
    (properties
     `((upstream-name . "assertive.sets")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertive-base))
    (home-page "https://bitbucket.org/richierocks/assertive.sets")
    (synopsis "Assertions to check properties of sets")
    (description
     "This package provides a set of predicates and assertions for checking
the properties of sets.  This is mainly for use by other package developers
who want to include run-time testing features in their own packages.")
    (license license:gpl3+)))

(define-public r-assertive-matrices
  (package
    (name "r-assertive-matrices")
    (version "0.0-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "assertive.matrices" version))
       (sha256
        (base32
         "16sykzcndv6y2d43x6v9n7m95kv76364h39kh10w4z0xw6ksfqil"))))
    (properties
     `((upstream-name . "assertive.matrices")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertive-base))
    (home-page "https://bitbucket.org/richierocks/assertive.matrices")
    (synopsis "Assertions to check properties of matrices")
    (description
     "This package provides a set of predicates and assertions for checking
the properties of matrices.  This is mainly for use by other package
developers who want to include run-time testing features in their own
packages.")
    (license license:gpl3+)))

(define-public r-assertive-models
  (package
    (name "r-assertive-models")
    (version "0.0-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "assertive.models" version))
       (sha256
        (base32
         "0bn4j4v5qvb2d672cgri61p8d9v258pmz35y3lvm6b9mdxwdi9mr"))))
    (properties
     `((upstream-name . "assertive.models")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertive-base))
    (home-page "https://bitbucket.org/richierocks/assertive.models")
    (synopsis "Assertions to check properties of models")
    (description
     "This package provides a set of predicates and assertions for checking
the properties of models.  This is mainly for use by other package developers
who want to include run-time testing features in their own packages.")
    (license license:gpl3+)))

(define-public r-assertive-reflection
  (package
    (name "r-assertive-reflection")
    (version "0.0-5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "assertive.reflection" version))
       (sha256
        (base32
         "1g9lpwzy6r2xmyi2mlbcccnfgyzhzbmx5bsicf3vkffxrlkrpjn2"))))
    (properties
     `((upstream-name . "assertive.reflection")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertive-base))
    (home-page "https://bitbucket.org/richierocks/assertive.reflection")
    (synopsis "Assertions for checking the state of R")
    (description
     "This package provides a set of predicates and assertions for checking
the state and capabilities of R, the operating system it is running on, and
the IDE being used.  This is mainly for use by other package developers who
want to include run-time testing features in their own packages.")
    (license license:gpl3+)))

(define-public r-assertive-types
  (package
    (name "r-assertive-types")
    (version "0.0-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "assertive.types" version))
       (sha256
        (base32
         "0zxq1jfrzgw95ll7alvm0xnk7aihjdksngq4ya2whyvfjbmv4vdb"))))
    (properties
     `((upstream-name . "assertive.types")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertive-base r-assertive-properties r-codetools))
    (home-page "https://bitbucket.org/richierocks/assertive.types")
    (synopsis "Assertions to check types of variables")
    (description
     "This package provides a set of predicates and assertions for checking
the types of variables.  This is mainly for use by other package developers
who want to include run-time testing features in their own packages.")
    (license license:gpl3+)))

(define-public r-assertive-files
  (package
    (name "r-assertive-files")
    (version "0.0-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "assertive.files" version))
       (sha256
        (base32
         "02pfz8j5vwcj5kl6zca46894li7lxwnlrr29j922f14ay6kdssmy"))))
    (properties
     `((upstream-name . "assertive.files")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertive-base r-assertive-numbers))
    (home-page "https://bitbucket.org/richierocks/assertive.files")
    (synopsis "Assertions to check properties of files")
    (description
     "This package provides a set of predicates and assertions for checking
the properties of files and connections.  This is mainly for use by other
package developers who want to include run-time testing features in their own
packages.")
    (license license:gpl3+)))

(define-public r-assertive-code
  (package
    (name "r-assertive-code")
    (version "0.0-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "assertive.code" version))
       (sha256
        (base32
         "1qhbp668zfvhqs8avkhg9amp4zyazz6dsy4fc6kpdmw3sv8yi07g"))))
    (properties
     `((upstream-name . "assertive.code")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertive-base r-assertive-properties r-assertive-types))
    (home-page "https://bitbucket.org/richierocks/assertive.code")
    (synopsis "Assertions to check properties of code")
    (description
     "This package provides a set of predicates and assertions for checking
the properties of code.  This is mainly for use by other package developers
who want to include run-time testing features in their own packages.")
    (license license:gpl3+)))

(define-public r-assertive-datetimes
  (package
    (name "r-assertive-datetimes")
    (version "0.0-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "assertive.datetimes" version))
       (sha256
        (base32
         "151d05z8n6dpl44pqsa1jfi0ijbigr3zfc43xlw53nd8ymi22kh1"))))
    (properties
     `((upstream-name . "assertive.datetimes")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertive-base r-assertive-types))
    (home-page "https://bitbucket.org/richierocks/assertive.datetimes")
    (synopsis "Assertions to check properties of dates and times")
    (description
     "This package provides a set of predicates and assertions for checking
the properties of dates and times.  This is mainly for use by other package
developers who want to include run-time testing features in their own
packages.")
    (license license:gpl3+)))

(define-public r-assertive-strings
  (package
    (name "r-assertive-strings")
    (version "0.0-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "assertive.strings" version))
       (sha256
        (base32
         "0n6jrk88670g4ym0r8ii40a08a90z1xadj8wcryk8h0nl04dchfm"))))
    (properties
     `((upstream-name . "assertive.strings")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertive-base r-assertive-types r-stringi))
    (home-page "https://bitbucket.org/richierocks/assertive.strings")
    (synopsis "Assertions to check properties of strings")
    (description
     "This package provides a set of predicates and assertions for checking
the properties of strings.  This is mainly for use by other package developers
who want to include run-time testing features in their own packages.")
    (license license:gpl3+)))

(define-public r-assertive-data-us
  (package
    (name "r-assertive-data-us")
    (version "0.0-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "assertive.data.us" version))
       (sha256
        (base32
         "1bgspn0sccmp9z7s7djvdvprgxlyc5vrxznp4zfjb79kwvgn83hq"))))
    (properties
     `((upstream-name . "assertive.data.us")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertive-base r-assertive-strings))
    (home-page "https://bitbucket.org/richierocks/assertive.data.us")
    (synopsis "Assertions to check properties of strings")
    (description
     "This package provides a set of predicates and assertions for checking
the properties of US-specific complex data types.  This is mainly for use by
other package developers who want to include run-time testing features in
their own packages.")
    (license license:gpl3+)))

(define-public r-assertive-data-uk
  (package
    (name "r-assertive-data-uk")
    (version "0.0-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "assertive.data.uk" version))
       (sha256
        (base32
         "1fzjvhwp7mwkqqix29khvs6zcrc82n6j4czvzzb473vyjyvdlj5b"))))
    (properties
     `((upstream-name . "assertive.data.uk")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertive-base r-assertive-strings))
    (home-page "https://bitbucket.org/richierocks/assertive.data.uk")
    (synopsis "Assertions to check properties of strings")
    (description
     "This package provides a set of predicates and assertions for checking
the properties of UK-specific complex data types.  This is mainly for use by
other package developers who want to include run-time testing features in
their own packages.")
    (license license:gpl3+)))

(define-public r-assertive-data
  (package
    (name "r-assertive-data")
    (version "0.0-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "assertive.data" version))
       (sha256
        (base32
         "00cvg2g36mdl8plrzx40m63qd55742mddqrchwy9n3c7mm4gn02s"))))
    (properties
     `((upstream-name . "assertive.data")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertive-base r-assertive-strings))
    (home-page "https://bitbucket.org/richierocks/assertive.data")
    (synopsis "Assertions to check properties of data")
    (description
     "This package provides a set of predicates and assertions for checking
the properties of (country independent) complex data types.  This is mainly
for use by other package developers who want to include run-time testing
features in their own packages.")
    (license license:gpl3+)))

(define-public r-assertive
  (package
    (name "r-assertive")
    (version "0.3-6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "assertive" version))
       (sha256
        (base32
         "02palil82idqhhshcdjsfsja9qkqnd0dczqzj5gbccy4hfg1c0y4"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertive-base
           r-assertive-code
           r-assertive-data
           r-assertive-data-uk
           r-assertive-data-us
           r-assertive-datetimes
           r-assertive-files
           r-assertive-matrices
           r-assertive-models
           r-assertive-numbers
           r-assertive-properties
           r-assertive-reflection
           r-assertive-sets
           r-assertive-strings
           r-assertive-types
           r-knitr))
    (native-inputs
     (list r-knitr))
    (home-page "https://bitbucket.org/richierocks/assertive")
    (synopsis "Readable check functions to ensure code integrity")
    (description
     "This package provides lots of predicates (@code{is_*} functions) to
check the state of your variables, and assertions (@code{assert_*} functions)
to throw errors if they aren't in the right form.")
    (license license:gpl3+)))

(define-public r-dotcall64
  (package
    (name "r-dotcall64")
    (version "1.0-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dotCall64" version))
       (sha256
        (base32
         "1b546z9r26q4xpr17gy2wzfych52q17sxvzydpqfp9dyxf575iz0"))))
    (properties `((upstream-name . "dotCall64")))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://git.math.uzh.ch/reinhard.furrer/dotCall64")
    (synopsis "Enhanced foreign function interface supporting long vectors")
    (description
     "This package provides @code{.C64()}, an enhanced version of @code{.C()}
and @code{.Fortran()} from the R foreign function interface.  @code{.C64()}
supports long vectors, arguments of type 64-bit integer, and provides a
mechanism to avoid unnecessary copies of read-only and write-only arguments.
This makes it a convenient and fast interface to C/C++ and Fortran code.")
    (license license:gpl2+)))

(define-public r-spam
  (package
    (name "r-spam")
    (version "2.9-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "spam" version))
       (sha256
        (base32 "1nvx965vxzs697k9m2l40a15bykflksn9bwa4py1p2wqg6922bn3"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dotcall64))
    (native-inputs
     (list gfortran r-knitr))
    (home-page "https://www.math.uzh.ch/pages/spam/")
    (synopsis "Sparse matrix algebra")
    (description
     "This package provides a set of functions for sparse matrix algebra.
Differences with other sparse matrix packages are:

@enumerate
@item it only supports (essentially) one sparse matrix format;
@item it is based on transparent and simple structure(s);
@item it is tailored for MCMC calculations within G(M)RF;
@item and it is fast and scalable (with the extension package @code{spam64}).
@end enumerate\n")
    ;; Either of these licenses
    (license (list license:bsd-3 license:lgpl2.0))))

(define-public r-fields
  (package
    (name "r-fields")
    (version "14.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fields" version))
       (sha256
        (base32 "0d2lm4s9p3rv676z291fynpx3vdmi6cikcqlj23fxlj34icwbi2p"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-maps r-spam r-viridis))
    (native-inputs
     (list gfortran))
    (home-page "https://www.image.ucar.edu/fields")
    (synopsis "Tools for spatial data")
    (description
     "This is a package for curve, surface and function fitting with an
emphasis on splines, spatial data and spatial statistics.  The major methods
include cubic, and thin plate splines, Kriging, and compactly supported
covariance functions for large data sets.")
    (license license:gpl2+)))

(define-public r-spatialextremes
  (package
    (name "r-spatialextremes")
    (version "2.1-0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "SpatialExtremes" version))
       (sha256
        (base32
         "0z1swxp1syz8hdskarjxx4sdd7wx835kcnb783bwqm235yh991j3"))))
    (properties
     `((upstream-name . "SpatialExtremes")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-fields r-maps))
    (home-page "http://spatialextremes.r-forge.r-project.org/")
    (synopsis "Modelling spatial extremes")
    (description
     "This package provides tools for the statistical modelling of spatial
extremes using max-stable processes, copula or Bayesian hierarchical models.
More precisely, this package allows (conditional) simulations from various
parametric max-stable models, analysis of the extremal spatial dependence, the
fitting of such processes using composite likelihoods or least square (simple
max-stable processes only), model checking and selection and prediction.")
    (license license:gpl2+)))

(define-public r-drc
  (package
    (name "r-drc")
    (version "3.0-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "drc" version))
       (sha256
        (base32
         "0c8xn8ripzq270hy8d16fcnx02l02alddznd7fqwk3jyi6113h1y"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-car
           r-gtools
           r-mass
           r-multcomp
           r-plotrix
           r-scales))
    (home-page "https://cran.r-project.org/web/packages/drc")
    (synopsis "Analysis of dose-response curves")
    (description
     "This package provides a suite of flexible and versatile model fitting
and after-fitting functions for the analysis of dose-response data.")
    (license license:gpl2+)))

(define-public r-rmeta
  (package
    (name "r-rmeta")
    (version "3.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rmeta" version))
       (sha256
        (base32
         "0vkbnxp579v8zmcv1isdbzj5swpr6fq17zwparxcvzswjc2x9ydr"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/rmeta")
    (synopsis "Tools for meta-analysis")
    (description
     "This package provides functions for simple fixed and random effects
meta-analysis for two-sample comparisons and cumulative meta-analyses.  It
draws standard summary plots, funnel plots, and computes summaries and tests
for association and heterogeneity.")
    (license license:gpl2)))

(define-public r-bootstrap
  (package
    (name "r-bootstrap")
    (version "2019.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bootstrap" version))
       (sha256
        (base32
         "1546jqhhw5h177ii8jkdikyd26rv6gwkav816np1zks4p7zgsljj"))))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/bootstrap")
    (synopsis "Functions for the book \"An Introduction to the Bootstrap\"")
    (description
     "This package provides software and data for the book \"An Introduction
to the Bootstrap\" by B. Efron and R. Tibshirani, 1993, Chapman and Hall.
This package is primarily provided for projects already based on it, and for
support of the book.  New projects should preferentially use the recommended
package \"boot\".")
    (license license:bsd-3)))

(define-public r-survivalroc
  (package
    (name "r-survivalroc")
    (version "1.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "survivalROC" version))
       (sha256
        (base32
         "0wnd65ff5w679hxa1zrpfrx9qg47q21pjxppsga6m3h4iq1yfj8l"))))
    (properties `((upstream-name . "survivalROC")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/survivalROC")
    (synopsis "Time-dependent ROC curve estimation from censored survival data")
    (description
     "Compute time-dependent ROC curve from censored survival data using
Kaplan-Meier (KM) or Nearest Neighbor Estimation (NNE) method of Heagerty,
Lumley & Pepe (Biometrics, Vol 56 No 2, 2000, PP 337-344)")
    (license license:gpl2+)))

(define-public r-locfdr
  (package
    (name "r-locfdr")
    (version "1.1-8")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "locfdr" version))
              (sha256
               (base32
                "1falkbp2xz07am8jlhwlvyqvxnli4nwl188kd0g58vdfjcjy3mj2"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/locfdr/")
    (synopsis "Computes local false discovery rates")
    (description "This package can be used to compute local false
discovery rates.")
    (license license:gpl2)))

(define-public r-longitudinal
  (package
    (name "r-longitudinal")
    (version "1.1.13")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "longitudinal" version))
       (sha256
        (base32
         "046w3xbr535c5jyd68adv42a7limxp1mv57b5w6w673w707lmw2p"))))
    (build-system r-build-system)
    (propagated-inputs (list r-corpcor))
    (home-page "http://strimmerlab.org/software/longitudinal/")
    (synopsis "Analysis of multiple time course data")
    (description
     "This package contains general data structures and functions for
longitudinal data with multiple variables, repeated measurements, and
irregularly spaced time points.  It also implements a shrinkage estimator of
dynamical correlation and dynamical covariance.")
    (license license:gpl3+)))

(define-public r-genenet
  (package
    (name "r-genenet")
    (version "1.2.16")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "GeneNet" version))
       (sha256
        (base32
         "1r1khga3nxxjghs4vnbymzp0cwb1q17zw2v3a94qz8fsrirq1sf1"))))
    (properties `((upstream-name . "GeneNet")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-corpcor r-fdrtool r-longitudinal))
    (home-page "http://strimmerlab.org/software/genenet/")
    (synopsis "Modeling and inferring gene networks")
    (description
     "This package analyzes gene expression (time series) data with focus on
the inference of gene networks.  In particular, GeneNet implements the methods
of Schaefer and Strimmer (2005a,b,c) and Opgen-Rhein and Strimmer (2006, 2007)
for learning large-scale gene association networks (including assignment of
putative directions).")
    (license license:gpl3+)))

(define-public r-rbamtools
  (package
    (name "r-rbamtools")
    (version "2.16.17")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rbamtools" version))
       (sha256
        (base32
         "0qj37ljdva3v29s01dkrbg31mcfzy3bl145cp40d54v4h9xhcghc"))))
    (build-system r-build-system)
    (inputs (list zlib))
    (propagated-inputs
     (list r-refgenome))
    (home-page "https://cran.r-project.org/web/packages/rbamtools")
    (synopsis "Read and write BAM (binary alignment) files")
    (description
     "This package provides an R interface to functions of the SAMtools
library.")
    (license license:artistic2.0)))

(define-public r-profvis
  (package
    (name "r-profvis")
    (version "0.3.7")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "profvis" version))
              (sha256
               (base32
                "1f86m426pcf90l29hf4hkirzf8f38dihk52bxbdq2gvrrdili5s3"))
              (modules '((guix build utils)))
              (snippet
               '(with-directory-excursion "inst/htmlwidgets/lib"
                  (for-each delete-file
                            (list "highlight/highlight.js" ;from rmarkdown
                                  "jquery/jquery.min.js" ;version 1.12.4
                                  "d3/d3.min.js")))))) ;version 3.5.6
    (properties `((upstream-name . "profvis")))
    (build-system r-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst/htmlwidgets/lib/"
               (copy-file
                (search-input-file
                 inputs "/site-library/rmarkdown/rmd/h/highlightjs/highlight.js")
                "highlight/highlight.js")
               (let ((mapping
                      `((,(assoc-ref inputs "js-jquery")
                         . "jquery/jquery.min.js")
                        (,(assoc-ref inputs "js-d3")
                         . "d3/d3.min.js"))))
                 (for-each (lambda (source target)
                             (format #true "Processing ~a --> ~a~%"
                                     source target)
                             (invoke "esbuild" source "--minify"
                                     (string-append "--outfile=" target)))
                           (map car mapping)
                           (map cdr mapping)))))))))
    (native-inputs
     `(("esbuild" ,esbuild)
       ("r-rmarkdown" ,r-rmarkdown)
       ("js-d3"
        ,(origin
           (method url-fetch)
           (uri "https://raw.githubusercontent.com/d3/d3/v3.5.6/d3.js")
           (sha256
            (base32
             "17qlbwn7vgx335gciq6zp2ib6zg1r9lfa6p1bd9g0ds0xbcsbvgd"))))
       ("js-jquery"
        ,(origin
           (method url-fetch)
           (uri "https://code.jquery.com/jquery-1.12.4.js")
           (sha256
            (base32
             "0x9mrc1668icvhpwzvgafm8xm11x9lfai9nwr66aw6pjnpwkc3s3"))))))
    (propagated-inputs (list r-htmlwidgets r-stringr))
    (home-page "https://rstudio.github.io/profvis/")
    (synopsis "Interactive visualizations for profiling R code")
    (description "This package provides interactive visualizations for
profiling R code.")
    (license license:gpl3)))

(define-public r-protviz
  (package
    (name "r-protviz")
    (version "0.7.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "protViz" version))
       (sha256
        (base32
         "0f6jwzcqi0w37hvg3i5dlk0c3anpkqh54ibf94vaf17r8sykr4nw"))))
    (properties `((upstream-name . "protViz")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (home-page "https://github.com/protViz/protViz/")
    (synopsis "Visualizing and analyzing mass spectrometry data in proteomics")
    (description
     "This package helps with quality checks, visualizations and analysis of
mass spectrometry data, coming from proteomics experiments.  The package is
developed, tested and used at the Functional Genomics Center Zurich, where it
is used mainly for prototyping, teaching, and having fun with proteomics data.
But it can also be used to do data analysis for small scale data sets.")
    (license license:gpl3)))

(define-public r-cmprsk
  (package
    (name "r-cmprsk")
    (version "2.2-11")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cmprsk" version))
       (sha256
        (base32 "050f24l5ab1ds9824c7yjahimf6pg8ih2k83jzpzfb0n5k5jfh44"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-survival))
    (native-inputs
     (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/cmprsk")
    (synopsis "Subdistribution analysis of competing risks")
    (description
     "This package provides tool for estimation, testing and regression
modeling of subdistribution functions in competing risks, as described in
Gray (1988), A class of K-sample tests for comparing the cumulative incidence
of a competing risk, Ann. Stat. 16:1141-1154, and Fine JP and Gray RJ (1999),
A proportional hazards model for the subdistribution of a competing risk,
JASA, 94:496-509.")
    (license license:gpl2+)))

(define-public r-etm
  (package
    (name "r-etm")
    (version "1.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "etm" version))
       (sha256
        (base32
         "1hvrplmdpjjpjji663rw0vjbbrzj2nvr04d1nkc8bf46p4ixyxgy"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-data-table r-lattice r-rcpp r-rcpparmadillo r-survival))
    (home-page "https://cran.r-project.org/web/packages/etm")
    (synopsis "Empirical transition matrix")
    (description
     "The @dfn{empirical transition matrix} (etm) package estimates
the matrix of transition probabilities for any time-inhomogeneous multistate
model with finite state space using the Aalen-Johansen estimator.")
    (license license:expat)))

(define-public r-epi
  (package
    (name "r-epi")
    (version "2.47")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Epi" version))
       (sha256
        (base32
         "1dkdx000cvy2rgxq3w6ppl3j9h7mwmcqg5xqsqh5hr3aks845pwx"))))
    (properties `((upstream-name . "Epi")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cmprsk
           r-data-table
           r-dplyr
           r-etm
           r-magrittr
           r-mass
           r-matrix
           r-mgcv
           r-numderiv
           r-plyr
           r-survival
           r-zoo))
    (home-page "https://BendixCarstensen.com/Epi/")
    (synopsis "Statistical analysis in epidemiology")
    (description
     "This package provides functions for demographic and epidemiological
analysis in the Lexis diagram, i.e. register and cohort follow-up data, in
particular representation, manipulation and simulation of multistate data -
the Lexis suite of functions, which includes interfaces to the @code{mstate},
@code{etm} and @code{cmprsk} packages.  It also contains functions for
Age-Period-Cohort and Lee-Carter modeling and a function for interval censored
data and some useful functions for tabulation and plotting, as well as a
number of epidemiological data sets.")
    (license license:gpl2)))

(define-public r-ppls
  (package
    (name "r-ppls")
    (version "1.6-1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ppls" version))
       (sha256
        (base32
         "1zyrisy3c4cz896j1bjh61sf57wdl9p8ywdq268cl819szfq78mx"))))
    (build-system r-build-system)
    (propagated-inputs (list r-mass))
    (home-page "https://cran.r-project.org/web/packages/ppls")
    (synopsis "Penalized partial least squares")
    (description
     "This package contains linear and nonlinear regression methods based on
partial least squares and penalization techniques.  Model parameters are
selected via cross-validation, and confidence intervals ans tests for the
regression coefficients can be conducted via jackknifing.")
    (license license:gpl2+)))

(define-public r-huge
  (package
    (name "r-huge")
    (version "1.3.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "huge" version))
       (sha256
        (base32 "1sl457a1lndrx98y2j9a2smanawx2iqlhl82iand0g3p5xp8ch4j"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-igraph r-mass r-matrix r-rcpp r-rcppeigen))
    (home-page "https://cran.r-project.org/web/packages/huge")
    (synopsis "High-dimensional undirected graph estimation")
    (description
     "This package provides a general framework for high-dimensional
undirected graph estimation.  It integrates data preprocessing, neighborhood
screening, graph estimation, and model selection techniques into a pipeline.")
    (license license:gpl2)))

(define-public r-parcor
  (package
    (name "r-parcor")
    (version "0.2-6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "parcor" version))
       (sha256
        (base32
         "0vgs6k92vdr0cmb8cwbv2ff6qavw30agskfd8bfh17hsskrisvx0"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-epi r-genenet r-glmnet r-mass r-ppls))
    (home-page "https://cran.r-project.org/web/packages/parcor")
    (synopsis "Regularized estimation of partial correlation matrices")
    (description
     "This package estimates the matrix of partial correlations based on
different regularized regression methods: lasso, adaptive lasso, PLS, and
Ridge Regression.  In addition, the package provides model selection for
lasso, adaptive lasso and Ridge regression based on cross-validation.")
    (license license:gpl2+)))

(define-public r-mcmc
  (package
    (name "r-mcmc")
    (version "0.9-7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mcmc" version))
       (sha256
        (base32
         "0q42m8ab7b6bxhns494ksjdss5f3c5m2jjfdlfj6fk1nz7ax7i5p"))))
    (build-system r-build-system)
    (home-page "https://www.stat.umn.edu/geyer/mcmc/")
    (synopsis "Markov chain Monte Carlo")
    (description
     "This package simulates continuous distributions of random vectors using
@dfn{Markov chain Monte Carlo} (MCMC).  Users specify the distribution by an R
function that evaluates the log unnormalized density.  Algorithms are random
walk Metropolis algorithm (function @code{metrop}), simulated
tempering (function @code{temper}), and morphometric random walk
Metropolis (function @code{morph.metrop}), which achieves geometric ergodicity
by change of variable.")
    (license license:expat)))

(define-public r-listenv
  (package
    (name "r-listenv")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "listenv" version))
       (sha256
        (base32
         "0ps8bk7zlhbviawrw7vw25skjq81hkk3ijyi6g74dmfqy8zsyapx"))))
    (build-system r-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (native-inputs
     (list r-r-rsp)) ; vignette builder
    (home-page "https://github.com/HenrikBengtsson/listenv")
    (synopsis "Environments behaving (almost) as lists")
    (description
     "This package implements list environments.  List environments are
environments that have list-like properties.  For instance, the elements of a
list environment are ordered and can be accessed and iterated over using index
subsetting.")
    (license license:lgpl2.1+)))

(define-public r-globals
  (package
    (name "r-globals")
    (version "0.16.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "globals" version))
       (sha256
        (base32
         "158y39qv99f1kc2i7w8d4lm2ls96plb43fzamz31im9xb9bkmxpp"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-codetools))
    (home-page "https://github.com/HenrikBengtsson/globals")
    (synopsis "Identify global objects in R expressions")
    (description
     "This package provides tools to identify global (\"unknown\" or \"free\")
objects in R expressions by code inspection using various strategies, e.g.
conservative or liberal.  The objective of this package is to make it as
simple as possible to identify global objects for the purpose of exporting
them in distributed compute environments.")
    (license license:lgpl2.1+)))

(define-public r-parallelly
  (package
    (name "r-parallelly")
    (version "1.32.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "parallelly" version))
       (sha256
        (base32
         "146a9i999vrflr4g1fph1pgkl4bq0dw102bjw8pp1zy7kbsqbiii"))))
    (properties `((upstream-name . "parallelly")))
    (build-system r-build-system)
    (home-page "https://github.com/HenrikBengtsson/parallelly")
    (synopsis "Enhancements of the parallel package")
    (description
     "This package provides utility functions that enhance the @code{parallel}
package and support the built-in parallel backends of the @code{future}
package.  For example, @code{availableCores} gives the number of CPU cores
available to your R process as given by R options and environment variables,
including those set by job schedulers on high-performance compute clusters.
If none is set, it will fall back to @code{parallel::detectCores}.  Another
example is @code{makeClusterPSOCK}, which is backward compatible with
@code{parallel::makePSOCKcluster} while doing a better job in setting up
remote cluster workers without the need for configuring the firewall to do
port-forwarding to your local computer.")
    (license license:lgpl2.1+)))

(define-public r-future
  (package
    (name "r-future")
    (version "1.28.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "future" version))
       (sha256
        (base32
         "1xhv0nf97yxxxsmxczyqqbnb4yn5sfn5vzvhm9dmw9csrmmadpbg"))))
    (build-system r-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (propagated-inputs
     (list r-digest r-globals r-listenv r-parallelly))
    (native-inputs
     (list r-r-rsp)) ; vignette builder
    (home-page "https://github.com/HenrikBengtsson/future")
    (synopsis "Unified parallel and distributed processing in R")
    (description
     "The purpose of this package is to provide a lightweight and unified
Future API for sequential and parallel processing of R expression via futures.
This package implements sequential, multicore, multisession, and cluster
futures.  With these, R expressions can be evaluated on the local machine, in
parallel a set of local machines, or distributed on a mix of local and remote
machines.  Extensions to this package implement additional backends for
processing futures via compute cluster schedulers etc.  Because of its unified
API, there is no need to modify any code in order to switch from sequential on
the local machine to, say, distributed processing on a remote compute cluster.")
    (license license:lgpl2.1+)))

(define-public r-future-apply
  (package
    (name "r-future-apply")
    (version "1.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "future.apply" version))
       (sha256
        (base32
         "0cr141mamjxby79sww02493yal9lahslvp3a3ic7f856rbawq8jg"))))
    (properties `((upstream-name . "future.apply")))
    (build-system r-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (propagated-inputs
     (list r-future r-globals))
    (native-inputs
     (list r-r-rsp)) ; vignette builder
    (home-page "https://github.com/HenrikBengtsson/future.apply")
    (synopsis "Apply function to elements in parallel using futures")
    (description
     "This package provides implementations of @code{apply()},
@code{eapply()}, @code{lapply()}, @code{Map()}, @code{mapply()},
@code{replicate()}, @code{sapply()}, @code{tapply()}, and @code{vapply()} that
can be resolved using any future-supported backend, e.g. parallel on the local
machine or distributed on a compute cluster.")
    (license license:gpl2+)))

(define-public r-rsvd
  (package
    (name "r-rsvd")
    (version "1.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rsvd" version))
       (sha256
        (base32
         "07p2hjmpcwcsang8z9sjkpy94rydcin7m3hyvcgzgm5cd6w8c1p4"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-matrix))
    (home-page "https://github.com/erichson/rSVD")
    (synopsis "Randomized singular value decomposition")
    (description
     "Low-rank matrix decompositions are fundamental tools and widely used for
data analysis, dimension reduction, and data compression.  Classically, highly
accurate deterministic matrix algorithms are used for this task.  However, the
emergence of large-scale data has severely challenged our computational
ability to analyze big data.  The concept of randomness has been demonstrated
as an effective strategy to quickly produce approximate answers to familiar
problems such as the @dfn{singular value decomposition} (SVD).  This package
provides several randomized matrix algorithms such as the randomized singular
value decomposition (@code{rsvd}), randomized principal component
analysis (@code{rpca}), randomized robust principal component
analysis (@code{rrpca}), randomized interpolative decomposition (@code{rid}),
and the randomized CUR decomposition (@code{rcur}).  In addition several plot
functions are provided.")
    (license license:gpl3+)))

(define-public r-sloop
  (package
    (name "r-sloop")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sloop" version))
       (sha256
        (base32
         "00fk5fr5zsk2qxc1kfhmshhjxgnamm3401089sx8m2l529zd6r8j"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-codetools r-crayon r-purrr r-rlang r-tibble))
    (home-page "https://github.com/r-lib/sloop")
    (synopsis "Helpers for object-oriented programming in R")
    (description
     "This package provides a collection of helper functions designed to
help you to better understand object oriented programming in R, particularly
using @code{S3}.")
    (license license:gpl3)))

(define-public r-capushe
  (package
    (name "r-capushe")
    (version "1.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "capushe" version))
       (sha256
        (base32
         "1aa76ir1kp67hiz7dr60azyc71yzslshyc640fjh0fpw0sp5kwbc"))))
    (build-system r-build-system)
    (propagated-inputs (list r-mass))
    (home-page "https://cran.r-project.org/web/packages/capushe/index.html")
    (synopsis "Calibrating penalties using slope heuristics")
    (description
     "This package provides tools for the calibration of penalized criteria
for model selection.  The calibration methods available are based on the slope
heuristics.")
    (license license:gpl2+)))

(define-public r-dorng
  (package
    (name "r-dorng")
    (version "1.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "doRNG" version))
       (sha256
        (base32
         "1jff27zzrvd1fd61x2m9468h8xn3s1c9f6wibviy5zdhj5dx9s9k"))))
    (properties `((upstream-name . "doRNG")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-foreach r-iterators r-rngtools))
    (home-page "https://renozao.github.io/doRNG/")
    (synopsis "Generic reproducible parallel backend for foreach loops")
    (description
     "This package provides functions to perform reproducible parallel
@code{foreach} loops, using independent random streams as generated by
L'Ecuyer's combined multiple-recursive generator.  It enables to easily
convert standard @code{%dopar%} loops into fully reproducible loops,
independently of the number of workers, the task scheduling strategy, or the
chosen parallel environment and associated foreach backend.")
    (license license:gpl2+)))

(define-public r-blockmodeling
  (package
    (name "r-blockmodeling")
    (version "1.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "blockmodeling" version))
       (sha256
        (base32
         "19mxmxsnl6rrh85p0sak91vcaw4dz2cnm70hdzfwnvdrr695yw2z"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-matrix))
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/blockmodeling")
    (synopsis "Generalized and classical blockmodeling of valued networks")
    (description
     "This package is primarily meant as an implementation of generalized
blockmodeling for valued networks.  In addition, measures of similarity or
dissimilarity based on structural equivalence and regular equivalence (REGE
algorithms) can be computed and partitioned matrices can be plotted.")
    (license license:gpl2+)))

(define-public r-upsetr
  (package
    (name "r-upsetr")
    (version "1.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "UpSetR" version))
       (sha256
        (base32
         "007i0njnjjy7vbrxabwav7a1kk2n0hn2mkvqsdzzfk10ckp5y7im"))))
    (properties `((upstream-name . "UpSetR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-gridextra r-plyr r-scales))
    (home-page "https://github.com/hms-dbmi/UpSetR")
    (synopsis "Visualize intersecting sets")
    (description
     "This package provides a more scalable alternative to Venn and Euler
diagrams for visualizing intersecting sets.  Create visualizations of
intersecting sets using a novel matrix design, along with visualizations of
several common set, element and attribute related tasks.")
    (license license:expat)))

;; This package includes a JavaScript file, which is not minified.  When
;; upgrading please check that there are no new minified JavaScript files.
(define-public r-shinybs
  (package
    (name "r-shinybs")
    (version "0.61.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shinyBS" version))
       (sha256
        (base32
         "0h51685a9qll4agayldjyryi60ih969219ibg071slv0613p5v8a"))))
    (properties `((upstream-name . "shinyBS")))
    (build-system r-build-system)
    ;; The tests spawn Shiny browser apps.  They cannot be run
    ;; non-interactively.
    (arguments '(#:tests? #f))
    (propagated-inputs
     (list r-htmltools r-shiny))
    (home-page "https://ebailey78.github.io/shinyBS/")
    (synopsis "Twitter Bootstrap components for Shiny")
    (description
     "This package adds additional Twitter Bootstrap components to Shiny.")
    (license license:gpl3)))

(define-public r-shinyjqui
  (package
    (name "r-shinyjqui")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shinyjqui" version))
       (sha256
        (base32
         "135gwz7syyb6pbn0lkvmq0v1c6r1zivavnqhi1rnzbbzlysi27v1"))
       (snippet
        '(for-each delete-file
                   (list "inst/www/shinyjqui.min.js"
                         "inst/www/jquery.ui.touch-punch.min.js")))))
    (properties `((upstream-name . "shinyjqui")))
    (build-system r-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst/www"
               (let ((mapping
                      `((,(string-append (assoc-ref inputs "js-jquery.ui.touch-punch")
                                         "/jquery.ui.touch-punch.js")
                         . "jquery.ui.touch-punch.min.js")
                        ("shinyjqui.js"
                         . "shinyjqui.min.js"))))
                 (for-each (lambda (source target)
                             (format #true "Processing ~a --> ~a~%"
                                     source target)
                             (invoke "esbuild" source "--minify"
                                     (string-append "--outfile=" target)))
                           (map car mapping)
                           (map cdr mapping)))))))))
    (propagated-inputs
     (list r-htmltools r-htmlwidgets r-jsonlite r-rlang r-shiny))
    (native-inputs
     `(("r-knitr" ,r-knitr)
       ("esbuild" ,esbuild)
       ("js-jquery.ui.touch-punch"
        ,(origin
           (method git-fetch)
           (uri (git-reference
                 (url "https://github.com/furf/jquery-ui-touch-punch")
                 (commit "8f7559b6e65cdc3ee3648d5fe76d38c653f87ff5")))
           (sha256
            (base32
             "1lzywp2q9hwx6d5fqjla95vp7ra2lahr5dam7lsqjmch9d98r48q"))))))
    (home-page "https://github.com/yang-tang/shinyjqui")
    (synopsis "jQuery UI interactions and effects for Shiny")
    (description
     "This is an extension to Shiny that brings interactions and animation
effects from the jQuery UI library.")
    (license license:expat)))

(define-public r-shinymanager
  (package
    (name "r-shinymanager")
    (version "1.0.410")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shinymanager" version))
       (sha256
        (base32 "0nl672dgwj34wm4i3pxk28lv6qw9xsgg3hm0h78q3zdgk8a33kdn"))))
    (properties `((upstream-name . "shinymanager")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-billboarder
           r-dbi
           r-dt
           r-htmltools
           r-openssl
           r-r-utils
           r-r6
           r-rsqlite
           r-scrypt
           r-shiny))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/datastorm-open/shinymanager")
    (synopsis "Authentication management for Shiny applications")
    (description
     "This package provides simple and secure authentication mechanism for
single Shiny applications.  Credentials are stored in an encrypted SQLite
database.")
    (license license:gpl3)))

(define-public r-outliers
  (package
    (name "r-outliers")
    (version "0.15")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "outliers" version))
       (sha256
        (base32
         "1yrmwvjjb0a6sbx940k9svf23cykcxz8rrwcgyic7lpgzbrdfcfc"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/outliers/index.html")
    (synopsis "Tests for outliers")
    (description
     "This package provides a collection of some tests commonly used for
identifying outliers.")
    (license license:gpl2+)))

(define-public r-bayesm
  (package
    (name "r-bayesm")
    (version "3.1-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bayesm" version))
       (sha256
        (base32 "154glks7rsjkza0sfi1kj7wj727py9sl1ba6sswflwmwc9n226q6"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp r-rcpparmadillo))
    (home-page "http://www.perossi.org/home/bsm-1")
    (synopsis "Bayesian inference for marketing/micro-econometrics")
    (description
     "This package covers many important models used in marketing and
micro-econometrics applications, including Bayes Regression (univariate or
multivariate dep var), Bayes Seemingly Unrelated Regression (SUR), Binary and
Ordinal Probit, Multinomial Logit (MNL) and Multinomial Probit (MNP),
Multivariate Probit, Negative Binomial (Poisson) Regression, Multivariate
Mixtures of Normals (including clustering), Dirichlet Process Prior Density
Estimation with normal base, Hierarchical Linear Models with normal prior and
covariates, Hierarchical Linear Models with a mixture of normals prior and
covariates, Hierarchical Multinomial Logits with a mixture of normals prior
and covariates, Hierarchical Multinomial Logits with a Dirichlet Process prior
and covariates, Hierarchical Negative Binomial Regression Models, Bayesian
analysis of choice-based conjoint data, Bayesian treatment of linear
instrumental variables models, Analysis of Multivariate Ordinal survey data
with scale usage heterogeneity, and Bayesian Analysis of Aggregate Random
Coefficient Logit Models.")
    (license license:gpl2+)))

(define-public r-tensora
  (package
    (name "r-tensora")
    (version "0.36.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tensorA" version))
       (sha256
        (base32
         "19wwh654qlja4z1n7afjpzsrrm53p8ddysa2vra5mdnkddb4g2cf"))))
    (properties `((upstream-name . "tensorA")))
    (build-system r-build-system)
    (home-page "http://www.stat.boogaart.de/tensorA")
    (synopsis "Advanced tensor arithmetic with named indices")
    (description
     "This package provides convenience functions for advanced linear algebra
with tensors and computation with datasets of tensors on a higher level
abstraction.  It includes Einstein and Riemann summing conventions, dragging,
co- and contravariate indices, and parallel computations on sequences of
tensors.")
    (license license:gpl2+)))

(define-public r-rarpack
  (package
    (name "r-rarpack")
    (version "0.11-0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rARPACK" version))
       (sha256
        (base32
         "12h2y46xcfldhjdmm960swgn9b23zvkj5vg2bi42s9qxwgi02d63"))))
    (properties `((upstream-name . "rARPACK")))
    (build-system r-build-system)
    (propagated-inputs (list r-rspectra))
    (home-page "https://github.com/yixuan/rARPACK")
    (synopsis "Solvers for large scale eigenvalue and SVD problems")
    (description
     "This package was previously an R wrapper of the ARPACK library, and now
a shell of the R package RSpectra, an R interface to the Spectra library for
solving large scale eigenvalue/vector problems.  The current version of
rARPACK simply imports and exports the functions provided by RSpectra.  New
users of rARPACK are advised to switch to the RSpectra package.")
    (license license:bsd-3)))

(define-public r-compositions
  (package
    (name "r-compositions")
    (version "2.0-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "compositions" version))
       (sha256
        (base32
         "1bqg0qqzsf92q0jb7hdjycr54bwv8rk7ajhvxgch5yslyqxpm73v"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bayesm r-mass r-robustbase r-tensora))
    (native-inputs
     (list r-knitr))
    (home-page "http://www.stat.boogaart.de/compositions")
    (synopsis "Compositional data analysis")
    (description
     "This package provides functions for the consistent analysis of
compositional data (e.g. portions of substances) and positive
numbers (e.g. concentrations).")
    (license license:gpl2+)))

(define-public r-cobs
  (package
    (name "r-cobs")
    (version "1.3-5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cobs" version))
       (sha256
        (base32
         "04f6a6gp11p93j2k35mbrfqgjx5qsgi3dj1085a5v5s0z6l7vbkz"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-quantreg r-sparsem))
    (home-page "https://cran.r-project.org/web/packages/cobs")
    (synopsis "Constrained B-Splines (sparse matrix based)")
    (description
     "This package provides qualitatively constrained (regression) smoothing
splines via linear programming and sparse matrices.")
    (license license:gpl2+)))

(define-public r-drimpute
  (package
    (name "r-drimpute")
    (version "1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "DrImpute" version))
       (sha256
        (base32
         "1adzarrwqb282pqgx2yqswp9rpwd1naxsmar54kddr6qyd6b923b"))))
    (properties `((upstream-name . "DrImpute")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp r-rcpparmadillo))
    (home-page "https://github.com/ikwak2/DrImpute")
    (synopsis "Imputing dropout events in single-cell RNA-Seq data")
    (description
     "This is an R package for imputing dropout events.  Many statistical
methods in cell type identification, visualization and lineage reconstruction
do not account for dropout events.  DrImpute can improve the performance of
such software by imputing dropout events.")
    (license license:gpl3)))

(define-public r-gamlss-dist
  (package
    (name "r-gamlss-dist")
    (version "6.0-5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gamlss.dist" version))
       (sha256
        (base32 "03m275qvrmpzmc10hs48277kxp503riz8sz6xk9pkpj8n7gsz20g"))))
    (properties `((upstream-name . "gamlss.dist")))
    (build-system r-build-system)
    (propagated-inputs (list r-mass))
    (home-page "http://www.gamlss.org/")
    (synopsis "Distributions for Generalized Additive Models for location scale and shape")
    (description
     "This package provides a set of distributions which can be used for
modelling the response variables in Generalized Additive Models for Location
Scale and Shape.  The distributions can be continuous, discrete or mixed
distributions.  Extra distributions can be created, by transforming, any
continuous distribution defined on the real line, to a distribution defined on
ranges 0 to infinity or 0 to 1, by using a @code{log} or a @code{logit}
transformation, respectively.")
    ;; Either version of the GPL.
    (license (list license:gpl2 license:gpl3))))

;; This package includes JavaScript files, which are not minified.  When
;; upgrading please check that there are no new minified JavaScript files.
(define-public r-shinyjs
  (package
    (name "r-shinyjs")
    (version "2.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shinyjs" version))
       (sha256
        (base32
         "1id9gsrkr28xl80a8794in17rxmmz06zqvd5hlns7mqz3fzhrhky"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-digest r-jsonlite r-shiny))
    (native-inputs
     (list r-knitr))
    (home-page "https://deanattali.com/shinyjs")
    (synopsis "Improve the user experience of your Shiny apps")
    (description
     "Perform common useful JavaScript operations in Shiny apps that will
greatly improve your apps without having to know any JavaScript.  Examples
include: hiding an element, disabling an input, resetting an input back to its
original value, delaying code execution by a few seconds, and many more useful
functions for both the end user and the developer.  Shinyjs can also be used
to easily call your own custom JavaScript functions from R.")
    (license license:agpl3+)))

;; This package includes minified JavaScript files.  When upgrading please
;; check that there are no new minified JavaScript files.
(define-public r-colourpicker
  (package
    (name "r-colourpicker")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "colourpicker" version))
       (sha256
        (base32
         "12k3m2s49pc1p2hzd4zqqzzdf94q7hhqz7zgp8w908a6w3p80b5w"))))
    (build-system r-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst"
               (let ((mapping
                      `((,(assoc-ref inputs "js-salvattore")
                         . "examples/colourInput/www/salvattore.min.js")
                        (,(assoc-ref inputs "js-jquery")
                         . "htmlwidgets/lib/jquery/jquery.min.js")
                        ("www/shared/colourpicker/js/colourpicker.js"
                         . "www/shared/colourpicker/js/colourpicker.min.js"))))
                 (for-each (lambda (source target)
                             (format #true "Processing ~a --> ~a~%"
                                     source target)
                             (delete-file target)
                             (invoke "esbuild" source "--minify"
                                     (string-append "--outfile=" target)))
                           (map car mapping)
                           (map cdr mapping)))))))))
    (propagated-inputs
     (list r-ggplot2
           r-htmltools
           r-htmlwidgets
           r-jsonlite
           r-miniui
           r-shiny
           r-shinyjs))
    (native-inputs
     `(("esbuild" ,esbuild)
       ("js-jquery"
        ,(origin
           (method url-fetch)
           (uri "https://code.jquery.com/jquery-3.6.1.js")
           (sha256
            (base32
             "1lm4zcpvqdi7qi2s7bgci2z74wazq0z0bdvjmlrqbhmfrpk42ffz"))))
       ("js-salvattore"
        ,(origin
           (method url-fetch)
           (uri "https://raw.githubusercontent.com/rnmp/salvattore/v1.0.9/dist/salvattore.js")
           (sha256
            (base32
             "0lfrbx7l9w5x89jpc6njmd0pk7h8fpvg537vklai2vf7b1r2nnk5"))))))
    (home-page "https://github.com/daattali/colourpicker")
    (synopsis "Color picker tool for Shiny and for selecting colors in plots")
    (description
     "This package provides a color picker that can be used as an input in
Shiny apps or Rmarkdown documents.  The color picker supports alpha opacity,
custom color palettes, and many more options.  A plot color helper tool is
available as an RStudio Addin, which helps you pick colors to use in your
plots.  A more generic color picker RStudio Addin is also provided to let you
select colors to use in your R code.")
    (license license:expat)))

(define-public r-ggextra
  (package
    (name "r-ggextra")
    (version "0.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggExtra" version))
       (sha256
        (base32
         "1rd3qv6ah3zphr1jicjhgxms73vi496mjnxnsrcgl7z8nyxmas6w"))))
    (properties `((upstream-name . "ggExtra")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-colourpicker
           r-ggplot2
           r-gtable
           r-miniui
           r-r6
           r-scales
           r-shiny
           r-shinyjs))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/daattali/ggExtra")
    (synopsis "Marginal histograms for ggplot2 and other enhancements")
    (description
     "This package is a collection of functions and layers to enhance ggplot2.
The flagship function is @code{ggMarginal()}, which can be used to add
marginal histograms/boxplots/density plots to ggplot2 scatterplots.")
    (license license:expat)))

(define-public r-minpack-lm
  (package
    (name "r-minpack-lm")
    (version "1.2-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "minpack.lm" version))
       (sha256
        (base32
         "11yz6hk2r33571d16kq01cb1x6sgdzi6jmksqlrm8mr84l95c2f7"))))
    (properties `((upstream-name . "minpack.lm")))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/minpack.lm")
    (synopsis "Levenberg-Marquardt Nonlinear Least-Squares algorithm")
    (description
     "The @code{nls.lm} function provides an R interface to @code{lmder} and
@code{lmdif} from the MINPACK library, for solving nonlinear least-squares
problems by a modification of the Levenberg-Marquardt algorithm, with support
for lower and upper parameter bounds.  The implementation can be used via
@code{nls}-like calls using the @code{nlsLM} function.")
    (license license:gpl3)))

(define-public r-moments
  (package
    (name "r-moments")
    (version "0.14.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "moments" version))
       (sha256
        (base32
         "0r6qf3i1rzh2822bx1p0h8mh91gsbgg6asl2rzh2l4ys094bilif"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/moments")
    (synopsis "Moments, cumulants, skewness, kurtosis and related tests")
    (description
     "This package provides functions to calculate: moments, Pearson's
kurtosis, Geary's kurtosis and skewness; it also includes tests related to
them (Anscombe-Glynn, D'Agostino, Bonett-Seier).")
    (license license:gpl2+)))

(define-public r-msir
  (package
    (name "r-msir")
    (version "1.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "msir" version))
       (sha256
        (base32
         "1wm83m3cqd6llxb9p2jwim0wb81v84pgdmgcznygzaaq6kbn3n84"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mclust))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/msir")
    (synopsis "Model-based sliced inverse regression")
    (description
     "This is an R package for dimension reduction based on finite Gaussian
mixture modeling of inverse regression.")
    (license license:gpl2+)))

(define-public r-pbivnorm
  (package
    (name "r-pbivnorm")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pbivnorm" version))
       (sha256
        (base32
         "05jzrjqxzbcf6z245hlk7sjxiszv9paadaaimvcx5y5qgi87vhq7"))))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://github.com/brentonk/pbivnorm")
    (synopsis "Vectorized bivariate normal CDF")
    (description
     "This package provides a vectorized R function for calculating
probabilities from a standard bivariate normal CDF.")
    (license license:gpl2+)))

(define-public r-lavaan
  (package
    (name "r-lavaan")
    (version "0.6-12")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lavaan" version))
       (sha256
        (base32
         "17h79pnww1mihvlp6ap0r6d8wnly9bwszj13l5dkby0284z2fj40"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mass r-mnormt r-numderiv r-pbivnorm))
    (home-page "https://lavaan.ugent.be")
    (synopsis "Latent variable analysis")
    (description
     "This package provides tools to fit a variety of latent variable models,
including confirmatory factor analysis, structural equation modeling and
latent growth curve models.")
    (license license:gpl2+)))

(define-public r-nonnest2
  (package
    (name "r-nonnest2")
    (version "0.5-5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "nonnest2" version))
       (sha256
        (base32
         "1ddaqwx8i3ygwvxf11mc8xhgk4nkvnail99nr5szq8i168752zq2"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-compquadform r-lavaan r-mvtnorm r-sandwich))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/nonnest2/")
    (synopsis "Tests of non-nested models")
    (description
     "This package allows for testing of non-nested models.  It includes tests
of model distinguishability and of model fit that can be applied to both
nested and non-nested models.  The package also includes functionality to
obtain confidence intervals associated with AIC and BIC.")
    ;; Either version of the GPL.
    (license (list license:gpl2 license:gpl3))))

(define-public r-penalized
  (package
    (name "r-penalized")
    (version "0.9-52")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "penalized" version))
       (sha256
        (base32
         "08badmgygppbqzay20qijyww028yw6s8dyd8ijcp8g4r9rn8xqyq"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp r-rcpparmadillo r-survival))
    (home-page "https://cran.r-project.org/web/packages/penalized/")
    (synopsis "Penalized estimation in GLMs and in the Cox model")
    (description
     "This package provides tools for fitting possibly high dimensional
penalized regression models.  The penalty structure can be any combination of
an L1 penalty (lasso and fused lasso), an L2 penalty (ridge) and a positivity
constraint on the regression coefficients.  The supported regression models
are linear, logistic and Poisson regression and the Cox Proportional Hazards
model.  Cross-validation routines allow optimization of the tuning
parameters.")
    (license license:gpl2+)))

(define-public r-zim
  (package
    (name "r-zim")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ZIM" version))
       (sha256
        (base32
         "0scyfjn4ilsvha3x41c3b8bcfi31hlhwm77wn2a8hj5dsvnnmzig"))))
    (properties `((upstream-name . "ZIM")))
    (build-system r-build-system)
    (propagated-inputs (list r-mass))
    (home-page "https://github.com/biostatstudio/ZIM")
    (synopsis "Zero-inflated models (ZIM) for count time series with excess zeros")
    (description
     "Analyze count time series with excess zeros.  Two types of statistical
models are supported: Markov regression and state-space models.  They are also
known as observation-driven and parameter-driven models respectively in the
time series literature.  The functions used for Markov regression or
observation-driven models can also be used to fit ordinary regression models
with independent data under the zero-inflated Poisson (ZIP) or zero-inflated
negative binomial (ZINB) assumption.  The package also contains miscellaneous
functions to compute density, distribution, quantile, and generate random
numbers from ZIP and ZINB distributions.")
    (license license:gpl3)))

(define-public r-nor1mix
  (package
    (name "r-nor1mix")
    (version "1.3-0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "nor1mix" version))
       (sha256
        (base32
         "1817wcvlmxs70vs4db0jkxd7i037744zz8ay3c2a9949z29fxr4w"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/nor1mix/")
    (synopsis "Normal (1-d) mixture models")
    (description
     "This package provides S3 classes and methods for one-dimensional normal
mixture models, for, e.g., density estimation or clustering algorithms
research and teaching; it provides the widely used Marron-Wand densities.  It
also provides tools for efficient random number generation and graphics.")
    (license license:gpl2+)))

(define-public r-beanplot
  (package
    (name "r-beanplot")
    (version "1.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "beanplot" version))
       (sha256
        (base32
         "1b8mvlcsv5l9g08ag92hndsvk8jmgxvznhzgazc8y4296kp8l5a9"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/beanplot/")
    (synopsis "Visualization via beanplots")
    (description
     "This package provides beanplots, an alternative to
boxplot/stripchart/violin plots.  It can be used to plot univariate comparison
graphs.")
    (license license:gpl2)))

(define-public r-pbdzmq
  (package
    (name "r-pbdzmq")
    (version "0.3-8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pbdZMQ" version))
       (sha256
        (base32
         "0rala2aqyva4cjpih8xbqq1nxhwfgbkcdwb1c3h5jjp5dv7lrvgd"))))
    (properties `((upstream-name . "pbdZMQ")))
    (build-system r-build-system)
    (inputs
     (list zeromq zlib))
    (native-inputs
     (list pkg-config))
    (home-page "https://pbdr.org/")
    (synopsis "R interface to ZeroMQ")
    (description
     "ZeroMQ is a well-known library for high-performance asynchronous
messaging in scalable, distributed applications.  This package provides high
level R wrapper functions to easily utilize ZeroMQ.  The main focus is on
interactive client/server programming frameworks.  A few wrapper functions
compatible with @code{rzmq} are also provided.")
    (license license:gpl3)))

(define-public r-repr
  (package
    (name "r-repr")
    (version "1.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "repr" version))
       (sha256
        (base32
         "0h3h14ybamcbwmm31ib66fx13v75vkzn4bn2v26n2h097sl9qybg"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-base64enc r-htmltools r-jsonlite r-pillar))
    (home-page "https://cran.r-project.org/web/packages/repr/")
    (synopsis "Serializable representations")
    (description
     "This package provides string and binary representations of objects for
several formats and MIME types.")
    (license license:gpl3)))

(define-public r-irdisplay
  (package
    (name "r-irdisplay")
    (version "1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "IRdisplay" version))
       (sha256
        (base32
         "0awdiv4rr93y8jb1d64sm1iy37ywyniqm7w98yv6qm0zz47h7sw3"))))
    (properties `((upstream-name . "IRdisplay")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-repr))
    (home-page "https://cran.r-project.org/web/packages/IRdisplay/")
    (synopsis "Jupyter display machinery")
    (description
     "This package provides an interface to the rich display capabilities of
Jupyter front-ends (e.g. Jupyter Notebook).  It is designed to be used from a
running IRkernel session.")
    (license license:expat)))

(define-public r-irkernel
  (package
    (name "r-irkernel")
    (version "1.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "IRkernel" version))
       (sha256
        (base32
         "00qrmsywpzw2hfp88020zjaijma7q4hqm9h2cz53rywdjzywnzss"))))
    (properties `((upstream-name . "IRkernel")))
    (build-system r-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'install 'install-kernelspec
           (lambda* (#:key outputs #:allow-other-keys)
             (let ((out (assoc-ref outputs "out")))
               (setenv "HOME" "/tmp")
               (invoke "jupyter" "kernelspec" "install"
                       "--name" "ir"
                       "--prefix" out
                       (string-append out "/site-library/IRkernel/kernelspec"))
               ;; Record the absolute file name of the 'R' executable in
               ;; 'kernel.json'.
               (substitute* (string-append out "/share/jupyter"
                                           "/kernels/ir/kernel.json")
                 (("\\[\"R\",")
                  (string-append "[\"" (which "R") "\",")))
               #t))))))
    (inputs
     (list jupyter))
    (propagated-inputs
     (list r-crayon
           r-digest
           r-evaluate
           r-irdisplay
           r-jsonlite
           ;; sets R_LIBS_SITE, so R can actually find this package (IRkernel)
           r-minimal
           r-pbdzmq
           r-repr
           r-uuid))
    (home-page "https://cran.r-project.org/web/packages/IRkernel/")
    (synopsis "Native R kernel for Jupyter")
    (description
     "The R kernel for the Jupyter environment executes R code which the
front-end (Jupyter Notebook or other front-ends) submits to the kernel via the
network.")
    (license license:expat)))

(define-public r-gmodels
  (package
    (name "r-gmodels")
    (version "2.18.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gmodels" version))
       (sha256
        (base32
         "158y7yh4maawn9vki8cq4sil48xib2bbpl6qgj5gvlkw3c14hzfs"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-gdata r-mass))
    (home-page "https://cran.r-project.org/web/packages/gmodels/")
    (synopsis "Various R programming tools for model fitting")
    (description
     "This package provides various R programming tools for model fitting.")
    (license license:gpl2)))

(define-public r-apcluster
  (package
    (name "r-apcluster")
    (version "1.4.10")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "apcluster" version))
       (sha256
        (base32
         "1820j1xjlbmw6j2fwwv2g806dqpk5qrbbaqsrbrn6igql8pzf552"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-matrix r-rcpp))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/apcluster/")
    (synopsis "Affinity propagation clustering")
    (description
     "This package implements affinity propagation clustering introduced by
Frey and Dueck (2007).  The package further provides leveraged affinity
propagation and an algorithm for exemplar-based agglomerative clustering that
can also be used to join clusters obtained from affinity propagation.  Various
plotting functions are available for analyzing clustering results.")
    (license license:gpl2+)))

(define-public r-rematch2
  (package
    (name "r-rematch2")
    (version "2.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rematch2" version))
       (sha256
        (base32
         "1fzpz8vhghw8ygwg6rsvfy3783pqk7ch029i5851lwypkplvz77y"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-tibble))
    (home-page "https://github.com/r-lib/rematch2")
    (synopsis "Tidy output from regular expression matching")
    (description
     "This package provides wrappers on @code{regexpr} and @code{gregexpr} to
return the match results in tidy data frames.")
    (license license:expat)))

(define-public r-picante
  (package
    (name "r-picante")
    (version "1.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "picante" version))
       (sha256
        (base32
         "19savjzj44b7ifdxcp02ynj22z4n4ikq2aipc74ljzy3yykmqmjn"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ape r-nlme r-vegan))
    (home-page "https://cran.r-project.org/web/packages/picante/")
    (synopsis "Integrating phylogenies and ecology")
    (description
     "This package provides functions for phylocom integration, community
analyses, null-models, traits and evolution.  It implements numerous
ecophylogenetic approaches including measures of community phylogenetic and
trait diversity, phylogenetic signal, estimation of trait values for
unobserved taxa, null models for community and phylogeny randomizations, and
utility functions for data input/output and phylogeny plotting.  A full
description of package functionality and methods are provided by Kembel et
al. (2010).")
    (license license:gpl2)))

(define-public r-reinforcelearn
  (package
    (name "r-reinforcelearn")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "reinforcelearn" version))
       (sha256
        (base32
         "176z2q69p24i29a8sh19xxn2zl3h1z2ixdssr5i6m4yvkvdrvv3b"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-checkmate r-nnet r-purrr r-r6))
    (home-page "https://markusdumke.github.io/reinforcelearn")
    (synopsis "Reinforcement learning")
    (description
     "This package implements reinforcement learning environments and
algorithms as described in Sutton & Barto (1998).  The Q-Learning algorithm
can be used with function approximation, eligibility traces (Singh & Sutton,
1996) and experience replay (Mnih et al., 2013).")
    (license license:expat)))

(define-public r-lemon
  (package
    (name "r-lemon")
    (version "0.4.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lemon" version))
       (sha256
        (base32
         "1y3ljidhqdakxlya2npj2w0az820g8kw6gl1cfm4f0cxvzgd1ly4"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2
           r-gridextra
           r-gtable
           r-knitr
           r-lattice
           r-plyr
           r-rlang
           r-scales))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/stefanedwards/lemon")
    (synopsis "Freshen up your ggplot2 plots")
    (description
     "This package provides functions for working with legends and axis lines
of ggplot2, facets that repeat axis lines on all panels, and some knitr
extensions.")
    (license license:gpl3)))

(define-public r-wgaim
  (package
    (name "r-wgaim")
    (version "2.0-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "wgaim" version))
       (sha256
        (base32 "1qiyfkpsbzjr9xsq5kqq6rlqpndngkn2irdfh3gyi45h6hn118j4"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-qtl))
    (home-page "https://cran.r-project.org/web/packages/wgaim")
    (synopsis "Whole genome average interval mapping for QTL detection")
    (description
     "This package integrates sophisticated mixed modelling methods with a
whole genome approach to detecting significant QTL in linkage maps.")
    (license license:gpl2+)))

(define-public r-bedr
  (package
    (name "r-bedr")
    (version "1.0.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bedr" version))
       (sha256
        (base32
         "0zpqvyjgwyqawxm8qrhcv8zq2b3yxgcqkkc87br29yrl7sjb8h6j"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-data-table
           r-r-utils
           r-testthat
           r-venndiagram
           r-yaml
           bedops
           bedtools
           htslib)) ; for tabix
    (native-inputs
     (list r-knitr)) ; for vignettes
    (home-page "https://cran.r-project.org/web/packages/bedr")
    (synopsis "Genomic region processing")
    (description
     "This package is for genomic regions processing using command line tools
such as BEDTools, BEDOPS and Tabix.  These tools offer scalable and efficient
utilities to perform genome arithmetic e.g indexing, formatting and merging.
The bedr package's API enhances access to these tools as well as offers
additional utilities for genomic regions processing.")
    (license license:gpl2)))

(define-public r-sets
  (package
    (name "r-sets")
    (version "1.0-21")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sets" version))
       (sha256
        (base32
         "1h1a03b1850kh5hd3gxbspx2nxqxvk2gb0wm0s60b70qb6zg0csp"))))
    (properties `((upstream-name . "sets")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/sets")
    (synopsis "Sets, generalized sets, customizable sets and intervals")
    (description
     "This package provides data structures and basic operations for ordinary
sets, generalizations such as fuzzy sets, multisets, and fuzzy multisets,
customizable sets, and intervals.")
    (license license:gpl2)))

(define-public r-partitions
  (package
    (name "r-partitions")
    (version "1.10-7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "partitions" version))
       (sha256
        (base32
         "1kxiy1wl7dr39kyfg2y9hd67s32knd83r2jsb7j9p3vg8iqq7yqb"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-gmp r-mathjaxr r-polynom r-rdpack r-sets))
    (home-page "https://cran.r-project.org/web/packages/partitions")
    (synopsis "Additive partitions of integers")
    (description
     "This package provides tools to enumerates the partitions, unequal
partitions, and restricted partitions of an integer; the three corresponding
partition functions are also given.")
    ;; Any version of the GPL
    (license license:gpl2+)))

(define-public r-brobdingnag
  (package
    (name "r-brobdingnag")
    (version "1.2-9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Brobdingnag" version))
       (sha256
        (base32
         "07p9416rdzfyiigbglxjpbcg7pfly9nw19yn2mwg98621cjjs0gr"))))
    (properties `((upstream-name . "Brobdingnag")))
    (build-system r-build-system)
    (propagated-inputs (list r-matrix))
    (home-page "https://github.com/RobinHankin/Brobdingnag.git")
    (synopsis "Very large numbers in R")
    (description
     "This package handles very large numbers in R.  Real numbers are held
using their natural logarithms, plus a logical flag indicating sign.  The
package includes a vignette that gives a step-by-step introduction to using S4
methods.")
    ;; Any version of the GPL
    (license license:gpl2+)))

(define-public r-untb
  (package
    (name "r-untb")
    (version "1.7-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "untb" version))
       (sha256
        (base32
         "1i7m4vfslsix98dwx4jlrsldm7fhhfp25gr7aapcxqxms7ryaby6"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-brobdingnag r-partitions r-polynom))
    (home-page "https://github.com/RobinHankin/untb.git")
    (synopsis "Ecological drift under the UNTB")
    (description
     "This package provides numerical simulations, and visualizations, of
Hubbell's @dfn{Unified Neutral Theory of Biodiversity} (UNTB).")
    (license license:gpl2+)))

(define-public r-stepwise
  (package
    (name "r-stepwise")
    (version "0.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "stepwise" version))
       (sha256
        (base32
         "1lbx1bxwkf9dw6q46w40pp7h5nkxgghmx8rkpaymm6iybc7gyir2"))))
    (build-system r-build-system)
    (home-page "https://stat.sfu.ca/statgen/research/stepwise.html")
    (synopsis "Stepwise detection of recombination breakpoints")
    (description
     "This package provides a stepwise approach to identifying recombination
breakpoints in a genomic sequence alignment.")
    (license license:gpl2+)))

(define-public r-snpmaxsel
  (package
    (name "r-snpmaxsel")
    (version "1.0-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "SNPmaxsel" version))
       (sha256
        (base32
         "0pjvixwqzjd3jwccc8yqq9c76afvbmfq0z1w0cwyj8bblrjpx13z"))))
    (properties `((upstream-name . "SNPmaxsel")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-combinat r-mvtnorm))
    (home-page "https://cran.r-project.org/web/packages/SNPmaxsel/index.html")
    (synopsis "Maximally selected statistics for SNP data")
    (description
     "This package implements asymptotic methods related to maximally selected
statistics, with applications to @dfn{single-nucleotide polymorphism} (SNP)
data.")
    (license license:gpl2+)))

(define-public r-acsnminer
  (package
    (name "r-acsnminer")
    (version "0.16.8.25")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ACSNMineR" version))
              (sha256
               (base32
                "0gh604s8qall6zfjlwcg2ilxjvz08dplf9k5g47idhv43scm748l"))))
    (properties `((upstream-name . "ACSNMineR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-gridextra))
    (home-page "https://cran.r-project.org/web/packages/ACSNMineR")
    (synopsis "Gene enrichment analysis")
    (description
     "This package provides tools to compute and represent gene set enrichment
or depletion from your data based on pre-saved maps from the @dfn{Atlas of
Cancer Signalling Networks} (ACSN) or user imported maps.  The gene set
enrichment can be run with hypergeometric test or Fisher exact test, and can
use multiple corrections.  Visualization of data can be done either by
barplots or heatmaps.")
    (license license:gpl2+)))

(define-public r-seqinr
  (package
    (name "r-seqinr")
    (version "4.2-16")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "seqinr" version))
       (sha256
        (base32
         "0cj07b7km5mla63qhbkxg1mnqq6vh79lsyyfpnbm29gw68w2bwy4"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ade4 r-segmented))
    (inputs
     (list zlib))
    (home-page "http://seqinr.r-forge.r-project.org/")
    (synopsis "Biological sequences retrieval and analysis")
    (description
     "This package provides tools for exploratory data analysis and data
visualization of biological sequence (DNA and protein) data.  It also includes
utilities for sequence data management under the ACNUC system.")
    (license license:gpl2+)))

(define-public r-units
  (package
    (name "r-units")
    (version "0.8-0")
    (source
      (origin
        (method url-fetch)
        (uri (cran-uri "units" version))
        (sha256
          (base32
            "06mjprqi06xprj6185k5cmrrdl025x0pd1r6a4x3s74ciq9zwilw"))))
    (build-system r-build-system)
    (inputs
     (list udunits))
    (propagated-inputs
     (list r-rcpp))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/r-quantities/units/")
    (synopsis "Measurement Units for R Vectors")
    (description
      "This package provides support for measurement units in R vectors,
matrices and arrays: automatic propagation, conversion, derivation and
simplification of units; raising errors in case of unit incompatibility.  It
is compatible with the @code{POSIXct}, @code{Date} and @code{difftime}
classes.")
    (license license:gpl2)))

(define-public r-udunits2
  (package
    (name "r-udunits2")
    (version "0.13.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "udunits2" version))
       (sha256
        (base32
         "00prsy8m41v1camcsz94d7gm8qab2mdnwl3x0dyhz4r49b02jm4z"))))
    (properties `((upstream-name . "udunits2")))
    (build-system r-build-system)
    (inputs
     (list udunits))
    (home-page "https://cran.r-project.org/package=udunits2")
    (synopsis "Udunits-2 bindings for R")
    (description
     "This package provides simple bindings to Unidata's udunits library.")
    (license license:gpl2)))

(define-public r-classint
  (package
    (name "r-classint")
    (version "0.4-8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "classInt" version))
       (sha256
        (base32
         "1csrrb93lzy1pajs91qd0vyvl218jyskcksa43xfrfvibdzn3sba"))))
    (properties `((upstream-name . "classInt")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-class r-e1071 r-kernsmooth))
    (native-inputs
     (list gfortran r-knitr))
    (home-page "https://github.com/r-spatial/classInt/")
    (synopsis "Choose univariate class intervals")
    (description
     "This package provides selected commonly used methods for choosing
univariate class intervals for mapping or other graphics purposes.")
    (license license:gpl2+)))

(define-public r-spdata
  (package
    (name "r-spdata")
    (version "2.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "spData" version))
       (sha256
        (base32
         "07whxr039cxvk2nn65jada3i8vqqw34lgca9j17ah8chy9r0m73f"))))
    (properties `((upstream-name . "spData")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-sp))
    (home-page "https://github.com/Nowosad/spData")
    (synopsis "Datasets for spatial analysis")
    (description
     "This a package containing diverse spatial datasets for demonstrating,
benchmarking and teaching spatial data analysis.  It includes R data of class
@code{sf}, @code{Spatial}, and @code{nb}.  It also contains data stored in a
range of file formats including GeoJSON, ESRI Shapefile and GeoPackage.  Some
of the datasets are designed to illustrate specific analysis techniques.
@code{cycle_hire()} and @code{cycle_hire_osm()}, for example, are designed to
illustrate point pattern analysis techniques.")
    (license license:cc0)))

(define-public r-learnbayes
  (package
    (name "r-learnbayes")
    (version "2.15.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "LearnBayes" version))
       (sha256
        (base32
         "0ch54v2zz2yyyk0lvn5rfikdmyz1qh9j1wk3585wl8v58mc0h4cv"))))
    (properties `((upstream-name . "LearnBayes")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/LearnBayes")
    (synopsis "Functions for learning Bayesian inference")
    (description
     "This package provides a collection of functions helpful in learning the
basic tenets of Bayesian statistical inference.  It contains functions for
summarizing basic one and two parameter posterior distributions and predictive
distributions.  It contains MCMC algorithms for summarizing posterior
distributions defined by the user.  It also contains functions for regression
models, hierarchical models, Bayesian tests, and illustrations of Gibbs
sampling.")
    (license license:gpl2+)))

(define-public r-deldir
  (package
    (name "r-deldir")
    (version "1.0-6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "deldir" version))
       (sha256
        (base32
         "1igq0l2knsbhizncgydcsidgkvvlwwlkrifbcdyhnzk0bhrdixkd"))))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/deldir")
    (synopsis "Delaunay triangulation and Dirichlet (Voronoi) tessellation")
    (description
     "This package provides tools for calculating the Delaunay triangulation
and the Dirichlet or Voronoi tessellation (with respect to the entire plane)
of a planar point set.  It plots triangulations and tessellations in various
ways, clips tessellations to sub-windows, calculates perimeters of
tessellations, and summarizes information about the tiles of the
tessellation.")
    (license license:gpl2+)))

(define-public r-wk
  (package
    (name "r-wk")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "wk" version))
       (sha256
        (base32
         "1pm2293xqcgjckghbf6q9sk7jh74njiynq3wqq1dbwigiz9jfhz2"))))
    (properties `((upstream-name . "wk")))
    (build-system r-build-system)
    (home-page "https://paleolimbot.github.io/wk/")
    (synopsis "Lightweight well-known geometry parsing")
    (description
     "This package provides a minimal R and C++ API for parsing well-known
binary and well-known text representation of geometries to and from R-native
formats.  Well-known binary is compact and fast to parse; well-known text is
human-readable and is useful for writing tests.  These formats are only useful
in R if the information they contain can be accessed in R, for which
high-performance functions are provided here.")
    (license license:expat)))

(define-public r-s2
  (package
    (name "r-s2")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "s2" version))
       (sha256
        (base32
         "05n459rp5b1wk826sq3c5d2z1xwgkpfp8m1jnfshvs4gadlfkap3"))))
    (properties `((upstream-name . "s2")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      `(modify-phases %standard-phases
         ;; We don't want to convert -lssl to -l:libssl.so.1.1; there is only
         ;; one libssl.so anyway and the -l:* thing breaks linking.
         (add-after 'unpack 'undo-library-versioning
           (lambda _
             (substitute* "configure"
               (("PKG_LIBS_VERSIONED=.*")
                "PKG_LIBS_VERSIONED=\"${PKG_LIBS}\"\n")))))))
    (propagated-inputs
     (list r-rcpp r-wk))
    (inputs
     (list openssl))
    (native-inputs
     (list pkg-config))
    (home-page "https://r-spatial.github.io/s2/")
    (synopsis "Spherical geometry operators using the S2 geometry library")
    (description
     "This package provides R bindings for Google's s2 library for geometric
calculations on the sphere.  High-performance constructors and exporters
provide high compatibility with existing spatial packages, transformers
construct new geometries from existing geometries, predicates provide a means
to select geometries based on spatial relationships, and accessors extract
information about geometries.")
    (license license:asl2.0)))

(define-public r-sf
  (package
    (name "r-sf")
    (version "1.0-8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sf" version))
       (sha256
        (base32
         "0cl7m47ar3iw95rpwpmjl23frdbscxa15q39mlzmwswxwy871p1x"))))
    (build-system r-build-system)
    (inputs
     (list gdal geos proj sqlite zlib))
    (propagated-inputs
     (list r-classint
           r-dbi
           r-magrittr
           r-rcpp
           r-s2
           r-units))
    (native-inputs
     (list pkg-config r-knitr))
    (home-page "https://github.com/r-spatial/sf/")
    (synopsis "Simple features for R")
    (description
     "This package provides support for simple features, a standardized way to
encode spatial vector data.  It binds to GDAL for reading and writing data, to
GEOS for geometrical operations, and to PROJ for projection conversions and
datum transformations.")
    ;; Either of these licenses
    (license (list license:gpl2 license:expat))))

(define-public r-sftime
  (package
    (name "r-sftime")
    (version "0.2-0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "sftime" version))
              (sha256
               (base32
                "1ymi60ag8kqb3293bdcvb83zwsgrz000ylifjvlpzzmh1xsisanq"))))
    (properties `((upstream-name . "sftime")))
    (build-system r-build-system)
    (propagated-inputs (list r-sf))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=sftime")
    (synopsis "Simple feature objects that have a time column")
    (description
     "This package provides classes and methods for spatial objects
that have a registered time column, in particular for irregular
spatiotemporal data.  The @code{time} column can be of any type, but
needs to be ordinal.  Regularly laid out spatiotemporal data (vector
or raster data cubes) are handled by package stars'.")
    (license license:asl2.0)))

(define-public r-spdep
  (package
    (name "r-spdep")
    (version "1.2-7")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "spdep" version))
              (sha256
               (base32
                "1slykkgvn7blj59lbzj0g0r0dqlcbp0gwnw43sihlbdz4m45kb4x"))
              (snippet
               '(for-each delete-file '("inst/doc/CO69.html"
                                        "inst/doc/CO69.R"
                                        "inst/doc/nb.html"
                                        "inst/doc/nb.R"
                                        "inst/doc/nb_sf.html"
                                        "inst/doc/nb_sf.R"
                                        "inst/doc/nb_sf.Rmd"
                                        "inst/doc/sids.html"
                                        "inst/doc/sids.R")))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-boot
           r-deldir
           r-e1071
           r-s2
           r-sf
           r-sp
           r-spdata
           r-units))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/r-spatial/spdep/")
    (synopsis "Spatial dependence: weighting schemes, statistics and models")
    (description
     "This package provides a collection of functions to create spatial
weights matrix objects from polygon contiguities, from point patterns by
distance and tessellations, for summarizing these objects, and for permitting
their use in spatial data analysis, including regional aggregation by minimum
spanning tree.")
    (license license:gpl2+)))

(define-public r-adegenet
  (package
    (name "r-adegenet")
    (version "2.1.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "adegenet" version))
       (sha256
        (base32
         "09ahgz1ddsdn30fmi5kimdcrcnw18ryqpjcixhyp4xz0xwz2rmw0"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ade4
           r-ape
           r-boot
           r-dplyr
           r-ggplot2
           r-igraph
           r-mass
           r-reshape2
           r-seqinr
           r-shiny
           r-vegan))
    (home-page "https://github.com/thibautjombart/adegenet")
    (synopsis "Exploratory analysis of genetic and genomic data")
    (description
     "This package provides a toolset for the exploration of genetic and
genomic data.  Adegenet provides formal (S4) classes for storing and handling
various genetic data, including genetic markers with varying ploidy and
hierarchical population structure (@code{genind} class), alleles counts by
populations (@code{genpop}), and genome-wide SNP data (@code{genlight}).  It
also implements original multivariate methods (DAPC, sPCA), graphics,
statistical tests, simulation tools, distance and similarity measures, and
several spatial methods.  A range of both empirical and simulated datasets is
also provided to illustrate various methods.")
    (license license:gpl2+)))

(define-public r-pegas
  (package
    (name "r-pegas")
    (version "1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pegas" version))
       (sha256
        (base32 "0ngd0laqbs139ji9hm9kwsm9rm56agw2yyfcplxgqva936l93fl7"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ape))
    (home-page "http://ape-package.ird.fr/pegas.html")
    (synopsis "Population and evolutionary genetics analysis system")
    (description
     "This package provides functions for reading, writing, plotting,
analysing, and manipulating allelic and haplotypic data, including from VCF
files, and for the analysis of population nucleotide sequences and
micro-satellites including coalescent analyses, linkage disequilibrium,
population structure (Fst, Amova) and equilibrium (HWE), haplotype networks,
minimum spanning tree and network, and median-joining networks.")
    (license license:gpl2+)))

(define-public r-rmetasim
  (package
    (name "r-rmetasim")
    (version "3.1.14")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rmetasim" version))
       (sha256
        (base32
         "0rdkhfgyr97r2d1kd9g8ipb2pn563qxm1y4m9z678q0kqan2ddl0"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ade4 r-adegenet r-gtools r-pegas))
    (home-page "https://cran.r-project.org/web/packages/rmetasim")
    (synopsis "Individual-based population genetic simulation environment")
    (description
     "This package provides an interface between R and the metasim simulation
engine.  The simulation environment is documented in: Strand, A.(2002),
Metasim 1.0: an individual-based environment for simulating population
genetics of complex population dynamics.")
    ;; Any GPL version
    (license license:gpl2+)))

(define-public r-genetics
  (package
    (name "r-genetics")
    (version "1.3.8.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "genetics" version))
       (sha256
        (base32
         "0lljxvz7nc6y2z303icphar2niir0i407w5cyhy2pwspd9gwkwpy"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-combinat r-gdata r-gtools r-mass r-mvtnorm))
    (home-page "https://cran.r-project.org/web/packages/genetics/")
    (synopsis "Population genetics")
    (description
     "This package provides classes and methods for handling genetic data.
It includes classes to represent genotypes and haplotypes at single markers up
to multiple markers on multiple chromosomes.  Function include allele
frequencies, flagging homo/heterozygotes, flagging carriers of certain
alleles, estimating and testing for Hardy-Weinberg disequilibrium, estimating
and testing for linkage disequilibrium, ...")
    ;; Any GPL version.
    (license license:gpl2+)))

(define-public r-snp-plotter
  (package
    (name "r-snp-plotter")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "snp.plotter" version))
       (sha256
        (base32
         "16apsqvkah5l0d5qcwp3lq2jspkb6n62wzr0wskmj84jblx483vv"))))
    (properties `((upstream-name . "snp.plotter")))
    (build-system r-build-system)
    (propagated-inputs (list r-genetics))
    (home-page "https://cran.r-project.org/web/packages/snp.plotter/")
    (synopsis "Plot p-values using single SNP and/or haplotype data")
    (description
     "This package helps you create plots of p-values using single SNP and/or
haplotype data.  Main features of the package include options to display a
@dfn{linkage disequilibrium} (LD) plot and the ability to plot multiple
datasets simultaneously.  Plots can be created using global and/or individual
haplotype p-values along with single SNP p-values.  Images are created as
either PDF/EPS files.")
    (license license:gpl2+)))

(define-public r-polspline
  (package
    (name "r-polspline")
    (version "1.1.20")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "polspline" version))
       (sha256
        (base32 "1dd1jwiaglkkhajzvqfkd1x5r3wzjlk5ww0yxzmns0s1kr74i4k9"))))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/polspline/")
    (synopsis "Polynomial spline routines")
    (description
     "This package provides routines for the polynomial spline fitting
routines hazard regression, hazard estimation with flexible tails, logspline,
lspec, polyclass, and polymars.")
    (license license:gpl2+)))

(define-public r-rms
  (package
    (name "r-rms")
    (version "6.3-0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rms" version))
       (sha256
        (base32 "1yfk800q4mgmrjkh0hqjkiv907sr1bi1jaigrj8l6pmg1mkynhbc"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cluster
           r-digest
           r-ggplot2
           r-hmisc
           r-htmltable
           r-htmltools
           r-lattice
           r-mass
           r-multcomp
           r-nlme
           r-polspline
           r-quantreg
           r-rpart
           r-sparsem
           r-survival))
    (native-inputs (list gfortran))
    (home-page "http://biostat.mc.vanderbilt.edu/rms")
    (synopsis "Regression modeling strategies")
    (description
     "This is a package for regression modeling, testing, estimation,
validation, graphics, prediction, and typesetting by storing enhanced model
design attributes in the fit.  The rms package is a collection of functions
that assist with and streamline modeling.  It also contains functions for
binary and ordinal logistic regression models, ordinal models for continuous Y
with a variety of distribution families, and the Buckley-James multiple
regression model for right-censored responses, and implements penalized
maximum likelihood estimation for logistic and ordinary linear models.  The
package works with almost any regression model, but it was especially written
to work with binary or ordinal regression models, Cox regression, accelerated
failure time models, ordinary linear models, the Buckley-James model,
generalized least squares for serially or spatially correlated observations,
generalized linear models, and quantile regression.")
    (license license:gpl2+)))

(define-public r-arsenal
  (package
    (name "r-arsenal")
    (version "3.6.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "arsenal" version))
       (sha256
        (base32
         "0qvs3ld28djnjnggdhqjwq8sbv8zz322qahlvf7dnx35yqf6xkms"))))
    (properties `((upstream-name . "arsenal")))
    (build-system r-build-system)
    (propagated-inputs (list r-knitr))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/mayoverse/arsenal")
    (synopsis "Functions for large-scale statistical summaries")
    (description
     "This package provides an arsenal of R functions for large-scale
statistical summaries, which are streamlined to work within the latest
reporting tools in R and RStudio and which use formulas and versatile
summary statistics for summary tables and models.  The primary functions
include

@enumerate
@item @code{tableby}, a Table-1-like summary of multiple variable types by the
  levels of one or more categorical variables;
@item @code{paired}, a Table-1-like summary of multiple variable types paired
  across two time points;
@item @code{modelsum}, which performs simple model fits on one or more
  endpoints for many variables (univariate or adjusted for covariates);
@item @code{freqlist}, a powerful frequency table across many categorical
  variables;
@item @code{comparedf}, a function for comparing @code{data.frames}; and
@item @code{write2}, a function to output tables to a document.
@end enumerate
")
    (license license:gpl2+)))

(define-public r-haplo-stats
  (package
    (name "r-haplo-stats")
    (version "1.8.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "haplo.stats" version))
       (sha256
        (base32
         "0np9kw4f30xbvwr4f79g909ilis5n273ridmlwyzjxiskiry6mx0"))))
    (properties `((upstream-name . "haplo.stats")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-arsenal r-rms))
    (native-inputs
     (list r-r-rsp)) ; for vignettes
    (home-page "https://www.mayo.edu/research/labs/statistical-genetics-genetic-epidemiology/software")
    (synopsis "Analysis of haplotypes when linkage phase is ambiguous")
    (description
     "This package provides routines for the analysis of indirectly measured
haplotypes.  The statistical methods assume that all subjects are unrelated
and that haplotypes are ambiguous (due to unknown linkage phase of the genetic
markers).  The main functions are: @code{haplo.em()}, @code{haplo.glm()},
@code{haplo.score()}, and @code{haplo.power()}; all of which have detailed
examples in the vignette.")
    (license license:gpl2+)))

(define-public r-bqtl
  (package
    (name "r-bqtl")
    (version "1.0-34")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bqtl" version))
       (sha256
        (base32
         "1xlkgyhlgrwqfzph4sbhh49pjzfnw5zdr3y4786rsnr3faksnxns"))))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "http://famprevmed.ucsd.edu/faculty/cberry/bqtl/")
    (synopsis "Bayesian QTL mapping toolkit")
    (description
     "This is a QTL mapping toolkit for inbred crosses and recombinant inbred
lines.  It includes maximum likelihood and Bayesian tools.")
    (license license:gpl2+)))

(define-public r-ibdreg
  (package
    (name "r-ibdreg")
    (version "0.3.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ibdreg" version))
       (sha256
        (base32
         "1x8z0vr2cmdks12hxfm0wwxskb0cr669w5j5rpa2ln8q704yy41g"))))
    (build-system r-build-system)
    (home-page "https://www.mayo.edu/research/labs/\
statistical-genetics-genetic-epidemiology/software")
    (synopsis "Regression methods for IBD linkage with covariates")
    (description
     "This package provides a method to test genetic linkage with covariates
by regression methods with response IBD sharing for relative pairs.  Account
for correlations of IBD statistics and covariates for relative pairs within
the same pedigree.")
    (license license:gpl2+)))

(define-public r-dlmap
  (package
    (name "r-dlmap")
    (version "1.13")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dlmap" version))
       (sha256
        (base32
         "0s6wlkggkm3qndwyvw72xv1n0mcjb7ss3ajbq2ll6rv30splq0db"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ibdreg r-mgcv r-nlme r-qtl r-wgaim))
    (home-page "https://cran.r-project.org/web/packages/dlmap/")
    (synopsis "Detection localization mapping for QTL")
    (description
     "This is package for QTL mapping in a mixed model framework with separate
detection and localization stages.  The first stage detects the number of QTL
on each chromosome based on the genetic variation due to grouped markers on
the chromosome; the second stage uses this information to determine the most
likely QTL positions.  The mixed model can accommodate general fixed and
random effects, including spatial effects in field trials and pedigree
effects.  It is applicable to backcrosses, doubled haploids, recombinant
inbred lines, F2 intercrosses, and association mapping populations.")
    (license license:gpl2)))

(define-public r-hwde
  (package
    (name "r-hwde")
    (version "0.67")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "hwde" version))
       (sha256
        (base32
         "0wb2f9i5qi7w77ygh8bvydfpr7j5x8dyvnnhdkajaz0wdcpkyaqy"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/hwde/")
    (synopsis "Models and tests for departure from Hardy-Weinberg equilibrium")
    (description
     "This package fits models for genotypic disequilibria, as described in
Huttley and Wilson (2000), Weir (1996) and Weir and Wilson (1986).  Contrast
terms are available that account for first order interactions between loci.
It also implements, for a single locus in a single population, a conditional
exact test for Hardy-Weinberg equilibrium.")
    (license license:gpl2+)))

(define-public r-tdthap
  (package
    (name "r-tdthap")
    (version "1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tdthap" version))
       (sha256
        (base32
         "0x67k50vly92b9n5hpqp4hy87kh8r6nzadsj8xzz4lvcmb4vb6mq"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/tdthap/")
    (synopsis "TDT tests for extended haplotypes")
    (description
     "Functions and examples are provided for transmission/disequilibrium
tests for extended marker haplotypes, as in Clayton, D. and Jones, H. (1999)
\"Transmission/disequilibrium tests for extended marker haplotypes\".")
    (license license:artistic2.0)))

(define-public r-sparql
  (package
    (name "r-sparql")
    (version "1.16")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "SPARQL" version))
              (sha256
               (base32
                "0gak1q06yyhdmcxb2n3v0h9gr1vqd0viqji52wpw211qp6r6dcrc"))))
    (properties `((upstream-name . "SPARQL")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcurl r-xml))
    (home-page "https://cran.r-project.org/web/packages/SPARQL")
    (synopsis "SPARQL client for R")
    (description "This package provides an interface to use SPARQL to pose
SELECT or UPDATE queries to an end-point.")
    ;; The only license indication is found in the DESCRIPTION file,
    ;; which states GPL-3.  So we cannot assume GPLv3+.
    (license license:gpl3)))

(define-public r-bookdown
  (package
    (name "r-bookdown")
    (version "0.29")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "bookdown" version))
              (sha256
               (base32
                "08zpky94bdbjsbhi90pymxpczpfkjxwbx7p1v7ip8raw9b23skjv"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-htmltools
           r-jquerylib
           r-knitr
           r-rmarkdown
           r-tinytex
           r-xfun
           r-yaml
           pandoc))
    ;; We cannot add knitr because this package depends on xfun, which is an
    ;; input to knitr.
    #;
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/rstudio/bookdown")
    (synopsis "Authoring books and technical documents with R markdown")
    (description "This package provides output formats and utilities for
authoring books and technical documents with R Markdown.")
    (license license:gpl3)))

(define-public r-optparse
  (package
    (name "r-optparse")
    (version "1.7.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "optparse" version))
       (sha256
        (base32
         "1v87db7fm494dwxvdsnl1m2kj84nplq7pkh0g41najhx0npy31v2"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-getopt))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/trevorld/optparse")
    (synopsis "Command line option parser")
    (description
     "This package provides a command line parser inspired by Python's
@code{optparse} library to be used with Rscript to write shebang scripts
that accept short and long options.")
    (license license:gpl2+)))

(define-public r-osqp
  (package
    (name "r-osqp")
    (version "0.6.0.7")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "osqp" version))
              (sha256
               (base32
                "00w2hr0pagnvpsk84z99c7alhv7xvs9wpcmkzbcg3qs14g888rgf"))))
    (properties `((upstream-name . "osqp")))
    (build-system r-build-system)
    (propagated-inputs (list r-matrix r-r6 r-rcpp))
    (home-page "https://osqp.org")
    (synopsis "Quadratic Programming Solver using the OSQP Library")
    (description
     "This package provides bindings to the OSQP solver.  The OSQP
solver is a numerical optimization package or solving convex quadratic
programs written in C and based on the alternating direction method of
multipliers.  See <arXiv:1711.08013> for details.")
    (license (list license:asl2.0))))

(define-public r-kernlab
  (package
    (name "r-kernlab")
    (version "0.9-31")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "kernlab" version))
       (sha256
        (base32 "12i7ffc1aacyy7bpjc0w60wwivn88wri8jz43h77irn5q5jwcnbk"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/kernlab")
    (synopsis "Kernel-based machine learning tools")
    (description
     "This package provides kernel-based machine learning methods for
classification, regression, clustering, novelty detection, quantile regression
and dimensionality reduction.  Among other methods @code{kernlab} includes
Support Vector Machines, Spectral Clustering, Kernel PCA, Gaussian Processes
and a QP solver.")
    (license license:gpl2)))

(define-public r-hierfstat
  (package
    (name "r-hierfstat")
    (version "0.5-11")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "hierfstat" version))
       (sha256
        (base32
         "0nyb5091lr8ma9vydbssyx9503601rynlrbldv98mmrmh74h6v41"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ade4 r-adegenet r-gaston r-gtools))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/hierfstat/")
    (synopsis "Estimation and tests of hierarchical F-statistics")
    (description
     "This package allows the estimation of hierarchical F-statistics from
haploid or diploid genetic data with any numbers of levels in the hierarchy,
following the algorithm of Yang (Evolution, 1998, 52(4):950-956).  Functions
are also given to test via randomisations the significance of each F and
variance components, using the likelihood-ratio statistics G.")
    (license license:gpl2+)))

(define-public r-hapassoc
  (package
    (name "r-hapassoc")
    (version "1.2-9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "hapassoc" version))
       (sha256
        (base32
         "09ijc4sbw743z74fzklmvig11ndkycg6j86k4214wfsj1yj6j9x6"))))
    (build-system r-build-system)
    (home-page "https://stat.sfu.ca/statgen/research/hapassoc.html")
    (synopsis "Inference of trait associations with SNP haplotypes")
    (description
     "Hapassoc performs likelihood inference of trait associations with
haplotypes and other covariates in @dfn{generalized linear models} (GLMs). The
functions are developed primarily for data collected in cohort or
cross-sectional studies.  They can accommodate uncertain haplotype phase and
handle missing genotypes at some SNPs.")
    (license license:gpl2)))

(define-public r-sampling
  (package
    (name "r-sampling")
    (version "2.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sampling" version))
       (sha256
        (base32
         "11xis4vzn2ga8ml9xrgfgqzccvwbnabq35aidzdvpnvciybsanvz"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lpsolve r-mass))
    (home-page "https://cran.r-project.org/web/packages/sampling/")
    (synopsis "Survey sampling")
    (description
     "This package provides functions for drawing and calibrating samples.")
    (license license:gpl2+)))

(define-public r-r2html
  (package
    (name "r-r2html")
    (version "2.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "R2HTML" version))
       (sha256
        (base32
         "12qg9rp1j26h2f48dfg5k9jds26ycacv3f3ymk686ks43hd1hzja"))))
    (properties `((upstream-name . "R2HTML")))
    (build-system r-build-system)
    (home-page "https://github.com/nalimilan/R2HTML")
    (synopsis "HTML export for R objects")
    (description
     "This package includes HTML functions and methods to write in an HTML
file.  Thus, making HTML reports is easy.  It includes a function that allows
redirection on the fly, which appears to be very useful for teaching purposes,
as the student can keep a copy of the produced output to keep all that they
did during the course.  The package comes with a vignette describing how to
write HTML reports for statistical analysis.  Finally, a driver for Sweave
parses HTML flat files containing R code and to automatically write
the corresponding outputs (tables and graphs).")
    (license license:gpl2+)))

(define-public r-rjava
  (package
    (name "r-rjava")
    (version "1.0-6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rJava" version))
       (sha256
        (base32
         "1ijqhvnb8ab38cp9pwdf7zq7xqqlm6x94gkrab2dd98p6d4x1472"))))
    (properties `((upstream-name . "rJava")))
    (build-system r-build-system)
    (arguments
     `(#:modules ((guix build utils)
                  (guix build r-build-system)
                  (ice-9 match))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'set-JAVA_HOME
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((jdk (assoc-ref inputs "jdk")))
               (setenv "JAVA_HOME" jdk)
               (setenv "JAVA" (which "java"))
               (setenv "JAR" (which "jar"))
               (setenv "JAVAC" (which "javac"))
               (setenv "JAVAH" (which "javah"))
               (setenv "JAVA_CPPFLAGS"
                       (string-append "-I" jdk "/include "
                                      "-I" jdk "/include/linux"))
               (match (find-files (string-append jdk "/jre/lib/") "libjvm.so")
                 ((lib) (setenv "JAVA_LIBS" lib))
                 (_ (error "Could not find libjvm.so"))))
             #t)))))
    (inputs
     `(("icu4c" ,icu4c)
       ("jdk" ,icedtea-8 "jdk")
       ("zlib" ,zlib)))
    (home-page "https://www.rforge.net/rJava/")
    (synopsis "Low-Level R to Java interface")
    (description
     "This package provides a low-level interface to the Java VM very much
like .C/.Call and friends.  It allows the creation of objects, calling methods
and accessing fields.")
    (license license:gpl2)))

(define-public r-svmisc
  (package
    (name "r-svmisc")
    (version "1.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "svMisc" version))
       (sha256
        (base32
         "1r3kih5bnr4plnzdn5f2gg3xl3krgyl7gkdlf58a2l8vk13j3m9d"))))
    (properties `((upstream-name . "svMisc")))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/SciViews/svMisc")
    (synopsis "Miscellaneous functions for SciViews")
    (description
     "This package provides miscellaneous functions for SciViews or general
use, including tools to manage a temporary environment attached to the search
path for temporary variables you do not want to @code{save()} or
@code{load()}; test the current platform; showing progress bars, etc.")
    (license license:gpl2)))

(define-public r-xyz
  (package
    (name "r-xyz")
    (version "0.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "xyz" version))
       (sha256
        (base32
         "13w4sb4pvgciwr8wsz785dafj2k2kpx7znz46r5d32wx88vkycp4"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp))
    (home-page "https://cran.r-project.org/web/packages/xyz/")
    (synopsis "Algorithm for fast interaction search in high-dimensional data")
    (description
     "High dimensional interaction search by brute force requires a quadratic
computational cost in the number of variables.  The xyz algorithm provably
finds strong interactions in almost linear time.  For details of the algorithm
see: G. Thanei, N. Meinshausen and R. Shah (2016).  The xyz algorithm for fast
interaction search in high-dimensional data.")
    ;; Any version of the GPL.
    (license license:gpl2+)))

(define-public r-rttf2pt1
  (package
    (name "r-rttf2pt1")
    (version "1.3.11")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Rttf2pt1" version))
       (sha256
        (base32
         "1fbls9hy4s0hdszg449bpapx2mhknwiasvr15djf9f1hm0b2908p"))))
    (properties `((upstream-name . "Rttf2pt1")))
    (build-system r-build-system)
    (home-page "https://github.com/wch/Rttf2pt1")
    (synopsis "Font conversion utility")
    (description
     "This package contains the program @code{ttf2pt1}, for use with the
@code{extrafont} package.")
    ;; Most of the files are covered under the Expat license.  Some files are
    ;; covered under BSD-3.  Deviations for individual files are recorded in
    ;; the LICENSE file.
    (license (list license:bsd-3 license:expat
                   (license:non-copyleft "file://LICENSE")))))

(define-public r-extrafontdb
  (package
    (name "r-extrafontdb")
    (version "1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "extrafontdb" version))
       (sha256
        (base32
         "115n42hfvv5h4nn4cfkfmkmn968py4lpy8zd0d6w5yylwpzbm8gs"))))
    (build-system r-build-system)
    (home-page "https://github.com/wch/extrafontdb")
    (synopsis "Database for the extrafont package")
    (description
     "This package holds the database for the @code{extrafont} package.")
    (license license:gpl2)))

(define-public r-extrafont
  (package
    (name "r-extrafont")
    (version "0.18")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "extrafont" version))
       (sha256
        (base32
         "0mx810mld67vb1w3wkl4fhpjmkq32lgpq5x1c0a9rf8li5wskrj4"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-extrafontdb r-rttf2pt1))
    (home-page "https://github.com/wch/extrafont")
    (synopsis "Tools for using fonts in R")
    (description
     "The extrafont package makes it easier to use fonts other than the basic
PostScript fonts that R uses.  Fonts that are imported into extrafont can be
used with PDF or PostScript output files.  There are two hurdles for using
fonts in PDF (or Postscript) output files:

@enumerate
@item Making R aware of the font and the dimensions of the characters.
@item Embedding the fonts in the PDF file so that the PDF can be displayed
  properly on a device that doesn't have the font.  This is usually needed if
  you want to print the PDF file or share it with others.
@end enumerate

The extrafont package makes both of these things easier.")
    (license license:gpl2)))

(define-public r-xkcd
  (package
    (name "r-xkcd")
    (version "0.0.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "xkcd" version))
       (sha256
        (base32
         "1z2y0ihn68ppay7xkglhw7djki5654g6z4bbpyy41if57z9q554f"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-extrafont r-ggplot2 r-hmisc))
    (home-page "https://cran.r-project.org/web/packages/xkcd/")
    (synopsis "Plot ggplot2 graphics in the XKCD style")
    (description
     "This package provides the means to plot ggplot2 graphs in the style of
the XKCD web comic.")
    (license license:gpl3)))

(define-public r-babelgene
  (package
    (name "r-babelgene")
    (version "22.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "babelgene" version))
       (sha256
        (base32
         "1ql5r1chl5ajzy9ppcnk755ia3m2a8n08m837dnm2ll3nzf02rnf"))))
    (properties `((upstream-name . "babelgene")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr r-rlang))
    (native-inputs
     (list r-knitr))
    (home-page
     "https://igordot.github.io/babelgene/")
    (synopsis "Gene orthologs for model organisms in a Tidy data format")
    (description
     "Genomic analysis of model organisms often requires the use of databases
based on human data or making comparisons to patient-derived resources.  This
requires converting genes between human and non-human analogues.  The
babelgene R package provides predicted gene orthologs/homologs for frequently
studied model organisms in an R-friendly tidy/long format.  The package
integrates orthology assertion predictions sourced from multiple databases as
compiled by the HGNC Comparison of Orthology Predictions (HCOP).")
    (license license:expat)))

(define-public r-msigdbr
  (package
    (name "r-msigdbr")
    (version "7.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "msigdbr" version))
       (sha256
        (base32
         "1jna9bkq0a7r6f8nhxziyiw75kfhsyh1rv7sx5d4551mvxxlhc6w"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-babelgene
           r-dplyr
           r-magrittr
           r-rlang
           r-tibble
           r-tidyselect))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/igordot/msigdbr")
    (synopsis "MSigDB gene sets for multiple organisms")
    (description
     "This package provides the @dfn{Molecular Signatures Database} (MSigDB)
gene sets typically used with the @dfn{Gene Set Enrichment Analysis} (GSEA)
software in a standard R data frame with key-value pairs.  Included are the
original human gene symbols and Entrez IDs as well as the equivalents for
various frequently studied model organisms such as mouse, rat, pig, fly, and
yeast.")
    ;; The package is covered under the Expat license, but the upstream MSigDB
    ;; files are made available under the Creative Commons Attribution 4.0
    ;; International license.
    (license (list license:expat license:cc-by4.0))))

(define-public r-gridgraphics
  (package
    (name "r-gridgraphics")
    (version "0.5-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gridGraphics" version))
       (sha256
        (base32
         "12yswy02j3h5wir7m5jnkhpjmb0sa4snn61vjd68i49qwsa6w219"))))
    (properties `((upstream-name . "gridGraphics")))
    (build-system r-build-system)
    (home-page "https://github.com/pmur002/gridgraphics")
    (synopsis "Redraw base graphics using @code{grid} graphics")
    (description
     "This package provides functions to convert a page of plots drawn with
the @code{graphics} package into identical output drawn with the @code{grid}
package.  The result looks like the original @code{graphics}-based plot, but
consists of @code{grid} grobs and viewports that can then be manipulated with
@code{grid} functions (e.g., edit grobs and revisit viewports).")
    (license license:gpl2+)))

(define-public r-farver
  (package
    (name "r-farver")
    (version "2.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "farver" version))
       (sha256
        (base32
         "1klnr73fhm7n46q85in1v9gi99y6rcdzzg4h4wvnbx23lxndmkqd"))))
    (build-system r-build-system)
    (home-page "https://github.com/thomasp85/farver")
    (synopsis "Vectorized color conversion and comparison")
    (description
     "The encoding of color can be handled in many different ways, using
different color spaces.  As different color spaces have different uses,
efficient conversion between these representations are important.  This
package provides a set of functions that gives access to very fast color space
conversion and comparisons implemented in C++, and offers 100-fold speed
improvements over the @code{convertColor} function in the @code{grDevices}
package.")
    (license license:expat)))

(define-public r-yulab-utils
  (package
    (name "r-yulab-utils")
    (version "0.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "yulab.utils" version))
       (sha256
        (base32
         "0sq5wc0mp84h6fs4wa2smvf7dcn0p0xarzb2ljvqc3p4vb2lvkbf"))))
    (properties `((upstream-name . "yulab.utils")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=yulab.utils")
    (synopsis "Supporting functions for packages maintained by YuLab-SMU")
    (description
     "Miscellaneous functions commonly used by YuLab-SMU, such as
@code{install_zip_gh} to install R packages from Github ZIP files.")
    (license license:artistic2.0)))

(define-public r-ggplotify
  (package
    (name "r-ggplotify")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggplotify" version))
       (sha256
        (base32
         "12mk3fa8fdjxj7xxz21jkr7h91w5wdgwjqhszcz1qffwsgb773qp"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-gridgraphics r-yulab-utils))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/GuangchuangYu/ggplotify")
    (synopsis "Convert plots to @code{grob} or @code{ggplot} object")
    (description
     "This package provides tools to convert plot function calls (using
expression or formula) to @code{grob} or @code{ggplot} objects that are
compatible with the @code{grid} and @code{ggplot2} environment.  With this
package, we are able to e.g. use @code{cowplot} to align plots produced by
@code{base} graphics, @code{grid}, @code{lattice}, @code{vcd} etc. by
converting them to @code{ggplot} objects.")
    (license license:artistic2.0)))

(define-public r-triebeard
  (package
    (name "r-triebeard")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "triebeard" version))
       (sha256
        (base32
         "1hqyz57gph02c9fdc07lxz113bbklif3g18sw8jan6pakhhdc7dz"))))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (home-page "https://github.com/Ironholds/triebeard/")
    (synopsis "Radix trees in Rcpp")
    (description
     "Radix trees, or tries, are key-value data structures optimized for
efficient lookups, similar in purpose to hash tables.  This package provides
an implementation of radix trees for use in R programming and in developing
packages with Rcpp.")
    (license license:expat)))

(define-public r-tweenr
  (package
    (name "r-tweenr")
    (version "2.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tweenr" version))
       (sha256
        (base32
         "1wqzcsxlz1isb1j0v5g6dgvd40q3q9qlahvgcgiq0j4d87nzvfv4"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'build-reproducibly
           (lambda _
             (substitute* "R/aaa.R"
               (("BASEDATETIME <- Sys.time.*")
                "BASEDATETIME <- structure(0, class = c(\"POSIXct\", \"POSIXt\"))\n")))))))
    (propagated-inputs
     (list r-cpp11 r-farver r-magrittr r-rlang r-vctrs))
    (home-page "https://github.com/thomasp85/tweenr")
    (synopsis "Interpolate data for smooth animations")
    (description
     "In order to create smooth animation between states of data, tweening is
necessary.  This package provides a range of functions for creating tweened
data that can be used as basis for animation.  Furthermore it adds a number of
vectorized interpolaters for common R data types such as numeric, date and
color.")
    (license license:expat)))

(define-public r-polyclip
  (package
    (name "r-polyclip")
    (version "1.10-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "polyclip" version))
       (sha256
        (base32
         "0mkg5v045an49c3j279vvabm7p4d9jsnzlfp96dpblvihxvwkll4"))))
    (build-system r-build-system)
    (native-inputs (list pkg-config))
    (home-page "http://www.angusj.com/delphi/clipper.php")
    (synopsis "Polygon clipping")
    (description
     "This package provides an R port of the library Clipper.  It performs
polygon clipping operations (intersection, union, set minus, set difference)
for polygonal regions of arbitrary complexity, including holes.  It computes
offset polygons (spatial buffer zones, morphological dilations, Minkowski
dilations) for polygonal regions and polygonal lines.  It computes the
Minkowski Sum of general polygons.  There is a function for removing
self-intersections from polygon data.")
    (license license:boost1.0)))

(define-public r-urlchecker
  (package
    (name "r-urlchecker")
    (version "1.0.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "urlchecker" version))
              (sha256
               (base32
                "06034lb94krbzawqg5xklwcksvyyzl3qy355f66baj5pw7dms5k2"))))
    (properties `((upstream-name . "urlchecker")))
    (build-system r-build-system)
    (propagated-inputs (list r-cli r-curl r-xml2))
    (home-page "https://github.com/r-lib/urlchecker")
    (synopsis "Run CRAN URL checks from older R versions")
    (description
     "This package provides the URL checking tools available in R 4.1+ as a
package for earlier versions of R.  It also uses concurrent requests so can be
much faster than the serial versions.")
    (license license:gpl3)))

(define-public r-urltools
  (package
    (name "r-urltools")
    (version "1.7.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "urltools" version))
       (sha256
        (base32
         "04x3my655dd287cbsszbnf75q0swmjlxxrblcsay7a8n3df3a830"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp r-triebeard))
    (home-page "https://github.com/Ironholds/urltools/")
    (synopsis "Vectorized tools for URL handling and parsing")
    (description
     "This package provides a toolkit for all URL-handling needs, including
encoding and decoding, parsing, parameter extraction and modification.  All
functions are designed to be both fast and entirely vectorized.  It is
intended to be useful for people dealing with web-related datasets, such as
server-side logs, although may be useful for other situations involving large
sets of URLs.")
    (license license:expat)))

(define-public r-ggforce
  (package
    (name "r-ggforce")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggforce" version))
       (sha256
        (base32
         "0wqq8l7lq96k4w0vq12jcg7clvgia8s35jjbqq1s0py4cgxijhml"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-ggplot2
           r-gtable
           r-lifecycle
           r-mass
           r-polyclip
           r-rcpp
           r-rcppeigen
           r-rlang
           r-scales
           r-systemfonts
           r-tidyselect
           r-tweenr
           r-vctrs
           r-withr))
    (home-page "https://ggforce.data-imaginist.com")
    (synopsis "Accelerating ggplot2")
    (description
     "The aim of the ggplot2 package is to aid in visual data investigations.
This focus has led to a lack of facilities for composing specialized plots.
This package aims to be a collection of mainly new statistics and geometries
that fills this gap.")
    (license license:expat)))

(define-public r-eulerr
  (package
    (name "r-eulerr")
    (version "6.1.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "eulerr" version))
              (sha256
               (base32
                "0lldp2319qd08y87f862gx8a77rvikcnkmdl9xgx4glynfs3hk19"))))
    (properties `((upstream-name . "eulerr")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-gensa
           r-polyclip
           r-polylabelr
           r-rcpp
           r-rcpparmadillo))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/jolars/eulerr")
    (synopsis "Area-proportional Euler and Venn diagrams with ellipses")
    (description
     "This package generates area-proportional Euler diagrams using
numerical optimization.  An Euler diagram is a generalization of a
Venn diagram, relaxing the criterion that all interactions need to be
represented.  Diagrams may be fit with ellipses and circles via a wide
range of inputs and can be visualized in numerous ways.")
    (license license:gpl3)))

(define-public r-europepmc
  (package
    (name "r-europepmc")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "europepmc" version))
       (sha256
        (base32
         "16japbndid34shqg8n0bmjrxn84xmhrylvz832zclcllm6i93fn1"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr
           r-httr
           r-jsonlite
           r-plyr
           r-progress
           r-purrr
           r-rlang
           r-tibble
           r-tidyr
           r-urltools
           r-xml2))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/ropensci/europepmc/")
    (synopsis "R Interface to the Europe PubMed Central RESTful Web Service")
    (description
     "This package provides an R Client for the
@url{https://europepmc.org/RestfulWebService,Europe PubMed Central RESTful Web
Service}.  It gives access to both metadata on life science literature and
open access full texts.  Europe PMC indexes all PubMed content and other
literature sources including Agricola, a bibliographic database of citations
to the agricultural literature, or Biological Patents.  In addition to
bibliographic metadata, the client allows users to fetch citations and
reference lists.  Links between life-science literature and other EBI
databases, including ENA, PDB or ChEMBL are also accessible.")
    (license license:gpl3)))

(define-public r-ggraph
  (package
    (name "r-ggraph")
    (version "2.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggraph" version))
       (sha256
        (base32
         "07sw4h94dzbs44dcvvj80g8v8252k4iw8pkmzdrk4qagvhidnvv8"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-digest
           r-dplyr
           r-ggforce
           r-ggplot2
           r-ggrepel
           r-graphlayouts
           r-gtable
           r-igraph
           r-lifecycle
           r-mass
           r-rcpp
           r-rlang
           r-scales
           r-tidygraph
           r-vctrs
           r-viridis
           r-withr))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/ggraph/")
    (synopsis "Implementation of grammar of graphics for graphs and networks")
    (description
     "The grammar of graphics as implemented in ggplot2 is a poor fit for
graph and network visualizations due to its reliance on tabular data input.
The ggraph package is an extension of the ggplot2 API tailored to graph
visualizations and provides the same flexible approach to building up plots
layer by layer.")
    (license license:gpl3)))

(define-public r-gkmsvm
  (package
    (name "r-gkmsvm")
    (version "0.81.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gkmSVM" version))
       (sha256
        (base32
         "119g5rhc7ffyviz04r04aj5z1g6abnj3ddd01g7db505sdr6lapj"))))
    (properties `((upstream-name . "gkmSVM")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-kernlab r-rcpp r-rocr r-seqinr))
    (home-page "https://cran.r-project.org/web/packages/gkmSVM")
    (synopsis "Gapped-kmer support vector machine")
    (description
     "This R package provides tools for training gapped-kmer SVM classifiers
for DNA and protein sequences.  This package supports several sequence
kernels, including: gkmSVM, kmer-SVM, mismatch kernel and wildcard kernel.")
    (license license:gpl2+)))

(define-public r-varselrf
  (package
    (name "r-varselrf")
    (version "0.7-8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "varSelRF" version))
       (sha256
        (base32
         "0h49rl1j13yfh97rsfsyh9s2c4wajny4rzms2qw77d0cavxqg53i"))))
    (properties `((upstream-name . "varSelRF")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-randomforest))
    (home-page "https://www.ligarto.org/rdiaz/software/software")
    (synopsis "Variable selection using random forests")
    (description
     "This package provides tools for the variable selection from random
forests using both backwards variable elimination (for the selection of small
sets of non-redundant variables) and selection based on the importance
spectrum (somewhat similar to scree plots; for the selection of large,
potentially highly-correlated variables).  The main applications are in
high-dimensional data (e.g., microarray data, and other genomics and
proteomics applications).")
    (license license:gpl2+)))

(define-public r-pamr
  (package
    (name "r-pamr")
    (version "1.56.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pamr" version))
       (sha256
        (base32
         "0ycpgkk23y3zzkb42n2skcyl35ps1n7jmyzfj7pbxr3f6gr2grfh"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cluster r-survival))
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/pamr/")
    (synopsis "Prediction Analysis for Microarrays")
    (description
     "This package provides some functions for sample classification in
microarrays.")
    (license license:gpl2)))

(define-public r-rda
  (package
    (name "r-rda")
    (version "1.0.2-2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rda" version))
       (sha256
        (base32
         "17ll0idnms4bcpbl65xnl8zfnwsk9ww0rg5z8qqh4ahk5qdab8zf"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/rda/")
    (synopsis "Shrunken centroids regularized discriminant analysis")
    (description
     "This package provides tools for shrunken centroids regularized
discriminant analysis for the purpose of classifying high dimensional data.")
    (license license:gpl2+)))

(define-public r-ggvis
  (package
    (name "r-ggvis")
    (version "0.4.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggvis" version))
       (sha256
        (base32
         "1qv512pd4x5vmx15y9nvqmabbbw14h75fmi1sjbcg5yl25z0cswy"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertthat
           r-dplyr
           r-htmltools
           r-jsonlite
           r-magrittr
           r-rlang
           r-shiny))
    (home-page "https://ggvis.rstudio.com/")
    (synopsis "Interactive grammar of graphics")
    (description
     "This package is a data visualization package for R providing an
implementation of an interactive grammar of graphics, taking the best parts of
ggplot2, combining them with the reactive framework of Shiny and drawing web
graphics using Vega.")
    (license license:gpl2)))

(define-public r-gbm
  (package
    (name "r-gbm")
    (version "2.1.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gbm" version))
       (sha256
        (base32
         "02z85d7zp3i5x8r8q005hyw2rx1ck7lw81q7a3lqwraj8l95c94d"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lattice r-survival))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/gbm-developers/gbm")
    (synopsis "Generalized boosted regression models")
    (description
     "This package is an implementation of extensions to Freund and Schapire's
AdaBoost algorithm and Friedman's gradient boosting machine.  It includes
regression methods for least squares, absolute loss, t-distribution loss,
quantile regression, logistic, multinomial logistic, Poisson, Cox proportional
hazards partial likelihood, AdaBoost exponential loss, Huberized hinge loss,
and Learning to Rank measures (LambdaMart).")
    (license license:gpl2+)))

(define-public r-threejs
  (package
    (name "r-threejs")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "threejs" version))
       (sha256
        (base32
         "1711h351nzxfkbbdwvfzyhciyvi9c6wx3jq1g97lzcqgnb45kivn"))))
    (build-system r-build-system)
    (arguments
     `(#:modules ((guix build utils)
                  (guix build r-build-system)
                  (srfi srfi-1)
                  (ice-9 popen))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst"
               (call-with-values
                   (lambda ()
                     (unzip2
                      `((,(assoc-ref inputs "js-jquery")
                         "htmlwidgets/lib/jquery/jquery.min.js")
                        (,(assoc-ref inputs "js-threejs-111")
                         "htmlwidgets/lib/threejs-111/three.min.js"))))
                 (lambda (sources targets)
                   (for-each (lambda (source target)
                               (format #t "Processing ~a --> ~a~%"
                                       source target)
                               (delete-file target)
                               (let ((minified (open-pipe* OPEN_READ "uglifyjs" source)))
                                 (call-with-output-file target
                                   (lambda (port)
                                     (dump-port minified port)))))
                             sources targets))))
             #t)))))
    (propagated-inputs
     (list r-base64enc r-crosstalk r-htmlwidgets r-igraph))
    (native-inputs
     `(("uglifyjs" ,node-uglify-js)
       ("js-jquery"
        ,(origin
           (method url-fetch)
           (uri "https://code.jquery.com/jquery-1.12.4.js")
           (sha256
            (base32
             "0x9mrc1668icvhpwzvgafm8xm11x9lfai9nwr66aw6pjnpwkc3s3"))))
       ("js-threejs-111"
        ,(origin
           (method url-fetch)
           (uri "https://raw.githubusercontent.com/mrdoob/three.js/r111/build/three.js")
           (sha256
            (base32
             "1cxdkw3plmlw1xvhbx5dm39gqczgzxip2dm887v6whhsxqxl9cky"))))))
    (home-page "https://bwlewis.github.io/rthreejs")
    (synopsis "Interactive 3D scatter plots, networks and globes")
    (description
     "Create interactive 3D scatter plots, network plots, and globes in R
using the three.js visualization library.")
    (license license:expat)))

(define-public r-mlbench
  (package
    (name "r-mlbench")
    (version "2.1-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mlbench" version))
       (sha256
        (base32
         "157iqsld0wj8g8cbs7nh6p2x6kasmkhs3078hsmqac946gk2pydi"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/mlbench/")
    (synopsis "Machine learning benchmark problems")
    (description
     "This package provides a collection of artificial and real-world machine
learning benchmark problems, including, e.g., several data sets from the UCI
repository.")
    (license license:gpl2)))

(define-public r-mpm
  (package
    (name "r-mpm")
    (version "1.0-23")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mpm" version))
       (sha256
        (base32
         "1jpv2ddmw7aarqbbyfys1yb840arw33319wnny3v2hk84hldmayj"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-kernsmooth r-mass))
    (home-page "http://mpm.r-forge.r-project.org")
    (synopsis "Multivariate projection methods")
    (description
     "This is a package for exploratory graphical analysis of multivariate
data, specifically gene expression data with different projection methods:
principal component analysis, correspondence analysis, spectral map
analysis.")
    (license license:gpl2+)))

(define-public r-png
  (package
    (name "r-png")
    (version "0.1-7")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "png" version))
              (sha256
               (base32
                "0g2mcp55lvvpx4kd3mn225mpbxqcq73wy5qx8b4lyf04iybgysg2"))))
    (build-system r-build-system)
    (inputs
     (list libpng zlib))
    (home-page "https://www.rforge.net/png/")
    (synopsis "Read and write PNG images")
    (description
     "This package provides an easy and simple way to read, write and display
bitmap images stored in the PNG format.  It can read and write both files and
in-memory raw vectors.")
    ;; Any of these GPL versions.
    (license (list license:gpl2 license:gpl3))))

(define-public r-ggcorrplot
  (package
    (name "r-ggcorrplot")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggcorrplot" version))
       (sha256
        (base32
         "186a0mpdpipp24fjbd52l1gdgpqm6vl83ff8069d8nngyqbrx0jr"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-reshape2))
    (home-page "http://www.sthda.com/english/wiki/ggcorrplot")
    (synopsis "Visualization of a correlation matrix using ggplot2")
    (description
     "The ggcorrplot package can be used to visualize easily a correlation
matrix using ggplot2.  It provides a solution for reordering the correlation
matrix and displays the significance level on the plot.  It also includes a
function for computing a matrix of correlation p-values.")
    (license license:gpl2)))

(define-public r-ggfun
  (package
    (name "r-ggfun")
    (version "0.0.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggfun" version))
       (sha256
        (base32
         "0x71p3mm0sw72hv92368wy2yiy7zv826p3kddpwndqv1bywmyfx8"))))
    (properties `((upstream-name . "ggfun")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-rlang))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=ggfun")
    (synopsis "Miscellaneous functions for ggplot2")
    (description
     "This package provides useful functions to edit ggplot object (e.g.,
setting fonts for theme and layers, adding rounded rectangle as background for
each of the legends).")
    (license license:artistic2.0)))

(define-public r-gridtext
  (package
    (name "r-gridtext")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gridtext" version))
       (sha256
        (base32
         "0f7i2qb8fawi8agy2iz2c173kfwj7cbb5ikjix64nmzqc5j7363d"))))
    (properties `((upstream-name . "gridtext")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-curl
           r-jpeg
           r-markdown
           r-png
           r-rcpp
           r-rlang
           r-stringr
           r-xml2))
    (home-page "https://wilkelab.org/gridtext/")
    (synopsis "Improved text rendering support for Grid graphics")
    (description
     "This package provides support for rendering of formatted text using Grid
graphics.  Text can be formatted via a minimal subset of Markdown, HTML, and
inline CSS directives, and it can be rendered both with and without word
wrap.")
    (license license:expat)))

(define-public r-ggghost
  (package
    (name "r-ggghost")
    (version "0.2.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ggghost" version))
              (sha256
               (base32
                "0kvsjadxxdf6yvzk4a6yqkg02q1ysslvf3m0a369bdim396z4hnv"))))
    (properties `((upstream-name . "ggghost")))
    (build-system r-build-system)
    (propagated-inputs (list r-animation r-ggplot2))
    (home-page "https://github.com/jonocarroll/ggghost")
    (synopsis "Capture the spirit of your ggplot2 calls")
    (description
     "This package lets you create a reproducible @code{ggplot2} object by
storing the data and calls.")
    (license license:gpl3+)))

(define-public r-ggtext
  (package
    (name "r-ggtext")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggtext" version))
       (sha256
        (base32
         "10vrrxviv4yp9lqsanqvwsvbj64vn66hwm1w7860x1g58hf1g0l7"))))
    (properties `((upstream-name . "ggtext")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-gridtext r-rlang r-scales))
    (native-inputs (list r-knitr))
    (home-page "https://wilkelab.org/ggtext/")
    (synopsis "Improved text rendering support for ggplot2")
    (description
     "This package provides a ggplot2 extension that enables the rendering of
complex formatted plot labels (titles, subtitles, facet labels, axis labels,
etc.).  Text boxes with automatic word wrap are also supported.")
    (license license:gpl2)))

(define-public r-ggthemeassist
  (package
    (name "r-ggthemeassist")
    (version "0.1.5")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ggThemeAssist" version))
              (sha256
               (base32
                "1biw91a8p13h62v4w3yim6ghr98khmyhb3qd0h04asf91vvmpxbv"))))
    (properties `((upstream-name . "ggThemeAssist")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-formatr
           r-ggplot2
           r-miniui
           r-rstudioapi
           r-shiny))
    (home-page "https://github.com/calligross/ggthemeassist")
    (synopsis "Add-in to customize ggplot2 themes")
    (description
     "This package provides an Rstudio add-in that delivers a graphical
interface for editing @code{ggplot2} theme elements.")
    (license license:gpl3)))

;; This package includes minified JavaScript files.  When upgrading please
;; check that there are no new minified JavaScript files.
(define-public r-flexdashboard
  (package
    (name "r-flexdashboard")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "flexdashboard" version))
       (sha256
        (base32
         "0bvw2ca6xxscia4hvq505qvjf6zkgpsqv86f1s78aknzwr9jsikm"))
       (modules '((guix build utils)))
       (snippet
        '(begin
           ;; Delete bundled minified JavaScript files
           (delete-file "inst/htmlwidgets/lib/raphael/raphael-2.1.4.min.js")
           (delete-file "inst/www/sly/sly.min.js")
           (delete-file "inst/www/stickytableheaders/jquery.stickytableheaders.min.js")
           (delete-file "inst/www/prism/prism.js")
           (delete-file "inst/www/featherlight/featherlight.min.js")))))
    (build-system r-build-system)
    (arguments
     `(#:modules ((guix build utils)
                  (guix build r-build-system)
                  (srfi srfi-1)
                  (srfi srfi-26)
                  (ice-9 popen)
                  (ice-9 textual-ports))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst"
               ;; Concatenate all components of prism.js
               (let ((contents (string-join
                                (map (lambda (name)
                                       (call-with-input-file
                                           (assoc-ref inputs name)
                                         get-string-all))
                                     (list "js-prism"
                                           "js-prism-r"
                                           "js-prism-line-numbers"))
                                "\n")))
                 (call-with-output-file "prism-src.js"
                   (cut display contents <>)))
               (call-with-values
                   (lambda ()
                     (unzip2
                      `(("www/stickytableheaders/jquery.stickytableheaders.js"
                         "www/stickytableheaders/jquery.stickytableheaders.min.js")
                        ("www/sly/sly.js"
                         "www/sly/sly.min.js")
                        ("prism-src.js"
                         "www/prism/prism.js")
                        (,(assoc-ref inputs "js-raphael")
                         "htmlwidgets/lib/raphael/raphael-2.1.4.min.js")
                        (,(assoc-ref inputs "js-featherlight")
                         "www/featherlight/featherlight.min.js"))))
                 (lambda (sources targets)
                   (for-each (lambda (source target)
                               (format #t "Processing ~a --> ~a~%"
                                       source target)
                               (let ((minified (open-pipe* OPEN_READ "uglifyjs" source)))
                                 (call-with-output-file target
                                   (lambda (port)
                                     (dump-port minified port)))))
                             sources targets)))))))))
    (propagated-inputs
     (list r-bslib
           r-htmltools
           r-htmlwidgets
           r-jsonlite
           r-knitr
           r-rmarkdown
           r-sass
           r-scales
           r-shiny))
    (native-inputs
     `(("uglifyjs" ,node-uglify-js)
       ("js-raphael"
        ,(origin
           (method url-fetch)
           (uri "https://raw.githubusercontent.com/DmitryBaranovskiy/raphael/v2.1.4/raphael.js")
           (sha256
            (base32
             "1h4c4akrgcj7wra9j1z1rv2406j0yf68y9c0wg8v7w9ibw2iwf1x"))))
       ("js-prism"
        ,(origin
           (method url-fetch)
           (uri "https://raw.githubusercontent.com/PrismJS/prism/v1.16.0/prism.js")
           (sha256
            (base32
             "0gqa9irbp9k8p5r3d98cszajzhjnssnl43nrsc5aiy7ki52z500c"))))
       ("js-prism-r"
        ,(origin
           (method url-fetch)
           (uri "https://raw.githubusercontent.com/PrismJS/prism/v1.16.0/components/prism-r.js")
           (sha256
            (base32
             "1x31glci7wdgr2305njy0bm2lncb0jyn0j1s2g72rqi29xid9aki"))))
       ("js-prism-line-numbers"
        ,(origin
           (method url-fetch)
           (uri "https://raw.githubusercontent.com/PrismJS/prism/v1.16.0/plugins/line-numbers/prism-line-numbers.js")
           (sha256
            (base32
             "1543wgf3iynrilyb27jq8px3h5gvfz5xmdib5ik2ki400c1sl991"))))
       ("js-featherlight"
        ,(origin
           (method url-fetch)
           (uri "https://raw.githubusercontent.com/noelboss/featherlight/1.3.4/src/featherlight.js")
           (sha256
            (base32
             "14kkhwzvp8rxq2mrck5i0xcm8v5rqwqhwnmncbng8h4qq42zx3sb"))))))
    (home-page "https://rmarkdown.rstudio.com/flexdashboard")
    (synopsis "R Markdown format for flexible dashboards")
    (description
     "This package provides an R Markdown format for converting an R Markdown
document to a grid-oriented dashboard.  The dashboard flexibly adapts the size
of its components to the containing web page.")
    (license license:expat)))

(define-public r-preseqr
  (package
    (name "r-preseqr")
    (version "4.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "preseqR" version))
       (sha256
        (base32
         "1g2rnnmi45649vpy6z45v5i3wxm54s138ajqrzwi3a5r7x3xnhq1"))))
    (properties `((upstream-name . "preseqR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-polynom))
    (home-page "https://cran.r-project.org/web/packages/preseqR/")
    (synopsis "Predicting species accumulation curves")
    (description
     "This package can be used to predict the r-species accumulation
curve (r-SAC), which is the number of species represented at least r times as
a function of the sampling effort.  When r = 1, the curve is known as the
species accumulation curve, or the library complexity curve in high-throughput
genomic sequencing.  The package includes both parametric and nonparametric
methods, as described by Deng C, et al. (2018).")
    (license license:gpl3)))

(define-public r-mapplots
  (package
    (name "r-mapplots")
    (version "1.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mapplots" version))
       (sha256
        (base32
         "18s2y66f8vi8g2r8a25zbgp2xm079r8v8qxv0w71h8krycs6vs9p"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/mapplots/")
    (synopsis "Data visualization on maps")
    (description
     "This package helps you create simple maps; add sub-plots like pie plots
to a map or any other plot; format, plot and export gridded data.  The package
was developed for displaying fisheries data but most functions can be used for
more generic data visualisation.")
    (license license:gpl2+)))

(define-public r-pmcmr
  (package
    (name "r-pmcmr")
    (version "4.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "PMCMR" version))
       (sha256
        (base32
         "05n13pp5yff6pzk4ry07crddfaj3jlglrd1vkcnacyd8jpaxkd77"))))
    (properties `((upstream-name . "PMCMR")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/PMCMR/")
    (synopsis "Calculate pairwise multiple comparisons of mean rank sums")
    (description
     "This is a deprecated package for calculating pairwise multiple
comparisons of mean rank sums.  This package is superseded by the novel
PMCMRplus package.  The PMCMR package is no longer maintained, but kept for
compatibility of dependent packages for some time.")
    (license license:gpl3+)))

(define-public r-downloader
  (package
    (name "r-downloader")
    (version "0.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "downloader" version))
       (sha256
        (base32
         "1axggnsc27zzgr7snf41j3zd1vp3nfpmq4zj4d01axc709dyg40q"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-digest))
    (home-page "https://github.com/wch/downloader")
    (synopsis "Download files over HTTP and HTTPS")
    (description
     "This package provides a wrapper for the @code{download.file} function,
making it possible to download files over HTTPS across platforms.  The
@code{RCurl} package provides this functionality (and much more) but has
external dependencies.  This package has is implemented purely in R.")
    (license license:gpl2)))

(define-public r-aplot
  (package
    (name "r-aplot")
    (version "0.1.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "aplot" version))
       (sha256
        (base32
         "17256cdn46cii97s0h2zmah9vs116ybnih78734lpkn7kmvdfcfr"))))
    (properties `((upstream-name . "aplot")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggfun
           r-ggplot2
           r-ggplotify
           r-magrittr
           r-patchwork))
    (home-page "https://github.com/YuLab-SMU/aplot")
    (synopsis "Decorate a ggplot with associated information")
    (description
     "Users may want to align plots with associated information that requires
axes to be exactly matched in subplots, e.g. hierarchical clustering with a
heatmap.  This package provides utilities to align associated subplots to a
main plot at different sides (left, right, top and bottom) with axes exactly
matched.")
    (license license:artistic2.0)))

(define-public r-ggnewscale
  (package
    (name "r-ggnewscale")
    (version "0.4.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggnewscale" version))
       (sha256
        (base32
         "004p5ai6rc5y8f6966k894jzw9v3m4zy36z50yapig7c85lzmzn7"))))
    (properties `((upstream-name . "ggnewscale")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2))
    (home-page "https://cran.r-project.org/package=ggnewscale")
    (synopsis "Multiple fill and color scales in ggplot2")
    (description
     "This package lets you use multiple fill and color scales in ggplot2.")
    (license license:gpl3)))

(define-public r-ggpointdensity
  (package
    (name "r-ggpointdensity")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggpointdensity" version))
       (sha256
        (base32
         "0c9a14j3b0hvamqylhzldw2hjdxmfbllwahjkf3gg2rw337ld9iy"))))
    (properties
     `((upstream-name . "ggpointdensity")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2))
    (home-page "https://github.com/LKremer/ggpointdensity")
    (synopsis "Cross between a 2D density plot and a scatter plot")
    (description
     "This package provides a cross between a 2D density plot and a scatter
plot, implemented as a ggplot2 @code{geom}.  Points in the scatter plot are
colored by the number of neighboring points.  This is useful to visualize the
2D-distribution of points in case of overplotting.")
    (license license:gpl3)))

(define-public r-arrow
  (package
    (name "r-arrow")
    (version "10.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "arrow" version))
       (sha256
        (base32
         "04qsj68zsqcwkv1ryp4l0is474siyi1b64dy41fr74ryj7mbamg8"))))
    (properties `((upstream-name . "arrow")))
    (build-system r-build-system)
    (inputs
     (list `(,apache-arrow "lib") zlib))
    (propagated-inputs
     (list r-assertthat
           r-bit64
           r-cpp11
           r-glue
           r-purrr
           r-r6
           r-rlang
           r-tidyselect
           r-vctrs))
    (native-inputs
     (list pkg-config r-knitr))
    (home-page "https://github.com/apache/arrow/")
    (synopsis "R integration to Apache Arrow")
    (description
     "Apache Arrow is a cross-language development platform for in-memory
data.  It specifies a standardized language-independent columnar memory format
for flat and hierarchical data, organized for efficient analytic operations on
modern hardware.  This package provides an R interface to the Arrow C++
library.")
    (license license:asl2.0)))

(define-public r-rex
  (package
    (name "r-rex")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rex" version))
       (sha256
        (base32
         "1mmzlc3j7xa0rbjxa369f4sr0iw3gq58g8fmjjxbsjvfq14ychmg"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lazyeval))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/kevinushey/rex")
    (synopsis "Friendly regular expressions")
    (description
     "This package provides a friendly interface for the construction of
regular expressions.  Regular expressions are a very powerful feature, however
they are often difficult to interpret.  Rex allows you to build complex
regular expressions from human readable expressions")
    (license license:expat)))

(define-public r-mlapi
  (package
    (name "r-mlapi")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mlapi" version))
       (sha256
        (base32
         "1qyiii6x9b89i4pd4yi2zd23aabpmnpj18gqi5va0zy0l8r7kknr"))))
    (properties `((upstream-name . "mlapi")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-matrix r-r6))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/package=mlapi")
    (synopsis "Abstract classes for building scikit-learn like API")
    (description
     "This package provides R6 abstract classes for building machine learning
models with a scikit-learn like API.  Scikit-learn is a popular module for the
Python programming language whose design became a de facto standard in
industry for machine learning tasks.")
    (license license:expat)))

(define-public r-float
  (package
    (name "r-float")
    (version "0.3-0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "float" version))
       (sha256
        (base32
         "0m7bf3548vlgkk1c78jyrgj72ngwg0gsccap2iqinm3l3qrm4zbs"))))
    (properties `((upstream-name . "float")))
    (build-system r-build-system)
    (native-inputs
     (list gfortran))
    (home-page "https://github.com/wrathematics/float")
    (synopsis "32-bit floats")
    (description
     "R comes with a suite of utilities for linear algebra with
\"numeric\" (double precision) vectors/matrices.  However, sometimes single
precision (or less!) is more than enough for a particular task.  This package
extends R's linear algebra facilities to include 32-bit float (single
precision) data.  Float vectors/matrices have half the precision of their
\"numeric\"-type counterparts but are generally faster to numerically operate
on, for a performance vs accuracy trade-off.")
    (license license:bsd-2)))

(define-public r-rsparse
  (package
    (name "r-rsparse")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rsparse" version))
       (sha256
        (base32
         "15kdllm2lh6xdlv4j0ljyj5pczhx26s9d8cac7953zbb0sd45chz"))))
    (properties `((upstream-name . "rsparse")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-data-table
           r-float
           r-lgr
           r-matrix
           r-matrixextra
           r-rcpp
           r-rcpparmadillo
           r-rhpcblasctl))
    (home-page "https://github.com/rexyai/rsparse")
    (synopsis "Statistical learning on sparse matrices")
    (description
     "This package implements many algorithms for statistical learning on
sparse matrices: matrix factorizations, matrix completion, elastic net
regressions, factorization machines.  The rsparse package also enhances the
Matrix package by providing methods for multithreaded <sparse, dense> matrix
products and native slicing of the sparse matrices in @dfn{Compressed Sparse
Row} (CSR) format.")
    (license license:gpl2+)))

(define-public r-text2vec
  (package
    (name "r-text2vec")
    (version "0.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "text2vec" version))
       (sha256
        (base32
         "1as58w1hb6h0hpncwcr2nx9a8bj5fy6bfllx2a8ck8hal764iach"))))
    (properties `((upstream-name . "text2vec")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-data-table
           r-digest
           r-lgr
           r-matrix
           r-mlapi
           r-r6
           r-rcpp
           r-rsparse
           r-stringi))
    (native-inputs
     (list r-knitr))
    (home-page "http://text2vec.org")
    (synopsis "Text mining framework for R")
    (description
     "This package provides fast and memory-friendly tools for text
vectorization, topic modeling (LDA, LSA), word embeddings (GloVe),
similarities.  It provides a source-agnostic streaming API, which allows
researchers to perform analysis of collections of documents which are larger
than available RAM.  All core functions are parallelized to benefit from
multicore machines.")
    (license license:gpl2+)))

(define-public r-mcmcpack
  (package
    (name "r-mcmcpack")
    (version "1.6-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "MCMCpack" version))
       (sha256
        (base32
         "1cwdjn43b9hxpxf9mnas583myhk6r2258mh57f0zsc8bd4hbl56b"))))
    (properties `((upstream-name . "MCMCpack")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-coda r-lattice r-mass r-mcmc r-quantreg))
    (home-page "https://cran.r-project.org/package=MCMCpack")
    (synopsis "Markov Chain Monte Carlo (MCMC) package")
    (description
     "This package contains functions to perform Bayesian inference using
posterior simulation for a number of statistical models.  Most simulation is
done in compiled C++ written in the Scythe Statistical Library.  All models
return @code{coda} @code{mcmc} objects that can then be summarized using the
@code{coda} package.  Some useful utility functions such as density functions,
pseudo-random number generators for statistical distributions, a general
purpose Metropolis sampling algorithm, and tools for visualization are
provided.")
    (license license:gpl3)))

(define-public r-xmlparsedata
  (package
    (name "r-xmlparsedata")
    (version "1.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "xmlparsedata" version))
       (sha256
        (base32
         "1c6bnz3ng1qw7sfip8wq3a4dn36a4d6rbja0sadn0a4pbsmk8q3n"))))
    (properties `((upstream-name . "xmlparsedata")))
    (build-system r-build-system)
    (home-page "https://github.com/r-lib/xmlparsedata#readme")
    (synopsis "Parse data of @code{R} code as an @code{XML} tree")
    (description
     "This package provides tools to convert the output of
@code{utils::getParseData()} to an @code{XML} tree, that one can search via
@code{XPath}, and is easier to manipulate in general.")
    (license license:expat)))

(define-public r-cyclocomp
  (package
    (name "r-cyclocomp")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cyclocomp" version))
       (sha256
        (base32
         "0gky3svk02wiajw7nfjh30684h3qxili4bvsab0m7b6cggw6bgyd"))))
    (properties `((upstream-name . "cyclocomp")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-callr r-crayon r-desc r-remotes r-withr))
    (home-page "https://github.com/MangoTheCat/cyclocomp")
    (synopsis "Cyclomatic complexity of R code")
    (description
     "Cyclomatic complexity is a software metric, used to indicate the
complexity of a program.  It is a quantitative measure of the number of
linearly independent paths through a program's source code.  This package
provides tools to compute this metric.")
    (license license:expat)))

(define-public r-lintr
  (package
    (name "r-lintr")
    (version "3.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lintr" version))
       (sha256
        (base32
         "1j9l5lsa88hl5b3lw1789868pm0m2sbahyqayj9213d7zspp0slz"))))
    (properties `((upstream-name . "lintr")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-backports
           r-codetools
           r-crayon
           r-cyclocomp
           r-digest
           r-glue
           r-jsonlite
           r-knitr
           r-rex
           r-xml2
           r-xmlparsedata))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/jimhester/lintr")
    (synopsis "Linter for R code")
    (description "This package checks adherence to a given style, syntax
errors and possible semantic issues.  It supports on the fly checking of R
code edited with @code{RStudio IDE}, @code{Emacs} and @code{Vim}.")
    (license license:expat)))

(define-public r-scs
  (package
    (name "r-scs")
    (version "3.0-1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "scs" version))
              (sha256
               (base32
                "04srf33zw4dxv22b1h5qwjch5yg7hrvk4iq8yvxqnbr8qzp1x26n"))))
    (properties `((upstream-name . "scs")))
    (build-system r-build-system)
    (home-page "https://github.com/FlorianSchwendinger/scs")
    (synopsis "Splitting conic solver")
    (description
     "This package solves convex cone programs via operator splitting.
It can solve: linear programs, second-order cone programs,
semidefinite programs, exponential cone programs, and power cone
programs, or problems with any combination of those cones.  SCS uses
AMD (a set of routines for permuting sparse matrices prior to
factorization) and LDL (a sparse LDL factorization and solve package)
from SuiteSparse.")
    (license license:gpl3)))

(define-public r-sctransform
  (package
    (name "r-sctransform")
    (version "0.3.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sctransform" version))
       (sha256
        (base32
         "02vfgv6v3knmn5nxadjyjkzqmni1sgaf3f9ywm7d0knn0pgmd3n0"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr
           r-future
           r-future-apply
           r-ggplot2
           r-gridextra
           r-magrittr
           r-mass
           r-matrix
           r-matrixstats
           r-rcpp
           r-rcpparmadillo
           r-reshape2
           r-rlang))
    (home-page "https://github.com/ChristophH/sctransform")
    (synopsis "Variance stabilizing transformations for Single Cell UMI Data")
    (description
     "This package provides a normalization method for single-cell UMI count
data using a variance stabilizing transformation.  The transformation is based
on a negative binomial regression model with regularized parameters.  As part
of the same regression framework, this package also provides functions for
batch correction, and data correction.")
    (license license:gpl3)))

(define-public r-styler
  (package
    (name "r-styler")
    (version "1.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "styler" version))
       (sha256
        (base32
         "1iw4nj68aj4psysrpyy7s6g3r3vhpfk8s05n6d20m2qmmk0p92sg"))))
    (build-system r-build-system)
    ;; This is needed by R.cache.
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (propagated-inputs
     (list r-cli
           r-magrittr
           r-purrr
           r-r-cache
           r-rlang
           r-rprojroot
           r-vctrs
           r-withr))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/r-lib/styler")
    (synopsis "Non-invasive pretty printing of R code")
    (description
     "This is a package for pretty-printing R code without changing the user's
formatting intent.")
    (license license:gpl3)))

(define-public r-scrime
  (package
    (name "r-scrime")
    (version "1.3.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "scrime" version))
       (sha256
        (base32
         "0y2mh9fsffjf3i15bafpasa17z99c1s75r8g6h4hgcwfgpjx75sx"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/scrime/")
    (synopsis "Analysis of high-dimensional categorical data such as SNP data")
    (description
     "This package provides tools for the analysis of high-dimensional data
developed/implemented at the group \"Statistical Complexity Reduction In
Molecular Epidemiology\" (SCRIME).  The main focus is on SNP data, but most of
the functions can also be applied to other types of categorical data.")
    (license license:gpl2)))

(define-public r-pbmcapply
  (package
    (name "r-pbmcapply")
    (version "1.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pbmcapply" version))
       (sha256
        (base32
         "1p8jf7c4k45482w72sr0jw4jkz787krrxai3sl6jz5l4lda2iz3z"))))
    (build-system r-build-system)
    (home-page "https://github.com/kvnkuang/pbmcapply")
    (synopsis "Track the progress of apply procedures with a progress bar")
    (description
     "This light-weight package helps you track and visualize the progress of
parallel versions of vectorized R functions of the @code{mc*apply} family.")
    (license license:expat)))

(define-public r-blme
  (package
    (name "r-blme")
    (version "1.0-5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "blme" version))
       (sha256
        (base32
         "0413j7gwr5yj14jamkizj55q7xii1a0kgazzj0ilqn2ascclz6k7"))))
    (build-system r-build-system)
    (propagated-inputs (list r-lme4))
    (home-page "https://github.com/vdorie/blme")
    (synopsis "Bayesian linear mixed-effects models")
    (description
     "This package provides tools for maximum a posteriori estimation for
linear and generalized linear mixed-effects models in a Bayesian setting.  It
extends the lme4 package.")
    (license license:gpl2+)))

(define-public r-batchtools
  (package
    (name "r-batchtools")
    (version "0.9.15")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "batchtools" version))
       (sha256
        (base32
         "0d2xy77hkzhcnyz8zxcv98i80fx6ripjw4rvyx4ww1d0vjjgqf52"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-backports
           r-base64url
           r-brew
           r-checkmate
           r-data-table
           r-digest
           r-fs
           r-progress
           r-r6
           r-rappdirs
           r-stringi
           r-withr))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/mllg/batchtools")
    (synopsis "Tools for computation on batch systems")
    (description
     "As a successor of the packages BatchJobs and BatchExperiments, this
package provides a parallel implementation of the Map function for high
performance computing systems managed by various schedulers.  A multicore and
socket mode allow the parallelization on a local machines, and multiple
machines can be hooked up via SSH to create a makeshift cluster.  Moreover,
the package provides an abstraction mechanism to define large-scale computer
experiments in a well-organized and reproducible way.")
    (license license:lgpl3)))

(define-public r-clue
  (package
    (name "r-clue")
    (version "0.3-62")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "clue" version))
       (sha256
        (base32
         "1lhybs6rhq8zs7q15ahng7c93liiygr64i2zwg3ya6maqji3ynjp"))))
    (build-system r-build-system)
    (propagated-inputs (list r-cluster))
    (home-page "https://cran.r-project.org/web/packages/clue/")
    (synopsis "Tools for analyzing cluster ensembles")
    (description "Cluster ensembles are collections of individual solutions to
a given clustering problem which are useful or necessary to consider in a wide
range of applications.  This R package provides an extensible computational
environment for creating and analyzing cluster ensembles, with basic data
structures for representing partitions and hierarchies, and facilities for
computing on them, including methods for measuring proximity and obtaining
consensus and secondary clusterings.")
    (license license:gpl2)))

(define-public r-sitmo
  (package
    (name "r-sitmo")
    (version "2.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sitmo" version))
       (sha256
        (base32
         "1hm89zi38ldgbskyx1cn7gm87yqy7zrxli8q05a36y1ndvazi3j4"))))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/coatless/sitmo/")
    (synopsis "Parallel pseudo random number generator header files")
    (description
     "This package provides two high quality and fast PPRNGs that may be used
in an OpenMP parallel environment.  In addition, there is a generator for one
dimensional low-discrepancy sequence.")
    (license license:expat)))

(define-public r-dqrng
  (package
    (name "r-dqrng")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dqrng" version))
       (sha256
        (base32
         "1fwsldqcri2lccna4icbmmlqic3w4xyjm7rn0xmikrsw4kzapvjb"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bh r-rcpp r-sitmo))
    (native-inputs
     (list r-knitr))
    (home-page "https://www.daqana.org/dqrng")
    (synopsis "Fast pseudo random number generators")
    (description
     "Several fast random number generators are provided as C++ header-only
libraries: the PCG family as well as Xoroshiro128+ and Xoshiro256+.
Additionally, fast functions for generating random numbers according to a
uniform, normal and exponential distribution are included.  The latter two use
the Ziggurat algorithm originally proposed by Marsaglia and Tsang.  These
functions are exported to R and as a C++ interface and are enabled for use
with the default 64 bit generator from the PCG family, Xoroshiro128+ and
Xoshiro256+ as well as the 64 bit version of the 20 rounds Threefry
engine (Salmon et al., 2011) as provided by the package @code{sitmo}.")
    ;; This package includes code under CC0 and Apache 2.0 or Expat, but as a
    ;; whole is distributed under the terms of the AGPL 3.
    (license license:agpl3)))

(define-public r-ingredients
  (package
    (name "r-ingredients")
    (version "2.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ingredients" version))
       (sha256
        (base32
         "11bv4l4fn9kr7y2nfzrwnaya8fi9w3nwcm9vzlqb7dva83rkqbsc"))))
    (properties `((upstream-name . "ingredients")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-gridextra r-scales))
    (native-inputs (list r-knitr))
    (home-page "https://ModelOriented.github.io/ingredients/")
    (synopsis "Effects and importances of model ingredients")
    (description
     "This is a collection of tools for assessment of feature importance and
feature effects.  Key functions are:

@itemize
@item @code{feature_importance()} for assessment of global level feature
  importance,
@item @code{ceteris_paribus()} for calculation of the what-if plots,
@item @code{partial_dependence()} for partial dependence plots,
@item @code{conditional_dependence()} for conditional dependence plots,
@item @code{accumulated_dependence()} for accumulated local effects plots,
@item @code{aggregate_profiles()} and @code{cluster_profiles()} for
  aggregation of ceteris paribus profiles,
@item generic @code{print()} and @code{plot()} for better usability of
  selected explainers,
@item generic @code{plotD3()} for interactive, D3 based explanations, and
@item generic @code{describe()} for explanations in natural language.
@end itemize\n")
    (license license:gpl3)))

(define-public r-ibreakdown
  (package
    (name "r-ibreakdown")
    (version "2.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "iBreakDown" version))
       (sha256
        (base32
         "00jzrndb3ahsv6ihp2pvs732n9cc944m83vdinrl9v1pxd82prkh"))))
    (properties `((upstream-name . "iBreakDown")))
    (build-system r-build-system)
    (propagated-inputs (list r-ggplot2))
    (native-inputs (list r-knitr))
    (home-page "https://ModelOriented.github.io/iBreakDown/")
    (synopsis "Model agnostic instance level variable attributions")
    (description
     "This package provides a model agnostic tool for decomposition of
predictions from black boxes.  It supports additive attributions and
attributions with interactions.  The Break Down Table shows contributions of
every variable to a final prediction.  The Break Down Plot presents variable
contributions in a concise graphical way.  This package works for
classification and regression models.")
    (license license:gpl3)))

(define-public r-dae
  (package
    (name "r-dae")
    (version "3.2-13")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dae" version))
       (sha256
        (base32
         "0mq94ah21p1glvsbvdmi2p7nlgz1bvq7w3rz2z3mdqq18kz6nkjw"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-plyr))
    (native-inputs
     (list r-r-rsp)) ; vignette builder
    (home-page "http://chris.brien.name")
    (synopsis "Functions useful in the design and ANOVA of experiments")
    (description
     "This package provides functions useful in the design and ANOVA of
experiments.  The content falls into the following groupings:

@enumerate
@item data,
@item factor manipulation functions,
@item design functions,
@item ANOVA functions,
@item matrix functions,
@item projector and canonical efficiency functions, and
@item miscellaneous functions.
@end enumerate

There is a vignette called @code{DesignNotes} describing how to use the design
functions for randomizing and assessing designs.  The ANOVA functions
facilitate the extraction of information when the @code{Error} function has
been used in the call to @code{aov}.")
    (license license:gpl2)))

(define-public r-dalex
  (package
    (name "r-dalex")
    (version "2.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "DALEX" version))
       (sha256
        (base32
         "1m19ibv8rpghqm4vr8nrvarrjkm9rxw6jx8xl3hzrqnnmf2xifqr"))))
    (properties `((upstream-name . "DALEX")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-ibreakdown r-ingredients))
    (home-page "https://pbiecek.github.io/DALEX/")
    (synopsis "Descriptive machine learning explanations")
    (description
     "Machine Learning models are widely used and have various applications in
classification or regression.  Models created with boosting, bagging, stacking
or similar techniques are often used due to their high performance, but such
black-box models usually lack interpretability.  The DALEX package contains
various explainers that help to understand the link between input variables
and model output.")
    ;; Any version of the GPL
    (license license:gpl3+)))

(define-public r-enrichr
  (package
    (name "r-enrichr")
    (version "3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "enrichR" version))
       (sha256
        (base32
         "0ad7jp398prvmm2fym07268qhv40mg67dx55ml4ayqkwxwffr1i9"))))
    (properties `((upstream-name . "enrichR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-curl r-ggplot2 r-httr r-rjson))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/enrichR/")
    (synopsis "R Interface to Enrichr database for analyzing gene sets")
    (description
     "This package provides an R interface to all Enrichr databases, a
web-based tool for analyzing gene sets and returns any enrichment of common
annotated biological functions.")
    (license license:gpl2+)))

(define-public r-plot3d
  (package
    (name "r-plot3d")
    (version "1.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "plot3D" version))
       (sha256
        (base32
         "1h59zlsyzbjylaziwavppl9bjmnba4iiq34772y3dys6fqclajnh"))))
    (properties `((upstream-name . "plot3D")))
    (build-system r-build-system)
    (propagated-inputs (list r-misc3d))
    (home-page "https://cran.r-project.org/web/packages/plot3D")
    (synopsis "Plot multi-dimensional data")
    (description
     "This package provides functions for viewing 2D and 3D data, including
perspective plots, slice plots, surface plots, scatter plots, etc.  It
includes data sets from oceanography.")
    (license license:gpl3+)))

(define-public r-ggfortify
  (package
    (name "r-ggfortify")
    (version "0.4.14")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggfortify" version))
       (sha256
        (base32
         "038m74azpy43869ax1yi6wxbl1kr59iaxl8raiikjg749vcx6njw"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr
           r-ggplot2
           r-gridextra
           r-scales
           r-stringr
           r-tibble
           r-tidyr))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/sinhrks/ggfortify")
    (synopsis "Data visualization tools for statistical analysis results")
    (description
     "This package provides unified plotting tools for statistics commonly
used, such as GLM, time series, PCA families, clustering and survival
analysis.  The package offers a single plotting interface for these analysis
results and plots in a unified style using the @code{ggplot2} package.")
    (license license:gpl2)))

(define-public r-refmanager
  (package
    (name "r-refmanager")
    (version "1.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RefManageR" version))
       (sha256
        (base32
         "1kjd66gp2z9fzrnyr1bqfd9p58q0bin3a187z9b56hiqmdjhyc78"))))
    (properties `((upstream-name . "RefManageR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bibtex
           r-httr
           r-jsonlite
           r-lubridate
           r-plyr
           r-stringr
           r-xml2))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/ropensci/RefManageR/")
    (synopsis "Straightforward BibTeX and BibLaTeX bibliography management")
    (description
     "This package provides tools for importing and working with bibliographic
references.  It greatly enhances the @code{bibentry} class by providing a
class @code{BibEntry} which stores BibTeX and BibLaTeX references, supports
UTF-8 encoding, and can be easily searched by any field, by date ranges, and
by various formats for name lists (author by last names, translator by full
names, etc.).  Entries can be updated, combined, sorted, printed in a number
of styles, and exported.  BibTeX and BibLaTeX @code{.bib} files can be read
into R and converted to @code{BibEntry} objects.")
    ;; Any of these licenses may be picked.
    (license (list license:gpl2 license:gpl3 license:bsd-3))))

(define-public r-citr
  (package
    (name "r-citr")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "citr" version))
       (sha256
        (base32
         "1qbarvafjb8jgkrnrhh6jw7mcglmjwf7dpdiibxf39jkmlhf7las"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertthat
           r-curl
           r-httr
           r-miniui
           r-refmanager
           r-rstudioapi
           r-shiny
           r-shinyjs
           r-yaml))
    (home-page "https://github.com/crsh/citr")
    (synopsis "RStudio add-in to insert Markdown citations")
    (description
     "This package provides functions and an RStudio add-in that search a
BibTeX or BibLaTeX file to create and insert formatted Markdown citations into
the current document.")
    (license license:expat)))

(define-public r-xgboost
  (package
    (name "r-xgboost")
    (version "1.6.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "xgboost" version))
       (sha256
        (base32
         "1gafjv6vcpny03lqw8s68xszalsylniavaqwsbzh46vyk4h9mscs"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-data-table r-jsonlite r-matrix))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/dmlc/xgboost")
    (synopsis "Extreme gradient boosting")
    (description
     "This package provides an R interface to Extreme Gradient Boosting, which
is an efficient implementation of the gradient boosting framework from Chen
and Guestrin (2016).  The package includes efficient linear model solver and
tree learning algorithms.  The package can automatically do parallel
computation on a single machine.  It supports various objective functions,
including regression, classification and ranking.  The package is made to be
extensible, so that users are also allowed to define their own objectives
easily.")
    (license license:asl2.0)))

(define-public r-umap
  (package
    (name "r-umap")
    (version "0.2.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "umap" version))
       (sha256
        (base32
         "1282v09kpds83mlr7kz06k8a40ji15hw85p30vrnp1g6w64w26sm"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-matrix r-openssl r-rcpp r-reticulate r-rspectra))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/tkonopka/umap")
    (synopsis "Uniform manifold approximation and projection")
    (description
     "Uniform manifold approximation and projection is a technique for
dimension reduction.  This package provides an interface to the UMAP algorithm
in R, including a translation of the original algorithm into R.")
    (license license:expat)))

(define-public r-uwot
  (package
    (name "r-uwot")
    (version "0.1.14")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "uwot" version))
       (sha256
        (base32
         "1q4z98w3pkc51vrcpmwaibnwmlm17zjcnh0qlx660wky5ccyh5l0"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dqrng
           r-fnn
           r-irlba
           r-matrix
           r-rcpp
           r-rcppannoy
           r-rcppprogress))
    (home-page "https://github.com/jlmelville/uwot")
    (synopsis "Uniform manifold approximation and projection")
    (description
     "This package provides an implementation of the Uniform Manifold
Approximation and Projection dimensionality reduction by McInnes et
al. (2018).  It also provides means to transform new data and to carry out
supervised dimensionality reduction.  An implementation of the related
LargeVis method of Tang et al. (2016) is also provided.")
    (license license:gpl3)))

(define-public r-kableextra
  (package
    (name "r-kableextra")
    (version "1.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "kableExtra" version))
       (sha256
        (base32
         "1c5vzy95cbz36jwyssr927qicrayifinv861rvnmg4nghb1gl7q9"))))
    (properties `((upstream-name . "kableExtra")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-digest
           r-glue
           r-htmltools
           r-knitr
           r-magrittr
           r-rmarkdown
           r-rstudioapi
           r-rvest
           r-scales
           r-stringr
           r-svglite
           r-viridislite
           r-webshot
           r-xml2))
    (native-inputs
     (list r-knitr))
    (home-page "https://haozhu233.github.io/kableExtra/")
    (synopsis "Construct complex tables with pipe syntax")
    (description
     "Build complex HTML or LaTeX tables using @code{kable()} from
@code{knitr} and the piping syntax from @code{magrittr}.  The function
@code{kable()} is a light weight table generator coming from @code{knitr}.
This package simplifies the way to manipulate the HTML or LaTeX codes
generated by @code{kable()} and allows users to construct complex tables and
customize styles using a readable syntax.")
    (license license:expat)))

(define-public r-glasso
  (package
    (name "r-glasso")
    (version "1.11")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "glasso" version))
       (sha256
        (base32 "02p3612rpydk195n2qr77lp1j2w8zsw1ckkk98c8angm4r5q8dsc"))))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://statweb.stanford.edu/~tibs/glasso/")
    (synopsis "Graphical Lasso: estimation of Gaussian graphical models")
    (description
     "This is a package for estimation of a sparse inverse covariance matrix
using a lasso (L1) penalty.  Facilities are provided for estimates along a
path of values for the regularization parameter.")
    (license license:gpl2)))

(define-public r-gldex
  (package
    (name "r-gldex")
    (version "2.0.0.9.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "GLDEX" version))
              (sha256
               (base32
                "0pikq5aywky77sbbkga7s0ww3ywlarx336rgpyiigr72fmjvb289"))))
    (properties `((upstream-name . "GLDEX")))
    (build-system r-build-system)
    (propagated-inputs (list r-cluster r-spacefillr))
    (home-page "https://cran.r-project.org/package=GLDEX")
    (synopsis "Fitting single and mixture of generalised lambda distributions")
    (description
     "@code{GLDEX} offers fitting algorithms corresponding to two major
objectives.  One is to provide a smoothing device to fit distributions to data
using the weighted and unweighted discretised approach based on the bin width
of the histogram.  The other is to provide a definitive fit to the data set
using the maximum likelihood and quantile matching estimation.  Other methods
such as moment matching, starship method, and L moment matching are also
provided.  Diagnostics on goodness of fit can be done via qqplots, KS-resample
tests and comparing mean, variance, skewness and kurtosis of the data with the
fitted distribution.")
    (license license:gpl3+)))

(define-public r-rhpcblasctl
  (package
    (name "r-rhpcblasctl")
    (version "0.21-247.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RhpcBLASctl" version))
       (sha256
        (base32
         "0scpr6jq25xx7wmqyc380ann4h536ll0g7wblikk25yqvpamzrav"))))
    (properties `((upstream-name . "RhpcBLASctl")))
    (build-system r-build-system)
    (home-page "https://prs.ism.ac.jp/~nakama/Rhpc/")
    (synopsis "Control the number of threads on BLAS")
    (description
     "This package allows you to control the number of threads the BLAS
library uses.  It is also possible to control the number of threads in
OpenMP.")
    (license license:agpl3+)))

(define-public r-lda
  (package
    (name "r-lda")
    (version "1.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lda" version))
       (sha256
        (base32
         "03r4h5kgr8mfy44p66mfj5bp4k00g8zh4a1mhn46jw14pkhs21jn"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/lda/")
    (synopsis "Collapsed Gibbs sampling methods for topic models")
    (description
     "This package implements @dfn{latent Dirichlet allocation} (LDA) and
related models.  This includes (but is not limited to) sLDA, corrLDA, and the
mixed-membership stochastic blockmodel.  Inference for all of these models is
implemented via a fast collapsed Gibbs sampler written in C.  Utility
functions for reading/writing data typically used in topic models, as well as
tools for examining posterior distributions are also included.")
    ;; Any version of the LGPL
    (license license:lgpl3+)))

(define-public r-rann-l1
  (package
    (name "r-rann-l1")
    (version "2.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RANN.L1" version))
       (sha256
        (base32
         "1hanh3my84mdr5wy6b89fawqzfc184vff1y65wy4l5ld9qza1n44"))))
    (properties `((upstream-name . "RANN.L1")))
    (build-system r-build-system)
    (home-page "https://github.com/jefferis/RANN/tree/master-L1")
    (synopsis "Fast nearest neighbour search using L1 metric")
    (description
     "This package provides tools to find the k nearest neighbours for every
point in a given dataset in O(N log N) time using Arya and Mount's ANN
library.  There is support for approximate as well as exact searches, fixed
radius searches and @code{bd} as well as @code{kd} trees.  The distance is
computed using the L1 (Manhattan, taxicab) metric.")
    (license license:gpl3+)))

(define-public r-leiden
  (package
    (name "r-leiden")
    (version "0.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "leiden" version))
       (sha256
        (base32
         "0f09k3mhb0di2cz1q95y6qd3rqh7xdybn0dpnd4ifqhfhr5lnika"))))
    (properties `((upstream-name . "leiden")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-igraph r-matrix r-reticulate))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/TomKellyGenetics/leiden")
    (synopsis "R implementation of Leiden clustering algorithm")
    (description
     "This package implements the Python @code{leidenalg} module to be called
in R.  It enables clustering using the Leiden algorithm for partitioning a
graph into communities.  See also Traag et al (2018) \"From Louvain to Leiden:
guaranteeing well-connected communities.\" <arXiv:1810.08473>.")
    (license license:gpl3)))

(define-public r-patchwork
  (package
    (name "r-patchwork")
    (version "1.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "patchwork" version))
       (sha256
        (base32
         "0xw9mh1qakj131nw98icxrxwvdlwy2ngwvmagrqr3m84sz9dbffs"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-gtable))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/thomasp85/patchwork")
    (synopsis "Compose ggplot2 plots")
    (description
     "The @code{ggplot2} package provides a strong API for sequentially
building up a plot, but does not concern itself with composition of multiple
plots.  Patchwork is a package that expands the API to allow for arbitrarily
complex composition of plots by providing mathematical operators for combining
multiple plots.")
    (license license:expat)))

(define-public r-liger
  (package
    (name "r-liger")
    (version "0.4.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/MacoskoLab/liger")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "16dzwwcpw6n78pxlc5w3kraigki35ix7zhd2cbx5f3y60bbkhlmx"))
       (modules '((guix build utils)))
       (snippet
        '(begin
           (delete-file "inst/java/ModularityOptimizer.jar")
           #t))))
    (build-system r-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'build-java-part
           (lambda* (#:key inputs #:allow-other-keys)
             (invoke "unzip" (assoc-ref inputs "optimizer-src"))
             (for-each (lambda (file) (invoke "javac" file))
                       (find-files "." "\\.java$"))
             (apply invoke "jar" "cf" "inst/java/ModularityOptimizer.jar"
                    (find-files "." "\\.class$"))
             #t)))))
    (propagated-inputs
     (list r-cowplot
           r-dosnow
           r-dplyr
           r-fnn
           r-foreach
           r-ggplot2
           r-ggrepel
           r-hmisc
           r-ica
           r-irlba
           r-matrix
           r-mclust
           r-patchwork
           r-plyr
           r-rann-l1
           r-rcpp
           r-rcpparmadillo
           r-riverplot
           r-rtsne
           r-snow))
    (native-inputs
     `(("jdk" ,icedtea "jdk")
       ;; See https://github.com/MacoskoLab/liger/issues/96
       ;; The optimizer is released under the Expat license.
       ("optimizer-src"
        ,(origin
           (method url-fetch)
           (uri "http://www.ludowaltman.nl/slm/modularity_optimizer_source.zip")
           (sha256
            (base32
             "01hmm6sapcmldvayknqx2w4cav3qv71mwwkdkwj4qgq6dss09g18"))))
       ("unzip" ,unzip)
       ("r-knitr" ,r-knitr))) ; for vignettes
    (home-page "https://github.com/MacoskoLab/liger")
    (synopsis "Integrate and analyze multiple single-cell datasets")
    (description
     "LIGER is a package for integrating and analyzing multiple single-cell
datasets, developed and maintained by the Macosko lab.  It relies on
integrative non-negative matrix factorization to identify shared and
dataset-specific factors.")
    (license license:gpl3)))

(define-public r-harmony
  (package
    (name "r-harmony")
    (version "0.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/immunogenomics/harmony")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "05r401q09rbr6fqhb9mbd95082cjdi3nag1cv6zn96xkr0f6imq9"))
       (modules '((guix build utils)))
       (snippet
        '(begin
           (for-each delete-file '("config.status" "configure"))
           #t))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cowplot
           r-dplyr
           r-ggplot2
           r-irlba
           r-matrix
           r-rcpp
           r-rcpparmadillo
           r-rcppprogress
           r-rlang
           r-tibble
           r-tidyr))
    (native-inputs
     (list autoconf))
    (home-page "https://github.com/immunogenomics/harmony")
    (synopsis "Integration of single cell sequencing data")
    (description
     "This package provides an implementation of the Harmony algorithm for
single cell integration, described in Korsunsky et al
@url{doi.org/10.1101/461954}.  The package includes a standalone Harmony
function and interfaces to external frameworks.")
    (license license:gpl3)))

(define-public r-covr
  (package
    (name "r-covr")
    (version "3.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "covr" version))
       (sha256
        (base32 "0mqiqmbwq5f083lda208nqd4ya0f912bkkya2i62fkqsii1ibgpz"))))
    (properties `((upstream-name . "covr")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-crayon
           r-digest
           r-httr
           r-jsonlite
           r-rex
           r-withr
           r-yaml))
    (native-inputs
     (list r-knitr)) ; for vignettes
    (home-page "https://github.com/r-lib/covr")
    (synopsis "Test coverage for R packages")
    (description
     "Thisp package enables you to track and report code coverage for your
package and (optionally) upload the results to a coverage service.  Code
coverage is a measure of the amount of code being exercised by a set of tests.
It is an indirect measure of test quality and completeness.  This package is
compatible with any testing methodology or framework and tracks coverage of
both R code and compiled C/C++/FORTRAN code.")
    (license license:gpl3)))

(define-public r-systemfonts
  (package
    (name "r-systemfonts")
    (version "1.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "systemfonts" version))
       (sha256
        (base32
         "1h44bal845jp7ya8i7ff1kz1n3wklkb00jk6hb9lgwa2p5snqxpg"))))
    (properties `((upstream-name . "systemfonts")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cpp11))
    (inputs
     (list fontconfig freetype zlib))
    (native-inputs
     (list pkg-config r-knitr))
    (home-page "https://github.com/r-lib/systemfonts")
    (synopsis "System native font finding")
    (description
     "This package provides system native access to the font catalogue.  As
font handling varies between systems it is difficult to correctly locate
installed fonts across different operating systems.  The 'systemfonts' package
provides bindings to the native libraries for finding font files that can then
be used further by e.g. graphic devices.")
    (license license:expat)))

(define-public r-graphlayouts
  (package
    (name "r-graphlayouts")
    (version "0.8.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "graphlayouts" version))
       (sha256
        (base32
         "08a4cpy0n90hw8xzmxck13hp76yh40r0njb2m7mwdldljkbybr7r"))))
    (properties `((upstream-name . "graphlayouts")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-igraph r-rcpp r-rcpparmadillo))
    (home-page "https://github.com/schochastics/graphlayouts")
    (synopsis "Additional layout algorithms for network visualizations")
    (description
     "This package provides several layout algorithms to visualize networks
which are not part of the igraph library.  Most are based on the concept of
stress majorization by Gansner et al. (2004)
<doi:10.1007/978-3-540-31843-9_25>.  Some more specific algorithms
emphasize hidden group structures in networks or focus on specific nodes.")
    (license license:expat)))

(define-public r-terra
  (package
    (name "r-terra")
    (version "1.6-17")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "terra" version))
       (sha256
        (base32
         "00mwigymvsqf7r3swbkdw8fwqzr05ddk84fhyhr16lfa4118z26v"))))
    (properties `((upstream-name . "terra")))
    (build-system r-build-system)
    (inputs
     (list gdal
           geos
           proj
           sqlite ; needed for proj
           zlib))
    (propagated-inputs
     (list r-rcpp))
    (native-inputs
     (list pkg-config))
    (home-page "https://rspatial.org/terra")
    (synopsis "Spatial data analysis")
    (description
     "This package provides methods for spatial data analysis, especially
raster data.  The included methods allow for low-level data manipulation as
well as high-level global, local, zonal, and focal computation.  The predict
and interpolate methods facilitate the use of regression type (interpolation,
machine learning) models for spatial prediction.  Processing of very large
files is supported.")
    (license license:gpl3+)))

(define-public r-tidygraph
  (package
    (name "r-tidygraph")
    (version "1.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tidygraph" version))
       (sha256
        (base32
         "0w34jfldjkynbkyinmi1vdrfjhjrs47hm599mbnx4sxmnpbclmfm"))))
    (properties `((upstream-name . "tidygraph")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-cpp11
           r-dplyr
           r-igraph
           r-magrittr
           r-pillar
           r-r6
           r-rlang
           r-tibble
           r-tidyr))
    (home-page "https://github.com/thomasp85/tidygraph")
    (synopsis "Tidy API for graph manipulation")
    (description
     "This package provides a graph implementation that can be thought of as
two tidy data frames describing node and edge data respectively.  It provides
an approach to manipulate these two virtual data frames using the API defined
in the @code{dplyr} package, and it also provides tidy interfaces to a lot of
common graph algorithms.")
    (license license:expat)))

(define-public r-soupx
  (let ((commit "a3354be76fb52fd795be6ddf163cf056c05c6cb8")
        (revision "1"))
    (package
      (name "r-soupx")
      (version (git-version "0.3.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/constantAmateur/SoupX")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "1zmlyzrl0fz6l79gn2wswid670p88mm3y292is89sa5p3h7frr99"))))
      (properties `((upstream-name . "SoupX")))
      (build-system r-build-system)
      (propagated-inputs
       (list r-ggplot2 r-matrix r-seurat))
      (home-page "https://github.com/constantAmateur/SoupX")
      (synopsis "Single cell mRNA Soup eXterminator")
      (description
       "This package provides a package for quantifying, profiling and
removing cell free mRNA contamination (the \"soup\") from droplet based single
cell RNA-seq experiments.")
      (license license:gpl2))))

(define-public r-assertr
  (package
    (name "r-assertr")
    (version "2.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "assertr" version))
       (sha256
        (base32
         "00764vv86r3bn4r85in4w637harffyw605fgq0dj6mrbrwcfb650"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr r-mass r-rlang))
    (native-inputs
     (list r-knitr))           ; needed for vignette
    (home-page "https://github.com/ropensci/assertr")
    (synopsis "Assertive programming for R analysis pipelines")
    (description
     "This package provides functionality to assert conditions that have to be
met so that errors in data used in analysis pipelines can fail quickly.  It is
similar to @code{stopifnot()} but more powerful, friendly, and easier for use
in pipelines.")
    (license license:expat)))

(define-public r-parameters
  (package
    (name "r-parameters")
    (version "0.19.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "parameters" version))
       (sha256
        (base32
         "10cl8vgcjncnry6qkkr41yyh8ngxxn81hwqqqix9g7pwpbf3c2mf"))))
    (properties `((upstream-name . "parameters")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bayestestr r-datawizard r-insight))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/parameters")
    (synopsis "Processing of model parameters")
    (description
     "This package provides utilities for processing the parameters of various
statistical models.  Beyond computing p values, CIs, and other indices for a
wide variety of models, this package implements features like standardization
or bootstrapping of parameters and models, feature reduction (feature
extraction and variable selection) as well as conversion between indices of
effect size.")
    (license license:gpl3)))

(define-public r-rgdal
  (package
    (name "r-rgdal")
    (version "1.5-32")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rgdal" version))
       (sha256
        (base32 "1vbkyhw8nd7dw1r53qisphav31x6zvpbzilvnlvbjbj9hzhs90s5"))))
    (properties `((upstream-name . "rgdal")))
    (build-system r-build-system)
    (inputs
     (list gdal proj zlib))
    (propagated-inputs
     (list r-sp))
    (native-inputs
     (list pkg-config r-knitr))
    (home-page "http://rgdal.r-forge.r-project.org")
    (synopsis "Bindings for the Geospatial Data Abstraction Library")
    (description
     "This package provides bindings to the Geospatial Data Abstraction
Library (GDAL) and access to projection/transformation operations from the
PROJ.4 library.")
    (license license:gpl2+)))

(define-public r-insol
  (package
    (name "r-insol")
    (version "1.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "insol" version))
       (sha256
        (base32
         "166kgxgzbh55y2qqya6c2si22x0v7asi70im054g6xxwc5187kh3"))))
    (properties `((upstream-name . "insol")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-raster))
    (native-inputs
     (list gfortran))
    (home-page "https://meteoexploration.com/R/insol/index.html")
    (synopsis "Tools for calculating solar radiation")
    (description
     "This package provides functions to compute insolation on tilted
surfaces, computes atmospheric transmittance and related parameters such as:
Earth radius vector, declination, sunset and sunrise, daylength, equation of
time, vector in the direction of the sun, vector normal to surface, and some
atmospheric physics.")
    (license license:gpl2+)))

(define-public r-lifecycle
  (package
    (name "r-lifecycle")
    (version "1.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lifecycle" version))
       (sha256
        (base32
         "1hk9mblhap429fk77qpgc4hv0j91q5wpahi0y76w118m471zsnb4"))))
    (properties `((upstream-name . "lifecycle")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli r-glue r-rlang))
    (native-inputs
     (list r-knitr)) ; for vignettes
    (home-page "https://github.com/r-lib/lifecycle")
    (synopsis "Manage the life cycle of your package functions")
    (description
     "Manage the life cycle of your exported functions with shared
conventions, documentation badges, and non-invasive deprecation warnings.  The
lifecycle package defines four development stages (experimental, maturing,
stable, and questioning) and three deprecation stages (soft-deprecated,
deprecated, and defunct).  It makes it easy to insert badges corresponding to
these stages in your documentation.  Usage of deprecated functions are
signalled with increasing levels of non-invasive verbosity.")
    (license license:gpl3)))

(define-public r-assertable
  (package
    (name "r-assertable")
    (version "0.2.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "assertable" version))
       (sha256
        (base32
         "1cciil1nzxd8gbj49w99jiv077lbpb59vx7bmb4p218aj2h5hqq4"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-data-table))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/assertable/")
    (synopsis "Verbose assertions for tabular data (data.frames and data.tables)")
    (description "This package provides simple, flexible assertions on
data.frame or data.table objects with verbose output for vetting.  While other
assertion packages apply towards more general use-cases, @code{assertable} is
tailored towards tabular data.  It includes functions to check variable names
and values, whether the dataset contains all combinations of a given set of
unique identifiers, and whether it is a certain length.  In addition,
@code{assertable} includes utility functions to check the existence of target
files and to efficiently import multiple tabular data files into one
data.table.")
    (license license:gpl3)))

(define-public r-quadprog
  (package
    (name "r-quadprog")
    (version "1.5-8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "quadprog" version))
       (sha256
        (base32 "1ka9g8zak8sg4y2xbz93dfrldznlk9qpd4pq9z21cdcdn3b8s4i2"))))
    (build-system r-build-system)
    (native-inputs
     (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/quadprog")
    (synopsis "Functions to solve quadratic programming problems")
    (description
     "This package contains routines and documentation for solving quadratic
programming problems.")
    (license license:gpl3+)))

(define-public r-desolve
  (package
    (name "r-desolve")
    (version "1.34")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "deSolve" version))
       (sha256
        (base32 "08czbjvq07ax6q3k303w37q8lq50547cdx7yhp32mqnx8igk0m12"))))
    (properties `((upstream-name . "deSolve")))
    (build-system r-build-system)
    (native-inputs
     (list gfortran))
    (home-page "https://desolve.r-forge.r-project.org/")
    (synopsis "Solvers for initial value problems of differential equations")
    (description "This package provides functions that solve initial value
problems of a system of first-order @dfn{ordinary differential
equations} (ODE), of @dfn{partial differential equations} (PDE), of
@dfn{differential algebraic equations} (DAE), and of delay differential
equations.  The functions provide an interface to the FORTRAN functions
@code{lsoda}, @code{lsodar}, @code{lsode}, @code{lsodes} of the ODEPACK
collection, to the FORTRAN functions @code{dvode} and @code{daspk} and a
C-implementation of solvers of the Runge-Kutta family with fixed or variable
time steps.  The package contains routines designed for solving ODEs resulting
from 1-D, 2-D and 3-D partial differential equations that have been converted
to ODEs by numerical differencing.")
    (license license:gpl2+)))

(define-public r-pmcmrplus
  (package
    (name "r-pmcmrplus")
    (version "1.9.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "PMCMRplus" version))
       (sha256
        (base32 "1mvj3cwrdkl3frk7fvh6l7v7yya5p3xm4z0qhc4fvykxdmb92ivz"))))
    (properties `((upstream-name . "PMCMRplus")))
    (build-system r-build-system)
    (inputs (list gmp))
    (propagated-inputs
     (list r-bwstest
           r-gmp
           r-ksamples
           r-mass
           r-multcompview
           r-mvtnorm
           r-rmpfr
           r-suppdists))
    (native-inputs (list gfortran r-knitr))
    (home-page "https://cran.r-project.org/package=PMCMRplus")
    (synopsis "Calculate pairwise multiple comparisons of mean rank sums extended")
    (description
     "This package provides multiple pairwise tests.")
    (license license:gpl3+)))

(define-public r-pracma
  (package
    (name "r-pracma")
    (version "2.4.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "pracma" version))
              (sha256
               (base32 "05lwx2yx7f45cr5amzbjv3b2p6ibspjxl0aglq2dga6rvxzk6l0x"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/pracma/")
    (synopsis "Practical numerical math functions")
    (description "This package provides functions for numerical analysis and
linear algebra, numerical optimization, differential equations, plus some
special functions.  It uses Matlab function names where appropriate to simplify
porting.")
    (license license:gpl3+)))

(define-public r-subplex
  (package
    (name "r-subplex")
    (version "1.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "subplex" version))
       (sha256
        (base32
         "19g5bd39gmcn27xdsklkzxg99x1r5v5q8zcw1iwry31qj24ivhrv"))))
    (build-system r-build-system)
    (native-inputs
     (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/subplex")
    (synopsis "Unconstrained optimization using the subplex algorithm")
    (description
     "This package implements the Subplex optimization algorithm.
It solves unconstrained optimization problems using a simplex method on
subspaces.  The method is well suited for optimizing objective functions that
are noisy or are discontinuous at the solution.")
    (license license:gpl3+)))

(define-public r-txtplot
  (package
    (name "r-txtplot")
    (version "1.0-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "txtplot" version))
       (sha256
        (base32
         "00sriml48y70j18jz235dsfm5x3a81bnzskfp3hnv6cbjwwsmca4"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/txtplot/")
    (synopsis "Text-based plotting")
    (description "This package provides functions to produce rudimentary ASCII
graphics directly in the terminal window.  This package provides a basic
plotting function (and equivalents of curve, density, acf and barplot) as well
as a boxplot function.")
    (license license:lgpl3+)))

(define-public r-bio3d
  (package
    (name "r-bio3d")
    (version "2.4-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bio3d" version))
       (sha256
        (base32
         "1scxzmh22ca0nmpkvapsdcmq3n06j2wy74ljz1g27r1k1p0ylm2n"))))
    (properties `((upstream-name . "bio3d")))
    (build-system r-build-system)
    (inputs (list zlib))
    (propagated-inputs (list r-rcpp))
    (native-inputs
     (list r-knitr))
    (home-page "http://thegrantlab.org/bio3d/")
    (synopsis "Biological structure analysis")
    (description
     "This package provides utilities to process, organize and explore protein
structure, sequence and dynamics data.  Features include the ability to read
and write structure, sequence and dynamic trajectory data, perform sequence
and structure database searches, data summaries, atom selection, alignment,
superposition, rigid core identification, clustering, torsion analysis,
distance matrix analysis, structure and sequence conservation analysis, normal
mode analysis, principal component analysis of heterogeneous structure data,
and correlation network analysis from normal mode and molecular dynamics data.
In addition, various utility functions are provided to enable the statistical
and graphical power of the R environment to work with biological sequence and
structural data.")
    (license license:gpl2+)))

(define-public r-bios2cor
  (package
    (name "r-bios2cor")
    (version "2.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Bios2cor" version))
       (sha256
        (base32
         "0xj7ab9a463p4a67y0hlv6mfd08xf8didkn2mwrfa7gxjqqvix4z"))))
    (properties `((upstream-name . "Bios2cor")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bigmemory r-bio3d r-circular r-igraph))
    (home-page "https://cran.r-project.org/web/packages/Bios2cor/")
    (synopsis "From biological sequences and simulations to correlation analysis")
    (description
     "This package provides utilities for computation and analysis of
correlation/covariation in multiple sequence alignments and in side chain
motions during molecular dynamics simulations.  Features include the
computation of correlation/covariation scores using a variety of scoring
functions between either sequence positions in alignments or side chain
dihedral angles in molecular dynamics simulations and utilities to analyze the
correlation/covariation matrix through a variety of tools including network
representation and principal components analysis.  In addition, several
utility functions are based on the R graphical environment to provide friendly
tools for help in data interpretation.")
    (license license:gpl2+)))

;; This package includes minified JavaScript files.  When upgrading please
;; check that there are no new minified JavaScript files.
(define-public r-networkd3
  (package
    (name "r-networkd3")
    (version "0.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "networkD3" version))
       (sha256
        (base32
         "02wxki67drppgfka1is1ykg1f2rxf0x0657c0crj7ipfy62jbf1k"))
       (snippet
        '(begin
           (delete-file "inst/htmlwidgets/lib/d3-4.5.0/d3.min.js")
           #t))))
    (properties `((upstream-name . "networkD3")))
    (build-system r-build-system)
    (arguments
     `(#:modules ((guix build utils)
                  (guix build r-build-system)
                  (srfi srfi-1)
                  (ice-9 popen))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst/htmlwidgets/lib/"
               (call-with-values
                   (lambda ()
                     (unzip2
                      `((,(assoc-ref inputs "d3.v4.js")
                         "d3-4.5.0/d3.min.js"))))
                 (lambda (sources targets)
                   (for-each (lambda (source target)
                               (format #t "Processing ~a --> ~a~%"
                                       source target)
                               (let ((minified (open-pipe* OPEN_READ "uglifyjs" source)))
                                 (call-with-output-file target
                                   (lambda (port)
                                     (dump-port minified port)))))
                             sources targets))))
             #t)))))
    (native-inputs
     `(("uglifyjs" ,node-uglify-js)
       ;; NOTE: Make sure that this version of d3 is still valid when
       ;; upgrading the package.
       ("d3.v4.js"
        ,(origin
           (method url-fetch)
           (uri "https://d3js.org/d3.v4.js")
           (sha256
            (base32
             "0y7byf6kcinfz9ac59jxc4v6kppdazmnyqfav0dm4h550fzfqqlg"))))))
    (propagated-inputs
     (list r-htmlwidgets r-igraph r-magrittr))
    (home-page "https://cran.r-project.org/package=networkD3")
    (synopsis "D3 JavaScript network graphs from R")
    (description
     "This package creates D3 JavaScript network, tree, dendrogram, and Sankey
graphs from R.")
    (license license:gpl3+)))

(define-public r-aasea
  (package
    (name "r-aasea")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "aaSEA" version))
       (sha256
        (base32
         "0him4r8qyp0xssgrmdxjs45yn4d28h5anv4jyxxbbs9phb0m6j3h"))))
    (properties `((upstream-name . "aaSEA")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bios2cor
           r-dt
           r-hmisc
           r-magrittr
           r-networkd3
           r-plotly
           r-seqinr
           r-shiny
           r-shinydashboard))
    (home-page "https://cran.r-project.org/web/packages/aaSEA/")
    (synopsis "Amino acid substitution effect analyzer")
    (description
     "Given a protein multiple sequence alignment, it is a daunting task to
assess the effects of substitutions along sequence length.  The aaSEA package
is intended to help researchers to rapidly analyze property changes caused by
single, multiple and correlated amino acid substitutions in proteins.")
    (license license:gpl3)))

(define-public r-abacus
  (package
    (name "r-abacus")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ABACUS" version))
       (sha256
        (base32
         "0m1dnkwjr1522l9ddbzzx7ayxvli17sbmk6s28adpmzzjwh2kd1i"))))
    (properties `((upstream-name . "ABACUS")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-shiny))
    (home-page "https://shiny.abdn.ac.uk/Stats/apps/")
    (synopsis "Apps-based activities for communicating and understanding statistics")
    (description
     "This package provides a set of Shiny apps for effective communication
and understanding in statistics.  The current version includes properties of
normal distribution, properties of sampling distribution, one-sample z and t
tests, two samples independent (unpaired) t test and analysis of variance.")
    (license license:gpl3)))

(define-public r-abc-rap
  (package
    (name "r-abc-rap")
    (version "0.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ABC.RAP" version))
       (sha256
        (base32
         "1kdspln17v0krvahcd55vib4dv5azp60b3r1zf489x10qqbp1mxk"))))
    (properties `((upstream-name . "ABC.RAP")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/ABC.RAP/")
    (synopsis "Array-based CpG region analysis pipeline")
    (description
     "This package aims to identify candidate genes that are differentially
methylated between cases and controls.  It applies Student's t-test and delta
beta analysis to identify candidate genes containing multiple CpG sites.")
    (license license:gpl3)))

(define-public r-abcadm
  (package
    (name "r-abcadm")
    (version "1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abcADM" version))
       (sha256
        (base32
         "0vcabnnnwc0psv9v3rda5aap9s8cq1pjh02zva3ki64hlavf2a10"))))
    (properties `((upstream-name . "abcADM")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bh r-rcpp))
    (home-page "https://cran.r-project.org/web/packages/abcADM/")
    (synopsis "Fit accumulated damage models and estimate reliability using ABC")
    (description
     "This package provides tools to estimate parameters of accumulated
damage (load duration) models based on failure time data under a Bayesian
framework, using @dfn{Approximate Bayesian Computation} (ABC), and to assess
long-term reliability under stochastic load profiles.")
    (license license:gpl3)))

(define-public r-rglpk
  (package
    (name "r-rglpk")
    (version "0.6-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Rglpk" version))
       (sha256
        (base32
         "19mzpyimzq9zqnbi05j79b2di3nzaln8swggs9p8sqdr60qvr3d2"))))
    (properties `((upstream-name . "Rglpk")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-slam))
    (inputs
     (list glpk))
    (home-page "https://r-forge.r-project.org/projects/rglp/")
    (synopsis "R interface to the GNU Linear Programming Kit")
    (description
     "This package provides an R interface to the GNU Linear Programming Kit,
software for solving large-scale @dfn{linear programming} (LP), @dfn{mixed
integer linear programming} (MILP) and other related problems.")
    ;; Either license
    (license (list license:gpl2 license:gpl3))))

(define-public r-abcdefba
  (package
    (name "r-abcdefba")
    (version "0.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abcdeFBA" version))
       (sha256
        (base32
         "1rxjripy8v6bxi25vdfjnbk24zkmf752qbl73cin6nvnqflwxkx4"))))
    (properties `((upstream-name . "abcdeFBA")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-corrplot r-lattice r-rgl r-rglpk))
    (home-page "https://cran.r-project.org/web/packages/abcdeFBA/")
    (synopsis "A-Biologist-Can-Do-Everything of Flux Balance Analysis with this package")
    (description
     "This package provides functions for Constraint Based Simulation using
Flux Balance Analysis and informative analysis of the data generated during
simulation.")
    (license license:gpl2)))

(define-public r-abcrlda
  (package
    (name "r-abcrlda")
    (version "1.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abcrlda" version))
       (sha256
        (base32
         "04pcdnk2szfpc2ylcw5ds7y895ivy03bycal03kxw7cwylzxasks"))))
    (properties `((upstream-name . "abcrlda")))
    (build-system r-build-system)
    (home-page "https://ieeexplore.ieee.org/document/8720003/")
    (synopsis "Asymptotically bias-corrected regularized linear discriminant analysis")
    (description
     "This package offers methods to perform @dfn{asymptotically
bias-corrected regularized linear discriminant analysis} (ABC_RLDA) for
cost-sensitive binary classification.  The bias-correction is an estimate of
the bias term added to regularized discriminant analysis that minimizes the
overall risk.")
    (license license:gpl3)))

(define-public r-abemus
  (package
    (name "r-abemus")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abemus" version))
       (sha256
        (base32
         "1dhllb184byp1yl15rg2w02zgw3iajag7cxshirg47mnmm7n70bb"))))
    (properties `((upstream-name . "abemus")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-data-table))
    (home-page "https://cran.r-project.org/web/packages/abemus/")
    (synopsis "Adaptive base error model in ultra-deep sequencing data")
    (description
     "This package provides an implementation of @dfn{Adaptive Base Error
Model in Ultra-deep Sequencing data} (ABEMUS), which combines
platform-specific genetic knowledge and empirical signal to readily detect and
quantify somatic @dfn{single nucleotide variants} (SNVs) in @dfn{circulating
cell free DNA} (cfDNA).")
    (license license:gpl3)))

;; This package includes minified JavaScript files.  When upgrading please
;; check that there are no new minified JavaScript files.
(define-public r-rintrojs
  (package
    (name "r-rintrojs")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rintrojs" version))
       (sha256
        (base32
         "19lpq421hrs1wc9bnimbwxx35p8bbzil3x1h9l28gjayn4djmjsh"))
       (snippet
        '(delete-file "inst/javascript/introjs/intro.min.js"))))
    (properties `((upstream-name . "rintrojs")))
    (build-system r-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst/javascript/introjs/"
               (let ((source (assoc-ref inputs "intro.js"))
                     (target "intro.min.js"))
                 (format #true "Processing ~a --> ~a~%"
                         source target)
                 (invoke "esbuild" source "--minify"
                         (string-append "--outfile=" target)))))))))
    (native-inputs
     `(("esbuild" ,esbuild)
       ("intro.js"
        ,(origin
           (method url-fetch)
           (uri "https://cdn.jsdelivr.net/npm/intro.js@3.2.1/intro.js")
           (sha256
            (base32
             "0vh5n7hqqyx2pdvlqq6xadfqibcn78h5961rwhpf817kpxfzv8v7"))))))
    (propagated-inputs
     (list r-jsonlite r-shiny))
    (home-page "https://github.com/carlganz/rintrojs")
    (synopsis "Wrapper for the Intro.js library")
    (description
     "This package provides a wrapper for the @url{http://www.introjs.com,
Intro.js} library.  This package makes it easy to include step-by-step
introductions, and clickable hints in a Shiny application.  It supports both
static introductions in the UI, and programmatic introductions from the
server-side.")
    ;; The intro.js library is licensed under Expat.
    (license (list license:agpl3+ license:expat))))

(define-public r-sysfonts
  (package
    (name "r-sysfonts")
    (version "0.8.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sysfonts" version))
       (sha256
        (base32
         "1fq5dn4l09sgrbznfz9cakf4vgc3761zwicvqaazh0s8mzbaicpn"))))
    (properties `((upstream-name . "sysfonts")))
    (build-system r-build-system)
    (inputs
     (list freetype libpng zlib))
    (native-inputs
     (list pkg-config))
    (home-page "https://github.com/yixuan/sysfonts")
    (synopsis "Loading fonts into R")
    (description
     "This is a package to simplify loading of system fonts and Google Fonts
into R, in order to support other packages.")
    (license license:gpl2)))

(define-public r-showtextdb
  (package
    (name "r-showtextdb")
    (version "3.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "showtextdb" version))
       (sha256
        (base32
         "0hlnc3fhgrdkd46n7hb6id0gg1v0bf8s4679nrr7rchyp455szq2"))))
    (properties `((upstream-name . "showtextdb")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-sysfonts))
    (home-page "https://cran.r-project.org/web/packages/showtextdb/")
    (synopsis "Font files for the 'showtext' package")
    (description
     "This package provides font files that can be used by the @code{showtext}
package.")
    (license license:asl2.0)))

(define-public r-showtext
  (package
    (name "r-showtext")
    (version "0.9-5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "showtext" version))
       (sha256
        (base32
         "1larnqxn9nanbqiadm35ah5hh89xrzm4fdj9pfc93zzzhlfrvhb3"))))
    (properties `((upstream-name . "showtext")))
    (build-system r-build-system)
    (inputs
     (list freetype libpng zlib))
    (propagated-inputs
     (list r-showtextdb r-sysfonts))
    (native-inputs
     (list pkg-config r-knitr))
    (home-page "https://github.com/yixuan/showtext")
    (synopsis "Using fonts more easily in R graphs")
    (description
     "This package aims to make it easy to use various types of
fonts (TrueType, OpenType, Type 1, web fonts, etc.) in R graphs, and supports
most output formats of R graphics including PNG, PDF and SVG.  Text glyphs
will be converted into polygons or raster images, hence after the plot has
been created, it no longer relies on the font files.  No external software
such as Ghostscript is needed to use this package.")
    (license license:asl2.0)))

(define-public r-emojifont
  (package
    (name "r-emojifont")
    (version "0.5.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "emojifont" version))
       (sha256
        (base32
         "1hhrwilv36hd9gs1kcl2zsi6519md0h9aixjrm6lfclxvz8r6k1i"))))
    (properties `((upstream-name . "emojifont")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-proto r-showtext r-sysfonts))
    (native-inputs
     (list r-knitr))
    (home-page "https://guangchuangyu.github.io/emojifont")
    (synopsis "Emoji and Font Awesome in R graphics")
    (description
     "This package enables the use of emoji and the Font Awesome glyphs in
both base and ggplot2 graphics.")
    (license license:artistic2.0)))

(define-public r-abstractr
  (package
    (name "r-abstractr")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abstractr" version))
       (sha256
        (base32
         "1ymwp7syrynwd4i8aj2x5n8jdi9d96fjzl6jb09n0bnr5fgl7vig"))))
    (properties `((upstream-name . "abstractr")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-colourpicker
           r-emojifont
           r-ggplot2
           r-gridextra
           r-rintrojs
           r-shiny
           r-shinythemes))
    (home-page "https://matt-kumar.shinyapps.io/portfolio")
    (synopsis "R-Shiny application for creating visual abstracts")
    (description
     "This package provides an R Shiny application to create visual abstracts
for original research.  A variety of user defined options and formatting are
included.")
    (license license:gpl3)))

(define-public r-qgam
  (package
    (name "r-qgam")
    (version "1.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "qgam" version))
       (sha256
        (base32
         "1jyamamdffaks89rspyhmg18b4iik0nb1j0vgqzvfnm890514cvn"))))
    (properties `((upstream-name . "qgam")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-doparallel r-mgcv r-plyr r-shiny))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/qgam/")
    (synopsis "Smooth additive quantile regression models")
    (description
     "This package provides smooth additive quantile regression models, fitted
using the methods of Fasiolo et al. (2017).  Differently from @code{quantreg},
the smoothing parameters are estimated automatically by marginal loss
minimization, while the regression coefficients are estimated using either
PIRLS or Newton algorithm.  The learning rate is determined so that the
Bayesian credible intervals of the estimated effects have approximately the
correct coverage.  The main function is @code{qgam()} which is similar to
@code{gam()} in the @code{mgcv} package, but fits non-parametric quantile
regression models.")
    (license license:gpl2+)))

(define-public r-abtest
  (package
    (name "r-abtest")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abtest" version))
       (sha256
        (base32
         "0jz2ry5364p8h8xlk5a5sycn8xlpxd1iasfg99bcr4jqzd92jfqg"))))
    (properties `((upstream-name . "abtest")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-matrix
           r-mvtnorm
           r-plotrix
           r-qgam
           r-rcolorbrewer
           r-rcpp
           r-sn
           r-truncnorm))
    (home-page "https://cran.r-project.org/web/packages/abtest/")
    (synopsis "Bayesian A/B testing")
    (description
     "This package provides functions for Bayesian A/B testing including prior
elicitation options based on Kass and Vaidyanathan (1992)
@url{doi:10.1111/j.2517-6161.1992.tb01868.x}.")
    (license license:gpl2+)))

(define-public r-reldist
  (package
    (name "r-reldist")
    (version "1.7-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "reldist" version))
       (sha256
        (base32
         "17kbqqapqmckghv7jizibmicv3bzbycfr3mz4xg3yjp3c2bap4r6"))))
    (properties `((upstream-name . "reldist")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-densestbayes r-mgcv))
    (home-page "http://www.stat.ucla.edu/~handcock/RelDist")
    (synopsis "Relative distribution methods")
    (description
     "This package provides tools for the comparison of distributions.  This
includes nonparametric estimation of the relative distribution PDF and CDF and
numerical summaries as described in \"Relative Distribution Methods in the
Social Sciences\" by Mark S. Handcock and Martina Morris, Springer-Verlag,
1999, Springer-Verlag, ISBN 0387987789.")
    ;; See also https://cran.r-project.org/web/packages/reldist/LICENSE for
    ;; attribution requirements.
    (license license:gpl3)))

(define-public r-accept
  (package
    (name "r-accept")
    (version "0.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "accept" version))
       (sha256
        (base32
         "0risdxw17jk3d56q40a78slb1rcj93b6kz71hn5hbwr0iih722gr"))))
    (properties `((upstream-name . "accept")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr r-reldist))
    (home-page "https://cran.r-project.org/web/packages/accept/")
    (synopsis "Acute COPD Exacerbation Prediction Tool (ACCEPT)")
    (description
     "This package allows clinicians to predict the rate and severity of
future acute exacerbation in @dfn{Chronic Obstructive Pulmonary
Disease} (COPD) patients, based on the clinical prediction model published in
Adibi et al. (2019) @url{doi:10.1101/651901}.")
    (license license:gpl3)))

(define-public r-smpracticals
  (package
    (name "r-smpracticals")
    (version "1.4-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "SMPracticals" version))
       (sha256
        (base32
         "0zxq84f9i3b86xx6msb25b61gyj9k09iab2b7wg4d93yas9qzayf"))))
    (properties `((upstream-name . "SMPracticals")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ellipse r-mass r-nlme r-survival))
    (home-page "http://statwww.epfl.ch/davison/SM/")
    (synopsis "Practicals for use with Davison (2003) Statistical Models")
    (description
     "This package contains the datasets and a few functions for use with the
practicals outlined in Appendix A of the book Statistical Models (Davison,
2003, Cambridge University Press).  The practicals themselves can be found at
@url{http://statwww.epfl.ch/davison/SM/}.")
    (license license:gpl2+)))

(define-public r-fgui
  (package
    (name "r-fgui")
    (version "1.0-8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fgui" version))
       (sha256
        (base32
         "024fzd1c7iwqprn26hwjb9l2qlvvyzl449d7iixy0x69djwsrysv"))))
    (properties `((upstream-name . "fgui")))
    (build-system r-build-system)
    (home-page
     "https://sites.google.com/site/thomashoffmannproject/software/fgui")
    (synopsis "Create GUI for R functions")
    (description
     "Rapidly create a GUI for a function you created by automatically
creating widgets for arguments of the function.  This package automatically
parses help routines for context-sensitive help to these arguments.  The
interface is essentially a wrapper to some Tcl/Tk routines to both simplify
and facilitate GUI creation.  More advanced Tcl/Tk routines/GUI objects can be
incorporated into the interface for greater customization for the more
experienced.")
    ;; Any version of the GPL.
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-tcltk2
  (package
    (name "r-tcltk2")
    (version "1.2-11")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tcltk2" version))
       (sha256
        (base32
         "1ibxld379600xx7kiqq3fck083s8psry12859980218rnzikl65d"))))
    (properties `((upstream-name . "tcltk2")))
    (build-system r-build-system)
    (inputs
     (list tcl tk))
    (home-page "https://www.sciviews.org/SciViews-R")
    (synopsis "Tcl/Tk additions")
    (description
     "This package provides a series of additional Tcl commands and Tk widgets
with style and various functions to supplement the tcltk package")
    (license license:lgpl3)))

(define-public r-accrual
  (package
    (name "r-accrual")
    (version "1.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "accrual" version))
       (sha256
        (base32
         "11clm9s5c5518nmp6hd6pjnp0s28y92b2i2x0xgj4j5g816p4j3z"))))
    (properties `((upstream-name . "accrual")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-fgui r-smpracticals r-tcltk2))
    (home-page "https://cran.r-project.org/web/packages/accrual/")
    (synopsis "Bayesian accrual prediction")
    (description
     "Subject recruitment for medical research is challenging.  Slow patient
accrual leads to delay in research.  Accrual monitoring during the process of
recruitment is critical.  Researchers need reliable tools to manage the
accrual rate.  This package provides an implementation of a Bayesian method
that integrates researcher's experience on previous trials and data from the
current study, providing reliable prediction on accrual rate for clinical
studies.  It provides functions for Bayesian accrual prediction which can be
easily used by statisticians and clinical researchers.")
    (license license:gpl2)))

(define-public r-accrued
  (package
    (name "r-accrued")
    (version "1.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "accrued" version))
       (sha256
        (base32
         "05g1jb5914z18rcai1ahn7nihn27vr2rnadwv94gc1j7ivvikvs5"))))
    (properties `((upstream-name . "accrued")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/accrued/")
    (synopsis "Data quality visualization tools for partially accruing data")
    (description
     "This is a package for visualizing data quality of partially accruing
data.")
    (license license:gpl3)))

(define-public r-mda
  (package
    (name "r-mda")
    (version "0.5-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mda" version))
       (sha256
        (base32
         "0qw4scc2w7jmnxssj5w2mdxb9rrl4dscqn54gplzm1gk2yf419mx"))))
    (properties `((upstream-name . "mda")))
    (build-system r-build-system)
    (propagated-inputs (list r-class))
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/mda/")
    (synopsis "Mixture and flexible discriminant analysis")
    (description
     "This is a package for mixture and flexible discriminant analysis,
@dfn{multivariate adaptive regression splines} (MARS), BRUTO, and so on.")
    (license license:gpl2)))

(define-public r-elasticnet
  (package
    (name "r-elasticnet")
    (version "1.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "elasticnet" version))
       (sha256
        (base32
         "0nxcw06d0cp2mbqzg2fm9yys5xm6xx7bfcfvr0avcs8afkvz29j8"))))
    (properties `((upstream-name . "elasticnet")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lars))
    (home-page "http://users.stat.umn.edu/~zouxx019/")
    (synopsis "Elastic-Net for sparse estimation and sparse PCA")
    (description
     "This package provides functions for fitting the entire solution path of
the Elastic-Net and also provides functions for estimating sparse Principal
Components.  The Lasso solution paths can be computed by the same function.")
    (license license:gpl2+)))

(define-public r-sparselda
  (package
    (name "r-sparselda")
    (version "0.1-9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sparseLDA" version))
       (sha256
        (base32
         "1k3sw9kc40yxnfss4vrsx34qxmv8ssddyhbfjhxrdldvblhbwchb"))))
    (properties `((upstream-name . "sparseLDA")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-elasticnet r-mass r-mda))
    (home-page "https://www.imm.dtu.dk/~lkhc/")
    (synopsis "Sparse discriminant analysis")
    (description
     "This package performs sparse linear discriminant analysis for Gaussians
and mixture of Gaussian models.")
    (license license:gpl2+)))

(define-public r-accsda
  (package
    (name "r-accsda")
    (version "1.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "accSDA" version))
       (sha256
        (base32
         "0jf4x5j9y7a3mvf2ghjp6bxdq1s5jh2sx3x3ar6f3lyzzvrnls4v"))))
    (properties `((upstream-name . "accSDA")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2
           r-ggthemes
           r-gridextra
           r-mass))
    (home-page "https://github.com/gumeo/accSDA/wiki")
    (synopsis "Accelerated sparse discriminant analysis")
    (description
     "This package provides an implementation of sparse linear discriminant
analysis, which is a supervised classification method for multiple classes.
Various novel optimization approaches to this problem are implemented
including @dfn{alternating direction method of multipliers} (ADMM),
@dfn{proximal gradient} (PG) and @dfn{accelerated proximal gradient} (APG).
Functions for performing cross validation are also supplied along with basic
prediction and plotting functions.  @dfn{Sparse zero variance
discriminant} (SZVD) analysis is also included in the package.")
    (license license:gpl2+)))

(define-public r-ace2fastq
  (package
    (name "r-ace2fastq")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ace2fastq" version))
       (sha256
        (base32
         "09kk3yyqnr2xp820g0p3aai9a21figigjr9lxkr3zjq2d8gzwfic"))))
    (properties `((upstream-name . "ace2fastq")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-stringr))
    (home-page "https://github.com/c5sire/ace2fastq")
    (synopsis "ACE file to FASTQ converter")
    (description
     "The ACE file format is used in genomics to store contigs from sequencing
machines.  This tools converts it into FASTQ format.  Both formats contain the
sequence characters and their corresponding quality information.  Unlike the
FASTQ file, the ACE file stores the quality values numerically.  The
conversion algorithm uses the standard Sanger formula.  The package
facilitates insertion into pipelines, and content inspection.")
    (license license:gpl3)))

(define-public r-rngwell
  (package
    (name "r-rngwell")
    (version "0.10-7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rngWELL" version))
       (sha256
        (base32
         "0f1dxxaimfb0fww8ym9ciqf6q760ai46wxldl37m5mfpd57ca00c"))))
    (properties `((upstream-name . "rngWELL")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/rngWELL/")
    (synopsis "Toolbox for WELL random number generators")
    (description
     "This is a dedicated package to WELL pseudo random generators, which were
introduced in Panneton et al. (2006), ``Improved Long-Period Generators Based
on Linear Recurrences Modulo 2'', ACM Transactions on Mathematical Software.")
    (license license:bsd-3)))

(define-public r-rnmf
  (package
   (name "r-rnmf")
   (version "0.5.0")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "rNMF" version))
            (sha256
             (base32
              "1nz6h0j5ywdh48m0swmhp34hbkycd7n13rclrxaw85qi9wc42597"))))
   (build-system r-build-system)
   (propagated-inputs
    (list r-knitr r-nnls))
   (home-page "https://cran.r-project.org/web/packages/rNMF/")
   (synopsis "Robust nonnegative matrix factorization")
   (description
    "This package provides an implementation of robust nonnegative matrix
factorization (rNMF).  The rNMF algorithm decomposes a nonnegative high
dimension data matrix into the product of two low rank nonnegative matrices,
while detecting and trimming outliers.  The main function is @code{rnmf()}.
The package also includes a visualization tool, @code{see()}, that arranges
and prints vectorized images.")
   (license license:gpl2+)))

(define-public r-randtoolbox
  (package
    (name "r-randtoolbox")
    (version "2.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "randtoolbox" version))
       (sha256
        (base32
         "0mvafd2gm1jpg19gdn6bw8668pqghi0xmcb56rl4fwamg8jg09xn"))))
    (properties `((upstream-name . "randtoolbox")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rngwell))
    (home-page "https://cran.r-project.org/web/packages/randtoolbox/")
    (synopsis "Toolbox for pseudo and quasi random number generation")
    (description
     "This package provides

@enumerate
@item pseudo random generators, such as general linear
congruential generators, multiple recursive generators and generalized
feedback shift register (SF-Mersenne Twister algorithm and WELL
generators)

@item quasi random generators, such as the Torus algorithm, the Sobol
sequence, the Halton sequence (including the Van der Corput sequence), and

@item some generator tests: the gap test, the serial test, the poker test.
@end enumerate

See e.g. Gentle (2003) @url{doi:10.1007/b97336}.")
    (license license:bsd-3)))

(define-public r-lhs
  (package
    (name "r-lhs")
    (version "1.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lhs" version))
       (sha256
        (base32
         "0fb3bc3s5pbwg92qkjbg7v8ah36wm6qs05vf098hwjakr7f6yg3s"))))
    (properties `((upstream-name . "lhs")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/bertcarnell/lhs")
    (synopsis "Latin Hypercube Samples")
    (description
     "This package provides a number of methods for creating and augmenting
Latin Hypercube Samples.")
    (license license:gpl3)))

(define-public r-acebayes
  (package
    (name "r-acebayes")
    (version "1.10")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "acebayes" version))
       (sha256
        (base32
         "11bffz430gdfdaxjx3simig66vhynmx6l1ylac4q2shcmj52nx73"))))
    (properties `((upstream-name . "acebayes")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-compare r-lhs r-randtoolbox r-rcpp r-rcpparmadillo))
    (home-page "https://cran.r-project.org/web/packages/acebayes/")
    (synopsis "Optimal Bayesian experimental design using the ACE algorithm")
    (description
     "Finding an optimal Bayesian experimental design involves maximizing an
objective function given by the expectation of some appropriately chosen
utility function with respect to the joint distribution of unknown
quantities (including responses).  This objective function is usually not
available in closed form and the design space can be continuous and of high
dimensionality.  This package uses @dfn{Approximate Coordinate Exchange} (ACE)
to maximise an approximation to the expectation of the utility function.")
    (license license:gpl2)))

(define-public r-acet
  (package
    (name "r-acet")
    (version "1.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ACEt" version))
       (sha256
        (base32
         "0583c9dg2yf01zf5p0bf24zipkm8yp7rwhn1dxyw2d0v881bbli6"))))
    (properties `((upstream-name . "ACEt")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bh r-mass r-rcpp r-rcpparmadillo))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/ACEt/")
    (synopsis "Estimating dynamic heritability and twin model comparison")
    (description
     "This package supports twin models that are able to estimate the dynamic
behaviour of the variance components in the classical twin models with respect
to age using B-splines and P-splines.")
    (license license:gpl2+)))

(define-public r-acfmperiod
  (package
    (name "r-acfmperiod")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "acfMPeriod" version))
       (sha256
        (base32
         "1yww8isfrbs2v9s94hx7p2imyszcgadwafdgpj438n2ik0q6p9d5"))))
    (properties `((upstream-name . "acfMPeriod")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mass))
    (home-page "https://cran.r-project.org/web/packages/acfMPeriod/")
    (synopsis "Estimation of the ACF from the M-periodogram")
    (description
     "This package support non-robust and robust computations of the sample
autocovariance (ACOVF) and sample autocorrelation functions (ACF) of
univariate and multivariate processes.  The methodology consists in reversing
the diagonalization procedure involving the periodogram or the
cross-periodogram and the Fourier transform vectors, and, thus, obtaining the
ACOVF or the ACF as discussed in Fuller (1995)
@url{doi:10.1002/9780470316917}.  The robust version is obtained by fitting
robust M-regressors to obtain the M-periodogram or M-cross-periodogram as
discussed in Reisen et al. (2017) @url{doi:10.1016/j.jspi.2017.02.008}.")
    (license license:gpl2+)))

(define-public r-gamlss-data
  (package
    (name "r-gamlss-data")
    (version "6.0-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gamlss.data" version))
       (sha256
        (base32
         "07mpdl4h9rwmnpl9jmsn6ig8ji11an6pyjfsvg62h2alapwbdcyv"))))
    (properties `((upstream-name . "gamlss.data")))
    (build-system r-build-system)
    (home-page "http://www.gamlss.org/")
    (synopsis "GAMLSS data")
    (description
     "This package provides data used as examples to demonstrate GAMLSS
models.")
    ;; Either version of the license
    (license (list license:gpl2 license:gpl3))))

(define-public r-gamlss
  (package
    (name "r-gamlss")
    (version "5.4-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gamlss" version))
       (sha256
        (base32
         "0xih19zqgpjl5qv5j38ana6x29y84shn2jfl2lk4kaw3q7yx86b6"))))
    (properties `((upstream-name . "gamlss")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-gamlss-data r-gamlss-dist r-mass r-nlme r-survival))
    (home-page "http://www.gamlss.org/")
    (synopsis "Generalized additive models for location scale and shape")
    (description
     "This package provides functions for fitting the generalized additive
models for location scale and shape introduced by Rigby and
Stasinopoulos (2005), @url{doi:10.1111/j.1467-9876.2005.00510.x}.  The models
use a distributional regression approach where all the parameters of the
conditional distribution of the response variable are modelled using
explanatory variables.")
    ;; Either version of the license
    (license (list license:gpl2 license:gpl3))))

(define-public r-acid
  (package
    (name "r-acid")
    (version "1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "acid" version))
       (sha256
        (base32
         "030i0y8s283ivbsmjccpbv9v7mgbcg2jk9df7vgcbbns74swf9hd"))))
    (properties `((upstream-name . "acid")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-gamlss r-gamlss-dist r-hmisc))
    (home-page "https://cran.r-project.org/web/packages/acid/")
    (synopsis "Analysing conditional income distributions")
    (description
     "This package provides functions for the analysis of income distributions
for subgroups of the population as defined by a set of variables like age,
gender, region, etc.  This entails a Kolmogorov-Smirnov test for a mixture
distribution as well as functions for moments, inequality measures, entropy
measures and polarisation measures of income distributions.  This package thus
aides the analysis of income inequality by offering tools for the exploratory
analysis of income distributions at the disaggregated level.")
    (license license:gpl3)))

(define-public r-acm4r
  (package
    (name "r-acm4r")
    (version "1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "acm4r" version))
       (sha256
        (base32
         "1wqzc35i1rshx0zlmas8y4qkkvy6h9r4i4apscjjv1xg2wjflzxa"))))
    (properties `((upstream-name . "acm4r")))
    (build-system r-build-system)
    (propagated-inputs (list r-mass))
    (home-page "https://cran.r-project.org/web/packages/acm4r/")
    (synopsis "Align-and-count method comparisons of RFLP data")
    (description
     "This is a package to compare sequence fragment lengths or molecular
weights from pairs of lanes.  The number of matching bands in the
@dfn{Restriction Fragment Length Polymorphism} (RFLP) data is calculated using
the align-and-count method.")
    ;; Any version of the GPL
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-filelock
  (package
    (name "r-filelock")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "filelock" version))
       (sha256
        (base32
         "00ql5fw1hidpfnm0szaavf43ahmsnvdbi8i5lr1nrcc90yaiaadc"))))
    (properties `((upstream-name . "filelock")))
    (build-system r-build-system)
    (home-page "https://github.com/r-lib/filelock")
    (synopsis "Portable file locking")
    (description
     "This library lets you place an exclusive or shared lock on a file using
the appropriate system call provided by the underlying operating system.")
    (license license:expat)))

(define-public r-filematrix
  (package
    (name "r-filematrix")
    (version "1.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "filematrix" version))
       (sha256
        (base32
         "1v3aj1ng742msb0sfdnjsbqb508mqjf8jlq2v33vxldhradw5w0b"))))
    (properties `((upstream-name . "filematrix")))
    (build-system r-build-system)
    ;; These inputs are needed for vignettes
    (native-inputs
     (list r-knitr r-rmarkdown))
    (home-page "https://github.com/andreyshabalin/filematrix")
    (synopsis "File-backed matrix class with convenient read and write access")
    (description
     "This package provides an interface for working with large matrices
stored in files, not in computer memory.  It supports multiple non-character
data types (double, integer, logical and raw) of various sizes (e.g.  8 and 4
byte real values).  Access to parts of the matrix is done by indexing, exactly
as with usual R matrices.  It supports very large matrices; the package has
been tested on multi-terabyte matrices.  It allows for more than 2^32 rows or
columns, ad allows for quick addition of extra columns to a filematrix.")
    (license license:lgpl3)))

(define-public r-acmeeqtl
  (package
    (name "r-acmeeqtl")
    (version "1.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ACMEeqtl" version))
       (sha256
        (base32
         "049xjv2ym35bbn43zwi68cq27fwdh404vp0r2ca5gxgmmx8kj1cz"))))
    (properties `((upstream-name . "ACMEeqtl")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-filematrix))
    (home-page "https://github.com/andreyshabalin/ACMEeqtl")
    (synopsis "Estimation of interpretable eQTL effect sizes")
    (description
     "This package provides a non-linear model, termed ACME, that reflects a
parsimonious biological model for allelic contributions of cis-acting eQTLs.
With non-linear least-squares algorithm the maximum likelihood parameters can
be estimated.  The ACME model provides interpretable effect size estimates and
p-values with well controlled Type-I error.")
    (license license:lgpl3)))

(define-public r-acmer
  (package
    (name "r-acmer")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "acmeR" version))
       (sha256
        (base32
         "000b2hqlhj93958nddw0fqb15ahigs08najv2miivym046x04mf7"))))
    (properties `((upstream-name . "acmeR")))
    (build-system r-build-system)
    (propagated-inputs (list r-foreign))
    (home-page "https://cran.r-project.org/web/packages/acmeR/")
    (synopsis "ACME estimator of bird and bat mortality by wind turbines")
    (description
     "This package provides an implementation of the ACME estimator, described
in Wolpert (2015), ACME: A Partially Periodic Estimator of Avian & Chiropteran
Mortality at Wind Turbines.  Unlike most other models, this estimator supports
decreasing-hazard Weibull model for persistence; decreasing search proficiency
as carcasses age; variable bleed-through at successive searches; and interval
mortality estimates.  The package provides, based on search data, functions
for estimating the mortality inflation factor in Frequentist and Bayesian
settings.")
    (license license:expat)))

(define-public r-r-huge
  (package
    (name "r-r-huge")
    (version "0.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "R.huge" version))
       (sha256
        (base32
         "13p558qalv60pgr24nsm6mi92ryj65rsbqa6pgdwy0snjqx12bgi"))))
    (properties `((upstream-name . "R.huge")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-r-methodss3 r-r-oo r-r-utils))
    (home-page "https://github.com/HenrikBengtsson/R.huge")
    (synopsis "Methods for accessing huge amounts of data")
    (description
     "This is a deprecated package for accessing huge amounts of data.
  Cross-platform alternatives are the following packages: bigmemory (CRAN),
ff (CRAN), or BufferedMatrix (Bioconductor).  The main usage of it was inside
the @code{aroma.affymetrix} package.")
    (license license:lgpl2.1+)))

(define-public r-r-filesets
  (package
    (name "r-r-filesets")
    (version "2.15.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "R.filesets" version))
       (sha256
        (base32
         "14dngx6ffhfvlaixpvlq890nwgil6zyaw8wy3dlcrv001wynzmms"))))
    (properties `((upstream-name . "R.filesets")))
    (build-system r-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (propagated-inputs
     (list r-digest r-r-cache r-r-methodss3 r-r-oo r-r-utils))
    (home-page "https://github.com/HenrikBengtsson/R.filesets")
    (synopsis "Easy handling of and access to files")
    (description
     "This package provides classes and methods to locate, setup, subset,
navigate and iterate file sets, i.e. sets of files located in one or more
directories on the file system.  The API is designed such that these classes
can be extended via inheritance to provide a richer API for special file
formats.  Moreover, a specific name format is defined such that filenames and
directories can be considered to have full names which consists of a name
followed by comma-separated tags.  This adds additional flexibility to
identify file sets and individual files.")
    (license license:lgpl2.1+)))

(define-public r-r-devices
  (package
    (name "r-r-devices")
    (version "2.17.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "R.devices" version))
       (sha256
        (base32
         "02cwdhb9m97gxi4pki4kasc5j3a12r7yzsychzzk9h0ijc1mfziv"))))
    (properties `((upstream-name . "R.devices")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-base64enc r-r-methodss3 r-r-oo r-r-utils))
    (home-page "https://github.com/HenrikBengtsson/R.devices")
    (synopsis "Unified handling of graphics devices")
    (description
     "This package provides functions for creating plots and image files in a
unified way regardless of output format (EPS, PDF, PNG, SVG, TIFF, WMF, etc.).
Default device options as well as scales and aspect ratios are controlled in a
uniform way across all device types.  Switching output format requires minimal
changes in code.  This package is ideal for large-scale batch processing,
because it will never leave open graphics devices or incomplete image files
behind, even on errors or user interrupts.")
    (license license:lgpl2.1+)))

(define-public r-acnr
  (package
    (name "r-acnr")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "acnr" version))
       (sha256
        (base32
         "087hq4i7jp67ba2finzsqjfnqbiprl33na6ryjv9zqzsdawj9cym"))))
    (properties `((upstream-name . "acnr")))
    (build-system r-build-system)
    (home-page "https://github.com/mpierrejean/acnr")
    (synopsis "Annotated copy-number regions")
    (description
     "This package provides SNP array data from different types of copy-number
regions.  These regions were identified manually by the authors of the package
and may be used to generate realistic data sets with known truth.")
    (license license:lgpl2.1+)))

(define-public r-acopula
  (package
    (name "r-acopula")
    (version "0.9.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "acopula" version))
       (sha256
        (base32
         "0vvbbw8pfs9jwfz5c57lw48pr0qj661r0ys007q6zf9jmlrhx1ln"))))
    (properties `((upstream-name . "acopula")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/acopula/")
    (synopsis "Modelling dependence with multivariate Archimax copulas")
    (description
     "Archimax copulas are a mixture of Archimedean and EV copulas.  This
package provides definitions of several parametric families of generator and
dependence function, computes CDF and PDF, estimates parameters, tests for
goodness of fit, generates random sample and checks copula properties for
custom constructs.  In the 2-dimensional case explicit formulas for density
are used, contrary to higher dimensions when all derivatives are linearly
approximated.  Several non-archimax families (normal, FGM, Plackett) are
provided as well.")
    (license license:gpl2)))

(define-public r-tuner
  (package
    (name "r-tuner")
    (version "1.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tuneR" version))
       (sha256
        (base32
         "1mfkhxprqkj5v2z23g0bj8mwdp6q5fj1krk5ggr79359bd1nl7pf"))))
    (properties `((upstream-name . "tuneR")))
    (build-system r-build-system)
    (propagated-inputs (list r-signal))
    (home-page "https://cran.r-project.org/web/packages/tuneR/")
    (synopsis "Analysis of music and speech")
    (description
     "This is a package for the analysis of music and speech.  Analyze music
and speech, extract features like MFCCs, handle wave files and their
representation in various ways, read MP3, read MIDI, perform steps of a
transcription, ...")
    ;; Either of these versions.
    (license (list license:gpl2 license:gpl3))))

(define-public r-seewave
  (package
    (name "r-seewave")
    (version "2.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "seewave" version))
       (sha256
        (base32
         "0bi1l47l3846c18k6h2vrv0xp9xh00n544a578jrndahzrj1hfwl"))))
    (properties `((upstream-name . "seewave")))
    (build-system r-build-system)
    (inputs
     (list libsndfile))
    (propagated-inputs
     (list r-tuner))
    (home-page "http://rug.mnhn.fr/seewave")
    (synopsis "Sound analysis and synthesis")
    (description
     "This package provides functions for analysing, manipulating, displaying,
editing and synthesizing time waves (particularly sound).  This package
processes time analysis (oscillograms and envelopes), spectral content,
resonance quality factor, entropy, cross correlation and autocorrelation,
zero-crossing, dominant frequency, analytic signal, frequency coherence, 2D
and 3D spectrograms and many other analyses.")
    (license license:gpl2+)))

(define-public r-acousticndlcoder
  (package
    (name "r-acousticndlcoder")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "AcousticNDLCodeR" version))
       (sha256
        (base32
         "1fgzgwanpv2pzy74xdk3hamc44p8qch467wh163dxby8jr9ik0sb"))))
    (properties
     `((upstream-name . "AcousticNDLCodeR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-seewave r-tuner r-zoo))
    (home-page "https://cran.r-project.org/web/packages/AcousticNDLCodeR/")
    (synopsis "Coding sound files for use with NDL")
    (description
     "Make acoustic cues to use with the R package @code{ndl}.
The package implements functions used in the PLoS ONE paper \"Words from
spontaneous conversational speech can be recognized with human-like accuracy
by an error-driven learning algorithm that discriminates between meanings
straight from smart acoustic features, bypassing the phoneme as recognition
unit.\" @url{doi:10.1371/journal.pone.0174623}")
    (license license:gpl2+)))

(define-public r-acp
  (package
    (name "r-acp")
    (version "2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "acp" version))
       (sha256
        (base32
         "0lcwbjcyyr32m6qjmjqh25qjwrbyqj1n092xhgbhxzd8fslppnmn"))))
    (properties `((upstream-name . "acp")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-quantmod r-tseries))
    (home-page "https://cran.r-project.org/web/packages/acp/")
    (synopsis "Autoregressive conditional Poisson")
    (description
     "This package supports the analysis of count data exhibiting
autoregressive properties, using the @dfn{Autoregressive Conditional Poisson}
model (ACP(p,q)) proposed by Heinen (2003).")
    (license license:gpl2)))

(define-public r-ada
  (package
    (name "r-ada")
    (version "2.0-5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ada" version))
       (sha256
        (base32
         "1h3a07czp0w3hrhjcg1fz721y8vsfclzqi3rq8qfzgpfb4h1f06r"))))
    (properties `((upstream-name . "ada")))
    (build-system r-build-system)
    (propagated-inputs (list r-rpart))
    (home-page "https://cran.r-project.org/web/packages/ada/")
    (synopsis "Stochastic boosting")
    (description
     "This package provides a straightforward, well-documented, and broad
boosting routine for classification, ideally suited for small to
moderate-sized data sets.  It performs discrete, real, and gentle boost under
both exponential and logistic loss on a given data set.")
    ;; Any version of the GPL.
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-genalg
  (package
    (name "r-genalg")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "genalg" version))
       (sha256
        (base32
         "1y4qz1s85zpd1r3259gr542arssf2vpd4drhy0wnq5q47ignrvna"))))
    (properties `((upstream-name . "genalg")))
    (build-system r-build-system)
    (home-page "https://github.com/egonw/genalg")
    (synopsis "R based genetic algorithm")
    (description
     "This package provides an R based genetic algorithm for binary and
floating point chromosomes.")
    (license license:gpl2)))

(define-public r-kernelfactory
  (package
    (name "r-kernelfactory")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "kernelFactory" version))
       (sha256
        (base32
         "001kw9k3ivd4drd4mwqapkkk3f4jgljiaprhg2630hmll064s89j"))))
    (properties `((upstream-name . "kernelFactory")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-auc r-genalg r-kernlab r-randomforest))
    (home-page "https://cran.r-project.org/web/packages/kernelFactory/")
    (synopsis "Ensemble of kernel machines")
    (description
     "Kernel factory is an ensemble method where each base classifier (random
forest) is fit on the kernel matrix of a subset of the training data.")
    (license license:gpl2+)))

(define-public r-dummies
  (package
    (name "r-dummies")
    (version "1.5.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dummies" version))
       (sha256
        (base32
         "01f84crqx17xd6xy55qxlvsj3knm8lhw7jl26p2rh2w3y0nvqlbm"))))
    (properties `((upstream-name . "dummies")))
    (build-system r-build-system)
    (home-page "https://decisionpatterns.com")
    (synopsis "Create dummy/indicator variables flexibly and efficiently")
    (description
     "This package lets you expand factors, characters and other eligible
classes into dummy/indicator variables.")
    (license license:gpl2+)))

(define-public r-acrm
  (package
    (name "r-acrm")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "aCRM" version))
       (sha256
        (base32
         "0kzp568hd9c9a9qgniia5s5gv0q5f89xfvvwpzb197gqhs3x092v"))))
    (properties `((upstream-name . "aCRM")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ada r-dummies r-kernelfactory r-randomforest))
    (home-page "https://cran.r-project.org/web/packages/aCRM/")
    (synopsis "Convenience functions for analytical customer relationship management")
    (description
     "This package provides convenience functions for data preparation and
modeling often used in @dfn{analytical customer relationship
management} (aCRM).")
    (license license:gpl2+)))

(define-public r-tree
  (package
   (name "r-tree")
   (version "1.0-42")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "tree" version))
            (sha256
             (base32
              "1q3jgkhl5d4d8c396cyvkw60094p0z0a3x7xwhdbi8gl4c2c65ss"))))
   (build-system r-build-system)
   (home-page "https://cran.r-project.org/web/packages/tree/")
   (synopsis "Classification and regression trees")
   (description "This package provides procedures to work with classification
and regression trees.")
   (license license:gpl2+)))

(define-public r-treeclust
  (package
    (name "r-treeclust")
    (version "1.1-7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "treeClust" version))
       (sha256
        (base32
         "1s7kh6q0bkixsygrip95zf1bi10ihddsa5lq9dfxd68yh8rsby6z"))))
    (properties `((upstream-name . "treeClust")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cluster r-rpart))
    (home-page "https://cran.r-project.org/web/packages/treeClust/")
    (synopsis "Cluster distances through trees")
    (description
     "This package provides tools to create a measure of inter-point
dissimilarity useful for clustering mixed data, and, optionally, perform the
clustering.")
    (license license:gpl2+)))

(define-public r-acrosstic
  (package
    (name "r-acrosstic")
    (version "1.0-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "AcrossTic" version))
       (sha256
        (base32
         "03180h79jhjd66ibrnsfp3yyp2jlfysp7cymw46phzj2palghsc0"))))
    (properties `((upstream-name . "AcrossTic")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lpsolve r-treeclust))
    (home-page "https://cran.r-project.org/web/packages/AcrossTic/")
    (synopsis "Cost-minimal regular spanning subgraph with TreeClust")
    (description
     "This is a package for constructing minimum-cost regular spanning
subgraph as part of a non-parametric two-sample test for equality of
distribution.")
    (license license:gpl2+)))

(define-public r-acrt
  (package
    (name "r-acrt")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "acrt" version))
       (sha256
        (base32
         "0y9ndcq8ffpfrv7w9rikm4zn68jpsj6baqisq9kp2433xrwzdb6s"))))
    (properties `((upstream-name . "acrt")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp r-rcppeigen r-sandwich))
    (home-page "https://cran.r-project.org/web/packages/acrt/")
    (synopsis "Autocorrelation robust testing")
    (description
     "This package provides functions for testing affine hypotheses on the
regression coefficient vector in regression models with autocorrelated
errors.")
    (license license:gpl2)))

(define-public r-acs
  (package
    (name "r-acs")
    (version "2.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "acs" version))
       (sha256
        (base32
         "0ajw9rf8l8akcvgqvbxjvryc6wjx74521xyxswz2b0bky3m6kah5"))))
    (properties `((upstream-name . "acs")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-httr r-plyr r-rcpp r-stringr r-xml))
    (home-page "https://dusp.mit.edu/faculty/ezra-haber-glenn")
    (synopsis "Work with data from the US Census")
    (description
     "This package provides a general toolkit for downloading, managing,
analyzing, and presenting data from the
@url{https://www.census.gov/data/developers/data-sets.html, U.S.  Census},
including SF1 (Decennial short-form), SF3 (Decennial long-form), and the
American Community Survey (ACS).  Confidence intervals provided with ACS data
are converted to standard errors to be bundled with estimates in complex
@code{acs} objects.  The package provides new methods to conduct standard
operations on @code{acs} objects and present/plot data in statistically
appropriate ways.")
    (license license:gpl3)))

(define-public r-acss-data
  (package
    (name "r-acss-data")
    (version "1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "acss.data" version))
       (sha256
        (base32
         "09kl4179ipr8bq19g89xcdi1xxs397zcx5cvgp6viy8gn687ilgv"))))
    (properties `((upstream-name . "acss.data")))
    (build-system r-build-system)
    (home-page "http://complexitycalculator.com/methodology.html")
    (synopsis "Data for algorithmic complexity of short strings")
    (description
     "This is a data only package providing the algorithmic complexity of
short strings, computed using the coding theorem method.  For a given set of
symbols in a string, all possible or a large number of random samples of
Turing machines with a given number of states (e.g., 5) and number of symbols
corresponding to the number of symbols in the strings were simulated until
they reached a halting state or failed to end.  This package contains data on
4.5 million strings from length 1 to 12 simulated on Turing machines with 2,
4, 5, 6, and 9 symbols.  The complexity of the string corresponds to the
distribution of the halting states.")
    (license license:gpl2+)))

(define-public r-acss
  (package
    (name "r-acss")
    (version "0.2-5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "acss" version))
       (sha256
        (base32
         "0cqa60544f58l5qd7h6xmsir40b9hqnq6pqgd5hfx2j2l5n7qhmk"))))
    (properties `((upstream-name . "acss")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-acss-data r-zoo))
    (home-page "http://complexitycalculator.com/methodology.html")
    (synopsis "Algorithmic complexity for short strings")
    (description
     "The main purpose of this package is to provide the algorithmic
complexity for short strings, an approximation of the Kolmogorov Complexity of
a short string using the coding theorem method.  While the database containing
the complexity is provided in the data only package @code{acss.data}, this
package provides functions accessing the data such as @code{prob_random}
returning the posterior probability that a given string was produced by a
random process.  In addition, two traditional (but problematic) measures of
complexity are also provided: entropy and change complexity.")
    (license license:gpl2+)))

(define-public r-acswr
  (package
    (name "r-acswr")
    (version "1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ACSWR" version))
       (sha256
        (base32
         "195vjrkang5cl7gwsna0aq4p0h4jym9xg9yh94bnf8vq6wf8j83n"))))
    (properties `((upstream-name . "ACSWR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mass))
    (home-page "https://cran.r-project.org/web/packages/ACSWR/")
    (synopsis "Companion package for the book \"A Course in Statistics with R\"")
    (description
     "This is a companion package for the book \"A Course in Statistics with
R\" (ISBN 978-1-119-15272-9.)")
    (license license:gpl2)))

(define-public r-alabama
  (package
    (name "r-alabama")
    (version "2022.4-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "alabama" version))
       (sha256
        (base32
         "0v6kl6ndm8wvp9xzya3x4gj5kh03qgx13x5vyzn410wsndcjiim8"))))
    (properties `((upstream-name . "alabama")))
    (build-system r-build-system)
    (propagated-inputs (list r-numderiv))
    (home-page "https://cran.r-project.org/web/packages/alabama/")
    (synopsis "Constrained nonlinear optimization")
    (description
     "Alabama stands for Augmented Lagrangian Adaptive Barrier Minimization
Algorithm; it is used for optimizing smooth nonlinear objective functions with
constraints.  Linear or nonlinear equality and inequality constraints are
allowed.")
    (license license:gpl2+)))

(define-public r-gdina
  (package
    (name "r-gdina")
    (version "2.9.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "GDINA" version))
       (sha256
        (base32
         "0bwg9sfsqs5nsqwhjnbb631fbhj0mx2dc4c185qkym9cjb5lfkm9"))))
    (properties `((upstream-name . "GDINA")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-alabama
           r-ggplot2
           r-mass
           r-nloptr
           r-numderiv
           r-rcpp
           r-rcpparmadillo
           r-rsolnp
           r-shiny
           r-shinydashboard))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/Wenchao-Ma/GDINA")
    (synopsis "Generalized DINA model framework")
    (description
     "This package provides a set of psychometric tools for cognitive
diagnosis modeling based on the generalized deterministic inputs, noisy and
gate (G-DINA) model by de la Torre (2011) @url{doi:10.1007/s11336-011-9207-7}
and its extensions, including the sequential G-DINA model by Ma and de la
Torre (2016) @url{doi:10.1111/bmsp.12070} for polytomous responses, and the
polytomous G-DINA model by Chen and de la Torre
@url{doi:10.1177/0146621613479818} for polytomous attributes.  Joint attribute
distribution can be independent, saturated, higher-order, loglinear smoothed
or structured.  Q-matrix validation, item and model fit statistics, model
comparison at test and item level and differential item functioning can also
be conducted.  A graphical user interface is also provided.")
    (license license:gpl3)))

(define-public r-actcd
  (package
    (name "r-actcd")
    (version "1.2-0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ACTCD" version))
       (sha256
        (base32
         "0mzjxxr2zfdidw8ibh6w8mvpkw3q3nvngqi05g9ind26ckvk053p"))))
    (properties `((upstream-name . "ACTCD")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-gdina r-r-methodss3))
    (native-inputs
     (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/ACTCD/")
    (synopsis "Asymptotic classification theory for cognitive diagnosis")
    (description
     "This is a package supporting cluster analysis for cognitive diagnosis
based on the Asymptotic Classification Theory (Chiu, Douglas & Li, 2009;
@url{doi:10.1007/s11336-009-9125-0}).  Given the sample statistic of
sum-scores, cluster analysis techniques can be used to classify examinees into
latent classes based on their attribute patterns.  In addition to the
algorithms used to classify data, three labeling approaches are proposed to
label clusters so that examinees' attribute profiles can be obtained.")
    (license license:gpl2+)))

(define-public r-ineq
  (package
    (name "r-ineq")
    (version "0.2-13")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ineq" version))
       (sha256
        (base32
         "09fsxyrh0j7mwmb5hkhmrzgcy7kf85jxkh7zlwpgqgcsyl1n91z0"))))
    (properties `((upstream-name . "ineq")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/ineq/")
    (synopsis "Measuring inequality, concentration, and poverty")
    (description
     "This package provides tools for measuring inequality, concentration, and
poverty measures.  It provides both empirical and theoretical Lorenz curves.")
    ;; Either of these two versions.
    (license (list license:gpl2 license:gpl3))))

(define-public r-actfrag
  (package
    (name "r-actfrag")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ActFrag" version))
       (sha256
        (base32
         "08r3gwjz4fkyy85dxqix0ffm5xyq45032qv3snnzxnlqxslxbqn1"))))
    (properties `((upstream-name . "ActFrag")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-accelerometry r-dplyr r-ineq r-survival r-tidyr))
    (home-page "https://github.com/junruidi/ActFrag")
    (synopsis "Activity fragmentation metrics extraction")
    (description
     "This package provides functions to extract commonly used fragmentation
metrics to quantify time accumulation strategies based on minute level
actigraphy-measured activity counts data.")
    (license license:gpl3)))

(define-public r-ash
  (package
    (name "r-ash")
    (version "1.0-15")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ash" version))
       (sha256
        (base32
         "1ay2a2agdmiz7zzvn26mli0x0iwk09g5pp4yy1r23knhkp1pn2lb"))))
    (properties `((upstream-name . "ash")))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/ash/")
    (synopsis "David Scott's ASH routines")
    (description
     "This package provides David Scott's ASH routines ported from S-PLUS to
R.")
    (license license:gpl2+)))

(define-public r-hdrcde
  (package
    (name "r-hdrcde")
    (version "3.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "hdrcde" version))
       (sha256
        (base32
         "16qlk44cjvn2s0vzaf915df65ksdx20dbxhy7fpdqins46hccha3"))))
    (properties `((upstream-name . "hdrcde")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ash
           r-ggplot2
           r-kernsmooth
           r-ks
           r-locfit
           r-rcolorbrewer))
    (native-inputs (list gfortran))
    (home-page "http://pkg.robjhyndman.com/hdrcde")
    (synopsis "Highest density regions and conditional density estimation")
    (description
     "This is a package for the computation of highest density regions in one
and two dimensions, kernel estimation of univariate density functions
conditional on one covariate, and multimodal regression.")
    (license license:gpl3)))

(define-public r-rainbow
  (package
    (name "r-rainbow")
    (version "3.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rainbow" version))
       (sha256
        (base32
         "1cldipi3cb55d434wv03ymwygbisfwgq2b84gwwkgqpfal2xk78m"))))
    (properties `((upstream-name . "rainbow")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cluster
           r-colorspace
           r-hdrcde
           r-ks
           r-mass
           r-pcapp))
    (home-page "https://cran.r-project.org/web/packages/rainbow/")
    (synopsis "Bagplots, boxplots and rainbow plots for functional data")
    (description
     "This is a package for visualizing functional data and identifying
functional outliers with bagplots, boxplots and rainbow plots.")
    (license license:gpl3)))

(define-public r-fds
  (package
    (name "r-fds")
    (version "1.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fds" version))
       (sha256
        (base32
         "1284vncixrzrz9x6b52gslrbrbia07sd0xac7nwdqhp5f5v5wfi0"))))
    (properties `((upstream-name . "fds")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rainbow r-rcurl))
    (home-page "https://cran.r-project.org/web/packages/fds/")
    (synopsis "Functional data sets")
    (description "This package contains a list of functional time series,
sliced functional time series, and functional data sets.  Functional time
series is a special type of functional data observed over time.  Sliced
functional time series is a special type of functional time series with a time
variable observed over time.")
    (license license:gpl2+)))

(define-public r-fda
  (package
    (name "r-fda")
    (version "6.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fda" version))
       (sha256
        (base32
         "1wdq35acxavarh7qrxxmdpcjc9jcs56mp3p9rbb4qa35ziv5fi0l"))))
    (properties `((upstream-name . "fda")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-desolve r-fds))
    (native-inputs
     (list r-knitr))
    (home-page "https://www.functionaldata.org")
    (synopsis "Functional data analysis")
    (description
     "These functions were developed to support functional data analysis as
described in Ramsay, J. O. and Silverman, B. W. (2005) Functional Data
Analysis.  The package includes data sets and script files working many
examples.")
    (license license:gpl2+)))

(define-public r-actigraphy
  (package
    (name "r-actigraphy")
    (version "1.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Actigraphy" version))
       (sha256
        (base32
         "0bpmvszzv5fm72nar3wgnmfl5am7znqfajmlbv38ihkbi7jbwk20"))))
    (properties `((upstream-name . "Actigraphy")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-fda))
    (home-page "https://cran.r-project.org/web/packages/Actigraphy/")
    (synopsis "Actigraphy data analysis")
    (description
     "This package provides tools for functional linear modeling and analysis
of actigraphy data.")
    (license license:asl2.0)))

(define-public r-activedriver
  (package
    (name "r-activedriver")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ActiveDriver" version))
       (sha256
        (base32
         "10c7ga48fwvpd5mc4dqiyw4kc2l0iz5qn4hg7xk15r1qmm5rsipa"))))
    (properties `((upstream-name . "ActiveDriver")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mass))
    (home-page "https://cran.r-project.org/web/packages/ActiveDriver/")
    (synopsis "Tools for finding cancer driver proteins")
    (description
     "This package provides a mutation analysis tool that discovers cancer
driver genes with frequent mutations in protein signalling sites such as
post-translational modifications (phosphorylation, ubiquitination, etc).  The
Poisson generalized linear regression model identifies genes where cancer
mutations in signalling sites are more frequent than expected from the
sequence of the entire gene.  Integration of mutations with signalling
information helps find new driver genes and propose candidate mechanisms to
known drivers.")
    (license license:gpl2+)))

(define-public r-activitycounts
  (package
    (name "r-activitycounts")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "activityCounts" version))
       (sha256
        (base32
         "0zgxr2sk3a8kmygfxx1p5hnrfwdkxx7php6jlrhm8wv6052ck8jz"))))
    (properties
     `((upstream-name . "activityCounts")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lubridate r-magrittr r-seewave r-signal r-tibble))
    (home-page "https://github.com/walkabillylab/activityCounts")
    (synopsis "Generate ActiLife counts")
    (description
     "ActiLife generates activity counts from data collected by Actigraph
accelerometers.  Actigraph is one of the most common research-grade
accelerometers.  There is considerable research validating and developing
algorithms for human activity using ActiLife counts.  Unfortunately, ActiLife
counts are proprietary and difficult to implement if researchers use different
accelerometer brands.  The code creates ActiLife counts from raw acceleration
data for different accelerometer brands.")
    (license license:gpl3)))

(define-public r-activityindex
  (package
    (name "r-activityindex")
    (version "0.3.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ActivityIndex" version))
       (sha256
        (base32
         "1zj2b6x31a1kxl80rarmkrlm7ack4154mrkbqs3fpi48zpmjbgd5"))))
    (properties `((upstream-name . "ActivityIndex")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-data-table r-matrixstats r-r-utils))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/ActivityIndex/")
    (synopsis "Activity Index calculation using raw accelerometry data")
    (description
     "This is a package to read raw accelerometry from GT3X+ accelerometry
data and plain table data to calculate the Activity Index from Bai et
al. (2016) @url{doi:10.1371/journal.pone.0160644}.")
    (license license:gpl3)))

(define-public r-activpal
  (package
    (name "r-activpal")
    (version "0.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "activPAL" version))
       (sha256
        (base32
         "1h6hp5z89ji73gdzxy1dgbfwjysiy5lvcqh90xagpb7sa7ahs3na"))))
    (properties `((upstream-name . "activPAL")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-devtools
           r-dplyr
           r-ggplot2
           r-lubridate
           r-magrittr
           r-tidyr))
    (home-page "https://cran.r-project.org/web/packages/activPAL")
    (synopsis "Processing and chart generation from activPAL events files")
    (description
     "This package contains functions to generate pre-defined summary
statistics from activPAL events files.  The package also contains functions to
produce informative graphics that visualize physical activity behaviour and
trends.  This includes generating graphs that align physical activity
behaviour with additional time based observations described by other data
sets, such as sleep diaries and continuous glucose monitoring data.")
    (license license:gpl3)))

(define-public r-activpalprocessing
  (package
    (name "r-activpalprocessing")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "activpalProcessing" version))
       (sha256
        (base32
         "1y0bjx2qx53iy930y9iww4q1yzjj8y16cwgixk1mq3w4g1f116d1"))))
    (properties
     `((upstream-name . "activpalProcessing")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-chron))
    (home-page "https://cran.r-project.org/web/packages/activpalProcessing/")
    (synopsis "Process activPAL events files")
    (description
     "This package performs estimation of physical activity and sedentary
behavior variables from activPAL events files.")
    ;; Either version of the GPL.
    (license (list license:gpl2 license:gpl3))))

(define-public r-actogrammr
  (package
    (name "r-actogrammr")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "actogrammr" version))
       (sha256
        (base32
         "1jzvarmd41yqlrkagzlc8m19n5mn0w0b36fy50lyvgrfsafjfbqa"))))
    (properties `((upstream-name . "actogrammr")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr r-ggplot2 r-lubridate r-readr r-tidyr))
    (home-page "https://cran.r-project.org/web/packages/actogrammr/")
    (synopsis "Read in activity data and plot actograms")
    (description
     "Read in activity measurements from standard file formats used by
circadian rhythm researchers, currently only ClockLab format, and process and
plot the data.  The central type of plot is the actogram, as first described
in \"Activity and distribution of certain wild mice in relation to biotic
communities\" by MS Johnson (1926) @url{doi:10.2307/1373575}.")
    (license license:gpl3)))

(define-public r-expint
  (package
    (name "r-expint")
    (version "0.1-8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "expint" version))
       (sha256
        (base32
         "1cn6c84pqf8bgk109qm4znn186h6s6cpll3d11cw144h0vh4yr8j"))))
    (properties `((upstream-name . "expint")))
    (build-system r-build-system)
    (home-page "https://gitlab.com/vigou3/expint")
    (synopsis "Exponential integral and incomplete Gamma function")
    (description
     "This package provides the exponential integrals @code{E_1(x)},
@code{E_2(x)}, @code{E_n(x)} and @code{Ei(x)}, and the incomplete gamma
function @code{G(a, x)} defined for negative values of its first argument.
The package also gives easy access to the underlying C routines through an
API; see the package vignette for details.")
    (license license:gpl2+)))

(define-public r-actuar
  (package
    (name "r-actuar")
    (version "3.3-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "actuar" version))
       (sha256
        (base32
         "16nyhn0aw2mb8915ycr46rjvg9pbcps7zxs2sgvdws9kzm027mpj"))))
    (properties `((upstream-name . "actuar")))
    (build-system r-build-system)
    (propagated-inputs (list r-expint))
    (home-page "https://gitlab.com/vigou3/actuar")
    (synopsis "Actuarial functions and heavy tailed distributions")
    (description
     "This package provides functions and data sets for actuarial science:
modeling of loss distributions; risk theory and ruin theory; simulation of
compound models, discrete mixtures and compound hierarchical models;
credibility theory.  It boasts support for many additional probability
distributions to model insurance loss amounts and loss frequency: 19
continuous heavy tailed distributions; the Poisson-inverse Gaussian discrete
distribution; zero-truncated and zero-modified extensions of the standard
discrete distributions.  It also supports phase-type distributions commonly
used to compute ruin probabilities.")
    (license license:gpl2+)))

(define-public r-bmp
  (package
    (name "r-bmp")
    (version "0.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bmp" version))
       (sha256
        (base32
         "0jd67r11bn98hjwgyr6gas423787xy7ji2hq7ay80blkkcj91xxx"))))
    (properties `((upstream-name . "bmp")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/bmp/")
    (synopsis "Read Bitmap (BMP) images")
    (description
     "This package provides pure R tools to read BMP format images.  It is
currently limited to 8 bit greyscale images and 24, 32 bit (A)RGB images.")
    (license license:gpl2+)))

(define-public r-readbitmap
  (package
    (name "r-readbitmap")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "readbitmap" version))
       (sha256
        (base32
         "14825906l326w59g6apy00j55jg3h5kx2r6s031f4gdkbrc7szbk"))))
    (properties `((upstream-name . "readbitmap")))
    (build-system r-build-system)
    (inputs
     (list libjpeg-turbo libpng))
    (propagated-inputs
     (list r-bmp r-jpeg r-png r-tiff))
    (home-page "https://github.com/jefferis/readbitmap")
    (synopsis "Unified interface to read bitmap images (BMP, JPEG, PNG, TIFF)")
    (description
     "This package provides tools to identify and read BMP, JPEG, PNG, and
TIFF format bitmap images.  Identification defaults to the use of the magic
number embedded in the file rather than the file extension.")
    (license license:gpl2+)))

(define-public r-imager
  (package
    (name "r-imager")
    (version "0.42.13")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "imager" version))
       (sha256
        (base32
         "0zygnmxwbbmj5i2l2affzdz90xvsa7b5pbkzkhjbm40is69rh2nr"))))
    (properties `((upstream-name . "imager")))
    (build-system r-build-system)
    (inputs
     (list fftw libtiff libx11 zlib))
    (propagated-inputs
     (list r-downloader
           r-igraph
           r-jpeg
           r-magrittr
           r-png
           r-purrr
           r-rcpp
           r-readbitmap
           r-stringr))
    (native-inputs
     (list pkg-config r-knitr))
    (home-page "https://dahtah.github.io/imager/")
    (synopsis "Image processing library")
    (description
     "This is a package for fast image processing for images in up to 4
dimensions (two spatial dimensions, one time/depth dimension, one color
dimension).  It provides most traditional image processing tools (filtering,
morphology, transformations, etc.) as well as various functions for easily
analyzing image data using R.  The package wraps @url{http://cimg.eu, CImg}, a
simple, modern C++ library for image processing.")
    (license license:lgpl3)))

(define-public r-acuityview
  (package
    (name "r-acuityview")
    (version "0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "AcuityView" version))
       (sha256
        (base32
         "0f0iclmnwdc8ixiiai4svk4x1g3pjy7dhm3cm58fv6ckx12d3d2l"))))
    (properties `((upstream-name . "AcuityView")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-fftwtools r-imager r-plotrix))
    (home-page "https://cran.r-project.org/web/packages/AcuityView/")
    (synopsis "Display scenes as seen by an animal with less acute vision")
    (description
     "This package provides a simple method for representing a visual scene as
it may be seen by an animal with less acute vision.")
    (license license:gpl2+)))

(define-public r-caret
  (package
    (name "r-caret")
    (version "6.0-93")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "caret" version))
       (sha256
        (base32
         "01sa1h9pc3a062pwm0rxadvg9qxszwcylya7llv08fcxhy46n5ac"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-e1071
           r-foreach
           r-ggplot2
           r-lattice
           r-modelmetrics
           r-nlme
           r-plyr
           r-proc
           r-recipes
           r-reshape2
           r-withr))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/topepo/caret")
    (synopsis "Classification and regression training")
    (description
     "This package provides miscellaneous functions for training and plotting
classification and regression models.")
    (license license:gpl2+)))

(define-public r-adabag
  (package
    (name "r-adabag")
    (version "4.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "adabag" version))
       (sha256
        (base32
         "109wrl1pwvmyv2l909hrvk7dg4aa9pv449mvdycp50zwrsw9w0a7"))))
    (properties `((upstream-name . "adabag")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-caret r-doparallel r-foreach r-rpart))
    (home-page "https://cran.r-project.org/web/packages/adabag/")
    (synopsis "Multiclass AdaBoost.M1, SAMME and Bagging")
    (description
     "This package implements Freund and Schapire's Adaboost.M1 algorithm and
Breiman's Bagging algorithm using classification trees as individual
classifiers.  Once these classifiers have been trained, they can be used to
predict on new data.  Also, cross validation estimation of the error can be
done.")
    (license license:gpl2+)))

(define-public r-adagio
  (package
    (name "r-adagio")
    (version "0.8.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "adagio" version))
       (sha256
        (base32
         "0icwr3cark67jyg9zzqwyv9q4fs0j0xgb5i7nkwv9s7y5dlldl0b"))))
    (properties `((upstream-name . "adagio")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lpsolve))
    (home-page "https://cran.r-project.org/web/packages/adagio/")
    (synopsis "Discrete and global optimization routines")
    (description
     "This package provides methods and algorithms for discrete optimization,
e.g. knapsack and subset sum procedures, derivative-free Nelder-Mead and
Hooke-Jeeves minimization, and some (evolutionary) global optimization
functions.")
    (license license:gpl3+)))

(define-public r-univoutl
  (package
    (name "r-univoutl")
    (version "0.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "univOutl" version))
       (sha256
        (base32
         "1kp014bhs8v02fp7misrj4fpfp2na9lg45p5zqvlfaypnm5imsr9"))))
    (properties `((upstream-name . "univOutl")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-hmisc r-robustbase))
    (home-page "https://github.com/marcellodo/univOutl")
    (synopsis "Detection of univariate outliers")
    (description
     "This package provides well-known outlier detection techniques in the
univariate case.  Methods to deal with skewed distribution are included too.
The Hidiroglou-Berthelot (1986) method to search for outliers in ratios of
historical data is implemented as well.  When available, survey weights can be
used in outliers detection.")
    (license license:gpl2+)))

(define-public r-tolerance
  (package
    (name "r-tolerance")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tolerance" version))
       (sha256
        (base32
         "001snzr2ipag3zprynydlbi9prkjzrllc054qh7m0qwkb3r19jjd"))))
    (properties `((upstream-name . "tolerance")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mass r-rgl))
    (home-page "https://cran.r-project.org/web/packages/tolerance/")
    (synopsis "Statistical tolerance intervals and regions")
    (description
     "This package provides functions for estimating tolerance
limits (intervals) for various univariate distributions (binomial, Cauchy,
discrete Pareto, exponential, two-parameter exponential, extreme value,
hypergeometric, Laplace, logistic, negative binomial, negative hypergeometric,
normal, Pareto, Poisson-Lindley, Poisson, uniform, and Zipf-Mandelbrot),
Bayesian normal tolerance limits, multivariate normal tolerance regions,
nonparametric tolerance intervals, tolerance bands for regression
settings (linear regression, nonlinear regression, nonparametric regression,
and multivariate regression), and analysis of variance tolerance intervals.
Visualizations are also available for most of these settings.")
    (license license:gpl2+)))

;; Keep this in sync with the liblantern package.
(define-public r-torch
  (package
    (name "r-torch")
    (version "0.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "torch" version))
       (sha256
        (base32 "1iylnz0hsi00q7hngi2h24kg3nvjjg10z6iarqhp3wylsasgjs1f"))))
    (properties `((upstream-name . "torch")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      (let ((python-version (version-major+minor (package-version python))))
        #~(modify-phases %standard-phases
            (add-after 'install 'link-libraries
              (lambda* (#:key inputs #:allow-other-keys)
                (let ((deps (string-append #$output "/site-library/torch/deps"))
                      (site-packages (string-append "/lib/python"
                                                    #$python-version
                                                    "/site-packages")))
                  (mkdir-p deps)
                  (symlink
                   (search-input-file
                    inputs (string-append site-packages "/torch/lib/libtorch.so"))
                   (string-append deps "/libtorch.so"))
                  (symlink
                   (search-input-file
                    inputs "/lib/liblantern.so")
                   (string-append deps "/liblantern.so")))))))))
    (inputs
     (list python-pytorch-for-r-torch
           liblantern))
    (propagated-inputs
     (list r-bit64
           r-callr
           r-cli
           r-coro
           r-ellipsis
           r-magrittr
           r-r6
           r-rcpp
           r-rlang
           r-withr))
    (native-inputs (list r-knitr))
    (home-page "https://torch.mlverse.org/docs")
    (synopsis "Tensors and neural networks with GPU acceleration")
    (description
     "This package provides functionality to define and train neural networks
similar to PyTorch but written entirely in R using the libtorch library.  It
also supports low-level tensor operations and GPU acceleration.")
    (license license:expat)))

(define-public r-additivitytests
  (package
    (name "r-additivitytests")
    (version "1.1-4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "additivityTests" version))
       (sha256
        (base32
         "00kzfv86z6kk0gvbz9mg3p6xi5fb8cn74rhslr17rdpd02md0884"))))
    (properties
     `((upstream-name . "additivityTests")))
    (build-system r-build-system)
    (native-inputs (list r-knitr))
    (home-page "https://github.com/simecek/additivityTests")
    (synopsis "Additivity tests in the two way Anova with single sub-class numbers")
    (description
     "This package provides an implementation of the Tukey, Mandel,
Johnson-Graybill, LBI, Tusell and modified Tukey non-additivity tests.")
    (license license:gpl3)))

(define-public r-flexclust
  (package
    (name "r-flexclust")
    (version "1.4-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "flexclust" version))
       (sha256
        (base32
         "13akk3w6a76jpws5v9108c3hdmb8i6gm0sc06lr2hqly0pgpfyfn"))))
    (properties `((upstream-name . "flexclust")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-class r-lattice r-modeltools))
    (home-page "https://cran.r-project.org/web/packages/flexclust/")
    (synopsis "Flexible cluster algorithms")
    (description
     "The main function @code{kcca} implements a general framework for
k-centroids cluster analysis supporting arbitrary distance measures and
centroid computation.  Further cluster methods include hard competitive
learning, neural gas, and QT clustering.  There are numerous visualization
methods for cluster results (neighborhood graphs, convex cluster hulls,
barcharts of centroids, ...), and bootstrap methods for the analysis of
cluster stability.")
    (license license:gpl2)))

(define-public r-biclust
  (package
    (name "r-biclust")
    (version "2.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "biclust" version))
       (sha256
        (base32
         "0lgyc2f04dhr65cwga78pradxsdzgjrpp8vphchqn60ab1z95dlp"))))
    (properties `((upstream-name . "biclust")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-additivitytests
           r-colorspace
           r-flexclust
           r-ggplot2
           r-lattice
           r-mass
           r-tidyr))
    (home-page "https://cran.r-project.org/web/packages/biclust/")
    (synopsis "BiCluster algorithms")
    (description
     "The main function @code{biclust()} provides several algorithms to find
biclusters in two-dimensional data, spectral, plaid model, xmotifs, and bimax.
In addition, the package provides methods for data
preprocessing (normalization and discretization), visualization, and
validation of bicluster solutions.")
    (license license:gpl3)))

(define-public r-icge
  (package
    (name "r-icge")
    (version "0.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ICGE" version))
       (sha256
        (base32
         "13p9v0g5qda8bpj3sj9p277l7idv4jscrsszg2kn080dapp3cppp"))))
    (properties `((upstream-name . "ICGE")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cluster r-fastcluster r-mass))
    (home-page "https://cran.r-project.org/web/packages/ICGE/")
    (synopsis "Cluster estimation and identification of atypical units")
    (description
     "ICGE is a package that helps to estimate the number of real clusters in
data as well as to identify atypical units.  The underlying methods are based
on distances rather than on unit x variables.")
    (license license:gpl2+)))

(define-public r-depth
  (package
    (name "r-depth")
    (version "2.1-1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "depth" version))
       (sha256
        (base32
         "0szy0027nh4ps1z919i740i50app5q7cfyg1fj7pdyl45nbl8k6m"))))
    (properties `((upstream-name . "depth")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-abind r-circular r-rgl))
    (native-inputs
     (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/depth/")
    (synopsis "Nonparametric depth functions for multivariate analysis")
    (description
     "This package provides tools for depth functions methodology applied to
multivariate analysis.  Besides allowing calculation of depth values and
depth-based location estimators, the package includes functions or drawing
contour plots and perspective plots of depth functions.  Euclidean and
spherical depths are supported.")
    (license license:gpl2)))

(define-public r-archetypes
  (package
    (name "r-archetypes")
    (version "2.2-0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "archetypes" version))
       (sha256
        (base32
         "0ibxsr173ib77gjhid91m85s8gjii4mi2w3d52q5301igv20p7r0"))))
    (properties `((upstream-name . "archetypes")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-modeltools r-nnls))
    (home-page "https://cran.r-project.org/web/packages/archetypes")
    (synopsis "Archetypal analysis")
    (description
     "The main function @code{archetypes} implements a framework for
archetypal analysis supporting arbitrary problem solving mechanisms for the
different conceptual parts of the algorithm.")
    (license license:gpl2+)))

(define-public r-shapes
  (package
    (name "r-shapes")
    (version "1.2.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shapes" version))
       (sha256
        (base32
         "1p9fr95zk3q2v277c5ksb0nh26mcpzwjzjb2lmag51z6hck8cb66"))))
    (properties `((upstream-name . "shapes")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mass r-minpack-lm r-rgl r-scatterplot3d))
    (home-page "http://www.maths.nottingham.ac.uk/~ild/shapes")
    (synopsis "Statistical shape analysis")
    (description
     "This package provides routines for the statistical analysis of landmark
shapes, including Procrustes analysis, graphical displays, principal
components analysis, permutation and bootstrap tests, thin-plate spline
transformation grids and comparing covariance matrices.  See Dryden, I.L.  and
Mardia, K.V. (2016).  Statistical shape analysis, with Applications in R (2nd
Edition), John Wiley and Sons.")
    (license license:gpl2)))

(define-public r-animation
  (package
    (name "r-animation")
    (version "2.7")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "animation" version))
              (sha256
               (base32
                "0sg4sz5lkn85yzpcg22xkr7921cbnh7g74nlp9imjy7c0hdqyhc8"))
              (snippet
               '(for-each delete-file
                          '("inst/misc/scianimator/js/jquery.scianimator.min.js"
                            "inst/misc/scianimator/js/jquery-1.4.4.min.js")))))
    (properties `((upstream-name . "animation")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst/misc/"
               (symlink (search-input-file
                         inputs
                         "share/javascript/jquery.scianimator.min.js")
                        "scianimator/js/jquery.scianimator.min.js")
               (invoke "esbuild" (assoc-ref inputs "js-jquery")
                       "--minify"
                       (string-append "--outfile="
                                      "scianimator/js/jquery-1.4.4.min.js"))))))))
    (propagated-inputs (list r-magick))
    (inputs (list js-scianimator))
    (native-inputs
     `(("esbuild" ,esbuild)
       ("js-jquery"
        ,(origin
           (method url-fetch)
           (uri "https://code.jquery.com/jquery-1.4.4.js")
           (sha256
            (base32
             "10nl4smq63vrfb0c3n0fknm1zw7ss8gicy6wc6jb6l3rmyad075k"))))))
    (home-page "https://yihui.org/animation/")
    (synopsis "Gallery of animations and utilities to create animations")
    (description
     "This package provides functions for animations in statistics, covering
topics in probability theory, mathematical statistics, multivariate
statistics, non-parametric statistics, sampling survey, linear models, time
series, computational statistics, data mining and machine learning.  These
functions may be helpful in teaching statistics and data analysis.  Also
provided in this package are a series of functions to save animations to
various formats, e.g. GIF, HTML pages, PDF, and videos.  PDF animations can be
inserted into Sweave / @code{knitr} easily.")
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-anthropometry
  (package
    (name "r-anthropometry")
    (version "1.17")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Anthropometry" version))
       (sha256
        (base32
         "0vxjlzxv16bygw8n57f25msq5bd1dydg41my92ximah0nzzvbg41"))))
    (properties `((upstream-name . "Anthropometry")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-archetypes
           r-biclust
           r-cluster
           r-depth
           r-fnn
           r-icge
           r-nnls
           r-rgl
           r-shapes))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/Anthropometry/")
    (synopsis "Statistical methods for anthropometric data")
    (description
     "This package provides statistical methods especially developed to
analyze anthropometric data.  These methods are aimed at providing effective
solutions to some commons problems related to Ergonomics and Anthropometry.
They are based on clustering, the statistical concept of data depth,
statistical shape analysis and archetypal analysis.")
    (license license:gpl2+)))

(define-public r-anndata
  (package
    (name "r-anndata")
    (version "0.7.5.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "anndata" version))
       (sha256
        (base32 "1ync82qp0v6zszibz8bwhlyknf99v3iki8cwq4n4vwmg9z7hrb54"))))
    (properties `((upstream-name . "anndata")))
    (build-system r-build-system)
    (propagated-inputs (list r-assertthat r-matrix r-r6 r-reticulate))
    (native-inputs (list r-knitr))
    (home-page "https://anndata.dynverse.org")
    (synopsis "Anndata for R")
    (description
     "This package provides a reticulate wrapper for the Python package
@code{anndata}.  It provides a scalable way of keeping track of data and
learned annotations.  It is used to read from and write to the h5ad file
format.")
    (license license:expat)))

(define-public r-adamethods
  (package
    (name "r-adamethods")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "adamethods" version))
       (sha256
        (base32
         "150awbd3skb1mqca18bqjykhyycqw8crviw66s6qrcnmcsbk77pj"))))
    (properties `((upstream-name . "adamethods")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-anthropometry
           r-archetypes
           r-fnn
           r-foreach
           r-nnls
           r-tolerance
           r-univoutl))
    (home-page "https://cran.r-project.org/web/packages/adamethods/")
    (synopsis "Archetypoid algorithms and anomaly detection")
    (description
     "This package is a collection of several algorithms to obtain
archetypoids with small and large databases and with both classical
multivariate data and functional data (univariate and multivariate).  Some of
these algorithms also detect anomalies (outliers).")
    (license license:gpl2+)))

(define-public r-idpmisc
  (package
    (name "r-idpmisc")
    (version "1.1.20")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "IDPmisc" version))
       (sha256
        (base32
         "0zy6mxqa8arq0vvhsdcifzm3085c23rnwa1n36fhircph1xwvfdw"))))
    (properties `((upstream-name . "IDPmisc")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lattice))
    (home-page "https://cran.r-project.org/web/packages/IDPmisc/")
    (synopsis "Functions for data analyses and visualization")
    (description
     "This package provides different high-level graphics functions for
displaying large datasets, displaying circular data in a very flexible way,
finding local maxima, brewing color ramps, drawing nice arrows, zooming
2D-plots, creating figures with differently colored margin and plot region.
In addition, the package contains auxiliary functions for data manipulation
like omitting observations with irregular values or selecting data by logical
vectors, which include NAs.  Other functions are especially useful in
spectroscopy and analyses of environmental data: robust baseline fitting,
finding peaks in spectra, converting humidity measures.")
    (license license:gpl3+)))

(define-public r-qqconf
  (package
    (name "r-qqconf")
    (version "1.3.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "qqconf" version))
              (sha256
               (base32
                "11sh0q5bwmqdygqd1gspx7xc5mysj18whz11afnz6s1m820snhhw"))))
    (properties `((upstream-name . "qqconf")))
    (build-system r-build-system)
    (inputs (list fftw))
    (propagated-inputs
     (list r-mass
           r-rcpp
           r-robustbase))
    (native-inputs (list pkg-config r-knitr))
    (home-page "https://github.com/eweine/qqconf")
    (synopsis "Create simultaneous testing bands for QQ-plots")
    (description
     "This package provides functionality for creating Quantile-Quantile (QQ) and
Probability-Probability (PP) plots with simultaneous testing bands to asses
significance of sample deviation from a reference distribution.")
    (license license:gpl3)))

(define-public r-qqman
  (package
    (name "r-qqman")
    (version "0.1.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "qqman" version))
       (sha256
        (base32
         "1a6qp5wv9bvwjchfw8x4jh48hkynlnfr21a8vqgnswldvwbq7njq"))))
    (properties `((upstream-name . "qqman")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-calibrate))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/qqman/")
    (synopsis "Q-Q and Manhattan plots for GWAS data")
    (description
     "This package allows you to create Q-Q and Manhattan plots for GWAS data
from PLINK results.")
    (license license:gpl3)))

(define-public r-gghighlight
  (package
    (name "r-gghighlight")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gghighlight" version))
       (sha256
        (base32 "0vfcn3gg6j7g20n2z1iwr94jnpqn0zl5j9jfc8bnbsrmz49dzqpd"))))
    (properties `((upstream-name . "gghighlight")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr r-ggplot2 r-ggrepel r-lifecycle r-purrr r-rlang r-tibble))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/yutannihilation/gghighlight/")
    (synopsis "Highlight lines and points in ggplot2")
    (description "Suppose we have data that has so many series that it is hard
to identify them by their colors as the differences are so subtle.  With
gghighlight we can highlight those lines that match certain criteria.  The
result is a usual @code{ggplot} object, so it is fully customizable and can be
used with custom themes and facets.")
    (license license:expat)))

(define-public r-ggplot-multistats
  (package
    (name "r-ggplot-multistats")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggplot.multistats" version))
       (sha256
        (base32
         "1afzfa86vc484bcwpg7m1ky03jpax584rigzgai8w06pifkmz0il"))))
    (properties
     `((upstream-name . "ggplot.multistats")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-hexbin r-rlang r-scales))
    (home-page "https://github.com/flying-sheep/ggplot.multistats")
    (synopsis "Multiple summary statistics for binned stats/geometries")
    (description
     "This package provides the ggplot binning layer @code{stat_summaries_hex()},
which functions similar to its singular form, but allows the use of multiple
statistics per bin.  Those statistics can be mapped to multiple bin
aesthetics.")
    (license license:gpl3)))

(define-public r-knn-covertree
  (package
    (name "r-knn-covertree")
    (version "1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "knn.covertree" version))
       (sha256
        (base32
         "0msfcmwydws7q7m5jdb0dxab0nkbl7mq5llg6v3r4qrnlvrdggvz"))))
    (properties `((upstream-name . "knn.covertree")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-matrix r-rcpp r-rcppeigen))
    (home-page "https://github.com/flying-sheep/knn.covertree")
    (synopsis "Accurate kNN Implementation with multiple distance measures")
    (description
     "Similarly to the FNN package, this package allows calculation of the k
nearest neighbors (kNN) of a data matrix.  The implementation is based on
cover trees introduced by Alina Beygelzimer, Sham Kakade, and John
Langford (2006) @url{doi:10.1145/1143844.1143857}.")
    (license license:agpl3+)))

(define-public r-poibin
  (package
    (name "r-poibin")
    (version "1.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "poibin" version))
       (sha256
        (base32
         "1sxryvwwz6ldsnkzdy56p8c895s5yvpcai9ndyjv1x5q3l05wf9v"))))
    (properties `((upstream-name . "poibin")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/poibin/")
    (synopsis "Poisson binomial distribution")
    (description
     "This package provides an implementation of both the exact and
approximation methods for computing the @dfn{cumulative distribution
function} (CDF) of the Poisson binomial distribution.  It also provides the
@dfn{probability mass function} (PMF), quantile function, and random number
generation for the Poisson binomial distribution.")
    (license license:gpl2)))

(define-public r-diagram
  (package
    (name "r-diagram")
    (version "1.6.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "diagram" version))
       (sha256
        (base32
         "1r3lyl0h7mk9cfg8smr3jydfkjdawaphnxibkxfjqa7029vkxh79"))))
    (properties `((upstream-name . "diagram")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-shape))
    (home-page "https://cran.r-project.org/web/packages/diagram/")
    (synopsis "Visualize simple graphs (networks) and plot flow diagrams")
    (description
     "This package provides tools to visualize simple graphs (networks) based
on a transition matrix, utilities to plot flow diagrams, visualizing webs,
electrical networks, etc.  It also includes supporting material for the book
\"A practical guide to ecological modelling - using R as a simulation
platform\" by Karline Soetaert and Peter M.J. Herman (2009) and the book
\"Solving Differential Equations in R\" by Karline Soetaert, Jeff Cash and
Francesca Mazzia (2012).")
    (license license:gpl2+)))

(define-public r-lim
  (package
    (name "r-lim")
    (version "1.4.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "LIM" version))
       (sha256
        (base32
         "0d9bgyd0mnag8wds993dsvlbpkhyakydlzwc3nghxzv2n8504hjj"))))
    (properties `((upstream-name . "LIM")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-diagram r-limsolve))
    (home-page "https://cran.r-project.org/web/packages/LIM/")
    (synopsis "Linear inverse model examples and solution methods")
    (description
     "This package provides functions that read and solve linear inverse
problems (food web problems, linear programming problems).")
    (license license:gpl2+)))

(define-public r-shinycssloaders
  (package
    (name "r-shinycssloaders")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shinycssloaders" version))
       (sha256
        (base32
         "0r3xm273lhdhzbs2mkgw1m2kwb7z1dh1pzya8yxy5vacda1l2ikl"))))
    (properties
     `((upstream-name . "shinycssloaders")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-digest r-glue r-shiny))
    (home-page "https://github.com/andrewsali/shinycssloaders")
    (synopsis "Add CSS loading animations to Shiny outputs")
    (description
     "This package provides tools to create a lightweight Shiny wrapper for
the css-loaders created by Luke Hass
@url{https://github.com/lukehaas/css-loaders}.  Wrapping a Shiny output will
automatically show a loader when the output is (re)calculating.")
    (license license:gpl3)))

(define-public r-rsvg
  (package
    (name "r-rsvg")
    (version "2.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rsvg" version))
       (sha256
        (base32
         "1lx84x5dnxj1xdsidwfg9i6fkay7ldarwrbg0gl0f02wajf8ifsz"))))
    (properties `((upstream-name . "rsvg")))
    (build-system r-build-system)
    (inputs
     (list librsvg zlib))
    (native-inputs
     (list pkg-config r-knitr))
    (home-page "https://github.com/jeroen/rsvg#readme")
    (synopsis "Render SVG images into PDF, PNG, PostScript, or Bitmap arrays")
    (description
     "This package allows you to render vector-based SVG images into
high-quality custom-size bitmap arrays using the librsvg2 library.  The
resulting bitmap can be written to e.g. PNG, JPEG or WEBP format.  In
addition, the package can convert images directly to various formats such as
PDF or PostScript.")
    (license license:expat)))

(define-public r-influencer
  (package
    (name "r-influencer")
    (version "0.1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "influenceR" version))
       (sha256
        (base32
         "0rj7rm236vn3v8302nwl12s0kvpv6xpdbm3q3gxk7vgwfl8nzi33"))))
    (properties `((upstream-name . "influenceR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-igraph r-matrix))
    (home-page "https://github.com/rcc-uchicago/influenceR")
    (synopsis "Tools to quantify structural importance of nodes in a network")
    (description
     "This package provides functionality to compute various node centrality
measures on networks.  Included are functions to compute betweenness
centrality (by utilizing Madduri and Bader's SNAP library), implementations of
Burt's constraint and @dfn{effective network size} (ENS) metrics, Borgatti's
algorithm to identify key players, and Valente's bridging metric.  The
betweenness, Key Players, and bridging implementations are parallelized with
OpenMP.")
    (license license:gpl2)))

(define-public r-emplik
  (package
    (name "r-emplik")
    (version "1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "emplik" version))
       (sha256
        (base32
         "039kz7703ri91j2i93dr8ixap7i63sr72id9zp74cm7ws9pd1b27"))))
    (properties `((upstream-name . "emplik")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-quantreg))
    (home-page "https://www.ms.uky.edu/~mai/EmpLik.html")
    (synopsis "Empirical likelihood ratio for censored/truncated data")
    (description
     "This package provides empirical likelihood ratio tests for
means/quantiles/hazards from possibly censored and/or truncated data.  It also
does regression.")
    (license license:gpl2+)))

(define-public r-imputeyn
  (package
    (name "r-imputeyn")
    (version "1.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "imputeYn" version))
       (sha256
        (base32
         "1b21w1aa5f7yiq8k0wa86wvbg4ij7f6ldwn6asfqwb0b90rvsgvs"))))
    (properties `((upstream-name . "imputeYn")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-boot r-emplik r-mvtnorm r-quadprog r-survival))
    (home-page "https://cran.r-project.org/web/packages/imputeYn/")
    (synopsis "Impute last largest censored observation under weighted least squares")
    (description
     "This package allows for the imputation of the last largest censored
observantions.  This method brings less bias and more efficient estimates for
AFT models.")
    (license license:gpl2)))

(define-public r-adapenetclass
  (package
    (name "r-adapenetclass")
    (version "1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "AdapEnetClass" version))
       (sha256
        (base32
         "01k3mj4g1ckbng7wkzzn9h0k9yf01cpnnkly0sjda574c5jhj0rc"))))
    (properties `((upstream-name . "AdapEnetClass")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-glmnet r-imputeyn r-lars r-quadprog))
    (home-page "https://cran.r-project.org/web/packages/AdapEnetClass/")
    (synopsis "Class of adaptive elastic net methods for censored data")
    (description
     "This package provides methods for variable selection for AFT models.")
    (license license:gpl2)))

(define-public r-flock
  (package
    (name "r-flock")
    (version "0.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "flock" version))
       (sha256
        (base32
         "1zg93p74icj4bhxnmnssj2xp6vw4yaksyavq03497v33xfpdxss7"))))
    (properties `((upstream-name . "flock")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (home-page "https://cran.r-project.org/web/packages/flock/")
    (synopsis "Process synchronization using file locks")
    (description
     "This package implements synchronization between R processes (spawned by
using the @code{parallel} package for instance) using file locks.  It supports
both exclusive and shared locking.")
    (license license:asl2.0)))

(define-public r-archivist
  (package
    (name "r-archivist")
    (version "2.3.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "archivist" version))
       (sha256
        (base32
         "0q1qysack30xzxdbvvi56rk7r85hsj4ghls9r70ki7bl3rqwr4c9"))))
    (properties `((upstream-name . "archivist")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dbi
           r-digest
           r-flock
           r-httr
           r-lubridate
           r-magrittr
           r-rcurl
           r-rsqlite))
    (native-inputs
     (list r-knitr))
    (home-page "https://pbiecek.github.io/archivist/")
    (synopsis "Tools for storing, restoring and searching for R objects")
    (description
     "Data exploration and modelling is a process in which a lot of data
artifacts are produced.  Artifacts like: subsets, data aggregates, plots,
statistical models, different versions of data sets and different versions of
results.  Archivist helps to store and manage artifacts created in R.  It
allows you to store selected artifacts as binary files together with their
metadata and relations.  Archivist allows sharing artifacts with others.  It
can look for already created artifacts by using its class, name, date of the
creation or other properties.  It also makes it easy to restore such
artifacts.")
    (license license:gpl2)))

(define-public r-versions
  (package
    (name "r-versions")
    (version "0.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "versions" version))
       (sha256
        (base32
         "0zm49j785dgv7fyr1yl9q5f0dsk8hhpim5q5bpkgrkzv7pwjribd"))))
    (properties `((upstream-name . "versions")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/versions/")
    (synopsis "Query and install specific versions of CRAN packages")
    (description
     "This package allows you to install specified versions of R packages
hosted on CRAN and provides functions to list available versions and the
versions of currently installed packages.")
    (license license:bsd-3)))

(define-public r-adapr
  (package
    (name "r-adapr")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "adapr" version))
       (sha256
        (base32
         "1s57jdbi5pik56xjz1d4438ax6cywg2yq2s47h5g6wrwvpgr1qfw"))))
    (properties `((upstream-name . "adapr")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-archivist
           r-devtools
           r-digest
           r-doparallel
           r-gdata
           r-ggplot2
           r-git2r
           r-igraph
           r-knitr
           r-plotly
           r-plyr
           r-rmarkdown
           r-shiny
           r-shinydashboard
           r-versions))
    (home-page "https://cran.r-project.org/web/packages/adapr/")
    (synopsis "Implementation of an accountable data analysis process")
    (description
     "This package tracks reading and writing within R scripts that are
organized into a directed acyclic graph.  It contains an interactive Shiny
application @code{adaprApp()}.  It uses Git and file hashes to track version
histories of inputs and outputs.")
    (license license:lgpl2.0)))

(define-public r-adapsamp
  (package
    (name "r-adapsamp")
    (version "1.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "AdapSamp" version))
       (sha256
        (base32
         "1jayjrsiib2ij4rxxj59g71r3xhzl5yqh0lhi8k6cfy03i7dkvis"))))
    (properties `((upstream-name . "AdapSamp")))
    (build-system r-build-system)
    (propagated-inputs (list r-pracma))
    (home-page "https://cran.r-project.org/web/packages/AdapSamp/")
    (synopsis "Adaptive sampling algorithms")
    (description
     "For distributions whose probability density functions are log-concave,
the adaptive rejection sampling algorithm can be used to build envelope
functions for sampling.  For others, the modified adaptive rejection sampling
algorithm, the concave-convex adaptive rejection sampling algorithm, and the
adaptive slice sampling algorithm can be used.  This R package mainly includes
these four functions: @code{rARS()}, @code{rMARS()}, @code{rCCARS()}, and
@code{rASS()}.  These functions can realize sampling based on the algorithms
above.")
    (license license:gpl2)))

(define-public r-adaptalint
  (package
    (name "r-adaptalint")
    (version "0.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "adaptalint" version))
       (sha256
        (base32
         "15qdcvnnbgcps8j5k79354wsc9alswijv8lcafg2i3lghaw536yf"))))
    (properties `((upstream-name . "adaptalint")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr r-lintr r-purrr))
    (home-page "https://cran.r-project.org/web/packages/adaptalint/")
    (synopsis "Check R code style")
    (description
     "This package provides tools to infer the code style (which style rules
are followed and which ones are not) from one package and use it to check
another.  This makes it easier to find and correct the most important problems
first.")
    (license license:gpl3)))

(define-public r-fracdiff
  (package
    (name "r-fracdiff")
    (version "1.5-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fracdiff" version))
       (sha256
        (base32
         "0dzl011c92skf7hmx1zvdwsrashmfkxy9p2wig35nzr8609qhpxc"))))
    (properties `((upstream-name . "fracdiff")))
    (build-system r-build-system)
    (home-page "https://github.com/mmaechler/fracdiff")
    (synopsis
     "Fractionally differenced ARIMA aka ARFIMA(P,d,q) models")
    (description
     "This package provides tools for the maximum likelihood estimation of the
parameters of a fractionally differenced ARIMA(p,d,q) model (Haslett and
Raftery, Appl.Statistics, 1989); it includes inference and basic methods.")
    (license license:gpl2+)))

(define-public r-forecast
  (package
    (name "r-forecast")
    (version "8.18")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "forecast" version))
       (sha256
        (base32
         "1pfq2b1ppkbg3a9bag4jrfsjclf0c7mdqbhf1l08h6fqv6lbl82r"))))
    (properties `((upstream-name . "forecast")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-colorspace
           r-fracdiff
           r-generics
           r-ggplot2
           r-lmtest
           r-magrittr
           r-nnet
           r-rcpp
           r-rcpparmadillo
           r-timedate
           r-tseries
           r-urca
           r-zoo))
    (native-inputs
     (list r-knitr))           ; needed for vignettes
    (home-page "https://pkg.robjhyndman.com/forecast/")
    (synopsis "Forecasting functions for time series and linear models")
    (description
     "This package provides methods and tools for displaying and analysing
univariate time series forecasts including exponential smoothing via state
space models and automatic ARIMA modelling.")
    (license license:gpl3)))

(define-public r-forestplot
  (package
    (name "r-forestplot")
    (version "3.1.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "forestplot" version))
              (sha256
               (base32
                "0xk30mpb87sab2afnk2j474qjjf4j6x1ifh9j5n7w690f481iqqb"))))
    (properties `((upstream-name . "forestplot")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-abind r-checkmate))
    (native-inputs (list r-knitr))
    (home-page "https://gforge.se/packages/")
    (synopsis "Advanced forest plot using @code{grid} graphics")
    (description
     "This package provides a forest plot that allows for multiple
confidence intervals per row, custom fonts for each text element,
custom confidence intervals, text mixed with expressions, and more.
The aim is to extend the use of forest plots beyond meta-analyses.
This is a more general version of the original @code{rmeta} package's
@code{forestplot()} function and relies heavily on the @code{grid}
package.")
    (license license:gpl2)))

(define-public r-formattable
  (package
    (name "r-formattable")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "formattable" version))
       (sha256
        (base32 "1vdxi0xmg019qyzjrp8bkjxciz245jcxsrkhfzd44ynqcwi4s3ag"))))
    (properties `((upstream-name . "formattable")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-htmltools r-htmlwidgets r-lifecycle r-rmarkdown))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/renkun-ken/formattable")
    (synopsis "Print vectors and data frames with text fromatting")
    (description
     "This R package provides functions to create formattable vectors and data
frames.  @emph{Formattable} vectors are printed with text formatting, and
formattable data frames are printed with multiple types of formatting in HTML
to improve the readability of data presented in tabular form rendered in web
pages.")
    (license license:expat)))

(define-public r-xmisc
  (package
    (name "r-xmisc")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Xmisc" version))
       (sha256
        (base32
         "11gwlcyxhz1p50m68cnqrxmisdk99v8vrsbvyr7k67f0kvsznzs1"))))
    (properties `((upstream-name . "Xmisc")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=Xmisc")
    (synopsis
     "Xiaobei's miscellaneous classes and functions")
    (description
     "This package provides Xiaobei's miscellaneous classes and functions,
which are useful when developing R packages for @dfn{object oriented
programming} (OOP) using R Reference Class.")
    (license license:gpl2+)))

(define-public r-proxyc
  (package
    (name "r-proxyc")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "proxyC" version))
       (sha256
        (base32
         "00p3604ny6qax5rr1865c27hfp90v2vga0xcrp3bb81xcfadl99y"))))
    (properties `((upstream-name . "proxyC")))
    (build-system r-build-system)
    (native-inputs (list r-knitr))
    (propagated-inputs
     (list r-matrix r-rcpp r-rcpparmadillo r-rcppparallel))
    (home-page "https://cran.r-project.org/package=proxyC")
    (synopsis "Compute proximity in large sparse matrices")
    (description
     "This package provides efficient tools to compute the proximity between
rows or columns of large matrices.  Functions are optimised for large sparse
matrices using the Armadillo and Intel TBB libraries.  Among several built-in
similarity/distance measures, computation of correlation, cosine similarity
and Euclidean distance is particularly fast.")
    (license license:gpl3)))

(define-public r-isocodes
  (package
    (name "r-isocodes")
    (version "2022.09.29")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ISOcodes" version))
       (sha256
        (base32
         "1rag5mb3bbyxp8n32rhfyy752cy9hh5j80lp9xljj70scvglzbjb"))))
    (properties `((upstream-name . "ISOcodes")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=ISOcodes")
    (synopsis "Selected ISO codes")
    (description
     "This package provides ISO language, territory, currency, script and
character codes.  It provides ISO 639 language codes, ISO 3166 territory
codes, ISO 4217 currency codes, ISO 15924 script codes, and the ISO 8859
character codes as well as the UN M.49 area codes.")
    (license license:gpl2)))

(define-public r-stopwords
  (package
    (name "r-stopwords")
    (version "2.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "stopwords" version))
       (sha256
        (base32
         "1ci1cgxrcvlhhplximsfv0plvjdbcd5kv0nphxnpildsn5m1rv65"))))
    (properties `((upstream-name . "stopwords")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-isocodes))
    (home-page "https://github.com/quanteda/stopwords")
    (synopsis "Multilingual stopword lists")
    (description
     "This package provides multiple sources of stopwords, for use in text
analysis and natural language processing.")
    (license license:expat)))

(define-public r-spacyr
  (package
    (name "r-spacyr")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "spacyr" version))
       (sha256
        (base32
         "1b2ccgwsiqkvp7w37x8k7699c676q16vfrybkrfvyczyhki4s6nw"))))
    (properties `((upstream-name . "spacyr")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-data-table r-reticulate))
    (home-page "https://spacyr.quanteda.io")
    (synopsis "R wrapper for the spaCy NLP library")
    (description
     "This package provides an R wrapper to the Python @dfn{natural language
processing} (NLP) library @code{spaCy}, from @url{http://spacy.io}.")
    (license license:gpl3)))

(define-public r-snowballc
  (package
    (name "r-snowballc")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "SnowballC" version))
       (sha256
        (base32
         "1wwm71mp4b2mjb5985x782p6xj519dfrpd40qli7lmig6afyw3xi"))))
    (properties `((upstream-name . "SnowballC")))
    (build-system r-build-system)
    (home-page "https://r-forge.r-project.org/projects/r-temis/")
    (synopsis "Snowball stemmers based on the C libstemmer UTF-8 library")
    (description
     "This package provides an R interface to the C @code{libstemmer} library
that implements Porter's word stemming algorithm for collapsing words to a
common root to aid comparison of vocabulary.  Currently supported languages
are Danish, Dutch, English, Finnish, French, German, Hungarian, Italian,
Norwegian, Portuguese, Romanian, Russian, Spanish, Swedish and Turkish.")
    (license license:bsd-3)))

(define-public r-quanteda
  (package
    (name "r-quanteda")
    (version "3.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "quanteda" version))
       (sha256
        (base32
         "1blk9nhydvqyyz0kzhph7nh7ahcjzflmgyr4sv8fx5bpmn4hwjzk"))))
    (properties `((upstream-name . "quanteda")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-fastmatch
           r-magrittr
           r-matrix
           r-rcpp
           r-rcpparmadillo
           r-rcppparallel
           r-snowballc
           r-stopwords
           r-stringi
           r-xml2
           r-yaml))
    (native-inputs
     (list r-knitr))
    (home-page "https://quanteda.io")
    (synopsis "Quantitative analysis of textual data")
    (description
     "This package provides a fast, flexible, and comprehensive framework for
quantitative text analysis in R.  It provides functionality for corpus
management, creating and manipulating tokens and ngrams, exploring keywords in
context, forming and manipulating sparse matrices of documents by features and
feature co-occurrences, analyzing keywords, computing feature similarities and
distances, applying content dictionaries, applying supervised and unsupervised
machine learning, visually representing text and text analyses, and more.")
    (license license:gpl3)))

(define-public r-topicmodels
  (package
    (name "r-topicmodels")
    (version "0.2-12")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "topicmodels" version))
       (sha256
        (base32
         "1d6iizmn042b59q2y6qc82z19wq3xm0zvgkf8iqf8fdzh51kmn5g"))))
    (properties `((upstream-name . "topicmodels")))
    (build-system r-build-system)
    (inputs
     (list gsl))
    (propagated-inputs
     (list r-modeltools r-slam r-tm))
    (home-page "https://cran.r-project.org/package=topicmodels")
    (synopsis "Topic models")
    (description
     "This package provides an interface to the C code for @dfn{Latent
Dirichlet Allocation} (LDA) models and @dfn{Correlated Topics Models} (CTM) by
David M. Blei and co-authors and the C++ code for fitting LDA models using
Gibbs sampling by Xuan-Hieu Phan and co-authors.")
    (license license:gpl2)))

(define-public r-stm
  (package
    (name "r-stm")
    (version "1.3.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "stm" version))
       (sha256
        (base32
         "0qwq4nin2n9fjd06852r8k7arvcgh46kcfb3lm21swgx6j8bgrhb"))))
    (properties `((upstream-name . "stm")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-data-table
           r-glmnet
           r-lda
           r-matrix
           r-matrixstats
           r-quadprog
           r-quanteda
           r-rcpp
           r-rcpparmadillo
           r-slam
           r-stringr))
    (home-page "http://www.structuraltopicmodel.com/")
    (synopsis "Estimation of the Structural Topic Model")
    (description
     "The @dfn{Structural Topic Model} (STM) allows researchers to estimate
topic models with document-level covariates.  The package also includes tools
for model selection, visualization, and estimation of topic-covariate
regressions.")
    (license license:expat)))

(define-public r-polycor
  (package
    (name "r-polycor")
    (version "0.8-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "polycor" version))
       (sha256
        (base32
         "0285rvx8238qp8dix0jq0cqq7ks8h6cjwsscbc7dx4n9nph56pzh"))))
    (properties `((upstream-name . "polycor")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-admisc r-matrix r-mvtnorm))
    (home-page "https://r-forge.r-project.org/projects/polycor/")
    (synopsis "Polychoric and polyserial correlations")
    (description
     "This package provides tools to compute polychoric and polyserial
correlations by quick \"two-step\" methods or ML, optionally with standard
errors; tetrachoric and biserial correlations are special cases.")
    (license license:gpl2+)))

(define-public r-msm
  (package
    (name "r-msm")
    (version "1.6.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "msm" version))
       (sha256
        (base32
         "08vhazswyxr3y1zb9y60mbg3bappzlizxml8s08p65mh82xxkz5f"))))
    (properties `((upstream-name . "msm")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-expm r-mvtnorm r-survival))
    (home-page "https://github.com/chjackson/msm")
    (synopsis "Multi-state Markov and hidden Markov models in continuous time")
    (description
     "This package provides functions for fitting continuous-time Markov and
hidden Markov multi-state models to longitudinal data.  It was designed for
processes observed at arbitrary times in continuous time (panel data) but some
other observation schemes are supported.  Both Markov transition rates and the
hidden Markov output process can be modelled in terms of covariates, which may
be constant or piecewise-constant in time.")
    (license license:gpl2+)))

(define-public r-ltm
  (package
    (name "r-ltm")
    (version "1.2-0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ltm" version))
       (sha256
        (base32
         "0vhgbk6j0z3limsrbjkjkpfn2whiaij5j4jf1gg66mjs9dlylap1"))))
    (properties `((upstream-name . "ltm")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mass r-msm r-polycor))
    (home-page "https://github.com/drizopoulos/ltm")
    (synopsis "Latent trait models under IRT")
    (description
     "This is a package supporting the analysis of multivariate dichotomous
and polytomous data using latent trait models under the Item Response Theory
approach.  It includes the Rasch, the Two-Parameter Logistic, the Birnbaum's
Three-Parameter, the Graded Response, and the Generalized Partial Credit
Models.")
    (license license:gpl2+)))

(define-public r-mi
  (package
    (name "r-mi")
    (version "1.1")
    (source
      (origin
        (method url-fetch)
        (uri (cran-uri "mi" version))
        (sha256
          (base32
            "11f75ivnax6p48mp2pasprws488cm2daym87sw2mcrywvf89fyjd"))))
    (properties `((upstream-name . "mi")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-arm r-matrix))
    (native-inputs
     (list r-knitr))
    (home-page "http://www.stat.columbia.edu/~gelman/")
    (synopsis "Missing data imputation and model checking")
    (description
     "This package provides functions for data manipulation, imputing missing
values in an approximate Bayesian framework, diagnostics of the models used to
generate the imputations, confidence-building mechanisms to validate some of
the assumptions of the imputation algorithm, and functions to analyze multiply
imputed data sets with the appropriate degree of sampling uncertainty.")
    (license license:gpl2+)))

(define-public r-matrixcalc
  (package
    (name "r-matrixcalc")
    (version "1.0-6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "matrixcalc" version))
       (sha256
        (base32
         "09pk0ym6qzribxc6v18cpb6478i4r4kzxpkljjbb3n323zqx5iqb"))))
    (properties `((upstream-name . "matrixcalc")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/matrixcalc/")
    (synopsis "Collection of functions for matrix calculations")
    (description
     "This package provides a collection of functions to support matrix
calculations for probability, econometric and numerical analysis.  There are
additional functions that are comparable to APL functions which are useful for
actuarial models such as pension mathematics.")
    (license license:gpl2+)))

(define-public r-matrixextra
  (package
    (name "r-matrixextra")
    (version "0.1.13")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "MatrixExtra" version))
       (sha256
        (base32 "1s8y8zp9k7rsnyi1d8ghi4brjbbdwxijc9chhla24qm3fi6np33a"))))
    (properties `((upstream-name . "MatrixExtra")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-float r-matrix r-rcpp r-rhpcblasctl))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/david-cortes/MatrixExtra")
    (synopsis "Extra methods for sparse matrices")
    (description
     "This package extends sparse matrix and vector classes from the Matrix
package by providing:

@enumerate
@item Methods and operators that work natively on CSR formats (compressed
  sparse row, a.k.a. @code{RsparseMatrix}) such as slicing/sub-setting,
  assignment, @code{rbind()}, mathematical operators for CSR and COO such as
  addition or @code{sqrt()}, and methods such as @code{diag()};
@item Multi-threaded matrix multiplication and cross-product for many
  @code{<sparse, dense>} types, including the @code{float32} type from
  @code{float};
@item Coercion methods between pairs of classes which are not present in
  @code{Matrix}, such as from @code{dgCMatrix} to @code{ngRMatrix}, as well as
  convenience conversion functions;
@item Utility functions for sparse matrices such as sorting the indices or
  removing zero-valued entries;
@item Fast transposes that work by outputting in the opposite storage format;
@item Faster replacements for many @code{Matrix} methods for all sparse types,
  such as slicing and elementwise multiplication.
@item Convenience functions for sparse objects, such as @code{mapSparse} or a
  shorter @code{show} method.
@end enumerate
")
    (license license:gpl2+)))

(define-public r-sem
  (package
    (name "r-sem")
    (version "3.1-15")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sem" version))
       (sha256
        (base32
         "05hk72zxvyv6kkjhk5y6qw253c64108az7030z8j1sz8wq03n0md"))))
    (properties `((upstream-name . "sem")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-boot r-mass r-mi))
    (home-page "https://cran.r-project.org/package=sem")
    (synopsis "Structural equation models")
    (description
     "This package provides functions for fitting general linear structural
equation models (with observed and latent variables) using the RAM approach,
and for fitting structural equations in observed-variable models by two-stage
least squares.")
    (license license:gpl2+)))

(define-public r-semtools
  (package
    (name "r-semtools")
    (version "0.5-6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "semTools" version))
       (sha256
        (base32
         "1wnakz76c4mgkwvx3iycmvgrzqys860jg9zpkba0ln5c08ycw8pm"))))
    (properties `((upstream-name . "semTools")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lavaan r-pbivnorm))
    (home-page "https://github.com/simsem/semTools/wiki")
    (synopsis "Useful tools for structural equation modeling")
    (description
     "This package provides useful tools for structural equation modeling.")
    (license license:gpl2+)))

(define-public r-regsem
  (package
    (name "r-regsem")
    (version "1.9.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "regsem" version))
       (sha256
        (base32
         "0vpizmdml55naxmhy9nfcm9ylhy15p9na7l0c6z3rvk29ck3g3sw"))))
    (properties `((upstream-name . "regsem")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lavaan r-rcpp r-rcpparmadillo r-rsolnp))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/package=regsem")
    (synopsis "Regularized structural equation modeling")
    (description
     "This package uses both ridge and lasso penalties (and extensions) to
penalize specific parameters in structural equation models.  The package
offers additional cost functions, cross validation, and other extensions
beyond traditional structural equation models.  It also contains a function to
perform @dfn{exploratory mediation} (XMed).")
    (license license:gpl2+)))

(define-public r-stanheaders
  (package
    (name "r-stanheaders")
    (version "2.21.0-7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "StanHeaders" version))
       (sha256
        (base32
         "0srkyawyiykn3p5lw1z3zf18s4ax4iasv1ci3l1px40f9w36wm17"))))
    (properties `((upstream-name . "StanHeaders")))
    (build-system r-build-system)
    (inputs (list pandoc))
    (propagated-inputs
     (list r-rcppeigen r-rcppparallel))
    (native-inputs
     (list gfortran r-knitr)) ; for vignettes
    (home-page "https://mc-stan.org/")
    (synopsis "C++ header files for Stan")
    (description
     "The C++ header files of the Stan project are provided by this package.
There is a shared object containing part of the @code{CVODES} library, but it
is not accessible from R.  @code{r-stanheaders} is only useful for developers
who want to utilize the @code{LinkingTo} directive of their package's
DESCRIPTION file to build on the Stan library without incurring unnecessary
dependencies.

The Stan project develops a probabilistic programming language that implements
full or approximate Bayesian statistical inference via Markov Chain Monte
Carlo or variational methods and implements (optionally penalized) maximum
likelihood estimation via optimization.  The Stan library includes an advanced
automatic differentiation scheme, templated statistical and linear algebra
functions that can handle the automatically differentiable scalar types (and
doubles, ints, etc.), and a parser for the Stan language.  The @code{r-rstan}
package provides user-facing R functions to parse, compile, test, estimate,
and analyze Stan models.")
    (license license:bsd-3)))

(define-public r-rpf
  (package
    (name "r-rpf")
    (version "1.0.11")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rpf" version))
       (sha256
        (base32
         "1yr1i7kswq57mcxv05lh7bvbicz1djqxcl6f13dlgsf3ww56gzg1"))))
    (properties `((upstream-name . "rpf")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lifecycle r-mvtnorm r-rcpp r-rcppeigen))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/jpritikin/rpf")
    (synopsis "Response probability functions")
    (description
     "The purpose of this package is to factor out logic and math common to
Item Factor Analysis fitting, diagnostics, and analysis.  It is envisioned as
core support code suitable for more specialized IRT packages to build upon.
Complete access to optimized C functions is made available with
@code{R_RegisterCCallable()}.")
    (license license:gpl3+)))

(define-public r-openmx
  (package
    (name "r-openmx")
    (version "2.20.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "OpenMx" version))
       (sha256
        (base32
         "0ki3n2i9b9880mpfxazmd6zrblzl1jngi10qnbxxvxik1x2mq3vy"))))
    (properties `((upstream-name . "OpenMx")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bh
           r-digest
           r-lifecycle
           r-mass
           r-matrix
           r-rcpp
           r-rcppeigen
           r-rcppparallel
           r-rpf
           r-stanheaders))
    (native-inputs (list r-knitr gfortran))
    (home-page "http://openmx.ssri.psu.edu")
    (synopsis "Extended structural equation modelling")
    (description
     "This package allows for the estimation of a wide variety of advanced
multivariate statistical models.  It consists of a library of functions and
optimizers that allow you to quickly and flexibly define an SEM model and
estimate parameters given observed data.")
    (license license:asl2.0)))

(define-public r-kutils
  (package
    (name "r-kutils")
    (version "1.70")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "kutils" version))
       (sha256
        (base32
         "06jk66wbq3jmdf2jdhqns6r3yk36l2x7c907x977zv80sqxa1l37"))))
    (properties `((upstream-name . "kutils")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-foreign r-openxlsx r-plyr r-runit r-xtable))
    (home-page "https://cran.r-project.org/package=kutils")
    (synopsis "Project management tools")
    (description
     "This package provides tools for data importation, recoding, and
inspection.  There are functions to create new project folders, R code
templates, create uniquely named output directories, and to quickly obtain a
visual summary for each variable in a data frame.  The main feature here is
the systematic implementation of the \"variable key\" framework for data
importation and recoding.")
    (license license:gpl2)))

(define-public r-rockchalk
  (package
    (name "r-rockchalk")
    (version "1.8.157")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rockchalk" version))
       (sha256
        (base32
         "13g2rdnxazqfgy653d7vj6w79b2vgnd7bbz0sqn9k4qiig59jh41"))))
    (properties `((upstream-name . "rockchalk")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cardata r-kutils r-lme4 r-mass))
    (home-page "https://cran.r-project.org/package=rockchalk")
    (synopsis "Regression estimation and presentation")
    (description
     "This package provides a collection of functions for interpretation and
presentation of regression analysis.  These functions are used to produce the
statistics lectures in @url{http://pj.freefaculty.org/guides}.  The package
includes regression diagnostics, regression tables, and plots of interactions
and \"moderator\" variables.  The emphasis is on \"mean-centered\" and
\"residual-centered\" predictors.  The vignette @code{rockchalk} offers a
fairly comprehensive overview.")
    (license license:gpl3+)))

(define-public r-lisreltor
  (package
    (name "r-lisreltor")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lisrelToR" version))
       (sha256
        (base32
         "0i51v0x87277ly0kggdd594w6q4zq62b4n7xs9r25j08bzs82nfk"))))
    (properties `((upstream-name . "lisrelToR")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=lisrelToR")
    (synopsis "Import output from LISREL into R")
    (description
     "This is an unofficial package aimed at automating the import of LISREL
output in R.")
    (license license:gpl2)))

(define-public r-bdgraph
  (package
    (name "r-bdgraph")
    (version "2.70")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "BDgraph" version))
       (sha256
        (base32
         "1s148fvvg1c0n4swsvcinlwckj86jys5nvwp4wlyzh3aw9siyqz7"))))
    (properties `((upstream-name . "BDgraph")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-igraph r-proc))
    (native-inputs
     (list r-knitr))
    (home-page "https://www.uva.nl/profile/a.mohammadi")
    (synopsis "Bayesian structure learning in graphical models")
    (description
     "This package provides statistical tools for Bayesian structure learning
in undirected graphical models for continuous, discrete, and mixed data.  It
uses a trans-dimensional @dfn{Markov Chain Monte Carlo} (MCMC) approach based
on a continuous-time birth-death process.")
    (license license:gpl2+)))

(define-public r-bundesligr
  (package
    (name "r-bundesligr")
    (version "0.1.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "bundesligR" version))
              (sha256
               (base32
                "0dnhbh9jh7dfbk7mfh8msq4ys5kakalr0kwkycycrb2q8rd049vp"))))
    (properties `((upstream-name . "bundesligR")))
    (build-system r-build-system)
    (home-page "https://github.com/ottlngr/bundesligR")
    (synopsis "All final tables of the Bundesliga")
    (description
     "This package provides all final tables of Germany's highest football
league, the Bundesliga.  It contains data from 1964 to 2016.")
    (license license:gpl3)))

(define-public r-d3network
  (package
    (name "r-d3network")
    (version "0.5.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "d3Network" version))
       (sha256
        (base32
         "1gh979z9wksyxxxdzlfzibn0ysvf6h1ij7vwpd55fvbwr308syaw"))))
    (properties `((upstream-name . "d3Network")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-plyr r-rjson r-whisker))
    (home-page "http://christophergandrud.github.io/d3Network/")
    (synopsis "Create D3 JavaScript network, tree, dendrogram, and Sankey graphs")
    (description
     "This package is intended to make it easy to create D3 JavaScript
network, tree, dendrogram, and Sankey graphs from R using data frames.")
    (license license:gpl3+)))

(define-public r-qgraph
  (package
    (name "r-qgraph")
    (version "1.9.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "qgraph" version))
       (sha256
        (base32
         "0r225b7rnsv6wz41ij0msmqr1xy0iqxh9dbsvjixbi1hvgv91wds"))))
    (properties `((upstream-name . "qgraph")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-abind
           r-colorspace
           r-corpcor
           r-fdrtool
           r-ggplot2
           r-glasso
           r-gtools
           r-hmisc
           r-igraph
           r-jpeg
           r-lavaan
           r-matrix
           r-pbapply
           r-plyr
           r-png
           r-psych
           r-rcpp
           r-reshape2))
    (home-page "http://sachaepskamp.com/qgraph/")
    (synopsis "Weighted network visualization and analysis")
    (description
     "This package implements tools for weighted network visualization and
analysis, as well as Gaussian graphical model computation.  It contains graph
plotting methods, and tools for psychometric data visualization and graphical
model estimation.  See Epskamp et al. (2012)
@url{doi:10.18637/jss.v048.i04}.")
    (license license:gpl2)))

(define-public r-semplot
  (package
    (name "r-semplot")
    (version "1.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "semPlot" version))
       (sha256
        (base32
         "0s9bp4pfsllg1k4x8a36yw82fw432dyz0xvmvi8dw9l12q3jkx8i"))))
    (properties `((upstream-name . "semPlot")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-colorspace
           r-corpcor
           r-igraph
           r-lavaan
           r-lisreltor
           r-openmx
           r-plyr
           r-qgraph
           r-rockchalk
           r-sem
           r-xml))
    (home-page "https://github.com/SachaEpskamp/semPlot")
    (synopsis "Unified visualizations of structural equation models")
    (description
     "Structural equation modeling (SEM) has a long history of representing
models graphically as path diagrams.  The semPlot package for R fills the gap
between advanced, but time-consuming, graphical software and the limited
graphics produced automatically by SEM software.  In addition, semPlot offers
more functionality than drawing path diagrams: it can act as a common ground
for importing SEM results into R.  Any result usable as input to semPlot can
also be represented in any of the three popular SEM frame-works, as well as
translated to input syntax for the R packages @code{sem} and @code{lavaan}.")
    (license license:gpl2)))

(define-public r-cdm
  (package
    (name "r-cdm")
    (version "8.2-6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "CDM" version))
       (sha256
        (base32
         "1lcq3i5rlyqkc12c26kj0x4fm2gh1jsisp6kbf59y3hjdkiqajhl"))))
    (properties `((upstream-name . "CDM")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mvtnorm r-polycor r-rcpp r-rcpparmadillo))
    (home-page
     "https://github.com/alexanderrobitzsch/CDM")
    (synopsis "Cognitive diagnosis modeling")
    (description
     "This package provides functions for cognitive diagnosis modeling and
multidimensional item response modeling for dichotomous and polytomous item
responses.  It enables the estimation of the DINA and DINO model, the multiple
group (polytomous) GDINA model, the multiple choice DINA model, the general
diagnostic model (GDM), the structured latent class model (SLCA), and
regularized latent class analysis.  See George, Robitzsch, Kiefer, Gross, and
Uenlue (2017) @url{doi:10.18637/jss.v074.i02} for further details on
estimation and the package structure.  For tutorials on how to use the CDM
package see George and Robitzsch (2015, @url{doi:10.20982/tqmp.11.3.p189}) as
well as Ravand and Robitzsch (2015).")
    (license license:gpl2+)))

(define-public r-tam
  (package
    (name "r-tam")
    (version "4.1-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "TAM" version))
       (sha256
        (base32
         "0b81d0g4j94yrfzj019jffxrk1aw24iscddp60kjbkrl5p7qy38g"))))
    (properties `((upstream-name . "TAM")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cdm r-rcpp r-rcpparmadillo))
    (home-page "http://www.edmeasurementsurveys.com/TAM/Tutorials/")
    (synopsis "Test analysis modules")
    (description
     "This package includes tools for marginal maximum likelihood estimation
and joint maximum likelihood estimation for unidimensional and
multidimensional item response models.  The package functionality covers the
Rasch model, 2PL model, 3PL model, generalized partial credit model,
multi-faceted Rasch model, nominal item response model, structured latent
class model, mixture distribution IRT models, and located latent class models.
Latent regression models and plausible value imputation are also supported.")
    (license license:gpl2+)))

(define-public r-erm
  (package
    (name "r-erm")
    (version "1.0-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "eRm" version))
       (sha256
        (base32
         "0smym010kswc5vx90qr3x1vl16xj1x1i54rvrj006dc4agc1vmlk"))))
    (properties `((upstream-name . "eRm")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-colorspace r-lattice r-mass r-matrix r-psych))
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/package=eRm")
    (synopsis "Extended Rasch modeling")
    (description
     "This package provides tools to fit @dfn{Rasch models} (RM), @dfn{linear
logistic test models} (LLTM), @dfn{rating scale model} (RSM), @dfn{linear
rating scale models} (LRSM), @dfn{partial credit models} (PCM), and
@dfn{linear partial credit models} (LPCM).  Missing values are allowed in the
data matrix.  Additional features are the ML estimation of the person
parameters, Andersen's LR-test, item-specific Wald test, Martin-Loef-Test,
nonparametric Monte-Carlo Tests, itemfit and personfit statistics including
infit and outfit measures, ICC and other plots, automated stepwise item
elimination, and a simulation module for various binary data matrices.")
    (license license:gpl3)))

(define-public r-irtoys
  (package
    (name "r-irtoys")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "irtoys" version))
       (sha256
        (base32
         "1qshz6czykgf53mq6xiswzv5xsjwrkrinpfkf1yavql4v08hs82b"))))
    (properties `((upstream-name . "irtoys")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ltm r-sm))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/package=irtoys")
    (synopsis "Collection of functions related to Item Response Theory (IRT)")
    (description
     "This package provides a collection of functions useful in learning and
practicing @dfn{Item Response Theory} (IRT), which can be combined into larger
programs.  It provides basic CTT analysis, a simple common interface to the
estimation of item parameters in IRT models for binary responses with three
different programs (ICL, BILOG-MG, and ltm), ability estimation (MLE, BME,
EAP, WLE, plausible values), item and person fit statistics, scaling
methods (MM, MS, Stocking-Lord, and the complete Hebaera method), and a rich
array of parametric and non-parametric (kernel) plots.  It estimates and plots
Haberman's interaction model when all items are dichotomously scored.")
    (license license:gpl2+)))

(define-public r-iheatmapr
  (package
    (name "r-iheatmapr")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "iheatmapr" version))
       (sha256
        (base32
         "1pwkwh7ljlpr6zyz6j8knpz3iw60xzkw8amc98x4pc2mw148jvzx"))))
    (properties `((upstream-name . "iheatmapr")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-fastcluster
           r-ggdendro
           r-htmlwidgets
           r-jsonlite
           r-knitr
           r-magrittr
           r-rcolorbrewer
           r-scales))
    (native-inputs
     (list r-knitr))
    (home-page "https://docs.ropensci.org/iheatmapr")
    (synopsis "Interactive, Complex Heatmaps")
    (description
     "iheatmapr is an R package for building complex, interactive heatmaps
using modular building blocks.  \"Complex\" heatmaps are heatmaps in which
subplots along the rows or columns of the main heatmap add more information
about each row or column.  For example, a one column additional heatmap may
indicate what group a particular row or column belongs to.  Complex heatmaps
may also include multiple side by side heatmaps which show different types of
data for the same conditions.  Interactivity can improve complex heatmaps by
providing tooltips with information about each cell and enabling zooming into
interesting features. iheatmapr uses the plotly library for interactivity.")
    (license license:expat)))

(define-public r-packrat
  (package
    (name "r-packrat")
    (version "0.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "packrat" version))
       (sha256
        (base32
         "1ni3xn51xifdb2bya5z54jn4nxgss6f23b3hn126j2kaz80h7ns5"))))
    (properties `((upstream-name . "packrat")))
    (build-system r-build-system)
    (home-page "https://github.com/rstudio/packrat/")
    (synopsis "Dependency management R projects")
    (description
     "This package provides a dependency manager for R projects that allows
you to manage the R packages your project depends on in an isolated, portable,
and reproducible way.")
    (license license:gpl2)))

(define-public r-rsconnect
  (package
    (name "r-rsconnect")
    (version "0.8.28")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rsconnect" version))
       (sha256
        (base32
         "1q0njv25xiri4ql9mfrzlwdf3l3xg9xjjj2wva9rbniafx3skf95"))))
    (properties `((upstream-name . "rsconnect")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-curl
           r-digest
           r-jsonlite
           r-openssl
           r-packrat
           r-rstudioapi
           r-yaml))
    (home-page "https://github.com/rstudio/rsconnect")
    (synopsis "Deployment interface for R Markdown documents and Shiny applications")
    (description
     "This package provides a programmatic deployment interface for RPubs,
shinyapps.io, and RStudio Connect.  Supported content types include R Markdown
documents, Shiny applications, Plumber APIs, plots, and static web content.")
    (license license:gpl2)))

;; This package includes minified JavaScript files.  When upgrading please
;; check that there are no new minified JavaScript files.
(define-public r-dygraphs
  (package
    (name "r-dygraphs")
    (version "1.1.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dygraphs" version))
       (sha256
        (base32
         "022j007mzfa9k2n31yg4aizcsf571vv3jip092h23rqj03rk3ly3"))))
    (properties `((upstream-name . "dygraphs")))
    (build-system r-build-system)
    (arguments
     `(#:modules ((guix build utils)
                  (guix build r-build-system)
                  (srfi srfi-1)
                  (ice-9 popen))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst/htmlwidgets/lib/"
               (call-with-values
                   (lambda ()
                     (unzip2
                      `(("dygraphs/dygraph-combined-dev.js"
                         "dygraph-combined.js")
                        (,(assoc-ref inputs "js-jquery")
                         "jquery/jquery.min.js")
                        (,(assoc-ref inputs "js-fquarter")
                         "fquarter/moment-fquarter.min.js"))))
                 (lambda (sources targets)
                   (for-each (lambda (source target)
                               (format #t "Processing ~a --> ~a~%"
                                       source target)
                               (let ((minified (open-pipe* OPEN_READ "uglifyjs" source)))
                                 (call-with-output-file target
                                   (lambda (port)
                                     (dump-port minified port)))))
                             sources targets))))
             #t)))))
    (native-inputs
     `(("uglifyjs" ,node-uglify-js)
       ;; They actually use version 1.11.1, but this more recent version
       ;; should be just fine.
       ("js-jquery"
        ,(origin
           (method url-fetch)
           (uri "https://code.jquery.com/jquery-1.12.4.js")
           (sha256
            (base32
             "0x9mrc1668icvhpwzvgafm8xm11x9lfai9nwr66aw6pjnpwkc3s3"))))
       ("js-fquarter"
        ,(origin
           (method url-fetch)
           (uri (string-append "https://raw.githubusercontent.com/robgallen/"
                               "moment-fquarter/1.0.1/moment-fquarter.js"))
           (sha256
            (base32
             "01mdnsaibm9jy2f1qpbn692hpv309lhj5si9nagib4dawmrkffij"))))))
    (propagated-inputs
     (list r-htmltools r-htmlwidgets r-magrittr r-xts r-zoo))
    (home-page "https://github.com/rstudio/dygraphs")
    (synopsis "Interface to Dygraphs interactive time series charting library")
    (description
     "This package provides an R interface to the dygraphs JavaScript charting
library (a copy of which is included in the package).  It provides rich
facilities for charting time-series data in R, including highly configurable
series- and axis-display and interactive features like zoom/pan and
series/point highlighting.")
    (license license:expat)))

(define-public r-shinystan
  (package
    (name "r-shinystan")
    (version "2.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shinystan" version))
       (sha256
        (base32
         "0afm703zriyqprz1zvypir80lq2ylfff3qvj5i7p9n365mm8b150"))))
    (properties `((upstream-name . "shinystan")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bayesplot
           r-colourpicker
           r-dt
           r-dygraphs
           r-ggplot2
           r-gridextra
           r-gtools
           r-markdown
           r-reshape2
           r-rstan
           r-shiny
           r-shinyjs
           r-shinythemes
           r-threejs
           r-xtable
           r-xts))
    (home-page "https://mc-stan.org/")
    (synopsis "Interactive visual and numerical analysis for Bayesian models")
    (description
     "This package provides a graphical user interface for interactive
@dfn{Markov chain Monte Carlo} (MCMC) diagnostics and plots and tables helpful
for analyzing a posterior sample.  The interface is powered by the Shiny web
application framework and works with the output of MCMC programs written in
any programming language (and has extended functionality for Stan models fit
using the @code{rstan} and @code{rstanarm} packages).")
    (license license:gpl3+)))

(define-public r-rstantools
  (package
    (name "r-rstantools")
    (version "2.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rstantools" version))
       (sha256
        (base32
         "1dsfgi02hps878n3vimfdbzpm4gr5n3ccrmnc61ncrqcp6p0p0fb"))))
    (properties `((upstream-name . "rstantools")))
    (build-system r-build-system)
    (inputs (list pandoc))
    (propagated-inputs
     (list r-desc r-rcpp r-rcppparallel))
    (native-inputs
     (list r-knitr))
    (home-page "https://mc-stan.org/rstantools/")
    (synopsis "Tools for developing R packages interfacing with Stan")
    (description
     "This package provides various tools for developers of R packages
interfacing with @url{https://mc-stan.org, Stan}, including functions to set
up the required package structure, S3 generics and default methods to unify
function naming across Stan-based R packages, and vignettes with
recommendations for developers.")
    (license license:gpl3+)))

(define-public r-loo
  (package
    (name "r-loo")
    (version "2.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "loo" version))
       (sha256
        (base32 "1wa5hxk7lkr88mway6b7xd5arrkkl2ldl9rf0v1nqwp8lia2ysl6"))))
    (properties `((upstream-name . "loo")))
    (build-system r-build-system)
    (inputs
     (list pandoc))
    (propagated-inputs
     (list r-checkmate r-matrixstats))
    (native-inputs
     (list r-knitr))
    (home-page "https://mc-stan.org/loo/")
    (synopsis "Leave-One-Out cross-validation and WAIC for Bayesian models")
    (description
     "This package provides an implementation of efficient approximate
@dfn{leave-one-out} (LOO) cross-validation for Bayesian models fit using
Markov chain Monte Carlo, as described in @url{doi:10.1007/s11222-016-9696-4}.
The approximation uses @dfn{Pareto smoothed importance sampling} (PSIS), a new
procedure for regularizing importance weights.  As a byproduct of the
calculations, we also obtain approximate standard errors for estimated
predictive errors and for the comparison of predictive errors between models.
The package also provides methods for using stacking and other model weighting
techniques to average Bayesian predictive distributions.")
    (license license:gpl3+)))

(define-public r-rstan
  (package
    (name "r-rstan")
    (version "2.21.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rstan" version))
       (sha256
        (base32
         "0ibd3pj2pvd7658sdg95fa2yhfmxz9gy0cjwcrdr546k209j55a4"))))
    (properties `((upstream-name . "rstan")))
    (build-system r-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'install 'set-timezone
           ;; This package is picky about timezones.
           (lambda* (#:key inputs #:allow-other-keys)
             (setenv "TZ" "UTC+1")
             (setenv "TZDIR"
                     (search-input-directory inputs
                                             "share/zoneinfo")))))))
    (native-inputs
     (list tzdata-for-tests pandoc r-knitr))
    (propagated-inputs
     (list r-bh
           r-ggplot2
           r-gridextra
           r-inline
           r-loo
           r-pkgbuild
           r-rcpp
           r-rcppeigen
           r-rcppparallel
           r-stanheaders))
    (home-page "https://discourse.mc-stan.org/")
    (synopsis "R interface to Stan")
    (description
     "User-facing R functions are provided to parse, compile, test, estimate,
and analyze Stan models by accessing the header-only Stan library provided by
the StanHeaders package.  The Stan project develops a probabilistic
programming language that implements full Bayesian statistical inference via
Markov Chain Monte Carlo, rough Bayesian inference via 'variational'
approximation, and (optionally penalized) maximum likelihood estimation via
optimization.  In all three cases, automatic differentiation is used to
quickly and accurately evaluate gradients without burdening the user with the
need to derive the partial derivatives.")
    (license license:gpl3+)))

(define-public r-rstanarm
  (package
    (name "r-rstanarm")
    (version "2.21.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rstanarm" version))
       (sha256
        (base32
         "19rj396q84maxnd9d2xcd5rblg3310xn7sqbd6k18kwf3dvd7wp9"))))
    (properties `((upstream-name . "rstanarm")))
    (build-system r-build-system)
    (inputs
     (list pandoc))
    (propagated-inputs
     (list r-bayesplot
           r-bh
           r-ggplot2
           r-lme4
           r-loo
           r-matrix
           r-nlme
           r-rcpp
           r-rcppeigen
           r-rcppparallel
           r-rstan
           r-rstantools
           r-shinystan
           r-stanheaders
           r-survival))
    (native-inputs
     (list r-knitr))
    (home-page "https://mc-stan.org/rstanarm/")
    (synopsis "Bayesian applied regression modeling via Stan")
    (description
     "This package estimates previously compiled regression models using the
@code{rstan} package, which provides the R interface to the Stan C++ library
for Bayesian estimation.  Users specify models via the customary R syntax with
a formula and @code{data.frame} plus some additional arguments for priors.")
    (license license:gpl3+)))

(define-public r-kendall
  (package
    (name "r-kendall")
    (version "2.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Kendall" version))
       (sha256
        (base32
         "1xmk95l4i3kj9jn0xh1chi2rj322k29jq14ra5pa7316gwf9vx2m"))))
    (properties `((upstream-name . "Kendall")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-boot))
    (native-inputs
     (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/Kendall/")
    (synopsis "Kendall rank correlation and Mann-Kendall trend test")
    (description
     "This package computes the Kendall rank correlation and Mann-Kendall
trend test.")
    (license license:gpl2+)))

(define-public r-keyring
  (package
    (name "r-keyring")
    (version "1.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "keyring" version))
       (sha256
        (base32
         "113rjhihqfhxdihnf6nwqbsknlnm8pqyhvnyxx624gyajl9mn3a7"))))
    (properties `((upstream-name . "keyring")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-askpass
           r-assertthat
           r-filelock
           r-openssl
           r-r6
           r-rappdirs
           r-sodium
           r-yaml))
    (native-inputs (list pkg-config))
    (home-page "https://github.com/r-lib/keyring")
    (synopsis "Access the system credential store from R")
    (description
     "This package provides a platform-independent API to access the operating
system's credential store.  It currently supports Keychain on macOS,
Credential Store on Windows, the Secret Service API on GNU/Linux, and a
simple, platform independent store implemented with environment variables.
Additional storage back-ends can be added easily.")
    (license license:expat)))

(define-public r-zyp
  (package
    (name "r-zyp")
    (version "0.10-1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "zyp" version))
       (sha256
        (base32
         "03cxpkfbhrx1fy8l0dl9a13ghz93cqq6877wa8rig09ksdiivaw9"))))
    (properties `((upstream-name . "zyp")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-kendall))
    (home-page "https://cran.r-project.org/web/packages/zyp/")
    (synopsis "Zhang + Yue-Pilon Trends Package")
    (description
     "This package contains an efficient implementation of Sen's slope
method (Sen, 1968) plus implementation of Xuebin Zhang's (Zhang, 1999) and
Yue-Pilon's (Yue, 2002) pre-whitening approaches to determining trends in
climate data.")
    (license license:lgpl2.1)))

(define-public r-rlecuyer
  (package
    (name "r-rlecuyer")
    (version "0.3-5")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "rlecuyer" version))
              (sha256
               (base32
                "09mniai7v8gapr6hd3zm8sm3vi1zcyhgym389904ykb2yx7l68s7"))))
    (properties `((upstream-name . "rlecuyer")))
    (build-system r-build-system)
    (home-page
     "https://www.iro.umontreal.ca/~lecuyer/myftp/papers/streams00.pdf")
    (synopsis "R interface to RNG with multiple streams")
    (description
     "This package provides an interface to the C implementation of the random
number generator with multiple independent streams developed by L'Ecuyer et
al (2002).  The main purpose of this package is to enable the use of this
random number generator in parallel R applications.")
    (license license:gpl2+)))

(define-public r-rlinsolve
  (package
    (name "r-rlinsolve")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Rlinsolve" version))
       (sha256
        (base32
         "1xv500n1480qyakw0isanw1s5ywykhc207hqja4804s5s2m8zfjw"))))
    (properties `((upstream-name . "Rlinsolve")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-matrix r-rcpp r-rcpparmadillo r-rdpack))
    (home-page "https://cran.r-project.org/web/packages/Rlinsolve/")
    (synopsis "Iterative solvers for (sparse) linear system of equations")
    (description
     "Solving a system of linear equations is one of the most fundamental
computational problems for many fields of mathematical studies, such as
regression problems from statistics or numerical partial differential
equations.  This package provides basic stationary iterative solvers such as
Jacobi, Gauss-Seidel, Successive Over-Relaxation and SSOR methods.
Nonstationary, also known as Krylov subspace methods are also provided.
Sparse matrix computation is also supported in that solving large and sparse
linear systems can be manageable using the @code{Matrix} package along with
@code{RcppArmadillo}.")
    (license license:gpl3+)))

(define-public r-zvcv
  (package
    (name "r-zvcv")
    (version "2.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ZVCV" version))
       (sha256
        (base32
         "0gc76j9i8fkm2v638nyzzb1qxl4zmapbspkkaffb8gi5qyjja448"))))
    (properties `((upstream-name . "ZVCV")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-abind
           r-bh
           r-dplyr
           r-glmnet
           r-magrittr
           r-mvtnorm
           r-rcpp
           r-rcpparmadillo
           r-rlinsolve))
    (home-page "https://cran.r-project.org/web/packages/ZVCV/")
    (synopsis "Zero-Variance Control Variates")
    (description
     "@dfn{Zero-variance control variates} (ZV-CV) is a post-processing method
to reduce the variance of Monte Carlo estimators of expectations using the
derivatives of the log target.  Once the derivatives are available, the only
additional computational effort is in solving a linear regression problem.
This method has been extended to higher dimensions using regularisation.  This
package can be used to easily perform ZV-CV or regularised ZV-CV when a set of
samples, derivatives and function evaluations are available.  Additional
functions for applying ZV-CV to two estimators for the normalising constant of
the posterior distribution in Bayesian statistics are also supplied.")
    (license license:gpl2+)))

(define-public r-ztype
  (package
    (name "r-ztype")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ztype" version))
       (sha256
        (base32
         "0brbq2rgkl4mhjbb70kkfv47lzs66k9ppfs2klavcbripirxn5fx"))))
    (properties `((upstream-name . "ztype")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertthat
           r-dplyr
           r-ggplot2
           r-lubridate
           r-magrittr
           r-rvest
           r-stringr))
    (home-page "https://cran.r-project.org/web/packages/ztype/")
    (synopsis "Run a Ztype game loaded with R functions")
    (description
     "How fast can you type R functions on your keyboard?  Find out by running
a @code{zty.pe} game: export R functions as instructions to type to destroy
opponents' vessels.")
    (license license:gpl3)))

(define-public r-zseq
  (package
    (name "r-zseq")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Zseq" version))
       (sha256
        (base32
         "0xp7qi5kjg8xmci9wrfvmygjmz8gbhq60fl9bvk8rnka6s4ppkrc"))))
    (properties `((upstream-name . "Zseq")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-gmp))
    (home-page "https://cran.r-project.org/web/packages/Zseq/")
    (synopsis "Integer sequence generator")
    (description
     "This package generates well-known integer sequences.  The @code{gmp}
package is adopted for computing with arbitrarily large numbers.  Every
function has a hyperlink to its corresponding item in the @dfn{On-Line
Encyclopedia of Integer Sequences} (OEIS) in the function help page.")
    (license license:gpl3+)))

(define-public r-isoband
  (package
    (name "r-isoband")
    (version "0.2.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "isoband" version))
       (sha256
        (base32
         "18s3mdzl9y8v5fpvdy6iyqp3j57kw8bwhgan94373xjkaya61r17"))))
    (properties `((upstream-name . "isoband")))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/wilkelab/isoband")
    (synopsis "Generate isolines and isobands from regularly spaced elevation grids")
    (description
     "This package provides a fast C++ implementation to generate contour
lines (isolines) and contour polygons (isobands) from regularly spaced grids
containing elevation data.")
    (license license:expat)))

(define-public r-ppcor
  (package
    (name "r-ppcor")
    (version "1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ppcor" version))
       (sha256
        (base32
         "1x9b2kb8s0bp92b17gby0jwzzr3i4cf3ap9c4nq7m8fav72g0y3a"))))
    (properties `((upstream-name . "ppcor")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mass))
    (home-page "https://cran.r-project.org/web/packages/ppcor/")
    (synopsis "Partial and semi-partial correlation")
    (description
     "This package provides users not only with a function to readily
calculate the higher-order partial and semi-partial correlations but also with
statistics and p-values of the correlation coefficients.")
    (license license:gpl2)))

(define-public r-hrbrthemes
  (package
    (name "r-hrbrthemes")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "hrbrthemes" version))
       (sha256
        (base32 "057h60b5p53dcyjyfwlgjc1ry968s9s64dw78p443w8717zk7zpc"))))
    (properties `((upstream-name . "hrbrthemes")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-extrafont
           r-gdtools
           r-ggplot2
           r-htmltools
           r-knitr
           r-magrittr
           r-rmarkdown
           r-scales))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/hrbrmstr/hrbrthemes/")
    (synopsis "Additional themes, theme components and utilities for @code{ggplot2}")
    (description
     "This package provides a compilation of extra @code{ggplot2} themes,
scales and utilities, including a spell check function for plot label fields
and an overall emphasis on typography.")
    (license license:expat)))

(define-public r-crochet
  (package
    (name "r-crochet")
    (version "2.3.0")
    (source
     (origin
      (method url-fetch)
      (uri (cran-uri "crochet" version))
      (sha256
       (base32
        "0zvjaf6cv0nrjb4l4llkr0mmgha7ig31p4ri2rlnqyjlxi5l8hyq"))))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/agrueneberg/crochet")
    (synopsis "Implementation Helper for Matrix-Like Types")
    (description
     "Functions to help implement the extraction / subsetting / indexing
function @code{[} and replacement function @code{[<-} of custom matrix-like
types (based on S3, S4, etc.), modeled as closely to the base matrix class
as possible (with tests to prove it).")
    (license license:expat)))

(define-public r-boa
  (package
    (name "r-boa")
    (version "1.1.8-2")
    (source
     (origin
      (method url-fetch)
      (uri (cran-uri "boa" version))
      (sha256
       (base32
        "04lhqk5qfvaz1jk90glr2yi5vq7cdy0w8m6g2lnzk359l9y41zhp"))))
    (properties `((upstream-name . "boa")))
    (build-system r-build-system)
    (home-page "https://www.jstatsoft.org/v21/i11")
    (synopsis "Library for @dfn{Bayesian Output Analysis Program} (BOA) for MCMC")
    (description
     "This package provides a menu-driven program and library of functions for
carrying out convergence diagnostics and statistical and graphical analysis of
@dfn{Markov chain Monte Carlo} (MCMC) sampling output.")
    (license license:gpl2+)))

(define-public r-httpcode
  (package
    (name "r-httpcode")
    (version "0.3.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "httpcode" version))
              (sha256
               (base32
                "0xig0rvc81hg7mw0iq9s0an1nw24fg0kfs2p2n6dzhwl9w506fjr"))))
    (build-system r-build-system)
    (home-page "https://github.com/sckott/httpcode")
    (synopsis "HTTP status code helper")
    (description "@code{httpcode} provides functionality for finding and
explaining the meaning of @code{HTTP} status codes.  Functions are included for
searching for codes by full or partial number, by message, and to get
appropriate dog and cat images for many status codes.")
    (license license:expat)))

(define-public r-latex2exp
  (package
    (name "r-latex2exp")
    (version "0.9.5")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "latex2exp" version))
              (sha256
               (base32
                "153br3xflvnnxqhkhm1wgwb2664bw08alhslgdcgjdk73clafhla"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-stringr r-magrittr))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/stefano-meschiari/latex2exp/")
    (synopsis "Use LaTeX expressions in plots")
    (description "@code{latex2exp} parses and converts LaTeX math formulas to
R's plotmath expressions, used to enter mathematical formulas and symbols to be
rendered as text, axis labels, etc. throughout R's plotting system.")
    (license license:expat)))

(define-public r-oai
  (package
    (name "r-oai")
    (version "0.3.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "oai" version))
              (sha256
               (base32
                "1zcbcxhw692s0y6izvwazyzhgx0iwsxsbcan2nk0mb7n11p7bypb"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-xml2 r-httr r-plyr r-stringr r-tibble))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/ropensci/oai/")
    (synopsis "General purpose OAI-PMH services client")
    (description "@code{oai} provides a general purpose client to work with
any @dfn{Open Archives Initiative Protocol for 'Metadata' Harvesting} (OAI-PMH)
service.  Functions are provided to work with the OAI-PMH verbs:
@code{GetRecord}, @code{Identify}, @code{ListIdentifiers},
@code{ListMetadataFormats}, @code{ListRecords}, and @code{ListSets}.")
    (license license:expat)))

(define-public r-argon2
  (package
    (name "r-argon2")
    (version "0.4-0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "argon2" version))
       (sha256
        (base32
         "09hzl0wz0lw2v7g64rdv0lij2hq36zl37a6rmxwvinmjdzijcsyw"))))
    (properties `((upstream-name . "argon2")))
    (build-system r-build-system)
    (home-page "https://github.com/wrathematics/argon2")
    (synopsis "Secure password hashing based on the argon2 algorithm")
    (description
     "This package provides utilities for secure password hashing via the
argon2 algorithm.")
    (license license:bsd-2)))

(define-public r-getpass
  (package
    (name "r-getpass")
    (version "0.2-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "getPass" version))
       (sha256
        (base32
         "03ydafhh0sk3rcnpr3paajyji64x2ddp6p814p9mvbmyrblcgzcc"))))
    (properties `((upstream-name . "getPass")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rstudioapi))
    (home-page "https://github.com/wrathematics/getPass")
    (synopsis "Masked user input")
    (description
     "This package provides a micro-package for reading \"passwords\", i.e.
reading user input with masking, so that the input is not displayed as it is
typed.  Currently, RStudio, the command line (every OS), and any platform
where tcltk is present are supported.")
    (license license:bsd-2)))

(define-public r-remoter
  (package
    (name "r-remoter")
    (version "0.4-0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "remoter" version))
       (sha256
        (base32
         "1a7m63l8phv5jnazvdqdrqkaqjwqzaac5y4jm2jn0ypy4n8jvkfl"))))
    (properties `((upstream-name . "remoter")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-argon2 r-getpass r-pbdzmq r-png))
    (home-page "https://github.com/RBigData/remoter")
    (synopsis "Control a remote R session from a local one")
    (description
     "This package provides a set of utilities for client/server computing
with R, controlling a remote R session (the server) from a local one (the
client).")
    (license license:bsd-2)))

(define-public r-asd
  (package
    (name "r-asd")
    (version "2.2")
    (source
      (origin
        (method url-fetch)
        (uri (cran-uri "asd" version))
        (sha256
          (base32
            "0p3r4qjam3sl3rpcilb0pgx4xx3ly71xqnvkv31vzjs885lgxz4l"))))
    (properties `((upstream-name . "asd")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mvtnorm))
    (home-page "https://cran.r-project.org/web/packages/asd")
    (synopsis "Simulations for Adaptive Seamless Designs")
    (description
     "This package provdes means to run simulations for adaptive seamless
designs with and without early outcomes for treatment selection and
subpopulation type designs.")
    (license license:gpl3)))

(define-public r-nbconvertr
  (package
    (name "r-nbconvertr")
    (version "1.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "nbconvertR" version))
       (sha256
        (base32
         "0yhmz177r1miain65vspclahhz8cg7638ldbpsw8ylgf7a60l0sg"))))
    (properties `((upstream-name . "nbconvertR")))
    (build-system r-build-system)
    (inputs
     (list python-nbconvert pandoc))
    (home-page "https://cran.r-project.org/web/packages/nbconvertR/")
    (synopsis "Vignette engine wrapping Jupyter notebooks")
    (description
     "This package calls the Jupyter script @code{nbconvert} to create
vignettes from notebooks.  Those notebooks (@code{.ipynb} files) are files
containing rich text, code, and its output.  Code cells can be edited and
evaluated interactively.")
    (license license:gpl3)))

(define-public r-bridgesampling
  (package
    (name "r-bridgesampling")
    (version "1.1-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bridgesampling" version))
       (sha256
        (base32
         "0sry1xwiv4y52k44hq6z8y2kysp5kxgl4dix3m94svg3ladd7v2l"))))
    (properties
     `((upstream-name . "bridgesampling")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-brobdingnag
           r-coda
           r-matrix
           r-mvtnorm
           r-scales
           r-stringr))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/quentingronau/bridgesampling")
    (synopsis "Bridge sampling for marginal likelihoods and Bayes factors")
    (description
     "This package provides functions for estimating marginal likelihoods,
Bayes factors, posterior model probabilities, and normalizing constants in
general, via different versions of bridge sampling.")
    (license license:gpl2+)))

(define-public r-tea
  (package
    (name "r-tea")
    (version "1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tea" version))
       (sha256
        (base32
         "0ql7lrxk0ihm49kqsvz79ig8i54rwiy9nxav4v9hy72j9kj5bgjn"))))
    (properties
     `((upstream-name . "tea")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-matrix))
    (home-page "https://cran.r-project.org/web/packages/tea/")
    (synopsis "Threshold estimation approaches")
    (description
     "This package provides different approaches for selecting the threshold
in generalized Pareto distributions.  Most of them are based on minimizing the
AMSE-criterion or at least by reducing the bias of the assumed GPD-model.
Others are heuristically motivated by searching for stable sample paths, i.e.
a nearly constant region of the tail index estimator with respect to k, which
is the number of data in the tail.  The third class is motivated by graphical
inspection.  In addition, a sequential testing procedure for GPD-GoF-tests
is also implemented here.")
    (license license:gpl3)))

(define-public r-awsmethods
  (package
    (name "r-awsmethods")
    (version "1.1-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "awsMethods" version))
       (sha256
        (base32
         "0hbmrcpdyg15zg4rysscsmxpxlpy0dkxx2aa63qibq7l1k14v4sh"))))
    (properties
     `((upstream-name . "awsMethods")))
    (build-system r-build-system)
    (home-page "http://www.wias-berlin.de/software/imaging/")
    (synopsis "Class and methods definitions")
    (description
     "This package defines the generic method @code{extract} and provides
@code{openMP} support as needed in several packages like
@code{aws}, @code{adimpro}, @code{fmri}, and @code{dwi}.")
    (license license:gpl2+)))

(define-public r-aws
  (package
    (name "r-aws")
    (version "2.5-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "aws" version))
       (sha256
        (base32
         "1fhm87iax6bkvd4vszvjbcqw3b2drs11rjxr7zf2w4sgc72svaz8"))))
    (properties
     `((upstream-name . "aws")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-awsmethods r-gsl))
    (native-inputs
     (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/aws/")
    (synopsis "Adaptive weights smoothing")
    (description
     "This package provides a collection of R-functions implementing adaptive
smoothing procedures in 1D, 2D and 3D.  This includes the
Propagation-Separation approach to adaptive smoothing, the @dfn{Intersecting
Confidence Intervals} (ICI), variational approaches, and a non-local means
filter.")
    (license license:gpl2+)))

(define-public r-sgloptim
  (package
    (name "r-sgloptim")
    (version "1.3.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sglOptim" version))
       (sha256
        (base32
         "15bkkvgp9v9vsp65wps48g3c2fa0fj1025hbrziywq14j7wayyjr"))))
    (properties
     `((upstream-name . "sglOptim")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bh
           r-doparallel
           r-foreach
           r-matrix
           r-rcpp
           r-rcpparmadillo
           r-rcppprogress))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/nielsrhansen/sglOptim")
    (synopsis "Generic sparse group Lasso solver")
    (description
     "This package provides a fast generic solver for sparse group lasso
optimization problems.  The loss (objective) function must be defined in a C++
module.  The optimization problem is solved using a coordinate gradient
descent algorithm.  Convergence of the algorithm is established and the
algorithm is applicable to a broad class of loss functions.  Use of parallel
computing for cross validation and subsampling is supported through the
@code{foreach} and @code{doParallel} packages.")
    (license license:gpl2+)))

(define-public r-grouped
  (package
    (name "r-grouped")
    (version "0.6-0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "grouped" version))
       (sha256
        (base32
         "1glxgacpwk7yjbkwg5ci6bmb2il6hf5zhydwi5bbq6hc032m9976"))))
    (properties
     `((upstream-name . "grouped")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mass))
    (home-page "https://cran.r-project.org/web/packages/grouped/")
    (synopsis "Regression analysis of grouped and coarse data")
    (description
     "This package provides regression models for grouped and coarse data,
under the coarsened at random assumption.")
    (license license:gpl2+)))

(define-public r-stam
  (package
    (name "r-stam")
    (version "0.0-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "stam" version))
       (sha256
        (base32
         "1x1j45fir64kffny0nssb2hwn4rcp8gd2cjv6fw4yy0l4d0xi5iv"))))
    (properties
     `((upstream-name . "stam")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-np r-sp))
    (home-page "https://cran.r-project.org/web/packages/stam")
    (synopsis "Spatio-temporal analysis and modelling")
    (description
     "This package provides various methods to conduct Spatio-Temporal
Analysis and Modelling, including Exploratory Spatio-Temporal Analysis and
Inferred Spatio-Temporal Modelling.")
    (license license:gpl2+)))

(define-public r-dcv
  (package
    (name "r-dcv")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dcv" version))
       (sha256
        (base32
         "12c716x8dnxnqksibpmyysqp2axggvy9dpd55s9bhnsvqvi6dshj"))))
    (properties
     `((upstream-name . "dcv")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lmtest))
    (home-page "https://cran.r-project.org/web/packages/dcv/")
    (synopsis "Conventional cross-validation statistics for climate-growth model")
    (description
     "This package performs several conventional cross-validation statistical
methods for climate-growth model in the climate reconstruction from tree
rings, including Sign Test statistic, Reduction of Error statistic, Product
Mean Test, Durbin-Watson statistic etc.")
    (license license:gpl2)))

(define-public r-rcdd
  (package
    (name "r-rcdd")
    (version "1.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rcdd" version))
       (sha256
        (base32
         "0zxx0qvv26ba30jkm8mvca4h59rqklay4jwazpcw7h9dzp4189jr"))))
    (properties
     `((upstream-name