// SPDX-FileCopyrightText: 2010 Paul E. McKenney, IBM Corporation.
// SPDX-FileCopyrightText: 2009-2015 Mathieu Desnoyers <mathieu.desnoyers@efficios.com>
//
// SPDX-License-Identifier: LGPL-2.1-or-later

#ifndef _URCU_ARCH_TILE_H
#define _URCU_ARCH_TILE_H

/*
 * arch/tile.h: definitions for tile architecture
 */

#include <urcu/compiler.h>
#include <urcu/config.h>
#include <urcu/syscall-compat.h>

#ifdef __cplusplus
extern "C" {
#endif

#include <stdlib.h>
#include <sys/time.h>

/*
 * On Linux, define the membarrier system call number if not yet available in
 * the system headers. tile implements asm-generic/unistd.h system call
 * numbers.
 */
#if (defined(__linux__) && !defined(__NR_membarrier))
#define __NR_membarrier		283
#endif

#ifdef __cplusplus
}
#endif

#include <urcu/arch/generic.h>

#endif /* _URCU_ARCH_TILE_H */
