/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2015-2024 Advanced Micro Devices, Inc. All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include <onnx_test.hpp>

TEST_CASE(hardmax_axis_ver11_test)
{
    migraphx::program p;
    auto* mm = p.get_main_module();
    std::vector<std::size_t> input_lens{1, 2, 3, 4};
    auto input_type = migraphx::shape::double_type;
    migraphx::shape data_shape{input_type, input_lens};
    auto input = mm->add_parameter("x", data_shape);

    input          = mm->add_instruction(migraphx::make_op("reshape", {{"dims", {2, 12}}}), input);
    auto indices   = mm->add_instruction(migraphx::make_op("argmax", {{"axis", 1}}), input);
    auto zero_data = mm->add_instruction(
        migraphx::make_op("multibroadcast", {{"out_lens", input->get_shape().lens()}}),
        mm->add_literal(migraphx::literal{migraphx::shape{input_type}, {0}}));
    auto updates = mm->add_instruction(
        migraphx::make_op("multibroadcast", {{"out_lens", indices->get_shape().lens()}}),
        mm->add_literal(migraphx::literal{migraphx::shape{input_type}, {1}}));
    auto output = mm->add_instruction(
        migraphx::make_op("scatter_none", {{"axis", 1}}), zero_data, indices, updates);
    mm->add_instruction(migraphx::make_op("reshape", {{"dims", input_lens}}), output);

    auto prog = optimize_onnx("hardmax_axis_ver11_test.onnx");
    EXPECT(p == prog);
}
