/* $Cambridge: hermes/src/prayer/cmd/cmd_unsubscribe.c,v 1.3 2008/09/16 09:59:55 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#include "prayer_session.h"

void cmd_unsubscribe(struct session *session)
{
    struct request *request = session->request;
    struct options *options = session->options;
    struct favourite_list *fl = options->favourite_list;
    char *name;

    if (request->argc == 2) {
        name =
            string_canon_decode(pool_strdup
                                (request->pool, request->argv[1]));
        if (string_filename_valid(name)) {
            if (favourite_delete(fl, name)) {
                options->save = T;
                session_message(session, "Removed %s from favourites list",
                                utf8_from_imaputf7(request->pool, name));
            } else
                session_message(session,
                                "Folder %s not on favourites list",
                                utf8_from_imaputf7(request->pool, name));
        } else
            session_message(session,
                            "String contained illegal characters");
    }

    session_redirect(session, request, "favourites");
}
