#!/bin/sh
# Script to generate a local test repository for pristine-lfs testing
# This replaces the need to clone from salsa.debian.org

set -e
export TZ=UTC

mkdir -p "$1"
cd "$1"

git init
git config user.name "Test User"
git config user.email "test@example.com"
git config commit.gpgsign false

git checkout -b pristine-lfs

git lfs install
cat > .gitattributes <<EOF
*.tar.* filter=lfs diff=lfs merge=lfs -text
*.tar.*.asc -filter -diff merge=binary -text
*.dsc -filter !diff merge=binary !text
EOF

git add .gitattributes
git commit -m "Initialise git attributes"

CARGO_VER=0.47.0
DASH_VER=0.5.10.2
MTIME='2020-01-01 00:00:00Z'

# Create fake tarballs

mkdir -p dash-$DASH_VER
echo "dash test content for version $DASH_VER" > dash-$DASH_VER/README
GZIP=-9 tar --mtime="$MTIME" --sort=name --owner=0 --group=0 --numeric-owner -zcf dash_$DASH_VER.orig.tar.gz dash-$DASH_VER/
rm -rf dash-$DASH_VER

mkdir -p cargo-$CARGO_VER
echo "cargo test content for version $CARGO_VER" > cargo-$CARGO_VER/README
GZIP=-9 tar --mtime="$MTIME" --sort=name --owner=0 --group=0 --numeric-owner -zcf cargo_$CARGO_VER.orig.tar.gz cargo-$CARGO_VER/
rm -rf cargo-$CARGO_VER

mkdir -p cargo-$CARGO_VER-vendor
echo "cargo vendor test content for version $CARGO_VER" > cargo-$CARGO_VER-vendor/README
GZIP=-9 tar --mtime="$MTIME" --sort=name --owner=0 --group=0 --numeric-owner -zcf cargo_$CARGO_VER.orig-vendor.tar.gz cargo-$CARGO_VER-vendor/
rm -rf cargo-$CARGO_VER-vendor

mkdir -p dash-debian
echo "dash debian content for version $DASH_VER-5" > dash-debian/README
GZIP=-9 tar --mtime="$MTIME" --sort=name --owner=0 --group=0 --numeric-owner -zcf dash_$DASH_VER-5.debian.tar.gz dash-debian/
rm -rf dash-debian

mkdir -p cargo-debian
echo "cargo debian content for version $CARGO_VER-3" > cargo-debian/README
GZIP=-9 tar --mtime="$MTIME" --sort=name --owner=0 --group=0 --numeric-owner -zcf cargo_$CARGO_VER-3.debian.tar.gz cargo-debian/
rm -rf cargo-debian

# Generate .dsc files with correct checksums and sizes
cat > dash_$DASH_VER-5.dsc <<EOF
Format: 3.0 (quilt)
Source: dash
Binary: dash
Architecture: any
Version: $DASH_VER-5
Maintainer: Test User <test@example.org>
Standards-Version: 4.5.0
Files:
 $(md5sum dash_*.orig.tar.gz | cut -d' ' -f1) $(stat -c%s dash_*.orig.tar.gz) $(echo dash_*.orig.tar.gz)
 $(md5sum dash_*.debian.tar.gz | cut -d' ' -f1) $(stat -c%s dash_*.debian.tar.gz) $(echo dash_*.debian.tar.gz)
EOF

cat > cargo_$CARGO_VER-3.dsc <<EOF
Format: 3.0 (quilt)
Source: cargo
Binary: cargo
Architecture: any
Version: $CARGO_VER-3
Maintainer: Test User <test@example.org>
Standards-Version: 4.5.0
Files:
 $(md5sum cargo_*.orig.tar.gz | cut -d' ' -f1) $(stat -c%s cargo_*.orig.tar.gz) $(echo cargo_*.orig.tar.gz)
 $(md5sum cargo_*.orig-vendor.tar.gz | cut -d' ' -f1) $(stat -c%s cargo_*.orig-vendor.tar.gz) $(echo cargo_*.orig-vendor.tar.gz)
 $(md5sum cargo_*.debian.tar.gz | cut -d' ' -f1) $(stat -c%s cargo_*.debian.tar.gz) $(echo cargo_*.debian.tar.gz)
EOF

git add *.orig*.tar.gz
git commit -m "Add original tarballs"

git checkout -b pristine-lfs-source

cat > .gitattributes <<EOF
*.tar.* filter=lfs diff=lfs merge=lfs -text
*.tar.*.asc -filter -diff merge=binary -text
*.dsc -filter !diff merge=binary !text
EOF

git add .gitattributes *.debian.tar.gz *.dsc
git commit -m "Add debian files and dsc"
