/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import weka.core.FastVector;
import weka.experiment.Experiment;
import weka.experiment.PropertyNode;
import weka.gui.GenericArrayEditor;
import weka.gui.PropertySelectorDialog;
import weka.gui.experiment.Messages;

public class GeneratorPropertyIteratorPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -6026938995241632139L;
    protected JButton m_ConfigureBut;
    protected JComboBox m_StatusBox;
    protected GenericArrayEditor m_ArrayEditor;
    protected Experiment m_Exp;
    protected FastVector m_Listeners;

    public GeneratorPropertyIteratorPanel() {
        Messages.getInstance();
        this.m_ConfigureBut = new JButton(Messages.getString("GeneratorPropertyIteratorPanel_ConfigureBut_JButton_Text"));
        this.m_StatusBox = new JComboBox();
        this.m_ArrayEditor = new GenericArrayEditor();
        this.m_Listeners = new FastVector();
        String[] stringArray = new String[2];
        Messages.getInstance();
        stringArray[0] = Messages.getString("GeneratorPropertyIteratorPanel_Options_Disabled_Text");
        Messages.getInstance();
        stringArray[1] = Messages.getString("GeneratorPropertyIteratorPanel_Options_Enabled_Text");
        String[] options = stringArray;
        DefaultComboBoxModel<String> cbm = new DefaultComboBoxModel<String>(options);
        this.m_StatusBox.setModel(cbm);
        this.m_StatusBox.setSelectedIndex(0);
        this.m_StatusBox.addActionListener(this);
        this.m_StatusBox.setEnabled(false);
        this.m_ConfigureBut.setEnabled(false);
        this.m_ConfigureBut.addActionListener(this);
        JPanel buttons = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        buttons.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        buttons.setLayout(gb);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.fill = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(0, 2, 0, 2);
        buttons.add((Component)this.m_StatusBox, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        buttons.add((Component)this.m_ConfigureBut, constraints);
        buttons.setMaximumSize(new Dimension(buttons.getMaximumSize().width, buttons.getMinimumSize().height));
        this.setBorder(BorderFactory.createTitledBorder("Generator properties"));
        this.setLayout(new BorderLayout());
        this.add((Component)buttons, "North");
        this.m_ArrayEditor.setBorder(BorderFactory.createEtchedBorder());
        this.m_ArrayEditor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                Messages.getInstance();
                System.err.println(Messages.getString("GeneratorPropertyIteratorPanel_PropertyChange_Error_Text"));
                GeneratorPropertyIteratorPanel.this.m_Exp.setPropertyArray(GeneratorPropertyIteratorPanel.this.m_ArrayEditor.getValue());
            }
        });
        this.add((Component)this.m_ArrayEditor, "Center");
    }

    public GeneratorPropertyIteratorPanel(Experiment exp) {
        this();
        this.setExperiment(exp);
    }

    public boolean getEditorActive() {
        return this.m_StatusBox.getSelectedIndex() != 0;
    }

    public void setExperiment(Experiment exp) {
        this.m_Exp = exp;
        this.m_StatusBox.setEnabled(true);
        this.m_ArrayEditor.setValue(this.m_Exp.getPropertyArray());
        if (this.m_Exp.getPropertyArray() == null) {
            this.m_StatusBox.setSelectedIndex(0);
            this.m_ConfigureBut.setEnabled(false);
        } else {
            this.m_StatusBox.setSelectedIndex(this.m_Exp.getUsePropertyIterator() ? 1 : 0);
            this.m_ConfigureBut.setEnabled(this.m_Exp.getUsePropertyIterator());
        }
        this.validate();
    }

    protected int selectProperty() {
        PropertySelectorDialog jd = new PropertySelectorDialog(null, this.m_Exp.getResultProducer());
        jd.setLocationRelativeTo(this);
        int result = jd.showDialog();
        if (result == 0) {
            Messages.getInstance();
            System.err.println(Messages.getString("GeneratorPropertyIteratorPanel_SelectProperty_Error_Text_First"));
            PropertyNode[] path = jd.getPath();
            Object value = path[path.length - 1].value;
            PropertyDescriptor property = path[path.length - 1].property;
            Class<?> propertyClass = property.getPropertyType();
            this.m_Exp.setPropertyPath(path);
            this.m_Exp.setPropertyArray(Array.newInstance(propertyClass, 1));
            Array.set(this.m_Exp.getPropertyArray(), 0, value);
            this.m_ArrayEditor.setValue(this.m_Exp.getPropertyArray());
            this.m_ArrayEditor.repaint();
            Messages.getInstance();
            System.err.println(Messages.getString("GeneratorPropertyIteratorPanel_SelectProperty_Error_Text_Second"));
        } else {
            Messages.getInstance();
            System.err.println(Messages.getString("GeneratorPropertyIteratorPanel_SelectProperty_Error_Text_Third"));
        }
        return result;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_ConfigureBut) {
            this.selectProperty();
        } else if (e.getSource() == this.m_StatusBox) {
            for (int i = 0; i < this.m_Listeners.size(); ++i) {
                ActionListener temp = (ActionListener)this.m_Listeners.elementAt(i);
                Messages.getInstance();
                temp.actionPerformed(new ActionEvent(this, 1001, Messages.getString("GeneratorPropertyIteratorPanel_ActionPerformed_Text")));
            }
            if (this.m_StatusBox.getSelectedIndex() == 0) {
                this.m_Exp.setUsePropertyIterator(false);
                this.m_ConfigureBut.setEnabled(false);
                this.m_ArrayEditor.setEnabled(false);
                this.m_ArrayEditor.setValue(null);
                this.validate();
            } else {
                if (this.m_Exp.getPropertyArray() == null) {
                    this.selectProperty();
                }
                if (this.m_Exp.getPropertyArray() == null) {
                    this.m_StatusBox.setSelectedIndex(0);
                } else {
                    this.m_Exp.setUsePropertyIterator(true);
                    this.m_ConfigureBut.setEnabled(true);
                    this.m_ArrayEditor.setEnabled(true);
                }
                this.validate();
            }
        }
    }

    public void addActionListener(ActionListener newA) {
        this.m_Listeners.addElement(newA);
    }

    public static void main(String[] args) {
        try {
            Messages.getInstance();
            final JFrame jf = new JFrame(Messages.getString("GeneratorPropertyIteratorPanel_Main_JFrame_Text"));
            jf.getContentPane().setLayout(new BorderLayout());
            GeneratorPropertyIteratorPanel gp = new GeneratorPropertyIteratorPanel();
            jf.getContentPane().add((Component)gp, "Center");
            jf.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
            Messages.getInstance();
            System.err.println(Messages.getString("GeneratorPropertyIteratorPanel_Main_Error_Text_First"));
            Thread.currentThread();
            Thread.sleep(3000L);
            Messages.getInstance();
            System.err.println(Messages.getString("GeneratorPropertyIteratorPanel_Main_Error_Text_Second"));
            gp.setExperiment(new Experiment());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

