import datetime

EXPECTED_FIRST_HOURLY_TIMESTEP = {
    "time": datetime.datetime(2024, 2, 15, 19, 0, tzinfo=datetime.timezone.utc),
    "screenTemperature": {
        "value": 11.0,
        "description": "Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "maxScreenAirTemp": {
        "value": 11.55,
        "description": "Maximum Screen Air Temperature Over Previous Hour",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "minScreenAirTemp": {
        "value": 10.98,
        "description": "Minimum Screen Air Temperature Over Previous Hour",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "screenDewPointTemperature": {
        "value": 8.94,
        "description": "Screen Dew Point Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "feelsLikeTemperature": {
        "value": 10.87,
        "description": "Feels Like Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "windSpeed10m": {
        "value": 1.18,
        "description": "10m Wind Speed",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "windDirectionFrom10m": {
        "value": 180,
        "description": "10m Wind From Direction",
        "unit_name": "degrees",
        "unit_symbol": "deg",
    },
    "windGustSpeed10m": {
        "value": 6.69,
        "description": "10m Wind Gust Speed",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "max10mWindGust": {
        "value": 8.92,
        "description": "Maximum 10m Wind Gust Speed Over Previous Hour",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "visibility": {
        "value": 19174,
        "description": "Visibility",
        "unit_name": "metres",
        "unit_symbol": "m",
    },
    "screenRelativeHumidity": {
        "value": 86.99,
        "description": "Screen Relative Humidity",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "mslp": {
        "value": 100660,
        "description": "Mean Sea Level Pressure",
        "unit_name": "pascals",
        "unit_symbol": "Pa",
    },
    "uvIndex": {
        "value": 0,
        "description": "UV Index",
        "unit_name": "dimensionless",
        "unit_symbol": "1",
    },
    "significantWeatherCode": {
        "value": "Partly cloudy",
        "description": "Significant Weather Code",
        "unit_name": "dimensionless",
        "unit_symbol": "1",
    },
    "precipitationRate": {
        "value": 0.0,
        "description": "Precipitation Rate",
        "unit_name": "millimetres per hour",
        "unit_symbol": "mm/h",
    },
    "totalPrecipAmount": {
        "value": 0.0,
        "description": "Total Precipitation Amount Over Previous Hour",
        "unit_name": "millimetres",
        "unit_symbol": "mm",
    },
    "totalSnowAmount": {
        "value": 0,
        "description": "Total Snow Amount Over Previous Hour",
        "unit_name": "millimetres",
        "unit_symbol": "mm",
    },
    "probOfPrecipitation": {
        "value": 4,
        "description": "Probability of Precipitation",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
}

EXPECTED_FIRST_HOURLY_TIMESTEP_RAW_WEATHER_CODE = {
    "time": datetime.datetime(2024, 2, 15, 19, 0, tzinfo=datetime.timezone.utc),
    "screenTemperature": {
        "value": 11.0,
        "description": "Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "maxScreenAirTemp": {
        "value": 11.55,
        "description": "Maximum Screen Air Temperature Over Previous Hour",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "minScreenAirTemp": {
        "value": 10.98,
        "description": "Minimum Screen Air Temperature Over Previous Hour",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "screenDewPointTemperature": {
        "value": 8.94,
        "description": "Screen Dew Point Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "feelsLikeTemperature": {
        "value": 10.87,
        "description": "Feels Like Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "windSpeed10m": {
        "value": 1.18,
        "description": "10m Wind Speed",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "windDirectionFrom10m": {
        "value": 180,
        "description": "10m Wind From Direction",
        "unit_name": "degrees",
        "unit_symbol": "deg",
    },
    "windGustSpeed10m": {
        "value": 6.69,
        "description": "10m Wind Gust Speed",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "max10mWindGust": {
        "value": 8.92,
        "description": "Maximum 10m Wind Gust Speed Over Previous Hour",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "visibility": {
        "value": 19174,
        "description": "Visibility",
        "unit_name": "metres",
        "unit_symbol": "m",
    },
    "screenRelativeHumidity": {
        "value": 86.99,
        "description": "Screen Relative Humidity",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "mslp": {
        "value": 100660,
        "description": "Mean Sea Level Pressure",
        "unit_name": "pascals",
        "unit_symbol": "Pa",
    },
    "uvIndex": {
        "value": 0,
        "description": "UV Index",
        "unit_name": "dimensionless",
        "unit_symbol": "1",
    },
    "significantWeatherCode": {
        "value": 2,
        "description": "Significant Weather Code",
        "unit_name": "dimensionless",
        "unit_symbol": "1",
    },
    "precipitationRate": {
        "value": 0.0,
        "description": "Precipitation Rate",
        "unit_name": "millimetres per hour",
        "unit_symbol": "mm/h",
    },
    "totalPrecipAmount": {
        "value": 0.0,
        "description": "Total Precipitation Amount Over Previous Hour",
        "unit_name": "millimetres",
        "unit_symbol": "mm",
    },
    "totalSnowAmount": {
        "value": 0,
        "description": "Total Snow Amount Over Previous Hour",
        "unit_name": "millimetres",
        "unit_symbol": "mm",
    },
    "probOfPrecipitation": {
        "value": 4,
        "description": "Probability of Precipitation",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
}

EXPECTED_AT_DATETIME_HOURLY_TIMESTEP = {
    "time": datetime.datetime(2024, 2, 16, 19, 0, tzinfo=datetime.timezone.utc),
    "screenTemperature": {
        "value": 8.94,
        "description": "Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "maxScreenAirTemp": {
        "value": 9.6,
        "description": "Maximum Screen Air Temperature Over Previous Hour",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "minScreenAirTemp": {
        "value": 8.9,
        "description": "Minimum Screen Air Temperature Over Previous Hour",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "screenDewPointTemperature": {
        "value": 6.8,
        "description": "Screen Dew Point Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "feelsLikeTemperature": {
        "value": 7.68,
        "description": "Feels Like Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "windSpeed10m": {
        "value": 2.46,
        "description": "10m Wind Speed",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "windDirectionFrom10m": {
        "value": 255,
        "description": "10m Wind From Direction",
        "unit_name": "degrees",
        "unit_symbol": "deg",
    },
    "windGustSpeed10m": {
        "value": 7.35,
        "description": "10m Wind Gust Speed",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "max10mWindGust": {
        "value": 8.02,
        "description": "Maximum 10m Wind Gust Speed Over Previous Hour",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "visibility": {
        "value": 22767,
        "description": "Visibility",
        "unit_name": "metres",
        "unit_symbol": "m",
    },
    "screenRelativeHumidity": {
        "value": 86.81,
        "description": "Screen Relative Humidity",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "mslp": {
        "value": 102246,
        "description": "Mean Sea Level Pressure",
        "unit_name": "pascals",
        "unit_symbol": "Pa",
    },
    "uvIndex": {
        "value": 0,
        "description": "UV Index",
        "unit_name": "dimensionless",
        "unit_symbol": "1",
    },
    "significantWeatherCode": {
        "value": "Clear night",
        "description": "Significant Weather Code",
        "unit_name": "dimensionless",
        "unit_symbol": "1",
    },
    "precipitationRate": {
        "value": 0.0,
        "description": "Precipitation Rate",
        "unit_name": "millimetres per hour",
        "unit_symbol": "mm/h",
    },
    "totalPrecipAmount": {
        "value": 0.0,
        "description": "Total Precipitation Amount Over Previous Hour",
        "unit_name": "millimetres",
        "unit_symbol": "mm",
    },
    "totalSnowAmount": {
        "value": 0,
        "description": "Total Snow Amount Over Previous Hour",
        "unit_name": "millimetres",
        "unit_symbol": "mm",
    },
    "probOfPrecipitation": {
        "value": 0,
        "description": "Probability of Precipitation",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
}

EXPECTED_AT_DATETIME_HOURLY_FINAL_TIMESTEP = {
    "time": datetime.datetime(2024, 2, 17, 19, 0, tzinfo=datetime.timezone.utc),
    "screenTemperature": {
        "value": 10.34,
        "description": "Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "screenDewPointTemperature": {
        "value": 9.37,
        "description": "Screen Dew Point Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "feelsLikeTemperature": {
        "value": 8.34,
        "description": "Feels Like Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "windSpeed10m": {
        "value": 4.29,
        "description": "10m Wind Speed",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "windDirectionFrom10m": {
        "value": 187,
        "description": "10m Wind From Direction",
        "unit_name": "degrees",
        "unit_symbol": "deg",
    },
    "windGustSpeed10m": {
        "value": 8.68,
        "description": "10m Wind Gust Speed",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "visibility": {
        "value": 10128,
        "description": "Visibility",
        "unit_name": "metres",
        "unit_symbol": "m",
    },
    "screenRelativeHumidity": {
        "value": 94.17,
        "description": "Screen Relative Humidity",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "mslp": {
        "value": 102910,
        "description": "Mean Sea Level Pressure",
        "unit_name": "pascals",
        "unit_symbol": "Pa",
    },
    "uvIndex": {
        "value": 0,
        "description": "UV Index",
        "unit_name": "dimensionless",
        "unit_symbol": "1",
    },
    "significantWeatherCode": {
        "value": "Overcast",
        "description": "Significant Weather Code",
        "unit_name": "dimensionless",
        "unit_symbol": "1",
    },
    "precipitationRate": {
        "value": 0.0,
        "description": "Precipitation Rate",
        "unit_name": "millimetres per hour",
        "unit_symbol": "mm/h",
    },
    "probOfPrecipitation": {
        "value": 16,
        "description": "Probability of Precipitation",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
}
EXPECTED_FIRST_DAILY_TIMESTEP = {
    "time": datetime.datetime(2024, 2, 16, 0, 0, tzinfo=datetime.timezone.utc),
    "midday10MWindSpeed": {
        "value": 5.04,
        "description": "10m Wind Speed at Local Midday",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "midnight10MWindSpeed": {
        "value": 1.39,
        "description": "10m Wind Speed at Local Midnight",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "midday10MWindDirection": {
        "value": 273,
        "description": "10m Wind Direction at Local Midday",
        "unit_name": "degrees",
        "unit_symbol": "deg",
    },
    "midnight10MWindDirection": {
        "value": 243,
        "description": "10m Wind Direction at Local Midnight",
        "unit_name": "degrees",
        "unit_symbol": "deg",
    },
    "midday10MWindGust": {
        "value": 8.75,
        "description": "10m Wind Gust Speed at Local Midday",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "midnight10MWindGust": {
        "value": 7.2,
        "description": "10m Wind Gust Speed at Local Midnight",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "middayVisibility": {
        "value": 28772,
        "description": "Visibility at Local Midday",
        "unit_name": "metres",
        "unit_symbol": "m",
    },
    "midnightVisibility": {
        "value": 27712,
        "description": "Visibility at Local Midnight",
        "unit_name": "metres",
        "unit_symbol": "m",
    },
    "middayRelativeHumidity": {
        "value": 75.21,
        "description": "Relative Humidity at Local Midday",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "midnightRelativeHumidity": {
        "value": 80.91,
        "description": "Relative Humidity at Local Midnight",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "middayMslp": {
        "value": 101680,
        "description": "Mean Sea Level Pressure at Local Midday",
        "unit_name": "pascals",
        "unit_symbol": "Pa",
    },
    "midnightMslp": {
        "value": 102640,
        "description": "Mean Sea Level Pressure at Local Midnight",
        "unit_name": "pascals",
        "unit_symbol": "Pa",
    },
    "nightSignificantWeatherCode": {
        "value": "Cloudy",
        "description": "Night Significant Weather Code",
        "unit_name": "dimensionless",
        "unit_symbol": "1",
    },
    "dayMaxScreenTemperature": {
        "value": 12.82,
        "description": "Day Maximum Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightMinScreenTemperature": {
        "value": 5.32,
        "description": "Night Minimum Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "dayUpperBoundMaxTemp": {
        "value": 14.1,
        "description": "Upper Bound on Day Maximum Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightUpperBoundMinTemp": {
        "value": 9.17,
        "description": "Upper Bound on Night Minimum Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "dayLowerBoundMaxTemp": {
        "value": 11.97,
        "description": "Lower Bound on Day Maximum Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightLowerBoundMinTemp": {
        "value": 3.56,
        "description": "Lower Bound on Night Minimum Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightMinFeelsLikeTemp": {
        "value": 6.27,
        "description": "Night Minimum Feels Like Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "dayUpperBoundMaxFeelsLikeTemp": {
        "value": 12.47,
        "description": "Upper Bound on Day Maximum Feels Like Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightUpperBoundMinFeelsLikeTemp": {
        "value": 8.74,
        "description": "Upper Bound on Night Minimum Feels Like Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "dayLowerBoundMaxFeelsLikeTemp": {
        "value": 10.01,
        "description": "Lower Bound on Day Maximum Feels Like Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightLowerBoundMinFeelsLikeTemp": {
        "value": 2.75,
        "description": "Lower Bound on Night Minimum Feels Like Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightProbabilityOfPrecipitation": {
        "value": 11,
        "description": "Probability of Precipitation During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfSnow": {
        "value": 0,
        "description": "Probability of Snow During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfHeavySnow": {
        "value": 0,
        "description": "Probability of Heavy Snow During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfRain": {
        "value": 10,
        "description": "Probability of Rain During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfHeavyRain": {
        "value": 0,
        "description": "Probability of Heavy Rain During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfHail": {
        "value": 0,
        "description": "Probability of Hail During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfSferics": {
        "value": 0,
        "description": "Probability of Sferics During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
}

EXPECTED_FIRST_DAILY_TIMESTEP_RAW_WEATHER_CODE = {
    "time": datetime.datetime(2024, 2, 16, 0, 0, tzinfo=datetime.timezone.utc),
    "midday10MWindSpeed": {
        "value": 5.04,
        "description": "10m Wind Speed at Local Midday",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "midnight10MWindSpeed": {
        "value": 1.39,
        "description": "10m Wind Speed at Local Midnight",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "midday10MWindDirection": {
        "value": 273,
        "description": "10m Wind Direction at Local Midday",
        "unit_name": "degrees",
        "unit_symbol": "deg",
    },
    "midnight10MWindDirection": {
        "value": 243,
        "description": "10m Wind Direction at Local Midnight",
        "unit_name": "degrees",
        "unit_symbol": "deg",
    },
    "midday10MWindGust": {
        "value": 8.75,
        "description": "10m Wind Gust Speed at Local Midday",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "midnight10MWindGust": {
        "value": 7.2,
        "description": "10m Wind Gust Speed at Local Midnight",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "middayVisibility": {
        "value": 28772,
        "description": "Visibility at Local Midday",
        "unit_name": "metres",
        "unit_symbol": "m",
    },
    "midnightVisibility": {
        "value": 27712,
        "description": "Visibility at Local Midnight",
        "unit_name": "metres",
        "unit_symbol": "m",
    },
    "middayRelativeHumidity": {
        "value": 75.21,
        "description": "Relative Humidity at Local Midday",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "midnightRelativeHumidity": {
        "value": 80.91,
        "description": "Relative Humidity at Local Midnight",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "middayMslp": {
        "value": 101680,
        "description": "Mean Sea Level Pressure at Local Midday",
        "unit_name": "pascals",
        "unit_symbol": "Pa",
    },
    "midnightMslp": {
        "value": 102640,
        "description": "Mean Sea Level Pressure at Local Midnight",
        "unit_name": "pascals",
        "unit_symbol": "Pa",
    },
    "nightSignificantWeatherCode": {
        "value": 7,
        "description": "Night Significant Weather Code",
        "unit_name": "dimensionless",
        "unit_symbol": "1",
    },
    "dayMaxScreenTemperature": {
        "value": 12.82,
        "description": "Day Maximum Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightMinScreenTemperature": {
        "value": 5.32,
        "description": "Night Minimum Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "dayUpperBoundMaxTemp": {
        "value": 14.1,
        "description": "Upper Bound on Day Maximum Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightUpperBoundMinTemp": {
        "value": 9.17,
        "description": "Upper Bound on Night Minimum Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "dayLowerBoundMaxTemp": {
        "value": 11.97,
        "description": "Lower Bound on Day Maximum Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightLowerBoundMinTemp": {
        "value": 3.56,
        "description": "Lower Bound on Night Minimum Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightMinFeelsLikeTemp": {
        "value": 6.27,
        "description": "Night Minimum Feels Like Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "dayUpperBoundMaxFeelsLikeTemp": {
        "value": 12.47,
        "description": "Upper Bound on Day Maximum Feels Like Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightUpperBoundMinFeelsLikeTemp": {
        "value": 8.74,
        "description": "Upper Bound on Night Minimum Feels Like Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "dayLowerBoundMaxFeelsLikeTemp": {
        "value": 10.01,
        "description": "Lower Bound on Day Maximum Feels Like Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightLowerBoundMinFeelsLikeTemp": {
        "value": 2.75,
        "description": "Lower Bound on Night Minimum Feels Like Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightProbabilityOfPrecipitation": {
        "value": 11,
        "description": "Probability of Precipitation During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfSnow": {
        "value": 0,
        "description": "Probability of Snow During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfHeavySnow": {
        "value": 0,
        "description": "Probability of Heavy Snow During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfRain": {
        "value": 10,
        "description": "Probability of Rain During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfHeavyRain": {
        "value": 0,
        "description": "Probability of Heavy Rain During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfHail": {
        "value": 0,
        "description": "Probability of Hail During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfSferics": {
        "value": 0,
        "description": "Probability of Sferics During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
}

EXPECTED_AT_DATETIME_DAILY_TIMESTEP = {
    "time": datetime.datetime(2024, 2, 17, 0, 0, tzinfo=datetime.timezone.utc),
    "midday10MWindSpeed": {
        "value": 4.32,
        "description": "10m Wind Speed at Local Midday",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "midnight10MWindSpeed": {
        "value": 6.1,
        "description": "10m Wind Speed at Local Midnight",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "midday10MWindDirection": {
        "value": 230,
        "description": "10m Wind Direction at Local Midday",
        "unit_name": "degrees",
        "unit_symbol": "deg",
    },
    "midnight10MWindDirection": {
        "value": 218,
        "description": "10m Wind Direction at Local Midnight",
        "unit_name": "degrees",
        "unit_symbol": "deg",
    },
    "midday10MWindGust": {
        "value": 8.75,
        "description": "10m Wind Gust Speed at Local Midday",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "midnight10MWindGust": {
        "value": 12.98,
        "description": "10m Wind Gust Speed at Local Midnight",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "middayVisibility": {
        "value": 4158,
        "description": "Visibility at Local Midday",
        "unit_name": "metres",
        "unit_symbol": "m",
    },
    "midnightVisibility": {
        "value": 5915,
        "description": "Visibility at Local Midnight",
        "unit_name": "metres",
        "unit_symbol": "m",
    },
    "middayRelativeHumidity": {
        "value": 97.38,
        "description": "Relative Humidity at Local Midday",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "midnightRelativeHumidity": {
        "value": 93.62,
        "description": "Relative Humidity at Local Midnight",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "middayMslp": {
        "value": 103140,
        "description": "Mean Sea Level Pressure at Local Midday",
        "unit_name": "pascals",
        "unit_symbol": "Pa",
    },
    "midnightMslp": {
        "value": 102800,
        "description": "Mean Sea Level Pressure at Local Midnight",
        "unit_name": "pascals",
        "unit_symbol": "Pa",
    },
    "maxUvIndex": {
        "value": 1,
        "description": "Day Maximum UV Index",
        "unit_name": "dimensionless",
        "unit_symbol": "1",
    },
    "daySignificantWeatherCode": {
        "value": "Overcast",
        "description": "Day Significant Weather Code",
        "unit_name": "dimensionless",
        "unit_symbol": "1",
    },
    "nightSignificantWeatherCode": {
        "value": "Heavy rain",
        "description": "Night Significant Weather Code",
        "unit_name": "dimensionless",
        "unit_symbol": "1",
    },
    "dayMaxScreenTemperature": {
        "value": 12.0,
        "description": "Day Maximum Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightMinScreenTemperature": {
        "value": 9.96,
        "description": "Night Minimum Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "dayUpperBoundMaxTemp": {
        "value": 13.71,
        "description": "Upper Bound on Day Maximum Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightUpperBoundMinTemp": {
        "value": 10.71,
        "description": "Upper Bound on Night Minimum Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "dayLowerBoundMaxTemp": {
        "value": 10.23,
        "description": "Lower Bound on Day Maximum Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightLowerBoundMinTemp": {
        "value": 9.04,
        "description": "Lower Bound on Night Minimum Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "dayMaxFeelsLikeTemp": {
        "value": 10.6,
        "description": "Day Maximum Feels Like Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightMinFeelsLikeTemp": {
        "value": 7.76,
        "description": "Night Minimum Feels Like Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "dayUpperBoundMaxFeelsLikeTemp": {
        "value": 11.49,
        "description": "Upper Bound on Day Maximum Feels Like Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightUpperBoundMinFeelsLikeTemp": {
        "value": 8.28,
        "description": "Upper Bound on Night Minimum Feels Like Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "dayLowerBoundMaxFeelsLikeTemp": {
        "value": 8.38,
        "description": "Lower Bound on Day Maximum Feels Like Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightLowerBoundMinFeelsLikeTemp": {
        "value": 7.04,
        "description": "Lower Bound on Night Minimum Feels Like Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "dayProbabilityOfPrecipitation": {
        "value": 18,
        "description": "Probability of Precipitation During The Day",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfPrecipitation": {
        "value": 97,
        "description": "Probability of Precipitation During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "dayProbabilityOfSnow": {
        "value": 0,
        "description": "Probability of Snow During The Day",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfSnow": {
        "value": 0,
        "description": "Probability of Snow During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "dayProbabilityOfHeavySnow": {
        "value": 0,
        "description": "Probability of Heavy Snow During The Day",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfHeavySnow": {
        "value": 0,
        "description": "Probability of Heavy Snow During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "dayProbabilityOfRain": {
        "value": 18,
        "description": "Probability of Rain During The Day",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfRain": {
        "value": 97,
        "description": "Probability of Rain During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "dayProbabilityOfHeavyRain": {
        "value": 5,
        "description": "Probability of Heavy Rain During The Day",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfHeavyRain": {
        "value": 96,
        "description": "Probability of Heavy Rain During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "dayProbabilityOfHail": {
        "value": 0,
        "description": "Probability of Hail During The Day",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfHail": {
        "value": 20,
        "description": "Probability of Hail During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "dayProbabilityOfSferics": {
        "value": 0,
        "description": "Probability of Sferics During The Day",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfSferics": {
        "value": 10,
        "description": "Probability of Sferics During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
}

EXPECTED_AT_DATETIME_DAILY_FINAL_TIMESTEP = {
    "time": datetime.datetime(2024, 2, 18, 0, 0, tzinfo=datetime.timezone.utc),
    "midday10MWindSpeed": {
        "value": 4.07,
        "description": "10m Wind Speed at Local Midday",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "midnight10MWindSpeed": {
        "value": 2.84,
        "description": "10m Wind Speed at Local Midnight",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "midday10MWindDirection": {
        "value": 292,
        "description": "10m Wind Direction at Local Midday",
        "unit_name": "degrees",
        "unit_symbol": "deg",
    },
    "midnight10MWindDirection": {
        "value": 281,
        "description": "10m Wind Direction at Local Midnight",
        "unit_name": "degrees",
        "unit_symbol": "deg",
    },
    "midday10MWindGust": {
        "value": 7.55,
        "description": "10m Wind Gust Speed at Local Midday",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "midnight10MWindGust": {
        "value": 6.36,
        "description": "10m Wind Gust Speed at Local Midnight",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "middayVisibility": {
        "value": 25425,
        "description": "Visibility at Local Midday",
        "unit_name": "metres",
        "unit_symbol": "m",
    },
    "midnightVisibility": {
        "value": 17183,
        "description": "Visibility at Local Midnight",
        "unit_name": "metres",
        "unit_symbol": "m",
    },
    "middayRelativeHumidity": {
        "value": 86.19,
        "description": "Relative Humidity at Local Midday",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "midnightRelativeHumidity": {
        "value": 94.68,
        "description": "Relative Humidity at Local Midnight",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "middayMslp": {
        "value": 102625,
        "description": "Mean Sea Level Pressure at Local Midday",
        "unit_name": "pascals",
        "unit_symbol": "Pa",
    },
    "midnightMslp": {
        "value": 103041,
        "description": "Mean Sea Level Pressure at Local Midnight",
        "unit_name": "pascals",
        "unit_symbol": "Pa",
    },
    "maxUvIndex": {
        "value": 1,
        "description": "Day Maximum UV Index",
        "unit_name": "dimensionless",
        "unit_symbol": "1",
    },
    "daySignificantWeatherCode": {
        "value": "Light rain",
        "description": "Day Significant Weather Code",
        "unit_name": "dimensionless",
        "unit_symbol": "1",
    },
    "nightSignificantWeatherCode": {
        "value": "Cloudy",
        "description": "Night Significant Weather Code",
        "unit_name": "dimensionless",
        "unit_symbol": "1",
    },
    "dayMaxScreenTemperature": {
        "value": 13.89,
        "description": "Day Maximum Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightMinScreenTemperature": {
        "value": 7.15,
        "description": "Night Minimum Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "dayUpperBoundMaxTemp": {
        "value": 14.73,
        "description": "Upper Bound on Day Maximum Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightUpperBoundMinTemp": {
        "value": 9.16,
        "description": "Upper Bound on Night Minimum Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "dayLowerBoundMaxTemp": {
        "value": 12.4,
        "description": "Lower Bound on Day Maximum Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightLowerBoundMinTemp": {
        "value": 5.31,
        "description": "Lower Bound on Night Minimum Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "dayMaxFeelsLikeTemp": {
        "value": 11.75,
        "description": "Day Maximum Feels Like Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightMinFeelsLikeTemp": {
        "value": 5.34,
        "description": "Night Minimum Feels Like Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "dayUpperBoundMaxFeelsLikeTemp": {
        "value": 13.47,
        "description": "Upper Bound on Day Maximum Feels Like Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightUpperBoundMinFeelsLikeTemp": {
        "value": 7.12,
        "description": "Upper Bound on Night Minimum Feels Like Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "dayLowerBoundMaxFeelsLikeTemp": {
        "value": 10.8,
        "description": "Lower Bound on Day Maximum Feels Like Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightLowerBoundMinFeelsLikeTemp": {
        "value": 5.06,
        "description": "Lower Bound on Night Minimum Feels Like Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "dayProbabilityOfPrecipitation": {
        "value": 55,
        "description": "Probability of Precipitation During The Day",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfPrecipitation": {
        "value": 9,
        "description": "Probability of Precipitation During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "dayProbabilityOfSnow": {
        "value": 0,
        "description": "Probability of Snow During The Day",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfSnow": {
        "value": 0,
        "description": "Probability of Snow During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "dayProbabilityOfHeavySnow": {
        "value": 0,
        "description": "Probability of Heavy Snow During The Day",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfHeavySnow": {
        "value": 0,
        "description": "Probability of Heavy Snow During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "dayProbabilityOfRain": {
        "value": 55,
        "description": "Probability of Rain During The Day",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfRain": {
        "value": 9,
        "description": "Probability of Rain During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "dayProbabilityOfHeavyRain": {
        "value": 36,
        "description": "Probability of Heavy Rain During The Day",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfHeavyRain": {
        "value": 2,
        "description": "Probability of Heavy Rain During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "dayProbabilityOfHail": {
        "value": 4,
        "description": "Probability of Hail During The Day",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfHail": {
        "value": 0,
        "description": "Probability of Hail During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "dayProbabilityOfSferics": {
        "value": 3,
        "description": "Probability of Sferics During The Day",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfSferics": {
        "value": 0,
        "description": "Probability of Sferics During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
}

EXPECTED_FIRST_THREE_HOURLY_TIMESTEP = {
    "time": datetime.datetime(2024, 2, 17, 15, 0, tzinfo=datetime.timezone.utc),
    "maxScreenAirTemp": {
        "value": 12.0,
        "description": "Maximum Screen Air Temperature Over Previous Three Hours",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "minScreenAirTemp": {
        "value": 10.73,
        "description": "Minimum Screen Air Temperature Over Previous Three Hours",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "max10mWindGust": {
        "value": 8.87,
        "description": "Maximum 10m Wind Gust Speed Over Previous Three Hours",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "significantWeatherCode": {
        "value": "Overcast",
        "description": "Three Hour Significant Weather Code",
        "unit_name": "dimensionless",
        "unit_symbol": "1",
    },
    "totalPrecipAmount": {
        "value": 0.0,
        "description": "Total Precipitation Amount Over Previous Three Hours",
        "unit_name": "millimetres",
        "unit_symbol": "mm",
    },
    "totalSnowAmount": {
        "value": 0,
        "description": "Total Snow Amount Over Previous Three Hours",
        "unit_name": "millimetres",
        "unit_symbol": "mm",
    },
    "windSpeed10m": {
        "value": 5.04,
        "description": "10m Wind Speed Over Previous Three Hours",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "windDirectionFrom10m": {
        "value": 225,
        "description": "10m Wind From Direction Over Previous Three Hours",
        "unit_name": "degrees",
        "unit_symbol": "deg",
    },
    "windGustSpeed10m": {
        "value": 8.75,
        "description": "10m Wind Gust Speed Over Previous Three Hours",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "visibility": {
        "value": 9118,
        "description": "Visibility Over Previous Three Hours",
        "unit_name": "metres",
        "unit_symbol": "m",
    },
    "mslp": {
        "value": 103090,
        "description": "Mean Sea Level Pressure Over Previous Three Hours",
        "unit_name": "pascals",
        "unit_symbol": "Pa",
    },
    "screenRelativeHumidity": {
        "value": 96.84,
        "description": "Screen Relative Humidity Over Previous Three Hours",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "feelsLikeTemp": {
        "value": 8.53,
        "description": "Feels Like Temperature Over Previous Three Hours",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "uvIndex": {
        "value": 1,
        "description": "Maximum UV Index Over Previous Three Hours",
        "unit_name": "dimensionless",
        "unit_symbol": "1",
    },
    "probOfPrecipitation": {
        "value": 10,
        "description": "Three Hour Probability of Precipitation",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "probOfSnow": {
        "value": 0,
        "description": "Three Hour Probability of Snow",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "probOfHeavySnow": {
        "value": 0,
        "description": "Three Hour Probability of Heavy Snow",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "probOfRain": {
        "value": 10,
        "description": "Three Hour Probability of Rain",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "probOfHeavyRain": {
        "value": 0,
        "description": "Three Hour Probability of Heavy Rain",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "probOfHail": {
        "value": 0,
        "description": "Three Hour Probability of Hail",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "probOfSferics": {
        "value": 0,
        "description": "Three Hour Probability of Sferics",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
}

EXPECTED_AT_DATETIME_THREE_HOURLY_TIMESTEP = {
    "time": datetime.datetime(2024, 2, 22, 18, 0, tzinfo=datetime.timezone.utc),
    "maxScreenAirTemp": {
        "value": 9.82,
        "description": "Maximum Screen Air Temperature Over Previous Three Hours",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "minScreenAirTemp": {
        "value": 7.61,
        "description": "Minimum Screen Air Temperature Over Previous Three Hours",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "max10mWindGust": {
        "value": 19.28,
        "description": "Maximum 10m Wind Gust Speed Over Previous Three Hours",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "significantWeatherCode": {
        "value": "Light rain shower",
        "description": "Three Hour Significant Weather Code",
        "unit_name": "dimensionless",
        "unit_symbol": "1",
    },
    "totalPrecipAmount": {
        "value": 1.11,
        "description": "Total Precipitation Amount Over Previous Three Hours",
        "unit_name": "millimetres",
        "unit_symbol": "mm",
    },
    "totalSnowAmount": {
        "value": 0,
        "description": "Total Snow Amount Over Previous Three Hours",
        "unit_name": "millimetres",
        "unit_symbol": "mm",
    },
    "windSpeed10m": {
        "value": 7.91,
        "description": "10m Wind Speed Over Previous Three Hours",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "windDirectionFrom10m": {
        "value": 239,
        "description": "10m Wind From Direction Over Previous Three Hours",
        "unit_name": "degrees",
        "unit_symbol": "deg",
    },
    "windGustSpeed10m": {
        "value": 14.42,
        "description": "10m Wind Gust Speed Over Previous Three Hours",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "visibility": {
        "value": 20148,
        "description": "Visibility Over Previous Three Hours",
        "unit_name": "metres",
        "unit_symbol": "m",
    },
    "mslp": {
        "value": 98434,
        "description": "Mean Sea Level Pressure Over Previous Three Hours",
        "unit_name": "pascals",
        "unit_symbol": "Pa",
    },
    "screenRelativeHumidity": {
        "value": 79.36,
        "description": "Screen Relative Humidity Over Previous Three Hours",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "feelsLikeTemp": {
        "value": 3.74,
        "description": "Feels Like Temperature Over Previous Three Hours",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "uvIndex": {
        "value": 0,
        "description": "Maximum UV Index Over Previous Three Hours",
        "unit_name": "dimensionless",
        "unit_symbol": "1",
    },
    "probOfPrecipitation": {
        "value": 44,
        "description": "Three Hour Probability of Precipitation",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "probOfSnow": {
        "value": 0,
        "description": "Three Hour Probability of Snow",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "probOfHeavySnow": {
        "value": 0,
        "description": "Three Hour Probability of Heavy Snow",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "probOfRain": {
        "value": 44,
        "description": "Three Hour Probability of Rain",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "probOfHeavyRain": {
        "value": 32,
        "description": "Three Hour Probability of Heavy Rain",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "probOfHail": {
        "value": 4,
        "description": "Three Hour Probability of Hail",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "probOfSferics": {
        "value": 6,
        "description": "Three Hour Probability of Sferics",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
}

EXPECTED_AT_DATETIME_THREE_HOURLY_FINAL_TIMESTEP = {
    "time": datetime.datetime(2024, 2, 24, 15, 0, tzinfo=datetime.timezone.utc),
    "maxScreenAirTemp": {
        "value": 8.25,
        "description": "Maximum Screen Air Temperature Over Previous Three Hours",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "minScreenAirTemp": {
        "value": 7.96,
        "description": "Minimum Screen Air Temperature Over Previous Three Hours",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "max10mWindGust": {
        "value": 12.77,
        "description": "Maximum 10m Wind Gust Speed Over Previous Three Hours",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "significantWeatherCode": {
        "value": "Light rain shower",
        "description": "Three Hour Significant Weather Code",
        "unit_name": "dimensionless",
        "unit_symbol": "1",
    },
    "totalPrecipAmount": {
        "value": 0.58,
        "description": "Total Precipitation Amount Over Previous Three Hours",
        "unit_name": "millimetres",
        "unit_symbol": "mm",
    },
    "totalSnowAmount": {
        "value": 0,
        "description": "Total Snow Amount Over Previous Three Hours",
        "unit_name": "millimetres",
        "unit_symbol": "mm",
    },
    "windSpeed10m": {
        "value": 5.98,
        "description": "10m Wind Speed Over Previous Three Hours",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "windDirectionFrom10m": {
        "value": 228,
        "description": "10m Wind From Direction Over Previous Three Hours",
        "unit_name": "degrees",
        "unit_symbol": "deg",
    },
    "windGustSpeed10m": {
        "value": 11.48,
        "description": "10m Wind Gust Speed Over Previous Three Hours",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "visibility": {
        "value": 22483,
        "description": "Visibility Over Previous Three Hours",
        "unit_name": "metres",
        "unit_symbol": "m",
    },
    "mslp": {
        "value": 99725,
        "description": "Mean Sea Level Pressure Over Previous Three Hours",
        "unit_name": "pascals",
        "unit_symbol": "Pa",
    },
    "screenRelativeHumidity": {
        "value": 72.01,
        "description": "Screen Relative Humidity Over Previous Three Hours",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "feelsLikeTemp": {
        "value": 4.97,
        "description": "Feels Like Temperature Over Previous Three Hours",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "uvIndex": {
        "value": 1,
        "description": "Maximum UV Index Over Previous Three Hours",
        "unit_name": "dimensionless",
        "unit_symbol": "1",
    },
    "probOfPrecipitation": {
        "value": 32,
        "description": "Three Hour Probability of Precipitation",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "probOfSnow": {
        "value": 0,
        "description": "Three Hour Probability of Snow",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "probOfHeavySnow": {
        "value": 0,
        "description": "Three Hour Probability of Heavy Snow",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "probOfRain": {
        "value": 32,
        "description": "Three Hour Probability of Rain",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "probOfHeavyRain": {
        "value": 17,
        "description": "Three Hour Probability of Heavy Rain",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "probOfHail": {
        "value": 1,
        "description": "Three Hour Probability of Hail",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "probOfSferics": {
        "value": 3,
        "description": "Three Hour Probability of Sferics",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
}

EXPECTED_FIRST_TWICE_DAILY_TIMESTEP = {
    "time": datetime.datetime(2024, 2, 16, 0, 0, tzinfo=datetime.timezone.utc),
    "midnight10MWindSpeed": {
        "value": 1.39,
        "description": "10m Wind Speed at Local Midnight",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "midnight10MWindDirection": {
        "value": 243,
        "description": "10m Wind Direction at Local Midnight",
        "unit_name": "degrees",
        "unit_symbol": "deg",
    },
    "midnight10MWindGust": {
        "value": 7.2,
        "description": "10m Wind Gust Speed at Local Midnight",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "midnightVisibility": {
        "value": 27712,
        "description": "Visibility at Local Midnight",
        "unit_name": "metres",
        "unit_symbol": "m",
    },
    "midnightRelativeHumidity": {
        "value": 80.91,
        "description": "Relative Humidity at Local Midnight",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "midnightMslp": {
        "value": 102640,
        "description": "Mean Sea Level Pressure at Local Midnight",
        "unit_name": "pascals",
        "unit_symbol": "Pa",
    },
    "nightSignificantWeatherCode": {
        "value": "Cloudy",
        "description": "Night Significant Weather Code",
        "unit_name": "dimensionless",
        "unit_symbol": "1",
    },
    "nightMinScreenTemperature": {
        "value": 5.32,
        "description": "Night Minimum Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightUpperBoundMinTemp": {
        "value": 9.17,
        "description": "Upper Bound on Night Minimum Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightLowerBoundMinTemp": {
        "value": 3.56,
        "description": "Lower Bound on Night Minimum Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightMinFeelsLikeTemp": {
        "value": 6.27,
        "description": "Night Minimum Feels Like Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightUpperBoundMinFeelsLikeTemp": {
        "value": 8.74,
        "description": "Upper Bound on Night Minimum Feels Like Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightLowerBoundMinFeelsLikeTemp": {
        "value": 2.75,
        "description": "Lower Bound on Night Minimum Feels Like Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightProbabilityOfPrecipitation": {
        "value": 11,
        "description": "Probability of Precipitation During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfSnow": {
        "value": 0,
        "description": "Probability of Snow During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfHeavySnow": {
        "value": 0,
        "description": "Probability of Heavy Snow During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfRain": {
        "value": 10,
        "description": "Probability of Rain During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfHeavyRain": {
        "value": 0,
        "description": "Probability of Heavy Rain During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfHail": {
        "value": 0,
        "description": "Probability of Hail During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfSferics": {
        "value": 0,
        "description": "Probability of Sferics During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
}

EXPECTED_AT_DATETIME_TWICE_DAILY_TIMESTEP = {
    "time": datetime.datetime(2024, 2, 17, 0, 0, tzinfo=datetime.timezone.utc),
    "midnight10MWindSpeed": {
        "value": 6.1,
        "description": "10m Wind Speed at Local Midnight",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "midnight10MWindDirection": {
        "value": 218,
        "description": "10m Wind Direction at Local Midnight",
        "unit_name": "degrees",
        "unit_symbol": "deg",
    },
    "midnight10MWindGust": {
        "value": 12.98,
        "description": "10m Wind Gust Speed at Local Midnight",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "midnightVisibility": {
        "value": 5915,
        "description": "Visibility at Local Midnight",
        "unit_name": "metres",
        "unit_symbol": "m",
    },
    "midnightRelativeHumidity": {
        "value": 93.62,
        "description": "Relative Humidity at Local Midnight",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "midnightMslp": {
        "value": 102800,
        "description": "Mean Sea Level Pressure at Local Midnight",
        "unit_name": "pascals",
        "unit_symbol": "Pa",
    },
    "nightSignificantWeatherCode": {
        "value": "Heavy rain",
        "description": "Night Significant Weather Code",
        "unit_name": "dimensionless",
        "unit_symbol": "1",
    },
    "nightMinScreenTemperature": {
        "value": 9.96,
        "description": "Night Minimum Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightUpperBoundMinTemp": {
        "value": 10.71,
        "description": "Upper Bound on Night Minimum Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightLowerBoundMinTemp": {
        "value": 9.04,
        "description": "Lower Bound on Night Minimum Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightMinFeelsLikeTemp": {
        "value": 7.76,
        "description": "Night Minimum Feels Like Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightUpperBoundMinFeelsLikeTemp": {
        "value": 8.28,
        "description": "Upper Bound on Night Minimum Feels Like Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightLowerBoundMinFeelsLikeTemp": {
        "value": 7.04,
        "description": "Lower Bound on Night Minimum Feels Like Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightProbabilityOfPrecipitation": {
        "value": 97,
        "description": "Probability of Precipitation During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfSnow": {
        "value": 0,
        "description": "Probability of Snow During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfHeavySnow": {
        "value": 0,
        "description": "Probability of Heavy Snow During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfRain": {
        "value": 97,
        "description": "Probability of Rain During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfHeavyRain": {
        "value": 96,
        "description": "Probability of Heavy Rain During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfHail": {
        "value": 20,
        "description": "Probability of Hail During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfSferics": {
        "value": 10,
        "description": "Probability of Sferics During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
}

EXPECTED_AT_DATETIME_TWICE_DAILY_FINAL_TIMESTEP = {
    "time": datetime.datetime(2024, 2, 17, 12, 0, tzinfo=datetime.timezone.utc),
    "midday10MWindSpeed": {
        "value": 4.32,
        "description": "10m Wind Speed at Local Midday",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "midday10MWindDirection": {
        "value": 230,
        "description": "10m Wind Direction at Local Midday",
        "unit_name": "degrees",
        "unit_symbol": "deg",
    },
    "midday10MWindGust": {
        "value": 8.75,
        "description": "10m Wind Gust Speed at Local Midday",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "middayVisibility": {
        "value": 4158,
        "description": "Visibility at Local Midday",
        "unit_name": "metres",
        "unit_symbol": "m",
    },
    "middayRelativeHumidity": {
        "value": 97.38,
        "description": "Relative Humidity at Local Midday",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "middayMslp": {
        "value": 103140,
        "description": "Mean Sea Level Pressure at Local Midday",
        "unit_name": "pascals",
        "unit_symbol": "Pa",
    },
    "maxUvIndex": {
        "value": 1,
        "description": "Day Maximum UV Index",
        "unit_name": "dimensionless",
        "unit_symbol": "1",
    },
    "daySignificantWeatherCode": {
        "value": "Overcast",
        "description": "Day Significant Weather Code",
        "unit_name": "dimensionless",
        "unit_symbol": "1",
    },
    "dayMaxScreenTemperature": {
        "value": 12.0,
        "description": "Day Maximum Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "dayUpperBoundMaxTemp": {
        "value": 13.71,
        "description": "Upper Bound on Day Maximum Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "dayLowerBoundMaxTemp": {
        "value": 10.23,
        "description": "Lower Bound on Day Maximum Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "dayMaxFeelsLikeTemp": {
        "value": 10.6,
        "description": "Day Maximum Feels Like Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "dayUpperBoundMaxFeelsLikeTemp": {
        "value": 11.49,
        "description": "Upper Bound on Day Maximum Feels Like Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "dayLowerBoundMaxFeelsLikeTemp": {
        "value": 8.38,
        "description": "Lower Bound on Day Maximum Feels Like Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "dayProbabilityOfPrecipitation": {
        "value": 18,
        "description": "Probability of Precipitation During The Day",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "dayProbabilityOfSnow": {
        "value": 0,
        "description": "Probability of Snow During The Day",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "dayProbabilityOfHeavySnow": {
        "value": 0,
        "description": "Probability of Heavy Snow During The Day",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "dayProbabilityOfRain": {
        "value": 18,
        "description": "Probability of Rain During The Day",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "dayProbabilityOfHeavyRain": {
        "value": 5,
        "description": "Probability of Heavy Rain During The Day",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "dayProbabilityOfHail": {
        "value": 0,
        "description": "Probability of Hail During The Day",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "dayProbabilityOfSferics": {
        "value": 0,
        "description": "Probability of Sferics During The Day",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
}

EXPECTED_FIRST_TWICE_DAILY_TIMESTEP_RAW_WEATHER_CODE = {
    "time": datetime.datetime(2024, 2, 16, 0, 0, tzinfo=datetime.timezone.utc),
    "midnight10MWindSpeed": {
        "value": 1.39,
        "description": "10m Wind Speed at Local Midnight",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "midnight10MWindDirection": {
        "value": 243,
        "description": "10m Wind Direction at Local Midnight",
        "unit_name": "degrees",
        "unit_symbol": "deg",
    },
    "midnight10MWindGust": {
        "value": 7.2,
        "description": "10m Wind Gust Speed at Local Midnight",
        "unit_name": "metres per second",
        "unit_symbol": "m/s",
    },
    "midnightVisibility": {
        "value": 27712,
        "description": "Visibility at Local Midnight",
        "unit_name": "metres",
        "unit_symbol": "m",
    },
    "midnightRelativeHumidity": {
        "value": 80.91,
        "description": "Relative Humidity at Local Midnight",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "midnightMslp": {
        "value": 102640,
        "description": "Mean Sea Level Pressure at Local Midnight",
        "unit_name": "pascals",
        "unit_symbol": "Pa",
    },
    "nightSignificantWeatherCode": {
        "value": 7,
        "description": "Night Significant Weather Code",
        "unit_name": "dimensionless",
        "unit_symbol": "1",
    },
    "nightMinScreenTemperature": {
        "value": 5.32,
        "description": "Night Minimum Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightUpperBoundMinTemp": {
        "value": 9.17,
        "description": "Upper Bound on Night Minimum Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightLowerBoundMinTemp": {
        "value": 3.56,
        "description": "Lower Bound on Night Minimum Screen Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightMinFeelsLikeTemp": {
        "value": 6.27,
        "description": "Night Minimum Feels Like Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightUpperBoundMinFeelsLikeTemp": {
        "value": 8.74,
        "description": "Upper Bound on Night Minimum Feels Like Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightLowerBoundMinFeelsLikeTemp": {
        "value": 2.75,
        "description": "Lower Bound on Night Minimum Feels Like Air Temperature",
        "unit_name": "degrees Celsius",
        "unit_symbol": "Cel",
    },
    "nightProbabilityOfPrecipitation": {
        "value": 11,
        "description": "Probability of Precipitation During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfSnow": {
        "value": 0,
        "description": "Probability of Snow During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfHeavySnow": {
        "value": 0,
        "description": "Probability of Heavy Snow During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfRain": {
        "value": 10,
        "description": "Probability of Rain During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfHeavyRain": {
        "value": 0,
        "description": "Probability of Heavy Rain During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfHail": {
        "value": 0,
        "description": "Probability of Hail During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
    "nightProbabilityOfSferics": {
        "value": 0,
        "description": "Probability of Sferics During The Night",
        "unit_name": "percentage",
        "unit_symbol": "%",
    },
}
