## Distro

Windows Server 2019


## GSSAPI Impl

SSPI


## Connection Info:

Connecting to SMB share using the IP address. Uses explicit auth. This still occurred on a domain setup with a domain
account, just used IPs so Kerberos wasn't selected


## Notes

* SMB auth is slightly different, it sends a `NegTokenInit2` structure from the server to client that lists all the mechs it supports
* The `NegTokenInit2` structure is slightly different than `NegTokenInit` as it includes the `negHints` field at the same tag `[3]` as `mechListMIC` in `NegTokenInit`
* The client seems to ignore the first message and just starts a branch new SPNEGO exchange with `NegTokenInit` in it's first reply
* Notable it shows it's still trying to connect with an SPN `cifs/192.168.56.10` as we connected with an IP address.
* Includes the `mechListMIC` even though NTLM was the sole mech that was available in the `mechList`


## Tokens

```yaml
MessageType: SPNEGO InitialContextToken
Data:
  thisMech: SPNEGO (1.3.6.1.5.5.2)
  innerContextToken:
    MessageType: SPNEGO NegTokenInit2
    Data:
      mechTypes:
      - NEGOEX (1.3.6.1.4.1.311.2.2.30)
      - MS Kerberos (1.2.840.48018.1.2.2)
      - Kerberos (1.2.840.113554.1.2.2)
      - Kerberos User to User (1.2.840.113554.1.2.2.3)
      - NTLM (1.3.6.1.4.1.311.2.2.10)
      reqFlags:
      mechToken:
      mechListMIC:
      negHints:
        hintName: not_defined_in_RFC4178@please_ignore
        hintAddress:
    RawData: A06C306AA03C303A060A2B06010401823702021E06092A864882F71201020206092A864886F712010202060A2A864886F71201020203060A2B06010401823702020AA32A3028A0261B246E6F745F646566696E65645F696E5F5246433431373840706C656173655F69676E6F7265
RawData: 607606062B0601050502A06C306AA03C303A060A2B06010401823702021E06092A864882F71201020206092A864886F712010202060A2A864886F71201020203060A2B06010401823702020AA32A3028A0261B246E6F745F646566696E65645F696E5F5246433431373840706C656173655F69676E6F7265
```

```yaml
MessageType: SPNEGO InitialContextToken
Data:
  thisMech: SPNEGO (1.3.6.1.5.5.2)
  innerContextToken:
    MessageType: SPNEGO NegTokenInit
    Data:
      mechTypes:
      - NTLM (1.3.6.1.4.1.311.2.2.10)
      reqFlags:
      mechToken:
        MessageType: NEGOTIATE_MESSAGE (1)
        Data:
          NegotiateFlags:
            raw: 3792208535
            flags:
            - NTLMSSP_NEGOTIATE_56 (2147483648)
            - NTLMSSP_NEGOTIATE_KEY_EXCH (1073741824)
            - NTLMSSP_NEGOTIATE_128 (536870912)
            - NTLMSSP_NEGOTIATE_VERSION (33554432)
            - NTLMSSP_NEGOTIATE_EXTENDED_SESSIONSECURITY (524288)
            - NTLMSSP_NEGOTIATE_ALWAYS_SIGN (32768)
            - NTLMSSP_NEGOTIATE_NTLM (512)
            - NTLMSSP_NEGOTIATE_LM_KEY (128)
            - NTLMSSP_NEGOTIATE_SIGN (16)
            - NTLMSSP_REQUEST_TARGET (4)
            - NTLMSSP_NEGOTIATE_OEM (2)
            - NTLMSSP_NEGOTIATE_UNICODE (1)
          DomainNameFields:
            Len: 0
            MaxLen: 0
            BufferOffset: 0
          WorkstationFields:
            Len: 0
            MaxLen: 0
            BufferOffset: 0
          Version:
            Major: 10
            Minor: 0
            Build: 17763
            Reserved: '000000'
            NTLMRevision: 15
          Payload:
            DomainName:
            Workstation:
        RawData: 4E544C4D5353500001000000978208E2000000000000000000000000000000000A0063450000000F
      mechListMIC:
    RawData: A03E303CA00E300C060A2B06010401823702020AA22A04284E544C4D5353500001000000978208E2000000000000000000000000000000000A0063450000000F
RawData: 604806062B0601050502A03E303CA00E300C060A2B06010401823702020AA22A04284E544C4D5353500001000000978208E2000000000000000000000000000000000A0063450000000F
```

```yaml
MessageType: SPNEGO NegTokenResp
Data:
  negState: accept-incomplete (1)
  supportedMech: NTLM (1.3.6.1.4.1.311.2.2.10)
  responseToken:
    MessageType: CHALLENGE_MESSAGE (2)
    Data:
      TargetNameFields:
        Len: 12
        MaxLen: 12
        BufferOffset: 56
      NegotiateFlags:
        raw: 3800662549
        flags:
        - NTLMSSP_NEGOTIATE_56 (2147483648)
        - NTLMSSP_NEGOTIATE_KEY_EXCH (1073741824)
        - NTLMSSP_NEGOTIATE_128 (536870912)
        - NTLMSSP_NEGOTIATE_VERSION (33554432)
        - NTLMSSP_NEGOTIATE_TARGET_INFO (8388608)
        - NTLMSSP_NEGOTIATE_EXTENDED_SESSIONSECURITY (524288)
        - NTLMSSP_TARGET_TYPE_DOMAIN (65536)
        - NTLMSSP_NEGOTIATE_ALWAYS_SIGN (32768)
        - NTLMSSP_NEGOTIATE_NTLM (512)
        - NTLMSSP_NEGOTIATE_SIGN (16)
        - NTLMSSP_REQUEST_TARGET (4)
        - NTLMSSP_NEGOTIATE_UNICODE (1)
      ServerChallenge: 3567F0F9FCE36ED9
      Reserved: '0000000000000000'
      TargetInfoFields:
        Len: 138
        MaxLen: 138
        BufferOffset: 68
      Version:
        Major: 10
        Minor: 0
        Build: 14393
        Reserved: '000000'
        NTLMRevision: 15
      Payload:
        TargetName: DOMAIN
        TargetInfo:
        - AvId: MSV_AV_NB_DOMAIN_NAME (2)
          Value: DOMAIN
        - AvId: MSV_AV_NB_COMPUTER_NAME (1)
          Value: DC01
        - AvId: MSV_AV_DNS_DOMAIN_NAME (4)
          Value: domain.local
        - AvId: MSV_AV_DNS_COMPUTER_NAME (3)
          Value: DC01.domain.local
        - AvId: MSV_AV_DNS_TREE_NAME (5)
          Value: domain.local
        - AvId: MSV_AV_TIMESTAMP (7)
          Value: '2020-05-07T11:00:32.2331671Z'
        - AvId: MSV_AV_EOL (0)
          Value:
    RawData: 4E544C4D53535000020000000C000C0038000000158289E23567F0F9FCE36ED900000000000000008A008A00440000000A0039380000000F44004F004D00410049004E0002000C0044004F004D00410049004E000100080044004300300031000400180064006F006D00610069006E002E006C006F00630061006C000300220044004300300031002E0064006F006D00610069006E002E006C006F00630061006C000500180064006F006D00610069006E002E006C006F00630061006C0007000800171C22BA5E24D60100000000
  mechListMIC:
RawData: A181EA3081E7A0030A0101A10C060A2B06010401823702020AA281D10481CE4E544C4D53535000020000000C000C0038000000158289E23567F0F9FCE36ED900000000000000008A008A00440000000A0039380000000F44004F004D00410049004E0002000C0044004F004D00410049004E000100080044004300300031000400180064006F006D00610069006E002E006C006F00630061006C000300220044004300300031002E0064006F006D00610069006E002E006C006F00630061006C000500180064006F006D00610069006E002E006C006F00630061006C0007000800171C22BA5E24D60100000000
```

```yaml
MessageType: SPNEGO NegTokenResp
Data:
  negState: accept-incomplete (1)
  supportedMech:
  responseToken:
    MessageType: AUTHENTICATE_MESSAGE (3)
    Data:
      LmChallengeResponseFields:
        Len: 24
        MaxLen: 24
        BufferOffset: 148
      NtChallengeResponseFields:
        Len: 306
        MaxLen: 306
        BufferOffset: 172
      DomainNameFields:
        Len: 12
        MaxLen: 12
        BufferOffset: 88
      UserNameFields:
        Len: 28
        MaxLen: 28
        BufferOffset: 100
      WorkstationFields:
        Len: 20
        MaxLen: 20
        BufferOffset: 128
      EncryptedRandomSessionKeyFields:
        Len: 16
        MaxLen: 16
        BufferOffset: 478
      NegotiateFlags:
        raw: 3800597013
        flags:
        - NTLMSSP_NEGOTIATE_56 (2147483648)
        - NTLMSSP_NEGOTIATE_KEY_EXCH (1073741824)
        - NTLMSSP_NEGOTIATE_128 (536870912)
        - NTLMSSP_NEGOTIATE_VERSION (33554432)
        - NTLMSSP_NEGOTIATE_TARGET_INFO (8388608)
        - NTLMSSP_NEGOTIATE_EXTENDED_SESSIONSECURITY (524288)
        - NTLMSSP_NEGOTIATE_ALWAYS_SIGN (32768)
        - NTLMSSP_NEGOTIATE_NTLM (512)
        - NTLMSSP_NEGOTIATE_SIGN (16)
        - NTLMSSP_REQUEST_TARGET (4)
        - NTLMSSP_NEGOTIATE_UNICODE (1)
      Version:
        Major: 10
        Minor: 0
        Build: 17763
        Reserved: '000000'
        NTLMRevision: 15
      MIC: 79FF21273B3C5D1C59CF8B5D8D2DC5B7
      Payload:
        LmChallengeResponse:
          ResponseType: LMv1
          LMProofStr: '000000000000000000000000000000000000000000000000'
        NtChallengeResponse:
          ResponseType: NTLMv2
          NTProofStr: 2F48B80AC15EBB3F2DE83EEA4B8D9B9E
          ClientChallenge:
            RespType: 1
            HiRespType: 1
            Reserved1: 0
            Reserved2: 0
            TimeStamp: '2020-05-07T11:00:32.2331671Z'
            ChallengeFromClient: 7169C56794BF118A
            Reserved3: 0
            AvPairs:
            - AvId: MSV_AV_NB_DOMAIN_NAME (2)
              Value: DOMAIN
            - AvId: MSV_AV_NB_COMPUTER_NAME (1)
              Value: DC01
            - AvId: MSV_AV_DNS_DOMAIN_NAME (4)
              Value: domain.local
            - AvId: MSV_AV_DNS_COMPUTER_NAME (3)
              Value: DC01.domain.local
            - AvId: MSV_AV_DNS_TREE_NAME (5)
              Value: domain.local
            - AvId: MSV_AV_TIMESTAMP (7)
              Value: '2020-05-07T11:00:32.2331671Z'
            - AvId: MSV_AV_FLAGS (6)
              Value:
                raw: 2
                flags:
                - MIC_PROVIDED (2)
            - AvId: MSV_AV_SINGLE_HOST (8)
              Value:
                Size: 48
                Z4: 0
                CustomData: '0100000000200000'
                MachineId: 4135E6AB9D279B8D0642C048E0C1F24D0A9017A55C35B1A184872FEDFA712BDC
            - AvId: MSV_AV_CHANNEL_BINDINGS (10)
              Value: '00000000000000000000000000000000'
            - AvId: MSV_AV_TARGET_NAME (9)
              Value: cifs/192.168.56.10
            - AvId: MSV_AV_EOL (0)
              Value:
            Reserved4: 0
        DomainName: DOMAIN
        UserName: vagrant-domain
        Workstation: SERVER2019
        EncryptedRandomSessionKey: 17C42D71EBDF8C27955309C9A35F018F
      SessionKey: 6A93BEFD8D75CF8E32DB8A6870599984
    RawData: 4E544C4D5353500003000000180018009400000032013201AC0000000C000C00580000001C001C0064000000140014008000000010001000DE010000158288E20A0063450000000F79FF21273B3C5D1C59CF8B5D8D2DC5B744004F004D00410049004E00760061006700720061006E0074002D0064006F006D00610069006E0053004500520056004500520032003000310039000000000000000000000000000000000000000000000000002F48B80AC15EBB3F2DE83EEA4B8D9B9E0101000000000000171C22BA5E24D6017169C56794BF118A0000000002000C0044004F004D00410049004E000100080044004300300031000400180064006F006D00610069006E002E006C006F00630061006C000300220044004300300031002E0064006F006D00610069006E002E006C006F00630061006C000500180064006F006D00610069006E002E006C006F00630061006C0007000800171C22BA5E24D601060004000200000008003000300000000000000001000000002000004135E6AB9D279B8D0642C048E0C1F24D0A9017A55C35B1A184872FEDFA712BDC0A001000000000000000000000000000000000000900240063006900660073002F003100390032002E003100360038002E00350036002E0031003000000000000000000017C42D71EBDF8C27955309C9A35F018F
  mechListMIC: 01000000A32D4DD6161B084F00000000
RawData: A18202133082020FA0030A0101A28201F2048201EE4E544C4D5353500003000000180018009400000032013201AC0000000C000C00580000001C001C0064000000140014008000000010001000DE010000158288E20A0063450000000F79FF21273B3C5D1C59CF8B5D8D2DC5B744004F004D00410049004E00760061006700720061006E0074002D0064006F006D00610069006E0053004500520056004500520032003000310039000000000000000000000000000000000000000000000000002F48B80AC15EBB3F2DE83EEA4B8D9B9E0101000000000000171C22BA5E24D6017169C56794BF118A0000000002000C0044004F004D00410049004E000100080044004300300031000400180064006F006D00610069006E002E006C006F00630061006C000300220044004300300031002E0064006F006D00610069006E002E006C006F00630061006C000500180064006F006D00610069006E002E006C006F00630061006C0007000800171C22BA5E24D601060004000200000008003000300000000000000001000000002000004135E6AB9D279B8D0642C048E0C1F24D0A9017A55C35B1A184872FEDFA712BDC0A001000000000000000000000000000000000000900240063006900660073002F003100390032002E003100360038002E00350036002E0031003000000000000000000017C42D71EBDF8C27955309C9A35F018FA312041001000000A32D4DD6161B084F00000000
```

```yaml
MessageType: SPNEGO NegTokenResp
Data:
  negState: accept-complete (0)
  supportedMech:
  responseToken:
  mechListMIC: 01000000791F335A883B1DF000000000
RawData: A11B3019A0030A0100A312041001000000791F335A883B1DF000000000
```