---
myst:
  html_meta:
    keywords: LaTeX,franc,franc français,symbole du franc,symboles monétaires,F avec une barre,currency units
---
# Comment obtenir le symbole du franc français ?

En usage courant, le [franc français](wpfr:Franc_français) n'a pas de symbole particulier, il est simplement abrégé en **F** ou **FF**. Les deux lettres **Fr** (ou leur [ligature](/3_composition/texte/mots/desactiver_une_ligature)) sont aussi utilisées, par analogie avec le [franc suisse](wpfr:Franc_suisse).

Néanmoins, le symbole **₣** a été proposé en 1988 (et refusé) et existe dans Unicode :

```text
U+20A3 FRENCH FRANC SIGN
```

Vous pouvez donc aller le chercher par son code :

```
%!TEX engine=lualatex
\documentclass{article}
\usepackage{libertine}
\pagestyle{empty}

\begin{document}
\Large ^^^^20a3 % ASCII notation
\end{document}
```

ou, mieux, définir une unité avec <ctanpkg:siunitx> :

```
%!TEX engine=lualatex
\documentclass{article}
\usepackage{libertine}
\usepackage{siunitx}
\usepackage[french]{babel}
\pagestyle{empty}

\DeclareSIUnit{\franc}{^^^^20a3}

\begin{document}
\large Question à \qty{100}{\franc}.
\end{document}
```

Et voici quelques autres exemples :

```
\documentclass{article}
\usepackage{fontspec}
\pagestyle{empty}

\begin{document}
\fontspec{FreeSerif}
\Large ^^^^20a3
\end{document}
```

```
\documentclass{article}
\usepackage{fontspec}
\pagestyle{empty}

\begin{document}
\fontspec{Comfortaa-Regular}
\Large ^^^^20a3
\end{document}
```

:::{sources}
- [Symboles monétaires : le franc](wpfr:Symbole_monétaire#Franc),
- [French franc](wp:French_franc) (en anglais),
- [Currency symbol : French franc](https://tex.stackexchange.com/questions/103220/currency-symbol-french-franc).
:::
