/*
 This file is part of GNU Taler
 (C) 2021-2024 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */
import { h, VNode } from "preact";
import { CreatedSuccessfully } from "../../../components/notifications/CreatedSuccessfully.js";
import { Entity } from "./index.js";
import { useTranslationContext } from "@gnu-taler/web-util/browser";

export function InstanceCreatedSuccessfully({
  entity,
  onConfirm,
}: {
  entity: Entity;
  onConfirm: () => void;
}): VNode {
  const { i18n } = useTranslationContext();
  return (
    <CreatedSuccessfully onConfirm={onConfirm}>
      <div class="field is-horizontal">
        <div class="field-label is-normal">
          <label class="label">
            <i18n.Translate>ID</i18n.Translate>
          </label>
        </div>
        <div class="field-body is-flex-grow-3">
          <div class="field">
            <p class="control">
              <input class="input" readonly value={entity.id} />
            </p>
          </div>
        </div>
      </div>
      <div class="field is-horizontal">
        <div class="field-label is-normal">
          <label class="label">
            <i18n.Translate>Business Name</i18n.Translate>
          </label>
        </div>
        <div class="field-body is-flex-grow-3">
          <div class="field">
            <p class="control">
              <input class="input" readonly value={entity.name} />
            </p>
          </div>
        </div>
      </div>
    </CreatedSuccessfully>
  );
}
