#include <qdragobject.h>

#include "kdragdemo.h"


KDragDemo::KDragDemo (QWidget *parent, const char *name) :
  QLabel (parent, name)
{
  dragging = false;
  setText ("This is draggable text.");
}


void
KDragDemo::mouseMoveEvent (QMouseEvent *qmouseevent)
{
  if (!dragging && qmouseevent->state() == Qt::LeftButton)
    {
      dragging = true;
      QTextDrag *qtextdrag = new QTextDrag( text(), this);
      qtextdrag->dragCopy();
    }
}

void
KDragDemo::mouseReleaseEvent (QMouseEvent *)
{
  dragging = false;
}

