#include <qlayout.h>

#include <klocale.h>

#include "runwalk.moc"

RunWalk::RunWalk()
{
    QVBoxLayout *layout=new QVBoxLayout(this,0,2);
    layout->setAutoAdd(true);
    program=new KLineEdit("http://www.kde.org/",this);
    pushme=new QPushButton(i18n("Open File"),this);
    show();

	connect(pushme, SIGNAL(clicked()), SLOT(slotRun()));
}

void RunWalk::slotDoneExec()
{
    pushme->setEnabled(true);
    program->setEnabled(true);
}

void RunWalk::slotRun()
{
    KRun *run=new KRun(KURL(program->text()));
    connect(run, SIGNAL(finished()), SLOT(slotDoneExec()));
    connect(run, SIGNAL(error()), SLOT(slotDoneExec()));
    pushme->setEnabled(false);
    program->setEnabled(false);
}


