#include "notepad_factory.h"

#include <kdebug.h>
#include <klocale.h>
#include <kstddirs.h>
#include <kinstance.h>
#include <kaboutdata.h>

#include "notepad_part.h"

extern "C"
{
    void* init_libnotepad()
    {
	return new NotepadFactory;
    }
};

KInstance* NotepadFactory::s_instance = 0L;
KAboutData* NotepadFactory::s_about = 0L;

NotepadFactory::NotepadFactory( QObject* parent, const char* name )
    : KLibFactory( parent, name )
{
}

NotepadFactory::~NotepadFactory()
{
  delete s_instance;
  delete s_about;
}

QObject* NotepadFactory::create( QObject* parent, const char* name, const char* classname, const QStringList & )
{
  if ( parent && !parent->inherits("QWidget") )
  {
    kdError() << "NotepadFactory: parent does not inherit QWidget" << endl;
    return 0L;
  }

  NotepadPart* part = new NotepadPart( (QWidget*) parent, name );
  // readonly ?
  if (QCString(classname) == "KParts::ReadOnlyPart")
     part->setReadWrite(false);

  // otherwise, it has to be readwrite
  else if (QCString(classname) != "KParts::ReadWritePart")
  {
    kdError() << "NotepadFactory: classname isn't ReadOnlyPart nor ReadWritePart but " << classname << "!" << endl;
    return 0L;
  }

  emit objectCreated( part );
  return part;
}

KInstance* NotepadFactory::instance()
{
  if( !s_instance )
  {
    s_about = new KAboutData( "notepadpart", I18N_NOOP( "Notepad" ), "2.0pre" );
    s_instance = new KInstance( s_about );
  }
  return s_instance;
}

#include "notepad_factory.moc"
