/***************************************************************************
 *   Copyright (C) 2010 by SIDDHARTH SHARMA siddharth.kde@gmail.com        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGDATAENGINE_H
#define SKGDATAENGINE_H

#include <Plasma/DataEngine>

#include "skgdocument.h"
#include "skgdocumentbank.h"

/**
 * This class is the skrooge dataengine. It allows fetching data
 * from a skrooge document, by sending SQL orders to the underlying
 * SQLite database
 */
class SKGDataEngine : public Plasma::DataEngine
{
    Q_OBJECT

public:
    /**
     * Reimplemented from Plasma::DataEngine
     */
    SKGDataEngine(QObject* iParent, const QVariantList& args);

    /**
     * Destructor
     */
    virtual ~SKGDataEngine();


    /**
     * Reimplemented from Plasma::DataEngine
     */
    virtual void init();

protected:

    /**
     * Reimplemented from Plasma::DataEngine
     * @param iSource the source
     */
    virtual bool updateSourceEvent(const QString& iSource);

    /**
     * Reimplemented from Plasma::DataEngine
     * @param iSource the source
     */
    virtual bool sourceRequestEvent(const QString& iSource);

    /**
     * Sets the Document to use
     * @param iDocument the document
     */
    virtual void setDocument(SKGDocumentBank* iDocument);

    /**
     * Returns the current document
     * @return the document
     */
    virtual SKGDocumentBank* getDocument() const;

    /**
     * Get some basic data on Accounts
     */
    virtual bool getAccountData();

    /**
     * Get Income and Expenditure Data
     */
    virtual bool getIncomeExpenditureData();

    /**
     * Get Highlighted operations
     */
    virtual bool getHighlightedOperationData();

    /**
     * Get Scheduled operations
     */
    virtual bool getScheduledOperationData();

    /**
     * Get data on Units
     */
    virtual bool getUnitsData();

    /**
     * Get data on Advice
     */
    virtual bool getAdviceData();

    /**
     * Get data on Interests
     */
    virtual bool getInterestsData();

    /**
     * Get data on Alarms
     */
    virtual bool getAlarmsData();

    /**
     * Reimplemented from Plasma::DataEngine
     */
    virtual QStringList sources() const;


private:
    Q_DISABLE_COPY(SKGDataEngine)

    /**
     * The document used to retrieve data
     */
    SKGDocumentBank* document;

};

#endif // SKGDATAENGINE_H
