/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGSIMPLEPERIODEDIT_H
#define SKGSIMPLEPERIODEDIT_H
/** @file
 * A simple period selector.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */

#include <QDate>

#include "skgcombobox.h"
#include "skgbasegui_export.h"
/**
 * This file is a simple period selector.
 */
class SKGBASEGUI_EXPORT SKGSimplePeriodEdit : public SKGComboBox
{
    Q_OBJECT
    /**
     * First date
     */
    Q_PROPERTY(QDate firstDate READ firstDate WRITE setFirstDate USER true)

    /**
     * Previous mode
     */
    Q_PROPERTY(Mode mode READ mode WRITE setMode)

    /**
     * Period
     */
    Q_PROPERTY(QString period READ period)

    /**
     * This enumerate for additional options in menu
     */
    Q_ENUMS(Mode)
public:
    /**
     * This enumerate for mode
     */
    enum Mode {PREVIOUS_MONTHS,   /**< Only previous months */
               PREVIOUS_PERIODS,  /**< All previous periods including quarters, semesters and years*/
               PREVIOUS_AND_CURRENT_MONTHS, /**< Previous and current months*/
               PREVIOUS_AND_CURRENT_PERIODS /**< Previous and current periods including quarters, semesters and years*/
              };
    /**
     * Default Constructor
     * @param iParent the parent
     */
    explicit SKGSimplePeriodEdit(QWidget* iParent = 0);

    /**
     * Default Destructor
     */
    virtual ~SKGSimplePeriodEdit();

    /**
     * Get the period
     * @return the period
     */
    virtual QString period() const;

    /**
     * Get the first date to take into account
     * @return the first date to take into account
     */
    virtual QDate firstDate() const;

    /**
     * Set the first date to take into account
     * @param iDate the first date to take into account
     */
    virtual void setFirstDate(const QDate& iDate);

    /**
     * To know if the mode of widget (default: PREVIOUS_MONTHS)
     * @return previous mode
     */
    virtual Mode mode() const;

    /**
     * Set the widget mode
     * @param iMode the mode
     */
    virtual void setMode(Mode iMode);

private:
    QDate m_FirstDate;
    Mode m_Mode;

    void refreshList();
};

#endif  // SKGSIMPLEPERIODEDIT_H
