/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.internal.plugins;

import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Rule;
import org.gradle.api.Task;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.TaskContainer;

public class CleanRule
implements Rule {
    public static final String CLEAN = "clean";
    private final TaskContainer tasks;

    public CleanRule(TaskContainer tasks) {
        this.tasks = tasks;
    }

    public String getDescription() {
        return "Pattern: clean<TaskName>: Cleans the output files of a task.";
    }

    public String toString() {
        return "Rule: " + this.getDescription();
    }

    public void apply(String taskName) {
        if (!taskName.startsWith(CLEAN) || taskName.equals(CLEAN)) {
            return;
        }
        String targetTaskName = taskName.substring(CLEAN.length());
        if (Character.isLowerCase(targetTaskName.charAt(0))) {
            return;
        }
        Task task = (Task)this.tasks.findByName(StringUtils.uncapitalize((String)targetTaskName));
        if (task == null) {
            return;
        }
        Delete clean = (Delete)this.tasks.create(taskName, Delete.class);
        clean.delete(new Object[]{task.getOutputs().getFiles()});
    }
}

