/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.dialog;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ChoiceItem;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.dialog.FreeColDialog;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.plaf.FreeColComboBoxRenderer;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.pathfinding.GoalDeciders;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;

public final class SelectDestinationDialog
extends FreeColDialog<Location>
implements ListSelectionListener {
    private static final Logger logger = Logger.getLogger(SelectDestinationDialog.class.getName());
    private static final int CELL_HEIGHT = 48;
    private static AtomicBoolean showOnlyMyColonies = new AtomicBoolean(true);
    private static AtomicReference<Comparator<Destination>> destinationComparator = new AtomicReference<Object>(null);
    private final List<Destination> destinations = new ArrayList<Destination>();
    private final JList<Destination> destinationList;
    private JCheckBox onlyMyColoniesBox;
    private JComboBox<String> comparatorBox;

    public SelectDestinationDialog(FreeColClient freeColClient, JFrame frame, Unit unit) {
        super(freeColClient, frame);
        ImageLibrary lib = this.getImageLibrary();
        List<GoodsType> goodsTypes = CollectionUtils.transform(unit.getCompactGoodsList(), CollectionUtils.alwaysTrue(), AbstractGoods::getType);
        this.loadDestinations(unit, goodsTypes);
        DefaultListModel model = new DefaultListModel();
        this.destinationList = new JList(model);
        this.destinationList.setCellRenderer(new LocationRenderer(lib));
        this.destinationList.setFixedCellHeight(48);
        this.destinationList.setSelectionMode(0);
        this.destinationList.addListSelectionListener(this);
        this.destinationList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                Destination d = SelectDestinationDialog.this.destinationList.getSelectedValue();
                if (d != null) {
                    SelectDestinationDialog.this.setValue(CollectionUtils.first(SelectDestinationDialog.this.options));
                }
            }
        });
        this.updateDestinationList();
        JScrollPane listScroller = new JScrollPane(this.destinationList);
        listScroller.setPreferredSize(new Dimension(300, 300));
        String omcb = Messages.message("selectDestinationDialog.onlyMyColonies");
        this.onlyMyColoniesBox = new JCheckBox(omcb, showOnlyMyColonies.get());
        this.onlyMyColoniesBox.addChangeListener(event -> {
            showOnlyMyColonies.set(this.onlyMyColoniesBox.isSelected());
            this.updateDestinationList();
        });
        this.comparatorBox = new JComboBox<String>(new String[]{Messages.message("selectDestinationDialog.sortByOwner"), Messages.message("selectDestinationDialog.sortByName"), Messages.message("selectDestinationDialog.sortByDistance")});
        this.comparatorBox.addItemListener(event -> {
            this.updateDestinationComparator();
            Comparator<Destination> dc = this.getDestinationComparator();
            this.destinations.sort(dc);
            this.updateDestinationList();
        });
        Comparator<Destination> dc = this.getDestinationComparator();
        this.comparatorBox.setSelectedIndex(Destination.getDestinationComparatorIndex(dc));
        MigPanel panel = new MigPanel(new MigLayout("wrap 1, fill", "[align center]", ""));
        panel.add(Utility.localizedHeader("selectDestinationDialog.text", Utility.FONTSPEC_SUBTITLE));
        panel.add((Component)listScroller, "newline 30, growx, growy");
        panel.add((Component)this.onlyMyColoniesBox, "left");
        panel.add(this.comparatorBox, "left");
        panel.setSize(panel.getPreferredSize());
        List c = SelectDestinationDialog.choices();
        c.add(new ChoiceItem<Location>(Messages.message("ok"), null).okOption());
        c.add(new ChoiceItem<Location>(Messages.message("selectDestinationDialog.cancel"), null).cancelOption().defaultOption());
        this.initializeDialog(frame, FreeColDialog.DialogType.QUESTION, true, panel, new ImageIcon(lib.getSmallUnitImage(unit)), c);
    }

    private Comparator<Destination> getDestinationComparator() {
        Comparator<Destination> ret = destinationComparator.get();
        if (ret == null) {
            ret = Destination.getDestinationComparator(0);
            destinationComparator.set(ret);
        }
        return ret;
    }

    private void setDestinationComparator(Comparator<Destination> dc) {
        destinationComparator.set(dc);
    }

    private void loadDestinations(Unit unit, List<GoodsType> goodsTypes) {
        int turns;
        if (unit.isInEurope() && !unit.getType().canMoveToHighSeas()) {
            return;
        }
        Player player = unit.getOwner();
        Settlement inSettlement = unit.getSettlement();
        boolean canTrade = player.hasAbility("model.ability.tradeWithForeignColonies");
        Europe europe = player.getEurope();
        Game game = this.getGame();
        Map map = game.getMap();
        Predicate<Settlement> canReach = s -> unit.isNaval() ? s.isConnectedPort() : Map.isSameContiguity(unit.getLocation(), s.getTile());
        ArrayList<Destination> td = new ArrayList<Destination>();
        if (unit.isInEurope()) {
            td.add(new Destination(map, unit.getSailTurns(), unit, goodsTypes));
        } else if (europe != null && player.canMoveToEurope() && unit.getType().canMoveToHighSeas() && (turns = unit.getTurnsToReach(europe)) < 10000) {
            td.add(new Destination(europe, turns, unit, goodsTypes));
        }
        td.addAll(CollectionUtils.transform(player.getSettlements(), s -> s != inSettlement && canReach.test((Settlement)s), s -> new Destination((Location)s, unit.getTurnsToReach((Location)s), unit, goodsTypes)));
        Predicate<Player> tradePred = p -> p.hasContacted(player) && (canTrade || !p.isEuropean());
        Function<Player, Stream> settlementTileMapper = p -> CollectionUtils.transform(p.getSettlements(), s -> canReach.test((Settlement)s) && s.hasContacted((Player)p), s -> s.getTile()).stream();
        List<Location> locs = CollectionUtils.toList(CollectionUtils.flatten(game.getLivePlayers(player), tradePred, settlementTileMapper));
        GoalDeciders.MultipleAdjacentDecider md = new GoalDeciders.MultipleAdjacentDecider(locs);
        unit.search(unit.getLocation(), md.getGoalDecider(), null, Integer.MAX_VALUE, null);
        Function<Map.Entry, Destination> dmapper = e -> {
            Settlement s = ((Location)e.getKey()).getTile().getSettlement();
            PathNode p = (PathNode)e.getValue();
            if (s == null) {
                logger.warning("BR#3149 null settlement: " + Messages.message(((Location)e.getKey()).getLocationLabel()) + " path=" + p.fullPathToString());
                return null;
            }
            int turns = p.getTotalTurns();
            if (unit.isInEurope()) {
                turns += unit.getSailTurns();
            }
            if (p.getMovesLeft() < unit.getInitialMovesLeft()) {
                ++turns;
            }
            return new Destination(s, turns, unit, goodsTypes);
        };
        td.addAll(CollectionUtils.transform(md.getResults().entrySet(), CollectionUtils.isNotNull(), dmapper));
        this.destinations.addAll(CollectionUtils.transform(td, d -> d.turns < 10000, Function.identity(), this.getDestinationComparator()));
    }

    private void updateDestinationList() {
        Player player = this.getMyPlayer();
        Destination selected = this.destinationList.getSelectedValue();
        DefaultListModel<Destination> model = new DefaultListModel<Destination>();
        for (Destination d : this.destinations) {
            if (showOnlyMyColonies.get()) {
                if (!(d.location instanceof Europe) && !(d.location instanceof Map) && (!(d.location instanceof Colony) || !player.owns((Colony)d.location))) continue;
                model.addElement(d);
                continue;
            }
            model.addElement(d);
        }
        this.destinationList.setModel(model);
        this.destinationList.setSelectedValue(selected, true);
        if (this.destinationList.getSelectedIndex() < 0) {
            this.destinationList.setSelectedIndex(0);
        }
        this.recenter(this.destinationList.getSelectedValue());
    }

    private void recenter(Destination destination) {
        if (destination != null && destination.location.getTile() != null) {
            this.getGUI().setFocus(destination.location.getTile());
        }
    }

    private void updateDestinationComparator() {
        this.setDestinationComparator(Destination.getDestinationComparator(this.comparatorBox.getSelectedIndex()));
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.recenter(this.destinationList.getSelectedValue());
    }

    @Override
    public Location getResponse() {
        Destination d;
        Object value = this.getValue();
        if (((ChoiceItem)this.options.get(0)).equals(value) && (d = this.destinationList.getSelectedValue()) != null) {
            return d.location;
        }
        return null;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeAll();
        this.destinations.clear();
        this.onlyMyColoniesBox = null;
        this.comparatorBox = null;
    }

    @Override
    public void requestFocus() {
        this.destinationList.requestFocus();
    }

    private static class LocationRenderer
    extends FreeColComboBoxRenderer<Destination> {
        private final ImageLibrary lib;

        public LocationRenderer(ImageLibrary lib) {
            this.lib = lib;
        }

        @Override
        public void setLabelValues(JLabel label, Destination value) {
            label.setText(value.text);
            String key = value.location.getLocationImageKey();
            label.setIcon(new ImageIcon(this.lib.getSizedImage(key, new Dimension(-1, 48))));
        }
    }

    private static class Destination {
        private static Comparator<Destination> nameComparator = new Comparator<Destination>(){

            @Override
            public int compare(Destination d1, Destination d2) {
                if (!(d1.location instanceof Settlement)) {
                    return -1;
                }
                if (!(d2.location instanceof Settlement)) {
                    return 1;
                }
                return d1.name.compareTo(d2.name);
            }
        };
        private static Comparator<Destination> distanceComparator = Comparator.comparingInt(Destination::getTurns).thenComparing(nameComparator);
        private static Comparator<Destination> ownerComparator = Comparator.comparingInt(Destination::getScore).thenComparing(nameComparator);
        public final Unit unit;
        public final Location location;
        public final String name;
        public final int turns;
        public final String extras;
        public final int score;
        public final String text;

        public Destination(Location location, int turns, Unit unit, List<GoodsType> goodsTypes) {
            this.unit = unit;
            this.location = location;
            this.name = Messages.message(location.getLocationLabelFor(unit.getOwner()));
            this.turns = turns;
            this.extras = this.getExtras(location, unit, goodsTypes);
            this.score = this.calculateScore();
            this.text = Messages.message(((StringTemplate)((StringTemplate)StringTemplate.template("selectDestinationDialog.destinationTurns").addName("%location%", this.name)).addAmount("%turns%", this.turns)).addName("%extras%", this.extras));
        }

        private String getExtras(Location loc, Unit unit, List<GoodsType> goodsTypes) {
            String sep = ", ";
            Player owner = unit.getOwner();
            LogBuilder lb = new LogBuilder(32);
            boolean dropSep = false;
            if (loc instanceof IndianSettlement && ((IndianSettlement)loc).hasMissionary(owner)) {
                lb.add(ResourceManager.getString("cross"));
            }
            if (loc instanceof Europe && !goodsTypes.isEmpty()) {
                Market market = owner.getMarket();
                for (GoodsType goodsType : goodsTypes) {
                    lb.add(Messages.getName(goodsType), " ", market.getSalePrice(goodsType, 1), ", ");
                    dropSep = true;
                }
            } else if (!(loc instanceof Settlement) || !owner.owns((Settlement)loc)) {
                if (loc instanceof Settlement && ((Settlement)loc).getOwner().atWarWith(owner)) {
                    lb.add("[", Messages.getName(Stance.WAR), "]");
                } else if (loc instanceof Settlement) {
                    IndianSettlement is;
                    UnitType sk;
                    if (loc instanceof IndianSettlement && (sk = (is = (IndianSettlement)loc).getLearnableSkill()) != null) {
                        Unit up;
                        Predicate<Unit> upgradePred = u -> u.getUnitChange("model.unitChange.natives") != null;
                        Unit unit2 = unit.isCarrier() ? CollectionUtils.find(unit.getUnits(), upgradePred) : (up = upgradePred.test(unit) ? unit : null);
                        if (up != null) {
                            lb.add("[", Messages.getName(sk), "]");
                        }
                    }
                    if (!goodsTypes.isEmpty()) {
                        for (GoodsType g : goodsTypes) {
                            String sale = owner.getLastSaleString(loc, g);
                            String more = null;
                            if (loc instanceof IndianSettlement) {
                                IndianSettlement is2 = (IndianSettlement)loc;
                                String string = g == is2.getWantedGoods(0) ? "***" : (g == is2.getWantedGoods(1) ? "**" : (more = g == is2.getWantedGoods(2) ? "*" : null));
                            }
                            if (sale == null || more == null) continue;
                            lb.add(Messages.getName(g), " ", sale, more, ", ");
                            dropSep = true;
                        }
                    }
                }
            }
            if (dropSep) {
                lb.shrink(", ");
            }
            return lb.toString();
        }

        private int calculateScore() {
            return this.location instanceof Europe || this.location instanceof Map ? 10 : (this.location instanceof Colony ? (this.unit.getOwner().owns((Colony)this.location) ? 20 : 30) : (this.location instanceof IndianSettlement ? 40 : 100));
        }

        public int getTurns() {
            return this.turns;
        }

        public int getScore() {
            return this.score;
        }

        public static int getDestinationComparatorIndex(Comparator<Destination> dc) {
            return dc == nameComparator ? 1 : (dc == distanceComparator ? 2 : 0);
        }

        public static Comparator<Destination> getDestinationComparator(int index) {
            return index == 1 ? nameComparator : (index == 2 ? distanceComparator : ownerComparator);
        }
    }
}

