/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.generator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.ToIntFunction;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Area;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.EuropeanNationType;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.RandomUtils;
import net.sf.freecol.server.model.ServerBuilding;
import net.sf.freecol.server.model.ServerColony;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;

class EuropeanStartingPositionsGenerator {
    private static final Logger logger = Logger.getLogger(EuropeanStartingPositionsGenerator.class.getName());
    private final Random random;

    EuropeanStartingPositionsGenerator(Random random) {
        this.random = random;
    }

    void createEuropeanUnits(Map map, List<Player> players) {
        List<Player> europeanPlayers = players.stream().filter(p -> p.isEuropean() && !p.isREF()).collect(Collectors.toList());
        if (europeanPlayers.isEmpty()) {
            throw new RuntimeException("No players to generate units for!");
        }
        Collections.shuffle(europeanPlayers, this.random);
        java.util.Map<Player, StartingUnits> playerStartingUnits = this.determineStartingUnits(europeanPlayers);
        java.util.Map<Player, Tile> playerStartingTiles = this.determineStartingTiles(map, europeanPlayers, playerStartingUnits);
        for (Player player : europeanPlayers) {
            Tile start = playerStartingTiles.get(player);
            StartingUnits startingUnits = playerStartingUnits.get(player);
            this.placeUnitsAtStartingLocation(player, start, startingUnits);
        }
    }

    private java.util.Map<Player, StartingUnits> determineStartingUnits(List<Player> europeanPlayers) {
        HashMap<Player, StartingUnits> playerStartingUnits = new HashMap<Player, StartingUnits>();
        for (Player player : europeanPlayers) {
            playerStartingUnits.put(player, new StartingUnits(player, this.random));
        }
        return playerStartingUnits;
    }

    private java.util.Map<Player, Tile> determineStartingTiles(Map map, List<Player> europeanPlayers, java.util.Map<Player, StartingUnits> playerStartingUnits) {
        Specification spec = map.getSpecification();
        Game game = map.getGame();
        boolean mapDefinedStartingPositionsAvailable = this.isMapDefinedStartingPositionsAvailableFor(europeanPlayers, game);
        if (!mapDefinedStartingPositionsAvailable) {
            return this.determineStartingTilesWithoutUsingPredeterminedPositions(map, europeanPlayers, playerStartingUnits);
        }
        java.util.Map<Player, Tile> startingPositions = this.determineStartingTilesUsingMapDefinedPositions(europeanPlayers, playerStartingUnits, game);
        if (startingPositions.size() < playerStartingUnits.size()) {
            logger.info("Unable to use map defined starting positions - possibly caused by overlapping nation areas.");
            return this.determineStartingTilesWithoutUsingPredeterminedPositions(map, europeanPlayers, playerStartingUnits);
        }
        return startingPositions;
    }

    private java.util.Map<Player, Tile> determineStartingTilesUsingMapDefinedPositions(List<Player> europeanPlayers, java.util.Map<Player, StartingUnits> playerStartingUnits, Game game) {
        Specification spec = game.getSpecification();
        int positionType = spec.getInteger("model.option.startingPositions");
        switch (positionType) {
            case 0: {
                return this.playerMapStartingAreaAndEnsureDistance(europeanPlayers, playerStartingUnits, game);
            }
            case 1: {
                return this.randomMapStartingArea(europeanPlayers, playerStartingUnits, game);
            }
            case 2: {
                return this.playerMapStartingArea(europeanPlayers, playerStartingUnits, game);
            }
        }
        throw new IllegalStateException("Unknown positionType=" + positionType);
    }

    private java.util.Map<Player, Tile> playerMapStartingAreaAndEnsureDistance(List<Player> europeanPlayers, java.util.Map<Player, StartingUnits> playerStartingUnits, Game game) {
        int MINIMUM_DISTANCE_BETWEEN_PLAYERS = 10;
        int MAX_TRIES = 10;
        for (int i = 0; i < 10; ++i) {
            java.util.Map<Player, Tile> startingTiles = this.playerMapStartingArea(europeanPlayers, playerStartingUnits, game);
            boolean satisfiesMinimumDistance = startingTiles.values().stream().noneMatch(t -> startingTiles.values().stream().anyMatch(t2 -> t != t2 && t.getDistanceTo((Tile)t2) < 10));
            if (!satisfiesMinimumDistance) continue;
            return startingTiles;
        }
        logger.info("Not able to secure minimum starting distance between European players.");
        return this.playerMapStartingArea(europeanPlayers, playerStartingUnits, game);
    }

    private java.util.Map<Player, Tile> playerMapStartingArea(List<Player> europeanPlayers, java.util.Map<Player, StartingUnits> playerStartingUnits, Game game) {
        HashMap<Player, Tile> startingTiles = new HashMap<Player, Tile>();
        block0: for (Player player : europeanPlayers) {
            StartingUnits startingUnits = playerStartingUnits.get(player);
            boolean prefersLand = startingUnits.getCarriers().isEmpty();
            Area startingArea = game.getNationStartingArea(player.getNation());
            List<Object> possibleStartingTiles = startingArea.getTiles().stream().filter(t -> t.isLand() == prefersLand).collect(Collectors.toList());
            if (possibleStartingTiles.isEmpty()) {
                possibleStartingTiles = startingArea.getTiles();
            }
            while (!possibleStartingTiles.isEmpty()) {
                int randomIndex = this.random.nextInt(possibleStartingTiles.size());
                Tile startingTile = (Tile)possibleStartingTiles.get(randomIndex);
                if (!startingTiles.values().contains(startingTile)) {
                    startingTiles.put(player, startingTile);
                    continue block0;
                }
                possibleStartingTiles.remove(randomIndex);
            }
        }
        return startingTiles;
    }

    private java.util.Map<Player, Tile> randomMapStartingArea(List<Player> europeanPlayers, java.util.Map<Player, StartingUnits> playerStartingUnits, Game game) {
        HashMap<Player, Tile> startingTiles = new HashMap<Player, Tile>();
        HashSet<Tile> tilesToChooseFrom = new HashSet<Tile>();
        for (Player player : europeanPlayers) {
            Area startingArea = game.getNationStartingArea(player.getNation());
            if (startingArea == null) continue;
            tilesToChooseFrom.addAll(startingArea.getTiles());
        }
        List randomLandTilesToChooseFrom = tilesToChooseFrom.stream().filter(t -> t.isLand()).collect(Collectors.toList());
        Collections.shuffle(randomLandTilesToChooseFrom, this.random);
        int indexLand = 0;
        List randomOceanTilesToChooseFrom = tilesToChooseFrom.stream().filter(t -> !t.isLand()).collect(Collectors.toList());
        Collections.shuffle(randomOceanTilesToChooseFrom, this.random);
        int indexOcean = 0;
        for (Player player : europeanPlayers) {
            Tile startingTile;
            StartingUnits startingUnits = playerStartingUnits.get(player);
            boolean prefersLand = startingUnits.getCarriers().isEmpty();
            if (prefersLand && indexLand < randomLandTilesToChooseFrom.size()) {
                startingTile = (Tile)randomLandTilesToChooseFrom.get(indexLand);
                ++indexLand;
            } else if (!prefersLand && indexOcean < randomOceanTilesToChooseFrom.size()) {
                startingTile = (Tile)randomOceanTilesToChooseFrom.get(indexOcean);
                ++indexOcean;
            } else if (indexLand < randomLandTilesToChooseFrom.size()) {
                startingTile = (Tile)randomLandTilesToChooseFrom.get(indexLand);
                ++indexLand;
            } else {
                startingTile = (Tile)randomOceanTilesToChooseFrom.get(indexOcean);
                ++indexOcean;
            }
            startingTiles.put(player, startingTile);
        }
        return startingTiles;
    }

    private boolean isMapDefinedStartingPositionsAvailableFor(List<Player> europeanPlayers, Game game) {
        Specification spec = game.getSpecification();
        boolean mapDefinedStartingPositions = spec.getBoolean("model.option.mapDefinedStartingPositions");
        int positionType = spec.getInteger("model.option.startingPositions");
        int numAreas = 0;
        if (mapDefinedStartingPositions) {
            for (Player player : europeanPlayers) {
                Area area = game.getNationStartingArea(player.getNation());
                if (area == null || area.getTiles().isEmpty()) {
                    logger.info("No map defined starting area for: " + player.getNationId());
                    if (positionType != 0 && positionType != 2) continue;
                    break;
                }
                ++numAreas;
            }
        }
        if (numAreas < europeanPlayers.size()) {
            mapDefinedStartingPositions = false;
        }
        return mapDefinedStartingPositions;
    }

    private java.util.Map<Player, Tile> determineStartingTilesWithoutUsingPredeterminedPositions(Map map, List<Player> europeanPlayers, java.util.Map<Player, StartingUnits> playerStartingUnits) {
        Specification spec = map.getSpecification();
        int positionType = spec.getInteger("model.option.startingPositions");
        int number = europeanPlayers.size();
        ArrayList<Tile> eastTiles = new ArrayList<Tile>();
        ArrayList<Tile> westTiles = new ArrayList<Tile>();
        ArrayList<Tile> eastLandTiles = new ArrayList<Tile>();
        ArrayList<Tile> westLandTiles = new ArrayList<Tile>();
        ArrayList<Tile> eastSeaTiles = new ArrayList<Tile>();
        ArrayList<Tile> westSeaTiles = new ArrayList<Tile>();
        map.collectStartingTiles(eastTiles, westTiles);
        for (Tile t : eastTiles) {
            if (t.isLand()) {
                eastLandTiles.add(t);
                continue;
            }
            eastSeaTiles.add(t);
        }
        for (Tile t : westTiles) {
            if (t.isLand()) {
                westLandTiles.add(t);
                continue;
            }
            westSeaTiles.add(t);
        }
        switch (positionType) {
            case 0: {
                this.sampleTiles(eastLandTiles, number);
                this.sampleTiles(eastSeaTiles, number);
                this.sampleTiles(westLandTiles, number);
                this.sampleTiles(westSeaTiles, number);
                break;
            }
            case 1: {
                eastLandTiles.addAll(westLandTiles);
                eastSeaTiles.addAll(westSeaTiles);
                this.sampleTiles(eastLandTiles, number);
                this.sampleTiles(eastSeaTiles, number);
                break;
            }
        }
        HashMap<Player, Tile> playerStartingTiles = new HashMap<Player, Tile>();
        for (Player player : europeanPlayers) {
            boolean startEast = player.getNation().getStartsOnEastCoast();
            boolean startAtSea = !playerStartingUnits.get(player).getCarriers().isEmpty();
            Tile start = null;
            switch (positionType) {
                case 0: {
                    start = (Tile)(startAtSea ? (startEast ? eastSeaTiles : westSeaTiles) : (startEast ? eastLandTiles : westLandTiles)).remove(0);
                    break;
                }
                case 1: {
                    start = (Tile)(startAtSea ? eastSeaTiles : eastLandTiles).remove(0);
                    break;
                }
                case 2: {
                    Tile tile = start = startAtSea ? this.findHistoricalStartingPosition(player, map, eastSeaTiles, westSeaTiles) : this.findHistoricalStartingPosition(player, map, eastLandTiles, westLandTiles);
                }
            }
            if (start == null) {
                throw new RuntimeException("Failed to find start tile " + (startAtSea ? "at sea" : "on land") + " for player " + player);
            }
            playerStartingTiles.put(player, start);
        }
        return playerStartingTiles;
    }

    private void placeUnitsAtStartingLocation(Player player, Tile start, StartingUnits startingUnits) {
        Player ourREF;
        Map map = player.getGame().getMap();
        Specification spec = map.getSpecification();
        player.setEntryTile(start);
        Europe europe = player.getEurope();
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (!start.isLand()) {
            for (Unit u : startingUnits.getCarriers()) {
                u.setLocation(start);
                serverPlayer.exploreForUnit(u);
            }
            block1: for (Unit unit : startingUnits.getPassengers()) {
                for (Unit carrier : startingUnits.getCarriers()) {
                    if (!carrier.canAdd(unit)) continue;
                    unit.setLocation(carrier);
                    continue block1;
                }
                unit.setLocation(europe);
            }
            for (Unit u : startingUnits.getOtherNaval()) {
                u.setLocation(start);
                serverPlayer.exploreForUnit(u);
            }
        } else {
            for (Unit u : startingUnits.getPassengers()) {
                u.setLocation(start);
                serverPlayer.exploreForUnit(u);
            }
            for (Unit u : startingUnits.getOtherNaval()) {
                u.setLocation(europe);
            }
        }
        if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.INIT)) {
            this.createDebugUnits(map, player, start);
            spec.setInteger("model.option.startingMoney", 10000);
        }
        if ((ourREF = player.getREFPlayer()) == null) {
            return;
        }
        int distance = 10;
        List refTiles = StreamSupport.stream(map.getCircleTiles(start, true, 10).spliterator(), false).filter(t -> !t.isLand()).collect(Collectors.toList());
        Tile startRef = (Tile)RandomUtils.getRandomMember(logger, ourREF + " start", refTiles, this.random);
        ourREF.setEntryTile(startRef);
    }

    private Tile findHistoricalStartingPosition(Player player, Map map, List<Tile> east, List<Tile> west) {
        List<Tile> tiles;
        Nation nation = player.getNation();
        int latY = map.getRow(nation.getPreferredLatitude());
        List<Tile> list = tiles = nation.getStartsOnEastCoast() ? east : west;
        if (tiles.isEmpty()) {
            return null;
        }
        ToIntFunction<Tile> dist = t -> Math.abs(t.getY() - latY);
        Comparator<Tile> closest = Comparator.comparingInt(dist);
        Tile ret = CollectionUtils.minimize(tiles, closest);
        tiles.remove(ret);
        return ret;
    }

    private boolean sampleTiles(List<Tile> tiles, int number) {
        int n = tiles.size();
        int step = n / number;
        if (step <= 1) {
            tiles.clear();
            return false;
        }
        ArrayList<Tile> samples = new ArrayList<Tile>();
        for (int i = step / 2; i < n; i += step) {
            samples.add(tiles.get(i));
        }
        tiles.clear();
        tiles.addAll(samples);
        RandomUtils.randomShuffle(logger, "Starting tiles", tiles, this.random);
        return true;
    }

    private List<Unit> createDebugUnits(Map map, Player player, Tile startTile) {
        Iterator<TileType> iterator;
        Game game = map.getGame();
        Specification spec = game.getSpecification();
        ArrayList<Unit> ret = new ArrayList<Unit>(20);
        UnitType unitType = spec.getUnitType("model.unit.galleon");
        ServerUnit galleon = new ServerUnit(game, startTile, player, unitType);
        galleon.setName(player.getNameForUnit(unitType, this.random));
        ret.add(galleon);
        unitType = spec.getUnitType("model.unit.privateer");
        ServerUnit privateer = new ServerUnit(game, startTile, player, unitType);
        ret.add(privateer);
        privateer.setName(player.getNameForUnit(unitType, this.random));
        ((ServerPlayer)player).exploreForUnit(privateer);
        unitType = spec.getUnitType("model.unit.freeColonist");
        ret.add(new ServerUnit(game, galleon, player, unitType));
        unitType = spec.getUnitType("model.unit.veteranSoldier");
        ret.add(new ServerUnit(game, galleon, player, unitType));
        unitType = spec.getUnitType("model.unit.jesuitMissionary");
        ret.add(new ServerUnit(game, galleon, player, unitType));
        Tile colonyTile = null;
        for (Tile tempTile : map.getCircleTiles(startTile, true, Integer.MAX_VALUE)) {
            if (tempTile.isPolar() || !player.canClaimToFoundSettlement(tempTile)) continue;
            colonyTile = tempTile;
            break;
        }
        if (colonyTile == null) {
            return ret;
        }
        colonyTile.setType(CollectionUtils.find(spec.getTileTypeList(), t -> !t.isWater()));
        unitType = spec.getUnitType("model.unit.expertFarmer");
        ServerUnit buildColonyUnit = new ServerUnit(game, colonyTile, player, unitType);
        ret.add(buildColonyUnit);
        String colonyName = Messages.message(player.getNationLabel()) + " " + Messages.message("Colony");
        ServerColony colony = new ServerColony(game, player, colonyName, colonyTile);
        player.addSettlement(colony);
        colony.placeSettlement(true);
        for (Tile tile : CollectionUtils.transform(colonyTile.getSurroundingTiles(1, 1), t -> !t.hasSettlement() && (t.getOwner() == null || !t.getOwner().isEuropean()))) {
            tile.changeOwnership(player, colony);
            if (!tile.hasLostCityRumour()) continue;
            tile.removeLostCityRumour();
        }
        buildColonyUnit.setLocation(colony);
        Tile ct = buildColonyUnit.getWorkTile();
        if (ct != null && (iterator = CollectionUtils.transform(spec.getTileTypeList(), tt -> !tt.isWater()).iterator()).hasNext()) {
            TileType t2 = iterator.next();
            ct.setType(t2);
            TileImprovementType plowType = map.getSpecification().getTileImprovementType("model.improvement.plow");
            TileImprovement plow = new TileImprovement(game, ct, plowType, null);
            plow.setTurnsToComplete(0);
            ct.add(plow);
        }
        BuildingType buildingType = spec.getBuildingType("model.building.schoolhouse");
        ServerBuilding schoolhouse = new ServerBuilding(game, colony, buildingType);
        colony.addBuilding(schoolhouse);
        unitType = spec.getUnitType("model.unit.elderStatesman");
        ServerUnit statesman = new ServerUnit(game, colonyTile, player, unitType);
        ret.add(statesman);
        statesman.setLocation(colony.getWorkLocationFor(statesman, statesman.getType().getExpertProduction()));
        unitType = spec.getUnitType("model.unit.expertLumberJack");
        ServerUnit lumberjack = new ServerUnit(game, colony, player, unitType);
        ret.add(lumberjack);
        Tile lt = lumberjack.getWorkTile();
        if (lt != null) {
            TileType tt2 = CollectionUtils.find(spec.getTileTypeList(), TileType::isForested);
            if (tt2 != null) {
                lt.setType(tt2);
            }
            lumberjack.changeWorkType(lumberjack.getType().getExpertProduction());
        }
        unitType = spec.getUnitType("model.unit.masterCarpenter");
        ret.add(new ServerUnit(game, colony, player, unitType));
        unitType = spec.getUnitType("model.unit.seasonedScout");
        ServerUnit scout = new ServerUnit(game, colonyTile, player, unitType);
        ret.add(scout);
        ((ServerPlayer)player).exploreForUnit(scout);
        unitType = spec.getUnitType("model.unit.veteranSoldier");
        ret.add(new ServerUnit(game, colonyTile, player, unitType));
        ret.add(new ServerUnit(game, colonyTile, player, unitType));
        unitType = spec.getUnitType("model.unit.artillery");
        ret.add(new ServerUnit(game, colonyTile, player, unitType));
        ret.add(new ServerUnit(game, colonyTile, player, unitType));
        ret.add(new ServerUnit(game, colonyTile, player, unitType));
        unitType = spec.getUnitType("model.unit.treasureTrain");
        ServerUnit train = new ServerUnit(game, colonyTile, player, unitType);
        ret.add(train);
        train.setTreasureAmount(10000);
        unitType = spec.getUnitType("model.unit.wagonTrain");
        ServerUnit wagon = new ServerUnit(game, colonyTile, player, unitType);
        ret.add(wagon);
        GoodsType cigarsType = spec.getGoodsType("model.goods.cigars");
        Goods cigards = new Goods(game, wagon, cigarsType, 5);
        wagon.add(cigards);
        unitType = spec.getUnitType("model.unit.jesuitMissionary");
        ret.add(new ServerUnit(game, colonyTile, player, unitType));
        ret.add(new ServerUnit(game, colonyTile, player, unitType));
        ((ServerPlayer)player).exploreForSettlement(colony);
        return ret;
    }

    private static final class StartingUnits {
        private final List<Unit> carriers = new ArrayList<Unit>();
        private final List<Unit> passengers = new ArrayList<Unit>();
        private final List<Unit> otherNaval = new ArrayList<Unit>();

        StartingUnits(Player player, Random random) {
            Game game = player.getGame();
            Specification spec = player.getSpecification();
            List<AbstractUnit> unitList = ((EuropeanNationType)player.getNationType()).getStartingUnits();
            for (AbstractUnit startingUnit : unitList) {
                UnitType type = startingUnit.getType(spec);
                Role role = startingUnit.getRole(spec);
                ServerUnit newUnit = new ServerUnit(game, null, player, type, role);
                newUnit.setName(player.getNameForUnit(type, random));
                if (newUnit.isNaval()) {
                    if (newUnit.canCarryUnits()) {
                        newUnit.setState(Unit.UnitState.ACTIVE);
                        this.carriers.add(newUnit);
                        continue;
                    }
                    this.otherNaval.add(newUnit);
                    continue;
                }
                newUnit.setState(Unit.UnitState.SENTRY);
                this.passengers.add(newUnit);
            }
        }

        List<Unit> getCarriers() {
            return this.carriers;
        }

        List<Unit> getPassengers() {
            return this.passengers;
        }

        List<Unit> getOtherNaval() {
            return this.otherNaval;
        }
    }
}

