/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.runner;

import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.jboss.logging.Logger;

public class DevModeMediator {
    protected static final Logger LOGGER = Logger.getLogger(DevModeMediator.class);
    private static final Set<Path> removedFiles = new HashSet<Path>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scheduleDelete(Collection<Path> deletedPaths) {
        Set<Path> set = removedFiles;
        synchronized (set) {
            for (Path deletedPath : deletedPaths) {
                if (!removedFiles.add(deletedPath)) continue;
                LOGGER.info((Object)("Scheduled for removal " + String.valueOf(deletedPath)));
            }
        }
    }

    static void doDevMode(Path appRoot) throws IOException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Path deploymentClassPath = appRoot.resolve("lib/deployment/deployment-class-path.dat");
        Closeable closeable = DevModeMediator.doStart(appRoot, deploymentClassPath);
        Timer timer = new Timer("Classpath Change Timer", false);
        timer.schedule((TimerTask)new ChangeDetector(appRoot, appRoot.resolve("lib/deployment/appmodel.dat"), deploymentClassPath, closeable), 1000L, 1000L);
    }

    private static Closeable doStart(Path appRoot, Path deploymentClassPath) throws IOException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try (ObjectInputStream in = new ObjectInputStream(Files.newInputStream(deploymentClassPath, new OpenOption[0]));){
            List paths = (List)in.readObject();
            URLClassLoader loader = new URLClassLoader((URL[])paths.stream().map(s -> {
                try {
                    return appRoot.resolve((String)s).toUri().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }).toArray(URL[]::new));
            AppProcessCleanup appProcessCleanup = new AppProcessCleanup((Closeable)loader.loadClass("io.quarkus.deployment.mutability.DevModeTask").getDeclaredMethod("main", Path.class).invoke(null, appRoot), loader);
            return appProcessCleanup;
        }
    }

    private static class ChangeDetector
    extends TimerTask {
        private final Path appRoot;
        private final Path deploymentClassPath;
        private final Path appModelDat;
        private long lastModified;
        private Closeable closeable;

        private static long getLastModified(Path appModelDat) throws IOException {
            return Files.getLastModifiedTime(appModelDat, new LinkOption[0]).toMillis();
        }

        public ChangeDetector(Path appRoot, Path appModelDat, Path deploymentClassPath, Closeable closeable) throws IOException {
            this.appRoot = appRoot;
            this.deploymentClassPath = deploymentClassPath;
            this.closeable = closeable;
            this.appModelDat = appModelDat;
            this.lastModified = ChangeDetector.getLastModified(appModelDat);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block10: {
                try {
                    long time = ChangeDetector.getLastModified(this.appModelDat);
                    if (this.lastModified == time) break block10;
                    this.lastModified = time;
                    if (this.closeable != null) {
                        this.closeable.close();
                    }
                    Set<Path> set = removedFiles;
                    synchronized (set) {
                        Iterator<Path> removedFilesIterator = removedFiles.iterator();
                        while (removedFilesIterator.hasNext()) {
                            Path removedFile = removedFilesIterator.next();
                            removedFilesIterator.remove();
                            StringBuilder sb = new StringBuilder().append("Deleting ").append(removedFile);
                            if (!Files.deleteIfExists(removedFile)) {
                                sb.append(" didn't succeed");
                            }
                            LOGGER.info((Object)sb.toString());
                        }
                    }
                    try {
                        this.closeable = DevModeMediator.doStart(this.appRoot, this.deploymentClassPath);
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)"Failed to restart app after classpath changes", (Throwable)e);
                    }
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Failed to check for classpath changes", (Throwable)e);
                }
            }
        }
    }

    private static class AppProcessCleanup
    implements Closeable {
        private final Closeable app;
        private final URLClassLoader baseCl;

        public AppProcessCleanup(Closeable app, URLClassLoader baseCl) {
            this.app = app;
            this.baseCl = baseCl;
        }

        @Override
        public void close() throws IOException {
            this.app.close();
            this.baseCl.close();
        }
    }
}

