/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.impl.converter;

import java.io.File;
import org.aesh.command.converter.Converter;
import org.aesh.command.converter.ConverterInvocation;

public class FileConverter
implements Converter<File, ConverterInvocation> {
    @Override
    public File convert(ConverterInvocation input) {
        return new File(FileConverter.translatePath(input.getAeshContext().getCurrentWorkingDirectory().getAbsolutePath(), input.getInput()));
    }

    public static String translatePath(String cwd, String path) {
        String translated;
        if (path.startsWith("~" + File.separator)) {
            translated = System.getProperty("user.home") + path.substring(1);
        } else if (path.startsWith("~")) {
            String userName = path.substring(1);
            translated = new File(new File(System.getProperty("user.home")).getParent(), userName).getAbsolutePath();
            translated = userName.isEmpty() || path.endsWith(File.separator) ? translated + File.separator : translated;
        } else {
            translated = !new File(path).isAbsolute() ? cwd + File.separator + path : path;
        }
        return translated;
    }
}

