/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabeledWord;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.ling.WordLemmaTag;
import edu.stanford.nlp.ling.WordTag;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sentence {
    private Sentence() {
    }

    public static ArrayList<TaggedWord> toTaggedList(List<String> lex, List<String> tags) {
        int ts;
        ArrayList<TaggedWord> sent = new ArrayList<TaggedWord>();
        int ls = lex.size();
        if (ls != (ts = tags.size())) {
            throw new IllegalArgumentException("Sentence.toSentence: lengths differ");
        }
        for (int i = 0; i < ls; ++i) {
            sent.add(new TaggedWord(lex.get(i), tags.get(i)));
        }
        return sent;
    }

    public static ArrayList<Word> toUntaggedList(List<String> lex) {
        ArrayList<Word> sent = new ArrayList<Word>();
        int ls = lex.size();
        for (int i = 0; i < ls; ++i) {
            sent.add(new Word(lex.get(i)));
        }
        return sent;
    }

    public static List<HasWord> toWordList(List<String> lex) {
        ArrayList<HasWord> sent = new ArrayList<HasWord>();
        for (String str : lex) {
            CoreLabel cl = new CoreLabel();
            cl.setValue(str);
            cl.setWord(str);
            sent.add(cl);
        }
        return sent;
    }

    public static ArrayList<Word> toUntaggedList(String ... words) {
        ArrayList<Word> sent = new ArrayList<Word>();
        for (String str : words) {
            sent.add(new Word(str));
        }
        return sent;
    }

    public static List<HasWord> toWordList(String ... words) {
        ArrayList<HasWord> sent = new ArrayList<HasWord>();
        for (int i = 0; i < words.length; ++i) {
            CoreLabel cl = new CoreLabel();
            cl.setValue(words[i]);
            cl.setWord(words[i]);
            sent.add(cl);
        }
        return sent;
    }

    public static <T> String listToString(List<T> list) {
        return Sentence.listToString(list, true);
    }

    public static <T> String listToString(List<T> list, boolean justValue) {
        return Sentence.listToString(list, justValue, null);
    }

    public static <T> String listToString(List<T> list, boolean justValue, String separator) {
        StringBuilder s = new StringBuilder();
        Iterator<T> wordIterator = list.iterator();
        while (wordIterator.hasNext()) {
            String w;
            CoreLabel l;
            T o = wordIterator.next();
            if (justValue && o instanceof Label) {
                if (o instanceof CoreLabel) {
                    l = (CoreLabel)o;
                    w = l.value();
                    if (w == null) {
                        w = l.word();
                    }
                    s.append(w);
                } else {
                    s.append(((Label)o).value());
                }
            } else if (o instanceof CoreLabel) {
                l = (CoreLabel)o;
                w = l.value();
                if (w == null) {
                    w = l.word();
                }
                s.append(w);
                if (l.tag() != null) {
                    s.append(separator != null ? separator : "/");
                    s.append(l.tag());
                }
            } else if (separator != null && o instanceof TaggedWord) {
                s.append(((TaggedWord)o).toString(separator));
            } else if (separator != null && o instanceof LabeledWord) {
                s.append(((LabeledWord)o).toString(separator));
            } else if (separator != null && o instanceof WordLemmaTag) {
                s.append(((WordLemmaTag)o).toString(separator));
            } else if (separator != null && o instanceof WordTag) {
                s.append(((WordTag)o).toString(separator));
            } else {
                s.append(o.toString());
            }
            if (!wordIterator.hasNext()) continue;
            s.append(' ');
        }
        return s.toString();
    }

    public static <T> String extractNgram(List<T> list, int start, int end) {
        if (start < 0 || end > list.size() || start >= end) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = start; i < end; ++i) {
            T o = list.get(i);
            if (sb.length() != 0) {
                sb.append(" ");
            }
            sb.append(o instanceof HasWord ? ((HasWord)o).word() : o.toString());
        }
        return sb.toString();
    }
}

