/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.Version;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.lucene.store.InputStreamIndexInput;
import org.opensearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.opensearch.index.store.CloseableFilterIndexOutput;
import org.opensearch.index.store.RemoteSegmentStoreDirectory;
import org.opensearch.index.store.StoreFileMetadata;
import org.opensearch.index.store.remote.file.OnDemandBlockSnapshotIndexInput;
import org.opensearch.index.store.remote.filecache.CachedFullFileIndexInput;
import org.opensearch.index.store.remote.filecache.CachedIndexInput;
import org.opensearch.index.store.remote.filecache.FileCache;
import org.opensearch.index.store.remote.utils.FileTypeUtils;
import org.opensearch.index.store.remote.utils.TransferManager;
import org.opensearch.threadpool.ThreadPool;

@ExperimentalApi
public class CompositeDirectory
extends FilterDirectory {
    private static final Logger logger = LogManager.getLogger(CompositeDirectory.class);
    protected final FSDirectory localDirectory;
    protected final RemoteSegmentStoreDirectory remoteDirectory;
    protected final FileCache fileCache;
    protected final TransferManager transferManager;
    protected final ThreadPool threadPool;

    public CompositeDirectory(Directory localDirectory, Directory remoteDirectory, FileCache fileCache, ThreadPool threadPool) {
        super(localDirectory);
        this.validate(localDirectory, remoteDirectory, fileCache);
        this.localDirectory = (FSDirectory)localDirectory;
        this.remoteDirectory = (RemoteSegmentStoreDirectory)remoteDirectory;
        this.fileCache = fileCache;
        this.threadPool = threadPool;
        this.transferManager = new TransferManager((name, position, length) -> new InputStreamIndexInput(this.remoteDirectory.openBlockInput(name, position, length, IOContext.DEFAULT), length), fileCache, threadPool);
    }

    private String[] listLocalFiles() throws IOException {
        this.ensureOpen();
        logger.trace("Composite Directory[{}]: listLocalOnly() called", new Supplier[]{this::toString});
        return this.localDirectory.listAll();
    }

    protected List<String> listBlockFiles(String fileName) throws IOException {
        return Stream.of(this.listLocalFiles()).filter(file -> file.equals(fileName) || file.startsWith(fileName + FileTypeUtils.BLOCK_FILE_IDENTIFIER)).collect(Collectors.toList());
    }

    public String[] listAll() throws IOException {
        String[] remoteFiles;
        this.ensureOpen();
        logger.trace("Composite Directory[{}]: listAll() called", new Supplier[]{this::toString});
        String[] localFiles = this.localDirectory.listAll();
        boolean hasLocalSegments = Arrays.stream(localFiles).anyMatch(fileName -> fileName.startsWith("segments"));
        try {
            remoteFiles = hasLocalSegments ? (String[])Arrays.stream(this.remoteDirectory.listAll()).filter(fileName -> !fileName.startsWith("segments")).toArray(String[]::new) : this.remoteDirectory.listAll();
        }
        catch (NullPointerException e) {
            remoteFiles = new String[]{};
        }
        logger.trace("Composite Directory[{}]: Local Directory files - {}", new Supplier[]{this::toString, () -> Arrays.toString(localFiles)});
        String[] finalRemoteFiles = remoteFiles;
        logger.trace("Composite Directory[{}]: Remote Directory files - {}", new Supplier[]{this::toString, () -> Arrays.toString(finalRemoteFiles)});
        Set allFiles = Stream.concat(Arrays.stream(localFiles), Arrays.stream(remoteFiles)).map(s -> s.contains(FileTypeUtils.BLOCK_FILE_IDENTIFIER) ? s.substring(0, s.indexOf(FileTypeUtils.BLOCK_FILE_IDENTIFIER)) : s).collect(Collectors.toSet());
        Set<Object> nonBlockLuceneFiles = allFiles.stream().filter(file -> !FileTypeUtils.isBlockFile(file)).collect(Collectors.toUnmodifiableSet());
        Object[] files = new String[nonBlockLuceneFiles.size()];
        nonBlockLuceneFiles.toArray(files);
        Arrays.sort(files);
        logger.trace("Composite Directory[{}]: listAll() returns : {}", new Supplier[]{this::toString, () -> CompositeDirectory.lambda$listAll$9((String[])files)});
        return files;
    }

    public void deleteFile(String name) throws IOException {
        this.ensureOpen();
        logger.trace("Composite Directory[{}]: deleteFile() called {}", new Supplier[]{this::toString, () -> name});
        if (FileTypeUtils.isTempFile(name)) {
            this.localDirectory.deleteFile(name);
        } else {
            if (!Arrays.asList(this.listAll()).contains(name)) {
                return;
            }
            List<String> blockFiles = this.listBlockFiles(name);
            if (blockFiles.isEmpty()) {
                logger.debug("The file [{}] or its block files do not exist in local directory", (Object)name);
            } else {
                for (String blockFile : blockFiles) {
                    if (this.fileCache.get(this.getFilePath(blockFile)) == null) {
                        logger.debug("The file [{}] exists in local but not part of FileCache, deleting it from local", (Object)blockFile);
                        this.localDirectory.deleteFile(blockFile);
                        continue;
                    }
                    this.fileCache.remove(this.getFilePath(blockFile));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long fileLength(String name) throws IOException {
        long fileLength;
        this.ensureOpen();
        logger.trace("Composite Directory[{}]: fileLength() called {}", new Supplier[]{this::toString, () -> name});
        Path key = this.getFilePath(name);
        if (FileTypeUtils.isTempFile(name) || this.fileCache.get(key) != null) {
            try {
                fileLength = this.localDirectory.fileLength(name);
                logger.trace("Composite Directory[{}]: fileLength of {} fetched from Local - {}", new Supplier[]{this::toString, () -> name, () -> fileLength});
            }
            finally {
                this.fileCache.decRef(key);
            }
        } else {
            fileLength = this.remoteDirectory.fileLength(name);
            logger.trace("Composite Directory[{}]: fileLength of {} fetched from Remote - {}", new Supplier[]{this::toString, () -> name, () -> fileLength});
        }
        return fileLength;
    }

    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        logger.trace("Composite Directory[{}]: createOutput() called {}", new Supplier[]{this::toString, () -> name});
        return new CloseableFilterIndexOutput(this.localDirectory.createOutput(name, context), name, this::cacheFile);
    }

    public void sync(Collection<String> names) throws IOException {
        this.ensureOpen();
        logger.trace("Composite Directory[{}]: sync() called {}", new Supplier[]{this::toString, () -> names});
        Set<String> remoteFiles = Set.of(this.getRemoteFiles());
        Set localFilesHavingBlocks = Arrays.stream(this.listLocalFiles()).filter(FileTypeUtils::isBlockFile).map(file -> file.substring(0, file.indexOf(FileTypeUtils.BLOCK_FILE_IDENTIFIER))).collect(Collectors.toSet());
        Collection fullFilesToSync = names.stream().filter(name -> !remoteFiles.contains(name) && !localFilesHavingBlocks.contains(name)).collect(Collectors.toList());
        logger.trace("Composite Directory[{}]: Synced files : {}", new Supplier[]{this::toString, () -> fullFilesToSync});
        this.localDirectory.sync(fullFilesToSync);
    }

    public void rename(String source, String dest) throws IOException {
        this.ensureOpen();
        logger.trace("Composite Directory[{}]: rename() called : source-{}, dest-{}", new Supplier[]{this::toString, () -> source, () -> dest});
        this.localDirectory.rename(source, dest);
        this.fileCache.remove(this.getFilePath(source));
        this.cacheFile(dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexInput openInput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        logger.trace("Composite Directory[{}]: openInput() called {}", new Supplier[]{this::toString, () -> name});
        if (FileTypeUtils.isTempFile(name)) {
            return this.localDirectory.openInput(name, context);
        }
        Path key = this.getFilePath(name);
        CachedIndexInput indexInput = this.fileCache.compute(key, (path, cachedIndexInput) -> {
            if (cachedIndexInput != null && !cachedIndexInput.isClosed()) {
                return cachedIndexInput;
            }
            if (cachedIndexInput != null && cachedIndexInput.isClosed() && Files.exists(key, new LinkOption[0])) {
                try {
                    assert (cachedIndexInput instanceof FileCache.RestoredCachedIndexInput);
                    return new CachedFullFileIndexInput(this.fileCache, key, this.localDirectory.openInput(name, IOContext.DEFAULT));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        });
        if (indexInput != null) {
            logger.trace("Composite Directory[{}]: Complete file {} found in FileCache", new Supplier[]{this::toString, () -> name});
            try {
                IndexInput indexInput2 = indexInput.getIndexInput().clone();
                return indexInput2;
            }
            finally {
                this.fileCache.decRef(key);
            }
        }
        logger.trace("Composite Directory[{}]: Complete file {} not in FileCache, to be fetched in Blocks from Remote", new Supplier[]{this::toString, () -> name});
        RemoteSegmentStoreDirectory.UploadedSegmentMetadata uploadedSegmentMetadata = this.remoteDirectory.getSegmentsUploadedToRemoteStore().get(name);
        if (uploadedSegmentMetadata == null) {
            throw new NoSuchFileException("File " + name + " not found in directory");
        }
        BlobStoreIndexShardSnapshot.FileInfo fileInfo = new BlobStoreIndexShardSnapshot.FileInfo(name, new StoreFileMetadata(name, uploadedSegmentMetadata.getLength(), uploadedSegmentMetadata.getChecksum(), Version.LATEST), null);
        return new OnDemandBlockSnapshotIndexInput(fileInfo, this.localDirectory, this.transferManager);
    }

    public void close() throws IOException {
        String[] localFiles;
        this.ensureOpen();
        logger.trace("Composite Directory[{}]: close() called", new Supplier[]{this::toString});
        for (String localFile : localFiles = this.listLocalFiles()) {
            if (!localFile.startsWith("segments")) continue;
            this.fileCache.remove(this.getFilePath(localFile));
        }
        this.localDirectory.close();
    }

    public String toString() {
        return "Composite Directory @ " + Integer.toHexString(((Object)((Object)this)).hashCode());
    }

    public void afterSyncToRemote(String file) {
        this.ensureOpen();
        logger.trace("Composite Directory[{}]: File {} uploaded to Remote Store and now can be eligible for eviction in FileCache", new Supplier[]{this::toString, () -> file});
        Path filePath = this.getFilePath(file);
        this.fileCache.unpin(filePath);
    }

    public Path getFilePath(String name) {
        return this.localDirectory.getDirectory().resolve(name);
    }

    private void validate(Directory localDirectory, Directory remoteDirectory, FileCache fileCache) {
        if (localDirectory == null || remoteDirectory == null) {
            throw new IllegalStateException("Local and remote directory cannot be null for Composite Directory");
        }
        if (fileCache == null) {
            throw new IllegalStateException("File Cache not initialized on this Node, cannot create Composite Directory without FileCache");
        }
        if (!(localDirectory instanceof FSDirectory)) {
            throw new IllegalStateException("For Composite Directory, local directory must be of type FSDirectory");
        }
        if (!(remoteDirectory instanceof RemoteSegmentStoreDirectory)) {
            throw new IllegalStateException("For Composite Directory, remote directory must be of type RemoteSegmentStoreDirectory");
        }
    }

    private String[] getRemoteFiles() throws IOException {
        String[] remoteFiles;
        try {
            remoteFiles = this.remoteDirectory.listAll();
        }
        catch (NullPointerException e) {
            remoteFiles = new String[]{};
        }
        return remoteFiles;
    }

    protected void cacheFile(String name) throws IOException {
        Path filePath = this.getFilePath(name);
        this.fileCache.put(filePath, new CachedFullFileIndexInput(this.fileCache, filePath, this.localDirectory.openInput(name, IOContext.DEFAULT)));
        this.fileCache.pin(filePath);
        this.fileCache.decRef(filePath);
    }

    private static /* synthetic */ Object lambda$listAll$9(String[] files) {
        return Arrays.toString(files);
    }
}

