/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.index.query.xyshape;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.lucene.geo.XYGeometry;
import org.opensearch.geometry.Circle;
import org.opensearch.geometry.Geometry;
import org.opensearch.geometry.GeometryCollection;
import org.opensearch.geometry.GeometryVisitor;
import org.opensearch.geometry.Line;
import org.opensearch.geometry.LinearRing;
import org.opensearch.geometry.MultiLine;
import org.opensearch.geometry.MultiPoint;
import org.opensearch.geometry.MultiPolygon;
import org.opensearch.geometry.Point;
import org.opensearch.geometry.Polygon;
import org.opensearch.geometry.Rectangle;
import org.opensearch.geospatial.index.common.xyshape.XYShapeConverter;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.QueryShardException;

public class XYShapeQueryVisitor
implements GeometryVisitor<List<XYGeometry>, RuntimeException> {
    private final String name;
    private final QueryShardContext context;

    public XYShapeQueryVisitor(String name, QueryShardContext context) {
        this.name = name;
        this.context = context;
    }

    public List<XYGeometry> visit(Circle circle) throws RuntimeException {
        Objects.requireNonNull(circle, "Circle cannot be null");
        return List.of(XYShapeConverter.toXYCircle(circle));
    }

    public List<XYGeometry> visit(GeometryCollection<?> geometryCollection) throws RuntimeException {
        Objects.requireNonNull(geometryCollection, "Geometry collection cannot be null");
        return this.visitCollection(geometryCollection);
    }

    public List<XYGeometry> visit(Line line) throws RuntimeException {
        Objects.requireNonNull(line, "Line cannot be null");
        return List.of(XYShapeConverter.toXYLine(line));
    }

    public List<XYGeometry> visit(LinearRing linearRing) throws RuntimeException {
        throw new QueryShardException(this.context, String.format(Locale.ROOT, "Field [%s] found an unsupported shape LinearRing", this.name), new Object[0]);
    }

    public List<XYGeometry> visit(MultiLine multiLine) throws RuntimeException {
        Objects.requireNonNull(multiLine, "Multi Line cannot be null");
        return this.visitCollection((GeometryCollection<?>)multiLine);
    }

    public List<XYGeometry> visit(MultiPoint multiPoint) throws RuntimeException {
        Objects.requireNonNull(multiPoint, "Multi Point cannot be null");
        return this.visitCollection((GeometryCollection<?>)multiPoint);
    }

    public List<XYGeometry> visit(MultiPolygon multiPolygon) throws RuntimeException {
        Objects.requireNonNull(multiPolygon, "Multi Polygon cannot be null");
        return this.visitCollection((GeometryCollection<?>)multiPolygon);
    }

    public List<XYGeometry> visit(Point point) throws RuntimeException {
        Objects.requireNonNull(point, "Point cannot be null");
        return List.of(XYShapeConverter.toXYPoint(point));
    }

    public List<XYGeometry> visit(Polygon polygon) throws RuntimeException {
        Objects.requireNonNull(polygon, "Polygon cannot be null");
        return List.of(XYShapeConverter.toXYPolygon(polygon));
    }

    public List<XYGeometry> visit(Rectangle rectangle) throws RuntimeException {
        Objects.requireNonNull(rectangle, "Rectangle cannot be null");
        return List.of(XYShapeConverter.toXYRectangle(rectangle));
    }

    private List<XYGeometry> visitCollection(GeometryCollection<?> collection) {
        if (collection.isEmpty()) {
            return List.of();
        }
        ArrayList xyGeometryCollection = new ArrayList();
        for (Geometry geometry : collection) {
            xyGeometryCollection.addAll((Collection)geometry.visit((GeometryVisitor)this));
        }
        return Collections.unmodifiableList(xyGeometryCollection);
    }
}

