/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot.internal.shaded.scala.cli.config;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import scala.Array$;
import scala.Function0;
import scala.Option$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.sys.package$;
import xsbt.boot.internal.shaded.scala.cli.config.Secret;
import xsbt.boot.internal.shaded.scala.cli.config.Secret$;

public abstract class PasswordOption
implements Serializable,
Product {
    @Override
    public Iterator<Object> productIterator() {
        return Product.productIterator$(this);
    }

    @Override
    public String productPrefix() {
        return Product.productPrefix$(this);
    }

    public abstract Secret<String> get();

    public PasswordOption() {
        Product.$init$(this);
    }

    public static final class Command
    extends PasswordOption {
        private final Seq<String> command;

        public final Seq<String> command() {
            return this.command;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Secret<String> get() {
            void var1_3;
            int read;
            ProcessBuilder b = new ProcessBuilder((String[])this.command().toArray(ClassTag$.MODULE$.apply(String.class)));
            b.redirectInput(ProcessBuilder.Redirect.INHERIT);
            b.redirectError(ProcessBuilder.Redirect.INHERIT);
            b.redirectOutput(ProcessBuilder.Redirect.PIPE);
            Process p = b.start();
            InputStream is = p.getInputStream();
            byte[] buf = (byte[])Array$.MODULE$.ofDim(2048, ClassTag$.MODULE$.Byte());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((read = is.read(buf)) >= 0) {
                void var3_7;
                if (read <= 0) continue;
                baos.write(buf, 0, (int)var3_7);
            }
            int exitCode = p.waitFor();
            if (exitCode != 0) {
                throw new RuntimeException(new StringBuilder(36).append("Error running command ").append(this.command().mkString(" ")).append(" (exit code: ").append(exitCode).append(")").toString());
            }
            String res = new String(baos.toByteArray());
            return Secret$.MODULE$.apply(var1_3);
        }

        @Override
        public final String productPrefix() {
            return "Command";
        }

        @Override
        public final int productArity() {
            return 1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Object productElement(int x$1) {
            void var1_1;
            switch (x$1) {
                case 0: {
                    return this.command();
                }
            }
            return Statics.ioobe((int)var1_1);
        }

        @Override
        public final Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        public final int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        public final String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        public final boolean equals(Object x$1) {
            block3: {
                block2: {
                    Object object;
                    if (this == x$1) break block2;
                    Object object2 = x$1;
                    if (!(object2 instanceof Command)) break block3;
                    object = (Command)object;
                    Seq<String> seq = this.command();
                    object = ((Command)object).command();
                    if (seq != null ? !seq.equals(object) : object != null) break block3;
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        public Command(Seq<String> command) {
            void var1_1;
            this.command = var1_1;
        }
    }

    public static final class Env
    extends PasswordOption {
        private final String name;

        public final String name() {
            return this.name;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Secret<String> get() {
            void var1_1;
            String value = (String)Option$.MODULE$.apply(System.getenv(this.name())).getOrElse((Function0<Nothing$> & Serializable)() -> {
                Env env;
                return package$.MODULE$.error(new StringBuilder(36).append("Error: environment variable ").append(env.name()).append(" not set").toString());
            });
            return Secret$.MODULE$.apply(var1_1);
        }

        @Override
        public final String productPrefix() {
            return "Env";
        }

        @Override
        public final int productArity() {
            return 1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Object productElement(int x$1) {
            void var1_1;
            switch (x$1) {
                case 0: {
                    return this.name();
                }
            }
            return Statics.ioobe((int)var1_1);
        }

        @Override
        public final Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        public final int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        public final String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        public final boolean equals(Object x$1) {
            block3: {
                block2: {
                    Object object;
                    if (this == x$1) break block2;
                    Object object2 = x$1;
                    if (!(object2 instanceof Env)) break block3;
                    object = (Env)object;
                    String string = this.name();
                    object = ((Env)object).name();
                    if (string != null ? !string.equals(object) : object != null) break block3;
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        public Env(String name) {
            void var1_1;
            this.name = var1_1;
        }
    }

    public static final class File
    extends PasswordOption {
        private final Path path;

        public final Path path() {
            return this.path;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Secret<String> get() {
            void var1_1;
            String value = new String(Files.readAllBytes(this.path()), StandardCharsets.UTF_8);
            return Secret$.MODULE$.apply(var1_1);
        }

        @Override
        public final String productPrefix() {
            return "File";
        }

        @Override
        public final int productArity() {
            return 1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Object productElement(int x$1) {
            void var1_1;
            switch (x$1) {
                case 0: {
                    return this.path();
                }
            }
            return Statics.ioobe((int)var1_1);
        }

        @Override
        public final Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        public final int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        public final String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        public final boolean equals(Object x$1) {
            block3: {
                block2: {
                    Object object;
                    if (this == x$1) break block2;
                    Object object2 = x$1;
                    if (!(object2 instanceof File)) break block3;
                    object = (File)object;
                    Path path = this.path();
                    object = ((File)object).path();
                    if (path != null ? !((Object)path).equals(object) : object != null) break block3;
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        public File(Path path) {
            void var1_1;
            this.path = var1_1;
        }
    }

    public static final class Value
    extends PasswordOption {
        private final Secret<String> value;

        public final Secret<String> value() {
            return this.value;
        }

        @Override
        public final Secret<String> get() {
            return this.value();
        }

        @Override
        public final String productPrefix() {
            return "Value";
        }

        @Override
        public final int productArity() {
            return 1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Object productElement(int x$1) {
            void var1_1;
            switch (x$1) {
                case 0: {
                    return this.value();
                }
            }
            return Statics.ioobe((int)var1_1);
        }

        @Override
        public final Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        public final int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        public final String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        public final boolean equals(Object x$1) {
            block3: {
                block2: {
                    Object object;
                    if (this == x$1) break block2;
                    Object object2 = x$1;
                    if (!(object2 instanceof Value)) break block3;
                    object = (Value)object;
                    Secret<String> secret = this.value();
                    object = ((Value)object).value();
                    if (secret != null ? !((Object)secret).equals(object) : object != null) break block3;
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        public Value(Secret<String> value) {
            void var1_1;
            this.value = var1_1;
        }
    }
}

