/*
 * Decompiled with CFR 0.152.
 */
package hughai.building;

import com.springrts.ai.oo.clb.OOAICallback;
import hughai.CSAI;
import hughai.PlayerObjects;
import hughai.utils.Config;
import hughai.utils.LogFile;
import hughai.utils.ReflectionHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class Workflows {
    HashMap<String, Workflow> workflowsByName = new HashMap();
    PlayerObjects playerObjects;
    LogFile logfile;
    CSAI csai;
    OOAICallback aicallback;
    Config config;
    String modname;
    String workflowdirectory;

    public HashMap<String, Workflow> getWorkflowsByName() {
        return this.workflowsByName;
    }

    public Workflows(PlayerObjects playerObjects) {
        this.playerObjects = playerObjects;
        this.logfile = playerObjects.getLogFile();
        this.csai = playerObjects.getCSAI();
        this.aicallback = playerObjects.getAicallback();
        this.config = playerObjects.getConfig();
        this.modname = this.aicallback.getMod().getShortName().toLowerCase();
        this.workflowdirectory = this.csai.getAIDirectoryPath() + "workflows" + File.separator + this.aicallback.getMod().getShortName() + File.separator;
        new File(this.workflowdirectory).mkdirs();
        this.Init();
    }

    String getWorkflowFilePath(String string) {
        return this.workflowdirectory + string + ".xml";
    }

    void Init() {
        String string = this.config.getDefaultWorkflowName();
        this.logfile.WriteLine("workflows.init()");
        ReflectionHelper reflectionHelper = new ReflectionHelper(this.playerObjects);
        for (File file : new File(this.workflowdirectory).listFiles()) {
            String string2 = file.getName().toLowerCase();
            if (string2.startsWith(".")) continue;
            String string3 = string2.split("\\.")[0];
            this.logfile.WriteLine("Workflow file found: " + string2);
            Workflow workflow = new Workflow();
            reflectionHelper.loadObjectFromFile(this.workflowdirectory + string2, workflow);
            workflow.setWorkflowName(string3);
            this.validate(workflow);
            this.workflowsByName.put(workflow.getWorkflowName(), workflow);
        }
        if (this.workflowsByName.get(string) == null) {
            this.csai.sendTextMessage("No default workflow config files found for mod " + this.aicallback.getMod().getHumanName() + ".  Creating one: " + this.workflowdirectory + string + ".xml");
            Workflow workflow = new Workflow();
            workflow.setWorkflowName(string);
            this.populateSampleWorkflow(workflow);
            this.workflowsByName.put(workflow.getWorkflowName(), workflow);
        }
        for (Workflow workflow : this.workflowsByName.values()) {
            reflectionHelper.saveObjectToFile(this.workflowdirectory + workflow.getWorkflowName() + ".xml", workflow);
        }
    }

    void validate(Workflow workflow) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Workflow.Order order : workflow.orders) {
            String string = order.unitname;
            if (this.playerObjects.getBuildTable().getUnitDefByName(string) != null) continue;
            arrayList.add(string);
        }
        if (arrayList.size() > 0) {
            this.playerObjects.getMainUI().showInfo("ERROR: the workflow file\n" + this.getWorkflowFilePath(workflow.workflowName) + "\ncontains the following invalid unitnames:\n" + arrayList + " .  If you are not sure what this means, you may be using an unsupported mod.  Please restart the game using the BA mod.");
            this.playerObjects.getLogFile().WriteLine("ERROR: the workflow file " + this.getWorkflowFilePath(workflow.workflowName) + " contains the following invalid unitnames: " + arrayList + " .  If you are not sure what this means, you may be using an unsupported mod.  Please restart the game using the BA mod.");
        } else {
            this.playerObjects.getLogFile().WriteLine("workflow " + workflow.workflowName + " validated.");
        }
    }

    void populateSampleWorkflow(Workflow workflow) {
        workflow.getOrders().add(new Workflow.Order(2.0f, "armvp", 1));
        workflow.getOrders().add(new Workflow.Order(2.1f, "armfav", 2));
        workflow.getOrders().add(new Workflow.Order(2.0f, "armstump", 10));
        workflow.getOrders().add(new Workflow.Order(2.0f, "armsam", 10));
        workflow.getOrders().add(new Workflow.Order(1.95f, "armmex", 4));
        workflow.getOrders().add(new Workflow.Order(1.95f, "armsolar", 4));
        workflow.getOrders().add(new Workflow.Order(1.9f, "armcv", 3));
        workflow.getOrders().add(new Workflow.Order(1.8f, "armmstor", 1));
        workflow.getOrders().add(new Workflow.Order(1.8f, "armavp", 1));
        workflow.getOrders().add(new Workflow.Order(2.0f, "armbull", 3));
        workflow.getOrders().add(new Workflow.Order(2.0f, "armmart", 2));
        workflow.getOrders().add(new Workflow.Order(1.9f, "armseer", 1));
        workflow.getOrders().add(new Workflow.Order(1.7f, "armyork", 3));
        workflow.getOrders().add(new Workflow.Order(1.7f, "armbull", 3));
        workflow.getOrders().add(new Workflow.Order(1.7f, "armmart", 2));
        workflow.getOrders().add(new Workflow.Order(0.9f, "armacv", 2));
        workflow.getOrders().add(new Workflow.Order(0.8f, "armmmkr", 4));
        workflow.getOrders().add(new Workflow.Order(0.8f, "armarad", 1));
        workflow.getOrders().add(new Workflow.Order(0.8f, "armestor", 1));
        workflow.getOrders().add(new Workflow.Order(0.7f, "armalab", 1));
        workflow.getOrders().add(new Workflow.Order(0.7f, "armfark", 2));
        workflow.getOrders().add(new Workflow.Order(0.6f, "armbull", 20));
        workflow.getOrders().add(new Workflow.Order(0.6f, "armyork", 20));
        workflow.getOrders().add(new Workflow.Order(0.6f, "armmart", 20));
        workflow.getOrders().add(new Workflow.Order(0.5f, "armseer", 1));
        workflow.getOrders().add(new Workflow.Order(0.5f, "armsjam", 1));
        workflow.getOrders().add(new Workflow.Order(0.4f, "armmav", 50));
        workflow.getOrders().add(new Workflow.Order(0.3f, "armfark", 4));
    }

    public static class Workflow {
        public String workflowName;
        @ReflectionHelper.ListTypeInfo(value=Order.class)
        @ReflectionHelper.CustomClass
        public ArrayList<Order> orders = new ArrayList();

        public ArrayList<Order> getOrders() {
            return this.orders;
        }

        public void setOrders(ArrayList<Order> arrayList) {
            this.orders = arrayList;
        }

        public void setWorkflowName(String string) {
            this.workflowName = string;
        }

        public String getWorkflowName() {
            return this.workflowName;
        }

        public static class Order {
            @ReflectionHelper.Exclude
            static int nextorderref = 0;
            @ReflectionHelper.Exclude
            int orderref;
            public float priority;
            public String unitname;
            public int quantity;

            public Order() {
            }

            public Order(float f, String string, int n) {
                this.priority = f;
                this.unitname = string;
                this.quantity = n;
                int n2 = nextorderref++;
            }

            public int hashCode() {
                return this.orderref;
            }
        }
    }
}

