/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.AbstractTeXObject;
import com.dickimawbooks.texparserlib.SingleToken;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSettings;
import java.io.IOException;

public class Tab
extends AbstractTeXObject
implements SingleToken {
    protected int charCode;

    public Tab() {
        this(38);
    }

    public Tab(int n) {
        this.charCode = n;
    }

    public Tab(TeXParser teXParser) {
        this(teXParser.getTabChar());
    }

    @Override
    public Object clone() {
        return new Tab(this.charCode);
    }

    @Override
    public int getCharCode() {
        return this.charCode;
    }

    @Override
    public int getCatCode() {
        return 4;
    }

    @Override
    public String toString(TeXParser teXParser) {
        return this.format();
    }

    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public String format() {
        return new String(Character.toChars(this.charCode));
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(teXParser.getListener().getOther(this.charCode));
        return teXObjectList;
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.process(teXParser);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        TeXSettings teXSettings = teXParser.getSettings();
        teXSettings.startColumn();
    }
}

