/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.filters.FilterBase;
import org.apache.catalina.util.NetMaskSet;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public final class RemoteCIDRFilter
extends FilterBase {
    private static final String PLAIN_TEXT_MIME_TYPE = "text/plain";
    private final Log log = LogFactory.getLog(RemoteCIDRFilter.class);
    private final NetMaskSet allow = new NetMaskSet();
    private final NetMaskSet deny = new NetMaskSet();

    public String getAllow() {
        return this.allow.toString().replace("[", "").replace("]", "");
    }

    public void setAllow(String string) {
        List<String> list = this.allow.addAll(string);
        if (list.isEmpty()) {
            return;
        }
        for (String string2 : list) {
            this.log.error((Object)string2);
        }
        throw new IllegalArgumentException(sm.getString("remoteCidrFilter.invalid", new Object[]{"allow"}));
    }

    public String getDeny() {
        return this.deny.toString().replace("[", "").replace("]", "");
    }

    public void setDeny(String string) {
        List<String> list = this.deny.addAll(string);
        if (list.isEmpty()) {
            return;
        }
        for (String string2 : list) {
            this.log.error((Object)string2);
        }
        throw new IllegalArgumentException(sm.getString("remoteCidrFilter.invalid", new Object[]{"deny"}));
    }

    @Override
    protected boolean isConfigProblemFatal() {
        return true;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.isAllowed(servletRequest.getRemoteAddr())) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        if (!(servletResponse instanceof HttpServletResponse)) {
            this.sendErrorWhenNotHttp(servletResponse);
            return;
        }
        ((HttpServletResponse)servletResponse).sendError(403);
    }

    @Override
    public Log getLogger() {
        return this.log;
    }

    private boolean isAllowed(String string) {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            this.log.error((Object)sm.getString("remoteCidrFilter.noRemoteIp"), (Throwable)unknownHostException);
            return false;
        }
        if (this.deny.contains(inetAddress)) {
            return false;
        }
        if (this.allow.contains(inetAddress)) {
            return true;
        }
        return !this.deny.isEmpty() && this.allow.isEmpty();
    }

    private void sendErrorWhenNotHttp(ServletResponse servletResponse) throws IOException {
        PrintWriter printWriter = servletResponse.getWriter();
        servletResponse.setContentType(PLAIN_TEXT_MIME_TYPE);
        printWriter.write(sm.getString("http.403"));
        printWriter.flush();
    }
}

