"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.decorateInlayHints = decorateInlayHints;
const sveltekit_1 = require("./sveltekit");
function decorateInlayHints(ls, info, ts, logger) {
    const provideInlayHints = ls.provideInlayHints;
    ls.provideInlayHints = (fileName, span, preferences) => {
        const result = (0, sveltekit_1.getVirtualLS)(fileName, info, ts);
        if (!result) {
            return provideInlayHints(fileName, span, preferences);
        }
        const { languageService, toVirtualPos, toOriginalPos } = result;
        const start = toVirtualPos(span.start);
        return languageService
            .provideInlayHints(fileName, {
            start,
            length: toVirtualPos(span.start + span.length) - start
        }, preferences)
            .map((hint) => ({
            ...hint,
            position: toOriginalPos(hint.position).pos
        }));
    };
}
//# sourceMappingURL=inlay-hints.js.map