﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ecs/ECS_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace ECS {
namespace Model {

/**
 * <p>Details on an Elastic Inference accelerator. For more information, see <a
 * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-inference.html">Working
 * with Amazon Elastic Inference on Amazon ECS</a> in the <i>Amazon Elastic
 * Container Service Developer Guide</i>.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/InferenceAccelerator">AWS
 * API Reference</a></p>
 */
class InferenceAccelerator {
 public:
  AWS_ECS_API InferenceAccelerator() = default;
  AWS_ECS_API InferenceAccelerator(Aws::Utils::Json::JsonView jsonValue);
  AWS_ECS_API InferenceAccelerator& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_ECS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The Elastic Inference accelerator device name. The <code>deviceName</code>
   * must also be referenced in a container definition as a <a
   * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ResourceRequirement.html">ResourceRequirement</a>.</p>
   */
  inline const Aws::String& GetDeviceName() const { return m_deviceName; }
  inline bool DeviceNameHasBeenSet() const { return m_deviceNameHasBeenSet; }
  template <typename DeviceNameT = Aws::String>
  void SetDeviceName(DeviceNameT&& value) {
    m_deviceNameHasBeenSet = true;
    m_deviceName = std::forward<DeviceNameT>(value);
  }
  template <typename DeviceNameT = Aws::String>
  InferenceAccelerator& WithDeviceName(DeviceNameT&& value) {
    SetDeviceName(std::forward<DeviceNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Elastic Inference accelerator type to use.</p>
   */
  inline const Aws::String& GetDeviceType() const { return m_deviceType; }
  inline bool DeviceTypeHasBeenSet() const { return m_deviceTypeHasBeenSet; }
  template <typename DeviceTypeT = Aws::String>
  void SetDeviceType(DeviceTypeT&& value) {
    m_deviceTypeHasBeenSet = true;
    m_deviceType = std::forward<DeviceTypeT>(value);
  }
  template <typename DeviceTypeT = Aws::String>
  InferenceAccelerator& WithDeviceType(DeviceTypeT&& value) {
    SetDeviceType(std::forward<DeviceTypeT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_deviceName;
  bool m_deviceNameHasBeenSet = false;

  Aws::String m_deviceType;
  bool m_deviceTypeHasBeenSet = false;
};

}  // namespace Model
}  // namespace ECS
}  // namespace Aws
