﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/resource-groups/ResourceGroups_EXPORTS.h>
#include <aws/resource-groups/model/GroupQuery.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ResourceGroups {
namespace Model {
class GetGroupQueryResult {
 public:
  AWS_RESOURCEGROUPS_API GetGroupQueryResult() = default;
  AWS_RESOURCEGROUPS_API GetGroupQueryResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_RESOURCEGROUPS_API GetGroupQueryResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The resource query associated with the specified group. For more information
   * about resource queries, see <a
   * href="https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag">Create
   * a tag-based group in Resource Groups</a>.</p>
   */
  inline const GroupQuery& GetGroupQuery() const { return m_groupQuery; }
  template <typename GroupQueryT = GroupQuery>
  void SetGroupQuery(GroupQueryT&& value) {
    m_groupQueryHasBeenSet = true;
    m_groupQuery = std::forward<GroupQueryT>(value);
  }
  template <typename GroupQueryT = GroupQuery>
  GetGroupQueryResult& WithGroupQuery(GroupQueryT&& value) {
    SetGroupQuery(std::forward<GroupQueryT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetGroupQueryResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  GroupQuery m_groupQuery;
  bool m_groupQueryHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ResourceGroups
}  // namespace Aws
