﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/macie2/Macie2_EXPORTS.h>

namespace Aws {
namespace Macie2 {
namespace Model {
enum class ErrorCode { NOT_SET, ClientError, InternalError };

namespace ErrorCodeMapper {
AWS_MACIE2_API ErrorCode GetErrorCodeForName(const Aws::String& name);

AWS_MACIE2_API Aws::String GetNameForErrorCode(ErrorCode value);
}  // namespace ErrorCodeMapper
}  // namespace Model
}  // namespace Macie2
}  // namespace Aws
