# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "consumption budget list",
    is_preview=True,
)
class List(AAZCommand):
    """List budgets for an Azure subscription.
    """

    _aaz_info = {
        "version": "2023-05-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/providers/microsoft.consumption/budgets", "2023-05-01"],
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.consumption/budgets", "2023-05-01"],
        ]
    }

    AZ_SUPPORT_PAGINATION = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_paging(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.resource_group = AAZResourceGroupNameArg()
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        condition_0 = has_value(self.ctx.args.resource_group) and has_value(self.ctx.subscription_id)
        condition_1 = has_value(self.ctx.subscription_id) and has_value(self.ctx.args.resource_group) is not True
        if condition_0:
            self.BudgetsListByResourceGroupName(ctx=self.ctx)()
        if condition_1:
            self.BudgetsList(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance.value, client_flatten=True)
        next_link = self.deserialize_output(self.ctx.vars.instance.next_link)
        return result, next_link

    class BudgetsListByResourceGroupName(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Consumption/budgets",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2023-05-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.next_link = AAZStrType(
                serialized_name="nextLink",
                flags={"read_only": True},
            )
            _schema_on_200.value = AAZListType(
                flags={"read_only": True},
            )

            value = cls._schema_on_200.value
            value.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element
            _element.e_tag = AAZStrType(
                serialized_name="eTag",
            )
            _element.id = AAZStrType(
                flags={"read_only": True},
            )
            _element.name = AAZStrType(
                flags={"read_only": True},
            )
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200.value.Element.properties
            properties.amount = AAZFloatType(
                flags={"required": True},
            )
            properties.category = AAZStrType(
                flags={"required": True},
            )
            properties.current_spend = AAZObjectType(
                serialized_name="currentSpend",
            )
            properties.filters = AAZObjectType()
            properties.notifications = AAZDictType()
            properties.time_grain = AAZStrType(
                serialized_name="timeGrain",
                flags={"required": True},
            )
            properties.time_period = AAZObjectType(
                serialized_name="timePeriod",
                flags={"required": True},
            )

            current_spend = cls._schema_on_200.value.Element.properties.current_spend
            current_spend.amount = AAZFloatType(
                flags={"read_only": True},
            )
            current_spend.unit = AAZStrType(
                flags={"read_only": True},
            )

            filters = cls._schema_on_200.value.Element.properties.filters
            filters.meters = AAZListType()
            filters.resource_groups = AAZListType(
                serialized_name="resourceGroups",
            )
            filters.resources = AAZListType()

            meters = cls._schema_on_200.value.Element.properties.filters.meters
            meters.Element = AAZStrType()

            resource_groups = cls._schema_on_200.value.Element.properties.filters.resource_groups
            resource_groups.Element = AAZStrType()

            resources = cls._schema_on_200.value.Element.properties.filters.resources
            resources.Element = AAZStrType()

            notifications = cls._schema_on_200.value.Element.properties.notifications
            notifications.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.notifications.Element
            _element.contact_emails = AAZListType(
                serialized_name="contactEmails",
                flags={"required": True},
            )
            _element.contact_groups = AAZListType(
                serialized_name="contactGroups",
            )
            _element.contact_roles = AAZListType(
                serialized_name="contactRoles",
            )
            _element.enabled = AAZBoolType(
                flags={"required": True},
            )
            _element.operator = AAZStrType(
                flags={"required": True},
            )
            _element.threshold = AAZFloatType(
                flags={"required": True},
            )

            contact_emails = cls._schema_on_200.value.Element.properties.notifications.Element.contact_emails
            contact_emails.Element = AAZStrType()

            contact_groups = cls._schema_on_200.value.Element.properties.notifications.Element.contact_groups
            contact_groups.Element = AAZStrType()

            contact_roles = cls._schema_on_200.value.Element.properties.notifications.Element.contact_roles
            contact_roles.Element = AAZStrType()

            time_period = cls._schema_on_200.value.Element.properties.time_period
            time_period.end_date = AAZStrType(
                serialized_name="endDate",
            )
            time_period.start_date = AAZStrType(
                serialized_name="startDate",
                flags={"required": True},
            )

            return cls._schema_on_200

    class BudgetsList(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/providers/Microsoft.Consumption/budgets",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2023-05-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.next_link = AAZStrType(
                serialized_name="nextLink",
                flags={"read_only": True},
            )
            _schema_on_200.value = AAZListType(
                flags={"read_only": True},
            )

            value = cls._schema_on_200.value
            value.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element
            _element.e_tag = AAZStrType(
                serialized_name="eTag",
            )
            _element.id = AAZStrType(
                flags={"read_only": True},
            )
            _element.name = AAZStrType(
                flags={"read_only": True},
            )
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200.value.Element.properties
            properties.amount = AAZFloatType(
                flags={"required": True},
            )
            properties.category = AAZStrType(
                flags={"required": True},
            )
            properties.current_spend = AAZObjectType(
                serialized_name="currentSpend",
            )
            properties.filters = AAZObjectType()
            properties.notifications = AAZDictType()
            properties.time_grain = AAZStrType(
                serialized_name="timeGrain",
                flags={"required": True},
            )
            properties.time_period = AAZObjectType(
                serialized_name="timePeriod",
                flags={"required": True},
            )

            current_spend = cls._schema_on_200.value.Element.properties.current_spend
            current_spend.amount = AAZFloatType(
                flags={"read_only": True},
            )
            current_spend.unit = AAZStrType(
                flags={"read_only": True},
            )

            filters = cls._schema_on_200.value.Element.properties.filters
            filters.meters = AAZListType()
            filters.resource_groups = AAZListType(
                serialized_name="resourceGroups",
            )
            filters.resources = AAZListType()

            meters = cls._schema_on_200.value.Element.properties.filters.meters
            meters.Element = AAZStrType()

            resource_groups = cls._schema_on_200.value.Element.properties.filters.resource_groups
            resource_groups.Element = AAZStrType()

            resources = cls._schema_on_200.value.Element.properties.filters.resources
            resources.Element = AAZStrType()

            notifications = cls._schema_on_200.value.Element.properties.notifications
            notifications.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.notifications.Element
            _element.contact_emails = AAZListType(
                serialized_name="contactEmails",
                flags={"required": True},
            )
            _element.contact_groups = AAZListType(
                serialized_name="contactGroups",
            )
            _element.contact_roles = AAZListType(
                serialized_name="contactRoles",
            )
            _element.enabled = AAZBoolType(
                flags={"required": True},
            )
            _element.operator = AAZStrType(
                flags={"required": True},
            )
            _element.threshold = AAZFloatType(
                flags={"required": True},
            )

            contact_emails = cls._schema_on_200.value.Element.properties.notifications.Element.contact_emails
            contact_emails.Element = AAZStrType()

            contact_groups = cls._schema_on_200.value.Element.properties.notifications.Element.contact_groups
            contact_groups.Element = AAZStrType()

            contact_roles = cls._schema_on_200.value.Element.properties.notifications.Element.contact_roles
            contact_roles.Element = AAZStrType()

            time_period = cls._schema_on_200.value.Element.properties.time_period
            time_period.end_date = AAZStrType(
                serialized_name="endDate",
            )
            time_period.start_date = AAZStrType(
                serialized_name="startDate",
                flags={"required": True},
            )

            return cls._schema_on_200


class _ListHelper:
    """Helper class for List"""


__all__ = ["List"]
