/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.overview.resizable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.SwingConstants;
import javax.swing.border.Border;
import org.freeplane.view.swing.map.overview.MapViewPane;
import org.freeplane.view.swing.map.overview.resizable.ResizePanelMouseHandler;

public class ResizablePanelBorder
implements Border,
SwingConstants {
    private final int size;
    private final int extendedSize;

    public ResizablePanelBorder(int size, int extendedSize) {
        this.size = size;
        this.extendedSize = extendedSize;
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return new Insets(this.size, this.size, this.size, this.size);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component component, Graphics g, int x, int y, int w, int h) {
        MapViewPane mapViewPane = (MapViewPane)component.getParent();
        Color mapViewBackground = mapViewPane.getMapViewBackground();
        Color invertedColor = this.complementaryColor(mapViewBackground);
        g.setColor(mapViewBackground);
        g.fillRect(x, y, w, h);
        g.setColor(invertedColor);
        g.drawRect(x, y, w - 1, h - 1);
        Rectangle rect = new Rectangle(this.size, this.size);
        g.setColor(invertedColor);
        for (MouseActionableSite loc : MouseActionableSite.values()) {
            rect.setLocation(loc.getSiteLocation(new Dimension(w, h), this.size));
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
        }
    }

    private Color complementaryColor(Color color) {
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
    }

    public Cursor getResizeCursor(MouseEvent e) {
        Point mouseLocation;
        int height;
        Component c = e.getComponent();
        int width = c.getWidth();
        Rectangle bounds = new Rectangle(width, height = c.getHeight());
        if (!bounds.contains(mouseLocation = e.getPoint())) {
            return Cursor.getDefaultCursor();
        }
        Rectangle contentAreaBounds = new Rectangle(this.size, this.size, width - 2 * this.size, height - 2 * this.size);
        if (contentAreaBounds.contains(mouseLocation)) {
            return Cursor.getDefaultCursor();
        }
        Rectangle actionableRegion = new Rectangle(this.extendedSize, this.extendedSize);
        for (MouseActionableSite site : MouseActionableSite.values()) {
            actionableRegion.setLocation(site.getSiteLocation(c.getSize(), this.extendedSize));
            if (!actionableRegion.contains(mouseLocation)) continue;
            return site.getCursor();
        }
        return Cursor.getPredefinedCursor(ResizePanelMouseHandler.COMPAT_MOVE_CURSOR);
    }

    private static enum MouseActionableSite {
        NORTH(8){

            @Override
            Point getSiteLocation(Dimension componentSize, int borderSize) {
                return new Point(componentSize.width / 2 - borderSize / 2, 0);
            }
        }
        ,
        SOUTH(9){

            @Override
            Point getSiteLocation(Dimension componentSize, int borderSize) {
                return new Point(componentSize.width / 2 - borderSize / 2, componentSize.height - borderSize);
            }
        }
        ,
        WEST(10){

            @Override
            Point getSiteLocation(Dimension componentSize, int borderSize) {
                return new Point(0, componentSize.height / 2 - borderSize / 2);
            }
        }
        ,
        EAST(11){

            @Override
            public Point getSiteLocation(Dimension componentSize, int borderSize) {
                return new Point(componentSize.width - borderSize, componentSize.height / 2 - borderSize / 2);
            }
        }
        ,
        NORTH_WEST(6){

            @Override
            Point getSiteLocation(Dimension componentSize, int borderSize) {
                return new Point(0, 0);
            }
        }
        ,
        NORTH_EAST(7){

            @Override
            Point getSiteLocation(Dimension componentSize, int borderSize) {
                return new Point(componentSize.width - borderSize, 0);
            }
        }
        ,
        SOUTH_WEST(4){

            @Override
            Point getSiteLocation(Dimension componentSize, int borderSize) {
                return new Point(0, componentSize.height - borderSize);
            }
        }
        ,
        SOUTH_EAST(5){

            @Override
            Point getSiteLocation(Dimension componentSize, int borderSize) {
                return new Point(componentSize.width - borderSize, componentSize.height - borderSize);
            }
        };

        private final int cursor;

        private MouseActionableSite(int cursor) {
            this.cursor = cursor;
        }

        abstract Point getSiteLocation(Dimension var1, int var2);

        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(this.cursor);
        }
    }
}

