/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.utils;

import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GrRangeExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrFinallyClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrAssertStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrBreakStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrContinueStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrArrayDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrElvisExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrInstanceOfExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTypeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public final class EquivalenceChecker {
    private static final int LITERAL_EXPRESSION = 1;
    private static final int REFERENCE_EXPRESSION = 3;
    private static final int CALL_EXPRESSION = 5;
    private static final int NEW_EXPRESSION = 6;
    private static final int ARRAY_LITERAL_EXPRESSION = 7;
    private static final int CLOSABLE_BLOCK_EXPRESSION = 8;
    private static final int PREFIX_EXPRESSION = 10;
    private static final int POSTFIX_EXPRESSION = 11;
    private static final int BINARY_EXPRESSION = 12;
    private static final int CONDITIONAL_EXPRESSION = 13;
    private static final int ASSIGNMENT_EXPRESSION = 14;
    private static final int ELVIS_EXPRESSION = 15;
    private static final int TYPE_CAST_EXPRESSION = 16;
    private static final int SAFE_CAST_EXPRESSION = 17;
    private static final int INSTANCEOF_EXPRESSION = 18;
    private static final int RANGE_EXPRESSION = 19;
    private static final int LIST_OR_MAP_EXPRESSION = 20;
    private static final int INDEX_EXPRESSION = 21;
    private static final int PROPERTY_SELECTION_EXPRESSION = 22;
    private static final int BLOCK_STATEMENT = 1;
    private static final int BREAK_STATEMENT = 2;
    private static final int CONTINUE_STATEMENT = 3;
    private static final int VAR_STATEMENT = 4;
    private static final int EMPTY_STATEMENT = 6;
    private static final int EXPRESSION_STATEMENT = 8;
    private static final int FOR_STATEMENT = 9;
    private static final int IF_STATEMENT = 10;
    private static final int RETURN_STATEMENT = 12;
    private static final int SWITCH_STATEMENT = 14;
    private static final int THROW_STATEMENT = 16;
    private static final int TRY_STATEMENT = 17;
    private static final int WHILE_STATEMENT = 18;
    private static final int SYNCHRONIZED_STATEMENT = 19;
    private static final int ASSERT_STATEMENT = 20;
    private static final int APPLICATION_STATEMENT = 21;

    private EquivalenceChecker() {
    }

    public static boolean statementsAreEquivalent(@Nullable GrStatement exp1, @Nullable GrStatement exp2) {
        int type2;
        if (exp1 == null && exp2 == null) {
            return true;
        }
        if (exp1 == null || exp2 == null) {
            return false;
        }
        int type1 = EquivalenceChecker.getStatementType(exp1);
        if (type1 != (type2 = EquivalenceChecker.getStatementType(exp2))) {
            return false;
        }
        return switch (type1) {
            case 1 -> EquivalenceChecker.blockStatementsAreEquivalent((GrBlockStatement)exp1, (GrBlockStatement)exp2);
            case 2, 3, 6 -> true;
            case 4 -> EquivalenceChecker.varStatementsAreEquivalent((GrVariableDeclaration)exp1, (GrVariableDeclaration)exp2);
            case 21 -> EquivalenceChecker.applicationStatementsAreEquivalent((GrApplicationStatement)exp1, (GrApplicationStatement)exp2);
            case 8 -> EquivalenceChecker.expressionStatementsAreEquivalent((GrExpression)exp1, (GrExpression)exp2);
            case 9 -> EquivalenceChecker.forInStatementsAreEquivalent((GrForStatement)exp1, (GrForStatement)exp2);
            case 10 -> EquivalenceChecker.ifStatementsAreEquivalent((GrIfStatement)exp1, (GrIfStatement)exp2);
            case 12 -> EquivalenceChecker.returnStatementsAreEquivalent((GrReturnStatement)exp1, (GrReturnStatement)exp2);
            case 14 -> EquivalenceChecker.switchStatementsAreEquivalent((GrSwitchStatement)exp1, (GrSwitchStatement)exp2);
            case 16 -> EquivalenceChecker.throwStatementsAreEquivalent((GrThrowStatement)exp1, (GrThrowStatement)exp2);
            case 17 -> EquivalenceChecker.tryStatementsAreEquivalent((GrTryCatchStatement)exp1, (GrTryCatchStatement)exp2);
            case 18 -> EquivalenceChecker.whileStatementsAreEquivalent((GrWhileStatement)exp1, (GrWhileStatement)exp2);
            case 19 -> EquivalenceChecker.synchronizedStatementsAreEquivalent((GrSynchronizedStatement)exp1, (GrSynchronizedStatement)exp2);
            case 20 -> EquivalenceChecker.assertStatementsAreEquivalent((GrAssertStatement)exp1, (GrAssertStatement)exp2);
            default -> false;
        };
    }

    private static boolean applicationStatementsAreEquivalent(GrApplicationStatement statement1, GrApplicationStatement statement2) {
        GrNamedArgument[] namedArgs2;
        GrExpression[] args2;
        GrExpression funExpression2;
        GrExpression funExpression1 = statement1.getInvokedExpression();
        if (!EquivalenceChecker.expressionsAreEquivalent(funExpression1, funExpression2 = statement2.getInvokedExpression())) {
            return false;
        }
        GrCommandArgumentList argumentList1 = statement1.getArgumentList();
        GrCommandArgumentList argumentList2 = statement2.getArgumentList();
        GrExpression[] args1 = argumentList1.getExpressionArguments();
        if (!EquivalenceChecker.expressionListsAreEquivalent(args1, args2 = argumentList2.getExpressionArguments())) {
            return false;
        }
        GrNamedArgument[] namedArgs1 = argumentList1.getNamedArguments();
        return EquivalenceChecker.namedArgumentListsAreEquivalent(namedArgs1, namedArgs2 = argumentList2.getNamedArguments());
    }

    private static boolean assertStatementsAreEquivalent(GrAssertStatement statement1, GrAssertStatement statement2) {
        return EquivalenceChecker.expressionsAreEquivalent(statement1.getAssertion(), statement2.getAssertion()) && EquivalenceChecker.expressionsAreEquivalent(statement1.getErrorMessage(), statement2.getErrorMessage());
    }

    private static boolean synchronizedStatementsAreEquivalent(GrSynchronizedStatement statement1, GrSynchronizedStatement statement2) {
        return EquivalenceChecker.expressionsAreEquivalent(statement1.getMonitor(), statement2.getMonitor()) && EquivalenceChecker.openBlocksAreEquivalent(statement1.getBody(), statement2.getBody());
    }

    private static boolean varStatementsAreEquivalent(@NotNull GrVariableDeclaration statement1, @NotNull GrVariableDeclaration statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(0);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(1);
        }
        Object[] variables1 = statement1.getVariables();
        Object[] variables2 = statement2.getVariables();
        return ArrayUtil.areEqual((Object[])variables1, (Object[])variables2, (v1, v2) -> EquivalenceChecker.variablesAreEquivalent(v1, v2));
    }

    private static boolean variablesAreEquivalent(@NotNull GrVariable var1, @NotNull GrVariable var2) {
        PsiType type2;
        GrExpression initializer2;
        GrExpression initializer1;
        if (var1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(2);
        }
        if (var2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(3);
        }
        if (!EquivalenceChecker.expressionsAreEquivalent(initializer1 = var1.getInitializerGroovy(), initializer2 = var2.getInitializerGroovy())) {
            return false;
        }
        PsiType type1 = var1.getType();
        if (!EquivalenceChecker.typesAreEquivalent(type1, type2 = var2.getType())) {
            return false;
        }
        String name1 = var1.getName();
        String name2 = var2.getName();
        return name1.equals(name2);
    }

    private static boolean tryStatementsAreEquivalent(@NotNull GrTryCatchStatement statement1, @NotNull GrTryCatchStatement statement2) {
        GrOpenBlock tryBlock2;
        GrOpenBlock tryBlock1;
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(4);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(5);
        }
        if (!EquivalenceChecker.openBlocksAreEquivalent(tryBlock1 = statement1.getTryBlock(), tryBlock2 = statement2.getTryBlock())) {
            return false;
        }
        GrFinallyClause finallyBlock1 = statement1.getFinallyClause();
        GrFinallyClause finallyBlock2 = statement2.getFinallyClause();
        if (finallyBlock1 != null ? finallyBlock2 == null || !EquivalenceChecker.openBlocksAreEquivalent(finallyBlock1.getBody(), finallyBlock2.getBody()) : finallyBlock2 != null) {
            return false;
        }
        Object[] catchBlocks1 = statement1.getCatchClauses();
        Object[] catchBlocks2 = statement2.getCatchClauses();
        return ArrayUtil.areEqual((Object[])catchBlocks1, (Object[])catchBlocks2, (c1, c2) -> EquivalenceChecker.catchClausesAreEquivalent(c1, c2));
    }

    private static boolean catchClausesAreEquivalent(GrCatchClause clause1, GrCatchClause clause2) {
        return EquivalenceChecker.parametersAreEquivalent(clause1.getParameter(), clause2.getParameter()) && EquivalenceChecker.openBlocksAreEquivalent(clause1.getBody(), clause2.getBody());
    }

    private static boolean parametersAreEquivalent(@Nullable GrParameter parameter1, @Nullable GrParameter parameter2) {
        PsiType type2;
        if (parameter1 == null || parameter2 == null) {
            return false;
        }
        PsiType type1 = parameter1.getType();
        if (!EquivalenceChecker.typesAreEquivalent(type1, type2 = parameter2.getType())) {
            return false;
        }
        String name1 = parameter1.getName();
        String name2 = parameter2.getName();
        return name1.equals(name2);
    }

    private static boolean typesAreEquivalent(@Nullable PsiType type1, @Nullable PsiType type2) {
        return Objects.equals(type1, type2);
    }

    private static boolean whileStatementsAreEquivalent(@NotNull GrWhileStatement statement1, @NotNull GrWhileStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(6);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(7);
        }
        GrExpression condition1 = statement1.getCondition();
        GrExpression condition2 = statement2.getCondition();
        GrStatement body1 = statement1.getBody();
        GrStatement body2 = statement2.getBody();
        return EquivalenceChecker.expressionsAreEquivalent(condition1, condition2) && EquivalenceChecker.statementsAreEquivalent(body1, body2);
    }

    private static boolean forInStatementsAreEquivalent(@NotNull GrForStatement statement1, @NotNull GrForStatement statement2) {
        GrForClause clause2;
        GrForClause clause1;
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(8);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(9);
        }
        if (!EquivalenceChecker.forClausesAreEquivalent(clause1 = statement1.getClause(), clause2 = statement2.getClause())) {
            return false;
        }
        GrStatement body1 = statement1.getBody();
        GrStatement body2 = statement2.getBody();
        return EquivalenceChecker.statementsAreEquivalent(body1, body2);
    }

    private static boolean forClausesAreEquivalent(@Nullable GrForClause statement1, @Nullable GrForClause statement2) {
        if (statement1 == null && statement2 == null) {
            return true;
        }
        if (statement1 == null || statement2 == null) {
            return false;
        }
        Object[] variables1 = statement1.getDeclaredVariables();
        Object[] variables2 = statement2.getDeclaredVariables();
        return ArrayUtil.areEqual((Object[])variables1, (Object[])variables2, (var1, var2) -> var1 == null && var2 == null || var1 != null && var2 != null && EquivalenceChecker.variablesAreEquivalent(var1, var2));
    }

    private static boolean switchStatementsAreEquivalent(@NotNull GrSwitchStatement statement1, @NotNull GrSwitchStatement statement2) {
        GrExpression switchExpression2;
        GrExpression switchExpression1;
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(10);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(11);
        }
        if (!EquivalenceChecker.expressionsAreEquivalent(switchExpression1 = statement1.getCondition(), switchExpression2 = statement2.getCondition())) {
            return false;
        }
        Object[] clauses1 = statement1.getCaseSections();
        Object[] clauses2 = statement2.getCaseSections();
        return ArrayUtil.areEqual((Object[])clauses1, (Object[])clauses2, (c1, c2) -> EquivalenceChecker.caseClausesAreEquivalent(c1, c2));
    }

    private static boolean caseClausesAreEquivalent(GrCaseSection clause1, GrCaseSection clause2) {
        return ArrayUtil.areEqual((Object[])clause1.getExpressions(), (Object[])clause2.getExpressions(), (l1, l2) -> EquivalenceChecker.expressionsAreEquivalent(l1, l2)) && ArrayUtil.areEqual((Object[])clause1.getStatements(), (Object[])clause2.getStatements(), (s1, s2) -> EquivalenceChecker.statementsAreEquivalent(s1, s2));
    }

    private static boolean blockStatementsAreEquivalent(@NotNull GrBlockStatement statement1, @NotNull GrBlockStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(12);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(13);
        }
        GrOpenBlock block1 = statement1.getBlock();
        GrOpenBlock block2 = statement2.getBlock();
        return EquivalenceChecker.openBlocksAreEquivalent(block1, block2);
    }

    private static boolean openBlocksAreEquivalent(@Nullable GrOpenBlock block1, @Nullable GrOpenBlock block2) {
        if (block1 == null || block2 == null) {
            return false;
        }
        return ArrayUtil.areEqual((Object[])block1.getStatements(), (Object[])block2.getStatements(), (s1, s2) -> EquivalenceChecker.statementsAreEquivalent(s1, s2));
    }

    private static boolean ifStatementsAreEquivalent(@NotNull GrIfStatement statement1, @NotNull GrIfStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(14);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(15);
        }
        GrExpression condition1 = statement1.getCondition();
        GrExpression condition2 = statement2.getCondition();
        GrStatement thenBranch1 = statement1.getThenBranch();
        GrStatement thenBranch2 = statement2.getThenBranch();
        GrStatement elseBranch1 = statement1.getElseBranch();
        GrStatement elseBranch2 = statement2.getElseBranch();
        return EquivalenceChecker.expressionsAreEquivalent(condition1, condition2) && EquivalenceChecker.statementsAreEquivalent(thenBranch1, thenBranch2) && EquivalenceChecker.statementsAreEquivalent(elseBranch1, elseBranch2);
    }

    private static boolean expressionStatementsAreEquivalent(@NotNull GrExpression statement1, @NotNull GrExpression statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(16);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(17);
        }
        return EquivalenceChecker.expressionsAreEquivalent(statement1, statement2);
    }

    private static boolean returnStatementsAreEquivalent(@NotNull GrReturnStatement statement1, @NotNull GrReturnStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(18);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(19);
        }
        GrExpression returnValue1 = statement1.getReturnValue();
        GrExpression returnValue2 = statement2.getReturnValue();
        return EquivalenceChecker.expressionsAreEquivalent(returnValue1, returnValue2);
    }

    private static boolean throwStatementsAreEquivalent(@NotNull GrThrowStatement statement1, @NotNull GrThrowStatement statement2) {
        if (statement1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(20);
        }
        if (statement2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(21);
        }
        GrExpression exception1 = statement1.getException();
        GrExpression exception2 = statement2.getException();
        return EquivalenceChecker.expressionsAreEquivalent(exception1, exception2);
    }

    public static boolean expressionsAreEquivalent(@Nullable GrExpression exp1, @Nullable GrExpression exp2) {
        int type2;
        if (exp1 == null && exp2 == null) {
            return true;
        }
        if (exp1 == null || exp2 == null) {
            return false;
        }
        GrExpression expToCompare1 = (GrExpression)PsiUtil.skipParentheses(exp1, false);
        GrExpression expToCompare2 = (GrExpression)PsiUtil.skipParentheses(exp2, false);
        int type1 = EquivalenceChecker.getExpressionType(expToCompare1);
        if (type1 != (type2 = EquivalenceChecker.getExpressionType(expToCompare2))) {
            return false;
        }
        return switch (type1) {
            case 1, 3 -> {
                String text1 = expToCompare1.getText();
                String text2 = expToCompare2.getText();
                yield text1.equals(text2);
            }
            case 5 -> EquivalenceChecker.methodCallExpressionsAreEquivalent((GrMethodCall)expToCompare1, (GrMethodCall)expToCompare2);
            case 6 -> EquivalenceChecker.newExpressionsAreEquivalent((GrNewExpression)expToCompare1, (GrNewExpression)expToCompare2);
            case 10 -> EquivalenceChecker.prefixExpressionsAreEquivalent((GrUnaryExpression)expToCompare1, (GrUnaryExpression)expToCompare2);
            case 11 -> EquivalenceChecker.postfixExpressionsAreEquivalent((GrUnaryExpression)expToCompare1, (GrUnaryExpression)expToCompare2);
            case 12 -> EquivalenceChecker.binaryExpressionsAreEquivalent((GrBinaryExpression)expToCompare1, (GrBinaryExpression)expToCompare2);
            case 14 -> EquivalenceChecker.assignmentExpressionsAreEquivalent((GrAssignmentExpression)expToCompare1, (GrAssignmentExpression)expToCompare2);
            case 13 -> EquivalenceChecker.conditionalExpressionsAreEquivalent((GrConditionalExpression)expToCompare1, (GrConditionalExpression)expToCompare2);
            case 15 -> EquivalenceChecker.elvisExpressionsAreEquivalent((GrElvisExpression)expToCompare1, (GrElvisExpression)expToCompare2);
            case 19 -> EquivalenceChecker.rangeExpressionsAreEquivalent((GrRangeExpression)expToCompare1, (GrRangeExpression)expToCompare2);
            case 16 -> EquivalenceChecker.typecastExpressionsAreEquivalent((GrTypeCastExpression)expToCompare1, (GrTypeCastExpression)expToCompare2);
            case 17 -> EquivalenceChecker.safeCastExpressionsAreEquivalent((GrSafeCastExpression)expToCompare1, (GrSafeCastExpression)expToCompare2);
            case 18 -> EquivalenceChecker.instanceofExpressionsAreEquivalent((GrInstanceOfExpression)expToCompare1, (GrInstanceOfExpression)expToCompare2);
            case 21 -> EquivalenceChecker.indexExpressionsAreEquivalent((GrIndexProperty)expToCompare1, (GrIndexProperty)expToCompare2);
            case 20 -> EquivalenceChecker.listOrMapExpressionsAreEquivalent((GrListOrMap)expToCompare1, (GrListOrMap)expToCompare2);
            case 8 -> EquivalenceChecker.closableBlockExpressionsAreEquivalent((GrClosableBlock)expToCompare1, (GrClosableBlock)expToCompare2);
            case 22 -> EquivalenceChecker.textOfExpressionsIsEquivalent(expToCompare1, expToCompare2);
            default -> false;
        };
    }

    private static boolean textOfExpressionsIsEquivalent(GrExpression expToCompare1, GrExpression expToCompare2) {
        String text1 = expToCompare1.getText();
        String text2 = expToCompare2.getText();
        return text1.equals(text2);
    }

    private static boolean closableBlockExpressionsAreEquivalent(GrClosableBlock closableBlock1, GrClosableBlock closableBlock2) {
        return ArrayUtil.areEqual((Object[])closableBlock1.getStatements(), (Object[])closableBlock2.getStatements(), (s1, s2) -> EquivalenceChecker.statementsAreEquivalent(s1, s2)) && ArrayUtil.areEqual((Object[])closableBlock1.getParameters(), (Object[])closableBlock2.getParameters(), (p1, p2) -> EquivalenceChecker.parametersAreEquivalent(p1, p2));
    }

    private static boolean listOrMapExpressionsAreEquivalent(GrListOrMap expression1, GrListOrMap expression2) {
        return expression1.isMap() == expression2.isMap() && EquivalenceChecker.expressionListsAreEquivalent(expression1.getInitializers(), expression2.getInitializers()) && EquivalenceChecker.namedArgumentListsAreEquivalent(expression1.getNamedArguments(), expression2.getNamedArguments());
    }

    private static boolean arrayDeclarationsAreEquivalent(GrArrayDeclaration declaration1, GrArrayDeclaration declaration2) {
        int count2;
        int count1 = declaration1.getArrayCount();
        if (count1 != (count2 = declaration2.getArrayCount())) {
            return false;
        }
        GrExpression[] bounds1 = declaration1.getBoundExpressions();
        GrExpression[] bounds2 = declaration2.getBoundExpressions();
        return EquivalenceChecker.expressionListsAreEquivalent(bounds1, bounds2);
    }

    private static boolean instanceofExpressionsAreEquivalent(GrInstanceOfExpression expression1, GrInstanceOfExpression expression2) {
        GrExpression operand2;
        GrExpression operand1 = expression1.getOperand();
        if (!EquivalenceChecker.expressionsAreEquivalent(operand1, operand2 = expression2.getOperand())) {
            return false;
        }
        GrTypeElement typeElement1 = expression1.getTypeElement();
        GrTypeElement typeElement2 = expression2.getTypeElement();
        if (typeElement1 == null || typeElement2 == null) {
            return false;
        }
        PsiType type1 = typeElement1.getType();
        PsiType type2 = typeElement2.getType();
        return EquivalenceChecker.typesAreEquivalent(type1, type2);
    }

    private static boolean indexExpressionsAreEquivalent(GrIndexProperty expression1, GrIndexProperty expression2) {
        return EquivalenceChecker.expressionsAreEquivalent(expression1.getInvokedExpression(), expression2.getInvokedExpression()) && EquivalenceChecker.argumentListsAreEquivalent(expression1.getArgumentList(), expression2.getArgumentList());
    }

    private static boolean typecastExpressionsAreEquivalent(GrTypeCastExpression expression1, GrTypeCastExpression expression2) {
        GrExpression operand2;
        GrExpression operand1 = expression1.getOperand();
        if (!EquivalenceChecker.expressionsAreEquivalent(operand1, operand2 = expression2.getOperand())) {
            return false;
        }
        PsiType type1 = expression1.getCastTypeElement().getType();
        PsiType type2 = expression2.getCastTypeElement().getType();
        return EquivalenceChecker.typesAreEquivalent(type1, type2);
    }

    private static boolean safeCastExpressionsAreEquivalent(GrSafeCastExpression expression1, GrSafeCastExpression expression2) {
        GrExpression operand2;
        GrExpression operand1 = expression1.getOperand();
        if (!EquivalenceChecker.expressionsAreEquivalent(operand1, operand2 = expression2.getOperand())) {
            return false;
        }
        GrTypeElement typeElement1 = expression1.getCastTypeElement();
        GrTypeElement typeElement2 = expression2.getCastTypeElement();
        PsiType safe1 = typeElement1 == null ? null : typeElement1.getType();
        PsiType safe2 = typeElement2 == null ? null : typeElement2.getType();
        return EquivalenceChecker.typesAreEquivalent(safe1, safe2);
    }

    private static boolean methodCallExpressionsAreEquivalent(@NotNull GrMethodCall methodExp1, @NotNull GrMethodCall methodExp2) {
        GrExpression[] closures2;
        GrExpression methodExpression2;
        GrExpression methodExpression1;
        if (methodExp1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(22);
        }
        if (methodExp2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(23);
        }
        if (!EquivalenceChecker.expressionsAreEquivalent(methodExpression1 = methodExp1.getInvokedExpression(), methodExpression2 = methodExp2.getInvokedExpression())) {
            return false;
        }
        GrExpression[] closures1 = methodExp1.getClosureArguments();
        if (!EquivalenceChecker.expressionListsAreEquivalent(closures1, closures2 = methodExp2.getClosureArguments())) {
            return false;
        }
        return EquivalenceChecker.argumentListsAreEquivalent(methodExp1.getArgumentList(), methodExp2.getArgumentList());
    }

    private static boolean argumentListsAreEquivalent(@Nullable GrArgumentList list1, @Nullable GrArgumentList list2) {
        GrNamedArgument[] namedArgs2;
        GrExpression[] args2;
        if (list1 == null && list2 == null) {
            return true;
        }
        if (list1 == null || list2 == null) {
            return false;
        }
        GrExpression[] args1 = list1.getExpressionArguments();
        if (!EquivalenceChecker.expressionListsAreEquivalent(args1, args2 = list2.getExpressionArguments())) {
            return false;
        }
        GrNamedArgument[] namedArgs1 = list1.getNamedArguments();
        return EquivalenceChecker.namedArgumentListsAreEquivalent(namedArgs1, namedArgs2 = list2.getNamedArguments());
    }

    private static boolean namedArgumentListsAreEquivalent(GrNamedArgument[] namedArgs1, GrNamedArgument[] namedArgs2) {
        if (namedArgs1.length != namedArgs2.length) {
            return false;
        }
        for (GrNamedArgument arg1 : namedArgs1) {
            GrArgumentLabel label1 = arg1.getLabel();
            if (label1 == null) {
                return false;
            }
            String name1 = label1.getName();
            boolean found = false;
            GrExpression expression1 = arg1.getExpression();
            for (GrNamedArgument arg2 : namedArgs2) {
                GrArgumentLabel label2 = arg2.getLabel();
                if (label2 == null) {
                    return false;
                }
                String name2 = label2.getName();
                GrExpression expression2 = arg2.getExpression();
                if (name1 == null) {
                    if (name2 != null || !EquivalenceChecker.expressionsAreEquivalent((GrExpression)label1.getNameElement(), (GrExpression)label2.getNameElement()) || !EquivalenceChecker.expressionsAreEquivalent(expression1, expression2)) continue;
                    found = true;
                    break;
                }
                if (!name1.equals(name2) || !EquivalenceChecker.expressionsAreEquivalent(expression1, expression2)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private static boolean newExpressionsAreEquivalent(@NotNull GrNewExpression newExp1, @NotNull GrNewExpression newExp2) {
        if (newExp1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(24);
        }
        if (newExp2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(25);
        }
        if (newExp1.getArrayCount() == newExp2.getArrayCount() && newExp1.getArrayCount() != 0) {
            GrCodeReferenceElement referenceElement1 = newExp1.getReferenceElement();
            GrCodeReferenceElement referenceElement2 = newExp2.getReferenceElement();
            if (referenceElement1 == null || referenceElement2 == null) {
                return referenceElement1 == referenceElement2;
            }
            if (referenceElement1.resolve() != referenceElement2.resolve()) {
                return false;
            }
            GrArrayDeclaration arrayDeclaration1 = newExp1.getArrayDeclaration();
            GrArrayDeclaration arrayDeclaration2 = newExp2.getArrayDeclaration();
            if (arrayDeclaration1 == null || arrayDeclaration2 == null) {
                return arrayDeclaration1 == arrayDeclaration2;
            }
            return EquivalenceChecker.arrayDeclarationsAreEquivalent(arrayDeclaration1, arrayDeclaration2);
        }
        PsiMethod constructor1 = newExp1.resolveMethod();
        PsiMethod constructor2 = newExp2.resolveMethod();
        if (constructor1 == null || constructor2 == null || !constructor1.equals(constructor2)) {
            return false;
        }
        return EquivalenceChecker.argumentListsAreEquivalent(newExp1.getArgumentList(), newExp2.getArgumentList());
    }

    private static boolean prefixExpressionsAreEquivalent(@NotNull GrUnaryExpression prefixExp1, @NotNull GrUnaryExpression prefixExp2) {
        IElementType sign2;
        IElementType sign1;
        if (prefixExp1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(26);
        }
        if (prefixExp2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(27);
        }
        if ((sign1 = prefixExp1.getOperationTokenType()) != (sign2 = prefixExp2.getOperationTokenType())) {
            return false;
        }
        GrExpression operand1 = prefixExp1.getOperand();
        GrExpression operand2 = prefixExp2.getOperand();
        return EquivalenceChecker.expressionsAreEquivalent(operand1, operand2);
    }

    private static boolean postfixExpressionsAreEquivalent(@NotNull GrUnaryExpression postfixExp1, @NotNull GrUnaryExpression postfixExp2) {
        IElementType sign2;
        IElementType sign1;
        if (postfixExp1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(28);
        }
        if (postfixExp2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(29);
        }
        if ((sign1 = postfixExp1.getOperationTokenType()) != (sign2 = postfixExp2.getOperationTokenType())) {
            return false;
        }
        GrExpression operand1 = postfixExp1.getOperand();
        GrExpression operand2 = postfixExp2.getOperand();
        return EquivalenceChecker.expressionsAreEquivalent(operand1, operand2);
    }

    private static boolean binaryExpressionsAreEquivalent(@NotNull GrBinaryExpression binaryExp1, @NotNull GrBinaryExpression binaryExp2) {
        IElementType sign2;
        IElementType sign1;
        if (binaryExp1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(30);
        }
        if (binaryExp2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(31);
        }
        if ((sign1 = binaryExp1.getOperationTokenType()) != (sign2 = binaryExp2.getOperationTokenType())) {
            return false;
        }
        GrExpression lhs1 = binaryExp1.getLeftOperand();
        GrExpression lhs2 = binaryExp2.getLeftOperand();
        GrExpression rhs1 = binaryExp1.getRightOperand();
        GrExpression rhs2 = binaryExp2.getRightOperand();
        return EquivalenceChecker.expressionsAreEquivalent(lhs1, lhs2) && EquivalenceChecker.expressionsAreEquivalent(rhs1, rhs2);
    }

    private static boolean rangeExpressionsAreEquivalent(@NotNull GrRangeExpression rangeExp1, @NotNull GrRangeExpression rangeExp2) {
        if (rangeExp1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(32);
        }
        if (rangeExp2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(33);
        }
        return EquivalenceChecker.expressionsAreEquivalent(rangeExp1.getFrom(), rangeExp2.getFrom()) && EquivalenceChecker.expressionsAreEquivalent(rangeExp1.getTo(), rangeExp2.getTo()) && rangeExp1.getBoundaryType() == rangeExp2.getBoundaryType();
    }

    private static boolean assignmentExpressionsAreEquivalent(@NotNull GrAssignmentExpression assignExp1, @NotNull GrAssignmentExpression assignExp2) {
        IElementType sign2;
        IElementType sign1;
        if (assignExp1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(34);
        }
        if (assignExp2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(35);
        }
        if ((sign1 = assignExp1.getOperationTokenType()) != (sign2 = assignExp2.getOperationTokenType())) {
            return false;
        }
        GrExpression lhs1 = assignExp1.getLValue();
        GrExpression lhs2 = assignExp2.getLValue();
        GrExpression rhs1 = assignExp1.getRValue();
        GrExpression rhs2 = assignExp2.getRValue();
        return EquivalenceChecker.expressionsAreEquivalent(lhs1, lhs2) && EquivalenceChecker.expressionsAreEquivalent(rhs1, rhs2);
    }

    private static boolean conditionalExpressionsAreEquivalent(@NotNull GrConditionalExpression condExp1, @NotNull GrConditionalExpression condExp2) {
        if (condExp1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(36);
        }
        if (condExp2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(37);
        }
        GrExpression condition1 = condExp1.getCondition();
        GrExpression condition2 = condExp2.getCondition();
        GrExpression thenExpression1 = condExp1.getThenBranch();
        GrExpression thenExpression2 = condExp2.getThenBranch();
        GrExpression elseExpression1 = condExp1.getElseBranch();
        GrExpression elseExpression2 = condExp2.getElseBranch();
        return EquivalenceChecker.expressionsAreEquivalent(condition1, condition2) && EquivalenceChecker.expressionsAreEquivalent(thenExpression1, thenExpression2) && EquivalenceChecker.expressionsAreEquivalent(elseExpression1, elseExpression2);
    }

    private static boolean elvisExpressionsAreEquivalent(@NotNull GrElvisExpression condExp1, @NotNull GrElvisExpression condExp2) {
        if (condExp1 == null) {
            EquivalenceChecker.$$$reportNull$$$0(38);
        }
        if (condExp2 == null) {
            EquivalenceChecker.$$$reportNull$$$0(39);
        }
        GrExpression condition1 = condExp1.getCondition();
        GrExpression condition2 = condExp2.getCondition();
        GrExpression elseExpression1 = condExp1.getElseBranch();
        GrExpression elseExpression2 = condExp2.getElseBranch();
        return EquivalenceChecker.expressionsAreEquivalent(condition1, condition2) && EquivalenceChecker.expressionsAreEquivalent(elseExpression1, elseExpression2);
    }

    private static boolean expressionListsAreEquivalent(GrExpression @Nullable [] expressions1, GrExpression @Nullable [] expressions2) {
        if (expressions1 == null && expressions2 == null) {
            return true;
        }
        if (expressions1 == null || expressions2 == null) {
            return false;
        }
        return ArrayUtil.areEqual((Object[])expressions1, (Object[])expressions2, (e1, e2) -> EquivalenceChecker.expressionsAreEquivalent(e1, e2));
    }

    private static int getExpressionType(@Nullable GrExpression exp) {
        if (exp instanceof GrLiteral) {
            return 1;
        }
        if (exp instanceof GrReferenceExpression) {
            return 3;
        }
        if (exp instanceof GrTypeCastExpression) {
            return 16;
        }
        if (exp instanceof GrSafeCastExpression) {
            return 17;
        }
        if (exp instanceof GrInstanceOfExpression) {
            return 18;
        }
        if (exp instanceof GrNewExpression) {
            return 6;
        }
        if (exp instanceof GrMethodCall) {
            return 5;
        }
        if (exp instanceof GrUnaryExpression) {
            return ((GrUnaryExpression)exp).isPostfix() ? 11 : 10;
        }
        if (exp instanceof GrAssignmentExpression) {
            return 14;
        }
        if (exp instanceof GrRangeExpression) {
            return 19;
        }
        if (exp instanceof GrBinaryExpression) {
            return 12;
        }
        if (exp instanceof GrElvisExpression) {
            return 15;
        }
        if (exp instanceof GrConditionalExpression) {
            return 13;
        }
        if (exp instanceof GrIndexProperty) {
            return 21;
        }
        if (exp instanceof GrListOrMap) {
            return 20;
        }
        if (exp instanceof GrClosableBlock) {
            return 8;
        }
        return -1;
    }

    private static int getStatementType(@Nullable GrStatement statement) {
        if (statement instanceof GrBlockStatement) {
            return 1;
        }
        if (statement instanceof GrBreakStatement) {
            return 2;
        }
        if (statement instanceof GrContinueStatement) {
            return 3;
        }
        if (statement instanceof GrVariableDeclaration) {
            return 4;
        }
        if (statement instanceof GrApplicationStatement) {
            return 21;
        }
        if (statement instanceof GrExpression) {
            return 8;
        }
        if (statement instanceof GrForStatement) {
            return 9;
        }
        if (statement instanceof GrIfStatement) {
            return 10;
        }
        if (statement instanceof GrReturnStatement) {
            return 12;
        }
        if (statement instanceof GrSwitchStatement) {
            return 14;
        }
        if (statement instanceof GrThrowStatement) {
            return 16;
        }
        if (statement instanceof GrTryCatchStatement) {
            return 17;
        }
        if (statement instanceof GrWhileStatement) {
            return 18;
        }
        if (statement instanceof GrSynchronizedStatement) {
            return 19;
        }
        if (statement instanceof GrAssertStatement) {
            return 20;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement1";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement2";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var2";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExp1";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExp2";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExp1";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExp2";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixExp1";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixExp2";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postfixExp1";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postfixExp2";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExp1";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExp2";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeExp1";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeExp2";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignExp1";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignExp2";
                break;
            }
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condExp1";
                break;
            }
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condExp2";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/utils/EquivalenceChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "varStatementsAreEquivalent";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "variablesAreEquivalent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "tryStatementsAreEquivalent";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "whileStatementsAreEquivalent";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "forInStatementsAreEquivalent";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "switchStatementsAreEquivalent";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "blockStatementsAreEquivalent";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "ifStatementsAreEquivalent";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "expressionStatementsAreEquivalent";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "returnStatementsAreEquivalent";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "throwStatementsAreEquivalent";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "methodCallExpressionsAreEquivalent";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "newExpressionsAreEquivalent";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "prefixExpressionsAreEquivalent";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "postfixExpressionsAreEquivalent";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "binaryExpressionsAreEquivalent";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[2] = "rangeExpressionsAreEquivalent";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[2] = "assignmentExpressionsAreEquivalent";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "conditionalExpressionsAreEquivalent";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[2] = "elvisExpressionsAreEquivalent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

